# After getting started

You're nearing the end of the course, but you're just getting started! This is an exciting journey of continuous learning, challenge and growth.

It is easy to get stuck in the 'getting started' phase \(it doesn't help that the number of 'getting started' tutorials is so much more than the 'getting good' or 'master X' tutorials\). So it's important that you deliberately practice getting good at your craft.

## Keep on learning

### Learning how to learn effectively

* You can spend some time to learn [how to learn](https://www.coursera.org/learn/learning-how-to-learn) or [how to read a book](https://www.amazon.com/How-Read-Book-Classic-Intelligent/dp/0671212095)
* Need to pick up a new programming language? There is a [fast way](http://www.flyingmachinestudios.com/programming/learn-programming-languages-efficiently/) although eventually it takes you [10 years](http://norvig.com/21-days.html) to be good at it.
* Don't just read. Get your hands dirty.
* You are capable to do 80% tasks by learning 20% of a new skill in [the first 20 hours](https://first20hours.com/)
* Staying up-to-date as a software developer with [a daily learning routine](https://trevordmiller.com/blog/learning-routine)
* Don't stay in your [comfortable zone](https://en.wikipedia.org/wiki/Comfort_zone). Always put yourself in learning zone.
* Make good use of your time. Have 15 mins free? You can learn something new in that 15 mins.

### Keep yourself updated with latest technology news

* [Hacker News](https://news.ycombinator.com/) is an excellent source of technology news.
* [Reddit Programming](https://www.reddit.com/r/programming/) is good too.
* Subscribe to good developer blogs with [Feedly](https://feedly.com/) or Twitter
* There are lots of podcasts[\[1\]](https://simpleprogrammer.com/ultimate-list-developer-podcasts/)[\[2\]](https://github.com/rShetty/awesome-podcasts) you can follow.
* There are also good mailing lists like [javascript weekly](https://javascriptweekly.com/) and [react status](https://react.statuscode.com/)
* Don't forget about [ThoughtWorks Radar](https://www.thoughtworks.com/radar)

Warning: you can be flooded by information if you subscribe to too many news sources.

### Don't be overwhelmed by the things you don't know about. It's OK.

There are lots of new development in technology field, everyday. Even experienced developers acknowledge [there are things they don't know](https://overreacted.io/things-i-dont-know-as-of-2018/). Give yourself more time to learn and grow.

### Learn from Guru

* [Awesome Talks](https://awesometalks.party/)
* [More Awesome Talks](https://github.com/JanVanRyswyck/awesome-talks)
* [Martin Fowler](https://martinfowler.com/bliki/)
* [Listening to TED Talks](https://www.ted.com/)

### Follow what senior developers do

* [Tips from the Pragmatic Programmer](https://pragprog.com/the-pragmatic-programmer/extracts/tips)
* [97 Things Every Programmer Should Know](https://legacy.gitbook.com/book/97-things-every-x-should-know/97-things-every-programmer-should-know/details)
* [More things you need to know](https://github.com/mtdvio/every-programmer-should-know)
* [A long list of websites that developers visit](https://github.com/sdmg15/Best-websites-a-programmer-should-visit)

### Log what you have learnt, twitter what you have learnt, blog what you have learnt

* [Keep a learning log](https://github.com/jbranchaud/til)

### Make a learning plan

* [Developer Roadmap](https://github.com/kamranahmedse/developer-roadmap) and the author [explains frontend roadmap](https://medium.com/tech-tajawal/modern-frontend-developer-in-2018-4c2072fa2b9c) and [backend roadmap](https://medium.com/tech-tajawal/modern-backend-developer-in-2018-6b3f7b5f8b9)
* [React Developer Roadmap](https://github.com/adam-golab/react-developer-roadmap)
* [Vue Developer Roadmap](https://flaviocopes.com/vue-developer-roadmap/)
* [2018 Developer Skills Report](https://research.hac*errank.com/developer-skills/2018/)

### Build solid fundamentals by doing more practices

* [Codewars](https://www.codewars.com/)
* [Exercism.io](https://exercism.io/)
* [Reddit Daily Programmer](https://www.reddit.com/r/dailyprogrammer/)
* [Lots of Katas](http://kata-log.rocks/)
* [Awesome Katas](https://github.com/gamontal/awesome-katas)

### Join Developer Community

* If you are really into react stuff, join [Reactiflux](https://www.reactiflux.com/)
* If you need a local community in Singapore, join [Junior Dev SG](https://www.meetup.com/Junior-Developers-Singapore/)
* There are lots of [meetup groups in Singapore](https://www.meetup.com/)

### LevelUp by keeping on building your portfolio

* [Programming achievements: How to level up as a developer](http://jasonrudolph.com/blog/2011/08/09/programming-achievements-how-to-level-up-as-a-developer/)
* You can became a better developer by [re-inventing the wheels](https://github.com/danistefanovic/build-your-own-x) and [project based learning](https://github.com/tuvtran/project-based-learning)
* If you need more ideas on what to build, check out the [open source ideas](https://github.com/open-source-ideas/open-source-ideas)

### If you feel you need more training in computer science

* [The Imposters Handbook](https://bigmachine.io/products/the-imposters-handbook/) is written by a self-taught programmer that explains some important concepts in computer science
* There are tons of good [online courses](https://www.class-central.com/) such as [Harvard CS50X](https://www.edx.org/course/cs50s-introduction-computer-science-harvardx-cs50x) and [Design of Computer Programs](https://www.udacity.com/course/design-of-computer-programs--cs212)
* You can also check out these [awesome courses](https://github.com/prakhar1989/awesome-courses)
* You can also [teach yourself CS](https://teachyourselfcs.com/) but I would recommend you to find some friends and do it together.
* Here is another learning path for [core programming skills](https://github.com/ossu/computer-science#core-cs)

### If you like reading books

* Here is [a list of highly recommended books](http://www.communitypicks.com/)
* [Pragmatic programmer](https://pragprog.com/the-pragmatic-programmer/extracts/tips)
* Pragmatic Thinking and Learning - Andrew Hunt
* The passionate programmer - Chad Fowler

### If you join a company that does not give you proper training, you can do it yourself

* [The Orione Team Learning Path](https://github.com/xpeppers/starway-to-orione)
* [The Novoda Craft University](https://blog.novoda.com/ncu-part-2-the-teaching/)

### Learn tools to make you more productive

* [Vim](https://vimawesome.com/)
* [Pomodoro Technique](https://en.wikipedia.org/wiki/Pomodoro_Technique)
* [Inbox Zero](https://flow-e.com/inbox-zero/gmail/)
* [The Seven Habits of Highly Effective People](https://www.franklincovey.com/the-7-habits.html)
* [Getting Things Done](https://gettingthingsdone.com/)

### Build up your soft skills too

I am pretty bad at this so I don't know what to put here...

### Last but not least, it's a long journey. Take care of yourself

Bon Voyage!!!

