# Web 101

## Learning objectives

* How does Internet work? How can you get the webpage in browser when you type www.google.com?
  * IP address
  * URL: protocol, subdomain, domain, extension, path, resources, query string
  * DNS resolution
  * Router
  * TCP/IP 
  * ports
  * HTTP protocol
  * HTTP request/response headers \(GET, POST, PUT, DELETE, etc\)
  * Ajax requests
  * HTTP response codes
* What does a server do when it receives a request?
* What does a browser do when it receives response?
* History of web application development     

## Networking: How can computers talk to each other?

* [How does Internet Work?](https://www.youtube.com/watch?v=7_LPdttKXPc)
  * How can one computer on the network communicate with another computer?
* [How does DNS work?](https://www.youtube.com/watch?v=72snZctFFtA)
  * [What is a domain name?](https://8thlight.com/blog/avni-kothari/2018/10/16/domain-name-servers.html)
  * What does DNS server do? Translate DNS name into IP addresses.
    * How is that done? Through a resolution process between:
      * Resolving Name Server
        * Root Name Server
        * TLD \(Top Level Domain\) Name Server
        * Domain Name Registrar 
        * Authoritative Name Server 
* [How does Router work?](https://www.youtube.com/watch?v=f9M6P9IVn7k)
  * What does Router do? 
* [Requests & Responses, Part 1](https://www.youtube.com/watch?v=e4S8zfLdLgQ)

## DNS Process

![DNS Resolution](https://qph.fs.quoracdn.net/main-qimg-38e19cdef7b1ebdbf9bc85430bbc93c1)

[What happens when you type 'google.com' into a browser and press Enter?](https://dev.to/antonfrattaroli/what-happens-when-you-type-googlecom-into-a-browser-and-press-enter-39g8)

## Common HTTP Request Headers

[https://en.wikipedia.org/wiki/List\_of\_HTTP\_header\_fields](https://en.wikipedia.org/wiki/List_of_HTTP_header_fields)

## Common HTTP Response Status Codes

[http://www.restapitutorial.com/httpstatuscodes.html](http://www.restapitutorial.com/httpstatuscodes.html) [https://www.addedbytes.com/blog/http-status-codes](https://www.addedbytes.com/blog/http-status-codes)

## HTTP GET Query String

[https://en.wikipedia.org/wiki/Query\_string](https://en.wikipedia.org/wiki/Query_string)

## History of the web application development

### The Client/Server model

Desktop Client + Server side.

The challenge is how to rollout updates on the desktop clients, when there are lots of them.

### The Client/Server model

Client + Server

* static website
* CGI scripts \(written in C/C++\)
* CGI scripts \(written in ASP/JSP/PHP\)
* Server Side MVC frameworks
* Client Side MVVM \(Singe Page App\) + Server Side API
* Server side rendering..again...Why?
* Progressive Web App

### Serverless Architecture

Serverless architectures refer to applications that significantly depend on third-party services \(knows as Backend as a Service or "BaaS"\) or on custom code that's run in ephemeral containers \(Function as a Service or "FaaS"\), the best known vendor host of which currently is AWS Lambda. By using these ideas, and by moving much behavior to the front end, such architectures remove the need for the traditional 'always on' server system sitting behind an application. Depending on the circumstances, such systems can significantly reduce operational cost and complexity at a cost of vendor dependencies and \(at the moment\) immaturity of supporting services.

[https://martinfowler.com/articles/serverless.html](https://martinfowler.com/articles/serverless.html)

## Resources

### Recommended Reading

* [Mozilla \(MDN\) docs on web](https://developer.mozilla.org/en-US/docs/Learn/Common_questions)
* [Great explanation of client requests and server responses](https://www.youtube.com/watch?v=keo0dglCj7I)
* [Scaling webapps for newbs & non-techies](https://arcentry.com/blog/scaling-webapps-for-newbs-and-non-techies/)
* [Web Architecture 101](https://engineering.videoblocks.com/web-architecture-101-a3224e126947?ref=abhimanyu)

### Labs

Observe the request/responses using Chrome Dev Tool while visiting a website. Look at the request/response headers/body. If you notice anything you don't know, google it or ask around.

