# Table of contents

* [Introduction](README.md)
* [FAQ](faq.md)
* [Prep Work](prep-work.md)
* [Course outline](outline.md)
* [Machine setup](machine-setup/README.md)
  * [Linux](machine-setup/linux.md)
  * [Mac](machine-setup/mac.md)
  * [Windows](machine-setup/windows.md)
* [How to learn effectively](how-to-learn-effectively.md)
* [Developer Tools](developer-tools/README.md)
  * [Unix commandline](developer-tools/unix-commandline/README.md)
    * [Basic commandline](developer-tools/unix-commandline/basic-commandline.md)
    * [Advanced commandline](developer-tools/unix-commandline/advanced-commandline.md)
    * [Shell scripting](developer-tools/unix-commandline/shell-scripting.md)
    * [Useful Commandline Tools](developer-tools/unix-commandline/commandline-tools.md)
  * [Git](developer-tools/git/README.md)
    * [Getting Started with Git](developer-tools/git/getting-started-with-git.md)
    * [Working with Github](developer-tools/git/github-cheat-sheet.md)
    * [Collaborating using Git](developer-tools/git/collaborating-using-git.md)
    * [Git Workflows](developer-tools/git/git-workflows.md)
    * [Merge hell](developer-tools/git/merge-hell.md)
    * [Advanced Git Commands](developer-tools/git/advanced-git.md)
  * [Chrome DevTools](developer-tools/chrome-devtools.md)
  * [VS Code Shortcuts](developer-tools/vs-code-shortcuts.md)
* [JavaScript](javascript/README.md)
  * [JavaScript Toolchain](javascript/toolchain/README.md)
    * [node and npm](javascript/toolchain/node-and-npm.md)
    * [yarn](javascript/toolchain/yarn.md)
    * [ESLint and Prettier](javascript/toolchain/eslint.md)
    * [babel](javascript/toolchain/babel.md)
  * [JavaScript basics](javascript/basics/README.md)
    * [Variables](javascript/basics/javascript-variable.md)
    * [Conditional statements](javascript/basics/conditional-statements.md)
    * [Functions](javascript/basics/javascript-function.md)
    * [Objects](javascript/basics/javascript-object.md)
    * [Arrays](javascript/basics/javascript-array.md)
    * [Array methods](javascript/basics/javascript-array-methods.md)
    * [Loops](javascript/basics/javascript-loop.md)
    * [Errors](javascript/basics/javascript-error.md)
  * [JavaScript in Depth](javascript/in-depth/README.md)
    * [What is ES6?](javascript/in-depth/what-is-es6.md)
    * [Variable and Scope](javascript/in-depth/values-and-variables/README.md)
      * [Execution Context](javascript/in-depth/values-and-variables/execution-context.md)
      * [What is stored in a variable?](javascript/in-depth/values-and-variables/what-is-stored-in-variable.md)
      * [let and const](javascript/in-depth/values-and-variables/let-and-const.md)
      * [Lexical Scope](javascript/in-depth/values-and-variables/scope.md)
    * [Functions](javascript/in-depth/functions/README.md)
      * [Arrow functions](javascript/in-depth/functions/arrow-functions.md)
      * [Callback functions](javascript/in-depth/functions/callback-functions.md)
      * [Default Function Parameters](javascript/in-depth/functions/default-function-parameters.md)
      * [Closures](javascript/in-depth/functions/closures.md)
    * [Arrays](javascript/in-depth/arrays/README.md)
      * [forEach](javascript/in-depth/arrays/foreach.md)
      * [map](javascript/in-depth/arrays/map.md)
      * [filter](javascript/in-depth/arrays/filter.md)
      * [reduce](javascript/in-depth/arrays/reduce.md)
      * [some](javascript/in-depth/arrays/some.md)
      * [every](javascript/in-depth/arrays/every.md)
      * [method chaining](javascript/in-depth/arrays/method-chaining.md)
      * [Which method to use?](javascript/in-depth/arrays/which-method-to-use.md)
    * [Object Oriented JavaScript](javascript/in-depth/classes/README.md)
      * [Defining classes](javascript/in-depth/classes/more-about-classes.md)
      * [Object equality](javascript/in-depth/classes/object-equality.md)
      * [Understanding this](javascript/in-depth/classes/this.md)
      * [Bind Apply Call](javascript/in-depth/classes/bind-apply-call.md)
      * [Be careful with this in arrow functions](javascript/in-depth/classes/this-and-arrow-functions.md)
      * [Prototype based inheritance](javascript/in-depth/classes/prototype-inheritance.md)
    * [Syntactic sugar](javascript/in-depth/syntactic-sugar/README.md)
      * [Template strings](javascript/in-depth/syntactic-sugar/template-strings.md)
      * [Destructuring](javascript/in-depth/syntactic-sugar/destructuring.md)
      * [Spread operators](javascript/in-depth/syntactic-sugar/spread-operators.md)
      * [Rest operators](javascript/in-depth/syntactic-sugar/rest-operators.md)
    * [Module System](javascript/in-depth/modules/README.md)
      * [CommonJS Modules](javascript/in-depth/modules/node-modules.md)
      * [ES6 module system](javascript/in-depth/modules/es6-module-system.md)
  * [Asynchronous JavaScript](javascript/asynchronous-javascript/README.md)
    * [Understanding the event loop](javascript/asynchronous-javascript/understanding-the-event-loop.md)
    * [Event loop and asynchronous tasks](javascript/asynchronous-javascript/event-loop-and-asynchronous-tasks.md)
    * [Callback Hell](javascript/asynchronous-javascript/callback-hell.md)
    * [Promises](javascript/asynchronous-javascript/promises.md)
    * [async and await](javascript/asynchronous-javascript/async-and-await.md)
    * [Comparing 3 approaches](javascript/asynchronous-javascript/comparing-3-approaches.md)
* [Front-end web development](front-end-web-development/README.md)
  * [How browser works](front-end-web-development/browser.md)
  * [HTML](front-end-web-development/html.md)
  * [CSS](front-end-web-development/css/README.md)
    * [CSS Basics](front-end-web-development/css/css-basics.md)
    * [Specificity Rules](front-end-web-development/css/specificity-rules.md)
    * [CSS Property Inheritance](front-end-web-development/css/css-inheritance.md)
    * [Box Model](front-end-web-development/css/box-model.md)
    * [block vs inline elements](front-end-web-development/css/block-vs-inline-elements.md)
    * [Centering elements](front-end-web-development/css/centering-elements.md)
    * [CSS Grid](front-end-web-development/css/css-grid.md)
    * [float](front-end-web-development/css/float.md)
    * [Responsive CSS](front-end-web-development/css/responsive-css.md)
    * [Additional topics](front-end-web-development/css/additional-topics.md)
    * [Miscellaneous](front-end-web-development/css/miscellaneous.md)
  * [DOM manipulation](front-end-web-development/dom-manipulation.md)
  * [React](front-end-web-development/react/README.md)
    * [Setup](front-end-web-development/react/setup.md)
    * [Basic Concepts](front-end-web-development/react/react-tutorial-overview/README.md)
      * [JSX](front-end-web-development/react/react-tutorial-overview/jsx.md)
      * [React Element\(s\)](front-end-web-development/react/react-tutorial-overview/react-element-s.md)
      * [Rendering on DOM](front-end-web-development/react/react-tutorial-overview/rendering-on-dom.md)
      * [React component\(s\)](front-end-web-development/react/react-tutorial-overview/react-component-s.md)
      * [Props](front-end-web-development/react/react-tutorial-overview/props.md)
      * [State](front-end-web-development/react/react-tutorial-overview/state.md)
      * [Lifecycle hooks/methods](front-end-web-development/react/react-tutorial-overview/lifecycle-hooks-methods.md)
      * [Event listeners and event handlers](front-end-web-development/react/react-tutorial-overview/event-listeners-and-event-handlers.md)
      * [Binding this](front-end-web-development/react/react-tutorial-overview/binding-this.md)
      * [Passing parameters to event handlers](front-end-web-development/react/react-tutorial-overview/passing-parameters-to-event-handlers.md)
      * [Your first React application](front-end-web-development/react/react-tutorial-overview/your-first-react-application.md)
      * [Importing CSS, other components and data](front-end-web-development/react/react-tutorial-overview/importing-css-other-components-and-data.md)
      * [Lab 1: List all restaurants from restaurant service](front-end-web-development/react/react-tutorial-overview/lab1.md)
      * [Lab 2: Filter restaurants by cuisine](front-end-web-development/react/react-tutorial-overview/lab2.md)
      * [Lab 3: Add a dropdown to sort restaurants by name or price](front-end-web-development/react/react-tutorial-overview/lab3.md)
      * [React Router](front-end-web-development/react/react-tutorial-overview/react-router.md)
      * [Lab 4: Add a navbar and link to pages Admin and Orders](front-end-web-development/react/react-tutorial-overview/lab4.md)
      * [Lab 5: Add a table to list and delete restaurants in the Admin page](front-end-web-development/react/react-tutorial-overview/lab5.md)
      * [Forms](front-end-web-development/react/react-tutorial-overview/forms.md)
      * [Lab 6: Add feature to create a new restaurant in the Admin page](front-end-web-development/react/react-tutorial-overview/lab6.md)
      * [Lab 7: Add feature to edit existing restaurants in the Admin page](front-end-web-development/react/react-tutorial-overview/lab7.md)
      * [Lab 8: Add validation for New Restaurant form](front-end-web-development/react/react-tutorial-overview/lab8.md)
      * [React Hooks](front-end-web-development/react/react-tutorial-overview/react-hooks.md)
    * [Beyond Basics](front-end-web-development/react/beyond-basics/README.md)
      * [Ideas and principles behind React](front-end-web-development/react/beyond-basics/react-core-ideas.md)
      * [Props Type Checking](front-end-web-development/react/beyond-basics/type-checking.md)
      * [Fetching data](front-end-web-development/react/beyond-basics/fetching-data.md)
      * [Public APIs](front-end-web-development/react/beyond-basics/public-apis.md)
      * [Environment variables](front-end-web-development/react/beyond-basics/environment-variables-in-create-react-app.md)
      * [React Pure Component](front-end-web-development/react/beyond-basics/pure-component.md)
      * [React Performance Tuning](front-end-web-development/react/beyond-basics/react-performance-tuning.md)
      * [Folder structure](front-end-web-development/react/beyond-basics/folder-structure.md)
    * [Advanced Concepts](front-end-web-development/react/advanced-concepts/README.md)
      * [Virtual DOM](front-end-web-development/react/advanced-concepts/virtual-dom.md)
      * [React Design Patterns](front-end-web-development/react/advanced-concepts/react-design-patterns.md)
      * [Context](front-end-web-development/react/advanced-concepts/context.md)
      * [React libraries for state management](front-end-web-development/react/advanced-concepts/react-state-management.md)
      * [Webpack](front-end-web-development/react/advanced-concepts/webpack.md)
      * [Progressive Web Applications](front-end-web-development/react/advanced-concepts/progressive-web-app.md)
    * [Testing React apps](front-end-web-development/react/react-testing-tools/README.md)
      * [Intro to react-testing-library](front-end-web-development/react/react-testing-tools/react-testing-library.md)
      * [Test Driven Development \(TDD\) with react-testing-library](front-end-web-development/react/react-testing-tools/tdd-react-testing-library.md)
      * [Testing asynchronous functions](front-end-web-development/react/react-testing-tools/test-async-function-with-jest.md)
      * [Mocking Fetch API](front-end-web-development/react/react-testing-tools/mocking-fetch.md)
      * [Mocking React Components](front-end-web-development/react/react-testing-tools/mocking-react-components.md)
      * [Snapshot Testing](front-end-web-development/react/react-testing-tools/snapshot-testing.md)
      * [Enzyme](front-end-web-development/react/react-testing-tools/enzyme.md)
  * [Frontend learning resources](front-end-web-development/frontend-resources.md)
* [Back-end web development](back-end-web-development/README.md)
  * [Web 101](back-end-web-development/web-101.md)
  * [REST API & CRUD](back-end-web-development/rest-api-and-crud.md)
  * [Web Service with Express.js](back-end-web-development/web-service-with-express.js/README.md)
    * [Hello World](back-end-web-development/web-service-with-express.js/hello-world.md)
    * [Sending responses](back-end-web-development/web-service-with-express.js/sending-responses.md)
    * [Routes](back-end-web-development/web-service-with-express.js/routes.md)
    * [Parsing request body](back-end-web-development/web-service-with-express.js/parsing-request-body.md)
    * [Parsing path params \(Part 1\)](back-end-web-development/web-service-with-express.js/parsing-path-params-part1.md)
    * [Parsing query params](back-end-web-development/web-service-with-express.js/parsing-query-params.md)
    * [Lab: Creating a Songs API](back-end-web-development/web-service-with-express.js/lab-creating-a-songs-api.md)
    * [Parsing path params \(Part 2\)](back-end-web-development/web-service-with-express.js/parsing-path-params-part2.md)
    * [Using Express Router](back-end-web-development/web-service-with-express.js/using-express-router.md)
    * [Handling errors](back-end-web-development/web-service-with-express.js/handling-errors.md)
    * [Validation with Joi](back-end-web-development/web-service-with-express.js/validation-with-joi.md)
    * [Middleware](back-end-web-development/web-service-with-express.js/middleware.md)
    * [Using Async Functions with Express.js](back-end-web-development/web-service-with-express.js/using-async-functions-with-express.js.md)
    * [Serving static files with Express.js](back-end-web-development/web-service-with-express.js/serving-static-response.md)
    * [API Documentation with Swagger](back-end-web-development/web-service-with-express.js/api-documentation-with-swagger.md)
    * [Bonus stuff](back-end-web-development/web-service-with-express.js/bonus-stuff.md)
  * [Web Service with MongoDB](back-end-web-development/web-service-with-mongodb/README.md)
    * [Installing MongoDB](back-end-web-development/web-service-with-mongodb/installing-mongodb.md)
    * [Using MongoDB with Mongoose](back-end-web-development/web-service-with-mongodb/using-mongodb-with-mongoose.md)
  * [Testing Web Services](back-end-web-development/testing-web-services/README.md)
    * [Testing REST API without database](back-end-web-development/testing-web-services/testing-handlers-and-routers.md)
    * [Testing REST API with MongoDB](back-end-web-development/testing-web-services/testing-express-with-mongodb.md)
  * [Authentication and Authorization](back-end-web-development/authentication-and-session-management/README.md)
    * [Cryptography 101](back-end-web-development/authentication-and-session-management/cryptography-primer.md)
    * [Introduction to Cookie](back-end-web-development/authentication-and-session-management/introduction-to-cookie.md)
    * [Introduction to JSON Web Token](back-end-web-development/authentication-and-session-management/introduction-to-jwt.md)
    * [Session Cookie vs JWT](back-end-web-development/authentication-and-session-management/cookie-vs-jwt.md)
    * [JWT Demo: Prelude](back-end-web-development/authentication-and-session-management/jwt-demo-prelude.md)
    * [JWT Demo: Project Setup](back-end-web-development/authentication-and-session-management/jwt-demo-project-setup.md)
    * [JWT Demo: Mongoose Setup](back-end-web-development/authentication-and-session-management/jwt-demo-mongoose-setup.md)
    * [JWT Demo: User Model](back-end-web-development/authentication-and-session-management/jwt-demo-create-user-model.md)
    * [JWT Demo: User Signup API](back-end-web-development/authentication-and-session-management/jwt-demo-user-registration.md)
    * [JWT Demo: Test Fixtures](back-end-web-development/authentication-and-session-management/jwt-demo-test-fixture.md)
    * [JWT Demo: User Login API](back-end-web-development/authentication-and-session-management/jwt-demo-user-login.md)
    * [JWT Demo: User Change Password API](back-end-web-development/authentication-and-session-management/jwt-demo-change-password.md)
    * [JWT Demo: Storing JWT token in cookie](back-end-web-development/authentication-and-session-management/jwt-demo-credentials-in-cookies.md)
    * [JWT Demo: User Logout](back-end-web-development/authentication-and-session-management/jwt-demo-user-logout.md)
    * [JWT Demo: one more thing](back-end-web-development/authentication-and-session-management/jwt-demo-db-connection.md)
    * [JWT Demo: Summary](back-end-web-development/authentication-and-session-management/jwt-demo-summary.md)
    * [Authentication with Passport.js](back-end-web-development/authentication-and-session-management/authentication-with-passport.md)
    * [Passport.js Demo: JWT Strategy](back-end-web-development/authentication-and-session-management/passport-demo-jwt-strategy.md)
    * [Passport.js Demo: Local Strategy](back-end-web-development/authentication-and-session-management/passport-demo-local-strategy.md)
    * [Passport.js Demo: Github Strategy](back-end-web-development/authentication-and-session-management/passport-demo-github-strategy.md)
    * [Passport.js Demo: Auth0 Strategy](back-end-web-development/authentication-and-session-management/passport-demo-auth0-strategy.md)
  * [Production Quality Web Service](back-end-web-development/production-quality-web-service.md)
  * [Web Service Security](back-end-web-development/web-service-security.md)
  * [Introduction to Relational Database](back-end-web-development/introduction_to_relational_database.md)
* [DevOps](devops/README.md)
  * [Deployment](devops/deployment/README.md)
    * [Deploy simple static websites to Now](devops/deployment/deploy-simple-static-websites.md)
    * [Deploy React apps to Now](devops/deployment/deploy-react-apps-to-now-or-github-pages.md)
    * [Deploy React apps to Heroku](devops/deployment/heroku-deployment.md)
    * [Deploy React apps + backend API](devops/deployment/deploy-frontend-and-backend.md)
    * [Heroku CLI](devops/deployment/heroku-setup.md)
  * [CI & CD](devops/ci-and-cd/README.md)
    * [CircleCI](devops/ci-and-cd/circleci.md)
    * [CircleCI with Multiple Environments](devops/ci-and-cd/circleci-with-multi-env.md)
    * [TravisCI](devops/ci-and-cd/travisci.md)
  * [Infrastructure as Code](devops/infrastructure-as-code.md)
  * [Container Technology](devops/container-technology.md)
* [Computer Science](computer-science/README.md)
  * [Data Structures and Algorithms](computer-science/data-structures-and-algorithms/README.md)
    * [Introduction: Data Structures](computer-science/data-structures-and-algorithms/introduction-data-structures.md)
    * [Introduction: Algorithms](computer-science/data-structures-and-algorithms/introduction-algorithms.md)
* [Software Engineering](software-engineering/README.md)
  * [Object-Oriented Programming](software-engineering/object-oriented-programming.md)
  * [Design Patterns](software-engineering/design-patterns/README.md)
    * [Observer pattern](software-engineering/design-patterns/observer-pattern.md)
  * [Functional Programming](software-engineering/functional-programming.md)
  * [Clean Code](software-engineering/clean-code.md)
  * [Testing](software-engineering/testing-and-tdd/README.md)
    * [Test Pyramid](software-engineering/testing-and-tdd/test-pyramid.md)
    * [Testing with Jest](software-engineering/testing-and-tdd/tdd-with-jest/README.md)
      * [Installing Jest](software-engineering/testing-and-tdd/tdd-with-jest/installing-jest.md)
      * [Syntax](software-engineering/testing-and-tdd/tdd-with-jest/syntax.md)
      * [Mocks](software-engineering/testing-and-tdd/tdd-with-jest/testing-with-mocks.md)
      * [More about Jest](software-engineering/testing-and-tdd/tdd-with-jest/more-about-jest.md)
    * [End-to-end Testing](software-engineering/testing-and-tdd/end-to-end-testing.md)
    * [Test Coverage](software-engineering/testing-and-tdd/test-coverage.md)
    * [Useful libraries](software-engineering/testing-and-tdd/useful-libraries.md)
  * [Debugging](software-engineering/debugging/README.md)
    * [Debug Web App with Chrome Debugger](software-engineering/debugging/debug-with-chrome-debugger.md)
    * [Debug Jest Test Cases with VS Code](software-engineering/debugging/debug-with-jest.md)
    * [Debug React Application with VS Code](software-engineering/debugging/debug-with-react.md)
    * [Debug Node Application with VS Code](software-engineering/debugging/debug-with-node.md)
* [Agile Software Development](agile-101/README.md)
  * [Writing User Stories](agile-101/writing_user_stories.md)
  * [Feedback](agile-101/feedback.md)
  * [Retrospectives](agile-101/retrospectives.md)
* [Independent learning](independent-learning-week.md)
* [Labs and Assignments](labs-and-assignments/README.md)
  * [Assignment Grading Rubric](labs-and-assignments/assignment-grading-rubric.md)
  * [katas](labs-and-assignments/katas.md)
* [Projects](projects/README.md)
  * [Build a static website with HTML/CSS/JavaScript](projects/static-html-site.md)
  * [Build a website with React](projects/project-1.md)
  * [Build a web API](projects/project-2.md)
  * [Presentation format](projects/presentation-format.md)
  * [Group project](projects/group-project.md)
* [Career](career/README.md)
  * [Job Hunt preparation](career/job-hunt-preparation.md)
  * [Technical Interview](career/technical-interview.md)
  * [Advices for Junior Developers](career/advices-for-junior-dev.md)
  * [After getting started](career/after-getting-started.md)
* [Resources](resources.md)

