/*
 * https://github.com/thordreier/Arduino-LPF
 */

#ifndef Arduino_LPF_values_h
#define Arduino_LPF_values_h

#include <Arduino.h>
#include <stdlib.h>

#define LPF_MSG_BITCOUNT 16
#define LPF_RED 0b0
#define LPF_BLUE 0b1
#define LPF_MAX_SPEED 7
#define LPF_LRC_CHECK_BITS 0xF

#define LPF_TIMEOUT 1200  // 1200 milli seconds = 1.2 seconds

// IR times (38 KHz)
#define LPF_IR_PULSE 13
#define LPF_IR_TRANSMIT (12 * LPF_IR_PULSE)  // 6 IR pulses with pause between

#define LPF_IR_LOW 421
#define LPF_IR_LOW_MIN 316
#define LPF_IR_LOW_MAX 526
#define LPF_IR_LOW_SILENCE (LPF_IR_LOW - LPF_IR_TRANSMIT)

#define LPF_IR_HIGH 711
#define LPF_IR_HIGH_MIN 526
#define LPF_IR_HIGH_MAX 947
#define LPF_IR_HIGH_SILENCE (LPF_IR_HIGH - LPF_IR_TRANSMIT)

#define LPF_IR_STARTSTOP 1184
#define LPF_IR_STARTSTOP_MIN 947
#define LPF_IR_STARTSTOP_MAX 1579
#define LPF_IR_STARTSTOP_SILENCE (LPF_IR_STARTSTOP - LPF_IR_TRANSMIT)

// NIBBLES - one nibble = 4 bit
#define LPF_NIBBLE1_BITS_FULL 0xF000
#define LPF_NIBBLE1_SHIFT_FULL 12
#define LPF_NIBBLE2_BITS_FULL 0x0F00
#define LPF_NIBBLE2_SHIFT_FULL 8
#define LPF_NIBBLE3_BITS_FULL 0x00F0
#define LPF_NIBBLE3_SHIFT_FULL 4
#define LPF_NIBBLE4_BITS_FULL 0x000F
#define LPF_NIBBLE4_SHIFT_FULL 0

// NIBBLE 1:

// Bit 15 - TOGGLE:
#define LPF_TOGGLE_BITS_NIBBLE 0b1000
#define LPF_TOGGLE_SHIFT_NIBBLE 3
#define LPF_TOGGLE_BITS_FULL \
  (lpf_msg)(LPF_TOGGLE_BITS_NIBBLE << LPF_NIBBLE1_SHIFT_FULL)
#define LPF_TOGGLE_SHIFT_FULL \
  (byte)(LPF_TOGGLE_SHIFT_NIBBLE + LPF_NIBBLE1_SHIFT_FULL)

// Bit 14 - ESCAPE:
#define LPF_ESCAPE_BITS_NIBBLE 0b0100
#define LPF_ESCAPE_SHIFT_NIBBLE 2
#define LPF_ESCAPE_BITS_FULL \
  (lpf_msg)(LPF_ESCAPE_BITS_NIBBLE << LPF_NIBBLE1_SHIFT_FULL)
#define LPF_ESCAPE_SHIFT_FULL \
  (byte)(LPF_ESCAPE_SHIFT_NIBBLE + LPF_NIBBLE1_SHIFT_FULL)

// Bit 13+12 - CHANNEL:
#define LPF_CHANNEL_BITS_NIBBLE 0b0011
#define LPF_CHANNEL_SHIFT_NIBBLE 0
#define LPF_CHANNEL_BITS_FULL \
  (lpf_msg)(LPF_CHANNEL_BITS_NIBBLE << LPF_NIBBLE1_SHIFT_FULL)
#define LPF_CHANNEL_SHIFT_FULL \
  (byte)(LPF_CHANNEL_SHIFT_NIBBLE + LPF_NIBBLE1_SHIFT_FULL)

// NIBBLE 2:

// Bit 11 - ADDRESS:
#define LPF_ADDRESS_BITS_NIBBLE 0b1000
#define LPF_ADDRESS_SHIFT_NIBBLE 3
#define LPF_ADDRESS_BITS_FULL \
  (lpf_msg)(LPF_ADDRESS_BITS_NIBBLE << LPF_NIBBLE2_SHIFT_FULL)
#define LPF_ADDRESS_SHIFT_FULL \
  (byte)(LPF_ADDRESS_SHIFT_NIBBLE + LPF_NIBBLE2_SHIFT_FULL)

// Bit 10+9+8:
#define LPF_MODE_BITS_NIBBLE 0b0111
#define LPF_MODE_SHIFT_NIBBLE 0
#define LPF_MODE_BITS_FULL \
  (lpf_msg)(LPF_MODE_BITS_NIBBLE << LPF_NIBBLE2_SHIFT_FULL)
#define LPF_MODE_SHIFT_FULL \
  (byte)(LPF_MODE_SHIFT_NIBBLE + LPF_NIBBLE2_SHIFT_FULL)

// NIBBLE 3:

// this nipple depends on mode etc.

// NIBBLE 4:

// Bit 3+2+1+0:
#define LPF_LRC_BITS_FULL 0x000F
#define LPF_LRC_SHIFT_FULL 0

// Modes
#define LPF_MODE_SINGLE 0b100
#define LPF_MODE_RESERVED 0b010
#define LPF_MODE_COMBO_DIRECT 0b001
#define LPF_MODE_EXTENDED 0b000

// Single mode
#define LPF_MODE_SINGLE_CSTID 0b010  // Clear/Set/Toggle/Inc/Dec
#define LPF_MODE_SINGLE_PWM 0b000    // PWM
#define LPF_MODE_SINGLE_OUTPUTBITMASK 0b001
#define LPF_MODE_SINGLE_OUTPUT0 LPF_RED
#define LPF_MODE_SINGLE_OUTPUT1 LPF_BLUE

// Databits in Single mode/PWM
#define LPF_MODE_SINGLE_PWM_FLOAT 0b0000
#define LPF_MODE_SINGLE_PWM_BRAKEFLOAT 0b1000
#define LPF_MODE_SINGLE_PWM_FORWARDX 0b0000
#define LPF_MODE_SINGLE_PWM_FORWARD1 0b0001
#define LPF_MODE_SINGLE_PWM_FORWARD2 0b0010
#define LPF_MODE_SINGLE_PWM_FORWARD3 0b0011
#define LPF_MODE_SINGLE_PWM_FORWARD4 0b0100
#define LPF_MODE_SINGLE_PWM_FORWARD5 0b0101
#define LPF_MODE_SINGLE_PWM_FORWARD6 0b0110
#define LPF_MODE_SINGLE_PWM_FORWARD7 0b0111
#define LPF_MODE_SINGLE_PWM_BACKWARDX 0b1000
#define LPF_MODE_SINGLE_PWM_BACKWARD1 0b1001
#define LPF_MODE_SINGLE_PWM_BACKWARD2 0b1010
#define LPF_MODE_SINGLE_PWM_BACKWARD3 0b1011
#define LPF_MODE_SINGLE_PWM_BACKWARD4 0b1100
#define LPF_MODE_SINGLE_PWM_BACKWARD5 0b1101
#define LPF_MODE_SINGLE_PWM_BACKWARD6 0b1110
#define LPF_MODE_SINGLE_PWM_BACKWARD7 0b1111

#define LPF_MODE_SINGLE_PWM_BRAKEFLOAT_FULL_LOOKAT \
  (0b0000 << 12 | 0b0110 << 8 | 0b1111 << 4 |      \
   0b0000)  // look at these bits to see if brake/float is pressed
#define LPF_MODE_SINGLE_PWM_BRAKEFLOAT_FULL_VALUES \
  (0b0000 << 12 | 0b0100 << 8 | 0b1000 << 4 |      \
   0b0000)  // check if bits have these values if brake/float i pressed

#define LPF_MODE_SINGLE_OUTPUT_FULL_LOOKAT \
  (0b0000 << 12 | 0b0101 << 8 | 0b0000 << 4 | 0b0000)
#define LPF_MODE_SINGLE_OUTPUT_FULL_VALUES \
  (0b0000 << 12 | 0b0001 << 8 | 0b0000 << 4 | 0b0000)
#define LPF_MODE_SINGLE_OUTPUT_FULL_SHIFT 8

// Databits in Combo Direct mode

#define LPF_MODE_COMBO_DIRECT_FLOAT 0b00
#define LPF_MODE_COMBO_DIRECT_FORWARD 0b01
#define LPF_MODE_COMBO_DIRECT_BACKWARD 0b10
#define LPF_MODE_COMBO_DIRECT_BRAKE 0b11

// Bit 7+6 in Combo Direct mode (RED):
#define LPF_MODE_COMBO_DIRECT_OUTPUT0_BITS_NIBBLE 0b0011
#define LPF_MODE_COMBO_DIRECT_OUTPUT0_SHIFT_NIBBLE 0
#define LPF_MODE_COMBO_DIRECT_OUTPUT0_BITS_FULL \
  (lpf_msg)(LPF_MODE_COMBO_DIRECT_OUTPUT0_BITS_NIBBLE << LPF_NIBBLE3_SHIFT_FULL)
#define LPF_MODE_COMBO_DIRECT_OUTPUT0_SHIFT_FULL \
  (byte)(LPF_MODE_COMBO_DIRECT_OUTPUT0_SHIFT_NIBBLE + LPF_NIBBLE3_SHIFT_FULL)

// Bit 5+4 in Combo Direct mode (BLUE):
#define LPF_MODE_COMBO_DIRECT_OUTPUT1_BITS_NIBBLE 0b1100
#define LPF_MODE_COMBO_DIRECT_OUTPUT1_SHIFT_NIBBLE 2
#define LPF_MODE_COMBO_DIRECT_OUTPUT1_BITS_FULL \
  (lpf_msg)(LPF_MODE_COMBO_DIRECT_OUTPUT1_BITS_NIBBLE << LPF_NIBBLE3_SHIFT_FULL)
#define LPF_MODE_COMBO_DIRECT_OUTPUT1_SHIFT_FULL \
  (byte)(LPF_MODE_COMBO_DIRECT_OUTPUT1_SHIFT_NIBBLE + LPF_NIBBLE3_SHIFT_FULL)

#endif  // Arduino_LPF_values_h
