<?php

namespace suframe\thinkAdmin\controller;

use think\facade\View;

abstract class Base extends BaseController
{

    protected function initialize()
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        if(!$this->request->isAjax()){
            $this->getThinkAdminViewLayout();
        }
        $this->setViewPath();
    }

    private function getThinkAdminViewLayout()
    {
        $layout = thinkAdminPath() . 'view' . DIRECTORY_SEPARATOR . 'layout_container.html';
        View::assign('thinkAdminViewLayoutFile', $layout);
    }

    protected function setViewPath()
    {
        if(!$this->request->isAjax()){
            View::config(['view_path' => __DIR__ . '/../view/']);
        }
    }

}
