/**
 * Copyright JS Foundation and other contributors, http://js.foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **/

var util = require('util');

var readRE = /^((.+)\.)?read$/
var writeRE = /^((.+)\.)?write$/

function hasPermission(userScope,permission) {
    if (permission === "") {
        return true;
    }
    var i;

    if (util.isArray(permission)) {
        // Multiple permissions requested - check each one
        for (i=0;i<permission.length;i++) {
            if (!hasPermission(userScope,permission[i])) {
                return false;
            }
        }
        // All permissions check out
        return true;
    }

    if (util.isArray(userScope)) {
        if (userScope.length === 0) {
            return false;
        }
        for (i=0;i<userScope.length;i++) {
            if (hasPermission(userScope[i],permission)) {
                return true;
            }
        }
        return false;
    }

    if (userScope === "*" || userScope === permission) {
        return true;
    }

    if (userScope === "read" || userScope === "*.read") {
        return readRE.test(permission);
    } else if (userScope === "write" || userScope === "*.write") {
        return writeRE.test(permission);
    }
    return false;
}

module.exports = {
    hasPermission: hasPermission,
}
