package com.mqttsnet.thinglinks.link.api.domain.device.vo.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * -----------------------------------------------------------------------------
 * File Name: OtaCommandResponseParam
 * -----------------------------------------------------------------------------
 * Description:
 * OTA 远程升级请求参数
 * 用于物联网平台向设备发送 OTA 升级指令
 * -----------------------------------------------------------------------------
 *
 * @author xiaonannet
 * @version 1.0
 * -----------------------------------------------------------------------------
 * Revision History:
 * Date         Author          Version     Description
 * --------      --------     -------   --------------------
 * 2024/1/18       xiaonannet        1.0        Initial creation
 * -----------------------------------------------------------------------------
 * @email 13733918655@163.com
 * @date 2024/1/18 22:28
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "OtaCommandRequestParam", description = "Request Data Structure for OTA Command")
public class OtaCommandRequestParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "Unique identifier for the device", notes = "Unique identifier for the device, as generated by the platform.")
    private String deviceIdentification;

    @ApiModelProperty(value = "Unique identifier for the product", notes = "Unique identifier for the product, as generated by the platform.")
    private String productIdentification;

    @ApiModelProperty(value = "Unique identifier for the OTA task", notes = "Unique identifier for the OTA task, as assigned by the platform.")
    private Long otaTaskId;

    @ApiModelProperty(value = "Type of OTA package", notes = "The type of OTA package, e.g., 0 for software, 1 for firmware.")
    private Integer packageType;

    @ApiModelProperty(value = "Version of the OTA package", notes = "The version of the OTA package. Should not exceed 256 characters and may include letters, numbers, underscores (_), hyphens (-), and periods (.)")
    private String version;

    @ApiModelProperty(value = "Location of the OTA package file", notes = "The file path or location where the OTA package is stored, accessible within 24 hours.")
    private String fileLocation;

    @ApiModelProperty(value = "Description of the OTA package", notes = "A brief description of the OTA package's functionality.")
    private String description;

    @ApiModelProperty(value = "Custom information for the OTA package", notes = "Additional custom information related to the OTA package, if any.")
    private String customInfo;
}
