package com.mqttsnet.thinglinks.link.api.domain.device.vo.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * -----------------------------------------------------------------------------
 * File Name: OpenAiChatRequestParam
 * -----------------------------------------------------------------------------
 * Description:
 * OpenAiChatRequest
 * -----------------------------------------------------------------------------
 *
 * @author xiaonannet
 * @version 1.0
 * -----------------------------------------------------------------------------
 * Revision History:
 * Date         Author          Version     Description
 * --------      --------     -------   --------------------
 * 2023/12/12       xiaonannet        1.0        Initial creation
 * -----------------------------------------------------------------------------
 * @email 13733918655@163.com
 * @date 2023/12/12 23:20
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString(callSuper = true)
@Accessors(chain = true)
@EqualsAndHashCode
@Builder
@ApiModel(value = "OpenAiChatRequest", description = "Request parameters for OpenAI Chat API")
public class OpenAiChatRequestParam implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "The unique session ID generated by OpenAI.", notes = "Specify the id to use for this callback.")
    private String id;

    @ApiModelProperty(value = "The model to use for this chat (e.g., gpt-3.5-turbo)", notes = "Specifies the model to be used by the API.")
    @NotEmpty(message = "Model is required")
    private String model;

    @ApiModelProperty(value = "Content of the message to be processed", notes = "Message content to be sent to OpenAI Chat.")
    @NotEmpty(message = "Content cannot be null")
    @Size(min = 1, max = 1000, message = "Content must be between 1 and 1000 characters")
    private String content;

    @ApiModelProperty(value = "API Key for OpenAI", notes = "The API Key for authentication with OpenAI services.")
    private String apiKey;

    @ApiModelProperty(value = "API Host for OpenAI", notes = "The host URL for OpenAI services.")
    private String apiHost;

}
