package com.mqttsnet.thinglinks.link.api.domain.device.vo.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Map;

/**
 * -----------------------------------------------------------------------------
 * 文件名称: CommandIssueRequestParam.java
 * -----------------------------------------------------------------------------
 * 描述:
 * Platform Command Issue Request Data Model
 * -----------------------------------------------------------------------------
 *
 * @author ShiHuan Sun
 * @version 1.0
 * -----------------------------------------------------------------------------
 * 修改历史:
 * 日期           作者          版本        描述
 * --------      --------     -------   --------------------
 * <p>
 * -----------------------------------------------------------------------------
 * @email 13733918655@163.com
 * @date 2023-10-17 09:48
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString(callSuper = true)
@Builder
@ApiModel(value = "CommandIssueRequestParam", description = "Device Command Request Data Structure")
public class CommandIssueRequestParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "Device unique identifier, ALL for all devices.", notes = "Device unique ID generated by the platform.")
    @NotEmpty(message = "Device ID cannot be empty")
    private String deviceIdentification;

    @ApiModelProperty(value = "Product unique identifier.", notes = "Product unique ID generated by the platform.")
    @NotEmpty(message = "Product ID cannot be empty")
    private String productIdentification;

    @ApiModelProperty(value = "Fixed value 'cloudReq', indicating the request issued by the platform.", notes = "Fixed value 'cloudReq', indicating the request issued by the platform.")
    @NotEmpty(message = "Message type cannot be empty")
    private String msgType;

    @ApiModelProperty(value = "Service code.", notes = "Service code.")
    @NotEmpty(message = "Service code cannot be empty")
    private String serviceCode;

    @ApiModelProperty(value = "Command code for the service.", notes = "Command code for the service.")
    @NotEmpty(message = "Command cannot be empty")
    private String cmd;

    @ApiModelProperty(value = "Parameters for the command.", notes = "Parameters for the command.")
    @NotNull(message = "Parameters cannot be null")
    private Map<String, Object> params;
}
