/*
 Navicat Premium Data Transfer

 Source Server         : 测试环境
 Source Server Type    : MySQL
 Source Server Version : 50744 (5.7.44-log)
 Source Host           : 127.0.0.1:13306
 Source Schema         : thinglinks

 Target Server Type    : MySQL
 Target Server Version : 50744 (5.7.44-log)
 File Encoding         : 65001

 Date: 10/05/2024 17:25:49
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for QRTZ_BLOB_TRIGGERS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_BLOB_TRIGGERS`;
CREATE TABLE `QRTZ_BLOB_TRIGGERS` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `trigger_name` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_name的外键',
  `trigger_group` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_group的外键',
  `blob_data` blob COMMENT '存放持久化Trigger对象',
  PRIMARY KEY (`sched_name`,`trigger_name`,`trigger_group`) USING BTREE,
  CONSTRAINT `QRTZ_BLOB_TRIGGERS_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `QRTZ_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='Blob类型的触发器表';

-- ----------------------------
-- Records of QRTZ_BLOB_TRIGGERS
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_CALENDARS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_CALENDARS`;
CREATE TABLE `QRTZ_CALENDARS` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `calendar_name` varchar(200) NOT NULL COMMENT '日历名称',
  `calendar` blob NOT NULL COMMENT '存放持久化calendar对象',
  PRIMARY KEY (`sched_name`,`calendar_name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='日历信息表';

-- ----------------------------
-- Records of QRTZ_CALENDARS
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_CRON_TRIGGERS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_CRON_TRIGGERS`;
CREATE TABLE `QRTZ_CRON_TRIGGERS` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `trigger_name` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_name的外键',
  `trigger_group` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_group的外键',
  `cron_expression` varchar(200) NOT NULL COMMENT 'cron表达式',
  `time_zone_id` varchar(80) DEFAULT NULL COMMENT '时区',
  PRIMARY KEY (`sched_name`,`trigger_name`,`trigger_group`) USING BTREE,
  CONSTRAINT `QRTZ_CRON_TRIGGERS_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `QRTZ_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='Cron类型的触发器表';

-- ----------------------------
-- Records of QRTZ_CRON_TRIGGERS
-- ----------------------------
BEGIN;
INSERT INTO `QRTZ_CRON_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`, `cron_expression`, `time_zone_id`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME1', 'DEFAULT', '0/10 * * * * ?', 'Asia/Shanghai');
INSERT INTO `QRTZ_CRON_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`, `cron_expression`, `time_zone_id`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME12', 'LINK_DEVICE', '0 0/10 * * * ?', 'Asia/Shanghai');
INSERT INTO `QRTZ_CRON_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`, `cron_expression`, `time_zone_id`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME13', 'LINK_DEVICE', '0 0/10 * * * ?', 'Asia/Shanghai');
INSERT INTO `QRTZ_CRON_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`, `cron_expression`, `time_zone_id`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME14', 'LINK_DEVICE', '0 0/10 * * * ?', 'Asia/Shanghai');
INSERT INTO `QRTZ_CRON_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`, `cron_expression`, `time_zone_id`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME15', 'LINK_DEVICE', '0 0/10 * * * ?', 'Asia/Shanghai');
INSERT INTO `QRTZ_CRON_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`, `cron_expression`, `time_zone_id`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME2', 'DEFAULT', '0/15 * * * * ?', 'Asia/Shanghai');
INSERT INTO `QRTZ_CRON_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`, `cron_expression`, `time_zone_id`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME3', 'DEFAULT', '0/20 * * * * ?', 'Asia/Shanghai');
INSERT INTO `QRTZ_CRON_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`, `cron_expression`, `time_zone_id`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME4', 'PROTOCOL', '0 0/10 * * * ?', 'Asia/Shanghai');
INSERT INTO `QRTZ_CRON_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`, `cron_expression`, `time_zone_id`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME7', 'LINK_DEVICE', '0 0 0/12 * * ?', 'Asia/Shanghai');
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_FIRED_TRIGGERS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_FIRED_TRIGGERS`;
CREATE TABLE `QRTZ_FIRED_TRIGGERS` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `entry_id` varchar(95) NOT NULL COMMENT '调度器实例id',
  `trigger_name` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_name的外键',
  `trigger_group` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_group的外键',
  `instance_name` varchar(200) NOT NULL COMMENT '调度器实例名',
  `fired_time` bigint(13) NOT NULL COMMENT '触发的时间',
  `sched_time` bigint(13) NOT NULL COMMENT '定时器制定的时间',
  `priority` int(11) NOT NULL COMMENT '优先级',
  `state` varchar(16) NOT NULL COMMENT '状态',
  `job_name` varchar(200) DEFAULT NULL COMMENT '任务名称',
  `job_group` varchar(200) DEFAULT NULL COMMENT '任务组名',
  `is_nonconcurrent` varchar(1) DEFAULT NULL COMMENT '是否并发',
  `requests_recovery` varchar(1) DEFAULT NULL COMMENT '是否接受恢复执行',
  PRIMARY KEY (`sched_name`,`entry_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='已触发的触发器表';

-- ----------------------------
-- Records of QRTZ_FIRED_TRIGGERS
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_JOB_DETAILS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_JOB_DETAILS`;
CREATE TABLE `QRTZ_JOB_DETAILS` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `job_name` varchar(200) NOT NULL COMMENT '任务名称',
  `job_group` varchar(200) NOT NULL COMMENT '任务组名',
  `description` varchar(250) DEFAULT NULL COMMENT '相关介绍',
  `job_class_name` varchar(250) NOT NULL COMMENT '执行任务类名称',
  `is_durable` varchar(1) NOT NULL COMMENT '是否持久化',
  `is_nonconcurrent` varchar(1) NOT NULL COMMENT '是否并发',
  `is_update_data` varchar(1) NOT NULL COMMENT '是否更新数据',
  `requests_recovery` varchar(1) NOT NULL COMMENT '是否接受恢复执行',
  `job_data` blob COMMENT '存放持久化job对象',
  PRIMARY KEY (`sched_name`,`job_name`,`job_group`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='任务详细信息表';

-- ----------------------------
-- Records of QRTZ_JOB_DETAILS
-- ----------------------------
BEGIN;
INSERT INTO `QRTZ_JOB_DETAILS` (`sched_name`, `job_name`, `job_group`, `description`, `job_class_name`, `is_durable`, `is_nonconcurrent`, `is_update_data`, `requests_recovery`, `job_data`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME1', 'DEFAULT', NULL, 'com.mqttsnet.thinglinks.job.utils.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372002D636F6D2E6D717474736E65742E7468696E676C696E6B732E6A6F622E6170692E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720039636F6D2E6D717474736E65742E7468696E676C696E6B732E636F6D6D6F6E2E636F72652E7765622E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017BF357AE9878707400007070707400013174000E302F3130202A202A202A202A203F74001172795461736B2E72794E6F506172616D7374000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000001740018E7B3BBE7BB9FE9BB98E8AEA4EFBC88E697A0E58F82EFBC8974000133740001317800);
INSERT INTO `QRTZ_JOB_DETAILS` (`sched_name`, `job_name`, `job_group`, `description`, `job_class_name`, `is_durable`, `is_nonconcurrent`, `is_update_data`, `requests_recovery`, `job_data`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME12', 'LINK_DEVICE', NULL, 'com.mqttsnet.thinglinks.job.utils.QuartzJobExecution', '0', '0', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372002D636F6D2E6D717474736E65742E7468696E676C696E6B732E6A6F622E6170692E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720039636F6D2E6D717474736E65742E7468696E676C696E6B732E636F6D6D6F6E2E636F72652E7765622E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000018E6F6B518078707400007070707400013074000E3020302F3130202A202A202A203F7400326361636865446576696365496E666F5461736B2E72656672657368446576696365496E666F446174614D6F64656C2827272974000B4C494E4B5F4445564943457372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000000C740027E588B7E696B0E5AD90E8AEBEE5A487E8AEBEE5A487E7BC93E5AD98E5AE9AE697B6E4BBBBE58AA174000131740001307800);
INSERT INTO `QRTZ_JOB_DETAILS` (`sched_name`, `job_name`, `job_group`, `description`, `job_class_name`, `is_durable`, `is_nonconcurrent`, `is_update_data`, `requests_recovery`, `job_data`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME13', 'LINK_DEVICE', NULL, 'com.mqttsnet.thinglinks.job.utils.QuartzJobExecution', '0', '0', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372002D636F6D2E6D717474736E65742E7468696E676C696E6B732E6A6F622E6170692E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720039636F6D2E6D717474736E65742E7468696E676C696E6B732E636F6D6D6F6E2E636F72652E7765622E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000018E6FA99EB878707400007070707400013074000E3020302F3130202A202A202A203F74002A63616368654465766963655461736B2E72656672657368416C6C4465766963654361636865732827272974000B4C494E4B5F4445564943457372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000000D74001EE588B7E696B0E8AEBEE5A487E7BC93E5AD98E5AE9AE697B6E4BBBBE58AA174000131740001307800);
INSERT INTO `QRTZ_JOB_DETAILS` (`sched_name`, `job_name`, `job_group`, `description`, `job_class_name`, `is_durable`, `is_nonconcurrent`, `is_update_data`, `requests_recovery`, `job_data`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME14', 'LINK_DEVICE', NULL, 'com.mqttsnet.thinglinks.job.utils.QuartzJobExecution', '0', '0', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372002D636F6D2E6D717474736E65742E7468696E676C696E6B732E6A6F622E6170692E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720039636F6D2E6D717474736E65742E7468696E676C696E6B732E636F6D6D6F6E2E636F72652E7765622E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000018E6FAABFC878707400007070707400013074000E3020302F3130202A202A202A203F74002C636163686550726F647563745461736B2E72656672657368416C6C50726F647563744361636865732827272974000B4C494E4B5F4445564943457372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000000E74001EE588B7E696B0E4BAA7E59381E7BC93E5AD98E5AE9AE697B6E4BBBBE58AA174000131740001307800);
INSERT INTO `QRTZ_JOB_DETAILS` (`sched_name`, `job_name`, `job_group`, `description`, `job_class_name`, `is_durable`, `is_nonconcurrent`, `is_update_data`, `requests_recovery`, `job_data`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME15', 'LINK_DEVICE', NULL, 'com.mqttsnet.thinglinks.job.utils.QuartzJobExecution', '0', '0', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372002D636F6D2E6D717474736E65742E7468696E676C696E6B732E6A6F622E6170692E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720039636F6D2E6D717474736E65742E7468696E676C696E6B732E636F6D6D6F6E2E636F72652E7765622E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000018E6FAC699078707400007070707400013074000E3020302F3130202A202A202A203F740036636163686550726F647563744D6F64656C5461736B2E72656672657368416C6C50726F647563744D6F64656C4361636865732827272974000B4C494E4B5F4445564943457372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000000F740024E588B7E696B0E4BAA7E59381E6A8A1E59E8BE7BC93E5AD98E5AE9AE697B6E4BBBBE58AA174000131740001307800);
INSERT INTO `QRTZ_JOB_DETAILS` (`sched_name`, `job_name`, `job_group`, `description`, `job_class_name`, `is_durable`, `is_nonconcurrent`, `is_update_data`, `requests_recovery`, `job_data`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME2', 'DEFAULT', NULL, 'com.mqttsnet.thinglinks.job.utils.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372002D636F6D2E6D717474736E65742E7468696E676C696E6B732E6A6F622E6170692E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720039636F6D2E6D717474736E65742E7468696E676C696E6B732E636F6D6D6F6E2E636F72652E7765622E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017BF357AE9878707400007070707400013174000E302F3135202A202A202A202A203F74001572795461736B2E7279506172616D7328277279272974000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000002740018E7B3BBE7BB9FE9BB98E8AEA4EFBC88E69C89E58F82EFBC8974000133740001317800);
INSERT INTO `QRTZ_JOB_DETAILS` (`sched_name`, `job_name`, `job_group`, `description`, `job_class_name`, `is_durable`, `is_nonconcurrent`, `is_update_data`, `requests_recovery`, `job_data`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME3', 'DEFAULT', NULL, 'com.mqttsnet.thinglinks.job.utils.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372002D636F6D2E6D717474736E65742E7468696E676C696E6B732E6A6F622E6170692E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720039636F6D2E6D717474736E65742E7468696E676C696E6B732E636F6D6D6F6E2E636F72652E7765622E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017BF357AE9878707400007070707400013174000E302F3230202A202A202A202A203F74003872795461736B2E72794D756C7469706C65506172616D7328277279272C20747275652C20323030304C2C203331362E3530442C203130302974000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000003740018E7B3BBE7BB9FE9BB98E8AEA4EFBC88E5A49AE58F82EFBC8974000133740001317800);
INSERT INTO `QRTZ_JOB_DETAILS` (`sched_name`, `job_name`, `job_group`, `description`, `job_class_name`, `is_durable`, `is_nonconcurrent`, `is_update_data`, `requests_recovery`, `job_data`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME4', 'PROTOCOL', NULL, 'com.mqttsnet.thinglinks.job.utils.QuartzJobExecution', '0', '0', '0', '0', 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
INSERT INTO `QRTZ_JOB_DETAILS` (`sched_name`, `job_name`, `job_group`, `description`, `job_class_name`, `is_durable`, `is_nonconcurrent`, `is_update_data`, `requests_recovery`, `job_data`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME7', 'LINK_DEVICE', NULL, 'com.mqttsnet.thinglinks.job.utils.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372002D636F6D2E6D717474736E65742E7468696E676C696E6B732E6A6F622E6170692E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720039636F6D2E6D717474736E65742E7468696E676C696E6B732E636F6D6D6F6E2E636F72652E7765622E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C787074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000018248AD1D2878707400007070707400013174000E30203020302F3132202A202A203F7400316C696E6B446576696365496E666F5461736B2E72656672657368446576696365496E666F446174614D6F64656C2827272974000B4C494E4B5F4445564943457372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000000774001BE588B7E696B0E5AD90E8AEBEE5A487E695B0E68DAEE6A8A1E59E8B74000131740001317800);
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_LOCKS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_LOCKS`;
CREATE TABLE `QRTZ_LOCKS` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `lock_name` varchar(40) NOT NULL COMMENT '悲观锁名称',
  PRIMARY KEY (`sched_name`,`lock_name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='存储的悲观锁信息表';

-- ----------------------------
-- Records of QRTZ_LOCKS
-- ----------------------------
BEGIN;
INSERT INTO `QRTZ_LOCKS` (`sched_name`, `lock_name`) VALUES ('mqttsScheduler', 'STATE_ACCESS');
INSERT INTO `QRTZ_LOCKS` (`sched_name`, `lock_name`) VALUES ('mqttsScheduler', 'TRIGGER_ACCESS');
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_PAUSED_TRIGGER_GRPS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_PAUSED_TRIGGER_GRPS`;
CREATE TABLE `QRTZ_PAUSED_TRIGGER_GRPS` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `trigger_group` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_group的外键',
  PRIMARY KEY (`sched_name`,`trigger_group`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='暂停的触发器表';

-- ----------------------------
-- Records of QRTZ_PAUSED_TRIGGER_GRPS
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_SCHEDULER_STATE
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_SCHEDULER_STATE`;
CREATE TABLE `QRTZ_SCHEDULER_STATE` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `instance_name` varchar(200) NOT NULL COMMENT '实例名称',
  `last_checkin_time` bigint(13) NOT NULL COMMENT '上次检查时间',
  `checkin_interval` bigint(13) NOT NULL COMMENT '检查间隔时间',
  PRIMARY KEY (`sched_name`,`instance_name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='调度器状态表';

-- ----------------------------
-- Records of QRTZ_SCHEDULER_STATE
-- ----------------------------
BEGIN;
INSERT INTO `QRTZ_SCHEDULER_STATE` (`sched_name`, `instance_name`, `last_checkin_time`, `checkin_interval`) VALUES ('mqttsScheduler', 'xiaonandeMacBook-Pro.local1715331095730', 1715332918233, 15000);
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_SIMPLE_TRIGGERS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_SIMPLE_TRIGGERS`;
CREATE TABLE `QRTZ_SIMPLE_TRIGGERS` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `trigger_name` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_name的外键',
  `trigger_group` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_group的外键',
  `repeat_count` bigint(7) NOT NULL COMMENT '重复的次数统计',
  `repeat_interval` bigint(12) NOT NULL COMMENT '重复的间隔时间',
  `times_triggered` bigint(10) NOT NULL COMMENT '已经触发的次数',
  PRIMARY KEY (`sched_name`,`trigger_name`,`trigger_group`) USING BTREE,
  CONSTRAINT `QRTZ_SIMPLE_TRIGGERS_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `QRTZ_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='简单触发器的信息表';

-- ----------------------------
-- Records of QRTZ_SIMPLE_TRIGGERS
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_SIMPROP_TRIGGERS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_SIMPROP_TRIGGERS`;
CREATE TABLE `QRTZ_SIMPROP_TRIGGERS` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `trigger_name` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_name的外键',
  `trigger_group` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_group的外键',
  `str_prop_1` varchar(512) DEFAULT NULL COMMENT 'String类型的trigger的第一个参数',
  `str_prop_2` varchar(512) DEFAULT NULL COMMENT 'String类型的trigger的第二个参数',
  `str_prop_3` varchar(512) DEFAULT NULL COMMENT 'String类型的trigger的第三个参数',
  `int_prop_1` int(11) DEFAULT NULL COMMENT 'int类型的trigger的第一个参数',
  `int_prop_2` int(11) DEFAULT NULL COMMENT 'int类型的trigger的第二个参数',
  `long_prop_1` bigint(20) DEFAULT NULL COMMENT 'long类型的trigger的第一个参数',
  `long_prop_2` bigint(20) DEFAULT NULL COMMENT 'long类型的trigger的第二个参数',
  `dec_prop_1` decimal(13,4) DEFAULT NULL COMMENT 'decimal类型的trigger的第一个参数',
  `dec_prop_2` decimal(13,4) DEFAULT NULL COMMENT 'decimal类型的trigger的第二个参数',
  `bool_prop_1` varchar(1) DEFAULT NULL COMMENT 'Boolean类型的trigger的第一个参数',
  `bool_prop_2` varchar(1) DEFAULT NULL COMMENT 'Boolean类型的trigger的第二个参数',
  PRIMARY KEY (`sched_name`,`trigger_name`,`trigger_group`) USING BTREE,
  CONSTRAINT `QRTZ_SIMPROP_TRIGGERS_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `QRTZ_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='同步机制的行锁表';

-- ----------------------------
-- Records of QRTZ_SIMPROP_TRIGGERS
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_TRIGGERS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_TRIGGERS`;
CREATE TABLE `QRTZ_TRIGGERS` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `trigger_name` varchar(200) NOT NULL COMMENT '触发器的名字',
  `trigger_group` varchar(200) NOT NULL COMMENT '触发器所属组的名字',
  `job_name` varchar(200) NOT NULL COMMENT 'qrtz_job_details表job_name的外键',
  `job_group` varchar(200) NOT NULL COMMENT 'qrtz_job_details表job_group的外键',
  `description` varchar(250) DEFAULT NULL COMMENT '相关介绍',
  `next_fire_time` bigint(13) DEFAULT NULL COMMENT '上一次触发时间（毫秒）',
  `prev_fire_time` bigint(13) DEFAULT NULL COMMENT '下一次触发时间（默认为-1表示不触发）',
  `priority` int(11) DEFAULT NULL COMMENT '优先级',
  `trigger_state` varchar(16) NOT NULL COMMENT '触发器状态',
  `trigger_type` varchar(8) NOT NULL COMMENT '触发器的类型',
  `start_time` bigint(13) NOT NULL COMMENT '开始时间',
  `end_time` bigint(13) DEFAULT NULL COMMENT '结束时间',
  `calendar_name` varchar(200) DEFAULT NULL COMMENT '日程表名称',
  `misfire_instr` smallint(2) DEFAULT NULL COMMENT '补偿执行的策略',
  `job_data` blob COMMENT '存放持久化job对象',
  PRIMARY KEY (`sched_name`,`trigger_name`,`trigger_group`) USING BTREE,
  KEY `sched_name` (`sched_name`,`job_name`,`job_group`) USING BTREE,
  CONSTRAINT `QRTZ_TRIGGERS_ibfk_1` FOREIGN KEY (`sched_name`, `job_name`, `job_group`) REFERENCES `QRTZ_JOB_DETAILS` (`sched_name`, `job_name`, `job_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='触发器详细信息表';

-- ----------------------------
-- Records of QRTZ_TRIGGERS
-- ----------------------------
BEGIN;
INSERT INTO `QRTZ_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`, `job_name`, `job_group`, `description`, `next_fire_time`, `prev_fire_time`, `priority`, `trigger_state`, `trigger_type`, `start_time`, `end_time`, `calendar_name`, `misfire_instr`, `job_data`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME1', 'DEFAULT', 'TASK_CLASS_NAME1', 'DEFAULT', NULL, 1715331100000, -1, 5, 'PAUSED', 'CRON', 1715331096000, 0, NULL, 2, '');
INSERT INTO `QRTZ_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`, `job_name`, `job_group`, `description`, `next_fire_time`, `prev_fire_time`, `priority`, `trigger_state`, `trigger_type`, `start_time`, `end_time`, `calendar_name`, `misfire_instr`, `job_data`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME12', 'LINK_DEVICE', 'TASK_CLASS_NAME12', 'LINK_DEVICE', NULL, 1715333400000, 1715332800000, 5, 'WAITING', 'CRON', 1715331101000, 0, NULL, -1, '');
INSERT INTO `QRTZ_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`, `job_name`, `job_group`, `description`, `next_fire_time`, `prev_fire_time`, `priority`, `trigger_state`, `trigger_type`, `start_time`, `end_time`, `calendar_name`, `misfire_instr`, `job_data`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME13', 'LINK_DEVICE', 'TASK_CLASS_NAME13', 'LINK_DEVICE', NULL, 1715333400000, 1715332800000, 5, 'WAITING', 'CRON', 1715331101000, 0, NULL, -1, '');
INSERT INTO `QRTZ_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`, `job_name`, `job_group`, `description`, `next_fire_time`, `prev_fire_time`, `priority`, `trigger_state`, `trigger_type`, `start_time`, `end_time`, `calendar_name`, `misfire_instr`, `job_data`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME14', 'LINK_DEVICE', 'TASK_CLASS_NAME14', 'LINK_DEVICE', NULL, 1715333400000, 1715332800000, 5, 'WAITING', 'CRON', 1715331102000, 0, NULL, -1, '');
INSERT INTO `QRTZ_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`, `job_name`, `job_group`, `description`, `next_fire_time`, `prev_fire_time`, `priority`, `trigger_state`, `trigger_type`, `start_time`, `end_time`, `calendar_name`, `misfire_instr`, `job_data`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME15', 'LINK_DEVICE', 'TASK_CLASS_NAME15', 'LINK_DEVICE', NULL, 1715333400000, 1715332800000, 5, 'WAITING', 'CRON', 1715331102000, 0, NULL, -1, '');
INSERT INTO `QRTZ_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`, `job_name`, `job_group`, `description`, `next_fire_time`, `prev_fire_time`, `priority`, `trigger_state`, `trigger_type`, `start_time`, `end_time`, `calendar_name`, `misfire_instr`, `job_data`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME2', 'DEFAULT', 'TASK_CLASS_NAME2', 'DEFAULT', NULL, 1715331105000, -1, 5, 'PAUSED', 'CRON', 1715331097000, 0, NULL, 2, '');
INSERT INTO `QRTZ_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`, `job_name`, `job_group`, `description`, `next_fire_time`, `prev_fire_time`, `priority`, `trigger_state`, `trigger_type`, `start_time`, `end_time`, `calendar_name`, `misfire_instr`, `job_data`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME3', 'DEFAULT', 'TASK_CLASS_NAME3', 'DEFAULT', NULL, 1715331100000, -1, 5, 'PAUSED', 'CRON', 1715331098000, 0, NULL, 2, '');
INSERT INTO `QRTZ_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`, `job_name`, `job_group`, `description`, `next_fire_time`, `prev_fire_time`, `priority`, `trigger_state`, `trigger_type`, `start_time`, `end_time`, `calendar_name`, `misfire_instr`, `job_data`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME4', 'PROTOCOL', 'TASK_CLASS_NAME4', 'PROTOCOL', NULL, 1715333400000, 1715332800000, 5, 'WAITING', 'CRON', 1715331305000, 0, NULL, 1, '');
INSERT INTO `QRTZ_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`, `job_name`, `job_group`, `description`, `next_fire_time`, `prev_fire_time`, `priority`, `trigger_state`, `trigger_type`, `start_time`, `end_time`, `calendar_name`, `misfire_instr`, `job_data`) VALUES ('mqttsScheduler', 'TASK_CLASS_NAME7', 'LINK_DEVICE', 'TASK_CLASS_NAME7', 'LINK_DEVICE', NULL, 1715356800000, -1, 5, 'PAUSED', 'CRON', 1715331100000, 0, NULL, -1, '');
COMMIT;

-- ----------------------------
-- Table structure for action_commands
-- ----------------------------
DROP TABLE IF EXISTS `action_commands`;
CREATE TABLE `action_commands` (
  `id` int(19) unsigned NOT NULL AUTO_INCREMENT,
  `business_type` int(11) NOT NULL COMMENT '业务类型:0规则生效1产品生效2设备生效',
  `rule_identification` varchar(100) DEFAULT NULL COMMENT '规则标识',
  `product_identification` varchar(100) DEFAULT NULL COMMENT '产品标识',
  `device_identification` varchar(100) DEFAULT NULL COMMENT '设备标识',
  `service_id` int(19) DEFAULT NULL COMMENT '服务id',
  `service_name` varchar(255) DEFAULT NULL COMMENT '服务名称',
  `command_id` int(19) DEFAULT NULL COMMENT '命令id',
  `command_body` text COMMENT 'json命令参数及参数值{"key":"value","key1":"value1"}',
  `ctreate_by` varchar(255) DEFAULT NULL COMMENT '创建者',
  `command_name` varchar(255) DEFAULT NULL COMMENT '命令名称\n',
  `ctreate_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(255) DEFAULT NULL COMMENT '更新者',
  `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COMMENT='动作命令信息表';

-- ----------------------------
-- Records of action_commands
-- ----------------------------
BEGIN;
INSERT INTO `action_commands` (`id`, `business_type`, `rule_identification`, `product_identification`, `device_identification`, `service_id`, `service_name`, `command_id`, `command_body`, `ctreate_by`, `command_name`, `ctreate_time`, `update_by`, `update_time`) VALUES (3, 0, 'a831d344c1784b35985b85026ce8fae1', '753c729dc92c42e08faa485cfb944ad5', 'device001', 75, NULL, 9, '{\"aa\":1,\"bb\":2}', 'admin', NULL, '2022-12-12 17:39:40', NULL, '2022-12-12 17:39:40');
COMMIT;

-- ----------------------------
-- Table structure for casbin_rule
-- ----------------------------
DROP TABLE IF EXISTS `casbin_rule`;
CREATE TABLE `casbin_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ptype` varchar(100) NOT NULL,
  `v0` varchar(100) DEFAULT NULL,
  `v1` varchar(100) DEFAULT NULL,
  `v2` varchar(100) DEFAULT NULL,
  `v3` varchar(100) DEFAULT NULL,
  `v4` varchar(100) DEFAULT NULL,
  `v5` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of casbin_rule
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for device
-- ----------------------------
DROP TABLE IF EXISTS `device`;
CREATE TABLE `device` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `client_id` varchar(255) NOT NULL COMMENT '客户端标识',
  `user_name` varchar(255) NOT NULL COMMENT '用户名',
  `password` varchar(255) NOT NULL COMMENT '密码',
  `app_id` varchar(64) NOT NULL COMMENT '应用ID',
  `auth_mode` varchar(255) DEFAULT NULL COMMENT '认证方式',
  `device_identification` varchar(100) NOT NULL COMMENT '设备标识',
  `device_name` varchar(255) NOT NULL COMMENT '设备名称',
  `connector` varchar(255) DEFAULT NULL COMMENT '连接实例',
  `device_description` varchar(255) DEFAULT NULL COMMENT '设备描述',
  `device_status` varchar(255) NOT NULL COMMENT '设备状态： 启用 || 禁用',
  `connect_status` varchar(255) DEFAULT NULL COMMENT '连接状态 : 在线：ONLINE || 离线：OFFLINE || 未连接：INIT',
  `is_will` varchar(255) DEFAULT NULL COMMENT '是否遗言',
  `device_tags` varchar(255) DEFAULT NULL COMMENT '设备标签',
  `product_identification` varchar(255) NOT NULL COMMENT '产品标识',
  `protocol_type` varchar(255) NOT NULL COMMENT '产品协议类型 ：mqtt || coap || modbus || http',
  `device_type` varchar(255) DEFAULT NULL COMMENT '设备类型',
  `create_by` varchar(64) DEFAULT 'ununited' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `encrypt_key` varchar(255) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '加密密钥',
  `encrypt_vector` varchar(255) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '加密向量',
  `sign_key` varchar(255) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '签名密钥',
  `encrypt_method` varchar(4) NOT NULL DEFAULT '0' COMMENT '协议加密方式',
  `sw_version` varchar(255) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '软件版本',
  `fw_version` varchar(255) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '固件版本',
  `device_sdk_version` varchar(255) CHARACTER SET utf8mb4 NOT NULL DEFAULT 'v1' COMMENT 'sdk版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `device_id` (`device_identification`) USING BTREE COMMENT '设备标识',
  KEY `client_id` (`client_id`) USING BTREE COMMENT '客户端标识'
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8 COMMENT='边设备档案信息表';

-- ----------------------------
-- Records of device
-- ----------------------------
BEGIN;
INSERT INTO `device` (`id`, `client_id`, `user_name`, `password`, `app_id`, `auth_mode`, `device_identification`, `device_name`, `connector`, `device_description`, `device_status`, `connect_status`, `is_will`, `device_tags`, `product_identification`, `protocol_type`, `device_type`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`, `encrypt_key`, `encrypt_vector`, `sign_key`, `encrypt_method`, `sw_version`, `fw_version`, `device_sdk_version`) VALUES (67, '1036150750765056@1', '123456', '123456', 'thinglinks', 'default', '7033164773752833', '123', '127.0.0.1:11883', NULL, 'ENABLE', 'OFFLINE', NULL, NULL, '53bf9b67bade40609bd5fb5834dca09b', 'MQTT', 'COMMON', 'admin', '2022-11-21 19:08:31', '', '2024-05-08 19:24:38', NULL, '', '', '', '0', '', '', 'v1');
COMMIT;

-- ----------------------------
-- Table structure for device_action
-- ----------------------------
DROP TABLE IF EXISTS `device_action`;
CREATE TABLE `device_action` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `device_identification` varchar(255) DEFAULT NULL COMMENT '设备标识',
  `action_type` varchar(255) DEFAULT NULL COMMENT '动作类型',
  `message` longtext COMMENT '内容信息',
  `status` varchar(255) DEFAULT NULL COMMENT '状态',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `device_id` (`device_identification`) USING BTREE COMMENT '设备标识'
) ENGINE=InnoDB AUTO_INCREMENT=386 DEFAULT CHARSET=utf8 COMMENT='设备动作数据';

-- ----------------------------
-- Records of device_action
-- ----------------------------
BEGIN;
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (152, '1036150750765056@1', 'DISCONNECT', 'The device connection status is updated to OFFLINE', 'SUCCESS', '2024-03-24 01:06:47');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (153, '1036150750765056@1', 'SUBSCRIBE', 'Subscribing to a topic to receive messages.', 'SUCCESS', '2024-03-24 01:06:48');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (154, '1036150750765056@1', 'SUBSCRIBE', 'Subscribing to a topic to receive messages.', 'SUCCESS', '2024-03-24 01:06:48');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (155, '1036150750765056@1', 'SUBSCRIBE', 'Subscribing to a topic to receive messages.', 'SUCCESS', '2024-03-24 01:06:48');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (156, '1036150750765056@1', 'CONNECT', 'The device connection status is updated to ONLINE', 'SUCCESS', '2024-03-24 01:06:48');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (157, '1036150750765056@1', 'SUBSCRIBE', 'Subscribing to a topic to receive messages.', 'SUCCESS', '2024-03-24 01:13:00');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (158, '1036150750765056@1', 'CONNECT', 'The device connection status is updated to ONLINE', 'SUCCESS', '2024-03-24 01:13:00');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (159, '1036150750765056@1', 'SUBSCRIBE', 'Subscribing to a topic to receive messages.', 'SUCCESS', '2024-03-24 01:28:11');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (160, '1036150750765056@1', 'CONNECT', 'The device connection status is updated to ONLINE', 'SUCCESS', '2024-03-24 01:28:11');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (161, '1036150750765056@1', 'SUBSCRIBE', 'Subscribing to a topic to receive messages.', 'SUCCESS', '2024-03-24 01:44:52');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (162, '1036150750765056@1', 'CONNECT', 'The device connection status is updated to ONLINE', 'SUCCESS', '2024-03-24 01:44:52');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (163, '1036150750765056@1', 'SUBSCRIBE', 'Subscribing to a topic to receive messages.', 'SUCCESS', '2024-03-24 01:57:03');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (164, '1036150750765056@1', 'CONNECT', 'The device connection status is updated to ONLINE', 'SUCCESS', '2024-03-24 01:57:04');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (165, '1036150750765056@1', 'SUBSCRIBE', 'Subscribing to a topic to receive messages.', 'SUCCESS', '2024-03-24 02:03:16');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (166, '1036150750765056@1', 'CONNECT', 'The device connection status is updated to ONLINE', 'SUCCESS', '2024-03-24 02:03:23');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (167, '1036150750765056@1', 'SUBSCRIBE', 'Subscribing to a topic to receive messages.', 'SUCCESS', '2024-03-24 02:13:57');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (168, '1036150750765056@1', 'CONNECT', 'The device connection status is updated to ONLINE', 'SUCCESS', '2024-03-24 02:13:58');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (169, '1036150750765056@1', 'SUBSCRIBE', 'Subscribing to a topic to receive messages.', 'SUCCESS', '2024-03-24 02:20:09');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (170, '1036150750765056@1', 'CONNECT', 'The device connection status is updated to ONLINE', 'SUCCESS', '2024-03-24 02:20:09');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (171, '1036150750765056@1', 'SUBSCRIBE', 'Subscribing to a topic to receive messages.', 'SUCCESS', '2024-03-24 02:29:20');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (172, '1036150750765056@1', 'CONNECT', 'The device connection status is updated to ONLINE', 'SUCCESS', '2024-03-24 02:29:20');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (173, '1036150750765056@1', 'SUBSCRIBE', 'Subscribing to a topic to receive messages.', 'SUCCESS', '2024-03-24 02:37:01');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (174, '1036150750765056@1', 'CONNECT', 'The device connection status is updated to ONLINE', 'SUCCESS', '2024-03-24 02:37:01');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (175, '1036150750765056@1', 'SUBSCRIBE', 'Subscribing to a topic to receive messages.', 'SUCCESS', '2024-03-24 03:00:16');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (176, '1036150750765056@1', 'CONNECT', 'The device connection status is updated to ONLINE', 'SUCCESS', '2024-03-24 03:00:16');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (177, '1036150750765056@1', 'SUBSCRIBE', 'Subscribing to a topic to receive messages.', 'SUCCESS', '2024-03-24 04:58:57');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (178, '1036150750765056@1', 'CONNECT', 'The device connection status is updated to ONLINE', 'SUCCESS', '2024-03-24 04:58:57');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (179, '1036150750765056@1', 'CONNECT', 'The device connection status is updated to ONLINE', 'SUCCESS', '2024-03-24 05:20:24');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (180, '1036150750765056@1', 'SUBSCRIBE', '{\"clientId\":\"1036150750765056@1\",\"address\":\"/127.0.0.1:49391\",\"success\":\"success\",\"tenantId\":\"1\",\"messageId\":44332,\"topic\":\"/v1/devices/10A5621DC5EB/down\",\"event\":\"SUBSCRIBE\",\"timestamp\":1711298335780}', 'SUCCESS', '2024-03-25 00:38:56');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (181, '1036150750765056@1', 'SUBSCRIBE', '{\"clientId\":\"1036150750765056@1\",\"address\":\"/127.0.0.1:49391\",\"success\":\"success\",\"tenantId\":\"1\",\"messageId\":44330,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1711298335592}', 'SUCCESS', '2024-03-25 00:38:57');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (182, '1036150750765056@1', 'SUBSCRIBE', '{\"clientId\":\"1036150750765056@1\",\"address\":\"/127.0.0.1:49391\",\"success\":\"success\",\"tenantId\":\"1\",\"messageId\":44331,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1711298335692}', 'SUCCESS', '2024-03-25 00:38:57');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (183, '1036150750765056@1', 'CONNECT', '{\"clientId\":\"1036150750765056@1\",\"address\":\"/127.0.0.1:49391\",\"success\":\"success\",\"tenantId\":\"1\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1711298335512}', 'SUCCESS', '2024-03-25 00:38:57');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (184, '1036150750765056@1', 'DISCONNECT', '{\"clientId\":\"1036150750765056@1\",\"address\":\"/127.0.0.1:49391\",\"success\":\"success\",\"tenantId\":\"1\",\"event\":\"DISCONNECT\",\"timestamp\":1711302940730}', 'SUCCESS', '2024-03-27 21:58:50');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (190, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:50958\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":12236,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1711613766657}', 'SUCCESS', '2024-03-28 16:16:07');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (191, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:50958\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1711613766649}', 'SUCCESS', '2024-03-28 16:16:07');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (192, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:52573\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":12237,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1711614498121}', 'SUCCESS', '2024-03-28 16:28:18');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (193, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:52573\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1711614498090}', 'SUCCESS', '2024-03-28 16:28:18');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (194, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:54365\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":12238,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1711615319635}', 'SUCCESS', '2024-03-28 16:42:00');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (195, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:54365\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1711615319589}', 'SUCCESS', '2024-03-28 16:42:00');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (196, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55393\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":12239,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1711615691719}', 'SUCCESS', '2024-03-28 16:48:12');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (197, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55393\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1711615691684}', 'SUCCESS', '2024-03-28 16:48:12');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (198, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:56359\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":12240,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1711616063699}', 'SUCCESS', '2024-03-28 16:54:24');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (199, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:56359\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1711616063672}', 'SUCCESS', '2024-03-28 16:54:24');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (200, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57973\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":12241,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1711616705813}', 'SUCCESS', '2024-03-28 17:05:06');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (201, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57973\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1711616705785}', 'SUCCESS', '2024-03-28 17:05:06');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (202, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:59282\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":12242,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1711617257663}', 'SUCCESS', '2024-03-28 17:14:18');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (203, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:59282\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1711617257624}', 'SUCCESS', '2024-03-28 17:14:18');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (204, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:60707\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":12243,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1711617899746}', 'SUCCESS', '2024-03-28 17:25:00');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (205, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:60707\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1711617899711}', 'SUCCESS', '2024-03-28 17:25:00');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (206, '4207313761001472', 'DISCONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:60707\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"event\":\"DISCONNECT\",\"timestamp\":1711618145404}', 'SUCCESS', '2024-03-28 17:29:06');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (207, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:54196\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":4631,\"topic\":\"/v1/devices/10A5621DC5EB/down\",\"event\":\"SUBSCRIBE\",\"timestamp\":1712476185036}', 'SUCCESS', '2024-04-07 15:49:45');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (208, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:54196\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":4630,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1712476184933}', 'SUCCESS', '2024-04-07 15:49:45');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (209, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:54196\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":4629,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1712476184882}', 'SUCCESS', '2024-04-07 15:49:45');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (210, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:54196\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1712476184786}', 'SUCCESS', '2024-04-07 15:49:45');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (211, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57652\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":4632,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1712479664284}', 'SUCCESS', '2024-04-07 16:47:44');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (212, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57652\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1712479664239}', 'SUCCESS', '2024-04-07 16:47:45');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (213, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:59308\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":4633,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1712480799293}', 'SUCCESS', '2024-04-07 17:06:39');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (214, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:59308\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1712480799289}', 'SUCCESS', '2024-04-07 17:06:40');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (215, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:60077\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":4634,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1712481261536}', 'SUCCESS', '2024-04-07 17:14:22');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (216, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:60077\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1712481261528}', 'SUCCESS', '2024-04-07 17:14:22');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (217, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:60608\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":4635,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1712481632857}', 'SUCCESS', '2024-04-07 17:20:33');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (218, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:60608\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1712481632834}', 'SUCCESS', '2024-04-07 17:20:33');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (219, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:61539\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":4636,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1712482275757}', 'SUCCESS', '2024-04-07 17:31:16');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (220, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:61539\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1712482275737}', 'SUCCESS', '2024-04-07 17:31:16');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (221, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:62029\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":4637,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1712482647199}', 'SUCCESS', '2024-04-07 17:37:27');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (222, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:62029\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1712482647163}', 'SUCCESS', '2024-04-07 17:37:27');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (223, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:62657\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":4638,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1712483019497}', 'SUCCESS', '2024-04-07 17:43:39');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (224, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:62657\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1712483019465}', 'SUCCESS', '2024-04-07 17:43:40');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (225, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:63727\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":4639,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1712483661405}', 'SUCCESS', '2024-04-07 17:54:21');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (226, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:63727\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1712483661371}', 'SUCCESS', '2024-04-07 17:54:22');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (227, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:64235\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":4640,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1712484032947}', 'SUCCESS', '2024-04-07 18:00:33');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (228, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:64235\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1712484032913}', 'SUCCESS', '2024-04-07 18:00:33');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (229, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:65049\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":4641,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1712484675483}', 'SUCCESS', '2024-04-07 18:11:16');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (230, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:65049\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1712484675460}', 'SUCCESS', '2024-04-07 18:11:16');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (231, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:49185\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":4642,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1712485047285}', 'SUCCESS', '2024-04-07 18:17:27');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (232, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:49185\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1712485047252}', 'SUCCESS', '2024-04-07 18:17:28');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (233, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:49897\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1712485599427}', 'SUCCESS', '2024-04-07 18:26:40');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (234, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:62820\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":8963,\"topic\":\"/v1/devices/10A5621DC5EB/down\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713274200308}', 'SUCCESS', '2024-04-16 21:30:01');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (235, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:62820\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":8962,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713274200203}', 'SUCCESS', '2024-04-16 21:30:01');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (236, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:62820\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":8961,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713274200162}', 'SUCCESS', '2024-04-16 21:30:01');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (237, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:62820\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713274200054}', 'SUCCESS', '2024-04-16 21:30:01');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (238, '4207313761001472', 'DISCONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:62820\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"event\":\"DISCONNECT\",\"timestamp\":1713274202110}', 'SUCCESS', '2024-04-16 21:30:02');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (239, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:62865\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":18338,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713274203963}', 'SUCCESS', '2024-04-16 21:30:04');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (240, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:62865\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":18339,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713274204092}', 'SUCCESS', '2024-04-16 21:30:04');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (241, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:62865\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713274203910}', 'SUCCESS', '2024-04-16 21:30:04');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (242, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:62865\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":18340,\"topic\":\"/v1/devices/10A5621DC5EB/down\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713274204171}', 'SUCCESS', '2024-04-16 21:30:04');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (243, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:62865\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":18341,\"topic\":\"/v1/devices/4207313761001472/topo/addResponse\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713274286393}', 'SUCCESS', '2024-04-16 21:31:26');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (244, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:56745\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":18342,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713276376449}', 'SUCCESS', '2024-04-16 22:06:17');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (245, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:56745\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713276376425}', 'SUCCESS', '2024-04-16 22:06:17');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (246, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:59855\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":18343,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713277018185}', 'SUCCESS', '2024-04-16 22:16:58');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (247, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:59855\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713277018157}', 'SUCCESS', '2024-04-16 22:16:58');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (248, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:61592\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":18344,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713277390291}', 'SUCCESS', '2024-04-16 22:23:10');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (249, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:61592\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713277390265}', 'SUCCESS', '2024-04-16 22:23:10');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (250, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:64155\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":18345,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713277942203}', 'SUCCESS', '2024-04-16 22:32:22');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (251, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:64155\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713277942163}', 'SUCCESS', '2024-04-16 22:32:22');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (252, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:51450\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":18346,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713278584513}', 'SUCCESS', '2024-04-16 22:43:05');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (253, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:51450\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713278584476}', 'SUCCESS', '2024-04-16 22:43:05');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (254, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:53797\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":18347,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713279045622}', 'SUCCESS', '2024-04-16 22:50:46');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (255, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:53797\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713279045579}', 'SUCCESS', '2024-04-16 22:50:46');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (256, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55586\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":18348,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713279417461}', 'SUCCESS', '2024-04-16 22:56:57');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (257, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55586\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713279417429}', 'SUCCESS', '2024-04-16 22:56:58');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (258, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57342\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713279790178}', 'SUCCESS', '2024-04-16 23:03:10');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (259, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57342\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":18349,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713279790233}', 'SUCCESS', '2024-04-16 23:03:10');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (260, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:59919\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":18350,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713280342323}', 'SUCCESS', '2024-04-16 23:12:22');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (261, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:59919\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713280342296}', 'SUCCESS', '2024-04-16 23:12:22');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (262, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:62935\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":18351,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713280984895}', 'SUCCESS', '2024-04-16 23:23:05');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (263, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:62935\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713280984870}', 'SUCCESS', '2024-04-16 23:23:05');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (264, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:49745\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":18352,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713282266462}', 'SUCCESS', '2024-04-16 23:44:27');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (265, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:49745\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713282266433}', 'SUCCESS', '2024-04-16 23:44:27');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (266, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:53038\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713282908189}', 'SUCCESS', '2024-04-16 23:55:08');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (267, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55097\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":32890,\"topic\":\"/v1/devices/10A5621DC5EB/down\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713320543872}', 'SUCCESS', '2024-04-17 10:22:24');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (268, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55097\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":32888,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713320543703}', 'SUCCESS', '2024-04-17 10:22:24');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (269, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55097\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":32889,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713320543772}', 'SUCCESS', '2024-04-17 10:22:24');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (270, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55097\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":32891,\"topic\":\"/v1/devices/4207313761001472/topo/addResponse\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713320543974}', 'SUCCESS', '2024-04-17 10:22:24');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (271, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55097\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713320543638}', 'SUCCESS', '2024-04-17 10:22:24');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (272, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:62980\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":32892,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713322086541}', 'SUCCESS', '2024-04-17 10:48:07');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (273, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:62980\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713322086474}', 'SUCCESS', '2024-04-17 10:48:07');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (274, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:64754\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":32893,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713322458263}', 'SUCCESS', '2024-04-17 10:54:18');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (275, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:64754\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713322458254}', 'SUCCESS', '2024-04-17 10:54:18');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (276, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:54036\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":32894,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713323550378}', 'SUCCESS', '2024-04-17 11:12:31');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (277, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:54036\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713323550374}', 'SUCCESS', '2024-04-17 11:12:31');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (278, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57487\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":32895,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713324192355}', 'SUCCESS', '2024-04-17 11:23:12');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (279, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57487\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713324192347}', 'SUCCESS', '2024-04-17 11:23:13');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (280, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:59324\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":32896,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713324564274}', 'SUCCESS', '2024-04-17 11:29:24');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (281, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:59324\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713324564200}', 'SUCCESS', '2024-04-17 11:29:24');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (282, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:62441\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":32897,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713325205870}', 'SUCCESS', '2024-04-17 11:40:06');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (283, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:62441\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713325205834}', 'SUCCESS', '2024-04-17 11:40:06');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (284, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:64274\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":32898,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713325578648}', 'SUCCESS', '2024-04-17 11:46:19');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (285, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:64274\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713325578609}', 'SUCCESS', '2024-04-17 11:46:19');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (286, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:50682\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":32899,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713326130212}', 'SUCCESS', '2024-04-17 11:55:30');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (287, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:50682\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713326130199}', 'SUCCESS', '2024-04-17 11:55:30');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (288, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:53701\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":32900,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713326772435}', 'SUCCESS', '2024-04-17 12:06:13');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (289, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:53701\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713326772404}', 'SUCCESS', '2024-04-17 12:06:13');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (290, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55466\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":32901,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713327144358}', 'SUCCESS', '2024-04-17 12:12:25');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (291, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55466\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713327144316}', 'SUCCESS', '2024-04-17 12:12:25');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (292, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:58490\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":32902,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713327787923}', 'SUCCESS', '2024-04-17 12:23:08');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (293, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:58490\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713327787883}', 'SUCCESS', '2024-04-17 12:23:08');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (294, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:60243\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713328160507}', 'SUCCESS', '2024-04-17 12:29:21');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (295, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57334\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":53617,\"topic\":\"/v1/devices/4207313761001472/topo/addResponse\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713369118412}', 'SUCCESS', '2024-04-17 23:51:58');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (296, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57334\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":53616,\"topic\":\"/v1/devices/10A5621DC5EB/down\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713369118308}', 'SUCCESS', '2024-04-17 23:51:58');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (297, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57334\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":53614,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713369118107}', 'SUCCESS', '2024-04-17 23:51:59');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (298, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57334\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":53615,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713369118206}', 'SUCCESS', '2024-04-17 23:51:59');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (299, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57334\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713369118028}', 'SUCCESS', '2024-04-17 23:51:59');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (300, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57796\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":49602,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713371939595}', 'SUCCESS', '2024-04-18 00:39:00');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (301, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57796\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":49603,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713371939691}', 'SUCCESS', '2024-04-18 00:39:00');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (302, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57796\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":49605,\"topic\":\"/v1/devices/4207313761001472/topo/addResponse\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713371939899}', 'SUCCESS', '2024-04-18 00:39:01');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (303, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57796\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":49604,\"topic\":\"/v1/devices/10A5621DC5EB/down\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713371939797}', 'SUCCESS', '2024-04-18 00:39:01');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (304, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57796\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713371939518}', 'SUCCESS', '2024-04-18 00:39:01');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (305, '4207313761001472', 'DISCONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57796\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"event\":\"DISCONNECT\",\"timestamp\":1713372767002}', 'SUCCESS', '2024-04-18 20:05:25');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (306, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55317\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":32463,\"topic\":\"/v1/devices/4207313761001472/topo/addResponse\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713452784930}', 'SUCCESS', '2024-04-18 23:06:25');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (307, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55317\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":32460,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713452784655}', 'SUCCESS', '2024-04-18 23:06:25');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (308, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55317\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":32461,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713452784713}', 'SUCCESS', '2024-04-18 23:06:25');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (309, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55317\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":32462,\"topic\":\"/v1/devices/10A5621DC5EB/down\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713452784816}', 'SUCCESS', '2024-04-18 23:06:25');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (310, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55317\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713452784568}', 'SUCCESS', '2024-04-18 23:06:25');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (311, '4207313761001472', 'DISCONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55317\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"event\":\"DISCONNECT\",\"timestamp\":1713452798056}', 'SUCCESS', '2024-04-18 23:06:38');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (312, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55353\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":40011,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713452804505}', 'SUCCESS', '2024-04-18 23:06:44');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (313, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55353\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":40012,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713452804598}', 'SUCCESS', '2024-04-18 23:06:44');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (314, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55353\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":40013,\"topic\":\"/v1/devices/10A5621DC5EB/down\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713452804702}', 'SUCCESS', '2024-04-18 23:06:44');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (315, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55353\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713452804442}', 'SUCCESS', '2024-04-18 23:06:45');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (316, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55353\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":40014,\"topic\":\"/v1/devices/4207313761001472/topo/addResponse\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713452804817}', 'SUCCESS', '2024-04-18 23:06:45');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (317, '4207313761001472', 'UNSUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55353\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":40015,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"UNSUBSCRIBE\",\"timestamp\":1713452856383}', 'SUCCESS', '2024-04-18 23:07:36');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (318, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:55353\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":40016,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713452856458}', 'SUCCESS', '2024-04-18 23:07:36');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (319, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57021\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":40017,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713454435940}', 'SUCCESS', '2024-04-18 23:33:56');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (320, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57021\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713454435898}', 'SUCCESS', '2024-04-18 23:33:56');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (321, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57820\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":40018,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713454988550}', 'SUCCESS', '2024-04-18 23:43:09');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (322, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:57820\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713454988520}', 'SUCCESS', '2024-04-18 23:43:09');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (323, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:65149\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56447,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713493414509}', 'SUCCESS', '2024-04-19 10:23:35');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (324, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:65149\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56445,\"topic\":\"/v1/devices/10A5621DC5EB/down\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713493414429}', 'SUCCESS', '2024-04-19 10:23:35');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (325, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:65149\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56446,\"topic\":\"/v1/devices/4207313761001472/topo/addResponse\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713493414430}', 'SUCCESS', '2024-04-19 10:23:36');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (326, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:65149\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713493414391}', 'SUCCESS', '2024-04-19 10:23:36');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (327, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:65149\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56444,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713493414426}', 'SUCCESS', '2024-04-19 10:23:36');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (328, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:49213\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56448,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713494056825}', 'SUCCESS', '2024-04-19 10:34:17');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (329, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:49213\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56449,\"topic\":\"/v1/devices/10A5621DC5EB/down\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713494056828}', 'SUCCESS', '2024-04-19 10:34:18');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (330, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:49213\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56451,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713494056889}', 'SUCCESS', '2024-04-19 10:34:18');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (331, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:49213\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56450,\"topic\":\"/v1/devices/4207313761001472/topo/addResponse\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713494056828}', 'SUCCESS', '2024-04-19 10:34:18');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (332, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:49213\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713494056803}', 'SUCCESS', '2024-04-19 10:34:18');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (333, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:50227\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56454,\"topic\":\"/v1/devices/4207313761001472/topo/addResponse\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713494968317}', 'SUCCESS', '2024-04-19 10:49:28');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (334, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:50227\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56455,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713494968329}', 'SUCCESS', '2024-04-19 10:49:29');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (335, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:50227\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56453,\"topic\":\"/v1/devices/10A5621DC5EB/down\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713494968317}', 'SUCCESS', '2024-04-19 10:49:29');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (336, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:50227\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56452,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713494968314}', 'SUCCESS', '2024-04-19 10:49:29');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (337, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:50227\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713494968289}', 'SUCCESS', '2024-04-19 10:49:29');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (338, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:51139\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56456,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713495339329}', 'SUCCESS', '2024-04-19 10:55:39');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (339, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:51139\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56457,\"topic\":\"/v1/devices/10A5621DC5EB/down\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713495339331}', 'SUCCESS', '2024-04-19 10:55:39');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (340, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:51139\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56459,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713495339332}', 'SUCCESS', '2024-04-19 10:55:40');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (341, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:51139\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56458,\"topic\":\"/v1/devices/4207313761001472/topo/addResponse\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713495339332}', 'SUCCESS', '2024-04-19 10:55:40');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (342, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:51139\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713495339290}', 'SUCCESS', '2024-04-19 10:55:40');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (343, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:51518\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56463,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713495800912}', 'SUCCESS', '2024-04-19 11:03:21');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (344, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:51518\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56462,\"topic\":\"/v1/devices/4207313761001472/topo/addResponse\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713495800911}', 'SUCCESS', '2024-04-19 11:03:21');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (345, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:51518\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56460,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713495800908}', 'SUCCESS', '2024-04-19 11:03:21');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (346, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:51518\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56461,\"topic\":\"/v1/devices/10A5621DC5EB/down\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713495800910}', 'SUCCESS', '2024-04-19 11:03:21');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (347, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:51518\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713495800870}', 'SUCCESS', '2024-04-19 11:03:21');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (348, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:51896\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56467,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713496352436}', 'SUCCESS', '2024-04-19 11:12:33');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (349, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:51896\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56466,\"topic\":\"/v1/devices/4207313761001472/topo/addResponse\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713496352430}', 'SUCCESS', '2024-04-19 11:12:33');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (350, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:51896\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56464,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713496352428}', 'SUCCESS', '2024-04-19 11:12:33');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (351, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:51896\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56465,\"topic\":\"/v1/devices/10A5621DC5EB/down\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713496352430}', 'SUCCESS', '2024-04-19 11:12:33');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (352, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:51896\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713496352394}', 'SUCCESS', '2024-04-19 11:12:33');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (353, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:52467\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56468,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713497173366}', 'SUCCESS', '2024-04-19 11:26:13');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (354, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:52467\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56471,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713497173373}', 'SUCCESS', '2024-04-19 11:26:13');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (355, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:52467\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56470,\"topic\":\"/v1/devices/4207313761001472/topo/addResponse\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713497173371}', 'SUCCESS', '2024-04-19 11:26:14');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (356, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:52467\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56469,\"topic\":\"/v1/devices/10A5621DC5EB/down\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713497173371}', 'SUCCESS', '2024-04-19 11:26:14');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (357, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:52467\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713497173319}', 'SUCCESS', '2024-04-19 11:26:14');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (358, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:53889\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56473,\"topic\":\"/v1/devices/10A5621DC5EB/down\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713498264168}', 'SUCCESS', '2024-04-19 11:44:24');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (359, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:53889\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56472,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713498264166}', 'SUCCESS', '2024-04-19 11:44:24');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (360, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:53889\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56474,\"topic\":\"/v1/devices/4207313761001472/topo/addResponse\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713498264169}', 'SUCCESS', '2024-04-19 11:44:24');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (361, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:53889\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56475,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713498264169}', 'SUCCESS', '2024-04-19 11:44:25');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (362, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:53889\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713498264124}', 'SUCCESS', '2024-04-19 11:44:25');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (363, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:54251\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56476,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713498815325}', 'SUCCESS', '2024-04-19 11:53:35');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (364, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:54251\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56479,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713498815329}', 'SUCCESS', '2024-04-19 11:53:36');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (365, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:54251\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56477,\"topic\":\"/v1/devices/10A5621DC5EB/down\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713498815328}', 'SUCCESS', '2024-04-19 11:53:36');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (366, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:54251\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56478,\"topic\":\"/v1/devices/4207313761001472/topo/addResponse\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713498815328}', 'SUCCESS', '2024-04-19 11:53:36');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (367, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:54251\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713498815292}', 'SUCCESS', '2024-04-19 11:53:36');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (368, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:54671\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56482,\"topic\":\"/v1/devices/4207313761001472/topo/addResponse\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713499456336}', 'SUCCESS', '2024-04-19 12:04:16');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (369, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:54671\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56483,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713499456353}', 'SUCCESS', '2024-04-19 12:04:17');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (370, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:54671\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56480,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713499456334}', 'SUCCESS', '2024-04-19 12:04:17');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (371, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:54671\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56481,\"topic\":\"/v1/devices/10A5621DC5EB/down\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713499456336}', 'SUCCESS', '2024-04-19 12:04:17');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (372, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:54671\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713499456318}', 'SUCCESS', '2024-04-19 12:04:17');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (373, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:56137\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56486,\"topic\":\"/v1/devices/4207313761001472/topo/addResponse\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713501087288}', 'SUCCESS', '2024-04-19 12:31:28');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (374, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:56137\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56484,\"topic\":\"/v1/devices/1106781324582913/chatgpt/response\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713501087286}', 'SUCCESS', '2024-04-19 12:31:28');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (375, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:56137\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56487,\"topic\":\"/v1/devices/1106781324582913/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713501087299}', 'SUCCESS', '2024-04-19 12:31:28');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (376, '4207313761001472', 'SUBSCRIBE', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:56137\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":56485,\"topic\":\"/v1/devices/10A5621DC5EB/down\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713501087288}', 'SUCCESS', '2024-04-19 12:31:28');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (377, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:56137\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713501087260}', 'SUCCESS', '2024-04-19 12:31:28');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (378, '4207313761001472', 'CONNECT', '{\"clientId\":\"test1234\",\"address\":\"/127.0.0.1:56484\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713501458206}', 'SUCCESS', '2024-04-19 12:37:38');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (379, '7033164773752833', 'SUBSCRIBE', '{\"clientId\":\"1036150750765056@1\",\"address\":\"/127.0.0.1:63570\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":17498,\"topic\":\"/v1/devices/1106781324582913/dataResponse\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713506210889}', 'SUCCESS', '2024-04-19 13:56:51');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (380, '7033164773752833', 'SUBSCRIBE', '{\"clientId\":\"1036150750765056@1\",\"address\":\"/127.0.0.1:63570\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":17500,\"topic\":\"/v1/devices/3160832883650561/topo/updateResponse\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713506211093}', 'SUCCESS', '2024-04-19 13:56:51');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (381, '7033164773752833', 'SUBSCRIBE', '{\"clientId\":\"1036150750765056@1\",\"address\":\"/127.0.0.1:63570\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":17499,\"topic\":\"/v1/devices/3160832883650561/topo/addResponse\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713506211010}', 'SUCCESS', '2024-04-19 13:56:51');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (382, '7033164773752833', 'SUBSCRIBE', '{\"clientId\":\"1036150750765056@1\",\"address\":\"/127.0.0.1:63570\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":17501,\"topic\":\"/v1/devices/3160832883650561/topo/queryResponse\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713506211200}', 'SUCCESS', '2024-04-19 13:56:51');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (383, '7033164773752833', 'CONNECT', '{\"clientId\":\"1036150750765056@1\",\"address\":\"/127.0.0.1:63570\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"keepAliveTimeSeconds\":60,\"event\":\"connect\",\"timestamp\":1713506210822}', 'SUCCESS', '2024-04-19 13:56:51');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (384, '7033164773752833', 'SUBSCRIBE', '{\"clientId\":\"1036150750765056@1\",\"address\":\"/127.0.0.1:63570\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"messageId\":17502,\"topic\":\"/v1/devices/1036150750765057/command\",\"event\":\"SUBSCRIBE\",\"timestamp\":1713506211304}', 'SUCCESS', '2024-04-19 13:56:51');
INSERT INTO `device_action` (`id`, `device_identification`, `action_type`, `message`, `status`, `create_time`) VALUES (385, '7033164773752833', 'DISCONNECT', '{\"clientId\":\"1036150750765056@1\",\"address\":\"/127.0.0.1:63570\",\"success\":\"success\",\"tenantId\":\"thinglinks\",\"event\":\"DISCONNECT\",\"timestamp\":1713506213142}', 'SUCCESS', '2024-04-19 13:56:53');
COMMIT;

-- ----------------------------
-- Table structure for device_command
-- ----------------------------
DROP TABLE IF EXISTS `device_command`;
CREATE TABLE `device_command` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `device_identification` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '设备标识',
  `command_identification` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '命令标识',
  `command_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '命令类型(0:命名下发、1:命令响应)',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态',
  `content` longtext COMMENT '内容',
  `remark` varchar(500) DEFAULT '' COMMENT '备注',
  `create_by` varchar(64) CHARACTER SET utf8 DEFAULT 'ununited' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8 DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_device_identification` (`device_identification`) USING BTREE COMMENT '设备标识'
) ENGINE=InnoDB AUTO_INCREMENT=483151483991228447 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='设备命令下发及响应表';

-- ----------------------------
-- Records of device_command
-- ----------------------------
BEGIN;
INSERT INTO `device_command` (`id`, `device_identification`, `command_identification`, `command_type`, `status`, `content`, `remark`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (483151483991228441, '4207313761001472', '1662197954674688', 0, 2, NULL, '', 'ununited', '2024-04-18 00:44:17', '', '2024-04-18 00:44:17');
INSERT INTO `device_command` (`id`, `device_identification`, `command_identification`, `command_type`, `status`, `content`, `remark`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (483151483991228442, '4324406985433088', '1662200920047616', 0, 2, NULL, '', 'ununited', '2024-04-18 00:44:18', '', '2024-04-18 00:44:18');
INSERT INTO `device_command` (`id`, `device_identification`, `command_identification`, `command_type`, `status`, `content`, `remark`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (483151483991228443, '4330045197234176', '1662203021393920', 0, 2, NULL, '', 'ununited', '2024-04-18 00:44:18', '', '2024-04-18 00:44:18');
INSERT INTO `device_command` (`id`, `device_identification`, `command_identification`, `command_type`, `status`, `content`, `remark`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (483151483991228444, '4207313761001472', '1662222269054976', 0, 2, NULL, '', 'ununited', '2024-04-18 00:44:23', '', '2024-04-18 00:44:23');
INSERT INTO `device_command` (`id`, `device_identification`, `command_identification`, `command_type`, `status`, `content`, `remark`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (483151483991228445, '4324406985433088', '1662224752082944', 0, 2, NULL, '', 'ununited', '2024-04-18 00:44:24', '', '2024-04-18 00:44:24');
INSERT INTO `device_command` (`id`, `device_identification`, `command_identification`, `command_type`, `status`, `content`, `remark`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (483151483991228446, '4330045197234176', '1662225930682368', 0, 2, NULL, '', 'ununited', '2024-04-18 00:44:24', '', '2024-04-18 00:44:24');
COMMIT;

-- ----------------------------
-- Table structure for device_datas
-- ----------------------------
DROP TABLE IF EXISTS `device_datas`;
CREATE TABLE `device_datas` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `device_identification` varchar(255) DEFAULT NULL COMMENT '设备标识',
  `protocol_type` varchar(255) NOT NULL COMMENT '协议类型 ：mqtt || coap || modbus || http',
  `message_id` varchar(255) DEFAULT NULL COMMENT '消息ID',
  `topic` varchar(255) DEFAULT NULL COMMENT 'topic',
  `message` longtext COMMENT '内容信息',
  `status` varchar(255) DEFAULT NULL COMMENT '状态',
  `report_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '上报时间',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `device_id` (`device_identification`) USING BTREE COMMENT '设备标识'
) ENGINE=InnoDB AUTO_INCREMENT=609 DEFAULT CHARSET=utf8 COMMENT='设备消息';

-- ----------------------------
-- Records of device_datas
-- ----------------------------
BEGIN;
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (36, 'mqttx_a2edea25', 'MQTT', '-1', '/v1/devices/0000000065E071E4/datas', '376230613230323032323634363537363639363336353733323233613230356230613230323032303230376230613230323032303230323032303232363436353736363936333635343936343232336132303232333133353333333236313333333133313633363533353335333433303335333233393333333636363336333436363333363436343333363636363636333833383232326330613230323032303230323032303232373336353732373636393633363537333232336132303562306132303230323032303230323032303230376230613230323032303230323032303230323032303230323237333635373237363639363336353439363432323361323032323733363537323736363936333635333132323263306132303230323032303230323032303230323032303232363436313734363132323361323037623061323032303230323032303230323032303230323032303230323237373635366536343735323233613230333133313263306132303230323032303230323032303230323032303230323032323734363936643635323233613230333733393061323032303230323032303230323032303230323037643263306132303230323032303230323032303230323032303232363537363635366537343534363936643635323233613230323233323330333233323331333033323338353433313334333133383331333235613232306132303230323032303230323032303230376430613230323032303230323032303564306132303230323032303764306132303230356430613764', 'success', '2022-12-17 20:23:29', '2022-12-17 20:23:29');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (37, 'mqttx_a2edea25', 'MQTT', '-1', '/v1/devices/0000000065E071E4/datas', '376230613230323032323634363537363639363336353733323233613230356230613230323032303230376230613230323032303230323032303232363436353736363936333635343936343232336132303232333133353333333236313333333133313633363533353335333433303335333233393333333636363336333436363333363436343333363636363636333833383232326330613230323032303230323032303232373336353732373636393633363537333232336132303562306132303230323032303230323032303230376230613230323032303230323032303230323032303230323237333635373237363639363336353439363432323361323032323733363537323736363936333635333132323263306132303230323032303230323032303230323032303232363436313734363132323361323037623061323032303230323032303230323032303230323032303230323237373635366536343735323233613230333133313263306132303230323032303230323032303230323032303230323032323734363936643635323233613230333733393061323032303230323032303230323032303230323037643263306132303230323032303230323032303230323032303232363537363635366537343534363936643635323233613230323233323330333233323331333033323338353433313334333133383331333235613232306132303230323032303230323032303230376430613230323032303230323032303564306132303230323032303764306132303230356430613764', 'success', '2022-12-17 20:23:29', '2022-12-17 20:23:29');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (38, 'mqttx_a2edea25', 'MQTT', '-1', '/v1/devices/0000000065E071E4/datas', '376230613230323032323634363537363639363336353733323233613230356230613230323032303230376230613230323032303230323032303232363436353736363936333635343936343232336132303232333133353333333236313333333133313633363533353335333433303335333233393333333636363336333436363333363436343333363636363636333833383232326330613230323032303230323032303232373336353732373636393633363537333232336132303562306132303230323032303230323032303230376230613230323032303230323032303230323032303230323237333635373237363639363336353439363432323361323032323733363537323736363936333635333132323263306132303230323032303230323032303230323032303232363436313734363132323361323037623061323032303230323032303230323032303230323032303230323237373635366536343735323233613230333133313263306132303230323032303230323032303230323032303230323032323734363936643635323233613230333733393061323032303230323032303230323032303230323037643263306132303230323032303230323032303230323032303232363537363635366537343534363936643635323233613230323233323330333233323331333033323338353433313334333133383331333235613232306132303230323032303230323032303230376430613230323032303230323032303564306132303230323032303764306132303230356430613764', 'success', '2022-12-17 20:29:50', '2022-12-17 20:29:51');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (39, 'mqttx_a2edea25', 'MQTT', '-1', '/v1/devices/0000000065E071E4/datas', '376230613230323032323634363537363639363336353733323233613230356230613230323032303230376230613230323032303230323032303232363436353736363936333635343936343232336132303232333133353333333236313333333133313633363533353335333433303335333233393333333636363336333436363333363436343333363636363636333833383232326330613230323032303230323032303232373336353732373636393633363537333232336132303562306132303230323032303230323032303230376230613230323032303230323032303230323032303230323237333635373237363639363336353439363432323361323032323733363537323736363936333635333132323263306132303230323032303230323032303230323032303232363436313734363132323361323037623061323032303230323032303230323032303230323032303230323237373635366536343735323233613230333133313263306132303230323032303230323032303230323032303230323032323734363936643635323233613230333733393061323032303230323032303230323032303230323037643263306132303230323032303230323032303230323032303232363537363635366537343534363936643635323233613230323233323330333233323331333033323338353433313334333133383331333235613232306132303230323032303230323032303230376430613230323032303230323032303564306132303230323032303764306132303230356430613764', 'success', '2022-12-17 20:29:50', '2022-12-17 20:29:51');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (40, 'mqttx_a2edea25', 'MQTT', '-1', '/v1/devices/0000000065E071E4/datas', '376230613230323032323634363537363639363336353733323233613230356230613230323032303230376230613230323032303230323032303232363436353736363936333635343936343232336132303232333133353333333236313333333133313633363533353335333433303335333233393333333636363336333436363333363436343333363636363636333833383232326330613230323032303230323032303232373336353732373636393633363537333232336132303562306132303230323032303230323032303230376230613230323032303230323032303230323032303230323237333635373237363639363336353439363432323361323032323733363537323736363936333635333132323263306132303230323032303230323032303230323032303232363436313734363132323361323037623061323032303230323032303230323032303230323032303230323237373635366536343735323233613230333133313263306132303230323032303230323032303230323032303230323032323734363936643635323233613230333733393061323032303230323032303230323032303230323037643263306132303230323032303230323032303230323032303232363537363635366537343534363936643635323233613230323233323330333233323331333033323338353433313334333133383331333235613232306132303230323032303230323032303230376430613230323032303230323032303564306132303230323032303764306132303230356430613764', 'success', '2022-12-17 20:29:50', '2022-12-17 20:29:52');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (41, 'mqttx_a2edea25', 'MQTT', '-1', '/v1/devices/0000000065E071E4/datas', '376230613230323032323634363537363639363336353733323233613230356230613230323032303230376230613230323032303230323032303232363436353736363936333635343936343232336132303232333133353333333236313333333133313633363533353335333433303335333233393333333636363336333436363333363436343333363636363636333833383232326330613230323032303230323032303232373336353732373636393633363537333232336132303562306132303230323032303230323032303230376230613230323032303230323032303230323032303230323237333635373237363639363336353439363432323361323032323733363537323736363936333635333132323263306132303230323032303230323032303230323032303232363436313734363132323361323037623061323032303230323032303230323032303230323032303230323237373635366536343735323233613230333133313263306132303230323032303230323032303230323032303230323032323734363936643635323233613230333733393061323032303230323032303230323032303230323037643263306132303230323032303230323032303230323032303232363537363635366537343534363936643635323233613230323233323330333233323331333033323338353433313334333133383331333235613232306132303230323032303230323032303230376430613230323032303230323032303564306132303230323032303764306132303230356430613764', 'success', '2022-12-17 20:29:51', '2022-12-17 20:29:52');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (42, 'mqttx_a2edea25', 'MQTT', '-1', '/v1/devices/0000000065E071E4/datas', '376230613230323032323634363537363639363336353733323233613230356230613230323032303230376230613230323032303230323032303232363436353736363936333635343936343232336132303232333133353333333236313333333133313633363533353335333433303335333233393333333636363336333436363333363436343333363636363636333833383232326330613230323032303230323032303232373336353732373636393633363537333232336132303562306132303230323032303230323032303230376230613230323032303230323032303230323032303230323237333635373237363639363336353439363432323361323032323733363537323736363936333635333132323263306132303230323032303230323032303230323032303232363436313734363132323361323037623061323032303230323032303230323032303230323032303230323237373635366536343735323233613230333133313263306132303230323032303230323032303230323032303230323032323734363936643635323233613230333733393061323032303230323032303230323032303230323037643263306132303230323032303230323032303230323032303232363537363635366537343534363936643635323233613230323233323330333233323331333033323338353433313334333133383331333235613232306132303230323032303230323032303230376430613230323032303230323032303564306132303230323032303764306132303230356430613764', 'success', '2022-12-17 20:29:51', '2022-12-17 20:29:52');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (43, 'mqttx_a2edea25', 'MQTT', '-1', '/v1/devices/0000000065E071E4/datas', '376230613230323032323634363537363639363336353733323233613230356230613230323032303230376230613230323032303230323032303232363436353736363936333635343936343232336132303232333133353333333236313333333133313633363533353335333433303335333233393333333636363336333436363333363436343333363636363636333833383232326330613230323032303230323032303232373336353732373636393633363537333232336132303562306132303230323032303230323032303230376230613230323032303230323032303230323032303230323237333635373237363639363336353439363432323361323032323733363537323736363936333635333132323263306132303230323032303230323032303230323032303232363436313734363132323361323037623061323032303230323032303230323032303230323032303230323237373635366536343735323233613230333133313263306132303230323032303230323032303230323032303230323032323734363936643635323233613230333733393061323032303230323032303230323032303230323037643263306132303230323032303230323032303230323032303232363537363635366537343534363936643635323233613230323233323330333233323331333033323338353433313334333133383331333235613232306132303230323032303230323032303230376430613230323032303230323032303564306132303230323032303764306132303230356430613764', 'success', '2022-12-17 20:29:51', '2022-12-17 20:29:52');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (44, 'mqttx_a2edea25', 'MQTT', '-1', '/v1/devices/0000000065E071E4/datas', '376230613230323032323634363537363639363336353733323233613230356230613230323032303230376230613230323032303230323032303232363436353736363936333635343936343232336132303232333133353333333236313333333133313633363533353335333433303335333233393333333636363336333436363333363436343333363636363636333833383232326330613230323032303230323032303232373336353732373636393633363537333232336132303562306132303230323032303230323032303230376230613230323032303230323032303230323032303230323237333635373237363639363336353439363432323361323032323733363537323736363936333635333132323263306132303230323032303230323032303230323032303232363436313734363132323361323037623061323032303230323032303230323032303230323032303230323237373635366536343735323233613230333133313263306132303230323032303230323032303230323032303230323032323734363936643635323233613230333733393061323032303230323032303230323032303230323037643263306132303230323032303230323032303230323032303232363537363635366537343534363936643635323233613230323233323330333233323331333033323338353433313334333133383331333235613232306132303230323032303230323032303230376430613230323032303230323032303564306132303230323032303764306132303230356430613764', 'success', '2022-12-17 20:32:08', '2022-12-17 20:32:09');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (45, 'mqttx_a2edea25', 'MQTT', '-1', '/v1/devices/0000000065E071E4/datas', '376230613230323032323634363537363639363336353733323233613230356230613230323032303230376230613230323032303230323032303232363436353736363936333635343936343232336132303232333133353333333236313333333133313633363533353335333433303335333233393333333636363336333436363333363436343333363636363636333833383232326330613230323032303230323032303232373336353732373636393633363537333232336132303562306132303230323032303230323032303230376230613230323032303230323032303230323032303230323237333635373237363639363336353439363432323361323032323733363537323736363936333635333132323263306132303230323032303230323032303230323032303232363436313734363132323361323037623061323032303230323032303230323032303230323032303230323237373635366536343735323233613230333133313263306132303230323032303230323032303230323032303230323032323734363936643635323233613230333733393061323032303230323032303230323032303230323037643263306132303230323032303230323032303230323032303232363537363635366537343534363936643635323233613230323233323330333233323331333033323338353433313334333133383331333235613232306132303230323032303230323032303230376430613230323032303230323032303564306132303230323032303764306132303230356430613764', 'success', '2022-12-17 20:32:08', '2022-12-17 20:32:09');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (46, 'mqttx_a2edea25', 'MQTT', '-1', '/v1/devices/0000000065E071E4/datas', '376230613230323032323634363537363639363336353733323233613230356230613230323032303230376230613230323032303230323032303232363436353736363936333635343936343232336132303232333133353333333236313333333133313633363533353335333433303335333233393333333636363336333436363333363436343333363636363636333833383232326330613230323032303230323032303232373336353732373636393633363537333232336132303562306132303230323032303230323032303230376230613230323032303230323032303230323032303230323237333635373237363639363336353439363432323361323032323733363537323736363936333635333132323263306132303230323032303230323032303230323032303232363436313734363132323361323037623061323032303230323032303230323032303230323032303230323237373635366536343735323233613230333133313263306132303230323032303230323032303230323032303230323032323734363936643635323233613230333733393061323032303230323032303230323032303230323037643263306132303230323032303230323032303230323032303232363537363635366537343534363936643635323233613230323233323330333233323331333033323338353433313334333133383331333235613232306132303230323032303230323032303230376430613230323032303230323032303564306132303230323032303764306132303230356430613764', 'success', '2022-12-17 20:32:08', '2022-12-17 20:32:09');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (47, 'mqttx_a2edea25', 'MQTT', '-1', '/v1/devices/0000000065E071E4/datas', '376230613230323032323634363537363639363336353733323233613230356230613230323032303230376230613230323032303230323032303232363436353736363936333635343936343232336132303232333133353333333236313333333133313633363533353335333433303335333233393333333636363336333436363333363436343333363636363636333833383232326330613230323032303230323032303232373336353732373636393633363537333232336132303562306132303230323032303230323032303230376230613230323032303230323032303230323032303230323237333635373237363639363336353439363432323361323032323733363537323736363936333635333132323263306132303230323032303230323032303230323032303232363436313734363132323361323037623061323032303230323032303230323032303230323032303230323237373635366536343735323233613230333133313263306132303230323032303230323032303230323032303230323032323734363936643635323233613230333733393061323032303230323032303230323032303230323037643263306132303230323032303230323032303230323032303232363537363635366537343534363936643635323233613230323233323330333233323331333033323338353433313334333133383331333235613232306132303230323032303230323032303230376430613230323032303230323032303564306132303230323032303764306132303230356430613764', 'success', '2022-12-17 20:32:08', '2022-12-17 20:32:09');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (48, 'mqttx_a2edea25', 'MQTT', '-1', '/v1/devices/0000000065E071E4/datas', '376230613230323032323634363537363639363336353733323233613230356230613230323032303230376230613230323032303230323032303232363436353736363936333635343936343232336132303232333133353333333236313333333133313633363533353335333433303335333233393333333636363336333436363333363436343333363636363636333833383232326330613230323032303230323032303232373336353732373636393633363537333232336132303562306132303230323032303230323032303230376230613230323032303230323032303230323032303230323237333635373237363639363336353439363432323361323032323733363537323736363936333635333132323263306132303230323032303230323032303230323032303232363436313734363132323361323037623061323032303230323032303230323032303230323032303230323237373635366536343735323233613230333133313263306132303230323032303230323032303230323032303230323032323734363936643635323233613230333733393061323032303230323032303230323032303230323037643263306132303230323032303230323032303230323032303232363537363635366537343534363936643635323233613230323233323330333233323331333033323338353433313334333133383331333235613232306132303230323032303230323032303230376430613230323032303230323032303564306132303230323032303764306132303230356430613764', 'success', '2022-12-17 20:32:08', '2022-12-17 20:32:09');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (104, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48400\"},\"eventTime\":\"2022-12-24 11:50:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:50:03', '2022-12-24 11:50:11');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (105, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48400\"},\"eventTime\":\"2022-12-24 11:50:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:50:12', '2022-12-24 11:50:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (106, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48500\"},\"eventTime\":\"2022-12-24 11:50:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:50:42', '2022-12-24 11:50:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (107, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 11:51:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:50:52', '2022-12-24 11:51:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (108, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48400\"},\"eventTime\":\"2022-12-24 11:51:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:51:22', '2022-12-24 11:51:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (109, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48400\"},\"eventTime\":\"2022-12-24 11:51:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:51:33', '2022-12-24 11:51:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (110, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.2\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 11:52:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:51:52', '2022-12-24 11:52:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (111, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.2\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 11:52:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:52:03', '2022-12-24 11:52:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (112, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 11:52:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:52:13', '2022-12-24 11:52:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (113, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.2\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 11:52:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:52:32', '2022-12-24 11:52:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (114, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.1\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 11:52:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:52:43', '2022-12-24 11:52:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (115, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.2\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 11:53:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:53:13', '2022-12-24 11:53:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (116, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.9\",\"humidity\":\"15.1\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 11:53:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:53:23', '2022-12-24 11:53:33');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (117, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.1\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 11:54:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:53:53', '2022-12-24 11:54:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (118, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.1\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 11:54:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:54:23', '2022-12-24 11:54:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (119, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.2\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 11:54:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:54:32', '2022-12-24 11:54:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (120, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.2\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 11:55:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:55:03', '2022-12-24 11:55:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (121, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 11:55:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:55:23', '2022-12-24 11:55:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (122, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.2\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 11:55:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:55:42', '2022-12-24 11:55:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (123, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.2\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 11:56:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:55:52', '2022-12-24 11:56:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (124, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.1\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 11:56:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:56:03', '2022-12-24 11:56:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (125, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.6\",\"mac\":\"284052675740\",\"Illuminance\":\"48500\"},\"eventTime\":\"2022-12-24 11:57:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:56:52', '2022-12-24 11:57:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (126, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48600\"},\"eventTime\":\"2022-12-24 11:57:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:57:02', '2022-12-24 11:57:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (127, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.1\",\"mac\":\"284052675740\",\"Illuminance\":\"48500\"},\"eventTime\":\"2022-12-24 11:57:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:57:43', '2022-12-24 11:57:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (128, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.0\",\"mac\":\"284052675740\",\"Illuminance\":\"48500\"},\"eventTime\":\"2022-12-24 11:58:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:58:23', '2022-12-24 11:58:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (129, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"mac\":\"284052675740\",\"Illuminance\":\"47700\"},\"eventTime\":\"2022-12-24 11:58:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:58:43', '2022-12-24 11:58:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (130, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.5\",\"humidity\":\"15.1\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 11:59:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:58:53', '2022-12-24 11:59:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (131, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"15.2\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 11:59:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 11:59:43', '2022-12-24 11:59:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (132, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.2\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 12:00:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:00:02', '2022-12-24 12:00:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (133, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":18,\"THdatafreshcnt\":205,\"freq\":49,\"electricity\":\"143.42\",\"mac\":\"\",\"voltage\":\"227.82\",\"current\":\"19.08\",\"temperature\":\"17.90\",\"voltameterstate\":48,\"RestartCnt\":22,\"humidity\":\"21.40\",\"power\":\"4332.23\",\"BLdatafreshcnt\":94,\"status\":1},\"eventTime\":\"20221224T120004Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 12:00:06', '2022-12-24 12:00:13');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (134, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.2\",\"humidity\":\"15.4\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 12:00:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:00:13', '2022-12-24 12:00:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (135, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.2\",\"humidity\":\"15.4\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 12:00:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:00:22', '2022-12-24 12:00:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (136, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.2\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 12:00:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:00:32', '2022-12-24 12:00:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (137, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.2\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48200\"},\"eventTime\":\"2022-12-24 12:00:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:00:42', '2022-12-24 12:00:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (138, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.2\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"47800\"},\"eventTime\":\"2022-12-24 12:01:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:01:02', '2022-12-24 12:01:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (139, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.2\",\"humidity\":\"15.4\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 12:01:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:01:12', '2022-12-24 12:01:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (140, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.2\",\"humidity\":\"15.6\",\"mac\":\"284052675740\",\"Illuminance\":\"48000\"},\"eventTime\":\"2022-12-24 12:01:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:01:32', '2022-12-24 12:01:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (141, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.2\",\"humidity\":\"15.5\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 12:02:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:02:03', '2022-12-24 12:02:16');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (142, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.3\",\"humidity\":\"15.5\",\"mac\":\"284052675740\",\"Illuminance\":\"48300\"},\"eventTime\":\"2022-12-24 12:03:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:03:03', '2022-12-24 12:03:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (143, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.4\",\"humidity\":\"15.4\",\"mac\":\"284052675740\",\"Illuminance\":\"48000\"},\"eventTime\":\"2022-12-24 12:04:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:03:52', '2022-12-24 12:04:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (144, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.3\",\"humidity\":\"15.4\",\"mac\":\"284052675740\",\"Illuminance\":\"48200\"},\"eventTime\":\"2022-12-24 12:04:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:04:02', '2022-12-24 12:04:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (145, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.4\",\"humidity\":\"15.4\",\"mac\":\"284052675740\",\"Illuminance\":\"48200\"},\"eventTime\":\"2022-12-24 12:04:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:04:32', '2022-12-24 12:04:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (146, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.4\",\"humidity\":\"15.4\",\"mac\":\"284052675740\",\"Illuminance\":\"47800\"},\"eventTime\":\"2022-12-24 12:04:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:04:43', '2022-12-24 12:04:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (147, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.4\",\"humidity\":\"15.5\",\"mac\":\"284052675740\",\"Illuminance\":\"48200\"},\"eventTime\":\"2022-12-24 12:05:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:04:52', '2022-12-24 12:05:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (148, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.4\",\"humidity\":\"15.5\",\"mac\":\"284052675740\",\"Illuminance\":\"48200\"},\"eventTime\":\"2022-12-24 12:05:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:05:02', '2022-12-24 12:05:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (149, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.4\",\"humidity\":\"15.5\",\"mac\":\"284052675740\",\"Illuminance\":\"48200\"},\"eventTime\":\"2022-12-24 12:05:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:05:13', '2022-12-24 12:05:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (150, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.4\",\"humidity\":\"15.4\",\"mac\":\"284052675740\",\"Illuminance\":\"48200\"},\"eventTime\":\"2022-12-24 12:05:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:05:22', '2022-12-24 12:05:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (151, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.4\",\"humidity\":\"15.4\",\"mac\":\"284052675740\",\"Illuminance\":\"48200\"},\"eventTime\":\"2022-12-24 12:05:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:05:32', '2022-12-24 12:05:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (152, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.5\",\"humidity\":\"15.4\",\"mac\":\"284052675740\",\"Illuminance\":\"47700\"},\"eventTime\":\"2022-12-24 12:05:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:05:42', '2022-12-24 12:05:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (153, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.5\",\"humidity\":\"15.4\",\"mac\":\"284052675740\",\"Illuminance\":\"48200\"},\"eventTime\":\"2022-12-24 12:06:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:05:52', '2022-12-24 12:06:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (154, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.5\",\"humidity\":\"15.5\",\"mac\":\"284052675740\",\"Illuminance\":\"48200\"},\"eventTime\":\"2022-12-24 12:06:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:06:12', '2022-12-24 12:06:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (155, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.5\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 12:06:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:06:23', '2022-12-24 12:06:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (156, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.5\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48200\"},\"eventTime\":\"2022-12-24 12:07:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:06:53', '2022-12-24 12:07:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (157, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.5\",\"humidity\":\"15.4\",\"mac\":\"284052675740\",\"Illuminance\":\"48200\"},\"eventTime\":\"2022-12-24 12:07:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:07:32', '2022-12-24 12:07:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (158, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.6\",\"humidity\":\"15.4\",\"mac\":\"284052675740\",\"Illuminance\":\"48200\"},\"eventTime\":\"2022-12-24 12:09:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:08:53', '2022-12-24 12:09:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (159, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.6\",\"humidity\":\"15.4\",\"mac\":\"284052675740\",\"Illuminance\":\"48200\"},\"eventTime\":\"2022-12-24 12:09:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:09:03', '2022-12-24 12:09:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (160, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.6\",\"humidity\":\"15.4\",\"mac\":\"284052675740\",\"Illuminance\":\"48200\"},\"eventTime\":\"2022-12-24 12:09:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:09:33', '2022-12-24 12:09:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (161, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.6\",\"humidity\":\"15.4\",\"mac\":\"284052675740\",\"Illuminance\":\"48200\"},\"eventTime\":\"2022-12-24 12:10:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:09:52', '2022-12-24 12:10:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (162, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":17,\"THdatafreshcnt\":505,\"freq\":49,\"electricity\":\"144.14\",\"mac\":\"\",\"voltage\":\"227.85\",\"current\":\"19.08\",\"temperature\":\"18.10\",\"voltameterstate\":48,\"RestartCnt\":22,\"humidity\":\"21.80\",\"power\":\"4331.75\",\"BLdatafreshcnt\":393,\"status\":1},\"eventTime\":\"20221224T121003Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 12:10:01', '2022-12-24 12:10:09');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (163, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.6\",\"humidity\":\"15.4\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 12:10:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:10:03', '2022-12-24 12:10:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (164, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.6\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 12:10:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:10:13', '2022-12-24 12:10:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (165, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.4\",\"mac\":\"284052675740\",\"Illuminance\":\"48000\"},\"eventTime\":\"2022-12-24 12:10:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:10:22', '2022-12-24 12:10:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (166, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 12:10:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:10:43', '2022-12-24 12:10:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (167, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48200\"},\"eventTime\":\"2022-12-24 12:11:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:11:02', '2022-12-24 12:11:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (168, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 12:11:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:11:13', '2022-12-24 12:11:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (169, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 12:11:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:11:32', '2022-12-24 12:11:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (170, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 12:11:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:11:43', '2022-12-24 12:11:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (171, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.2\",\"mac\":\"284052675740\",\"Illuminance\":\"48200\"},\"eventTime\":\"2022-12-24 12:12:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:12:42', '2022-12-24 12:12:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (172, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.2\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 12:13:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:13:03', '2022-12-24 12:13:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (173, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.2\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 12:13:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:13:12', '2022-12-24 12:13:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (174, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 12:13:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:13:33', '2022-12-24 12:13:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (175, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.2\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 12:14:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:14:03', '2022-12-24 12:14:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (176, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.2\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 12:14:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:14:12', '2022-12-24 12:14:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (177, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.2\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 12:14:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:14:22', '2022-12-24 12:14:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (178, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 12:14:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:14:33', '2022-12-24 12:14:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (179, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.2\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 12:15:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:14:52', '2022-12-24 12:15:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (180, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":17,\"THdatafreshcnt\":655,\"freq\":49,\"electricity\":\"144.50\",\"mac\":\"\",\"voltage\":\"228.26\",\"current\":\"18.98\",\"temperature\":\"18.20\",\"voltameterstate\":0,\"RestartCnt\":22,\"humidity\":\"21.70\",\"power\":\"4317.49\",\"BLdatafreshcnt\":543,\"status\":1},\"eventTime\":\"20221224T121503Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 12:15:07', '2022-12-24 12:15:14');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (181, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.1\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 12:15:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:15:22', '2022-12-24 12:15:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (182, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.1\",\"mac\":\"284052675740\",\"Illuminance\":\"48000\"},\"eventTime\":\"2022-12-24 12:15:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:15:43', '2022-12-24 12:15:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (183, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.1\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 12:16:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:15:52', '2022-12-24 12:16:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (184, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.2\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 12:16:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:16:02', '2022-12-24 12:16:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (185, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.1\",\"mac\":\"284052675740\",\"Illuminance\":\"48000\"},\"eventTime\":\"2022-12-24 12:17:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:16:53', '2022-12-24 12:17:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (186, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.0\",\"mac\":\"284052675740\",\"Illuminance\":\"48000\"},\"eventTime\":\"2022-12-24 12:17:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:17:42', '2022-12-24 12:17:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (187, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.0\",\"mac\":\"284052675740\",\"Illuminance\":\"47800\"},\"eventTime\":\"2022-12-24 12:18:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:18:12', '2022-12-24 12:18:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (188, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.1\",\"mac\":\"284052675740\",\"Illuminance\":\"48000\"},\"eventTime\":\"2022-12-24 12:18:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:18:33', '2022-12-24 12:18:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (189, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.3\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 12:18:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:18:42', '2022-12-24 12:18:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (190, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.2\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 12:19:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:19:03', '2022-12-24 12:19:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (191, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.1\",\"mac\":\"284052675740\",\"Illuminance\":\"48100\"},\"eventTime\":\"2022-12-24 12:19:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:19:12', '2022-12-24 12:19:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (192, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.1\",\"mac\":\"284052675740\",\"Illuminance\":\"47700\"},\"eventTime\":\"2022-12-24 12:19:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:19:22', '2022-12-24 12:19:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (193, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.1\",\"mac\":\"284052675740\",\"Illuminance\":\"47700\"},\"eventTime\":\"2022-12-24 12:19:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:19:33', '2022-12-24 12:19:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (194, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.1\",\"mac\":\"284052675740\",\"Illuminance\":\"47800\"},\"eventTime\":\"2022-12-24 12:19:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:19:43', '2022-12-24 12:19:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (195, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.1\",\"mac\":\"284052675740\",\"Illuminance\":\"48000\"},\"eventTime\":\"2022-12-24 12:20:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:19:52', '2022-12-24 12:20:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (196, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.0\",\"mac\":\"284052675740\",\"Illuminance\":\"48000\"},\"eventTime\":\"2022-12-24 12:20:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:20:03', '2022-12-24 12:20:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (197, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":17,\"THdatafreshcnt\":805,\"freq\":49,\"electricity\":\"144.86\",\"mac\":\"\",\"voltage\":\"228.55\",\"current\":\"18.97\",\"temperature\":\"18.20\",\"voltameterstate\":0,\"RestartCnt\":22,\"humidity\":\"21.60\",\"power\":\"4319.29\",\"BLdatafreshcnt\":693,\"status\":1},\"eventTime\":\"20221224T122003Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 12:20:04', '2022-12-24 12:20:12');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (198, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.7\",\"mac\":\"284052675740\",\"Illuminance\":\"48000\"},\"eventTime\":\"2022-12-24 12:20:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:20:13', '2022-12-24 12:20:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (199, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.2\",\"mac\":\"284052675740\",\"Illuminance\":\"47900\"},\"eventTime\":\"2022-12-24 12:20:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:20:33', '2022-12-24 12:20:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (200, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.2\",\"mac\":\"284052675740\",\"Illuminance\":\"47900\"},\"eventTime\":\"2022-12-24 12:21:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:20:53', '2022-12-24 12:21:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (201, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.2\",\"mac\":\"284052675740\",\"Illuminance\":\"47900\"},\"eventTime\":\"2022-12-24 12:21:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:21:02', '2022-12-24 12:21:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (202, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.0\",\"mac\":\"284052675740\",\"Illuminance\":\"48000\"},\"eventTime\":\"2022-12-24 12:23:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:22:53', '2022-12-24 12:23:01');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (203, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"14.9\",\"mac\":\"284052675740\",\"Illuminance\":\"47900\"},\"eventTime\":\"2022-12-24 12:23:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:23:12', '2022-12-24 12:23:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (204, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"14.9\",\"mac\":\"284052675740\",\"Illuminance\":\"48000\"},\"eventTime\":\"2022-12-24 12:23:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:23:42', '2022-12-24 12:23:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (205, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"15.0\",\"mac\":\"284052675740\",\"Illuminance\":\"48000\"},\"eventTime\":\"2022-12-24 12:24:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:23:53', '2022-12-24 12:24:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (206, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"14.9\",\"mac\":\"284052675740\",\"Illuminance\":\"48000\"},\"eventTime\":\"2022-12-24 12:24:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:24:03', '2022-12-24 12:24:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (207, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"14.9\",\"mac\":\"284052675740\",\"Illuminance\":\"47900\"},\"eventTime\":\"2022-12-24 12:24:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:24:13', '2022-12-24 12:24:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (208, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.7\",\"humidity\":\"14.9\",\"mac\":\"284052675740\",\"Illuminance\":\"48000\"},\"eventTime\":\"2022-12-24 12:24:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:24:22', '2022-12-24 12:24:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (209, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.8\",\"humidity\":\"15.0\",\"mac\":\"284052675740\",\"Illuminance\":\"48000\"},\"eventTime\":\"2022-12-24 12:24:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:24:43', '2022-12-24 12:24:52');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (210, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":21,\"THdatafreshcnt\":221,\"freq\":49,\"electricity\":\"143.39\",\"mac\":\"898604872120F1101593\",\"voltage\":\"228.66\",\"current\":\"18.54\",\"temperature\":\"18.20\",\"voltameterstate\":0,\"RestartCnt\":23,\"humidity\":\"21.20\",\"power\":\"4222.82\",\"BLdatafreshcnt\":110,\"status\":1},\"eventTime\":\"20221224T123001Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 12:29:58', '2022-12-24 12:30:06');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (211, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/commandResponse', '{\"errcode\":0,\"msgType\":\"deviceRsp\",\"mid\":706,\"body\":{\"orginParameters\":{\"command\":\"06fe03840071014f0072014f0072006f0077006a0072006e0071006e0071014f0078014b007201500072014f0072014f0072014f007201500072006e0072006e0073014f0072006f0071006f0071006f0072006f0072006f0072014f007201500072014f0073006f0071006f0072006f0071006f0072006f0072006f0072006e0072006f0071006f0071006f0071006e0071006e0071006e007201500072006f007201500072006f0071006f0071006f0071006f0071006e0072006f0072006f007200700071006f0070006f0071006f0071006f0071006f0071006f0071006f00720150007200700070006f0071006f0071006f007100700071006f0071006f0072006f0071006f007000700071006f0071006f0071006f00710070007100700072006f007000700071006f0070006f0071006f00720150007201500072006f00710070007100700070006f0071006f0071006f0071007000710070007100700072006f0070015000710070007001500071006f0071006f0072006f007101500071006f0070015000710150007101500072006f007101500071007000710150007201500070\",\"status\":1}}}', 'success', '2022-12-24 12:33:17', '2022-12-24 12:33:26');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (212, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:33:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:33:22', '2022-12-24 12:33:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (213, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:33:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:33:32', '2022-12-24 12:33:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (214, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:34:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:34:12', '2022-12-24 12:34:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (215, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:34:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:34:22', '2022-12-24 12:34:29');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (216, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":372,\"freq\":49,\"electricity\":\"143.75\",\"mac\":\"898604872120F1101593\",\"voltage\":\"228.43\",\"current\":\"18.80\",\"temperature\":\"18.20\",\"voltameterstate\":48,\"RestartCnt\":23,\"humidity\":\"21.30\",\"power\":\"4277.50\",\"BLdatafreshcnt\":261,\"status\":1},\"eventTime\":\"20221224T123502Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 12:35:02', '2022-12-24 12:35:09');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (217, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:35:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:35:02', '2022-12-24 12:35:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (218, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:35:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:35:12', '2022-12-24 12:35:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (219, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:36:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:35:52', '2022-12-24 12:36:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (220, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:36:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:36:02', '2022-12-24 12:36:09');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (221, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:36:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:36:32', '2022-12-24 12:36:39');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (222, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:36:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:36:42', '2022-12-24 12:36:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (223, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:37:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:36:52', '2022-12-24 12:37:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (224, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:37:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:37:02', '2022-12-24 12:37:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (225, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:37:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:37:12', '2022-12-24 12:37:19');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (226, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:37:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:37:32', '2022-12-24 12:37:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (227, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:37:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:37:42', '2022-12-24 12:37:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (228, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:38:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:37:52', '2022-12-24 12:38:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (229, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:38:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:38:32', '2022-12-24 12:38:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (230, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:38:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:38:42', '2022-12-24 12:38:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (231, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:39:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:39:42', '2022-12-24 12:39:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (232, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:40:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:39:52', '2022-12-24 12:39:59');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (233, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:40:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:40:22', '2022-12-24 12:40:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (234, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:41:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:41:02', '2022-12-24 12:41:09');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (235, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:41:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:41:12', '2022-12-24 12:41:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (236, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:41:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:41:22', '2022-12-24 12:41:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (237, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:41:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:41:32', '2022-12-24 12:41:39');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (238, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:41:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:41:42', '2022-12-24 12:41:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (239, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:42:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:42:12', '2022-12-24 12:42:19');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (240, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:42:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:42:22', '2022-12-24 12:42:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (241, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:42:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:42:42', '2022-12-24 12:42:49');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (242, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:43:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:42:52', '2022-12-24 12:43:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (243, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:43:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:43:02', '2022-12-24 12:43:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (244, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:43:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:43:12', '2022-12-24 12:43:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (245, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:43:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:43:22', '2022-12-24 12:43:29');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (246, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"0.0\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 12:44:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 12:44:12', '2022-12-24 12:44:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (247, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":822,\"freq\":49,\"electricity\":\"144.83\",\"mac\":\"898604872120F1101593\",\"voltage\":\"228.73\",\"current\":\"18.92\",\"temperature\":\"18.20\",\"voltameterstate\":48,\"RestartCnt\":23,\"humidity\":\"21.30\",\"power\":\"4312.23\",\"BLdatafreshcnt\":711,\"status\":1},\"eventTime\":\"20221224T125003Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 12:50:01', '2022-12-24 12:50:09');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (248, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":21,\"THdatafreshcnt\":971,\"freq\":49,\"electricity\":\"145.19\",\"mac\":\"898604872120F1101593\",\"voltage\":\"228.66\",\"current\":\"18.93\",\"temperature\":\"18.20\",\"voltameterstate\":48,\"RestartCnt\":23,\"humidity\":\"21.20\",\"power\":\"4313.93\",\"BLdatafreshcnt\":860,\"status\":1},\"eventTime\":\"20221224T125502Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 12:54:59', '2022-12-24 12:55:07');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (249, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":21,\"THdatafreshcnt\":1122,\"freq\":49,\"electricity\":\"145.55\",\"mac\":\"898604872120F1101593\",\"voltage\":\"228.45\",\"current\":\"18.90\",\"temperature\":\"18.10\",\"voltameterstate\":48,\"RestartCnt\":23,\"humidity\":\"21.30\",\"power\":\"4302.06\",\"BLdatafreshcnt\":1010,\"status\":1},\"eventTime\":\"20221224T130004Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 12:59:59', '2022-12-24 13:00:07');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (250, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":21,\"THdatafreshcnt\":1422,\"freq\":49,\"electricity\":\"146.34\",\"mac\":\"898604872120F1101593\",\"voltage\":\"227.06\",\"current\":\"23.50\",\"temperature\":\"18.10\",\"voltameterstate\":48,\"RestartCnt\":23,\"humidity\":\"21.00\",\"power\":\"5323.15\",\"BLdatafreshcnt\":1310,\"status\":1},\"eventTime\":\"20221224T131003Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 13:09:59', '2022-12-24 13:10:07');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (251, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":21,\"THdatafreshcnt\":1871,\"freq\":49,\"electricity\":\"147.70\",\"mac\":\"898604872120F1101593\",\"voltage\":\"226.86\",\"current\":\"23.99\",\"temperature\":\"18.60\",\"voltameterstate\":48,\"RestartCnt\":23,\"humidity\":\"20.60\",\"power\":\"5432.34\",\"BLdatafreshcnt\":1760,\"status\":1},\"eventTime\":\"20221224T132502Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 13:24:59', '2022-12-24 13:25:06');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (252, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":370,\"freq\":49,\"electricity\":\"148.46\",\"mac\":\"\",\"voltage\":\"228.52\",\"current\":\"19.22\",\"temperature\":\"18.60\",\"voltameterstate\":0,\"RestartCnt\":23,\"humidity\":\"20.50\",\"power\":\"4377.79\",\"BLdatafreshcnt\":259,\"status\":1},\"eventTime\":\"20221224T133503Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 13:34:59', '2022-12-24 13:35:07');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (253, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":520,\"freq\":49,\"electricity\":\"148.83\",\"mac\":\"\",\"voltage\":\"228.46\",\"current\":\"19.12\",\"temperature\":\"18.60\",\"voltameterstate\":0,\"RestartCnt\":23,\"humidity\":\"20.50\",\"power\":\"4353.12\",\"BLdatafreshcnt\":409,\"status\":1},\"eventTime\":\"20221224T134003Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 13:40:00', '2022-12-24 13:40:08');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (254, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":821,\"freq\":49,\"electricity\":\"149.55\",\"mac\":\"\",\"voltage\":\"228.47\",\"current\":\"19.11\",\"temperature\":\"18.60\",\"voltameterstate\":48,\"RestartCnt\":23,\"humidity\":\"20.50\",\"power\":\"4349.86\",\"BLdatafreshcnt\":709,\"status\":1},\"eventTime\":\"20221224T135004Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 13:50:00', '2022-12-24 13:50:08');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (255, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.6\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 13:53:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:53:12', '2022-12-24 13:53:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (256, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.7\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 13:53:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:53:23', '2022-12-24 13:53:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (257, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.7\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 13:54:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:53:53', '2022-12-24 13:54:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (258, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.7\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 13:54:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:54:03', '2022-12-24 13:54:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (259, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.6\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 13:54:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:54:33', '2022-12-24 13:54:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (260, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.6\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 13:54:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:54:43', '2022-12-24 13:54:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (261, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.6\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 13:55:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:55:03', '2022-12-24 13:55:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (262, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.6\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 13:55:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:55:33', '2022-12-24 13:55:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (263, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.7\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 13:55:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:55:43', '2022-12-24 13:55:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (264, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.7\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 13:56:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:55:53', '2022-12-24 13:56:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (265, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.6\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 13:56:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:56:13', '2022-12-24 13:56:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (266, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.7\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 13:56:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:56:23', '2022-12-24 13:56:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (267, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.6\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 13:57:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:57:03', '2022-12-24 13:57:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (268, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.6\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 13:57:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:57:23', '2022-12-24 13:57:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (269, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.6\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 13:57:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:57:33', '2022-12-24 13:57:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (270, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.7\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 13:58:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:58:12', '2022-12-24 13:58:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (271, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.6\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 13:58:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:58:33', '2022-12-24 13:58:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (272, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.7\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 13:58:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:58:43', '2022-12-24 13:58:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (273, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.7\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 13:59:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:58:53', '2022-12-24 13:59:02');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (274, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.6\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 13:59:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:59:03', '2022-12-24 13:59:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (275, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.7\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 13:59:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:59:22', '2022-12-24 13:59:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (276, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.7\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 14:00:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 13:59:52', '2022-12-24 14:00:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (277, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":1120,\"freq\":49,\"electricity\":\"150.28\",\"mac\":\"\",\"voltage\":\"228.58\",\"current\":\"19.15\",\"temperature\":\"18.70\",\"voltameterstate\":32,\"RestartCnt\":23,\"humidity\":\"20.50\",\"power\":\"4361.49\",\"BLdatafreshcnt\":1009,\"status\":1},\"eventTime\":\"20221224T140003Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 13:59:59', '2022-12-24 14:00:06');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (278, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.7\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 14:00:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:00:03', '2022-12-24 14:00:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (279, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.6\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 14:01:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:01:13', '2022-12-24 14:01:21');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (280, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.6\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 14:01:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:01:23', '2022-12-24 14:01:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (281, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.7\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 14:01:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:01:33', '2022-12-24 14:01:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (282, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.6\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 14:01:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:01:43', '2022-12-24 14:01:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (283, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.6\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 14:02:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:01:53', '2022-12-24 14:02:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (284, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.7\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 14:02:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:02:23', '2022-12-24 14:02:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (285, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.8\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 14:02:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:02:42', '2022-12-24 14:02:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (286, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.8\",\"mac\":\"284052675740\",\"Illuminance\":\"30900\"},\"eventTime\":\"2022-12-24 14:03:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:02:53', '2022-12-24 14:03:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (287, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.7\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:03:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:03:13', '2022-12-24 14:03:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (288, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.7\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:04:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:03:53', '2022-12-24 14:04:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (289, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.7\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:04:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:04:03', '2022-12-24 14:04:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (290, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.7\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:04:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:04:22', '2022-12-24 14:04:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (291, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.7\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:04:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:04:43', '2022-12-24 14:04:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (292, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.7\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:05:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:04:53', '2022-12-24 14:05:01');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (293, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":1270,\"freq\":49,\"electricity\":\"150.64\",\"mac\":\"\",\"voltage\":\"228.17\",\"current\":\"19.06\",\"temperature\":\"18.60\",\"voltameterstate\":176,\"RestartCnt\":23,\"humidity\":\"20.50\",\"power\":\"4335.33\",\"BLdatafreshcnt\":1159,\"status\":1},\"eventTime\":\"20221224T140503Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 14:04:58', '2022-12-24 14:05:05');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (294, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":1570,\"freq\":49,\"electricity\":\"151.37\",\"mac\":\"\",\"voltage\":\"228.13\",\"current\":\"19.08\",\"temperature\":\"18.70\",\"voltameterstate\":48,\"RestartCnt\":23,\"humidity\":\"20.50\",\"power\":\"4339.45\",\"BLdatafreshcnt\":1459,\"status\":1},\"eventTime\":\"20221224T141503Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 14:14:59', '2022-12-24 14:15:07');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (295, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"0.0\",\"humidity\":\"14.8\",\"mac\":\"284052675740\",\"Illuminance\":\"0\"},\"eventTime\":\"2022-12-24 14:15:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:15:23', '2022-12-24 14:15:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (296, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.8\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:16:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:15:52', '2022-12-24 14:16:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (297, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.8\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:16:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:16:22', '2022-12-24 14:16:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (298, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.8\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:16:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:16:42', '2022-12-24 14:16:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (299, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.8\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:17:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:16:52', '2022-12-24 14:17:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (300, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.8\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:17:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:17:12', '2022-12-24 14:17:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (301, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.8\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:17:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:17:22', '2022-12-24 14:17:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (302, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.9\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:17:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:17:32', '2022-12-24 14:17:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (303, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.8\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:17:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:17:42', '2022-12-24 14:17:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (304, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.8\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:18:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:17:52', '2022-12-24 14:18:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (305, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.8\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:18:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:18:13', '2022-12-24 14:18:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (306, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.8\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:18:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:18:22', '2022-12-24 14:18:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (307, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.9\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:18:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:18:43', '2022-12-24 14:18:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (308, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.8\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:19:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:19:12', '2022-12-24 14:19:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (309, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.9\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:20:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:20:02', '2022-12-24 14:20:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (310, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.8\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:20:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:20:42', '2022-12-24 14:20:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (311, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.2\",\"humidity\":\"14.9\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:21:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:21:02', '2022-12-24 14:21:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (312, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.8\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:21:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:21:12', '2022-12-24 14:21:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (313, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.2\",\"humidity\":\"14.8\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:21:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:21:42', '2022-12-24 14:21:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (314, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.9\",\"mac\":\"284052675740\",\"Illuminance\":\"31100\"},\"eventTime\":\"2022-12-24 14:22:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:21:52', '2022-12-24 14:22:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (315, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.9\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:22:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:22:03', '2022-12-24 14:22:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (316, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.9\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:22:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:22:22', '2022-12-24 14:22:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (317, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.9\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:22:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:22:32', '2022-12-24 14:22:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (318, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.9\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:22:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:22:42', '2022-12-24 14:22:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (319, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"temperature\":\"18.1\",\"humidity\":\"14.9\",\"mac\":\"284052675740\",\"Illuminance\":\"31000\"},\"eventTime\":\"2022-12-24 14:23:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:23:02', '2022-12-24 14:23:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (320, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.8\",\"temperature2\":\"18.8\",\"temperature\":\"18.1\",\"humidity\":\"15\",\"CO2Concentration\":\"411.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:24:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:24:02', '2022-12-24 14:24:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (321, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.8\",\"temperature2\":\"18.8\",\"temperature\":\"18.1\",\"humidity\":\"15\",\"CO2Concentration\":\"411.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:24:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:24:22', '2022-12-24 14:24:29');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (322, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.8\",\"temperature2\":\"18.8\",\"temperature\":\"18.1\",\"humidity\":\"15\",\"CO2Concentration\":\"411.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:24:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:24:42', '2022-12-24 14:24:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (323, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.8\",\"temperature\":\"18.1\",\"humidity\":\"15\",\"CO2Concentration\":\"411.0\",\"Illuminance\":\"30900.0\"},\"eventTime\":\"2022-12-24 14:25:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:24:52', '2022-12-24 14:25:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (324, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.7\",\"temperature\":\"18.1\",\"humidity\":\"15\",\"CO2Concentration\":\"411.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:25:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:25:02', '2022-12-24 14:25:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (325, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.8\",\"temperature\":\"18.1\",\"humidity\":\"15\",\"CO2Concentration\":\"411.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:25:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:25:12', '2022-12-24 14:25:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (326, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.8\",\"temperature\":\"18.1\",\"humidity\":\"15\",\"CO2Concentration\":\"411.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:25:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:25:32', '2022-12-24 14:25:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (327, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.8\",\"temperature\":\"18.1\",\"humidity\":\"15\",\"CO2Concentration\":\"411.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:25:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:25:42', '2022-12-24 14:25:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (328, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.8\",\"temperature\":\"18.1\",\"humidity\":\"15\",\"CO2Concentration\":\"411.0\",\"Illuminance\":\"30900.0\"},\"eventTime\":\"2022-12-24 14:26:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:25:52', '2022-12-24 14:26:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (329, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.8\",\"temperature\":\"18.2\",\"humidity\":\"15\",\"CO2Concentration\":\"411.0\",\"Illuminance\":\"30800.0\"},\"eventTime\":\"2022-12-24 14:26:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:26:02', '2022-12-24 14:26:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (330, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.8\",\"temperature\":\"18.1\",\"humidity\":\"15\",\"CO2Concentration\":\"412.0\",\"Illuminance\":\"30800.0\"},\"eventTime\":\"2022-12-24 14:27:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:27:12', '2022-12-24 14:27:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (331, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.8\",\"temperature\":\"18.1\",\"humidity\":\"15\",\"CO2Concentration\":\"412.0\",\"Illuminance\":\"30900.0\"},\"eventTime\":\"2022-12-24 14:27:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:27:22', '2022-12-24 14:27:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (332, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.8\",\"temperature\":\"18.2\",\"humidity\":\"15\",\"CO2Concentration\":\"412.0\",\"Illuminance\":\"31100.0\"},\"eventTime\":\"2022-12-24 14:28:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:28:02', '2022-12-24 14:28:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (333, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.8\",\"temperature\":\"18.2\",\"humidity\":\"15\",\"CO2Concentration\":\"412.0\",\"Illuminance\":\"31100.0\"},\"eventTime\":\"2022-12-24 14:28:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:28:12', '2022-12-24 14:28:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (334, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.8\",\"temperature\":\"18.2\",\"humidity\":\"15\",\"CO2Concentration\":\"413.0\",\"Illuminance\":\"31100.0\"},\"eventTime\":\"2022-12-24 14:28:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:28:32', '2022-12-24 14:28:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (335, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.8\",\"temperature\":\"18.2\",\"humidity\":\"15\",\"CO2Concentration\":\"413.0\",\"Illuminance\":\"31100.0\"},\"eventTime\":\"2022-12-24 14:28:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:28:42', '2022-12-24 14:28:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (336, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.8\",\"temperature\":\"18.2\",\"humidity\":\"15\",\"CO2Concentration\":\"413.0\",\"Illuminance\":\"31100.0\"},\"eventTime\":\"2022-12-24 14:29:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:29:02', '2022-12-24 14:29:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (337, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.8\",\"temperature\":\"18.2\",\"humidity\":\"15\",\"CO2Concentration\":\"413.0\",\"Illuminance\":\"31100.0\"},\"eventTime\":\"2022-12-24 14:29:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:29:22', '2022-12-24 14:29:29');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (338, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.8\",\"temperature\":\"18.2\",\"humidity\":\"15\",\"CO2Concentration\":\"413.0\",\"Illuminance\":\"30900.0\"},\"eventTime\":\"2022-12-24 14:29:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:29:32', '2022-12-24 14:29:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (339, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.8\",\"temperature\":\"18.2\",\"humidity\":\"15\",\"CO2Concentration\":\"413.0\",\"Illuminance\":\"30900.0\"},\"eventTime\":\"2022-12-24 14:29:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:29:42', '2022-12-24 14:29:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (340, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"temperature\":\"18.2\",\"humidity\":\"15\",\"CO2Concentration\":\"413.0\",\"Illuminance\":\"30900.0\"},\"eventTime\":\"2022-12-24 14:30:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:29:52', '2022-12-24 14:30:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (341, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"temperature\":\"18.2\",\"humidity\":\"15\",\"CO2Concentration\":\"414.0\",\"Illuminance\":\"30900.0\"},\"eventTime\":\"2022-12-24 14:30:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:30:12', '2022-12-24 14:30:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (342, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.8\",\"temperature\":\"18.2\",\"humidity\":\"15\",\"CO2Concentration\":\"414.0\",\"Illuminance\":\"30800.0\"},\"eventTime\":\"2022-12-24 14:30:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:30:22', '2022-12-24 14:30:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (343, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"temperature\":\"18.2\",\"humidity\":\"15\",\"CO2Concentration\":\"414.0\",\"Illuminance\":\"30900.0\"},\"eventTime\":\"2022-12-24 14:30:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:30:42', '2022-12-24 14:30:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (344, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.9\",\"temperature\":\"18.2\",\"humidity\":\"15\",\"CO2Concentration\":\"414.0\",\"Illuminance\":\"30900.0\"},\"eventTime\":\"2022-12-24 14:31:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:31:02', '2022-12-24 14:31:09');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (345, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.8\",\"temperature\":\"18.2\",\"humidity\":\"15\",\"CO2Concentration\":\"415.0\",\"Illuminance\":\"30900.0\"},\"eventTime\":\"2022-12-24 14:32:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:32:42', '2022-12-24 14:32:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (346, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"415.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:33:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:33:12', '2022-12-24 14:33:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (347, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.8\",\"temperature\":\"18.2\",\"humidity\":\"15\",\"CO2Concentration\":\"415.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:33:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:33:22', '2022-12-24 14:33:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (348, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"415.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:33:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:33:32', '2022-12-24 14:33:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (349, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"415.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:33:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:33:42', '2022-12-24 14:33:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (350, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"415.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:34:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:33:52', '2022-12-24 14:33:59');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (351, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"415.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:34:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:34:02', '2022-12-24 14:34:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (352, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"415.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:34:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:34:12', '2022-12-24 14:34:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (353, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"415.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:34:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:34:22', '2022-12-24 14:34:29');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (354, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"415.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:34:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:34:42', '2022-12-24 14:34:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (355, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":369,\"freq\":49,\"electricity\":\"152.82\",\"mac\":\"\",\"voltage\":\"228.29\",\"current\":\"19.12\",\"temperature\":\"18.70\",\"voltameterstate\":16,\"RestartCnt\":23,\"humidity\":\"20.90\",\"power\":\"4350.17\",\"BLdatafreshcnt\":258,\"status\":1},\"eventTime\":\"20221224T143504Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 14:35:00', '2022-12-24 14:35:07');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (356, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"416.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:36:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:35:52', '2022-12-24 14:36:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (357, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"416.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:36:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:36:42', '2022-12-24 14:36:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (358, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"416.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:37:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:36:52', '2022-12-24 14:37:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (359, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"416.0\",\"Illuminance\":\"31100.0\"},\"eventTime\":\"2022-12-24 14:37:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:37:02', '2022-12-24 14:37:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (360, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"416.0\",\"Illuminance\":\"31100.0\"},\"eventTime\":\"2022-12-24 14:37:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:37:12', '2022-12-24 14:37:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (361, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"416.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:37:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:37:22', '2022-12-24 14:37:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (362, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"416.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:37:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:37:32', '2022-12-24 14:37:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (363, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"417.0\",\"Illuminance\":\"31100.0\"},\"eventTime\":\"2022-12-24 14:38:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:38:02', '2022-12-24 14:38:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (364, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"417.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:38:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:38:12', '2022-12-24 14:38:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (365, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"417.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:38:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:38:22', '2022-12-24 14:38:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (366, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"417.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:39:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:38:52', '2022-12-24 14:38:59');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (367, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"417.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:39:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:39:02', '2022-12-24 14:39:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (368, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"417.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:39:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:39:22', '2022-12-24 14:39:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (369, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"417.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:39:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:39:32', '2022-12-24 14:39:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (370, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.9\",\"temperature\":\"18.3\",\"humidity\":\"15\",\"CO2Concentration\":\"417.0\",\"Illuminance\":\"31000.0\"},\"eventTime\":\"2022-12-24 14:39:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:39:42', '2022-12-24 14:39:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (371, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.3\",\"humidity\":\"14.9\",\"CO2Concentration\":\"418.0\",\"Illuminance\":\"30300.0\"},\"eventTime\":\"2022-12-24 14:41:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:41:13', '2022-12-24 14:41:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (372, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"19.0\",\"infra-red\":\"0\",\"temperature\":\"18.3\",\"humidity\":\"15.1\",\"CO2Concentration\":\"418.0\",\"Illuminance\":\"30900.0\"},\"eventTime\":\"2022-12-24 14:42:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:41:53', '2022-12-24 14:42:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (373, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"19.0\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"15.0\",\"CO2Concentration\":\"418.0\",\"Illuminance\":\"30900.0\"},\"eventTime\":\"2022-12-24 14:42:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:42:02', '2022-12-24 14:42:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (374, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"19.0\",\"infra-red\":\"0\",\"temperature\":\"18.3\",\"humidity\":\"14.9\",\"CO2Concentration\":\"418.0\",\"Illuminance\":\"30900.0\"},\"eventTime\":\"2022-12-24 14:42:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:42:13', '2022-12-24 14:42:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (375, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"19.0\",\"infra-red\":\"1\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"418.5\",\"Illuminance\":\"30900.0\"},\"eventTime\":\"2022-12-24 14:42:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:42:42', '2022-12-24 14:42:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (376, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"infra-red\":\"1\",\"temperature\":\"18.4\",\"humidity\":\"15.1\",\"CO2Concentration\":\"418.5\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 14:43:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:42:53', '2022-12-24 14:43:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (377, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.9\",\"infra-red\":\"1\",\"temperature\":\"18.3\",\"humidity\":\"15.1\",\"CO2Concentration\":\"418.5\",\"Illuminance\":\"24400.0\"},\"eventTime\":\"2022-12-24 14:43:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:43:03', '2022-12-24 14:43:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (378, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"19.0\",\"infra-red\":\"0\",\"temperature\":\"18.3\",\"humidity\":\"14.9\",\"CO2Concentration\":\"418.0\",\"Illuminance\":\"24500.0\"},\"eventTime\":\"2022-12-24 14:43:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:43:12', '2022-12-24 14:43:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (379, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"14.9\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.3\",\"humidity\":\"14.9\",\"CO2Concentration\":\"418.0\",\"Illuminance\":\"24700.0\"},\"eventTime\":\"2022-12-24 14:43:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:43:33', '2022-12-24 14:43:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (380, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"59.4\",\"temperature2\":\"19.3\",\"infra-red\":\"1\",\"temperature\":\"18.3\",\"humidity\":\"15.0\",\"CO2Concentration\":\"516.9\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:44:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:44:13', '2022-12-24 14:44:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (381, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"50.6\",\"temperature2\":\"19.4\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"15.0\",\"CO2Concentration\":\"1905.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:44:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:44:22', '2022-12-24 14:44:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (382, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.4\",\"temperature2\":\"19.5\",\"infra-red\":\"-0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"4116.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:45:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:45:13', '2022-12-24 14:45:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (383, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.3\",\"temperature2\":\"19.5\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"4096.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:45:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:45:22', '2022-12-24 14:45:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (384, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"19.4\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"4096.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:45:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:45:33', '2022-12-24 14:45:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (385, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"19.4\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"4000.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:45:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:45:43', '2022-12-24 14:45:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (386, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"19.3\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"3936.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:46:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:45:53', '2022-12-24 14:46:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (387, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"19.2\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.8\",\"CO2Concentration\":\"3408.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:46:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:46:32', '2022-12-24 14:46:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (388, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"19.1\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"3344.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:46:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:46:43', '2022-12-24 14:46:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (389, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"19.1\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"2912.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:47:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:47:23', '2022-12-24 14:47:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (390, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"0.0\",\"temperature2\":\"0.0\",\"infra-red\":\"0\",\"temperature\":\"0.0\",\"humidity\":\"14.9\",\"CO2Concentration\":\"0.0\",\"Illuminance\":\"0.0\"},\"eventTime\":\"2022-12-24 14:48:18\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:48:11', '2022-12-24 14:48:18');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (391, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"0.0\",\"temperature2\":\"0.0\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"0.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:48:21\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:48:13', '2022-12-24 14:48:21');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (392, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"19.0\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.8\",\"CO2Concentration\":\"2416.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:48:33\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:48:25', '2022-12-24 14:48:33');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (393, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"19.0\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.8\",\"CO2Concentration\":\"2416.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:48:36\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:48:28', '2022-12-24 14:48:36');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (394, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"19.0\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.8\",\"CO2Concentration\":\"2368.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:48:39\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:48:31', '2022-12-24 14:48:39');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (395, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"19.0\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"2368.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:48:42\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:48:34', '2022-12-24 14:48:42');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (396, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"2320.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:48:48\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:48:40', '2022-12-24 14:48:48');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (397, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"2256.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:48:54\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:48:46', '2022-12-24 14:48:54');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (398, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"2256.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:48:57\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:48:50', '2022-12-24 14:48:57');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (399, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"2224.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:49:06\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:48:58', '2022-12-24 14:49:06');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (400, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"2176.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:49:09\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:49:01', '2022-12-24 14:49:09');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (401, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"2176.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:49:12\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:49:04', '2022-12-24 14:49:12');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (402, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"2096.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 14:49:27\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:49:19', '2022-12-24 14:49:27');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (403, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"2048.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:49:33\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:49:25', '2022-12-24 14:49:33');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (404, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"2016.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:49:42\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:49:34', '2022-12-24 14:49:42');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (405, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1976.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:49:45\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:49:37', '2022-12-24 14:49:45');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (406, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.9\",\"infra-red\":\"5555555555\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1907.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:49:57\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:49:49', '2022-12-24 14:49:57');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (407, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1904.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 14:50:03\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:49:55', '2022-12-24 14:50:03');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (408, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1864.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 14:50:06\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:49:58', '2022-12-24 14:50:06');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (409, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":819,\"freq\":49,\"electricity\":\"153.91\",\"mac\":\"\",\"voltage\":\"228.08\",\"current\":\"19.19\",\"temperature\":\"18.80\",\"voltameterstate\":48,\"RestartCnt\":23,\"humidity\":\"20.80\",\"power\":\"4360.54\",\"BLdatafreshcnt\":707,\"status\":1},\"eventTime\":\"20221224T145003Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 14:49:59', '2022-12-24 14:50:07');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (410, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1832.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:50:12\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:50:04', '2022-12-24 14:50:12');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (411, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1832.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 14:50:18\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:50:10', '2022-12-24 14:50:17');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (412, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.8\",\"CO2Concentration\":\"1792.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 14:50:21\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:50:13', '2022-12-24 14:50:21');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (413, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.8\",\"CO2Concentration\":\"1792.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:50:24\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:50:16', '2022-12-24 14:50:24');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (414, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1768.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 14:50:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:50:22', '2022-12-24 14:50:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (415, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1737.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 14:50:33\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:50:25', '2022-12-24 14:50:33');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (416, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.8\",\"CO2Concentration\":\"1736.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:50:39\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:50:31', '2022-12-24 14:50:39');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (417, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1641.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 14:50:54\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:50:46', '2022-12-24 14:50:54');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (418, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1640.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 14:51:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:50:52', '2022-12-24 14:51:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (419, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.9\",\"infra-red\":\"-2\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1590.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 14:51:09\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:51:01', '2022-12-24 14:51:09');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (420, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.8\",\"infra-red\":\"1\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1561.9\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 14:51:18\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 14:51:10', '2022-12-24 14:51:18');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (421, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"0.0\",\"temperature2\":\"0.0\",\"infra-red\":\"0\",\"temperature\":\"0.0\",\"humidity\":\"14.9\",\"CO2Concentration\":\"0.0\",\"Illuminance\":\"0.0\"},\"eventTime\":\"2022-12-24 15:01:37\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:01:30', '2022-12-24 15:01:38');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (422, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"1\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"512.9\",\"Illuminance\":\"26600.0\"},\"eventTime\":\"2022-12-24 15:01:48\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:01:40', '2022-12-24 15:01:48');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (423, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"512.0\",\"Illuminance\":\"26600.0\"},\"eventTime\":\"2022-12-24 15:01:51\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:01:43', '2022-12-24 15:01:51');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (424, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"512.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 15:01:54\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:01:46', '2022-12-24 15:01:54');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (425, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.7\",\"infra-red\":\"-2\",\"temperature\":\"18.4\",\"humidity\":\"14.9\",\"CO2Concentration\":\"515.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 15:01:57\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:01:49', '2022-12-24 15:01:57');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (426, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.7\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"512.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 15:02:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:01:52', '2022-12-24 15:01:59');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (427, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"512.0\",\"Illuminance\":\"26600.0\"},\"eventTime\":\"2022-12-24 15:02:03\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:01:55', '2022-12-24 15:02:03');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (428, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"512.0\",\"Illuminance\":\"26600.0\"},\"eventTime\":\"2022-12-24 15:02:06\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:01:58', '2022-12-24 15:02:06');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (429, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"512.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 15:02:09\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:02:01', '2022-12-24 15:02:09');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (430, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"512.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 15:02:21\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:02:13', '2022-12-24 15:02:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (431, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"1\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"512.9\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 15:02:27\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:02:19', '2022-12-24 15:02:27');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (432, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"1\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"512.9\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:02:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:02:22', '2022-12-24 15:02:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (433, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"510.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 15:02:51\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:02:43', '2022-12-24 15:02:51');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (434, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"509.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 15:02:54\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:02:46', '2022-12-24 15:02:54');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (435, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"508.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 15:02:57\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:02:49', '2022-12-24 15:02:56');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (436, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"508.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:03:03\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:02:55', '2022-12-24 15:03:03');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (437, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"temperature2\":\"18.8\",\"infra-red\":\"1\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"508.5\",\"Illuminance\":\"25900.0\"},\"eventTime\":\"2022-12-24 15:03:15\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:03:07', '2022-12-24 15:03:14');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (438, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"temperature2\":\"18.8\",\"infra-red\":\"1\",\"temperature\":\"18.5\",\"humidity\":\"15.0\",\"CO2Concentration\":\"508.5\",\"Illuminance\":\"25900.0\"},\"eventTime\":\"2022-12-24 15:03:18\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:03:10', '2022-12-24 15:03:17');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (439, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.8\",\"temperature2\":\"18.8\",\"infra-red\":\"1\",\"temperature\":\"18.5\",\"humidity\":\"15.0\",\"CO2Concentration\":\"508.5\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 15:03:21\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:03:13', '2022-12-24 15:03:21');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (440, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.8\",\"temperature2\":\"18.8\",\"infra-red\":\"1\",\"temperature\":\"18.5\",\"humidity\":\"15.0\",\"CO2Concentration\":\"528.9\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 15:03:24\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:03:16', '2022-12-24 15:03:24');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (441, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.8\",\"temperature2\":\"18.8\",\"infra-red\":\"1\",\"temperature\":\"18.5\",\"humidity\":\"15.0\",\"CO2Concentration\":\"528.9\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:03:27\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:03:19', '2022-12-24 15:03:27');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (442, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.5\",\"temperature2\":\"18.8\",\"infra-red\":\"-2\",\"temperature\":\"18.5\",\"humidity\":\"15.0\",\"CO2Concentration\":\"763.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:03:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:03:22', '2022-12-24 15:03:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (443, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.5\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"15.0\",\"CO2Concentration\":\"760.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:03:33\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:03:25', '2022-12-24 15:03:33');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (444, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.3\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"15.0\",\"CO2Concentration\":\"1028.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 15:03:45\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:03:37', '2022-12-24 15:03:45');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (445, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1024.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 15:03:51\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:03:43', '2022-12-24 15:03:51');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (446, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1072.0\",\"Illuminance\":\"26700.0\"},\"eventTime\":\"2022-12-24 15:03:54\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:03:46', '2022-12-24 15:03:53');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (447, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"-2\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1118.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:04:21\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:04:13', '2022-12-24 15:04:21');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (448, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1112.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:04:24\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:04:16', '2022-12-24 15:04:24');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (449, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1112.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:04:27\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:04:19', '2022-12-24 15:04:27');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (450, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1112.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:04:33\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:04:25', '2022-12-24 15:04:32');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (451, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"-2\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1118.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:04:42\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:04:34', '2022-12-24 15:04:42');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (452, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1112.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:04:45\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:04:37', '2022-12-24 15:04:45');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (453, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1112.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:04:48\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:04:40', '2022-12-24 15:04:48');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (454, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1112.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:04:51\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:04:43', '2022-12-24 15:04:51');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (455, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1112.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:04:54\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:04:46', '2022-12-24 15:04:53');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (456, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1112.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:04:57\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:04:49', '2022-12-24 15:04:56');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (457, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1112.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:05:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:04:52', '2022-12-24 15:05:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (458, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1104.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:05:09\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:05:01', '2022-12-24 15:05:09');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (459, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1096.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:05:15\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:05:07', '2022-12-24 15:05:14');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (460, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"-0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1085.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:05:18\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:05:10', '2022-12-24 15:05:18');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (461, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1080.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:05:21\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:05:13', '2022-12-24 15:05:21');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (462, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1032.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:05:48\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:05:40', '2022-12-24 15:05:48');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (463, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1032.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:05:51\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:05:43', '2022-12-24 15:05:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (464, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"1016.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:05:57\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:05:49', '2022-12-24 15:05:57');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (465, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"15.0\",\"CO2Concentration\":\"988.0\",\"Illuminance\":\"26900.0\"},\"eventTime\":\"2022-12-24 15:06:09\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:06:01', '2022-12-24 15:06:09');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (466, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"988.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:06:12\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:06:04', '2022-12-24 15:06:11');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (467, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"978.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:06:15\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:06:07', '2022-12-24 15:06:14');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (468, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"976.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:06:18\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:06:10', '2022-12-24 15:06:18');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (469, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"976.0\",\"Illuminance\":\"26900.0\"},\"eventTime\":\"2022-12-24 15:06:21\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:06:13', '2022-12-24 15:06:21');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (470, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"964.0\",\"Illuminance\":\"26900.0\"},\"eventTime\":\"2022-12-24 15:06:24\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:06:16', '2022-12-24 15:06:24');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (471, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"964.0\",\"Illuminance\":\"26900.0\"},\"eventTime\":\"2022-12-24 15:06:27\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:06:19', '2022-12-24 15:06:27');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (472, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"936.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:06:39\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:06:31', '2022-12-24 15:06:39');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (473, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"916.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:06:45\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:06:37', '2022-12-24 15:06:45');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (474, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"916.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:06:48\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:06:40', '2022-12-24 15:06:48');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (475, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"15.1\",\"CO2Concentration\":\"874.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:07:12\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:07:04', '2022-12-24 15:07:11');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (476, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"15.0\",\"CO2Concentration\":\"872.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:07:15\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:07:07', '2022-12-24 15:07:15');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (477, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"15.0\",\"CO2Concentration\":\"872.0\",\"Illuminance\":\"26800.0\"},\"eventTime\":\"2022-12-24 15:07:18\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:07:10', '2022-12-24 15:07:18');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (478, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"temperature2\":\"18.8\",\"infra-red\":\"1\",\"temperature\":\"18.5\",\"humidity\":\"15.0\",\"CO2Concentration\":\"860.9\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:07:24\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:07:16', '2022-12-24 15:07:24');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (479, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"840.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:07:36\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:07:28', '2022-12-24 15:07:36');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (480, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"840.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:07:39\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:07:31', '2022-12-24 15:07:39');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (481, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"828.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:07:42\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:07:34', '2022-12-24 15:07:42');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (482, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"828.0\",\"Illuminance\":\"29100.0\"},\"eventTime\":\"2022-12-24 15:07:45\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:07:37', '2022-12-24 15:07:45');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (483, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"2\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"821.0\",\"Illuminance\":\"29100.0\"},\"eventTime\":\"2022-12-24 15:07:48\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:07:40', '2022-12-24 15:07:47');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (484, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"1\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"820.9\",\"Illuminance\":\"29100.0\"},\"eventTime\":\"2022-12-24 15:07:51\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:07:43', '2022-12-24 15:07:51');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (485, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"1\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"820.9\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:07:54\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:07:46', '2022-12-24 15:07:54');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (486, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"800.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:08:06\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:07:58', '2022-12-24 15:08:05');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (487, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"15.0\",\"CO2Concentration\":\"792.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:08:12\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:08:04', '2022-12-24 15:08:12');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (488, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"15.0\",\"CO2Concentration\":\"792.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:08:15\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:08:07', '2022-12-24 15:08:15');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (489, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"764.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:08:36\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:08:28', '2022-12-24 15:08:36');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (490, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"760.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:08:39\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:08:31', '2022-12-24 15:08:39');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (491, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.8\",\"CO2Concentration\":\"760.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:08:42\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:08:34', '2022-12-24 15:08:42');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (492, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"752.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:08:48\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:08:40', '2022-12-24 15:08:47');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (493, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"744.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:08:57\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:08:49', '2022-12-24 15:08:57');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (494, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"2\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"737.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:09:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:08:52', '2022-12-24 15:09:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (495, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"736.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:09:03\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:08:55', '2022-12-24 15:09:03');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (496, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"736.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:09:06\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:08:58', '2022-12-24 15:09:05');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (497, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"728.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:09:09\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:09:01', '2022-12-24 15:09:09');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (498, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"728.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:09:12\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:09:04', '2022-12-24 15:09:12');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (499, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"724.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:09:15\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:09:07', '2022-12-24 15:09:15');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (500, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"716.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:09:27\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:09:19', '2022-12-24 15:09:26');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (501, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"708.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:09:33\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:09:25', '2022-12-24 15:09:33');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (502, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"-2\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"703.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:09:36\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:09:28', '2022-12-24 15:09:36');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (503, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"700.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:09:39\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:09:31', '2022-12-24 15:09:39');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (504, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"684.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:10:03\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:09:55', '2022-12-24 15:10:02');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (505, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"676.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:10:06\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:09:58', '2022-12-24 15:10:05');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (506, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":1419,\"freq\":49,\"electricity\":\"155.37\",\"mac\":\"898604872120F1101593\",\"voltage\":\"228.49\",\"current\":\"19.14\",\"temperature\":\"19.00\",\"voltameterstate\":0,\"RestartCnt\":23,\"humidity\":\"20.80\",\"power\":\"4358.81\",\"BLdatafreshcnt\":1308,\"status\":1},\"eventTime\":\"20221224T151003Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 15:09:59', '2022-12-24 15:10:07');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (507, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"668.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:10:12\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:10:04', '2022-12-24 15:10:12');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (508, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"664.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:10:24\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:10:16', '2022-12-24 15:10:23');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (509, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"656.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:10:27\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:10:19', '2022-12-24 15:10:27');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (510, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"656.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:10:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:10:22', '2022-12-24 15:10:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (511, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"2\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"653.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:10:33\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:10:25', '2022-12-24 15:10:33');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (512, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"652.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:10:36\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:10:28', '2022-12-24 15:10:36');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (513, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"622.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:11:18\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:11:10', '2022-12-24 15:11:17');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (514, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"620.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:11:24\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:11:16', '2022-12-24 15:11:23');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (515, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"616.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:11:27\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:11:19', '2022-12-24 15:11:27');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (516, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"616.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:11:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:11:22', '2022-12-24 15:11:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (517, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"600.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:11:57\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:11:49', '2022-12-24 15:11:56');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (518, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"600.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:12:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:11:52', '2022-12-24 15:11:59');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (519, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"15.0\",\"CO2Concentration\":\"592.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:12:03\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:11:55', '2022-12-24 15:12:02');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (520, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"15.0\",\"CO2Concentration\":\"592.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:12:09\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:12:01', '2022-12-24 15:12:09');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (521, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"584.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:12:18\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:12:10', '2022-12-24 15:12:17');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (522, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"584.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:12:21\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:12:13', '2022-12-24 15:12:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (523, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"1\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"584.9\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:12:24\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:12:16', '2022-12-24 15:12:23');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (524, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"1\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"584.9\",\"Illuminance\":\"17300.0\"},\"eventTime\":\"2022-12-24 15:12:27\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:12:19', '2022-12-24 15:12:27');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (525, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"1\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"580.9\",\"Illuminance\":\"17300.0\"},\"eventTime\":\"2022-12-24 15:12:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:12:22', '2022-12-24 15:12:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (526, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"1\",\"temperature\":\"18.5\",\"humidity\":\"14.9\",\"CO2Concentration\":\"580.9\",\"Illuminance\":\"17300.0\"},\"eventTime\":\"2022-12-24 15:12:33\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:12:25', '2022-12-24 15:12:32');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (527, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"temperature2\":\"18.8\",\"infra-red\":\"0\",\"temperature\":\"18.5\",\"humidity\":\"15.0\",\"CO2Concentration\":\"576.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:12:42\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:12:34', '2022-12-24 15:12:41');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (528, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"0.0\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"0.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:19:12\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:19:04', '2022-12-24 15:19:12');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (529, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"18.8\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"477.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:19:15\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:19:08', '2022-12-24 15:19:15');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (530, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"18.8\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"477.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:19:18\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:19:11', '2022-12-24 15:19:18');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (531, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"18.8\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"477.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:19:21\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:19:14', '2022-12-24 15:19:21');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (532, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"18.8\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"476.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:19:23\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:19:16', '2022-12-24 15:19:24');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (533, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"18.8\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"476.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:19:24\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:19:17', '2022-12-24 15:19:24');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (534, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"18.8\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"476.0\",\"Illuminance\":\"28900.0\"},\"eventTime\":\"2022-12-24 15:19:27\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:19:20', '2022-12-24 15:19:27');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (535, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"18.8\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"473.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:19:39\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:19:32', '2022-12-24 15:19:39');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (536, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"18.8\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"473.0\",\"Illuminance\":\"29100.0\"},\"eventTime\":\"2022-12-24 15:19:45\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:19:38', '2022-12-24 15:19:45');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (537, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"18.8\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"472.0\",\"Illuminance\":\"29100.0\"},\"eventTime\":\"2022-12-24 15:19:48\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:19:41', '2022-12-24 15:19:48');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (538, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"18.8\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"472.0\",\"Illuminance\":\"29100.0\"},\"eventTime\":\"2022-12-24 15:19:48\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:19:41', '2022-12-24 15:19:49');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (539, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":1719,\"freq\":49,\"electricity\":\"156.10\",\"mac\":\"898604872120F1101593\",\"voltage\":\"227.95\",\"current\":\"19.21\",\"temperature\":\"19.00\",\"voltameterstate\":176,\"RestartCnt\":23,\"humidity\":\"20.80\",\"power\":\"4362.78\",\"BLdatafreshcnt\":1608,\"status\":1},\"eventTime\":\"20221224T152003Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 15:19:59', '2022-12-24 15:20:07');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (540, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"470.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:20:09\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:20:02', '2022-12-24 15:20:09');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (541, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"18.8\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"469.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:20:12\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:20:05', '2022-12-24 15:20:12');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (542, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.3\",\"temperature2\":\"18.8\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"469.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:20:18\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:20:10', '2022-12-24 15:20:18');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (543, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.1\",\"temperature2\":\"18.8\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"468.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:20:24\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:20:16', '2022-12-24 15:20:24');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (544, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.1\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"468.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:20:27\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:20:19', '2022-12-24 15:20:27');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (545, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.1\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"467.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:20:28\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:20:21', '2022-12-24 15:20:29');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (546, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.1\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"467.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:20:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:20:22', '2022-12-24 15:20:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (547, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"467.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:20:33\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:20:25', '2022-12-24 15:20:33');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (548, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"18.8\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"467.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:20:36\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:20:28', '2022-12-24 15:20:36');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (549, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"18.8\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"467.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:20:37\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:20:30', '2022-12-24 15:20:37');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (550, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"18.8\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"467.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:20:48\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:20:40', '2022-12-24 15:20:48');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (551, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"466.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:20:54\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:20:47', '2022-12-24 15:20:54');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (552, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"466.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:20:57\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:20:50', '2022-12-24 15:20:57');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (553, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"18.8\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"466.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:21:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:20:53', '2022-12-24 15:21:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (554, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"461.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:22:08\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:22:01', '2022-12-24 15:22:09');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (555, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"461.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:22:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:22:02', '2022-12-24 15:22:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (556, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.2\",\"temperature2\":\"18.8\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"460.0\",\"Illuminance\":\"29300.0\"},\"eventTime\":\"2022-12-24 15:22:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:22:12', '2022-12-24 15:22:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (557, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"18.8\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"458.0\",\"Illuminance\":\"29100.0\"},\"eventTime\":\"2022-12-24 15:22:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:22:33', '2022-12-24 15:22:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (558, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"458.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:22:48\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:22:41', '2022-12-24 15:22:49');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (559, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"458.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:22:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:22:43', '2022-12-24 15:22:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (560, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"457.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:23:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:22:53', '2022-12-24 15:23:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (561, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"457.0\",\"Illuminance\":\"29100.0\"},\"eventTime\":\"2022-12-24 15:23:05\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:22:58', '2022-12-24 15:23:05');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (562, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"457.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:23:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:23:03', '2022-12-24 15:23:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (563, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.5\",\"Smoke-sensation\":\"1\",\"humidity1\":\"15.2\",\"temperature2\":\"18.9\",\"temperature1\":\"18.7\",\"infra-red\":\"1\",\"CO2Concentration\":\"455.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:24:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:23:53', '2022-12-24 15:24:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (564, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.3\",\"Smoke-sensation\":\"1\",\"humidity1\":\"15.1\",\"temperature2\":\"18.9\",\"temperature1\":\"18.7\",\"infra-red\":\"1\",\"CO2Concentration\":\"455.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:24:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:24:03', '2022-12-24 15:24:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (565, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"457.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:24:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:24:43', '2022-12-24 15:24:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (566, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"457.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:24:51\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:24:44', '2022-12-24 15:24:52');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (567, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"18.9\",\"temperature1\":\"18.7\",\"infra-red\":\"0\",\"CO2Concentration\":\"457.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:25:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:24:53', '2022-12-24 15:25:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (568, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":1869,\"freq\":49,\"electricity\":\"156.47\",\"mac\":\"898604872120F1101593\",\"voltage\":\"227.85\",\"current\":\"19.24\",\"temperature\":\"19.00\",\"voltameterstate\":128,\"RestartCnt\":23,\"humidity\":\"20.80\",\"power\":\"4370.41\",\"BLdatafreshcnt\":1758,\"status\":1},\"eventTime\":\"20221224T152504Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 15:25:00', '2022-12-24 15:25:07');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (569, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"457.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:25:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:25:03', '2022-12-24 15:25:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (570, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"18.9\",\"temperature1\":\"18.7\",\"infra-red\":\"1\",\"CO2Concentration\":\"457.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:25:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:25:23', '2022-12-24 15:25:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (571, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"18.8\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"457.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:25:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:25:33', '2022-12-24 15:25:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (572, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"18.8\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"457.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:25:41\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:25:33', '2022-12-24 15:25:41');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (573, '1ff64cb6d0a74903a508b5f0e88601a1', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/command', '{\"msgType\":\"cloudReq\",\"mid\":706,\"cmd\":\"control\",\"paras\":{\"command\":\"06fe03840071014f0072014f0072006f0077006a0072006e0071006e0071014f0078014b007201500072014f0072014f0072014f007201500072006e0072006e0073014f0072006f0071006f0071006f0072006f0072006f0072014f007201500072014f0073006f0071006f0072006f0071006f0072006f0072006f0072006e0072006f0071006f0071006f0071006e0071006e0071006e007201500072006f007201500072006f0071006f0071006f0071006f0071006e0072006f0072006f007200700071006f0070006f0071006f0071006f0071006f0071006f0071006f00720150007200700070006f0071006f0071006f007100700071006f0071006f0072006f0071006f007000700071006f0071006f0071006f00710070007100700072006f007000700071006f0070006f0071006f00720150007201500072006f00710070007100700070006f0071006f0071006f0071007000710070007100700072006f0070015000710070007001500071006f0071006f0072006f007101500071006f0070015000710150007101500072006f007101500071007000710150007201500070\",\"status\":1},\"serviceId\":\"service_command\",\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}', 'success', '2022-12-24 15:25:37', '2022-12-24 15:25:45');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (574, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"457.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:25:48\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:25:41', '2022-12-24 15:25:49');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (575, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"457.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:25:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:25:43', '2022-12-24 15:25:51');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (576, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"457.0\",\"Illuminance\":\"29100.0\"},\"eventTime\":\"2022-12-24 15:25:56\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:25:49', '2022-12-24 15:25:57');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (577, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"457.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:26:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:25:53', '2022-12-24 15:26:01');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (578, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"457.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:26:20\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:26:12', '2022-12-24 15:26:20');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (579, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"15.0\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"1\",\"CO2Concentration\":\"457.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:26:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:26:22', '2022-12-24 15:26:30');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (580, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.2\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"18.9\",\"temperature1\":\"18.6\",\"infra-red\":\"0\",\"CO2Concentration\":\"457.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:26:38\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:26:31', '2022-12-24 15:26:38');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (581, '1ff64cb6d0a74903a508b5f0e88601a1', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/command', '{\"msgType\":\"cloudReq\",\"mid\":706,\"cmd\":\"control\",\"paras\":{\"command\":\"06fe03840071014f0072014f0072006f0077006a0072006e0071006e0071014f0078014b007201500072014f0072014f0072014f007201500072006e0072006e0073014f0072006f0071006f0071006f0072006f0072006f0072014f007201500072014f0073006f0071006f0072006f0071006f0072006f0072006f0072006e0072006f0071006f0071006f0071006e0071006e0071006e007201500072006f007201500072006f0071006f0071006f0071006f0071006e0072006f0072006f007200700071006f0070006f0071006f0071006f0071006f0071006f0071006f00720150007200700070006f0071006f0071006f007100700071006f0071006f0072006f0071006f007000700071006f0071006f0071006f00710070007100700072006f007000700071006f0070006f0071006f00720150007201500072006f00710070007100700070006f0071006f0071006f0071007000710070007100700072006f0070015000710070007001500071006f0071006f0072006f007101500071006f0070015000710150007101500072006f007101500071007000710150007201500070\",\"status\":1},\"serviceId\":\"service_command\",\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}', 'success', '2022-12-24 15:27:31', '2022-12-24 15:27:38');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (582, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"19.0\",\"temperature1\":\"18.7\",\"infra-red\":\"0\",\"CO2Concentration\":\"456.0\",\"Illuminance\":\"29300.0\"},\"eventTime\":\"2022-12-24 15:27:40\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:27:32', '2022-12-24 15:27:40');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (583, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.0\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"19.0\",\"temperature1\":\"18.7\",\"infra-red\":\"0\",\"CO2Concentration\":\"456.0\",\"Illuminance\":\"29300.0\"},\"eventTime\":\"2022-12-24 15:27:50\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:27:42', '2022-12-24 15:27:50');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (584, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"19.0\",\"temperature1\":\"18.7\",\"infra-red\":\"0\",\"CO2Concentration\":\"456.0\",\"Illuminance\":\"29300.0\"},\"eventTime\":\"2022-12-24 15:28:00\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:27:52', '2022-12-24 15:28:00');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (585, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"19.0\",\"temperature1\":\"18.7\",\"infra-red\":\"0\",\"CO2Concentration\":\"456.0\",\"Illuminance\":\"29300.0\"},\"eventTime\":\"2022-12-24 15:28:10\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:28:02', '2022-12-24 15:28:10');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (586, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"19.0\",\"temperature1\":\"18.7\",\"infra-red\":\"0\",\"CO2Concentration\":\"456.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:28:30\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:28:23', '2022-12-24 15:28:31');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (587, '1ff64cb6d0a74903a508b5f0e88601a3', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '{\"devices\":[{\"services\":[{\"data\":{\"humidity2\":\"15.1\",\"Smoke-sensation\":\"0\",\"humidity1\":\"14.9\",\"temperature2\":\"19.0\",\"temperature1\":\"18.7\",\"infra-red\":\"1\",\"CO2Concentration\":\"455.0\",\"Illuminance\":\"29200.0\"},\"eventTime\":\"2022-12-24 15:28:32\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a3\"}]}', 'success', '2022-12-24 15:28:25', '2022-12-24 15:28:32');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (588, '1ff64cb6d0a74903a508b5f0e88601a1', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/command', '{\"msgType\":\"cloudReq\",\"mid\":706,\"cmd\":\"control\",\"paras\":{\"command\":\"06fe03840071014f0072014f0072006f0077006a0072006e0071006e0071014f0078014b007201500072014f0072014f0072014f007201500072006e0072006e0073014f0072006f0071006f0071006f0072006f0072006f0072014f007201500072014f0073006f0071006f0072006f0071006f0072006f0072006f0072006e0072006f0071006f0071006f0071006e0071006e0071006e007201500072006f007201500072006f0071006f0071006f0071006f0071006e0072006f0072006f007200700071006f0070006f0071006f0071006f0071006f0071006f0071006f00720150007200700070006f0071006f0071006f007100700071006f0071006f0072006f0071006f007000700071006f0071006f0071006f00710070007100700072006f007000700071006f0070006f0071006f00720150007201500072006f00710070007100700070006f0071006f0071006f0071007000710070007100700072006f0070015000710070007001500071006f0071006f0072006f007101500071006f0070015000710150007101500072006f007101500071007000710150007201500070\",\"status\":1},\"serviceId\":\"service_command\",\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}', 'success', '2022-12-24 15:33:34', '2022-12-24 15:33:42');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (589, '1ff64cb6d0a74903a508b5f0e88601a1', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/command', '{\"msgType\":\"cloudReq\",\"mid\":706,\"cmd\":\"control\",\"paras\":{\"command\":\"06fd03840070014f0072014f0072006f0072006f0072006f0072006f007201500073014f0072014f0071014f0072014f00720150007201500072006f0072006f0072014f0072006f0071006f0070006f0072006f0072006f007201500072014f007301500072006f0071006f0071006f0072006f0072006f0072006f0071006f0072006f0071006f0071006f0070006f0071006f0072006f007201500072006f007201500072006f0070006f0071006f0071006f00710070007100700071006f0072006f0070006f0071006f0070006f0071006f0072006f0072006f0072006f00720150007200700071006f00710070007100700071006f0072006f0072006f007200700071006f0070006f0071006f0071006f0072006f0071006f0071006f0072006f0070006f0071006f0070006f0071006f0072006f0072006f0072006f00720070007100700070006f007000700071006f0071006f0072006f0071006f0071006f0071015000700070007001500071006f0071006f0072006f00720150007200700071015000720150007101500071006f0072006f0072015000720070007101500071\",\"status\":1},\"serviceId\":\"service_command\",\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}', 'success', '2022-12-24 15:42:25', '2022-12-24 15:42:33');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (590, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":967,\"freq\":49,\"electricity\":\"158.65\",\"mac\":\"\",\"voltage\":\"227.46\",\"current\":\"19.18\",\"temperature\":\"19.10\",\"voltameterstate\":48,\"RestartCnt\":23,\"humidity\":\"21.40\",\"power\":\"4346.59\",\"BLdatafreshcnt\":856,\"status\":1},\"eventTime\":\"20221224T155502Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 15:54:58', '2022-12-24 15:55:06');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (591, '1ff64cb6d0a74903a508b5f0e88601a1', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/command', '{\"msgType\":\"cloudReq\",\"mid\":706,\"cmd\":\"control\",\"paras\":{\"command\":\"06fd03840070014f0072014f0072006f0072006f0072006f0072006f007201500073014f0072014f0071014f0072014f00720150007201500072006f0072006f0072014f0072006f0071006f0070006f0072006f0072006f007201500072014f007301500072006f0071006f0071006f0072006f0072006f0072006f0071006f0072006f0071006f0071006f0070006f0071006f0072006f007201500072006f007201500072006f0070006f0071006f0071006f00710070007100700071006f0072006f0070006f0071006f0070006f0071006f0072006f0072006f0072006f00720150007200700071006f00710070007100700071006f0072006f0072006f007200700071006f0070006f0071006f0071006f0072006f0071006f0071006f0072006f0070006f0071006f0070006f0071006f0072006f0072006f0072006f00720070007100700070006f007000700071006f0071006f0072006f0071006f0071006f0071015000700070007001500071006f0071006f0072006f00720150007200700071015000720150007101500071006f0072006f0072015000720070007101500071\",\"status\":1},\"serviceId\":\"service_command\",\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}', 'success', '2022-12-24 15:55:08', '2022-12-24 15:55:16');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (592, '1ff64cb6d0a74903a508b5f0e88601a1', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/command', '{\"msgType\":\"cloudReq\",\"mid\":706,\"cmd\":\"control\",\"paras\":{\"command\":\"06fd03840070014f0072014f0072006f0072006f0072006f0072006f007201500073014f0072014f0071014f0072014f00720150007201500072006f0072006f0072014f0072006f0071006f0070006f0072006f0072006f007201500072014f007301500072006f0071006f0071006f0072006f0072006f0072006f0071006f0072006f0071006f0071006f0070006f0071006f0072006f007201500072006f007201500072006f0070006f0071006f0071006f00710070007100700071006f0072006f0070006f0071006f0070006f0071006f0072006f0072006f0072006f00720150007200700071006f00710070007100700071006f0072006f0072006f007200700071006f0070006f0071006f0071006f0072006f0071006f0071006f0072006f0070006f0071006f0070006f0071006f0072006f0072006f0072006f00720070007100700070006f007000700071006f0071006f0072006f0071006f0071006f0071015000700070007001500071006f0071006f0072006f00720150007200700071015000720150007101500071006f0072006f0072015000720070007101500071\",\"status\":1},\"serviceId\":\"service_command\",\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}', 'success', '2022-12-24 16:13:57', '2022-12-24 16:14:05');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (593, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/commandResponse', '{\"errcode\":0,\"msgType\":\"deviceRsp\",\"mid\":706,\"body\":{\"orginParameters\":{\"command\":\"06fd03840070014f0072014f0072006f0072006f0072006f0072006f007201500073014f0072014f0071014f0072014f00720150007201500072006f0072006f0072014f0072006f0071006f0070006f0072006f0072006f007201500072014f007301500072006f0071006f0071006f0072006f0072006f0072006f0071006f0072006f0071006f0071006f0070006f0071006f0072006f007201500072006f007201500072006f0070006f0071006f0071006f00710070007100700071006f0072006f0070006f0071006f0070006f0071006f0072006f0072006f0072006f00720150007200700071006f00710070007100700071006f0072006f0072006f007200700071006f0070006f0071006f0071006f0072006f0071006f0071006f0072006f0070006f0071006f0070006f0071006f0072006f0072006f0072006f00720070007100700070006f007000700071006f0071006f0072006f0071006f0071006f0071015000700070007001500071006f0071006f0072006f00720150007200700071015000720150007101500071006f0072006f0072015000720070007101500071\",\"status\":1}}}', 'success', '2022-12-24 16:14:21', '2022-12-24 16:14:28');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (594, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":129,\"freq\":49,\"electricity\":\"160.07\",\"mac\":\"\",\"voltage\":\"233.28\",\"current\":\"0.27\",\"temperature\":\"19.00\",\"voltameterstate\":256,\"RestartCnt\":23,\"humidity\":\"21.20\",\"power\":\"24.25\",\"BLdatafreshcnt\":17,\"status\":1},\"eventTime\":\"20221224T161503Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 16:14:59', '2022-12-24 16:15:06');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (595, '1ff64cb6d0a74903a508b5f0e88601a1', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/command', '{\"msgType\":\"cloudReq\",\"mid\":706,\"cmd\":\"control\",\"paras\":{\"command\":\"06fe03840071014f0072014f0072006f0077006a0072006e0071006e0071014f0078014b007201500072014f0072014f0072014f007201500072006e0072006e0073014f0072006f0071006f0071006f0072006f0072006f0072014f007201500072014f0073006f0071006f0072006f0071006f0072006f0072006f0072006e0072006f0071006f0071006f0071006e0071006e0071006e007201500072006f007201500072006f0071006f0071006f0071006f0071006e0072006f0072006f007200700071006f0070006f0071006f0071006f0071006f0071006f0071006f00720150007200700070006f0071006f0071006f007100700071006f0071006f0072006f0071006f007000700071006f0071006f0071006f00710070007100700072006f007000700071006f0070006f0071006f00720150007201500072006f00710070007100700070006f0071006f0071006f0071007000710070007100700072006f0070015000710070007001500071006f0071006f0072006f007101500071006f0070015000710150007101500072006f007101500071007000710150007201500070\",\"status\":1},\"serviceId\":\"service_command\",\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}', 'success', '2022-12-24 16:19:35', '2022-12-24 16:19:43');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (596, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":279,\"freq\":49,\"electricity\":\"160.07\",\"mac\":\"\",\"voltage\":\"233.55\",\"current\":\"0.05\",\"temperature\":\"18.70\",\"voltameterstate\":288,\"RestartCnt\":23,\"humidity\":\"21.20\",\"power\":\"2.21\",\"BLdatafreshcnt\":167,\"status\":1},\"eventTime\":\"20221224T162003Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 16:20:00', '2022-12-24 16:20:07');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (597, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/commandResponse', '{\"errcode\":0,\"msgType\":\"deviceRsp\",\"mid\":706,\"body\":{\"orginParameters\":{\"command\":\"06fe03840071014f0072014f0072006f0077006a0072006e0071006e0071014f0078014b007201500072014f0072014f0072014f007201500072006e0072006e0073014f0072006f0071006f0071006f0072006f0072006f0072014f007201500072014f0073006f0071006f0072006f0071006f0072006f0072006f0072006e0072006f0071006f0071006f0071006e0071006e0071006e007201500072006f007201500072006f0071006f0071006f0071006f0071006e0072006f0072006f007200700071006f0070006f0071006f0071006f0071006f0071006f0071006f00720150007200700070006f0071006f0071006f007100700071006f0071006f0072006f0071006f007000700071006f0071006f0071006f00710070007100700072006f007000700071006f0070006f0071006f00720150007201500072006f00710070007100700070006f0071006f0071006f0071007000710070007100700072006f0070015000710070007001500071006f0071006f0072006f007101500071006f0070015000710150007101500072006f007101500071007000710150007201500070\",\"status\":1}}}', 'success', '2022-12-24 16:20:08', '2022-12-24 16:20:15');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (598, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":555,\"freq\":49,\"electricity\":\"161.06\",\"mac\":\"\",\"voltage\":\"228.10\",\"current\":\"19.07\",\"temperature\":\"18.60\",\"voltameterstate\":128,\"RestartCnt\":23,\"humidity\":\"21.00\",\"power\":\"4334.15\",\"BLdatafreshcnt\":444,\"status\":1},\"eventTime\":\"20221224T163502Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 16:34:58', '2022-12-24 16:35:06');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (599, '1ff64cb6d0a74903a508b5f0e88601a1', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/command', '{\"msgType\":\"cloudReq\",\"mid\":706,\"cmd\":\"control\",\"paras\":{\"command\":\"06fe03840071014f0072014f0072006f0077006a0072006e0071006e0071014f0078014b007201500072014f0072014f0072014f007201500072006e0072006e0073014f0072006f0071006f0071006f0072006f0072006f0072014f007201500072014f0073006f0071006f0072006f0071006f0072006f0072006f0072006e0072006f0071006f0071006f0071006e0071006e0071006e007201500072006f007201500072006f0071006f0071006f0071006f0071006e0072006f0072006f007200700071006f0070006f0071006f0071006f0071006f0071006f0071006f00720150007200700070006f0071006f0071006f007100700071006f0071006f0072006f0071006f007000700071006f0071006f0071006f00710070007100700072006f007000700071006f0070006f0071006f00720150007201500072006f00710070007100700070006f0071006f0071006f0071007000710070007100700072006f0070015000710070007001500071006f0071006f0072006f007101500071006f0070015000710150007101500072006f007101500071007000710150007201500070\",\"status\":1},\"serviceId\":\"service_command\",\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}', 'success', '2022-12-24 16:37:58', '2022-12-24 16:38:06');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (600, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":706,\"freq\":49,\"electricity\":\"161.42\",\"mac\":\"\",\"voltage\":\"227.59\",\"current\":\"19.13\",\"temperature\":\"18.70\",\"voltameterstate\":48,\"RestartCnt\":23,\"humidity\":\"20.80\",\"power\":\"4339.25\",\"BLdatafreshcnt\":594,\"status\":1},\"eventTime\":\"20221224T164003Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 16:39:59', '2022-12-24 16:40:07');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (601, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":1155,\"freq\":49,\"electricity\":\"162.51\",\"mac\":\"\",\"voltage\":\"227.40\",\"current\":\"19.17\",\"temperature\":\"18.90\",\"voltameterstate\":176,\"RestartCnt\":23,\"humidity\":\"20.80\",\"power\":\"4345.43\",\"BLdatafreshcnt\":1044,\"status\":1},\"eventTime\":\"20221224T165503Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 16:54:58', '2022-12-24 16:55:06');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (602, '1ff64cb6d0a74903a508b5f0e88601a1', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/command', '{\"msgType\":\"cloudReq\",\"mid\":706,\"cmd\":\"control\",\"paras\":{\"command\":\"06fe03840071014f0072014f0072006f0077006a0072006e0071006e0071014f0078014b007201500072014f0072014f0072014f007201500072006e0072006e0073014f0072006f0071006f0071006f0072006f0072006f0072014f007201500072014f0073006f0071006f0072006f0071006f0072006f0072006f0072006e0072006f0071006f0071006f0071006e0071006e0071006e007201500072006f007201500072006f0071006f0071006f0071006f0071006e0072006f0072006f007200700071006f0070006f0071006f0071006f0071006f0071006f0071006f00720150007200700070006f0071006f0071006f007100700071006f0071006f0072006f0071006f007000700071006f0071006f0071006f00710070007100700072006f007000700071006f0070006f0071006f00720150007201500072006f00710070007100700070006f0071006f0071006f0071007000710070007100700072006f0070015000710070007001500071006f0071006f0072006f007101500071006f0070015000710150007101500072006f007101500071007000710150007201500070\",\"status\":1},\"serviceId\":\"service_command\",\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}', 'success', '2022-12-24 16:55:55', '2022-12-24 16:56:02');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (603, '1ff64cb6d0a74903a508b5f0e88601a1', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/command', '{\"msgType\":\"cloudReq\",\"mid\":706,\"cmd\":\"control\",\"paras\":{\"command\":\"06fe03840071014f0072014f0072006f0077006a0072006e0071006e0071014f0078014b007201500072014f0072014f0072014f007201500072006e0072006e0073014f0072006f0071006f0071006f0072006f0072006f0072014f007201500072014f0073006f0071006f0072006f0071006f0072006f0072006f0072006e0072006f0071006f0071006f0071006e0071006e0071006e007201500072006f007201500072006f0071006f0071006f0071006f0071006e0072006f0072006f007200700071006f0070006f0071006f0071006f0071006f0071006f0071006f00720150007200700070006f0071006f0071006f007100700071006f0071006f0072006f0071006f007000700071006f0071006f0071006f00710070007100700072006f007000700071006f0070006f0071006f00720150007201500072006f00710070007100700070006f0071006f0071006f0071007000710070007100700072006f0070015000710070007001500071006f0071006f0072006f007101500071006f0070015000710150007101500072006f007101500071007000710150007201500070\",\"status\":1},\"serviceId\":\"service_command\",\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}', 'success', '2022-12-24 17:07:26', '2022-12-24 17:07:34');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (604, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":19,\"THdatafreshcnt\":1754,\"freq\":49,\"electricity\":\"163.96\",\"mac\":\"898604872120F1101593\",\"voltage\":\"228.34\",\"current\":\"19.00\",\"temperature\":\"18.90\",\"voltameterstate\":0,\"RestartCnt\":23,\"humidity\":\"21.70\",\"power\":\"4323.33\",\"BLdatafreshcnt\":1643,\"status\":1},\"eventTime\":\"20221224T171501Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 17:15:07', '2022-12-24 17:15:15');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (605, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":404,\"freq\":49,\"electricity\":\"165.04\",\"mac\":\"\",\"voltage\":\"228.55\",\"current\":\"18.97\",\"temperature\":\"18.80\",\"voltameterstate\":0,\"RestartCnt\":23,\"humidity\":\"21.40\",\"power\":\"4318.72\",\"BLdatafreshcnt\":292,\"status\":1},\"eventTime\":\"20221224T173003Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 17:29:58', '2022-12-24 17:30:06');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (606, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":554,\"freq\":49,\"electricity\":\"165.41\",\"mac\":\"\",\"voltage\":\"228.72\",\"current\":\"18.98\",\"temperature\":\"18.80\",\"voltameterstate\":48,\"RestartCnt\":23,\"humidity\":\"21.20\",\"power\":\"4325.71\",\"BLdatafreshcnt\":442,\"status\":1},\"eventTime\":\"20221224T173503Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 17:34:59', '2022-12-24 17:35:06');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (607, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":854,\"freq\":49,\"electricity\":\"166.13\",\"mac\":\"\",\"voltage\":\"228.13\",\"current\":\"19.00\",\"temperature\":\"18.60\",\"voltameterstate\":0,\"RestartCnt\":23,\"humidity\":\"21.30\",\"power\":\"4318.99\",\"BLdatafreshcnt\":742,\"status\":1},\"eventTime\":\"20221224T174503Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 17:45:00', '2022-12-24 17:45:08');
INSERT INTO `device_datas` (`id`, `device_identification`, `protocol_type`, `message_id`, `topic`, `message`, `status`, `report_time`, `create_time`) VALUES (608, '1ff64cb6d0a74903a508b5f0e88601a6', 'MQTT', '-1', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '{\"devices\":[{\"services\":[{\"data\":{\"CSQ\":20,\"THdatafreshcnt\":1004,\"freq\":49,\"electricity\":\"166.49\",\"mac\":\"\",\"voltage\":\"228.49\",\"current\":\"19.00\",\"temperature\":\"18.60\",\"voltameterstate\":0,\"RestartCnt\":23,\"humidity\":\"21.10\",\"power\":\"4326.12\",\"BLdatafreshcnt\":892,\"status\":1},\"eventTime\":\"20221224T175004Z\",\"serviceId\":\"service_data\"}],\"deviceId\":\"1ff64cb6d0a74903a508b5f0e88601a6\"}]}', 'success', '2022-12-24 17:50:00', '2022-12-24 17:50:07');
COMMIT;

-- ----------------------------
-- Table structure for device_info
-- ----------------------------
DROP TABLE IF EXISTS `device_info`;
CREATE TABLE `device_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `d_id` bigint(20) NOT NULL COMMENT '边设备档案主键',
  `app_id` varchar(64) NOT NULL COMMENT '应用ID',
  `node_id` varchar(256) DEFAULT NULL COMMENT '设备节点ID',
  `node_name` varchar(256) DEFAULT NULL COMMENT '设备名称',
  `device_id` varchar(256) DEFAULT NULL COMMENT '子设备唯一标识',
  `description` varchar(256) DEFAULT NULL COMMENT '设备描述',
  `manufacturer_id` varchar(256) DEFAULT NULL COMMENT '厂商ID',
  `model` varchar(256) DEFAULT NULL COMMENT '设备型号',
  `connect_status` varchar(20) DEFAULT NULL COMMENT '子设备连接状态 : 在线：ONLINE || 离线：OFFLINE || 未连接：INIT',
  `shadow_enable` tinyint(1) DEFAULT '1' COMMENT '是否支持设备影子TRUE:1、FALSE :0',
  `shadow_table_name` varchar(2048) DEFAULT NULL COMMENT '设备影子数据表名(多个英文逗号分割)',
  `status` varchar(10) NOT NULL DEFAULT '0' COMMENT '状态(字典值：0启用  1停用)',
  `create_by` varchar(64) DEFAULT 'ununited' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='子设备档案表';

-- ----------------------------
-- Records of device_info
-- ----------------------------
BEGIN;
INSERT INTO `device_info` (`id`, `d_id`, `app_id`, `node_id`, `node_name`, `device_id`, `description`, `manufacturer_id`, `model`, `connect_status`, `shadow_enable`, `shadow_table_name`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1, 81, 'thinglinks', 'wenshidu1001', '温湿度设备1001', 'e444a9455dde4b5694888a87d9381a6e', '温湿度设备1001测试', 'thinglinks', 'sensorTest', 'ONLINE', 0, 'GATEWAY_14d7e584abb44239be00d3e04e35e0e8_hongwai_e444a9455dde4b5694888a87d9381a6e,GATEWAY_14d7e584abb44239be00d3e04e35e0e8_wenshidu_e444a9455dde4b5694888a87d9381a6e', '0', 'admin', '2023-05-02 22:19:50', 'admin', '2023-05-02 22:46:58', NULL);
INSERT INTO `device_info` (`id`, `d_id`, `app_id`, `node_id`, `node_name`, `device_id`, `description`, `manufacturer_id`, `model`, `connect_status`, `shadow_enable`, `shadow_table_name`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (2, 81, 'thinglinks', 'hongwai1001', '红外设备1001', 'd1aeed0a1e8a4097b7fd28a7d7ade7b8', '红外设备1001测试', 'thinglinks', 'sensorTest', 'ONLINE', 1, NULL, '0', 'admin', '2023-05-02 22:22:20', '', '2023-05-02 22:47:05', NULL);
INSERT INTO `device_info` (`id`, `d_id`, `app_id`, `node_id`, `node_name`, `device_id`, `description`, `manufacturer_id`, `model`, `connect_status`, `shadow_enable`, `shadow_table_name`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (3, 82, '34567098765', 'hitelecom888', 'sdfghgjk', 'e68610a961e44d98a44d14ec03dbf1aa', 'jhk', 'zxcvbnm', 'zxcvnm', 'INIT', 1, NULL, '0', 'hitelcom', '2023-11-29 22:03:24', '', '2023-11-29 22:03:24', 'rtghjnbvc');
COMMIT;

-- ----------------------------
-- Table structure for device_location
-- ----------------------------
DROP TABLE IF EXISTS `device_location`;
CREATE TABLE `device_location` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `device_identification` varchar(100) NOT NULL COMMENT '设备标识',
  `latitude` decimal(10,7) NOT NULL COMMENT '纬度',
  `longitude` decimal(10,7) NOT NULL COMMENT '经度',
  `full_name` varchar(500) NOT NULL COMMENT '位置名称',
  `province_code` varchar(50) NOT NULL COMMENT '省,直辖市编码',
  `city_code` varchar(50) NOT NULL COMMENT '市编码',
  `region_code` varchar(50) NOT NULL COMMENT '区县',
  `create_by` varchar(64) DEFAULT 'ununited' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8 COMMENT='设备位置表';

-- ----------------------------
-- Records of device_location
-- ----------------------------
BEGIN;
INSERT INTO `device_location` (`id`, `device_identification`, `latitude`, `longitude`, `full_name`, `province_code`, `city_code`, `region_code`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (67, '123', 39.5749380, 116.8707560, '天津市武清区白古屯镇', '120114', '022', '武清区', 'admin', '2022-11-21 19:08:31', 'admin', '2022-11-21 19:08:31', NULL);
INSERT INTO `device_location` (`id`, `device_identification`, `latitude`, `longitude`, `full_name`, `province_code`, `city_code`, `region_code`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (68, '1ff64cb6d0a74903a508b5f0e88601a1', 39.8960900, 116.4103940, '北京市东城区前门街道奋章胡同', '110101', '010', '东城区', 'admin', '2022-11-24 20:59:45', 'admin', '2022-11-24 20:59:45', NULL);
INSERT INTO `device_location` (`id`, `device_identification`, `latitude`, `longitude`, `full_name`, `province_code`, `city_code`, `region_code`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (69, '1ff64cb6d0a74903a508b5f0e88601a3', 39.8978020, 116.4301350, '北京市东城区东花市街道东花市北里(西区)东花市北里西区', '110101', '010', '东城区', 'admin', '2022-11-27 11:41:39', 'admin', '2022-11-27 11:41:39', NULL);
INSERT INTO `device_location` (`id`, `device_identification`, `latitude`, `longitude`, `full_name`, `province_code`, `city_code`, `region_code`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (70, '1ff64cb6d0a74903a508b5f0e88601a6', 39.8949050, 116.3801810, '北京市西城区椿树街道南柳巷9号琉璃厂文化街', '110102', '010', '西城区', 'admin', '2022-11-27 11:42:58', 'admin', '2022-11-27 11:42:58', NULL);
INSERT INTO `device_location` (`id`, `device_identification`, `latitude`, `longitude`, `full_name`, `province_code`, `city_code`, `region_code`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (71, '1ff64cb6d0a74903a508b5f0e88601a4', 39.9045180, 116.4442110, '北京市朝阳区建外街道Kargo1号库永安南里宿舍区', '110105', '010', '朝阳区', 'admin', '2022-11-27 13:49:20', 'admin', '2022-11-27 13:49:20', NULL);
INSERT INTO `device_location` (`id`, `device_identification`, `latitude`, `longitude`, `full_name`, `province_code`, `city_code`, `region_code`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (72, '1ff64cb6d0a74903a508b5f0e88601a5', 39.8962220, 116.3894510, '北京市西城区大栅栏街道延寿街大栅栏街道文体活动中心', '110102', '010', '西城区', 'admin', '2022-11-27 13:50:37', 'admin', '2022-11-27 13:50:37', NULL);
INSERT INTO `device_location` (`id`, `device_identification`, `latitude`, `longitude`, `full_name`, `province_code`, `city_code`, `region_code`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (73, 'eysdevice', 34.6914560, 112.2716010, '河南省洛阳市新安县磁涧镇新安县胜达力车有限公司洛阳泰九农业机械有限公司', '410323', '0379', '410323', 'admin', '2022-12-07 14:52:28', 'admin', '2022-12-07 14:52:28', NULL);
INSERT INTO `device_location` (`id`, `device_identification`, `latitude`, `longitude`, `full_name`, `province_code`, `city_code`, `region_code`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (74, 'eysdevice', 34.6914560, 112.2716010, '河南省洛阳市新安县磁涧镇新安县胜达力车有限公司洛阳泰九农业机械有限公司', '410323', '0379', '新安县', 'admin', '2022-12-07 14:52:41', 'admin', '2022-12-07 15:40:34', NULL);
INSERT INTO `device_location` (`id`, `device_identification`, `latitude`, `longitude`, `full_name`, `province_code`, `city_code`, `region_code`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (75, '10001', 39.9099480, 116.3831220, '北京市西城区西长安街街道南海', '110102', '010', '西城区', 'admin', '2023-03-28 00:43:43', 'admin', '2023-03-28 00:43:43', NULL);
INSERT INTO `device_location` (`id`, `device_identification`, `latitude`, `longitude`, `full_name`, `province_code`, `city_code`, `region_code`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (80, '1', 39.9128750, 116.3775810, '北京市西城区西长安街街道罗家胡同北京市宏庙小学低年级部', '110102', '010', '西城区', 'admin', '2023-05-02 22:02:00', 'admin', '2023-05-02 22:02:00', NULL);
INSERT INTO `device_location` (`id`, `device_identification`, `latitude`, `longitude`, `full_name`, `province_code`, `city_code`, `region_code`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (81, '1002', 39.9180450, 116.4104610, '北京市东城区东华门街道王府井大街103号王府井步行街', '110101', '010', '东城区', 'admin', '2023-05-02 22:10:03', 'admin', '2023-05-02 22:10:03', NULL);
INSERT INTO `device_location` (`id`, `device_identification`, `latitude`, `longitude`, `full_name`, `province_code`, `city_code`, `region_code`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (82, '1234567890', 36.1101780, 111.5200550, '山西省临汾市尧都区滨河街道河汾一路3号康乐富健康大厦', '141002', '0357', '尧都区', 'admin', '2023-11-29 21:56:36', 'admin', '2024-01-15 11:02:57', NULL);
INSERT INTO `device_location` (`id`, `device_identification`, `latitude`, `longitude`, `full_name`, `province_code`, `city_code`, `region_code`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (83, 'device123', 22.8596040, 108.2792710, '广西壮族自治区南宁市西乡塘区心圩街道南宁·中关村创新示范基地', '450107', '0771', '西乡塘区', 'admin', '2023-12-08 18:36:41', 'admin', '2024-01-15 11:11:14', NULL);
INSERT INTO `device_location` (`id`, `device_identification`, `latitude`, `longitude`, `full_name`, `province_code`, `city_code`, `region_code`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (84, '4207313761001472', 45.7683680, 130.5667610, '黑龙江省七台河市勃利县城西街道大龙水泥公司亿达信能源有限公司', '230921', '0464', '230921', 'admin', '2024-03-28 11:01:14', 'admin', '2024-03-28 11:01:14', NULL);
INSERT INTO `device_location` (`id`, `device_identification`, `latitude`, `longitude`, `full_name`, `province_code`, `city_code`, `region_code`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (85, '4324406985433088', 44.4111370, 84.6966130, '新疆维吾尔自治区塔城地区乌苏市南苑街道兰新线乌阿段新疆金浩电力工程有限公司', '654202', '0901', '654202', 'admin', '2024-03-28 18:46:32', 'admin', '2024-03-28 18:46:32', NULL);
INSERT INTO `device_location` (`id`, `device_identification`, `latitude`, `longitude`, `full_name`, `province_code`, `city_code`, `region_code`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (88, '4324406985433088', 44.4111370, 84.6966130, '新疆维吾尔自治区塔城地区乌苏市南苑街道兰新线乌阿段新疆金浩电力工程有限公司', '654202', '0901', '654202', 'admin', '2024-03-28 19:00:39', 'admin', '2024-03-28 19:00:39', NULL);
INSERT INTO `device_location` (`id`, `device_identification`, `latitude`, `longitude`, `full_name`, `province_code`, `city_code`, `region_code`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (89, '4330045197234176', 39.9094030, 116.3620830, '北京市西城区金融街街道华荣公寓', '110102', '010', '西城区', 'admin', '2024-03-28 19:08:56', 'admin', '2024-03-28 19:08:56', NULL);
COMMIT;

-- ----------------------------
-- Table structure for device_topic
-- ----------------------------
DROP TABLE IF EXISTS `device_topic`;
CREATE TABLE `device_topic` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `device_identification` varchar(100) NOT NULL COMMENT '设备标识',
  `type` varchar(255) DEFAULT NULL COMMENT '类型(0:基础Topic,1:自定义Topic)',
  `topic` varchar(100) DEFAULT NULL COMMENT 'topic',
  `publisher` varchar(255) DEFAULT NULL COMMENT '发布者',
  `subscriber` varchar(255) DEFAULT NULL COMMENT '订阅者',
  `create_by` varchar(64) DEFAULT 'ununited' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=483 DEFAULT CHARSET=utf8 COMMENT='设备Topic数据表';

-- ----------------------------
-- Records of device_topic
-- ----------------------------
BEGIN;
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (399, '123', '0', '/v1/devices/123/commandResponse', '边设备', '物联网平台', 'admin', '2022-11-21 19:08:32', '', '2022-11-21 19:08:32', '边设备返回给物联网平台的命令响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (400, '123', '0', '/v1/devices/123/datas', '边设备', '物联网平台', 'admin', '2022-11-21 19:08:32', '', '2022-11-21 19:08:32', '边设备上报数据');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (401, '123', '0', '/v1/devices/123/command', '边设备', '物联网平台', 'admin', '2022-11-21 19:08:32', '', '2022-11-21 19:08:32', '物联网平台给设备或边设备下发命令');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (402, '1ff64cb6d0a74903a508b5f0e88601a1', '0', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a1/command', '边设备', '物联网平台', 'admin', '2022-11-24 20:59:47', '', '2022-11-24 20:59:47', '物联网平台给设备或边设备下发命令');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (403, '1ff64cb6d0a74903a508b5f0e88601a1', '0', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a1/datas', '边设备', '物联网平台', 'admin', '2022-11-24 20:59:47', '', '2022-11-24 20:59:47', '边设备上报数据');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (404, '1ff64cb6d0a74903a508b5f0e88601a1', '0', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a1/commandResponse', '边设备', '物联网平台', 'admin', '2022-11-24 20:59:47', '', '2022-11-24 20:59:47', '边设备返回给物联网平台的命令响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (405, '1ff64cb6d0a74903a508b5f0e88601a3', '0', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/datas', '边设备', '物联网平台', 'admin', '2022-11-27 11:41:42', '', '2022-11-27 11:41:42', '边设备上报数据');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (406, '1ff64cb6d0a74903a508b5f0e88601a3', '0', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/commandResponse', '边设备', '物联网平台', 'admin', '2022-11-27 11:41:42', '', '2022-11-27 11:41:42', '边设备返回给物联网平台的命令响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (407, '1ff64cb6d0a74903a508b5f0e88601a3', '0', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a3/command', '边设备', '物联网平台', 'admin', '2022-11-27 11:41:42', '', '2022-11-27 11:41:42', '物联网平台给设备或边设备下发命令');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (408, '1ff64cb6d0a74903a508b5f0e88601a6', '0', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/datas', '边设备', '物联网平台', 'admin', '2022-11-27 11:42:58', '', '2022-11-27 11:42:58', '边设备上报数据');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (409, '1ff64cb6d0a74903a508b5f0e88601a6', '0', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/command', '边设备', '物联网平台', 'admin', '2022-11-27 11:42:58', '', '2022-11-27 11:42:58', '物联网平台给设备或边设备下发命令');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (410, '1ff64cb6d0a74903a508b5f0e88601a6', '0', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a6/commandResponse', '边设备', '物联网平台', 'admin', '2022-11-27 11:42:58', '', '2022-11-27 11:42:58', '边设备返回给物联网平台的命令响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (411, '1ff64cb6d0a74903a508b5f0e88601a4', '0', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a4/command', '边设备', '物联网平台', 'admin', '2022-11-27 13:49:21', '', '2022-11-27 13:49:21', '物联网平台给设备或边设备下发命令');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (412, '1ff64cb6d0a74903a508b5f0e88601a4', '0', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a4/commandResponse', '边设备', '物联网平台', 'admin', '2022-11-27 13:49:21', '', '2022-11-27 13:49:21', '边设备返回给物联网平台的命令响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (413, '1ff64cb6d0a74903a508b5f0e88601a4', '0', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a4/datas', '边设备', '物联网平台', 'admin', '2022-11-27 13:49:21', '', '2022-11-27 13:49:21', '边设备上报数据');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (414, '1ff64cb6d0a74903a508b5f0e88601a5', '0', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a5/datas', '边设备', '物联网平台', 'admin', '2022-11-27 13:50:38', '', '2022-11-27 13:50:38', '边设备上报数据');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (415, '1ff64cb6d0a74903a508b5f0e88601a5', '0', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a5/command', '边设备', '物联网平台', 'admin', '2022-11-27 13:50:38', '', '2022-11-27 13:50:38', '物联网平台给设备或边设备下发命令');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (416, '1ff64cb6d0a74903a508b5f0e88601a5', '0', '/v1/devices/1ff64cb6d0a74903a508b5f0e88601a5/commandResponse', '边设备', '物联网平台', 'admin', '2022-11-27 13:50:38', '', '2022-11-27 13:50:38', '边设备返回给物联网平台的命令响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (417, 'eysdevice', '0', '/v1/devices/eysdevice/datas', '边设备', '物联网平台', 'admin', '2022-12-07 14:52:49', '', '2022-12-07 14:52:49', '边设备上报数据');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (418, 'eysdevice', '0', '/v1/devices/eysdevice/commandResponse', '边设备', '物联网平台', 'admin', '2022-12-07 14:52:49', '', '2022-12-07 14:52:49', '边设备返回给物联网平台的命令响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (419, 'eysdevice', '0', '/v1/devices/eysdevice/command', '边设备', '物联网平台', 'admin', '2022-12-07 14:52:49', '', '2022-12-07 14:52:49', '物联网平台给设备或边设备下发命令');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (420, 'eysdevice', '0', '/v1/devices/eysdevice/datas', '边设备', '物联网平台', 'admin', '2022-12-07 14:53:01', '', '2022-12-07 14:53:01', '边设备上报数据');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (421, 'eysdevice', '0', '/v1/devices/eysdevice/commandResponse', '边设备', '物联网平台', 'admin', '2022-12-07 14:53:01', '', '2022-12-07 14:53:01', '边设备返回给物联网平台的命令响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (422, 'eysdevice', '0', '/v1/devices/eysdevice/command', '边设备', '物联网平台', 'admin', '2022-12-07 14:53:02', '', '2022-12-07 14:53:02', '物联网平台给设备或边设备下发命令');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (423, '10001', '0', '/v1/devices/10001/command', '物联网平台', '边设备', 'admin', '2023-03-28 00:43:45', '', '2023-03-28 00:43:45', '物联网平台给设备或边设备下发命令');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (424, '10001', '0', '/v1/devices/10001/datas', '边设备', '物联网平台', 'admin', '2023-03-28 00:43:45', '', '2023-03-28 00:43:45', '边设备上报数据');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (425, '10001', '0', '/v1/devices/10001/commandResponse', '边设备', '物联网平台', 'admin', '2023-03-28 00:43:45', '', '2023-03-28 00:43:45', '边设备返回给物联网平台的命令响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (426, '1', '0', '/v1/devices/1/command', '物联网平台', '边设备', 'admin', '2023-05-02 22:02:12', '', '2023-05-02 22:02:12', '物联网平台给设备或边设备下发命令');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (427, '1', '0', '/v1/devices/1/commandResponse', '边设备', '物联网平台', 'admin', '2023-05-02 22:02:12', '', '2023-05-02 22:02:12', '边设备返回给物联网平台的命令响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (428, '1', '0', '/v1/devices/1/datas', '边设备', '物联网平台', 'admin', '2023-05-02 22:02:12', '', '2023-05-02 22:02:12', '边设备上报数据');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (429, '1002', '0', '/v1/devices/1002/datas', '边设备', '物联网平台', 'admin', '2023-05-02 22:10:03', '', '2023-05-02 22:10:03', '边设备上报数据');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (430, '1002', '0', '/v1/devices/1002/topo/delete', '边设备', '物联网平台', 'admin', '2023-05-02 22:10:03', '', '2023-05-02 22:10:03', '边设备删除子设备');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (431, '1002', '0', '/v1/devices/1002/topo/deleteResponse', '物联网平台', '边设备', 'admin', '2023-05-02 22:10:03', '', '2023-05-02 22:10:03', '物联网平台返回的删除子设备的响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (432, '1002', '0', '/v1/devices/1002/topo/update', '边设备', '物联网平台', 'admin', '2023-05-02 22:10:03', '', '2023-05-02 22:10:03', '边设备更新子设备状态');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (433, '1002', '0', '/v1/devices/1002/commandResponse', '边设备', '物联网平台', 'admin', '2023-05-02 22:10:03', '', '2023-05-02 22:10:03', '边设备返回给物联网平台的命令响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (434, '1002', '0', '/v1/devices/1002/topo/add', '边设备', '物联网平台', 'admin', '2023-05-02 22:10:03', '', '2023-05-02 22:10:03', '边设备添加子设备');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (435, '1002', '0', '/v1/devices/1002/topo/addResponse', '物联网平台', '边设备', 'admin', '2023-05-02 22:10:03', '', '2023-05-02 22:10:03', '物联网平台返回的添加子设备的响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (436, '1002', '0', '/v1/devices/1002/topo/updateResponse', '物联网平台', '边设备', 'admin', '2023-05-02 22:10:03', '', '2023-05-02 22:10:03', '物联网平台返回的更新子设备状态的响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (437, '1002', '0', '/v1/devices/1002/command', '物联网平台', '边设备', 'admin', '2023-05-02 22:10:03', '', '2023-05-02 22:10:03', '物联网平台给设备或边设备下发命令');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (438, '1234567890', '0', '/v1/devices/1234567890/command', '物联网平台', '边设备', 'hitelcom', '2023-11-29 21:56:37', '', '2023-11-29 21:56:37', '物联网平台给设备或边设备下发命令');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (439, '1234567890', '0', '/v1/devices/1234567890/commandResponse', '边设备', '物联网平台', 'hitelcom', '2023-11-29 21:56:37', '', '2023-11-29 21:56:37', '边设备返回给物联网平台的命令响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (440, '1234567890', '0', '/v1/devices/1234567890/datas', '边设备', '物联网平台', 'hitelcom', '2023-11-29 21:56:37', '', '2023-11-29 21:56:37', '边设备上报数据');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (441, 'device123', '0', '/v1/devices/device123/commandResponse', '边设备', '物联网平台', 'admin', '2023-12-08 18:36:41', '', '2023-12-08 18:36:41', '边设备返回给物联网平台的命令响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (442, 'device123', '0', '/v1/devices/device123/datas', '边设备', '物联网平台', 'admin', '2023-12-08 18:36:41', '', '2023-12-08 18:36:41', '边设备上报数据');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (443, 'device123', '0', '/v1/devices/device123/command', '物联网平台', '边设备', 'admin', '2023-12-08 18:36:42', '', '2023-12-08 18:36:42', '物联网平台给设备或边设备下发命令');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (444, '4207313761001472', '0', '/null/devices/4207313761001472/topo/otaPull', '边设备', '物联网平台', 'admin', '2024-03-28 11:01:14', '', '2024-03-28 11:01:14', '网关设备拉取物联网平台的最新软固件信息');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (445, '4207313761001472', '0', '/null/devices/4207313761001472/topo/addResponse', '物联网平台', '边设备', 'admin', '2024-03-28 11:01:14', '', '2024-03-28 11:01:14', '物联网平台返回的添加子设备的响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (446, '4207313761001472', '0', '/null/devices/4207313761001472/commandResponse', '边设备', '物联网平台', 'admin', '2024-03-28 11:01:15', '', '2024-03-28 11:01:15', '边设备返回给物联网平台的命令响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (447, '4207313761001472', '0', '/null/devices/4207313761001472/topo/deleteResponse', '物联网平台', '边设备', 'admin', '2024-03-28 11:01:15', '', '2024-03-28 11:01:15', '物联网平台返回的删除子设备的响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (448, '4207313761001472', '0', '/null/devices/4207313761001472/topo/delete', '边设备', '物联网平台', 'admin', '2024-03-28 11:01:15', '', '2024-03-28 11:01:15', '边设备删除子设备');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (449, '4207313761001472', '0', '/null/devices/4207313761001472/topo/update', '边设备', '物联网平台', 'admin', '2024-03-28 11:01:15', '', '2024-03-28 11:01:15', '边设备更新子设备状态');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (450, '4207313761001472', '0', '/null/devices/4207313761001472/topo/otaCommand', '边设备', '物联网平台', 'admin', '2024-03-28 11:01:15', '', '2024-03-28 11:01:15', '物联网平台给网关设备下发OTA远程升级命令');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (451, '4207313761001472', '0', '/null/devices/4207313761001472/topo/updateResponse', '物联网平台', '边设备', 'admin', '2024-03-28 11:01:15', '', '2024-03-28 11:01:15', '物联网平台返回的更新子设备状态的响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (452, '4207313761001472', '0', '/null/devices/4207313761001472/topo/otaReportResponse', '物联网平台', '边设备', 'admin', '2024-03-28 11:01:15', '', '2024-03-28 11:01:15', '物联网平台接收到上报软固件信息响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (453, '4207313761001472', '0', '/null/devices/4207313761001472/command', '物联网平台', '边设备', 'admin', '2024-03-28 11:01:15', '', '2024-03-28 11:01:15', '物联网平台给设备或边设备下发命令');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (454, '4207313761001472', '0', '/null/devices/4207313761001472/topo/otaCommandResponse', '物联网平台', '边设备', 'admin', '2024-03-28 11:01:15', '', '2024-03-28 11:01:15', '网关设备返回给物联网平台的OTA远程升级命令响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (455, '4207313761001472', '0', '/null/devices/4207313761001472/datas', '边设备', '物联网平台', 'admin', '2024-03-28 11:01:15', '', '2024-03-28 11:01:15', '边设备上报数据');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (456, '4207313761001472', '0', '/null/devices/4207313761001472/topo/otaRead', '边设备', '物联网平台', 'admin', '2024-03-28 11:01:15', '', '2024-03-28 11:01:15', '物联网平台读取设备软固件版本');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (457, '4207313761001472', '0', '/null/devices/4207313761001472/topo/otaReadResponse', '物联网平台', '边设备', 'admin', '2024-03-28 11:01:16', '', '2024-03-28 11:01:16', '网关设备回复物联网平台读取设备固件版本指令');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (458, '4207313761001472', '0', '/null/devices/4207313761001472/topo/otaReport', '边设备', '物联网平台', 'admin', '2024-03-28 11:01:16', '', '2024-03-28 11:01:16', '网关设备向物联网平台上报软固件版本');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (459, '4207313761001472', '0', '/null/devices/4207313761001472/topo/otaPullResponse', '物联网平台', '边设备', 'admin', '2024-03-28 11:01:16', '', '2024-03-28 11:01:16', '物联网平台响应软固件信息给设备');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (460, '4207313761001472', '0', '/null/devices/4207313761001472/topo/add', '边设备', '物联网平台', 'admin', '2024-03-28 11:01:16', '', '2024-03-28 11:01:16', '边设备添加子设备');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (461, '4324406985433088', '0', '/null/devices/4324406985433088/command', '物联网平台', '边设备', 'admin', '2024-03-28 18:46:32', '', '2024-03-28 18:46:32', '物联网平台给普通设备下发命令');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (462, '4324406985433088', '0', '/null/devices/4324406985433088/datas', '边设备', '物联网平台', 'admin', '2024-03-28 18:46:32', '', '2024-03-28 18:46:32', '普通设备上报数据');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (463, '4324406985433088', '0', '/null/devices/4324406985433088/topo/otaRead', '边设备', '物联网平台', 'admin', '2024-03-28 18:46:32', '', '2024-03-28 18:46:32', '物联网平台读取设备软固件版本');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (464, '4324406985433088', '0', '/null/devices/4324406985433088/topo/otaReport', '边设备', '物联网平台', 'admin', '2024-03-28 18:46:32', '', '2024-03-28 18:46:32', '普通设备向物联网平台上报软固件版本');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (465, '4324406985433088', '0', '/null/devices/4324406985433088/topo/otaReportResponse', '物联网平台', '边设备', 'admin', '2024-03-28 18:46:32', '', '2024-03-28 18:46:32', '物联网平台接收到上报软固件信息响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (466, '4324406985433088', '0', '/null/devices/4324406985433088/topo/otaCommand', '边设备', '物联网平台', 'admin', '2024-03-28 18:46:32', '', '2024-03-28 18:46:32', '物联网平台给普通设备下发OTA远程升级命令');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (467, '4324406985433088', '0', '/null/devices/4324406985433088/topo/otaCommandResponse', '物联网平台', '边设备', 'admin', '2024-03-28 18:46:32', '', '2024-03-28 18:46:32', '普通设备返回给物联网平台的OTA远程升级命令响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (468, '4324406985433088', '0', '/null/devices/4324406985433088/commandResponse', '边设备', '物联网平台', 'admin', '2024-03-28 18:46:32', '', '2024-03-28 18:46:32', '普通设备返回给物联网平台的命令响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (469, '4324406985433088', '0', '/null/devices/4324406985433088/topo/otaPull', '边设备', '物联网平台', 'admin', '2024-03-28 18:46:32', '', '2024-03-28 18:46:32', '普通设备拉取物联网平台的最新软固件信息');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (470, '4324406985433088', '0', '/null/devices/4324406985433088/topo/otaReadResponse', '物联网平台', '边设备', 'admin', '2024-03-28 18:46:32', '', '2024-03-28 18:46:32', '普通设备回复物联网平台读取设备固件版本指令');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (471, '4324406985433088', '0', '/null/devices/4324406985433088/topo/otaPullResponse', '物联网平台', '边设备', 'admin', '2024-03-28 18:46:32', '', '2024-03-28 18:46:32', '物联网平台响应软固件信息给普通设备');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (472, '4330045197234176', '0', '/v1/devices/4330045197234176/topo/otaRead', '边设备', '物联网平台', 'admin', '2024-03-28 19:08:56', '', '2024-03-28 19:08:56', '物联网平台读取设备软固件版本');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (473, '4330045197234176', '0', '/v1/devices/4330045197234176/datas', '边设备', '物联网平台', 'admin', '2024-03-28 19:08:56', '', '2024-03-28 19:08:56', '普通设备上报数据');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (474, '4330045197234176', '0', '/v1/devices/4330045197234176/command', '物联网平台', '边设备', 'admin', '2024-03-28 19:08:56', '', '2024-03-28 19:08:56', '物联网平台给普通设备下发命令');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (475, '4330045197234176', '0', '/v1/devices/4330045197234176/topo/otaCommandResponse', '物联网平台', '边设备', 'admin', '2024-03-28 19:08:57', '', '2024-03-28 19:08:57', '普通设备返回给物联网平台的OTA远程升级命令响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (476, '4330045197234176', '0', '/v1/devices/4330045197234176/topo/otaPull', '边设备', '物联网平台', 'admin', '2024-03-28 19:08:57', '', '2024-03-28 19:08:57', '普通设备拉取物联网平台的最新软固件信息');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (477, '4330045197234176', '0', '/v1/devices/4330045197234176/topo/otaPullResponse', '物联网平台', '边设备', 'admin', '2024-03-28 19:08:57', '', '2024-03-28 19:08:57', '物联网平台响应软固件信息给普通设备');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (478, '4330045197234176', '0', '/v1/devices/4330045197234176/topo/otaReportResponse', '物联网平台', '边设备', 'admin', '2024-03-28 19:08:57', '', '2024-03-28 19:08:57', '物联网平台接收到上报软固件信息响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (479, '4330045197234176', '0', '/v1/devices/4330045197234176/topo/otaReport', '边设备', '物联网平台', 'admin', '2024-03-28 19:08:57', '', '2024-03-28 19:08:57', '普通设备向物联网平台上报软固件版本');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (480, '4330045197234176', '0', '/v1/devices/4330045197234176/commandResponse', '边设备', '物联网平台', 'admin', '2024-03-28 19:08:57', '', '2024-03-28 19:08:57', '普通设备返回给物联网平台的命令响应');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (481, '4330045197234176', '0', '/v1/devices/4330045197234176/topo/otaReadResponse', '物联网平台', '边设备', 'admin', '2024-03-28 19:08:57', '', '2024-03-28 19:08:57', '普通设备回复物联网平台读取设备固件版本指令');
INSERT INTO `device_topic` (`id`, `device_identification`, `type`, `topic`, `publisher`, `subscriber`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (482, '4330045197234176', '0', '/v1/devices/4330045197234176/topo/otaCommand', '边设备', '物联网平台', 'admin', '2024-03-28 19:08:57', '', '2024-03-28 19:08:57', '物联网平台给普通设备下发OTA远程升级命令');
COMMIT;

-- ----------------------------
-- Table structure for gen_table
-- ----------------------------
DROP TABLE IF EXISTS `gen_table`;
CREATE TABLE `gen_table` (
  `table_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_name` varchar(200) DEFAULT '' COMMENT '表名称',
  `table_comment` varchar(500) DEFAULT '' COMMENT '表描述',
  `sub_table_name` varchar(64) DEFAULT NULL COMMENT '关联子表的表名',
  `sub_table_fk_name` varchar(64) DEFAULT NULL COMMENT '子表关联的外键名',
  `class_name` varchar(100) DEFAULT '' COMMENT '实体类名称',
  `tpl_category` varchar(200) DEFAULT 'crud' COMMENT '使用的模板（crud单表操作 tree树表操作）',
  `package_name` varchar(100) DEFAULT NULL COMMENT '生成包路径',
  `module_name` varchar(30) DEFAULT NULL COMMENT '生成模块名',
  `business_name` varchar(30) DEFAULT NULL COMMENT '生成业务名',
  `function_name` varchar(50) DEFAULT NULL COMMENT '生成功能名',
  `function_author` varchar(50) DEFAULT NULL COMMENT '生成功能作者',
  `gen_type` char(1) DEFAULT '0' COMMENT '生成代码方式（0zip压缩包 1自定义路径）',
  `gen_path` varchar(200) DEFAULT '/' COMMENT '生成路径（不填默认项目路径）',
  `options` varchar(1000) DEFAULT NULL COMMENT '其它生成选项',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`table_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COMMENT='代码生成业务表';

-- ----------------------------
-- Records of gen_table
-- ----------------------------
BEGIN;
INSERT INTO `gen_table` (`table_id`, `table_name`, `table_comment`, `sub_table_name`, `sub_table_fk_name`, `class_name`, `tpl_category`, `package_name`, `module_name`, `business_name`, `function_name`, `function_author`, `gen_type`, `gen_path`, `options`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (3, 'device', '设备管理', '', '', 'Device', 'crud', 'com.mqttsnet.thinglinks.link', 'link', 'device', '设备管理', 'thinglinks', '0', '/', '{\"treeCode\":\"id\",\"parentMenuId\":1061}', 'thinglinks', '2021-12-28 10:51:40', '', '2021-12-28 11:04:26', NULL);
INSERT INTO `gen_table` (`table_id`, `table_name`, `table_comment`, `sub_table_name`, `sub_table_fk_name`, `class_name`, `tpl_category`, `package_name`, `module_name`, `business_name`, `function_name`, `function_author`, `gen_type`, `gen_path`, `options`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (4, 'product', '产品管理', NULL, NULL, 'Product', 'crud', 'com.mqttsnet.thinglinks.link', 'link', 'product', '产品管理', 'thinglinks', '0', '/', '{\"parentMenuId\":1061}', 'admin', '2022-02-09 16:13:45', '', '2022-02-09 16:52:41', NULL);
INSERT INTO `gen_table` (`table_id`, `table_name`, `table_comment`, `sub_table_name`, `sub_table_fk_name`, `class_name`, `tpl_category`, `package_name`, `module_name`, `business_name`, `function_name`, `function_author`, `gen_type`, `gen_path`, `options`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (5, 'device_info', '子设备档案表', '', '', 'DeviceInfo', 'crud', 'com.mqttsnet.thinglinks.link', 'link', 'deviceInfo', '子设备管理', 'thinglinks', '0', '/', '{\"treeCode\":\"d_id\",\"treeName\":\"d_id\",\"treeParentCode\":\"d_id\",\"parentMenuId\":\"1076\"}', 'admin', '2022-05-09 15:38:08', '', '2022-06-21 14:32:37', NULL);
INSERT INTO `gen_table` (`table_id`, `table_name`, `table_comment`, `sub_table_name`, `sub_table_fk_name`, `class_name`, `tpl_category`, `package_name`, `module_name`, `business_name`, `function_name`, `function_author`, `gen_type`, `gen_path`, `options`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (7, 'casbin_rule', 'CAS规则策略配置表', NULL, NULL, 'CasbinRule', 'crud', 'com.mqttsnet.thinglinks.link', 'link', 'casbinRule', 'CAS规则管理', 'thinglinks', '0', '/', '{\"parentMenuId\":\"1061\"}', 'admin', '2022-06-16 17:19:58', '', '2022-06-17 11:09:44', NULL);
INSERT INTO `gen_table` (`table_id`, `table_name`, `table_comment`, `sub_table_name`, `sub_table_fk_name`, `class_name`, `tpl_category`, `package_name`, `module_name`, `business_name`, `function_name`, `function_author`, `gen_type`, `gen_path`, `options`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (8, 'device_topic', '设备Topic数据表', '', '', 'DeviceTopic', 'crud', 'com.mqttsnet.thinglinks.link', 'link', 'topic', '设备Topic数据', 'thinglinks', '0', '/', '{\"treeCode\":\"device_identification\",\"parentMenuId\":1076}', 'admin', '2022-06-17 16:41:13', '', '2022-06-17 16:57:24', NULL);
INSERT INTO `gen_table` (`table_id`, `table_name`, `table_comment`, `sub_table_name`, `sub_table_fk_name`, `class_name`, `tpl_category`, `package_name`, `module_name`, `business_name`, `function_name`, `function_author`, `gen_type`, `gen_path`, `options`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (9, 'device_action', '设备动作数据', NULL, NULL, 'DeviceAction', 'crud', 'com.mqttsnet.thinglinks.link', 'link', 'action', '设备动作数据', 'thinglinks', '0', '/', '{\"parentMenuId\":\"1076\"}', 'admin', '2022-06-17 17:38:20', '', '2022-06-17 17:46:18', NULL);
INSERT INTO `gen_table` (`table_id`, `table_name`, `table_comment`, `sub_table_name`, `sub_table_fk_name`, `class_name`, `tpl_category`, `package_name`, `module_name`, `business_name`, `function_name`, `function_author`, `gen_type`, `gen_path`, `options`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (10, 'device_location', '设备位置表', NULL, NULL, 'DeviceLocation', 'crud', 'com.mqttsnet.thinglinks.link', 'link', 'device_location', '设备位置', 'lvwshuai', '0', '/', '{\"parentMenuId\":\"1062\"}', 'admin', '2022-06-30 16:54:17', '', '2022-06-30 16:58:36', NULL);
INSERT INTO `gen_table` (`table_id`, `table_name`, `table_comment`, `sub_table_name`, `sub_table_fk_name`, `class_name`, `tpl_category`, `package_name`, `module_name`, `business_name`, `function_name`, `function_author`, `gen_type`, `gen_path`, `options`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (11, 'product_template', '产品模板', NULL, NULL, 'ProductTemplate', 'crud', 'com.mqttsnet.thinglinks.link', 'link', 'product_template', '产品模板', 'thinglinks', '0', '/', '{\"parentMenuId\":1061}', 'admin', '2022-06-30 20:03:00', '', '2022-07-08 18:33:57', NULL);
INSERT INTO `gen_table` (`table_id`, `table_name`, `table_comment`, `sub_table_name`, `sub_table_fk_name`, `class_name`, `tpl_category`, `package_name`, `module_name`, `business_name`, `function_name`, `function_author`, `gen_type`, `gen_path`, `options`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (12, 'protocol', '协议信息表', NULL, NULL, 'Protocol', 'crud', 'com.mqttsnet.thinglinks.link', 'link', 'protocol', '协议管理', 'thinglinks', '0', '/', '{\"parentMenuId\":\"1061\"}', 'admin', '2022-07-04 09:05:19', '', '2022-07-04 11:21:13', '协议管理');
INSERT INTO `gen_table` (`table_id`, `table_name`, `table_comment`, `sub_table_name`, `sub_table_fk_name`, `class_name`, `tpl_category`, `package_name`, `module_name`, `business_name`, `function_name`, `function_author`, `gen_type`, `gen_path`, `options`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (13, 'rule', '规则信息表', NULL, NULL, 'Rule', 'crud', 'com.mqttsnet.thinglinks.rule', 'link', 'rule', '规则信息', 'thinglinks', '0', '/', NULL, 'admin', '2022-07-15 17:47:01', '', '2022-11-29 21:23:25', NULL);
INSERT INTO `gen_table` (`table_id`, `table_name`, `table_comment`, `sub_table_name`, `sub_table_fk_name`, `class_name`, `tpl_category`, `package_name`, `module_name`, `business_name`, `function_name`, `function_author`, `gen_type`, `gen_path`, `options`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (14, 'rule_conditions', '规则触发条件表', NULL, NULL, 'RuleConditions', 'crud', 'com.mqttsnet.thinglinks.rule', 'rule', 'rule_conditions', '触发条件', 'thinglinks', '0', '/', NULL, 'admin', '2022-11-29 21:23:17', '', '2022-11-29 21:24:51', NULL);
COMMIT;

-- ----------------------------
-- Table structure for gen_table_column
-- ----------------------------
DROP TABLE IF EXISTS `gen_table_column`;
CREATE TABLE `gen_table_column` (
  `column_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_id` varchar(64) DEFAULT NULL COMMENT '归属表编号',
  `column_name` varchar(200) DEFAULT NULL COMMENT '列名称',
  `column_comment` varchar(500) DEFAULT NULL COMMENT '列描述',
  `column_type` varchar(100) DEFAULT NULL COMMENT '列类型',
  `java_type` varchar(500) DEFAULT NULL COMMENT 'JAVA类型',
  `java_field` varchar(200) DEFAULT NULL COMMENT 'JAVA字段名',
  `is_pk` char(1) DEFAULT NULL COMMENT '是否主键（1是）',
  `is_increment` char(1) DEFAULT NULL COMMENT '是否自增（1是）',
  `is_required` char(1) DEFAULT NULL COMMENT '是否必填（1是）',
  `is_insert` char(1) DEFAULT NULL COMMENT '是否为插入字段（1是）',
  `is_edit` char(1) DEFAULT NULL COMMENT '是否编辑字段（1是）',
  `is_list` char(1) DEFAULT NULL COMMENT '是否列表字段（1是）',
  `is_query` char(1) DEFAULT NULL COMMENT '是否查询字段（1是）',
  `query_type` varchar(200) DEFAULT 'EQ' COMMENT '查询方式（等于、不等于、大于、小于、范围）',
  `html_type` varchar(200) DEFAULT NULL COMMENT '显示类型（文本框、文本域、下拉框、复选框、单选框、日期控件）',
  `dict_type` varchar(200) DEFAULT '' COMMENT '字典类型',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`column_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=189 DEFAULT CHARSET=utf8 COMMENT='代码生成业务表字段';

-- ----------------------------
-- Records of gen_table_column
-- ----------------------------
BEGIN;
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (49, '3', 'id', 'id', 'bigint(19)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'thinglinks', '2021-12-28 10:51:40', '', '2021-12-28 11:04:26');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (50, '3', 'client_id', '客户端标识', 'varchar(255)', 'String', 'clientId', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'thinglinks', '2021-12-28 10:51:40', '', '2021-12-28 11:04:26');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (51, '3', 'user_name', '用户名', 'varchar(255)', 'String', 'userName', '0', '0', '1', '1', '1', '1', NULL, 'LIKE', 'input', '', 3, 'thinglinks', '2021-12-28 10:51:40', '', '2021-12-28 11:04:26');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (52, '3', 'password', '密码', 'varchar(255)', 'String', 'password', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'thinglinks', '2021-12-28 10:51:40', '', '2021-12-28 11:04:26');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (53, '3', 'app_id', '应用ID', 'varchar(64)', 'String', 'appId', '0', '0', '1', '1', '1', NULL, NULL, 'EQ', 'input', '', 5, 'thinglinks', '2021-12-28 10:51:40', '', '2021-12-28 11:04:26');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (54, '3', 'auth_mode', '认证方式', 'varchar(255)', 'String', 'authMode', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', 'link_device_auth_mode', 6, 'thinglinks', '2021-12-28 10:51:40', '', '2021-12-28 11:04:26');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (55, '3', 'device_identification', '设备标识', 'varchar(100)', 'String', 'deviceIdentification', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 7, 'thinglinks', '2021-12-28 10:51:40', '', '2021-12-28 11:04:26');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (56, '3', 'device_name', '设备名称', 'varchar(255)', 'String', 'deviceName', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 8, 'thinglinks', '2021-12-28 10:51:40', '', '2021-12-28 11:04:26');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (57, '3', 'connector', '连接实例', 'varchar(255)', 'String', 'connector', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', 'link_device_connector', 9, 'thinglinks', '2021-12-28 10:51:40', '', '2021-12-28 11:04:26');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (58, '3', 'device_description', '设备描述', 'varchar(255)', 'String', 'deviceDescription', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 10, 'thinglinks', '2021-12-28 10:51:40', '', '2021-12-28 11:04:26');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (59, '3', 'device_status', '设备状态', 'varchar(255)', 'String', 'deviceStatus', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'radio', 'link_device_status', 11, 'thinglinks', '2021-12-28 10:51:41', '', '2021-12-28 11:04:26');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (60, '3', 'connect_status', '连接状态', 'varchar(255)', 'String', 'connectStatus', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'radio', 'link_device_connect_status', 12, 'thinglinks', '2021-12-28 10:51:41', '', '2021-12-28 11:04:26');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (61, '3', 'is_will', '是否遗言', 'varchar(255)', 'String', 'isWill', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', 'link_device_is_will', 13, 'thinglinks', '2021-12-28 10:51:41', '', '2021-12-28 11:04:27');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (62, '3', 'device_tags', '设备标签', 'varchar(255)', 'String', 'deviceTags', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 14, 'thinglinks', '2021-12-28 10:51:41', '', '2021-12-28 11:04:27');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (63, '3', 'product_id', '产品型号', 'varchar(255)', 'String', 'productId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 15, 'thinglinks', '2021-12-28 10:51:41', '', '2021-12-28 11:04:27');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (64, '3', 'manufacturer_id', '厂商ID', 'varchar(255)', 'String', 'manufacturerId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 16, 'thinglinks', '2021-12-28 10:51:41', '', '2021-12-28 11:04:27');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (65, '3', 'protocol_type', '产品协议类型', 'varchar(255)', 'String', 'protocolType', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'link_device_protocol_type', 17, 'thinglinks', '2021-12-28 10:51:41', '', '2021-12-28 11:04:27');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (66, '3', 'device_type', '设备类型', 'varchar(255)', 'String', 'deviceType', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'link_device_device_type', 18, 'thinglinks', '2021-12-28 10:51:41', '', '2021-12-28 11:04:27');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (67, '3', 'create_by', '创建者', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, '1', NULL, 'EQ', 'input', '', 19, 'thinglinks', '2021-12-28 10:51:41', '', '2021-12-28 11:04:27');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (68, '3', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, '1', '1', 'EQ', 'datetime', '', 20, 'thinglinks', '2021-12-28 10:51:41', '', '2021-12-28 11:04:27');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (69, '3', 'update_by', '更新者', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 21, 'thinglinks', '2021-12-28 10:51:41', '', '2021-12-28 11:04:27');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (70, '3', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 22, 'thinglinks', '2021-12-28 10:51:42', '', '2021-12-28 11:04:27');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (71, '3', 'remark', '备注', 'varchar(500)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 23, 'thinglinks', '2021-12-28 10:51:42', '', '2021-12-28 11:04:27');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (72, '4', 'id', 'id', 'bigint(19)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2022-02-09 16:13:46', '', '2022-02-09 16:52:41');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (73, '4', 'app_id', '应用ID', 'varchar(64)', 'String', 'appId', '0', '0', '1', '1', NULL, '1', NULL, 'EQ', 'select', 'link_application_type', 2, 'admin', '2022-02-09 16:13:46', '', '2022-02-09 16:52:41');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (74, '4', 'template_id', '产品模型模板', 'bigint(19)', 'Long', 'templateId', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 3, 'admin', '2022-02-09 16:13:46', '', '2022-02-09 16:52:41');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (75, '4', 'product_name', '产品名称:自定义，支持中文、英文大小写、数字、下划线和中划线', 'varchar(255)', 'String', 'productName', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2022-02-09 16:13:46', '', '2022-02-09 16:52:41');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (76, '4', 'product_identification', '产品标识', 'varchar(100)', 'String', 'productIdentification', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 5, 'admin', '2022-02-09 16:13:46', '', '2022-02-09 16:52:41');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (77, '4', 'product_type', '支持以下两种产品类型•0：普通产品，需直连设备。\r\n•1：网关产品，可挂载子设备。\r\n', 'varchar(255)', 'String', 'productType', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'select', 'link_device_device_type', 6, 'admin', '2022-02-09 16:13:46', '', '2022-02-09 16:52:41');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (78, '4', 'manufacturer_id', '厂商ID:支持英文大小写，数字，下划线和中划线', 'varchar(255)', 'String', 'manufacturerId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2022-02-09 16:13:46', '', '2022-02-09 16:52:41');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (79, '4', 'manufacturer_name', '厂商名称 :支持中文、英文大小写、数字、下划线和中划线', 'varchar(255)', 'String', 'manufacturerName', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 8, 'admin', '2022-02-09 16:13:46', '', '2022-02-09 16:52:41');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (80, '4', 'model', '产品型号，建议包含字母或数字来保证可扩展性。支持英文大小写、数字、下划线和中划线\r\n', 'varchar(255)', 'String', 'model', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2022-02-09 16:13:46', '', '2022-02-09 16:52:42');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (81, '4', 'data_format', '数据格式，默认为JSON无需修改。', 'varchar(255)', 'String', 'dataFormat', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 10, 'admin', '2022-02-09 16:13:46', '', '2022-02-09 16:52:42');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (82, '4', 'device_type', '设备类型:支持英文大小写、数字、下划线和中划线\r\n', 'varchar(255)', 'String', 'deviceType', '0', '0', '1', '1', NULL, '1', NULL, 'EQ', 'select', 'link_protocol_device_type', 11, 'admin', '2022-02-09 16:13:46', '', '2022-02-09 16:52:42');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (83, '4', 'protocol_type', '设备接入平台的协议类型，默认为MQTT无需修改。\r\n ', 'varchar(255)', 'String', 'protocolType', '0', '0', '1', '1', NULL, '1', NULL, 'EQ', 'select', 'link_device_protocol_type', 12, 'admin', '2022-02-09 16:13:46', '', '2022-02-09 16:52:42');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (84, '4', 'status', '状态(字典值：启用  停用)', 'varchar(10)', 'String', 'status', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'select', 'sys_normal_disable', 13, 'admin', '2022-02-09 16:13:46', '', '2022-02-09 16:52:42');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (85, '4', 'remark', '产品描述', 'varchar(255)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 14, 'admin', '2022-02-09 16:13:47', '', '2022-02-09 16:52:42');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (86, '4', 'create_by', '创建者', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 15, 'admin', '2022-02-09 16:13:47', '', '2022-02-09 16:52:42');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (87, '4', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 16, 'admin', '2022-02-09 16:13:47', '', '2022-02-09 16:52:42');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (88, '4', 'update_by', '更新者', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 17, 'admin', '2022-02-09 16:13:47', '', '2022-02-09 16:52:42');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (89, '4', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 18, 'admin', '2022-02-09 16:13:47', '', '2022-02-09 16:52:42');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (90, '5', 'id', '主键', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2022-05-09 15:38:08', '', '2022-06-21 14:32:37');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (91, '5', 'd_id', '边设备', 'bigint(20)', 'Long', 'dId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2022-05-09 15:38:08', '', '2022-06-21 14:32:37');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (92, '5', 'app_id', '应用ID', 'varchar(64)', 'String', 'appId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2022-05-09 15:38:08', '', '2022-06-21 14:32:37');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (93, '5', 'node_id', '设备唯一标识', 'varchar(256)', 'String', 'nodeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2022-05-09 15:38:08', '', '2022-06-21 14:32:37');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (94, '5', 'node_name', '设备名称', 'varchar(256)', 'String', 'nodeName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2022-05-09 15:38:08', '', '2022-06-21 14:32:37');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (95, '5', 'device_id', '子设备标识', 'varchar(256)', 'String', 'deviceId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2022-05-09 15:38:09', '', '2022-06-21 14:32:37');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (96, '5', 'description', '设备描述', 'varchar(256)', 'String', 'description', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2022-05-09 15:38:09', '', '2022-06-21 14:32:37');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (97, '5', 'manufacturer_id', '厂商ID', 'varchar(256)', 'String', 'manufacturerId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2022-05-09 15:38:09', '', '2022-06-21 14:32:37');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (98, '5', 'model', '设备型号', 'varchar(256)', 'String', 'model', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2022-05-09 15:38:09', '', '2022-06-21 14:32:38');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (99, '5', 'connect_status', '连接状态 : 在线：ONLINE || 离线：OFFLINE || 未连接：INIT', 'varchar(20)', 'String', 'connectStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'link_device_connect_status', 10, 'admin', '2022-05-09 15:38:09', '', '2022-06-21 14:32:38');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (100, '5', 'shadow_enable', '是否支持设备影子', 'tinyint(1)', 'Integer', 'shadowEnable', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'link_deviceInfo_shadow_enable', 11, 'admin', '2022-05-09 15:38:09', '', '2022-06-21 14:32:38');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (101, '5', 'shadow_table_name', '设备影子数据表名', 'varchar(2048)', 'String', 'shadowTableName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 12, 'admin', '2022-05-09 15:38:09', '', '2022-06-21 14:32:38');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (102, '5', 'status', '状态(字典值：0启用  1停用)', 'varchar(10)', 'String', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'business_data_status', 13, 'admin', '2022-05-09 15:38:09', '', '2022-06-21 14:32:38');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (103, '5', 'create_by', '创建者', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 14, 'admin', '2022-05-09 15:38:09', '', '2022-06-21 14:32:38');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (104, '5', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 15, 'admin', '2022-05-09 15:38:09', '', '2022-06-21 14:32:38');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (105, '5', 'update_by', '更新者', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 16, 'admin', '2022-05-09 15:38:09', '', '2022-06-21 14:32:38');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (106, '5', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 17, 'admin', '2022-05-09 15:38:09', '', '2022-06-21 14:32:38');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (107, '5', 'remark', '备注', 'varchar(500)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 18, 'admin', '2022-05-09 15:38:09', '', '2022-06-21 14:32:39');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (116, '7', 'id', 'id', 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2022-06-16 17:19:58', '', '2022-06-17 11:09:44');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (117, '7', 'ptype', '类型', 'varchar(100)', 'String', 'ptype', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'link_device_protocol_type', 2, 'admin', '2022-06-16 17:19:58', '', '2022-06-17 11:09:45');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (118, '7', 'v0', '规则名称', 'varchar(100)', 'String', 'v0', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2022-06-16 17:19:58', '', '2022-06-17 11:09:45');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (119, '7', 'v1', '资源', 'varchar(100)', 'String', 'v1', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2022-06-16 17:19:58', '', '2022-06-17 11:09:45');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (120, '7', 'v2', '动作', 'varchar(100)', 'String', 'v2', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'link_casbinRule_v2', 5, 'admin', '2022-06-16 17:19:58', '', '2022-06-17 11:09:45');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (121, '7', 'v3', '策略', 'varchar(100)', 'String', 'v3', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'link_casbinRule_v3', 6, 'admin', '2022-06-16 17:19:58', '', '2022-06-17 11:09:45');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (122, '7', 'v4', NULL, 'varchar(100)', 'String', 'v4', '0', '0', NULL, NULL, NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2022-06-16 17:19:58', '', '2022-06-17 11:09:45');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (123, '7', 'v5', NULL, 'varchar(100)', 'String', 'v5', '0', '0', NULL, NULL, NULL, NULL, NULL, 'EQ', 'input', '', 8, 'admin', '2022-06-16 17:19:58', '', '2022-06-17 11:09:45');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (124, '8', 'id', 'id', 'bigint(19)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2022-06-17 16:41:14', '', '2022-06-17 16:57:24');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (125, '8', 'device_identification', '设备标识', 'varchar(100)', 'String', 'deviceIdentification', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2022-06-17 16:41:14', '', '2022-06-17 16:57:24');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (126, '8', 'type', '类型(0:基础Topic,1:自定义Topic)', 'varchar(255)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 3, 'admin', '2022-06-17 16:41:14', '', '2022-06-17 16:57:24');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (127, '8', 'topic', 'topic', 'varchar(100)', 'String', 'topic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2022-06-17 16:41:14', '', '2022-06-17 16:57:24');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (128, '8', 'publisher', '发布者', 'varchar(255)', 'String', 'publisher', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2022-06-17 16:41:14', '', '2022-06-17 16:57:24');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (129, '8', 'subscriber', '订阅者', 'varchar(255)', 'String', 'subscriber', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2022-06-17 16:41:14', '', '2022-06-17 16:57:24');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (130, '8', 'create_by', '创建者', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2022-06-17 16:41:14', '', '2022-06-17 16:57:24');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (131, '8', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2022-06-17 16:41:14', '', '2022-06-17 16:57:25');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (132, '8', 'update_by', '更新者', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 9, 'admin', '2022-06-17 16:41:14', '', '2022-06-17 16:57:25');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (133, '8', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 10, 'admin', '2022-06-17 16:41:14', '', '2022-06-17 16:57:25');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (134, '8', 'remark', '备注', 'varchar(500)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 11, 'admin', '2022-06-17 16:41:15', '', '2022-06-17 16:57:25');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (135, '9', 'id', 'id', 'bigint(19)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2022-06-17 17:38:20', '', '2022-06-17 17:46:18');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (136, '9', 'device_identification', '设备标识', 'varchar(255)', 'String', 'deviceIdentification', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2022-06-17 17:38:20', '', '2022-06-17 17:46:18');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (137, '9', 'action_type', '动作类型', 'varchar(255)', 'String', 'actionType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'link_device_action_type', 3, 'admin', '2022-06-17 17:38:21', '', '2022-06-17 17:46:18');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (138, '9', 'message', '内容信息', 'longtext', 'String', 'message', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 4, 'admin', '2022-06-17 17:38:21', '', '2022-06-17 17:46:18');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (139, '9', 'status', '状态', 'varchar(255)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 5, 'admin', '2022-06-17 17:38:21', '', '2022-06-17 17:46:18');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (140, '9', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2022-06-17 17:38:21', '', '2022-06-17 17:46:19');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (141, '10', 'id', '主键', 'bigint(19)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2022-06-30 16:54:17', '', '2022-06-30 16:58:36');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (142, '10', 'device_identification', '设备标识', 'varchar(100)', 'String', 'deviceIdentification', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2022-06-30 16:54:17', '', '2022-06-30 16:58:36');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (143, '10', 'latitude', '纬度', 'decimal(10,7)', 'BigDecimal', 'latitude', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2022-06-30 16:54:17', '', '2022-06-30 16:58:36');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (144, '10', 'longitude', '经度', 'decimal(10,7)', 'BigDecimal', 'longitude', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2022-06-30 16:54:17', '', '2022-06-30 16:58:36');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (145, '10', 'full_name', '位置名称', 'varchar(500)', 'String', 'fullName', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'textarea', '', 5, 'admin', '2022-06-30 16:54:17', '', '2022-06-30 16:58:36');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (146, '10', 'province_code', '省,直辖市编码', 'varchar(50)', 'String', 'provinceCode', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2022-06-30 16:54:17', '', '2022-06-30 16:58:36');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (147, '10', 'city_code', '市编码', 'varchar(50)', 'String', 'cityCode', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2022-06-30 16:54:17', '', '2022-06-30 16:58:36');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (148, '10', 'region_code', '区县', 'varchar(50)', 'String', 'regionCode', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2022-06-30 16:54:17', '', '2022-06-30 16:58:36');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (149, '10', 'create_by', '创建者', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 9, 'admin', '2022-06-30 16:54:17', '', '2022-06-30 16:58:37');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (150, '10', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 10, 'admin', '2022-06-30 16:54:17', '', '2022-06-30 16:58:37');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (151, '10', 'update_by', '更新者', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 11, 'admin', '2022-06-30 16:54:17', '', '2022-06-30 16:58:37');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (152, '10', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 12, 'admin', '2022-06-30 16:54:17', '', '2022-06-30 16:58:37');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (153, '10', 'remark', '备注', 'varchar(500)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 13, 'admin', '2022-06-30 16:54:17', '', '2022-06-30 16:58:37');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (154, '11', 'id', 'id', 'bigint(19)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2022-06-30 20:03:00', '', '2022-07-08 18:33:58');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (155, '11', 'app_id', '应用ID', 'varchar(64)', 'String', 'appId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2022-06-30 20:03:01', '', '2022-07-08 18:33:58');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (156, '11', 'template_name', '产品模板名称:自定义，支持中文、英文大小写、数字、下划线和中划线', 'varchar(255)', 'String', 'templateName', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2022-06-30 20:03:01', '', '2022-07-08 18:33:58');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (157, '11', 'status', '状态(字典值：启用  停用)', 'varchar(10)', 'String', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'radio', '', 4, 'admin', '2022-06-30 20:03:01', '', '2022-07-08 18:33:58');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (158, '11', 'remark', '产品模型模板描述', 'varchar(255)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2022-06-30 20:03:01', '', '2022-07-08 18:33:58');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (159, '11', 'create_by', '创建者', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2022-06-30 20:03:01', '', '2022-07-08 18:33:58');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (160, '11', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2022-06-30 20:03:01', '', '2022-07-08 18:33:58');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (161, '11', 'update_by', '更新者', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 8, 'admin', '2022-06-30 20:03:01', '', '2022-07-08 18:33:58');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (162, '11', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 9, 'admin', '2022-06-30 20:03:01', '', '2022-07-08 18:33:58');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (163, '12', 'id', 'id', 'bigint(19)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2022-07-04 09:05:19', '', '2022-07-04 11:21:13');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (164, '12', 'product_identification', '产品标识', 'varchar(100)', 'String', 'productIdentification', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2022-07-04 09:05:19', '', '2022-07-04 11:21:13');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (165, '12', 'protocol_name', '协议名称', 'varchar(255)', 'String', 'protocolName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2022-07-04 09:05:19', '', '2022-07-04 11:21:13');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (166, '12', 'protocol_identification', '协议标识', 'varchar(255)', 'String', 'protocolIdentification', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2022-07-04 09:05:19', '', '2022-07-04 11:21:13');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (167, '12', 'protocol_version', '协议版本', 'varchar(255)', 'String', 'protocolVersion', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2022-07-04 09:05:19', '', '2022-07-04 11:21:13');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (168, '12', 'protocol_type', '协议类型 ：mqtt || coap || modbus || http', 'varchar(255)', 'String', 'protocolType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'link_device_protocol_type', 6, 'admin', '2022-07-04 09:05:19', '', '2022-07-04 11:21:13');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (169, '12', 'protocol_voice', '协议语言', 'varchar(255)', 'String', 'protocolVoice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'link_ protocol_voice', 7, 'admin', '2022-07-04 09:05:19', '', '2022-07-04 11:21:13');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (170, '12', 'class_name', '类名', 'varchar(255)', 'String', 'className', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 8, 'admin', '2022-07-04 09:05:19', '', '2022-07-04 11:21:14');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (171, '12', 'file_path', '文件地址', 'varchar(255)', 'String', 'filePath', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2022-07-04 09:05:19', '', '2022-07-04 11:21:14');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (172, '12', 'content', '内容', 'text', 'String', 'content', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'editor', '', 10, 'admin', '2022-07-04 09:05:19', '', '2022-07-04 11:21:14');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (173, '12', 'status', '状态(字典值：0启用  1停用)', 'varchar(10)', 'String', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'business_data_status', 11, 'admin', '2022-07-04 09:05:20', '', '2022-07-04 11:21:14');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (174, '12', 'create_by', '创建者', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, '1', NULL, 'EQ', 'input', '', 12, 'admin', '2022-07-04 09:05:20', '', '2022-07-04 11:21:14');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (175, '12', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, '1', NULL, 'EQ', 'datetime', '', 13, 'admin', '2022-07-04 09:05:20', '', '2022-07-04 11:21:14');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (176, '12', 'update_by', '更新者', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 14, 'admin', '2022-07-04 09:05:20', '', '2022-07-04 11:21:14');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (177, '12', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 15, 'admin', '2022-07-04 09:05:20', '', '2022-07-04 11:21:14');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (178, '12', 'remark', '备注', 'varchar(500)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 16, 'admin', '2022-07-04 09:05:20', '', '2022-07-04 11:21:14');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (179, '13', 'id', '主键', 'bigint(1)', 'Integer', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2022-07-15 17:47:02', '', '2022-11-18 13:38:21');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (180, '13', 'app_id', '应用ID', 'varchar(64)', 'String', 'appId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2022-07-15 17:47:02', '', '2022-11-18 13:38:26');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (181, '13', 'rule_name', '规则名称', 'varchar(255)', 'String', 'ruleName', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2022-07-15 17:47:02', '', '2022-11-18 13:38:38');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (182, '13', 'cron_expression', '生效时间', 'varchar(50)', 'String', 'cronExpression', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2022-07-15 17:47:02', '', '2022-11-18 13:38:38');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (183, '13', 'status', '状态(字典值：0启用  1停用)', 'varchar(10)', 'String', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'radio', '', 5, 'admin', '2022-07-15 17:47:02', '', '2022-11-18 13:38:38');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (184, '13', 'remark', '规则描述，可以为空', 'varchar(255)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2022-07-15 17:47:02', '', '2022-11-18 13:38:38');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (185, '13', 'create_by', '创建人', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2022-07-15 17:47:02', '', '2022-11-18 13:38:38');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (186, '13', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2022-07-15 17:47:03', '', '2022-11-18 13:38:38');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (187, '13', 'update_by', '更新人', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 9, 'admin', '2022-07-15 17:47:03', '', '2022-11-18 13:38:38');
INSERT INTO `gen_table_column` (`column_id`, `table_id`, `column_name`, `column_comment`, `column_type`, `java_type`, `java_field`, `is_pk`, `is_increment`, `is_required`, `is_insert`, `is_edit`, `is_list`, `is_query`, `query_type`, `html_type`, `dict_type`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (188, '13', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 10, 'admin', '2022-07-15 17:47:03', '', '2022-11-18 13:38:38');
COMMIT;

-- ----------------------------
-- Table structure for ota_upgrade_records
-- ----------------------------
DROP TABLE IF EXISTS `ota_upgrade_records`;
CREATE TABLE `ota_upgrade_records` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `task_id` bigint(20) NOT NULL COMMENT '任务ID，关联ota_upgrade_tasks表',
  `device_identification` varchar(100) NOT NULL DEFAULT '' COMMENT '设备标识',
  `upgrade_status` smallint(1) NOT NULL DEFAULT '0' COMMENT '升级状态(0:待升级、1:升级中、2:升级成功、3:升级失败)',
  `progress` smallint(3) NOT NULL DEFAULT '0' COMMENT '升级进度（百分比）',
  `error_code` varchar(100) DEFAULT NULL COMMENT '错误代码',
  `error_message` varchar(255) DEFAULT NULL COMMENT '错误信息',
  `start_time` datetime DEFAULT NULL COMMENT '升级开始时间',
  `end_time` datetime DEFAULT NULL COMMENT '升级结束时间',
  `success_details` longtext COMMENT '升级成功详细信息',
  `failure_details` longtext COMMENT '升级失败详细信息',
  `log_details` longtext COMMENT '升级过程日志',
  `remark` varchar(255) DEFAULT '' COMMENT '描述',
  `created_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '记录创建时间',
  `created_by` varchar(20) DEFAULT NULL COMMENT '创建人',
  `updated_by` varchar(20) DEFAULT NULL COMMENT '更新人',
  `updated_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `idx_task_id_device_identification` (`task_id`,`device_identification`) USING BTREE,
  KEY `idx_task_id` (`task_id`),
  KEY `idx_device_identification` (`device_identification`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='OTA升级记录表';

-- ----------------------------
-- Records of ota_upgrade_records
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for ota_upgrade_tasks
-- ----------------------------
DROP TABLE IF EXISTS `ota_upgrade_tasks`;
CREATE TABLE `ota_upgrade_tasks` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `upgrade_id` bigint(20) NOT NULL COMMENT '升级包ID，关联ota_upgrades表',
  `task_name` varchar(100) NOT NULL DEFAULT '' COMMENT '任务名称',
  `task_status` smallint(1) NOT NULL DEFAULT '0' COMMENT '任务状态(0:待发布、1:进行中、2:已完成、3:已取消)',
  `scheduled_time` datetime DEFAULT NULL COMMENT '计划执行时间',
  `description` varchar(255) DEFAULT '' COMMENT '任务描述',
  `remark` varchar(255) DEFAULT '' COMMENT '描述',
  `created_by` varchar(20) DEFAULT NULL COMMENT '创建人',
  `created_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updated_by` varchar(20) DEFAULT NULL COMMENT '更新人',
  `updated_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_upgrade_id` (`upgrade_id`) USING BTREE COMMENT '升级包ID'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='OTA升级任务表';

-- ----------------------------
-- Records of ota_upgrade_tasks
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for ota_upgrades
-- ----------------------------
DROP TABLE IF EXISTS `ota_upgrades`;
CREATE TABLE `ota_upgrades` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `app_id` varchar(64) NOT NULL DEFAULT '' COMMENT '应用ID',
  `package_name` varchar(100) NOT NULL DEFAULT '' COMMENT '包名称',
  `package_type` smallint(1) NOT NULL DEFAULT '0' COMMENT '升级包类型(0:软件包、1:固件包)',
  `product_identification` varchar(100) NOT NULL DEFAULT '' COMMENT '产品标识',
  `version` varchar(255) NOT NULL DEFAULT '' COMMENT '升级包版本号',
  `file_location` varchar(255) NOT NULL DEFAULT '' COMMENT '升级包的位置',
  `status` smallint(1) NOT NULL DEFAULT '0' COMMENT '状态',
  `description` varchar(255) DEFAULT '' COMMENT '升级包功能描述',
  `custom_info` longtext COMMENT '自定义信息',
  `remark` varchar(255) DEFAULT '' COMMENT '描述',
  `created_by` varchar(20) DEFAULT NULL COMMENT '创建人',
  `created_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updated_by` varchar(20) DEFAULT NULL COMMENT '更新人',
  `updated_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_app_id` (`app_id`) USING BTREE COMMENT '应用ID',
  KEY `idx_product_identification` (`product_identification`) USING BTREE COMMENT '产品标识',
  KEY `idx_version` (`version`) USING BTREE COMMENT '升级包版本号'
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COMMENT='OTA升级包';

-- ----------------------------
-- Records of ota_upgrades
-- ----------------------------
BEGIN;
INSERT INTO `ota_upgrades` (`id`, `app_id`, `package_name`, `package_type`, `product_identification`, `version`, `file_location`, `status`, `description`, `custom_info`, `remark`, `created_by`, `created_time`, `updated_by`, `updated_time`) VALUES (1, '2', '2', 1, 'b6d1914cfe824acf974fb24a242a05bc', '2', '2', 0, '2', '2', '2', 'admin', '2024-03-14 10:51:00', 'admin', '2024-03-14 11:07:41');
COMMIT;

-- ----------------------------
-- Table structure for product
-- ----------------------------
DROP TABLE IF EXISTS `product`;
CREATE TABLE `product` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `app_id` varchar(64) NOT NULL COMMENT '应用ID',
  `template_identification` varchar(100) DEFAULT NULL COMMENT '产品模版标识',
  `product_name` varchar(255) NOT NULL COMMENT '产品名称:自定义，支持中文、英文大小写、数字、下划线和中划线',
  `product_identification` varchar(100) NOT NULL COMMENT '产品标识',
  `product_type` varchar(255) NOT NULL COMMENT '支持以下两种产品类型•COMMON：普通产品，需直连设备。\r\n•GATEWAY：网关产品，可挂载子设备。\r\n',
  `manufacturer_id` varchar(255) NOT NULL COMMENT '厂商ID:支持英文大小写，数字，下划线和中划线',
  `manufacturer_name` varchar(255) NOT NULL COMMENT '厂商名称 :支持中文、英文大小写、数字、下划线和中划线',
  `model` varchar(255) NOT NULL COMMENT '产品型号，建议包含字母或数字来保证可扩展性。支持英文大小写、数字、下划线和中划线\r\n',
  `data_format` varchar(255) NOT NULL COMMENT '数据格式，默认为JSON无需修改。',
  `device_type` varchar(255) NOT NULL COMMENT '设备类型:支持英文大小写、数字、下划线和中划线\r\n',
  `protocol_type` varchar(255) NOT NULL COMMENT '设备接入平台的协议类型，默认为MQTT无需修改。\r\n ',
  `status` varchar(10) NOT NULL DEFAULT '0' COMMENT '状态(字典值：0启用  1停用)',
  `remark` varchar(255) DEFAULT NULL COMMENT '产品描述',
  `create_by` varchar(64) DEFAULT 'ununited' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `manufacturer_id` (`manufacturer_id`) USING BTREE COMMENT '厂商ID索引'
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8 COMMENT='产品模型';

-- ----------------------------
-- Records of product
-- ----------------------------
BEGIN;
INSERT INTO `product` (`id`, `app_id`, `template_identification`, `product_name`, `product_identification`, `product_type`, `manufacturer_id`, `manufacturer_name`, `model`, `data_format`, `device_type`, `protocol_type`, `status`, `remark`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (55, 'thinglinks', NULL, 'starlighting-ManualControl', '53bf9b67bade40609bd5fb5834dca09b', 'GATEWAY', 'starlighting', 'starlighting', '1234', 'JSON', '1234', 'MQTT', '0', NULL, 'admin', '2024-03-27 22:41:25', '', '2024-03-27 22:41:25');
COMMIT;

-- ----------------------------
-- Table structure for product_commands
-- ----------------------------
DROP TABLE IF EXISTS `product_commands`;
CREATE TABLE `product_commands` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT COMMENT '命令id',
  `service_id` bigint(19) NOT NULL COMMENT '服务ID',
  `name` varchar(255) NOT NULL COMMENT '指示命令的名字，如门磁的LOCK命令、摄像头的VIDEO_RECORD命令，命令名与参数共同构成一个完整的命令。\r\n支持英文大小写、数字及下划线，长度[2,50]。\r\n',
  `description` varchar(255) DEFAULT NULL COMMENT '命令描述。',
  `create_by` varchar(64) DEFAULT 'ununited' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `service_id` (`service_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COMMENT='产品模型设备服务命令表';

-- ----------------------------
-- Records of product_commands
-- ----------------------------
BEGIN;
INSERT INTO `product_commands` (`id`, `service_id`, `name`, `description`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (13, 82, 'status', '状态', 'admin', '2024-03-25 01:15:26', '', '2024-03-25 01:15:26');
INSERT INTO `product_commands` (`id`, `service_id`, `name`, `description`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (15, 83, 'status', '控制灯具的开关状态', 'admin', '2024-03-27 22:57:09', '', '2024-03-27 22:57:09');
COMMIT;

-- ----------------------------
-- Table structure for product_commands_requests
-- ----------------------------
DROP TABLE IF EXISTS `product_commands_requests`;
CREATE TABLE `product_commands_requests` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `service_id` bigint(19) NOT NULL COMMENT '服务ID',
  `commands_id` bigint(19) NOT NULL COMMENT '命令ID',
  `datatype` varchar(255) NOT NULL COMMENT '指示数据类型。取值范围：string、int、decimal\r\n',
  `enumlist` varchar(255) DEFAULT NULL COMMENT '指示枚举值。\r\n如开关状态status可有如下取值\r\n"enumList" : ["OPEN","CLOSE"]\r\n目前本字段是非功能性字段，仅起到描述作用。建议准确定义。\r\n',
  `max` varchar(255) DEFAULT NULL COMMENT '指示最大值。\r\n仅当dataType为int、decimal时生效，逻辑小于等于。',
  `maxlength` varchar(255) DEFAULT NULL COMMENT '指示字符串长度。\r\n仅当dataType为string时生效。',
  `min` varchar(255) DEFAULT NULL COMMENT '指示最小值。\r\n仅当dataType为int、decimal时生效，逻辑大于等于。',
  `parameter_description` varchar(255) DEFAULT NULL COMMENT '命令中参数的描述，不影响实际功能，可配置为空字符串""。',
  `parameter_name` varchar(255) DEFAULT NULL COMMENT '命令中参数的名字。',
  `required` varchar(255) NOT NULL COMMENT '指示本条属性是否必填，取值为0或1，默认取值1（必填）。\r\n目前本字段是非功能性字段，仅起到描述作用。',
  `step` varchar(255) DEFAULT NULL COMMENT '指示步长。',
  `unit` varchar(255) DEFAULT NULL COMMENT '指示单位。\r\n取值根据参数确定，如：\r\n•温度单位：“C”或“K”\r\n•百分比单位：“%”\r\n•压强单位：“Pa”或“kPa”\r\n',
  `create_by` varchar(64) DEFAULT 'ununited' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `commands_id` (`commands_id`) USING BTREE,
  KEY `service_id` (`service_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='产品模型设备下发服务命令属性表';

-- ----------------------------
-- Records of product_commands_requests
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for product_commands_response
-- ----------------------------
DROP TABLE IF EXISTS `product_commands_response`;
CREATE TABLE `product_commands_response` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `commands_id` bigint(19) NOT NULL COMMENT '命令ID',
  `service_id` bigint(19) DEFAULT NULL COMMENT '服务ID',
  `datatype` varchar(255) NOT NULL COMMENT '指示数据类型。取值范围：string、int、decimal\r\n',
  `enumlist` varchar(255) DEFAULT NULL COMMENT '指示枚举值。\r\n如开关状态status可有如下取值\r\n"enumList" : ["OPEN","CLOSE"]\r\n目前本字段是非功能性字段，仅起到描述作用。建议准确定义。\r\n',
  `max` varchar(255) DEFAULT NULL COMMENT '指示最大值。\r\n仅当dataType为int、decimal时生效，逻辑小于等于。',
  `maxlength` varchar(255) DEFAULT NULL COMMENT '指示字符串长度。\r\n仅当dataType为string时生效。',
  `min` varchar(255) DEFAULT NULL COMMENT '指示最小值。\r\n仅当dataType为int、decimal时生效，逻辑大于等于。',
  `parameter_description` varchar(255) DEFAULT NULL COMMENT '命令中参数的描述，不影响实际功能，可配置为空字符串""。',
  `parameter_name` varchar(255) DEFAULT NULL COMMENT '命令中参数的名字。',
  `required` varchar(255) NOT NULL COMMENT '指示本条属性是否必填，取值为0或1，默认取值1（必填）。\r\n目前本字段是非功能性字段，仅起到描述作用。',
  `step` varchar(255) DEFAULT NULL COMMENT '指示步长。',
  `unit` varchar(255) DEFAULT NULL COMMENT '指示单位。\r\n取值根据参数确定，如：\r\n•温度单位：“C”或“K”\r\n•百分比单位：“%”\r\n•压强单位：“Pa”或“kPa”\r\n',
  `create_by` varchar(64) DEFAULT 'ununited' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `commands_id` (`commands_id`) USING BTREE,
  KEY `service_id` (`service_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='产品模型设备响应服务命令属性表';

-- ----------------------------
-- Records of product_commands_response
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for product_properties
-- ----------------------------
DROP TABLE IF EXISTS `product_properties`;
CREATE TABLE `product_properties` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `property_name` varchar(255) NOT NULL COMMENT '指示属性名称。',
  `service_id` bigint(19) NOT NULL COMMENT '服务ID',
  `datatype` varchar(255) NOT NULL COMMENT '指示数据类型：取值范围：string、int、decimal（float和double都可以使用此类型）、DateTime、jsonObject上报数据时，复杂类型数据格式如下：\r\n•DateTime:yyyyMMdd’T’HHmmss’Z’如:20151212T121212Z•jsonObject：自定义json结构体，平台不理解只透传\r\n',
  `description` varchar(255) DEFAULT NULL COMMENT '属性描述，不影响实际功能，可配置为空字符串""。',
  `enumlist` varchar(255) DEFAULT NULL COMMENT '指示枚举值:如开关状态status可有如下取值"enumList" : ["OPEN","CLOSE"]目前本字段是非功能性字段，仅起到描述作用。建议准确定义。\r\n',
  `max` varchar(255) DEFAULT NULL COMMENT '指示最大值。支持长度不超过50的数字。仅当dataType为int、decimal时生效，逻辑小于等于。\r\n',
  `maxlength` bigint(19) DEFAULT NULL COMMENT '指示字符串长度。仅当dataType为string、DateTime时生效。\r\n',
  `method` varchar(255) DEFAULT NULL COMMENT '指示访问模式。R:可读；W:可写；E属性值更改时上报数据取值范围：R、RW、RE、RWE\r\n',
  `min` varchar(255) DEFAULT NULL COMMENT '指示最小值。支持长度不超过50的数字。仅当dataType为int、decimal时生效，逻辑大于等于。\r\n',
  `required` int(2) DEFAULT NULL COMMENT '指示本条属性是否必填，取值为0或1，默认取值1（必填）。目前本字段是非功能性字段，仅起到描述作用。(字典值link_product_isRequired：0非必填 1必填)\r\n',
  `step` int(9) DEFAULT NULL COMMENT '指示步长。',
  `unit` varchar(255) DEFAULT NULL COMMENT '指示单位。支持长度不超过50。\r\n取值根据参数确定，如：\r\n•温度单位：“C”或“K”\r\n•百分比单位：“%”\r\n•压强单位：“Pa”或“kPa”\r\n',
  `create_by` varchar(64) DEFAULT 'ununited' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `property_code` varchar(255) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '属性编码',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `service_id` (`service_id`) USING BTREE COMMENT '服务ID'
) ENGINE=InnoDB AUTO_INCREMENT=178 DEFAULT CHARSET=utf8 COMMENT='产品模型服务属性表';

-- ----------------------------
-- Records of product_properties
-- ----------------------------
BEGIN;
INSERT INTO `product_properties` (`id`, `property_name`, `service_id`, `datatype`, `description`, `enumlist`, `max`, `maxlength`, `method`, `min`, `required`, `step`, `unit`, `create_by`, `create_time`, `update_by`, `update_time`, `property_code`) VALUES (172, '设备标识', 82, 'string', NULL, NULL, '65535', 100, 'R', '0', 0, NULL, NULL, 'admin', '2024-03-25 01:14:01', '', '2024-03-25 01:14:01', 'device_id');
INSERT INTO `product_properties` (`id`, `property_name`, `service_id`, `datatype`, `description`, `enumlist`, `max`, `maxlength`, `method`, `min`, `required`, `step`, `unit`, `create_by`, `create_time`, `update_by`, `update_time`, `property_code`) VALUES (173, '亮度等级', 82, 'string', NULL, NULL, '65535', 100, 'R', '0', 0, NULL, NULL, 'admin', '2024-03-25 01:14:20', '', '2024-03-25 01:14:20', 'brightness_level');
INSERT INTO `product_properties` (`id`, `property_name`, `service_id`, `datatype`, `description`, `enumlist`, `max`, `maxlength`, `method`, `min`, `required`, `step`, `unit`, `create_by`, `create_time`, `update_by`, `update_time`, `property_code`) VALUES (174, '亮度调整次数', 82, 'int', NULL, NULL, '65535', NULL, NULL, '0', 0, 10, NULL, 'admin', '2024-03-25 01:14:57', '', '2024-03-25 01:14:57', 'brightness_adjustment_count');
INSERT INTO `product_properties` (`id`, `property_name`, `service_id`, `datatype`, `description`, `enumlist`, `max`, `maxlength`, `method`, `min`, `required`, `step`, `unit`, `create_by`, `create_time`, `update_by`, `update_time`, `property_code`) VALUES (175, '设备标识', 83, 'string', '每个设备应有一个独特的标识符，如序列号或设备ID，以便于识别和追踪', NULL, '65535', 100, 'R', '0', 1, NULL, NULL, 'admin', '2024-03-27 22:45:39', '', '2024-03-27 22:45:39', 'device_id');
INSERT INTO `product_properties` (`id`, `property_name`, `service_id`, `datatype`, `description`, `enumlist`, `max`, `maxlength`, `method`, `min`, `required`, `step`, `unit`, `create_by`, `create_time`, `update_by`, `update_time`, `property_code`) VALUES (176, '亮度等级', 83, 'string', '记录灯具的当前亮度。这通常是一个百分比值，表示最低亮度（0%）到最高亮度（100%）', NULL, '65535', 100, 'R', '0', 0, NULL, NULL, 'admin', '2024-03-27 22:47:03', '', '2024-03-27 22:47:03', 'brightness_level');
INSERT INTO `product_properties` (`id`, `property_name`, `service_id`, `datatype`, `description`, `enumlist`, `max`, `maxlength`, `method`, `min`, `required`, `step`, `unit`, `create_by`, `create_time`, `update_by`, `update_time`, `property_code`) VALUES (177, '亮度调整次数', 83, 'string', '记录自从最后一次设定后，亮度调整的次数。这有助于了解用户的使用习惯', NULL, '65535', 100, 'R', '0', 0, NULL, NULL, 'admin', '2024-03-27 22:47:33', '', '2024-03-27 22:47:33', 'brightness_adjustment_count');
COMMIT;

-- ----------------------------
-- Table structure for product_services
-- ----------------------------
DROP TABLE IF EXISTS `product_services`;
CREATE TABLE `product_services` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT COMMENT '服务id',
  `service_code` varchar(255) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '服务编码:支持英文大小写、数字、下划线和中划线',
  `service_name` varchar(255) NOT NULL COMMENT '服务名称',
  `template_identification` varchar(100) DEFAULT NULL COMMENT '产品模版标识',
  `product_identification` varchar(100) DEFAULT NULL COMMENT '产品标识',
  `status` varchar(10) NOT NULL DEFAULT '0' COMMENT '状态(字典值：0启用  1停用)',
  `description` varchar(255) DEFAULT NULL COMMENT '服务的描述信息:文本描述，不影响实际功能，可配置为空字符串""。\r\n',
  `create_by` varchar(64) DEFAULT 'ununited' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8 COMMENT='产品模型服务表';

-- ----------------------------
-- Records of product_services
-- ----------------------------
BEGIN;
INSERT INTO `product_services` (`id`, `service_code`, `service_name`, `template_identification`, `product_identification`, `status`, `description`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (82, 'default_brightness_controls', '默认亮度控制', NULL, 'b6d1914cfe824acf974fb24a242a05bc', '0', '此服务用于收集灯具信息，并控制灯具的开关', 'admin', '2024-03-25 01:13:39', '', '2024-03-25 01:13:39');
INSERT INTO `product_services` (`id`, `service_code`, `service_name`, `template_identification`, `product_identification`, `status`, `description`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (83, 'default_brightness_controls', '默认亮度控制', NULL, '53bf9b67bade40609bd5fb5834dca09b', '0', '上报路灯数据，设定照明设备启用时所需的亮度水平和渐变时间', 'admin', '2024-03-27 22:44:11', '', '2024-03-27 22:44:11');
COMMIT;

-- ----------------------------
-- Table structure for product_template
-- ----------------------------
DROP TABLE IF EXISTS `product_template`;
CREATE TABLE `product_template` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `app_id` varchar(64) NOT NULL COMMENT '应用ID',
  `template_identification` varchar(100) NOT NULL COMMENT '产品模版标识',
  `template_name` varchar(255) NOT NULL COMMENT '产品模板名称:自定义，支持中文、英文大小写、数字、下划线和中划线',
  `status` varchar(10) NOT NULL COMMENT '状态(字典值：启用  停用)',
  `remark` varchar(255) DEFAULT NULL COMMENT '产品模型模板描述',
  `create_by` varchar(64) DEFAULT 'ununited' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='产品模板';

-- ----------------------------
-- Records of product_template
-- ----------------------------
BEGIN;
INSERT INTO `product_template` (`id`, `app_id`, `template_identification`, `template_name`, `status`, `remark`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (4, 'zhima', '6f6dac1b0c1c46b0828e4ee2cdaf3b7e', 'PM-01', '0', '产品1号', 'admin', '2022-11-24 18:52:38', '', '2022-11-24 18:52:38');
INSERT INTO `product_template` (`id`, `app_id`, `template_identification`, `template_name`, `status`, `remark`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (5, 'zhima', 'c0d47af01b3043f4a24fb99528475a9c', 'PM-01', '0', '产品1号', 'admin', '2022-11-24 18:52:38', '', '2022-11-24 18:52:38');
INSERT INTO `product_template` (`id`, `app_id`, `template_identification`, `template_name`, `status`, `remark`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (6, 'thinglinks', 'ce147bee0fdd4f56bec70bf54cded07f', '232', '0', '3', 'admin', '2022-11-24 18:54:02', '', '2022-11-24 18:54:02');
INSERT INTO `product_template` (`id`, `app_id`, `template_identification`, `template_name`, `status`, `remark`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (7, 'zhima', '1de7180b39e84c3bbe558f01e2f76928', 'PM-01', '0', '产品1号', 'admin', '2022-11-24 18:54:39', '', '2022-11-24 18:54:39');
INSERT INTO `product_template` (`id`, `app_id`, `template_identification`, `template_name`, `status`, `remark`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (8, 'zhima', '1669d08e6c414730a53a73d7c9933e01', '2222222', '0', '222222', 'admin', '2023-09-15 16:50:05', '', '2023-09-15 16:50:05');
INSERT INTO `product_template` (`id`, `app_id`, `template_identification`, `template_name`, `status`, `remark`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (9, 'thinglinks', '70ed2295437145ca9f32122a8aa8cf28', '1234567890', '0', '1234567890', 'hitelcom', '2023-12-05 16:18:46', '', '2023-12-05 16:18:46');
COMMIT;

-- ----------------------------
-- Table structure for protocol
-- ----------------------------
DROP TABLE IF EXISTS `protocol`;
CREATE TABLE `protocol` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `app_id` varchar(64) NOT NULL COMMENT '应用ID',
  `product_identification` varchar(100) NOT NULL COMMENT '产品标识',
  `protocol_name` varchar(255) DEFAULT NULL COMMENT '协议名称',
  `protocol_identification` varchar(255) DEFAULT NULL COMMENT '协议标识',
  `protocol_version` varchar(255) DEFAULT NULL COMMENT '协议版本',
  `protocol_type` varchar(255) DEFAULT NULL COMMENT '协议类型 ：mqtt || coap || modbus || http',
  `protocol_voice` varchar(255) DEFAULT NULL COMMENT '协议语言',
  `class_name` varchar(255) DEFAULT NULL COMMENT '类名',
  `file_path` varchar(255) DEFAULT NULL COMMENT '文件地址',
  `content` text COMMENT '内容',
  `status` varchar(10) NOT NULL DEFAULT '0' COMMENT '状态(字典值：0启用  1停用)',
  `create_by` varchar(64) DEFAULT 'ununited' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='协议信息表';

-- ----------------------------
-- Records of protocol
-- ----------------------------
BEGIN;
INSERT INTO `protocol` (`id`, `app_id`, `product_identification`, `protocol_name`, `protocol_identification`, `protocol_version`, `protocol_type`, `protocol_voice`, `class_name`, `file_path`, `content`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1, 'thinglinks', '82325a1de5e84ea88f332f3dbc10f6d5', '温湿度产品协议转换', '22', '22', 'MQTT', 'java', '222', '222', 'import com.alibaba.fastjson.JSONArray;\nimport com.alibaba.fastjson.JSONObject;\n\nimport javax.xml.bind.annotation.adapters.HexBinaryAdapter;\nimport java.math.BigInteger;\nimport java.util.Date;\n\npublic class newtest {\n    public static void main(String[] args) throws Exception {\n        String injson = \"\";\n\n        if (args != null && args.length != 0) {\n            injson = args[0];\n        }\n        JSONObject parsejson = JSONObject.parseObject(injson);\n        System.out.println(Convert2SystemJSON(parsejson));\n    }\n    public static String Convert2SystemJSON(JSONObject injsonobj) throws Exception {\n        String hexdata = injsonobj.get(\"data\").toString();\n        byte[] bt = java.util.Base64.getDecoder().decode(hexdata);\n        JSONObject data = hex2wsdjsonobj(bt);\n\n        JSONArray services = new JSONArray();\n        JSONObject server = new JSONObject();\n        server.put(\"serviceId\", \"serdsd123\");\n        server.put(\"data\", data);\n        server.put(\"eventTime\", new Date());\n        services.add(server);\n\n        JSONObject dev = new JSONObject();\n        dev.put(\"deviceId\", injsonobj.get(\"devEui\"));\n        dev.put(\"services\", services);\n        JSONArray devices = new JSONArray();\n        devices.add(dev);\n\n        JSONObject root = new JSONObject();\n        root.put(\"devices\", devices);\n        return root.toJSONString();\n    }\n\n    /**\n     * 十六进制转换成10进制 负数也能转换\n     */\n    public static int hex16convert2(String hex) throws Exception {\n        if (hex.length() != 4) {\n            throw new Exception(\"必须是4个长度\");\n        }\n        int bit1 = Integer.parseInt(hex.substring(0, 1), 16);\n        if (bit1 &lt; 8)\n        {\n            return Integer.parseInt(hex, 16);\n        } else {\n            return new BigInteger(\"FFFF\" + hex, 16).intValue();\n        }\n    }\n\n    /**\n     * 温湿度解码\n     */\n    private static JSONObject hex2wsdjsonobj(byte[] bt) throws Exception {\n        javax.xml.bind.annotation.adapters.HexBinaryAdapter hexBinaryAdapter = new HexBinaryAdapter();\n        JSONObject data = new JSONObject();\n        String temp = hexBinaryAdapter.marshal(new byte[]{bt[2]});\n        String temp2 = hexBinaryAdapter.marshal(new byte[]{bt[3]});\n        String changtemp = change(temp, temp2);\n        data.put(\"temperature\", hex16convert2(changtemp) * 0.01);\n        temp = hexBinaryAdapter.marshal(new byte[]{bt[4]});\n        temp2 = hexBinaryAdapter.marshal(new byte[]{bt[5]});\n        changtemp = change(temp, temp2);\n        data.put(\"humidity\", hex16convert2(changtemp) * 0.01);\n        temp = hexBinaryAdapter.marshal(new byte[]{bt[8]});\n        temp2 = hexBinaryAdapter.marshal(new byte[]{bt[9]});\n        changtemp = change(temp, temp2);\n        data.put(\"battery\", hex16convert2(changtemp));\n        return data;\n    }\n\n    public static String change(String first, String end) {\n        return end + first;\n    }\n}\n', '1', 'admin', '2022-07-11 15:55:22', 'admin', '2024-05-10 16:55:28', '温湿度产品协议转换样例');
INSERT INTO `protocol` (`id`, `app_id`, `product_identification`, `protocol_name`, `protocol_identification`, `protocol_version`, `protocol_type`, `protocol_voice`, `class_name`, `file_path`, `content`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (2, 'thinglinks', '53bf9b67bade40609bd5fb5834dca09b', 'co2协议转换', '1', '1', 'MQTT', 'java', '1', '1', 'import com.alibaba.fastjson.JSONArray;\nimport com.alibaba.fastjson.JSONObject;\n\nimport javax.xml.bind.annotation.adapters.HexBinaryAdapter;\nimport java.util.Date;\n\npublic class co2test {\n    public static void main(String[] args) throws Exception {\n        String injson = \"\";\n\n        if (args != null && args.length != 0) {\n            injson = args[0];\n        }\n        JSONObject parsejson = JSONObject.parseObject(injson);\n        System.out.println(Convert2SystemJSON(parsejson));\n    }\n    public static String Convert2SystemJSON(JSONObject injsonobj) throws Exception {\n        String hexdata = injsonobj.get(\"data\").toString();\n        byte[] bt = java.util.Base64.getDecoder().decode(hexdata);\n        JSONObject data = hex2co2jsonobj(bt);\n\n        JSONArray services = new JSONArray();\n        JSONObject server = new JSONObject();\n        server.put(\"serviceId\", \"serdsd123\");\n        server.put(\"data\", data);\n        server.put(\"eventTime\", new Date());\n        services.add(server);\n\n        JSONObject dev = new JSONObject();\n        dev.put(\"deviceId\",  injsonobj.get(\"devEUI\").toString());\n        dev.put(\"services\", services);\n        JSONArray devices = new JSONArray();\n        devices.add(dev);\n\n        JSONObject root = new JSONObject();\n        root.put(\"devices\", devices);\n        return root.toJSONString();\n    }\n \n    private static JSONObject hex2co2jsonobj(byte[] bt) throws Exception {\n        javax.xml.bind.annotation.adapters.HexBinaryAdapter hexBinaryAdapter = new HexBinaryAdapter();\n        String hex=hexBinaryAdapter.marshal(bt);\n        JSONObject data = new JSONObject();\n        for (int i = 0; i &lt; hex.length(); i++) {\n            String td = hex.substring(i, i + 2);\n            String type = hex.substring(i + 2, i + 4); \n            if (td.equals(\"01\") && type.equals(\"75\")) {\n                data.put(\"battery\", Integer.parseInt(hex.substring(i + 4, i + 6), 16));\n            } \n            else if (td.equals(\"03\") && type.equals(\"67\")) { \n                String temp = change(hex.substring(i + 4, i + 6), hex.substring(i + 6, i + 8));\n                data.put(\"temperature\", Integer.parseInt(temp, 16) * 0.1);\n                i = i + 7;\n            } \n            else if (td.equals(\"04\") && type.equals(\"68\")) {\n                data.put(\"humidity\", Integer.parseInt(hex.substring(i + 4, i + 6), 16) / 2);\n                i = i + 5;\n            } \n            else if (td.equals(\"05\") && type.toLowerCase().equals(\"7d\")) {\n                String temp = change(hex.substring(i + 4, i + 6), hex.substring(i + 6, i + 8));\n                data.put(\"co2\", Integer.parseInt(temp, 16));\n                i = i + 7;\n            } \n            else if (td.equals(\"06\") && type.equals(\"73\")) {\n                String temp = change(hex.substring(i + 4, i + 6), hex.substring(i + 6, i + 8));\n                data.put(\"pressure\",Integer.parseInt(temp, 16) * 0.1);\n                i = i + 7;\n            } else {\n                break;\n            }\n        }\n        return data;\n    }\n\n    public static String change(String first, String end) {\n        return end + first;\n    }\n}\n', '1', 'admin', '2022-07-13 09:26:32', 'admin', '2024-05-10 16:57:26', 'co2协议转换样例');
COMMIT;

-- ----------------------------
-- Table structure for rule
-- ----------------------------
DROP TABLE IF EXISTS `rule`;
CREATE TABLE `rule` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `app_id` varchar(64) NOT NULL COMMENT '应用ID',
  `rule_identification` varchar(100) NOT NULL COMMENT '规则标识',
  `rule_name` varchar(255) NOT NULL COMMENT '规则名称',
  `job_identification` varchar(255) NOT NULL COMMENT '任务标识',
  `status` varchar(10) NOT NULL DEFAULT '0' COMMENT '状态(字典值：0启用  1停用)',
  `triggering` smallint(20) DEFAULT NULL COMMENT '触发机制（0:全部，1:任意一个）',
  `remark` varchar(255) DEFAULT NULL COMMENT '规则描述，可以为空',
  `create_by` varchar(64) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='规则信息表';

-- ----------------------------
-- Records of rule
-- ----------------------------
BEGIN;
INSERT INTO `rule` (`id`, `app_id`, `rule_identification`, `rule_name`, `job_identification`, `status`, `triggering`, `remark`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (1, 'thinglinks', 'rule-001', '测试规则', '10', '0', 1, '测试规则', 'admin', '2022-10-28 16:47:09', NULL, '2022-10-28 16:47:09');
INSERT INTO `rule` (`id`, `app_id`, `rule_identification`, `rule_name`, `job_identification`, `status`, `triggering`, `remark`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (2, 'tinglinks', 'a831d344c1784b35985b85026ce8fae1', 'tssasss', '240cb7568f80412bb257655d4acf8056', '0', 1, '', 'admin', '2022-11-29 21:00:37', 'admin', '2022-11-30 20:03:28');
INSERT INTO `rule` (`id`, `app_id`, `rule_identification`, `rule_name`, `job_identification`, `status`, `triggering`, `remark`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (3, 'thinglinks', '7fec1be560f2432ea7c4bc50988e5cac', 'test', '2222', '0', 0, '1', 'admin', '2022-12-14 13:11:13', NULL, '2022-12-14 13:11:13');
INSERT INTO `rule` (`id`, `app_id`, `rule_identification`, `rule_name`, `job_identification`, `status`, `triggering`, `remark`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (4, 'thinglinks', '9faecc98c082482eb350b78dfd7ee7da', '测试规则2', 'rule-0002', '0', 0, NULL, 'admin', '2023-03-22 10:04:58', NULL, '2023-03-22 10:04:58');
COMMIT;

-- ----------------------------
-- Table structure for rule_action
-- ----------------------------
DROP TABLE IF EXISTS `rule_action`;
CREATE TABLE `rule_action` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `app_id` varchar(64) CHARACTER SET utf8 NOT NULL COMMENT '应用ID',
  `rule_id` bigint(20) NOT NULL COMMENT '规则ID',
  `action_identification` varchar(100) NOT NULL COMMENT '动作标识',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='规则动作表';

-- ----------------------------
-- Records of rule_action
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for rule_alarm
-- ----------------------------
DROP TABLE IF EXISTS `rule_alarm`;
CREATE TABLE `rule_alarm` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '规则告警ID',
  `alarm_identification` varchar(100) NOT NULL COMMENT '告警唯一标识',
  `alarm_name` varchar(255) DEFAULT NULL COMMENT '告警名称',
  `alarm_status` int(10) DEFAULT NULL COMMENT '告警状态0 未启动  1运行中',
  `alarm_remark` varchar(255) DEFAULT NULL COMMENT '告警规则描述',
  `rule_level` int(10) DEFAULT NULL COMMENT '告警级别',
  `notice_type` int(10) DEFAULT NULL COMMENT '通知方式',
  `create_by` varchar(64) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='规则告警表';

-- ----------------------------
-- Records of rule_alarm
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for rule_alarm_list
-- ----------------------------
DROP TABLE IF EXISTS `rule_alarm_list`;
CREATE TABLE `rule_alarm_list` (
  `id` bigint(19) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `alarm_time` datetime DEFAULT NULL COMMENT '告警时间',
  `alarm_name` varchar(255) DEFAULT NULL COMMENT '告警名称',
  `alarm_level` int(10) DEFAULT NULL COMMENT '告警级别',
  `alarm_describe` varchar(255) DEFAULT NULL COMMENT '告警描述',
  `processing_result` int(10) DEFAULT NULL COMMENT '处理结果 0 未处理 1已处理',
  `processing_opinions` varchar(255) DEFAULT NULL COMMENT '处理意见',
  `alarm_content` varchar(500) DEFAULT NULL COMMENT '告警内容',
  `processing_people` varchar(64) DEFAULT NULL COMMENT '处理人',
  `processing_time` datetime DEFAULT NULL COMMENT '处理时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='告警列表';

-- ----------------------------
-- Records of rule_alarm_list
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for rule_conditions
-- ----------------------------
DROP TABLE IF EXISTS `rule_conditions`;
CREATE TABLE `rule_conditions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `rule_id` bigint(20) NOT NULL COMMENT '规则ID',
  `condition_type` smallint(20) NOT NULL COMMENT '条件类型(0:匹配设备触发、1:指定设备触发、2:按策略定时触发)',
  `device_identification` varchar(2000) DEFAULT NULL COMMENT '设备标识(匹配设备设备类型存储一个产品下所有的设备标识逗号分隔，指定设备触发存储指定的设备标识)',
  `product_identification` varchar(100) DEFAULT NULL COMMENT '产品标识',
  `service_id` bigint(20) DEFAULT NULL COMMENT '服务ID',
  `properties_id` bigint(20) DEFAULT NULL COMMENT '属性ID',
  `comparison_mode` varchar(255) DEFAULT NULL COMMENT '比较模式\r\n<\r\n<=\r\n>\r\n>=\r\n==\r\n!=\r\nin\r\nbetween',
  `comparison_value` varchar(255) DEFAULT NULL COMMENT '比较值\r\n\r\nbetween类型传值例子  [10,15] 必须是两位，且数字不能重复\r\n判断数据是否处于一个离散的取值范围内，例如输入[1,2,3,4]，取值范围是1、2、3、4四个值，如果比较值类型为float(double)，两个float（double）型数值相差在0.000001范围内即为相等',
  `create_by` varchar(64) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='规则条件表';

-- ----------------------------
-- Records of rule_conditions
-- ----------------------------
BEGIN;
INSERT INTO `rule_conditions` (`id`, `rule_id`, `condition_type`, `device_identification`, `product_identification`, `service_id`, `properties_id`, `comparison_mode`, `comparison_value`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (1, 1, 1, '1ff64cb6d0a74903a508b5f0e88601a5', '245b33f311104f11a1c11b8803f1c3a4', 73, 149, '==', '20', 'admin', '2022-11-03 16:03:30', NULL, '2022-11-29 15:32:13');
INSERT INTO `rule_conditions` (`id`, `rule_id`, `condition_type`, `device_identification`, `product_identification`, `service_id`, `properties_id`, `comparison_mode`, `comparison_value`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (2, 1, 1, '1ff64cb6d0a74903a508b5f0e88601a5', '245b33f311104f11a1c11b8803f1c3a4', 73, 149, 'in', '20', 'admin', '2022-11-29 21:55:31', NULL, '2022-11-29 21:55:31');
COMMIT;

-- ----------------------------
-- Table structure for rule_instance
-- ----------------------------
DROP TABLE IF EXISTS `rule_instance`;
CREATE TABLE `rule_instance` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `app_id` varchar(64) NOT NULL DEFAULT '' COMMENT '应用ID',
  `rule_name` varchar(255) DEFAULT '' COMMENT '规则实例名称',
  `flow_id` varchar(200) DEFAULT '' COMMENT '流程ID， 规则实例类型为“规则编排”时，该项为对应的NedRed流程',
  `flow_data` longtext COMMENT '流程数据',
  `type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '规则实例类型(0规则编排、1设备告警、2数据转发）',
  `instance_address` varchar(100) NOT NULL DEFAULT '' COMMENT '实例地址',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态',
  `remark` varchar(500) DEFAULT '' COMMENT '备注',
  `created_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `created_by` bigint(20) DEFAULT NULL COMMENT '创建人',
  `updated_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  `updated_by` bigint(20) DEFAULT NULL COMMENT '最后修改人',
  `created_org_id` bigint(20) DEFAULT NULL COMMENT '创建人组织',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `idx_flow_id` (`flow_id`) USING BTREE COMMENT '流程ID'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='规则实例表';

-- ----------------------------
-- Records of rule_instance
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for sys_config
-- ----------------------------
DROP TABLE IF EXISTS `sys_config`;
CREATE TABLE `sys_config` (
  `config_id` int(5) NOT NULL AUTO_INCREMENT COMMENT '参数主键',
  `config_name` varchar(100) DEFAULT '' COMMENT '参数名称',
  `config_key` varchar(100) DEFAULT '' COMMENT '参数键名',
  `config_value` varchar(500) DEFAULT '' COMMENT '参数键值',
  `config_type` char(1) DEFAULT 'N' COMMENT '系统内置（Y是 N否）',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`config_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='参数配置表';

-- ----------------------------
-- Records of sys_config
-- ----------------------------
BEGIN;
INSERT INTO `sys_config` (`config_id`, `config_name`, `config_key`, `config_value`, `config_type`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1, '主框架页-默认皮肤样式名称', 'sys.index.skinName', 'skin-green', 'Y', 'admin', '2021-09-17 18:40:14', 'admin', '2022-10-14 17:53:03', '蓝色 skin-blue、绿色 skin-green、紫色 skin-purple、红色 skin-red、黄色 skin-yellow');
INSERT INTO `sys_config` (`config_id`, `config_name`, `config_key`, `config_value`, `config_type`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (2, '用户管理-账号初始密码', 'sys.user.initPassword', '123456', 'Y', 'admin', '2021-09-17 18:40:14', 'admin', '2021-10-21 17:04:07', '初始化密码 123456');
INSERT INTO `sys_config` (`config_id`, `config_name`, `config_key`, `config_value`, `config_type`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (3, '主框架页-侧边栏主题', 'sys.index.sideTheme', 'theme-dark', 'Y', 'admin', '2021-09-17 18:40:14', '', '2022-11-18 13:51:15', '深色主题theme-dark，浅色主题theme-light');
INSERT INTO `sys_config` (`config_id`, `config_name`, `config_key`, `config_value`, `config_type`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (4, '账号自助-是否开启用户注册功能', 'sys.account.registerUser', 'false', 'Y', 'admin', '2021-09-17 18:40:14', '', '2022-11-18 13:51:20', '是否开启注册用户功能（true开启，false关闭）');
COMMIT;

-- ----------------------------
-- Table structure for sys_dept
-- ----------------------------
DROP TABLE IF EXISTS `sys_dept`;
CREATE TABLE `sys_dept` (
  `dept_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '部门id',
  `parent_id` bigint(20) DEFAULT '0' COMMENT '父部门id',
  `ancestors` varchar(50) DEFAULT '' COMMENT '祖级列表',
  `dept_name` varchar(30) DEFAULT '' COMMENT '部门名称',
  `order_num` int(4) DEFAULT '0' COMMENT '显示顺序',
  `leader` varchar(20) DEFAULT NULL COMMENT '负责人',
  `phone` varchar(11) DEFAULT NULL COMMENT '联系电话',
  `email` varchar(50) DEFAULT NULL COMMENT '邮箱',
  `status` char(1) DEFAULT '0' COMMENT '部门状态（0正常 1停用）',
  `del_flag` char(1) DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`dept_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=111 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='部门表';

-- ----------------------------
-- Records of sys_dept
-- ----------------------------
BEGIN;
INSERT INTO `sys_dept` (`dept_id`, `parent_id`, `ancestors`, `dept_name`, `order_num`, `leader`, `phone`, `email`, `status`, `del_flag`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (100, 0, '0', 'dziot', 0, 'daiot', '15888888888', 'dziot@163.com', '0', '0', 'admin', '2021-09-17 18:39:56', 'admin', '2023-12-26 20:27:05');
INSERT INTO `sys_dept` (`dept_id`, `parent_id`, `ancestors`, `dept_name`, `order_num`, `leader`, `phone`, `email`, `status`, `del_flag`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (101, 100, '0,100', '唐山总公司', 1, 'dziot', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2021-09-17 18:39:56', 'admin', '2023-12-26 20:27:21');
INSERT INTO `sys_dept` (`dept_id`, `parent_id`, `ancestors`, `dept_name`, `order_num`, `leader`, `phone`, `email`, `status`, `del_flag`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (102, 100, '0,100', '长沙分公司', 2, 'mqtts', '15888888888', 'ry@qq.com', '0', '2', 'admin', '2021-09-17 18:39:56', '', '2022-01-03 11:45:55');
INSERT INTO `sys_dept` (`dept_id`, `parent_id`, `ancestors`, `dept_name`, `order_num`, `leader`, `phone`, `email`, `status`, `del_flag`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (103, 101, '0,100,101', '研发部门', 1, 'mqtts', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2021-09-17 18:39:56', '', '2022-01-03 11:45:55');
INSERT INTO `sys_dept` (`dept_id`, `parent_id`, `ancestors`, `dept_name`, `order_num`, `leader`, `phone`, `email`, `status`, `del_flag`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (104, 101, '0,100,101', '市场部门', 2, 'mqtts', '15888888888', 'ry@qq.com', '0', '2', 'admin', '2021-09-17 18:39:57', '', '2023-12-26 20:25:48');
INSERT INTO `sys_dept` (`dept_id`, `parent_id`, `ancestors`, `dept_name`, `order_num`, `leader`, `phone`, `email`, `status`, `del_flag`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (105, 101, '0,100,101', '测试部门', 3, 'mqtts', '15888888888', 'ry@qq.com', '0', '2', 'admin', '2021-09-17 18:39:57', '', '2023-12-26 20:25:45');
INSERT INTO `sys_dept` (`dept_id`, `parent_id`, `ancestors`, `dept_name`, `order_num`, `leader`, `phone`, `email`, `status`, `del_flag`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (106, 101, '0,100,101', '财务部门', 4, 'mqtts', '15888888888', 'ry@qq.com', '0', '2', 'admin', '2021-09-17 18:39:57', '', '2022-01-03 11:45:55');
INSERT INTO `sys_dept` (`dept_id`, `parent_id`, `ancestors`, `dept_name`, `order_num`, `leader`, `phone`, `email`, `status`, `del_flag`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (107, 101, '0,100,101', '运维部门', 5, 'mqtts', '15888888888', 'ry@qq.com', '0', '2', 'admin', '2021-09-17 18:39:57', '', '2022-01-03 11:45:55');
INSERT INTO `sys_dept` (`dept_id`, `parent_id`, `ancestors`, `dept_name`, `order_num`, `leader`, `phone`, `email`, `status`, `del_flag`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (108, 102, '0,100,102', '市场部门', 1, 'mqtts', '15888888888', 'ry@qq.com', '0', '2', 'admin', '2021-09-17 18:39:57', '', '2022-01-03 11:45:55');
INSERT INTO `sys_dept` (`dept_id`, `parent_id`, `ancestors`, `dept_name`, `order_num`, `leader`, `phone`, `email`, `status`, `del_flag`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (109, 102, '0,100,102', '财务部门', 2, 'mqtts', '15888888888', 'ry@qq.com', '0', '2', 'admin', '2021-09-17 18:39:57', '', '2022-01-03 11:45:55');
INSERT INTO `sys_dept` (`dept_id`, `parent_id`, `ancestors`, `dept_name`, `order_num`, `leader`, `phone`, `email`, `status`, `del_flag`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES (110, 100, '0,100', '测试', 1, NULL, NULL, NULL, '0', '0', 'admin', '2024-01-02 17:24:33', '', '2024-01-02 17:24:33');
COMMIT;

-- ----------------------------
-- Table structure for sys_dict_data
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict_data`;
CREATE TABLE `sys_dict_data` (
  `dict_code` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '字典编码',
  `dict_sort` int(4) DEFAULT '0' COMMENT '字典排序',
  `dict_label` varchar(100) DEFAULT '' COMMENT '字典标签',
  `dict_value` varchar(100) DEFAULT '' COMMENT '字典键值',
  `dict_type` varchar(100) DEFAULT '' COMMENT '字典类型',
  `css_class` varchar(100) DEFAULT NULL COMMENT '样式属性（其他样式扩展）',
  `list_class` varchar(100) DEFAULT NULL COMMENT '表格回显样式',
  `is_default` char(1) DEFAULT 'N' COMMENT '是否默认（Y是 N否）',
  `status` char(1) DEFAULT '0' COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`dict_code`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='字典数据表';

-- ----------------------------
-- Records of sys_dict_data
-- ----------------------------
BEGIN;
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1, 1, '男', '0', 'sys_user_sex', '', '', 'Y', '0', 'admin', '2021-09-17 18:40:12', '', '2021-09-17 18:40:13', '性别男');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (2, 2, '女', '1', 'sys_user_sex', '', '', 'N', '0', 'admin', '2021-09-17 18:40:13', '', '2021-09-17 18:40:13', '性别女');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (3, 3, '未知', '2', 'sys_user_sex', '', '', 'N', '0', 'admin', '2021-09-17 18:40:13', '', '2021-09-17 18:40:13', '性别未知');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (4, 1, '显示', '0', 'sys_show_hide', '', 'primary', 'Y', '0', 'admin', '2021-09-17 18:40:13', '', '2021-09-17 18:40:13', '显示菜单');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (5, 2, '隐藏', '1', 'sys_show_hide', '', 'danger', 'N', '0', 'admin', '2021-09-17 18:40:13', '', '2021-09-17 18:40:13', '隐藏菜单');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (6, 1, '正常', '0', 'sys_normal_disable', '', 'primary', 'Y', '0', 'admin', '2021-09-17 18:40:13', '', '2021-09-17 18:40:13', '正常状态');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (7, 2, '停用', '1', 'sys_normal_disable', '', 'danger', 'N', '0', 'admin', '2021-09-17 18:40:13', '', '2021-09-17 18:40:13', '停用状态');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (8, 1, '正常', '0', 'sys_job_status', '', 'primary', 'Y', '0', 'admin', '2021-09-17 18:40:13', '', '2021-09-17 18:40:13', '正常状态');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (9, 2, '暂停', '1', 'sys_job_status', '', 'danger', 'N', '0', 'admin', '2021-09-17 18:40:13', '', '2021-09-17 18:40:13', '停用状态');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (10, 1, '默认', 'DEFAULT', 'sys_job_group', '', '', 'Y', '0', 'admin', '2021-09-17 18:40:13', '', '2021-09-17 18:40:13', '默认分组');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (11, 2, '系统', 'SYSTEM', 'sys_job_group', '', '', 'N', '0', 'admin', '2021-09-17 18:40:13', '', '2021-09-17 18:40:13', '系统分组');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (12, 1, '是', 'Y', 'sys_yes_no', '', 'primary', 'Y', '0', 'admin', '2021-09-17 18:40:13', '', '2021-09-17 18:40:13', '系统默认是');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (13, 2, '否', 'N', 'sys_yes_no', '', 'danger', 'N', '0', 'admin', '2021-09-17 18:40:13', '', '2021-09-17 18:40:13', '系统默认否');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (14, 1, '通知', '1', 'sys_notice_type', '', 'warning', 'Y', '0', 'admin', '2021-09-17 18:40:13', '', '2021-09-17 18:40:13', '通知');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (15, 2, '公告', '2', 'sys_notice_type', '', 'success', 'N', '0', 'admin', '2021-09-17 18:40:13', '', '2021-09-17 18:40:13', '公告');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (16, 1, '正常', '0', 'sys_notice_status', '', 'primary', 'Y', '0', 'admin', '2021-09-17 18:40:13', '', '2021-09-17 18:40:13', '正常状态');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (17, 2, '关闭', '1', 'sys_notice_status', '', 'danger', 'N', '0', 'admin', '2021-09-17 18:40:13', '', '2021-09-17 18:40:13', '关闭状态');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (18, 1, '新增', '1', 'sys_oper_type', '', 'info', 'N', '0', 'admin', '2021-09-17 18:40:13', '', '2021-09-17 18:40:13', '新增操作');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (19, 2, '修改', '2', 'sys_oper_type', '', 'info', 'N', '0', 'admin', '2021-09-17 18:40:13', '', '2021-09-17 18:40:13', '修改操作');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (20, 3, '删除', '3', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2021-09-17 18:40:13', '', '2021-09-17 18:40:13', '删除操作');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (21, 4, '授权', '4', 'sys_oper_type', '', 'primary', 'N', '0', 'admin', '2021-09-17 18:40:13', '', '2021-09-17 18:40:13', '授权操作');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (22, 5, '导出', '5', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2021-09-17 18:40:13', '', '2021-09-17 18:40:13', '导出操作');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (23, 6, '导入', '6', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2021-09-17 18:40:14', '', '2021-09-17 18:40:13', '导入操作');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (24, 7, '强退', '7', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2021-09-17 18:40:14', '', '2021-09-17 18:40:13', '强退操作');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (25, 8, '生成代码', '8', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2021-09-17 18:40:14', '', '2021-09-17 18:40:13', '生成操作');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (26, 9, '清空数据', '9', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2021-09-17 18:40:14', '', '2021-09-17 18:40:13', '清空操作');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (27, 1, '成功', '0', 'sys_common_status', '', 'primary', 'N', '0', 'admin', '2021-09-17 18:40:14', '', '2021-09-17 18:40:13', '正常状态');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (28, 2, '失败', '1', 'sys_common_status', '', 'danger', 'N', '0', 'admin', '2021-09-17 18:40:14', '', '2021-09-17 18:40:13', '停用状态');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (29, 0, '用户名密码', '0', 'link_device_auth_mode', NULL, 'default', 'N', '0', 'admin', '2021-10-21 17:56:52', 'admin', '2024-03-28 16:38:58', '设备用户名+设备密码');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (30, 1, 'SSL/TLS', '1', 'link_device_auth_mode', NULL, 'default', 'N', '0', 'admin', '2021-10-21 17:59:10', 'admin', '2024-03-28 16:39:07', 'SSL/TLS认证');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (31, 0, '192.168.86.128:18083', '192.168.86.128:18083', 'link_device_connector', NULL, 'default', 'N', '0', 'admin', '2021-10-21 18:11:26', 'admin', '2024-01-15 11:10:53', '本地默认节点');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (32, 0, '启用', 'ENABLE', 'link_device_status', NULL, 'success', 'N', '0', 'admin', '2021-10-22 16:28:13', 'admin', '2021-09-17 18:40:13', '设备启用');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (33, 1, '禁用', 'DISABLE', 'link_device_status', NULL, 'danger', 'N', '0', 'admin', '2021-10-22 16:28:31', 'admin', '2021-09-17 18:40:13', '设备禁用');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (34, 1, '在线', 'ONLINE', 'link_device_connect_status', '', 'success', 'N', '0', 'admin', '2021-10-22 16:35:53', 'admin', '2021-09-17 18:40:13', '设备在线');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (35, 2, '离线', 'OFFLINE', 'link_device_connect_status', '', 'warning', 'N', '0', 'admin', '2021-10-22 16:36:23', 'admin', '2021-09-17 18:40:13', '设备离线');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (36, 0, '未连接', 'INIT', 'link_device_connect_status', '', 'info', 'N', '0', 'admin', '2021-10-22 16:37:15', 'admin', '2021-09-17 18:40:13', '设备未连接');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (37, 0, '是', '0', 'link_device_is_will', NULL, 'primary', 'N', '0', 'admin', '2021-10-22 16:40:55', 'admin', '2021-09-17 18:40:13', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (38, 0, '否', '1', 'link_device_is_will', NULL, 'warning', 'N', '0', 'admin', '2021-10-22 16:41:02', 'admin', '2021-09-17 18:40:13', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (39, 0, 'mqtt', 'MQTT', 'link_device_protocol_type', NULL, 'default', 'N', '0', 'admin', '2021-10-22 16:43:48', 'mqtts', '2021-09-17 18:40:13', 'mqtt');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (40, 1, 'coap', 'COAP', 'link_device_protocol_type', NULL, 'default', 'N', '0', 'admin', '2021-10-22 16:44:02', 'mqtts', '2021-09-17 18:40:13', 'coap');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (41, 2, 'modbus', 'MODBUS', 'link_device_protocol_type', NULL, 'default', 'N', '0', 'admin', '2021-10-22 16:44:15', 'mqtts', '2021-09-17 18:40:13', 'modbus');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (42, 3, 'http', 'HTTP', 'link_device_protocol_type', NULL, 'default', 'N', '0', 'admin', '2021-10-22 16:44:35', 'mqtts', '2021-09-17 18:40:13', 'http');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (43, 0, '普通设备', 'COMMON', 'link_device_device_type', NULL, 'default', 'N', '0', 'admin', '2021-10-22 16:57:26', 'mqtts', '2021-09-17 18:40:13', '普通设备（无子设备也无父设备）');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (44, 1, '网关设备', 'GATEWAY', 'link_device_device_type', NULL, 'default', 'N', '0', 'admin', '2021-10-22 16:57:44', 'mqtts', '2021-09-17 18:40:13', '网关设备(可挂载子设备)');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (46, 1, 'thinglinks', 'thinglinks', 'link_application_type', NULL, 'default', 'N', '0', 'thinglinks', '2021-12-28 13:47:34', 'admin', '2022-11-24 16:28:45', 'thinglinks');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (47, 1, '218.78.103.93:11883', '218.78.103.93:11883', 'link_device_connector', NULL, 'default', 'N', '0', 'thinglinks', '2021-12-28 13:49:09', 'thinglinks', '2021-09-17 18:40:13', '物联网测试环境');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (48, 0, 'Default', 'default', 'link_product_device_type', NULL, 'default', 'N', '0', 'admin', '2022-02-09 16:51:26', '', '2021-09-17 18:40:13', '默认');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (49, 0, '普通产品', 'COMMON', 'link_product_type', NULL, 'default', 'N', '0', 'admin', '2022-02-09 18:02:38', '', '2021-09-17 18:40:13', '普通产品，需直连设备。');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (50, 1, '网关产品', 'GATEWAY', 'link_product_type', NULL, 'default', 'N', '0', 'admin', '2022-02-09 18:02:55', 'admin', '2021-09-17 18:40:13', '网关产品，可挂载子设备。');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (51, 0, '非必填', '0', 'link_product_isRequired', NULL, 'default', 'N', '0', 'admin', '2022-03-25 15:51:10', '', '2021-09-17 18:40:13', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (52, 0, '必填', '1', 'link_product_isRequired', NULL, 'default', 'N', '0', 'admin', '2022-03-25 15:51:19', '', '2021-09-17 18:40:13', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (53, 0, '允许', 'allow', 'link_casbinRule_v3', NULL, 'success', 'N', '0', 'admin', '2022-06-16 18:03:46', 'admin', '2021-09-17 18:40:13', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (55, 0, '拒绝', 'deny', 'link_casbinRule_v3', NULL, 'warning', 'N', '0', 'admin', '2022-06-16 18:05:08', 'admin', '2021-09-17 18:40:13', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (57, 0, '发布', 'PUBLISH', 'link_casbinRule_v2', NULL, 'primary', 'N', '0', 'admin', '2022-06-16 18:13:15', 'admin', '2021-09-17 18:40:13', '发布动作');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (58, 0, '订阅', 'SUBSCRIBE', 'link_casbinRule_v2', NULL, 'info', 'N', '0', 'admin', '2022-06-16 18:21:09', 'admin', '2021-09-17 18:40:13', '订阅动作');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (59, 0, '上线', 'CONNECT', 'link_device_action_type', NULL, 'success', 'N', '0', 'admin', '2022-06-17 17:45:24', 'admin', '2024-03-28 16:22:35', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (60, 0, '离线', 'CLOSE', 'link_device_action_type', NULL, 'warning', 'N', '0', 'admin', '2022-06-17 17:45:49', 'admin', '2024-03-28 16:22:44', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (61, 0, '是', 'true', 'link_deviceInfo_shadow_enable', NULL, 'primary', 'N', '0', 'admin', '2022-06-21 11:28:26', 'admin', '2021-09-17 18:40:13', '支持设备影子');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (62, 0, '否', 'false', 'link_deviceInfo_shadow_enable', NULL, 'danger', 'N', '0', 'admin', '2022-06-21 11:28:46', 'admin', '2021-09-17 18:40:13', '不支持设备影子');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (63, 0, '启用', '0', 'business_data_status', NULL, 'success', 'N', '0', 'admin', '2022-06-21 14:26:47', '', '2021-09-17 18:40:13', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (64, 0, '停用', '1', 'business_data_status', NULL, 'danger', 'N', '0', 'admin', '2022-06-21 14:27:03', '', '2021-09-17 18:40:13', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (65, 0, 'string', 'string', 'link_product_datatype', NULL, 'default', 'N', '0', 'admin', '2022-06-24 18:42:46', '', '2021-09-17 18:40:13', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (66, 0, 'bigint', 'bigint', 'link_product_datatype', NULL, 'default', 'N', '0', 'admin', '2022-06-24 18:42:59', 'admin', '2024-03-24 23:26:51', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (67, 0, 'int', 'int', 'link_product_datatype', NULL, 'default', 'N', '0', 'admin', '2022-06-24 18:43:09', '', '2021-09-17 18:40:13', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (68, 0, 'varBinary', 'varBinary', 'link_product_datatype', NULL, 'default', 'N', '0', 'admin', '2022-06-24 18:43:18', 'admin', '2024-03-24 23:27:15', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (69, 0, 'decimal', 'decimal', 'link_product_datatype', NULL, 'default', 'N', '0', 'admin', '2022-06-24 18:43:28', '', '2021-09-17 18:40:13', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (70, 0, 'DateTime', 'DateTime', 'link_product_datatype', NULL, 'default', 'N', '0', 'admin', '2022-06-24 18:43:58', 'admin', '2024-03-24 23:27:27', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (71, 0, 'jsonObject', 'jsonObject', 'link_product_datatype', NULL, 'default', 'N', '0', 'admin', '2022-06-24 18:44:08', 'admin', '2024-03-24 23:27:37', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (72, 0, 'java', 'java', 'link_protocol_voice', NULL, 'default', 'N', '0', 'admin', '2022-07-04 11:17:07', '', '2021-09-17 18:40:13', 'java');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (73, 3, '协议管理', 'PROTOCOL', 'sys_job_group', NULL, 'default', 'N', '0', 'admin', '2022-07-11 15:48:55', 'admin', '2021-09-17 18:40:13', '协议管理');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (74, 4, '规则触发器', 'RULE_TRIGGER', 'sys_job_group', NULL, 'default', 'N', '0', 'admin', '2022-07-18 18:22:09', 'admin', '2021-09-17 18:40:13', '设备联动规则触发器');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (75, 5, '设备管理', 'LINK_DEVICE', 'sys_job_group', NULL, 'default', 'N', '0', 'admin', '2022-07-29 14:36:31', 'admin', '2021-09-17 18:40:13', '设备管理');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (76, 0, 'zhima', 'zhima', 'link_application_type', NULL, 'default', 'N', '0', 'admin', '2022-11-24 16:28:09', 'admin', '2022-11-24 16:28:22', 'zhima');
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (77, 0, 'PUBLISH', 'PUBLISH', 'link_device_action_type', NULL, 'info', 'N', '0', 'admin', '2024-03-28 16:23:36', 'admin', '2024-03-28 16:24:09', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (78, 0, 'SUBSCRIBE', 'SUBSCRIBE', 'link_device_action_type', NULL, 'info', 'N', '0', 'admin', '2024-03-28 16:23:48', 'admin', '2024-03-28 16:24:16', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (79, 0, 'UNSUBSCRIBE', 'UNSUBSCRIBE', 'link_device_action_type', NULL, 'info', 'N', '0', 'admin', '2024-03-28 16:23:55', 'admin', '2024-03-28 16:24:22', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (80, 0, '明文传输', '0', 'link_device_encrypt_method', NULL, 'default', 'N', '0', 'admin', '2024-03-28 16:49:37', '', '2024-03-28 16:49:37', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (81, 0, 'SM4', '1', 'link_device_encrypt_method', NULL, 'default', 'N', '0', 'admin', '2024-03-28 16:49:49', '', '2024-03-28 16:49:49', NULL);
INSERT INTO `sys_dict_data` (`dict_code`, `dict_sort`, `dict_label`, `dict_value`, `dict_type`, `css_class`, `list_class`, `is_default`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (82, 0, 'AES', '2', 'link_device_encrypt_method', NULL, 'default', 'N', '0', 'admin', '2024-03-28 16:50:02', '', '2024-03-28 16:50:02', NULL);
COMMIT;

-- ----------------------------
-- Table structure for sys_dict_type
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict_type`;
CREATE TABLE `sys_dict_type` (
  `dict_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '字典主键',
  `dict_name` varchar(100) DEFAULT '' COMMENT '字典名称',
  `dict_type` varchar(100) DEFAULT '' COMMENT '字典类型',
  `status` char(1) DEFAULT '0' COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`dict_id`) USING BTREE,
  UNIQUE KEY `dict_type` (`dict_type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='字典类型表';

-- ----------------------------
-- Records of sys_dict_type
-- ----------------------------
BEGIN;
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1, '用户性别', 'sys_user_sex', '0', 'admin', '2021-09-17 18:40:11', '', NULL, '用户性别列表');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (2, '菜单状态', 'sys_show_hide', '0', 'admin', '2021-09-17 18:40:11', '', NULL, '菜单状态列表');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (3, '系统开关', 'sys_normal_disable', '0', 'admin', '2021-09-17 18:40:11', '', NULL, '系统开关列表');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (4, '任务状态', 'sys_job_status', '0', 'admin', '2021-09-17 18:40:12', '', NULL, '任务状态列表');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (5, '任务分组', 'sys_job_group', '0', 'admin', '2021-09-17 18:40:12', '', NULL, '任务分组列表');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (6, '系统是否', 'sys_yes_no', '0', 'admin', '2021-09-17 18:40:12', '', NULL, '系统是否列表');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (7, '通知类型', 'sys_notice_type', '0', 'admin', '2021-09-17 18:40:12', '', NULL, '通知类型列表');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (8, '通知状态', 'sys_notice_status', '0', 'admin', '2021-09-17 18:40:12', '', NULL, '通知状态列表');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (9, '操作类型', 'sys_oper_type', '0', 'admin', '2021-09-17 18:40:12', '', NULL, '操作类型列表');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (10, '系统状态', 'sys_common_status', '0', 'admin', '2021-09-17 18:40:12', '', NULL, '登录状态列表');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (11, '设备认证方式', 'link_device_auth_mode', '0', 'admin', '2021-10-21 17:52:30', '', NULL, '设备管理鉴权方式');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (12, '设备连接实例', 'link_device_connector', '0', 'admin', '2021-10-21 18:10:18', '', NULL, '设备连接实例');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (13, '设备状态', 'link_device_status', '0', 'admin', '2021-10-22 16:27:28', 'mqtts', '2021-10-25 15:48:58', '设备状态');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (14, '连接状态', 'link_device_connect_status', '0', 'admin', '2021-10-22 16:35:11', '', NULL, '设备连接状态\n');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (15, '是否遗言', 'link_device_is_will', '0', 'admin', '2021-10-22 16:40:39', '', NULL, '设备是否有遗言');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (16, '产品协议类型', 'link_device_protocol_type', '0', 'admin', '2021-10-22 16:43:24', '', NULL, '产品协议类型 ：mqtt || coap || modbus || http');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (17, '设备类型', 'link_device_device_type', '0', 'admin', '2021-10-22 16:54:12', 'admin', '2021-10-22 16:56:47', '设备类型0-普通设备（无子设备也无父设备）1-网关设备(可挂载子设备)2-子设备(归属于某个网关设备)。');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (18, '集成应用类型', 'link_application_type', '0', 'thinglinks', '2021-12-28 13:41:22', 'thinglinks', '2021-12-28 13:42:28', '集成应用');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (19, '产品设备类型', 'link_product_device_type', '0', 'admin', '2022-02-09 16:50:14', 'admin', '2022-02-09 17:53:25', '产品设备类型，支持英文大小写、数字、下划线和中划线');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (20, '产品类型', 'link_product_type', '0', 'admin', '2022-02-09 17:52:26', '', NULL, '支持以下两种产品类型：\n•0：普通产品，需直连设备。\n•1：网关产品，可挂载子设备。\n');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (21, '是否必填', 'link_product_isRequired', '0', 'admin', '2022-03-25 15:39:40', '', NULL, NULL);
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (22, 'CAS策略类型', 'link_casbinRule_v3', '0', 'admin', '2022-06-16 18:02:31', '', NULL, 'CAS策略类型：允许||拒绝');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (23, 'CAS策略动作', 'link_casbinRule_v2', '0', 'admin', '2022-06-16 18:11:05', '', NULL, '认证动作');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (24, '设备动作类型', 'link_device_action_type', '0', 'admin', '2022-06-17 17:43:34', '', NULL, NULL);
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (25, '设备影子状态', 'link_deviceInfo_shadow_enable', '0', 'admin', '2022-06-21 11:27:39', '', NULL, '是否支设备影子');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (26, '业务数据状态', 'business_data_status', '0', 'admin', '2022-06-21 14:25:45', '', NULL, '业务数据状态标识（0启用  1停用）');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (27, '指示数据类型', 'link_product_datatype', '0', 'admin', '2022-06-24 18:41:39', '', NULL, '产品模型指示数据类型');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (28, '协议语言', 'link_protocol_voice', '0', 'admin', '2022-07-04 11:16:20', 'admin', '2022-07-04 17:09:29', '协议管理-支持的协议脚本语言');
INSERT INTO `sys_dict_type` (`dict_id`, `dict_name`, `dict_type`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (29, '传输协议的加密方式', 'link_device_encrypt_method', '0', 'admin', '2024-03-28 16:49:08', '', NULL, NULL);
COMMIT;

-- ----------------------------
-- Table structure for sys_job
-- ----------------------------
DROP TABLE IF EXISTS `sys_job`;
CREATE TABLE `sys_job` (
  `job_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '任务ID',
  `job_name` varchar(64) NOT NULL DEFAULT '' COMMENT '任务名称',
  `job_group` varchar(64) NOT NULL DEFAULT 'DEFAULT' COMMENT '任务组名',
  `invoke_target` varchar(500) NOT NULL COMMENT '调用目标字符串',
  `cron_expression` varchar(255) DEFAULT '' COMMENT 'cron执行表达式',
  `misfire_policy` varchar(20) DEFAULT '3' COMMENT '计划执行错误策略（1立即执行 2执行一次 3放弃执行）',
  `concurrent` char(1) DEFAULT '1' COMMENT '是否并发执行（0允许 1禁止）',
  `status` char(1) DEFAULT '0' COMMENT '状态（0正常 1暂停）',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remark` varchar(500) DEFAULT '' COMMENT '备注信息',
  PRIMARY KEY (`job_id`,`job_name`,`job_group`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='定时任务调度表';

-- ----------------------------
-- Records of sys_job
-- ----------------------------
BEGIN;
INSERT INTO `sys_job` (`job_id`, `job_name`, `job_group`, `invoke_target`, `cron_expression`, `misfire_policy`, `concurrent`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1, '系统默认（无参）', 'DEFAULT', 'ryTask.ryNoParams', '0/10 * * * * ?', '3', '1', '1', 'admin', '2021-09-17 18:40:15', 'mqtts', '2021-10-25 03:09:23', '');
INSERT INTO `sys_job` (`job_id`, `job_name`, `job_group`, `invoke_target`, `cron_expression`, `misfire_policy`, `concurrent`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (2, '系统默认（有参）', 'DEFAULT', 'ryTask.ryParams(\'ry\')', '0/15 * * * * ?', '3', '1', '1', 'admin', '2021-09-17 18:40:15', '', '2024-03-24 15:35:18', '');
INSERT INTO `sys_job` (`job_id`, `job_name`, `job_group`, `invoke_target`, `cron_expression`, `misfire_policy`, `concurrent`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (3, '系统默认（多参）', 'DEFAULT', 'ryTask.ryMultipleParams(\'ry\', true, 2000L, 316.50D, 100)', '0/20 * * * * ?', '3', '1', '1', 'admin', '2021-09-17 18:40:15', '', '2022-11-18 13:54:40', '');
INSERT INTO `sys_job` (`job_id`, `job_name`, `job_group`, `invoke_target`, `cron_expression`, `misfire_policy`, `concurrent`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (4, '协议脚本缓存刷新定时任务', 'PROTOCOL', 'linkProtocolTask.protocolScriptCacheRefreshTask', '0 0/10 * * * ?', '2', '0', '0', 'admin', '2022-07-11 15:50:49', 'admin', '2024-05-10 16:55:05', '');
INSERT INTO `sys_job` (`job_id`, `job_name`, `job_group`, `invoke_target`, `cron_expression`, `misfire_policy`, `concurrent`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (7, '刷新子设备数据模型', 'LINK_DEVICE', 'linkDeviceInfoTask.refreshDeviceInfoDataModel(\'\')', '0 0 0/12 * * ?', '1', '1', '1', 'admin', '2022-07-29 14:38:01', 'admin', '2022-07-29 16:09:15', '');
INSERT INTO `sys_job` (`job_id`, `job_name`, `job_group`, `invoke_target`, `cron_expression`, `misfire_policy`, `concurrent`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (12, '刷新子设备设备缓存定时任务', 'LINK_DEVICE', 'cacheDeviceInfoTask.refreshDeviceInfoDataModel(\'\')', '0 0/10 * * * ?', '1', '0', '0', 'admin', '2024-03-24 15:44:48', '', '2024-03-24 15:44:53', '');
INSERT INTO `sys_job` (`job_id`, `job_name`, `job_group`, `invoke_target`, `cron_expression`, `misfire_policy`, `concurrent`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (13, '刷新设备缓存定时任务', 'LINK_DEVICE', 'cacheDeviceTask.refreshAllDeviceCaches(\'\')', '0 0/10 * * * ?', '1', '0', '0', 'admin', '2024-03-24 16:52:51', '', '2024-03-24 16:52:56', '');
INSERT INTO `sys_job` (`job_id`, `job_name`, `job_group`, `invoke_target`, `cron_expression`, `misfire_policy`, `concurrent`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (14, '刷新产品缓存定时任务', 'LINK_DEVICE', 'cacheProductTask.refreshAllProductCaches(\'\')', '0 0/10 * * * ?', '1', '0', '0', 'admin', '2024-03-24 16:54:05', '', '2024-03-24 16:54:09', '');
INSERT INTO `sys_job` (`job_id`, `job_name`, `job_group`, `invoke_target`, `cron_expression`, `misfire_policy`, `concurrent`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (15, '刷新产品模型缓存定时任务', 'LINK_DEVICE', 'cacheProductModelTask.refreshAllProductModelCaches(\'\')', '0 0/10 * * * ?', '1', '0', '0', 'admin', '2024-03-24 16:55:54', '', '2024-03-24 16:56:00', '');
COMMIT;

-- ----------------------------
-- Table structure for sys_job_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_job_log`;
CREATE TABLE `sys_job_log` (
  `job_log_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '任务日志ID',
  `job_name` varchar(64) NOT NULL COMMENT '任务名称',
  `job_group` varchar(64) NOT NULL COMMENT '任务组名',
  `invoke_target` varchar(500) NOT NULL COMMENT '调用目标字符串',
  `job_message` varchar(500) DEFAULT NULL COMMENT '日志信息',
  `status` char(1) DEFAULT '0' COMMENT '执行状态（0正常 1失败）',
  `exception_info` varchar(2000) DEFAULT '' COMMENT '异常信息',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`job_log_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4578 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='定时任务调度日志表';

-- ----------------------------
-- Records of sys_job_log
-- ----------------------------
BEGIN;
INSERT INTO `sys_job_log` (`job_log_id`, `job_name`, `job_group`, `invoke_target`, `job_message`, `status`, `exception_info`, `create_time`) VALUES (4562, '协议脚本缓存刷新定时任务', 'PROTOCOL', 'linkProtocolTask.protocolScriptCacheRefreshTask', '协议脚本缓存刷新定时任务 总共耗时：10078毫秒', '0', '', '2024-05-10 16:55:22');
INSERT INTO `sys_job_log` (`job_log_id`, `job_name`, `job_group`, `invoke_target`, `job_message`, `status`, `exception_info`, `create_time`) VALUES (4563, '协议脚本缓存刷新定时任务', 'PROTOCOL', 'linkProtocolTask.protocolScriptCacheRefreshTask', '协议脚本缓存刷新定时任务 总共耗时：10009毫秒', '0', '', '2024-05-10 17:00:10');
INSERT INTO `sys_job_log` (`job_log_id`, `job_name`, `job_group`, `invoke_target`, `job_message`, `status`, `exception_info`, `create_time`) VALUES (4564, '刷新产品缓存定时任务', 'LINK_DEVICE', 'cacheProductTask.refreshAllProductCaches(\'\')', '刷新产品缓存定时任务 总共耗时：8226毫秒', '0', '', '2024-05-10 17:00:11');
INSERT INTO `sys_job_log` (`job_log_id`, `job_name`, `job_group`, `invoke_target`, `job_message`, `status`, `exception_info`, `create_time`) VALUES (4565, '刷新子设备设备缓存定时任务', 'LINK_DEVICE', 'cacheDeviceInfoTask.refreshDeviceInfoDataModel(\'\')', '刷新子设备设备缓存定时任务 总共耗时：10004毫秒', '0', '', '2024-05-10 17:00:11');
INSERT INTO `sys_job_log` (`job_log_id`, `job_name`, `job_group`, `invoke_target`, `job_message`, `status`, `exception_info`, `create_time`) VALUES (4566, '刷新产品模型缓存定时任务', 'LINK_DEVICE', 'cacheProductModelTask.refreshAllProductModelCaches(\'\')', '刷新产品模型缓存定时任务 总共耗时：7707毫秒', '0', '', '2024-05-10 17:00:11');
INSERT INTO `sys_job_log` (`job_log_id`, `job_name`, `job_group`, `invoke_target`, `job_message`, `status`, `exception_info`, `create_time`) VALUES (4567, '刷新设备缓存定时任务', 'LINK_DEVICE', 'cacheDeviceTask.refreshAllDeviceCaches(\'\')', '刷新设备缓存定时任务 总共耗时：9381毫秒', '0', '', '2024-05-10 17:00:11');
INSERT INTO `sys_job_log` (`job_log_id`, `job_name`, `job_group`, `invoke_target`, `job_message`, `status`, `exception_info`, `create_time`) VALUES (4568, '协议脚本缓存刷新定时任务', 'PROTOCOL', 'linkProtocolTask.protocolScriptCacheRefreshTask', '协议脚本缓存刷新定时任务 总共耗时：10010毫秒', '0', '', '2024-05-10 17:10:10');
INSERT INTO `sys_job_log` (`job_log_id`, `job_name`, `job_group`, `invoke_target`, `job_message`, `status`, `exception_info`, `create_time`) VALUES (4569, '刷新子设备设备缓存定时任务', 'LINK_DEVICE', 'cacheDeviceInfoTask.refreshDeviceInfoDataModel(\'\')', '刷新子设备设备缓存定时任务 总共耗时：10020毫秒', '0', '', '2024-05-10 17:10:11');
INSERT INTO `sys_job_log` (`job_log_id`, `job_name`, `job_group`, `invoke_target`, `job_message`, `status`, `exception_info`, `create_time`) VALUES (4570, '刷新设备缓存定时任务', 'LINK_DEVICE', 'cacheDeviceTask.refreshAllDeviceCaches(\'\')', '刷新设备缓存定时任务 总共耗时：10005毫秒', '0', '', '2024-05-10 17:10:12');
INSERT INTO `sys_job_log` (`job_log_id`, `job_name`, `job_group`, `invoke_target`, `job_message`, `status`, `exception_info`, `create_time`) VALUES (4571, '刷新产品缓存定时任务', 'LINK_DEVICE', 'cacheProductTask.refreshAllProductCaches(\'\')', '刷新产品缓存定时任务 总共耗时：10013毫秒', '0', '', '2024-05-10 17:10:13');
INSERT INTO `sys_job_log` (`job_log_id`, `job_name`, `job_group`, `invoke_target`, `job_message`, `status`, `exception_info`, `create_time`) VALUES (4572, '刷新产品模型缓存定时任务', 'LINK_DEVICE', 'cacheProductModelTask.refreshAllProductModelCaches(\'\')', '刷新产品模型缓存定时任务 总共耗时：10013毫秒', '0', '', '2024-05-10 17:10:14');
INSERT INTO `sys_job_log` (`job_log_id`, `job_name`, `job_group`, `invoke_target`, `job_message`, `status`, `exception_info`, `create_time`) VALUES (4573, '协议脚本缓存刷新定时任务', 'PROTOCOL', 'linkProtocolTask.protocolScriptCacheRefreshTask', '协议脚本缓存刷新定时任务 总共耗时：6338毫秒', '0', '', '2024-05-10 17:20:06');
INSERT INTO `sys_job_log` (`job_log_id`, `job_name`, `job_group`, `invoke_target`, `job_message`, `status`, `exception_info`, `create_time`) VALUES (4574, '刷新产品缓存定时任务', 'LINK_DEVICE', 'cacheProductTask.refreshAllProductCaches(\'\')', '刷新产品缓存定时任务 总共耗时：3944毫秒', '0', '', '2024-05-10 17:20:07');
INSERT INTO `sys_job_log` (`job_log_id`, `job_name`, `job_group`, `invoke_target`, `job_message`, `status`, `exception_info`, `create_time`) VALUES (4575, '刷新子设备设备缓存定时任务', 'LINK_DEVICE', 'cacheDeviceInfoTask.refreshDeviceInfoDataModel(\'\')', '刷新子设备设备缓存定时任务 总共耗时：5936毫秒', '0', '', '2024-05-10 17:20:07');
INSERT INTO `sys_job_log` (`job_log_id`, `job_name`, `job_group`, `invoke_target`, `job_message`, `status`, `exception_info`, `create_time`) VALUES (4576, '刷新设备缓存定时任务', 'LINK_DEVICE', 'cacheDeviceTask.refreshAllDeviceCaches(\'\')', '刷新设备缓存定时任务 总共耗时：5121毫秒', '0', '', '2024-05-10 17:20:07');
INSERT INTO `sys_job_log` (`job_log_id`, `job_name`, `job_group`, `invoke_target`, `job_message`, `status`, `exception_info`, `create_time`) VALUES (4577, '刷新产品模型缓存定时任务', 'LINK_DEVICE', 'cacheProductModelTask.refreshAllProductModelCaches(\'\')', '刷新产品模型缓存定时任务 总共耗时：3405毫秒', '0', '', '2024-05-10 17:20:07');
COMMIT;

-- ----------------------------
-- Table structure for sys_logininfor
-- ----------------------------
DROP TABLE IF EXISTS `sys_logininfor`;
CREATE TABLE `sys_logininfor` (
  `info_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '访问ID',
  `user_name` varchar(50) DEFAULT '' COMMENT '用户账号',
  `ipaddr` varchar(128) DEFAULT '' COMMENT '登录IP地址',
  `status` char(1) DEFAULT '0' COMMENT '登录状态（0成功 1失败）',
  `msg` varchar(255) DEFAULT '' COMMENT '提示信息',
  `access_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '访问时间',
  PRIMARY KEY (`info_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=817 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='系统访问记录';

-- ----------------------------
-- Records of sys_logininfor
-- ----------------------------
BEGIN;
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (322, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-19 16:24:21');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (323, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-19 22:29:59');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (324, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-19 22:30:28');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (325, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-19 22:31:21');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (326, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-19 22:31:45');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (327, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-19 22:32:18');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (328, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-20 16:27:44');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (329, 'admin', '127.0.0.1', '0', '退出成功', '2022-11-20 16:37:17');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (330, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-20 16:38:01');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (331, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-20 21:11:57');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (332, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-21 11:27:17');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (333, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-21 11:27:42');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (334, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-21 11:28:18');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (335, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-21 11:28:25');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (336, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-21 11:28:59');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (337, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-21 16:45:07');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (338, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-21 17:11:06');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (339, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-21 18:03:21');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (340, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-21 18:04:45');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (341, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-21 18:05:16');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (342, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-21 18:07:08');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (343, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-21 18:08:27');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (344, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-21 19:01:09');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (345, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-21 21:42:16');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (346, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-22 10:19:43');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (347, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-22 10:20:00');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (348, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-22 13:02:11');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (349, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-22 16:15:04');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (350, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-22 20:16:58');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (351, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-22 20:33:48');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (352, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-22 20:34:45');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (353, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-22 20:35:28');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (354, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-22 20:36:33');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (355, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-22 20:37:03');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (356, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-22 20:37:47');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (357, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-22 20:39:56');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (358, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-22 20:40:42');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (359, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-22 20:40:49');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (360, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-22 20:42:07');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (361, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-22 20:42:59');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (362, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-22 20:43:24');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (363, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-22 20:49:10');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (364, 'test', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-22 20:50:52');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (365, 'test', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-22 20:51:17');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (366, 'test', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-22 20:53:51');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (367, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-23 09:41:37');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (368, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-23 11:30:15');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (369, 'test', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 12:25:12');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (370, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 12:26:06');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (371, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 12:27:00');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (372, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 12:27:34');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (373, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 12:27:48');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (374, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 12:28:20');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (375, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 12:28:51');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (376, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 12:33:59');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (377, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 12:34:59');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (378, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 12:35:06');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (379, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 12:38:14');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (380, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 12:38:41');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (381, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 12:39:18');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (382, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 12:46:16');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (383, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 12:55:03');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (384, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 12:55:13');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (385, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 12:55:43');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (386, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 12:58:18');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (387, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 12:59:33');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (388, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 13:01:08');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (389, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 13:02:10');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (390, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 13:02:22');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (391, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 13:05:18');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (392, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 13:05:55');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (393, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 13:06:06');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (394, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 13:09:36');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (395, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 13:09:57');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (396, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-23 13:10:55');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (397, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-23 14:47:40');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (398, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-23 14:48:14');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (399, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-23 14:48:38');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (400, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-23 14:49:48');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (401, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-23 16:21:34');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (402, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-23 18:52:36');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (403, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-23 20:12:54');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (404, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 20:15:13');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (405, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 20:15:53');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (406, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-23 20:17:09');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (407, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-23 20:17:32');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (408, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-23 20:22:57');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (409, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-23 20:43:38');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (410, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-23 20:45:07');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (411, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-24 09:56:23');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (412, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-24 11:29:36');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (413, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-24 11:33:46');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (414, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-24 14:50:16');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (415, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-24 16:14:55');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (416, 'admin', '127.0.0.1', '0', '退出成功', '2022-11-24 16:26:12');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (417, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-24 16:26:21');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (418, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-24 17:31:34');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (419, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-24 17:35:16');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (420, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-24 17:48:23');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (421, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-24 18:20:51');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (422, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-24 18:25:54');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (423, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-24 18:28:19');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (424, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-24 20:20:39');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (425, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-24 20:21:35');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (426, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-24 20:21:53');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (427, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-24 20:22:04');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (428, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-24 20:23:08');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (429, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-24 20:23:13');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (430, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-24 20:23:32');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (431, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-25 11:38:38');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (432, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-25 11:41:02');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (433, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-26 19:12:41');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (434, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-27 10:46:42');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (435, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-28 12:54:35');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (436, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-28 22:06:59');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (437, 'admin', '127.0.0.1', '0', '退出成功', '2022-11-29 10:20:54');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (438, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-29 10:21:06');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (439, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-29 16:21:45');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (440, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-29 19:40:15');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (441, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-29 19:45:35');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (442, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-30 10:36:52');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (443, 'test', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-30 14:34:08');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (444, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-30 14:35:06');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (445, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-30 14:35:50');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (446, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2022-11-30 14:35:52');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (447, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-30 14:36:33');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (448, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-30 14:37:50');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (449, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-11-30 14:46:25');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (450, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-30 15:42:41');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (451, 'admin', '127.0.0.1', '0', '登录成功', '2022-11-30 19:44:00');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (452, 'admin', '127.0.0.1', '0', '登录成功', '2022-12-02 18:47:45');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (453, 'admin', '127.0.0.1', '0', '退出成功', '2022-12-02 18:57:46');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (454, 'admin', '127.0.0.1', '0', '登录成功', '2022-12-02 18:57:59');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (455, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-02 19:08:39');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (456, 'admin', '127.0.0.1', '0', '登录成功', '2022-12-02 19:08:55');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (457, 'admin', '127.0.0.1', '0', '登录成功', '2022-12-03 10:39:44');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (458, 'admin', '221.218.209.195', '0', '登录成功', '2022-12-04 22:17:28');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (459, 'admin', '111.162.217.6', '1', '用户密码不在指定范围', '2022-12-04 22:17:38');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (460, 'admin', '111.162.217.6', '0', '登录成功', '2022-12-04 22:17:50');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (461, 'admin', '221.218.209.195', '0', '退出成功', '2022-12-04 22:22:27');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (462, 'admin', '221.218.209.195', '0', '登录成功', '2022-12-04 22:22:55');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (463, 'thinglinks', '120.244.192.161', '1', '对不起，您的账号已被删除', '2022-12-04 22:43:35');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (464, 'thinglinks', '124.166.160.12', '1', '对不起，您的账号已被删除', '2022-12-04 22:48:40');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (465, 'thinglinks', '124.166.160.12', '1', '对不起，您的账号已被删除', '2022-12-04 22:49:22');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (466, 'admin', '124.166.160.12', '1', '用户密码错误', '2022-12-04 22:49:41');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (467, 'thinglinks', '112.87.97.122', '1', '对不起，您的账号已被删除', '2022-12-04 23:05:52');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (468, 'admin', '221.218.209.195', '0', '登录成功', '2022-12-05 00:07:03');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (469, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-06 14:47:05');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (470, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-06 14:47:27');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (471, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-06 14:47:53');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (472, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-06 14:52:14');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (473, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-06 14:52:55');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (474, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-06 14:53:36');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (475, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-06 14:54:07');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (476, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-06 14:58:20');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (477, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-06 15:05:31');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (478, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-06 15:06:09');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (479, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-06 17:46:07');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (480, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-06 18:03:09');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (481, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-07 13:34:56');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (482, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-07 13:35:29');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (483, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-07 13:35:55');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (484, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-07 13:39:54');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (485, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-07 14:07:20');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (486, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-07 14:07:54');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (487, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-07 14:08:39');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (488, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-07 14:20:45');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (489, 'admin', '127.0.0.1', '0', '登录成功', '2022-12-07 14:21:02');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (490, 'admin', '127.0.0.1', '0', '登录成功', '2022-12-08 10:09:32');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (491, 'admin', '127.0.0.1', '0', '登录成功', '2022-12-09 10:57:05');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (492, 'admin', '127.0.0.1', '0', '登录成功', '2022-12-10 17:02:16');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (493, 'admin', '127.0.0.1', '0', '登录成功', '2022-12-12 13:55:38');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (494, 'admin', '127.0.0.1', '0', '登录成功', '2022-12-12 13:58:34');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (495, 'admin', '127.0.0.1', '0', '登录成功', '2022-12-12 14:51:24');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (496, 'admin', '127.0.0.1', '0', '登录成功', '2022-12-13 10:38:03');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (497, 'admin', '127.0.0.1', '0', '登录成功', '2022-12-14 11:11:51');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (498, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-14 13:06:01');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (499, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-14 13:06:16');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (500, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-14 13:06:28');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (501, 'admin', '127.0.0.1', '0', '登录成功', '2022-12-14 13:07:52');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (502, 'admin', '127.0.0.1', '0', '登录成功', '2022-12-14 14:30:53');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (503, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-14 14:56:58');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (504, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-14 14:57:08');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (505, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-14 14:57:27');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (506, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-14 14:58:29');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (507, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-14 14:59:44');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (508, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-14 15:00:01');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (509, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-14 15:01:53');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (510, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-14 15:03:36');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (511, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-14 15:03:49');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (512, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-14 15:04:01');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (513, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-14 15:04:20');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (514, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-14 15:11:05');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (515, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-14 15:11:23');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (516, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-14 15:12:01');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (517, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-14 15:16:11');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (518, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-14 15:16:28');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (519, 'admin', '127.0.0.1', '0', '登录成功', '2022-12-14 15:18:07');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (520, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-19 14:08:48');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (521, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-19 14:13:40');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (522, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-19 14:13:54');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (523, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-19 14:15:08');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (524, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-19 14:15:59');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (525, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-19 14:16:08');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (526, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-19 14:16:57');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (527, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-19 14:17:15');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (528, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-19 14:17:36');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (529, 'admin', '127.0.0.1', '1', '用户密码错误', '2022-12-19 14:18:52');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (530, 'admin', '127.0.0.1', '0', '登录成功', '2022-12-19 14:20:19');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (531, 'admin', '127.0.0.1', '0', '登录成功', '2022-12-24 11:32:09');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (532, 'admin', '127.0.0.1', '0', '登录成功', '2022-12-24 11:32:30');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (533, 'admin', '127.0.0.1', '0', '登录成功', '2022-12-26 10:45:10');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (534, 'admin', '127.0.0.1', '0', '登录成功', '2022-12-27 14:02:09');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (535, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-01-03 19:53:58');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (536, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-01-03 19:54:10');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (537, 'admin', '127.0.0.1', '0', '登录成功', '2023-01-03 19:55:40');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (538, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-01-03 20:19:59');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (539, 'admin', '127.0.0.1', '0', '登录成功', '2023-01-03 20:20:28');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (540, 'admin', '127.0.0.1', '0', '登录成功', '2023-01-03 20:44:22');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (541, 'admin', '127.0.0.1', '0', '登录成功', '2023-01-04 09:38:09');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (542, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-02-21 17:06:46');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (543, 'admin', '127.0.0.1', '0', '登录成功', '2023-02-21 17:07:28');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (544, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-03-22 09:41:13');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (545, 'admin', '127.0.0.1', '0', '登录成功', '2023-03-22 09:41:52');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (546, 'admin', '127.0.0.1', '0', '登录成功', '2023-03-24 23:59:55');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (547, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-03-28 00:08:46');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (548, 'admin', '127.0.0.1', '0', '登录成功', '2023-03-28 00:09:19');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (549, 'admin', '127.0.0.1', '0', '登录成功', '2023-03-28 22:41:45');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (550, 'admin', '127.0.0.1', '0', '登录成功', '2023-04-04 14:43:00');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (551, 'admin', '127.0.0.1', '0', '登录成功', '2023-04-20 23:22:40');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (552, 'admin', '127.0.0.1', '0', '登录成功', '2023-04-24 23:07:27');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (553, 'admin', '127.0.0.1', '0', '登录成功', '2023-05-02 18:28:30');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (554, 'admin', '127.0.0.1', '0', '登录成功', '2023-05-03 16:08:00');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (555, 'admin', '127.0.0.1', '0', '登录成功', '2023-05-03 19:38:16');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (556, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-09-14 16:30:13');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (557, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-09-14 16:31:22');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (558, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2023-09-14 16:34:11');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (559, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2023-09-14 16:34:35');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (560, '18222601949', '127.0.0.1', '1', '对不起，您的账号已被删除', '2023-09-14 16:37:14');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (561, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2023-09-14 16:39:19');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (562, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-09-14 16:57:36');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (563, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-09-14 17:03:17');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (564, 'admin', '127.0.0.1', '0', '登录成功', '2023-09-14 17:05:15');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (565, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-09-15 15:23:38');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (566, 'admin', '127.0.0.1', '0', '登录成功', '2023-09-15 15:25:28');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (567, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-10-27 23:05:03');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (568, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-10-27 23:05:25');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (569, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2023-10-27 23:06:24');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (570, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2023-10-27 23:06:55');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (571, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-10-27 23:07:32');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (572, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-10-27 23:07:41');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (573, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-10-27 23:07:54');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (574, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-10-27 23:08:10');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (575, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-10-27 23:08:40');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (576, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-10-28 08:02:29');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (577, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-10-28 08:07:10');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (578, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-10-28 08:07:18');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (579, 'admin', '103.100.176.35', '1', '用户密码错误', '2023-10-29 15:22:37');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (580, 'admin', '127.0.0.1', '0', '登录成功', '2023-11-02 18:20:19');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (581, 'admin', '127.0.0.1', '0', '登录成功', '2023-11-06 14:49:37');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (582, 'admin', '127.0.0.1', '0', '登录成功', '2023-11-06 14:58:24');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (583, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-08 16:15:22');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (584, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-08 16:18:36');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (585, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-08 16:21:23');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (586, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-09 19:39:08');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (587, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-09 19:39:19');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (588, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-09 19:40:06');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (589, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-09 19:40:17');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (590, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-09 19:42:07');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (591, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-09 19:42:23');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (592, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-09 19:45:33');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (593, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-09 19:46:53');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (594, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-09 19:49:36');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (595, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-09 19:53:07');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (596, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-09 19:53:32');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (597, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-09 19:53:40');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (598, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-09 19:54:01');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (599, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-09 19:57:03');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (600, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-09 20:05:27');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (601, 'admin', '127.0.0.1', '0', '登录成功', '2023-11-09 20:06:25');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (602, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-10 20:05:28');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (603, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-10 20:05:44');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (604, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-13 17:01:18');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (605, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-13 17:02:40');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (606, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-13 17:04:56');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (607, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-13 17:26:37');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (608, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-13 17:27:14');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (609, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-13 17:29:46');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (610, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-13 17:35:23');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (611, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-13 18:12:25');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (612, 'admin', '127.0.0.1', '0', '登录成功', '2023-11-13 18:34:50');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (613, 'admin', '127.0.0.1', '0', '登录成功', '2023-11-14 10:30:26');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (614, 'admin', '127.0.0.1', '0', '登录成功', '2023-11-14 10:30:47');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (615, 'admin', '127.0.0.1', '0', '退出成功', '2023-11-14 14:56:26');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (616, 'admin', '127.0.0.1', '0', '登录成功', '2023-11-14 14:57:37');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (617, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-18 21:40:53');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (618, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-18 21:41:07');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (619, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-18 21:56:17');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (620, 'admin', '127.0.0.1', '0', '登录成功', '2023-11-18 22:03:39');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (621, 'admin', '127.0.0.1', '0', '退出成功', '2023-11-18 22:09:03');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (622, 'hitelcom', '127.0.0.1', '0', '登录成功', '2023-11-18 22:09:54');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (623, 'hitelcom', '127.0.0.1', '0', '登录成功', '2023-11-19 20:23:20');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (624, 'admin', '127.0.0.1', '0', '登录成功', '2023-11-23 09:18:39');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (625, 'admin', '127.0.0.1', '0', '退出成功', '2023-11-23 09:29:26');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (626, 'admin', '127.0.0.1', '0', '登录成功', '2023-11-23 09:29:35');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (627, 'hitelcom', '127.0.0.1', '0', '登录成功', '2023-11-24 20:49:16');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (628, 'hitelcom', '127.0.0.1', '0', '登录成功', '2023-11-26 15:16:13');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (629, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-26 22:39:07');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (630, 'admin', '127.0.0.1', '0', '登录成功', '2023-11-26 22:40:22');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (631, 'hitelcom', '127.0.0.1', '0', '登录成功', '2023-11-27 22:10:46');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (632, 'hitelcom', '127.0.0.1', '0', '退出成功', '2023-11-27 22:28:13');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (633, 'hitelcom', '127.0.0.1', '0', '登录成功', '2023-11-27 22:28:23');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (634, 'hitelcom', '127.0.0.1', '0', '登录成功', '2023-11-27 22:37:41');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (635, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-28 17:13:28');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (636, 'admin', '127.0.0.1', '1', '用户密码错误$2a$10$03Rpfc5ykyzqqZddjHYPVOAqGVkxuGVMpsYNsvB50QN0Cd5exvHh.', '2023-11-28 17:17:37');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (637, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-11-28 17:18:38');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (638, 'admin', '127.0.0.1', '1', '用户密码不在指定范围', '2023-11-28 17:23:45');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (639, 'admin', '127.0.0.1', '0', '登录成功', '2023-11-28 17:23:56');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (640, 'admin', '127.0.0.1', '0', '登录成功', '2023-11-29 09:30:51');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (641, 'hitelcom', '127.0.0.1', '0', '登录成功', '2023-11-29 21:04:09');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (642, 'admin', '127.0.0.1', '0', '登录成功', '2023-11-30 09:30:28');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (643, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-04 15:33:37');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (644, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-04 15:35:28');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (645, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-04 15:37:30');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (646, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-04 15:38:08');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (647, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-04 15:40:58');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (648, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-04 15:46:59');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (649, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-04 15:47:22');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (650, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2023-12-04 15:51:09');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (651, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-04 15:51:37');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (652, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-04 15:52:47');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (653, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-04 15:54:58');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (654, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-04 15:56:26');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (655, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-04 15:57:53');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (656, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-04 16:03:39');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (657, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-04 16:04:01');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (658, 'hitelcom', '58.34.206.202', '1', '用户密码错误', '2023-12-05 10:11:08');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (659, 'hitelcom', '58.34.206.202', '0', '登录成功', '2023-12-05 10:11:31');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (660, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-06 15:11:17');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (661, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-06 15:16:30');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (662, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-06 15:17:41');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (663, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-06 15:18:24');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (664, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-06 15:18:34');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (665, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-06 15:44:53');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (666, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-06 16:01:01');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (667, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-06 16:02:05');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (668, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-06 16:04:08');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (669, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-06 16:05:46');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (670, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-06 16:20:59');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (671, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-06 16:25:26');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (672, 'hitelcom', '58.34.206.202', '0', '登录成功', '2023-12-06 17:21:32');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (673, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-06 18:19:43');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (674, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-06 18:19:57');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (675, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-06 18:20:08');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (676, 'hitelcom', '58.34.206.202', '0', '登录成功', '2023-12-07 13:27:57');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (677, 'hitelcom', '58.34.206.202', '0', '登录成功', '2023-12-07 15:36:12');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (678, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-07 15:51:41');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (679, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-07 15:58:16');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (680, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-08 18:08:27');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (681, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-13 17:31:16');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (682, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-21 10:33:14');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (683, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-21 10:33:54');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (684, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-21 10:35:06');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (685, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-21 10:35:39');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (686, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-21 10:43:54');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (687, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-21 11:03:19');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (688, 'test', '127.0.0.1', '1', '对不起，您的账号已被删除', '2023-12-21 11:04:13');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (689, 'test', '127.0.0.1', '1', '对不起，您的账号已被删除', '2023-12-21 11:04:31');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (690, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-21 11:10:17');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (691, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-21 11:11:12');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (692, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2023-12-21 11:17:10');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (693, '18222601949', '127.0.0.1', '1', '对不起，您的账号已被删除', '2023-12-21 11:18:20');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (694, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-21 11:18:33');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (695, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-23 15:29:53');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (696, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-25 13:30:42');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (697, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-25 17:00:04');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (698, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-26 19:46:26');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (699, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-27 20:34:17');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (700, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-29 14:25:09');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (701, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-29 15:22:14');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (702, 'root', '127.0.0.1', '0', '登录成功', '2023-12-29 15:23:36');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (703, 'root', '127.0.0.1', '0', '退出成功', '2023-12-29 15:24:23');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (704, 'hitelcom', '127.0.0.1', '1', '用户密码错误', '2023-12-29 15:24:47');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (705, 'ywq', '127.0.0.1', '0', '登录成功', '2023-12-29 15:25:01');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (706, 'ywq', '192.168.20.110', '0', '登录成功', '2023-12-29 15:28:18');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (707, 'admin', '192.168.20.5', '0', '登录成功', '2023-12-29 15:28:41');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (708, 'admin', '192.168.20.5', '0', '退出成功', '2023-12-29 15:29:33');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (709, 'thinglinks', '192.168.20.5', '1', '对不起，您的账号已被删除', '2023-12-29 15:30:03');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (710, 'admin', '192.168.20.5', '0', '登录成功', '2023-12-29 15:33:50');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (711, 'ywq', '192.168.20.110', '0', '退出成功', '2023-12-29 15:38:27');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (712, 'ywq', '192.168.20.110', '0', '登录成功', '2023-12-29 15:39:16');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (713, 'admin', '192.168.22.24', '0', '登录成功', '2023-12-29 15:46:01');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (714, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-31 10:46:17');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (715, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-31 10:47:33');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (716, 'admin', '127.0.0.1', '1', '用户密码错误', '2023-12-31 10:54:20');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (717, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-31 10:56:02');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (718, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-31 10:56:56');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (719, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-31 16:34:30');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (720, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-31 16:34:43');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (721, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-31 16:53:33');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (722, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-31 16:54:43');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (723, 'admin', '127.0.0.1', '0', '退出成功', '2023-12-31 17:46:05');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (724, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-31 17:47:46');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (725, 'admin', '127.0.0.1', '0', '退出成功', '2023-12-31 18:13:29');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (726, 'admin', '127.0.0.1', '0', '登录成功', '2023-12-31 18:13:44');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (727, 'admin', '127.0.0.1', '0', '登录成功', '2024-01-02 15:08:58');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (728, 'admin', '127.0.0.1', '0', '退出成功', '2024-01-02 15:50:23');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (729, 'admin', '127.0.0.1', '0', '登录成功', '2024-01-02 15:50:30');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (730, 'admin', '127.0.0.1', '0', '退出成功', '2024-01-02 15:51:01');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (731, 'admin', '127.0.0.1', '0', '登录成功', '2024-01-02 15:51:09');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (732, 'admin', '127.0.0.1', '0', '退出成功', '2024-01-02 16:06:17');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (733, 'admin', '127.0.0.1', '0', '登录成功', '2024-01-02 16:06:30');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (734, 'admin', '127.0.0.1', '0', '退出成功', '2024-01-02 16:10:29');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (735, 'admin', '127.0.0.1', '0', '登录成功', '2024-01-02 16:12:20');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (736, 'admin', '127.0.0.1', '0', '退出成功', '2024-01-02 20:25:41');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (737, 'admin', '127.0.0.1', '0', '登录成功', '2024-01-02 20:25:50');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (738, 'admin', '127.0.0.1', '0', '退出成功', '2024-01-02 20:26:01');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (739, 'admin', '127.0.0.1', '0', '登录成功', '2024-01-02 20:28:11');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (740, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-03 10:55:50');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (741, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-03 11:42:11');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (742, 'admin', '127.0.0.1', '0', '登录成功', '2024-01-03 11:43:20');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (743, 'admin', '127.0.0.1', '0', '退出成功', '2024-01-03 11:43:39');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (744, 'admin', '127.0.0.1', '0', '登录成功', '2024-01-03 11:44:09');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (745, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-03 11:45:24');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (746, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-03 11:48:57');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (747, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-03 11:51:21');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (748, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-03 11:53:03');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (749, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-03 12:06:35');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (750, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-03 12:16:47');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (751, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-03 12:19:55');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (752, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-03 12:20:08');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (753, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-03 12:24:36');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (754, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-03 12:24:50');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (755, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-03 12:26:39');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (756, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-03 12:27:18');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (757, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-03 12:27:47');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (758, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2024-01-03 12:28:21');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (759, 'thinglinks', '127.0.0.1', '1', '对不起，您的账号已被删除', '2024-01-03 12:32:19');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (760, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-03 12:34:33');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (761, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-03 12:35:04');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (762, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-03 12:39:27');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (763, 'test', '127.0.0.1', '1', '用户密码不在指定范围', '2024-01-03 12:40:13');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (764, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-03 12:41:17');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (765, 'admin', '127.0.0.1', '0', '退出成功', '2024-01-03 12:50:32');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (766, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-03 12:50:42');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (767, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-04 11:19:24');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (768, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-04 11:24:36');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (769, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-04 11:27:05');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (770, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-05 16:28:30');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (771, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-05 16:29:14');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (772, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-05 16:40:37');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (773, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-06 14:50:28');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (774, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-06 20:11:21');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (775, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-06 20:11:45');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (776, 'admin', '127.0.0.1', '0', '登录成功', '2024-01-15 10:54:57');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (777, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-15 14:11:51');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (778, 'admin', '127.0.0.1', '0', '登录成功', '2024-01-15 14:15:10');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (779, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-16 09:51:03');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (780, 'admin', '127.0.0.1', '0', '登录成功', '2024-01-16 09:51:16');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (781, 'admin', '192.168.1.55', '1', '用户密码错误', '2024-01-17 15:06:18');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (782, 'admin', '192.168.1.55', '1', '用户密码错误', '2024-01-17 15:06:39');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (783, 'admin', '192.168.1.55', '1', '用户密码错误', '2024-01-17 15:06:49');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (784, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-01-17 15:22:32');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (785, 'admin', '127.0.0.1', '0', '登录成功', '2024-01-17 15:24:06');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (786, 'admin', '192.168.1.55', '0', '登录成功', '2024-01-18 10:12:15');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (787, 'admin', '192.168.1.37', '0', '登录成功', '2024-01-18 10:24:29');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (788, 'admin', '10.1.177.172', '0', '登录成功', '2024-01-18 11:31:35');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (789, 'admin', '10.1.177.172', '0', '登录成功', '2024-01-18 11:32:10');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (790, 'admin', '10.1.177.172', '0', '退出成功', '2024-01-18 13:58:16');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (791, 'admin', '127.0.0.1', '1', '用户密码不在指定范围', '2024-03-14 10:41:12');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (792, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-03-14 10:41:21');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (793, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-03-14 10:42:23');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (794, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-03-14 10:44:59');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (795, 'admin', '127.0.0.1', '0', '登录成功', '2024-03-14 10:50:12');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (796, 'admin', '127.0.0.1', '0', '登录成功', '2024-03-24 01:46:16');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (797, 'admin', '127.0.0.1', '0', '退出成功', '2024-03-24 20:31:38');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (798, 'hitelcom', '127.0.0.1', '0', '登录成功', '2024-03-24 20:31:50');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (799, 'hitelcom', '127.0.0.1', '0', '退出成功', '2024-03-24 20:34:01');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (800, 'admin', '127.0.0.1', '0', '登录成功', '2024-03-24 20:34:11');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (801, 'admin', '127.0.0.1', '0', '退出成功', '2024-03-24 20:37:19');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (802, 'admin', '127.0.0.1', '0', '登录成功', '2024-03-24 20:37:41');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (803, 'admin', '127.0.0.1', '0', '登录成功', '2024-03-26 20:15:22');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (804, 'admin', '127.0.0.1', '0', '登录成功', '2024-03-27 22:00:09');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (805, 'admin', '127.0.0.1', '0', '登录成功', '2024-04-07 15:30:37');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (806, 'admin', '127.0.0.1', '0', '登录成功', '2024-04-09 11:31:38');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (807, 'admin', '127.0.0.1', '0', '登录成功', '2024-04-11 19:27:01');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (808, 'admin', '127.0.0.1', '0', '退出成功', '2024-04-11 20:11:48');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (809, 'admin', '127.0.0.1', '0', '登录成功', '2024-04-11 20:11:56');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (810, 'admin', '127.0.0.1', '1', '用户密码错误', '2024-04-12 09:57:55');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (811, 'admin', '127.0.0.1', '0', '登录成功', '2024-04-12 09:58:13');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (812, 'admin', '127.0.0.1', '0', '登录成功', '2024-04-16 21:26:09');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (813, 'admin', '127.0.0.1', '0', '登录成功', '2024-04-17 23:51:06');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (814, 'admin', '127.0.0.1', '0', '登录成功', '2024-04-18 16:50:53');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (815, 'admin', '127.0.0.1', '0', '登录成功', '2024-04-19 10:07:50');
INSERT INTO `sys_logininfor` (`info_id`, `user_name`, `ipaddr`, `status`, `msg`, `access_time`) VALUES (816, 'admin', '127.0.0.1', '0', '登录成功', '2024-05-10 16:29:20');
COMMIT;

-- ----------------------------
-- Table structure for sys_menu
-- ----------------------------
DROP TABLE IF EXISTS `sys_menu`;
CREATE TABLE `sys_menu` (
  `menu_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '菜单ID',
  `menu_name` varchar(50) NOT NULL COMMENT '菜单名称',
  `parent_id` bigint(20) DEFAULT '0' COMMENT '父菜单ID',
  `order_num` int(4) DEFAULT '0' COMMENT '显示顺序',
  `path` varchar(200) DEFAULT '' COMMENT '路由地址',
  `component` varchar(255) DEFAULT NULL COMMENT '组件路径',
  `query` varchar(255) DEFAULT NULL COMMENT '路由参数',
  `is_frame` int(1) DEFAULT '1' COMMENT '是否为外链（0是 1否）',
  `is_cache` int(1) DEFAULT '0' COMMENT '是否缓存（0缓存 1不缓存）',
  `menu_type` char(1) DEFAULT '' COMMENT '菜单类型（M目录 C菜单 F按钮）',
  `visible` char(1) DEFAULT '0' COMMENT '菜单状态（0显示 1隐藏）',
  `status` char(1) DEFAULT '0' COMMENT '菜单状态（0正常 1停用）',
  `perms` varchar(100) DEFAULT NULL COMMENT '权限标识',
  `icon` varchar(100) DEFAULT '#' COMMENT '菜单图标',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`menu_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1140 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='菜单权限表';

-- ----------------------------
-- Records of sys_menu
-- ----------------------------
BEGIN;
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1, '系统管理', 0, 1, 'system', NULL, '', 1, 0, 'M', '0', '0', '', 'system', 'admin', '2021-09-17 18:39:58', '', '2022-10-28 17:46:29', '系统管理目录');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (2, '系统监控', 0, 2, 'monitor', NULL, '', 1, 0, 'M', '0', '0', '', 'monitor', 'admin', '2021-09-17 18:39:58', '', '2022-10-28 17:46:29', '系统监控目录');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (3, '系统工具', 0, 3, 'tool', NULL, '', 1, 0, 'M', '0', '0', '', 'tool', 'admin', '2021-09-17 18:39:58', 'admin', '2024-03-24 17:55:16', '系统工具目录');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (4, '系统功能说明', 0, 8, 'https://www.mqttsnet.com', NULL, '', 0, 0, 'M', '0', '0', '', 'guide', 'admin', '2021-09-17 18:39:59', 'admin', '2024-03-24 17:54:53', 'mqtts官网地址');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (100, '用户管理', 1, 1, 'user', 'system/user/index', '', 1, 0, 'C', '0', '0', 'system:user:list', 'user', 'admin', '2021-09-17 18:39:59', '', '2022-10-28 17:46:29', '用户管理菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (101, '角色管理', 1, 2, 'role', 'system/role/index', '', 1, 0, 'C', '0', '0', 'system:role:list', 'peoples', 'admin', '2021-09-17 18:39:59', '', '2022-10-28 17:46:29', '角色管理菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (102, '菜单管理', 1, 3, 'menu', 'system/menu/index', '', 1, 0, 'C', '0', '0', 'system:menu:list', 'tree-table', 'admin', '2021-09-17 18:39:59', '', '2022-10-28 17:46:29', '菜单管理菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (103, '厂商管理', 1, 4, 'dept', 'system/dept/index', '', 1, 0, 'C', '0', '0', 'system:dept:list', 'tree', 'admin', '2021-09-17 18:39:59', 'admin', '2024-04-11 19:57:07', '部门管理菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (104, '岗位管理', 1, 5, 'post', 'system/post/index', '', 1, 0, 'C', '0', '0', 'system:post:list', 'post', 'admin', '2021-09-17 18:39:59', 'admin', '2024-03-24 17:56:18', '岗位管理菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (105, '字典管理', 1, 6, 'dict', 'system/dict/index', '', 1, 0, 'C', '0', '0', 'system:dict:list', 'dict', 'admin', '2021-09-17 18:39:59', '', '2022-10-28 17:46:29', '字典管理菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (106, '参数设置', 1, 7, 'config', 'system/config/index', '', 1, 0, 'C', '0', '0', 'system:config:list', 'edit', 'admin', '2021-09-17 18:39:59', '', '2022-10-28 17:46:29', '参数设置菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (107, '通知公告', 1, 8, 'notice', 'system/notice/index', '', 1, 0, 'C', '0', '0', 'system:notice:list', 'message', 'admin', '2021-09-17 18:39:59', '', '2022-10-28 17:46:29', '通知公告菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (108, '日志管理', 1, 9, 'log', '', '', 1, 0, 'M', '0', '0', '', 'log', 'admin', '2021-09-17 18:39:59', '', '2022-10-28 17:46:29', '日志管理菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (109, '在线用户', 2, 1, 'online', 'monitor/online/index', '', 1, 0, 'C', '0', '0', 'monitor:online:list', 'online', 'admin', '2021-09-17 18:39:59', '', '2022-10-28 17:46:29', '在线用户菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (110, '定时任务', 2, 2, 'job', 'monitor/job/index', '', 1, 0, 'C', '0', '0', 'monitor:job:list', 'job', 'admin', '2021-09-17 18:39:59', '', '2022-10-28 17:46:29', '定时任务菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (111, 'Sentinel控制台', 2, 3, 'http://106.14.73.90:19101', '', '', 0, 0, 'C', '1', '0', 'monitor:sentinel:list', 'sentinel', 'admin', '2021-09-17 18:39:59', 'admin', '2024-01-02 17:30:46', '流量控制菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (112, 'Nacos控制台', 2, 4, 'http://106.14.73.90:8848/nacos/index.html', '', '', 0, 0, 'C', '0', '0', 'monitor:nacos:list', 'nacos', 'admin', '2021-09-17 18:39:59', 'admin', '2022-10-28 17:46:29', '服务治理菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (113, 'Admin控制台', 2, 5, 'http://localhost:19400/login', '', '', 0, 0, 'C', '1', '0', 'monitor:server:list', 'server', 'admin', '2021-09-17 18:39:59', 'admin', '2024-01-02 17:30:51', '服务监控菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (114, '表单构建', 3, 1, 'build', 'tool/build/index', '', 1, 0, 'C', '0', '0', 'tool:build:list', 'build', 'admin', '2021-09-17 18:39:59', '', '2022-10-28 17:46:29', '表单构建菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (115, '代码生成', 3, 2, 'gen', 'tool/gen/index', '', 1, 0, 'C', '0', '0', 'tool:gen:list', 'code', 'admin', '2021-09-17 18:40:00', '', '2022-10-28 17:46:29', '代码生成菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (116, '系统接口', 3, 3, 'http://127.0.0.1:19100/swagger-ui.html', '', '', 0, 0, 'C', '0', '0', 'tool:swagger:list', 'swagger', 'admin', '2021-09-17 18:40:00', 'admin', '2024-03-28 19:17:10', '系统接口菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (500, '操作日志', 108, 1, 'operlog', 'system/operlog/index', '', 1, 0, 'C', '0', '0', 'system:operlog:list', 'form', 'admin', '2021-09-17 18:40:00', '', '2022-10-28 17:46:29', '操作日志菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (501, '登录日志', 108, 2, 'logininfor', 'system/logininfor/index', '', 1, 0, 'C', '0', '0', 'system:logininfor:list', 'logininfor', 'admin', '2021-09-17 18:40:00', '', '2022-10-28 17:46:29', '登录日志菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1001, '用户查询', 100, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:user:query', '#', 'admin', '2021-09-17 18:40:00', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1002, '用户新增', 100, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:user:add', '#', 'admin', '2021-09-17 18:40:00', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1003, '用户修改', 100, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:user:edit', '#', 'admin', '2021-09-17 18:40:00', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1004, '用户删除', 100, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:user:remove', '#', 'admin', '2021-09-17 18:40:00', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1005, '用户导出', 100, 5, '', '', '', 1, 0, 'F', '0', '0', 'system:user:export', '#', 'admin', '2021-09-17 18:40:00', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1006, '用户导入', 100, 6, '', '', '', 1, 0, 'F', '0', '0', 'system:user:import', '#', 'admin', '2021-09-17 18:40:00', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1007, '重置密码', 100, 7, '', '', '', 1, 0, 'F', '0', '0', 'system:user:resetPwd', '#', 'admin', '2021-09-17 18:40:00', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1008, '角色查询', 101, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:role:query', '#', 'admin', '2021-09-17 18:40:00', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1009, '角色新增', 101, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:role:add', '#', 'admin', '2021-09-17 18:40:00', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1010, '角色修改', 101, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:role:edit', '#', 'admin', '2021-09-17 18:40:01', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1011, '角色删除', 101, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:role:remove', '#', 'admin', '2021-09-17 18:40:01', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1012, '角色导出', 101, 5, '', '', '', 1, 0, 'F', '0', '0', 'system:role:export', '#', 'admin', '2021-09-17 18:40:01', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1013, '菜单查询', 102, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:menu:query', '#', 'admin', '2021-09-17 18:40:01', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1014, '菜单新增', 102, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:menu:add', '#', 'admin', '2021-09-17 18:40:01', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1015, '菜单修改', 102, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:menu:edit', '#', 'admin', '2021-09-17 18:40:01', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1016, '菜单删除', 102, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:menu:remove', '#', 'admin', '2021-09-17 18:40:01', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1017, '部门查询', 103, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:dept:query', '#', 'admin', '2021-09-17 18:40:01', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1018, '部门新增', 103, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:dept:add', '#', 'admin', '2021-09-17 18:40:01', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1019, '部门修改', 103, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:dept:edit', '#', 'admin', '2021-09-17 18:40:01', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1020, '部门删除', 103, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:dept:remove', '#', 'admin', '2021-09-17 18:40:01', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1021, '岗位查询', 104, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:post:query', '#', 'admin', '2021-09-17 18:40:01', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1022, '岗位新增', 104, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:post:add', '#', 'admin', '2021-09-17 18:40:01', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1023, '岗位修改', 104, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:post:edit', '#', 'admin', '2021-09-17 18:40:01', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1024, '岗位删除', 104, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:post:remove', '#', 'admin', '2021-09-17 18:40:01', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1025, '岗位导出', 104, 5, '', '', '', 1, 0, 'F', '0', '0', 'system:post:export', '#', 'admin', '2021-09-17 18:40:01', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1026, '字典查询', 105, 1, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:query', '#', 'admin', '2021-09-17 18:40:02', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1027, '字典新增', 105, 2, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:add', '#', 'admin', '2021-09-17 18:40:02', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1028, '字典修改', 105, 3, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:edit', '#', 'admin', '2021-09-17 18:40:02', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1029, '字典删除', 105, 4, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:remove', '#', 'admin', '2021-09-17 18:40:02', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1030, '字典导出', 105, 5, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:export', '#', 'admin', '2021-09-17 18:40:02', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1031, '参数查询', 106, 1, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:query', '#', 'admin', '2021-09-17 18:40:02', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1032, '参数新增', 106, 2, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:add', '#', 'admin', '2021-09-17 18:40:02', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1033, '参数修改', 106, 3, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:edit', '#', 'admin', '2021-09-17 18:40:02', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1034, '参数删除', 106, 4, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:remove', '#', 'admin', '2021-09-17 18:40:02', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1035, '参数导出', 106, 5, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:export', '#', 'admin', '2021-09-17 18:40:02', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1036, '公告查询', 107, 1, '#', '', '', 1, 0, 'F', '0', '0', 'system:notice:query', '#', 'admin', '2021-09-17 18:40:02', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1037, '公告新增', 107, 2, '#', '', '', 1, 0, 'F', '0', '0', 'system:notice:add', '#', 'admin', '2021-09-17 18:40:02', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1038, '公告修改', 107, 3, '#', '', '', 1, 0, 'F', '0', '0', 'system:notice:edit', '#', 'admin', '2021-09-17 18:40:02', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1039, '公告删除', 107, 4, '#', '', '', 1, 0, 'F', '0', '0', 'system:notice:remove', '#', 'admin', '2021-09-17 18:40:02', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1040, '操作查询', 500, 1, '#', '', '', 1, 0, 'F', '0', '0', 'system:operlog:query', '#', 'admin', '2021-09-17 18:40:02', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1041, '操作删除', 500, 2, '#', '', '', 1, 0, 'F', '0', '0', 'system:operlog:remove', '#', 'admin', '2021-09-17 18:40:02', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1042, '日志导出', 500, 4, '#', '', '', 1, 0, 'F', '0', '0', 'system:operlog:export', '#', 'admin', '2021-09-17 18:40:02', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1043, '登录查询', 501, 1, '#', '', '', 1, 0, 'F', '0', '0', 'system:logininfor:query', '#', 'admin', '2021-09-17 18:40:02', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1044, '登录删除', 501, 2, '#', '', '', 1, 0, 'F', '0', '0', 'system:logininfor:remove', '#', 'admin', '2021-09-17 18:40:03', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1045, '日志导出', 501, 3, '#', '', '', 1, 0, 'F', '0', '0', 'system:logininfor:export', '#', 'admin', '2021-09-17 18:40:03', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1046, '在线查询', 109, 1, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:online:query', '#', 'admin', '2021-09-17 18:40:03', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1047, '批量强退', 109, 2, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:online:batchLogout', '#', 'admin', '2021-09-17 18:40:03', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1048, '单条强退', 109, 3, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:online:forceLogout', '#', 'admin', '2021-09-17 18:40:03', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1049, '任务查询', 110, 1, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:query', '#', 'admin', '2021-09-17 18:40:03', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1050, '任务新增', 110, 2, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:add', '#', 'admin', '2021-09-17 18:40:03', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1051, '任务修改', 110, 3, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:edit', '#', 'admin', '2021-09-17 18:40:03', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1052, '任务删除', 110, 4, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:remove', '#', 'admin', '2021-09-17 18:40:03', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1053, '状态修改', 110, 5, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:changeStatus', '#', 'admin', '2021-09-17 18:40:03', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1054, '任务导出', 110, 7, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:export', '#', 'admin', '2021-09-17 18:40:03', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1055, '生成查询', 115, 1, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:query', '#', 'admin', '2021-09-17 18:40:04', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1056, '生成修改', 115, 2, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:edit', '#', 'admin', '2021-09-17 18:40:04', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1057, '生成删除', 115, 3, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:remove', '#', 'admin', '2021-09-17 18:40:04', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1058, '导入代码', 115, 2, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:import', '#', 'admin', '2021-09-17 18:40:04', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1059, '预览代码', 115, 4, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:preview', '#', 'admin', '2021-09-17 18:40:04', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1060, '生成代码', 115, 5, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:code', '#', 'admin', '2021-09-17 18:40:04', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1061, '设备集成', 0, 4, 'link', NULL, NULL, 1, 0, 'M', '0', '0', '', 'client', 'admin', '2021-10-21 17:14:32', 'admin', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1062, '设备管理', 1061, 3, 'device', 'link/device/index', NULL, 1, 0, 'C', '0', '0', 'link:device:list', 'slider', 'admin', '2021-10-21 17:27:48', 'admin', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1063, '设备查询', 1062, 1, '', NULL, NULL, 1, 0, 'F', '0', '0', 'link:device:query', '#', 'admin', '2021-10-21 17:35:09', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1064, '设备新增', 1062, 2, '', NULL, NULL, 1, 0, 'F', '0', '0', 'link:device:add', '#', 'admin', '2021-10-21 17:35:39', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1065, '设备修改', 1062, 3, '', NULL, NULL, 1, 0, 'F', '0', '0', 'link:device:edit', '#', 'admin', '2021-10-21 17:36:00', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1066, '设备删除', 1062, 4, '', NULL, NULL, 1, 0, 'F', '0', '0', 'link:device:remove', '#', 'admin', '2021-10-21 17:36:21', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1067, '设备导出', 1062, 5, '', NULL, NULL, 1, 0, 'F', '0', '0', 'link:device:export', '#', 'admin', '2021-10-21 17:36:41', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1068, '产品管理', 1061, 1, 'product', 'link/product/index', NULL, 1, 0, 'C', '0', '0', 'link:product:list', 'nested', 'thinglinks', '2022-02-09 15:56:11', 'admin', '2024-03-24 17:55:51', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1069, '产品管理查询', 1068, 1, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:product:query', '#', 'admin', '2022-02-09 16:58:42', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1070, '产品管理新增', 1068, 2, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:product:add', '#', 'admin', '2022-02-09 16:58:42', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1071, '产品管理复制', 1068, 3, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:product:edit', '#', 'admin', '2022-02-09 16:58:42', 'admin', '2024-03-28 10:15:39', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1072, '产品管理删除', 1068, 4, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:product:remove', '#', 'admin', '2022-02-09 16:58:42', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1073, '产品管理导出', 1068, 5, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:product:export', '#', 'admin', '2022-02-09 16:58:42', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1074, '断开连接', 1062, 6, '', NULL, NULL, 1, 0, 'F', '0', '0', 'link:device:disconnect', '#', 'admin', '2022-03-08 16:17:36', 'admin', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1075, '产品管理导入', 1068, 6, '', NULL, NULL, 1, 0, 'F', '0', '0', 'link:product:import', '#', 'admin', '2022-03-25 18:04:07', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1076, '设备详情', 1062, 7, '', NULL, NULL, 1, 0, 'F', '0', '0', 'link:device:deviceDetails', '#', 'admin', '2022-05-04 18:20:08', 'admin', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1077, '设备监控', 0, 6, 'tdengine', NULL, NULL, 1, 0, 'M', '1', '1', '', 'online', 'admin', '2022-05-05 14:06:11', 'admin', '2022-11-19 16:24:59', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1078, '设备影子', 1077, 1, 'tdengine', 'tdengine/shadow/index', NULL, 1, 0, 'C', '1', '0', 'tdengine:shadow:list', 'ContentUnion', 'admin', '2022-05-05 14:09:20', 'admin', '2022-11-19 16:24:46', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1079, '快捷生成', 1068, 7, '', NULL, NULL, 1, 0, 'F', '0', '0', 'link:product:generate', '#', 'admin', '2022-05-13 14:23:43', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1080, 'CAS规则管理', 1061, 6, 'casbinRule', 'link/casbinRule/index', NULL, 1, 0, 'C', '1', '0', 'link:casbinRule:list', 'lock', 'admin', '2022-06-16 18:29:45', 'hitelcom', '2023-11-24 21:10:00', 'CAS规则管理菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1081, 'CAS规则管理查询', 1080, 1, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:casbinRule:query', '#', 'admin', '2022-06-16 18:29:45', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1082, 'CAS规则管理新增', 1080, 2, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:casbinRule:add', '#', 'admin', '2022-06-16 18:29:46', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1083, 'CAS规则管理修改', 1080, 3, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:casbinRule:edit', '#', 'admin', '2022-06-16 18:29:46', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1084, 'CAS规则管理删除', 1080, 4, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:casbinRule:remove', '#', 'admin', '2022-06-16 18:29:46', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1085, 'CAS规则管理导出', 1080, 5, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:casbinRule:export', '#', 'admin', '2022-06-16 18:29:46', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1086, '设备Topic数据', 1076, 1, 'topic', 'link/topic/index', NULL, 1, 0, 'C', '0', '0', 'link:topic:list', '#', 'admin', '2022-06-17 17:15:10', '', '2022-10-28 17:46:29', '设备Topic数据菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1087, '设备Topic数据查询', 1086, 1, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:topic:query', '#', 'admin', '2022-06-17 17:15:10', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1088, '设备Topic数据新增', 1086, 2, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:topic:add', '#', 'admin', '2022-06-17 17:15:10', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1089, '设备Topic数据修改', 1086, 3, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:topic:edit', '#', 'admin', '2022-06-17 17:15:10', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1090, '设备Topic数据删除', 1086, 4, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:topic:remove', '#', 'admin', '2022-06-17 17:15:10', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1091, '设备Topic数据导出', 1086, 5, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:topic:export', '#', 'admin', '2022-06-17 17:15:11', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1092, '设备动作数据', 1076, 1, 'action', 'link/action/index', NULL, 1, 0, 'C', '0', '0', 'link:action:list', '#', 'admin', '2022-06-17 17:47:32', '', '2022-10-28 17:46:29', '设备动作数据菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1093, '设备动作数据查询', 1092, 1, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:action:query', '#', 'admin', '2022-06-17 17:47:32', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1094, '设备动作数据新增', 1092, 2, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:action:add', '#', 'admin', '2022-06-17 17:47:32', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1095, '设备动作数据修改', 1092, 3, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:action:edit', '#', 'admin', '2022-06-17 17:47:32', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1096, '设备动作数据删除', 1092, 4, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:action:remove', '#', 'admin', '2022-06-17 17:47:32', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1097, '设备动作数据导出', 1092, 5, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:action:export', '#', 'admin', '2022-06-17 17:47:32', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1098, '子设备管理', 1061, 4, 'deviceInfo', 'link/deviceInfo/index', NULL, 1, 0, 'C', '0', '0', 'link:deviceInfo:list', 'cascader', 'admin', '2022-06-21 10:48:04', 'admin', '2022-10-28 17:46:29', '子设备管理菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1099, '子设备管理查询', 1098, 1, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:deviceInfo:query', '#', 'admin', '2022-06-21 10:48:05', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1102, '子设备管理删除', 1098, 4, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:deviceInfo:remove', '#', 'admin', '2022-06-21 10:48:05', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1103, '子设备管理导出', 1098, 5, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:deviceInfo:export', '#', 'admin', '2022-06-21 10:48:05', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1104, '产品赋能', 1068, 8, '', NULL, NULL, 1, 0, 'F', '0', '0', 'link:product:empowerment', '#', 'admin', '2022-06-24 18:27:08', 'admin', '2024-03-24 20:36:06', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1105, '子设备影子', 1098, 6, '', NULL, NULL, 1, 0, 'F', '0', '0', 'link:deviceInfo:shadow', '#', 'admin', '2022-06-27 16:13:35', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1107, '协议管理', 1061, 5, 'protocol', 'link/protocol/index', NULL, 1, 0, 'C', '0', '0', 'link:protocol:list', 'example', 'admin', '2022-07-04 11:05:44', 'admin', '2022-10-28 17:46:29', '协议管理菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1108, '协议管理查询', 1107, 1, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:protocol:query', '#', 'admin', '2022-07-04 11:05:44', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1109, '协议管理新增', 1107, 2, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:protocol:add', '#', 'admin', '2022-07-04 11:05:44', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1110, '协议管理修改', 1107, 3, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:protocol:edit', '#', 'admin', '2022-07-04 11:05:44', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1111, '协议管理删除', 1107, 4, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:protocol:remove', '#', 'admin', '2022-07-04 11:05:44', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1112, '协议管理导出', 1107, 5, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:protocol:export', '#', 'admin', '2022-07-04 11:05:44', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1113, '协议管理启用', 1107, 6, '', NULL, NULL, 1, 0, 'F', '0', '0', 'link:protocol:enable', '#', 'admin', '2022-07-05 11:08:28', 'admin', '2024-04-07 15:34:45', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1114, '协议管理停用', 1107, 7, '', NULL, NULL, 1, 0, 'F', '0', '0', 'link:protocol:disable', '#', 'admin', '2022-07-05 11:09:06', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1121, '设备调试', 0, 5, 'broker', NULL, NULL, 1, 0, 'M', '0', '0', '', 'bug', 'admin', '2022-07-08 19:12:34', 'admin', '2024-01-02 16:23:30', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1122, '实时监控', 1121, 1, 'broker', 'broker/realTime/index', NULL, 1, 0, 'C', '1', '0', 'broker:realTime:list', 'time-range', 'admin', '2022-07-08 19:17:33', 'admin', '2024-04-11 19:27:42', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1123, '命令下发', 1121, 2, 'link:sendCustomMessage:list', 'link/sendCustomMessage/index', NULL, 1, 0, 'C', '0', '0', 'link:sendCustomMessage:list', 'post', 'admin', '2022-07-13 08:24:51', 'admin', '2024-04-18 01:15:46', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1126, '子设备管理', 1076, 1, 'deviceInfo', 'link/deviceInfo/index', NULL, 1, 0, 'C', '0', '0', 'link:deviceInfo:list', '#', 'admin', '2022-07-27 12:34:15', '', '2022-10-28 17:46:29', '子设备管理菜单');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1127, '子设备管理查询', 1126, 1, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:deviceInfo:query', '#', 'admin', '2022-07-27 12:34:15', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1128, '子设备管理新增', 1126, 2, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:deviceInfo:add', '#', 'admin', '2022-07-27 12:34:15', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1129, '子设备管理修改', 1126, 3, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:deviceInfo:edit', '#', 'admin', '2022-07-27 12:34:15', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1130, '子设备管理删除', 1126, 4, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:deviceInfo:remove', '#', 'admin', '2022-07-27 12:34:15', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1131, '子设备管理导出', 1126, 5, '#', '', NULL, 1, 0, 'F', '0', '0', 'link:deviceInfo:export', '#', 'admin', '2022-07-27 12:34:15', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1132, '子设备管理新增', 1098, 2, '', NULL, NULL, 1, 0, 'F', '0', '0', 'link:deviceInfo:add', '#', 'admin', '2022-07-27 12:35:42', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1133, '子设备管理修改', 1098, 3, '', NULL, NULL, 1, 0, 'F', '0', '0', 'link:deviceInfo:edit', '#', 'admin', '2022-07-27 12:36:07', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1134, '初始化模型', 1098, 7, '', NULL, NULL, 1, 0, 'F', '0', '0', 'link:deviceInfo:initialize', '#', 'admin', '2022-08-04 18:32:50', '', '2022-10-28 17:46:29', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1137, '设备列表状态数量', 1062, 0, '#', NULL, NULL, 1, 0, 'F', '0', '0', 'link:device:count', '#', 'admin', '2022-11-26 20:35:40', 'admin', '2022-11-26 20:35:47', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1138, '规则引擎', 0, 7, 'rule', NULL, NULL, 1, 0, 'M', '0', '0', '', 'component', 'admin', '2024-04-11 20:04:54', 'admin', '2024-04-11 20:44:08', '');
INSERT INTO `sys_menu` (`menu_id`, `menu_name`, `parent_id`, `order_num`, `path`, `component`, `query`, `is_frame`, `is_cache`, `menu_type`, `visible`, `status`, `perms`, `icon`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1139, '链式规则', 1138, 10, 'engine', 'rule/engine/index', NULL, 1, 0, 'C', '0', '0', 'rule:engine:list', 'slider', 'admin', '2024-04-11 20:09:16', 'admin', '2024-04-12 10:00:42', '');
COMMIT;

-- ----------------------------
-- Table structure for sys_notice
-- ----------------------------
DROP TABLE IF EXISTS `sys_notice`;
CREATE TABLE `sys_notice` (
  `notice_id` int(4) NOT NULL AUTO_INCREMENT COMMENT '公告ID',
  `notice_title` varchar(50) NOT NULL COMMENT '公告标题',
  `notice_type` char(1) NOT NULL COMMENT '公告类型（1通知 2公告）',
  `notice_content` longblob COMMENT '公告内容',
  `status` char(1) DEFAULT '0' COMMENT '公告状态（0正常 1关闭）',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`notice_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='通知公告表';

-- ----------------------------
-- Records of sys_notice
-- ----------------------------
BEGIN;
INSERT INTO `sys_notice` (`notice_id`, `notice_title`, `notice_type`, `notice_content`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (2, '修改维护中', '1', 0x3C703EE7BBB4E68AA4E58685E5AEB93C2F703E, '0', 'admin', '2021-09-17 18:40:16', 'admin', '2024-01-02 16:24:47', '管理员');
COMMIT;

-- ----------------------------
-- Table structure for sys_oper_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_oper_log`;
CREATE TABLE `sys_oper_log` (
  `oper_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '日志主键',
  `title` varchar(50) DEFAULT '' COMMENT '模块标题',
  `business_type` int(2) DEFAULT '0' COMMENT '业务类型（0其它 1新增 2修改 3删除）',
  `method` varchar(100) DEFAULT '' COMMENT '方法名称',
  `request_method` varchar(10) DEFAULT '' COMMENT '请求方式',
  `operator_type` int(1) DEFAULT '0' COMMENT '操作类别（0其它 1后台用户 2手机端用户）',
  `oper_name` varchar(50) DEFAULT '' COMMENT '操作人员',
  `dept_name` varchar(50) DEFAULT '' COMMENT '部门名称',
  `oper_url` varchar(255) DEFAULT '' COMMENT '请求URL',
  `oper_ip` varchar(128) DEFAULT '' COMMENT '主机地址',
  `oper_location` varchar(255) DEFAULT '' COMMENT '操作地点',
  `oper_param` varchar(2000) DEFAULT '' COMMENT '请求参数',
  `json_result` varchar(2000) DEFAULT '' COMMENT '返回参数',
  `status` int(1) DEFAULT '0' COMMENT '操作状态（0正常 1异常）',
  `error_msg` varchar(2000) DEFAULT '' COMMENT '错误消息',
  `oper_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '操作时间',
  PRIMARY KEY (`oper_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=799 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='操作日志记录';

-- ----------------------------
-- Records of sys_oper_log
-- ----------------------------
BEGIN;
INSERT INTO `sys_oper_log` (`oper_id`, `title`, `business_type`, `method`, `request_method`, `operator_type`, `oper_name`, `dept_name`, `oper_url`, `oper_ip`, `oper_location`, `oper_param`, `json_result`, `status`, `error_msg`, `oper_time`) VALUES (795, '定时任务', 2, 'com.mqttsnet.thinglinks.job.controller.SysJobController.edit()', 'PUT', 1, 'admin', NULL, '/job', '127.0.0.1', '', '{\"jobName\":\"协议脚本缓存刷新定时任务\",\"concurrent\":\"1\",\"remark\":\"\",\"jobGroup\":\"PROTOCOL\",\"params\":{},\"cronExpression\":\"0/5 0 0/23 * * ?\",\"jobId\":4,\"createBy\":\"admin\",\"nextValidTime\":1715353200000,\"createTime\":1657525849000,\"updateBy\":\"admin\",\"invokeTarget\":\"linkProtocolTask.protocolScriptCacheRefreshTask\",\"misfirePolicy\":\"2\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2024-05-10 16:53:15');
INSERT INTO `sys_oper_log` (`oper_id`, `title`, `business_type`, `method`, `request_method`, `operator_type`, `oper_name`, `dept_name`, `oper_url`, `oper_ip`, `oper_location`, `oper_param`, `json_result`, `status`, `error_msg`, `oper_time`) VALUES (796, '定时任务', 2, 'com.mqttsnet.thinglinks.job.controller.SysJobController.edit()', 'PUT', 1, 'admin', NULL, '/job', '127.0.0.1', '', '{\"jobName\":\"协议脚本缓存刷新定时任务\",\"concurrent\":\"0\",\"remark\":\"\",\"jobGroup\":\"PROTOCOL\",\"params\":{},\"cronExpression\":\"0 0/10 * * * ?\",\"jobId\":4,\"createBy\":\"admin\",\"nextValidTime\":1715331600000,\"createTime\":1657525849000,\"updateBy\":\"admin\",\"invokeTarget\":\"linkProtocolTask.protocolScriptCacheRefreshTask\",\"misfirePolicy\":\"2\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2024-05-10 16:54:25');
INSERT INTO `sys_oper_log` (`oper_id`, `title`, `business_type`, `method`, `request_method`, `operator_type`, `oper_name`, `dept_name`, `oper_url`, `oper_ip`, `oper_location`, `oper_param`, `json_result`, `status`, `error_msg`, `oper_time`) VALUES (797, '定时任务', 2, 'com.mqttsnet.thinglinks.job.controller.SysJobController.edit()', 'PUT', 1, 'admin', NULL, '/job', '127.0.0.1', '', '{\"jobName\":\"协议脚本缓存刷新定时任务\",\"concurrent\":\"0\",\"remark\":\"\",\"jobGroup\":\"PROTOCOL\",\"params\":{},\"cronExpression\":\"0 0/10 * * * ?\",\"jobId\":4,\"createBy\":\"admin\",\"nextValidTime\":1715331600000,\"createTime\":1657525849000,\"updateBy\":\"admin\",\"invokeTarget\":\"linkProtocolTask.protocolScriptCacheRefreshTask\",\"misfirePolicy\":\"2\",\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2024-05-10 16:55:06');
INSERT INTO `sys_oper_log` (`oper_id`, `title`, `business_type`, `method`, `request_method`, `operator_type`, `oper_name`, `dept_name`, `oper_url`, `oper_ip`, `oper_location`, `oper_param`, `json_result`, `status`, `error_msg`, `oper_time`) VALUES (798, '定时任务', 2, 'com.mqttsnet.thinglinks.job.controller.SysJobController.run()', 'PUT', 1, 'admin', NULL, '/job/run', '127.0.0.1', '', '{\"jobGroup\":\"PROTOCOL\",\"params\":{},\"jobId\":4,\"misfirePolicy\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2024-05-10 16:55:11');
COMMIT;

-- ----------------------------
-- Table structure for sys_post
-- ----------------------------
DROP TABLE IF EXISTS `sys_post`;
CREATE TABLE `sys_post` (
  `post_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '岗位ID',
  `post_code` varchar(64) NOT NULL COMMENT '岗位编码',
  `post_name` varchar(50) NOT NULL COMMENT '岗位名称',
  `post_sort` int(4) NOT NULL COMMENT '显示顺序',
  `status` char(1) NOT NULL COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`post_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='岗位信息表';

-- ----------------------------
-- Records of sys_post
-- ----------------------------
BEGIN;
INSERT INTO `sys_post` (`post_id`, `post_code`, `post_name`, `post_sort`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1, 'ceo', '董事长', 1, '0', 'admin', '2021-09-17 18:39:58', '', '2022-11-18 13:57:49', '');
INSERT INTO `sys_post` (`post_id`, `post_code`, `post_name`, `post_sort`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (2, 'se', '项目经理', 2, '0', 'admin', '2021-09-17 18:39:58', '', '2022-11-18 13:57:49', '');
INSERT INTO `sys_post` (`post_id`, `post_code`, `post_name`, `post_sort`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (3, 'hr', '人力资源', 3, '0', 'admin', '2021-09-17 18:39:58', '', '2022-11-18 13:57:49', '');
INSERT INTO `sys_post` (`post_id`, `post_code`, `post_name`, `post_sort`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (4, 'user', '普通员工', 4, '0', 'admin', '2021-09-17 18:39:58', '', '2022-11-18 13:57:49', '');
COMMIT;

-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_role`;
CREATE TABLE `sys_role` (
  `role_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) NOT NULL COMMENT '角色名称',
  `role_key` varchar(100) NOT NULL COMMENT '角色权限字符串',
  `role_sort` int(4) NOT NULL COMMENT '显示顺序',
  `data_scope` char(1) DEFAULT '1' COMMENT '数据范围（1：全部数据权限 2：自定数据权限 3：本部门数据权限 4：本部门及以下数据权限）',
  `menu_check_strictly` tinyint(1) DEFAULT '1' COMMENT '菜单树选择项是否关联显示',
  `dept_check_strictly` tinyint(1) DEFAULT '1' COMMENT '部门树选择项是否关联显示',
  `status` char(1) NOT NULL COMMENT '角色状态（0正常 1停用）',
  `del_flag` char(1) DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`role_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='角色信息表';

-- ----------------------------
-- Records of sys_role
-- ----------------------------
BEGIN;
INSERT INTO `sys_role` (`role_id`, `role_name`, `role_key`, `role_sort`, `data_scope`, `menu_check_strictly`, `dept_check_strictly`, `status`, `del_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1, '超级管理员', 'admin', 1, '1', 1, 1, '0', '0', 'admin', '2021-09-17 18:39:58', '', '2022-06-17 10:43:52', '超级管理员');
INSERT INTO `sys_role` (`role_id`, `role_name`, `role_key`, `role_sort`, `data_scope`, `menu_check_strictly`, `dept_check_strictly`, `status`, `del_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (2, '普通角色', 'common', 2, '2', 1, 1, '0', '0', 'admin', '2021-09-17 18:39:58', 'ywq', '2023-12-29 15:29:05', '普通角色');
COMMIT;

-- ----------------------------
-- Table structure for sys_role_dept
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_dept`;
CREATE TABLE `sys_role_dept` (
  `role_id` bigint(20) NOT NULL COMMENT '角色ID',
  `dept_id` bigint(20) NOT NULL COMMENT '部门ID',
  PRIMARY KEY (`role_id`,`dept_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='角色和部门关联表';

-- ----------------------------
-- Records of sys_role_dept
-- ----------------------------
BEGIN;
INSERT INTO `sys_role_dept` (`role_id`, `dept_id`) VALUES (2, 100);
INSERT INTO `sys_role_dept` (`role_id`, `dept_id`) VALUES (2, 101);
INSERT INTO `sys_role_dept` (`role_id`, `dept_id`) VALUES (2, 103);
INSERT INTO `sys_role_dept` (`role_id`, `dept_id`) VALUES (2, 104);
INSERT INTO `sys_role_dept` (`role_id`, `dept_id`) VALUES (2, 105);
COMMIT;

-- ----------------------------
-- Table structure for sys_role_menu
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_menu`;
CREATE TABLE `sys_role_menu` (
  `role_id` bigint(20) NOT NULL COMMENT '角色ID',
  `menu_id` bigint(20) NOT NULL COMMENT '菜单ID',
  PRIMARY KEY (`role_id`,`menu_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='角色和菜单关联表';

-- ----------------------------
-- Records of sys_role_menu
-- ----------------------------
BEGIN;
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 2);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 3);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 4);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 100);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 101);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 102);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 103);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 104);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 105);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 106);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 107);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 108);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 109);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 110);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 111);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 112);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 113);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 114);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 115);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 116);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 500);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 501);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1001);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1002);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1003);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1004);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1005);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1006);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1007);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1008);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1009);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1010);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1011);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1012);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1013);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1014);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1015);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1016);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1017);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1018);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1019);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1020);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1021);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1022);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1023);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1024);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1025);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1026);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1027);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1028);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1029);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1030);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1031);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1032);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1033);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1034);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1035);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1036);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1037);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1038);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1039);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1040);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1041);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1042);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1043);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1044);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1045);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1046);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1047);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1048);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1049);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1050);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1051);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1052);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1053);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1054);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1055);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1056);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1057);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1058);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1059);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1060);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1061);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1062);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1063);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1064);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1065);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1066);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1067);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1068);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1069);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1070);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1071);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1072);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1073);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1074);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1075);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1076);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1079);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1080);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1081);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1082);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1083);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1084);
INSERT INTO `sys_role_menu` (`role_id`, `menu_id`) VALUES (2, 1085);
COMMIT;

-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
DROP TABLE IF EXISTS `sys_user`;
CREATE TABLE `sys_user` (
  `user_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '用户ID',
  `dept_id` bigint(20) DEFAULT NULL COMMENT '部门ID',
  `user_name` varchar(30) NOT NULL COMMENT '用户账号',
  `nick_name` varchar(30) NOT NULL COMMENT '用户昵称',
  `user_type` varchar(2) DEFAULT '00' COMMENT '用户类型（00系统用户）',
  `email` varchar(50) DEFAULT '' COMMENT '用户邮箱',
  `phonenumber` varchar(11) DEFAULT '' COMMENT '手机号码',
  `sex` char(1) DEFAULT '0' COMMENT '用户性别（0男 1女 2未知）',
  `avatar` varchar(100) DEFAULT '' COMMENT '头像地址',
  `password` varchar(100) DEFAULT '' COMMENT '密码',
  `status` char(1) DEFAULT '0' COMMENT '帐号状态（0正常 1停用）',
  `del_flag` char(1) DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `login_ip` varchar(128) DEFAULT '' COMMENT '最后登录IP',
  `login_date` datetime DEFAULT NULL COMMENT '最后登录时间',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1008 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='用户信息表';

-- ----------------------------
-- Records of sys_user
-- ----------------------------
BEGIN;
INSERT INTO `sys_user` (`user_id`, `dept_id`, `user_name`, `nick_name`, `user_type`, `email`, `phonenumber`, `sex`, `avatar`, `password`, `status`, `del_flag`, `login_ip`, `login_date`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (1, 103, 'admin', 'admin', '00', 'mqttsnet@163.com', '15888888888', '0', 'http://127.0.0.1:19300/statics/2022/08/08/ed20c7f4-7382-4330-b010-68cdcb74676f.jpeg', '$2a$10$03Rpfc5ykyzqqZddjHYPVOAqGVkxuGVMpsYNsvB50QN0Cd5exvHh.', '0', '0', '127.0.0.1', '2021-09-17 18:39:57', 'admin', '2021-09-17 18:39:57', '', '2024-03-24 20:33:54', '管理员');
INSERT INTO `sys_user` (`user_id`, `dept_id`, `user_name`, `nick_name`, `user_type`, `email`, `phonenumber`, `sex`, `avatar`, `password`, `status`, `del_flag`, `login_ip`, `login_date`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES (2, 103, 'admintTest', 'admintTest', '00', 'mqttsnet@163.com', '15888888881', '0', 'http://127.0.0.1:19300/statics/2023/12/25/71d160d0-43d3-40ec-8599-a529e192f126.jpeg', '$2a$10$7JB720yubVSZvUI0rEqK/.VqGOZTH.ulu33dHOiBE8ByOhJIrdAu2', '0', '0', '127.0.0.1', '2021-09-17 18:39:57', 'admin', '2021-09-17 18:39:57', 'hitelcom', '2024-03-24 20:33:46', '管理员');
COMMIT;

-- ----------------------------
-- Table structure for sys_user_post
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_post`;
CREATE TABLE `sys_user_post` (
  `user_id` bigint(20) NOT NULL COMMENT '用户ID',
  `post_id` bigint(20) NOT NULL COMMENT '岗位ID',
  PRIMARY KEY (`user_id`,`post_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='用户与岗位关联表';

-- ----------------------------
-- Records of sys_user_post
-- ----------------------------
BEGIN;
INSERT INTO `sys_user_post` (`user_id`, `post_id`) VALUES (1, 1);
INSERT INTO `sys_user_post` (`user_id`, `post_id`) VALUES (2, 2);
COMMIT;

-- ----------------------------
-- Table structure for sys_user_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_role`;
CREATE TABLE `sys_user_role` (
  `user_id` bigint(20) NOT NULL COMMENT '用户ID',
  `role_id` bigint(20) NOT NULL COMMENT '角色ID',
  PRIMARY KEY (`user_id`,`role_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='用户和角色关联表';

-- ----------------------------
-- Records of sys_user_role
-- ----------------------------
BEGIN;
INSERT INTO `sys_user_role` (`user_id`, `role_id`) VALUES (1, 1);
INSERT INTO `sys_user_role` (`user_id`, `role_id`) VALUES (2, 2);
COMMIT;

SET FOREIGN_KEY_CHECKS = 1;
