## Contributing to Basalt
Thank you for considering contributing to Basalt! Down below have general steps on how you can contribute to the project and improve it!

#### Testing and Debugging
The Basalt.TestField project contains a sample scene with some existing components. It can be convenient for testing if you have some entities already set up. Feel free to improve it to fit your needs and improve testing overall.
Any changes should have all units tests passing. If you implement new changes, adding unit and integration tests for you component would help ensure the code is fully functional when another contributor changes it.

#### Did you find a bug?
- Open a [Github Issue](https://github.com/thiagomvas/Basalt/issues/new) for us or any other contributor to take a look.
- Try to describe the bug as well as you can. If possible include source code reproducing the same bug.
> [!TIP]
> Try to see if that bug already has an issue before opening a new one! This prevents clutter and makes it easier to keep track of things.

#### Did you write a patch that fixes a bug?
Feel free to open a new pull request with the patch.
- If any, reference an issue that contains the bug(s) fixed
- Describe what you changed if the bug fix was more than a few lines of code. This makes it easier and faster to accept pull requests.

#### Did you add a new feature or change an existing one?
Before doing this, please open a Github Issue explaining any changes you make. Sometimes, a change can be out of scope and unlikely to be accepted, this is a way to gather feedback on whether that would be a good change, or even improve your ideas.
If you've done this, feel free to open a pull request explaining your changes.

#### Did you change whitespaces, code formatting, documentation or similar?
While any contribution is welcome and likely to get accepted, changes of this nature shouldn't be something as small as fixing a README typo. If you added documentation for the wiki, useful information on README or XML Comments in the source code where it was missing before, then those will likely be accepted, as they are meaningful contributions.

We appreciate your time and are thankful for any contributions!
