﻿namespace Basalt.Core.Common.Types
{
	/// <summary>
	/// This enum has all input buttons that can be used in the engine.
	/// Keyboard keys have their correct keycode assigned.
	/// </summary>
	public enum InputKey : short
	{
		A = 65,
		B = 66,
		C = 67,
		D = 68,
		E = 69,
		F = 70,
		G = 71,
		H = 72,
		I = 73,
		J = 74,
		K = 75,
		L = 76,
		M = 77,
		N = 78,
		O = 79,
		P = 80,
		Q = 81,
		R = 82,
		S = 83,
		T = 84,
		U = 85,
		V = 86,
		W = 87,
		X = 88,
		Y = 89,
		Z = 90,
		Num0 = 48,
		Num1 = 49,
		Num2 = 50,
		Num3 = 51,
		Num4 = 52,
		Num5 = 53,
		Num6 = 54,
		Num7 = 55,
		Num8 = 56,
		Num9 = 57,
		Space = 32,
		Enter = 13,
		Escape = 27,
		Tab = 9,
		Shift = 16,
		Control = 17,
		Alt = 18,
		CapsLock = 20,
		Backspace = 8,
		Delete = 46,
		Insert = 45,
		Home = 36,
		End = 35,
		PageUp = 33,
		PageDown = 34,
		ArrowUp = 38,
		ArrowDown = 40,
		ArrowLeft = 37,
		ArrowRight = 39,
		F1 = 112,
		F2 = 113,
		F3 = 114,
		F4 = 115,
		F5 = 116,
		F6 = 117,
		F7 = 118,
		F8 = 119,
		F9 = 120,
		F10 = 121,
		F11 = 122,
		F12 = 123,

		// MOUSE INPUT

		MouseLeft = 1001,
		MouseRight = 1002,
		MouseMiddle = 1003,
		MouseBack = 1004,
		MouseForward = 1005,

	}
}
