---
title: "About"
tagline: "How this whole thing started"
date: 2019-04-03T01:11:34-07:00
---

## About Me

![Linus @ Cal Hacks 2018](/img/about-linus.jpg)

Hi there 👋 I'm Linus. I've been coding since around 2012, and for most of that time, I've been building software for the web, focusing on what we call "frontend" -- that's the bits you see when you interact with anything on the web. The webpages, the buttons, the forms, the animations, the whole deal.

I've wanted to start my own web design and development course for years now. I love teaching, I love making things for the web, and this is a combination I just had to hit at some point.

If you ever want to get in touch, whether about Zero to Code or anything else, you can start a conversation at...

- [@thesephist](https://twitter.com/thesephist) on Twitter
- [/thesephist](https://www.linkedin.com/in/thesephist/) on LinkedIn
- [linus.zone/now](https://linus.zone/now), my website, for everything else.

Please reach out if you have any questions, ideas, or feedback! I'd love to hear from you and see what you're making.

## A problem: great courses are hard to come by

Coding for the web was how I began my career as a programmer, and it's still my primary field of expertise in software, as a UI and frontend infrastructure engineer. So over the years lots of friends and family have asked me, "I want to get into learning how to code to build websites. Where should I go?" And I've always come up dry.

See, the problem isn't that there aren't any great courses online. From Codecademy to FreeCodeCamp to Egghead.io and a million tutorial sites and YouTube videos in between, there's a seemingly endless supply of online, usually free, courses on web development. No, my issue is that almost all of the high-quality, well-designed, up-to-date courses on web development are inexplicably targeted towards developers who already know their way around a terminal or a Python shell. Most of these tutorials out there today also focus disproportionately on the "programming" side of building on the web. Compelling experiences on the web are built as a well-balanced marriage of good engineering and great design, and most tutorials only mention design in passing.

>Almost all of the high-quality, well-designed, up-to-date courses on web development are inexplicably targeted towards developers who already know their way around a terminal.

I didn't like that I never had great answers when people asked for a way to learn to code. I wanted to build a high-quality, design-oriented course on web development that was guaranteed to be open and freely accessible by anyone.

## Codeframe sparked an idea

In late March 2019, I started a side project called [Codeframe](https://codeframe.co), a fast, lightweight, easy-to-use code editor for writing frontend web code using HTML, CSS, and JavaScript. It looked like this.

![Codeframe screenshot circa March 2019](/img/codeframe-mar19.png)

Originally, this was just like any other side project of mine -- something I spend one, maybe two days to get working, and leave to sit on my computer and collect dust while I go entertain other ideas that would come after. But Codeframe ended up being different. Once I got the basic features working, I found myself being more and more interested in adding features, making it better and more useful to people learning to program for the first time. And when I shared it online, people reached out wanting to try it without being asked. I started sharing it with students new to programming or building websites, and found that Codeframe could be a unique tool in helping people learn to program more easily and painlessly.

So once the main features were complete in Codeframe, I started working on a web design and development course that would be built around the unique features of Codeframe as a programming and creative tool -- ease of use, fast feedback, and shareability. This was Zero to Code.

## A course built around creating and sharing, from day one

Some of the most impressive and talented developers I know started by programming on the web using HTML, CSS, and JavaScript. The web is so qualitatively unique as a place to learn to code, because it's visual from the beginning, interactive by design, and anything you make on the web can be shared instantly with anyone else, regardless of whether they're a programmer.

I think this makes the web a unique place to start learning to code, and when I started designing ZTC, I consciously laid out the materials around _milestones_, digestible units of small projects which would review concepts, be instantly sharable, and leave room for creative exploration and experimentation.

To me, the most important button in the Codeframe editor is this one.

<p>
    <button class="button">Preview</button>
</p>

Codeframe is built from the ground up around **instant feedback** -- you see the output of your code, live, as you type. But **once you have something interesting, or creative, or useful, you should be able to share it with anyone else**. I think this is the most important step in learning to code, getting other people's feedback and iterating on ideas to make something useful or interesting. So Zero to Code's projects are all designed to be more than just reviews -- they're useful mini-projects that you can customize and share with other people. I really think that's key, and I hope this instant shareability built into the course inspires more people to keep coding.

## Building a high-quality, open resource

Ultimately, I want Zero to Code to be less of a course and more of a guide. Because the Internet is built by web designers and developers, it's fortunately not an impossible feat to become a self-taught web developer, but it takes a lot of trials and tribulations, trying to sort out which sources are better than others, which Stack Overflow answers are more up-to-date, and where you should go for help. And all this extra work makes the actual task of _learning to code_ and make stuff on the web tiring at times.

I hope the materials and notes on Zero to Code, alongside Codeframe's features, makes it a bit more painless and a bit more empowering for everyone to learn to build things with code. And to that goal of making the course as accessible and open as possible, everything on this website will be, as long as I can manage, available freely for everyone online.

If you have any questions, concerns, feedback, ideas, feature requests, stories, or comments, please don't hesitate to get in touch! I'd love to hear what you think. I'm online at **@thesephist** on [GitHub](https://github.com/thesephist) and [Twitter](https://twitter.com/thesephist), and you can find more info about me at [linus.zone/now](https://linus.zone/now).
