# 更新日志

<GlobalElement />

对于新功能、新组件、`bug` 修复以及文档更新，您可以向 `main` 分支创建拉取请求或者直接通过右下角邮箱地址直接联系我

## 2.0.5 <Tag color="volcano" size="small">soon</Tag>

- 优化并更新 [复选框 Checkbox](https://themusecatcher.github.io/vue-amazing-ui/guide/components/checkbox.html) 组件点击动画效果
- 优化并更新 [表格 Table](https://themusecatcher.github.io/vue-amazing-ui/guide/components/table.html) 组件功能优化
- 组件库及文档代码优化

## 2.0.4 <Tag color="volcano" size="small">2024-12-30</Tag>

- 优化并更新 [水印 Watermark](https://themusecatcher.github.io/vue-amazing-ui/guide/components/watermark.html) 组件，新增 `fixed` 属性，支持固定全屏水印
- 组件库及文档代码优化

## 2.0.3 <Tag color="volcano" size="small">2024-12-26</Tag>

- 优化并更新 [倒计时 Countdown](https://themusecatcher.github.io/vue-amazing-ui/guide/components/countdown.html) 组件，将 `finishedText` 属性重命名为 `finish`
- 修复 [搜索框 InputSearch](https://themusecatcher.github.io/vue-amazing-ui/guide/components/inputsearch.html) 组件使用插槽自定义搜索图标不生效的问题
- 所有支持插槽的组件文档新增 `Slots` 相关说明文档
- 组件库及文档代码优化

## 2.0.2 <Tag color="volcano" size="small">2024-12-24</Tag>

- 优化并更新 [浮动按钮 FloatButton](https://themusecatcher.github.io/vue-amazing-ui/guide/components/floatbutton.html) 组件，`icon` 属性新增类型 `VNode`
- 新增 `VueAmazingUIStyleResolve` 方法导出，用于配合 `vite-plugin-style-import` 插件实现按需自动引入组件样式，具体请参考 [自动引入样式](https://themusecatcher.github.io/vue-amazing-ui/guide/ondemand.html#%E8%87%AA%E5%8A%A8%E5%BC%95%E5%85%A5%E6%A0%B7%E5%BC%8F-%E6%8E%A8%E8%8D%90)
- 组件库及文档代码优化

## 2.0.1 <Tag color="volcano" size="small">2024-12-20</Tag>

- 优化并更新 [步骤条 Steps](https://themusecatcher.github.io/vue-amazing-ui/guide/components/steps.html) 组件，将 `Steps` 属性重命名为 `items`
- 优化并更新 [标签页 Tabs](https://themusecatcher.github.io/vue-amazing-ui/guide/components/tabs.html) 组件，将 `tabPages` 属性重命名为 `items`
- 组件库及文档代码优化

## 2.0.0 <Tag color="volcano" size="small">2024-12-18</Tag>

- 优化组件库打包构建；所有组件支持手动或自动按需引入；全面支持基于 `ES modules` 的 `tree shaking`
- 新增 `VueAmazingUIResolver` 方法导出，用于配合 `unplugin-vue-components` 插件支持组件库的自动按需引入，具体请参考 [自动按需引入](https://themusecatcher.github.io/vue-amazing-ui/guide/ondemand.html#%E8%87%AA%E5%8A%A8%E6%8C%89%E9%9C%80%E5%BC%95%E5%85%A5-%E5%BC%BA%E7%83%88%E6%8E%A8%E8%8D%90)
- 组件库及文档代码优化

## 1.10.4 <Tag color="volcano" size="small">2024-12-10</Tag>

- 优化并更新 [复选框 Checkbox](https://themusecatcher.github.io/vue-amazing-ui/guide/components/checkbox.html) 组件，删除 `width` `height` 属性；新增选中动画效果
- 优化并更新 [单选框 Radio](https://themusecatcher.github.io/vue-amazing-ui/guide/components/radio.html) 组件，删除 `width` `height` 属性；新增选中动画效果
- 优化并更新 [文字滚动 TextScroll](https://themusecatcher.github.io/vue-amazing-ui/guide/components/textscroll.html) 组件，将 `verticalInterval` 属性重命名为 `interval`；新增 `duration` 属性；用于控制垂直滚动过渡持续时间；代码逻辑优化

## 1.10.3 <Tag color="volcano" size="small">2024-12-09</Tag>

- 优化并更新 [表格 Table](https://themusecatcher.github.io/vue-amazing-ui/guide/components/table.html) 组件，新增 `sticky` 属性，支持：对于长表格设置跟随页面固定表头和水平滚动条，方便查看表头和使用滚动条
- 优化并更新 [文字滚动 TextScroll](https://themusecatcher.github.io/vue-amazing-ui/guide/components/textscroll.html) 组件，将 `scrollText` 属性重命名为 `items`；删除 `interval` `step` 属性，新增 `speed` 属性；用于更方便的控制水平滚动动画速度；重构水平滚动动画效果；新增 `pauseOnMouseEnter` 属性，支持控制鼠标移入时是否暂停滚动
- 组件库及文档代码优化

## 1.10.2 <Tag color="volcano" size="small">2024-12-05</Tag>

- 优化并更新 [播放器 Video](https://themusecatcher.github.io/vue-amazing-ui/guide/components/video.html) 组件，新增 `iconSize` 属性；重命名 `showPlay` 属性为 `playIcon`；新增 `play` `pause` 方法；支持：设置播放暂停图标的尺寸；使用 `Methods` 控制播放暂停

## 1.10.1 <Tag color="volcano" size="small">2024-12-04</Tag>

- 优化类型声明文件导出
- 组件库及文档代码优化

## 1.10.0 <Tag color="volcano" size="small">2024-12-03</Tag>

- 添加类型声明文件，提供所有组件相关类型定义的导出，为使用 `TypeScript` 开发提供更好的支持
- 组件库及文档代码优化

## 1.9.12 <Tag color="volcano" size="small">2024-12-02</Tag>

- 优化并更新 [折叠面板 Collapse](https://themusecatcher.github.io/vue-amazing-ui/guide/components/collapse.html) 组件，将 `collapseData` 属性重命名为 `items`，新增 `collapseStyle` `copyText` `copiedText` 等属性；支持：自定义样式；自定义箭头图标；自定义复制按钮文本；单个面板自定义样式、箭头属性、复制按钮等功能
- 优化并更新 [时间轴 Timeline](https://themusecatcher.github.io/vue-amazing-ui/guide/components/timeline.html) 组件，将 `timelineData` 属性重命名为 `items`

## 1.9.11 <Tag color="volcano" size="small">2024-11-28</Tag>

- 修复组件库 `vue-amazing-ui@1.9.10` 更新 `vite` 至 `v6` 后，打包时 `cssFileName` 默认值更改为 `package.json` 中的 `name` 值导致无法引入 `css` 文件的相关问题

## 1.9.10 <Tag color="volcano" size="small">2024-11-28</Tag>

- 优化并更新 [回到顶部 BackTop](https://themusecatcher.github.io/vue-amazing-ui/guide/components/backtop.html) 组件，新增支持设置多种 `CSS` 变量自定义样式
- 优化并更新 [滑动输入条 Slider](https://themusecatcher.github.io/vue-amazing-ui/guide/components/slider.html) 组件，新增支持设置多种 `CSS` 变量自定义样式
- 组件库及文档代码优化

## 1.9.9 <Tag color="volcano" size="small">2024-11-27</Tag>

- 优化并更新 [表格 Table](https://themusecatcher.github.io/vue-amazing-ui/guide/components/table.html) 组件代码和功能
- 优化并更新 [进度条 Progress](https://themusecatcher.github.io/vue-amazing-ui/guide/components/progress.html) 组件，重构组件，新增支持更多样式自定义
- 组件库及文档代码优化

## 1.9.8 <Tag color="volcano" size="small">2024-11-26</Tag>

- 优化并更新 [滚动条 Scrollbar](https://themusecatcher.github.io/vue-amazing-ui/guide/components/scrollbar.html) 组件，新增 `yScrollable` 属性，用于控制是否使用垂直滚动；新增支持通过设置 `--scrollbar` 相关变量自定义滚动条样式
- 优化并更新 [表格 Table](https://themusecatcher.github.io/vue-amazing-ui/guide/components/table.html) 组件，新增 `rowClassName` `showSorterTooltip` `sortDirections` `tooltipProps` 属性；表格列的配置项 `columns` 属性新增 `align` `className` `key` `children` `showSorterTooltip` `sortTooltipProps` `defaultSortOrder` `sortDirections` `sorter` 类型；新增 `expand` `expandedRowsChange` 事件；支持：设置列文本对齐方式；自定义样式；列表头分组；是否显示下一次排序的 `tooltip` 提示；自定义某列的默认排序顺序；设置支持的排序方式；表格排序控制；展开行变化回调事件；排序变化回调事件
- 优化并更新 [文字提示 Tooltip](https://themusecatcher.github.io/vue-amazing-ui/guide/components/tooltip.html) 组件，新增 `contentClass` `showControl` 属性，支持：设置展示内容的类名；是否 `trigger: hover` 时只使用 `show` 属性控制显示隐藏
- 优化并更新 [弹出确认 Popconfirm](https://themusecatcher.github.io/vue-amazing-ui/guide/components/popconfirm.html) 组件，新增 `keyboard` 属性，默认支持按键操作
- 优化并更新 [气泡卡片 Popover](https://themusecatcher.github.io/vue-amazing-ui/guide/components/popover.html) 组件，新增 `keyboard` 属性，默认支持按键操作
- 组件库及文档代码优化

## 1.9.7 <Tag color="volcano" size="small">2024-11-20</Tag>

- 优化并更新 [滚动条 Scrollbar](https://themusecatcher.github.io/vue-amazing-ui/guide/components/scrollbar.html) 组件，新增 `xPlacement` `yPlacement` 属性，支持设置滚动条位置；调整是否使用横向滚动属性名 `horizontal` 为 `xScrollable`；新增 `getScrollData` 方法，用于获取滚动区域相关数据；新增 `scrollend` 回调函数，同时回调函数新增 `direction` 参数，用于表示滚动方向
- 优化并更新 [表格 Table](https://themusecatcher.github.io/vue-amazing-ui/guide/components/table.html) 组件，新增 `scrollbarProps` 属性，表格所有滚动均使用 [滚动条 Scrollbar](https://themusecatcher.github.io/vue-amazing-ui/guide/components/scrollbar.html) 组件，并支持滚动条相关属性配置
- 新增 [滚动监测 useScroll](https://themusecatcher.github.io/vue-amazing-ui/utils/functions/scroll.html) 工具函数，用于实时监测指定元素滚动位置及状态；删除 `useScrollDirection` 工具函数
- 组件库及文档代码优化

## 1.9.6 <Tag color="volcano" size="small">2024-11-15</Tag>

- 优化并更新 [选择器 Select](https://themusecatcher.github.io/vue-amazing-ui/guide/components/select.html) 组件，新增 `size` 属性，支持设置选择器的尺寸大小
- 优化并更新 [分页 Pagination](https://themusecatcher.github.io/vue-amazing-ui/guide/components/pagination.html) 组件，新增 `size` 属性，支持设置分页器的尺寸大小
- 优化并更新 [表格 Table](https://themusecatcher.github.io/vue-amazing-ui/guide/components/table.html) 组件，新增 `size` `striped` `ellipsisProps` `scroll` `showExpandColumn` `expandColumnTitle` `expandColumnWidth` `expandCell` `expandedRowRender` `expandFixed` `expandedRowKeys` `expandRowByClick` 等属性；支持：设置三种尺寸；斑马条纹；合并单元格；可编辑单元格；可编辑行；可展开；固定列；固定表头；固定头和列等多种功能
- 组件库及文档代码优化

## 1.9.5 <Tag color="volcano" size="small">2024-11-13</Tag>

- 优化并更新 [浮动按钮 FloatButton](https://themusecatcher.github.io/vue-amazing-ui/guide/components/floatbutton.html) 组件，新增 `zIndex` 属性，支持设置按钮的 `z-index` 值
- 优化并更新 [文字滚动 TextScroll](https://themusecatcher.github.io/vue-amazing-ui/guide/components/floatbutton.html) 组件代码
- 优化并更新 [文本省略 Ellipsis](https://themusecatcher.github.io/vue-amazing-ui/guide/components/ellipsis.html) 组件代码逻辑
- 组件库及文档代码优化

## 1.9.4 <Tag color="volcano" size="small">2024-11-08</Tag>

- 优化并更新 [文本省略 Ellipsis](https://themusecatcher.github.io/vue-amazing-ui/guide/components/ellipsis.html) 组件，优化弹出提示默认最大宽度计算方式
- 优化并更新 [文字提示 Tooltip](https://themusecatcher.github.io/vue-amazing-ui/guide/components/tooltip.html) 组件，优化自动调整弹出位置算法逻辑
- 优化并更新 [警告提示 Alert](https://themusecatcher.github.io/vue-amazing-ui/guide/components/alert.html) 组件，优化关闭时的动画效果
- 优化并更新 [徽标 Badge](https://themusecatcher.github.io/vue-amazing-ui/guide/components/badge.html) 组件，优化关闭时的动画效果
- 优化并更新 [图片 Image](https://themusecatcher.github.io/vue-amazing-ui/guide/components/image.html) 组件，优化预览打开关闭动画效果
- 优化并更新 [全局提示 Message](https://themusecatcher.github.io/vue-amazing-ui/guide/components/message.html) 组件，优化显示隐藏动画效果
- 优化并更新 [选择器 Select](https://themusecatcher.github.io/vue-amazing-ui/guide/components/select.html) 组件，优化红点显示隐藏动画效果
- 优化并更新 [表格 Table](https://themusecatcher.github.io/vue-amazing-ui/guide/components/table.html) 组件，重构表格组件；新增 `header` `footer` `bordered` `tableLayout` 属性；支持：使用 `headerCell` `bodyCell` 自定义个性化头部单元格和内容单元格；引入文本省略组件，支持表格头部或内容单元格文本溢出时自动显示省略号，且悬浮省略文本时，自动弹出文字提示
- 组件库及文档代码优化

## 1.9.3 <Tag color="volcano" size="small">2024-11-06</Tag>

- 优化并更新 [上传 Upload](https://themusecatcher.github.io/vue-amazing-ui/guide/components/upload.html) 组件，新增 `draggable` 属性，支持控制拖拽上传功能
- 优化并更新 [文字提示 Tooltip](https://themusecatcher.github.io/vue-amazing-ui/guide/components/tooltip.html) 组件代码和动画效果，支持异步更新内容和文字提示，自动更新文字提示框位置
- 优化并更新 [回到顶部 BackTop](https://themusecatcher.github.io/vue-amazing-ui/guide/components/backtop.html) 组件，`icon` 属性新增支持 `VNode` 类型
- 优化并更新 [按钮 Button](https://themusecatcher.github.io/vue-amazing-ui/guide/components/button.html) 组件，`icon` 属性新增支持 `VNode` 类型
- 组件库及文档代码优化

## 1.9.2 <Tag color="volcano" size="small">2024-11-04</Tag>

- 优化并更新 [对话框 Dialog](https://themusecatcher.github.io/vue-amazing-ui/guide/components/dialog.html) 组件，新增 `titleStyle` `contentStyle` `bodyClass` `bodyStyle` `maskStyle` `transformOrigin` `blockScroll` `keyboard` `maskClosable` 等属性；删除部分属性；支持：控制对话框动画出现位置；控制打开对话框时禁用背景滚动；控制键盘 `Esc` 关闭；控制点击蒙层关闭；设置标题、内容、`body`、蒙层样式等功能
- 优化并更新 [模态框 Modal](https://themusecatcher.github.io/vue-amazing-ui/guide/components/modal.html) 组件，新增 `titleStyle` `contentStyle` `bodyClass` `bodyStyle` `maskStyle` `transformOrigin` `blockScroll` `keyboard` `maskClosable` 等属性；删除部分属性；支持：控制模态框动画出现位置；控制打开模态框时禁用背景滚动；控制键盘 `Esc` 关闭；控制点击蒙层关闭；设置标题、内容、`body`、蒙层样式等功能
- 组件库及文档代码优化

## 1.9.1 <Tag color="volcano" size="small">2024-10-31</Tag>

- 优化并更新 [对话框 Dialog](https://themusecatcher.github.io/vue-amazing-ui/guide/components/dialog.html) 组件，优化显示隐藏动画效果
- 优化并更新 [图片 Image](https://themusecatcher.github.io/vue-amazing-ui/guide/components/image.html) 组件，优化显示隐藏动画效果
- 优化并更新 [全局提示 Message](https://themusecatcher.github.io/vue-amazing-ui/guide/components/message.html) 组件，优化显示隐藏动画效果
- 优化并更新 [模态框 Modal](https://themusecatcher.github.io/vue-amazing-ui/guide/components/modal.html) 组件，优化显示隐藏动画效果
- 优化并更新 [按钮 Button](https://themusecatcher.github.io/vue-amazing-ui/guide/components/modal.html) 组件，新增 `keyboard` 属性，支持控制是否支持键盘操作
- 组件库及文档代码优化

## 1.9.0 <Tag color="volcano" size="small">2024-10-30</Tag>

- 优化并更新 [文字提示 Tooltip](https://themusecatcher.github.io/vue-amazing-ui/guide/components/tooltip.html) 组件，新增 `flip` `keyboard` `transitionDuration` 属性，支持自动调整弹出位置；按键控制；自定义过渡动画时间；使用 `Methods` 控制显示隐藏
- 优化并更新 [弹出确认 Popconfirm](https://themusecatcher.github.io/vue-amazing-ui/guide/components/popconfirm.html) 组件，以 `Tooltip` 组件为基础重构，新增 `tooltipStyle` 属性，删除部分原有属性，更多属性请参考 [Tooltip](https://themusecatcher.github.io/vue-amazing-ui/guide/components/tooltip.html#tooltip)，支持自动调整弹出位置；自定义过渡动画时间等
- 优化并更新 [气泡卡片 Popover](https://themusecatcher.github.io/vue-amazing-ui/guide/components/popconfirm.html) 组件，以 `Tooltip` 组件为基础重构，新增 `tooltipStyle` 属性，删除部分原有属性，更多属性请参考 [Tooltip](https://themusecatcher.github.io/vue-amazing-ui/guide/components/tooltip.html#tooltip)，支持自动调整弹出位置；自定义过渡动画时间等
- 优化并更新 [文本省略 Ellipsis](https://themusecatcher.github.io/vue-amazing-ui/guide/components/ellipsis.html) 组件，新增 `tooltipMaxWidth` 属性，删除 `tooltipProps` 属性，更多属性请参考 [Tooltip](https://themusecatcher.github.io/vue-amazing-ui/guide/components/tooltip.html#tooltip)，支持自动调整弹出位置；自定义过渡动画时间；延迟显示隐藏；隐藏箭头等
- 组件库及文档代码优化

## 1.8.10 <Tag color="volcano" size="small">2024-10-25</Tag>

- 优化并更新 [文字提示 Tooltip](https://themusecatcher.github.io/vue-amazing-ui/guide/components/tooltip.html) 组件，新增 `tooltipClass` `placement` 属性，支持自定义弹出提示位置及类名
- 优化并更新 [标签页 Tabs](https://themusecatcher.github.io/vue-amazing-ui/guide/components/tabs.html) 组件，修复当标签页左右切换时，页面会短暂出现滚动条的问题
- 组件库及文档代码优化

## 1.8.9 <Tag color="volcano" size="small">2024-10-24</Tag>

- 优化并更新 [浮动按钮 FloatButton](https://themusecatcher.github.io/vue-amazing-ui/guide/components/floatbutton.html) 组件
- 组件库文档代新增赞助功能模块
- 组件库及文档代码优化

## 1.8.8 <Tag color="volcano" size="small">2024-10-22</Tag>

- 优化并更新 [头像 Avatar](https://themusecatcher.github.io/vue-amazing-ui/guide/components/avatar.html) 组件，新增 `href` `target` 属性，支持链接跳转功能
- 优化并更新 [文字滚动 TextScroll](https://themusecatcher.github.io/vue-amazing-ui/guide/components/textscroll.html) 组件，新增 `hrefHoverColor` 属性，支持自定义链接悬浮颜色
- 组件库及文档代码优化

## 1.8.7 <Tag color="volcano" size="small">2024-10-21</Tag>

- 优化并更新 [上传 Upload](https://themusecatcher.github.io/vue-amazing-ui/guide/components/upload.html) 组件，新增 `drop` `preview` 事件回调，调整 `beforeUpload` 属性，支持返回一个 `Promise` 对象，用于控制上传
- 优化并更新 [加载中 Spin](https://themusecatcher.github.io/vue-amazing-ui/guide/components/upload.html) 组件
- 组件库及文档代码优化

## 1.8.6 <Tag color="volcano" size="small">2024-10-18</Tag>

- 优化并更新 [警告提示 Alert](https://themusecatcher.github.io/vue-amazing-ui/guide/components/alert.html) 组件，新增 `type: 'default'` 类型，以及 `bordered` 属性
- 优化并更新 [头像 Avatar](https://themusecatcher.github.io/vue-amazing-ui/guide/components/avatar.html) 组件，新增 `color` 属性
- 优化并更新 [渐变文字 GradientText](https://themusecatcher.github.io/vue-amazing-ui/guide/components/gradienttext.html) 组件，新增 `weight` 属性
- 优化并更新 [抽屉 Drawer](https://themusecatcher.github.io/vue-amazing-ui/guide/components/drawer.html) 组件，支持开启抽屉时，禁止背景滚动
- 组件库及文档代码优化

## 1.8.5 <Tag color="volcano" size="small">2024-10-17</Tag>

- 优化并更新 [文本省略 Ellipsis](https://themusecatcher.github.io/vue-amazing-ui/guide/components/ellipsis.html) 组件
- 组件库及文档代码优化

## 1.8.4 <Tag color="volcano" size="small">2024-10-16</Tag>

- 优化并更新 [评分 Rate](https://themusecatcher.github.io/vue-amazing-ui/guide/components/rate.html) 组件，支持键盘左/右按键操作评分
- 组件库及文档代码优化

## 1.8.3 <Tag color="volcano" size="small">2024-10-15</Tag>

- 优化并更新 [单选框 Radio](https://themusecatcher.github.io/vue-amazing-ui/guide/components/radio.html) 组件，新增 `checked` `width` `height` 属性，调整 `gap` 属性相关功能
- 优化并更新 [评分 Rate](https://themusecatcher.github.io/vue-amazing-ui/guide/components/rate.html) 组件，新增 `tooltips` `tooltipProps` 属性，支持设置文案提示
- 组件库及文档代码优化

## 1.8.2 <Tag color="volcano" size="small">2024-10-14</Tag>

- 优化并更新 [复选框 Checkbox](https://themusecatcher.github.io/vue-amazing-ui/guide/components/checkbox.html) 组件
- 组件库及文档代码优化

## 1.8.1 <Tag color="volcano" size="small">2024-10-11</Tag>

- 优化并更新 [选择器 Select](https://themusecatcher.github.io/vue-amazing-ui/guide/components/select.html) 组件，新增 `openChange` 事件
- 优化并更新 [文字滚动 TextScroll](https://themusecatcher.github.io/vue-amazing-ui/guide/components/textscroll.html) 组件，新增 `start` `stop` `reset` 方法，支持手动控制开始、暂停、重置滚动
- 组件库及文档代码优化

## 1.8.0 <Tag color="volcano" size="small">2024-10-10</Tag>

- 新增 [浮动按钮 FloatButton](https://themusecatcher.github.io/vue-amazing-ui/guide/components/floatbutton.html) 组件
- 组件库及文档代码优化

## 1.7.2 <Tag color="volcano" size="small">2024-10-09</Tag>

- 优化并更新 [对话框 Dialog](https://themusecatcher.github.io/vue-amazing-ui/guide/components/dialog.html) 组件，将属性 `show` 重命名为 `open`
- 组件库及文档代码优化

## 1.7.1 <Tag color="volcano" size="small">2024-10-01</Tag>

- 优化并更新 [按钮 Button](https://themusecatcher.github.io/vue-amazing-ui/guide/components/button.html) 组件
- 优化并更新 [选择框 Select](https://themusecatcher.github.io/vue-amazing-ui/guide/components/select.html) 组件
- 组件库及文档代码优化

## 1.7.0 <Tag color="volcano" size="small">2024-09-28</Tag>

- 优化并更新 [标签页 Tabs](https://themusecatcher.github.io/vue-amazing-ui/guide/components/tabs.html) 组件，新增 `prefix` `suffix` `animated` `tabGutter` `tabStyle` `tabPosition` `contentStyle` 属性

## 1.6.9 <Tag color="volcano" size="small">2024-09-26</Tag>

- 优化并更新 [标签页 Tabs](https://themusecatcher.github.io/vue-amazing-ui/guide/components/tabs.html) 组件，新增带图标的标签页功能
- 组件库及文档代码优化

## 1.6.8 <Tag color="volcano" size="small">2024-09-24</Tag>

- 优化 [徽标 Badge](https://themusecatcher.github.io/vue-amazing-ui/guide/components/badge.html) 组件实现
- 优化并更新 [卡片 Card](https://themusecatcher.github.io/vue-amazing-ui/guide/components/card.html) 组件，新增 `hoverable` `skeletonProps` 属性，并调整卡片尺寸 `size` 功能
- 优化并更新 [折叠面板 Collapse](https://themusecatcher.github.io/vue-amazing-ui/guide/components/collapse.html) 组件，新增 `copyProps` 属性
- 组件库及文档代码优化

## 1.6.7 <Tag color="volcano" size="small">2024-09-18</Tag>

- 组件库代码优化

## 1.6.6 <Tag color="volcano" size="small">2024-09-13</Tag>

- 优化并更新 [滑动输入条 Slider](https://themusecatcher.github.io/vue-amazing-ui/guide/components/slider.html) 组件，新增垂直模式
- 优化并更新 [数字输入框 InputNumber](https://themusecatcher.github.io/vue-amazing-ui/guide/components/inputnumber.html) 组件
- 组件库及文档代码优化

## 1.6.5 <Tag color="volcano" size="small">2024-09-10</Tag>

- 优化并更新 [全局提示 Message](https://themusecatcher.github.io/vue-amazing-ui/guide/components/message.html) 组件，新增自定义图标、自定义类名、自定义样式等功能
- 优化并更新 [模态框 Modal](https://themusecatcher.github.io/vue-amazing-ui/guide/components/modal.html) 组件，新增自定义图标、自定义类型、自定义样式等功能
- 组件库及文档代码优化

## 1.6.4 <Tag color="volcano" size="small">2024-09-06</Tag>

- 优化并更新 [倒计时 Countdown](https://themusecatcher.github.io/vue-amazing-ui/guide/components/countdown.html) 组件，新增随时暂停和重置倒计时功能
- 优化并更新 [通知提醒 Notification](https://themusecatcher.github.io/vue-amazing-ui/guide/components/notification.html) 组件，新增自定义图标、自定义类名、自定义样式等功能
- 组件库及文档代码优化

## 1.6.3 <Tag color="volcano" size="small">2024-08-30</Tag>

- 优化并更新 [回到顶部 Backtop](https://themusecatcher.github.io/vue-amazing-ui/guide/components/backtop.html) 组件，新增 `icon` `description` `tooltip` `tooltipProps` `type` `shape` 属性
- 优化并更新 [文字提示 Tooltip](https://themusecatcher.github.io/vue-amazing-ui/guide/components/tooltip.html) 组件，新增 `contentStyle` 属性
- 优化并更新 [按钮 Button](https://themusecatcher.github.io/vue-amazing-ui/guide/components/button.html) 组件，新增 `buttonClass` 属性，删除 `loadingColor` 属性
- 组件库及文档代码优化

## 1.6.2 <Tag color="volcano" size="small">2024-08-29</Tag>

- 优化并更新 [对话框 Dialog](https://themusecatcher.github.io/vue-amazing-ui/guide/components/dialog.html) 组件，`top` 属性新增 `string` 类型
- 优化并更新 [水印 Watermark](https://themusecatcher.github.io/vue-amazing-ui/guide/components/watermark.html) 组件，新增 `textStyle` 属性，删除 `color` `fontSize` `fontWeight` `fontFamily` `fontStyle` 属性
- 优化并更新 [折叠面板 Collapse](https://themusecatcher.github.io/vue-amazing-ui/guide/components/collapse.html) 组件，新增 `disabled` `itemStyle` `headerStyle` `contentStyle` `arrow` `arrowStyle` `extra` 属性
- 组件库及文档代码优化

## 1.6.1 <Tag color="volcano" size="small">2024-08-27</Tag>

- 优化并更新 [输入框 Input](https://themusecatcher.github.io/vue-amazing-ui/guide/components/input.html) 组件
- 优化并更新 [文字提示 Tooltip](https://themusecatcher.github.io/vue-amazing-ui/guide/components/tooltip.html) 组件，新增 `bgColor` `tooltipStyle` `arrow` `trigger` `showDelay` `hideDelay` `show` 属性
- 优化并更新 [气泡卡片 Popover](https://themusecatcher.github.io/vue-amazing-ui/guide/components/popover.html) 组件，新增 `titleStyle` `contentStyle` `bgColor` `popoverStyle` `arrow` `trigger` `showDelay` `hideDelay` `show` 属性
- 优化并更新 [弹出确认 Popconfirm](https://themusecatcher.github.io/vue-amazing-ui/guide/components/popconfirm.html) 组件，新增 `titleStyle` `descriptionStyle` `bgColor` `popconfirmStyle` `iconStyle` `arrow` `trigger` `showDelay` `hideDelay` `show` 属性
- 组件库代码优化

## 1.6.0 <Tag color="volcano" size="small">2024-08-23</Tag>

- 新增 [搜索框 InputSearch](https://themusecatcher.github.io/vue-amazing-ui/guide/components/inputsearch.html) 组件
- 组件库代码优化

## 1.5.4 <Tag color="volcano" size="small">2024-08-22</Tag>

- 优化并更新 [按钮 Button](https://themusecatcher.github.io/vue-amazing-ui/guide/components/button.html) 组件，新增 `shape` `icon` 属性
- 新增工具函数 [监听插槽存在 useSlotsExist](https://themusecatcher.github.io/vue-amazing-ui/utils/functions/slots-exist.html)，用于监听 Vue 组件中插槽是否存在
- 组件库代码优化

## 1.5.3 <Tag color="volcano" size="small">2024-08-19</Tag>

- 优化并更新 [面包屑 Breadcrumb](https://themusecatcher.github.io/vue-amazing-ui/guide/components/breadcrumb.html) 组件，新增 `breadcrumbClass` `breadcrumbStyle` `separatorStyle` 属性
- 优化并更新 [对话框 Dialog](https://themusecatcher.github.io/vue-amazing-ui/guide/components/dialog.html) 组件，新增 `cancelProps` `okProps` 属性
- 优化并更新 [加载中 Spin](https://themusecatcher.github.io/vue-amazing-ui/guide/components/spin.html) 组件，新增 `spinCircleWidth` `spinCirclePercent` `ringRailColor` 属性
- 组件库代码优化

## 1.5.2 <Tag color="volcano" size="small">2024-08-16</Tag>

- 优化并更新 [水印 Watermark](https://themusecatcher.github.io/vue-amazing-ui/guide/components/watermark.html) 组件，新增浏览器暗黑模式下水印颜色自动反转
- 优化并更新 [警告提示 Alert](https://themusecatcher.github.io/vue-amazing-ui/guide/components/alert.html)，新增 `actions` 属性
- 优化并更新 [加载中 Spin](https://themusecatcher.github.io/vue-amazing-ui/guide/components/spin.html)，新增 `indicator: 'ring-circle'` 加载中类型，并新增 `ringCirclePercent` `ringCircleColor` 属性，优化整体效果
- 组件库优化

## 1.5.1 <Tag color="volcano" size="small">2024-08-15</Tag>

- 优化并更新 [列表 List](https://themusecatcher.github.io/vue-amazing-ui/guide/components/list.html) 组件
- 组件库代码优化

## 1.5.0 <Tag color="volcano" size="small">2024-08-14</Tag>

- 新增 [列表 List](https://themusecatcher.github.io/vue-amazing-ui/guide/components/list.html) 组件
- 优化并更新 [空状态 Empty](https://themusecatcher.github.io/vue-amazing-ui/guide/components/empty.html) 组件，新增 `footer` 属性
- 组件库代码优化

## 1.4.7 <Tag color="volcano" size="small">2024-08-13</Tag>

- 优化并更新 [表格 Table](https://themusecatcher.github.io/vue-amazing-ui/guide/components/table.html) 组件，新增 `spinProps` `emptyProps` 属性
- 优化并更新 [表格 Pagination](https://themusecatcher.github.io/vue-amazing-ui/guide/components/table.html) 组件，新增 `disabled` `pageAmount` 属性，更新 `showTotal` 属性
- 优化并更新 [输入框 Input](https://themusecatcher.github.io/vue-amazing-ui/guide/components/input.html) 组件
- 优化并更新 [文本域 Textarea](https://themusecatcher.github.io/vue-amazing-ui/guide/components/textarea.html) 组件
- 组件库及文档代码优化

## 1.4.6 <Tag color="volcano" size="small">2024-08-08</Tag>

- 优化并更新 [文字滚动 TextScroll](https://themusecatcher.github.io/vue-amazing-ui/guide/components/textscroll.html) 组件，优化滚动逻辑
- 优化并更新 [空状态 Empty](https://themusecatcher.github.io/vue-amazing-ui/guide/components/empty.html) 组件，新增 `descriptionStyle` 属性

## 1.4.5 <Tag color="volcano" size="small">2024-08-07</Tag>

- 优化并更新 [倒计时 Countdown](https://themusecatcher.github.io/vue-amazing-ui/guide/components/countdown.html) 组件
- 优化并更新 [弹性布局 Flex](https://themusecatcher.github.io/vue-amazing-ui/guide/components/flex.html) 组件
- 优化并更新 [间距 Space](https://themusecatcher.github.io/vue-amazing-ui/guide/components/space.html) 组件
- 优化并更新 [头像 Avatar](https://themusecatcher.github.io/vue-amazing-ui/guide/components/avatar.html) 组件
- 优化并更新 [卡片 Card](https://themusecatcher.github.io/vue-amazing-ui/guide/components/card.html) 组件
- 组件库及文档代码优化

## 1.4.4 <Tag color="volcano" size="small">2024-08-05</Tag>

- 重构并优化 [开关 Switch](https://themusecatcher.github.io/vue-amazing-ui/guide/components/switch.html) 组件
- 优化并更新 [水印 Watermark](https://themusecatcher.github.io/vue-amazing-ui/guide/components/watermark.html) 组件
- 组件库及文档代码优化

## 1.4.3 <Tag color="volcano" size="small">2024-08-02</Tag>

- 优化并更新 [空状态 Empty](https://themusecatcher.github.io/vue-amazing-ui/guide/components/empty.html) 组件
- 优化并更新 [模态框 Modal](https://themusecatcher.github.io/vue-amazing-ui/guide/components/modal.html) 组件，新增 `cancelProps` `okType` `okProps` `noticeProps` 属性
- 组件库及文档代码优化

## 1.4.2 <Tag color="volcano" size="small">2024-08-01</Tag>

- 优化 [选择器 Select](https://themusecatcher.github.io/vue-amazing-ui/guide/components/select.html) 组件
- 优化 [对话框 Dialog](https://themusecatcher.github.io/vue-amazing-ui/guide/components/dialog.html) 组件
- 优化并更新 [滚动条 Scrollbar](https://themusecatcher.github.io/vue-amazing-ui/guide/components/scrollbar.html) 组件，新增 `contentClass` 属性
- 优化 [抽屉 Drawer](https://themusecatcher.github.io/vue-amazing-ui/guide/components/drawer.html) 组件，新增 `headerClass` `scrollbarProps` `bodyClass` `footerClass` 属性

## 1.4.1 <Tag color="volcano" size="small">2024-07-31</Tag>

- 优化 [按钮 Button](https://themusecatcher.github.io/vue-amazing-ui/guide/components/button.html) 组件
- 优化并更新 [标签 Tag](https://themusecatcher.github.io/vue-amazing-ui/guide/components/tag.html) 组件，新增 `spaceProps` 属性
- 优化并更新 [图片 Image](https://themusecatcher.github.io/vue-amazing-ui/guide/components/image.html) 组件，新增 `spaceProps` `spinProps` 属性，同时删除了部分属性
- 优化并更新 [上传 Upload](https://themusecatcher.github.io/vue-amazing-ui/guide/components/upload.html) 组件，新增 `spaceProps` `spinProps` `imageProps` `messageProps` `actionMessage` 属性，同时删除了部分属性
- 组件库及文档代码优化

## 1.4.0 <Tag color="volcano" size="small">2024-07-30</Tag>

- 新增 [加载条 LoadingBar](https://themusecatcher.github.io/vue-amazing-ui/guide/components/loadingbar.html) 组件

## 1.3.4 <Tag color="volcano" size="small">2024-07-29</Tag>

- 优化并更新 [滚动条 Scrollbar](https://themusecatcher.github.io/vue-amazing-ui/guide/components/scrollbar.html) 组件，新增 `autoHide` `delay` 属性
- 优化并更新 [选择器 Select](https://themusecatcher.github.io/vue-amazing-ui/guide/components/select.html) 组件，新增 `scrollbarProps` 属性

## 1.3.3 <Tag color="volcano" size="small">2024-07-26</Tag>

- 优化 [文本省略 Ellipsis](https://themusecatcher.github.io/vue-amazing-ui/guide/components/ellipsis.html) 组件，新增 `tooltipProps` 属性

## 1.3.2 <Tag color="volcano" size="small">2024-07-26</Tag>

- 优化 [滑动输入条 Slider](https://themusecatcher.github.io/vue-amazing-ui/guide/components/slider.html) 组件
- 优化 [瀑布流 Waterfall](https://themusecatcher.github.io/vue-amazing-ui/guide/components/waterfall.html) 组件

## 1.3.1 <Tag color="volcano" size="small">2024-07-25</Tag>

- 优化 [标签页 Tabs](https://themusecatcher.github.io/vue-amazing-ui/guide/components/tabs.html) 组件实现
- 优化 [轮播图 Carousel](https://themusecatcher.github.io/vue-amazing-ui/guide/components/carousel.html) 组件实现
- 优化更新 [按钮 Button](https://themusecatcher.github.io/vue-amazing-ui/guide/components/button.html) 组件
- 优化更新 [弹出确认 Popconfirm](https://themusecatcher.github.io/vue-amazing-ui/guide/components/popconfirm.html) 组件
- 组件库及文档代码优化

## 1.3.0 <Tag color="volcano" size="small">2024-07-24</Tag>

- 新增 [分段控制器 Segmented](https://themusecatcher.github.io/vue-amazing-ui/guide/components/segmented.html) 组件
- 修复 [文本省略 Ellipsis](https://themusecatcher.github.io/vue-amazing-ui/guide/components/ellipsis.html) 组件：当文本区域宽高变化时，`tooltip` 显示的问题
- 修复 [文字滚动 TextScroll](https://themusecatcher.github.io/vue-amazing-ui/guide/components/textscroll.html)组件：滚动区域尺寸变化时的横向滚动问题

## 1.2.0 <Tag color="volcano" size="small">2024-07-23</Tag>

- 优化 [按钮 Button](https://themusecatcher.github.io/vue-amazing-ui/guide/components/button.html) 组件，并新增相关功能
- 优化 [评分 Rate](https://themusecatcher.github.io/vue-amazing-ui/guide/components/rate.html) 组件
- 修复并优化 [文本省略 Ellipsis](https://themusecatcher.github.io/vue-amazing-ui/guide/components/ellipsis.html) 组件

## 1.1.2 <Tag color="volcano" size="small">2024-07-22</Tag>

- 新增 [监听DOM尺寸 useResizeObserver](https://themusecatcher.github.io/vue-amazing-ui/utils/functions/resize-observer.html) 工具函数

## 1.1.1 <Tag color="volcano" size="small">2024-07-19</Tag>

- 优化 [描述列表 Descriptions](https://themusecatcher.github.io/vue-amazing-ui/guide/components/descriptions.html) 组件

## 1.1.0 <Tag color="volcano" size="small">2024-07-18</Tag>

- 新增 [滚动条 Scrollbar](https://themusecatcher.github.io/vue-amazing-ui/guide/components/scrollbar.html) 组件
- 新增 [DOM监听 useMutationObserver](https://themusecatcher.github.io/vue-amazing-ui/utils/functions/mutation-observer.html) 工具函数

## future

- 新增 布局 Layout 组件
- 新增 菜单 Menu 组件
- 新增 穿梭框 Transfer 组件
- 新增 颜色选择器 ColorPicker 组件
- 时间轴 Timeline 组件，新增水平时间轴
<!-- - 新增 时间选择器 TimePicker 组件
- 重构级联选择 Cascader 组件
- 分段控制器 Segmented 组件，选项切换效果优化 -->

<style lang="less" scoped>
.m-tag {
  vertical-align: top;
  margin-top: 5px;
}
</style>
