import { CheckoutPageType } from '@js/types/checkout.types';

export const CHECKOUT_STEP: { [k: string]: CheckoutPageType } = {
  CART: {
    id: 1,
    slug: 'Cart',
    label: 'YOUR_CART',
    title: 'YOUR_CART',
    ctaLabel: 'NEXT'
  },
  DELIVERY: {
    id: 2,
    slug: 'Delivery',
    label: 'DELIVERY_GENERAL',
    title: 'DELIVERY_MODE',
    ctaLabel: 'CONFIRM_DELIVERY'
  },
  INVOICE: {
    id: 3,
    slug: 'Invoice',
    label: 'BILLING_ADDRESS',
    title: 'SELECT_BILLING_ADDRESS',
    ctaLabel: 'CONFIRM_INVOICE'
  },
  PAYMENT: {
    id: 4,
    slug: 'Payment',
    label: 'PAYMENT',
    title: 'PAYMENT_MODE',
    ctaLabel: 'CONFIRM_PAIEMENT'
  }
};

export const pickupFixtures = [
  {
    id: '484270',
    latitude: '45.778439',
    longitude: '3.082960',
    title: '1001 HERBE',
    address: {
      id: '484270',
      default: 0,
      label: '',
      title: '1001 HERBE',
      firstName: '',
      lastName: '',
      cellphoneNumber: '',
      phoneNumber: '',
      company: '',
      address1: '35 RUE DES CHAUSSETIERS',
      address2: '',
      address3: '',
      zipCode: '63000',
      city: 'CLERMONT FERRAND',
      countryCode: 'FR',
      additionalData: []
    },
    moduleId: 46,
    moduleOptionCode: null,
    openingHours: [
      '10:00-13:00 14:00-19:00',
      '10:00-13:00 14:00-19:00',
      '10:00-13:00 14:00-19:00',
      '10:00-13:00 14:00-19:00',
      '10:00-13:00 14:00-19:00',
      '10:00-13:00 14:00-19:00',
      '00:00-00:00 00:00-00:00'
    ]
  },
  {
    id: '639210',
    latitude: '45.7803831',
    longitude: '3.08291858',
    title: 'BUREAU DE POSTE CLERMONT FERRAND PLACE GAILLARD',
    address: {
      id: '639210',
      default: 0,
      label: '',
      title: 'BUREAU DE POSTE CLERMONT FERRAND PLACE GAILLARD',
      firstName: '',
      lastName: '',
      cellphoneNumber: '',
      phoneNumber: '',
      company: '',
      address1: '2 PLACE GILBERT GAILLARD',
      address2: '',
      address3: '',
      zipCode: '63000',
      city: 'CLERMONT FERRAND',
      countryCode: 'FR',
      additionalData: []
    },
    moduleId: 46,
    moduleOptionCode: null,
    openingHours: [
      '09:00-18:00 00:00-00:00',
      '09:00-18:00 00:00-00:00',
      '09:00-18:00 00:00-00:00',
      '09:00-12:15 14:15-18:00',
      '09:00-18:00 00:00-00:00',
      '09:00-12:00 00:00-00:00',
      '00:00-00:00 00:00-00:00'
    ]
  },
  {
    id: '108891',
    latitude: '45.778648',
    longitude: '3.083939',
    title: 'TAKLOPE',
    address: {
      id: '108891',
      default: 0,
      label: '',
      title: 'TAKLOPE',
      firstName: '',
      lastName: '',
      cellphoneNumber: '',
      phoneNumber: '',
      company: '',
      address1: '9 RUE DES GRAS',
      address2: '',
      address3: '',
      zipCode: '63000',
      city: 'CLERMONT FERRAND',
      countryCode: 'FR',
      additionalData: []
    },
    moduleId: 46,
    moduleOptionCode: null,
    openingHours: [
      '10:00-19:00 00:00-00:00',
      '10:00-19:00 00:00-00:00',
      '10:00-19:00 00:00-00:00',
      '10:00-19:00 00:00-00:00',
      '10:00-19:00 00:00-00:00',
      '10:00-19:00 00:00-00:00',
      '00:00-00:00 00:00-00:00'
    ]
  },
  {
    id: '002572',
    latitude: '45.777777',
    longitude: '3.082777',
    title: '2 PIEDS 2 MAINS',
    address: {
      id: '002572',
      default: 0,
      label: '',
      title: '2 PIEDS 2 MAINS',
      firstName: '',
      lastName: '',
      cellphoneNumber: '',
      phoneNumber: '',
      company: '',
      address1: '34 RUE DU CHEVAL BLANC',
      address2: '',
      address3: '',
      zipCode: '63000',
      city: 'CLERMONT FERRAND',
      countryCode: 'FR',
      additionalData: []
    },
    moduleId: 46,
    moduleOptionCode: null,
    openingHours: [
      '00:00-00:00 00:00-00:00',
      '10:00-13:00 14:00-18:30',
      '10:00-13:00 14:00-18:30',
      '10:00-13:00 14:00-18:30',
      '10:00-13:00 14:00-18:30',
      '10:00-13:00 14:00-18:30',
      '00:00-00:00 00:00-00:00'
    ]
  },
  {
    id: '904500',
    latitude: '45.780652',
    longitude: '3.081796',
    title: 'L  ATELIER DE MARIE',
    address: {
      id: '904500',
      default: 0,
      label: '',
      title: 'L  ATELIER DE MARIE',
      firstName: '',
      lastName: '',
      cellphoneNumber: '',
      phoneNumber: '',
      company: '',
      address1: '8 RUE FONTGIEVE',
      address2: '',
      address3: '',
      zipCode: '63000',
      city: 'CLERMONT FERRAND',
      countryCode: 'FR',
      additionalData: []
    },
    moduleId: 46,
    moduleOptionCode: null,
    openingHours: [
      '10:00-13:30 14:00-19:00',
      '10:00-13:30 14:00-19:00',
      '10:00-19:00 00:00-00:00',
      '10:00-13:30 14:00-19:00',
      '10:00-19:00 00:00-00:00',
      '10:00-19:00 00:00-00:00',
      '00:00-00:00 00:00-00:00'
    ]
  },
  {
    id: '905169',
    latitude: '45.778936',
    longitude: '3.084941',
    title: 'OLIVIER ET CO',
    address: {
      id: '905169',
      default: 0,
      label: '',
      title: 'OLIVIER ET CO',
      firstName: '',
      lastName: '',
      cellphoneNumber: '',
      phoneNumber: '',
      company: '',
      address1: '2 RUE DES GRAS',
      address2: '',
      address3: '',
      zipCode: '63000',
      city: 'CLERMONT FERRAND',
      countryCode: 'FR',
      additionalData: []
    },
    moduleId: 46,
    moduleOptionCode: null,
    openingHours: [
      '00:00-00:00 14:00-19:00',
      '10:00-19:00 00:00-00:00',
      '10:00-19:00 00:00-00:00',
      '10:00-19:00 00:00-00:00',
      '10:00-19:00 00:00-00:00',
      '10:00-19:00 00:00-00:00',
      '00:00-00:00 00:00-00:00'
    ]
  },
  {
    id: '060046',
    latitude: '45.7809822',
    longitude: '3.07991609',
    title: 'BUREAU DE POSTE CLERMONT FERRAND FONTGIEVE RP',
    address: {
      id: '060046',
      default: 0,
      label: '',
      title: 'BUREAU DE POSTE CLERMONT FERRAND FONTGIEVE RP',
      firstName: '',
      lastName: '',
      cellphoneNumber: '',
      phoneNumber: '',
      company: '',
      address1: '30 RUE FONTGIEVE',
      address2: 'LE QUINZE',
      address3: '',
      zipCode: '63000',
      city: 'CLERMONT FERRAND',
      countryCode: 'FR',
      additionalData: []
    },
    moduleId: 46,
    moduleOptionCode: null,
    openingHours: [
      '07:30-19:00 00:00-00:00',
      '07:30-19:00 00:00-00:00',
      '07:30-19:00 00:00-00:00',
      '07:30-19:00 00:00-00:00',
      '07:30-19:00 00:00-00:00',
      '08:00-12:30 00:00-00:00',
      '00:00-00:00 00:00-00:00'
    ]
  },
  {
    id: '102363',
    latitude: '45.780707',
    longitude: '3.078875',
    title: 'LA FABRIQUE DE MARIE',
    address: {
      id: '102363',
      default: 0,
      label: '',
      title: 'LA FABRIQUE DE MARIE',
      firstName: '',
      lastName: '',
      cellphoneNumber: '',
      phoneNumber: '',
      company: '',
      address1: '37 RUE FONTGIEVE',
      address2: '',
      address3: '',
      zipCode: '63000',
      city: 'CLERMONT-FERRAND',
      countryCode: 'FR',
      additionalData: []
    },
    moduleId: 46,
    moduleOptionCode: null,
    openingHours: [
      '00:00-00:00 14:00-19:00',
      '10:00-19:00 00:00-00:00',
      '10:00-19:00 00:00-00:00',
      '10:00-19:00 00:00-00:00',
      '10:00-19:00 00:00-00:00',
      '10:00-19:00 00:00-00:00',
      '00:00-00:00 00:00-00:00'
    ]
  },
  {
    id: '485741',
    latitude: '45.775656',
    longitude: '3.086620',
    title: 'TABAC PRESSE DES BEAUX ARTS',
    address: {
      id: '485741',
      default: 0,
      label: '',
      title: 'TABAC PRESSE DES BEAUX ARTS',
      firstName: '',
      lastName: '',
      cellphoneNumber: '',
      phoneNumber: '',
      company: '',
      address1: '12 RUE BALLAINVILLIERS',
      address2: '',
      address3: '',
      zipCode: '63000',
      city: 'CLERMONT FERRAND',
      countryCode: 'FR',
      additionalData: []
    },
    moduleId: 46,
    moduleOptionCode: null,
    openingHours: [
      '06:30-20:00 00:00-00:00',
      '06:30-20:00 00:00-00:00',
      '06:30-20:00 00:00-00:00',
      '06:30-21:00 00:00-00:00',
      '06:30-21:00 00:00-00:00',
      '06:30-21:00 00:00-00:00',
      '09:00-12:30 15:00-20:30'
    ]
  },
  {
    id: '631130',
    latitude: '45.775193',
    longitude: '3.085848',
    title: 'BUREAU DE POSTE CLERMONT FERRAND SAINT ELOI',
    address: {
      id: '631130',
      default: 0,
      label: '',
      title: 'BUREAU DE POSTE CLERMONT FERRAND SAINT ELOI',
      firstName: '',
      lastName: '',
      cellphoneNumber: '',
      phoneNumber: '',
      company: '',
      address1: '1 RUE MAURICE BUSSET',
      address2: '',
      address3: '',
      zipCode: '63000',
      city: 'CLERMONT FERRAND',
      countryCode: 'FR',
      additionalData: []
    },
    moduleId: 46,
    moduleOptionCode: null,
    openingHours: [
      '10:00-18:00 00:00-00:00',
      '10:00-18:00 00:00-00:00',
      '10:00-18:00 00:00-00:00',
      '10:00-18:00 00:00-00:00',
      '10:00-18:00 00:00-00:00',
      '09:00-12:00 00:00-00:00',
      '00:00-00:00 00:00-00:00'
    ]
  },
  {
    id: '101582',
    latitude: '45.780244',
    longitude: '3.089174',
    title: 'OPTIQUE DUMAS',
    address: {
      id: '101582',
      default: 0,
      label: '',
      title: 'OPTIQUE DUMAS',
      firstName: '',
      lastName: '',
      cellphoneNumber: '',
      phoneNumber: '',
      company: '',
      address1: '38 RUE DU PORT',
      address2: '',
      address3: '',
      zipCode: '63000',
      city: 'CLERMONT-FERRAND',
      countryCode: 'FR',
      additionalData: []
    },
    moduleId: 46,
    moduleOptionCode: null,
    openingHours: [
      '00:00-00:00 00:00-00:00',
      '09:30-13:00 13:30-19:00',
      '09:30-13:00 13:30-19:00',
      '09:30-13:00 13:30-19:00',
      '09:30-13:00 13:30-19:00',
      '09:30-13:00 13:30-18:00',
      '00:00-00:00 00:00-00:00'
    ]
  },
  {
    id: '107661',
    latitude: '45.782938',
    longitude: '3.074946',
    title: 'L APPART FITNESS',
    address: {
      id: '107661',
      default: 0,
      label: '',
      title: 'L APPART FITNESS',
      firstName: '',
      lastName: '',
      cellphoneNumber: '',
      phoneNumber: '',
      company: '',
      address1: '52 RUE DU CLOS NOTRE DAME',
      address2: '',
      address3: '',
      zipCode: '63000',
      city: 'CLERMONT FERRAND',
      countryCode: 'FR',
      additionalData: []
    },
    moduleId: 46,
    moduleOptionCode: null,
    openingHours: [
      '09:00-13:30 17:30-20:00',
      '09:00-13:30 17:30-20:00',
      '09:00-13:30 17:30-20:00',
      '09:00-13:30 17:30-20:00',
      '09:00-13:30 17:30-20:00',
      '09:00-12:00 00:00-00:00',
      '00:00-00:00 00:00-00:00'
    ]
  },
  {
    id: '485269',
    latitude: '45.773441',
    longitude: '3.074998',
    title: 'LE CELTIQUE CAFE',
    address: {
      id: '485269',
      default: 0,
      label: '',
      title: 'LE CELTIQUE CAFE',
      firstName: '',
      lastName: '',
      cellphoneNumber: '',
      phoneNumber: '',
      company: '',
      address1: '50 AVENUE PASTEUR',
      address2: '',
      address3: '',
      zipCode: '63400',
      city: 'CHAMALIERES',
      countryCode: 'FR',
      additionalData: []
    },
    moduleId: 46,
    moduleOptionCode: null,
    openingHours: [
      '08:30-12:00 14:00-19:00',
      '08:30-12:00 14:00-19:00',
      '08:30-12:00 14:00-19:00',
      '08:30-12:00 14:00-19:00',
      '08:30-12:00 14:00-19:00',
      '00:00-00:00 00:00-00:00',
      '00:00-00:00 00:00-00:00'
    ]
  },
  {
    id: '488439',
    latitude: '45.782569',
    longitude: '3.093214',
    title: 'TABAC DES CARMES DECHAUX',
    address: {
      id: '488439',
      default: 0,
      label: '',
      title: 'TABAC DES CARMES DECHAUX',
      firstName: '',
      lastName: '',
      cellphoneNumber: '',
      phoneNumber: '',
      company: '',
      address1: '4 PLACE DES CARMES DECHAUX',
      address2: '',
      address3: '',
      zipCode: '63000',
      city: 'CLERMONT FERRAND',
      countryCode: 'FR',
      additionalData: []
    },
    moduleId: 46,
    moduleOptionCode: null,
    openingHours: [
      '07:30-14:00 15:30-19:30',
      '07:30-14:00 15:30-19:30',
      '07:30-14:00 15:30-19:30',
      '07:30-14:00 15:30-19:30',
      '07:30-14:00 15:30-19:30',
      '00:00-00:00 00:00-00:00',
      '00:00-00:00 00:00-00:00'
    ]
  },
  {
    id: '904858',
    latitude: '45.778118',
    longitude: '3.094363',
    title: 'MLEZI',
    address: {
      id: '904858',
      default: 0,
      label: '',
      title: 'MLEZI',
      firstName: '',
      lastName: '',
      cellphoneNumber: '',
      phoneNumber: '',
      company: '',
      address1: '31 AVENUE DE GRANDE BRETAGNE',
      address2: '',
      address3: '',
      zipCode: '63000',
      city: 'CLERMONT FERRAND',
      countryCode: 'FR',
      additionalData: []
    },
    moduleId: 46,
    moduleOptionCode: null,
    openingHours: [
      '00:00-00:00 00:00-00:00',
      '10:00-20:00 00:00-00:00',
      '10:00-20:00 00:00-00:00',
      '00:00-00:00 14:00-20:00',
      '10:00-20:00 00:00-00:00',
      '10:00-20:00 00:00-00:00',
      '00:00-00:00 14:00-20:00'
    ]
  },
  {
    id: '908340',
    latitude: '45.781741',
    longitude: '3.095727',
    title: 'N PROMOBILE',
    address: {
      id: '908340',
      default: 0,
      label: '',
      title: 'N PROMOBILE',
      firstName: '',
      lastName: '',
      cellphoneNumber: '',
      phoneNumber: '',
      company: '',
      address1: '7 AVENUE D ITALIE',
      address2: '',
      address3: '',
      zipCode: '63000',
      city: 'CLERMONT FERRAND',
      countryCode: 'FR',
      additionalData: []
    },
    moduleId: 46,
    moduleOptionCode: null,
    openingHours: [
      '09:00-12:00 14:00-19:00',
      '09:00-12:00 14:00-19:00',
      '09:00-12:00 14:00-19:00',
      '09:00-12:00 14:00-19:00',
      '09:00-12:00 14:00-19:00',
      '09:00-12:00 14:00-19:00',
      '00:00-00:00 00:00-00:00'
    ]
  },
  {
    id: '102071',
    latitude: '45.769098',
    longitude: '3.077152',
    title: 'MARCHE AUX FLEURS',
    address: {
      id: '102071',
      default: 0,
      label: '',
      title: 'MARCHE AUX FLEURS',
      firstName: '',
      lastName: '',
      cellphoneNumber: '',
      phoneNumber: '',
      company: '',
      address1: '84 BOULEVARD ARISTIDE BRIAND',
      address2: '',
      address3: '',
      zipCode: '63000',
      city: 'CLERMONT-FERRAND',
      countryCode: 'FR',
      additionalData: []
    },
    moduleId: 46,
    moduleOptionCode: null,
    openingHours: [
      '09:00-20:00 00:00-00:00',
      '09:00-20:00 00:00-00:00',
      '09:00-20:00 00:00-00:00',
      '09:00-20:00 00:00-00:00',
      '09:00-20:00 00:00-00:00',
      '09:00-20:00 00:00-00:00',
      '08:30-19:00 00:00-00:00'
    ]
  },
  {
    id: '906749',
    latitude: '45.776769',
    longitude: '3.066206',
    title: 'NC2L INFORMATIQUE',
    address: {
      id: '906749',
      default: 0,
      label: '',
      title: 'NC2L INFORMATIQUE',
      firstName: '',
      lastName: '',
      cellphoneNumber: '',
      phoneNumber: '',
      company: '',
      address1: '7 RUE DES SAULEES',
      address2: '',
      address3: '',
      zipCode: '63400',
      city: 'CHAMALIERES',
      countryCode: 'FR',
      additionalData: []
    },
    moduleId: 46,
    moduleOptionCode: null,
    openingHours: [
      '00:00-00:00 14:00-18:00',
      '09:30-12:30 14:00-18:00',
      '09:30-12:30 14:00-18:00',
      '09:30-12:30 14:00-18:00',
      '09:30-12:30 14:00-18:00',
      '10:00-12:00 00:00-00:00',
      '00:00-00:00 00:00-00:00'
    ]
  },
  {
    id: '639250',
    latitude: '45.767896',
    longitude: '3.079051',
    title: 'BUREAU DE POSTE CLERMONT FERRAND VALLIERES BP',
    address: {
      id: '639250',
      default: 0,
      label: '',
      title: 'BUREAU DE POSTE CLERMONT FERRAND VALLIERES BP',
      firstName: '',
      lastName: '',
      cellphoneNumber: '',
      phoneNumber: '',
      company: '',
      address1: '6 PLACE LITTRE',
      address2: '',
      address3: '',
      zipCode: '63000',
      city: 'CLERMONT FERRAND',
      countryCode: 'FR',
      additionalData: []
    },
    moduleId: 46,
    moduleOptionCode: null,
    openingHours: [
      '00:00-00:00 00:00-00:00',
      '10:00-12:00 14:00-18:00',
      '10:00-12:00 14:00-17:30',
      '10:00-12:00 14:00-17:30',
      '10:00-12:00 14:00-17:30',
      '09:00-12:00 00:00-00:00',
      '00:00-00:00 00:00-00:00'
    ]
  },
  {
    id: '902465',
    latitude: '45.767537',
    longitude: '3.082979',
    title: 'BAR DES BOULEVARDS',
    address: {
      id: '902465',
      default: 0,
      label: '',
      title: 'BAR DES BOULEVARDS',
      firstName: '',
      lastName: '',
      cellphoneNumber: '',
      phoneNumber: '',
      company: '',
      address1: '26 AVENUE DE LA LIBERATION',
      address2: '',
      address3: '',
      zipCode: '63000',
      city: 'CLERMONT FERRAND',
      countryCode: 'FR',
      additionalData: []
    },
    moduleId: 46,
    moduleOptionCode: null,
    openingHours: [
      '08:00-11:30 13:30-19:00',
      '08:00-11:30 13:30-19:00',
      '08:00-11:30 13:30-19:00',
      '08:00-11:30 13:30-19:00',
      '08:00-11:30 13:30-19:00',
      '08:00-12:00 00:00-00:00',
      '00:00-00:00 00:00-00:00'
    ]
  }
];
