SET FOREIGN_KEY_CHECKS = 0;

UPDATE `config` SET `value`='2.3.0-alpha1' WHERE `name`='thelia_version';
UPDATE `config` SET `value`='2' WHERE `name`='thelia_major_version';
UPDATE `config` SET `value`='3' WHERE `name`='thelia_minus_version';
UPDATE `config` SET `value`='0' WHERE `name`='thelia_release_version';
UPDATE `config` SET `value`='alpha1' WHERE `name`='thelia_extra_version';

-- Add new column in module_hook table
ALTER TABLE `module_hook` ADD `templates` TEXT AFTER`position`;

-- Add new columns in currency table
ALTER TABLE `currency` ADD  `format` CHAR( 10 ) NOT NULL AFTER  `symbol`;
ALTER TABLE `currency` ADD  `visible` TINYINT( 1 ) NOT NULL DEFAULT '0' AFTER  `rate`;

-- Update currencies
UPDATE `currency` SET `visible` = 1 WHERE 1;
UPDATE `currency` SET `format` = '%n %s' WHERE `code` NOT IN ('USD', 'GBP');
UPDATE `currency` SET `format` = '%s%n' WHERE `code` IN ('USD', 'GBP');

-- Additional hooks

SELECT @max_id := IFNULL(MAX(`id`),0) FROM `hook`;

INSERT INTO `hook` (`id`, `code`, `type`, `by_module`, `block`, `native`, `activate`, `position`, `created_at`, `updated_at`) VALUES
(@max_id+1,  'brand.modification.form-right.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+2,  'brand.modification.form-right.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+3,  'category.modification.form-right.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+4,  'category.modification.form-right.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+5,  'content.modification.form-right.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+6,  'content.modification.form-right.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+7,  'folder.modification.form-right.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+8,  'folder.modification.form-right.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+9,  'product.modification.form-right.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+10, 'product.modification.form-right.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW())
;

INSERT INTO  `hook_i18n` (`id`, `locale`, `title`, `description`, `chapo`) VALUES
{foreach $locales as $locale}
(@max_id+1,  '{$locale}', {intl l='Brand edit - right column top' locale=$locale}, NULL, NULL),
(@max_id+2,  '{$locale}', {intl l='Brand edit - right column bottom' locale=$locale}, NULL, NULL),
(@max_id+3,  '{$locale}', {intl l='Category edit - right column top' locale=$locale}, NULL, NULL),
(@max_id+4,  '{$locale}', {intl l='Category edit - right column bottom' locale=$locale}, NULL, NULL),
(@max_id+5,  '{$locale}', {intl l='Content edit - right column top' locale=$locale}, NULL, NULL),
(@max_id+6,  '{$locale}', {intl l='Content edit - right column bottom' locale=$locale}, NULL, NULL),
(@max_id+7,  '{$locale}', {intl l='Folder edit - right column top' locale=$locale}, NULL, NULL),
(@max_id+8,  '{$locale}', {intl l='Folder edit - right column bottom' locale=$locale}, NULL, NULL),
(@max_id+9,  '{$locale}', {intl l='Product edit - right column top' locale=$locale}, NULL, NULL),
(@max_id+10, '{$locale}', {intl l='Product edit - right column bottom' locale=$locale}, NULL, NULL){if ! $locale@last},{/if}

{/foreach}
;

/* States */
SELECT @max_id := IFNULL(MAX(`id`),0) FROM `hook`;

INSERT INTO `hook` (`id`, `code`, `type`, `by_module`, `block`, `native`, `activate`, `position`, `created_at`, `updated_at`) VALUES
(@max_id + 1, 'state-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 2, 'state-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 3, 'state.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 4, 'states.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 5, 'states.table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 6, 'states.table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 7, 'states.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 8, 'state.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 9, 'state.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 10, 'states.js', 2, 0, 0, 1, 1, 1, NOW(), NOW())
;

INSERT INTO  `hook_i18n` (`id`, `locale`, `title`, `description`, `chapo`) VALUES
{foreach $locales as $locale}
(@max_id + 1, '{$locale}', {intl l='state-edit - at the top' locale=$locale}, '', ''),
(@max_id + 2, '{$locale}', {intl l='state-edit - bottom' locale=$locale}, '', ''),
(@max_id + 3, '{$locale}', {intl l='state - Edit JavaScript' locale=$locale}, '', ''),
(@max_id + 4, '{$locale}', {intl l='states - at the top' locale=$locale}, '', ''),
(@max_id + 5, '{$locale}', {intl l='states - table header' locale=$locale}, '',    ''),
(@max_id + 6, '{$locale}', {intl l='states - table row' locale=$locale}, '', ''),
(@max_id + 7, '{$locale}', {intl l='states - bottom' locale=$locale}, '', ''),
(@max_id + 8, '{$locale}', {intl l='state - creation form' locale=$locale}, '',  ''),
(@max_id + 9, '{$locale}', {intl l='state - delete form' locale=$locale}, '', ''),
(@max_id + 10, '{$locale}', {intl l='states - JavaScript' locale=$locale}, '', ''){if ! $locale@last},{/if}

{/foreach}
;

SELECT @max_id := IFNULL(MAX(`id`),0) FROM `hook`;

INSERT INTO `hook` (`id`, `code`, `type`, `by_module`, `block`, `native`, `activate`, `position`, `created_at`, `updated_at`) VALUES
(@max_id+1, 'email-html.template.css', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+2, 'email-html.layout.footer', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+3, 'email-html.order-confirmation.before-address', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+4, 'email-html.order-confirmation.delivery-address', 4, 1, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+5, 'email-html.order-confirmation.after-address', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+6, 'email-html.order-confirmation.order-product', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+7, 'email-html.order-confirmation.before-products', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+8, 'email-html.order-confirmation.after-products', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+9, 'email-html.order-confirmation.footer', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+10, 'email-html.order-notification.before-address', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+11, 'email-html.order-notification.delivery-address', 4, 1, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+12, 'email-html.order-notification.after-address', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+13, 'email-html.order-notification.order-product', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+14, 'email-html.order-notification.before-products', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+15, 'email-html.order-notification.after-products', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+16, 'email-txt.order-confirmation.before-address', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+17, 'email-txt.order-confirmation.delivery-address', 4, 1, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+18, 'email-txt.order-confirmation.after-address', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+19, 'email-txt.order-confirmation.order-product', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+20, 'email-txt.order-confirmation.before-products', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+21, 'email-txt.order-confirmation.after-products', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+22, 'email-txt.order-notification.before-address', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+23, 'email-txt.order-notification.delivery-address', 4, 1, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+24, 'email-txt.order-notification.after-address', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+25, 'email-txt.order-notification.order-product', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+26, 'email-txt.order-notification.before-products', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+27, 'email-txt.order-notification.after-products', 4, 0, 0, 1, 1, 1, NOW(), NOW())
;

INSERT INTO  `hook_i18n` (`id`, `locale`, `title`, `description`, `chapo`) VALUES
{foreach $locales as $locale}
    (@max_id+1, '{$locale}', {intl l='Email html - layout - CSS' locale=$locale}, NULL, NULL),
    (@max_id+2, '{$locale}', {intl l='Email html - layout - footer' locale=$locale}, NULL, NULL),
    (@max_id+3, '{$locale}', {intl l='Email html - order confirmation - before address' locale=$locale}, NULL, NULL),
    (@max_id+4, '{$locale}', {intl l='Email html - order confirmation - delivery address' locale=$locale}, NULL, NULL),
    (@max_id+5, '{$locale}', {intl l='Email html - order confirmation - after address' locale=$locale}, NULL, NULL),
    (@max_id+6, '{$locale}', {intl l='Email html - order confirmation - order product' locale=$locale}, NULL, NULL),
    (@max_id+7, '{$locale}', {intl l='Email html - order confirmation - before products' locale=$locale}, NULL, NULL),
    (@max_id+8, '{$locale}', {intl l='Email html - order confirmation - after products' locale=$locale}, NULL, NULL),
    (@max_id+9, '{$locale}', {intl l='Email html - order confirmation - footer' locale=$locale}, NULL, NULL),
    (@max_id+10, '{$locale}', {intl l='Email html - order notification - before address' locale=$locale}, NULL, NULL),
    (@max_id+11, '{$locale}', {intl l='Email html - order notification - delivery address' locale=$locale}, NULL, NULL),
    (@max_id+12, '{$locale}', {intl l='Email html - order notification - after address' locale=$locale}, NULL, NULL),
    (@max_id+13, '{$locale}', {intl l='Email html - order notification - order product' locale=$locale}, NULL, NULL),
    (@max_id+14, '{$locale}', {intl l='Email html - order notification - before products' locale=$locale}, NULL, NULL),
    (@max_id+15, '{$locale}', {intl l='Email html - order notification - after products' locale=$locale}, NULL, NULL),
    (@max_id+16, '{$locale}', {intl l='Email txt - order confirmation - before address' locale=$locale}, NULL, NULL),
    (@max_id+17, '{$locale}', {intl l='Email txt - order confirmation - delivery address' locale=$locale}, NULL, NULL),
    (@max_id+18, '{$locale}', {intl l='Email txt - order confirmation - after address' locale=$locale}, NULL, NULL),
    (@max_id+19, '{$locale}', {intl l='Email txt - order confirmation - order product' locale=$locale}, NULL, NULL),
    (@max_id+20, '{$locale}', {intl l='Email txt - order confirmation - before products' locale=$locale}, NULL, NULL),
    (@max_id+21, '{$locale}', {intl l='Email txt - order confirmation - after products' locale=$locale}, NULL, NULL),
    (@max_id+22, '{$locale}', {intl l='Email txt - order notification - before address' locale=$locale}, NULL, NULL),
    (@max_id+23, '{$locale}', {intl l='Email txt - order notification - delivery address' locale=$locale}, NULL, NULL),
    (@max_id+24, '{$locale}', {intl l='Email txt - order notification - after address' locale=$locale}, NULL, NULL),
    (@max_id+25, '{$locale}', {intl l='Email txt - order notification - order product' locale=$locale}, NULL, NULL),
    (@max_id+26, '{$locale}', {intl l='Email txt - order notification - before products' locale=$locale}, NULL, NULL),
    (@max_id+27, '{$locale}', {intl l='Email txt - order notification - after products' locale=$locale}, NULL, NULL){if ! $locale@last},{/if}

{/foreach}
;

/* countries and states */

ALTER TABLE `country`
    ADD COLUMN `visible` TINYINT DEFAULT 0 NOT NULL AFTER  `id`,
    ADD COLUMN `has_states` TINYINT DEFAULT 0 AFTER `isoalpha3`,
    ADD COLUMN `need_zip_code` TINYINT DEFAULT 0 AFTER  `has_states`,
    ADD COLUMN `zip_code_format` VARCHAR(20) AFTER `need_zip_code`;

CREATE TABLE `state`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `visible` TINYINT DEFAULT 0 NOT NULL,
    `isocode` VARCHAR(4) NOT NULL,
    `country_id` INTEGER NOT NULL,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`),
    INDEX `FI_state_country_id` (`country_id`),
    CONSTRAINT `fk_state_country_id`
        FOREIGN KEY (`country_id`)
        REFERENCES `country` (`id`)
        ON UPDATE RESTRICT
        ON DELETE CASCADE
) ENGINE=InnoDB CHARACTER SET='utf8';

CREATE TABLE `state_i18n`
(
    `id` INTEGER NOT NULL,
    `locale` VARCHAR(5) DEFAULT 'en_US' NOT NULL,
    `title` VARCHAR(255),
    PRIMARY KEY (`id`,`locale`),
    CONSTRAINT `state_i18n_FK_1`
        FOREIGN KEY (`id`)
        REFERENCES `state` (`id`)
        ON DELETE CASCADE
) ENGINE=InnoDB CHARACTER SET='utf8';

ALTER TABLE `address`
    ADD COLUMN `state_id` INTEGER AFTER `country_id`,
    ADD CONSTRAINT `fk_address_state_id`
        FOREIGN KEY (`state_id`)
        REFERENCES `state` (`id`)
        ON UPDATE RESTRICT
        ON DELETE RESTRICT,
    ADD INDEX `FI_address_state_id` (`state_id`);

ALTER TABLE `order_address`
    ADD COLUMN `state_id` INTEGER AFTER `country_id`,
    ADD CONSTRAINT `fk_order_address_state_id`
        FOREIGN KEY (`state_id`)
        REFERENCES `state` (`id`)
        ON UPDATE RESTRICT
        ON DELETE RESTRICT,
    ADD INDEX `FI_order_address_state_id` (`state_id`);

ALTER TABLE `tax_rule_country`
    DROP PRIMARY KEY,
    ADD COLUMN `id` INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST,
    ADD COLUMN `state_id` INTEGER AFTER `country_id`,
    ADD CONSTRAINT `fk_tax_rule_country_state_id`
        FOREIGN KEY (`state_id`)
        REFERENCES `state` (`id`)
        ON UPDATE RESTRICT
        ON DELETE CASCADE,
    ADD INDEX `idx_tax_rule_country_state_id` (`state_id`);

ALTER TABLE `country_area`
    ADD COLUMN `id` INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST,
    ADD COLUMN `state_id` INTEGER AFTER `country_id`,
    ADD INDEX `fk_country_area_state_id_idx` (`state_id`);

/*
we create new countries (not visible) and link them to states
the migration will be done with the module migrateCountryState
*/

UPDATE `country` SET `visible` = 1 WHERE 1;

SELECT @max_id := IFNULL(MAX(`id`),0) FROM `country`;

INSERT INTO `country` (`visible`, `isocode`, `isoalpha2`, `isoalpha3`, `by_default`, `shop_country`, `has_states`, `need_zip_code`, `zip_code_format`, `created_at`, `updated_at`) VALUES
(0, '840', 'US', 'USA', 0, 0, '1', '1', 'NNNNN', NOW(), NOW()),
(0, '124', 'CA', 'CAN', 0, 0, '1', '1', 'LNL NLN', NOW(), NOW()),
(0, '32', 'AR', 'ARG', 0, 0, '1', '1', 'LNNNN', NOW(), NOW()),
(0, '360', 'ID', 'IDN', 0, 0, '1', '1', 'NNNNN', NOW(), NOW()),
(0, '380', 'IT', 'ITA', 0, 0, '1', '1', 'NNNNN', NOW(), NOW()),
(0, '392', 'JP', 'JPN', 0, 0, '1', '1', 'NNN-NNNN', NOW(), NOW()),
(0, '484', 'MX', 'MEX', 0, 0, '1', '1', 'NNNNN', NOW(), NOW())
;

INSERT INTO `country_i18n` (`id`, `locale`, `title`, `chapo`, `description`, `postscriptum`) VALUES
{foreach $locales as $locale}
    (@max_id + 1, '{$locale}', {intl l='USA' locale=$locale}, NULL, NULL, NULL),
    (@max_id + 2, '{$locale}', {intl l='Canada' locale=$locale}, NULL, NULL, NULL),
    (@max_id + 3, '{$locale}', {intl l='Argentina' locale=$locale}, NULL, NULL, NULL),
    (@max_id + 4, '{$locale}', {intl l='Indonesia' locale=$locale}, NULL, NULL, NULL),
    (@max_id + 5, '{$locale}', {intl l='Italy' locale=$locale}, NULL, NULL, NULL),
    (@max_id + 6, '{$locale}', {intl l='Japan' locale=$locale}, NULL, NULL, NULL),
    (@max_id + 7, '{$locale}', {intl l='Mexico' locale=$locale}, NULL, NULL, NULL){if ! $locale@last},{/if}

{/foreach}
;

INSERT INTO `state` (`id`, `visible`, `isocode`, `country_id`, `created_at`, `updated_at`) VALUES
(1, 1, 'AL', @max_id + 1, NOW(), NOW()),
(2, 1, 'AK', @max_id + 1, NOW(), NOW()),
(3, 1, 'AZ', @max_id + 1, NOW(), NOW()),
(4, 1, 'AR', @max_id + 1, NOW(), NOW()),
(5, 1, 'CA', @max_id + 1, NOW(), NOW()),
(6, 1, 'CO', @max_id + 1, NOW(), NOW()),
(7, 1, 'CT', @max_id + 1, NOW(), NOW()),
(8, 1, 'DE', @max_id + 1, NOW(), NOW()),
(9, 1, 'FL', @max_id + 1, NOW(), NOW()),
(10, 1, 'GA', @max_id + 1, NOW(), NOW()),
(11, 1, 'HI', @max_id + 1, NOW(), NOW()),
(12, 1, 'ID', @max_id + 1, NOW(), NOW()),
(13, 1, 'IL', @max_id + 1, NOW(), NOW()),
(14, 1, 'IN', @max_id + 1, NOW(), NOW()),
(15, 1, 'IA', @max_id + 1, NOW(), NOW()),
(16, 1, 'KS', @max_id + 1, NOW(), NOW()),
(17, 1, 'KY', @max_id + 1, NOW(), NOW()),
(18, 1, 'LA', @max_id + 1, NOW(), NOW()),
(19, 1, 'ME', @max_id + 1, NOW(), NOW()),
(20, 1, 'MD', @max_id + 1, NOW(), NOW()),
(21, 1, 'MA', @max_id + 1, NOW(), NOW()),
(22, 1, 'MI', @max_id + 1, NOW(), NOW()),
(23, 1, 'MN', @max_id + 1, NOW(), NOW()),
(24, 1, 'MS', @max_id + 1, NOW(), NOW()),
(25, 1, 'MO', @max_id + 1, NOW(), NOW()),
(26, 1, 'MT', @max_id + 1, NOW(), NOW()),
(27, 1, 'NE', @max_id + 1, NOW(), NOW()),
(28, 1, 'NV', @max_id + 1, NOW(), NOW()),
(29, 1, 'NH', @max_id + 1, NOW(), NOW()),
(30, 1, 'NJ', @max_id + 1, NOW(), NOW()),
(31, 1, 'NM', @max_id + 1, NOW(), NOW()),
(32, 1, 'NY', @max_id + 1, NOW(), NOW()),
(33, 1, 'NC', @max_id + 1, NOW(), NOW()),
(34, 1, 'ND', @max_id + 1, NOW(), NOW()),
(35, 1, 'OH', @max_id + 1, NOW(), NOW()),
(36, 1, 'OK', @max_id + 1, NOW(), NOW()),
(37, 1, 'OR', @max_id + 1, NOW(), NOW()),
(38, 1, 'PA', @max_id + 1, NOW(), NOW()),
(39, 1, 'RI', @max_id + 1, NOW(), NOW()),
(40, 1, 'SC', @max_id + 1, NOW(), NOW()),
(41, 1, 'SD', @max_id + 1, NOW(), NOW()),
(42, 1, 'TN', @max_id + 1, NOW(), NOW()),
(43, 1, 'TX', @max_id + 1, NOW(), NOW()),
(44, 1, 'UT', @max_id + 1, NOW(), NOW()),
(45, 1, 'VT', @max_id + 1, NOW(), NOW()),
(46, 1, 'VA', @max_id + 1, NOW(), NOW()),
(47, 1, 'WA', @max_id + 1, NOW(), NOW()),
(48, 1, 'WV', @max_id + 1, NOW(), NOW()),
(49, 1, 'WI', @max_id + 1, NOW(), NOW()),
(50, 1, 'WY', @max_id + 1, NOW(), NOW()),
(51, 1, 'PR', @max_id + 1, NOW(), NOW()),
(52, 1, 'VI', @max_id + 1, NOW(), NOW()),
(53, 1, 'DC', @max_id + 1, NOW(), NOW()),
(54, 1, 'AGS', @max_id + 7, NOW(), NOW()),
(55, 1, 'BCN', @max_id + 7, NOW(), NOW()),
(56, 1, 'BCS', @max_id + 7, NOW(), NOW()),
(57, 1, 'CAM', @max_id + 7, NOW(), NOW()),
(58, 1, 'CHP', @max_id + 7, NOW(), NOW()),
(59, 1, 'CHH', @max_id + 7, NOW(), NOW()),
(60, 1, 'COA', @max_id + 7, NOW(), NOW()),
(61, 1, 'COL', @max_id + 7, NOW(), NOW()),
(62, 1, 'DIF', @max_id + 7, NOW(), NOW()),
(63, 1, 'DUR', @max_id + 7, NOW(), NOW()),
(64, 1, 'GUA', @max_id + 7, NOW(), NOW()),
(65, 1, 'GRO', @max_id + 7, NOW(), NOW()),
(66, 1, 'HID', @max_id + 7, NOW(), NOW()),
(67, 1, 'JAL', @max_id + 7, NOW(), NOW()),
(68, 1, 'MEX', @max_id + 7, NOW(), NOW()),
(69, 1, 'MIC', @max_id + 7, NOW(), NOW()),
(70, 1, 'MOR', @max_id + 7, NOW(), NOW()),
(71, 1, 'NAY', @max_id + 7, NOW(), NOW()),
(72, 1, 'NLE', @max_id + 7, NOW(), NOW()),
(73, 1, 'OAX', @max_id + 7, NOW(), NOW()),
(74, 1, 'PUE', @max_id + 7, NOW(), NOW()),
(75, 1, 'QUE', @max_id + 7, NOW(), NOW()),
(76, 1, 'ROO', @max_id + 7, NOW(), NOW()),
(77, 1, 'SLP', @max_id + 7, NOW(), NOW()),
(78, 1, 'SIN', @max_id + 7, NOW(), NOW()),
(79, 1, 'SON', @max_id + 7, NOW(), NOW()),
(80, 1, 'TAB', @max_id + 7, NOW(), NOW()),
(81, 1, 'TAM', @max_id + 7, NOW(), NOW()),
(82, 1, 'TLA', @max_id + 7, NOW(), NOW()),
(83, 1, 'VER', @max_id + 7, NOW(), NOW()),
(84, 1, 'YUC', @max_id + 7, NOW(), NOW()),
(85, 1, 'ZAC', @max_id + 7, NOW(), NOW()),
(86, 1, 'ON', @max_id + 2, NOW(), NOW()),
(87, 1, 'QC', @max_id + 2, NOW(), NOW()),
(88, 1, 'BC', @max_id + 2, NOW(), NOW()),
(89, 1, 'AB', @max_id + 2, NOW(), NOW()),
(90, 1, 'MB', @max_id + 2, NOW(), NOW()),
(91, 1, 'SK', @max_id + 2, NOW(), NOW()),
(92, 1, 'NS', @max_id + 2, NOW(), NOW()),
(93, 1, 'NB', @max_id + 2, NOW(), NOW()),
(94, 1, 'NL', @max_id + 2, NOW(), NOW()),
(95, 1, 'PE', @max_id + 2, NOW(), NOW()),
(96, 1, 'NT', @max_id + 2, NOW(), NOW()),
(97, 1, 'YT', @max_id + 2, NOW(), NOW()),
(98, 1, 'NU', @max_id + 2, NOW(), NOW()),
(99, 1, 'B',  @max_id + 3, NOW(), NOW()),
(100, 1, 'K',  @max_id + 3, NOW(), NOW()),
(101, 1, 'H',  @max_id + 3, NOW(), NOW()),
(102, 1, 'U',  @max_id + 3, NOW(), NOW()),
(103, 1, 'C',  @max_id + 3, NOW(), NOW()),
(104, 1, 'X',  @max_id + 3, NOW(), NOW()),
(105, 1, 'W',  @max_id + 3, NOW(), NOW()),
(106, 1, 'E',  @max_id + 3, NOW(), NOW()),
(107, 1, 'P',  @max_id + 3, NOW(), NOW()),
(108, 1, 'Y',  @max_id + 3, NOW(), NOW()),
(109, 1, 'L',  @max_id + 3, NOW(), NOW()),
(110, 1, 'F',  @max_id + 3, NOW(), NOW()),
(111, 1, 'M',  @max_id + 3, NOW(), NOW()),
(112, 1, 'N',  @max_id + 3, NOW(), NOW()),
(113, 1, 'Q',  @max_id + 3, NOW(), NOW()),
(114, 1, 'R',  @max_id + 3, NOW(), NOW()),
(115, 1, 'A',  @max_id + 3, NOW(), NOW()),
(116, 1, 'J',  @max_id + 3, NOW(), NOW()),
(117, 1, 'D',  @max_id + 3, NOW(), NOW()),
(118, 1, 'Z',  @max_id + 3, NOW(), NOW()),
(119, 1, 'S',  @max_id + 3, NOW(), NOW()),
(120, 1, 'G',  @max_id + 3, NOW(), NOW()),
(121, 1, 'V',  @max_id + 3, NOW(), NOW()),
(122, 1, 'T',  @max_id + 3, NOW(), NOW()),
(123, 1, 'AG', @max_id + 5, NOW(), NOW()),
(124, 1, 'AL', @max_id + 5, NOW(), NOW()),
(125, 1, 'AN', @max_id + 5, NOW(), NOW()),
(126, 1, 'AO', @max_id + 5, NOW(), NOW()),
(127, 1, 'AR', @max_id + 5, NOW(), NOW()),
(128, 1, 'AP', @max_id + 5, NOW(), NOW()),
(129, 1, 'AT', @max_id + 5, NOW(), NOW()),
(130, 1, 'AV', @max_id + 5, NOW(), NOW()),
(131, 1, 'BA', @max_id + 5, NOW(), NOW()),
(132, 1, 'BT', @max_id + 5, NOW(), NOW()),
(133, 1, 'BL', @max_id + 5, NOW(), NOW()),
(134, 1, 'BN', @max_id + 5, NOW(), NOW()),
(135, 1, 'BG', @max_id + 5, NOW(), NOW()),
(136, 1, 'BI', @max_id + 5, NOW(), NOW()),
(137, 1, 'BO', @max_id + 5, NOW(), NOW()),
(138, 1, 'BZ', @max_id + 5, NOW(), NOW()),
(139, 1, 'BS', @max_id + 5, NOW(), NOW()),
(140, 1, 'BR', @max_id + 5, NOW(), NOW()),
(141, 1, 'CA', @max_id + 5, NOW(), NOW()),
(142, 1, 'CL', @max_id + 5, NOW(), NOW()),
(143, 1, 'CB', @max_id + 5, NOW(), NOW()),
(144, 1, 'CI', @max_id + 5, NOW(), NOW()),
(145, 1, 'CE', @max_id + 5, NOW(), NOW()),
(146, 1, 'CT', @max_id + 5, NOW(), NOW()),
(147, 1, 'CZ', @max_id + 5, NOW(), NOW()),
(148, 1, 'CH', @max_id + 5, NOW(), NOW()),
(149, 1, 'CO', @max_id + 5, NOW(), NOW()),
(150, 1, 'CS', @max_id + 5, NOW(), NOW()),
(151, 1, 'CR', @max_id + 5, NOW(), NOW()),
(152, 1, 'KR', @max_id + 5, NOW(), NOW()),
(153, 1, 'CN', @max_id + 5, NOW(), NOW()),
(154, 1, 'EN', @max_id + 5, NOW(), NOW()),
(155, 1, 'FM', @max_id + 5, NOW(), NOW()),
(156, 1, 'FE', @max_id + 5, NOW(), NOW()),
(157, 1, 'FI', @max_id + 5, NOW(), NOW()),
(158, 1, 'FG', @max_id + 5, NOW(), NOW()),
(159, 1, 'FC', @max_id + 5, NOW(), NOW()),
(160, 1, 'FR', @max_id + 5, NOW(), NOW()),
(161, 1, 'GE', @max_id + 5, NOW(), NOW()),
(162, 1, 'GO', @max_id + 5, NOW(), NOW()),
(163, 1, 'GR', @max_id + 5, NOW(), NOW()),
(164, 1, 'IM', @max_id + 5, NOW(), NOW()),
(165, 1, 'IS', @max_id + 5, NOW(), NOW()),
(166, 1, 'AQ', @max_id + 5, NOW(), NOW()),
(167, 1, 'SP', @max_id + 5, NOW(), NOW()),
(168, 1, 'LT', @max_id + 5, NOW(), NOW()),
(169, 1, 'LE', @max_id + 5, NOW(), NOW()),
(170, 1, 'LC', @max_id + 5, NOW(), NOW()),
(171, 1, 'LI', @max_id + 5, NOW(), NOW()),
(172, 1, 'LO', @max_id + 5, NOW(), NOW()),
(173, 1, 'LU', @max_id + 5, NOW(), NOW()),
(174, 1, 'MC', @max_id + 5, NOW(), NOW()),
(175, 1, 'MN', @max_id + 5, NOW(), NOW()),
(176, 1, 'MS', @max_id + 5, NOW(), NOW()),
(177, 1, 'MT', @max_id + 5, NOW(), NOW()),
(178, 1, 'VS', @max_id + 5, NOW(), NOW()),
(179, 1, 'ME', @max_id + 5, NOW(), NOW()),
(180, 1, 'MI', @max_id + 5, NOW(), NOW()),
(181, 1, 'MO', @max_id + 5, NOW(), NOW()),
(182, 1, 'MB', @max_id + 5, NOW(), NOW()),
(183, 1, 'NA', @max_id + 5, NOW(), NOW()),
(184, 1, 'NO', @max_id + 5, NOW(), NOW()),
(185, 1, 'NU', @max_id + 5, NOW(), NOW()),
(186, 1, 'OG', @max_id + 5, NOW(), NOW()),
(187, 1, 'OT', @max_id + 5, NOW(), NOW()),
(188, 1, 'OR', @max_id + 5, NOW(), NOW()),
(189, 1, 'PD', @max_id + 5, NOW(), NOW()),
(190, 1, 'PA', @max_id + 5, NOW(), NOW()),
(191, 1, 'PR', @max_id + 5, NOW(), NOW()),
(192, 1, 'PV', @max_id + 5, NOW(), NOW()),
(193, 1, 'PG', @max_id + 5, NOW(), NOW()),
(194, 1, 'PU', @max_id + 5, NOW(), NOW()),
(195, 1, 'PE', @max_id + 5, NOW(), NOW()),
(196, 1, 'PC', @max_id + 5, NOW(), NOW()),
(197, 1, 'PI', @max_id + 5, NOW(), NOW()),
(198, 1, 'PT', @max_id + 5, NOW(), NOW()),
(199, 1, 'PN', @max_id + 5, NOW(), NOW()),
(200, 1, 'PZ', @max_id + 5, NOW(), NOW()),
(201, 1, 'PO', @max_id + 5, NOW(), NOW()),
(202, 1, 'RG', @max_id + 5, NOW(), NOW()),
(203, 1, 'RA', @max_id + 5, NOW(), NOW()),
(204, 1, 'RC', @max_id + 5, NOW(), NOW()),
(205, 1, 'RE', @max_id + 5, NOW(), NOW()),
(206, 1, 'RI', @max_id + 5, NOW(), NOW()),
(207, 1, 'RN', @max_id + 5, NOW(), NOW()),
(208, 1, 'RM', @max_id + 5, NOW(), NOW()),
(209, 1, 'RO', @max_id + 5, NOW(), NOW()),
(210, 1, 'SA', @max_id + 5, NOW(), NOW()),
(211, 1, 'SS', @max_id + 5, NOW(), NOW()),
(212, 1, 'SV', @max_id + 5, NOW(), NOW()),
(213, 1, 'SI', @max_id + 5, NOW(), NOW()),
(214, 1, 'SR', @max_id + 5, NOW(), NOW()),
(215, 1, 'SO', @max_id + 5, NOW(), NOW()),
(216, 1, 'TA', @max_id + 5, NOW(), NOW()),
(217, 1, 'TE', @max_id + 5, NOW(), NOW()),
(218, 1, 'TR', @max_id + 5, NOW(), NOW()),
(219, 1, 'TO', @max_id + 5, NOW(), NOW()),
(220, 1, 'TP', @max_id + 5, NOW(), NOW()),
(221, 1, 'TN', @max_id + 5, NOW(), NOW()),
(222, 1, 'TV', @max_id + 5, NOW(), NOW()),
(223, 1, 'TS', @max_id + 5, NOW(), NOW()),
(224, 1, 'UD', @max_id + 5, NOW(), NOW()),
(225, 1, 'VA', @max_id + 5, NOW(), NOW()),
(226, 1, 'VE', @max_id + 5, NOW(), NOW()),
(227, 1, 'VB', @max_id + 5, NOW(), NOW()),
(228, 1, 'VC', @max_id + 5, NOW(), NOW()),
(229, 1, 'VR', @max_id + 5, NOW(), NOW()),
(230, 1, 'VV', @max_id + 5, NOW(), NOW()),
(231, 1, 'VI', @max_id + 5, NOW(), NOW()),
(232, 1, 'VT', @max_id + 5, NOW(), NOW()),
(233, 1, 'AC', @max_id + 4, NOW(), NOW()),
(234, 1, 'BA', @max_id + 4, NOW(), NOW()),
(235, 1, 'BB', @max_id + 4, NOW(), NOW()),
(236, 1, 'BT', @max_id + 4, NOW(), NOW()),
(237, 1, 'BE', @max_id + 4, NOW(), NOW()),
(238, 1, 'JT', @max_id + 4, NOW(), NOW()),
(239, 1, 'KT', @max_id + 4, NOW(), NOW()),
(240, 1, 'ST', @max_id + 4, NOW(), NOW()),
(241, 1, 'JI', @max_id + 4, NOW(), NOW()),
(242, 1, 'KI', @max_id + 4, NOW(), NOW()),
(243, 1, 'NT', @max_id + 4, NOW(), NOW()),
(244, 1, 'GO', @max_id + 4, NOW(), NOW()),
(245, 1, 'JK', @max_id + 4, NOW(), NOW()),
(246, 1, 'JA', @max_id + 4, NOW(), NOW()),
(247, 1, 'LA', @max_id + 4, NOW(), NOW()),
(248, 1, 'MA', @max_id + 4, NOW(), NOW()),
(249, 1, 'MU', @max_id + 4, NOW(), NOW()),
(250, 1, 'SA', @max_id + 4, NOW(), NOW()),
(251, 1, 'SU', @max_id + 4, NOW(), NOW()),
(252, 1, 'PA', @max_id + 4, NOW(), NOW()),
(253, 1, 'RI', @max_id + 4, NOW(), NOW()),
(254, 1, 'KR', @max_id + 4, NOW(), NOW()),
(255, 1, 'SG', @max_id + 4, NOW(), NOW()),
(256, 1, 'KS', @max_id + 4, NOW(), NOW()),
(257, 1, 'SN', @max_id + 4, NOW(), NOW()),
(258, 1, 'SS', @max_id + 4, NOW(), NOW()),
(259, 1, 'JB', @max_id + 4, NOW(), NOW()),
(260, 1, 'KB', @max_id + 4, NOW(), NOW()),
(261, 1, 'NB', @max_id + 4, NOW(), NOW()),
(262, 1, 'PB', @max_id + 4, NOW(), NOW()),
(263, 1, 'SR', @max_id + 4, NOW(), NOW()),
(264, 1, 'SB', @max_id + 4, NOW(), NOW()),
(265, 1, 'YO', @max_id + 4, NOW(), NOW()),
(266, 1, '23', @max_id + 6, NOW(), NOW()),
(267, 1, '05', @max_id + 6, NOW(), NOW()),
(268, 1, '02', @max_id + 6, NOW(), NOW()),
(269, 1, '12', @max_id + 6, NOW(), NOW()),
(270, 1, '38', @max_id + 6, NOW(), NOW()),
(271, 1, '18', @max_id + 6, NOW(), NOW()),
(272, 1, '40', @max_id + 6, NOW(), NOW()),
(273, 1, '07', @max_id + 6, NOW(), NOW()),
(274, 1, '21', @max_id + 6, NOW(), NOW()),
(275, 1, '10', @max_id + 6, NOW(), NOW()),
(276, 1, '34', @max_id + 6, NOW(), NOW()),
(277, 1, '01', @max_id + 6, NOW(), NOW()),
(278, 1, '28', @max_id + 6, NOW(), NOW()),
(279, 1, '08', @max_id + 6, NOW(), NOW()),
(280, 1, '17', @max_id + 6, NOW(), NOW()),
(281, 1, '03', @max_id + 6, NOW(), NOW()),
(282, 1, '37', @max_id + 6, NOW(), NOW()),
(283, 1, '46', @max_id + 6, NOW(), NOW()),
(284, 1, '14', @max_id + 6, NOW(), NOW()),
(285, 1, '39', @max_id + 6, NOW(), NOW()),
(286, 1, '43', @max_id + 6, NOW(), NOW()),
(287, 1, '26', @max_id + 6, NOW(), NOW()),
(288, 1, '24', @max_id + 6, NOW(), NOW()),
(289, 1, '04', @max_id + 6, NOW(), NOW()),
(290, 1, '45', @max_id + 6, NOW(), NOW()),
(291, 1, '20', @max_id + 6, NOW(), NOW()),
(292, 1, '42', @max_id + 6, NOW(), NOW()),
(293, 1, '29', @max_id + 6, NOW(), NOW()),
(294, 1, '15', @max_id + 6, NOW(), NOW()),
(295, 1, '44', @max_id + 6, NOW(), NOW()),
(296, 1, '33', @max_id + 6, NOW(), NOW()),
(297, 1, '47', @max_id + 6, NOW(), NOW()),
(298, 1, '27', @max_id + 6, NOW(), NOW()),
(299, 1, '41', @max_id + 6, NOW(), NOW()),
(300, 1, '11', @max_id + 6, NOW(), NOW()),
(301, 1, '25', @max_id + 6, NOW(), NOW()),
(302, 1, '32', @max_id + 6, NOW(), NOW()),
(303, 1, '22', @max_id + 6, NOW(), NOW()),
(304, 1, '09', @max_id + 6, NOW(), NOW()),
(305, 1, '36', @max_id + 6, NOW(), NOW()),
(306, 1, '13', @max_id + 6, NOW(), NOW()),
(307, 1, '31', @max_id + 6, NOW(), NOW()),
(308, 1, '16', @max_id + 6, NOW(), NOW()),
(309, 1, '30', @max_id + 6, NOW(), NOW()),
(310, 1, '06', @max_id + 6, NOW(), NOW()),
(311, 1, '35', @max_id + 6, NOW(), NOW()),
(312, 1, '19', @max_id + 6, NOW(), NOW()),
(313, 1, '', @max_id + 3, NOW(), NOW()),
(314, 1, '', @max_id + 4, NOW(), NOW()),
(315, 1, '', @max_id + 5, NOW(), NOW()),
(316, 1, '', @max_id + 6, NOW(), NOW()),
(317, 1, '', @max_id + 7, NOW(), NOW());


INSERT INTO `state_i18n` (`id`, `locale`, `title`) VALUES
{foreach $locales as $locale}

    (1, '{$locale}', {intl l='Alabama' locale=$locale}),
    (2, '{$locale}', {intl l='Alaska' locale=$locale}),
    (3, '{$locale}', {intl l='Arizona' locale=$locale}),
    (4, '{$locale}', {intl l='Arkansas' locale=$locale}),
    (5, '{$locale}', {intl l='California' locale=$locale}),
    (6, '{$locale}', {intl l='Colorado' locale=$locale}),
    (7, '{$locale}', {intl l='Connecticut' locale=$locale}),
    (8, '{$locale}', {intl l='Delaware' locale=$locale}),
    (9, '{$locale}', {intl l='Florida' locale=$locale}),
    (10, '{$locale}', {intl l='Georgia' locale=$locale}),
    (11, '{$locale}', {intl l='Hawaii' locale=$locale}),
    (12, '{$locale}', {intl l='Idaho' locale=$locale}),
    (13, '{$locale}', {intl l='Illinois' locale=$locale}),
    (14, '{$locale}', {intl l='Indiana' locale=$locale}),
    (15, '{$locale}', {intl l='Iowa' locale=$locale}),
    (16, '{$locale}', {intl l='Kansas' locale=$locale}),
    (17, '{$locale}', {intl l='Kentucky' locale=$locale}),
    (18, '{$locale}', {intl l='Louisiana' locale=$locale}),
    (19, '{$locale}', {intl l='Maine' locale=$locale}),
    (20, '{$locale}', {intl l='Maryland' locale=$locale}),
    (21, '{$locale}', {intl l='Massachusetts' locale=$locale}),
    (22, '{$locale}', {intl l='Michigan' locale=$locale}),
    (23, '{$locale}', {intl l='Minnesota' locale=$locale}),
    (24, '{$locale}', {intl l='Mississippi' locale=$locale}),
    (25, '{$locale}', {intl l='Missouri' locale=$locale}),
    (26, '{$locale}', {intl l='Montana' locale=$locale}),
    (27, '{$locale}', {intl l='Nebraska' locale=$locale}),
    (28, '{$locale}', {intl l='Nevada' locale=$locale}),
    (29, '{$locale}', {intl l='New Hampshire' locale=$locale}),
    (30, '{$locale}', {intl l='New Jersey' locale=$locale}),
    (31, '{$locale}', {intl l='New Mexico' locale=$locale}),
    (32, '{$locale}', {intl l='New York' locale=$locale}),
    (33, '{$locale}', {intl l='North Carolina' locale=$locale}),
    (34, '{$locale}', {intl l='North Dakota' locale=$locale}),
    (35, '{$locale}', {intl l='Ohio' locale=$locale}),
    (36, '{$locale}', {intl l='Oklahoma' locale=$locale}),
    (37, '{$locale}', {intl l='Oregon' locale=$locale}),
    (38, '{$locale}', {intl l='Pennsylvania' locale=$locale}),
    (39, '{$locale}', {intl l='Rhode Island' locale=$locale}),
    (40, '{$locale}', {intl l='South Carolina' locale=$locale}),
    (41, '{$locale}', {intl l='South Dakota' locale=$locale}),
    (42, '{$locale}', {intl l='Tennessee' locale=$locale}),
    (43, '{$locale}', {intl l='Texas' locale=$locale}),
    (44, '{$locale}', {intl l='Utah' locale=$locale}),
    (45, '{$locale}', {intl l='Vermont' locale=$locale}),
    (46, '{$locale}', {intl l='Virginia' locale=$locale}),
    (47, '{$locale}', {intl l='Washington' locale=$locale}),
    (48, '{$locale}', {intl l='West Virginia' locale=$locale}),
    (49, '{$locale}', {intl l='Wisconsin' locale=$locale}),
    (50, '{$locale}', {intl l='Wyoming' locale=$locale}),
    (51, '{$locale}', {intl l='Puerto Rico' locale=$locale}),
    (52, '{$locale}', {intl l='US Virgin Islands' locale=$locale}),
    (53, '{$locale}', {intl l='District of Columbia' locale=$locale}),
    (54, '{$locale}', {intl l='Aguascalientes' locale=$locale}),
    (55, '{$locale}', {intl l='Baja California' locale=$locale}),
    (56, '{$locale}', {intl l='Baja California Sur' locale=$locale}),
    (57, '{$locale}', {intl l='Campeche' locale=$locale}),
    (58, '{$locale}', {intl l='Chiapas' locale=$locale}),
    (59, '{$locale}', {intl l='Chihuahua' locale=$locale}),
    (60, '{$locale}', {intl l='Coahuila' locale=$locale}),
    (61, '{$locale}', {intl l='Colima' locale=$locale}),
    (62, '{$locale}', {intl l='Distrito Federal' locale=$locale}),
    (63, '{$locale}', {intl l='Durango' locale=$locale}),
    (64, '{$locale}', {intl l='Guanajuato' locale=$locale}),
    (65, '{$locale}', {intl l='Guerrero' locale=$locale}),
    (66, '{$locale}', {intl l='Hidalgo' locale=$locale}),
    (67, '{$locale}', {intl l='Jalisco' locale=$locale}),
    (68, '{$locale}', {intl l='Estado de México' locale=$locale}),
    (69, '{$locale}', {intl l='Michoacán' locale=$locale}),
    (70, '{$locale}', {intl l='Morelos' locale=$locale}),
    (71, '{$locale}', {intl l='Nayarit' locale=$locale}),
    (72, '{$locale}', {intl l='Nuevo León' locale=$locale}),
    (73, '{$locale}', {intl l='Oaxaca' locale=$locale}),
    (74, '{$locale}', {intl l='Puebla' locale=$locale}),
    (75, '{$locale}', {intl l='Querétaro' locale=$locale}),
    (76, '{$locale}', {intl l='Quintana Roo' locale=$locale}),
    (77, '{$locale}', {intl l='San Luis Potosí' locale=$locale}),
    (78, '{$locale}', {intl l='Sinaloa' locale=$locale}),
    (79, '{$locale}', {intl l='Sonora' locale=$locale}),
    (80, '{$locale}', {intl l='Tabasco' locale=$locale}),
    (81, '{$locale}', {intl l='Tamaulipas' locale=$locale}),
    (82, '{$locale}', {intl l='Tlaxcala' locale=$locale}),
    (83, '{$locale}', {intl l='Veracruz' locale=$locale}),
    (84, '{$locale}', {intl l='Yucatán' locale=$locale}),
    (85, '{$locale}', {intl l='Zacatecas' locale=$locale}),
    (86, '{$locale}', {intl l='Ontario' locale=$locale}),
    (87, '{$locale}', {intl l='Quebec' locale=$locale}),
    (88, '{$locale}', {intl l='British Columbia' locale=$locale}),
    (89, '{$locale}', {intl l='Alberta' locale=$locale}),
    (90, '{$locale}', {intl l='Manitoba' locale=$locale}),
    (91, '{$locale}', {intl l='Saskatchewan' locale=$locale}),
    (92, '{$locale}', {intl l='Nova Scotia' locale=$locale}),
    (93, '{$locale}', {intl l='New Brunswick' locale=$locale}),
    (94, '{$locale}', {intl l='Newfoundland and Labrador' locale=$locale}),
    (95, '{$locale}', {intl l='Prince Edward Island' locale=$locale}),
    (96, '{$locale}', {intl l='Northwest Territories' locale=$locale}),
    (97, '{$locale}', {intl l='Yukon' locale=$locale}),
    (98, '{$locale}', {intl l='Nunavut' locale=$locale}),
    (99, '{$locale}', {intl l='Buenos Aires' locale=$locale}),
    (100, '{$locale}', {intl l='Catamarca' locale=$locale}),
    (101, '{$locale}', {intl l='Chaco' locale=$locale}),
    (102, '{$locale}', {intl l='Chubut' locale=$locale}),
    (103, '{$locale}', {intl l='Ciudad de Buenos Aires' locale=$locale}),
    (104, '{$locale}', {intl l='Córdoba' locale=$locale}),
    (105, '{$locale}', {intl l='Corrientes' locale=$locale}),
    (106, '{$locale}', {intl l='Entre Ríos' locale=$locale}),
    (107, '{$locale}', {intl l='Formosa' locale=$locale}),
    (108, '{$locale}', {intl l='Jujuy' locale=$locale}),
    (109, '{$locale}', {intl l='La Pampa' locale=$locale}),
    (110, '{$locale}', {intl l='La Rioja' locale=$locale}),
    (111, '{$locale}', {intl l='Mendoza' locale=$locale}),
    (112, '{$locale}', {intl l='Misiones' locale=$locale}),
    (113, '{$locale}', {intl l='Neuquén' locale=$locale}),
    (114, '{$locale}', {intl l='Río Negro' locale=$locale}),
    (115, '{$locale}', {intl l='Salta' locale=$locale}),
    (116, '{$locale}', {intl l='San Juan' locale=$locale}),
    (117, '{$locale}', {intl l='San Luis' locale=$locale}),
    (118, '{$locale}', {intl l='Santa Cruz' locale=$locale}),
    (119, '{$locale}', {intl l='Santa Fe' locale=$locale}),
    (120, '{$locale}', {intl l='Santiago del Estero' locale=$locale}),
    (121, '{$locale}', {intl l='Tierra del Fuego' locale=$locale}),
    (122, '{$locale}', {intl l='Tucumán' locale=$locale}),
    (123, '{$locale}', {intl l='Agrigento' locale=$locale}),
    (124, '{$locale}', {intl l='Alessandria' locale=$locale}),
    (125, '{$locale}', {intl l='Ancona' locale=$locale}),
    (126, '{$locale}', {intl l='Aosta' locale=$locale}),
    (127, '{$locale}', {intl l='Arezzo' locale=$locale}),
    (128, '{$locale}', {intl l='Ascoli Piceno' locale=$locale}),
    (129, '{$locale}', {intl l='Asti' locale=$locale}),
    (130, '{$locale}', {intl l='Avellino' locale=$locale}),
    (131, '{$locale}', {intl l='Bari' locale=$locale}),
    (132, '{$locale}', {intl l='Barletta-Andria-Trani' locale=$locale}),
    (133, '{$locale}', {intl l='Belluno' locale=$locale}),
    (134, '{$locale}', {intl l='Benevento' locale=$locale}),
    (135, '{$locale}', {intl l='Bergamo' locale=$locale}),
    (136, '{$locale}', {intl l='Biella' locale=$locale}),
    (137, '{$locale}', {intl l='Bologna' locale=$locale}),
    (138, '{$locale}', {intl l='Bolzano' locale=$locale}),
    (139, '{$locale}', {intl l='Brescia' locale=$locale}),
    (140, '{$locale}', {intl l='Brindisi' locale=$locale}),
    (141, '{$locale}', {intl l='Cagliari' locale=$locale}),
    (142, '{$locale}', {intl l='Caltanissetta' locale=$locale}),
    (143, '{$locale}', {intl l='Campobasso' locale=$locale}),
    (144, '{$locale}', {intl l='Carbonia-Iglesias' locale=$locale}),
    (145, '{$locale}', {intl l='Caserta' locale=$locale}),
    (146, '{$locale}', {intl l='Catania' locale=$locale}),
    (147, '{$locale}', {intl l='Catanzaro' locale=$locale}),
    (148, '{$locale}', {intl l='Chieti' locale=$locale}),
    (149, '{$locale}', {intl l='Como' locale=$locale}),
    (150, '{$locale}', {intl l='Cosenza' locale=$locale}),
    (151, '{$locale}', {intl l='Cremona' locale=$locale}),
    (152, '{$locale}', {intl l='Crotone' locale=$locale}),
    (153, '{$locale}', {intl l='Cuneo' locale=$locale}),
    (154, '{$locale}', {intl l='Enna' locale=$locale}),
    (155, '{$locale}', {intl l='Fermo' locale=$locale}),
    (156, '{$locale}', {intl l='Ferrara' locale=$locale}),
    (157, '{$locale}', {intl l='Firenze' locale=$locale}),
    (158, '{$locale}', {intl l='Foggia' locale=$locale}),
    (159, '{$locale}', {intl l='Forlì-Cesena' locale=$locale}),
    (160, '{$locale}', {intl l='Frosinone' locale=$locale}),
    (161, '{$locale}', {intl l='Genova' locale=$locale}),
    (162, '{$locale}', {intl l='Gorizia' locale=$locale}),
    (163, '{$locale}', {intl l='Grosseto' locale=$locale}),
    (164, '{$locale}', {intl l='Imperia' locale=$locale}),
    (165, '{$locale}', {intl l='Isernia' locale=$locale}),
    (166, '{$locale}', {intl l='L\'Aquila' locale=$locale}),
    (167, '{$locale}', {intl l='La Spezia' locale=$locale}),
    (168, '{$locale}', {intl l='Latina' locale=$locale}),
    (169, '{$locale}', {intl l='Lecce' locale=$locale}),
    (170, '{$locale}', {intl l='Lecco' locale=$locale}),
    (171, '{$locale}', {intl l='Livorno' locale=$locale}),
    (172, '{$locale}', {intl l='Lodi' locale=$locale}),
    (173, '{$locale}', {intl l='Lucca' locale=$locale}),
    (174, '{$locale}', {intl l='Macerata' locale=$locale}),
    (175, '{$locale}', {intl l='Mantova' locale=$locale}),
    (176, '{$locale}', {intl l='Massa' locale=$locale}),
    (177, '{$locale}', {intl l='Matera' locale=$locale}),
    (178, '{$locale}', {intl l='Medio Campidano' locale=$locale}),
    (179, '{$locale}', {intl l='Messina' locale=$locale}),
    (180, '{$locale}', {intl l='Milano' locale=$locale}),
    (181, '{$locale}', {intl l='Modena' locale=$locale}),
    (182, '{$locale}', {intl l='Monza e della Brianza' locale=$locale}),
    (183, '{$locale}', {intl l='Napoli' locale=$locale}),
    (184, '{$locale}', {intl l='Novara' locale=$locale}),
    (185, '{$locale}', {intl l='Nuoro' locale=$locale}),
    (186, '{$locale}', {intl l='Ogliastra' locale=$locale}),
    (187, '{$locale}', {intl l='Olbia-Tempio' locale=$locale}),
    (188, '{$locale}', {intl l='Oristano' locale=$locale}),
    (189, '{$locale}', {intl l='Padova' locale=$locale}),
    (190, '{$locale}', {intl l='Palermo' locale=$locale}),
    (191, '{$locale}', {intl l='Parma' locale=$locale}),
    (192, '{$locale}', {intl l='Pavia' locale=$locale}),
    (193, '{$locale}', {intl l='Perugia' locale=$locale}),
    (194, '{$locale}', {intl l='Pesaro-Urbino' locale=$locale}),
    (195, '{$locale}', {intl l='Pescara' locale=$locale}),
    (196, '{$locale}', {intl l='Piacenza' locale=$locale}),
    (197, '{$locale}', {intl l='Pisa' locale=$locale}),
    (198, '{$locale}', {intl l='Pistoia' locale=$locale}),
    (199, '{$locale}', {intl l='Pordenone' locale=$locale}),
    (200, '{$locale}', {intl l='Potenza' locale=$locale}),
    (201, '{$locale}', {intl l='Prato' locale=$locale}),
    (202, '{$locale}', {intl l='Ragusa' locale=$locale}),
    (203, '{$locale}', {intl l='Ravenna' locale=$locale}),
    (204, '{$locale}', {intl l='Reggio Calabria' locale=$locale}),
    (205, '{$locale}', {intl l='Reggio Emilia' locale=$locale}),
    (206, '{$locale}', {intl l='Rieti' locale=$locale}),
    (207, '{$locale}', {intl l='Rimini' locale=$locale}),
    (208, '{$locale}', {intl l='Roma' locale=$locale}),
    (209, '{$locale}', {intl l='Rovigo' locale=$locale}),
    (210, '{$locale}', {intl l='Salerno' locale=$locale}),
    (211, '{$locale}', {intl l='Sassari' locale=$locale}),
    (212, '{$locale}', {intl l='Savona' locale=$locale}),
    (213, '{$locale}', {intl l='Siena' locale=$locale}),
    (214, '{$locale}', {intl l='Siracusa' locale=$locale}),
    (215, '{$locale}', {intl l='Sondrio' locale=$locale}),
    (216, '{$locale}', {intl l='Taranto' locale=$locale}),
    (217, '{$locale}', {intl l='Teramo' locale=$locale}),
    (218, '{$locale}', {intl l='Terni' locale=$locale}),
    (219, '{$locale}', {intl l='Torino' locale=$locale}),
    (220, '{$locale}', {intl l='Trapani' locale=$locale}),
    (221, '{$locale}', {intl l='Trento' locale=$locale}),
    (222, '{$locale}', {intl l='Treviso' locale=$locale}),
    (223, '{$locale}', {intl l='Trieste' locale=$locale}),
    (224, '{$locale}', {intl l='Udine' locale=$locale}),
    (225, '{$locale}', {intl l='Varese' locale=$locale}),
    (226, '{$locale}', {intl l='Venezia' locale=$locale}),
    (227, '{$locale}', {intl l='Verbano-Cusio-Ossola' locale=$locale}),
    (228, '{$locale}', {intl l='Vercelli' locale=$locale}),
    (229, '{$locale}', {intl l='Verona' locale=$locale}),
    (230, '{$locale}', {intl l='Vibo Valentia' locale=$locale}),
    (231, '{$locale}', {intl l='Vicenza' locale=$locale}),
    (232, '{$locale}', {intl l='Viterbo' locale=$locale}),
    (233, '{$locale}', {intl l='Aceh' locale=$locale}),
    (234, '{$locale}', {intl l='Bali' locale=$locale}),
    (235, '{$locale}', {intl l='Bangka' locale=$locale}),
    (236, '{$locale}', {intl l='Banten' locale=$locale}),
    (237, '{$locale}', {intl l='Bengkulu' locale=$locale}),
    (238, '{$locale}', {intl l='Central Java' locale=$locale}),
    (239, '{$locale}', {intl l='Central Kalimantan' locale=$locale}),
    (240, '{$locale}', {intl l='Central Sulawesi' locale=$locale}),
    (241, '{$locale}', {intl l='Coat of arms of East Java' locale=$locale}),
    (242, '{$locale}', {intl l='East kalimantan' locale=$locale}),
    (243, '{$locale}', {intl l='East Nusa Tenggara' locale=$locale}),
    (244, '{$locale}', {intl l='Lambang propinsi' locale=$locale}),
    (245, '{$locale}', {intl l='Jakarta' locale=$locale}),
    (246, '{$locale}', {intl l='Jambi' locale=$locale}),
    (247, '{$locale}', {intl l='Lampung' locale=$locale}),
    (248, '{$locale}', {intl l='Maluku' locale=$locale}),
    (249, '{$locale}', {intl l='North Maluku' locale=$locale}),
    (250, '{$locale}', {intl l='North Sulawesi' locale=$locale}),
    (251, '{$locale}', {intl l='North Sumatra' locale=$locale}),
    (252, '{$locale}', {intl l='Papua' locale=$locale}),
    (253, '{$locale}', {intl l='Riau' locale=$locale}),
    (254, '{$locale}', {intl l='Lambang Riau' locale=$locale}),
    (255, '{$locale}', {intl l='Southeast Sulawesi' locale=$locale}),
    (256, '{$locale}', {intl l='South Kalimantan' locale=$locale}),
    (257, '{$locale}', {intl l='South Sulawesi' locale=$locale}),
    (258, '{$locale}', {intl l='South Sumatra' locale=$locale}),
    (259, '{$locale}', {intl l='West Java' locale=$locale}),
    (260, '{$locale}', {intl l='West Kalimantan' locale=$locale}),
    (261, '{$locale}', {intl l='West Nusa Tenggara' locale=$locale}),
    (262, '{$locale}', {intl l='Lambang Provinsi Papua Barat' locale=$locale}),
    (263, '{$locale}', {intl l='West Sulawesi' locale=$locale}),
    (264, '{$locale}', {intl l='West Sumatra' locale=$locale}),
    (265, '{$locale}', {intl l='Yogyakarta' locale=$locale}),
    (266, '{$locale}', {intl l='Aichi' locale=$locale}),
    (267, '{$locale}', {intl l='Akita' locale=$locale}),
    (268, '{$locale}', {intl l='Aomori' locale=$locale}),
    (269, '{$locale}', {intl l='Chiba' locale=$locale}),
    (270, '{$locale}', {intl l='Ehime' locale=$locale}),
    (271, '{$locale}', {intl l='Fukui' locale=$locale}),
    (272, '{$locale}', {intl l='Fukuoka' locale=$locale}),
    (273, '{$locale}', {intl l='Fukushima' locale=$locale}),
    (274, '{$locale}', {intl l='Gifu' locale=$locale}),
    (275, '{$locale}', {intl l='Gunma' locale=$locale}),
    (276, '{$locale}', {intl l='Hiroshima' locale=$locale}),
    (277, '{$locale}', {intl l='Hokkaido' locale=$locale}),
    (278, '{$locale}', {intl l='Hyogo' locale=$locale}),
    (279, '{$locale}', {intl l='Ibaraki' locale=$locale}),
    (280, '{$locale}', {intl l='Ishikawa' locale=$locale}),
    (281, '{$locale}', {intl l='Iwate' locale=$locale}),
    (282, '{$locale}', {intl l='Kagawa' locale=$locale}),
    (283, '{$locale}', {intl l='Kagoshima' locale=$locale}),
    (284, '{$locale}', {intl l='Kanagawa' locale=$locale}),
    (285, '{$locale}', {intl l='Kochi' locale=$locale}),
    (286, '{$locale}', {intl l='Kumamoto' locale=$locale}),
    (287, '{$locale}', {intl l='Kyoto' locale=$locale}),
    (288, '{$locale}', {intl l='Mie' locale=$locale}),
    (289, '{$locale}', {intl l='Miyagi' locale=$locale}),
    (290, '{$locale}', {intl l='Miyazaki' locale=$locale}),
    (291, '{$locale}', {intl l='Nagano' locale=$locale}),
    (292, '{$locale}', {intl l='Nagasaki' locale=$locale}),
    (293, '{$locale}', {intl l='Nara' locale=$locale}),
    (294, '{$locale}', {intl l='Niigata' locale=$locale}),
    (295, '{$locale}', {intl l='Oita' locale=$locale}),
    (296, '{$locale}', {intl l='Okayama' locale=$locale}),
    (297, '{$locale}', {intl l='Okinawa' locale=$locale}),
    (298, '{$locale}', {intl l='Osaka' locale=$locale}),
    (299, '{$locale}', {intl l='Saga' locale=$locale}),
    (300, '{$locale}', {intl l='Saitama' locale=$locale}),
    (301, '{$locale}', {intl l='Shiga' locale=$locale}),
    (302, '{$locale}', {intl l='Shimane' locale=$locale}),
    (303, '{$locale}', {intl l='Shizuoka' locale=$locale}),
    (304, '{$locale}', {intl l='Tochigi' locale=$locale}),
    (305, '{$locale}', {intl l='Tokushima' locale=$locale}),
    (306, '{$locale}', {intl l='Tokyo' locale=$locale}),
    (307, '{$locale}', {intl l='Tottori' locale=$locale}),
    (308, '{$locale}', {intl l='Toyama' locale=$locale}),
    (309, '{$locale}', {intl l='Wakayama' locale=$locale}),
    (310, '{$locale}', {intl l='Yamagata' locale=$locale}),
    (311, '{$locale}', {intl l='Yamaguchi' locale=$locale}),
    (312, '{$locale}', {intl l='Yamanashi' locale=$locale}),
    (313, '{$locale}', ''),
    (314, '{$locale}', ''),
    (315, '{$locale}', ''),
    (316, '{$locale}', ''),
    (317, '{$locale}', ''){if ! $locale@last},{/if}

{/foreach}
;

-- Add new column in lang table
ALTER TABLE  `lang` ADD  `active` BOOLEAN NOT NULL DEFAULT FALSE AFTER  `decimals` ;
ALTER TABLE  `lang` ADD  `visible` TINYINT NOT NULL DEFAULT  '0' AFTER  `active` ;

-- Update lang
UPDATE `lang` SET `active` = '1', `visible` = '1' WHERE 1;

-- add missing primary key
ALTER TABLE `coupon_customer_count` ADD PRIMARY KEY(`coupon_id`, `customer_id`);
ALTER TABLE `ignored_module_hook` ADD PRIMARY KEY(`module_id`, `hook_id`);

SET FOREIGN_KEY_CHECKS = 1;
