SET FOREIGN_KEY_CHECKS = 0;

UPDATE `config` SET `value`='2.3.0-alpha1' WHERE `name`='thelia_version';
UPDATE `config` SET `value`='2' WHERE `name`='thelia_major_version';
UPDATE `config` SET `value`='3' WHERE `name`='thelia_minus_version';
UPDATE `config` SET `value`='0' WHERE `name`='thelia_release_version';
UPDATE `config` SET `value`='alpha1' WHERE `name`='thelia_extra_version';

-- Add new column in module_hook table
ALTER TABLE `module_hook` ADD `templates` TEXT AFTER`position`;

-- Add new columns in currency table
ALTER TABLE `currency` ADD  `format` CHAR( 10 ) NOT NULL AFTER  `symbol`;
ALTER TABLE `currency` ADD  `visible` TINYINT( 1 ) NOT NULL DEFAULT '0' AFTER  `rate`;

-- Update currencies
UPDATE `currency` SET `visible` = 1 WHERE 1;
UPDATE `currency` SET `format` = '%n %s' WHERE `code` NOT IN ('USD', 'GBP');
UPDATE `currency` SET `format` = '%s%n' WHERE `code` IN ('USD', 'GBP');

-- Additional hooks

SELECT @max_id := IFNULL(MAX(`id`),0) FROM `hook`;

INSERT INTO `hook` (`id`, `code`, `type`, `by_module`, `block`, `native`, `activate`, `position`, `created_at`, `updated_at`) VALUES
(@max_id+1,  'brand.modification.form-right.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+2,  'brand.modification.form-right.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+3,  'category.modification.form-right.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+4,  'category.modification.form-right.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+5,  'content.modification.form-right.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+6,  'content.modification.form-right.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+7,  'folder.modification.form-right.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+8,  'folder.modification.form-right.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+9,  'product.modification.form-right.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+10, 'product.modification.form-right.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW())
;

INSERT INTO  `hook_i18n` (`id`, `locale`, `title`, `description`, `chapo`) VALUES
(@max_id+1,  'de_DE', 'Marke bearbeiten - Rechte Spalte oben', NULL, NULL),
(@max_id+2,  'de_DE', 'Marke bearbeiten - Rechte Spalte unten', NULL, NULL),
(@max_id+3,  'de_DE', NULL, NULL, NULL),
(@max_id+4,  'de_DE', NULL, NULL, NULL),
(@max_id+5,  'de_DE', 'Inhalt bearbeiten - Rechte Spalte oben', NULL, NULL),
(@max_id+6,  'de_DE', 'Inhalt bearbeiten - Rechte Spalte unten', NULL, NULL),
(@max_id+7,  'de_DE', 'Ordner bearbeiten - Rechte Spalte oben', NULL, NULL),
(@max_id+8,  'de_DE', 'Ordner bearbeiten - Rechte Spalte unten', NULL, NULL),
(@max_id+9,  'de_DE', NULL, NULL, NULL),
(@max_id+10, 'de_DE', NULL, NULL, NULL),
(@max_id+1,  'en_US', 'Brand edit - right column top', NULL, NULL),
(@max_id+2,  'en_US', 'Brand edit - right column bottom', NULL, NULL),
(@max_id+3,  'en_US', 'Category edit - right column top', NULL, NULL),
(@max_id+4,  'en_US', 'Category edit - right column bottom', NULL, NULL),
(@max_id+5,  'en_US', 'Content edit - right column top', NULL, NULL),
(@max_id+6,  'en_US', 'Content edit - right column bottom', NULL, NULL),
(@max_id+7,  'en_US', 'Folder edit - right column top', NULL, NULL),
(@max_id+8,  'en_US', 'Folder edit - right column bottom', NULL, NULL),
(@max_id+9,  'en_US', 'Product edit - right column top', NULL, NULL),
(@max_id+10, 'en_US', 'Product edit - right column bottom', NULL, NULL),
(@max_id+1,  'es_ES', 'Edición de marca - encabezado de la columna derecha', NULL, NULL),
(@max_id+2,  'es_ES', 'Edición de marca - al pie de la columna derecha', NULL, NULL),
(@max_id+3,  'es_ES', 'Edición de categoría - al tope de la columna derecha', NULL, NULL),
(@max_id+4,  'es_ES', 'Edición de categoría - al pie de la columna derecha', NULL, NULL),
(@max_id+5,  'es_ES', 'Edición de Contenido - al tope de la columna derecha', NULL, NULL),
(@max_id+6,  'es_ES', 'Edición de Contenido - al pie de la columna derecha', NULL, NULL),
(@max_id+7,  'es_ES', 'Edición de carpeta - al tope de la columna derecha', NULL, NULL),
(@max_id+8,  'es_ES', 'Edición de carpeta - al pie de la columna derecha', NULL, NULL),
(@max_id+9,  'es_ES', 'Edición de producto - encabezado de la columna derecha', NULL, NULL),
(@max_id+10, 'es_ES', 'Edición de producto - al pie de la columna derecha', NULL, NULL),
(@max_id+1,  'fr_FR', 'Édition d\'une marque - en haut de la colonne de droite', NULL, NULL),
(@max_id+2,  'fr_FR', 'Édition d\'une marque - en bas de la colonne de droite', NULL, NULL),
(@max_id+3,  'fr_FR', 'Édition d\'une catégorie - en haut de la colonne de droite', NULL, NULL),
(@max_id+4,  'fr_FR', 'Édition d\'une catégorie - en bas de la colonne de droite', NULL, NULL),
(@max_id+5,  'fr_FR', 'Édition d\'un contenu - en haut de la colonne de droite', NULL, NULL),
(@max_id+6,  'fr_FR', 'Édition d\'un contenu  - en bas de la colonne de droite', NULL, NULL),
(@max_id+7,  'fr_FR', 'Édition d\'un dossier - en haut de la colonne de droite', NULL, NULL),
(@max_id+8,  'fr_FR', 'Édition d\'un dossier - en bas de la colonne de droite', NULL, NULL),
(@max_id+9,  'fr_FR', 'Édition d\'un produit - en haut de la colonne de droite', NULL, NULL),
(@max_id+10, 'fr_FR', 'Édition d\'un produit - en bas de la colonne de droite', NULL, NULL)
;

/* States */
SELECT @max_id := IFNULL(MAX(`id`),0) FROM `hook`;

INSERT INTO `hook` (`id`, `code`, `type`, `by_module`, `block`, `native`, `activate`, `position`, `created_at`, `updated_at`) VALUES
(@max_id + 1, 'state-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 2, 'state-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 3, 'state.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 4, 'states.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 5, 'states.table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 6, 'states.table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 7, 'states.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 8, 'state.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 9, 'state.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 10, 'states.js', 2, 0, 0, 1, 1, 1, NOW(), NOW())
;

INSERT INTO  `hook_i18n` (`id`, `locale`, `title`, `description`, `chapo`) VALUES
(@max_id + 1, 'de_DE', NULL, '', ''),
(@max_id + 2, 'de_DE', NULL, '', ''),
(@max_id + 3, 'de_DE', NULL, '', ''),
(@max_id + 4, 'de_DE', NULL, '', ''),
(@max_id + 5, 'de_DE', NULL, '',    ''),
(@max_id + 6, 'de_DE', NULL, '', ''),
(@max_id + 7, 'de_DE', NULL, '', ''),
(@max_id + 8, 'de_DE', NULL, '',  ''),
(@max_id + 9, 'de_DE', NULL, '', ''),
(@max_id + 10, 'de_DE', NULL, '', ''),
(@max_id + 1, 'en_US', 'state-edit - at the top', '', ''),
(@max_id + 2, 'en_US', 'state-edit - bottom', '', ''),
(@max_id + 3, 'en_US', 'state - Edit JavaScript', '', ''),
(@max_id + 4, 'en_US', 'states - at the top', '', ''),
(@max_id + 5, 'en_US', 'states - table header', '',    ''),
(@max_id + 6, 'en_US', 'states - table row', '', ''),
(@max_id + 7, 'en_US', 'states - bottom', '', ''),
(@max_id + 8, 'en_US', 'state - creation form', '',  ''),
(@max_id + 9, 'en_US', 'state - delete form', '', ''),
(@max_id + 10, 'en_US', 'states - JavaScript', '', ''),
(@max_id + 1, 'es_ES', 'estado - editar - encabezado', '', ''),
(@max_id + 2, 'es_ES', 'estado - al pie', '', ''),
(@max_id + 3, 'es_ES', 'estado - Editar JavaScript', '', ''),
(@max_id + 4, 'es_ES', 'estados - encabezado', '', ''),
(@max_id + 5, 'es_ES', 'estados - encabezado de tabla', '',    ''),
(@max_id + 6, 'es_ES', 'estados - fila de tabla', '', ''),
(@max_id + 7, 'es_ES', 'estados - al pie', '', ''),
(@max_id + 8, 'es_ES', 'estado - formulario de creación', '',  ''),
(@max_id + 9, 'es_ES', 'estado - formulario de borrado', '', ''),
(@max_id + 10, 'es_ES', 'estados - JavaScript', '', ''),
(@max_id + 1, 'fr_FR', 'édition d\'un état - en haut', '', ''),
(@max_id + 2, 'fr_FR', 'édition d\'un état - en bas', '', ''),
(@max_id + 3, 'fr_FR', 'Etat - JavaScript modification', '', ''),
(@max_id + 4, 'fr_FR', 'états - en haut', '', ''),
(@max_id + 5, 'fr_FR', 'états - colonne tableau', '',    ''),
(@max_id + 6, 'fr_FR', 'états - ligne du tableau', '', ''),
(@max_id + 7, 'fr_FR', 'états - bas', '', ''),
(@max_id + 8, 'fr_FR', 'état - formulaire de création', '',  ''),
(@max_id + 9, 'fr_FR', 'état - formulaire de suppression', '', ''),
(@max_id + 10, 'fr_FR', 'états - JavaScript', '', '')
;

SELECT @max_id := IFNULL(MAX(`id`),0) FROM `hook`;

INSERT INTO `hook` (`id`, `code`, `type`, `by_module`, `block`, `native`, `activate`, `position`, `created_at`, `updated_at`) VALUES
(@max_id+1, 'email-html.template.css', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+2, 'email-html.layout.footer', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+3, 'email-html.order-confirmation.before-address', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+4, 'email-html.order-confirmation.delivery-address', 4, 1, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+5, 'email-html.order-confirmation.after-address', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+6, 'email-html.order-confirmation.order-product', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+7, 'email-html.order-confirmation.before-products', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+8, 'email-html.order-confirmation.after-products', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+9, 'email-html.order-confirmation.footer', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+10, 'email-html.order-notification.before-address', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+11, 'email-html.order-notification.delivery-address', 4, 1, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+12, 'email-html.order-notification.after-address', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+13, 'email-html.order-notification.order-product', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+14, 'email-html.order-notification.before-products', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+15, 'email-html.order-notification.after-products', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+16, 'email-txt.order-confirmation.before-address', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+17, 'email-txt.order-confirmation.delivery-address', 4, 1, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+18, 'email-txt.order-confirmation.after-address', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+19, 'email-txt.order-confirmation.order-product', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+20, 'email-txt.order-confirmation.before-products', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+21, 'email-txt.order-confirmation.after-products', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+22, 'email-txt.order-notification.before-address', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+23, 'email-txt.order-notification.delivery-address', 4, 1, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+24, 'email-txt.order-notification.after-address', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+25, 'email-txt.order-notification.order-product', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+26, 'email-txt.order-notification.before-products', 4, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id+27, 'email-txt.order-notification.after-products', 4, 0, 0, 1, 1, 1, NOW(), NOW())
;

INSERT INTO  `hook_i18n` (`id`, `locale`, `title`, `description`, `chapo`) VALUES
    (@max_id+1, 'de_DE', 'E-Mail html - Layout - CSS', NULL, NULL),
    (@max_id+2, 'de_DE', 'E-Mail html - Layout - Fußzeile', NULL, NULL),
    (@max_id+3, 'de_DE', 'E-Mail html - Bestellbestätigung - vor Adresse', NULL, NULL),
    (@max_id+4, 'de_DE', NULL, NULL, NULL),
    (@max_id+5, 'de_DE', 'E-Mail html - Bestellbestätigung - nach Adresse', NULL, NULL),
    (@max_id+6, 'de_DE', NULL, NULL, NULL),
    (@max_id+7, 'de_DE', 'E-Mail html - Bestellbestätigung - vor Produkten', NULL, NULL),
    (@max_id+8, 'de_DE', 'E-Mail html - Bestellbestätigung - nach Produkten', NULL, NULL),
    (@max_id+9, 'de_DE', NULL, NULL, NULL),
    (@max_id+10, 'de_DE', NULL, NULL, NULL),
    (@max_id+11, 'de_DE', NULL, NULL, NULL),
    (@max_id+12, 'de_DE', NULL, NULL, NULL),
    (@max_id+13, 'de_DE', NULL, NULL, NULL),
    (@max_id+14, 'de_DE', NULL, NULL, NULL),
    (@max_id+15, 'de_DE', NULL, NULL, NULL),
    (@max_id+16, 'de_DE', NULL, NULL, NULL),
    (@max_id+17, 'de_DE', NULL, NULL, NULL),
    (@max_id+18, 'de_DE', NULL, NULL, NULL),
    (@max_id+19, 'de_DE', NULL, NULL, NULL),
    (@max_id+20, 'de_DE', NULL, NULL, NULL),
    (@max_id+21, 'de_DE', NULL, NULL, NULL),
    (@max_id+22, 'de_DE', NULL, NULL, NULL),
    (@max_id+23, 'de_DE', NULL, NULL, NULL),
    (@max_id+24, 'de_DE', NULL, NULL, NULL),
    (@max_id+25, 'de_DE', NULL, NULL, NULL),
    (@max_id+26, 'de_DE', NULL, NULL, NULL),
    (@max_id+27, 'de_DE', NULL, NULL, NULL),
    (@max_id+1, 'en_US', 'Email html - layout - CSS', NULL, NULL),
    (@max_id+2, 'en_US', 'Email html - layout - footer', NULL, NULL),
    (@max_id+3, 'en_US', 'Email html - order confirmation - before address', NULL, NULL),
    (@max_id+4, 'en_US', 'Email html - order confirmation - delivery address', NULL, NULL),
    (@max_id+5, 'en_US', 'Email html - order confirmation - after address', NULL, NULL),
    (@max_id+6, 'en_US', 'Email html - order confirmation - order product', NULL, NULL),
    (@max_id+7, 'en_US', 'Email html - order confirmation - before products', NULL, NULL),
    (@max_id+8, 'en_US', 'Email html - order confirmation - after products', NULL, NULL),
    (@max_id+9, 'en_US', 'Email html - order confirmation - footer', NULL, NULL),
    (@max_id+10, 'en_US', 'Email html - order notification - before address', NULL, NULL),
    (@max_id+11, 'en_US', 'Email html - order notification - delivery address', NULL, NULL),
    (@max_id+12, 'en_US', 'Email html - order notification - after address', NULL, NULL),
    (@max_id+13, 'en_US', 'Email html - order notification - order product', NULL, NULL),
    (@max_id+14, 'en_US', 'Email html - order notification - before products', NULL, NULL),
    (@max_id+15, 'en_US', 'Email html - order notification - after products', NULL, NULL),
    (@max_id+16, 'en_US', 'Email txt - order confirmation - before address', NULL, NULL),
    (@max_id+17, 'en_US', 'Email txt - order confirmation - delivery address', NULL, NULL),
    (@max_id+18, 'en_US', 'Email txt - order confirmation - after address', NULL, NULL),
    (@max_id+19, 'en_US', 'Email txt - order confirmation - order product', NULL, NULL),
    (@max_id+20, 'en_US', 'Email txt - order confirmation - before products', NULL, NULL),
    (@max_id+21, 'en_US', 'Email txt - order confirmation - after products', NULL, NULL),
    (@max_id+22, 'en_US', 'Email txt - order notification - before address', NULL, NULL),
    (@max_id+23, 'en_US', 'Email txt - order notification - delivery address', NULL, NULL),
    (@max_id+24, 'en_US', 'Email txt - order notification - after address', NULL, NULL),
    (@max_id+25, 'en_US', 'Email txt - order notification - order product', NULL, NULL),
    (@max_id+26, 'en_US', 'Email txt - order notification - before products', NULL, NULL),
    (@max_id+27, 'en_US', 'Email txt - order notification - after products', NULL, NULL),
    (@max_id+1, 'es_ES', 'Email HTML - Interfaz - CSS', NULL, NULL),
    (@max_id+2, 'es_ES', 'Email HTML - Interfaz - pie', NULL, NULL),
    (@max_id+3, 'es_ES', NULL, NULL, NULL),
    (@max_id+4, 'es_ES', NULL, NULL, NULL),
    (@max_id+5, 'es_ES', 'Email HTML - confirmación de orden - después de la dirección', NULL, NULL),
    (@max_id+6, 'es_ES', NULL, NULL, NULL),
    (@max_id+7, 'es_ES', NULL, NULL, NULL),
    (@max_id+8, 'es_ES', NULL, NULL, NULL),
    (@max_id+9, 'es_ES', NULL, NULL, NULL),
    (@max_id+10, 'es_ES', NULL, NULL, NULL),
    (@max_id+11, 'es_ES', NULL, NULL, NULL),
    (@max_id+12, 'es_ES', NULL, NULL, NULL),
    (@max_id+13, 'es_ES', 'Email HTML - notificación de orden - pedir producto', NULL, NULL),
    (@max_id+14, 'es_ES', NULL, NULL, NULL),
    (@max_id+15, 'es_ES', NULL, NULL, NULL),
    (@max_id+16, 'es_ES', 'Email texto - confirmación de pedido - antes de la dirección', NULL, NULL),
    (@max_id+17, 'es_ES', 'Email texto - confirmación de pedido - dirección de entrega', NULL, NULL),
    (@max_id+18, 'es_ES', 'Email texto - confirmación de pedido - después de la dirección', NULL, NULL),
    (@max_id+19, 'es_ES', 'Email texto - confirmación de pedido - pedido de producto', NULL, NULL),
    (@max_id+20, 'es_ES', 'Email texto - confirmación de pedido - antes de los productos', NULL, NULL),
    (@max_id+21, 'es_ES', 'Email texto - confirmación de pedido - después de los productos', NULL, NULL),
    (@max_id+22, 'es_ES', NULL, NULL, NULL),
    (@max_id+23, 'es_ES', NULL, NULL, NULL),
    (@max_id+24, 'es_ES', 'Email texto - notificación de pedido - después de la dirección', NULL, NULL),
    (@max_id+25, 'es_ES', NULL, NULL, NULL),
    (@max_id+26, 'es_ES', NULL, NULL, NULL),
    (@max_id+27, 'es_ES', NULL, NULL, NULL),
    (@max_id+1, 'fr_FR', 'Email html - layout - CSS', NULL, NULL),
    (@max_id+2, 'fr_FR', 'Email html - layout - pied de page', NULL, NULL),
    (@max_id+3, 'fr_FR', 'Email html - confirmation commande - avant adresses', NULL, NULL),
    (@max_id+4, 'fr_FR', 'Email html - confirmation commande - adresse de livraison', NULL, NULL),
    (@max_id+5, 'fr_FR', 'Email html - confirmation commande - après adresses', NULL, NULL),
    (@max_id+6, 'fr_FR', 'Email html - confirmation commande - produit de la commande', NULL, NULL),
    (@max_id+7, 'fr_FR', 'Email html - confirmation commande - avant produits', NULL, NULL),
    (@max_id+8, 'fr_FR', 'Email html - confirmation commande - après produits', NULL, NULL),
    (@max_id+9, 'fr_FR', 'Email html - confirmation commande - pied de page', NULL, NULL),
    (@max_id+10, 'fr_FR', 'Email html - notification commande - avant adresses', NULL, NULL),
    (@max_id+11, 'fr_FR', 'Email html - notification commande - adresse de livraison', NULL, NULL),
    (@max_id+12, 'fr_FR', 'Email html - notification commande - après adresses', NULL, NULL),
    (@max_id+13, 'fr_FR', 'Email html - notification commande - produit de la commande', NULL, NULL),
    (@max_id+14, 'fr_FR', 'Email html - notification commande - avant produits', NULL, NULL),
    (@max_id+15, 'fr_FR', 'Email html - notification commande - après produits', NULL, NULL),
    (@max_id+16, 'fr_FR', 'Email txt - confirmation commande - avant adresses', NULL, NULL),
    (@max_id+17, 'fr_FR', 'Email txt - confirmation commande - adresse de livraison', NULL, NULL),
    (@max_id+18, 'fr_FR', 'Email txt - confirmation commande - après adresses', NULL, NULL),
    (@max_id+19, 'fr_FR', 'Email txt - confirmation commande - produit de la commande', NULL, NULL),
    (@max_id+20, 'fr_FR', 'Email txt - confirmation commande - avant produits', NULL, NULL),
    (@max_id+21, 'fr_FR', 'Email txt - confirmation commande - après produits', NULL, NULL),
    (@max_id+22, 'fr_FR', 'Email txt - notification commande - avant adresses', NULL, NULL),
    (@max_id+23, 'fr_FR', 'Email txt - notification commande - adresse de livraison', NULL, NULL),
    (@max_id+24, 'fr_FR', 'Email txt - notification commande - après adresses', NULL, NULL),
    (@max_id+25, 'fr_FR', 'Email txt - notification commande - produit de la commande', NULL, NULL),
    (@max_id+26, 'fr_FR', 'Email txt - notification commande - avant produits', NULL, NULL),
    (@max_id+27, 'fr_FR', 'Email txt - notification commande - après produits', NULL, NULL)
;

/* countries and states */

ALTER TABLE `country`
    ADD COLUMN `visible` TINYINT DEFAULT 0 NOT NULL AFTER  `id`,
    ADD COLUMN `has_states` TINYINT DEFAULT 0 AFTER `isoalpha3`,
    ADD COLUMN `need_zip_code` TINYINT DEFAULT 0 AFTER  `has_states`,
    ADD COLUMN `zip_code_format` VARCHAR(20) AFTER `need_zip_code`;

CREATE TABLE `state`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `visible` TINYINT DEFAULT 0 NOT NULL,
    `isocode` VARCHAR(4) NOT NULL,
    `country_id` INTEGER NOT NULL,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`),
    INDEX `FI_state_country_id` (`country_id`),
    CONSTRAINT `fk_state_country_id`
        FOREIGN KEY (`country_id`)
        REFERENCES `country` (`id`)
        ON UPDATE RESTRICT
        ON DELETE CASCADE
) ENGINE=InnoDB CHARACTER SET='utf8';

CREATE TABLE `state_i18n`
(
    `id` INTEGER NOT NULL,
    `locale` VARCHAR(5) DEFAULT 'en_US' NOT NULL,
    `title` VARCHAR(255),
    PRIMARY KEY (`id`,`locale`),
    CONSTRAINT `state_i18n_FK_1`
        FOREIGN KEY (`id`)
        REFERENCES `state` (`id`)
        ON DELETE CASCADE
) ENGINE=InnoDB CHARACTER SET='utf8';

ALTER TABLE `address`
    ADD COLUMN `state_id` INTEGER AFTER `country_id`,
    ADD CONSTRAINT `fk_address_state_id`
        FOREIGN KEY (`state_id`)
        REFERENCES `state` (`id`)
        ON UPDATE RESTRICT
        ON DELETE RESTRICT,
    ADD INDEX `FI_address_state_id` (`state_id`);

ALTER TABLE `order_address`
    ADD COLUMN `state_id` INTEGER AFTER `country_id`,
    ADD CONSTRAINT `fk_order_address_state_id`
        FOREIGN KEY (`state_id`)
        REFERENCES `state` (`id`)
        ON UPDATE RESTRICT
        ON DELETE RESTRICT,
    ADD INDEX `FI_order_address_state_id` (`state_id`);

ALTER TABLE `tax_rule_country`
    DROP PRIMARY KEY,
    ADD COLUMN `id` INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST,
    ADD COLUMN `state_id` INTEGER AFTER `country_id`,
    ADD CONSTRAINT `fk_tax_rule_country_state_id`
        FOREIGN KEY (`state_id`)
        REFERENCES `state` (`id`)
        ON UPDATE RESTRICT
        ON DELETE CASCADE,
    ADD INDEX `idx_tax_rule_country_state_id` (`state_id`);

ALTER TABLE `country_area`
    ADD COLUMN `id` INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST,
    ADD COLUMN `state_id` INTEGER AFTER `country_id`,
    ADD INDEX `fk_country_area_state_id_idx` (`state_id`);

/*
we create new countries (not visible) and link them to states
the migration will be done with the module migrateCountryState
*/

UPDATE `country` SET `visible` = 1 WHERE 1;

SELECT @max_id := IFNULL(MAX(`id`),0) FROM `country`;

INSERT INTO `country` (`visible`, `isocode`, `isoalpha2`, `isoalpha3`, `by_default`, `shop_country`, `has_states`, `need_zip_code`, `zip_code_format`, `created_at`, `updated_at`) VALUES
(0, '840', 'US', 'USA', 0, 0, '1', '1', 'NNNNN', NOW(), NOW()),
(0, '124', 'CA', 'CAN', 0, 0, '1', '1', 'LNL NLN', NOW(), NOW()),
(0, '32', 'AR', 'ARG', 0, 0, '1', '1', 'LNNNN', NOW(), NOW()),
(0, '360', 'ID', 'IDN', 0, 0, '1', '1', 'NNNNN', NOW(), NOW()),
(0, '380', 'IT', 'ITA', 0, 0, '1', '1', 'NNNNN', NOW(), NOW()),
(0, '392', 'JP', 'JPN', 0, 0, '1', '1', 'NNN-NNNN', NOW(), NOW()),
(0, '484', 'MX', 'MEX', 0, 0, '1', '1', 'NNNNN', NOW(), NOW())
;

INSERT INTO `country_i18n` (`id`, `locale`, `title`, `chapo`, `description`, `postscriptum`) VALUES
    (@max_id + 1, 'de_DE', NULL, NULL, NULL, NULL),
    (@max_id + 2, 'de_DE', NULL, NULL, NULL, NULL),
    (@max_id + 3, 'de_DE', 'Argentinien', NULL, NULL, NULL),
    (@max_id + 4, 'de_DE', 'Indonesien', NULL, NULL, NULL),
    (@max_id + 5, 'de_DE', 'Italien', NULL, NULL, NULL),
    (@max_id + 6, 'de_DE', 'Japan', NULL, NULL, NULL),
    (@max_id + 7, 'de_DE', 'Mexiko', NULL, NULL, NULL),
    (@max_id + 1, 'en_US', 'USA', NULL, NULL, NULL),
    (@max_id + 2, 'en_US', 'Canada', NULL, NULL, NULL),
    (@max_id + 3, 'en_US', 'Argentina', NULL, NULL, NULL),
    (@max_id + 4, 'en_US', 'Indonesia', NULL, NULL, NULL),
    (@max_id + 5, 'en_US', 'Italy', NULL, NULL, NULL),
    (@max_id + 6, 'en_US', 'Japan', NULL, NULL, NULL),
    (@max_id + 7, 'en_US', 'Mexico', NULL, NULL, NULL),
    (@max_id + 1, 'es_ES', NULL, NULL, NULL, NULL),
    (@max_id + 2, 'es_ES', NULL, NULL, NULL, NULL),
    (@max_id + 3, 'es_ES', 'Argentina', NULL, NULL, NULL),
    (@max_id + 4, 'es_ES', 'Indonesia', NULL, NULL, NULL),
    (@max_id + 5, 'es_ES', 'Italia', NULL, NULL, NULL),
    (@max_id + 6, 'es_ES', 'Japón', NULL, NULL, NULL),
    (@max_id + 7, 'es_ES', 'Méjico', NULL, NULL, NULL),
    (@max_id + 1, 'fr_FR', 'États-Unis', NULL, NULL, NULL),
    (@max_id + 2, 'fr_FR', 'Canada', NULL, NULL, NULL),
    (@max_id + 3, 'fr_FR', 'Argentine', NULL, NULL, NULL),
    (@max_id + 4, 'fr_FR', 'Indonésie', NULL, NULL, NULL),
    (@max_id + 5, 'fr_FR', 'Italie', NULL, NULL, NULL),
    (@max_id + 6, 'fr_FR', 'Japon', NULL, NULL, NULL),
    (@max_id + 7, 'fr_FR', 'Mexique', NULL, NULL, NULL)
;

INSERT INTO `state` (`id`, `visible`, `isocode`, `country_id`, `created_at`, `updated_at`) VALUES
(1, 1, 'AL', @max_id + 1, NOW(), NOW()),
(2, 1, 'AK', @max_id + 1, NOW(), NOW()),
(3, 1, 'AZ', @max_id + 1, NOW(), NOW()),
(4, 1, 'AR', @max_id + 1, NOW(), NOW()),
(5, 1, 'CA', @max_id + 1, NOW(), NOW()),
(6, 1, 'CO', @max_id + 1, NOW(), NOW()),
(7, 1, 'CT', @max_id + 1, NOW(), NOW()),
(8, 1, 'DE', @max_id + 1, NOW(), NOW()),
(9, 1, 'FL', @max_id + 1, NOW(), NOW()),
(10, 1, 'GA', @max_id + 1, NOW(), NOW()),
(11, 1, 'HI', @max_id + 1, NOW(), NOW()),
(12, 1, 'ID', @max_id + 1, NOW(), NOW()),
(13, 1, 'IL', @max_id + 1, NOW(), NOW()),
(14, 1, 'IN', @max_id + 1, NOW(), NOW()),
(15, 1, 'IA', @max_id + 1, NOW(), NOW()),
(16, 1, 'KS', @max_id + 1, NOW(), NOW()),
(17, 1, 'KY', @max_id + 1, NOW(), NOW()),
(18, 1, 'LA', @max_id + 1, NOW(), NOW()),
(19, 1, 'ME', @max_id + 1, NOW(), NOW()),
(20, 1, 'MD', @max_id + 1, NOW(), NOW()),
(21, 1, 'MA', @max_id + 1, NOW(), NOW()),
(22, 1, 'MI', @max_id + 1, NOW(), NOW()),
(23, 1, 'MN', @max_id + 1, NOW(), NOW()),
(24, 1, 'MS', @max_id + 1, NOW(), NOW()),
(25, 1, 'MO', @max_id + 1, NOW(), NOW()),
(26, 1, 'MT', @max_id + 1, NOW(), NOW()),
(27, 1, 'NE', @max_id + 1, NOW(), NOW()),
(28, 1, 'NV', @max_id + 1, NOW(), NOW()),
(29, 1, 'NH', @max_id + 1, NOW(), NOW()),
(30, 1, 'NJ', @max_id + 1, NOW(), NOW()),
(31, 1, 'NM', @max_id + 1, NOW(), NOW()),
(32, 1, 'NY', @max_id + 1, NOW(), NOW()),
(33, 1, 'NC', @max_id + 1, NOW(), NOW()),
(34, 1, 'ND', @max_id + 1, NOW(), NOW()),
(35, 1, 'OH', @max_id + 1, NOW(), NOW()),
(36, 1, 'OK', @max_id + 1, NOW(), NOW()),
(37, 1, 'OR', @max_id + 1, NOW(), NOW()),
(38, 1, 'PA', @max_id + 1, NOW(), NOW()),
(39, 1, 'RI', @max_id + 1, NOW(), NOW()),
(40, 1, 'SC', @max_id + 1, NOW(), NOW()),
(41, 1, 'SD', @max_id + 1, NOW(), NOW()),
(42, 1, 'TN', @max_id + 1, NOW(), NOW()),
(43, 1, 'TX', @max_id + 1, NOW(), NOW()),
(44, 1, 'UT', @max_id + 1, NOW(), NOW()),
(45, 1, 'VT', @max_id + 1, NOW(), NOW()),
(46, 1, 'VA', @max_id + 1, NOW(), NOW()),
(47, 1, 'WA', @max_id + 1, NOW(), NOW()),
(48, 1, 'WV', @max_id + 1, NOW(), NOW()),
(49, 1, 'WI', @max_id + 1, NOW(), NOW()),
(50, 1, 'WY', @max_id + 1, NOW(), NOW()),
(51, 1, 'PR', @max_id + 1, NOW(), NOW()),
(52, 1, 'VI', @max_id + 1, NOW(), NOW()),
(53, 1, 'DC', @max_id + 1, NOW(), NOW()),
(54, 1, 'AGS', @max_id + 7, NOW(), NOW()),
(55, 1, 'BCN', @max_id + 7, NOW(), NOW()),
(56, 1, 'BCS', @max_id + 7, NOW(), NOW()),
(57, 1, 'CAM', @max_id + 7, NOW(), NOW()),
(58, 1, 'CHP', @max_id + 7, NOW(), NOW()),
(59, 1, 'CHH', @max_id + 7, NOW(), NOW()),
(60, 1, 'COA', @max_id + 7, NOW(), NOW()),
(61, 1, 'COL', @max_id + 7, NOW(), NOW()),
(62, 1, 'DIF', @max_id + 7, NOW(), NOW()),
(63, 1, 'DUR', @max_id + 7, NOW(), NOW()),
(64, 1, 'GUA', @max_id + 7, NOW(), NOW()),
(65, 1, 'GRO', @max_id + 7, NOW(), NOW()),
(66, 1, 'HID', @max_id + 7, NOW(), NOW()),
(67, 1, 'JAL', @max_id + 7, NOW(), NOW()),
(68, 1, 'MEX', @max_id + 7, NOW(), NOW()),
(69, 1, 'MIC', @max_id + 7, NOW(), NOW()),
(70, 1, 'MOR', @max_id + 7, NOW(), NOW()),
(71, 1, 'NAY', @max_id + 7, NOW(), NOW()),
(72, 1, 'NLE', @max_id + 7, NOW(), NOW()),
(73, 1, 'OAX', @max_id + 7, NOW(), NOW()),
(74, 1, 'PUE', @max_id + 7, NOW(), NOW()),
(75, 1, 'QUE', @max_id + 7, NOW(), NOW()),
(76, 1, 'ROO', @max_id + 7, NOW(), NOW()),
(77, 1, 'SLP', @max_id + 7, NOW(), NOW()),
(78, 1, 'SIN', @max_id + 7, NOW(), NOW()),
(79, 1, 'SON', @max_id + 7, NOW(), NOW()),
(80, 1, 'TAB', @max_id + 7, NOW(), NOW()),
(81, 1, 'TAM', @max_id + 7, NOW(), NOW()),
(82, 1, 'TLA', @max_id + 7, NOW(), NOW()),
(83, 1, 'VER', @max_id + 7, NOW(), NOW()),
(84, 1, 'YUC', @max_id + 7, NOW(), NOW()),
(85, 1, 'ZAC', @max_id + 7, NOW(), NOW()),
(86, 1, 'ON', @max_id + 2, NOW(), NOW()),
(87, 1, 'QC', @max_id + 2, NOW(), NOW()),
(88, 1, 'BC', @max_id + 2, NOW(), NOW()),
(89, 1, 'AB', @max_id + 2, NOW(), NOW()),
(90, 1, 'MB', @max_id + 2, NOW(), NOW()),
(91, 1, 'SK', @max_id + 2, NOW(), NOW()),
(92, 1, 'NS', @max_id + 2, NOW(), NOW()),
(93, 1, 'NB', @max_id + 2, NOW(), NOW()),
(94, 1, 'NL', @max_id + 2, NOW(), NOW()),
(95, 1, 'PE', @max_id + 2, NOW(), NOW()),
(96, 1, 'NT', @max_id + 2, NOW(), NOW()),
(97, 1, 'YT', @max_id + 2, NOW(), NOW()),
(98, 1, 'NU', @max_id + 2, NOW(), NOW()),
(99, 1, 'B',  @max_id + 3, NOW(), NOW()),
(100, 1, 'K',  @max_id + 3, NOW(), NOW()),
(101, 1, 'H',  @max_id + 3, NOW(), NOW()),
(102, 1, 'U',  @max_id + 3, NOW(), NOW()),
(103, 1, 'C',  @max_id + 3, NOW(), NOW()),
(104, 1, 'X',  @max_id + 3, NOW(), NOW()),
(105, 1, 'W',  @max_id + 3, NOW(), NOW()),
(106, 1, 'E',  @max_id + 3, NOW(), NOW()),
(107, 1, 'P',  @max_id + 3, NOW(), NOW()),
(108, 1, 'Y',  @max_id + 3, NOW(), NOW()),
(109, 1, 'L',  @max_id + 3, NOW(), NOW()),
(110, 1, 'F',  @max_id + 3, NOW(), NOW()),
(111, 1, 'M',  @max_id + 3, NOW(), NOW()),
(112, 1, 'N',  @max_id + 3, NOW(), NOW()),
(113, 1, 'Q',  @max_id + 3, NOW(), NOW()),
(114, 1, 'R',  @max_id + 3, NOW(), NOW()),
(115, 1, 'A',  @max_id + 3, NOW(), NOW()),
(116, 1, 'J',  @max_id + 3, NOW(), NOW()),
(117, 1, 'D',  @max_id + 3, NOW(), NOW()),
(118, 1, 'Z',  @max_id + 3, NOW(), NOW()),
(119, 1, 'S',  @max_id + 3, NOW(), NOW()),
(120, 1, 'G',  @max_id + 3, NOW(), NOW()),
(121, 1, 'V',  @max_id + 3, NOW(), NOW()),
(122, 1, 'T',  @max_id + 3, NOW(), NOW()),
(123, 1, 'AG', @max_id + 5, NOW(), NOW()),
(124, 1, 'AL', @max_id + 5, NOW(), NOW()),
(125, 1, 'AN', @max_id + 5, NOW(), NOW()),
(126, 1, 'AO', @max_id + 5, NOW(), NOW()),
(127, 1, 'AR', @max_id + 5, NOW(), NOW()),
(128, 1, 'AP', @max_id + 5, NOW(), NOW()),
(129, 1, 'AT', @max_id + 5, NOW(), NOW()),
(130, 1, 'AV', @max_id + 5, NOW(), NOW()),
(131, 1, 'BA', @max_id + 5, NOW(), NOW()),
(132, 1, 'BT', @max_id + 5, NOW(), NOW()),
(133, 1, 'BL', @max_id + 5, NOW(), NOW()),
(134, 1, 'BN', @max_id + 5, NOW(), NOW()),
(135, 1, 'BG', @max_id + 5, NOW(), NOW()),
(136, 1, 'BI', @max_id + 5, NOW(), NOW()),
(137, 1, 'BO', @max_id + 5, NOW(), NOW()),
(138, 1, 'BZ', @max_id + 5, NOW(), NOW()),
(139, 1, 'BS', @max_id + 5, NOW(), NOW()),
(140, 1, 'BR', @max_id + 5, NOW(), NOW()),
(141, 1, 'CA', @max_id + 5, NOW(), NOW()),
(142, 1, 'CL', @max_id + 5, NOW(), NOW()),
(143, 1, 'CB', @max_id + 5, NOW(), NOW()),
(144, 1, 'CI', @max_id + 5, NOW(), NOW()),
(145, 1, 'CE', @max_id + 5, NOW(), NOW()),
(146, 1, 'CT', @max_id + 5, NOW(), NOW()),
(147, 1, 'CZ', @max_id + 5, NOW(), NOW()),
(148, 1, 'CH', @max_id + 5, NOW(), NOW()),
(149, 1, 'CO', @max_id + 5, NOW(), NOW()),
(150, 1, 'CS', @max_id + 5, NOW(), NOW()),
(151, 1, 'CR', @max_id + 5, NOW(), NOW()),
(152, 1, 'KR', @max_id + 5, NOW(), NOW()),
(153, 1, 'CN', @max_id + 5, NOW(), NOW()),
(154, 1, 'EN', @max_id + 5, NOW(), NOW()),
(155, 1, 'FM', @max_id + 5, NOW(), NOW()),
(156, 1, 'FE', @max_id + 5, NOW(), NOW()),
(157, 1, 'FI', @max_id + 5, NOW(), NOW()),
(158, 1, 'FG', @max_id + 5, NOW(), NOW()),
(159, 1, 'FC', @max_id + 5, NOW(), NOW()),
(160, 1, 'FR', @max_id + 5, NOW(), NOW()),
(161, 1, 'GE', @max_id + 5, NOW(), NOW()),
(162, 1, 'GO', @max_id + 5, NOW(), NOW()),
(163, 1, 'GR', @max_id + 5, NOW(), NOW()),
(164, 1, 'IM', @max_id + 5, NOW(), NOW()),
(165, 1, 'IS', @max_id + 5, NOW(), NOW()),
(166, 1, 'AQ', @max_id + 5, NOW(), NOW()),
(167, 1, 'SP', @max_id + 5, NOW(), NOW()),
(168, 1, 'LT', @max_id + 5, NOW(), NOW()),
(169, 1, 'LE', @max_id + 5, NOW(), NOW()),
(170, 1, 'LC', @max_id + 5, NOW(), NOW()),
(171, 1, 'LI', @max_id + 5, NOW(), NOW()),
(172, 1, 'LO', @max_id + 5, NOW(), NOW()),
(173, 1, 'LU', @max_id + 5, NOW(), NOW()),
(174, 1, 'MC', @max_id + 5, NOW(), NOW()),
(175, 1, 'MN', @max_id + 5, NOW(), NOW()),
(176, 1, 'MS', @max_id + 5, NOW(), NOW()),
(177, 1, 'MT', @max_id + 5, NOW(), NOW()),
(178, 1, 'VS', @max_id + 5, NOW(), NOW()),
(179, 1, 'ME', @max_id + 5, NOW(), NOW()),
(180, 1, 'MI', @max_id + 5, NOW(), NOW()),
(181, 1, 'MO', @max_id + 5, NOW(), NOW()),
(182, 1, 'MB', @max_id + 5, NOW(), NOW()),
(183, 1, 'NA', @max_id + 5, NOW(), NOW()),
(184, 1, 'NO', @max_id + 5, NOW(), NOW()),
(185, 1, 'NU', @max_id + 5, NOW(), NOW()),
(186, 1, 'OG', @max_id + 5, NOW(), NOW()),
(187, 1, 'OT', @max_id + 5, NOW(), NOW()),
(188, 1, 'OR', @max_id + 5, NOW(), NOW()),
(189, 1, 'PD', @max_id + 5, NOW(), NOW()),
(190, 1, 'PA', @max_id + 5, NOW(), NOW()),
(191, 1, 'PR', @max_id + 5, NOW(), NOW()),
(192, 1, 'PV', @max_id + 5, NOW(), NOW()),
(193, 1, 'PG', @max_id + 5, NOW(), NOW()),
(194, 1, 'PU', @max_id + 5, NOW(), NOW()),
(195, 1, 'PE', @max_id + 5, NOW(), NOW()),
(196, 1, 'PC', @max_id + 5, NOW(), NOW()),
(197, 1, 'PI', @max_id + 5, NOW(), NOW()),
(198, 1, 'PT', @max_id + 5, NOW(), NOW()),
(199, 1, 'PN', @max_id + 5, NOW(), NOW()),
(200, 1, 'PZ', @max_id + 5, NOW(), NOW()),
(201, 1, 'PO', @max_id + 5, NOW(), NOW()),
(202, 1, 'RG', @max_id + 5, NOW(), NOW()),
(203, 1, 'RA', @max_id + 5, NOW(), NOW()),
(204, 1, 'RC', @max_id + 5, NOW(), NOW()),
(205, 1, 'RE', @max_id + 5, NOW(), NOW()),
(206, 1, 'RI', @max_id + 5, NOW(), NOW()),
(207, 1, 'RN', @max_id + 5, NOW(), NOW()),
(208, 1, 'RM', @max_id + 5, NOW(), NOW()),
(209, 1, 'RO', @max_id + 5, NOW(), NOW()),
(210, 1, 'SA', @max_id + 5, NOW(), NOW()),
(211, 1, 'SS', @max_id + 5, NOW(), NOW()),
(212, 1, 'SV', @max_id + 5, NOW(), NOW()),
(213, 1, 'SI', @max_id + 5, NOW(), NOW()),
(214, 1, 'SR', @max_id + 5, NOW(), NOW()),
(215, 1, 'SO', @max_id + 5, NOW(), NOW()),
(216, 1, 'TA', @max_id + 5, NOW(), NOW()),
(217, 1, 'TE', @max_id + 5, NOW(), NOW()),
(218, 1, 'TR', @max_id + 5, NOW(), NOW()),
(219, 1, 'TO', @max_id + 5, NOW(), NOW()),
(220, 1, 'TP', @max_id + 5, NOW(), NOW()),
(221, 1, 'TN', @max_id + 5, NOW(), NOW()),
(222, 1, 'TV', @max_id + 5, NOW(), NOW()),
(223, 1, 'TS', @max_id + 5, NOW(), NOW()),
(224, 1, 'UD', @max_id + 5, NOW(), NOW()),
(225, 1, 'VA', @max_id + 5, NOW(), NOW()),
(226, 1, 'VE', @max_id + 5, NOW(), NOW()),
(227, 1, 'VB', @max_id + 5, NOW(), NOW()),
(228, 1, 'VC', @max_id + 5, NOW(), NOW()),
(229, 1, 'VR', @max_id + 5, NOW(), NOW()),
(230, 1, 'VV', @max_id + 5, NOW(), NOW()),
(231, 1, 'VI', @max_id + 5, NOW(), NOW()),
(232, 1, 'VT', @max_id + 5, NOW(), NOW()),
(233, 1, 'AC', @max_id + 4, NOW(), NOW()),
(234, 1, 'BA', @max_id + 4, NOW(), NOW()),
(235, 1, 'BB', @max_id + 4, NOW(), NOW()),
(236, 1, 'BT', @max_id + 4, NOW(), NOW()),
(237, 1, 'BE', @max_id + 4, NOW(), NOW()),
(238, 1, 'JT', @max_id + 4, NOW(), NOW()),
(239, 1, 'KT', @max_id + 4, NOW(), NOW()),
(240, 1, 'ST', @max_id + 4, NOW(), NOW()),
(241, 1, 'JI', @max_id + 4, NOW(), NOW()),
(242, 1, 'KI', @max_id + 4, NOW(), NOW()),
(243, 1, 'NT', @max_id + 4, NOW(), NOW()),
(244, 1, 'GO', @max_id + 4, NOW(), NOW()),
(245, 1, 'JK', @max_id + 4, NOW(), NOW()),
(246, 1, 'JA', @max_id + 4, NOW(), NOW()),
(247, 1, 'LA', @max_id + 4, NOW(), NOW()),
(248, 1, 'MA', @max_id + 4, NOW(), NOW()),
(249, 1, 'MU', @max_id + 4, NOW(), NOW()),
(250, 1, 'SA', @max_id + 4, NOW(), NOW()),
(251, 1, 'SU', @max_id + 4, NOW(), NOW()),
(252, 1, 'PA', @max_id + 4, NOW(), NOW()),
(253, 1, 'RI', @max_id + 4, NOW(), NOW()),
(254, 1, 'KR', @max_id + 4, NOW(), NOW()),
(255, 1, 'SG', @max_id + 4, NOW(), NOW()),
(256, 1, 'KS', @max_id + 4, NOW(), NOW()),
(257, 1, 'SN', @max_id + 4, NOW(), NOW()),
(258, 1, 'SS', @max_id + 4, NOW(), NOW()),
(259, 1, 'JB', @max_id + 4, NOW(), NOW()),
(260, 1, 'KB', @max_id + 4, NOW(), NOW()),
(261, 1, 'NB', @max_id + 4, NOW(), NOW()),
(262, 1, 'PB', @max_id + 4, NOW(), NOW()),
(263, 1, 'SR', @max_id + 4, NOW(), NOW()),
(264, 1, 'SB', @max_id + 4, NOW(), NOW()),
(265, 1, 'YO', @max_id + 4, NOW(), NOW()),
(266, 1, '23', @max_id + 6, NOW(), NOW()),
(267, 1, '05', @max_id + 6, NOW(), NOW()),
(268, 1, '02', @max_id + 6, NOW(), NOW()),
(269, 1, '12', @max_id + 6, NOW(), NOW()),
(270, 1, '38', @max_id + 6, NOW(), NOW()),
(271, 1, '18', @max_id + 6, NOW(), NOW()),
(272, 1, '40', @max_id + 6, NOW(), NOW()),
(273, 1, '07', @max_id + 6, NOW(), NOW()),
(274, 1, '21', @max_id + 6, NOW(), NOW()),
(275, 1, '10', @max_id + 6, NOW(), NOW()),
(276, 1, '34', @max_id + 6, NOW(), NOW()),
(277, 1, '01', @max_id + 6, NOW(), NOW()),
(278, 1, '28', @max_id + 6, NOW(), NOW()),
(279, 1, '08', @max_id + 6, NOW(), NOW()),
(280, 1, '17', @max_id + 6, NOW(), NOW()),
(281, 1, '03', @max_id + 6, NOW(), NOW()),
(282, 1, '37', @max_id + 6, NOW(), NOW()),
(283, 1, '46', @max_id + 6, NOW(), NOW()),
(284, 1, '14', @max_id + 6, NOW(), NOW()),
(285, 1, '39', @max_id + 6, NOW(), NOW()),
(286, 1, '43', @max_id + 6, NOW(), NOW()),
(287, 1, '26', @max_id + 6, NOW(), NOW()),
(288, 1, '24', @max_id + 6, NOW(), NOW()),
(289, 1, '04', @max_id + 6, NOW(), NOW()),
(290, 1, '45', @max_id + 6, NOW(), NOW()),
(291, 1, '20', @max_id + 6, NOW(), NOW()),
(292, 1, '42', @max_id + 6, NOW(), NOW()),
(293, 1, '29', @max_id + 6, NOW(), NOW()),
(294, 1, '15', @max_id + 6, NOW(), NOW()),
(295, 1, '44', @max_id + 6, NOW(), NOW()),
(296, 1, '33', @max_id + 6, NOW(), NOW()),
(297, 1, '47', @max_id + 6, NOW(), NOW()),
(298, 1, '27', @max_id + 6, NOW(), NOW()),
(299, 1, '41', @max_id + 6, NOW(), NOW()),
(300, 1, '11', @max_id + 6, NOW(), NOW()),
(301, 1, '25', @max_id + 6, NOW(), NOW()),
(302, 1, '32', @max_id + 6, NOW(), NOW()),
(303, 1, '22', @max_id + 6, NOW(), NOW()),
(304, 1, '09', @max_id + 6, NOW(), NOW()),
(305, 1, '36', @max_id + 6, NOW(), NOW()),
(306, 1, '13', @max_id + 6, NOW(), NOW()),
(307, 1, '31', @max_id + 6, NOW(), NOW()),
(308, 1, '16', @max_id + 6, NOW(), NOW()),
(309, 1, '30', @max_id + 6, NOW(), NOW()),
(310, 1, '06', @max_id + 6, NOW(), NOW()),
(311, 1, '35', @max_id + 6, NOW(), NOW()),
(312, 1, '19', @max_id + 6, NOW(), NOW()),
(313, 1, '', @max_id + 3, NOW(), NOW()),
(314, 1, '', @max_id + 4, NOW(), NOW()),
(315, 1, '', @max_id + 5, NOW(), NOW()),
(316, 1, '', @max_id + 6, NOW(), NOW()),
(317, 1, '', @max_id + 7, NOW(), NOW());


INSERT INTO `state_i18n` (`id`, `locale`, `title`) VALUES

    (1, 'de_DE', NULL),
    (2, 'de_DE', NULL),
    (3, 'de_DE', NULL),
    (4, 'de_DE', NULL),
    (5, 'de_DE', NULL),
    (6, 'de_DE', NULL),
    (7, 'de_DE', NULL),
    (8, 'de_DE', NULL),
    (9, 'de_DE', NULL),
    (10, 'de_DE', 'Georgien'),
    (11, 'de_DE', NULL),
    (12, 'de_DE', NULL),
    (13, 'de_DE', NULL),
    (14, 'de_DE', NULL),
    (15, 'de_DE', NULL),
    (16, 'de_DE', NULL),
    (17, 'de_DE', NULL),
    (18, 'de_DE', NULL),
    (19, 'de_DE', NULL),
    (20, 'de_DE', NULL),
    (21, 'de_DE', NULL),
    (22, 'de_DE', NULL),
    (23, 'de_DE', NULL),
    (24, 'de_DE', NULL),
    (25, 'de_DE', NULL),
    (26, 'de_DE', NULL),
    (27, 'de_DE', NULL),
    (28, 'de_DE', NULL),
    (29, 'de_DE', NULL),
    (30, 'de_DE', NULL),
    (31, 'de_DE', NULL),
    (32, 'de_DE', 'New York'),
    (33, 'de_DE', NULL),
    (34, 'de_DE', NULL),
    (35, 'de_DE', NULL),
    (36, 'de_DE', NULL),
    (37, 'de_DE', NULL),
    (38, 'de_DE', NULL),
    (39, 'de_DE', NULL),
    (40, 'de_DE', NULL),
    (41, 'de_DE', NULL),
    (42, 'de_DE', NULL),
    (43, 'de_DE', NULL),
    (44, 'de_DE', NULL),
    (45, 'de_DE', NULL),
    (46, 'de_DE', NULL),
    (47, 'de_DE', NULL),
    (48, 'de_DE', NULL),
    (49, 'de_DE', NULL),
    (50, 'de_DE', NULL),
    (51, 'de_DE', NULL),
    (52, 'de_DE', NULL),
    (53, 'de_DE', NULL),
    (54, 'de_DE', NULL),
    (55, 'de_DE', NULL),
    (56, 'de_DE', NULL),
    (57, 'de_DE', NULL),
    (58, 'de_DE', NULL),
    (59, 'de_DE', NULL),
    (60, 'de_DE', NULL),
    (61, 'de_DE', NULL),
    (62, 'de_DE', NULL),
    (63, 'de_DE', NULL),
    (64, 'de_DE', NULL),
    (65, 'de_DE', NULL),
    (66, 'de_DE', NULL),
    (67, 'de_DE', NULL),
    (68, 'de_DE', NULL),
    (69, 'de_DE', NULL),
    (70, 'de_DE', NULL),
    (71, 'de_DE', NULL),
    (72, 'de_DE', NULL),
    (73, 'de_DE', NULL),
    (74, 'de_DE', NULL),
    (75, 'de_DE', NULL),
    (76, 'de_DE', NULL),
    (77, 'de_DE', NULL),
    (78, 'de_DE', NULL),
    (79, 'de_DE', NULL),
    (80, 'de_DE', NULL),
    (81, 'de_DE', NULL),
    (82, 'de_DE', NULL),
    (83, 'de_DE', NULL),
    (84, 'de_DE', NULL),
    (85, 'de_DE', NULL),
    (86, 'de_DE', NULL),
    (87, 'de_DE', NULL),
    (88, 'de_DE', NULL),
    (89, 'de_DE', NULL),
    (90, 'de_DE', NULL),
    (91, 'de_DE', NULL),
    (92, 'de_DE', NULL),
    (93, 'de_DE', NULL),
    (94, 'de_DE', NULL),
    (95, 'de_DE', NULL),
    (96, 'de_DE', NULL),
    (97, 'de_DE', NULL),
    (98, 'de_DE', NULL),
    (99, 'de_DE', NULL),
    (100, 'de_DE', NULL),
    (101, 'de_DE', NULL),
    (102, 'de_DE', NULL),
    (103, 'de_DE', NULL),
    (104, 'de_DE', NULL),
    (105, 'de_DE', NULL),
    (106, 'de_DE', NULL),
    (107, 'de_DE', NULL),
    (108, 'de_DE', NULL),
    (109, 'de_DE', NULL),
    (110, 'de_DE', NULL),
    (111, 'de_DE', NULL),
    (112, 'de_DE', NULL),
    (113, 'de_DE', NULL),
    (114, 'de_DE', NULL),
    (115, 'de_DE', NULL),
    (116, 'de_DE', NULL),
    (117, 'de_DE', NULL),
    (118, 'de_DE', NULL),
    (119, 'de_DE', NULL),
    (120, 'de_DE', NULL),
    (121, 'de_DE', NULL),
    (122, 'de_DE', NULL),
    (123, 'de_DE', NULL),
    (124, 'de_DE', NULL),
    (125, 'de_DE', NULL),
    (126, 'de_DE', NULL),
    (127, 'de_DE', NULL),
    (128, 'de_DE', NULL),
    (129, 'de_DE', NULL),
    (130, 'de_DE', NULL),
    (131, 'de_DE', NULL),
    (132, 'de_DE', NULL),
    (133, 'de_DE', NULL),
    (134, 'de_DE', NULL),
    (135, 'de_DE', NULL),
    (136, 'de_DE', NULL),
    (137, 'de_DE', NULL),
    (138, 'de_DE', NULL),
    (139, 'de_DE', NULL),
    (140, 'de_DE', NULL),
    (141, 'de_DE', NULL),
    (142, 'de_DE', NULL),
    (143, 'de_DE', NULL),
    (144, 'de_DE', NULL),
    (145, 'de_DE', NULL),
    (146, 'de_DE', NULL),
    (147, 'de_DE', NULL),
    (148, 'de_DE', NULL),
    (149, 'de_DE', NULL),
    (150, 'de_DE', NULL),
    (151, 'de_DE', NULL),
    (152, 'de_DE', NULL),
    (153, 'de_DE', NULL),
    (154, 'de_DE', NULL),
    (155, 'de_DE', NULL),
    (156, 'de_DE', NULL),
    (157, 'de_DE', NULL),
    (158, 'de_DE', NULL),
    (159, 'de_DE', NULL),
    (160, 'de_DE', NULL),
    (161, 'de_DE', NULL),
    (162, 'de_DE', NULL),
    (163, 'de_DE', NULL),
    (164, 'de_DE', NULL),
    (165, 'de_DE', NULL),
    (166, 'de_DE', NULL),
    (167, 'de_DE', NULL),
    (168, 'de_DE', NULL),
    (169, 'de_DE', NULL),
    (170, 'de_DE', NULL),
    (171, 'de_DE', NULL),
    (172, 'de_DE', NULL),
    (173, 'de_DE', NULL),
    (174, 'de_DE', NULL),
    (175, 'de_DE', NULL),
    (176, 'de_DE', NULL),
    (177, 'de_DE', NULL),
    (178, 'de_DE', NULL),
    (179, 'de_DE', NULL),
    (180, 'de_DE', NULL),
    (181, 'de_DE', NULL),
    (182, 'de_DE', NULL),
    (183, 'de_DE', NULL),
    (184, 'de_DE', NULL),
    (185, 'de_DE', NULL),
    (186, 'de_DE', NULL),
    (187, 'de_DE', NULL),
    (188, 'de_DE', NULL),
    (189, 'de_DE', NULL),
    (190, 'de_DE', NULL),
    (191, 'de_DE', NULL),
    (192, 'de_DE', NULL),
    (193, 'de_DE', NULL),
    (194, 'de_DE', NULL),
    (195, 'de_DE', NULL),
    (196, 'de_DE', NULL),
    (197, 'de_DE', NULL),
    (198, 'de_DE', NULL),
    (199, 'de_DE', NULL),
    (200, 'de_DE', NULL),
    (201, 'de_DE', NULL),
    (202, 'de_DE', NULL),
    (203, 'de_DE', NULL),
    (204, 'de_DE', NULL),
    (205, 'de_DE', NULL),
    (206, 'de_DE', NULL),
    (207, 'de_DE', NULL),
    (208, 'de_DE', NULL),
    (209, 'de_DE', NULL),
    (210, 'de_DE', NULL),
    (211, 'de_DE', NULL),
    (212, 'de_DE', NULL),
    (213, 'de_DE', NULL),
    (214, 'de_DE', NULL),
    (215, 'de_DE', NULL),
    (216, 'de_DE', NULL),
    (217, 'de_DE', NULL),
    (218, 'de_DE', NULL),
    (219, 'de_DE', NULL),
    (220, 'de_DE', NULL),
    (221, 'de_DE', NULL),
    (222, 'de_DE', NULL),
    (223, 'de_DE', NULL),
    (224, 'de_DE', NULL),
    (225, 'de_DE', NULL),
    (226, 'de_DE', NULL),
    (227, 'de_DE', NULL),
    (228, 'de_DE', NULL),
    (229, 'de_DE', NULL),
    (230, 'de_DE', NULL),
    (231, 'de_DE', NULL),
    (232, 'de_DE', NULL),
    (233, 'de_DE', NULL),
    (234, 'de_DE', NULL),
    (235, 'de_DE', NULL),
    (236, 'de_DE', NULL),
    (237, 'de_DE', NULL),
    (238, 'de_DE', NULL),
    (239, 'de_DE', NULL),
    (240, 'de_DE', NULL),
    (241, 'de_DE', NULL),
    (242, 'de_DE', NULL),
    (243, 'de_DE', NULL),
    (244, 'de_DE', NULL),
    (245, 'de_DE', NULL),
    (246, 'de_DE', NULL),
    (247, 'de_DE', NULL),
    (248, 'de_DE', NULL),
    (249, 'de_DE', NULL),
    (250, 'de_DE', NULL),
    (251, 'de_DE', NULL),
    (252, 'de_DE', NULL),
    (253, 'de_DE', NULL),
    (254, 'de_DE', NULL),
    (255, 'de_DE', NULL),
    (256, 'de_DE', NULL),
    (257, 'de_DE', NULL),
    (258, 'de_DE', NULL),
    (259, 'de_DE', NULL),
    (260, 'de_DE', NULL),
    (261, 'de_DE', NULL),
    (262, 'de_DE', NULL),
    (263, 'de_DE', NULL),
    (264, 'de_DE', NULL),
    (265, 'de_DE', NULL),
    (266, 'de_DE', NULL),
    (267, 'de_DE', NULL),
    (268, 'de_DE', NULL),
    (269, 'de_DE', NULL),
    (270, 'de_DE', NULL),
    (271, 'de_DE', NULL),
    (272, 'de_DE', NULL),
    (273, 'de_DE', NULL),
    (274, 'de_DE', NULL),
    (275, 'de_DE', NULL),
    (276, 'de_DE', NULL),
    (277, 'de_DE', NULL),
    (278, 'de_DE', NULL),
    (279, 'de_DE', NULL),
    (280, 'de_DE', NULL),
    (281, 'de_DE', NULL),
    (282, 'de_DE', NULL),
    (283, 'de_DE', NULL),
    (284, 'de_DE', NULL),
    (285, 'de_DE', NULL),
    (286, 'de_DE', NULL),
    (287, 'de_DE', NULL),
    (288, 'de_DE', NULL),
    (289, 'de_DE', NULL),
    (290, 'de_DE', NULL),
    (291, 'de_DE', NULL),
    (292, 'de_DE', NULL),
    (293, 'de_DE', NULL),
    (294, 'de_DE', NULL),
    (295, 'de_DE', NULL),
    (296, 'de_DE', NULL),
    (297, 'de_DE', NULL),
    (298, 'de_DE', NULL),
    (299, 'de_DE', NULL),
    (300, 'de_DE', NULL),
    (301, 'de_DE', NULL),
    (302, 'de_DE', NULL),
    (303, 'de_DE', NULL),
    (304, 'de_DE', NULL),
    (305, 'de_DE', NULL),
    (306, 'de_DE', NULL),
    (307, 'de_DE', NULL),
    (308, 'de_DE', NULL),
    (309, 'de_DE', NULL),
    (310, 'de_DE', NULL),
    (311, 'de_DE', NULL),
    (312, 'de_DE', NULL),
    (313, 'de_DE', ''),
    (314, 'de_DE', ''),
    (315, 'de_DE', ''),
    (316, 'de_DE', ''),
    (317, 'de_DE', ''),

    (1, 'en_US', 'Alabama'),
    (2, 'en_US', 'Alaska'),
    (3, 'en_US', 'Arizona'),
    (4, 'en_US', 'Arkansas'),
    (5, 'en_US', 'California'),
    (6, 'en_US', 'Colorado'),
    (7, 'en_US', 'Connecticut'),
    (8, 'en_US', 'Delaware'),
    (9, 'en_US', 'Florida'),
    (10, 'en_US', 'Georgia'),
    (11, 'en_US', 'Hawaii'),
    (12, 'en_US', 'Idaho'),
    (13, 'en_US', 'Illinois'),
    (14, 'en_US', 'Indiana'),
    (15, 'en_US', 'Iowa'),
    (16, 'en_US', 'Kansas'),
    (17, 'en_US', 'Kentucky'),
    (18, 'en_US', 'Louisiana'),
    (19, 'en_US', 'Maine'),
    (20, 'en_US', 'Maryland'),
    (21, 'en_US', 'Massachusetts'),
    (22, 'en_US', 'Michigan'),
    (23, 'en_US', 'Minnesota'),
    (24, 'en_US', 'Mississippi'),
    (25, 'en_US', 'Missouri'),
    (26, 'en_US', 'Montana'),
    (27, 'en_US', 'Nebraska'),
    (28, 'en_US', 'Nevada'),
    (29, 'en_US', 'New Hampshire'),
    (30, 'en_US', 'New Jersey'),
    (31, 'en_US', 'New Mexico'),
    (32, 'en_US', 'New York'),
    (33, 'en_US', 'North Carolina'),
    (34, 'en_US', 'North Dakota'),
    (35, 'en_US', 'Ohio'),
    (36, 'en_US', 'Oklahoma'),
    (37, 'en_US', 'Oregon'),
    (38, 'en_US', 'Pennsylvania'),
    (39, 'en_US', 'Rhode Island'),
    (40, 'en_US', 'South Carolina'),
    (41, 'en_US', 'South Dakota'),
    (42, 'en_US', 'Tennessee'),
    (43, 'en_US', 'Texas'),
    (44, 'en_US', 'Utah'),
    (45, 'en_US', 'Vermont'),
    (46, 'en_US', 'Virginia'),
    (47, 'en_US', 'Washington'),
    (48, 'en_US', 'West Virginia'),
    (49, 'en_US', 'Wisconsin'),
    (50, 'en_US', 'Wyoming'),
    (51, 'en_US', 'Puerto Rico'),
    (52, 'en_US', 'US Virgin Islands'),
    (53, 'en_US', 'District of Columbia'),
    (54, 'en_US', 'Aguascalientes'),
    (55, 'en_US', 'Baja California'),
    (56, 'en_US', 'Baja California Sur'),
    (57, 'en_US', 'Campeche'),
    (58, 'en_US', 'Chiapas'),
    (59, 'en_US', 'Chihuahua'),
    (60, 'en_US', 'Coahuila'),
    (61, 'en_US', 'Colima'),
    (62, 'en_US', 'Distrito Federal'),
    (63, 'en_US', 'Durango'),
    (64, 'en_US', 'Guanajuato'),
    (65, 'en_US', 'Guerrero'),
    (66, 'en_US', 'Hidalgo'),
    (67, 'en_US', 'Jalisco'),
    (68, 'en_US', 'Estado de México'),
    (69, 'en_US', 'Michoacán'),
    (70, 'en_US', 'Morelos'),
    (71, 'en_US', 'Nayarit'),
    (72, 'en_US', 'Nuevo León'),
    (73, 'en_US', 'Oaxaca'),
    (74, 'en_US', 'Puebla'),
    (75, 'en_US', 'Querétaro'),
    (76, 'en_US', 'Quintana Roo'),
    (77, 'en_US', 'San Luis Potosí'),
    (78, 'en_US', 'Sinaloa'),
    (79, 'en_US', 'Sonora'),
    (80, 'en_US', 'Tabasco'),
    (81, 'en_US', 'Tamaulipas'),
    (82, 'en_US', 'Tlaxcala'),
    (83, 'en_US', 'Veracruz'),
    (84, 'en_US', 'Yucatán'),
    (85, 'en_US', 'Zacatecas'),
    (86, 'en_US', 'Ontario'),
    (87, 'en_US', 'Quebec'),
    (88, 'en_US', 'British Columbia'),
    (89, 'en_US', 'Alberta'),
    (90, 'en_US', 'Manitoba'),
    (91, 'en_US', 'Saskatchewan'),
    (92, 'en_US', 'Nova Scotia'),
    (93, 'en_US', 'New Brunswick'),
    (94, 'en_US', 'Newfoundland and Labrador'),
    (95, 'en_US', 'Prince Edward Island'),
    (96, 'en_US', 'Northwest Territories'),
    (97, 'en_US', 'Yukon'),
    (98, 'en_US', 'Nunavut'),
    (99, 'en_US', 'Buenos Aires'),
    (100, 'en_US', 'Catamarca'),
    (101, 'en_US', 'Chaco'),
    (102, 'en_US', 'Chubut'),
    (103, 'en_US', 'Ciudad de Buenos Aires'),
    (104, 'en_US', 'Córdoba'),
    (105, 'en_US', 'Corrientes'),
    (106, 'en_US', 'Entre Ríos'),
    (107, 'en_US', 'Formosa'),
    (108, 'en_US', 'Jujuy'),
    (109, 'en_US', 'La Pampa'),
    (110, 'en_US', 'La Rioja'),
    (111, 'en_US', 'Mendoza'),
    (112, 'en_US', 'Misiones'),
    (113, 'en_US', 'Neuquén'),
    (114, 'en_US', 'Río Negro'),
    (115, 'en_US', 'Salta'),
    (116, 'en_US', 'San Juan'),
    (117, 'en_US', 'San Luis'),
    (118, 'en_US', 'Santa Cruz'),
    (119, 'en_US', 'Santa Fe'),
    (120, 'en_US', 'Santiago del Estero'),
    (121, 'en_US', 'Tierra del Fuego'),
    (122, 'en_US', 'Tucumán'),
    (123, 'en_US', 'Agrigento'),
    (124, 'en_US', 'Alessandria'),
    (125, 'en_US', 'Ancona'),
    (126, 'en_US', 'Aosta'),
    (127, 'en_US', 'Arezzo'),
    (128, 'en_US', 'Ascoli Piceno'),
    (129, 'en_US', 'Asti'),
    (130, 'en_US', 'Avellino'),
    (131, 'en_US', 'Bari'),
    (132, 'en_US', 'Barletta-Andria-Trani'),
    (133, 'en_US', 'Belluno'),
    (134, 'en_US', 'Benevento'),
    (135, 'en_US', 'Bergamo'),
    (136, 'en_US', 'Biella'),
    (137, 'en_US', 'Bologna'),
    (138, 'en_US', 'Bolzano'),
    (139, 'en_US', 'Brescia'),
    (140, 'en_US', 'Brindisi'),
    (141, 'en_US', 'Cagliari'),
    (142, 'en_US', 'Caltanissetta'),
    (143, 'en_US', 'Campobasso'),
    (144, 'en_US', 'Carbonia-Iglesias'),
    (145, 'en_US', 'Caserta'),
    (146, 'en_US', 'Catania'),
    (147, 'en_US', 'Catanzaro'),
    (148, 'en_US', 'Chieti'),
    (149, 'en_US', 'Como'),
    (150, 'en_US', 'Cosenza'),
    (151, 'en_US', 'Cremona'),
    (152, 'en_US', 'Crotone'),
    (153, 'en_US', 'Cuneo'),
    (154, 'en_US', 'Enna'),
    (155, 'en_US', 'Fermo'),
    (156, 'en_US', 'Ferrara'),
    (157, 'en_US', 'Firenze'),
    (158, 'en_US', 'Foggia'),
    (159, 'en_US', 'Forlì-Cesena'),
    (160, 'en_US', 'Frosinone'),
    (161, 'en_US', 'Genova'),
    (162, 'en_US', 'Gorizia'),
    (163, 'en_US', 'Grosseto'),
    (164, 'en_US', 'Imperia'),
    (165, 'en_US', 'Isernia'),
    (166, 'en_US', 'L\'Aquila'),
    (167, 'en_US', 'La Spezia'),
    (168, 'en_US', 'Latina'),
    (169, 'en_US', 'Lecce'),
    (170, 'en_US', 'Lecco'),
    (171, 'en_US', 'Livorno'),
    (172, 'en_US', 'Lodi'),
    (173, 'en_US', 'Lucca'),
    (174, 'en_US', 'Macerata'),
    (175, 'en_US', 'Mantova'),
    (176, 'en_US', 'Massa'),
    (177, 'en_US', 'Matera'),
    (178, 'en_US', 'Medio Campidano'),
    (179, 'en_US', 'Messina'),
    (180, 'en_US', 'Milano'),
    (181, 'en_US', 'Modena'),
    (182, 'en_US', 'Monza e della Brianza'),
    (183, 'en_US', 'Napoli'),
    (184, 'en_US', 'Novara'),
    (185, 'en_US', 'Nuoro'),
    (186, 'en_US', 'Ogliastra'),
    (187, 'en_US', 'Olbia-Tempio'),
    (188, 'en_US', 'Oristano'),
    (189, 'en_US', 'Padova'),
    (190, 'en_US', 'Palermo'),
    (191, 'en_US', 'Parma'),
    (192, 'en_US', 'Pavia'),
    (193, 'en_US', 'Perugia'),
    (194, 'en_US', 'Pesaro-Urbino'),
    (195, 'en_US', 'Pescara'),
    (196, 'en_US', 'Piacenza'),
    (197, 'en_US', 'Pisa'),
    (198, 'en_US', 'Pistoia'),
    (199, 'en_US', 'Pordenone'),
    (200, 'en_US', 'Potenza'),
    (201, 'en_US', 'Prato'),
    (202, 'en_US', 'Ragusa'),
    (203, 'en_US', 'Ravenna'),
    (204, 'en_US', 'Reggio Calabria'),
    (205, 'en_US', 'Reggio Emilia'),
    (206, 'en_US', 'Rieti'),
    (207, 'en_US', 'Rimini'),
    (208, 'en_US', 'Roma'),
    (209, 'en_US', 'Rovigo'),
    (210, 'en_US', 'Salerno'),
    (211, 'en_US', 'Sassari'),
    (212, 'en_US', 'Savona'),
    (213, 'en_US', 'Siena'),
    (214, 'en_US', 'Siracusa'),
    (215, 'en_US', 'Sondrio'),
    (216, 'en_US', 'Taranto'),
    (217, 'en_US', 'Teramo'),
    (218, 'en_US', 'Terni'),
    (219, 'en_US', 'Torino'),
    (220, 'en_US', 'Trapani'),
    (221, 'en_US', 'Trento'),
    (222, 'en_US', 'Treviso'),
    (223, 'en_US', 'Trieste'),
    (224, 'en_US', 'Udine'),
    (225, 'en_US', 'Varese'),
    (226, 'en_US', 'Venezia'),
    (227, 'en_US', 'Verbano-Cusio-Ossola'),
    (228, 'en_US', 'Vercelli'),
    (229, 'en_US', 'Verona'),
    (230, 'en_US', 'Vibo Valentia'),
    (231, 'en_US', 'Vicenza'),
    (232, 'en_US', 'Viterbo'),
    (233, 'en_US', 'Aceh'),
    (234, 'en_US', 'Bali'),
    (235, 'en_US', 'Bangka'),
    (236, 'en_US', 'Banten'),
    (237, 'en_US', 'Bengkulu'),
    (238, 'en_US', 'Central Java'),
    (239, 'en_US', 'Central Kalimantan'),
    (240, 'en_US', 'Central Sulawesi'),
    (241, 'en_US', 'Coat of arms of East Java'),
    (242, 'en_US', 'East kalimantan'),
    (243, 'en_US', 'East Nusa Tenggara'),
    (244, 'en_US', 'Lambang propinsi'),
    (245, 'en_US', 'Jakarta'),
    (246, 'en_US', 'Jambi'),
    (247, 'en_US', 'Lampung'),
    (248, 'en_US', 'Maluku'),
    (249, 'en_US', 'North Maluku'),
    (250, 'en_US', 'North Sulawesi'),
    (251, 'en_US', 'North Sumatra'),
    (252, 'en_US', 'Papua'),
    (253, 'en_US', 'Riau'),
    (254, 'en_US', 'Lambang Riau'),
    (255, 'en_US', 'Southeast Sulawesi'),
    (256, 'en_US', 'South Kalimantan'),
    (257, 'en_US', 'South Sulawesi'),
    (258, 'en_US', 'South Sumatra'),
    (259, 'en_US', 'West Java'),
    (260, 'en_US', 'West Kalimantan'),
    (261, 'en_US', 'West Nusa Tenggara'),
    (262, 'en_US', 'Lambang Provinsi Papua Barat'),
    (263, 'en_US', 'West Sulawesi'),
    (264, 'en_US', 'West Sumatra'),
    (265, 'en_US', 'Yogyakarta'),
    (266, 'en_US', 'Aichi'),
    (267, 'en_US', 'Akita'),
    (268, 'en_US', 'Aomori'),
    (269, 'en_US', 'Chiba'),
    (270, 'en_US', 'Ehime'),
    (271, 'en_US', 'Fukui'),
    (272, 'en_US', 'Fukuoka'),
    (273, 'en_US', 'Fukushima'),
    (274, 'en_US', 'Gifu'),
    (275, 'en_US', 'Gunma'),
    (276, 'en_US', 'Hiroshima'),
    (277, 'en_US', 'Hokkaido'),
    (278, 'en_US', 'Hyogo'),
    (279, 'en_US', 'Ibaraki'),
    (280, 'en_US', 'Ishikawa'),
    (281, 'en_US', 'Iwate'),
    (282, 'en_US', 'Kagawa'),
    (283, 'en_US', 'Kagoshima'),
    (284, 'en_US', 'Kanagawa'),
    (285, 'en_US', 'Kochi'),
    (286, 'en_US', 'Kumamoto'),
    (287, 'en_US', 'Kyoto'),
    (288, 'en_US', 'Mie'),
    (289, 'en_US', 'Miyagi'),
    (290, 'en_US', 'Miyazaki'),
    (291, 'en_US', 'Nagano'),
    (292, 'en_US', 'Nagasaki'),
    (293, 'en_US', 'Nara'),
    (294, 'en_US', 'Niigata'),
    (295, 'en_US', 'Oita'),
    (296, 'en_US', 'Okayama'),
    (297, 'en_US', 'Okinawa'),
    (298, 'en_US', 'Osaka'),
    (299, 'en_US', 'Saga'),
    (300, 'en_US', 'Saitama'),
    (301, 'en_US', 'Shiga'),
    (302, 'en_US', 'Shimane'),
    (303, 'en_US', 'Shizuoka'),
    (304, 'en_US', 'Tochigi'),
    (305, 'en_US', 'Tokushima'),
    (306, 'en_US', 'Tokyo'),
    (307, 'en_US', 'Tottori'),
    (308, 'en_US', 'Toyama'),
    (309, 'en_US', 'Wakayama'),
    (310, 'en_US', 'Yamagata'),
    (311, 'en_US', 'Yamaguchi'),
    (312, 'en_US', 'Yamanashi'),
    (313, 'en_US', ''),
    (314, 'en_US', ''),
    (315, 'en_US', ''),
    (316, 'en_US', ''),
    (317, 'en_US', ''),

    (1, 'es_ES', NULL),
    (2, 'es_ES', NULL),
    (3, 'es_ES', NULL),
    (4, 'es_ES', NULL),
    (5, 'es_ES', NULL),
    (6, 'es_ES', NULL),
    (7, 'es_ES', NULL),
    (8, 'es_ES', NULL),
    (9, 'es_ES', NULL),
    (10, 'es_ES', 'Georgia'),
    (11, 'es_ES', NULL),
    (12, 'es_ES', NULL),
    (13, 'es_ES', NULL),
    (14, 'es_ES', NULL),
    (15, 'es_ES', NULL),
    (16, 'es_ES', NULL),
    (17, 'es_ES', NULL),
    (18, 'es_ES', NULL),
    (19, 'es_ES', NULL),
    (20, 'es_ES', NULL),
    (21, 'es_ES', NULL),
    (22, 'es_ES', NULL),
    (23, 'es_ES', NULL),
    (24, 'es_ES', NULL),
    (25, 'es_ES', NULL),
    (26, 'es_ES', NULL),
    (27, 'es_ES', NULL),
    (28, 'es_ES', NULL),
    (29, 'es_ES', NULL),
    (30, 'es_ES', NULL),
    (31, 'es_ES', NULL),
    (32, 'es_ES', 'Nueva York'),
    (33, 'es_ES', NULL),
    (34, 'es_ES', NULL),
    (35, 'es_ES', NULL),
    (36, 'es_ES', NULL),
    (37, 'es_ES', NULL),
    (38, 'es_ES', NULL),
    (39, 'es_ES', NULL),
    (40, 'es_ES', NULL),
    (41, 'es_ES', NULL),
    (42, 'es_ES', NULL),
    (43, 'es_ES', NULL),
    (44, 'es_ES', NULL),
    (45, 'es_ES', NULL),
    (46, 'es_ES', NULL),
    (47, 'es_ES', NULL),
    (48, 'es_ES', NULL),
    (49, 'es_ES', NULL),
    (50, 'es_ES', NULL),
    (51, 'es_ES', NULL),
    (52, 'es_ES', NULL),
    (53, 'es_ES', NULL),
    (54, 'es_ES', NULL),
    (55, 'es_ES', NULL),
    (56, 'es_ES', NULL),
    (57, 'es_ES', NULL),
    (58, 'es_ES', NULL),
    (59, 'es_ES', NULL),
    (60, 'es_ES', NULL),
    (61, 'es_ES', NULL),
    (62, 'es_ES', 'Ciudad de México'),
    (63, 'es_ES', NULL),
    (64, 'es_ES', NULL),
    (65, 'es_ES', NULL),
    (66, 'es_ES', NULL),
    (67, 'es_ES', NULL),
    (68, 'es_ES', NULL),
    (69, 'es_ES', NULL),
    (70, 'es_ES', NULL),
    (71, 'es_ES', NULL),
    (72, 'es_ES', NULL),
    (73, 'es_ES', NULL),
    (74, 'es_ES', NULL),
    (75, 'es_ES', NULL),
    (76, 'es_ES', NULL),
    (77, 'es_ES', NULL),
    (78, 'es_ES', NULL),
    (79, 'es_ES', NULL),
    (80, 'es_ES', NULL),
    (81, 'es_ES', NULL),
    (82, 'es_ES', NULL),
    (83, 'es_ES', NULL),
    (84, 'es_ES', NULL),
    (85, 'es_ES', NULL),
    (86, 'es_ES', NULL),
    (87, 'es_ES', NULL),
    (88, 'es_ES', NULL),
    (89, 'es_ES', NULL),
    (90, 'es_ES', NULL),
    (91, 'es_ES', NULL),
    (92, 'es_ES', NULL),
    (93, 'es_ES', NULL),
    (94, 'es_ES', NULL),
    (95, 'es_ES', NULL),
    (96, 'es_ES', NULL),
    (97, 'es_ES', NULL),
    (98, 'es_ES', NULL),
    (99, 'es_ES', NULL),
    (100, 'es_ES', NULL),
    (101, 'es_ES', NULL),
    (102, 'es_ES', NULL),
    (103, 'es_ES', NULL),
    (104, 'es_ES', NULL),
    (105, 'es_ES', NULL),
    (106, 'es_ES', NULL),
    (107, 'es_ES', NULL),
    (108, 'es_ES', NULL),
    (109, 'es_ES', NULL),
    (110, 'es_ES', NULL),
    (111, 'es_ES', NULL),
    (112, 'es_ES', NULL),
    (113, 'es_ES', NULL),
    (114, 'es_ES', NULL),
    (115, 'es_ES', NULL),
    (116, 'es_ES', NULL),
    (117, 'es_ES', NULL),
    (118, 'es_ES', NULL),
    (119, 'es_ES', NULL),
    (120, 'es_ES', NULL),
    (121, 'es_ES', NULL),
    (122, 'es_ES', NULL),
    (123, 'es_ES', NULL),
    (124, 'es_ES', NULL),
    (125, 'es_ES', NULL),
    (126, 'es_ES', NULL),
    (127, 'es_ES', NULL),
    (128, 'es_ES', NULL),
    (129, 'es_ES', NULL),
    (130, 'es_ES', NULL),
    (131, 'es_ES', NULL),
    (132, 'es_ES', NULL),
    (133, 'es_ES', NULL),
    (134, 'es_ES', NULL),
    (135, 'es_ES', NULL),
    (136, 'es_ES', NULL),
    (137, 'es_ES', NULL),
    (138, 'es_ES', NULL),
    (139, 'es_ES', NULL),
    (140, 'es_ES', NULL),
    (141, 'es_ES', NULL),
    (142, 'es_ES', NULL),
    (143, 'es_ES', NULL),
    (144, 'es_ES', NULL),
    (145, 'es_ES', NULL),
    (146, 'es_ES', NULL),
    (147, 'es_ES', NULL),
    (148, 'es_ES', NULL),
    (149, 'es_ES', NULL),
    (150, 'es_ES', NULL),
    (151, 'es_ES', NULL),
    (152, 'es_ES', NULL),
    (153, 'es_ES', NULL),
    (154, 'es_ES', NULL),
    (155, 'es_ES', NULL),
    (156, 'es_ES', NULL),
    (157, 'es_ES', NULL),
    (158, 'es_ES', NULL),
    (159, 'es_ES', NULL),
    (160, 'es_ES', NULL),
    (161, 'es_ES', NULL),
    (162, 'es_ES', NULL),
    (163, 'es_ES', NULL),
    (164, 'es_ES', NULL),
    (165, 'es_ES', NULL),
    (166, 'es_ES', NULL),
    (167, 'es_ES', NULL),
    (168, 'es_ES', NULL),
    (169, 'es_ES', NULL),
    (170, 'es_ES', NULL),
    (171, 'es_ES', NULL),
    (172, 'es_ES', NULL),
    (173, 'es_ES', NULL),
    (174, 'es_ES', NULL),
    (175, 'es_ES', NULL),
    (176, 'es_ES', NULL),
    (177, 'es_ES', NULL),
    (178, 'es_ES', NULL),
    (179, 'es_ES', NULL),
    (180, 'es_ES', NULL),
    (181, 'es_ES', NULL),
    (182, 'es_ES', NULL),
    (183, 'es_ES', NULL),
    (184, 'es_ES', NULL),
    (185, 'es_ES', NULL),
    (186, 'es_ES', NULL),
    (187, 'es_ES', NULL),
    (188, 'es_ES', NULL),
    (189, 'es_ES', NULL),
    (190, 'es_ES', NULL),
    (191, 'es_ES', NULL),
    (192, 'es_ES', NULL),
    (193, 'es_ES', NULL),
    (194, 'es_ES', NULL),
    (195, 'es_ES', NULL),
    (196, 'es_ES', NULL),
    (197, 'es_ES', NULL),
    (198, 'es_ES', NULL),
    (199, 'es_ES', NULL),
    (200, 'es_ES', NULL),
    (201, 'es_ES', NULL),
    (202, 'es_ES', NULL),
    (203, 'es_ES', NULL),
    (204, 'es_ES', NULL),
    (205, 'es_ES', NULL),
    (206, 'es_ES', NULL),
    (207, 'es_ES', NULL),
    (208, 'es_ES', NULL),
    (209, 'es_ES', NULL),
    (210, 'es_ES', NULL),
    (211, 'es_ES', NULL),
    (212, 'es_ES', NULL),
    (213, 'es_ES', NULL),
    (214, 'es_ES', NULL),
    (215, 'es_ES', NULL),
    (216, 'es_ES', NULL),
    (217, 'es_ES', NULL),
    (218, 'es_ES', NULL),
    (219, 'es_ES', NULL),
    (220, 'es_ES', NULL),
    (221, 'es_ES', NULL),
    (222, 'es_ES', NULL),
    (223, 'es_ES', NULL),
    (224, 'es_ES', NULL),
    (225, 'es_ES', NULL),
    (226, 'es_ES', NULL),
    (227, 'es_ES', NULL),
    (228, 'es_ES', NULL),
    (229, 'es_ES', NULL),
    (230, 'es_ES', NULL),
    (231, 'es_ES', NULL),
    (232, 'es_ES', NULL),
    (233, 'es_ES', NULL),
    (234, 'es_ES', NULL),
    (235, 'es_ES', NULL),
    (236, 'es_ES', NULL),
    (237, 'es_ES', NULL),
    (238, 'es_ES', NULL),
    (239, 'es_ES', NULL),
    (240, 'es_ES', NULL),
    (241, 'es_ES', NULL),
    (242, 'es_ES', NULL),
    (243, 'es_ES', NULL),
    (244, 'es_ES', NULL),
    (245, 'es_ES', NULL),
    (246, 'es_ES', NULL),
    (247, 'es_ES', NULL),
    (248, 'es_ES', NULL),
    (249, 'es_ES', NULL),
    (250, 'es_ES', NULL),
    (251, 'es_ES', NULL),
    (252, 'es_ES', NULL),
    (253, 'es_ES', NULL),
    (254, 'es_ES', NULL),
    (255, 'es_ES', NULL),
    (256, 'es_ES', NULL),
    (257, 'es_ES', NULL),
    (258, 'es_ES', NULL),
    (259, 'es_ES', NULL),
    (260, 'es_ES', NULL),
    (261, 'es_ES', NULL),
    (262, 'es_ES', NULL),
    (263, 'es_ES', NULL),
    (264, 'es_ES', NULL),
    (265, 'es_ES', NULL),
    (266, 'es_ES', NULL),
    (267, 'es_ES', NULL),
    (268, 'es_ES', NULL),
    (269, 'es_ES', NULL),
    (270, 'es_ES', NULL),
    (271, 'es_ES', NULL),
    (272, 'es_ES', NULL),
    (273, 'es_ES', NULL),
    (274, 'es_ES', NULL),
    (275, 'es_ES', NULL),
    (276, 'es_ES', NULL),
    (277, 'es_ES', NULL),
    (278, 'es_ES', NULL),
    (279, 'es_ES', NULL),
    (280, 'es_ES', NULL),
    (281, 'es_ES', NULL),
    (282, 'es_ES', NULL),
    (283, 'es_ES', NULL),
    (284, 'es_ES', NULL),
    (285, 'es_ES', NULL),
    (286, 'es_ES', NULL),
    (287, 'es_ES', NULL),
    (288, 'es_ES', NULL),
    (289, 'es_ES', NULL),
    (290, 'es_ES', NULL),
    (291, 'es_ES', NULL),
    (292, 'es_ES', NULL),
    (293, 'es_ES', NULL),
    (294, 'es_ES', NULL),
    (295, 'es_ES', NULL),
    (296, 'es_ES', NULL),
    (297, 'es_ES', NULL),
    (298, 'es_ES', NULL),
    (299, 'es_ES', NULL),
    (300, 'es_ES', NULL),
    (301, 'es_ES', NULL),
    (302, 'es_ES', NULL),
    (303, 'es_ES', NULL),
    (304, 'es_ES', NULL),
    (305, 'es_ES', NULL),
    (306, 'es_ES', NULL),
    (307, 'es_ES', NULL),
    (308, 'es_ES', NULL),
    (309, 'es_ES', NULL),
    (310, 'es_ES', NULL),
    (311, 'es_ES', NULL),
    (312, 'es_ES', NULL),
    (313, 'es_ES', ''),
    (314, 'es_ES', ''),
    (315, 'es_ES', ''),
    (316, 'es_ES', ''),
    (317, 'es_ES', ''),

    (1, 'fr_FR', 'Alabama'),
    (2, 'fr_FR', 'Alaska'),
    (3, 'fr_FR', 'Arizona'),
    (4, 'fr_FR', 'Arkansas'),
    (5, 'fr_FR', 'Californie'),
    (6, 'fr_FR', 'Colorado'),
    (7, 'fr_FR', 'Connecticut'),
    (8, 'fr_FR', 'Delaware'),
    (9, 'fr_FR', 'Floride'),
    (10, 'fr_FR', 'Géorgie'),
    (11, 'fr_FR', 'Hawaii'),
    (12, 'fr_FR', 'Idaho'),
    (13, 'fr_FR', 'Illinois'),
    (14, 'fr_FR', 'Indiana'),
    (15, 'fr_FR', 'Iowa'),
    (16, 'fr_FR', 'Kansas'),
    (17, 'fr_FR', 'Kentucky'),
    (18, 'fr_FR', 'Louisiane'),
    (19, 'fr_FR', 'Maine'),
    (20, 'fr_FR', 'Maryland'),
    (21, 'fr_FR', 'Massachusetts'),
    (22, 'fr_FR', 'Michigan'),
    (23, 'fr_FR', 'Minnesota'),
    (24, 'fr_FR', 'Mississippi'),
    (25, 'fr_FR', 'Missouri'),
    (26, 'fr_FR', 'Montana'),
    (27, 'fr_FR', 'Nebraska'),
    (28, 'fr_FR', 'Nevada'),
    (29, 'fr_FR', 'New Hampshire'),
    (30, 'fr_FR', 'New Jersey'),
    (31, 'fr_FR', 'Nouveau-Mexique'),
    (32, 'fr_FR', 'New York'),
    (33, 'fr_FR', 'Caroline du Nord'),
    (34, 'fr_FR', 'Dakota du Nord'),
    (35, 'fr_FR', 'Ohio'),
    (36, 'fr_FR', 'Oklahoma'),
    (37, 'fr_FR', 'Oregon'),
    (38, 'fr_FR', 'Pennsylvanie'),
    (39, 'fr_FR', 'Rhode Island'),
    (40, 'fr_FR', 'Caroline du Sud'),
    (41, 'fr_FR', 'Dakota du Sud'),
    (42, 'fr_FR', 'Tennessee'),
    (43, 'fr_FR', 'Texas'),
    (44, 'fr_FR', 'Utah'),
    (45, 'fr_FR', 'Vermont'),
    (46, 'fr_FR', 'Virginie'),
    (47, 'fr_FR', 'Washington'),
    (48, 'fr_FR', 'Virginie-occidentale'),
    (49, 'fr_FR', 'Wisconsin'),
    (50, 'fr_FR', 'Wyoming'),
    (51, 'fr_FR', 'Porto Rico'),
    (52, 'fr_FR', 'Îles Vierges américaines'),
    (53, 'fr_FR', 'District de Columbia'),
    (54, 'fr_FR', 'Aguascalientes'),
    (55, 'fr_FR', 'Baja California'),
    (56, 'fr_FR', 'Baja California Sur'),
    (57, 'fr_FR', 'Campeche'),
    (58, 'fr_FR', 'Chiapas'),
    (59, 'fr_FR', 'Chihuahua'),
    (60, 'fr_FR', 'Coahuila'),
    (61, 'fr_FR', 'Colima'),
    (62, 'fr_FR', 'Distrito Federal'),
    (63, 'fr_FR', 'Durango'),
    (64, 'fr_FR', 'Guanajuato'),
    (65, 'fr_FR', 'Guerrero'),
    (66, 'fr_FR', 'Hidalgo'),
    (67, 'fr_FR', 'Jalisco'),
    (68, 'fr_FR', 'Estado de México'),
    (69, 'fr_FR', 'Michoacán'),
    (70, 'fr_FR', 'Morelos'),
    (71, 'fr_FR', 'Nayarit'),
    (72, 'fr_FR', 'Nuevo León'),
    (73, 'fr_FR', 'Oaxaca'),
    (74, 'fr_FR', 'Puebla'),
    (75, 'fr_FR', 'Querétaro'),
    (76, 'fr_FR', 'Quintana Roo'),
    (77, 'fr_FR', 'San Luis Potosí'),
    (78, 'fr_FR', 'Sinaloa'),
    (79, 'fr_FR', 'Sonora'),
    (80, 'fr_FR', 'Tabasco'),
    (81, 'fr_FR', 'Tamaulipas'),
    (82, 'fr_FR', 'Tlaxcala'),
    (83, 'fr_FR', 'Veracruz'),
    (84, 'fr_FR', 'Yucatán'),
    (85, 'fr_FR', 'Zacatecas'),
    (86, 'fr_FR', 'Ontario'),
    (87, 'fr_FR', 'Québec'),
    (88, 'fr_FR', 'Colombie-Britannique'),
    (89, 'fr_FR', 'Alberta'),
    (90, 'fr_FR', 'Manitoba'),
    (91, 'fr_FR', 'Saskatchewan'),
    (92, 'fr_FR', 'Nouvelle-Écosse'),
    (93, 'fr_FR', 'Nouveau-Brunswick'),
    (94, 'fr_FR', 'Terre Neuve et Labrador'),
    (95, 'fr_FR', 'Île-du-Prince-Édouard'),
    (96, 'fr_FR', 'Territoires du Nord-Ouest'),
    (97, 'fr_FR', 'Yukon'),
    (98, 'fr_FR', 'Nunavut'),
    (99, 'fr_FR', 'Buenos Aires'),
    (100, 'fr_FR', 'Catamarca'),
    (101, 'fr_FR', 'Chaco'),
    (102, 'fr_FR', 'Chubut'),
    (103, 'fr_FR', 'Ciudad de Buenos Aires'),
    (104, 'fr_FR', 'Cordoba'),
    (105, 'fr_FR', 'Corrientes'),
    (106, 'fr_FR', 'Entre Ríos'),
    (107, 'fr_FR', 'Formosa'),
    (108, 'fr_FR', 'Jujuy'),
    (109, 'fr_FR', 'La Pampa'),
    (110, 'fr_FR', 'La Rioja'),
    (111, 'fr_FR', 'Mendoza'),
    (112, 'fr_FR', 'Misiones'),
    (113, 'fr_FR', 'Neuquén'),
    (114, 'fr_FR', 'Rio Negro'),
    (115, 'fr_FR', 'Salta'),
    (116, 'fr_FR', 'San Juan'),
    (117, 'fr_FR', 'San Luis'),
    (118, 'fr_FR', 'Santa Cruz'),
    (119, 'fr_FR', 'Santa Fe'),
    (120, 'fr_FR', 'Santiago del Estero'),
    (121, 'fr_FR', 'Tierra del Fuego'),
    (122, 'fr_FR', 'Tucuman'),
    (123, 'fr_FR', 'Agrigento'),
    (124, 'fr_FR', 'Alessandria'),
    (125, 'fr_FR', 'Ancona'),
    (126, 'fr_FR', 'Aosta'),
    (127, 'fr_FR', 'Arezzo'),
    (128, 'fr_FR', 'Ascoli Piceno'),
    (129, 'fr_FR', 'Asti'),
    (130, 'fr_FR', 'Avellino'),
    (131, 'fr_FR', 'Bari'),
    (132, 'fr_FR', 'Barletta-Andria-Trani'),
    (133, 'fr_FR', 'Belluno'),
    (134, 'fr_FR', 'Benevento'),
    (135, 'fr_FR', 'Bergamo'),
    (136, 'fr_FR', 'Biella'),
    (137, 'fr_FR', 'Bologne'),
    (138, 'fr_FR', 'Bolzano'),
    (139, 'fr_FR', 'Brescia'),
    (140, 'fr_FR', 'Brindisi'),
    (141, 'fr_FR', 'Cagliari'),
    (142, 'fr_FR', 'Caltanissetta'),
    (143, 'fr_FR', 'Campobasso'),
    (144, 'fr_FR', 'Carbonia-Iglesias'),
    (145, 'fr_FR', 'Caserta'),
    (146, 'fr_FR', 'Catane'),
    (147, 'fr_FR', 'Catanzaro'),
    (148, 'fr_FR', 'Chieti'),
    (149, 'fr_FR', 'Como'),
    (150, 'fr_FR', 'Cosenza'),
    (151, 'fr_FR', 'Cremona'),
    (152, 'fr_FR', 'Crotone'),
    (153, 'fr_FR', 'Cuneo'),
    (154, 'fr_FR', 'Enna'),
    (155, 'fr_FR', 'Fermo'),
    (156, 'fr_FR', 'Ferrara'),
    (157, 'fr_FR', 'Firenze'),
    (158, 'fr_FR', 'Foggia'),
    (159, 'fr_FR', 'Forlì-Cesena'),
    (160, 'fr_FR', 'Frosinone'),
    (161, 'fr_FR', 'Genova'),
    (162, 'fr_FR', 'Gorizia'),
    (163, 'fr_FR', 'Grosseto'),
    (164, 'fr_FR', 'Imperia'),
    (165, 'fr_FR', 'Isernia'),
    (166, 'fr_FR', 'L\'Aquila'),
    (167, 'fr_FR', 'La Spezia'),
    (168, 'fr_FR', 'Latina'),
    (169, 'fr_FR', 'Lecce'),
    (170, 'fr_FR', 'Lecco'),
    (171, 'fr_FR', 'Livourne'),
    (172, 'fr_FR', 'Lodi'),
    (173, 'fr_FR', 'Lucca'),
    (174, 'fr_FR', 'Macerata'),
    (175, 'fr_FR', 'Mantova'),
    (176, 'fr_FR', 'Massa'),
    (177, 'fr_FR', 'Matera'),
    (178, 'fr_FR', 'Medio Campidano'),
    (179, 'fr_FR', 'Messina'),
    (180, 'fr_FR', 'Milano'),
    (181, 'fr_FR', 'Modena'),
    (182, 'fr_FR', 'Monza e della Brianza'),
    (183, 'fr_FR', 'Napoli'),
    (184, 'fr_FR', 'Novara'),
    (185, 'fr_FR', 'Nuoro'),
    (186, 'fr_FR', 'Ogliastra'),
    (187, 'fr_FR', 'Olbia-Tempio'),
    (188, 'fr_FR', 'Oristano'),
    (189, 'fr_FR', 'Padova'),
    (190, 'fr_FR', 'Palerme'),
    (191, 'fr_FR', 'Parma'),
    (192, 'fr_FR', 'Pavie'),
    (193, 'fr_FR', 'Pérouse'),
    (194, 'fr_FR', 'Pesaro-Urbino'),
    (195, 'fr_FR', 'Pescara'),
    (196, 'fr_FR', 'Piacenza'),
    (197, 'fr_FR', 'Pise'),
    (198, 'fr_FR', 'Pistoia'),
    (199, 'fr_FR', 'Pordenone'),
    (200, 'fr_FR', 'Potenza'),
    (201, 'fr_FR', 'Prato'),
    (202, 'fr_FR', 'Ragusa'),
    (203, 'fr_FR', 'Ravenne'),
    (204, 'fr_FR', 'Reggio de Calabre'),
    (205, 'fr_FR', 'Reggio d\'Émilie'),
    (206, 'fr_FR', 'Rieti'),
    (207, 'fr_FR', 'Rimini'),
    (208, 'fr_FR', 'Rome'),
    (209, 'fr_FR', 'Rovigo'),
    (210, 'fr_FR', 'Salerno'),
    (211, 'fr_FR', 'Sassari'),
    (212, 'fr_FR', 'Savona'),
    (213, 'fr_FR', 'Siena'),
    (214, 'fr_FR', 'Siracusa'),
    (215, 'fr_FR', 'Sondrio'),
    (216, 'fr_FR', 'Taranto'),
    (217, 'fr_FR', 'Teramo'),
    (218, 'fr_FR', 'Terni'),
    (219, 'fr_FR', 'Torino'),
    (220, 'fr_FR', 'Trapani'),
    (221, 'fr_FR', 'Trento'),
    (222, 'fr_FR', 'Treviso'),
    (223, 'fr_FR', 'Trieste'),
    (224, 'fr_FR', 'Udine'),
    (225, 'fr_FR', 'Varese'),
    (226, 'fr_FR', 'Venezia'),
    (227, 'fr_FR', 'Verbano-Cusio-Ossola'),
    (228, 'fr_FR', 'Vercelli'),
    (229, 'fr_FR', 'Vérone'),
    (230, 'fr_FR', 'Vibo Valentia'),
    (231, 'fr_FR', 'Vicenza'),
    (232, 'fr_FR', 'Viterbo'),
    (233, 'fr_FR', 'Aceh'),
    (234, 'fr_FR', 'Bali'),
    (235, 'fr_FR', 'Bangka'),
    (236, 'fr_FR', 'Banten'),
    (237, 'fr_FR', 'Bengkulu'),
    (238, 'fr_FR', 'Central Java'),
    (239, 'fr_FR', 'Kalimantan occidental'),
    (240, 'fr_FR', 'Sulawesi central'),
    (241, 'fr_FR', 'Coat of arms of East Java'),
    (242, 'fr_FR', 'Kalimantan oriental'),
    (243, 'fr_FR', 'Nusa Tenggara oriental'),
    (244, 'fr_FR', 'Lambang propinsi'),
    (245, 'fr_FR', 'Jakarta'),
    (246, 'fr_FR', 'Jambi'),
    (247, 'fr_FR', 'Lampung'),
    (248, 'fr_FR', 'Maluku'),
    (249, 'fr_FR', 'Maluku du Nord'),
    (250, 'fr_FR', 'Sulawesi du Nord'),
    (251, 'fr_FR', 'Sumatra-Nord'),
    (252, 'fr_FR', 'Papouasie'),
    (253, 'fr_FR', 'Riau'),
    (254, 'fr_FR', 'Lambang Riau'),
    (255, 'fr_FR', 'Sulawesi du sud-est'),
    (256, 'fr_FR', 'Kalimantan du Sud'),
    (257, 'fr_FR', 'Sulawesi du Sud'),
    (258, 'fr_FR', 'Sumatra du Sud'),
    (259, 'fr_FR', 'Java-Ouest'),
    (260, 'fr_FR', 'Kalimantan occidental'),
    (261, 'fr_FR', 'Nusa Tenggara occidental'),
    (262, 'fr_FR', 'Lambang Provinsi Papua Barat'),
    (263, 'fr_FR', 'Sulawesi occidental'),
    (264, 'fr_FR', 'Sumatra occidental'),
    (265, 'fr_FR', 'Yogyakarta'),
    (266, 'fr_FR', 'Aichi'),
    (267, 'fr_FR', 'Akita'),
    (268, 'fr_FR', 'Aomori'),
    (269, 'fr_FR', 'Chiba'),
    (270, 'fr_FR', 'Ehime'),
    (271, 'fr_FR', 'Fukui'),
    (272, 'fr_FR', 'Fukuoka'),
    (273, 'fr_FR', 'Fukushima'),
    (274, 'fr_FR', 'Gifu'),
    (275, 'fr_FR', 'Gunma'),
    (276, 'fr_FR', 'Hiroshima'),
    (277, 'fr_FR', 'Hokkaido'),
    (278, 'fr_FR', 'Hyogo'),
    (279, 'fr_FR', 'Ibaraki'),
    (280, 'fr_FR', 'Ishikawa'),
    (281, 'fr_FR', 'Iwate'),
    (282, 'fr_FR', 'Kagawa'),
    (283, 'fr_FR', 'Kagoshima'),
    (284, 'fr_FR', 'Kanagawa'),
    (285, 'fr_FR', 'Kochi'),
    (286, 'fr_FR', 'Kumamoto'),
    (287, 'fr_FR', 'Kyoto'),
    (288, 'fr_FR', 'Mie'),
    (289, 'fr_FR', 'Miyagi'),
    (290, 'fr_FR', 'Miyazaki'),
    (291, 'fr_FR', 'Nagano'),
    (292, 'fr_FR', 'Nagasaki'),
    (293, 'fr_FR', 'Nara'),
    (294, 'fr_FR', 'Niigata'),
    (295, 'fr_FR', 'Oita'),
    (296, 'fr_FR', 'Okayama'),
    (297, 'fr_FR', 'Okinawa'),
    (298, 'fr_FR', 'Osaka'),
    (299, 'fr_FR', 'Saga'),
    (300, 'fr_FR', 'Saitama'),
    (301, 'fr_FR', 'Shiga'),
    (302, 'fr_FR', 'Shimane'),
    (303, 'fr_FR', 'Shizuoka'),
    (304, 'fr_FR', 'Tochigi'),
    (305, 'fr_FR', 'Tokushima'),
    (306, 'fr_FR', 'Tokyo'),
    (307, 'fr_FR', 'Tottori'),
    (308, 'fr_FR', 'Toyama'),
    (309, 'fr_FR', 'Wakayama'),
    (310, 'fr_FR', 'Yamagata'),
    (311, 'fr_FR', 'Yamaguchi'),
    (312, 'fr_FR', 'Yamanashi'),
    (313, 'fr_FR', ''),
    (314, 'fr_FR', ''),
    (315, 'fr_FR', ''),
    (316, 'fr_FR', ''),
    (317, 'fr_FR', '')
;

-- Add new column in lang table
ALTER TABLE  `lang` ADD  `active` BOOLEAN NOT NULL DEFAULT FALSE AFTER  `decimals` ;
ALTER TABLE  `lang` ADD  `visible` TINYINT NOT NULL DEFAULT  '0' AFTER  `active` ;

-- Update lang
UPDATE `lang` SET `active` = '1', `visible` = '1' WHERE 1;

-- add missing primary key
ALTER TABLE `coupon_customer_count` ADD PRIMARY KEY(`coupon_id`, `customer_id`);
ALTER TABLE `ignored_module_hook` ADD PRIMARY KEY(`module_id`, `hook_id`);

SET FOREIGN_KEY_CHECKS = 1;
