SET FOREIGN_KEY_CHECKS = 0;

UPDATE `config` SET `value`='2.2.0-alpha1' WHERE `name`='thelia_version';
UPDATE `config` SET `value`='2' WHERE `name`='thelia_major_version';
UPDATE `config` SET `value`='2' WHERE `name`='thelia_minus_version';
UPDATE `config` SET `value`='0' WHERE `name`='thelia_release_version';
UPDATE `config` SET `value`='alpha1' WHERE `name`='thelia_extra_version';

-- order status

SELECT @max_id := MAX(`id`) FROM `order_status`;

INSERT INTO `order_status` VALUES
  (@max_id + 1, "refunded", NOW(), NOW())
;

INSERT INTO `order_status_i18n` VALUES
(@max_id + 1, "de_DE", 'Zrückerstattet', "", "", ""),
(@max_id + 1, "en_US", 'Refunded', "", "", ""),
(@max_id + 1, "es_ES", 'Reembolsado', "", "", ""),
(@max_id + 1, "fr_FR", 'Remboursé', "", "", "")
;

-- new column in admin_log

ALTER TABLE `admin_log` ADD `resource_id` INTEGER AFTER `resource` ;

-- new config

SELECT @max_id := IFNULL(MAX(`id`),0) FROM `config`;

INSERT INTO `config` (`id`, `name`, `value`, `secured`, `hidden`, `created_at`, `updated_at`) VALUES
(@max_id + 1, 'customer_change_email', '0', 0, 0, NOW(), NOW()),
(@max_id + 2, 'customer_confirm_email', '0', 0, 0, NOW(), NOW())
;

INSERT INTO `config_i18n` (`id`, `locale`, `title`, `description`, `chapo`, `postscriptum`) VALUES
(@max_id + 1, 'de_DE', 'Den Kunden erlauben ihre E-Mail-Adresse zu ändern. 1 für Ja, 0 für Nein', NULL, NULL, NULL),
(@max_id + 2, 'de_DE', 'Den Kunden fragen, ihre E-Mail-Adresse zu bestätigen. 1 für Jan, 0 für Nein', NULL, NULL, NULL),
(@max_id + 1, 'en_US', 'Allow customers to change their email. 1 for yes, 0 for no', NULL, NULL, NULL),
(@max_id + 2, 'en_US', NULL, NULL, NULL, NULL),
(@max_id + 1, 'es_ES', 'Permitir a los clientes cambiar su correo electrónico. 1 para sí, 0 para no', NULL, NULL, NULL),
(@max_id + 2, 'es_ES', 'Preguntar al cliente para confirmar su correo electrónico, 1 para sí, 0 no', NULL, NULL, NULL),
(@max_id + 1, 'fr_FR', 'Permettre aux utilisateurs de changer leur email. 1 pour oui, 0 pour non', NULL, NULL, NULL),
(@max_id + 2, 'fr_FR', 'Demander aux clients de confirmer leur email. 1 pour oui, 0 pour non', NULL, NULL, NULL)
;

-- country area table

create table IF NOT EXISTS `country_area`
(
    `country_id` INTEGER NOT NULL,
    `area_id` INTEGER NOT NULL,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    INDEX `country_area_area_id_idx` (`area_id`),
    INDEX `fk_country_area_country_id_idx` (`country_id`),
    CONSTRAINT `fk_country_area_area_id`
        FOREIGN KEY (`area_id`)
        REFERENCES `area` (`id`)
        ON UPDATE RESTRICT
        ON DELETE CASCADE,
    CONSTRAINT `fk_country_area_country_id`
        FOREIGN KEY (`country_id`)
        REFERENCES `country` (`id`)
        ON UPDATE RESTRICT
        ON DELETE CASCADE
) ENGINE=InnoDB CHARACTER SET='utf8';

-- Initialize the table with existing data
INSERT INTO `country_area` (`country_id`, `area_id`, `created_at`, `updated_at`) select `id`, `area_id`, NOW(), NOW() FROM `country` WHERE `area_id` IS NOT NULL;

-- Remove area_id column from country table
ALTER TABLE `country` DROP FOREIGN KEY `fk_country_area_id`;
ALTER TABLE `country` DROP KEY `idx_country_area_id`;
ALTER TABLE `country` DROP COLUMN `area_id`;
ALTER TABLE `category` ADD COLUMN `default_template_id` INTEGER AFTER  `position`;

-- new hook --
SELECT @max_id := IFNULL(MAX(`id`),0) FROM `hook`;

INSERT INTO `hook` (`id`, `code`, `type`, `by_module`, `block`, `native`, `activate`, `position`, `created_at`, `updated_at`) VALUES
(@max_id + 1, 'profile.table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 2, 'profile.table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 3, 'import.table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 4, 'import.table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 5, 'export.table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 6, 'export.table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 7, 'category-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 8, 'category-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 9, 'brand-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 10, 'brand-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 11, 'attribute-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 12, 'attribute-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 13, 'currency-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 14, 'currency-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 15, 'country-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 16, 'country-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 17, 'content-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 18, 'content-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 19, 'feature-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 20, 'feature-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 21, 'document-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 22, 'document-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 23, 'customer-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 24, 'customer-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 25, 'image-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 26, 'image-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 27, 'hook-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 28, 'hook-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 29, 'folder-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 30, 'folder-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 31, 'module-hook-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 32, 'module-hook-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 33, 'module-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 34, 'module-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 35, 'message-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 36, 'message-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 37, 'profile-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 38, 'profile-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 39, 'product-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 40, 'product-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 41, 'order-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 42, 'order-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 43, 'shipping-zones-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 44, 'shipping-zones-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 45, 'shipping-configuration-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 46, 'shipping-configuration-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 47, 'sale-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 48, 'sale-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 49, 'variables-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 50, 'variables-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 51, 'template-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 52, 'template-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 53, 'tax-rule-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 54, 'tax-rule-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 55, 'tax-edit.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 56, 'tax-edit.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 57, 'order-edit.product-list', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 58, 'order.tab', 2, 0, 1, 1, 1, 1, NOW(), NOW()),
(@max_id + 59, 'account-order.product', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 60, 'tab-seo.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 61, 'tab-seo.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 62, 'tab-image.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 63, 'tab-image.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 64, 'tab-document.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
(@max_id + 65, 'tab-document.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW())
;

INSERT INTO  `hook_i18n` (`id`, `locale`, `title`, `description`, `chapo`) VALUES
(@max_id + 1, 'de_DE', 'Profil - Tabellenkopf', '', ''),
(@max_id + 2, 'de_DE', 'Profil - Tabellenzeile', '', ''),
(@max_id + 3, 'de_DE', 'Import - Tabellenkopf', '', ''),
(@max_id + 4, 'de_DE', 'Import - Tabellenzeile', '', ''),
(@max_id + 5, 'de_DE', 'Export - Tabellenkopf', '', ''),
(@max_id + 6, 'de_DE', 'Export - Tabellenzeile', '', ''),
(@max_id + 7, 'de_DE', 'Kategorie Bearbeitung - oben', '', ''),
(@max_id + 8, 'de_DE', 'Kategorie Bearbeitung - unten', '', ''),
(@max_id + 9, 'de_DE', 'Marke Bearbeitung - oben', '', ''),
(@max_id + 10, 'de_DE', 'Marke Bearbeitung - unten', '', ''),
(@max_id + 11, 'de_DE', 'Deklination Bearbeitung - oben', '', ''),
(@max_id + 12, 'de_DE', 'Deklination Bearbeitung - unten', '', ''),
(@max_id + 13, 'de_DE', 'Währung Bearbeitung - oben', '', ''),
(@max_id + 14, 'de_DE', 'Währung Bearbeitung - unten', '', ''),
(@max_id + 15, 'de_DE', 'Währung Bearbeitung - oben', '', ''),
(@max_id + 16, 'de_DE', 'Währung Bearbeitung - unten', '', ''),
(@max_id + 17, 'de_DE', 'Inhalt Bearbeitung - oben', '', ''),
(@max_id + 18, 'de_DE', 'Inhalt Bearbeitung - unten', '', ''),
(@max_id + 19, 'de_DE', 'Charakteristik Bearbeitung - oben', '', ''),
(@max_id + 20, 'de_DE', 'Charakteristik Bearbeitung - unten', '', ''),
(@max_id + 21, 'de_DE', 'Dokument Bearbeitung - oben', '', ''),
(@max_id + 22, 'de_DE', 'Dokument Bearbeitung - unten', '', ''),
(@max_id + 23, 'de_DE', 'Kunde Bearbeitung - oben', '', ''),
(@max_id + 24, 'de_DE', 'Kunde Bearbeitung - unten', '', ''),
(@max_id + 25, 'de_DE', 'Bild Bearbeitung - oben', '', ''),
(@max_id + 26, 'de_DE', 'Bild Bearbeitung - unten', '', ''),
(@max_id + 27, 'de_DE', 'Hook Bearbeitung - oben', '', ''),
(@max_id + 28, 'de_DE', 'Hook Bearbeitung - unten', '', ''),
(@max_id + 29, 'de_DE', 'Ordner Bearbeitung - oben', '', ''),
(@max_id + 30, 'de_DE', 'Ordner Bearbeitung - unten', '', ''),
(@max_id + 31, 'de_DE', 'Modul-Hook Bearbeitung - oben', '', ''),
(@max_id + 32, 'de_DE', 'Modul-Hook Bearbeitung - unten', '', ''),
(@max_id + 33, 'de_DE', 'Modul Bearbeitung - oben', '', ''),
(@max_id + 34, 'de_DE', 'Modul Bearbeitung - unten', '', ''),
(@max_id + 35, 'de_DE', 'Nachricht Bearbeitung - oben', '', ''),
(@max_id + 36, 'de_DE', 'Nachricht Bearbeitung - unten', '', ''),
(@max_id + 37, 'de_DE', 'Profil Bearbeitung - oben', '', ''),
(@max_id + 38, 'de_DE', 'Profil Bearbeitung - unten', '', ''),
(@max_id + 39, 'de_DE', 'Produkt Bearbeitung - oben', '', ''),
(@max_id + 40, 'de_DE', 'Produkt Bearbeitung - unten', '', ''),
(@max_id + 41, 'de_DE', 'Bestellung Bearbeitung - oben', '', ''),
(@max_id + 42, 'de_DE', 'Bestellung Bearbeitung - unten', '', ''),
(@max_id + 43, 'de_DE', 'Transporteur Lieferzonen Bearbeitung - oben', '', ''),
(@max_id + 44, 'de_DE', 'Transporteur Lieferzonen Bearbeitung - unten', '', ''),
(@max_id + 45, 'de_DE', 'Lieferzone Bearbeitung - oben', '', ''),
(@max_id + 46, 'de_DE', 'Lieferzone Bearbeitung - unten', '', ''),
(@max_id + 47, 'de_DE', 'Sonderangebot Bearbeitung - oben', '', ''),
(@max_id + 48, 'de_DE', 'Sonderangebot Bearbeitung - unten', '', ''),
(@max_id + 49, 'de_DE', 'Variable Bearbeitung - oben', '', ''),
(@max_id + 50, 'de_DE', 'Variable Bearbeitung - unten', '', ''),
(@max_id + 51, 'de_DE', 'Template Bearbeitung - oben', '', ''),
(@max_id + 52, 'de_DE', 'Template Bearbeitung - unten', '', ''),
(@max_id + 53, 'de_DE', 'Taxregel Bearbeitung - oben', '', ''),
(@max_id + 54, 'de_DE', 'Taxregel Bearbeitung - unten', '', ''),
(@max_id + 55, 'de_DE', 'Taxe Bearbeitung - oben', '', ''),
(@max_id + 56, 'de_DE', 'Taxe Bearbeitung - unten', '', ''),
(@max_id + 57, 'de_DE', 'Bestellungs Bearbeitung - unter die Produktdaten', '', ''),
(@max_id + 58, 'de_DE', 'Bestellung - Tab', '', ''),
(@max_id + 59, 'de_DE', 'Bestelldaten - nach einem Produkt', '', ''),
(@max_id + 60, 'de_DE', 'SEO Tab - oben', '', ''),
(@max_id + 61, 'de_DE', 'SEO Tab - unten', '', ''),
(@max_id + 62, 'de_DE', 'Bild Tab - oben', '', ''),
(@max_id + 63, 'de_DE', 'Bild Tab - unten', '', ''),
(@max_id + 64, 'de_DE', 'Dokument Tab - oben', '', ''),
(@max_id + 65, 'de_DE', 'Dokument Tab - unten', '', ''),
(@max_id + 1, 'en_US', 'Profile - table header', '', ''),
(@max_id + 2, 'en_US', 'Profile - table row', '', ''),
(@max_id + 3, 'en_US', 'Import - table header', '', ''),
(@max_id + 4, 'en_US', 'Import - table row', '', ''),
(@max_id + 5, 'en_US', 'Export - table header', '', ''),
(@max_id + 6, 'en_US', 'Export - table row', '', ''),
(@max_id + 7, 'en_US', 'Category edit - top', '', ''),
(@max_id + 8, 'en_US', 'Category edit - bottom', '', ''),
(@max_id + 9, 'en_US', 'Brand edit - top', '', ''),
(@max_id + 10, 'en_US', 'Brand edit - bottom', '', ''),
(@max_id + 11, 'en_US', 'Attribute edit - top', '', ''),
(@max_id + 12, 'en_US', 'Attribute edit - bottom', '', ''),
(@max_id + 13, 'en_US', 'Currency edit - top', '', ''),
(@max_id + 14, 'en_US', 'Currency edit - bottom', '', ''),
(@max_id + 15, 'en_US', 'Country edit - top', '', ''),
(@max_id + 16, 'en_US', 'Country edit - bottom', '', ''),
(@max_id + 17, 'en_US', 'Content edit - top', '', ''),
(@max_id + 18, 'en_US', 'Content edit - bottom', '', ''),
(@max_id + 19, 'en_US', 'Feature edit - top', '', ''),
(@max_id + 20, 'en_US', 'Feature edit - bottom', '', ''),
(@max_id + 21, 'en_US', 'Document edit - top', '', ''),
(@max_id + 22, 'en_US', 'Document edit - bottom', '', ''),
(@max_id + 23, 'en_US', 'Client edit - top', '', ''),
(@max_id + 24, 'en_US', 'Client edit - bottom', '', ''),
(@max_id + 25, 'en_US', 'Image edit - top', '', ''),
(@max_id + 26, 'en_US', 'Image edit - bottom', '', ''),
(@max_id + 27, 'en_US', 'Hook edit - top', '', ''),
(@max_id + 28, 'en_US', 'Hook edit - bottom', '', ''),
(@max_id + 29, 'en_US', 'Folder edit - top', '', ''),
(@max_id + 30, 'en_US', 'Folder edit - bottom', '', ''),
(@max_id + 31, 'en_US', 'Module hook edit - top', '', ''),
(@max_id + 32, 'en_US', 'Module hook edit - bottom', '', ''),
(@max_id + 33, 'en_US', 'Module edit - top', '', ''),
(@max_id + 34, 'en_US', 'Module edit - bottom', '', ''),
(@max_id + 35, 'en_US', 'Message edit - top', '', ''),
(@max_id + 36, 'en_US', 'Message edit - bottom', '', ''),
(@max_id + 37, 'en_US', 'Profile edit - top', '', ''),
(@max_id + 38, 'en_US', 'Profile edit - bottom', '', ''),
(@max_id + 39, 'en_US', 'Product edit - top', '', ''),
(@max_id + 40, 'en_US', 'Product edit - bottom', '', ''),
(@max_id + 41, 'en_US', 'Order edit - top', '', ''),
(@max_id + 42, 'en_US', 'Order edit - bottom', '', ''),
(@max_id + 43, 'en_US', 'Shipping zones edit - top', '', ''),
(@max_id + 44, 'en_US', 'Shipping zones edit - bottom', '', ''),
(@max_id + 45, 'en_US', 'Shipping configuration edit - top', '', ''),
(@max_id + 46, 'en_US', 'Shipping configuration edit - bottom', '', ''),
(@max_id + 47, 'en_US', 'Sale edit - top', '', ''),
(@max_id + 48, 'en_US', 'Sale edit - bottom', '', ''),
(@max_id + 49, 'en_US', 'Variable edit - top', '', ''),
(@max_id + 50, 'en_US', 'Variable edit - bottom', '', ''),
(@max_id + 51, 'en_US', 'Template edit - top', '', ''),
(@max_id + 52, 'en_US', 'Template edit - bottom', '', ''),
(@max_id + 53, 'en_US', 'Tax rule edit - top', '', ''),
(@max_id + 54, 'en_US', 'Tax rule edit - bottom', '', ''),
(@max_id + 55, 'en_US', 'Tax edit - top', '', ''),
(@max_id + 56, 'en_US', 'Tax edit - bottom', '', ''),
(@max_id + 57, 'en_US', 'Order edit - displayed after product information', '', ''),
(@max_id + 58, 'en_US', 'Order - Tab', '', ''),
(@max_id + 59, 'en_US', 'Order details - after product', '', ''),
(@max_id + 60, 'en_US', 'Tab SEO - top', '', ''),
(@max_id + 61, 'en_US', 'Tab SEO - bottom', '', ''),
(@max_id + 62, 'en_US', 'Tab image - top', '', ''),
(@max_id + 63, 'en_US', 'Tab image - bottom', '', ''),
(@max_id + 64, 'en_US', 'Tab document - top', '', ''),
(@max_id + 65, 'en_US', 'Tab document - bottom', '', ''),
(@max_id + 1, 'es_ES', 'Perfil - encabezado de tabla', '', ''),
(@max_id + 2, 'es_ES', 'Perfil - fila de la tabla', '', ''),
(@max_id + 3, 'es_ES', 'Importar - encabezado de tabla', '', ''),
(@max_id + 4, 'es_ES', 'Importar - fila de la tabla', '', ''),
(@max_id + 5, 'es_ES', 'Exportación - encabezado de tabla', '', ''),
(@max_id + 6, 'es_ES', 'Exportación - fila de la tabla', '', ''),
(@max_id + 7, 'es_ES', 'Categoría edición - superior', '', ''),
(@max_id + 8, 'es_ES', 'Editar categoría - inferior', '', ''),
(@max_id + 9, 'es_ES', 'Editar marca - superior', '', ''),
(@max_id + 10, 'es_ES', 'Editar marca - inferior', '', ''),
(@max_id + 11, 'es_ES', 'Editar atributo - superior', '', ''),
(@max_id + 12, 'es_ES', 'Edición de atributos - inferior', '', ''),
(@max_id + 13, 'es_ES', 'Editar Monedas - Cabecera', '', ''),
(@max_id + 14, 'es_ES', 'Editar Monedas - Pie', '', ''),
(@max_id + 15, 'es_ES', 'Edición de país - parte superior', '', ''),
(@max_id + 16, 'es_ES', 'Edición de pais - parte inferior', '', ''),
(@max_id + 17, 'es_ES', 'Editar contenido - superior', '', ''),
(@max_id + 18, 'es_ES', 'Editar Contenido - inferior', '', ''),
(@max_id + 19, 'es_ES', 'Editar Característica - superior', '', ''),
(@max_id + 20, 'es_ES', 'Editar Característica - inferior', '', ''),
(@max_id + 21, 'es_ES', 'Edición de documentos - cabecera', '', ''),
(@max_id + 22, 'es_ES', 'Edición de documentos - pie', '', ''),
(@max_id + 23, 'es_ES', 'Editar cliente - superior', '', ''),
(@max_id + 24, 'es_ES', 'Editar cliente - parte inferior', '', ''),
(@max_id + 25, 'es_ES', 'Edición de imagen - parte superior', '', ''),
(@max_id + 26, 'es_ES', 'Edición de imagen - parte inferior', '', ''),
(@max_id + 27, 'es_ES', 'Edición de Hook - superior', '', ''),
(@max_id + 28, 'es_ES', 'Edición de Hook - inferior', '', ''),
(@max_id + 29, 'es_ES', 'Edición de carpeta - superior', '', ''),
(@max_id + 30, 'es_ES', 'Editar carpeta - parte inferior', '', ''),
(@max_id + 31, 'es_ES', NULL, '', ''),
(@max_id + 32, 'es_ES', NULL, '', ''),
(@max_id + 33, 'es_ES', 'Edición de módulo - tope', '', ''),
(@max_id + 34, 'es_ES', 'Edición de módulo - base', '', ''),
(@max_id + 35, 'es_ES', 'Editar mensaje - tope', '', ''),
(@max_id + 36, 'es_ES', 'Editar mensaje - base', '', ''),
(@max_id + 37, 'es_ES', 'Editar Perfil - parte superior', '', ''),
(@max_id + 38, 'es_ES', 'Editar Perfil - parte inferior', '', ''),
(@max_id + 39, 'es_ES', 'Editar producto - parte superior', '', ''),
(@max_id + 40, 'es_ES', 'Editar producto - parte inferior', '', ''),
(@max_id + 41, 'es_ES', 'Edición de Pedido - al tope', '', ''),
(@max_id + 42, 'es_ES', 'Editar Orden - parte inferior', '', ''),
(@max_id + 43, 'es_ES', 'Edición zonas de envío - inicio', '', ''),
(@max_id + 44, 'es_ES', 'Edición zonas de envío - base', '', ''),
(@max_id + 45, 'es_ES', 'Configuración de envío - inicio', '', ''),
(@max_id + 46, 'es_ES', 'Configuración de envío - base', '', ''),
(@max_id + 47, 'es_ES', 'Editar Venta - parte superior', '', ''),
(@max_id + 48, 'es_ES', 'Editar Venta - parte inferior', '', ''),
(@max_id + 49, 'es_ES', 'Editar variable - parte superior', '', ''),
(@max_id + 50, 'es_ES', 'Editar variable - parte inferior', '', ''),
(@max_id + 51, 'es_ES', 'Editar plantilla - parte superior', '', ''),
(@max_id + 52, 'es_ES', 'Editar plantilla - parte inferior', '', ''),
(@max_id + 53, 'es_ES', 'Edición de regla de impuesto - parte superior', '', ''),
(@max_id + 54, 'es_ES', 'Editar regla de Impuesto - base', '', ''),
(@max_id + 55, 'es_ES', 'Editar Impuesto - parte superior', '', ''),
(@max_id + 56, 'es_ES', 'Editar Impuesto - base', '', ''),
(@max_id + 57, 'es_ES', 'Edición de Pedido - se muestra después de la información de producto', '', ''),
(@max_id + 58, 'es_ES', 'Orden - Pestaña', '', ''),
(@max_id + 59, 'es_ES', 'Detalles de la orden - después del producto', '', ''),
(@max_id + 60, 'es_ES', 'Ficha SEO - arriba', '', ''),
(@max_id + 61, 'es_ES', 'Ficha SEO - abajo', '', ''),
(@max_id + 62, 'es_ES', 'Pestaña de imagen - arriba', '', ''),
(@max_id + 63, 'es_ES', 'Pestaña de imagen - abajo', '', ''),
(@max_id + 64, 'es_ES', 'Ficha de documento - arriba', '', ''),
(@max_id + 65, 'es_ES', 'Ficha de documento - abajo', '', ''),
(@max_id + 1, 'fr_FR', 'Profil - colonne tableau', '', ''),
(@max_id + 2, 'fr_FR', 'Profil - ligne du tableau', '', ''),
(@max_id + 3, 'fr_FR', 'Import - colonne tableau', '', ''),
(@max_id + 4, 'fr_FR', 'Import - ligne du tableau', '', ''),
(@max_id + 5, 'fr_FR', 'Export - colonne tableau', '', ''),
(@max_id + 6, 'fr_FR', 'Export - ligne du tableau', '', ''),
(@max_id + 7, 'fr_FR', 'Édition d\'une categorie - en haut', '', ''),
(@max_id + 8, 'fr_FR', 'Édition d\'une categorie - en bas', '', ''),
(@max_id + 9, 'fr_FR', 'Édition d\'une marque - en haut', '', ''),
(@max_id + 10, 'fr_FR', 'Édition d\'une marque - en bas', '', ''),
(@max_id + 11, 'fr_FR', 'Édition d\'une déclinaison - en haut', '', ''),
(@max_id + 12, 'fr_FR', 'Édition d\'une déclinaison - en bas', '', ''),
(@max_id + 13, 'fr_FR', 'Édition d\'une devise - en haut', '', ''),
(@max_id + 14, 'fr_FR', 'Édition d\'une devise - en bas', '', ''),
(@max_id + 15, 'fr_FR', 'Édition d\'un pays - en haut', '', ''),
(@max_id + 16, 'fr_FR', 'Édition d\'un pays - en bas', '', ''),
(@max_id + 17, 'fr_FR', 'Édition d\'un contenu - en haut', '', ''),
(@max_id + 18, 'fr_FR', 'Édition d\'un contenu - en bas', '', ''),
(@max_id + 19, 'fr_FR', 'Édition d\'une caractéristique - en haut', '', ''),
(@max_id + 20, 'fr_FR', 'Édition d\'une caractéristique - en bas', '', ''),
(@max_id + 21, 'fr_FR', 'Édition d\'un document - en haut', '', ''),
(@max_id + 22, 'fr_FR', 'Édition d\'un document - en bas', '', ''),
(@max_id + 23, 'fr_FR', 'Édition d\'un client - en haut', '', ''),
(@max_id + 24, 'fr_FR', 'Édition d\'un client - en bas', '', ''),
(@max_id + 25, 'fr_FR', 'Édition d\'image - en haut', '', ''),
(@max_id + 26, 'fr_FR', 'Édition d\'image - en bas', '', ''),
(@max_id + 27, 'fr_FR', 'Édition d\'hook - en haut', '', ''),
(@max_id + 28, 'fr_FR', 'Édition d\'hook - en bas', '', ''),
(@max_id + 29, 'fr_FR', 'Édition d\'un dossier - en haut', '', ''),
(@max_id + 30, 'fr_FR', 'Édition d\'un dossier - en bas', '', ''),
(@max_id + 31, 'fr_FR', 'Édition d\'un hook de module - en haut', '', ''),
(@max_id + 32, 'fr_FR', 'Édition d\'un hook de module - en bas', '', ''),
(@max_id + 33, 'fr_FR', 'Édition d\'un module - en haut', '', ''),
(@max_id + 34, 'fr_FR', 'Édition d\'un module - en bas', '', ''),
(@max_id + 35, 'fr_FR', 'Édition d\'un message - en haut', '', ''),
(@max_id + 36, 'fr_FR', 'Édition d\'un message - en bas', '', ''),
(@max_id + 37, 'fr_FR', 'Édition d\'un profil - en haut', '', ''),
(@max_id + 38, 'fr_FR', 'Édition d\'un profil - en bas', '', ''),
(@max_id + 39, 'fr_FR', 'Édition d\'un produit - en haut', '', ''),
(@max_id + 40, 'fr_FR', 'Édition d\'un produit - en bas', '', ''),
(@max_id + 41, 'fr_FR', 'Édition d\'une commande - en haut', '', ''),
(@max_id + 42, 'fr_FR', 'Édition d\'une commande - en bas', '', ''),
(@max_id + 43, 'fr_FR', 'Édition des zones de livraison d\'un transporteur - en haut', '', ''),
(@max_id + 44, 'fr_FR', 'Édition des zones de livraison d\'un transporteur - en bas', '', ''),
(@max_id + 45, 'fr_FR', 'Édition d\'une zone de livraison - en haut', '', ''),
(@max_id + 46, 'fr_FR', 'Édition d\'une zone de livraiso - en bas', '', ''),
(@max_id + 47, 'fr_FR', 'Édition d\'une promotion - en haut', '', ''),
(@max_id + 48, 'fr_FR', 'Édition d\'une promotion - en bas', '', ''),
(@max_id + 49, 'fr_FR', 'Édition d\'une variable - en haut', '', ''),
(@max_id + 50, 'fr_FR', 'Édition d\'une variable - en bas', '', ''),
(@max_id + 51, 'fr_FR', 'Édition d\'un gabarit - en haut', '', ''),
(@max_id + 52, 'fr_FR', 'Édition d\'un gabarit - en bas', '', ''),
(@max_id + 53, 'fr_FR', 'Édition d\'une règle de taxe - en haut', '', ''),
(@max_id + 54, 'fr_FR', 'Édition d\'une règle de taxe - en bas', '', ''),
(@max_id + 55, 'fr_FR', 'Édition d\'une taxe - en haut', '', ''),
(@max_id + 56, 'fr_FR', 'Édition d\'une taxe - en bas', '', ''),
(@max_id + 57, 'fr_FR', 'Édition d\'une commande - sous les informations du produit', '', ''),
(@max_id + 58, 'fr_FR', 'Commande- Onglet', '', ''),
(@max_id + 59, 'fr_FR', 'Détail d\'une commande - Après un produit', '', ''),
(@max_id + 60, 'fr_FR', 'Onglet SEO - en haut', '', ''),
(@max_id + 61, 'fr_FR', 'Onglet SEO - en bas', '', ''),
(@max_id + 62, 'fr_FR', 'Onglet image - en haut', '', ''),
(@max_id + 63, 'fr_FR', 'Onglet image - en bas', '', ''),
(@max_id + 64, 'fr_FR', 'Onglet document - en haut', '', ''),
(@max_id + 65, 'fr_FR', 'Onglet document - en bas', '', '')
;

-- Fix attribute_template and feature_template relations
ALTER TABLE `attribute_template` DROP FOREIGN KEY `fk_attribute_template`; ALTER TABLE `attribute_template` ADD CONSTRAINT `fk_attribute_template` FOREIGN KEY (`template_id`) REFERENCES `template`(`id`) ON DELETE CASCADE ON UPDATE RESTRICT;
ALTER TABLE `feature_template` DROP FOREIGN KEY `fk_feature_template`; ALTER TABLE `feature_template` ADD CONSTRAINT `fk_feature_template` FOREIGN KEY (`template_id`) REFERENCES `template`(`id`) ON DELETE CASCADE ON UPDATE RESTRICT;

SET FOREIGN_KEY_CHECKS = 1;