<?php

/*
 * This file is part of the Thelia package.
 * http://www.thelia.net
 *
 * (c) OpenStudio <info@thelia.net>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Thelia\Core\Event;

class UpdateSeoEvent extends ActionEvent
{
    protected $object_id;
    protected $locale;
    protected $url;
    protected $meta_title;
    protected $meta_description;
    protected $meta_keywords;

    protected $object;

    /**
     * @param null $locale
     * @param null $url
     * @param null $meta_title
     * @param null $meta_description
     * @param null $meta_keywords
     */
    public function __construct($object_id, $locale = null, $url = null, $meta_title = null, $meta_description = null, $meta_keywords = null)
    {
        $this->object_id = $object_id;
        $this->locale = $locale;
        $this->url = $url;
        $this->meta_title = $meta_title;
        $this->meta_description = $meta_description;
        $this->meta_keywords = $meta_keywords;
    }

    public function getObjectId()
    {
        return $this->object_id;
    }

    /**
     * @return $this
     */
    public function setObjectId($object_id)
    {
        $this->object_id = $object_id;

        return $this;
    }

    /**
     * @return null
     */
    public function getLocale()
    {
        return $this->locale;
    }

    /**
     * @return $this
     */
    public function setLocale($locale)
    {
        $this->locale = $locale;

        return $this;
    }

    /**
     * @return null
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @return $this
     */
    public function setUrl($url)
    {
        $this->url = $url;

        return $this;
    }

    /**
     * @return null
     */
    public function getMetaTitle()
    {
        return $this->meta_title;
    }

    /**
     * @return $this
     */
    public function setMetaTitle($meta_title)
    {
        $this->meta_title = $meta_title;

        return $this;
    }

    /**
     * @return null
     */
    public function getMetaDescription()
    {
        return $this->meta_description;
    }

    /**
     * @return $this
     */
    public function setMetaDescription($meta_description)
    {
        $this->meta_description = $meta_description;

        return $this;
    }

    /**
     * @return null
     */
    public function getMetaKeywords()
    {
        return $this->meta_keywords;
    }

    /**
     * @return $this
     */
    public function setMetaKeywords($meta_keywords)
    {
        $this->meta_keywords = $meta_keywords;

        return $this;
    }

    public function setObject($object)
    {
        $this->object = $object;

        return $this;
    }

    public function getObject()
    {
        return $this->object;
    }
}
