{*********************************************************************
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Autor: Brovin Y.D.
 * E-mail: y.brovin@gmail.com
 *
 ********************************************************************}

unit FGX.Colors.Presets;

interface

{$SCOPEDENUMS ON}

uses
  System.Classes;

const

  { At one time many computer displays were only capable of displaying 256 colors. These may be dictated by the hardware
    or changeable by a "color table". When a color is found (e.g., in an image) that is not one available, a different
    one has to be used. This can be done by either using the closest color, which greatly speeds up the load time, or
    by using dithering, which results in more accurate results, but takes longer to load due to the complex calculations.
    See Details: http://en.wikipedia.org/wiki/Web_colors }

  COLORS_PRESET_WEB_SAFE: array [1..216] of TIdentMapEntry =
   ((Value: Integer($FFFFFFCC); Name: 'Unknow'),
    (Value: Integer($FFFFFF99); Name: 'Unknow'),
    (Value: Integer($FFFFFF66); Name: 'Unknow'),
    (Value: Integer($FFFFFF33); Name: 'Unknow'),
    (Value: Integer($FFFFFF00); Name: 'Unknow'),
    (Value: Integer($FFCCCC00); Name: 'Unknow'),
    (Value: Integer($FFFFCC66); Name: 'Unknow'),
    (Value: Integer($FFFFCC00); Name: 'Unknow'),
    (Value: Integer($FFFFCC33); Name: 'Unknow'),
    (Value: Integer($FFCC9900); Name: 'Unknow'),
    (Value: Integer($FFCC9933); Name: 'Unknow'),
    (Value: Integer($FF996600); Name: 'Unknow'),
    (Value: Integer($FFFF9900); Name: 'Unknow'),
    (Value: Integer($FFFF9933); Name: 'Unknow'),
    (Value: Integer($FFCC9966); Name: 'Unknow'),
    (Value: Integer($FFCC6600); Name: 'Unknow'),
    (Value: Integer($FF996633); Name: 'Unknow'),
    (Value: Integer($FF663300); Name: 'Unknow'),
    (Value: Integer($FFFFCC99); Name: 'Unknow'),
    (Value: Integer($FFFF9966); Name: 'Unknow'),
    (Value: Integer($FFFF6600); Name: 'Unknow'),
    (Value: Integer($FFCC6633); Name: 'Unknow'),
    (Value: Integer($FF993300); Name: 'Unknow'),
    (Value: Integer($FF660000); Name: 'Unknow'),
    (Value: Integer($FFFF6633); Name: 'Unknow'),
    (Value: Integer($FFCC3300); Name: 'Unknow'),
    (Value: Integer($FFFF3300); Name: 'Unknow'),
    (Value: Integer($FFFF0000); Name: 'Unknow'),
    (Value: Integer($FFCC0000); Name: 'Unknow'),
    (Value: Integer($FF990000); Name: 'Unknow'),
    (Value: Integer($FFFFCCCC); Name: 'Unknow'),
    (Value: Integer($FFFF9999); Name: 'Unknow'),
    (Value: Integer($FFFF6666); Name: 'Unknow'),
    (Value: Integer($FFFF3333); Name: 'Unknow'),
    (Value: Integer($FFFF0033); Name: 'Unknow'),
    (Value: Integer($FFCC0033); Name: 'Unknow'),
    (Value: Integer($FFCC9999); Name: 'Unknow'),
    (Value: Integer($FFCC6666); Name: 'Unknow'),
    (Value: Integer($FFCC3333); Name: 'Unknow'),
    (Value: Integer($FF993333); Name: 'Unknow'),
    (Value: Integer($FF990033); Name: 'Unknow'),
    (Value: Integer($FF330000); Name: 'Unknow'),
    (Value: Integer($FFFF6699); Name: 'Unknow'),
    (Value: Integer($FFFF3366); Name: 'Unknow'),
    (Value: Integer($FFFF0066); Name: 'Unknow'),
    (Value: Integer($FFCC3366); Name: 'Unknow'),
    (Value: Integer($FF996666); Name: 'Unknow'),
    (Value: Integer($FF663333); Name: 'Unknow'),
    (Value: Integer($FFFF99CC); Name: 'Unknow'),
    (Value: Integer($FFFF3399); Name: 'Unknow'),
    (Value: Integer($FFFF0099); Name: 'Unknow'),
    (Value: Integer($FFCC0066); Name: 'Unknow'),
    (Value: Integer($FF993366); Name: 'Unknow'),
    (Value: Integer($FF660033); Name: 'Unknow'),
    (Value: Integer($FFFF66CC); Name: 'Unknow'),
    (Value: Integer($FFFF00CC); Name: 'Unknow'),
    (Value: Integer($FFFF33CC); Name: 'Unknow'),
    (Value: Integer($FFCC6699); Name: 'Unknow'),
    (Value: Integer($FFCC0099); Name: 'Unknow'),
    (Value: Integer($FF990066); Name: 'Unknow'),
    (Value: Integer($FFFFCCFF); Name: 'Unknow'),
    (Value: Integer($FFFF99FF); Name: 'Unknow'),
    (Value: Integer($FFFF66FF); Name: 'Unknow'),
    (Value: Integer($FFFF33FF); Name: 'Unknow'),
    (Value: Integer($FFFF00FF); Name: 'Unknow'),
    (Value: Integer($FFCC3399); Name: 'Unknow'),
    (Value: Integer($FFCC99CC); Name: 'Unknow'),
    (Value: Integer($FFCC66CC); Name: 'Unknow'),
    (Value: Integer($FFCC00CC); Name: 'Unknow'),
    (Value: Integer($FFCC33CC); Name: 'Unknow'),
    (Value: Integer($FF990099); Name: 'Unknow'),
    (Value: Integer($FF993399); Name: 'Unknow'),
    (Value: Integer($FFCC66FF); Name: 'Unknow'),
    (Value: Integer($FFCC33FF); Name: 'Unknow'),
    (Value: Integer($FFCC00FF); Name: 'Unknow'),
    (Value: Integer($FF9900CC); Name: 'Unknow'),
    (Value: Integer($FF996699); Name: 'Unknow'),
    (Value: Integer($FF660066); Name: 'Unknow'),
    (Value: Integer($FFCC99FF); Name: 'Unknow'),
    (Value: Integer($FF9933CC); Name: 'Unknow'),
    (Value: Integer($FF9933FF); Name: 'Unknow'),
    (Value: Integer($FF9900FF); Name: 'Unknow'),
    (Value: Integer($FF660099); Name: 'Unknow'),
    (Value: Integer($FF663366); Name: 'Unknow'),
    (Value: Integer($FF9966CC); Name: 'Unknow'),
    (Value: Integer($FF9966FF); Name: 'Unknow'),
    (Value: Integer($FF6600CC); Name: 'Unknow'),
    (Value: Integer($FF6633CC); Name: 'Unknow'),
    (Value: Integer($FF663399); Name: 'Unknow'),
    (Value: Integer($FF330033); Name: 'Unknow'),
    (Value: Integer($FFCCCCFF); Name: 'Unknow'),
    (Value: Integer($FF9999FF); Name: 'Unknow'),
    (Value: Integer($FF6633FF); Name: 'Unknow'),
    (Value: Integer($FF6600FF); Name: 'Unknow'),
    (Value: Integer($FF330099); Name: 'Unknow'),
    (Value: Integer($FF330066); Name: 'Unknow'),
    (Value: Integer($FF9999CC); Name: 'Unknow'),
    (Value: Integer($FF6666FF); Name: 'Unknow'),
    (Value: Integer($FF6666CC); Name: 'Unknow'),
    (Value: Integer($FF666699); Name: 'Unknow'),
    (Value: Integer($FF333399); Name: 'Unknow'),
    (Value: Integer($FF333366); Name: 'Unknow'),
    (Value: Integer($FF3333FF); Name: 'Unknow'),
    (Value: Integer($FF3300FF); Name: 'Unknow'),
    (Value: Integer($FF3300CC); Name: 'Unknow'),
    (Value: Integer($FF3333CC); Name: 'Unknow'),
    (Value: Integer($FF000099); Name: 'Unknow'),
    (Value: Integer($FF000066); Name: 'Unknow'),
    (Value: Integer($FF6699FF); Name: 'Unknow'),
    (Value: Integer($FF3366FF); Name: 'Unknow'),
    (Value: Integer($FF0000FF); Name: 'Unknow'),
    (Value: Integer($FF0000CC); Name: 'Unknow'),
    (Value: Integer($FF0033CC); Name: 'Unknow'),
    (Value: Integer($FF000033); Name: 'Unknow'),
    (Value: Integer($FF0066FF); Name: 'Unknow'),
    (Value: Integer($FF0066CC); Name: 'Unknow'),
    (Value: Integer($FF3366CC); Name: 'Unknow'),
    (Value: Integer($FF0033FF); Name: 'Unknow'),
    (Value: Integer($FF003399); Name: 'Unknow'),
    (Value: Integer($FF003366); Name: 'Unknow'),
    (Value: Integer($FF99CCFF); Name: 'Unknow'),
    (Value: Integer($FF3399FF); Name: 'Unknow'),
    (Value: Integer($FF0099FF); Name: 'Unknow'),
    (Value: Integer($FF6699CC); Name: 'Unknow'),
    (Value: Integer($FF336699); Name: 'Unknow'),
    (Value: Integer($FF006699); Name: 'Unknow'),
    (Value: Integer($FF66CCFF); Name: 'Unknow'),
    (Value: Integer($FF33CCFF); Name: 'Unknow'),
    (Value: Integer($FF00CCFF); Name: 'Unknow'),
    (Value: Integer($FF3399CC); Name: 'Unknow'),
    (Value: Integer($FF0099CC); Name: 'Unknow'),
    (Value: Integer($FF003333); Name: 'Unknow'),
    (Value: Integer($FF99CCCC); Name: 'Unknow'),
    (Value: Integer($FF66CCCC); Name: 'Unknow'),
    (Value: Integer($FF339999); Name: 'Unknow'),
    (Value: Integer($FF669999); Name: 'Unknow'),
    (Value: Integer($FF006666); Name: 'Unknow'),
    (Value: Integer($FF336666); Name: 'Unknow'),
    (Value: Integer($FFCCFFFF); Name: 'Unknow'),
    (Value: Integer($FF99FFFF); Name: 'Unknow'),
    (Value: Integer($FF66FFFF); Name: 'Unknow'),
    (Value: Integer($FF33FFFF); Name: 'Unknow'),
    (Value: Integer($FF00FFFF); Name: 'Unknow'),
    (Value: Integer($FF00CCCC); Name: 'Unknow'),
    (Value: Integer($FF99FFCC); Name: 'Unknow'),
    (Value: Integer($FF66FFCC); Name: 'Unknow'),
    (Value: Integer($FF33FFCC); Name: 'Unknow'),
    (Value: Integer($FF00FFCC); Name: 'Unknow'),
    (Value: Integer($FF33CCCC); Name: 'Unknow'),
    (Value: Integer($FF009999); Name: 'Unknow'),
    (Value: Integer($FF66CC99); Name: 'Unknow'),
    (Value: Integer($FF33CC99); Name: 'Unknow'),
    (Value: Integer($FF00CC99); Name: 'Unknow'),
    (Value: Integer($FF339966); Name: 'Unknow'),
    (Value: Integer($FF009966); Name: 'Unknow'),
    (Value: Integer($FF006633); Name: 'Unknow'),
    (Value: Integer($FF66FF99); Name: 'Unknow'),
    (Value: Integer($FF33FF99); Name: 'Unknow'),
    (Value: Integer($FF00FF99); Name: 'Unknow'),
    (Value: Integer($FF33CC66); Name: 'Unknow'),
    (Value: Integer($FF00CC66); Name: 'Unknow'),
    (Value: Integer($FF009933); Name: 'Unknow'),
    (Value: Integer($FF99FF99); Name: 'Unknow'),
    (Value: Integer($FF66FF66); Name: 'Unknow'),
    (Value: Integer($FF33FF66); Name: 'Unknow'),
    (Value: Integer($FF00FF66); Name: 'Unknow'),
    (Value: Integer($FF339933); Name: 'Unknow'),
    (Value: Integer($FF006600); Name: 'Unknow'),
    (Value: Integer($FFCCFFCC); Name: 'Unknow'),
    (Value: Integer($FF99CC99); Name: 'Unknow'),
    (Value: Integer($FF66CC66); Name: 'Unknow'),
    (Value: Integer($FF669966); Name: 'Unknow'),
    (Value: Integer($FF336633); Name: 'Unknow'),
    (Value: Integer($FF003300); Name: 'Unknow'),
    (Value: Integer($FF33FF33); Name: 'Unknow'),
    (Value: Integer($FF00FF33); Name: 'Unknow'),
    (Value: Integer($FF00FF00); Name: 'Unknow'),
    (Value: Integer($FF00CC00); Name: 'Unknow'),
    (Value: Integer($FF33CC33); Name: 'Unknow'),
    (Value: Integer($FF00CC33); Name: 'Unknow'),
    (Value: Integer($FF66FF00); Name: 'Unknow'),
    (Value: Integer($FF66FF33); Name: 'Unknow'),
    (Value: Integer($FF33FF00); Name: 'Unknow'),
    (Value: Integer($FF33CC00); Name: 'Unknow'),
    (Value: Integer($FF339900); Name: 'Unknow'),
    (Value: Integer($FF009900); Name: 'Unknow'),
    (Value: Integer($FFCCFF99); Name: 'Unknow'),
    (Value: Integer($FF99FF66); Name: 'Unknow'),
    (Value: Integer($FF66CC00); Name: 'Unknow'),
    (Value: Integer($FF66CC33); Name: 'Unknow'),
    (Value: Integer($FF669933); Name: 'Unknow'),
    (Value: Integer($FF336600); Name: 'Unknow'),
    (Value: Integer($FF99FF00); Name: 'Unknow'),
    (Value: Integer($FF99FF33); Name: 'Unknow'),
    (Value: Integer($FF99CC66); Name: 'Unknow'),
    (Value: Integer($FF99CC00); Name: 'Unknow'),
    (Value: Integer($FF99CC33); Name: 'Unknow'),
    (Value: Integer($FF669900); Name: 'Unknow'),
    (Value: Integer($FFCCFF66); Name: 'Unknow'),
    (Value: Integer($FFCCFF00); Name: 'Unknow'),
    (Value: Integer($FFCCFF33); Name: 'Unknow'),
    (Value: Integer($FFCCCC99); Name: 'Unknow'),
    (Value: Integer($FF666633); Name: 'Unknow'),
    (Value: Integer($FF333300); Name: 'Unknow'),
    (Value: Integer($FFCCCC66); Name: 'Unknow'),
    (Value: Integer($FFCCCC33); Name: 'Unknow'),
    (Value: Integer($FF999966); Name: 'Unknow'),
    (Value: Integer($FF999933); Name: 'Unknow'),
    (Value: Integer($FF999900); Name: 'Unknow'),
    (Value: Integer($FF666600); Name: 'Unknow'),
    (Value: Integer($FFFFFFFF); Name: 'Unknow'),
    (Value: Integer($FFCCCCCC); Name: 'Unknow'),
    (Value: Integer($FF999999); Name: 'Unknow'),
    (Value: Integer($FF666666); Name: 'Unknow'),
    (Value: Integer($FF333333); Name: 'Unknow'),
    (Value: Integer($FF000000); Name: 'Unknow'));


  { The list of colors actually shipped with the X11 product varies between implementations, and clashes with certain of
    the HTML names such as green. Furthermore, X11 colors are defined as simple RGB (hence, no particular color space),
    rather than sRGB. This means that the list of colors found in X11 (e.g. in /usr/lib/X11/rgb.txt) should not directly
    be used to choose colors for the web.[8]
    See Details:              http://en.wikipedia.org/wiki/Web_colors
    File with all RGB colors: http://cvsweb.xfree86.org/cvsweb/xc/programs/rgb/rgb.txt
    Standart X11:             http://www.w3.org/TR/SVG/types.html#ColorKeywords }

  COLORS_PRESET_X11: array [1..657] of TIdentMapEntry =
   ((Value: Integer($FFFFFAFA); Name: 'Snow'),
    (Value: Integer($FFF8F8FF); Name: 'GhostWhite'),
    (Value: Integer($FFF5F5F5); Name: 'WhiteSmoke'),
    (Value: Integer($FFDCDCDC); Name: 'Gainsboro'),
    (Value: Integer($FFFFFAF0); Name: 'FloralWhite'),
    (Value: Integer($FFFDF5E6); Name: 'OldLace'),
    (Value: Integer($FFFAF0E6); Name: 'Linen'),
    (Value: Integer($FFFAEBD7); Name: 'AntiqueWhite'),
    (Value: Integer($FFFFEFD5); Name: 'PapayaWhip'),
    (Value: Integer($FFFFEBCD); Name: 'BlanchedAlmond'),
    (Value: Integer($FFFFE4C4); Name: 'Bisque'),
    (Value: Integer($FFFFDAB9); Name: 'PeachPuff'),
    (Value: Integer($FFFFDEAD); Name: 'NavajoWhite'),
    (Value: Integer($FFFFE4B5); Name: 'Moccasin'),
    (Value: Integer($FFFFF8DC); Name: 'Cornsilk'),
    (Value: Integer($FFFFFFF0); Name: 'Ivory'),
    (Value: Integer($FFFFFACD); Name: 'LemonChiffon'),
    (Value: Integer($FFFFF5EE); Name: 'Seashell'),
    (Value: Integer($FFF0FFF0); Name: 'Honeydew'),
    (Value: Integer($FFF5FFFA); Name: 'MintCream'),
    (Value: Integer($FFF0FFFF); Name: 'Azure'),
    (Value: Integer($FFF0F8FF); Name: 'AliceBlue'),
    (Value: Integer($FFE6E6FA); Name: 'Lavender'),
    (Value: Integer($FFFFF0F5); Name: 'LavenderBlush'),
    (Value: Integer($FFFFE4E1); Name: 'MistyRose'),
    (Value: Integer($FFFFFFFF); Name: 'White'),
    (Value: Integer($FF000000); Name: 'Black'),
    (Value: Integer($FF2F4F4F); Name: 'DarkSlateGray'),
    (Value: Integer($FF2F4F4F); Name: 'DarkSlateGrey'),
    (Value: Integer($FF696969); Name: 'DimGray'),
    (Value: Integer($FF696969); Name: 'DimGrey'),
    (Value: Integer($FF708090); Name: 'SlateGray'),
    (Value: Integer($FF708090); Name: 'SlateGrey'),
    (Value: Integer($FF778899); Name: 'LightSlateGray'),
    (Value: Integer($FF778899); Name: 'LightSlateGrey'),
    (Value: Integer($FFBEBEBE); Name: 'Gray'),
    (Value: Integer($FFBEBEBE); Name: 'Grey'),
    (Value: Integer($FFD3D3D3); Name: 'LightGrey'),
    (Value: Integer($FFD3D3D3); Name: 'LightGray'),
    (Value: Integer($FF191970); Name: 'MidnightBlue'),
    (Value: Integer($FF000080); Name: 'Navy'),
    (Value: Integer($FF000080); Name: 'NavyBlue'),
    (Value: Integer($FF6495ED); Name: 'CornflowerBlue'),
    (Value: Integer($FF483D8B); Name: 'DarkSlateBlue'),
    (Value: Integer($FF6A5ACD); Name: 'SlateBlue'),
    (Value: Integer($FF7B68EE); Name: 'MediumSlateBlue'),
    (Value: Integer($FF8470FF); Name: 'LightSlateBlue'),
    (Value: Integer($FF0000CD); Name: 'MediumBlue'),
    (Value: Integer($FF4169E1); Name: 'RoyalBlue'),
    (Value: Integer($FF0000FF); Name: 'Blue'),
    (Value: Integer($FF1E90FF); Name: 'DodgerBlue'),
    (Value: Integer($FF00BFFF); Name: 'DeepSkyBlue'),
    (Value: Integer($FF87CEEB); Name: 'SkyBlue'),
    (Value: Integer($FF87CEFA); Name: 'LightSkyBlue'),
    (Value: Integer($FF4682B4); Name: 'SteelBlue'),
    (Value: Integer($FFB0C4DE); Name: 'LightSteelBlue'),
    (Value: Integer($FFADD8E6); Name: 'LightBlue'),
    (Value: Integer($FFB0E0E6); Name: 'PowderBlue'),
    (Value: Integer($FFAFEEEE); Name: 'PaleTurquoise'),
    (Value: Integer($FF00CED1); Name: 'DarkTurquoise'),
    (Value: Integer($FF48D1CC); Name: 'MediumTurquoise'),
    (Value: Integer($FF40E0D0); Name: 'Turquoise'),
    (Value: Integer($FF00FFFF); Name: 'Cyan'),
    (Value: Integer($FFE0FFFF); Name: 'LightCyan'),
    (Value: Integer($FF5F9EA0); Name: 'CadetBlue'),
    (Value: Integer($FF66CDAA); Name: 'MediumAquamarine'),
    (Value: Integer($FF7FFFD4); Name: 'Aquamarine'),
    (Value: Integer($FF006400); Name: 'DarkGreen'),
    (Value: Integer($FF556B2F); Name: 'DarkOliveGreen'),
    (Value: Integer($FF8FBC8F); Name: 'DarkSeaGreen'),
    (Value: Integer($FF2E8B57); Name: 'SeaGreen'),
    (Value: Integer($FF3CB371); Name: 'MediumSeaGreen'),
    (Value: Integer($FF20B2AA); Name: 'LightSeaGreen'),
    (Value: Integer($FF98FB98); Name: 'PaleGreen'),
    (Value: Integer($FF00FF7F); Name: 'SpringGreen'),
    (Value: Integer($FF7CFC00); Name: 'LawnGreen'),
    (Value: Integer($FF00FF00); Name: 'Green'),
    (Value: Integer($FF7FFF00); Name: 'Chartreuse'),
    (Value: Integer($FF00FA9A); Name: 'MediumSpringGreen'),
    (Value: Integer($FFADFF2F); Name: 'GreenYellow'),
    (Value: Integer($FF32CD32); Name: 'LimeGreen'),
    (Value: Integer($FF9ACD32); Name: 'YellowGreen'),
    (Value: Integer($FF228B22); Name: 'ForestGreen'),
    (Value: Integer($FF6B8E23); Name: 'OliveDrab'),
    (Value: Integer($FFBDB76B); Name: 'DarkKhaki'),
    (Value: Integer($FFF0E68C); Name: 'Khaki'),
    (Value: Integer($FFEEE8AA); Name: 'PaleGoldenrod'),
    (Value: Integer($FFFAFAD2); Name: 'LightGoldenrodYellow'),
    (Value: Integer($FFFFFFE0); Name: 'LightYellow'),
    (Value: Integer($FFFFFF00); Name: 'Yellow'),
    (Value: Integer($FFFFD700); Name: 'Gold'),
    (Value: Integer($FFEEDD82); Name: 'LightGoldenrod'),
    (Value: Integer($FFDAA520); Name: 'Goldenrod'),
    (Value: Integer($FFB8860B); Name: 'DarkGoldenrod'),
    (Value: Integer($FFBC8F8F); Name: 'RosyBrown'),
    (Value: Integer($FFCD5C5C); Name: 'IndianRed'),
    (Value: Integer($FF8B4513); Name: 'SaddleBrown'),
    (Value: Integer($FFA0522D); Name: 'Sienna'),
    (Value: Integer($FFCD853F); Name: 'Peru'),
    (Value: Integer($FFDEB887); Name: 'Burlywood'),
    (Value: Integer($FFF5F5DC); Name: 'Beige'),
    (Value: Integer($FFF5DEB3); Name: 'Wheat'),
    (Value: Integer($FFF4A460); Name: 'SandyBrown'),
    (Value: Integer($FFD2B48C); Name: 'Tan'),
    (Value: Integer($FFD2691E); Name: 'Chocolate'),
    (Value: Integer($FFB22222); Name: 'Firebrick'),
    (Value: Integer($FFA52A2A); Name: 'Brown'),
    (Value: Integer($FFE9967A); Name: 'DarkSalmon'),
    (Value: Integer($FFFA8072); Name: 'Salmon'),
    (Value: Integer($FFFFA07A); Name: 'LightSalmon'),
    (Value: Integer($FFFFA500); Name: 'Orange'),
    (Value: Integer($FFFF8C00); Name: 'DarkOrange'),
    (Value: Integer($FFFF7F50); Name: 'Coral'),
    (Value: Integer($FFF08080); Name: 'LightCoral'),
    (Value: Integer($FFFF6347); Name: 'Tomato'),
    (Value: Integer($FFFF4500); Name: 'OrangeRed'),
    (Value: Integer($FFFF0000); Name: 'Red'),
    (Value: Integer($FFFF69B4); Name: 'HotPink'),
    (Value: Integer($FFFF1493); Name: 'DeepPink'),
    (Value: Integer($FFFFC0CB); Name: 'Pink'),
    (Value: Integer($FFFFB6C1); Name: 'LightPink'),
    (Value: Integer($FFDB7093); Name: 'PaleVioletRed'),
    (Value: Integer($FFB03060); Name: 'Maroon'),
    (Value: Integer($FFC71585); Name: 'MediumVioletRed'),
    (Value: Integer($FFD02090); Name: 'VioletRed'),
    (Value: Integer($FFFF00FF); Name: 'Magenta'),
    (Value: Integer($FFEE82EE); Name: 'Violet'),
    (Value: Integer($FFDDA0DD); Name: 'Plum'),
    (Value: Integer($FFDA70D6); Name: 'Orchid'),
    (Value: Integer($FFBA55D3); Name: 'MediumOrchid'),
    (Value: Integer($FF9932CC); Name: 'DarkOrchid'),
    (Value: Integer($FF9400D3); Name: 'DarkViolet'),
    (Value: Integer($FF8A2BE2); Name: 'BlueViolet'),
    (Value: Integer($FFA020F0); Name: 'Purple'),
    (Value: Integer($FF9370DB); Name: 'MediumPurple'),
    (Value: Integer($FFD8BFD8); Name: 'Thistle'),
    (Value: Integer($FFFFFAFA); Name: 'Snow1'),
    (Value: Integer($FFEEE9E9); Name: 'Snow2'),
    (Value: Integer($FFCDC9C9); Name: 'Snow3'),
    (Value: Integer($FF8B8989); Name: 'Snow4'),
    (Value: Integer($FFFFF5EE); Name: 'Seashell1'),
    (Value: Integer($FFEEE5DE); Name: 'Seashell2'),
    (Value: Integer($FFCDC5BF); Name: 'Seashell3'),
    (Value: Integer($FF8B8682); Name: 'Seashell4'),
    (Value: Integer($FFFFEFDB); Name: 'AntiqueWhite1'),
    (Value: Integer($FFEEDFCC); Name: 'AntiqueWhite2'),
    (Value: Integer($FFCDC0B0); Name: 'AntiqueWhite3'),
    (Value: Integer($FF8B8378); Name: 'AntiqueWhite4'),
    (Value: Integer($FFFFE4C4); Name: 'Bisque1'),
    (Value: Integer($FFEED5B7); Name: 'Bisque2'),
    (Value: Integer($FFCDB79E); Name: 'Bisque3'),
    (Value: Integer($FF8B7D6B); Name: 'Bisque4'),
    (Value: Integer($FFFFDAB9); Name: 'PeachPuff1'),
    (Value: Integer($FFEECBAD); Name: 'PeachPuff2'),
    (Value: Integer($FFCDAF95); Name: 'PeachPuff3'),
    (Value: Integer($FF8B7765); Name: 'PeachPuff4'),
    (Value: Integer($FFFFDEAD); Name: 'NavajoWhite1'),
    (Value: Integer($FFEECFA1); Name: 'NavajoWhite2'),
    (Value: Integer($FFCDB38B); Name: 'NavajoWhite3'),
    (Value: Integer($FF8B795E); Name: 'NavajoWhite4'),
    (Value: Integer($FFFFFACD); Name: 'LemonChiffon1'),
    (Value: Integer($FFEEE9BF); Name: 'LemonChiffon2'),
    (Value: Integer($FFCDC9A5); Name: 'LemonChiffon3'),
    (Value: Integer($FF8B8970); Name: 'LemonChiffon4'),
    (Value: Integer($FFFFF8DC); Name: 'Cornsilk1'),
    (Value: Integer($FFEEE8CD); Name: 'Cornsilk2'),
    (Value: Integer($FFCDC8B1); Name: 'Cornsilk3'),
    (Value: Integer($FF8B8878); Name: 'Cornsilk4'),
    (Value: Integer($FFFFFFF0); Name: 'Ivory1'),
    (Value: Integer($FFEEEEE0); Name: 'Ivory2'),
    (Value: Integer($FFCDCDC1); Name: 'Ivory3'),
    (Value: Integer($FF8B8B83); Name: 'Ivory4'),
    (Value: Integer($FFF0FFF0); Name: 'Honeydew1'),
    (Value: Integer($FFE0EEE0); Name: 'Honeydew2'),
    (Value: Integer($FFC1CDC1); Name: 'Honeydew3'),
    (Value: Integer($FF838B83); Name: 'Honeydew4'),
    (Value: Integer($FFFFF0F5); Name: 'LavenderBlush1'),
    (Value: Integer($FFEEE0E5); Name: 'LavenderBlush2'),
    (Value: Integer($FFCDC1C5); Name: 'LavenderBlush3'),
    (Value: Integer($FF8B8386); Name: 'LavenderBlush4'),
    (Value: Integer($FFFFE4E1); Name: 'MistyRose1'),
    (Value: Integer($FFEED5D2); Name: 'MistyRose2'),
    (Value: Integer($FFCDB7B5); Name: 'MistyRose3'),
    (Value: Integer($FF8B7D7B); Name: 'MistyRose4'),
    (Value: Integer($FFF0FFFF); Name: 'Azure1'),
    (Value: Integer($FFE0EEEE); Name: 'Azure2'),
    (Value: Integer($FFC1CDCD); Name: 'Azure3'),
    (Value: Integer($FF838B8B); Name: 'Azure4'),
    (Value: Integer($FF836FFF); Name: 'SlateBlue1'),
    (Value: Integer($FF7A67EE); Name: 'SlateBlue2'),
    (Value: Integer($FF6959CD); Name: 'SlateBlue3'),
    (Value: Integer($FF473C8B); Name: 'SlateBlue4'),
    (Value: Integer($FF4876FF); Name: 'RoyalBlue1'),
    (Value: Integer($FF436EEE); Name: 'RoyalBlue2'),
    (Value: Integer($FF3A5FCD); Name: 'RoyalBlue3'),
    (Value: Integer($FF27408B); Name: 'RoyalBlue4'),
    (Value: Integer($FF0000FF); Name: 'Blue1'),
    (Value: Integer($FF0000EE); Name: 'Blue2'),
    (Value: Integer($FF0000CD); Name: 'Blue3'),
    (Value: Integer($FF00008B); Name: 'Blue4'),
    (Value: Integer($FF1E90FF); Name: 'DodgerBlue1'),
    (Value: Integer($FF1C86EE); Name: 'DodgerBlue2'),
    (Value: Integer($FF1874CD); Name: 'DodgerBlue3'),
    (Value: Integer($FF104E8B); Name: 'DodgerBlue4'),
    (Value: Integer($FF63B8FF); Name: 'SteelBlue1'),
    (Value: Integer($FF5CACEE); Name: 'SteelBlue2'),
    (Value: Integer($FF4F94CD); Name: 'SteelBlue3'),
    (Value: Integer($FF36648B); Name: 'SteelBlue4'),
    (Value: Integer($FF00BFFF); Name: 'DeepSkyBlue1'),
    (Value: Integer($FF00B2EE); Name: 'DeepSkyBlue2'),
    (Value: Integer($FF009ACD); Name: 'DeepSkyBlue3'),
    (Value: Integer($FF00688B); Name: 'DeepSkyBlue4'),
    (Value: Integer($FF87CEFF); Name: 'SkyBlue1'),
    (Value: Integer($FF7EC0EE); Name: 'SkyBlue2'),
    (Value: Integer($FF6CA6CD); Name: 'SkyBlue3'),
    (Value: Integer($FF4A708B); Name: 'SkyBlue4'),
    (Value: Integer($FFB0E2FF); Name: 'LightSkyBlue1'),
    (Value: Integer($FFA4D3EE); Name: 'LightSkyBlue2'),
    (Value: Integer($FF8DB6CD); Name: 'LightSkyBlue3'),
    (Value: Integer($FF607B8B); Name: 'LightSkyBlue4'),
    (Value: Integer($FFC6E2FF); Name: 'SlateGray1'),
    (Value: Integer($FFB9D3EE); Name: 'SlateGray2'),
    (Value: Integer($FF9FB6CD); Name: 'SlateGray3'),
    (Value: Integer($FF6C7B8B); Name: 'SlateGray4'),
    (Value: Integer($FFCAE1FF); Name: 'LightSteelBlue1'),
    (Value: Integer($FFBCD2EE); Name: 'LightSteelBlue2'),
    (Value: Integer($FFA2B5CD); Name: 'LightSteelBlue3'),
    (Value: Integer($FF6E7B8B); Name: 'LightSteelBlue4'),
    (Value: Integer($FFBFEFFF); Name: 'LightBlue1'),
    (Value: Integer($FFB2DFEE); Name: 'LightBlue2'),
    (Value: Integer($FF9AC0CD); Name: 'LightBlue3'),
    (Value: Integer($FF68838B); Name: 'LightBlue4'),
    (Value: Integer($FFE0FFFF); Name: 'LightCyan1'),
    (Value: Integer($FFD1EEEE); Name: 'LightCyan2'),
    (Value: Integer($FFB4CDCD); Name: 'LightCyan3'),
    (Value: Integer($FF7A8B8B); Name: 'LightCyan4'),
    (Value: Integer($FFBBFFFF); Name: 'PaleTurquoise1'),
    (Value: Integer($FFAEEEEE); Name: 'PaleTurquoise2'),
    (Value: Integer($FF96CDCD); Name: 'PaleTurquoise3'),
    (Value: Integer($FF668B8B); Name: 'PaleTurquoise4'),
    (Value: Integer($FF98F5FF); Name: 'CadetBlue1'),
    (Value: Integer($FF8EE5EE); Name: 'CadetBlue2'),
    (Value: Integer($FF7AC5CD); Name: 'CadetBlue3'),
    (Value: Integer($FF53868B); Name: 'CadetBlue4'),
    (Value: Integer($FF00F5FF); Name: 'Turquoise1'),
    (Value: Integer($FF00E5EE); Name: 'Turquoise2'),
    (Value: Integer($FF00C5CD); Name: 'Turquoise3'),
    (Value: Integer($FF00868B); Name: 'Turquoise4'),
    (Value: Integer($FF00FFFF); Name: 'Cyan1'),
    (Value: Integer($FF00EEEE); Name: 'Cyan2'),
    (Value: Integer($FF00CDCD); Name: 'Cyan3'),
    (Value: Integer($FF008B8B); Name: 'Cyan4'),
    (Value: Integer($FF97FFFF); Name: 'DarkSlateGray1'),
    (Value: Integer($FF8DEEEE); Name: 'DarkSlateGray2'),
    (Value: Integer($FF79CDCD); Name: 'DarkSlateGray3'),
    (Value: Integer($FF528B8B); Name: 'DarkSlateGray4'),
    (Value: Integer($FF7FFFD4); Name: 'Aquamarine1'),
    (Value: Integer($FF76EEC6); Name: 'Aquamarine2'),
    (Value: Integer($FF66CDAA); Name: 'Aquamarine3'),
    (Value: Integer($FF458B74); Name: 'Aquamarine4'),
    (Value: Integer($FFC1FFC1); Name: 'DarkSeaGreen1'),
    (Value: Integer($FFB4EEB4); Name: 'DarkSeaGreen2'),
    (Value: Integer($FF9BCD9B); Name: 'DarkSeaGreen3'),
    (Value: Integer($FF698B69); Name: 'DarkSeaGreen4'),
    (Value: Integer($FF54FF9F); Name: 'SeaGreen1'),
    (Value: Integer($FF4EEE94); Name: 'SeaGreen2'),
    (Value: Integer($FF43CD80); Name: 'SeaGreen3'),
    (Value: Integer($FF2E8B57); Name: 'SeaGreen4'),
    (Value: Integer($FF9AFF9A); Name: 'PaleGreen1'),
    (Value: Integer($FF90EE90); Name: 'PaleGreen2'),
    (Value: Integer($FF7CCD7C); Name: 'PaleGreen3'),
    (Value: Integer($FF548B54); Name: 'PaleGreen4'),
    (Value: Integer($FF00FF7F); Name: 'SpringGreen1'),
    (Value: Integer($FF00EE76); Name: 'SpringGreen2'),
    (Value: Integer($FF00CD66); Name: 'SpringGreen3'),
    (Value: Integer($FF008B45); Name: 'SpringGreen4'),
    (Value: Integer($FF00FF00); Name: 'Green1'),
    (Value: Integer($FF00EE00); Name: 'Green2'),
    (Value: Integer($FF00CD00); Name: 'Green3'),
    (Value: Integer($FF008B00); Name: 'Green4'),
    (Value: Integer($FF7FFF00); Name: 'Chartreuse1'),
    (Value: Integer($FF76EE00); Name: 'Chartreuse2'),
    (Value: Integer($FF66CD00); Name: 'Chartreuse3'),
    (Value: Integer($FF458B00); Name: 'Chartreuse4'),
    (Value: Integer($FFC0FF3E); Name: 'OliveDrab1'),
    (Value: Integer($FFB3EE3A); Name: 'OliveDrab2'),
    (Value: Integer($FF9ACD32); Name: 'OliveDrab3'),
    (Value: Integer($FF698B22); Name: 'OliveDrab4'),
    (Value: Integer($FFCAFF70); Name: 'DarkOliveGreen1'),
    (Value: Integer($FFBCEE68); Name: 'DarkOliveGreen2'),
    (Value: Integer($FFA2CD5A); Name: 'DarkOliveGreen3'),
    (Value: Integer($FF6E8B3D); Name: 'DarkOliveGreen4'),
    (Value: Integer($FFFFF68F); Name: 'Khaki1'),
    (Value: Integer($FFEEE685); Name: 'Khaki2'),
    (Value: Integer($FFCDC673); Name: 'Khaki3'),
    (Value: Integer($FF8B864E); Name: 'Khaki4'),
    (Value: Integer($FFFFEC8B); Name: 'LightGoldenrod1'),
    (Value: Integer($FFEEDC82); Name: 'LightGoldenrod2'),
    (Value: Integer($FFCDBE70); Name: 'LightGoldenrod3'),
    (Value: Integer($FF8B814C); Name: 'LightGoldenrod4'),
    (Value: Integer($FFFFFFE0); Name: 'LightYellow1'),
    (Value: Integer($FFEEEED1); Name: 'LightYellow2'),
    (Value: Integer($FFCDCDB4); Name: 'LightYellow3'),
    (Value: Integer($FF8B8B7A); Name: 'LightYellow4'),
    (Value: Integer($FFFFFF00); Name: 'Yellow1'),
    (Value: Integer($FFEEEE00); Name: 'Yellow2'),
    (Value: Integer($FFCDCD00); Name: 'Yellow3'),
    (Value: Integer($FF8B8B00); Name: 'Yellow4'),
    (Value: Integer($FFFFD700); Name: 'Gold1'),
    (Value: Integer($FFEEC900); Name: 'Gold2'),
    (Value: Integer($FFCDAD00); Name: 'Gold3'),
    (Value: Integer($FF8B7500); Name: 'Gold4'),
    (Value: Integer($FFFFC125); Name: 'Goldenrod1'),
    (Value: Integer($FFEEB422); Name: 'Goldenrod2'),
    (Value: Integer($FFCD9B1D); Name: 'Goldenrod3'),
    (Value: Integer($FF8B6914); Name: 'Goldenrod4'),
    (Value: Integer($FFFFB90F); Name: 'DarkGoldenrod1'),
    (Value: Integer($FFEEAD0E); Name: 'DarkGoldenrod2'),
    (Value: Integer($FFCD950C); Name: 'DarkGoldenrod3'),
    (Value: Integer($FF8B6508); Name: 'DarkGoldenrod4'),
    (Value: Integer($FFFFC1C1); Name: 'RosyBrown1'),
    (Value: Integer($FFEEB4B4); Name: 'RosyBrown2'),
    (Value: Integer($FFCD9B9B); Name: 'RosyBrown3'),
    (Value: Integer($FF8B6969); Name: 'RosyBrown4'),
    (Value: Integer($FFFF6A6A); Name: 'IndianRed1'),
    (Value: Integer($FFEE6363); Name: 'IndianRed2'),
    (Value: Integer($FFCD5555); Name: 'IndianRed3'),
    (Value: Integer($FF8B3A3A); Name: 'IndianRed4'),
    (Value: Integer($FFFF8247); Name: 'Sienna1'),
    (Value: Integer($FFEE7942); Name: 'Sienna2'),
    (Value: Integer($FFCD6839); Name: 'Sienna3'),
    (Value: Integer($FF8B4726); Name: 'Sienna4'),
    (Value: Integer($FFFFD39B); Name: 'Burlywood1'),
    (Value: Integer($FFEEC591); Name: 'Burlywood2'),
    (Value: Integer($FFCDAA7D); Name: 'Burlywood3'),
    (Value: Integer($FF8B7355); Name: 'Burlywood4'),
    (Value: Integer($FFFFE7BA); Name: 'Wheat1'),
    (Value: Integer($FFEED8AE); Name: 'Wheat2'),
    (Value: Integer($FFCDBA96); Name: 'Wheat3'),
    (Value: Integer($FF8B7E66); Name: 'Wheat4'),
    (Value: Integer($FFFFA54F); Name: 'Tan1'),
    (Value: Integer($FFEE9A49); Name: 'Tan2'),
    (Value: Integer($FFCD853F); Name: 'Tan3'),
    (Value: Integer($FF8B5A2B); Name: 'Tan4'),
    (Value: Integer($FFFF7F24); Name: 'Chocolate1'),
    (Value: Integer($FFEE7621); Name: 'Chocolate2'),
    (Value: Integer($FFCD661D); Name: 'Chocolate3'),
    (Value: Integer($FF8B4513); Name: 'Chocolate4'),
    (Value: Integer($FFFF3030); Name: 'Firebrick1'),
    (Value: Integer($FFEE2C2C); Name: 'Firebrick2'),
    (Value: Integer($FFCD2626); Name: 'Firebrick3'),
    (Value: Integer($FF8B1A1A); Name: 'Firebrick4'),
    (Value: Integer($FFFF4040); Name: 'Brown1'),
    (Value: Integer($FFEE3B3B); Name: 'Brown2'),
    (Value: Integer($FFCD3333); Name: 'Brown3'),
    (Value: Integer($FF8B2323); Name: 'Brown4'),
    (Value: Integer($FFFF8C69); Name: 'Salmon1'),
    (Value: Integer($FFEE8262); Name: 'Salmon2'),
    (Value: Integer($FFCD7054); Name: 'Salmon3'),
    (Value: Integer($FF8B4C39); Name: 'Salmon4'),
    (Value: Integer($FFFFA07A); Name: 'LightSalmon1'),
    (Value: Integer($FFEE9572); Name: 'LightSalmon2'),
    (Value: Integer($FFCD8162); Name: 'LightSalmon3'),
    (Value: Integer($FF8B5742); Name: 'LightSalmon4'),
    (Value: Integer($FFFFA500); Name: 'Orange1'),
    (Value: Integer($FFEE9A00); Name: 'Orange2'),
    (Value: Integer($FFCD8500); Name: 'Orange3'),
    (Value: Integer($FF8B5A00); Name: 'Orange4'),
    (Value: Integer($FFFF7F00); Name: 'DarkOrange1'),
    (Value: Integer($FFEE7600); Name: 'DarkOrange2'),
    (Value: Integer($FFCD6600); Name: 'DarkOrange3'),
    (Value: Integer($FF8B4500); Name: 'DarkOrange4'),
    (Value: Integer($FFFF7256); Name: 'Coral1'),
    (Value: Integer($FFEE6A50); Name: 'Coral2'),
    (Value: Integer($FFCD5B45); Name: 'Coral3'),
    (Value: Integer($FF8B3E2F); Name: 'Coral4'),
    (Value: Integer($FFFF6347); Name: 'Tomato1'),
    (Value: Integer($FFEE5C42); Name: 'Tomato2'),
    (Value: Integer($FFCD4F39); Name: 'Tomato3'),
    (Value: Integer($FF8B3626); Name: 'Tomato4'),
    (Value: Integer($FFFF4500); Name: 'OrangeRed1'),
    (Value: Integer($FFEE4000); Name: 'OrangeRed2'),
    (Value: Integer($FFCD3700); Name: 'OrangeRed3'),
    (Value: Integer($FF8B2500); Name: 'OrangeRed4'),
    (Value: Integer($FFFF0000); Name: 'Red1'),
    (Value: Integer($FFEE0000); Name: 'Red2'),
    (Value: Integer($FFCD0000); Name: 'Red3'),
    (Value: Integer($FF8B0000); Name: 'Red4'),
    (Value: Integer($FFFF1493); Name: 'DeepPink1'),
    (Value: Integer($FFEE1289); Name: 'DeepPink2'),
    (Value: Integer($FFCD1076); Name: 'DeepPink3'),
    (Value: Integer($FF8B0A50); Name: 'DeepPink4'),
    (Value: Integer($FFFF6EB4); Name: 'HotPink1'),
    (Value: Integer($FFEE6AA7); Name: 'HotPink2'),
    (Value: Integer($FFCD6090); Name: 'HotPink3'),
    (Value: Integer($FF8B3A62); Name: 'HotPink4'),
    (Value: Integer($FFFFB5C5); Name: 'Pink1'),
    (Value: Integer($FFEEA9B8); Name: 'Pink2'),
    (Value: Integer($FFCD919E); Name: 'Pink3'),
    (Value: Integer($FF8B636C); Name: 'Pink4'),
    (Value: Integer($FFFFAEB9); Name: 'LightPink1'),
    (Value: Integer($FFEEA2AD); Name: 'LightPink2'),
    (Value: Integer($FFCD8C95); Name: 'LightPink3'),
    (Value: Integer($FF8B5F65); Name: 'LightPink4'),
    (Value: Integer($FFFF82AB); Name: 'PaleVioletRed1'),
    (Value: Integer($FFEE799F); Name: 'PaleVioletRed2'),
    (Value: Integer($FFCD6889); Name: 'PaleVioletRed3'),
    (Value: Integer($FF8B475D); Name: 'PaleVioletRed4'),
    (Value: Integer($FFFF34B3); Name: 'Maroon1'),
    (Value: Integer($FFEE30A7); Name: 'Maroon2'),
    (Value: Integer($FFCD2990); Name: 'Maroon3'),
    (Value: Integer($FF8B1C62); Name: 'Maroon4'),
    (Value: Integer($FFFF3E96); Name: 'VioletRed1'),
    (Value: Integer($FFEE3A8C); Name: 'VioletRed2'),
    (Value: Integer($FFCD3278); Name: 'VioletRed3'),
    (Value: Integer($FF8B2252); Name: 'VioletRed4'),
    (Value: Integer($FFFF00FF); Name: 'Magenta1'),
    (Value: Integer($FFEE00EE); Name: 'Magenta2'),
    (Value: Integer($FFCD00CD); Name: 'Magenta3'),
    (Value: Integer($FF8B008B); Name: 'Magenta4'),
    (Value: Integer($FFFF83FA); Name: 'Orchid1'),
    (Value: Integer($FFEE7AE9); Name: 'Orchid2'),
    (Value: Integer($FFCD69C9); Name: 'Orchid3'),
    (Value: Integer($FF8B4789); Name: 'Orchid4'),
    (Value: Integer($FFFFBBFF); Name: 'Plum1'),
    (Value: Integer($FFEEAEEE); Name: 'Plum2'),
    (Value: Integer($FFCD96CD); Name: 'Plum3'),
    (Value: Integer($FF8B668B); Name: 'Plum4'),
    (Value: Integer($FFE066FF); Name: 'MediumOrchid1'),
    (Value: Integer($FFD15FEE); Name: 'MediumOrchid2'),
    (Value: Integer($FFB452CD); Name: 'MediumOrchid3'),
    (Value: Integer($FF7A378B); Name: 'MediumOrchid4'),
    (Value: Integer($FFBF3EFF); Name: 'DarkOrchid1'),
    (Value: Integer($FFB23AEE); Name: 'DarkOrchid2'),
    (Value: Integer($FF9A32CD); Name: 'DarkOrchid3'),
    (Value: Integer($FF68228B); Name: 'DarkOrchid4'),
    (Value: Integer($FF9B30FF); Name: 'Purple1'),
    (Value: Integer($FF912CEE); Name: 'Purple2'),
    (Value: Integer($FF7D26CD); Name: 'Purple3'),
    (Value: Integer($FF551A8B); Name: 'Purple4'),
    (Value: Integer($FFAB82FF); Name: 'MediumPurple1'),
    (Value: Integer($FF9F79EE); Name: 'MediumPurple2'),
    (Value: Integer($FF8968CD); Name: 'MediumPurple3'),
    (Value: Integer($FF5D478B); Name: 'MediumPurple4'),
    (Value: Integer($FFFFE1FF); Name: 'Thistle1'),
    (Value: Integer($FFEED2EE); Name: 'Thistle2'),
    (Value: Integer($FFCDB5CD); Name: 'Thistle3'),
    (Value: Integer($FF8B7B8B); Name: 'Thistle4'),
    (Value: Integer($FF000000); Name: 'Gray0'),
    (Value: Integer($FF000000); Name: 'Grey0'),
    (Value: Integer($FF030303); Name: 'Gray1'),
    (Value: Integer($FF030303); Name: 'Grey1'),
    (Value: Integer($FF050505); Name: 'Gray2'),
    (Value: Integer($FF050505); Name: 'Grey2'),
    (Value: Integer($FF080808); Name: 'Gray3'),
    (Value: Integer($FF080808); Name: 'Grey3'),
    (Value: Integer($FF0A0A0A); Name: 'Gray4'),
    (Value: Integer($FF0A0A0A); Name: 'Grey4'),
    (Value: Integer($FF0D0D0D); Name: 'Gray5'),
    (Value: Integer($FF0D0D0D); Name: 'Grey5'),
    (Value: Integer($FF0F0F0F); Name: 'Gray6'),
    (Value: Integer($FF0F0F0F); Name: 'Grey6'),
    (Value: Integer($FF121212); Name: 'Gray7'),
    (Value: Integer($FF121212); Name: 'Grey7'),
    (Value: Integer($FF141414); Name: 'Gray8'),
    (Value: Integer($FF141414); Name: 'Grey8'),
    (Value: Integer($FF171717); Name: 'Gray9'),
    (Value: Integer($FF171717); Name: 'Grey9'),
    (Value: Integer($FF1A1A1A); Name: 'Gray10'),
    (Value: Integer($FF1A1A1A); Name: 'Grey10'),
    (Value: Integer($FF1C1C1C); Name: 'Gray11'),
    (Value: Integer($FF1C1C1C); Name: 'Grey11'),
    (Value: Integer($FF1F1F1F); Name: 'Gray12'),
    (Value: Integer($FF1F1F1F); Name: 'Grey12'),
    (Value: Integer($FF212121); Name: 'Gray13'),
    (Value: Integer($FF212121); Name: 'Grey13'),
    (Value: Integer($FF242424); Name: 'Gray14'),
    (Value: Integer($FF242424); Name: 'Grey14'),
    (Value: Integer($FF262626); Name: 'Gray15'),
    (Value: Integer($FF262626); Name: 'Grey15'),
    (Value: Integer($FF292929); Name: 'Gray16'),
    (Value: Integer($FF292929); Name: 'Grey16'),
    (Value: Integer($FF2B2B2B); Name: 'Gray17'),
    (Value: Integer($FF2B2B2B); Name: 'Grey17'),
    (Value: Integer($FF2E2E2E); Name: 'Gray18'),
    (Value: Integer($FF2E2E2E); Name: 'Grey18'),
    (Value: Integer($FF303030); Name: 'Gray19'),
    (Value: Integer($FF303030); Name: 'Grey19'),
    (Value: Integer($FF333333); Name: 'Gray20'),
    (Value: Integer($FF333333); Name: 'Grey20'),
    (Value: Integer($FF363636); Name: 'Gray21'),
    (Value: Integer($FF363636); Name: 'Grey21'),
    (Value: Integer($FF383838); Name: 'Gray22'),
    (Value: Integer($FF383838); Name: 'Grey22'),
    (Value: Integer($FF3B3B3B); Name: 'Gray23'),
    (Value: Integer($FF3B3B3B); Name: 'Grey23'),
    (Value: Integer($FF3D3D3D); Name: 'Gray24'),
    (Value: Integer($FF3D3D3D); Name: 'Grey24'),
    (Value: Integer($FF404040); Name: 'Gray25'),
    (Value: Integer($FF404040); Name: 'Grey25'),
    (Value: Integer($FF424242); Name: 'Gray26'),
    (Value: Integer($FF424242); Name: 'Grey26'),
    (Value: Integer($FF454545); Name: 'Gray27'),
    (Value: Integer($FF454545); Name: 'Grey27'),
    (Value: Integer($FF474747); Name: 'Gray28'),
    (Value: Integer($FF474747); Name: 'Grey28'),
    (Value: Integer($FF4A4A4A); Name: 'Gray29'),
    (Value: Integer($FF4A4A4A); Name: 'Grey29'),
    (Value: Integer($FF4D4D4D); Name: 'Gray30'),
    (Value: Integer($FF4D4D4D); Name: 'Grey30'),
    (Value: Integer($FF4F4F4F); Name: 'Gray31'),
    (Value: Integer($FF4F4F4F); Name: 'Grey31'),
    (Value: Integer($FF525252); Name: 'Gray32'),
    (Value: Integer($FF525252); Name: 'Grey32'),
    (Value: Integer($FF545454); Name: 'Gray33'),
    (Value: Integer($FF545454); Name: 'Grey33'),
    (Value: Integer($FF575757); Name: 'Gray34'),
    (Value: Integer($FF575757); Name: 'Grey34'),
    (Value: Integer($FF595959); Name: 'Gray35'),
    (Value: Integer($FF595959); Name: 'Grey35'),
    (Value: Integer($FF5C5C5C); Name: 'Gray36'),
    (Value: Integer($FF5C5C5C); Name: 'Grey36'),
    (Value: Integer($FF5E5E5E); Name: 'Gray37'),
    (Value: Integer($FF5E5E5E); Name: 'Grey37'),
    (Value: Integer($FF616161); Name: 'Gray38'),
    (Value: Integer($FF616161); Name: 'Grey38'),
    (Value: Integer($FF636363); Name: 'Gray39'),
    (Value: Integer($FF636363); Name: 'Grey39'),
    (Value: Integer($FF666666); Name: 'Gray40'),
    (Value: Integer($FF666666); Name: 'Grey40'),
    (Value: Integer($FF696969); Name: 'Gray41'),
    (Value: Integer($FF696969); Name: 'Grey41'),
    (Value: Integer($FF6B6B6B); Name: 'Gray42'),
    (Value: Integer($FF6B6B6B); Name: 'Grey42'),
    (Value: Integer($FF6E6E6E); Name: 'Gray43'),
    (Value: Integer($FF6E6E6E); Name: 'Grey43'),
    (Value: Integer($FF707070); Name: 'Gray44'),
    (Value: Integer($FF707070); Name: 'Grey44'),
    (Value: Integer($FF737373); Name: 'Gray45'),
    (Value: Integer($FF737373); Name: 'Grey45'),
    (Value: Integer($FF757575); Name: 'Gray46'),
    (Value: Integer($FF757575); Name: 'Grey46'),
    (Value: Integer($FF787878); Name: 'Gray47'),
    (Value: Integer($FF787878); Name: 'Grey47'),
    (Value: Integer($FF7A7A7A); Name: 'Gray48'),
    (Value: Integer($FF7A7A7A); Name: 'Grey48'),
    (Value: Integer($FF7D7D7D); Name: 'Gray49'),
    (Value: Integer($FF7D7D7D); Name: 'Grey49'),
    (Value: Integer($FF7F7F7F); Name: 'Gray50'),
    (Value: Integer($FF7F7F7F); Name: 'Grey50'),
    (Value: Integer($FF828282); Name: 'Gray51'),
    (Value: Integer($FF828282); Name: 'Grey51'),
    (Value: Integer($FF858585); Name: 'Gray52'),
    (Value: Integer($FF858585); Name: 'Grey52'),
    (Value: Integer($FF878787); Name: 'Gray53'),
    (Value: Integer($FF878787); Name: 'Grey53'),
    (Value: Integer($FF8A8A8A); Name: 'Gray54'),
    (Value: Integer($FF8A8A8A); Name: 'Grey54'),
    (Value: Integer($FF8C8C8C); Name: 'Gray55'),
    (Value: Integer($FF8C8C8C); Name: 'Grey55'),
    (Value: Integer($FF8F8F8F); Name: 'Gray56'),
    (Value: Integer($FF8F8F8F); Name: 'Grey56'),
    (Value: Integer($FF919191); Name: 'Gray57'),
    (Value: Integer($FF919191); Name: 'Grey57'),
    (Value: Integer($FF949494); Name: 'Gray58'),
    (Value: Integer($FF949494); Name: 'Grey58'),
    (Value: Integer($FF969696); Name: 'Gray59'),
    (Value: Integer($FF969696); Name: 'Grey59'),
    (Value: Integer($FF999999); Name: 'Gray60'),
    (Value: Integer($FF999999); Name: 'Grey60'),
    (Value: Integer($FF9C9C9C); Name: 'Gray61'),
    (Value: Integer($FF9C9C9C); Name: 'Grey61'),
    (Value: Integer($FF9E9E9E); Name: 'Gray62'),
    (Value: Integer($FF9E9E9E); Name: 'Grey62'),
    (Value: Integer($FFA1A1A1); Name: 'Gray63'),
    (Value: Integer($FFA1A1A1); Name: 'Grey63'),
    (Value: Integer($FFA3A3A3); Name: 'Gray64'),
    (Value: Integer($FFA3A3A3); Name: 'Grey64'),
    (Value: Integer($FFA6A6A6); Name: 'Gray65'),
    (Value: Integer($FFA6A6A6); Name: 'Grey65'),
    (Value: Integer($FFA8A8A8); Name: 'Gray66'),
    (Value: Integer($FFA8A8A8); Name: 'Grey66'),
    (Value: Integer($FFABABAB); Name: 'Gray67'),
    (Value: Integer($FFABABAB); Name: 'Grey67'),
    (Value: Integer($FFADADAD); Name: 'Gray68'),
    (Value: Integer($FFADADAD); Name: 'Grey68'),
    (Value: Integer($FFB0B0B0); Name: 'Gray69'),
    (Value: Integer($FFB0B0B0); Name: 'Grey69'),
    (Value: Integer($FFB3B3B3); Name: 'Gray70'),
    (Value: Integer($FFB3B3B3); Name: 'Grey70'),
    (Value: Integer($FFB5B5B5); Name: 'Gray71'),
    (Value: Integer($FFB5B5B5); Name: 'Grey71'),
    (Value: Integer($FFB8B8B8); Name: 'Gray72'),
    (Value: Integer($FFB8B8B8); Name: 'Grey72'),
    (Value: Integer($FFBABABA); Name: 'Gray73'),
    (Value: Integer($FFBABABA); Name: 'Grey73'),
    (Value: Integer($FFBDBDBD); Name: 'Gray74'),
    (Value: Integer($FFBDBDBD); Name: 'Grey74'),
    (Value: Integer($FFBFBFBF); Name: 'Gray75'),
    (Value: Integer($FFBFBFBF); Name: 'Grey75'),
    (Value: Integer($FFC2C2C2); Name: 'Gray76'),
    (Value: Integer($FFC2C2C2); Name: 'Grey76'),
    (Value: Integer($FFC4C4C4); Name: 'Gray77'),
    (Value: Integer($FFC4C4C4); Name: 'Grey77'),
    (Value: Integer($FFC7C7C7); Name: 'Gray78'),
    (Value: Integer($FFC7C7C7); Name: 'Grey78'),
    (Value: Integer($FFC9C9C9); Name: 'Gray79'),
    (Value: Integer($FFC9C9C9); Name: 'Grey79'),
    (Value: Integer($FFCCCCCC); Name: 'Gray80'),
    (Value: Integer($FFCCCCCC); Name: 'Grey80'),
    (Value: Integer($FFCFCFCF); Name: 'Gray81'),
    (Value: Integer($FFCFCFCF); Name: 'Grey81'),
    (Value: Integer($FFD1D1D1); Name: 'Gray82'),
    (Value: Integer($FFD1D1D1); Name: 'Grey82'),
    (Value: Integer($FFD4D4D4); Name: 'Gray83'),
    (Value: Integer($FFD4D4D4); Name: 'Grey83'),
    (Value: Integer($FFD6D6D6); Name: 'Gray84'),
    (Value: Integer($FFD6D6D6); Name: 'Grey84'),
    (Value: Integer($FFD9D9D9); Name: 'Gray85'),
    (Value: Integer($FFD9D9D9); Name: 'Grey85'),
    (Value: Integer($FFDBDBDB); Name: 'Gray86'),
    (Value: Integer($FFDBDBDB); Name: 'Grey86'),
    (Value: Integer($FFDEDEDE); Name: 'Gray87'),
    (Value: Integer($FFDEDEDE); Name: 'Grey87'),
    (Value: Integer($FFE0E0E0); Name: 'Gray88'),
    (Value: Integer($FFE0E0E0); Name: 'Grey88'),
    (Value: Integer($FFE3E3E3); Name: 'Gray89'),
    (Value: Integer($FFE3E3E3); Name: 'Grey89'),
    (Value: Integer($FFE5E5E5); Name: 'Gray90'),
    (Value: Integer($FFE5E5E5); Name: 'Grey90'),
    (Value: Integer($FFE8E8E8); Name: 'Gray91'),
    (Value: Integer($FFE8E8E8); Name: 'Grey91'),
    (Value: Integer($FFEBEBEB); Name: 'Gray92'),
    (Value: Integer($FFEBEBEB); Name: 'Grey92'),
    (Value: Integer($FFEDEDED); Name: 'Gray93'),
    (Value: Integer($FFEDEDED); Name: 'Grey93'),
    (Value: Integer($FFF0F0F0); Name: 'Gray94'),
    (Value: Integer($FFF0F0F0); Name: 'Grey94'),
    (Value: Integer($FFF2F2F2); Name: 'Gray95'),
    (Value: Integer($FFF2F2F2); Name: 'Grey95'),
    (Value: Integer($FFF5F5F5); Name: 'Gray96'),
    (Value: Integer($FFF5F5F5); Name: 'Grey96'),
    (Value: Integer($FFF7F7F7); Name: 'Gray97'),
    (Value: Integer($FFF7F7F7); Name: 'Grey97'),
    (Value: Integer($FFFAFAFA); Name: 'Gray98'),
    (Value: Integer($FFFAFAFA); Name: 'Grey98'),
    (Value: Integer($FFFCFCFC); Name: 'Gray99'),
    (Value: Integer($FFFCFCFC); Name: 'Grey99'),
    (Value: Integer($FFFFFFFF); Name: 'Gray100'),
    (Value: Integer($FFFFFFFF); Name: 'Grey100'),
    (Value: Integer($FFA9A9A9); Name: 'DarkGrey'),
    (Value: Integer($FFA9A9A9); Name: 'DarkGray'),
    (Value: Integer($FF00008B); Name: 'DarkBlue'),
    (Value: Integer($FF008B8B); Name: 'DarkCyan'),
    (Value: Integer($FF8B008B); Name: 'DarkMagenta'),
    (Value: Integer($FF8B0000); Name: 'DarkRed'),
    (Value: Integer($FF90EE90); Name: 'LightGreen'));

type
  TfgColorsPreset = array of TIdentMapEntry;

implementation

end.
