/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.io.File;
import java.io.IOException;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.resolver.NamingAdapterInterface;

public class TNSNamesNamingAdapter
implements NamingAdapterInterface {
    private NLParamParser tnsEntriesHdl;
    private String tnsDir;
    private long lastModifiedTime;
    private long nextPollTime;
    private static final String TNSFILE = "tnsnames.ora";
    private static final long REFRESH_INTERVAL = 0L;

    public TNSNamesNamingAdapter(String string) {
        this.tnsDir = string;
        this.resetAttr();
    }

    private void checkAndReload() throws NetException {
        long l = System.currentTimeMillis();
        if (l > this.nextPollTime) {
            this.nextPollTime = l;
            this.loadFile();
        }
    }

    private void loadFile() throws NetException {
        File file = new File(this.tnsDir, TNSFILE);
        String string = file.getAbsolutePath();
        if (!file.isFile() || !file.canRead()) {
            this.resetAttr();
            throw new NetException(123, ": " + string);
        }
        long l = file.lastModified();
        if (this.lastModifiedTime != l) {
            try {
                this.tnsEntriesHdl = new NLParamParser(string, 1);
                this.lastModifiedTime = l;
            }
            catch (IOException iOException) {
                this.resetAttr();
                throw new NetException(123, ": " + string);
            }
            catch (NLException nLException) {
            }
        }
    }

    private void resetAttr() {
        this.tnsEntriesHdl = null;
        this.lastModifiedTime = 0L;
        this.nextPollTime = 0L;
    }

    public String resolve(String string) throws NetException {
        NVPair nVPair = null;
        TNSNamesNamingAdapter tNSNamesNamingAdapter = this;
        synchronized (tNSNamesNamingAdapter) {
            this.checkAndReload();
            nVPair = this.tnsEntriesHdl.getNLPListElement(string);
        }
        if (nVPair == null) {
            throw new NetException(122, "\"" + string + "\"");
        }
        return nVPair.valueToString();
    }
}

