/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.util.Vector;
import oracle.net.TNSAddress.AddressList;
import oracle.net.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.resolver.NavAddress;
import oracle.net.resolver.NavDescriptionList;
import oracle.net.resolver.NavSchemaObject;

public class NavAddressList
extends AddressList
implements NavSchemaObject {
    private Vector activeChildren = new Vector(1, 10);
    private int sBuflength;

    public NavAddressList(SchemaObjectFactoryInterface schemaObjectFactoryInterface) {
        super(schemaObjectFactoryInterface);
    }

    public void addToString(ConnStrategy connStrategy) {
        String string = this.toString();
        int n = connStrategy.cOpts.size() - 1;
        while (n >= 0 && !((ConnOption)connStrategy.cOpts.elementAt((int)n)).done) {
            ((ConnOption)connStrategy.cOpts.elementAt((int)n)).conn_data.append(string);
            --n;
        }
    }

    private void closeNVPair(ConnStrategy connStrategy, boolean bl) {
        int n = connStrategy.cOpts.size() - 1;
        while (n >= 0 && !((ConnOption)connStrategy.cOpts.elementAt((int)n)).done) {
            if (!bl && connStrategy.cOpts.size() - 1 - n >= this.getChildrenSize()) break;
            if (this.sourceRoute) {
                ((ConnOption)connStrategy.cOpts.elementAt((int)n)).conn_data.append("(SOURCE_ROUTE=yes)");
                ((ConnOption)connStrategy.cOpts.elementAt((int)n)).conn_data.append("(HOP_COUNT=0)");
            }
            ((ConnOption)connStrategy.cOpts.elementAt((int)n)).conn_data.append(")");
            --n;
        }
    }

    public NavAddress getChild(int n) {
        return (NavAddress)this.children.elementAt(n);
    }

    public int getChildrenSize() {
        return this.children.size();
    }

    public int getChildrenType(int n) {
        return ((NavSchemaObject)this.children.elementAt(n)).isA();
    }

    public void navigate(ConnStrategy connStrategy, StringBuffer stringBuffer) {
        this.navigate2(connStrategy, stringBuffer, 0);
    }

    private void navigate2(ConnStrategy connStrategy, StringBuffer stringBuffer, int n) {
        int n2;
        boolean bl = false;
        ++n;
        this.sBuflength = stringBuffer.length();
        stringBuffer.append("(ADDRESS_LIST=");
        if (this.sourceRoute) {
            this.activeChildren = this.children;
            ((NavSchemaObject)this.activeChildren.elementAt(0)).navigate(connStrategy, stringBuffer);
            n2 = 1;
            while (n2 < this.activeChildren.size()) {
                ((NavSchemaObject)this.activeChildren.elementAt(n2)).addToString(connStrategy);
                ++n2;
            }
        } else {
            this.activeChildren = NavDescriptionList.setActiveChildren(this.children, this.failover, this.loadBalance);
            n2 = 0;
            while (n2 < this.activeChildren.size()) {
                if (this.getChildrenType(n2) == 1) {
                    bl = true;
                    ((NavAddressList)this.activeChildren.elementAt(n2)).navigate2(connStrategy, stringBuffer, n);
                } else {
                    ((NavSchemaObject)this.activeChildren.elementAt(n2)).navigate(connStrategy, stringBuffer);
                }
                ++n2;
            }
        }
        if (!(--n == 0 && bl || this.sourceRoute)) {
            this.closeNVPair(connStrategy, false);
        } else {
            this.closeNVPair(connStrategy, true);
        }
        stringBuffer.setLength(this.sBuflength);
    }

    public String toString() {
        String string = new String("");
        string = String.valueOf(string) + "(ADDRESS_LIST=";
        int n = 0;
        while (n < this.children.size()) {
            string = String.valueOf(string) + ((NavSchemaObject)this.children.elementAt(n)).toString();
            ++n;
        }
        if (this.sourceRoute) {
            string = String.valueOf(string) + "(SOURCE_ROUTE=yes)(HOP_COUNT=0)";
        }
        if (this.loadBalance) {
            string = String.valueOf(string) + "(LOAD_BALANCE=yes)";
        }
        if (!this.failover) {
            string = String.valueOf(string) + "(FAILOVER=false)";
        }
        string = String.valueOf(string) + ")";
        return string;
    }
}

