/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.util.RepConversion;
import oracle.net.ns.BreakNetException;
import oracle.security.o3logon.O3LoginClientHelper;
import oracle.sql.converter.CharacterSetMetaData;

class T4CTTIoauthenticate
extends T4CTTIfun {
    byte[] user;
    String userStr;
    byte[] password;
    String passwordStr;
    byte[] terminal;
    byte[] machine;
    byte[] sysUserName;
    byte[] processID;
    byte[] programName;
    long flag;
    byte[] encryptedSK;
    byte[] internalName;
    byte[] externalName;
    byte[] alterSession;
    byte[] aclValue;
    byte[] clientname;
    String ressourceManagerId;
    T4CConnection conn;
    boolean isSessionTZ = true;
    Properties connectionValues = new Properties();
    static final int SERVER_VERSION_81 = 8100;
    static final int KPZ_LOGON = 1;
    static final int KPZ_CPW = 2;
    static final int KPZ_SRVAUTH = 4;
    static final int KPZ_ENCRYPTED_PASSWD = 256;
    static final int KPZ_LOGON_MIGRATE = 16;
    static final int KPZ_LOGON_SYSDBA = 32;
    static final int KPZ_LOGON_SYSOPER = 64;
    static final int KPZ_LOGON_PRELIMAUTH = 128;
    static final int KPZ_PASSWD_ENCRYPTED = 256;
    static final int KPZ_LOGON_DBCONC = 512;
    static final int KPZ_PROXY_AUTH = 1024;
    static final int KPZ_SESSION_CACHE = 2048;
    static final int KPZ_PASSWD_IS_VFR = 4096;
    static final String AUTH_TERMINAL = "AUTH_TERMINAL";
    static final String AUTH_PROGRAM_NM = "AUTH_PROGRAM_NM";
    static final String AUTH_MACHINE = "AUTH_MACHINE";
    static final String AUTH_PID = "AUTH_PID";
    static final String AUTH_SID = "AUTH_SID";
    static final String AUTH_SESSKEY = "AUTH_SESSKEY";
    static final String AUTH_VFR_DATA = "AUTH_VFR_DATA";
    static final String AUTH_PASSWORD = "AUTH_PASSWORD";
    static final String AUTH_INTERNALNAME = "AUTH_INTERNALNAME_";
    static final String AUTH_EXTERNALNAME = "AUTH_EXTERNALNAME_";
    static final String AUTH_ACL = "AUTH_ACL";
    static final String AUTH_ALTER_SESSION = "AUTH_ALTER_SESSION";
    static final String AUTH_INITIAL_CLIENT_ROLE = "INITIAL_CLIENT_ROLE";
    static final String AUTH_VERSION_SQL = "AUTH_VERSION_SQL";
    static final String AUTH_VERSION_NO = "AUTH_VERSION_NO";
    static final String AUTH_XACTION_TRAITS = "AUTH_XACTION_TRAITS";
    static final String AUTH_VERSION_STATUS = "AUTH_VERSION_STATUS";
    static final String AUTH_SERIAL_NUM = "AUTH_SERIAL_NUM";
    static final String AUTH_SESSION_ID = "AUTH_SESSION_ID";
    static final String AUTH_CLIENT_CERTIFICATE = "AUTH_CLIENT_CERTIFICATE";
    static final String AUTH_PROXY_CLIENT_NAME = "PROXY_CLIENT_NAME";
    static final String AUTH_CLIENT_DN = "AUTH_CLIENT_DISTINGUISHED_NAME";
    static final String AUTH_INSTANCENAME = "AUTH_INSTANCENAME";
    static final String AUTH_DBNAME = "AUTH_DBNAME";
    static final String AUTH_INSTANCE_NO = "AUTH_INSTANCE_NO";
    static final String AUTH_SC_SERVER_HOST = "AUTH_SC_SERVER_HOST";
    static final String AUTH_SC_INSTANCE_NAME = "AUTH_SC_INSTANCE_NAME";
    static final String AUTH_SC_INSTANCE_ID = "AUTH_SC_INSTANCE_ID";
    static final String AUTH_SC_INSTANCE_START_TIME = "AUTH_SC_INSTANCE_START_TIME";
    static final String AUTH_SC_DBUNIQUE_NAME = "AUTH_SC_DBUNIQUE_NAME";
    static final String AUTH_SC_SERVICE_NAME = "AUTH_SC_SERVICE_NAME";
    static final String AUTH_SC_SVC_FLAGS = "AUTH_SC_SVC_FLAGS";
    static final String AUTH_COPYRIGHT = "AUTH_COPYRIGHT";
    static final String COPYRIGHT_STR = "\"Oracle\nEverybody follows\nSpeedy bits exchange\nStars await to glow\"\nThe preceding key is copyrighted by Oracle Corporation.\nDuplication of this key is not allowed without permission\nfrom Oracle Corporation. Copyright 2003 Oracle Corporation.";
    static final int MAX_SIZE_VSESSION_OSUSER = 30;
    static final int MAX_SIZE_VSESSION_PROCESS = 24;
    static final int MAX_SIZE_VSESSION_MACHINE = 64;
    static final int MAX_SIZE_VSESSION_TERMINAL = 30;
    static final int MAX_SIZE_VSESSION_PROGRAM = 48;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Apr__7_23:26:45_PDT_2010";

    T4CTTIoauthenticate(T4CMAREngine t4CMAREngine, String string, String string2, Properties properties, long l, String string3, T4CTTIoer t4CTTIoer, T4CConnection t4CConnection) throws SQLException {
        super((byte)3, 0, (short)0);
        this.oer = t4CTTIoer;
        this.setMarshalingEngine(t4CMAREngine);
        this.user = t4CMAREngine.conv.StringToCharBytes(string);
        this.userStr = string;
        this.passwordStr = string2;
        this.flag = l;
        this.ressourceManagerId = string3;
        this.conn = t4CConnection;
        this.setSessionFields(properties);
        this.isSessionTZ = this.conn.ver.getVersionNumber() >= 8100;
    }

    int getSerialNumber() {
        int n = -1;
        String string = this.connectionValues.getProperty(AUTH_SERIAL_NUM);
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    int getSessionId() {
        int n = -1;
        String string = this.connectionValues.getProperty(AUTH_SESSION_ID);
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    void marshalOauth() throws IOException, SQLException {
        this.funCode = (short)115;
        if (this.encryptedSK.length > 16) {
            DatabaseError.throwSqlException(413);
        }
        String string = this.userStr.trim();
        String string2 = this.passwordStr.trim();
        this.passwordStr = null;
        String string3 = string;
        String string4 = string2;
        if (string.startsWith("\"") || string.endsWith("\"")) {
            string3 = this.removeQuotes(string);
        }
        if (string2.startsWith("\"") || string2.endsWith("\"")) {
            string4 = this.removeQuotes(string2);
        }
        O3LoginClientHelper o3LoginClientHelper = new O3LoginClientHelper(this.meg.conv.isServerCSMultiByte);
        byte[] byArray = o3LoginClientHelper.getSessionKey(string3, string4, this.encryptedSK);
        byte[] byArray2 = this.meg.conv.StringToCharBytes(string4);
        byte by = byArray2.length % 8 > 0 ? (byte)((byte)(8 - byArray2.length % 8)) : (byte)0;
        byte[] byArray3 = new byte[byArray2.length + by];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        byte[] byArray4 = o3LoginClientHelper.getEPasswd(byArray, byArray3);
        this.password = new byte[2 * byArray3.length + 1];
        if (this.password.length < 2 * byArray4.length) {
            DatabaseError.throwSqlException(413);
        }
        RepConversion.bArray2Nibbles(byArray4, this.password);
        this.password[this.password.length - 1] = RepConversion.nibbleToHex(by);
        this.marshalFunHeader();
        this.meg.marshalPTR();
        this.meg.marshalSB4(this.user.length);
        this.meg.marshalUB4(this.flag | 1L | 0x100L);
        this.meg.marshalPTR();
        boolean bl = false;
        if (!this.ressourceManagerId.equals("0000")) {
            bl = true;
        }
        int n = 6;
        if (bl) {
            n += 2;
        }
        ++n;
        if (this.programName != null) {
            ++n;
        }
        if (this.clientname != null) {
            ++n;
        }
        this.meg.marshalUB4(n);
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        this.meg.marshalCHR(this.user);
        byte[][] byArray5 = new byte[n][];
        byte[][] byArray6 = new byte[n][];
        byte[] byArray7 = new byte[n];
        int n2 = 0;
        byArray5[n2] = this.meg.conv.StringToCharBytes(AUTH_PASSWORD);
        byArray6[n2++] = this.password;
        byArray5[n2++] = this.meg.conv.StringToCharBytes(AUTH_TERMINAL);
        if (this.programName != null) {
            byArray5[n2] = this.meg.conv.StringToCharBytes(AUTH_PROGRAM_NM);
            byArray6[n2++] = this.programName;
        }
        if (this.clientname != null) {
            byArray5[n2] = this.meg.conv.StringToCharBytes(AUTH_PROXY_CLIENT_NAME);
            byArray6[n2++] = this.clientname;
        }
        byArray5[n2] = this.meg.conv.StringToCharBytes(AUTH_MACHINE);
        byArray6[n2++] = this.machine;
        byArray5[n2] = this.meg.conv.StringToCharBytes(AUTH_PID);
        byArray6[n2++] = this.processID;
        if (bl) {
            byArray5[n2] = this.meg.conv.StringToCharBytes(AUTH_INTERNALNAME);
            byArray5[n2][byArray5[n2].length - 1] = 0;
            byArray6[n2++] = this.internalName;
            byArray5[n2] = this.meg.conv.StringToCharBytes(AUTH_EXTERNALNAME);
            byArray5[n2][byArray5[n2].length - 1] = 0;
            byArray6[n2++] = this.externalName;
        }
        byArray5[n2] = this.meg.conv.StringToCharBytes(AUTH_ACL);
        byArray6[n2++] = this.aclValue;
        byArray5[n2] = this.meg.conv.StringToCharBytes(AUTH_ALTER_SESSION);
        byArray6[n2] = this.alterSession;
        byArray7[n2++] = 1;
        byArray5[n2] = this.meg.conv.StringToCharBytes(AUTH_COPYRIGHT);
        byArray6[n2++] = this.meg.conv.StringToCharBytes(COPYRIGHT_STR);
        this.meg.marshalKEYVAL(byArray5, byArray6, byArray7, n);
    }

    void marshalOauth(int n, Properties properties, int n2, int n3) throws IOException, SQLException {
        String[] stringArray;
        this.funCode = (short)115;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[][] byArray3 = null;
        if (n == 1) {
            stringArray = properties.getProperty("PROXY_USER_NAME");
            this.user = this.meg.conv.StringToCharBytes((String)stringArray);
            bl = true;
        } else if (n == 2) {
            stringArray = properties.getProperty("PROXY_DISTINGUISHED_NAME");
            byArray = this.meg.conv.StringToCharBytes((String)stringArray);
            bl2 = true;
        } else {
            try {
                byArray2 = (byte[])((Hashtable)properties).get("PROXY_CERTIFICATE");
                stringArray = new StringBuffer();
                int n4 = 0;
                while (n4 < byArray2.length) {
                    String string = Integer.toHexString(0xFF & byArray2[n4]);
                    int n5 = string.length();
                    if (n5 == 0) {
                        stringArray.append("00");
                    } else if (n5 == 1) {
                        stringArray.append('0');
                        stringArray.append(string);
                    } else {
                        stringArray.append(string);
                    }
                    ++n4;
                }
                byArray2 = stringArray.toString().getBytes();
            }
            catch (Exception exception) {}
            bl3 = true;
        }
        stringArray = null;
        try {
            stringArray = (String[])((Hashtable)properties).get("PROXY_ROLES");
        }
        catch (Exception exception) {}
        if (stringArray != null) {
            byArray3 = new byte[stringArray.length][];
            int n6 = 0;
            while (n6 < stringArray.length) {
                byArray3[n6] = this.meg.conv.StringToCharBytes(stringArray[n6]);
                ++n6;
            }
            bl4 = true;
        }
        this.marshalFunHeader();
        if (bl) {
            this.meg.marshalPTR();
            this.meg.marshalSB4(this.user.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSB4(0);
        }
        this.meg.marshalUB4(1025L);
        this.meg.marshalPTR();
        int n7 = 7;
        ++n7;
        if (bl2 || bl3) {
            ++n7;
        }
        if (bl4) {
            n7 += byArray3.length;
        }
        if (this.programName != null) {
            ++n7;
        }
        this.meg.marshalUB4(n7);
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        if (bl) {
            this.meg.marshalCHR(this.user);
        }
        byte[][] byArray4 = new byte[n7][];
        byte[][] byArray5 = new byte[n7][];
        byte[] byArray6 = new byte[n7];
        int n8 = 0;
        if (bl4) {
            int n9 = 0;
            while (n9 < byArray3.length) {
                byArray4[n8] = this.meg.conv.StringToCharBytes(AUTH_INITIAL_CLIENT_ROLE);
                byArray5[n8] = byArray3[n9];
                ++n8;
                ++n9;
            }
        }
        if (bl2) {
            byArray4[n8] = this.meg.conv.StringToCharBytes(AUTH_CLIENT_DN);
            byArray5[n8++] = byArray;
        } else if (bl3) {
            byArray4[n8] = this.meg.conv.StringToCharBytes(AUTH_CLIENT_CERTIFICATE);
            byArray5[n8++] = byArray2;
        }
        byArray4[n8++] = this.meg.conv.StringToCharBytes(AUTH_TERMINAL);
        if (this.programName != null) {
            byArray4[n8] = this.meg.conv.StringToCharBytes(AUTH_PROGRAM_NM);
            byArray5[n8++] = this.programName;
        }
        byArray4[n8] = this.meg.conv.StringToCharBytes(AUTH_MACHINE);
        byArray5[n8++] = this.machine;
        byArray4[n8] = this.meg.conv.StringToCharBytes(AUTH_PID);
        byArray5[n8++] = this.processID;
        byArray4[n8] = this.meg.conv.StringToCharBytes(AUTH_ACL);
        byArray5[n8++] = this.aclValue;
        byArray4[n8] = this.meg.conv.StringToCharBytes(AUTH_ALTER_SESSION);
        byArray5[n8] = this.alterSession;
        byArray6[n8++] = 1;
        byArray4[n8] = this.meg.conv.StringToCharBytes(AUTH_SESSION_ID);
        byArray5[n8++] = this.meg.conv.StringToCharBytes(Integer.toString(n2));
        byArray4[n8] = this.meg.conv.StringToCharBytes(AUTH_SERIAL_NUM);
        byArray5[n8++] = this.meg.conv.StringToCharBytes(Integer.toString(n3));
        byArray4[n8] = this.meg.conv.StringToCharBytes(AUTH_COPYRIGHT);
        byArray5[n8++] = this.meg.conv.StringToCharBytes(COPYRIGHT_STR);
        this.meg.marshalKEYVAL(byArray4, byArray5, byArray6, n7);
    }

    void marshalOsesskey() throws IOException, SQLException {
        this.funCode = (short)118;
        this.marshalFunHeader();
        this.meg.marshalPTR();
        this.meg.marshalSB4(this.user.length);
        this.meg.marshalUB4(this.flag | 1L);
        this.meg.marshalPTR();
        int n = 4;
        if (this.programName != null) {
            ++n;
        }
        this.meg.marshalUB4(n);
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        this.meg.marshalCHR(this.user);
        byte[][] byArray = new byte[n][];
        byte[][] byArray2 = new byte[n][];
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        byArray[n2] = this.meg.conv.StringToCharBytes(AUTH_TERMINAL);
        byArray2[n2++] = this.terminal;
        if (this.programName != null) {
            byArray[n2] = this.meg.conv.StringToCharBytes(AUTH_PROGRAM_NM);
            byArray2[n2++] = this.programName;
        }
        byArray[n2] = this.meg.conv.StringToCharBytes(AUTH_MACHINE);
        byArray2[n2++] = this.machine;
        byArray[n2] = this.meg.conv.StringToCharBytes(AUTH_PID);
        byArray2[n2++] = this.processID;
        byArray[n2] = this.meg.conv.StringToCharBytes(AUTH_SID);
        byArray2[n2++] = this.sysUserName;
        this.meg.marshalKEYVAL(byArray, byArray2, byArray3, n);
    }

    void receiveOauth() throws IOException, SQLException {
        byte[][] byArray = null;
        byte[][] byArray2 = null;
        int n = 0;
        block11: while (true) {
            try {
                while (true) {
                    byte by = this.meg.unmarshalSB1();
                    switch (by) {
                        case 8: {
                            n = this.meg.unmarshalUB2();
                            byArray = new byte[n][];
                            byArray2 = new byte[n][];
                            this.meg.unmarshalKEYVAL(byArray, byArray2, n);
                            break;
                        }
                        case 15: {
                            this.oer.init();
                            this.oer.unmarshalWarning();
                            try {
                                this.oer.processWarning();
                            }
                            catch (SQLWarning sQLWarning) {
                                this.conn.setWarnings(DatabaseError.addSqlWarning(this.conn.getWarnings(), sQLWarning));
                            }
                            continue block11;
                        }
                        case 4: {
                            this.oer.init();
                            this.oer.unmarshal();
                            this.oer.processError();
                            break block11;
                        }
                        default: {
                            DatabaseError.throwSqlException(401);
                            break;
                        }
                    }
                }
            }
            catch (BreakNetException breakNetException) {
                continue;
            }
            break;
        }
        int n2 = 0;
        while (n2 < n) {
            String string = this.meg.conv.CharBytesToString(byArray[n2], byArray[n2].length);
            String string2 = "";
            if (byArray2[n2] != null) {
                string2 = this.meg.conv.CharBytesToString(byArray2[n2], byArray2[n2].length);
            }
            this.connectionValues.setProperty(string, string2);
            ++n2;
        }
    }

    void receiveOsesskey() throws IOException, SQLException {
        byte[][] byArray = null;
        byte[][] byArray2 = null;
        block8: while (true) {
            try {
                while (true) {
                    byte by = this.meg.unmarshalSB1();
                    switch (by) {
                        case 8: {
                            int n = this.meg.unmarshalUB2();
                            byArray = new byte[n][];
                            byArray2 = new byte[n][];
                            this.meg.unmarshalKEYVAL(byArray, byArray2, n);
                            break;
                        }
                        case 4: {
                            this.oer.init();
                            this.oer.unmarshal();
                            this.oer.processError();
                            break block8;
                        }
                        default: {
                            DatabaseError.throwSqlException(401);
                            break;
                        }
                    }
                }
            }
            catch (BreakNetException breakNetException) {
                continue;
            }
            break;
        }
        if (byArray == null || byArray.length < 1) {
            DatabaseError.throwSqlException(438);
        }
        this.encryptedSK = byArray2[0];
        if (this.encryptedSK == null || this.encryptedSK.length != 16) {
            DatabaseError.throwSqlException(438);
        }
    }

    String removeQuotes(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        int n3 = 0;
        while (n3 < string.length()) {
            if (string.charAt(n3) != '\"') {
                n = n3;
                break;
            }
            ++n3;
        }
        int n4 = string.length() - 1;
        while (n4 >= 0) {
            if (string.charAt(n4) != '\"') {
                n2 = n4;
                break;
            }
            --n4;
        }
        String string2 = string.substring(n, n2 + 1);
        return string2;
    }

    void setSessionFields(Properties properties) throws SQLException {
        String string = properties.getProperty("v$session.terminal");
        String string2 = properties.getProperty("v$session.machine");
        String string3 = properties.getProperty("v$session.osuser");
        String string4 = properties.getProperty("v$session.program");
        String string5 = properties.getProperty("v$session.process");
        String string6 = properties.getProperty("v$session.iname");
        String string7 = properties.getProperty("v$session.ename");
        String string8 = properties.getProperty(AUTH_PROXY_CLIENT_NAME);
        if (string == null) {
            string = "unknown";
        }
        if (string2 == null) {
            try {
                string2 = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                string2 = "jdbcclient";
            }
        }
        if (string3 == null && (string3 = OracleDriver.getSystemPropertyUserName()) == null) {
            string3 = "jdbcuser";
        }
        if (string5 == null) {
            string5 = "1234";
        }
        if (string6 == null) {
            string6 = "jdbc_ttc_impl";
        }
        if (string7 == null) {
            string7 = "jdbc_" + this.ressourceManagerId;
        }
        this.terminal = this.meg.conv.StringToCharBytes(string);
        this.machine = this.meg.conv.StringToCharBytes(string2);
        this.sysUserName = this.meg.conv.StringToCharBytes(string3);
        this.programName = this.meg.conv.StringToCharBytes(string4 == null ? "JDBC Thin Client" : string4);
        this.processID = this.meg.conv.StringToCharBytes(string5);
        this.internalName = this.meg.conv.StringToCharBytes(string6);
        this.externalName = this.meg.conv.StringToCharBytes(string7);
        if (string8 != null) {
            this.clientname = this.meg.conv.StringToCharBytes(string8);
        }
        TimeZone timeZone = TimeZone.getDefault();
        int n = timeZone.getRawOffset();
        int n2 = n / 3600000;
        int n3 = n / 60000 % 60;
        if (timeZone.useDaylightTime() && timeZone.inDaylightTime(new Date())) {
            ++n2;
        }
        String string9 = String.valueOf(n2 < 0 ? String.valueOf(n2) : "+" + n2) + (n3 < 10 ? ":0" + n3 : ":" + n3);
        String string10 = CharacterSetMetaData.getNLSLanguage(Locale.getDefault());
        String string11 = CharacterSetMetaData.getNLSTerritory(Locale.getDefault());
        if (string10 == null) {
            DatabaseError.throwSqlException(176);
        }
        this.alterSession = this.meg.conv.StringToCharBytes("ALTER SESSION SET " + (this.isSessionTZ ? "TIME_ZONE='" + string9 + "'" : "") + " NLS_LANGUAGE='" + string10 + "' NLS_TERRITORY='" + string11 + "' ");
        this.aclValue = this.meg.conv.StringToCharBytes("4400");
        this.alterSession[this.alterSession.length - 1] = 0;
    }
}

