/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;

class T4CInputStream
extends OracleInputStream {
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Apr__7_23:26:44_PDT_2010";

    T4CInputStream(OracleStatement oracleStatement, int n, Accessor accessor) {
        super(oracleStatement, n, accessor);
    }

    public int getBytes(int n) throws IOException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n2 = 0;
            try {
                n2 = this.accessor.readStream(this.resizableBuffer, this.initialBufferSize);
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
            catch (IOException iOException) {
                try {
                    ((T4CConnection)this.statement.connection).handleIOException(iOException);
                }
                catch (SQLException sQLException) {}
                throw iOException;
            }
            int n3 = n2;
            Object var4_7 = null;
            return n3;
        }
    }

    public boolean isNull() throws IOException {
        if (!this.statement.connection.useFetchSizeWithLongColumn) {
            return super.isNull();
        }
        boolean bl = false;
        try {
            int n = this.statement.currentRow;
            if (n < 0) {
                n = 0;
            }
            if (n >= this.statement.validRows) {
                return true;
            }
            bl = this.accessor.isNull(n);
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
        return bl;
    }
}

