/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.TimeZone;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;

abstract class DateCommonBinder
extends Binder {
    static final int GREGORIAN_CUTOVER_YEAR = 1582;
    static final long GREGORIAN_CUTOVER = -12219292800000L;
    static final int JAN_1_1_JULIAN_DAY = 1721426;
    static final int EPOCH_JULIAN_DAY = 2440588;
    static final int ONE_SECOND = 1000;
    static final int ONE_MINUTE = 60000;
    static final int ONE_HOUR = 3600000;
    static final long ONE_DAY = 86400000L;
    static final int[] NUM_DAYS;
    static final int[] LEAP_NUM_DAYS;
    static final int[] MONTH_LENGTH;
    static final int[] LEAP_MONTH_LENGTH;
    static final int ORACLE_DATE_CENTURY = 0;
    static final int ORACLE_DATE_YEAR = 1;
    static final int ORACLE_DATE_MONTH = 2;
    static final int ORACLE_DATE_DAY = 3;
    static final int ORACLE_DATE_HOUR = 4;
    static final int ORACLE_DATE_MIN = 5;
    static final int ORACLE_DATE_SEC = 6;
    static final int ORACLE_DATE_NANO1 = 7;
    static final int ORACLE_DATE_NANO2 = 8;
    static final int ORACLE_DATE_NANO3 = 9;
    static final int ORACLE_DATE_NANO4 = 10;

    static {
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        NUM_DAYS = nArray;
        int[] nArray2 = new int[12];
        nArray2[1] = 31;
        nArray2[2] = 60;
        nArray2[3] = 91;
        nArray2[4] = 121;
        nArray2[5] = 152;
        nArray2[6] = 182;
        nArray2[7] = 213;
        nArray2[8] = 244;
        nArray2[9] = 274;
        nArray2[10] = 305;
        nArray2[11] = 335;
        LEAP_NUM_DAYS = nArray2;
        MONTH_LENGTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        LEAP_MONTH_LENGTH = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    }

    DateCommonBinder() {
    }

    static final int floorDivide(int n, int n2) {
        return n >= 0 ? n / n2 : (n + 1) / n2 - 1;
    }

    static final int floorDivide(int n, int n2, int[] nArray) {
        if (n >= 0) {
            nArray[0] = n % n2;
            return n / n2;
        }
        int n3 = (n + 1) / n2 - 1;
        nArray[0] = n - n3 * n2;
        return n3;
    }

    static final int floorDivide(long l, int n, int[] nArray) {
        if (l >= 0L) {
            nArray[0] = (int)(l % (long)n);
            return (int)(l / (long)n);
        }
        int n2 = (int)((l + 1L) / (long)n - 1L);
        nArray[0] = (int)(l - (long)(n2 * n));
        return n2;
    }

    static final long floorDivide(long l, long l2) {
        return l >= 0L ? l / l2 : (l + 1L) / l2 - 1L;
    }

    static int setOracleCYMD(long l, byte[] byArray, int n, OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        long l2;
        int n2;
        int n3;
        boolean bl;
        int n4;
        int n5;
        int n6;
        long l3;
        TimeZone timeZone = oraclePreparedStatement.getDefaultTimeZone();
        int n7 = timeZone.getRawOffset();
        long l4 = l + (long)n7;
        if (l4 >= -12219292800000L) {
            int n8;
            int n9;
            int n10;
            l3 = 2440588L + DateCommonBinder.floorDivide(l4, 86400000L) - 1721426L;
            if (l3 > 0L) {
                n10 = (int)(l3 / 146097L);
                n6 = (int)(l3 % 146097L);
                n9 = n6 / 36524;
                n5 = (n6 %= 36524) / 1461;
                n8 = (n6 %= 1461) / 365;
                n6 %= 365;
            } else {
                int[] nArray = new int[1];
                n10 = DateCommonBinder.floorDivide(l3, 146097, nArray);
                n9 = DateCommonBinder.floorDivide(nArray[0], 36524, nArray);
                n5 = DateCommonBinder.floorDivide(nArray[0], 1461, nArray);
                n8 = DateCommonBinder.floorDivide(nArray[0], 365, nArray);
                n6 = nArray[0];
            }
            n4 = 400 * n10 + 100 * n9 + 4 * n5 + n8;
            if (n9 == 4 || n8 == 4) {
                n6 = 365;
            } else {
                ++n4;
            }
            bl = (n4 & 3) == 0 && (n4 % 100 != 0 || n4 % 400 == 0);
            n3 = (int)((l3 + 1L) % 7L);
        } else {
            l3 = 2440588L + DateCommonBinder.floorDivide(l4, 86400000L) - 1721424L;
            n4 = (int)DateCommonBinder.floorDivide(4L * l3 + 1464L, 1461L);
            long l5 = 365 * (n4 - 1) + DateCommonBinder.floorDivide(n4 - 1, 4);
            n6 = (int)(l3 - l5);
            bl = (n4 & 3) == 0;
            n3 = (int)((l3 - 1L) % 7L);
        }
        int n11 = 0;
        int n12 = n2 = bl ? 60 : 59;
        if (n6 >= n2) {
            n11 = bl ? 1 : 2;
        }
        int n13 = (12 * (n6 + n11) + 6) / 367;
        int n14 = n6 - (bl ? LEAP_NUM_DAYS[n13] : NUM_DAYS[n13]) + 1;
        n3 += n3 < 0 ? 8 : 1;
        long l6 = l4 / 86400000L;
        n5 = (int)(l4 - l6 * 86400000L);
        if (n5 < 0) {
            n5 = (int)((long)n5 + 86400000L);
        }
        if ((long)(n5 = (int)((long)n5 + (l2 = DateCommonBinder.zoneOffset(timeZone, n4, n13, n14, n3, n5) - (long)n7))) >= 86400000L) {
            n5 = (int)((long)n5 - 86400000L);
            if (++n14 > (bl ? LEAP_MONTH_LENGTH[n13] : MONTH_LENGTH[n13])) {
                n14 = 1;
                if (++n13 == 12) {
                    n13 = 0;
                    ++n4;
                }
            }
        }
        if (n4 <= 0) {
            --n4;
        }
        if (n4 > 9999 || n4 < -4712) {
            DatabaseError.throwSqlException(361);
        }
        byArray[n] = (byte)(n4 / 100 + 100);
        byArray[1 + n] = (byte)(n4 % 100 + 100);
        byArray[2 + n] = (byte)(n13 + 1);
        byArray[3 + n] = (byte)n14;
        return n5;
    }

    static void setOracleHMS(int n, byte[] byArray, int n2) {
        byArray[6 + n2] = (byte)((n /= 1000) % 60 + 1);
        byArray[5 + n2] = (byte)((n /= 60) % 60 + 1);
        byArray[4 + n2] = (byte)((n /= 60) + 1);
    }

    static void setOracleNanos(long l, byte[] byArray, int n) {
        byArray[10 + n] = (byte)(l & 0xFFL);
        byArray[9 + n] = (byte)(l >> 8 & 0xFFL);
        byArray[8 + n] = (byte)(l >> 16 & 0xFFL);
        byArray[7 + n] = (byte)(l >> 24 & 0xFFL);
    }

    static final long zoneOffset(TimeZone timeZone, int n, int n2, int n3, int n4, int n5) {
        return timeZone.getOffset(n < 0 ? 0 : 1, n, n2, n3, n4, n5);
    }
}

