/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;

public class LobPlsqlUtil {
    static boolean PLSQL_DEBUG = false;
    static final int MAX_PLSQL_SIZE = 32512;
    static final int MAX_PLSQL_INSTR_SIZE = 32512;
    static final int MAX_CHUNK_SIZE = 32512;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Apr__7_23:34:11_PDT_2010";

    public static long hasPattern(BLOB bLOB, byte[] byArray, long l) throws SQLException {
        return LobPlsqlUtil.hasPattern(bLOB.getInternalConnection(), bLOB, 2004, byArray, l);
    }

    public static long isSubLob(BLOB bLOB, BLOB bLOB2, long l) throws SQLException {
        return LobPlsqlUtil.isSubLob(bLOB.getInternalConnection(), bLOB, 2004, bLOB2, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long hasPattern(CLOB cLOB, char[] cArray, long l) throws SQLException {
        if (cArray == null || l <= 0L) {
            return 0L;
        }
        OracleConnection oracleConnection = cLOB.getInternalConnection();
        long l2 = cArray.length;
        long l3 = LobPlsqlUtil.length(oracleConnection, cLOB, 2005);
        if (l2 == 0L || l2 > l3 - l + 1L || l > l3) {
            return 0L;
        }
        if (l2 <= (long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection)) {
            Statement statement = null;
            try {
                statement = (OracleCallableStatement)oracleConnection.prepareCall("begin :1 := dbms_lob.instr(:2, :3, :4); end;");
                statement.registerOutParameter(1, 2);
                if (cLOB.isNCLOB()) {
                    statement.setFormOfUse(2, (short)2);
                    statement.setFormOfUse(3, (short)2);
                }
                statement.setCLOB(2, cLOB);
                statement.setString(3, new String(cArray));
                statement.setLong(4, l);
                statement.execute();
                long l4 = statement.getLong(1);
                return l4;
            }
            finally {
                statement.close();
                statement = null;
            }
        }
        int n = 0;
        long l5 = l;
        boolean bl = false;
        long l6 = 0L;
        while (!bl) {
            if (l2 > l3 - l5 + 1L) {
                return 0L;
            }
            n = 0;
            int n2 = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection), l2 - (long)n);
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, n, cArray2, 0, n2);
            long l7 = LobPlsqlUtil.hasPattern(cLOB, cArray2, l5);
            if (l7 == 0L) {
                return 0L;
            }
            l6 = l7;
            n += n2;
            l5 = l7 + (long)n2;
            boolean bl2 = true;
            while (bl2) {
                n2 = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection), l2 - (long)n);
                cArray2 = new char[n2];
                System.arraycopy(cArray, n, cArray2, 0, n2);
                l7 = LobPlsqlUtil.hasPattern(cLOB, cArray2, l5);
                if (l7 == l5) {
                    l5 += (long)n2;
                    if ((long)(n += n2) != l2) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l7 == 0L) {
                    return 0L;
                }
                l5 = l7 - (long)n;
                bl2 = false;
            }
        }
        return l6;
    }

    public static long isSubLob(CLOB cLOB, CLOB cLOB2, long l) throws SQLException {
        if (cLOB2 == null || l <= 0L) {
            return 0L;
        }
        OracleConnection oracleConnection = cLOB.getInternalConnection();
        long l2 = LobPlsqlUtil.length(oracleConnection, cLOB2, 2005);
        long l3 = LobPlsqlUtil.length(oracleConnection, cLOB, 2005);
        if (l2 == 0L || l2 > l3 - l + 1L || l > l3) {
            return 0L;
        }
        if (l2 <= (long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection)) {
            char[] cArray = new char[(int)l2];
            cLOB2.getChars(1L, (int)l2, cArray);
            return LobPlsqlUtil.hasPattern(cLOB, cArray, l);
        }
        int n = 0;
        long l4 = l;
        boolean bl = false;
        long l5 = 0L;
        while (!bl) {
            if (l2 > l3 - l4 + 1L) {
                return 0L;
            }
            n = 0;
            int n2 = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection), l2 - (long)n);
            char[] cArray = new char[n2];
            cLOB2.getChars(n + 1, n2, cArray);
            long l6 = LobPlsqlUtil.hasPattern(cLOB, cArray, l4);
            if (l6 == 0L) {
                return 0L;
            }
            l5 = l6;
            n += n2;
            l4 = l6 + (long)n2;
            boolean bl2 = true;
            while (bl2) {
                n2 = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection), l2 - (long)n);
                cArray = new char[n2];
                cLOB2.getChars(n + 1, n2, cArray);
                l6 = LobPlsqlUtil.hasPattern(cLOB, cArray, l4);
                if (l6 == l4) {
                    l4 += (long)n2;
                    if ((long)(n += n2) != l2) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l6 == 0L) {
                    return 0L;
                }
                l4 = l6 - (long)n;
                bl2 = false;
            }
        }
        return l5;
    }

    public static long hasPattern(BFILE bFILE, byte[] byArray, long l) throws SQLException {
        return LobPlsqlUtil.hasPattern(bFILE.getInternalConnection(), bFILE, -13, byArray, l);
    }

    public static long isSubLob(BFILE bFILE, BFILE bFILE2, long l) throws SQLException {
        return LobPlsqlUtil.isSubLob(bFILE.getInternalConnection(), bFILE, -13, bFILE2, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String fileGetName(BFILE bFILE) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        String string = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)bFILE.getInternalConnection().prepareCall("begin dbms_lob.fileGetName(:1, :2, :3); end; ");
            oracleCallableStatement.setBFILE(1, bFILE);
            oracleCallableStatement.registerOutParameter(2, 12);
            oracleCallableStatement.registerOutParameter(3, 12);
            oracleCallableStatement.execute();
            string = oracleCallableStatement.getString(3);
            Object var4_3 = null;
            if (oracleCallableStatement == null) return string;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String fileGetDirAlias(BFILE bFILE) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        String string = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)bFILE.getInternalConnection().prepareCall("begin dbms_lob.fileGetName(:1, :2, :3); end; ");
            oracleCallableStatement.setBFILE(1, bFILE);
            oracleCallableStatement.registerOutParameter(2, 12);
            oracleCallableStatement.registerOutParameter(3, 12);
            oracleCallableStatement.execute();
            string = oracleCallableStatement.getString(2);
            Object var4_3 = null;
            if (oracleCallableStatement == null) return string;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        return string;
    }

    private static int getPlsqlMaxInstrSize(OracleConnection oracleConnection) throws SQLException {
        boolean bl = oracleConnection.isCharSetMultibyte(oracleConnection.getDriverCharSet());
        int n = oracleConnection.getMaxCharbyteSize();
        int n2 = 32512;
        if (bl) {
            n2 = 32512 / (oracleConnection.getC2SNlsRatio() * n);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long read(OracleConnection oracleConnection, Datum datum, int n, long l, long l2, byte[] byArray) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        int n2 = 0;
        try {
            try {
                oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin dbms_lob.read (:1, :2, :3, :4); end;");
                int n3 = 0;
                int n4 = 0;
                if (LobPlsqlUtil.isNCLOB(datum)) {
                    oracleCallableStatement.setFormOfUse(1, (short)2);
                    oracleCallableStatement.setFormOfUse(4, (short)2);
                }
                oracleCallableStatement.setObject(1, (Object)datum, n);
                oracleCallableStatement.registerOutParameter(2, 2);
                oracleCallableStatement.registerOutParameter(4, -3);
                while ((long)n2 < l2) {
                    n4 = Math.min((int)l2, 32512);
                    oracleCallableStatement.setInt(2, n4);
                    oracleCallableStatement.setInt(3, (int)l + n2);
                    oracleCallableStatement.execute();
                    n3 = oracleCallableStatement.getInt(2);
                    byte[] byArray2 = oracleCallableStatement.getBytes(4);
                    System.arraycopy(byArray2, 0, byArray, n2, n3);
                    n2 += n3;
                    l2 -= (long)n3;
                }
                Object var14_12 = null;
                if (oracleCallableStatement == null) return n2;
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 1403) {
                    throw sQLException;
                }
                Object var14_13 = null;
                if (oracleCallableStatement == null) return n2;
                oracleCallableStatement.close();
                return n2;
            }
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (oracleCallableStatement != null) {
                oracleCallableStatement.close();
                oracleCallableStatement = null;
            }
            throw throwable;
        }
        oracleCallableStatement.close();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long length(OracleConnection oracleConnection, Datum datum, int n) throws SQLException {
        long l = 0L;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin :1 := dbms_lob.getLength (:2); end;");
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(2, (short)2);
            }
            oracleCallableStatement.setObject(2, (Object)datum, n);
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.execute();
            l = oracleCallableStatement.getLong(1);
            Object var7_5 = null;
            if (oracleCallableStatement == null) return l;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long hasPattern(OracleConnection oracleConnection, Datum datum, int n, byte[] byArray, long l) throws SQLException {
        if (byArray == null || l <= 0L) {
            return 0L;
        }
        long l2 = byArray.length;
        long l3 = LobPlsqlUtil.length(oracleConnection, datum, n);
        if (l2 == 0L || l2 > l3 - l + 1L || l > l3) {
            return 0L;
        }
        if (l2 <= 32512L) {
            Statement statement = null;
            try {
                statement = (OracleCallableStatement)oracleConnection.prepareCall("begin :1 := dbms_lob.instr(:2, :3, :4); end;");
                statement.registerOutParameter(1, 2);
                statement.setObject(2, datum, n);
                statement.setBytes(3, byArray);
                statement.setLong(4, l);
                statement.execute();
                long l4 = statement.getLong(1);
                return l4;
            }
            finally {
                statement.close();
                statement = null;
            }
        }
        int n2 = 0;
        long l5 = l;
        boolean bl = false;
        long l6 = 0L;
        while (!bl) {
            if (l2 > l3 - l5 + 1L) {
                return 0L;
            }
            n2 = 0;
            int n3 = (int)Math.min(32512L, l2 - (long)n2);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            long l7 = LobPlsqlUtil.hasPattern(oracleConnection, datum, n, byArray2, l5);
            if (l7 == 0L) {
                return 0L;
            }
            l6 = l7;
            n2 += n3;
            l5 = l7 + (long)n3;
            boolean bl2 = true;
            while (bl2) {
                n3 = (int)Math.min(32512L, l2 - (long)n2);
                byArray2 = new byte[n3];
                System.arraycopy(byArray, n2, byArray2, 0, n3);
                l7 = LobPlsqlUtil.hasPattern(oracleConnection, datum, n, byArray2, l5);
                if (l7 == l5) {
                    l5 += (long)n3;
                    if ((long)(n2 += n3) != l2) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l7 == 0L) {
                    return 0L;
                }
                l5 = l7 - (long)n2;
                bl2 = false;
            }
        }
        return l6;
    }

    public static long isSubLob(OracleConnection oracleConnection, Datum datum, int n, Datum datum2, long l) throws SQLException {
        if (datum2 == null || l <= 0L) {
            return 0L;
        }
        long l2 = LobPlsqlUtil.length(oracleConnection, datum2, n);
        long l3 = LobPlsqlUtil.length(oracleConnection, datum, n);
        if (l2 == 0L || l2 > l3 - l + 1L || l > l3) {
            return 0L;
        }
        if (l2 <= 32512L) {
            byte[] byArray = new byte[(int)l2];
            LobPlsqlUtil.read(oracleConnection, datum2, n, 1L, l2, byArray);
            return LobPlsqlUtil.hasPattern(oracleConnection, datum, n, byArray, l);
        }
        int n2 = 0;
        long l4 = l;
        boolean bl = false;
        long l5 = 0L;
        while (!bl) {
            if (l2 > l3 - l4 + 1L) {
                return 0L;
            }
            n2 = 0;
            int n3 = (int)Math.min(32512L, l2 - (long)n2);
            byte[] byArray = new byte[n3];
            LobPlsqlUtil.read(oracleConnection, datum2, n, n2 + 1, n3, byArray);
            long l6 = LobPlsqlUtil.hasPattern(oracleConnection, datum, n, byArray, l4);
            if (l6 == 0L) {
                return 0L;
            }
            l5 = l6;
            n2 += n3;
            l4 = l6 + (long)n3;
            boolean bl2 = true;
            while (bl2) {
                n3 = (int)Math.min(32512L, l2 - (long)n2);
                byArray = new byte[n3];
                LobPlsqlUtil.read(oracleConnection, datum2, n, n2 + 1, n3, byArray);
                l6 = LobPlsqlUtil.hasPattern(oracleConnection, datum, n, byArray, l4);
                if (l6 == l4) {
                    l4 += (long)n3;
                    if ((long)(n2 += n3) != l2) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l6 == 0L) {
                    return 0L;
                }
                l4 = l6 - (long)n2;
                bl2 = false;
            }
        }
        return l5;
    }

    private static boolean isNCLOB(Datum datum) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("oracle.sql.CLOB");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        if (!clazz.isInstance(datum)) {
            return false;
        }
        CLOB cLOB = (CLOB)datum;
        return cLOB.isNCLOB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Datum createTemporaryLob(Connection connection, boolean bl, int n, int n2, short s) throws SQLException {
        Statement statement = null;
        Datum datum = null;
        try {
            statement = (OracleCallableStatement)connection.prepareCall("begin dbms_lob.createTemporary (:1," + (bl ? "TRUE" : "FALSE") + ", :2); end;");
            statement.registerOutParameter(1, n2);
            statement.setFormOfUse(1, s);
            statement.setInt(2, n);
            statement.execute();
            datum = statement.getOracleObject(1);
            Object var8_7 = null;
            if (statement == null) return datum;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (statement == null) throw throwable;
            statement.close();
            statement = null;
            throw throwable;
        }
        statement.close();
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void freeTemporaryLob(Connection connection, Datum datum, int n) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin dbms_lob.freeTemporary (:1); end;");
            oracleCallableStatement.registerOutParameter(1, n);
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(1, (short)2);
            }
            oracleCallableStatement.setOracleObject(1, datum);
            oracleCallableStatement.execute();
            datum.setShareBytes(oracleCallableStatement.privateGetBytes(1));
            Object var5_4 = null;
            if (oracleCallableStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
    }
}

