---
title: textlint v14.0.0
author: azu
authorURL: http://github.com/azu
---

We are pleased to announce the release of textlint v14.0.0.
This release includes a number of new features and improvements.

## Summary

textlint v14 requires Node.js v18.14.0;.

Node.js 16 is already EOL, so we drop support for Node.js 16.
If you use older Node.js, you need to upgrade Node.js to LTS(Long Term Support) version.

- [Download | Node.js](https://nodejs.org/en/download/)

## Breaking Changes for user

### Drop Node.js 16 support

textlint v14 requires Node.js v18.14.0+.
You need to upgrade Node.js to 18 or 20.

- [Download | Node.js](https://nodejs.org/en/download/)

For textlint developer, `textlint-scripts` also requires Node.js v18.19.0+.

### Move `gulp-textlint` to out of monorepo

We move `gulp-textlint` to out of monorepo.

- [chore!: move gulp-textlint to out of monorepo by azu · Pull Request #1319 · textlint/textlint](https://github.com/textlint/textlint/pull/1319)
- [textlint/gulp-textlint](https://github.com/textlint/gulp-textlint)

`gulp-textlint` is not maintained by textlint core team.

If you interested in `gulp-textlint`, please check the following issue:

- [Looking for new maintainers · Issue #12 · textlint/gulp-textlint](https://github.com/textlint/gulp-textlint/issues/12)

### Remove `--parallel` and `--maxConcurrency` flag

textlint v14 removes `--parallel` and `--maxConcurrency` flag.
This flag is for parallel linting, but It is not used by many users.

We may visit again, but we will delete this experimental flag once.

- Issue: [Parallel linting · Issue #633 · textlint/textlint](https://github.com/textlint/textlint/issues/633)
- PR: [fix(textlint): remove `--parallel` and `--maxConcurrency` flag by azu · Pull Request #1338 · textlint/textlint](https://github.com/textlint/textlint/pull/1338)

### Remove `@textlint/linter-formatter` CLI

`@textlint/linter-formatter` includes CLI, but it is not used by many users.
So, we remove the CLI from `@textlint/linter-formatter`.

- PR: [Removes CLI from @textlint/linter-formatter by kapooraryan · Pull Request #1272 · textlint/textlint](https://github.com/textlint/textlint/pull/1272)

## Breaking Changes for developer

### Change textlint-scirpts output target

`textlint-scripts` output target is changed to Node.js v18.14.0.

Previously, It output ES2015-compatible JavaScript.
In textlint v14, It outputs ES2022-compatible JavaScript.

It means that `textlint-scripts` output JavaScript is compatible with Node.js v18.14.0+.
It aims to support the latest JavaScript features and improve the performance of the output.

### Add deprecation warning to old APIs

textlint v14 adds a deprecation warning to old APIs.
Old APIs are `textlint`, `TextLintCore`, `TextLintEngine`, and `TextFixEngine` of `textlint` package.

There are replaced by `createLinter` and `loadTextlintrc`, and `loadLinerFormatter` since v13.0.0.

- [textlint v13.0.0 · textlint](https://textlint.github.io/blog/2023/01/27/textlint-13.html)

#### Depretead old APIs

Depreacate four APIs in `textlint` package.

| Old API | New API |
| --- | ----------- |
| `textlint` | use `@textlint/legacy-textlint-core` or `@textlint/kernel` |
| `TextLintCore` | use `@textlint/legacy-textlint-core` or `@textlint/kernel` |
| `TextLintEngine` | use `createLinter` and `loadTextlintrc` |
| `TextFixEngine` | use `createLinter` and `loadTextlintrc` |

#### How to control the deprecation message?

- If the `NODE_OPTIONS=--throw-deprecation` is used, the deprecation warning is thrown as an exception rather than being emitted as an event.
- If the `NODE_OPTIONS=--no-deprecation` is used, the deprecation warning is suppressed.
- If the `NODE_OPTIONS=--trace-deprecation` is used, the deprecation warning is printed to stderr along with the full stack trace.

If you want to find the usage of deprecation APIs, you can run with `NODE_OPTIONS=--throw-deprecation` env.

```shell
NODE_OPTIONS=--throw-deprecation node your-script.js
```

For more details, see [process.emitWarning(warning[, options])](https://nodejs.org/api/process.html#processemitwarningwarning-options).

#### Documentaion for New APIs

- [Use as Node Modules · textlint](https://textlint.github.io/docs/use-as-modules.html)

#### Migration Guide

- [Feedback for new APIs · textlint/textlint · Discussion #968](https://github.com/textlint/textlint/discussions/968)

##### `TextLintEngine`/`TextFixEngine` migration

Use `createLinter` and `loadTextlintrc` instead of `TextLintEngine`/`TextFixEngine`

```ts
import { TextLintEngine } from "textlint";
import path from "path";
function lintFile(filePath) {
  const engine = new TextLintEngine({
    formatterName: "stylish",
  });
  const filePathList = [filePath];
  return engine.executeOnFiles(filePathList).then(function (results) {
    const output = engine.formatResults(results);
    console.log(output);
  });
}
lintFile(path.resolve(process.cwd(), "README.md"));
```

→

```ts
import { createLinter, loadTextlintrc, loadLinterFormatter } from "textlint";
import path from "node:path";
import { fileURLToPath } from "node:url";
async function lintFile(filePath) {
    // descriptor is a structure object for linter
    // It includes rules, plugins, and options
    const descriptor = await loadTextlintrc({
        configFilePath: path.join(process.cwd(), ".textlintrc.json")
    });
    const linter = createLinter({
        descriptor
    });
    const results = await linter.lintFiles([filePath]);
    // textlint has two types formatter sets for linter and fixer
    const formatter = await loadLinterFormatter({ formatterName: "stylish" });
    const output = formatter.format(results);
    console.log(output);
}
lintFile(path.join(process.cwd(), "README.md")
```

##### `TextLintCore` and `textlint` migration

Use [`@textlint/legacy-textlint-core`](https://github.com/textlint/textlint/blob/master/packages/%40textlint/legacy-textlint-core/README.md) instead of it.
This package is deprecated, but you can migrate it smooth.

```diff
- import { TextLintCore } from "textlint";
+ import { TextLintCore } from "@textlint/legacy-textlint-core";
const textlint = new TextLintCore();
```

## Full Changelog

- [textlint v14.0.0 - textlint](https://github.com/textlint/textlint/releases/tag/v14.0.0)

## Thanks for Support!

Many people support us, Thanks!

If you're interested in GitHub Sponsor, please check [@azu on GitHub Sponsors](https://github.com/sponsors/azu)!

<iframe src="https://github.com/sponsors/azu/card" title="Sponsor azu" height="225" width="600" style="border: 0;"></iframe>
