---
title: textlint v13.0.0
author: azu
authorURL: http://github.com/azu
---

We just publish textlint v13.0.0, which is a major release upgrade of textlint.

textlint v13 support ESM rules/plugins native.

We have rewritten CLI and `textlint` package.
However, it is not a breaking change for most `textlint` CLI users.
Almost CLI behaviors are the same as textlint v12.

## Summary

**For textlint user**

You can upgrade textlint via following commands:

    npm install textlint@13 --save-dev
    # or
    yarn install textlint@13 --dev

textlint 13.0.0 requires Node.js 16+.
If you use Node.js 14, you need to upgrade Node.js to 16+.

- [Download | Node.js](https://nodejs.org/en/download/)

**For textlint rule creator**

You can write own rule as ESM module.

`textlint` v13.0.0 can load ESM rules native. So you need to transpile your rule to CommonJS.

`textlint` CLI load ESM rules and lint files!

:warning: However, textlint editor plugin may not support ESM rules yet.
You need to wait for editor plugin author migrate to textlint new APIs.

**For textlint module user**

If you use `textlint` as node module, you should use new APIs.

`textlint` package provides new APIs from [v12.3.0](https://github.com/textlint/textlint/releases/tag/v12.3.0)

We have introduced new API like `createLinter` for supporting Async APIs.
v13 continue to support current `TextlintCore`, `TextLintEngine` and `TextFixEngine` for backward compatible.
However, These API will be retired in the future.

New `createLinter` and `loadTextlintrc` supports ESM rules/plugins.
`textlint` modules user should use these instead of `TextlintCore`, `TextLintEngine` and `TextFixEngine`.

ℹ️ Timeline:

- textlint v12.3.0 support old APIs(deprecated) and new APIs
    - use old APIs as default
- textlint v13.0.0 support old APIs(deprecated) and new APIs
    - use new APIs as default - CURRENT
- textlint v14.0.0 drop to support old APIs

| API                         | Description                                                                                                     | Behavior                                        | Target Platform          | v13+                                                   |
|-----------------------------|-----------------------------------------------------------------------------------------------------------------|-------------------------------------------------|--------------------------|--------------------------------------------------------|
| cli                         | Command LIne Interface                                                                                          | Async                                           | Node.js                  | ✅ (Use `createLinter` and `loadTextlintrc` internally) |
| textlint                    | TextLintCore alias                                                                                              | Async                                           | Node.js/CommonJS         | ❌ Deprecated                                           |
| TextLintCore                | Old API. It is Procedural API. Lint Only Single File. Recommended to use @texltint/kernel module instead of It. | Async                                           | Node.js/CommonJS         | ❌ Deprecated                                           |
| TextLintEngine              | Lint Engine API. It load .textlintrc automaticaly                                                               | ◉ Loading is Sync <br>◉ Linting is Async        | Node.js/CommonJS         | ❌ Deprecated                                           |
| TextFixEngine               | Fix Engine API. It load .textlintrc automaticaly                                                                | ◉ Loading is Sync <br>◉ Fixing is Async         | Node.js/CommonJS         | ❌ Deprecated                                           |
| createLinter/loadTextlintrc | Support Async APIs.                                                                                             | ◉ Loading is Async<br>◉ Linting/Fixing is Async | Node.js/CommonJS and ESM | ✅ Recommended                                          |

## New APIs

textlint v12.3.0 introduce new APIs.
textlint will drop support old APIs(`textlint`, `TextLintEngine`, `TextFixEngine`, and `TextLintCore`) in the future.

📝 Old APIs can not support ECMAScript modules, new APIs support ECMAScript modules.

- `createLinter`: create linter instance
    - `lintFiles(files): Promise<TextlintResult[]>`: lint files and return linter messages
    - `lintText(text, filePath): Promise<TextlintResult>` lint text with virtual filePath and return linter messages
    - `fixFiles(files): Promise<TextlintFixResult[]>` lint text and return fixer messages
    - `fixText(text, filePath): Promise<TextlintFixResult>` lint text with virtual filePath and return fixer messages
        - `fixFiles` and `fixText` does not modify files
- `loadTextlintrc`: load `.textlintrc` config file and return a descriptor object
- `loadLinerFormatter` and `loadFixerFormatter`: load formatter

### Examples

Lint files and output to console.

```ts
import { createLinter, loadTextlintrc, loadLinterFormatter } from "textlint";
// descriptor is a structure object for linter
// It includes rules, plugins, and options
const descriptor = await loadTextlintrc();
const linter = createLinter({
    descriptor
});
const results = await linter.lintFiles(["*.md"]);
// textlint has two types formatter sets for linter and fixer
const formatter = await loadLinterFormatter({ formatterName: "stylish" })
const output = formatter.format(results);
console.log(output);
```

For more details, please read next document.

- [Use as Node Modules · textlint](https://textlint.github.io/docs/use-as-modules.html)

If you have any questions, please ask us via GitHub Discussion.

- [Feedback for new APIs · Discussion #968 · textlint/textlint](https://github.com/textlint/textlint/discussions/968)

## ChangeLog

### 🔥 Breaking Changes

- Require Node.js 16+
- `textlint --init` output `.textlintrc.json`
  - Previously, `textlint --init` output `.textlintrc`
- Improve `@textlint/ast-node-types` types
  - Now, All node types are defined!
  - It changes the existing node type and it is a breaking change
  - If you want to know TxtAST, please read [TxtAST Interface](https://textlint.github.io/docs/txtnode.html)
- Use New-CLI instead of Old-CLI
  - textlint has introduced New-CLI and New-APIs in [v12.3.0](https://github.com/textlint/textlint/releases/tag/v12.3.0)
  - New-CLI uses new APIs: `createLinter`/`loadTextlintrc`/`loadLinterFormatter`/`loadFixerFormatter`( If you want to know new APIs, please read [Use as Node Modules](https://textlint.github.io/docs/use-as-modules.html))
  - It means that textlint support rules/plugins that are written by ESM 🎉
  - Remove Old-CLI

#### Difference between Old-CLI and New-CLI

- New CLI support ESM rules/plugins
- New CLI must require `--stdin-filename` with  `--stdin`
  - `--stdin-filename` may be optional in Old-CLI
- Correct exit status

#### Exit Status on new CLI

`0`: No Error

- Not found lint error
- --fix: found errors but fix all errors, so exit with 0
- --output-file: Found lint error but --output-file is specified
- --dryRun: Found lint error but --dryRun is specified

`1`: Lint Error

- found lint error
- --fix: found errors and could not fix all errors, so exit with 1

`2`: Fatal Error

- Crash textlint process
- Fail to load config/rule/plugin etc...

### 🆕 Features

#### Add individual Node type and Add Table/TableRow/TableCell node #1008

- Define all node types in `@textlint/ast-node-types`
- Add Table/TableRow/TableCell node to `@textlint/ast-node-types`

These types are defined in [`@textlint/ast-node-types`](https://github.com/textlint/textlint/tree/master/packages/%40textlint/ast-node-types).

| Type name                       | Node type                        | Description                          |
|---------------------------------|----------------------------------|--------------------------------------|
| ASTNodeTypes.Document           | TxtDocumentNode(TxtParentNode)   | Root Node                            |
| ASTNodeTypes.DocumentExit       | TxtDocumentNode(TxtParentNode)   |                                      |
| ASTNodeTypes.Paragraph          | TxtParagraphNode(TxtParentNode)  | Paragraph Node                       |
| ASTNodeTypes.ParagraphExit      | TxtParagraphNode(TxtParentNode)  |                                      |
| ASTNodeTypes.BlockQuote         | TxtBlockQuoteNode(TxtParentNode) | > Block Quote Node                   |
| ASTNodeTypes.BlockQuoteExit     | TxtBlockQuoteNode(TxtParentNode) |                                      |
| ASTNodeTypes.List               | TxtListNode(TxtParentNode)       | List Node                            |
| ASTNodeTypes.ListExit           | TxtListNode(TxtParentNode)       |                                      |
| ASTNodeTypes.ListItem           | TxtListItemNode(TxtParentNode)   | List (each) item Node                |
| ASTNodeTypes.ListItemExit       | TxtListItemNode(TxtParentNode)   |                                      |
| ASTNodeTypes.Header             | TxtHeaderNode(TxtParentNode)     | # Header Node                        |
| ASTNodeTypes.HeaderExit         | TxtHeaderNode(TxtParentNode)     |                                      |
| ASTNodeTypes.CodeBlock          | TxtCodeBlockNode(TxtParentNode)  | Code Block Node                      |
| ASTNodeTypes.CodeBlockExit      | TxtCodeBlockNode(TxtParentNode)  |                                      |
| ASTNodeTypes.HtmlBlock          | TxtHtmlBlockNode(TxtParentNode)  | HTML Block Node                      |
| ASTNodeTypes.HtmlBlockExit      | TxtHtmlBlockNode(TxtParentNode)  |                                      |
| ASTNodeTypes.Link               | TxtLinkNode(TxtParentNode)       | Link Node                            |
| ASTNodeTypes.LinkExit           | TxtLinkNode(TxtParentNode)       |                                      |
| ASTNodeTypes.Delete             | TxtDeleteNode(TxtParentNode)     | Delete Node(`~Str~`)                 |
| ASTNodeTypes.DeleteExit         | TxtDeleteNode(TxtParentNode)     |                                      |
| ASTNodeTypes.Emphasis           | TxtEmphasisNode(TxtParentNode)   | Emphasis(`*Str*`)                    |
| ASTNodeTypes.EmphasisExit       | TxtEmphasisNode(TxtParentNode)   |                                      |
| ASTNodeTypes.Strong             | TxtStrongNode(TxtParentNode)     | Strong Node(`**Str**`)               |
| ASTNodeTypes.StrongExit         | TxtStrongNode(TxtParentNode)     |                                      |
| ASTNodeTypes.Break              | TxtBreakNode                     | Hard Break Node(`Str<space><space>`) |
| ASTNodeTypes.BreakExit          | TxtBreakNode                     |                                      |
| ASTNodeTypes.Image              | TxtImageNode                     | Image Node                           |
| ASTNodeTypes.ImageExit          | TxtImageNode                     |                                      |
| ASTNodeTypes.HorizontalRule     | TxtHorizontalRuleNode            | Horizontal Node(`---`)               |
| ASTNodeTypes.HorizontalRuleExit | TxtHorizontalRuleNode            |                                      |
| ASTNodeTypes.Comment            | TxtCommentNode                   | Comment Node                         |
| ASTNodeTypes.CommentExit        | TxtCommentNode                   |                                      |
| ASTNodeTypes.Str                | TxtStrNode                       | Str Node                             |
| ASTNodeTypes.StrExit            | TxtStrNode                       |                                      |
| ASTNodeTypes.Code               | TxtCodeNode                      | Inline Code Node                     |
| ASTNodeTypes.CodeExit           | TxtCodeNode                      |                                      |
| ASTNodeTypes.Html               | TxtHtmlNode                      | Inline HTML Node                     |
| ASTNodeTypes.HtmlExit           | TxtHtmlNode                      |                                      |
| ASTNodeTypes.Table              | TxtTableNode                     | Table node. textlint 13+             |
| ASTNodeTypes.TableExit          | TxtTableNode                     |                                      |
| ASTNodeTypes.TableRow           | TxtTableRowNode                  | Table row node. textlint 13+         |
| ASTNodeTypes.TableRowExit       | TxtTableRowNode                  |                                      |
| ASTNodeTypes.TableCell          | TxtTableCellNode                 | Table cell node. textlint 13+        |
| ASTNodeTypes.TableCellExit      | TxtTableCellNode                 |                                      |

Some nodes have additional properties.
For example, `TxtHeaderNode` has `level` property.

```ts
export interface TxtHeaderNode extends TxtParentNode {
    type: "Header";
    depth: 1 | 2 | 3 | 4 | 5 | 6;
    children: PhrasingContent[];
}
```

For more details, see [`@textlint/ast-node-types`](https://github.com/textlint/textlint/tree/master/packages/%40textlint/ast-node-types).

- [`@textlint/ast-node-types/src/NodeType.ts`](https://github.com/textlint/textlint/tree/master/packages/%40textlint/ast-node-types/src/NodeType.ts).

## Full Changelog

- [textlint v13.0.0 - textlint](https://github.com/textlint/textlint/releases/tag/v13.0.0)

## Thanks for Support!

Many people support us, Thanks!

If you're interested in GitHub Sponsor, please check [@azu on GitHub Sponsors](https://github.com/sponsors/azu)!

<iframe src="https://github.com/sponsors/azu/card" title="Sponsor azu" height="225" width="600" style="border: 0;"></iframe>
