---
title: textlint v12.0.0
author: azu
authorURL: http://github.com/azu
---

We just publish textlint v12.0.0, which is a major release upgrade of textlint.

This release adds some new features and fixes several bugs found in the previous release.
This release also has some breaking changes.

## Summary

**For textlint user**

textlint improves markdown parsing, so it may found newer errors.

You can upgrade textlint via following commands:

    npm install textlint@12
    # or
    yarn install textlint@12

textlint 12.0.0 requires Node.js 12+.
If you are using Node.js 10.x, please upgrade your Node.js env.

- [Download | Node.js](https://nodejs.org/en/download/)

**For textlint rule creator**

`textlint-tester` and `textlint-scripts` are updated.

```
npm install textlint-scripts@12 --save-dev
# or
yarn install textlint-scripts@12 --dev
```

`textlint-tester@12` use `export default` instead of `modules.exports = `.
So, you need to use `import TextLintTester from "textlint-tester"` instead of `const TextLintTester = require("textlint-tester")`.

```diff
- const TextLintTester = require("textlint-tester");
+ import TextLintTester from "textlint-tester";
```

Migration script using [Semgrep](https://semgrep.dev/docs/getting-started/#run-semgrep-locally).

```
# Install semgrep
# For macOS
$ brew install semgrep

# For Ubuntu / Windows via WSL / Linux / macOS
$ python3 -m pip install semgrep

# ---- After installation ----

# Run migration script
semgrep --config s/azu:textlint-12-migration
```

## Breaking Changes

- All `@textlint/*` internal modules use same version
    - All modules are released as `12.0.0`.
- Drop Node.js 10.x support [#600](https://github.com/textlint/textlint/issues/600)
    - update `engines` filels to `"node": "^12.20.0 || ^14.13.1 || >=16.0.0"`
- Modules require ES2015 supported environments [#777](https://github.com/textlint/textlint/issues/777) [#774](https://github.com/textlint/textlint/issues/774)
    - Now, all module target is ES2015
    - It means that textlint does not support IE
    - 📝 Node.js 12+ support ES2018+
- Built-in markdown parser is updated
    - `@textlint/markdown-to-ast@12` use [remark@13.0.0](https://github.com/remarkjs/remark/releases/tag/13.0.0)

## Package Versions

| Breaking Changes | Package | Previous version | Current version |
| ----  | ---- | ---- | ---- |
| ✔ | textlint | 11.9.1 | 12.0.0 |
| ✔ | textlint-tester | 5.3.5 | 12.0.0 |
| ✔ | textlint-scripts | 3.0.0 | 12.0.0 |
| 　| @textlint/ast-node-types | 4.4.3 | 12.0.0 |
| 　| @textlint/ast-traverse | 2.3.5 | 12.0.0 |
| 　| @textlint/ast-tester | 2.3.5 | 12.0.0 |
| 　| @textlint/feature-flag | 3.3.5 | 12.0.0 |
| 　| @textlint/fixer-formatter | 3.3.5 | 12.0.0 |
|    | @textlint/kernel | 3.4.5 | 12.0.0 |
| 　| @textlint/linter-formatter | 3.3.5 | 12.0.0 |
| 　| @textlint/module-interop | 1.2.5 | 12.0.0 |
| ✔ | @textlint/textlint-plugin-markdown | 5.3.5 | 12.0.0 |
| 　| @textlint/textlint-plugin-text | 4.3.5 | 12.0.0 |
| ✔ | @textlint/types | 1.5.5 | 12.0.0 |
|  | @textlint/utils | 1.2.5 | 12.0.0 |

Now, This monorepo includes `textlint-scripts` package in [#779](https://github.com/textlint/textlint/issues/779).

## `@textlint/markdown-to-ast`

It is a markdown parser in textlint.
We have updated to [remark@13.0.0](https://github.com/remarkjs/remark/releases/tag/13.0.0), and it has many changes related to Markdown AST

You can see the changes at [feat(markdown-to-ast): update to remark-parse@9 #767](https://github.com/textlint/textlint/pull/767)

This package updates also includes security fixes.
CVE-2020-7753 has been fixed in textlint 12.0.0.

- [Regular Expression Denial of Service in trim · CVE-2020-7753 · GitHub Advisory Database](https://github.com/advisories/GHSA-w5p7-h5w8-2hfq)

### Features

#### Add `FootnoteReference` node

```markdown
The NATO phonetic alphabet[^wiki].

[^wiki]: Read more about it on wikipedia: <http://en.wikipedia.org/wiki/NATO_phonetic_alphabet>.
```

Previously, It is called `LinkReference`, textlint@12 treat it as `FootnoteReference`.
Some rules may report new errors on `FootnoteReference`.

### Known bugs

- gfm parsing bug that generate broken AST: [remarkjs/remark-gfm#16](https://github.com/remarkjs/remark-gfm/issues/16)
    - → textlint use workaround:  [remarkjs/remark-gfm#16 (comment)](https://github.com/remarkjs/remark-gfm/issues/16#issuecomment-846357030) at [`c99218e`](https://github.com/textlint/textlint/commit/c99218ea37518e8a42bb5d283276ccf696618748)
    - → markdown-to-ast does not generate broken AST.

## `textlint-tester`

- use `export default` instead of `export =` [#775](https://github.com/textlint/textlint/issues/775) [#689](https://github.com/textlint/textlint/issues/689)

The `textlint-tester` user should use `import` instead of `require`.

```diff
- const TextLintTester = require("textlint-tester");
+ import TextLintTester from "textlint-tester";
```

Or, pick `default` property.

```diff
- const TextLintTester = require("textlint-tester");
+ const TextLintTester = require("textlint-tester").default;
```

## `textlint-scripts`

- Update to mocha@8

## `@textlint/types`

- Fix `getSource` argument type [#770](https://github.com/textlint/textlint/issues/770)

## `@textlint/ast-tester`

- Improve error message [#783](https://github.com/textlint/textlint/issues/783)

## Community News 🆕

- [textlint-plugin-latex2e](https://github.com/textlint/textlint-plugin-latex2e) reach to v1.0.0 🎉
  - textlint can lint LaTeX files with this plugin
- [@textlint/editor](https://github.com/textlint/editor) beta released 🎉
  - textlint works on your browser as browser extension
  - [textlint editor - Firefox](https://addons.mozilla.org/firefox/addon/textlint-editor/)
  - [textlint editor - Chrome](https://chrome.google.com/webstore/detail/textlint-editor/gfhlfpnpjokocfohicmfbgjneiipfeil)
  - It's [purpose](https://github.com/textlint/editor#purpose) is privacy first linting tools!

## Thanks to Support!

[VELC](https://github.com/Velc) supports [@azu](https://github.com/azu/) as GitHub Sponsors!

- [会社（ヴェルク）としてGithub Sponsorsになりました - ヴェルク - IT起業の記録](https://tamukai.blog.velc.jp/entry/2021/05/18/091040) (Japanese blog)

Many people support me, Thanks again!

If you're interested in GitHub Sponsor, please check [@azu on GitHub Sponsors](https://github.com/sponsors/azu)! 

<iframe src="https://github.com/sponsors/azu/card" title="Sponsor azu" height="225" width="600" style="border: 0;"></iframe>
