---
title: textlint 11 released
author: azu
authorURL: http://github.com/azu
---

We just pushed textlint v11.0.0, which is a major release upgrade of textlint.

This release adds some new features and fixes several bugs found in the previous release.
This release also has some breaking changes.

# Highlights

## ⭐️ Features

### [@textlint/textlint-plugin-text](https://github.com/textlint/textlint/tree/master/packages/%40textlint/textlint-plugin-text) and [@textlint/textlint-plugin-markdown](https://github.com/textlint/textlint/tree/102d5683ea7172ead702acf00e9fc111a53637d3/packages/%40textlint/textlint-plugin-markdown) support `extensions` option

Notes: [@textlint/textlint-plugin-text](https://github.com/textlint/textlint/tree/master/packages/%40textlint/textlint-plugin-text) and [@textlint/textlint-plugin-markdown](https://github.com/textlint/textlint/tree/102d5683ea7172ead702acf00e9fc111a53637d3/packages/%40textlint/textlint-plugin-markdown) are built-in plugin.

For example, if you want to treat `.hown` as markdown, put `extensions` options to `.textlintrc`    

```json5
{
    "plugins": {
        "@textlint/markdown": {
            "extensions": [".hown"]
        }
    }
}
```

For more details, please see [custom extension example](https://github.com/textlint/textlint/tree/master/examples/plugin-extensions-option).

For developer:

if you want to support `extensions` options, see [Plugin · textlint](https://textlint.github.io/docs/plugin.html).

### Show message if `textlint --init` is success [#529](https://github.com/textlint/textlint/issues/529)

Add message to `textlint --init`

![screen shot](https://user-images.githubusercontent.com/19714/41762379-7d696dfc-7635-11e8-9b57-661aff4daba7.png)


## 🔥BREAKING CHANGE

### Drop Node.js 4.x support [#443](https://github.com/textlint/textlint/issues/443) 

textlint does no more test on Node.js 4.x.
Node.js 4.x was end of support.

- [nodejs/Release: Node.js Foundation Release Working Group](https://github.com/nodejs/Release)

If you use Node.js 4.x, please update Node.js.

- [Node.js official site](https://nodejs.org/)

### [Developer] Freeze Rule's Context [#508](https://github.com/textlint/textlint/issues/508) 

textlint 11 freeze rule's `context` object.

Next code should throw error in textlint 11.

```js
export default function(context) {
    // Error: `context` object can not be modified
    context.modifiedContext = true;
    const { Syntax } = context;
    return {
        [Syntax.Str](node) {
        }
    };
}
```

### [Developer] Change default value of Rule's `options` and Plugin's `options` [#535](https://github.com/textlint/textlint/issues/535) [#540](https://github.com/textlint/textlint/issues/540)

textlint@11 change the default value of `options` from `true` to `{}` (empty object).

For example, `very-nice-rule`'s option is `true`(enable the rule) in `.textlintrc`
 
```json
{
  "rules": {
    "very-nice-rule": true
  }
}
```

**Before**

`very-nice-rule.js` rule get `true` as `options`.
 
```js
export default function(context, options) {
    console.log(options); // true
}
```

**After**:
 
`very-nice-rule.js` rule get `{}` (emptry object) as `options`.
 
```js
export default function(context, options) {
    console.log(options); // {}
}
```

## ⚠ Deprecation 

### [Developer] Deprecate `static availableExtensions()` in plugin Processor

Insteadof it, support availableExtensions() instance method in plugin [#534](https://github.com/textlint/textlint/issues/534)

You should change the implementaion of plugin.
textlint still support `static availableExtensions` for backward-compatibility.

```diff
-    static availableExtensions() {
+    availableExtensions() {
        return [".txt", ".text"];
    }
```

This change allow to extends `availableExtensions()` by options.

- Example: [feat: markdown/text plugin support "extensions" options by azu · Pull Request #537 · textlint/textlint](https://github.com/textlint/textlint/pull/537)

For more information, see [availableExtensions(): string\[\]](https://github.com/textlint/textlint/blob/master/docs/plugin.md#availableextensions-string).

---


# ALL CHANGELOG

## textlint@11.0.0

### fixes

- **textlint:** add engine.availableExtensions for backward-compatible ([e8652bc](https://github.com/textlint/textlint/commit/e8652bc))
- **textlint:** fix config type ([0f2fd6f](https://github.com/textlint/textlint/commit/0f2fd6f))
- **deps:** update mocha ([5df8af4](https://github.com/textlint/textlint/commit/5df8af4))
- **textlint:** add type of public TextlintrcDescriptor ([7268b9e](https://github.com/textlint/textlint/commit/7268b9e))
- **textlint:** make static availableExtensions() optional ([d471637](https://github.com/textlint/textlint/commit/d471637))
- remove [@textlint](https://github.com/textlint)/textlintrc-descriptor ([3613e1f](https://github.com/textlint/textlint/commit/3613e1f))
- **textlint:** use shallowMerge ([95d056d](https://github.com/textlint/textlint/commit/95d056d))
- **kernel:** merge textlintrc-descriptor to kernel ([3c01067](https://github.com/textlint/textlint/commit/3c01067))
- **kernel:** separate linter and fixer descriptor ([b5bc8bd](https://github.com/textlint/textlint/commit/b5bc8bd))
- **textlint:** fix to import util ([6629bd5](https://github.com/textlint/textlint/commit/6629bd5))
- **textlint:** remove &#x60;extensions&#x60; from Config ([7bc9ab8](https://github.com/textlint/textlint/commit/7bc9ab8))
- **textlintrc-descriptor:** Introduce textlintrc-descriptor ([6177794](https://github.com/textlint/textlint/commit/6177794))

### features

- **textlint:** show message if &#x60;textlint --init&#x60; is success ([#529](https://github.com/textlint/textlint/issues/529)) ([102d568](https://github.com/textlint/textlint/commit/102d568))
- **textlint:** support availableExtensions() instance method in plugin ([a7cd053](https://github.com/textlint/textlint/commit/a7cd053))
- **kernel:** add plugin&#x27;s option tests ([f362257](https://github.com/textlint/textlint/commit/f362257))
- **textlint:** add cli output test ([#533](https://github.com/textlint/textlint/issues/533)) ([abd314a](https://github.com/textlint/textlint/commit/abd314a)), closes [#532](https://github.com/textlint/textlint/issues/532)
- **textlint:** add tests for object-to-kernel-format ([5fbb22d](https://github.com/textlint/textlint/commit/5fbb22d))
- **textlint:** fix plugin tests ([bbfc8f6](https://github.com/textlint/textlint/commit/bbfc8f6))

### breakingChanges

[#535](https://github.com/textlint/textlint/issues/535) [#540](https://github.com/textlint/textlint/issues/540)

Change default value of Rule's `options` and Plugin's `options`.

textlint@11 change the default value of `options` from `true` to `{}` (empty object).

For example, `very-nice-rule`'s option is `true`(enable the rule) in `.textlintrc`
 
```json
{
  "rules": {
    "very-nice-rule": true
  }
}
```

**Before**

`very-nice-rule.js` rule get `true` as `options`.
 
```js
export default function(context, options) {
    console.log(options); // true
}
```

**After**:
 
`very-nice-rule.js` rule get `{}` (emptry object) as `options`.
 
```js
export default function(context, options) {
    console.log(options); // {}
}
```

## @textlint/kernel@3.0.0

### fixes

- **kernel:** kernel use TextlintrcDescriptor ([efd89c2](https://github.com/textlint/textlint/commit/efd89c2))
- **kernel:** make rule and plugin&#x27;s option value {} by default ([b7aa63d](https://github.com/textlint/textlint/commit/b7aa63d))
- **deps:** update mocha ([5df8af4](https://github.com/textlint/textlint/commit/5df8af4))
- remove [@textlint](https://github.com/textlint)/textlintrc-descriptor ([3613e1f](https://github.com/textlint/textlint/commit/3613e1f))
- **kernel:** add comment ([582d0d6](https://github.com/textlint/textlint/commit/582d0d6))
- **kernel:** add Processor validation ([86ed609](https://github.com/textlint/textlint/commit/86ed609))
- **kernel:** fix test title ([4eeeff8](https://github.com/textlint/textlint/commit/4eeeff8))
- **kernel:** support instance availableExtensions() method ([b821fc5](https://github.com/textlint/textlint/commit/b821fc5))
- **textlint:** make static availableExtensions() optional ([d471637](https://github.com/textlint/textlint/commit/d471637))
- **textlint:** use shallowMerge ([95d056d](https://github.com/textlint/textlint/commit/95d056d))
- **kernel:** merge textlintrc-descriptor to kernel ([3c01067](https://github.com/textlint/textlint/commit/3c01067))
- **kernel:** remove TextlintRuleDescriptorType ([a5b0f30](https://github.com/textlint/textlint/commit/a5b0f30))
- **kernel:** Replace Object.freeze directly with factory function ([c43580b](https://github.com/textlint/textlint/commit/c43580b))
- **kernel:** separate linter and fixer descriptor ([b5bc8bd](https://github.com/textlint/textlint/commit/b5bc8bd))
- **kernel:** use textlintrc-descriptor instead of rule-creator-helper ([f0eb4bf](https://github.com/textlint/textlint/commit/f0eb4bf))
- **textlintrc-descriptor:** Introduce textlintrc-descriptor ([6177794](https://github.com/textlint/textlint/commit/6177794))
- **typescript:** update to TypeScript 2.8 ([f7b2b08](https://github.com/textlint/textlint/commit/f7b2b08))

### features

- **kernel:** Freeze Context ([7fc9ec8](https://github.com/textlint/textlint/commit/7fc9ec8)), closes [#508](https://github.com/textlint/textlint/issues/508) [#508](https://github.com/textlint/textlint/issues/508)
- **textlint:** support availableExtensions() instance method in plugin ([a7cd053](https://github.com/textlint/textlint/commit/a7cd053))
- **kernel:** Add missing Readonly&lt;T&gt; ([c5313c8](https://github.com/textlint/textlint/commit/c5313c8))
- **kernel:** add plugin&#x27;s option tests ([f362257](https://github.com/textlint/textlint/commit/f362257))
- **textlint:** add tests for object-to-kernel-format ([5fbb22d](https://github.com/textlint/textlint/commit/5fbb22d))

### breakingChanges

- **kernel:** Previously, textlint pass `true` to rule and plugin as default value of option. [#535](https://github.com/textlint/textlint/issues/535) [#540](https://github.com/textlint/textlint/issues/540)


## @textlint/textlint-plugin-markdown@5.0.0

### fixes

- **kernel:** make rule and plugin&#x27;s option value {} by default ([b7aa63d](https://github.com/textlint/textlint/commit/b7aa63d))
- **deps:** update mocha ([5df8af4](https://github.com/textlint/textlint/commit/5df8af4))
- **plugin:** add plugin configuration ([6e179ec](https://github.com/textlint/textlint/commit/6e179ec))

### features

- **textlint-plugin-markdown:** Support &quot;extensions&quot; option ([c3d55fe](https://github.com/textlint/textlint/commit/c3d55fe))

### breakingChanges

- **kernel:** Previously, textlint pass `true` to rule and plugin as default value of option. [#535](https://github.com/textlint/textlint/issues/535) [#540](https://github.com/textlint/textlint/issues/540)

## @textlint/textlint-plugin-text@4.0.0

### fixes

- **kernel:** make rule and plugin&#x27;s option value {} by default ([b7aa63d](https://github.com/textlint/textlint/commit/b7aa63d))
- **deps:** update mocha ([5df8af4](https://github.com/textlint/textlint/commit/5df8af4))
- **plugin:** add &quot;extensions&quot; option to docs ([8026997](https://github.com/textlint/textlint/commit/8026997))
- **plugin:** add plugin configuration ([6e179ec](https://github.com/textlint/textlint/commit/6e179ec))

### features

- **textlint-text-markdown:** support &quot;extensions&quot; option ([cce29ed](https://github.com/textlint/textlint/commit/cce29ed))

### breakingChanges

- **kernel:** Previously, textlint pass &#x60;true&#x60; to rule and plugin as default value of option. [#535](https://github.com/textlint/textlint/issues/535) [#540](https://github.com/textlint/textlint/issues/540)

## gulp-textlint@5.0.11

### fixes

- **deps:** update to natives@1.1.3 ([0c20f42](https://github.com/textlint/textlint/commit/0c20f42))
- **deps:** update mocha ([5df8af4](https://github.com/textlint/textlint/commit/5df8af4))

## textlint-tester@5.0.0

### fixes

- **kernel:** make rule and plugin&#x27;s option value {} by default ([b7aa63d](https://github.com/textlint/textlint/commit/b7aa63d))
- **deps:** update mocha ([5df8af4](https://github.com/textlint/textlint/commit/5df8af4))
- **kernel:** separate linter and fixer descriptor ([b5bc8bd](https://github.com/textlint/textlint/commit/b5bc8bd))

### breakingChanges

- **kernel:** Previously, textlint pass &#x60;true&#x60; to rule and plugin as default value of option.


## textlint-website@10.4.0

### fixes

- **website:** update index.css ([6f7977e](https://github.com/textlint/textlint/commit/6f7977e))
- **website:** use https image ([4495ed3](https://github.com/textlint/textlint/commit/4495ed3))
- **website:** use short menu name ([81911ad](https://github.com/textlint/textlint/commit/81911ad))
- **website:** add { search: true }, ([0c3c4a9](https://github.com/textlint/textlint/commit/0c3c4a9))
- **website:** add Edit url ([e85c6bf](https://github.com/textlint/textlint/commit/e85c6bf))
- **website:** add new blog ([cabc987](https://github.com/textlint/textlint/commit/cabc987))
- **website:** add project link ([2000dc4](https://github.com/textlint/textlint/commit/2000dc4))
- **website:** add textlint icon ([54873c0](https://github.com/textlint/textlint/commit/54873c0))
- **website:** change vuejs usecase ([9d832e5](https://github.com/textlint/textlint/commit/9d832e5))
- **website:** Add a project depends on textlint ([#523](https://github.com/textlint/textlint/issues/523)) ([80b4b73](https://github.com/textlint/textlint/commit/80b4b73))

### features

- **website:** enable search ([9e18b9e](https://github.com/textlint/textlint/commit/9e18b9e))


