---
author: azu
description: "この書籍でJavaScriptを学ぶ前に、まずは意味はわからなくてもいいので、JavaScriptを実行できることから確認していきます。"
---

# 読みはじめる前の事前準備 {#preparation}

この書籍は、すでに何かしらのプログラミング言語を触ったことがある人向けに書かれています。
そのため、この書籍でプログラミング言語を初めて学ぶ場合には、まずコードに慣れる必要があります。

JavaScriptのコードは、ブラウザがあれば実行できます。

{% if output.name == "ebook" %}

まずは、ブラウザをインストールしてください。
ブラウザには[Microsoft Edge][]、[Firefox][]、[Google Chrome][]、[Safari][]などがありますが、この書籍ではFirefoxを使用していきます。すでにブラウザをインストール済みの場合も、最新のバージョンを使っているかを確認してください。

ブラウザの準備ができたら、次のURLをブラウザで開いてください。

- <https://jsprimer.net/intro/preparation/>

{% endif %}

次のJavaScriptのサンプルコードを書き写して、ブラウザでJavaScriptを実行するところから始めてみましょう。

## サンプルコード {#samplecode}

次のコードが書き写して実行するサンプルコードです。
今はまだコードの内容が理解できなくても問題ありません。
まずは、実際にコードを実行してみることが重要です。

```js
function hello(name) {
    console.log("こんにちは" + name + "さん");
}

hello("名前");
```

## エディター {#editor}

このサンプルコードを、次のエディターに書き写して"実行"ボタンを押して、JavaScriptを実行してみてください。
`"`と`"`で囲まれた`名前`という文字列は、自分の名前に書き換えてみてください。

<!-- js-console:{ "state": "open" } -->
```js
// この行を消して、先ほどのコードを書き写して"実行"を押してみよう
```

実行した結果として、次のようなメッセージが表示されているなら実行成功です
（メッセージの`名前`の部分は、自分で書いた名前に書き換えて読んでください）。

> こんにちは名前さん

"ログをクリア"ボタンを押すと、表示されているログを削除できます。
"終了"ボタンを押すとエディターを終了できます。

"実行"ボタンを押して異なるメッセージがでた場合は、次の注意事項を読んでもう一度挑戦してみてください。

## 注意事項 {#caution}

"実行"したときに、`SyntaxError`というようなエラーが表示されたなら、コードのどこかを書き間違えています。
次の点に気をつけて成功するまで試してみてください。

- コードは日本語入力をオフにして入力します
    - `"`と`"`で囲まれた部分以外は、すべて半角の英数字で入力してください
    - `"`（ダブルクォート）、`;`（セミコロン）、カッコ、スペースなどの記号も半角になっているかを確認してください
- 1行入力するごとに<kbd>Enter</kbd>キーを押すことで改行できます
- 大文字と小文字は区別されます
    - このサンプルコードでは小文字の英数字しか利用していません
- コードの意味はまだわからなくても問題ありません
    - 正しくコードを入力して、実行できることが重要です

<!-- textlint-disable -->

*SyntaxError: illegal character*や*SyntaxError: Invalid or unexpected token*のようなエラーメッセージが出ている場合は、
どこかに全角の記号や全角の英数字が混ざっています。

<!-- textlint-enable -->

一度すべてのコードを消してから、もう一度入力してみましょう。

## コードを実行できない {#failure}

<!-- textlint-disable preset-ja-technical-writing/ja-no-weak-phrase -->

どうしても実行できない場合は、まだこの書籍を読むには少し早いのかもしれません。
また、書籍は文字を中心とした解説になるため、初めてのプログラミングではイメージするのが難しいこともあります。
そのため、書籍より情報量の多い動画などを見て、まずはコードを実行できるようにすることからはじめるのがよいかもしれません。

`"JavaScript 入門 動画"`といったキーワードで検索し、映像で学んで見てからでも遅くはありません。

<!-- textlint-enable preset-ja-technical-writing/ja-no-weak-phrase -->

また、もっとも効率的なのは、身近な知り合いに聞くことです。
一人で学ぼうとすると、思わぬところで詰まってしまい進めなくなる場合があります。
特に新しいことは最初の出発点が一番難しいです。
ほかの人に手伝ってもらうことで意外と簡単に進めるようになるはずです。

## ようこそJavaScriptへ {#welcome-to-javascript}

サンプルコードが実行できたなら、おそらくこの書籍は読めるはずです。

この書籍は、JavaScriptというプログラミング言語の基本的な文法から、実際のウェブアプリケーションで使われるようなパターンについてを学んでいく書籍です。
JavaScriptという言語は、常に変化している言語としても知られています。
その意味は、古いコードが動かなくなるのではなく、新しいやり方が常に増えていくという意味での変化です。

この書籍では、そのような変化していくJavaScriptの学び方についても学んでいきます。

<!-- 参考:

- https://gist.github.com/kwappa/afbfae5d6ce005592d7d2e653729ccac

 -->

[Microsoft Edge]: https://www.microsoft.com/ja-jp/edge/home?form=MA13FJ
[Firefox]: https://www.mozilla.org/ja/firefox/new/
[Google Chrome]: https://www.google.com/intl/ja_ALL/chrome/
[Safari]: https://www.apple.com/jp/safari/
