---
author: azu
description: "あらゆる技術書には何かしらの間違いがあるという前提で書籍を読み進めることを推奨しています。また、この書籍で間違いを見つけたらどのように報告、修正するかについてを紹介します。"
---

# 文章の間違いに気づいたら {#how-to-report-mistake}

まったくバグがないプログラムはないのと同様に、まったく間違いのない技術書は存在しません。
この書籍もできるだけ間違い（特に技術的な間違い）を減らせるように努力していますが、
どうしても誤字脱字や技術的な間違い、コード例の間違いなどを見落としている場合があります。

そのため「この書籍には間違いが存在する」と思って読んでいくことを推奨しています。
もし、読んでいて間違いを見つけたなら、ぜひ報告してください。

また、文章の意味や意図がわからないといった疑問を持つこともあるでしょう。
そのような疑問もぜひ報告してください。

もし、その疑問が実際には間違いではなく勘違いであっても、回答をもらうことで自分の理解を修正できます。
そのため、疑問を問い合わせても損することはないはずです。

この書籍はGitHub上で公開されているため、GitHubリポジトリのIssueとしてあなたの疑問を報告できます。

- 書籍や内容に対する質問 → [こちらから質問できます](https://github.com/asciidwango/js-primer/issues/new?template=question.md)
- 内容のエラーや問題の報告 → [こちらからバグ報告できます](https://github.com/asciidwango/js-primer/issues/new?template=bug_report.md)
- 内容をもっと詳細に解説する提案 → [こちらから提案できます](https://github.com/asciidwango/js-primer/issues/new?template=feature_request.md)
- 新しいトピックなどの提案 → [こちらから提案できます](https://github.com/asciidwango/js-primer/issues/new?template=feature_request.md)
- その他のIssue → [その他のIssueはこちらから](https://github.com/asciidwango/js-primer/issues/new?template=other.md)

また、GitHub Discussions（掲示板）へIssueにするのは気が引けると思った質問を書いたり、JavaScript Primerを読んだ感想などを書き込めます。

- [Discussions · asciidwango/js-primer](https://github.com/asciidwango/js-primer/discussions)

GitHub Discussions（掲示板）の使い方については、次のスレッドにまとめています。

- [👋 ようこそ JavaScript Primer へ ! · Discussion #1304 · asciidwango/js-primer](https://github.com/asciidwango/js-primer/discussions/1304)

GitHubのアカウントを持っていない方は、次のフォームから報告できます。

<https://goo.gl/forms/lOx4ckFyb0fB9cBM2>

## 問題を修正する {#pull-request}

この書籍はGitHub上で文章やサンプルのソースコードがすべて公開されています。

- <https://github.com/asciidwango/js-primer>

そのため、問題を報告するだけではなく、修正内容を[Pull Request][]することで問題を修正できます。

詳しいPull Requestの送り方は[CONTRIBUTING.md][]に書かれているので参考にしてください。

- <https://github.com/asciidwango/js-primer/blob/master/CONTRIBUTING.md>

誤字を1文字修正するものから技術的な間違いを修正するものまで、どのような修正であっても感謝いたします。
問題を見つけたら、ぜひ修正することにも挑戦してみてください。

## 参考 {#reference}

- [専門書には間違いもある：柴田 芳樹 (Yoshiki Shibata)：So-netブログ](https://yshibata.blog.ss-blog.jp/2015-12-23)
- [技術書の間違いに気付いたら：柴田 芳樹 (Yoshiki Shibata)：So-netブログ](https://yshibata.blog.ss-blog.jp/2018-06-09)

[Pull Request]: https://help.github.com/articles/about-pull-requests/
[CONTRIBUTING.md]: https://github.com/asciidwango/js-primer/blob/master/CONTRIBUTING.md
