# Links

| Implementation | Characters | Nested | Mismatched | Escaped | Named Entities | Numbered Entities |
| -------------- | ---------- |------- | ---------- | ------- | -------------- | ----------------- |
| Markdown.pl    | `"`        | Yes    | Yes        | No      | Yes            | Yes               |
| GitHub         | `"`        | Yes    | Yes        | No      | No             | No                |
| CommonMark     | `"`        | No     | No         | Yes     | Yes            | Yes               |
| Markdown.pl    | `'`        | Yes    | Yes        | No      | Yes            | Yes               |
| GitHub         | `'`        | Yes    | Yes        | No      | No             | No                |
| CommonMark     | `'`        | No     | No         | Yes     | Yes            | Yes               |
| Markdown.pl    | `()`       | -      | -          | -       | -              | -                 |
| GitHub         | `()`       | -      | -          | -       | -              | -                 |
| CommonMark     | `()`       | No     | Yes        | Yes     | Yes            | Yes               |

## Double quotes

[Hello](./world.html "and text")

[Hello](./world.html "and "matching delimiters"")

[Hello](./world.html "and "mismatched delimiters")

[Hello](./world.html "and \"escapes\"")

[Hello](./world.html "and &quot;named entities&quot;")

[Hello](./world.html "and &#x22;numbered entities&#x22;")

## Single quotes

[Hello](./world.html 'and text')

[Hello](./world.html 'and 'matching delimiters'')

[Hello](./world.html 'and 'mismatched delimiters')

[Hello](./world.html 'and \'escapes\'')

[Hello](./world.html 'and &apos;named entities&apos;')

[Hello](./world.html 'and &#x27;numbered entities&#x27;')

## Parentheses

[Hello](./world.html (and text))

[Hello](./world.html (and (matching delimiters)))

[Hello](./world.html (and (mismatched delimiters))

[Hello](./world.html (and \(escapes\)))

[Hello](./world.html (and &lpar;named entities&rpar;))

[Hello](./world.html (and &#x28;numbered entities&#x29;))

# Images

## Double quotes

![Hello](./world.png "and text")

![Hello](./world.png "and "matching delimiters"")

![Hello](./world.png "and "mismatched delimiters")

![Hello](./world.png "and \"escapes\"")

![Hello](./world.png "and &quot;named entities&quot;")

![Hello](./world.png "and &#x22;numbered entities&#x22;")

## Single quotes

![Hello](./world.png 'and text')

![Hello](./world.png 'and 'matching delimiters'')

![Hello](./world.png 'and 'mismatched delimiters')

![Hello](./world.png 'and \'escapes\'')

![Hello](./world.png 'and &apos;named entities&apos;')

![Hello](./world.png 'and &#x27;numbered entities&#x27;')

## Parentheses

![Hello](./world.png (and text))

![Hello](./world.png (and (matching delimiters)))

![Hello](./world.png (and (mismatched delimiters))

![Hello](./world.png (and \(escapes\)))

![Hello](./world.png (and &lpar;named entities&rpar;))

![Hello](./world.png (and &#x28;numbered entities&#x29;))
