# Comments

Comments are statements that will not be executed by the interpreter, comments are used to mark annotations for other programmers or small descriptions of what your code does, thus making it easier for others to understand what your code does.

In Javascript, comments can be written in 2 different ways:

* Line starting with `//`:

```javascript
// This is a comment, it will be ignored by the interpreter
var a = "this is a variable defined in a statement";
```

* Section of code starting with `/*`and ending with `*/`, this method is used for multi-line comments:

```javascript
/*
This is a multi-line comment,
it will be ignored by the interpreter
*/
var a = "this is a variable defined in a statement";
```


---

Mark the editor's contents as a comment

```js

Mark me as a comment
or I'll throw an error

```

```js
/*
Mark me as a comment
or I'll throw an error
*/
```

```js
assert.ok(true);
```

---
