# ASP.NET Essential Training
## by [Tertiary Infotech Pte. Ltd](https://www.tertiarycourses.com.sg/)

These are the exercise files used for [ASP.NET Essential Training](https://www.tertiarycourses.com.sg/asp-net-essential-training-singapore.html) course. 

The course outline can be found in 

https://www.tertiarycourses.com.sg/asp-net-essential-training-singapore.html
https://www.tertiarycourses.com.my/asp-net-essential-training-malaysia.html

<p><strong>Module 1. Getting Started</strong></p>
<ul>
<li>Understanding how ASP.NET works</li>
<li>Installing Visual Studio&nbsp;</li>
<li>Hello World: Creating your first ASP.NET web site</li>
<li>Creating pages with dynamic output</li>
<li>Understanding the development web server</li>
<li>Exploring the development environment</li>
</ul>
<p><strong>Module 2. Using Microsoft SQL Server</strong></p>
<ul>
<li>Understanding Microsoft SQL Server</li>
<li>Installing SQL Server Express</li>
<li>Exploring SQL Server Management Studio Basic</li>
<li>Creating a new database</li>
<li>Connecting to the database in ASP.NET</li>
<li>Testing SQL queries</li>
<li>Presenting a dataset in an ASP.NET page</li>
</ul>
<p><strong>Module 3. Creating ASP.NET Pages</strong></p>
<ul>
<li>Understanding ASP.NET web form pages</li>
<li>Separating presentation and logic with code files</li>
<li>Adding web form controls to a page</li>
<li>Handling postback data in a web form page</li>
<li>Using data binding expressions</li>
</ul>
<p><strong>Module 4. Programming in ASP.NET</strong></p>
<ul>
<li>Creating a testing environment</li>
<li>Declaring and using a simple variable</li>
<li>Declaring and using a complex object</li>
<li>Using loops</li>
<li>Using functions</li>
<li>Using trace statements</li>
<li>Debugging with breakpoints</li>
<li>Commenting code</li>
</ul>
<p><strong>Module 5. Creating Reusable Code</strong></p>
<ul>
<li>Creating web controls</li>
<li>Registering a user control on a web form page</li>
<li>Registering controls globally in the web.config file</li>
<li>Adding public properties to a web control</li>
</ul>
<p><strong>Module 6. Using Cascading Style Sheets in Web Forms</strong></p>
<ul>
<li>Understanding Cascading Style Sheets (CSS)</li>
<li>Attaching external CSS files</li>
<li>Defining a CSS selector</li>
<li>Using CSS class selectors in server controls</li>
</ul>
<p><strong>Module 7. Presenting Dynamic Data</strong></p>
<ul>
<li>Presenting data with the GridView control</li>
<li>Controlling GridView paging and appearance</li>
<li>Editing data with the GridView control</li>
<li>Presenting data with the DataList control</li>
<li>Formatting data with binding expressions</li>
</ul>
<p><strong>Nodule 8. Creating a Data Entry System</strong></p>
<ul>
<li>Using the DetailsView control</li>
<li>Inserting data with the DetailsView control</li>
<li>Redirecting page requests</li>
<li>Creating an update page</li>
<li>Linking to update pages from the list page</li>
<li>Deleting database records</li>
</ul>
<p><strong>Module 9. Validating User Input</strong></p>
<ul>
<li>Customizing forms with item editing templates</li>
<li>Adding validator controls to a form</li>
<li>Controlling the validation error message display</li>
<li>Using the ValidationSummary control</li>
</ul>
<p><strong>Module 10. Creating Reports</strong></p>
<ul>
<li>Creating a query with joined tables</li>
<li>Replacing control style properties with CSS</li>
<li>Creating a CSS file for printing</li>
<li>Suppressing elements in printed web pages</li>
<li>Selecting data for a report</li>
</ul>
<p><strong>Module 11. Managing Session State</strong></p>
<ul>
<li>Understanding ViewState and managing postbacks</li>
<li>Using session variables</li>
</ul>
<p><strong>Module 12. Securing a Site with Forms Authentication</strong></p>
<ul>
<li>Turning on forms authentication</li>
<li>Creating a page to log in users</li>
<li>Creating a page to set up new users</li>
<li>Understanding the security database</li>
<li>Configuring security in the web.config file</li>
<li>Creating a page to log out users</li>
</ul>
