/*
 * test_stack_update_table_array.cpp
 *
 *  Created on: Mar 4, 2013
 *      Author: ipopa
 */

#include <iostream>
#include <cstring>

#include "test_client_common.h"

using namespace std;

static const uint16_t MAX_VALUES_ENTRIES = 10;

struct ArrayValuesEntry
{
  uint16_t      type;
  uint16_t      elementsCount;
  const char* values[MAX_VALUES_ENTRIES];
};

struct ArrayValuesEntry _values[] =
{
    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }},

    /* Repeat */

    {WHC_TYPE_BOOL, 5, {"0", "0", "1", "0", "1", }},
    {WHC_TYPE_CHAR, 5, {"A", "a", "Z", "\xC5\xA2", "\xE2\x8B\xA0", }},
    {WHC_TYPE_DATE, 3, {"2012/11/21", "2981/3/1", "3123/4/4", }},
    {WHC_TYPE_DATETIME, 3, {"2012/11/21 14:23:12", "2981/3/1 5:1:1", "3123/8/2 0:1:2", }},
    {WHC_TYPE_HIRESTIME, 3, {"2012/11/21 14:23:12.001000", "2981/3/1 5:1:1.100000", "3123/8/2 0:1:2.000400", }},
    {WHC_TYPE_UINT8, 7, {"127", "128", "254", "0", "1", "255", "123", }},
    {WHC_TYPE_UINT16, 7, {"32767", "32768", "65534", "0", "1", "65535", "123", }},
    {WHC_TYPE_UINT32, 7, {"2147483647", "2147483648", "4294967294", "0", "1", "4294967295", "123", }},
    {WHC_TYPE_UINT64, 7, {"9223372036854775807", "9223372036854775808", "18446744073709551614", "0", "1", "18446744073709551615", "123", }},
    {WHC_TYPE_REAL, 5, {"-549755813888.999999", "549755813887.999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_RICHREAL, 5, {"-9223372036854775808.99999999999999", "9223372036854775807.99999999999999", "-123.123", "124.012", "-235451.167" }},
    {WHC_TYPE_INT8, 5, {"-128", "127", "0", "1", "123", }},
    {WHC_TYPE_INT16, 5, {"-32768", "32767", "0", "1", "123", }},
    {WHC_TYPE_INT32, 5, {"-2147483648", "2147483647", "0", "1", "123", }},
    {WHC_TYPE_INT64, 5, {"-9223372036854775808", "9223372036854775807", "0", "1", "123", }}
};

static const WField _fields[] =
{
  {"WHC_TYPE_ARRAY_BOOL", WHC_TYPE_BOOL | WHC_TYPE_ARRAY_MASK},
  {"WHC_TYPE_ARRAY_CHAR", WHC_TYPE_CHAR | WHC_TYPE_ARRAY_MASK},
  {"WHC_TYPE_ARRAY_DATE", WHC_TYPE_DATE | WHC_TYPE_ARRAY_MASK},
  {"WHC_TYPE_ARRAY_DATETIME", WHC_TYPE_DATETIME | WHC_TYPE_ARRAY_MASK},
  {"WHC_TYPE_ARRAY_HIRESTIME", WHC_TYPE_HIRESTIME | WHC_TYPE_ARRAY_MASK},
  {"WHC_TYPE_ARRAY_INT8", WHC_TYPE_INT8 | WHC_TYPE_ARRAY_MASK},
  {"WHC_TYPE_ARRAY_INT16", WHC_TYPE_INT16 | WHC_TYPE_ARRAY_MASK},
  {"WHC_TYPE_ARRAY_INT32", WHC_TYPE_INT32 | WHC_TYPE_ARRAY_MASK},
  {"WHC_TYPE_ARRAY_INT64", WHC_TYPE_INT64 | WHC_TYPE_ARRAY_MASK},
  {"WHC_TYPE_ARRAY_UINT8", WHC_TYPE_UINT8 | WHC_TYPE_ARRAY_MASK},
  {"WHC_TYPE_ARRAY_UINT16", WHC_TYPE_UINT16 | WHC_TYPE_ARRAY_MASK},
  {"WHC_TYPE_ARRAY_UINT32", WHC_TYPE_UINT32 | WHC_TYPE_ARRAY_MASK},
  {"WHC_TYPE_ARRAY_UINT64", WHC_TYPE_UINT64 | WHC_TYPE_ARRAY_MASK},
  {"WHC_TYPE_ARRAY_REAL", WHC_TYPE_REAL | WHC_TYPE_ARRAY_MASK},
  {"WHC_TYPE_ARRAY_RICHREAL", WHC_TYPE_RICHREAL| WHC_TYPE_ARRAY_MASK}
};

static const uint_t _valuesCount = sizeof(_values) / sizeof(_values[0]);
static const uint_t _fieldsCount = sizeof(_fields) / sizeof(_fields[0]);

static const char*
get_table_field_name(const uint_t fieldType)
{
  for (uint_t i = 0; i < _fieldsCount; ++i)
    {
      if ((fieldType | WHC_TYPE_ARRAY_MASK) == _fields[i].type)
        return _fields[i].name;
    }

  return nullptr;
}


static bool
check_table_description(WH_CONNECTION hnd)
{
  uint_t type, fcount;

  const char* fieldName = nullptr;
  uint_t        fieldType = 0;

  if ((WDescribeStackTop(hnd, &type) != WCS_OK)
      || (type != WHC_TYPE_TABLE_MASK)
      || (WValueFieldsCount(hnd, &fcount) != WCS_OK)
      || (fcount != _fieldsCount))
    {
      return false;
    }

  for (uint_t i = 0; i < _fieldsCount; ++i)
    {

      if (WValueFetchField(hnd, &fieldName, &fieldType) != WCS_OK)
        return false;

      if (strcmp(fieldName, get_table_field_name( fieldType)) != 0)
        return false;
    }

  if ((WValueFetchField(hnd, &fieldName, &fieldType) != WCS_OK)
      || (fieldName != nullptr)
      || (fieldType != WHC_TYPE_NOTSET))
    {
      return false;
    }

  return true;
}


static bool
check_table_value(WH_CONNECTION      hnd,
                   const uint_t         index,
                   const bool           extraCheck)
{
  const char* const fieldName = get_table_field_name(_values[index].type);
  const char*       tabVal    = nullptr;
  const uint64_t      row       = index / _fieldsCount;

  unsigned long long  elCount;

  if (extraCheck)
    {
      if (WValueEntry(hnd,
                       "some_field_name",
                       row,
                       WIGNORE_OFF,
                       WIGNORE_OFF,
                       &tabVal) != WCS_INVALID_FIELD)
      {
        return false;
      }

      if (WValueEntry(hnd,
                       fieldName,
                       98012, //Some big row number
                       WIGNORE_OFF,
                       WIGNORE_OFF,
                       &tabVal) != WCS_INVALID_ROW)
      {
        return false;
      }

      if (WValueEntry(hnd,
                       fieldName,
                       row,
                       WIGNORE_OFF,
                       WIGNORE_OFF,
                       &tabVal) != WCS_INVALID_ARRAY_OFF)
        {
          return false;
        }

      if (WValueEntry(hnd,
                       fieldName,
                       row,
                       MAX_VALUES_ENTRIES + index,
                       WIGNORE_OFF,
                       &tabVal) != WCS_INVALID_ARRAY_OFF)
        {
          return false;
        }

      if (WValueEntry(hnd,
                       fieldName,
                       row,
                       0,
                       0,
                       &tabVal) != WCS_TYPE_MISMATCH)
        {
          return false;
        }

      if (WValueArraySize(hnd,
                           "some_field",
                           WIGNORE_ROW,
                           &elCount) != WCS_INVALID_FIELD)
        {
          return false;
        }

      if (WValueArraySize(hnd,
                           fieldName,
                           WIGNORE_ROW,
                           &elCount) != WCS_INVALID_ROW)
        {
          return false;
        }


      if (WValueTextLength(hnd,
                            fieldName,
                            0,
                            0,
                            &elCount) != WCS_TYPE_MISMATCH)
        {
          return false;
        }
    }



  if ((WValueArraySize(hnd,
                        fieldName,
                        row,
                        &elCount) != WCS_OK)
      || (elCount != _values[index].elementsCount))
    {
      return false;
    }

  for (uint_t i = 0; i < elCount; ++i)
    {
      if (WValueEntry(hnd,
                       fieldName,
                       row,
                       i,
                       WIGNORE_OFF,
                       &tabVal) != WCS_OK)
        {
          return false;
        }

      if (strcmp(tabVal, _values[index].values[i]) != 0)
        return false;
    }

  return true;
}


static bool
fill_table_with_values(WH_CONNECTION hnd,
                        const bool      bulk)
{
  if (WPushValue(hnd, WHC_TYPE_TABLE_MASK, _fieldsCount, _fields) != WCS_OK)
    return false;

  if ( ! bulk && (WFlush(hnd) != WCS_OK))
    return false;

  for (uint_t i = 0; i < _valuesCount; ++i)
    {
      for (uint_t j = 0; j < _values[i].elementsCount; ++j)
        {
          if (WUpdateValue(hnd,
                            _values[i].type,
                            get_table_field_name(_values[i].type),
                            i / _fieldsCount,
                            j,
                            WIGNORE_OFF,
                            _values[i].values[j]) != WCS_OK)
            {
              goto fill_table_fail;
            }

          if ( ! bulk && (WFlush(hnd) != WCS_OK))
            goto fill_table_fail;
        }
    }

  if (WFlush(hnd) != WCS_OK)
    return false;

  return check_table_description(hnd);

fill_table_fail:
  return false;
}

static bool
test_step_table_fill(WH_CONNECTION hnd)
{
  cout << "Testing filling a table with basic values(stepping mode)... ";

  if (! fill_table_with_values(hnd, false))
    goto test_step_table_fill_error;


  for (uint_t i = 0; i < _valuesCount; ++i)
    {
      if (! check_table_value(hnd, i, true))
        goto test_step_table_fill_error;
    }

  if ((WPopValues(hnd, WPOP_ALL) != WCS_OK)
      || (WFlush(hnd) !=WCS_OK))
    {
      goto test_step_table_fill_error;
    }

  cout << "OK\n";
  return true;

test_step_table_fill_error:

  cout << "FAIL\n";
  return false;
}


static bool
test_bulk_table_fill(WH_CONNECTION hnd)
{
  cout << "Testing filling a table with basic values(bulk mode)... ";

  if (! fill_table_with_values(hnd, true))
    goto test_bulk_table_fill_error;

  for (uint_t i = 0; i < _valuesCount; ++i)
    {
      if (! check_table_value(hnd, i, false))
        goto test_bulk_table_fill_error;
    }

  if ((WPopValues(hnd, WPOP_ALL) != WCS_OK)
      || (WFlush(hnd) !=WCS_OK))
    {
      goto test_bulk_table_fill_error;
    }

  cout << "OK\n";
  return true;

test_bulk_table_fill_error:

  cout << "FAIL\n";
  return false;
}



static bool
test_for_errors(WH_CONNECTION hnd)
{
  unsigned long long count;

  cout << "Testing against error conditions ... ";

  if ((WPushValue(hnd, WHC_TYPE_TABLE_MASK, _fieldsCount, _fields) != WCS_OK)
      || (WFlush(hnd) != WCS_OK)
      || (WFlush(hnd) != WCS_OK) //Just for fun!
      || (WValueRowsCount(nullptr, nullptr) != WCS_INVALID_ARGS)
      || (WValueRowsCount(nullptr, &count) != WCS_INVALID_ARGS)
      || (WValueRowsCount(hnd, nullptr) != WCS_INVALID_ARGS)
      || (WValueRowsCount(hnd, &count) != WCS_OK)
      || (count != 0)
      || (WValueArraySize(hnd, WIGNORE_FIELD, WIGNORE_ROW, &count) != WCS_INVALID_FIELD)
      || (WValueArraySize(hnd, "some_f", WIGNORE_ROW, &count) != WCS_INVALID_FIELD)
      || (WValueTextLength(hnd, WIGNORE_FIELD, WIGNORE_ROW, WIGNORE_OFF, &count) != WCS_INVALID_FIELD)
      || (WValueTextLength(hnd, "some_f", WIGNORE_ROW, WIGNORE_OFF, &count) != WCS_INVALID_FIELD)
      || (WPopValues(hnd, WPOP_ALL) != WCS_OK)
      || (WFlush(hnd) != WCS_OK))
    {
      goto test_for_errors_fail;
    }

  cout << "OK\n";
  return true;

test_for_errors_fail :
  cout << "FAIL\n";
  return false;
}

const char*
DefaultDatabaseName()
{
  return "test_list_db";
}

const uint_t
DefaultUserId()
{
  return 1;
}

const char*
DefaultUserPassword()
{
  return "test_password";
}

int
main(int argc, const char** argv)
{
  WH_CONNECTION hnd        = nullptr;

  bool success = tc_settup_connection(argc, argv, &hnd);

  success = success && test_for_errors(hnd);
  success = success && test_step_table_fill(hnd);
  success = success && test_bulk_table_fill(hnd);

  WClose(hnd);

  if (!success)
    {
      cout << "TEST RESULT: FAIL" << std::endl;
      return 1;
    }

  cout << "TEST RESULT: PASS" << std::endl;

  return 0;
}


