#include <iostream>
#include <cstring>

#include "test_client_common.h"
#include "utils/wtypes.h"

using namespace std;

static string sDbName;

static const bool check_type(const WH_CONNECTION hnd, const string& glbName, const string& glbType)
{
  uint_t type;
  if (WDescribeGlobal(hnd, glbName.c_str(), &type) != WCS_OK)
  {
    cout << "Failed to describe global " << glbName << "\n.";
    return false;
  }

  if (type != T_TABLE_MASK)
    return glbType == decode_typeinfo(type);

  //Count the ',' and '(' to get the number of table fields.
  uint_t fieldsCount = 0;
  for (size_t i = 0; i < glbType.size(); ++i)
  {
    if ((glbType[i] == ',') || (glbType[i] == '('))
      ++fieldsCount;
  }

  uint_t temp;
  if (WValueFieldsCount(hnd, &temp) != WCS_OK)
  {
    cout << "Failed to retrieve the fields count.\n";
    return false;
  }
  else if (temp != fieldsCount)
  {
    cout << "Fields count mismatch.\n";
    return false;
  }
  else if (fieldsCount == 0)
    return glbType == string("TABLE");

  vector<size_t> offsets;
  while (temp < 900000)
  {
    const char* fieldName;
    uint_t fieldType;

    if (WValueFetchField(hnd, &fieldName, &fieldType) != WCS_OK)
    {
      cout << "Failed to retrieve field type.\n";
      return false;
    }

    if (fieldName == nullptr)
    {
      for (int dummy = 0; dummy < 1024; ++dummy)
      {
        if (WValueFetchField(hnd, &fieldName, &type) != WCS_OK)
        {
          cout << "Error encountered during the field fetch end condition.\n";
          return false;
        }
        else if (fieldName != nullptr)
        {
          cout << "Invalid field fetch end condition ...\n";
          return false;
        }
      }
      break;
    }

    const string fieldText = string(fieldName) + " " + decode_typeinfo(fieldType);
    const size_t offset = glbType.find(fieldText);

    if (offset == string::npos)
    {
      cout << "Cannot find '" << fieldText << "' field description.\n";
      return false;
    }
    else
    {
      for (temp = 0; temp < offsets.size(); temp++)
      {
        if (offset == offsets[temp])
        {
          cout << "Retrieved the same a field declaration twice.\n";
          return false;
        }
      }

      offsets.push_back(offset);
    }
  }

  if (fieldsCount != offsets.size())
  {
    cout << "Found fields count does not match.\n";
    return false;
  }

  return true;
}


static bool
test_global_variables(WH_CONNECTION hnd, vector<string> glbNames, vector<string> glbTypes)
{
  uint_t glbsCount = 0;
  if ((WStartGlobalsList(hnd, &glbsCount) != WCS_OK)
      || (glbsCount != glbNames.size()))
  {
    cout << "Globals count mismatch: " << glbsCount << " vs. " << glbNames.size() << endl;
    return false;
  }
  vector<bool> foundGlbs(glbsCount, false);

  const char* name = nullptr;
  uint_t i = 0;
  while (i < 9999999)
  {
    if (WFetchGlobal(hnd, &name) != WCS_OK)
    {
      cout << "Failed to fetch " << i + 1 << "(th) global.\n";
      return false;
    }

    if (name == nullptr)
      break;

    size_t index;
    for (index = 0; index < glbNames.size(); ++index)
    {
      if (glbNames[index] == string(name))
        break;
    }

    if (index >= glbNames.size())
    {
      cout << "Found global '" << name << "' that we don't know it.\n";
      return false;
    }

    if (foundGlbs[i])
    {
      cout << "Global '" << name << "' was already retrieved.";
      return false;
    }
    else
      foundGlbs[i] = true;

    ++i;
  }

  for (int dummy = 0; dummy < 1024; ++dummy)
  {
    if (WFetchGlobal(hnd, &name) != WCS_OK)
    {
      cout << "Error encountered during global fetch end condition.\n";
      return false;
    }
    else if (name != nullptr)
    {
      cout << "Invalid global name end condition ...\n";
      return false;
    }
  }

  cout << "Fetched " << i << " global(s).\n";
  if (i != glbsCount)
  {
    cout << "Those globals were less than " << glbsCount << ".\n";
    return false;
  }

  for (i = 0; i < glbsCount; ++i)
  {
    if ( !check_type(hnd, glbNames[i], glbTypes[i]))
    {
      cout << "Type mismatch at variable " << i << ".\n";
      return false;
    }
  }

  return true;
}


const char*
DefaultDatabaseName()
{
  return sDbName.c_str();
}


const uint_t
DefaultUserId()
{
  return 0;
}


const char*
DefaultUserPassword()
{
  return "root_test_password";
}


static void
setup_database(const string& db, vector<string>& glbNames, vector<string>& glbTypes)
{
  cout << "\n\n Setting up for database " << db << ".\n";
  sDbName = db;

  glbNames.clear();
  glbTypes.clear();

  if (sDbName == "administrator")
    {
      glbNames.push_back("users");
      glbTypes.push_back("TABLE(password TEXT, username TEXT)");
    }
  else if (sDbName == "test_list_db_frame_size")
    {
      glbNames.push_back("var_0_0");
      glbNames.push_back("var_1_01");
      glbNames.push_back("var_2_012");
      glbNames.push_back("var_3_0123");
      glbNames.push_back("var_4_01234");
      glbNames.push_back("var_5_012345");
      glbNames.push_back("var_6_0123456");
      glbNames.push_back("var_7_01234567");
      glbNames.push_back("var_8_012345678");
      glbNames.push_back("var_9_0123456789");
      glbNames.push_back("var_10_0");
      glbNames.push_back("var_11_01");
      glbNames.push_back("var_12_012");
      glbNames.push_back("var_13_0123");
      glbNames.push_back("var_14_01234");
      glbNames.push_back("var_15_012345");
      glbNames.push_back("var_16_0123456");
      glbNames.push_back("var_17_01234567");
      glbNames.push_back("var_18_012345678");
      glbNames.push_back("var_19_0123456789");
      glbNames.push_back("var_20_0");
      glbNames.push_back("var_21_01");
      glbNames.push_back("var_22_012");
      glbNames.push_back("var_23_0123");
      glbNames.push_back("var_24_01234");
      glbNames.push_back("var_25_012345");
      glbNames.push_back("var_26_0123456");
      glbNames.push_back("var_27_01234567");
      glbNames.push_back("var_28_012345678");
      glbNames.push_back("var_29_0123456789");
      glbNames.push_back("var_30_0");
      glbNames.push_back("var_31_01");
      glbNames.push_back("var_32_012");
      glbNames.push_back("var_33_0123");
      glbNames.push_back("var_34_01234");
      glbNames.push_back("var_35_012345");
      glbNames.push_back("var_36_0123456");
      glbNames.push_back("var_37_01234567");
      glbNames.push_back("var_38_012345678");
      glbNames.push_back("var_39_0123456789");
      glbNames.push_back("var_40_0");
      glbNames.push_back("var_41_01");
      glbNames.push_back("var_42_012");
      glbNames.push_back("var_43_0123");
      glbNames.push_back("var_44_01234");
      glbNames.push_back("var_45_012345");
      glbNames.push_back("var_46_0123456");
      glbNames.push_back("var_47_01234567");
      glbNames.push_back("var_48_012345678");
      glbNames.push_back("var_49_0123456789");
      glbNames.push_back("var_50_0");
      glbNames.push_back("var_51_01");
      glbNames.push_back("var_52_012");
      glbNames.push_back("var_53_0123");
      glbNames.push_back("var_54_01234");
      glbNames.push_back("var_55_012345");
      glbNames.push_back("var_56_0123456");
      glbNames.push_back("var_57_01234567");
      glbNames.push_back("var_58_012345678");
      glbNames.push_back("var_59_0123456789");
      glbNames.push_back("var_60_0");
      glbNames.push_back("var_61_01");
      glbNames.push_back("var_62_012");
      glbNames.push_back("var_63_0123");
      glbNames.push_back("var_64_01234");
      glbNames.push_back("var_65_012345");
      glbNames.push_back("var_66_0123456");
      glbNames.push_back("var_67_01234567");
      glbNames.push_back("var_68_012345678");
      glbNames.push_back("var_69_0123456789");
      glbNames.push_back("var_70_0");
      glbNames.push_back("var_71_01");
      glbNames.push_back("var_72_012");
      glbNames.push_back("var_73_0123");
      glbNames.push_back("var_74_01234");
      glbNames.push_back("var_75_012345");
      glbNames.push_back("var_76_0123456");
      glbNames.push_back("var_77_01234567");
      glbNames.push_back("var_78_012345678");
      glbNames.push_back("var_79_0123456789");
      glbNames.push_back("var_80_0");
      glbNames.push_back("var_81_01");
      glbNames.push_back("var_82_012");
      glbNames.push_back("var_83_0123");
      glbNames.push_back("var_84_01234");
      glbNames.push_back("var_85_012345");
      glbNames.push_back("var_86_0123456");
      glbNames.push_back("var_87_01234567");
      glbNames.push_back("var_88_012345678");
      glbNames.push_back("var_89_0123456789");
      glbNames.push_back("var_90_0");
      glbNames.push_back("var_91_01");
      glbNames.push_back("var_92_012");
      glbNames.push_back("var_93_0123");
      glbNames.push_back("var_94_01234");
      glbNames.push_back("var_95_012345");
      glbNames.push_back("var_96_0123456");
      glbNames.push_back("var_97_01234567");
      glbNames.push_back("var_98_012345678");
      glbNames.push_back("var_99_0123456789");
      glbNames.push_back("a");
      glbNames.push_back("xa");
      glbNames.push_back("var_102_012");
      glbNames.push_back("var_103_0123");
      glbNames.push_back("var_104_01234");
      glbNames.push_back("var_105_012345");
      glbNames.push_back("var_106_0123456");
      glbNames.push_back("var_107_01234567");
      glbNames.push_back("var_108_012345678");
      glbNames.push_back("var_109_0123456789");
      glbNames.push_back("var_110_0");
      glbNames.push_back("var_111_01");
      glbNames.push_back("var_112_012");
      glbNames.push_back("var_113_0123");
      glbNames.push_back("var_114_01234");
      glbNames.push_back("var_115_012345");
      glbNames.push_back("var_116_0123456");
      glbNames.push_back("var_117_01234567");
      glbNames.push_back("var_118_012345678");
      glbNames.push_back("var_119_0123456789");
      glbNames.push_back("var_120_0");
      glbNames.push_back("var_121_01");
      glbNames.push_back("var_122_012");
      glbNames.push_back("var_123_0123");
      glbNames.push_back("var_124_01234");
      glbNames.push_back("var_125_012345");
      glbNames.push_back("var_126_0123456");
      glbNames.push_back("var_127_01234567");
      glbNames.push_back("var_128_012345678");
      glbNames.push_back("var_129_0123456789");
      glbNames.push_back("var_130_0");
      glbNames.push_back("var_131_01");
      glbNames.push_back("var_132_012");
      glbNames.push_back("var_133_0123");
      glbNames.push_back("var_134_01234");
      glbNames.push_back("var_135_012345");
      glbNames.push_back("var_136_0123456");
      glbNames.push_back("var_137_01234567");
      glbNames.push_back("var_138_012345678");
      glbNames.push_back("var_139_0123456789");
      glbNames.push_back("var_140_0");
      glbNames.push_back("var_141_01");
      glbNames.push_back("var_142_012");
      glbNames.push_back("var_143_0123");
      glbNames.push_back("var_144_01234");
      glbNames.push_back("var_145_012345");
      glbNames.push_back("var_146_0123456");
      glbNames.push_back("var_147_01234567");
      glbNames.push_back("var_148_012345678");
      glbNames.push_back("var_149_0123456789");
      glbNames.push_back("var_150_0");
      glbNames.push_back("var_151_01");
      glbNames.push_back("var_152_012");
      glbNames.push_back("var_153_0123");
      glbNames.push_back("var_154_01234");
      glbNames.push_back("var_155_012345");
      glbNames.push_back("var_156_0123456");
      glbNames.push_back("var_157_01234567");
      glbNames.push_back("var_158_012345678");
      glbNames.push_back("var_159_0123456789");
      glbNames.push_back("var_160_0");
      glbNames.push_back("var_161_01");
      glbNames.push_back("var_162_012");
      glbNames.push_back("var_163_0123");
      glbNames.push_back("var_164_01234");
      glbNames.push_back("var_165_012345");
      glbNames.push_back("var_166_0123456");
      glbNames.push_back("var_167_01234567");
      glbNames.push_back("var_168_012345678");
      glbNames.push_back("var_169_0123456789");
      glbNames.push_back("var_170_0");
      glbNames.push_back("var_171_01");
      glbNames.push_back("var_172_012");
      glbNames.push_back("var_173_0123");
      glbNames.push_back("var_174_01234");
      glbNames.push_back("var_175_012345");
      glbNames.push_back("var_176_0123456");
      glbNames.push_back("var_177_01234567");
      glbNames.push_back("var_178_012345678");
      glbNames.push_back("var_179_0123456789");
      glbNames.push_back("var_180_0");
      glbNames.push_back("var_181_01");
      glbNames.push_back("var_182_012");
      glbNames.push_back("var_183_0123");
      glbNames.push_back("var_184_01234");
      glbNames.push_back("var_185_012345");
      glbNames.push_back("var_186_0123456");
      glbNames.push_back("var_187_01234567");
      glbNames.push_back("var_188_012345678");
      glbNames.push_back("var_189_0123456789");
      glbNames.push_back("var_190_0");
      glbNames.push_back("var_191_01");
      glbNames.push_back("var_192_012");
      glbNames.push_back("var_193_0123");
      glbNames.push_back("var_194_01234");
      glbNames.push_back("var_195_012345");
      glbNames.push_back("var_196_0123456");
      glbNames.push_back("var_197_01234567");
      glbNames.push_back("var_198_012345678");
      glbNames.push_back("var_199_0123456789");
      glbNames.push_back("b");
      glbNames.push_back("xb");
      glbNames.push_back("var_202_012");
      glbNames.push_back("var_203_0123");
      glbNames.push_back("var_204_01234");
      glbNames.push_back("var_205_012345");
      glbNames.push_back("var_206_0123456");
      glbNames.push_back("var_207_01234567");
      glbNames.push_back("var_208_012345678");
      glbNames.push_back("var_209_0123456789");
      glbNames.push_back("var_210_0");
      glbNames.push_back("var_211_01");
      glbNames.push_back("var_212_012");
      glbNames.push_back("var_213_0123");
      glbNames.push_back("var_214_01234");
      glbNames.push_back("var_215_012345");
      glbNames.push_back("var_216_0123456");
      glbNames.push_back("var_217_01234567");
      glbNames.push_back("var_218_012345678");
      glbNames.push_back("var_219_0123456789");
      glbNames.push_back("var_220_0");
      glbNames.push_back("var_221_01");
      glbNames.push_back("var_222_012");
      glbNames.push_back("var_223_0123");
      glbNames.push_back("var_224_01234");
      glbNames.push_back("var_225_012345");
      glbNames.push_back("var_226_0123456");
      glbNames.push_back("var_227_01234567");
      glbNames.push_back("var_228_012345678");
      glbNames.push_back("var_229_0123456789");
      glbNames.push_back("var_230_0");
      glbNames.push_back("var_231_01");
      glbNames.push_back("var_232_012");
      glbNames.push_back("var_233_0123");
      glbNames.push_back("var_234_01234");
      glbNames.push_back("var_235_012345");
      glbNames.push_back("var_236_0123456");
      glbNames.push_back("var_237_01234567");
      glbNames.push_back("var_238_012345678");
      glbNames.push_back("var_239_0123456789");
      glbNames.push_back("var_240_0");
      glbNames.push_back("var_241_01");
      glbNames.push_back("var_242_012");
      glbNames.push_back("var_243_0123");
      glbNames.push_back("var_244_01234");
      glbNames.push_back("var_245_012345");
      glbNames.push_back("var_246_0123456");
      glbNames.push_back("var_247_01234567");
      glbNames.push_back("var_248_012345678");
      glbNames.push_back("var_249_0123456789");
      glbNames.push_back("var_250_0");
      glbNames.push_back("var_251_01");
      glbNames.push_back("var_252_012");
      glbNames.push_back("var_253_0123");
      glbNames.push_back("var_254_01234");
      glbNames.push_back("var_255_012345");
      glbNames.push_back("var_256_0123456");
      glbNames.push_back("var_257_01234567");
      glbNames.push_back("var_258_012345678");
      glbNames.push_back("var_259_0123456789");
      glbNames.push_back("var_260_0");
      glbNames.push_back("var_261_01");
      glbNames.push_back("var_262_012");
      glbNames.push_back("var_263_0123");
      glbNames.push_back("var_264_01234");
      glbNames.push_back("var_265_012345");
      glbNames.push_back("var_266_0123456");
      glbNames.push_back("var_267_01234567");
      glbNames.push_back("var_268_012345678");
      glbNames.push_back("var_269_0123456789");
      glbNames.push_back("var_270_0");
      glbNames.push_back("var_271_01");
      glbNames.push_back("var_272_012");
      glbNames.push_back("var_273_0123");
      glbNames.push_back("var_274_01234");
      glbNames.push_back("var_275_012345");
      glbNames.push_back("var_276_0123456");
      glbNames.push_back("var_277_01234567");
      glbNames.push_back("var_278_012345678");
      glbNames.push_back("var_279_0123456789");
      glbNames.push_back("var_280_0");
      glbNames.push_back("var_281_01");
      glbNames.push_back("var_282_012");
      glbNames.push_back("var_283_0123");
      glbNames.push_back("var_284_01234");
      glbNames.push_back("var_285_012345");
      glbNames.push_back("var_286_0123456");
      glbNames.push_back("var_287_01234567");
      glbNames.push_back("var_288_012345678");
      glbNames.push_back("var_289_0123456789");
      glbNames.push_back("var_290_0");
      glbNames.push_back("var_291_01");
      glbNames.push_back("var_292_012");
      glbNames.push_back("var_293_0123");
      glbNames.push_back("var_294_01234");
      glbNames.push_back("var_295_012345");
      glbNames.push_back("var_296_0123456");
      glbNames.push_back("var_297_01234567");
      glbNames.push_back("var_298_012345678");
      glbNames.push_back("var_299_0123456789");
      glbNames.push_back("c");
      glbNames.push_back("xc");
      glbNames.push_back("var_302_012");
      glbNames.push_back("var_303_0123");
      glbNames.push_back("var_304_01234");
      glbNames.push_back("var_305_012345");
      glbNames.push_back("var_306_0123456");
      glbNames.push_back("var_307_01234567");
      glbNames.push_back("var_308_012345678");
      glbNames.push_back("var_309_0123456789");
      glbNames.push_back("var_310_0");
      glbNames.push_back("var_311_01");
      glbNames.push_back("var_312_012");
      glbNames.push_back("var_313_0123");
      glbNames.push_back("var_314_01234");
      glbNames.push_back("var_315_012345");
      glbNames.push_back("var_316_0123456");
      glbNames.push_back("var_317_01234567");
      glbNames.push_back("var_318_012345678");
      glbNames.push_back("var_319_0123456789");
      glbNames.push_back("var_320_0");
      glbNames.push_back("var_321_01");
      glbNames.push_back("var_322_012");
      glbNames.push_back("var_323_0123");
      glbNames.push_back("var_324_01234");
      glbNames.push_back("var_325_012345");
      glbNames.push_back("var_326_0123456");
      glbNames.push_back("var_327_01234567");
      glbNames.push_back("var_328_012345678");
      glbNames.push_back("var_329_0123456789");
      glbNames.push_back("var_330_0");
      glbNames.push_back("var_331_01");
      glbNames.push_back("var_332_012");
      glbNames.push_back("var_333_0123");
      glbNames.push_back("var_334_01234");
      glbNames.push_back("var_335_012345");
      glbNames.push_back("var_336_0123456");
      glbNames.push_back("var_337_01234567");
      glbNames.push_back("var_338_012345678");
      glbNames.push_back("var_339_0123456789");
      glbNames.push_back("var_340_0");
      glbNames.push_back("var_341_01");
      glbNames.push_back("var_342_012");
      glbNames.push_back("var_343_0123");
      glbNames.push_back("var_344_01234");
      glbNames.push_back("var_345_012345");
      glbNames.push_back("var_346_0123456");
      glbNames.push_back("var_347_01234567");
      glbNames.push_back("var_348_012345678");
      glbNames.push_back("var_349_0123456789");
      glbNames.push_back("var_350_0");
      glbNames.push_back("var_351_01");
      glbNames.push_back("var_352_012");
      glbNames.push_back("var_353_0123");
      glbNames.push_back("var_354_01234");
      glbNames.push_back("var_355_012345");
      glbNames.push_back("var_356_0123456");
      glbNames.push_back("var_357_01234567");
      glbNames.push_back("var_358_012345678");
      glbNames.push_back("var_359_0123456789");
      glbNames.push_back("var_360_0");
      glbNames.push_back("var_361_01");
      glbNames.push_back("var_362_012");
      glbNames.push_back("var_363_0123");
      glbNames.push_back("var_364_01234");
      glbNames.push_back("var_365_012345");
      glbNames.push_back("var_366_0123456");
      glbNames.push_back("var_367_01234567");
      glbNames.push_back("var_368_012345678");
      glbNames.push_back("var_369_0123456789");
      glbNames.push_back("var_370_0");
      glbNames.push_back("var_371_01");
      glbNames.push_back("var_372_012");
      glbNames.push_back("var_373_0123");
      glbNames.push_back("var_374_01234");
      glbNames.push_back("var_375_012345");
      glbNames.push_back("var_376_0123456");
      glbNames.push_back("var_377_01234567");
      glbNames.push_back("var_378_012345678");
      glbNames.push_back("var_379_0123456789");
      glbNames.push_back("var_380_0");
      glbNames.push_back("var_381_01");
      glbNames.push_back("var_382_012");
      glbNames.push_back("var_383_0123");
      glbNames.push_back("var_384_01234");
      glbNames.push_back("var_385_012345");
      glbNames.push_back("var_386_0123456");
      glbNames.push_back("var_387_01234567");
      glbNames.push_back("var_388_012345678");
      glbNames.push_back("var_389_0123456789");
      glbNames.push_back("var_390_0");
      glbNames.push_back("var_391_01");
      glbNames.push_back("var_392_012");
      glbNames.push_back("var_393_0123");
      glbNames.push_back("var_394_01234");
      glbNames.push_back("var_395_012345");
      glbNames.push_back("var_396_0123456");
      glbNames.push_back("var_397_01234567");
      glbNames.push_back("var_398_012345678");
      glbNames.push_back("var_399_0123456789");
      glbNames.push_back("d");
      glbNames.push_back("xd");
      glbNames.push_back("var_402_012");
      glbNames.push_back("var_403_0123");
      glbNames.push_back("var_404_01234");
      glbNames.push_back("var_405_012345");
      glbNames.push_back("var_406_0123456");
      glbNames.push_back("var_407_01234567");
      glbNames.push_back("var_408_012345678");
      glbNames.push_back("var_409_0123456789");
      glbNames.push_back("var_410_0");
      glbNames.push_back("var_411_01");
      glbNames.push_back("var_412_012");
      glbNames.push_back("var_413_0123");
      glbNames.push_back("var_414_01234");
      glbNames.push_back("var_415_012345");
      glbNames.push_back("var_416_0123456");
      glbNames.push_back("var_417_01234567");
      glbNames.push_back("var_418_012345678");
      glbNames.push_back("var_419_0123456789");
      glbNames.push_back("var_420_0");
      glbNames.push_back("var_421_01");
      glbNames.push_back("var_422_012");
      glbNames.push_back("var_423_0123");
      glbNames.push_back("var_424_01234");
      glbNames.push_back("var_425_012345");
      glbNames.push_back("var_426_0123456");
      glbNames.push_back("var_427_01234567");
      glbNames.push_back("var_428_012345678");
      glbNames.push_back("var_429_0123456789");
      glbNames.push_back("var_430_0");
      glbNames.push_back("var_431_01");
      glbNames.push_back("var_432_012");
      glbNames.push_back("var_433_0123");
      glbNames.push_back("var_434_01234");
      glbNames.push_back("var_435_012345");
      glbNames.push_back("var_436_0123456");
      glbNames.push_back("var_437_01234567");
      glbNames.push_back("var_438_012345678");
      glbNames.push_back("var_439_0123456789");
      glbNames.push_back("var_440_0");
      glbNames.push_back("var_441_01");
      glbNames.push_back("var_442_012");
      glbNames.push_back("var_443_0123");
      glbNames.push_back("var_444_01234");
      glbNames.push_back("var_445_012345");
      glbNames.push_back("var_446_0123456");
      glbNames.push_back("var_447_01234567");
      glbNames.push_back("var_448_012345678");
      glbNames.push_back("var_449_0123456789");
      glbNames.push_back("var_450_0");
      glbNames.push_back("var_451_01");
      glbNames.push_back("var_452_012");
      glbNames.push_back("var_453_0123");
      glbNames.push_back("var_454_01234");
      glbNames.push_back("var_455_012345");
      glbNames.push_back("var_456_0123456");
      glbNames.push_back("var_457_01234567");
      glbNames.push_back("var_458_012345678");
      glbNames.push_back("var_459_0123456789");
      glbNames.push_back("var_460_0");
      glbNames.push_back("var_461_01");
      glbNames.push_back("var_462_012");
      glbNames.push_back("var_463_0123");
      glbNames.push_back("var_464_01234");
      glbNames.push_back("var_465_012345");
      glbNames.push_back("var_466_0123456");
      glbNames.push_back("var_467_01234567");
      glbNames.push_back("var_468_012345678");
      glbNames.push_back("var_469_0123456789");
      glbNames.push_back("var_470_0");
      glbNames.push_back("var_471_01");
      glbNames.push_back("var_472_012");
      glbNames.push_back("var_473_0123");
      glbNames.push_back("var_474_01234");
      glbNames.push_back("var_475_012345");
      glbNames.push_back("var_476_0123456");
      glbNames.push_back("var_477_01234567");
      glbNames.push_back("var_478_012345678");
      glbNames.push_back("var_479_0123456789");
      glbNames.push_back("var_480_0");
      glbNames.push_back("var_481_01");
      glbNames.push_back("var_482_012");
      glbNames.push_back("var_483_0123");
      glbNames.push_back("var_484_01234");
      glbNames.push_back("var_485_012345");
      glbNames.push_back("var_486_0123456");
      glbNames.push_back("var_487_01234567");
      glbNames.push_back("var_488_012345678");
      glbNames.push_back("var_489_0123456789");
      glbNames.push_back("var_490_0");
      glbNames.push_back("var_491_01");
      glbNames.push_back("var_492_012");
      glbNames.push_back("var_493_0123");
      glbNames.push_back("var_494_01234");
      glbNames.push_back("var_495_012345");
      glbNames.push_back("var_496_0123456");
      glbNames.push_back("var_497_01234567");
      glbNames.push_back("var_498_012345678");
      glbNames.push_back("var_499_0123456789");
      glbNames.push_back("e");
      glbNames.push_back("xe");
      glbNames.push_back("var_502_012");
      glbNames.push_back("var_503_0123");
      glbNames.push_back("var_504_01234");
      glbNames.push_back("var_505_012345");
      glbNames.push_back("var_506_0123456");
      glbNames.push_back("var_507_01234567");
      glbNames.push_back("var_508_012345678");
      glbNames.push_back("var_509_0123456789");
      glbNames.push_back("var_510_0");
      glbNames.push_back("var_511_01");
      glbNames.push_back("var_512_012");
      glbNames.push_back("var_513_0123");
      glbNames.push_back("var_514_01234");
      glbNames.push_back("var_515_012345");
      glbNames.push_back("var_516_0123456");
      glbNames.push_back("var_517_01234567");
      glbNames.push_back("var_518_012345678");
      glbNames.push_back("var_519_0123456789");
      glbNames.push_back("var_520_0");
      glbNames.push_back("var_521_01");
      glbNames.push_back("var_522_012");
      glbNames.push_back("var_523_0123");
      glbNames.push_back("var_524_01234");
      glbNames.push_back("var_525_012345");
      glbNames.push_back("var_526_0123456");
      glbNames.push_back("var_527_01234567");
      glbNames.push_back("var_528_012345678");
      glbNames.push_back("var_529_0123456789");
      glbNames.push_back("var_530_0");
      glbNames.push_back("var_531_01");
      glbNames.push_back("var_532_012");
      glbNames.push_back("var_533_0123");
      glbNames.push_back("var_534_01234");
      glbNames.push_back("var_535_012345");
      glbNames.push_back("var_536_0123456");
      glbNames.push_back("var_537_01234567");
      glbNames.push_back("var_538_012345678");
      glbNames.push_back("var_539_0123456789");
      glbNames.push_back("var_540_0");
      glbNames.push_back("var_541_01");
      glbNames.push_back("var_542_012");
      glbNames.push_back("var_543_0123");
      glbNames.push_back("var_544_01234");
      glbNames.push_back("var_545_012345");
      glbNames.push_back("var_546_0123456");
      glbNames.push_back("var_547_01234567");
      glbNames.push_back("var_548_012345678");
      glbNames.push_back("var_549_0123456789");
      glbNames.push_back("var_550_0");
      glbNames.push_back("var_551_01");
      glbNames.push_back("var_552_012");
      glbNames.push_back("var_553_0123");
      glbNames.push_back("var_554_01234");
      glbNames.push_back("var_555_012345");
      glbNames.push_back("var_556_0123456");
      glbNames.push_back("var_557_01234567");
      glbNames.push_back("var_558_012345678");
      glbNames.push_back("var_559_0123456789");
      glbNames.push_back("var_560_0");
      glbNames.push_back("var_561_01");
      glbNames.push_back("var_562_012");
      glbNames.push_back("var_563_0123");
      glbNames.push_back("var_564_01234");
      glbNames.push_back("var_565_012345");
      glbNames.push_back("var_566_0123456");
      glbNames.push_back("var_567_01234567");
      glbNames.push_back("var_568_012345678");
      glbNames.push_back("var_569_0123456789");
      glbNames.push_back("var_570_0");
      glbNames.push_back("var_571_01");
      glbNames.push_back("var_572_012");
      glbNames.push_back("var_573_0123");
      glbNames.push_back("var_574_01234");
      glbNames.push_back("var_575_012345");
      glbNames.push_back("var_576_0123456");
      glbNames.push_back("var_577_01234567");
      glbNames.push_back("var_578_012345678");
      glbNames.push_back("var_579_0123456789");
      glbNames.push_back("var_580_0");
      glbNames.push_back("var_581_01");
      glbNames.push_back("var_582_012");
      glbNames.push_back("var_583_0123");
      glbNames.push_back("var_584_01234");
      glbNames.push_back("var_585_012345");
      glbNames.push_back("var_586_0123456");
      glbNames.push_back("var_587_01234567");
      glbNames.push_back("var_588_012345678");
      glbNames.push_back("var_589_0123456789");
      glbNames.push_back("var_590_0");
      glbNames.push_back("var_591_01");
      glbNames.push_back("var_592_012");
      glbNames.push_back("var_593_0123");
      glbNames.push_back("var_594_01234");
      glbNames.push_back("var_595_012345");
      glbNames.push_back("var_596_0123456");
      glbNames.push_back("var_597_01234567");
      glbNames.push_back("var_598_012345678");
      glbNames.push_back("var_599_0123456789");
      glbNames.push_back("f");
      glbNames.push_back("xf");
      glbNames.push_back("var_602_012");
      glbNames.push_back("var_603_0123");
      glbNames.push_back("var_604_01234");
      glbNames.push_back("var_605_012345");
      glbNames.push_back("var_606_0123456");
      glbNames.push_back("var_607_01234567");
      glbNames.push_back("var_608_012345678");
      glbNames.push_back("var_609_0123456789");
      glbNames.push_back("var_610_0");
      glbNames.push_back("var_611_01");
      glbNames.push_back("var_612_012");
      glbNames.push_back("var_613_0123");
      glbNames.push_back("var_614_01234");
      glbNames.push_back("var_615_012345");
      glbNames.push_back("var_616_0123456");
      glbNames.push_back("var_617_01234567");
      glbNames.push_back("var_618_012345678");
      glbNames.push_back("var_619_0123456789");
      glbNames.push_back("var_620_0");
      glbNames.push_back("var_621_01");
      glbNames.push_back("var_622_012");
      glbNames.push_back("var_623_0123");
      glbNames.push_back("var_624_01234");
      glbNames.push_back("var_625_012345");
      glbNames.push_back("var_626_0123456");
      glbNames.push_back("var_627_01234567");
      glbNames.push_back("var_628_012345678");
      glbNames.push_back("var_629_0123456789");
      glbNames.push_back("var_630_0");
      glbNames.push_back("var_631_01");
      glbNames.push_back("var_632_012");
      glbNames.push_back("var_633_0123");
      glbNames.push_back("var_634_01234");
      glbNames.push_back("var_635_012345");
      glbNames.push_back("var_636_0123456");
      glbNames.push_back("var_637_01234567");
      glbNames.push_back("var_638_012345678");
      glbNames.push_back("var_639_0123456789");
      glbNames.push_back("var_640_0");
      glbNames.push_back("var_641_01");
      glbNames.push_back("var_642_012");
      glbNames.push_back("var_643_0123");
      glbNames.push_back("var_644_01234");
      glbNames.push_back("var_645_012345");
      glbNames.push_back("var_646_0123456");
      glbNames.push_back("var_647_01234567");
      glbNames.push_back("var_648_012345678");
      glbNames.push_back("var_649_0123456789");
      glbNames.push_back("var_650_0");
      glbNames.push_back("var_651_01");
      glbNames.push_back("var_652_012");
      glbNames.push_back("var_653_0123");
      glbNames.push_back("var_654_01234");
      glbNames.push_back("var_655_012345");
      glbNames.push_back("var_656_0123456");
      glbNames.push_back("var_657_01234567");
      glbNames.push_back("var_658_012345678");
      glbNames.push_back("var_659_0123456789");
      glbNames.push_back("var_660_0");
      glbNames.push_back("var_661_01");
      glbNames.push_back("var_662_012");
      glbNames.push_back("var_663_0123");
      glbNames.push_back("var_664_01234");
      glbNames.push_back("var_665_012345");
      glbNames.push_back("var_666_0123456");
      glbNames.push_back("var_667_01234567");
      glbNames.push_back("var_668_012345678");
      glbNames.push_back("var_669_0123456789");
      glbNames.push_back("var_670_0");
      glbNames.push_back("var_671_01");
      glbNames.push_back("var_672_012");
      glbNames.push_back("var_673_0123");
      glbNames.push_back("var_674_01234");
      glbNames.push_back("var_675_012345");
      glbNames.push_back("var_676_0123456");
      glbNames.push_back("var_677_01234567");
      glbNames.push_back("var_678_012345678");
      glbNames.push_back("var_679_0123456789");
      glbNames.push_back("var_680_0");
      glbNames.push_back("var_681_01");
      glbNames.push_back("var_682_012");
      glbNames.push_back("var_683_0123");
      glbNames.push_back("var_684_01234");
      glbNames.push_back("var_685_012345");
      glbNames.push_back("var_686_0123456");
      glbNames.push_back("var_687_01234567");
      glbNames.push_back("var_688_012345678");
      glbNames.push_back("var_689_0123456789");
      glbNames.push_back("var_690_0");
      glbNames.push_back("var_691_01");
      glbNames.push_back("var_692_012");
      glbNames.push_back("var_693_0123");
      glbNames.push_back("var_694_01234");
      glbNames.push_back("var_695_012345");
      glbNames.push_back("var_696_0123456");
      glbNames.push_back("var_697_01234567");
      glbNames.push_back("var_698_012345678");
      glbNames.push_back("var_699_0123456789");
      glbNames.push_back("g");
      glbNames.push_back("xg");
      glbNames.push_back("var_702_012");
      glbNames.push_back("var_703_0123");
      glbNames.push_back("var_704_01234");
      glbNames.push_back("var_705_012345");
      glbNames.push_back("var_706_0123456");
      glbNames.push_back("var_707_01234567");
      glbNames.push_back("var_708_012345678");
      glbNames.push_back("var_709_0123456789");
      glbNames.push_back("var_710_0");
      glbNames.push_back("var_711_01");
      glbNames.push_back("var_712_012");
      glbNames.push_back("var_713_0123");
      glbNames.push_back("var_714_01234");
      glbNames.push_back("var_715_012345");
      glbNames.push_back("var_716_0123456");
      glbNames.push_back("var_717_01234567");
      glbNames.push_back("var_718_012345678");
      glbNames.push_back("var_719_0123456789");
      glbNames.push_back("var_720_0");
      glbNames.push_back("var_721_01");
      glbNames.push_back("var_722_012");
      glbNames.push_back("var_723_0123");
      glbNames.push_back("var_724_01234");
      glbNames.push_back("var_725_012345");
      glbNames.push_back("var_726_0123456");
      glbNames.push_back("var_727_01234567");
      glbNames.push_back("var_728_012345678");
      glbNames.push_back("var_729_0123456789");
      glbNames.push_back("var_730_0");
      glbNames.push_back("var_731_01");
      glbNames.push_back("var_732_012");
      glbNames.push_back("var_733_0123");
      glbNames.push_back("var_734_01234");
      glbNames.push_back("var_735_012345");
      glbNames.push_back("var_736_0123456");
      glbNames.push_back("var_737_01234567");
      glbNames.push_back("var_738_012345678");
      glbNames.push_back("var_739_0123456789");
      glbNames.push_back("var_740_0");
      glbNames.push_back("var_741_01");
      glbNames.push_back("var_742_012");
      glbNames.push_back("var_743_0123");
      glbNames.push_back("var_744_01234");
      glbNames.push_back("var_745_012345");
      glbNames.push_back("var_746_0123456");
      glbNames.push_back("var_747_01234567");
      glbNames.push_back("var_748_012345678");
      glbNames.push_back("var_749_0123456789");
      glbNames.push_back("var_750_0");
      glbNames.push_back("var_751_01");
      glbNames.push_back("var_752_012");
      glbNames.push_back("var_753_0123");
      glbNames.push_back("var_754_01234");
      glbNames.push_back("var_755_012345");
      glbNames.push_back("var_756_0123456");
      glbNames.push_back("var_757_01234567");
      glbNames.push_back("var_758_012345678");
      glbNames.push_back("var_759_0123456789");
      glbNames.push_back("var_760_0");
      glbNames.push_back("var_761_01");
      glbNames.push_back("var_762_012");
      glbNames.push_back("var_763_0123");
      glbNames.push_back("var_764_01234");
      glbNames.push_back("var_765_012345");
      glbNames.push_back("var_766_0123456");
      glbNames.push_back("var_767_01234567");
      glbNames.push_back("var_768_012345678");
      glbNames.push_back("var_769_0123456789");
      glbNames.push_back("var_770_0");
      glbNames.push_back("var_771_01");
      glbNames.push_back("var_772_012");
      glbNames.push_back("var_773_0123");
      glbNames.push_back("var_774_01234");
      glbNames.push_back("var_775_012345");
      glbNames.push_back("var_776_0123456");
      glbNames.push_back("var_777_01234567");
      glbNames.push_back("var_778_012345678");
      glbNames.push_back("var_779_0123456789");
      glbNames.push_back("var_780_0");
      glbNames.push_back("var_781_01");
      glbNames.push_back("var_782_012");
      glbNames.push_back("var_783_0123");
      glbNames.push_back("var_784_01234");
      glbNames.push_back("var_785_012345");
      glbNames.push_back("var_786_0123456");
      glbNames.push_back("var_787_01234567");
      glbNames.push_back("var_788_012345678");
      glbNames.push_back("var_789_0123456789");
      glbNames.push_back("var_790_0");
      glbNames.push_back("var_791_01");
      glbNames.push_back("var_792_012");
      glbNames.push_back("var_793_0123");
      glbNames.push_back("var_794_01234");
      glbNames.push_back("var_795_012345");
      glbNames.push_back("var_796_0123456");
      glbNames.push_back("var_797_01234567");
      glbNames.push_back("var_798_012345678");
      glbNames.push_back("var_799_0123456789");
      glbNames.push_back("h");
      glbNames.push_back("xh");
      glbNames.push_back("var_802_012");
      glbNames.push_back("var_803_0123");
      glbNames.push_back("var_804_01234");
      glbNames.push_back("var_805_012345");
      glbNames.push_back("var_806_0123456");
      glbNames.push_back("var_807_01234567");
      glbNames.push_back("var_808_012345678");
      glbNames.push_back("var_809_0123456789");
      glbNames.push_back("var_810_0");
      glbNames.push_back("var_811_01");
      glbNames.push_back("var_812_012");
      glbNames.push_back("var_813_0123");
      glbNames.push_back("var_814_01234");
      glbNames.push_back("var_815_012345");
      glbNames.push_back("var_816_0123456");
      glbNames.push_back("var_817_01234567");
      glbNames.push_back("var_818_012345678");
      glbNames.push_back("var_819_0123456789");
      glbNames.push_back("var_820_0");
      glbNames.push_back("var_821_01");
      glbNames.push_back("var_822_012");
      glbNames.push_back("var_823_0123");
      glbNames.push_back("var_824_01234");
      glbNames.push_back("var_825_012345");
      glbNames.push_back("var_826_0123456");
      glbNames.push_back("var_827_01234567");
      glbNames.push_back("var_828_012345678");
      glbNames.push_back("var_829_0123456789");
      glbNames.push_back("var_830_0");
      glbNames.push_back("var_831_01");
      glbNames.push_back("var_832_012");
      glbNames.push_back("var_833_0123");
      glbNames.push_back("var_834_01234");
      glbNames.push_back("var_835_012345");
      glbNames.push_back("var_836_0123456");
      glbNames.push_back("var_837_01234567");
      glbNames.push_back("var_838_012345678");
      glbNames.push_back("var_839_0123456789");
      glbNames.push_back("var_840_0");
      glbNames.push_back("var_841_01");
      glbNames.push_back("var_842_012");
      glbNames.push_back("var_843_0123");
      glbNames.push_back("var_844_01234");
      glbNames.push_back("var_845_012345");
      glbNames.push_back("var_846_0123456");
      glbNames.push_back("var_847_01234567");
      glbNames.push_back("var_848_012345678");
      glbNames.push_back("var_849_0123456789");
      glbNames.push_back("var_850_0");
      glbNames.push_back("var_851_01");
      glbNames.push_back("var_852_012");
      glbNames.push_back("var_853_0123");
      glbNames.push_back("var_854_01234");
      glbNames.push_back("var_855_012345");
      glbNames.push_back("var_856_0123456");
      glbNames.push_back("var_857_01234567");
      glbNames.push_back("var_858_012345678");
      glbNames.push_back("var_859_0123456789");
      glbNames.push_back("var_860_0");
      glbNames.push_back("var_861_01");
      glbNames.push_back("var_862_012");
      glbNames.push_back("var_863_0123");
      glbNames.push_back("var_864_01234");
      glbNames.push_back("var_865_012345");
      glbNames.push_back("var_866_0123456");
      glbNames.push_back("var_867_01234567");
      glbNames.push_back("var_868_012345678");
      glbNames.push_back("var_869_0123456789");
      glbNames.push_back("var_870_0");
      glbNames.push_back("var_871_01");
      glbNames.push_back("var_872_012");
      glbNames.push_back("var_873_0123");
      glbNames.push_back("var_874_01234");
      glbNames.push_back("var_875_012345");
      glbNames.push_back("var_876_0123456");
      glbNames.push_back("var_877_01234567");
      glbNames.push_back("var_878_012345678");
      glbNames.push_back("var_879_0123456789");
      glbNames.push_back("var_880_0");
      glbNames.push_back("var_881_01");
      glbNames.push_back("var_882_012");
      glbNames.push_back("var_883_0123");
      glbNames.push_back("var_884_01234");
      glbNames.push_back("var_885_012345");
      glbNames.push_back("var_886_0123456");
      glbNames.push_back("var_887_01234567");
      glbNames.push_back("var_888_012345678");
      glbNames.push_back("var_889_0123456789");
      glbNames.push_back("var_890_0");
      glbNames.push_back("var_891_01");
      glbNames.push_back("var_892_012");
      glbNames.push_back("var_893_0123");
      glbNames.push_back("var_894_01234");
      glbNames.push_back("var_895_012345");
      glbNames.push_back("var_896_0123456");
      glbNames.push_back("var_897_01234567");
      glbNames.push_back("var_898_012345678");
      glbNames.push_back("var_899_0123456789");
      glbNames.push_back("i");
      glbNames.push_back("xi");
      glbNames.push_back("var_902_012");
      glbNames.push_back("var_903_0123");
      glbNames.push_back("var_904_01234");
      glbNames.push_back("var_905_012345");
      glbNames.push_back("var_906_0123456");
      glbNames.push_back("var_907_01234567");
      glbNames.push_back("var_908_012345678");
      glbNames.push_back("var_909_0123456789");
      glbNames.push_back("var_910_0");
      glbNames.push_back("var_911_01");
      glbNames.push_back("var_912_012");
      glbNames.push_back("var_913_0123");
      glbNames.push_back("var_914_01234");
      glbNames.push_back("var_915_012345");
      glbNames.push_back("var_916_0123456");
      glbNames.push_back("var_917_01234567");
      glbNames.push_back("var_918_012345678");
      glbNames.push_back("var_919_0123456789");
      glbNames.push_back("var_920_0");
      glbNames.push_back("var_921_01");
      glbNames.push_back("var_922_012");
      glbNames.push_back("var_923_0123");
      glbNames.push_back("var_924_01234");
      glbNames.push_back("var_925_012345");
      glbNames.push_back("var_926_0123456");
      glbNames.push_back("var_927_01234567");
      glbNames.push_back("var_928_012345678");
      glbNames.push_back("var_929_0123456789");
      glbNames.push_back("var_930_0");
      glbNames.push_back("var_931_01");
      glbNames.push_back("var_932_012");
      glbNames.push_back("var_933_0123");
      glbNames.push_back("var_934_01234");
      glbNames.push_back("var_935_012345");
      glbNames.push_back("var_936_0123456");
      glbNames.push_back("var_937_01234567");
      glbNames.push_back("var_938_012345678");
      glbNames.push_back("var_939_0123456789");
      glbNames.push_back("var_940_0");
      glbNames.push_back("var_941_01");
      glbNames.push_back("var_942_012");
      glbNames.push_back("var_943_0123");
      glbNames.push_back("var_944_01234");
      glbNames.push_back("var_945_012345");
      glbNames.push_back("var_946_0123456");
      glbNames.push_back("var_947_01234567");
      glbNames.push_back("var_948_012345678");
      glbNames.push_back("var_949_0123456789");
      glbNames.push_back("var_950_0");
      glbNames.push_back("var_951_01");
      glbNames.push_back("var_952_012");
      glbNames.push_back("var_953_0123");
      glbNames.push_back("var_954_01234");
      glbNames.push_back("var_955_012345");
      glbNames.push_back("var_956_0123456");
      glbNames.push_back("var_957_01234567");
      glbNames.push_back("var_958_012345678");
      glbNames.push_back("var_959_0123456789");
      glbNames.push_back("var_960_0");
      glbNames.push_back("var_961_01");
      glbNames.push_back("var_962_012");
      glbNames.push_back("var_963_0123");
      glbNames.push_back("var_964_01234");
      glbNames.push_back("var_965_012345");
      glbNames.push_back("var_966_0123456");
      glbNames.push_back("var_967_01234567");
      glbNames.push_back("var_968_012345678");
      glbNames.push_back("var_969_0123456789");
      glbNames.push_back("var_970_0");
      glbNames.push_back("var_971_01");
      glbNames.push_back("var_972_012");
      glbNames.push_back("var_973_0123");
      glbNames.push_back("var_974_01234");
      glbNames.push_back("var_975_012345");
      glbNames.push_back("var_976_0123456");
      glbNames.push_back("var_977_01234567");
      glbNames.push_back("var_978_012345678");
      glbNames.push_back("var_979_0123456789");
      glbNames.push_back("var_980_0");
      glbNames.push_back("var_981_01");
      glbNames.push_back("var_982_012");
      glbNames.push_back("var_983_0123");
      glbNames.push_back("var_984_01234");
      glbNames.push_back("var_985_012345");
      glbNames.push_back("var_986_0123456");
      glbNames.push_back("var_987_01234567");
      glbNames.push_back("var_988_012345678");
      glbNames.push_back("var_989_0123456789");
      glbNames.push_back("var_990_0");
      glbNames.push_back("var_991_01");
      glbNames.push_back("var_992_012");
      glbNames.push_back("var_993_0123");
      glbNames.push_back("var_994_01234");
      glbNames.push_back("var_995_012345");
      glbNames.push_back("var_996_0123456");
      glbNames.push_back("var_997_01234567");
      glbNames.push_back("var_998_012345678");
      glbNames.push_back("var_999_0123456789");
      glbNames.push_back("j");
      glbNames.push_back("xj");
      glbNames.push_back("var_1002_012");
      glbNames.push_back("var_1003_0123");
      glbNames.push_back("var_1004_01234");
      glbNames.push_back("var_1005_012345");
      glbNames.push_back("var_1006_0123456");
      glbNames.push_back("var_1007_01234567");
      glbNames.push_back("var_1008_012345678");
      glbNames.push_back("var_1009_0123456789");
      glbNames.push_back("var_1010_0");
      glbNames.push_back("var_1011_01");
      glbNames.push_back("var_1012_012");
      glbNames.push_back("var_1013_0123");
      glbNames.push_back("var_1014_01234");
      glbNames.push_back("var_1015_012345");
      glbNames.push_back("var_1016_0123456");
      glbNames.push_back("var_1017_01234567");
      glbNames.push_back("var_1018_012345678");
      glbNames.push_back("var_1019_0123456789");
      glbNames.push_back("var_1020_0");
      glbNames.push_back("var_1021_01");
      glbNames.push_back("var_1022_012");
      glbNames.push_back("var_1023_0123");

      /* 0 */ glbTypes.push_back("INT16");
      /* 1 */ glbTypes.push_back("INT8");
      /* 2 */ glbTypes.push_back("UINT64");
      /* 3 */ glbTypes.push_back("INT32");
      /* 4 */ glbTypes.push_back("HIRESTIME");
      /* 5 */ glbTypes.push_back("UINT16");
      /* 6 */ glbTypes.push_back("UINT16");
      /* 7 */ glbTypes.push_back("DATETIME");
      /* 8 */ glbTypes.push_back("UINT64");
      /* 9 */ glbTypes.push_back("RICHREAL");
      /* 10 */ glbTypes.push_back("INT8");
      /* 11 */ glbTypes.push_back("UINT32");
      /* 12 */ glbTypes.push_back("BOOL");
      /* 13 */ glbTypes.push_back("INT64");
      /* 14 */ glbTypes.push_back("INT16");
      /* 15 */ glbTypes.push_back("RICHREAL");
      /* 16 */ glbTypes.push_back("UINT64");
      /* 17 */ glbTypes.push_back("RICHREAL");
      /* 18 */ glbTypes.push_back("UINT64");
      /* 19 */ glbTypes.push_back("DATETIME");
      /* 20 */ glbTypes.push_back("RICHREAL");
      /* 21 */ glbTypes.push_back("UINT64");
      /* 22 */ glbTypes.push_back("UINT32");
      /* 23 */ glbTypes.push_back("DATE");
      /* 24 */ glbTypes.push_back("UINT16");
      /* 25 */ glbTypes.push_back("DATETIME");
      /* 26 */ glbTypes.push_back("REAL");
      /* 27 */ glbTypes.push_back("INT64");
      /* 28 */ glbTypes.push_back("BOOL");
      /* 29 */ glbTypes.push_back("DATETIME");
      /* 30 */ glbTypes.push_back("UINT8");
      /* 31 */ glbTypes.push_back("INT64");
      /* 32 */ glbTypes.push_back("UINT8");
      /* 33 */ glbTypes.push_back("UINT32");
      /* 34 */ glbTypes.push_back("BOOL");
      /* 35 */ glbTypes.push_back("INT16");
      /* 36 */ glbTypes.push_back("BOOL");
      /* 37 */ glbTypes.push_back("UINT32");
      /* 38 */ glbTypes.push_back("CHAR");
      /* 39 */ glbTypes.push_back("UINT64");
      /* 40 */ glbTypes.push_back("UINT32");
      /* 41 */ glbTypes.push_back("DATETIME");
      /* 42 */ glbTypes.push_back("UINT32");
      /* 43 */ glbTypes.push_back("INT8");
      /* 44 */ glbTypes.push_back("REAL");
      /* 45 */ glbTypes.push_back("INT8");
      /* 46 */ glbTypes.push_back("HIRESTIME");
      /* 47 */ glbTypes.push_back("DATE");
      /* 48 */ glbTypes.push_back("UINT64");
      /* 49 */ glbTypes.push_back("INT32");
      /* 50 */ glbTypes.push_back("INT32");
      /* 51 */ glbTypes.push_back("UINT8");
      /* 52 */ glbTypes.push_back("DATETIME");
      /* 53 */ glbTypes.push_back("BOOL");
      /* 54 */ glbTypes.push_back("UINT64");
      /* 55 */ glbTypes.push_back("REAL");
      /* 56 */ glbTypes.push_back("REAL");
      /* 57 */ glbTypes.push_back("DATETIME");
      /* 58 */ glbTypes.push_back("HIRESTIME");
      /* 59 */ glbTypes.push_back("INT16");
      /* 60 */ glbTypes.push_back("DATE");
      /* 61 */ glbTypes.push_back("INT8");
      /* 62 */ glbTypes.push_back("INT64");
      /* 63 */ glbTypes.push_back("INT16");
      /* 64 */ glbTypes.push_back("UINT16");
      /* 65 */ glbTypes.push_back("RICHREAL");
      /* 66 */ glbTypes.push_back("INT32");
      /* 67 */ glbTypes.push_back("INT64");
      /* 68 */ glbTypes.push_back("HIRESTIME");
      /* 69 */ glbTypes.push_back("INT8");
      /* 70 */ glbTypes.push_back("INT16");
      /* 71 */ glbTypes.push_back("DATETIME");
      /* 72 */ glbTypes.push_back("HIRESTIME");
      /* 73 */ glbTypes.push_back("UINT16");
      /* 74 */ glbTypes.push_back("DATE");
      /* 75 */ glbTypes.push_back("RICHREAL");
      /* 76 */ glbTypes.push_back("REAL");
      /* 77 */ glbTypes.push_back("RICHREAL");
      /* 78 */ glbTypes.push_back("BOOL");
      /* 79 */ glbTypes.push_back("DATETIME");
      /* 80 */ glbTypes.push_back("INT16");
      /* 81 */ glbTypes.push_back("INT64");
      /* 82 */ glbTypes.push_back("UINT64");
      /* 83 */ glbTypes.push_back("REAL");
      /* 84 */ glbTypes.push_back("INT8");
      /* 85 */ glbTypes.push_back("INT16");
      /* 86 */ glbTypes.push_back("UINT64");
      /* 87 */ glbTypes.push_back("INT16");
      /* 88 */ glbTypes.push_back("INT8");
      /* 89 */ glbTypes.push_back("HIRESTIME");
      /* 90 */ glbTypes.push_back("INT8");
      /* 91 */ glbTypes.push_back("INT16");
      /* 92 */ glbTypes.push_back("DATE");
      /* 93 */ glbTypes.push_back("CHAR");
      /* 94 */ glbTypes.push_back("UINT64");
      /* 95 */ glbTypes.push_back("DATETIME");
      /* 96 */ glbTypes.push_back("INT32");
      /* 97 */ glbTypes.push_back("BOOL");
      /* 98 */ glbTypes.push_back("INT64");
      /* 99 */ glbTypes.push_back("UINT32");
      /* 100 */ glbTypes.push_back("ARRAY");
      /* 101 */ glbTypes.push_back("INT8 ARRAY");
      /* 102 */ glbTypes.push_back("DATETIME ARRAY");
      /* 103 */ glbTypes.push_back("BOOL ARRAY");
      /* 104 */ glbTypes.push_back("DATETIME ARRAY");
      /* 105 */ glbTypes.push_back("ARRAY");
      /* 106 */ glbTypes.push_back("UINT64 ARRAY");
      /* 107 */ glbTypes.push_back("ARRAY");
      /* 108 */ glbTypes.push_back("BOOL ARRAY");
      /* 109 */ glbTypes.push_back("INT32 ARRAY");
      /* 110 */ glbTypes.push_back("INT8 ARRAY");
      /* 111 */ glbTypes.push_back("INT64 ARRAY");
      /* 112 */ glbTypes.push_back("RICHREAL ARRAY");
      /* 113 */ glbTypes.push_back("CHAR ARRAY");
      /* 114 */ glbTypes.push_back("INT8 ARRAY");
      /* 115 */ glbTypes.push_back("ARRAY");
      /* 116 */ glbTypes.push_back("CHAR ARRAY");
      /* 117 */ glbTypes.push_back("UINT8 ARRAY");
      /* 118 */ glbTypes.push_back("INT32 ARRAY");
      /* 119 */ glbTypes.push_back("DATETIME ARRAY");
      /* 120 */ glbTypes.push_back("HIRESTIME ARRAY");
      /* 121 */ glbTypes.push_back("ARRAY");
      /* 122 */ glbTypes.push_back("INT64 ARRAY");
      /* 123 */ glbTypes.push_back("HIRESTIME ARRAY");
      /* 124 */ glbTypes.push_back("UINT8 ARRAY");
      /* 125 */ glbTypes.push_back("ARRAY");
      /* 126 */ glbTypes.push_back("RICHREAL ARRAY");
      /* 127 */ glbTypes.push_back("BOOL ARRAY");
      /* 128 */ glbTypes.push_back("INT8 ARRAY");
      /* 129 */ glbTypes.push_back("HIRESTIME ARRAY");
      /* 130 */ glbTypes.push_back("DATETIME ARRAY");
      /* 131 */ glbTypes.push_back("INT32 ARRAY");
      /* 132 */ glbTypes.push_back("BOOL ARRAY");
      /* 133 */ glbTypes.push_back("INT16 ARRAY");
      /* 134 */ glbTypes.push_back("INT16 ARRAY");
      /* 135 */ glbTypes.push_back("DATETIME ARRAY");
      /* 136 */ glbTypes.push_back("REAL ARRAY");
      /* 137 */ glbTypes.push_back("CHAR ARRAY");
      /* 138 */ glbTypes.push_back("INT16 ARRAY");
      /* 139 */ glbTypes.push_back("ARRAY");
      /* 140 */ glbTypes.push_back("RICHREAL ARRAY");
      /* 141 */ glbTypes.push_back("UINT8 ARRAY");
      /* 142 */ glbTypes.push_back("INT8 ARRAY");
      /* 143 */ glbTypes.push_back("UINT32 ARRAY");
      /* 144 */ glbTypes.push_back("INT8 ARRAY");
      /* 145 */ glbTypes.push_back("ARRAY");
      /* 146 */ glbTypes.push_back("BOOL ARRAY");
      /* 147 */ glbTypes.push_back("INT16 ARRAY");
      /* 148 */ glbTypes.push_back("DATETIME ARRAY");
      /* 149 */ glbTypes.push_back("BOOL ARRAY");
      /* 150 */ glbTypes.push_back("CHAR ARRAY");
      /* 151 */ glbTypes.push_back("UINT16 ARRAY");
      /* 152 */ glbTypes.push_back("DATE ARRAY");
      /* 153 */ glbTypes.push_back("ARRAY");
      /* 154 */ glbTypes.push_back("INT32 ARRAY");
      /* 155 */ glbTypes.push_back("ARRAY");
      /* 156 */ glbTypes.push_back("ARRAY");
      /* 157 */ glbTypes.push_back("DATE ARRAY");
      /* 158 */ glbTypes.push_back("UINT32 ARRAY");
      /* 159 */ glbTypes.push_back("RICHREAL ARRAY");
      /* 160 */ glbTypes.push_back("INT8 ARRAY");
      /* 161 */ glbTypes.push_back("UINT64 ARRAY");
      /* 162 */ glbTypes.push_back("INT16 ARRAY");
      /* 163 */ glbTypes.push_back("INT8 ARRAY");
      /* 164 */ glbTypes.push_back("CHAR ARRAY");
      /* 165 */ glbTypes.push_back("INT16 ARRAY");
      /* 166 */ glbTypes.push_back("DATE ARRAY");
      /* 167 */ glbTypes.push_back("INT8 ARRAY");
      /* 168 */ glbTypes.push_back("HIRESTIME ARRAY");
      /* 169 */ glbTypes.push_back("DATETIME ARRAY");
      /* 170 */ glbTypes.push_back("ARRAY");
      /* 171 */ glbTypes.push_back("INT8 ARRAY");
      /* 172 */ glbTypes.push_back("HIRESTIME ARRAY");
      /* 173 */ glbTypes.push_back("INT32 ARRAY");
      /* 174 */ glbTypes.push_back("REAL ARRAY");
      /* 175 */ glbTypes.push_back("DATETIME ARRAY");
      /* 176 */ glbTypes.push_back("UINT32 ARRAY");
      /* 177 */ glbTypes.push_back("INT16 ARRAY");
      /* 178 */ glbTypes.push_back("REAL ARRAY");
      /* 179 */ glbTypes.push_back("HIRESTIME ARRAY");
      /* 180 */ glbTypes.push_back("DATE ARRAY");
      /* 181 */ glbTypes.push_back("BOOL ARRAY");
      /* 182 */ glbTypes.push_back("REAL ARRAY");
      /* 183 */ glbTypes.push_back("UINT64 ARRAY");
      /* 184 */ glbTypes.push_back("UINT32 ARRAY");
      /* 185 */ glbTypes.push_back("INT16 ARRAY");
      /* 186 */ glbTypes.push_back("UINT64 ARRAY");
      /* 187 */ glbTypes.push_back("HIRESTIME ARRAY");
      /* 188 */ glbTypes.push_back("HIRESTIME ARRAY");
      /* 189 */ glbTypes.push_back("HIRESTIME ARRAY");
      /* 190 */ glbTypes.push_back("INT64 ARRAY");
      /* 191 */ glbTypes.push_back("INT8 ARRAY");
      /* 192 */ glbTypes.push_back("DATETIME ARRAY");
      /* 193 */ glbTypes.push_back("INT16 ARRAY");
      /* 194 */ glbTypes.push_back("UINT16 ARRAY");
      /* 195 */ glbTypes.push_back("DATETIME ARRAY");
      /* 196 */ glbTypes.push_back("INT32 ARRAY");
      /* 197 */ glbTypes.push_back("UINT8 ARRAY");
      /* 198 */ glbTypes.push_back("HIRESTIME ARRAY");
      /* 199 */ glbTypes.push_back("INT8 ARRAY");
      /* 200 */ glbTypes.push_back("DATETIME FIELD");
      /* 201 */ glbTypes.push_back("INT64 FIELD");
      /* 202 */ glbTypes.push_back("REAL FIELD");
      /* 203 */ glbTypes.push_back("INT16 FIELD");
      /* 204 */ glbTypes.push_back("INT64 FIELD");
      /* 205 */ glbTypes.push_back("UINT8 FIELD");
      /* 206 */ glbTypes.push_back("UINT32 FIELD");
      /* 207 */ glbTypes.push_back("CHAR FIELD");
      /* 208 */ glbTypes.push_back("FIELD");
      /* 209 */ glbTypes.push_back("HIRESTIME FIELD");
      /* 210 */ glbTypes.push_back("UINT64 FIELD");
      /* 211 */ glbTypes.push_back("INT64 FIELD");
      /* 212 */ glbTypes.push_back("INT32 FIELD");
      /* 213 */ glbTypes.push_back("FIELD");
      /* 214 */ glbTypes.push_back("BOOL FIELD");
      /* 215 */ glbTypes.push_back("HIRESTIME FIELD");
      /* 216 */ glbTypes.push_back("INT32 FIELD");
      /* 217 */ glbTypes.push_back("RICHREAL FIELD");
      /* 218 */ glbTypes.push_back("CHAR FIELD");
      /* 219 */ glbTypes.push_back("CHAR FIELD");
      /* 220 */ glbTypes.push_back("INT16 FIELD");
      /* 221 */ glbTypes.push_back("HIRESTIME FIELD");
      /* 222 */ glbTypes.push_back("INT32 FIELD");
      /* 223 */ glbTypes.push_back("FIELD");
      /* 224 */ glbTypes.push_back("BOOL FIELD");
      /* 225 */ glbTypes.push_back("INT8 FIELD");
      /* 226 */ glbTypes.push_back("HIRESTIME FIELD");
      /* 227 */ glbTypes.push_back("BOOL FIELD");
      /* 228 */ glbTypes.push_back("HIRESTIME FIELD");
      /* 229 */ glbTypes.push_back("FIELD");
      /* 230 */ glbTypes.push_back("UINT64 FIELD");
      /* 231 */ glbTypes.push_back("REAL FIELD");
      /* 232 */ glbTypes.push_back("INT8 FIELD");
      /* 233 */ glbTypes.push_back("CHAR FIELD");
      /* 234 */ glbTypes.push_back("UINT8 FIELD");
      /* 235 */ glbTypes.push_back("RICHREAL FIELD");
      /* 236 */ glbTypes.push_back("DATE FIELD");
      /* 237 */ glbTypes.push_back("REAL FIELD");
      /* 238 */ glbTypes.push_back("UINT64 FIELD");
      /* 239 */ glbTypes.push_back("INT32 FIELD");
      /* 240 */ glbTypes.push_back("DATETIME FIELD");
      /* 241 */ glbTypes.push_back("DATETIME FIELD");
      /* 242 */ glbTypes.push_back("INT16 FIELD");
      /* 243 */ glbTypes.push_back("CHAR FIELD");
      /* 244 */ glbTypes.push_back("BOOL FIELD");
      /* 245 */ glbTypes.push_back("BOOL FIELD");
      /* 246 */ glbTypes.push_back("RICHREAL FIELD");
      /* 247 */ glbTypes.push_back("INT32 FIELD");
      /* 248 */ glbTypes.push_back("UINT32 FIELD");
      /* 249 */ glbTypes.push_back("DATETIME FIELD");
      /* 250 */ glbTypes.push_back("FIELD");
      /* 251 */ glbTypes.push_back("INT8 FIELD");
      /* 252 */ glbTypes.push_back("INT64 FIELD");
      /* 253 */ glbTypes.push_back("DATETIME FIELD");
      /* 254 */ glbTypes.push_back("DATE FIELD");
      /* 255 */ glbTypes.push_back("FIELD");
      /* 256 */ glbTypes.push_back("INT16 FIELD");
      /* 257 */ glbTypes.push_back("DATE FIELD");
      /* 258 */ glbTypes.push_back("UINT64 FIELD");
      /* 259 */ glbTypes.push_back("UINT8 FIELD");
      /* 260 */ glbTypes.push_back("UINT64 FIELD");
      /* 261 */ glbTypes.push_back("DATE FIELD");
      /* 262 */ glbTypes.push_back("INT32 FIELD");
      /* 263 */ glbTypes.push_back("DATE FIELD");
      /* 264 */ glbTypes.push_back("FIELD");
      /* 265 */ glbTypes.push_back("UINT64 FIELD");
      /* 266 */ glbTypes.push_back("FIELD");
      /* 267 */ glbTypes.push_back("INT16 FIELD");
      /* 268 */ glbTypes.push_back("INT8 FIELD");
      /* 269 */ glbTypes.push_back("UINT8 FIELD");
      /* 270 */ glbTypes.push_back("DATETIME FIELD");
      /* 271 */ glbTypes.push_back("UINT32 FIELD");
      /* 272 */ glbTypes.push_back("UINT64 FIELD");
      /* 273 */ glbTypes.push_back("INT16 FIELD");
      /* 274 */ glbTypes.push_back("UINT16 FIELD");
      /* 275 */ glbTypes.push_back("FIELD");
      /* 276 */ glbTypes.push_back("CHAR FIELD");
      /* 277 */ glbTypes.push_back("HIRESTIME FIELD");
      /* 278 */ glbTypes.push_back("UINT32 FIELD");
      /* 279 */ glbTypes.push_back("UINT64 FIELD");
      /* 280 */ glbTypes.push_back("HIRESTIME FIELD");
      /* 281 */ glbTypes.push_back("UINT64 FIELD");
      /* 282 */ glbTypes.push_back("UINT16 FIELD");
      /* 283 */ glbTypes.push_back("INT16 FIELD");
      /* 284 */ glbTypes.push_back("RICHREAL FIELD");
      /* 285 */ glbTypes.push_back("FIELD");
      /* 286 */ glbTypes.push_back("HIRESTIME FIELD");
      /* 287 */ glbTypes.push_back("UINT16 FIELD");
      /* 288 */ glbTypes.push_back("RICHREAL FIELD");
      /* 289 */ glbTypes.push_back("BOOL FIELD");
      /* 290 */ glbTypes.push_back("INT64 FIELD");
      /* 291 */ glbTypes.push_back("REAL FIELD");
      /* 292 */ glbTypes.push_back("INT64 FIELD");
      /* 293 */ glbTypes.push_back("INT64 FIELD");
      /* 294 */ glbTypes.push_back("UINT16 FIELD");
      /* 295 */ glbTypes.push_back("REAL FIELD");
      /* 296 */ glbTypes.push_back("REAL FIELD");
      /* 297 */ glbTypes.push_back("CHAR FIELD");
      /* 298 */ glbTypes.push_back("FIELD");
      /* 299 */ glbTypes.push_back("UINT64 FIELD");
      /* 300 */ glbTypes.push_back("REAL ARRAY FIELD");
      /* 301 */ glbTypes.push_back("CHAR ARRAY FIELD");
      /* 302 */ glbTypes.push_back("UINT8 ARRAY FIELD");
      /* 303 */ glbTypes.push_back("CHAR ARRAY FIELD");
      /* 304 */ glbTypes.push_back("DATE ARRAY FIELD");
      /* 305 */ glbTypes.push_back("HIRESTIME ARRAY FIELD");
      /* 306 */ glbTypes.push_back("REAL ARRAY FIELD");
      /* 307 */ glbTypes.push_back("ARRAY FIELD");
      /* 308 */ glbTypes.push_back("UINT8 ARRAY FIELD");
      /* 309 */ glbTypes.push_back("BOOL ARRAY FIELD");
      /* 310 */ glbTypes.push_back("UINT8 ARRAY FIELD");
      /* 311 */ glbTypes.push_back("UINT64 ARRAY FIELD");
      /* 312 */ glbTypes.push_back("UINT64 ARRAY FIELD");
      /* 313 */ glbTypes.push_back("UINT32 ARRAY FIELD");
      /* 314 */ glbTypes.push_back("INT32 ARRAY FIELD");
      /* 315 */ glbTypes.push_back("UINT64 ARRAY FIELD");
      /* 316 */ glbTypes.push_back("UINT64 ARRAY FIELD");
      /* 317 */ glbTypes.push_back("BOOL ARRAY FIELD");
      /* 318 */ glbTypes.push_back("DATE ARRAY FIELD");
      /* 319 */ glbTypes.push_back("ARRAY FIELD");
      /* 320 */ glbTypes.push_back("CHAR ARRAY FIELD");
      /* 321 */ glbTypes.push_back("ARRAY FIELD");
      /* 322 */ glbTypes.push_back("REAL ARRAY FIELD");
      /* 323 */ glbTypes.push_back("ARRAY FIELD");
      /* 324 */ glbTypes.push_back("INT8 ARRAY FIELD");
      /* 325 */ glbTypes.push_back("REAL ARRAY FIELD");
      /* 326 */ glbTypes.push_back("RICHREAL ARRAY FIELD");
      /* 327 */ glbTypes.push_back("DATE ARRAY FIELD");
      /* 328 */ glbTypes.push_back("UINT8 ARRAY FIELD");
      /* 329 */ glbTypes.push_back("REAL ARRAY FIELD");
      /* 330 */ glbTypes.push_back("UINT8 ARRAY FIELD");
      /* 331 */ glbTypes.push_back("UINT32 ARRAY FIELD");
      /* 332 */ glbTypes.push_back("UINT8 ARRAY FIELD");
      /* 333 */ glbTypes.push_back("INT64 ARRAY FIELD");
      /* 334 */ glbTypes.push_back("UINT8 ARRAY FIELD");
      /* 335 */ glbTypes.push_back("INT32 ARRAY FIELD");
      /* 336 */ glbTypes.push_back("INT16 ARRAY FIELD");
      /* 337 */ glbTypes.push_back("INT64 ARRAY FIELD");
      /* 338 */ glbTypes.push_back("DATETIME ARRAY FIELD");
      /* 339 */ glbTypes.push_back("DATETIME ARRAY FIELD");
      /* 340 */ glbTypes.push_back("INT8 ARRAY FIELD");
      /* 341 */ glbTypes.push_back("HIRESTIME ARRAY FIELD");
      /* 342 */ glbTypes.push_back("HIRESTIME ARRAY FIELD");
      /* 343 */ glbTypes.push_back("UINT16 ARRAY FIELD");
      /* 344 */ glbTypes.push_back("ARRAY FIELD");
      /* 345 */ glbTypes.push_back("UINT16 ARRAY FIELD");
      /* 346 */ glbTypes.push_back("INT8 ARRAY FIELD");
      /* 347 */ glbTypes.push_back("INT16 ARRAY FIELD");
      /* 348 */ glbTypes.push_back("UINT64 ARRAY FIELD");
      /* 349 */ glbTypes.push_back("INT16 ARRAY FIELD");
      /* 350 */ glbTypes.push_back("UINT32 ARRAY FIELD");
      /* 351 */ glbTypes.push_back("REAL ARRAY FIELD");
      /* 352 */ glbTypes.push_back("BOOL ARRAY FIELD");
      /* 353 */ glbTypes.push_back("UINT8 ARRAY FIELD");
      /* 354 */ glbTypes.push_back("UINT8 ARRAY FIELD");
      /* 355 */ glbTypes.push_back("HIRESTIME ARRAY FIELD");
      /* 356 */ glbTypes.push_back("UINT8 ARRAY FIELD");
      /* 357 */ glbTypes.push_back("DATETIME ARRAY FIELD");
      /* 358 */ glbTypes.push_back("RICHREAL ARRAY FIELD");
      /* 359 */ glbTypes.push_back("DATE ARRAY FIELD");
      /* 360 */ glbTypes.push_back("UINT64 ARRAY FIELD");
      /* 361 */ glbTypes.push_back("INT64 ARRAY FIELD");
      /* 362 */ glbTypes.push_back("UINT64 ARRAY FIELD");
      /* 363 */ glbTypes.push_back("HIRESTIME ARRAY FIELD");
      /* 364 */ glbTypes.push_back("ARRAY FIELD");
      /* 365 */ glbTypes.push_back("ARRAY FIELD");
      /* 366 */ glbTypes.push_back("CHAR ARRAY FIELD");
      /* 367 */ glbTypes.push_back("INT8 ARRAY FIELD");
      /* 368 */ glbTypes.push_back("DATETIME ARRAY FIELD");
      /* 369 */ glbTypes.push_back("INT8 ARRAY FIELD");
      /* 370 */ glbTypes.push_back("RICHREAL ARRAY FIELD");
      /* 371 */ glbTypes.push_back("UINT32 ARRAY FIELD");
      /* 372 */ glbTypes.push_back("DATETIME ARRAY FIELD");
      /* 373 */ glbTypes.push_back("INT8 ARRAY FIELD");
      /* 374 */ glbTypes.push_back("HIRESTIME ARRAY FIELD");
      /* 375 */ glbTypes.push_back("INT16 ARRAY FIELD");
      /* 376 */ glbTypes.push_back("INT64 ARRAY FIELD");
      /* 377 */ glbTypes.push_back("UINT16 ARRAY FIELD");
      /* 378 */ glbTypes.push_back("UINT8 ARRAY FIELD");
      /* 379 */ glbTypes.push_back("UINT64 ARRAY FIELD");
      /* 380 */ glbTypes.push_back("INT32 ARRAY FIELD");
      /* 381 */ glbTypes.push_back("INT32 ARRAY FIELD");
      /* 382 */ glbTypes.push_back("REAL ARRAY FIELD");
      /* 383 */ glbTypes.push_back("UINT16 ARRAY FIELD");
      /* 384 */ glbTypes.push_back("UINT32 ARRAY FIELD");
      /* 385 */ glbTypes.push_back("ARRAY FIELD");
      /* 386 */ glbTypes.push_back("ARRAY FIELD");
      /* 387 */ glbTypes.push_back("UINT32 ARRAY FIELD");
      /* 388 */ glbTypes.push_back("UINT16 ARRAY FIELD");
      /* 389 */ glbTypes.push_back("INT8 ARRAY FIELD");
      /* 390 */ glbTypes.push_back("DATE ARRAY FIELD");
      /* 391 */ glbTypes.push_back("INT16 ARRAY FIELD");
      /* 392 */ glbTypes.push_back("UINT32 ARRAY FIELD");
      /* 393 */ glbTypes.push_back("ARRAY FIELD");
      /* 394 */ glbTypes.push_back("BOOL ARRAY FIELD");
      /* 395 */ glbTypes.push_back("ARRAY FIELD");
      /* 396 */ glbTypes.push_back("INT8 ARRAY FIELD");
      /* 397 */ glbTypes.push_back("INT16 ARRAY FIELD");
      /* 398 */ glbTypes.push_back("UINT32 ARRAY FIELD");
      /* 399 */ glbTypes.push_back("INT32 ARRAY FIELD");
      /* 400 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 RICHREAL, field_3_0123 INT64, field_4_01234 UINT64, field_5_012345 INT32, field_6_0123456 UINT32, field_7_01234567 UINT8 ARRAY, field_8_012345678 INT8, field_9_0123456789 UINT8, field_10_0 RICHREAL, field_11_01 INT32, field_12_012 UINT64, field_13_0123 INT32, field_14_01234 UINT16, field_15_012345 UINT8, field_16_0123456 REAL, field_17_01234567 INT8, field_18_012345678 HIRESTIME, field_19_0123456789 REAL, field_20_0 UINT8, field_21_01 BOOL, field_22_012 UINT32, field_23_0123 HIRESTIME, field_24_01234 BOOL, field_25_012345 CHAR, field_26_0123456 UINT16, field_27_01234567 UINT64, field_28_012345678 INT32 ARRAY, field_29_0123456789 CHAR, field_30_0 INT8 ARRAY, field_31_01 UINT16, field_32_012 HIRESTIME ARRAY, field_33_0123 CHAR ARRAY, field_34_01234 CHAR, field_35_012345 BOOL, field_36_0123456 HIRESTIME, field_37_01234567 UINT16, field_38_012345678 UINT64, field_39_0123456789 UINT64, field_40_0 INT8, field_41_01 INT16, field_42_012 CHAR, field_43_0123 UINT32 ARRAY, field_44_01234 UINT32, field_45_012345 UINT8, field_46_0123456 BOOL ARRAY, field_47_01234567 UINT32, field_48_012345678 DATETIME, field_49_0123456789 REAL, field_50_0 INT16, field_51_01 RICHREAL, field_52_012 BOOL, field_53_0123 DATE, field_54_01234 UINT8 ARRAY, field_55_012345 UINT16, field_56_0123456 CHAR)");
      /* 401 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 DATE, field_3_0123 DATETIME, field_4_01234 INT64, field_5_012345 HIRESTIME, field_6_0123456 CHAR, field_7_01234567 DATETIME, field_8_012345678 INT64, field_9_0123456789 HIRESTIME ARRAY, field_10_0 BOOL, field_11_01 RICHREAL ARRAY, field_12_012 UINT32 ARRAY, field_13_0123 UINT64, field_14_01234 BOOL, field_15_012345 HIRESTIME, field_16_0123456 HIRESTIME, field_17_01234567 UINT16 ARRAY, field_18_012345678 BOOL, field_19_0123456789 RICHREAL, field_20_0 INT16 ARRAY, field_21_01 RICHREAL, field_22_012 HIRESTIME, field_23_0123 DATETIME, field_24_01234 UINT8 ARRAY, field_25_012345 BOOL, field_26_0123456 HIRESTIME, field_27_01234567 INT16, field_28_012345678 INT64, field_29_0123456789 INT16, field_30_0 DATE, field_31_01 RICHREAL, field_32_012 INT16 ARRAY, field_33_0123 RICHREAL, field_34_01234 UINT16, field_35_012345 UINT8, field_36_0123456 INT16, field_37_01234567 REAL, field_38_012345678 REAL, field_39_0123456789 UINT8, field_40_0 INT8, field_41_01 INT64, field_42_012 DATETIME ARRAY, field_43_0123 INT64, field_44_01234 REAL, field_45_012345 INT64 ARRAY, field_46_0123456 UINT32, field_47_01234567 INT16, field_48_012345678 REAL ARRAY, field_49_0123456789 UINT32)");
      /* 402 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 INT64 ARRAY, field_3_0123 CHAR ARRAY, field_4_01234 INT64, field_5_012345 INT16, field_6_0123456 INT16, field_7_01234567 UINT16, field_8_012345678 CHAR, field_9_0123456789 INT64 ARRAY, field_10_0 INT32, field_11_01 INT8, field_12_012 UINT8 ARRAY, field_13_0123 UINT32, field_14_01234 UINT8, field_15_012345 DATE ARRAY, field_16_0123456 REAL, field_17_01234567 REAL, field_18_012345678 UINT8, field_19_0123456789 RICHREAL, field_20_0 UINT8, field_21_01 UINT16, field_22_012 UINT8, field_23_0123 UINT64, field_24_01234 DATETIME, field_25_012345 UINT64, field_26_0123456 DATE, field_27_01234567 INT32, field_28_012345678 INT16, field_29_0123456789 UINT8, field_30_0 UINT32, field_31_01 UINT8, field_32_012 INT64, field_33_0123 DATE, field_34_01234 INT16, field_35_012345 DATETIME ARRAY, field_36_0123456 UINT64, field_37_01234567 DATETIME, field_38_012345678 INT32 ARRAY, field_39_0123456789 BOOL, field_40_0 RICHREAL, field_41_01 INT16, field_42_012 INT8)");
      /* 403 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 HIRESTIME, field_3_0123 UINT8 ARRAY, field_4_01234 BOOL, field_5_012345 CHAR ARRAY, field_6_0123456 UINT64, field_7_01234567 HIRESTIME, field_8_012345678 INT16 ARRAY, field_9_0123456789 UINT8, field_10_0 DATE, field_11_01 INT16, field_12_012 HIRESTIME, field_13_0123 DATE, field_14_01234 UINT32 ARRAY, field_15_012345 DATETIME, field_16_0123456 INT16, field_17_01234567 HIRESTIME, field_18_012345678 INT32, field_19_0123456789 INT32, field_20_0 UINT16 ARRAY, field_21_01 UINT64, field_22_012 CHAR, field_23_0123 INT8, field_24_01234 HIRESTIME, field_25_012345 UINT16, field_26_0123456 REAL, field_27_01234567 DATETIME, field_28_012345678 REAL ARRAY, field_29_0123456789 UINT32, field_30_0 UINT16, field_31_01 INT8, field_32_012 HIRESTIME, field_33_0123 DATETIME, field_34_01234 DATE ARRAY, field_35_012345 DATE ARRAY, field_36_0123456 INT16, field_37_01234567 CHAR ARRAY, field_38_012345678 UINT32, field_39_0123456789 REAL, field_40_0 INT16, field_41_01 UINT8, field_42_012 INT16, field_43_0123 HIRESTIME, field_44_01234 BOOL, field_45_012345 INT32, field_46_0123456 INT32, field_47_01234567 INT8, field_48_012345678 DATETIME, field_49_0123456789 HIRESTIME, field_50_0 HIRESTIME, field_51_01 INT64, field_52_012 UINT16, field_53_0123 UINT8, field_54_01234 HIRESTIME, field_55_012345 REAL, field_56_0123456 INT64, field_57_01234567 REAL, field_58_012345678 UINT64 ARRAY, field_59_0123456789 UINT64, field_60_0 UINT32 ARRAY, field_61_01 CHAR, field_62_012 RICHREAL, field_63_0123 UINT16, field_64_01234 CHAR, field_65_012345 INT64, field_66_0123456 REAL, field_67_01234567 RICHREAL, field_68_012345678 INT16 ARRAY, field_69_0123456789 UINT64 ARRAY, field_70_0 HIRESTIME, field_71_01 INT64, field_72_012 INT32 ARRAY, field_73_0123 HIRESTIME, field_74_01234 HIRESTIME, field_75_012345 INT64, field_76_0123456 UINT64, field_77_01234567 CHAR, field_78_012345678 RICHREAL ARRAY, field_79_0123456789 DATE, field_80_0 DATETIME, field_81_01 HIRESTIME, field_82_012 RICHREAL, field_83_0123 INT16, field_84_01234 HIRESTIME ARRAY, field_85_012345 DATE, field_86_0123456 DATETIME, field_87_01234567 DATE, field_88_012345678 CHAR, field_89_0123456789 HIRESTIME, field_90_0 UINT16, field_91_01 REAL, field_92_012 UINT16, field_93_0123 INT8, field_94_01234 DATETIME, field_95_012345 BOOL, field_96_0123456 DATETIME, field_97_01234567 DATETIME, field_98_012345678 INT8 ARRAY)");
      /* 404 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 INT8, field_3_0123 CHAR ARRAY, field_4_01234 RICHREAL, field_5_012345 DATE, field_6_0123456 INT16, field_7_01234567 UINT16 ARRAY, field_8_012345678 REAL, field_9_0123456789 INT64 ARRAY, field_10_0 DATE, field_11_01 UINT16, field_12_012 DATE, field_13_0123 UINT16, field_14_01234 DATETIME, field_15_012345 UINT8, field_16_0123456 REAL ARRAY, field_17_01234567 DATE, field_18_012345678 UINT8, field_19_0123456789 UINT64, field_20_0 UINT8, field_21_01 RICHREAL ARRAY, field_22_012 UINT32 ARRAY, field_23_0123 DATE, field_24_01234 INT64, field_25_012345 INT8, field_26_0123456 DATE, field_27_01234567 RICHREAL, field_28_012345678 INT64, field_29_0123456789 INT16, field_30_0 INT64, field_31_01 RICHREAL, field_32_012 UINT8 ARRAY, field_33_0123 REAL, field_34_01234 INT32, field_35_012345 UINT8, field_36_0123456 DATETIME, field_37_01234567 INT32, field_38_012345678 DATETIME, field_39_0123456789 INT32 ARRAY, field_40_0 RICHREAL, field_41_01 CHAR ARRAY)");
      /* 405 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 UINT64, field_3_0123 RICHREAL, field_4_01234 INT8, field_5_012345 UINT64, field_6_0123456 UINT64, field_7_01234567 INT8 ARRAY, field_8_012345678 BOOL, field_9_0123456789 UINT64, field_10_0 BOOL, field_11_01 INT32, field_12_012 HIRESTIME, field_13_0123 DATETIME, field_14_01234 UINT64, field_15_012345 DATE, field_16_0123456 DATE ARRAY, field_17_01234567 INT16 ARRAY, field_18_012345678 UINT64, field_19_0123456789 DATETIME, field_20_0 BOOL, field_21_01 DATE ARRAY, field_22_012 INT64, field_23_0123 INT16, field_24_01234 UINT64, field_25_012345 DATETIME, field_26_0123456 DATE, field_27_01234567 INT16 ARRAY, field_28_012345678 DATETIME, field_29_0123456789 UINT64, field_30_0 INT64, field_31_01 UINT8, field_32_012 INT8, field_33_0123 CHAR, field_34_01234 INT32 ARRAY, field_35_012345 INT32 ARRAY, field_36_0123456 REAL, field_37_01234567 DATE, field_38_012345678 INT8, field_39_0123456789 UINT16, field_40_0 BOOL, field_41_01 RICHREAL, field_42_012 DATETIME ARRAY, field_43_0123 UINT8, field_44_01234 INT32, field_45_012345 INT16)");
      /* 406 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 DATETIME, field_3_0123 REAL ARRAY, field_4_01234 INT64 ARRAY, field_5_012345 UINT8, field_6_0123456 REAL, field_7_01234567 INT8, field_8_012345678 HIRESTIME, field_9_0123456789 INT16, field_10_0 DATETIME, field_11_01 INT32, field_12_012 RICHREAL, field_13_0123 UINT32, field_14_01234 HIRESTIME, field_15_012345 INT8 ARRAY, field_16_0123456 DATETIME, field_17_01234567 HIRESTIME, field_18_012345678 INT64, field_19_0123456789 INT64 ARRAY, field_20_0 CHAR ARRAY, field_21_01 REAL, field_22_012 DATE, field_23_0123 INT8, field_24_01234 INT16, field_25_012345 HIRESTIME, field_26_0123456 CHAR, field_27_01234567 UINT8, field_28_012345678 DATETIME, field_29_0123456789 DATETIME, field_30_0 INT8, field_31_01 DATE, field_32_012 UINT64, field_33_0123 DATE, field_34_01234 INT8, field_35_012345 DATETIME, field_36_0123456 DATE, field_37_01234567 UINT32, field_38_012345678 INT16, field_39_0123456789 INT8, field_40_0 UINT32, field_41_01 INT32, field_42_012 RICHREAL, field_43_0123 INT16, field_44_01234 INT8, field_45_012345 UINT16, field_46_0123456 DATETIME, field_47_01234567 UINT8, field_48_012345678 INT64, field_49_0123456789 REAL, field_50_0 INT64 ARRAY, field_51_01 INT64, field_52_012 UINT16, field_53_0123 UINT32 ARRAY, field_54_01234 UINT8, field_55_012345 UINT64, field_56_0123456 DATETIME ARRAY, field_57_01234567 INT64, field_58_012345678 BOOL, field_59_0123456789 INT8, field_60_0 CHAR, field_61_01 CHAR ARRAY, field_62_012 DATETIME ARRAY, field_63_0123 UINT16, field_64_01234 INT64, field_65_012345 INT16, field_66_0123456 UINT32, field_67_01234567 INT32, field_68_012345678 UINT16 ARRAY, field_69_0123456789 DATE, field_70_0 HIRESTIME ARRAY, field_71_01 DATETIME, field_72_012 DATETIME, field_73_0123 REAL, field_74_01234 BOOL, field_75_012345 BOOL, field_76_0123456 BOOL, field_77_01234567 INT64, field_78_012345678 UINT8 ARRAY, field_79_0123456789 DATETIME, field_80_0 BOOL ARRAY, field_81_01 UINT64, field_82_012 DATE, field_83_0123 UINT16 ARRAY, field_84_01234 INT64, field_85_012345 RICHREAL, field_86_0123456 DATETIME, field_87_01234567 UINT8, field_88_012345678 BOOL ARRAY, field_89_0123456789 UINT32, field_90_0 INT16 ARRAY, field_91_01 CHAR, field_92_012 UINT32, field_93_0123 DATETIME, field_94_01234 HIRESTIME, field_95_012345 UINT32, field_96_0123456 UINT16, field_97_01234567 RICHREAL)");
      /* 407 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 INT8, field_3_0123 INT8 ARRAY, field_4_01234 UINT16, field_5_012345 REAL, field_6_0123456 UINT16, field_7_01234567 REAL, field_8_012345678 UINT64, field_9_0123456789 CHAR ARRAY, field_10_0 UINT32 ARRAY, field_11_01 INT8, field_12_012 UINT32 ARRAY, field_13_0123 DATE, field_14_01234 INT16, field_15_012345 DATE, field_16_0123456 BOOL, field_17_01234567 UINT64, field_18_012345678 CHAR, field_19_0123456789 INT16, field_20_0 HIRESTIME ARRAY, field_21_01 UINT8, field_22_012 UINT16, field_23_0123 INT16 ARRAY, field_24_01234 INT32, field_25_012345 RICHREAL, field_26_0123456 UINT8, field_27_01234567 INT32, field_28_012345678 UINT32, field_29_0123456789 UINT16, field_30_0 INT32, field_31_01 INT32, field_32_012 INT16, field_33_0123 INT32, field_34_01234 RICHREAL, field_35_012345 CHAR, field_36_0123456 CHAR, field_37_01234567 INT64, field_38_012345678 INT64, field_39_0123456789 INT8 ARRAY, field_40_0 INT8 ARRAY, field_41_01 UINT8, field_42_012 INT8 ARRAY, field_43_0123 INT64 ARRAY, field_44_01234 UINT16, field_45_012345 INT16, field_46_0123456 INT64, field_47_01234567 INT32, field_48_012345678 DATETIME, field_49_0123456789 UINT16, field_50_0 REAL ARRAY, field_51_01 UINT16, field_52_012 RICHREAL, field_53_0123 INT32, field_54_01234 DATE ARRAY, field_55_012345 UINT32, field_56_0123456 INT32, field_57_01234567 RICHREAL, field_58_012345678 INT64, field_59_0123456789 UINT16 ARRAY)");
      /* 408 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 DATE, field_3_0123 INT32 ARRAY, field_4_01234 UINT16, field_5_012345 RICHREAL, field_6_0123456 INT16 ARRAY, field_7_01234567 REAL, field_8_012345678 BOOL, field_9_0123456789 BOOL, field_10_0 DATE, field_11_01 HIRESTIME, field_12_012 UINT16 ARRAY, field_13_0123 UINT32, field_14_01234 DATE, field_15_012345 BOOL, field_16_0123456 REAL, field_17_01234567 DATE, field_18_012345678 INT16, field_19_0123456789 UINT32, field_20_0 UINT64 ARRAY, field_21_01 INT16, field_22_012 CHAR ARRAY, field_23_0123 UINT16 ARRAY, field_24_01234 UINT8, field_25_012345 UINT16, field_26_0123456 DATE ARRAY, field_27_01234567 DATE, field_28_012345678 CHAR, field_29_0123456789 UINT64, field_30_0 DATE, field_31_01 RICHREAL, field_32_012 UINT32, field_33_0123 REAL, field_34_01234 REAL, field_35_012345 INT64 ARRAY, field_36_0123456 UINT32, field_37_01234567 INT64 ARRAY, field_38_012345678 INT32, field_39_0123456789 INT16, field_40_0 UINT32, field_41_01 DATE, field_42_012 INT16, field_43_0123 BOOL, field_44_01234 BOOL, field_45_012345 INT8, field_46_0123456 HIRESTIME ARRAY, field_47_01234567 UINT32, field_48_012345678 DATE, field_49_0123456789 CHAR, field_50_0 HIRESTIME ARRAY, field_51_01 UINT16)");
      /* 409 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL ARRAY, field_2_012 DATE ARRAY, field_3_0123 RICHREAL, field_4_01234 RICHREAL, field_5_012345 HIRESTIME, field_6_0123456 UINT32)");
      /* 410 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 HIRESTIME, field_3_0123 UINT16, field_4_01234 BOOL ARRAY, field_5_012345 HIRESTIME ARRAY, field_6_0123456 HIRESTIME, field_7_01234567 HIRESTIME, field_8_012345678 BOOL, field_9_0123456789 INT16 ARRAY, field_10_0 UINT8 ARRAY, field_11_01 BOOL, field_12_012 CHAR, field_13_0123 BOOL, field_14_01234 DATETIME, field_15_012345 UINT64, field_16_0123456 DATETIME, field_17_01234567 DATE ARRAY, field_18_012345678 HIRESTIME, field_19_0123456789 INT32 ARRAY, field_20_0 UINT8 ARRAY, field_21_01 DATETIME, field_22_012 INT8, field_23_0123 INT64 ARRAY, field_24_01234 UINT8, field_25_012345 INT32, field_26_0123456 BOOL, field_27_01234567 DATETIME, field_28_012345678 INT32, field_29_0123456789 UINT32 ARRAY, field_30_0 UINT16, field_31_01 DATE, field_32_012 DATE, field_33_0123 HIRESTIME, field_34_01234 INT64, field_35_012345 INT32, field_36_0123456 RICHREAL, field_37_01234567 UINT64 ARRAY, field_38_012345678 DATE, field_39_0123456789 INT64, field_40_0 UINT32 ARRAY, field_41_01 BOOL ARRAY, field_42_012 UINT8, field_43_0123 CHAR ARRAY, field_44_01234 INT16, field_45_012345 INT32, field_46_0123456 UINT8, field_47_01234567 UINT64, field_48_012345678 UINT64, field_49_0123456789 HIRESTIME, field_50_0 BOOL, field_51_01 BOOL ARRAY, field_52_012 UINT8, field_53_0123 CHAR ARRAY, field_54_01234 REAL, field_55_012345 UINT8, field_56_0123456 DATE, field_57_01234567 RICHREAL, field_58_012345678 INT32, field_59_0123456789 INT32, field_60_0 INT64, field_61_01 INT16, field_62_012 INT32 ARRAY, field_63_0123 DATETIME, field_64_01234 UINT16, field_65_012345 DATE ARRAY, field_66_0123456 INT32 ARRAY, field_67_01234567 HIRESTIME ARRAY, field_68_012345678 BOOL, field_69_0123456789 RICHREAL, field_70_0 HIRESTIME, field_71_01 INT32 ARRAY, field_72_012 UINT32, field_73_0123 UINT8, field_74_01234 INT16, field_75_012345 UINT16 ARRAY, field_76_0123456 HIRESTIME, field_77_01234567 CHAR, field_78_012345678 INT64, field_79_0123456789 DATE, field_80_0 INT32, field_81_01 DATETIME ARRAY, field_82_012 DATE, field_83_0123 BOOL, field_84_01234 DATETIME, field_85_012345 INT64, field_86_0123456 UINT16 ARRAY, field_87_01234567 DATE ARRAY, field_88_012345678 DATE, field_89_0123456789 INT64, field_90_0 UINT32, field_91_01 DATETIME, field_92_012 INT8)");
      /* 411 */ glbTypes.push_back("TABLE(field_1_01 DATE ARRAY, field_2_012 INT64, field_3_0123 DATE)");
      /* 412 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 INT64 ARRAY, field_3_0123 INT32, field_4_01234 CHAR, field_5_012345 HIRESTIME, field_6_0123456 INT32, field_7_01234567 DATE ARRAY, field_8_012345678 RICHREAL, field_9_0123456789 INT64 ARRAY, field_10_0 INT32 ARRAY, field_11_01 BOOL, field_12_012 INT32, field_13_0123 UINT8, field_14_01234 UINT8 ARRAY, field_15_012345 UINT8, field_16_0123456 RICHREAL, field_17_01234567 INT16 ARRAY, field_18_012345678 UINT32, field_19_0123456789 UINT16, field_20_0 DATE ARRAY, field_21_01 UINT64, field_22_012 HIRESTIME ARRAY, field_23_0123 UINT64, field_24_01234 REAL, field_25_012345 CHAR, field_26_0123456 HIRESTIME, field_27_01234567 CHAR, field_28_012345678 INT32, field_29_0123456789 UINT32, field_30_0 INT16, field_31_01 INT32 ARRAY, field_32_012 UINT64, field_33_0123 INT8, field_34_01234 INT16, field_35_012345 INT16, field_36_0123456 REAL ARRAY, field_37_01234567 RICHREAL, field_38_012345678 RICHREAL, field_39_0123456789 INT64, field_40_0 BOOL, field_41_01 INT8, field_42_012 UINT8, field_43_0123 REAL, field_44_01234 DATETIME, field_45_012345 DATETIME, field_46_0123456 UINT64, field_47_01234567 INT16, field_48_012345678 UINT32, field_49_0123456789 REAL, field_50_0 INT64, field_51_01 CHAR, field_52_012 UINT16, field_53_0123 DATE, field_54_01234 RICHREAL, field_55_012345 INT32, field_56_0123456 UINT8, field_57_01234567 UINT8, field_58_012345678 UINT8, field_59_0123456789 INT16, field_60_0 UINT16, field_61_01 HIRESTIME, field_62_012 INT64, field_63_0123 DATETIME, field_64_01234 UINT32, field_65_012345 INT64 ARRAY, field_66_0123456 UINT32, field_67_01234567 DATE ARRAY, field_68_012345678 UINT64, field_69_0123456789 DATETIME, field_70_0 INT8, field_71_01 RICHREAL, field_72_012 INT16, field_73_0123 INT8 ARRAY, field_74_01234 UINT8, field_75_012345 UINT8 ARRAY, field_76_0123456 UINT32, field_77_01234567 INT32, field_78_012345678 BOOL, field_79_0123456789 BOOL)");
      /* 413 */ glbTypes.push_back("TABLE(field_1_01 UINT16 ARRAY, field_2_012 BOOL, field_3_0123 BOOL, field_4_01234 UINT64 ARRAY, field_5_012345 UINT16, field_6_0123456 DATE, field_7_01234567 CHAR ARRAY, field_8_012345678 HIRESTIME, field_9_0123456789 CHAR, field_10_0 UINT64, field_11_01 INT64, field_12_012 DATETIME, field_13_0123 INT8, field_14_01234 INT32 ARRAY, field_15_012345 UINT8, field_16_0123456 INT8, field_17_01234567 INT8, field_18_012345678 UINT8, field_19_0123456789 HIRESTIME, field_20_0 DATETIME, field_21_01 HIRESTIME ARRAY, field_22_012 UINT64 ARRAY, field_23_0123 UINT16 ARRAY, field_24_01234 REAL, field_25_012345 BOOL, field_26_0123456 UINT16, field_27_01234567 RICHREAL, field_28_012345678 INT8 ARRAY, field_29_0123456789 UINT16 ARRAY, field_30_0 CHAR, field_31_01 INT64, field_32_012 DATETIME ARRAY, field_33_0123 REAL, field_34_01234 DATE, field_35_012345 CHAR, field_36_0123456 INT32, field_37_01234567 UINT16 ARRAY, field_38_012345678 UINT32, field_39_0123456789 INT64, field_40_0 REAL, field_41_01 BOOL, field_42_012 CHAR, field_43_0123 RICHREAL, field_44_01234 DATE, field_45_012345 DATETIME ARRAY, field_46_0123456 UINT32, field_47_01234567 BOOL, field_48_012345678 DATETIME, field_49_0123456789 DATETIME, field_50_0 UINT32 ARRAY, field_51_01 CHAR, field_52_012 INT64 ARRAY, field_53_0123 DATETIME, field_54_01234 UINT64, field_55_012345 UINT16, field_56_0123456 INT16 ARRAY, field_57_01234567 INT8, field_58_012345678 UINT64, field_59_0123456789 INT8, field_60_0 INT16 ARRAY, field_61_01 INT64, field_62_012 REAL, field_63_0123 UINT16, field_64_01234 INT64, field_65_012345 UINT16, field_66_0123456 INT8 ARRAY, field_67_01234567 DATE, field_68_012345678 HIRESTIME, field_69_0123456789 DATETIME, field_70_0 INT64, field_71_01 HIRESTIME, field_72_012 INT32, field_73_0123 UINT32 ARRAY, field_74_01234 RICHREAL, field_75_012345 UINT32, field_76_0123456 INT64)");
      /* 414 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 UINT32, field_3_0123 CHAR, field_4_01234 RICHREAL, field_5_012345 BOOL, field_6_0123456 HIRESTIME, field_7_01234567 UINT64, field_8_012345678 UINT32, field_9_0123456789 INT64, field_10_0 RICHREAL, field_11_01 RICHREAL, field_12_012 UINT32, field_13_0123 RICHREAL, field_14_01234 DATE)");
      /* 415 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 INT64, field_3_0123 INT64, field_4_01234 HIRESTIME ARRAY, field_5_012345 UINT16, field_6_0123456 HIRESTIME, field_7_01234567 REAL ARRAY, field_8_012345678 REAL, field_9_0123456789 HIRESTIME, field_10_0 INT64, field_11_01 UINT32 ARRAY, field_12_012 INT8 ARRAY, field_13_0123 HIRESTIME ARRAY, field_14_01234 INT64, field_15_012345 DATETIME ARRAY, field_16_0123456 BOOL ARRAY, field_17_01234567 REAL, field_18_012345678 DATE ARRAY, field_19_0123456789 REAL, field_20_0 UINT64, field_21_01 RICHREAL ARRAY, field_22_012 INT64, field_23_0123 INT32 ARRAY, field_24_01234 INT32, field_25_012345 UINT8, field_26_0123456 BOOL, field_27_01234567 INT32, field_28_012345678 INT8, field_29_0123456789 UINT16, field_30_0 RICHREAL ARRAY, field_31_01 UINT32 ARRAY, field_32_012 REAL, field_33_0123 REAL ARRAY, field_34_01234 CHAR, field_35_012345 CHAR, field_36_0123456 HIRESTIME, field_37_01234567 UINT16, field_38_012345678 REAL, field_39_0123456789 UINT16, field_40_0 UINT8, field_41_01 CHAR ARRAY, field_42_012 INT8 ARRAY, field_43_0123 HIRESTIME, field_44_01234 UINT32, field_45_012345 DATE, field_46_0123456 UINT32 ARRAY, field_47_01234567 RICHREAL, field_48_012345678 INT8, field_49_0123456789 RICHREAL, field_50_0 DATE, field_51_01 HIRESTIME, field_52_012 DATETIME, field_53_0123 INT32, field_54_01234 INT8 ARRAY, field_55_012345 UINT32, field_56_0123456 DATE, field_57_01234567 INT32, field_58_012345678 INT8, field_59_0123456789 HIRESTIME, field_60_0 INT64, field_61_01 BOOL, field_62_012 BOOL, field_63_0123 RICHREAL ARRAY, field_64_01234 BOOL, field_65_012345 HIRESTIME, field_66_0123456 INT64, field_67_01234567 INT8, field_68_012345678 BOOL, field_69_0123456789 RICHREAL, field_70_0 INT32, field_71_01 INT16, field_72_012 INT8 ARRAY, field_73_0123 DATETIME, field_74_01234 DATE, field_75_012345 BOOL ARRAY, field_76_0123456 UINT16 ARRAY, field_77_01234567 INT8, field_78_012345678 REAL, field_79_0123456789 DATE ARRAY, field_80_0 RICHREAL ARRAY, field_81_01 REAL ARRAY, field_82_012 DATE, field_83_0123 UINT16, field_84_01234 INT32, field_85_012345 RICHREAL, field_86_0123456 UINT32, field_87_01234567 INT8, field_88_012345678 INT16, field_89_0123456789 BOOL, field_90_0 REAL ARRAY, field_91_01 BOOL, field_92_012 UINT8 ARRAY, field_93_0123 REAL)");
      /* 416 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 UINT64, field_3_0123 UINT32, field_4_01234 INT16, field_5_012345 INT16, field_6_0123456 UINT32, field_7_01234567 RICHREAL)");
      /* 417 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL ARRAY, field_2_012 INT8, field_3_0123 DATETIME, field_4_01234 DATE, field_5_012345 BOOL ARRAY, field_6_0123456 INT64, field_7_01234567 INT16, field_8_012345678 INT64 ARRAY, field_9_0123456789 UINT64 ARRAY, field_10_0 INT32 ARRAY, field_11_01 INT8, field_12_012 INT8, field_13_0123 UINT64, field_14_01234 UINT32, field_15_012345 REAL, field_16_0123456 UINT8, field_17_01234567 INT8 ARRAY, field_18_012345678 HIRESTIME, field_19_0123456789 DATE, field_20_0 CHAR, field_21_01 UINT64)");
      /* 418 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 UINT8, field_3_0123 DATE, field_4_01234 DATE, field_5_012345 INT16, field_6_0123456 UINT8, field_7_01234567 INT32, field_8_012345678 INT8, field_9_0123456789 INT8, field_10_0 UINT8, field_11_01 INT16, field_12_012 UINT64, field_13_0123 INT32, field_14_01234 DATE, field_15_012345 UINT8, field_16_0123456 CHAR, field_17_01234567 INT64, field_18_012345678 INT64, field_19_0123456789 UINT32, field_20_0 CHAR, field_21_01 INT8, field_22_012 INT16, field_23_0123 DATE, field_24_01234 INT8, field_25_012345 UINT32 ARRAY, field_26_0123456 UINT64, field_27_01234567 UINT16, field_28_012345678 DATE ARRAY, field_29_0123456789 INT32 ARRAY, field_30_0 UINT64, field_31_01 INT32, field_32_012 BOOL, field_33_0123 INT64, field_34_01234 UINT16, field_35_012345 HIRESTIME, field_36_0123456 UINT8 ARRAY, field_37_01234567 DATETIME ARRAY, field_38_012345678 UINT8, field_39_0123456789 INT16, field_40_0 INT64, field_41_01 INT64 ARRAY, field_42_012 UINT8, field_43_0123 DATE ARRAY, field_44_01234 INT8, field_45_012345 INT8, field_46_0123456 BOOL, field_47_01234567 REAL, field_48_012345678 DATETIME, field_49_0123456789 UINT32, field_50_0 HIRESTIME, field_51_01 CHAR ARRAY, field_52_012 INT16, field_53_0123 INT64, field_54_01234 INT16, field_55_012345 INT8, field_56_0123456 CHAR, field_57_01234567 BOOL, field_58_012345678 BOOL, field_59_0123456789 BOOL, field_60_0 INT32, field_61_01 INT8)");
      /* 419 */ glbTypes.push_back("TABLE(field_1_01 CHAR ARRAY, field_2_012 DATETIME, field_3_0123 INT64, field_4_01234 INT16, field_5_012345 HIRESTIME, field_6_0123456 DATE, field_7_01234567 INT16, field_8_012345678 UINT32, field_9_0123456789 BOOL, field_10_0 INT8, field_11_01 BOOL, field_12_012 INT32 ARRAY, field_13_0123 INT32, field_14_01234 BOOL, field_15_012345 HIRESTIME, field_16_0123456 INT32, field_17_01234567 RICHREAL, field_18_012345678 INT64 ARRAY, field_19_0123456789 UINT8 ARRAY, field_20_0 INT16, field_21_01 INT32, field_22_012 CHAR, field_23_0123 CHAR, field_24_01234 CHAR, field_25_012345 UINT16, field_26_0123456 UINT8 ARRAY, field_27_01234567 CHAR, field_28_012345678 RICHREAL, field_29_0123456789 INT16, field_30_0 DATETIME, field_31_01 INT64 ARRAY, field_32_012 UINT8, field_33_0123 DATETIME, field_34_01234 CHAR, field_35_012345 DATETIME, field_36_0123456 BOOL, field_37_01234567 CHAR, field_38_012345678 HIRESTIME, field_39_0123456789 INT16, field_40_0 UINT64, field_41_01 CHAR, field_42_012 CHAR, field_43_0123 UINT8, field_44_01234 UINT32, field_45_012345 UINT32, field_46_0123456 CHAR, field_47_01234567 CHAR, field_48_012345678 HIRESTIME, field_49_0123456789 UINT64, field_50_0 INT32 ARRAY, field_51_01 DATETIME, field_52_012 REAL, field_53_0123 UINT8, field_54_01234 UINT16, field_55_012345 REAL, field_56_0123456 BOOL, field_57_01234567 UINT64, field_58_012345678 INT32, field_59_0123456789 INT16, field_60_0 BOOL ARRAY, field_61_01 INT16, field_62_012 REAL, field_63_0123 BOOL ARRAY, field_64_01234 UINT64, field_65_012345 REAL, field_66_0123456 DATETIME, field_67_01234567 HIRESTIME ARRAY, field_68_012345678 UINT64, field_69_0123456789 INT64, field_70_0 INT64, field_71_01 RICHREAL, field_72_012 INT16, field_73_0123 UINT16, field_74_01234 UINT32, field_75_012345 INT32, field_76_0123456 DATETIME, field_77_01234567 BOOL, field_78_012345678 UINT32, field_79_0123456789 UINT8, field_80_0 INT32 ARRAY, field_81_01 UINT16, field_82_012 INT32)");
      /* 420 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 DATE ARRAY, field_3_0123 UINT8, field_4_01234 INT32, field_5_012345 UINT16, field_6_0123456 UINT8, field_7_01234567 INT32 ARRAY, field_8_012345678 CHAR, field_9_0123456789 UINT16, field_10_0 INT16, field_11_01 DATETIME ARRAY, field_12_012 REAL, field_13_0123 INT32, field_14_01234 DATETIME ARRAY, field_15_012345 INT64 ARRAY, field_16_0123456 DATETIME, field_17_01234567 REAL, field_18_012345678 CHAR, field_19_0123456789 UINT64 ARRAY, field_20_0 HIRESTIME, field_21_01 CHAR, field_22_012 BOOL, field_23_0123 UINT8, field_24_01234 INT64 ARRAY, field_25_012345 RICHREAL, field_26_0123456 INT8 ARRAY, field_27_01234567 DATE, field_28_012345678 DATE, field_29_0123456789 REAL ARRAY, field_30_0 DATETIME, field_31_01 UINT32, field_32_012 INT8, field_33_0123 UINT16, field_34_01234 INT64, field_35_012345 CHAR ARRAY, field_36_0123456 RICHREAL, field_37_01234567 UINT32, field_38_012345678 INT8, field_39_0123456789 HIRESTIME, field_40_0 CHAR, field_41_01 DATETIME ARRAY, field_42_012 BOOL ARRAY, field_43_0123 UINT32, field_44_01234 HIRESTIME, field_45_012345 RICHREAL, field_46_0123456 UINT32 ARRAY, field_47_01234567 UINT64, field_48_012345678 UINT8, field_49_0123456789 RICHREAL, field_50_0 INT32, field_51_01 HIRESTIME ARRAY, field_52_012 UINT16, field_53_0123 UINT8, field_54_01234 UINT16, field_55_012345 UINT32 ARRAY, field_56_0123456 UINT32, field_57_01234567 UINT8, field_58_012345678 RICHREAL, field_59_0123456789 UINT32, field_60_0 DATE, field_61_01 UINT64, field_62_012 UINT16, field_63_0123 DATE ARRAY, field_64_01234 INT64 ARRAY, field_65_012345 DATETIME, field_66_0123456 RICHREAL, field_67_01234567 DATE)");
      /* 421 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 UINT32, field_3_0123 UINT32, field_4_01234 UINT8, field_5_012345 REAL, field_6_0123456 REAL, field_7_01234567 REAL, field_8_012345678 INT32, field_9_0123456789 INT16, field_10_0 DATE, field_11_01 INT8, field_12_012 CHAR ARRAY, field_13_0123 INT32, field_14_01234 DATETIME, field_15_012345 INT64, field_16_0123456 BOOL, field_17_01234567 UINT64, field_18_012345678 BOOL, field_19_0123456789 INT32, field_20_0 BOOL ARRAY, field_21_01 UINT32, field_22_012 BOOL, field_23_0123 INT64, field_24_01234 INT16, field_25_012345 INT16 ARRAY, field_26_0123456 INT64 ARRAY, field_27_01234567 REAL, field_28_012345678 UINT64, field_29_0123456789 BOOL, field_30_0 DATE, field_31_01 INT8, field_32_012 INT16, field_33_0123 INT64 ARRAY, field_34_01234 INT32, field_35_012345 INT32, field_36_0123456 REAL, field_37_01234567 DATE, field_38_012345678 UINT64, field_39_0123456789 CHAR, field_40_0 UINT8, field_41_01 INT64 ARRAY, field_42_012 UINT64, field_43_0123 UINT16, field_44_01234 DATETIME, field_45_012345 INT32, field_46_0123456 INT16, field_47_01234567 UINT8, field_48_012345678 UINT16 ARRAY, field_49_0123456789 UINT32, field_50_0 UINT32, field_51_01 INT16, field_52_012 INT16, field_53_0123 DATETIME, field_54_01234 INT16, field_55_012345 RICHREAL, field_56_0123456 INT64, field_57_01234567 BOOL, field_58_012345678 BOOL ARRAY, field_59_0123456789 DATETIME, field_60_0 BOOL, field_61_01 DATE, field_62_012 UINT32 ARRAY, field_63_0123 UINT16 ARRAY, field_64_01234 INT64 ARRAY, field_65_012345 HIRESTIME, field_66_0123456 DATE ARRAY, field_67_01234567 DATETIME ARRAY, field_68_012345678 UINT32, field_69_0123456789 UINT32, field_70_0 UINT8 ARRAY, field_71_01 INT16, field_72_012 CHAR, field_73_0123 UINT32, field_74_01234 UINT8, field_75_012345 HIRESTIME, field_76_0123456 INT8, field_77_01234567 RICHREAL, field_78_012345678 DATETIME)");
      /* 422 */ glbTypes.push_back("TABLE(field_1_01 UINT16 ARRAY, field_2_012 DATETIME ARRAY, field_3_0123 UINT16, field_4_01234 HIRESTIME, field_5_012345 REAL, field_6_0123456 INT32, field_7_01234567 UINT32, field_8_012345678 INT32, field_9_0123456789 DATETIME, field_10_0 UINT8 ARRAY, field_11_01 UINT64, field_12_012 UINT32, field_13_0123 UINT16 ARRAY, field_14_01234 CHAR, field_15_012345 INT8, field_16_0123456 UINT8, field_17_01234567 INT64, field_18_012345678 INT8, field_19_0123456789 UINT8, field_20_0 CHAR, field_21_01 INT16 ARRAY, field_22_012 DATETIME, field_23_0123 INT32, field_24_01234 INT64 ARRAY, field_25_012345 UINT16 ARRAY, field_26_0123456 REAL, field_27_01234567 UINT8 ARRAY, field_28_012345678 DATE, field_29_0123456789 INT16, field_30_0 BOOL, field_31_01 UINT32 ARRAY, field_32_012 UINT8, field_33_0123 BOOL, field_34_01234 RICHREAL, field_35_012345 INT32 ARRAY, field_36_0123456 UINT8, field_37_01234567 DATE, field_38_012345678 REAL, field_39_0123456789 INT8, field_40_0 INT32 ARRAY, field_41_01 UINT16 ARRAY, field_42_012 UINT8 ARRAY, field_43_0123 INT32, field_44_01234 UINT16 ARRAY, field_45_012345 RICHREAL, field_46_0123456 DATETIME ARRAY, field_47_01234567 UINT16, field_48_012345678 INT8 ARRAY, field_49_0123456789 REAL ARRAY, field_50_0 INT16, field_51_01 BOOL, field_52_012 INT32, field_53_0123 INT8, field_54_01234 INT32, field_55_012345 CHAR ARRAY, field_56_0123456 DATE, field_57_01234567 REAL, field_58_012345678 DATE, field_59_0123456789 BOOL, field_60_0 UINT64, field_61_01 UINT32, field_62_012 DATE, field_63_0123 UINT32, field_64_01234 REAL, field_65_012345 UINT16, field_66_0123456 INT32, field_67_01234567 DATETIME, field_68_012345678 UINT32 ARRAY, field_69_0123456789 INT8 ARRAY, field_70_0 DATE, field_71_01 UINT32 ARRAY, field_72_012 BOOL, field_73_0123 INT64, field_74_01234 UINT8, field_75_012345 UINT8, field_76_0123456 INT64, field_77_01234567 DATE, field_78_012345678 HIRESTIME, field_79_0123456789 INT16, field_80_0 INT32 ARRAY, field_81_01 UINT64, field_82_012 HIRESTIME, field_83_0123 INT8, field_84_01234 DATE)");
      /* 423 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 UINT16, field_3_0123 UINT32, field_4_01234 CHAR, field_5_012345 INT64, field_6_0123456 UINT64, field_7_01234567 INT16, field_8_012345678 RICHREAL, field_9_0123456789 BOOL, field_10_0 UINT16, field_11_01 INT32, field_12_012 REAL, field_13_0123 RICHREAL, field_14_01234 DATETIME, field_15_012345 DATETIME, field_16_0123456 INT8, field_17_01234567 UINT32 ARRAY, field_18_012345678 DATE, field_19_0123456789 INT16, field_20_0 INT8, field_21_01 INT64, field_22_012 DATETIME, field_23_0123 INT64, field_24_01234 UINT16, field_25_012345 CHAR, field_26_0123456 DATE ARRAY, field_27_01234567 INT64, field_28_012345678 INT64, field_29_0123456789 RICHREAL, field_30_0 DATETIME)");
      /* 424 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 CHAR, field_3_0123 RICHREAL, field_4_01234 RICHREAL, field_5_012345 CHAR, field_6_0123456 INT16, field_7_01234567 UINT64, field_8_012345678 HIRESTIME, field_9_0123456789 DATETIME, field_10_0 DATETIME ARRAY, field_11_01 BOOL, field_12_012 UINT64, field_13_0123 INT32, field_14_01234 HIRESTIME ARRAY, field_15_012345 REAL, field_16_0123456 DATE, field_17_01234567 INT64, field_18_012345678 HIRESTIME ARRAY, field_19_0123456789 UINT64, field_20_0 UINT8, field_21_01 DATETIME, field_22_012 DATETIME ARRAY, field_23_0123 UINT64 ARRAY, field_24_01234 DATE, field_25_012345 UINT16, field_26_0123456 HIRESTIME, field_27_01234567 INT64)");
      /* 425 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 REAL, field_3_0123 HIRESTIME, field_4_01234 REAL ARRAY, field_5_012345 HIRESTIME ARRAY, field_6_0123456 UINT32, field_7_01234567 INT8, field_8_012345678 INT32 ARRAY, field_9_0123456789 INT8, field_10_0 CHAR ARRAY, field_11_01 BOOL, field_12_012 UINT8, field_13_0123 BOOL, field_14_01234 UINT32 ARRAY, field_15_012345 UINT32, field_16_0123456 UINT8, field_17_01234567 DATE, field_18_012345678 UINT32, field_19_0123456789 RICHREAL, field_20_0 UINT64, field_21_01 UINT64, field_22_012 INT8, field_23_0123 INT64 ARRAY, field_24_01234 DATETIME, field_25_012345 UINT32, field_26_0123456 HIRESTIME)");
      /* 426 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 INT64, field_3_0123 INT32 ARRAY, field_4_01234 DATE ARRAY, field_5_012345 REAL, field_6_0123456 INT8 ARRAY, field_7_01234567 DATE, field_8_012345678 UINT64, field_9_0123456789 DATE ARRAY, field_10_0 UINT8, field_11_01 BOOL, field_12_012 INT16 ARRAY, field_13_0123 RICHREAL, field_14_01234 REAL, field_15_012345 RICHREAL, field_16_0123456 INT8, field_17_01234567 DATETIME ARRAY, field_18_012345678 UINT8, field_19_0123456789 UINT16, field_20_0 BOOL ARRAY, field_21_01 HIRESTIME, field_22_012 UINT64, field_23_0123 HIRESTIME, field_24_01234 INT16, field_25_012345 INT32, field_26_0123456 INT32, field_27_01234567 CHAR, field_28_012345678 RICHREAL, field_29_0123456789 HIRESTIME, field_30_0 INT8, field_31_01 INT64, field_32_012 HIRESTIME ARRAY, field_33_0123 INT32 ARRAY, field_34_01234 BOOL, field_35_012345 BOOL, field_36_0123456 INT16, field_37_01234567 CHAR, field_38_012345678 INT64, field_39_0123456789 UINT8, field_40_0 INT8, field_41_01 DATETIME, field_42_012 DATE, field_43_0123 UINT32, field_44_01234 BOOL, field_45_012345 UINT8, field_46_0123456 INT64, field_47_01234567 RICHREAL, field_48_012345678 INT64 ARRAY, field_49_0123456789 RICHREAL, field_50_0 UINT16, field_51_01 DATETIME, field_52_012 BOOL, field_53_0123 RICHREAL, field_54_01234 DATETIME, field_55_012345 INT64, field_56_0123456 CHAR ARRAY, field_57_01234567 CHAR, field_58_012345678 INT32, field_59_0123456789 REAL, field_60_0 DATE, field_61_01 UINT8, field_62_012 HIRESTIME, field_63_0123 DATETIME, field_64_01234 DATETIME, field_65_012345 UINT32, field_66_0123456 UINT32, field_67_01234567 INT64, field_68_012345678 INT64, field_69_0123456789 HIRESTIME, field_70_0 UINT64, field_71_01 REAL ARRAY, field_72_012 REAL, field_73_0123 HIRESTIME, field_74_01234 UINT32 ARRAY, field_75_012345 INT64 ARRAY, field_76_0123456 HIRESTIME, field_77_01234567 REAL, field_78_012345678 CHAR ARRAY)");
      /* 427 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 INT8 ARRAY, field_3_0123 UINT8, field_4_01234 CHAR, field_5_012345 REAL, field_6_0123456 BOOL, field_7_01234567 REAL, field_8_012345678 HIRESTIME, field_9_0123456789 UINT32 ARRAY, field_10_0 UINT32, field_11_01 INT64, field_12_012 UINT64, field_13_0123 REAL, field_14_01234 CHAR, field_15_012345 BOOL ARRAY, field_16_0123456 UINT32, field_17_01234567 RICHREAL, field_18_012345678 CHAR, field_19_0123456789 INT16 ARRAY, field_20_0 INT16, field_21_01 HIRESTIME, field_22_012 HIRESTIME, field_23_0123 CHAR, field_24_01234 CHAR, field_25_012345 INT8 ARRAY, field_26_0123456 INT8, field_27_01234567 CHAR, field_28_012345678 INT16, field_29_0123456789 INT64, field_30_0 DATE, field_31_01 INT8, field_32_012 UINT32 ARRAY, field_33_0123 HIRESTIME, field_34_01234 UINT8, field_35_012345 UINT16, field_36_0123456 UINT32, field_37_01234567 CHAR, field_38_012345678 REAL, field_39_0123456789 UINT16, field_40_0 BOOL, field_41_01 BOOL ARRAY, field_42_012 UINT16 ARRAY, field_43_0123 INT64 ARRAY, field_44_01234 UINT32, field_45_012345 UINT8 ARRAY, field_46_0123456 UINT8 ARRAY, field_47_01234567 CHAR, field_48_012345678 INT64 ARRAY, field_49_0123456789 BOOL, field_50_0 UINT16, field_51_01 INT64, field_52_012 UINT32 ARRAY, field_53_0123 RICHREAL, field_54_01234 DATE, field_55_012345 BOOL, field_56_0123456 INT32 ARRAY, field_57_01234567 REAL, field_58_012345678 INT8 ARRAY, field_59_0123456789 CHAR, field_60_0 CHAR, field_61_01 INT64, field_62_012 BOOL, field_63_0123 DATETIME ARRAY, field_64_01234 INT32, field_65_012345 INT32, field_66_0123456 UINT8, field_67_01234567 UINT32, field_68_012345678 INT64, field_69_0123456789 UINT16, field_70_0 INT32, field_71_01 INT32, field_72_012 UINT8, field_73_0123 INT8, field_74_01234 UINT32 ARRAY, field_75_012345 DATE, field_76_0123456 BOOL ARRAY, field_77_01234567 INT8, field_78_012345678 REAL, field_79_0123456789 UINT32, field_80_0 CHAR, field_81_01 RICHREAL, field_82_012 INT64, field_83_0123 RICHREAL, field_84_01234 CHAR, field_85_012345 HIRESTIME, field_86_0123456 CHAR, field_87_01234567 BOOL, field_88_012345678 INT32, field_89_0123456789 UINT64, field_90_0 RICHREAL ARRAY, field_91_01 BOOL, field_92_012 INT64, field_93_0123 BOOL)");
      /* 428 */ glbTypes.push_back("TABLE(field_1_01 INT8 ARRAY, field_2_012 DATE, field_3_0123 CHAR, field_4_01234 INT8, field_5_012345 UINT16, field_6_0123456 UINT64, field_7_01234567 DATE, field_8_012345678 DATE, field_9_0123456789 UINT32, field_10_0 INT32, field_11_01 DATE ARRAY, field_12_012 INT32, field_13_0123 INT16, field_14_01234 INT32, field_15_012345 INT8, field_16_0123456 INT16, field_17_01234567 DATE, field_18_012345678 INT32, field_19_0123456789 REAL, field_20_0 CHAR ARRAY, field_21_01 HIRESTIME, field_22_012 CHAR ARRAY, field_23_0123 UINT64, field_24_01234 RICHREAL, field_25_012345 UINT32, field_26_0123456 UINT8)");
      /* 429 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 INT32, field_3_0123 INT64, field_4_01234 DATETIME ARRAY, field_5_012345 INT8, field_6_0123456 BOOL, field_7_01234567 DATE, field_8_012345678 DATE, field_9_0123456789 INT32, field_10_0 INT32, field_11_01 INT8 ARRAY, field_12_012 INT16, field_13_0123 INT8, field_14_01234 UINT32, field_15_012345 UINT8, field_16_0123456 REAL, field_17_01234567 REAL, field_18_012345678 RICHREAL, field_19_0123456789 INT8, field_20_0 UINT8, field_21_01 UINT8, field_22_012 INT8, field_23_0123 DATE, field_24_01234 BOOL, field_25_012345 UINT16, field_26_0123456 HIRESTIME, field_27_01234567 REAL, field_28_012345678 DATETIME, field_29_0123456789 UINT8, field_30_0 UINT8, field_31_01 UINT16, field_32_012 INT64 ARRAY, field_33_0123 INT32, field_34_01234 UINT32 ARRAY, field_35_012345 RICHREAL, field_36_0123456 UINT16 ARRAY, field_37_01234567 DATE ARRAY, field_38_012345678 DATETIME, field_39_0123456789 INT32, field_40_0 UINT64, field_41_01 BOOL, field_42_012 UINT8)");
      /* 430 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 INT64, field_3_0123 DATE, field_4_01234 DATETIME, field_5_012345 BOOL, field_6_0123456 HIRESTIME, field_7_01234567 RICHREAL, field_8_012345678 INT32, field_9_0123456789 INT8, field_10_0 DATETIME, field_11_01 DATETIME, field_12_012 CHAR, field_13_0123 CHAR, field_14_01234 UINT8 ARRAY, field_15_012345 UINT64, field_16_0123456 INT32, field_17_01234567 HIRESTIME, field_18_012345678 INT16, field_19_0123456789 DATE, field_20_0 DATETIME, field_21_01 HIRESTIME, field_22_012 HIRESTIME, field_23_0123 DATE, field_24_01234 INT32, field_25_012345 INT16, field_26_0123456 DATETIME, field_27_01234567 DATETIME ARRAY, field_28_012345678 INT32 ARRAY, field_29_0123456789 DATETIME, field_30_0 UINT8 ARRAY, field_31_01 REAL, field_32_012 DATETIME ARRAY, field_33_0123 BOOL, field_34_01234 INT8, field_35_012345 DATETIME, field_36_0123456 DATE, field_37_01234567 UINT16, field_38_012345678 INT64, field_39_0123456789 INT8, field_40_0 UINT64, field_41_01 REAL ARRAY, field_42_012 HIRESTIME, field_43_0123 DATE, field_44_01234 INT8, field_45_012345 RICHREAL ARRAY, field_46_0123456 UINT8, field_47_01234567 CHAR)");
      /* 431 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 DATETIME, field_3_0123 INT16 ARRAY, field_4_01234 BOOL ARRAY, field_5_012345 UINT32, field_6_0123456 DATETIME, field_7_01234567 UINT8, field_8_012345678 INT32, field_9_0123456789 INT64, field_10_0 UINT32, field_11_01 RICHREAL ARRAY, field_12_012 INT16 ARRAY, field_13_0123 UINT32 ARRAY, field_14_01234 UINT32, field_15_012345 UINT16 ARRAY, field_16_0123456 INT64 ARRAY, field_17_01234567 INT64, field_18_012345678 DATETIME, field_19_0123456789 DATE, field_20_0 INT64, field_21_01 RICHREAL ARRAY, field_22_012 INT8, field_23_0123 UINT16, field_24_01234 CHAR, field_25_012345 HIRESTIME ARRAY, field_26_0123456 REAL, field_27_01234567 INT16, field_28_012345678 INT8, field_29_0123456789 CHAR, field_30_0 UINT32, field_31_01 UINT64, field_32_012 BOOL, field_33_0123 INT32, field_34_01234 REAL ARRAY, field_35_012345 INT8, field_36_0123456 UINT16, field_37_01234567 REAL, field_38_012345678 RICHREAL, field_39_0123456789 BOOL, field_40_0 INT16, field_41_01 UINT16, field_42_012 INT64, field_43_0123 RICHREAL, field_44_01234 REAL, field_45_012345 INT32, field_46_0123456 DATETIME ARRAY, field_47_01234567 BOOL, field_48_012345678 INT64 ARRAY, field_49_0123456789 DATE, field_50_0 CHAR, field_51_01 UINT64, field_52_012 UINT8, field_53_0123 HIRESTIME, field_54_01234 BOOL)");
      /* 432 */ glbTypes.push_back("TABLE(field_1_01 INT64 ARRAY, field_2_012 INT8, field_3_0123 INT8, field_4_01234 UINT64, field_5_012345 INT8, field_6_0123456 HIRESTIME, field_7_01234567 INT32 ARRAY, field_8_012345678 UINT32, field_9_0123456789 REAL, field_10_0 UINT8)");
      /* 433 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 DATETIME, field_3_0123 HIRESTIME, field_4_01234 DATETIME, field_5_012345 REAL, field_6_0123456 INT16, field_7_01234567 INT64, field_8_012345678 HIRESTIME, field_9_0123456789 INT32, field_10_0 INT16, field_11_01 DATE ARRAY, field_12_012 INT64, field_13_0123 DATETIME, field_14_01234 BOOL, field_15_012345 CHAR, field_16_0123456 DATETIME, field_17_01234567 CHAR, field_18_012345678 REAL, field_19_0123456789 UINT16, field_20_0 INT32, field_21_01 DATETIME, field_22_012 INT8 ARRAY, field_23_0123 HIRESTIME, field_24_01234 INT64, field_25_012345 DATETIME, field_26_0123456 INT32, field_27_01234567 DATE, field_28_012345678 DATETIME ARRAY, field_29_0123456789 CHAR, field_30_0 UINT16 ARRAY, field_31_01 CHAR ARRAY, field_32_012 INT32, field_33_0123 UINT32, field_34_01234 CHAR, field_35_012345 DATETIME, field_36_0123456 DATETIME, field_37_01234567 UINT64, field_38_012345678 UINT64, field_39_0123456789 RICHREAL ARRAY, field_40_0 INT16, field_41_01 DATETIME, field_42_012 BOOL, field_43_0123 CHAR, field_44_01234 INT16, field_45_012345 UINT8, field_46_0123456 RICHREAL ARRAY, field_47_01234567 INT32, field_48_012345678 INT32, field_49_0123456789 RICHREAL, field_50_0 HIRESTIME, field_51_01 UINT64, field_52_012 INT64, field_53_0123 UINT64, field_54_01234 BOOL, field_55_012345 INT64, field_56_0123456 UINT8, field_57_01234567 INT64, field_58_012345678 UINT32, field_59_0123456789 INT64 ARRAY, field_60_0 CHAR, field_61_01 REAL)");
      /* 434 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 UINT16 ARRAY, field_3_0123 INT16, field_4_01234 INT16 ARRAY, field_5_012345 REAL, field_6_0123456 DATE ARRAY, field_7_01234567 INT8 ARRAY, field_8_012345678 UINT16, field_9_0123456789 UINT8 ARRAY, field_10_0 HIRESTIME, field_11_01 UINT32, field_12_012 UINT32, field_13_0123 CHAR, field_14_01234 UINT16 ARRAY, field_15_012345 DATETIME ARRAY, field_16_0123456 INT32, field_17_01234567 RICHREAL, field_18_012345678 DATE ARRAY, field_19_0123456789 UINT64, field_20_0 BOOL, field_21_01 REAL, field_22_012 DATE, field_23_0123 DATETIME, field_24_01234 INT16, field_25_012345 HIRESTIME ARRAY, field_26_0123456 UINT32, field_27_01234567 INT64, field_28_012345678 UINT64, field_29_0123456789 REAL, field_30_0 DATE, field_31_01 DATETIME, field_32_012 UINT32, field_33_0123 UINT64 ARRAY, field_34_01234 UINT8, field_35_012345 UINT16 ARRAY, field_36_0123456 UINT32, field_37_01234567 INT16, field_38_012345678 HIRESTIME, field_39_0123456789 INT64, field_40_0 INT16, field_41_01 BOOL, field_42_012 BOOL, field_43_0123 INT8, field_44_01234 CHAR, field_45_012345 UINT32, field_46_0123456 DATE, field_47_01234567 INT8 ARRAY, field_48_012345678 DATETIME, field_49_0123456789 REAL, field_50_0 INT32, field_51_01 UINT16, field_52_012 UINT32, field_53_0123 UINT8, field_54_01234 INT64 ARRAY, field_55_012345 RICHREAL, field_56_0123456 RICHREAL)");
      /* 435 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 UINT16, field_3_0123 DATETIME, field_4_01234 INT64, field_5_012345 INT64, field_6_0123456 UINT8, field_7_01234567 HIRESTIME ARRAY, field_8_012345678 INT32, field_9_0123456789 INT64, field_10_0 UINT8 ARRAY, field_11_01 DATETIME, field_12_012 INT64, field_13_0123 INT32 ARRAY, field_14_01234 UINT32 ARRAY, field_15_012345 UINT32 ARRAY, field_16_0123456 INT32, field_17_01234567 INT8, field_18_012345678 DATETIME, field_19_0123456789 BOOL, field_20_0 UINT16, field_21_01 INT32, field_22_012 RICHREAL, field_23_0123 DATE ARRAY, field_24_01234 INT16, field_25_012345 RICHREAL, field_26_0123456 INT64, field_27_01234567 UINT16 ARRAY, field_28_012345678 INT64, field_29_0123456789 INT16, field_30_0 INT16, field_31_01 INT32 ARRAY, field_32_012 CHAR, field_33_0123 INT32, field_34_01234 REAL, field_35_012345 RICHREAL, field_36_0123456 REAL, field_37_01234567 DATE ARRAY, field_38_012345678 UINT16, field_39_0123456789 BOOL, field_40_0 RICHREAL, field_41_01 INT16 ARRAY, field_42_012 INT32 ARRAY, field_43_0123 INT32, field_44_01234 INT64 ARRAY, field_45_012345 UINT32, field_46_0123456 DATETIME, field_47_01234567 DATE, field_48_012345678 INT8 ARRAY, field_49_0123456789 DATE, field_50_0 BOOL ARRAY, field_51_01 INT32, field_52_012 INT8, field_53_0123 INT64 ARRAY, field_54_01234 BOOL ARRAY, field_55_012345 UINT32, field_56_0123456 INT8, field_57_01234567 DATE, field_58_012345678 RICHREAL, field_59_0123456789 INT16, field_60_0 UINT32, field_61_01 HIRESTIME ARRAY, field_62_012 UINT8 ARRAY, field_63_0123 BOOL ARRAY, field_64_01234 UINT16 ARRAY)");
      /* 436 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 INT64, field_3_0123 INT8, field_4_01234 UINT64 ARRAY, field_5_012345 UINT64, field_6_0123456 INT64, field_7_01234567 REAL, field_8_012345678 DATETIME, field_9_0123456789 UINT8, field_10_0 DATETIME, field_11_01 DATE, field_12_012 DATETIME, field_13_0123 INT64, field_14_01234 UINT64 ARRAY, field_15_012345 UINT8 ARRAY, field_16_0123456 RICHREAL, field_17_01234567 RICHREAL, field_18_012345678 HIRESTIME, field_19_0123456789 RICHREAL, field_20_0 DATETIME, field_21_01 UINT16 ARRAY, field_22_012 CHAR ARRAY, field_23_0123 INT16 ARRAY, field_24_01234 INT64, field_25_012345 BOOL, field_26_0123456 UINT64, field_27_01234567 BOOL, field_28_012345678 REAL, field_29_0123456789 DATETIME, field_30_0 INT64 ARRAY, field_31_01 UINT32, field_32_012 UINT8, field_33_0123 DATETIME, field_34_01234 DATE, field_35_012345 UINT64, field_36_0123456 HIRESTIME, field_37_01234567 REAL, field_38_012345678 INT16, field_39_0123456789 INT64, field_40_0 CHAR, field_41_01 DATETIME, field_42_012 INT64, field_43_0123 INT32, field_44_01234 REAL, field_45_012345 UINT32, field_46_0123456 REAL ARRAY)");
      /* 437 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 UINT32 ARRAY, field_3_0123 INT16, field_4_01234 UINT8 ARRAY, field_5_012345 RICHREAL, field_6_0123456 INT64, field_7_01234567 RICHREAL, field_8_012345678 INT16, field_9_0123456789 UINT8, field_10_0 CHAR)");
      /* 438 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 INT32 ARRAY, field_3_0123 UINT8, field_4_01234 DATETIME, field_5_012345 UINT16, field_6_0123456 UINT16, field_7_01234567 HIRESTIME, field_8_012345678 RICHREAL, field_9_0123456789 REAL, field_10_0 INT32, field_11_01 HIRESTIME, field_12_012 DATETIME, field_13_0123 UINT16, field_14_01234 INT8, field_15_012345 CHAR, field_16_0123456 BOOL ARRAY, field_17_01234567 CHAR)");
      /* 439 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 INT32, field_3_0123 INT32, field_4_01234 UINT32 ARRAY, field_5_012345 UINT16, field_6_0123456 CHAR, field_7_01234567 UINT16, field_8_012345678 DATETIME, field_9_0123456789 DATE, field_10_0 DATE ARRAY, field_11_01 UINT16, field_12_012 UINT8, field_13_0123 BOOL, field_14_01234 INT64, field_15_012345 UINT32, field_16_0123456 CHAR, field_17_01234567 INT64, field_18_012345678 CHAR, field_19_0123456789 INT64 ARRAY, field_20_0 DATE, field_21_01 DATETIME, field_22_012 REAL, field_23_0123 INT8, field_24_01234 INT64 ARRAY, field_25_012345 BOOL, field_26_0123456 RICHREAL, field_27_01234567 DATE, field_28_012345678 UINT32, field_29_0123456789 INT16, field_30_0 DATETIME, field_31_01 RICHREAL, field_32_012 RICHREAL, field_33_0123 REAL, field_34_01234 UINT64, field_35_012345 INT8, field_36_0123456 INT32, field_37_01234567 REAL, field_38_012345678 RICHREAL, field_39_0123456789 BOOL, field_40_0 INT32, field_41_01 BOOL ARRAY, field_42_012 UINT16 ARRAY, field_43_0123 DATE)");
      /* 440 */ glbTypes.push_back("TABLE(field_1_01 DATE ARRAY, field_2_012 UINT32)");
      /* 441 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 INT8, field_3_0123 INT32 ARRAY, field_4_01234 CHAR, field_5_012345 UINT8, field_6_0123456 UINT16 ARRAY, field_7_01234567 INT16 ARRAY, field_8_012345678 DATETIME, field_9_0123456789 UINT16, field_10_0 RICHREAL, field_11_01 INT16, field_12_012 INT8, field_13_0123 INT16, field_14_01234 UINT64, field_15_012345 HIRESTIME, field_16_0123456 UINT32, field_17_01234567 DATE, field_18_012345678 UINT8, field_19_0123456789 INT32, field_20_0 CHAR ARRAY, field_21_01 DATE ARRAY, field_22_012 UINT64, field_23_0123 REAL ARRAY, field_24_01234 UINT16, field_25_012345 DATE, field_26_0123456 HIRESTIME, field_27_01234567 UINT64 ARRAY, field_28_012345678 CHAR ARRAY, field_29_0123456789 BOOL ARRAY, field_30_0 REAL, field_31_01 INT16 ARRAY, field_32_012 REAL ARRAY, field_33_0123 UINT32, field_34_01234 BOOL, field_35_012345 RICHREAL ARRAY, field_36_0123456 INT16, field_37_01234567 REAL, field_38_012345678 INT32, field_39_0123456789 BOOL ARRAY, field_40_0 RICHREAL, field_41_01 UINT32, field_42_012 CHAR, field_43_0123 INT32, field_44_01234 INT64, field_45_012345 UINT16, field_46_0123456 INT32 ARRAY, field_47_01234567 UINT8 ARRAY, field_48_012345678 UINT8 ARRAY, field_49_0123456789 UINT16, field_50_0 CHAR, field_51_01 INT16, field_52_012 INT64)");
      /* 442 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 DATETIME, field_3_0123 CHAR, field_4_01234 DATE, field_5_012345 INT32 ARRAY, field_6_0123456 BOOL, field_7_01234567 DATETIME ARRAY, field_8_012345678 INT64, field_9_0123456789 REAL, field_10_0 UINT16 ARRAY, field_11_01 HIRESTIME, field_12_012 UINT16, field_13_0123 UINT16, field_14_01234 DATETIME, field_15_012345 INT64, field_16_0123456 DATETIME, field_17_01234567 UINT64, field_18_012345678 INT8, field_19_0123456789 CHAR, field_20_0 INT16, field_21_01 UINT8, field_22_012 UINT64, field_23_0123 HIRESTIME, field_24_01234 RICHREAL, field_25_012345 INT8, field_26_0123456 UINT32, field_27_01234567 UINT16, field_28_012345678 INT8 ARRAY, field_29_0123456789 UINT8, field_30_0 DATETIME, field_31_01 BOOL, field_32_012 INT16, field_33_0123 CHAR, field_34_01234 BOOL, field_35_012345 RICHREAL ARRAY, field_36_0123456 CHAR, field_37_01234567 INT32 ARRAY, field_38_012345678 DATE ARRAY, field_39_0123456789 REAL, field_40_0 RICHREAL, field_41_01 HIRESTIME, field_42_012 DATE, field_43_0123 INT16, field_44_01234 UINT32, field_45_012345 RICHREAL, field_46_0123456 UINT8)");
      /* 443 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 INT8, field_3_0123 UINT16, field_4_01234 INT32)");
      /* 444 */ glbTypes.push_back("TABLE");
      /* 445 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 INT8, field_3_0123 DATETIME, field_4_01234 RICHREAL, field_5_012345 CHAR, field_6_0123456 INT8, field_7_01234567 INT16, field_8_012345678 UINT16, field_9_0123456789 UINT64, field_10_0 RICHREAL, field_11_01 UINT32, field_12_012 INT64, field_13_0123 UINT64, field_14_01234 UINT32 ARRAY, field_15_012345 CHAR ARRAY, field_16_0123456 DATETIME, field_17_01234567 DATETIME, field_18_012345678 UINT64, field_19_0123456789 DATETIME, field_20_0 DATE, field_21_01 RICHREAL, field_22_012 UINT32 ARRAY, field_23_0123 INT16, field_24_01234 UINT16, field_25_012345 HIRESTIME, field_26_0123456 DATETIME, field_27_01234567 RICHREAL, field_28_012345678 DATETIME, field_29_0123456789 DATE, field_30_0 UINT8, field_31_01 UINT16, field_32_012 DATE ARRAY, field_33_0123 RICHREAL ARRAY, field_34_01234 UINT8, field_35_012345 INT8, field_36_0123456 REAL, field_37_01234567 CHAR, field_38_012345678 RICHREAL, field_39_0123456789 UINT16, field_40_0 INT64, field_41_01 INT8, field_42_012 INT64, field_43_0123 UINT64, field_44_01234 DATETIME, field_45_012345 CHAR, field_46_0123456 DATE, field_47_01234567 DATETIME, field_48_012345678 INT8, field_49_0123456789 HIRESTIME, field_50_0 INT32 ARRAY, field_51_01 DATETIME, field_52_012 UINT32, field_53_0123 INT16, field_54_01234 INT64, field_55_012345 UINT8 ARRAY, field_56_0123456 UINT32, field_57_01234567 UINT16, field_58_012345678 DATE, field_59_0123456789 BOOL, field_60_0 RICHREAL, field_61_01 CHAR, field_62_012 INT32, field_63_0123 INT8, field_64_01234 INT64, field_65_012345 HIRESTIME, field_66_0123456 INT16, field_67_01234567 BOOL, field_68_012345678 UINT8 ARRAY, field_69_0123456789 INT32 ARRAY, field_70_0 INT32, field_71_01 INT16, field_72_012 UINT8, field_73_0123 UINT32, field_74_01234 CHAR ARRAY, field_75_012345 HIRESTIME, field_76_0123456 DATETIME, field_77_01234567 INT16, field_78_012345678 DATETIME ARRAY, field_79_0123456789 INT32, field_80_0 BOOL, field_81_01 CHAR, field_82_012 DATE, field_83_0123 BOOL, field_84_01234 BOOL, field_85_012345 UINT8, field_86_0123456 UINT8, field_87_01234567 CHAR, field_88_012345678 DATETIME ARRAY, field_89_0123456789 UINT8, field_90_0 DATE, field_91_01 DATETIME)");
      /* 446 */ glbTypes.push_back("TABLE(field_1_01 DATE ARRAY, field_2_012 UINT8, field_3_0123 UINT8, field_4_01234 UINT32, field_5_012345 DATETIME, field_6_0123456 HIRESTIME, field_7_01234567 INT64 ARRAY, field_8_012345678 UINT32, field_9_0123456789 UINT16, field_10_0 UINT32, field_11_01 DATETIME ARRAY, field_12_012 UINT8 ARRAY, field_13_0123 UINT32, field_14_01234 INT64, field_15_012345 INT8, field_16_0123456 INT16, field_17_01234567 DATETIME, field_18_012345678 UINT8, field_19_0123456789 UINT8, field_20_0 INT64, field_21_01 UINT16 ARRAY, field_22_012 UINT64 ARRAY, field_23_0123 UINT16, field_24_01234 INT64, field_25_012345 RICHREAL, field_26_0123456 INT32, field_27_01234567 RICHREAL ARRAY, field_28_012345678 UINT32 ARRAY, field_29_0123456789 HIRESTIME, field_30_0 RICHREAL, field_31_01 BOOL ARRAY, field_32_012 CHAR, field_33_0123 UINT64, field_34_01234 DATE, field_35_012345 INT32, field_36_0123456 BOOL, field_37_01234567 UINT8, field_38_012345678 CHAR, field_39_0123456789 DATETIME ARRAY, field_40_0 RICHREAL ARRAY, field_41_01 UINT32, field_42_012 UINT16, field_43_0123 INT8, field_44_01234 UINT8, field_45_012345 UINT64, field_46_0123456 UINT8, field_47_01234567 BOOL, field_48_012345678 BOOL, field_49_0123456789 DATE ARRAY, field_50_0 BOOL, field_51_01 INT16, field_52_012 INT8, field_53_0123 CHAR, field_54_01234 RICHREAL, field_55_012345 UINT8, field_56_0123456 INT32, field_57_01234567 HIRESTIME, field_58_012345678 DATETIME, field_59_0123456789 RICHREAL)");
      /* 447 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 UINT64, field_3_0123 INT32, field_4_01234 CHAR, field_5_012345 HIRESTIME, field_6_0123456 RICHREAL, field_7_01234567 REAL, field_8_012345678 HIRESTIME, field_9_0123456789 BOOL ARRAY, field_10_0 UINT8, field_11_01 INT8, field_12_012 CHAR, field_13_0123 UINT32, field_14_01234 DATE, field_15_012345 UINT16, field_16_0123456 UINT64, field_17_01234567 INT8, field_18_012345678 INT32, field_19_0123456789 REAL, field_20_0 UINT64, field_21_01 RICHREAL, field_22_012 BOOL, field_23_0123 BOOL ARRAY, field_24_01234 UINT16 ARRAY, field_25_012345 INT64, field_26_0123456 REAL, field_27_01234567 REAL, field_28_012345678 INT32 ARRAY, field_29_0123456789 INT8, field_30_0 DATE, field_31_01 UINT64, field_32_012 DATETIME ARRAY, field_33_0123 UINT8, field_34_01234 RICHREAL, field_35_012345 UINT16, field_36_0123456 UINT8, field_37_01234567 REAL, field_38_012345678 INT32, field_39_0123456789 DATETIME, field_40_0 UINT32, field_41_01 DATETIME, field_42_012 INT64, field_43_0123 UINT32, field_44_01234 HIRESTIME, field_45_012345 CHAR, field_46_0123456 INT8, field_47_01234567 INT64, field_48_012345678 INT32)");
      /* 448 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 INT8, field_3_0123 INT32, field_4_01234 DATETIME ARRAY, field_5_012345 UINT16 ARRAY, field_6_0123456 INT8, field_7_01234567 INT8, field_8_012345678 UINT32, field_9_0123456789 INT64, field_10_0 INT8, field_11_01 CHAR, field_12_012 HIRESTIME, field_13_0123 INT64, field_14_01234 INT64, field_15_012345 DATE, field_16_0123456 INT8, field_17_01234567 INT16, field_18_012345678 UINT16, field_19_0123456789 HIRESTIME, field_20_0 UINT8, field_21_01 DATETIME, field_22_012 UINT64, field_23_0123 RICHREAL, field_24_01234 BOOL ARRAY, field_25_012345 REAL, field_26_0123456 INT16, field_27_01234567 UINT16, field_28_012345678 HIRESTIME, field_29_0123456789 INT16, field_30_0 BOOL, field_31_01 UINT16, field_32_012 HIRESTIME, field_33_0123 HIRESTIME, field_34_01234 UINT8, field_35_012345 UINT64 ARRAY, field_36_0123456 INT16, field_37_01234567 INT16, field_38_012345678 DATE, field_39_0123456789 UINT16, field_40_0 REAL, field_41_01 DATETIME, field_42_012 INT8, field_43_0123 INT16, field_44_01234 RICHREAL, field_45_012345 INT64, field_46_0123456 BOOL)");
      /* 449 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 DATE ARRAY)");
      /* 450 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 INT16 ARRAY, field_3_0123 CHAR, field_4_01234 UINT8, field_5_012345 BOOL, field_6_0123456 INT16, field_7_01234567 UINT8, field_8_012345678 RICHREAL, field_9_0123456789 UINT64 ARRAY, field_10_0 UINT32, field_11_01 HIRESTIME, field_12_012 INT8 ARRAY, field_13_0123 CHAR ARRAY, field_14_01234 HIRESTIME, field_15_012345 HIRESTIME, field_16_0123456 DATE, field_17_01234567 CHAR, field_18_012345678 BOOL, field_19_0123456789 RICHREAL, field_20_0 DATE, field_21_01 INT32, field_22_012 DATE ARRAY, field_23_0123 UINT8, field_24_01234 HIRESTIME, field_25_012345 HIRESTIME, field_26_0123456 DATETIME, field_27_01234567 INT8 ARRAY, field_28_012345678 INT64, field_29_0123456789 HIRESTIME, field_30_0 INT8, field_31_01 UINT16 ARRAY, field_32_012 HIRESTIME, field_33_0123 CHAR, field_34_01234 HIRESTIME ARRAY, field_35_012345 HIRESTIME, field_36_0123456 DATETIME, field_37_01234567 RICHREAL, field_38_012345678 RICHREAL, field_39_0123456789 DATE ARRAY, field_40_0 INT8, field_41_01 UINT16, field_42_012 RICHREAL, field_43_0123 UINT8, field_44_01234 BOOL, field_45_012345 UINT16, field_46_0123456 INT32, field_47_01234567 UINT8, field_48_012345678 INT16 ARRAY, field_49_0123456789 UINT64, field_50_0 INT8, field_51_01 INT8, field_52_012 UINT16, field_53_0123 DATETIME, field_54_01234 INT8, field_55_012345 INT32, field_56_0123456 INT32 ARRAY, field_57_01234567 UINT32, field_58_012345678 UINT16 ARRAY, field_59_0123456789 INT8, field_60_0 RICHREAL ARRAY, field_61_01 DATE ARRAY, field_62_012 INT32, field_63_0123 DATE, field_64_01234 UINT32 ARRAY, field_65_012345 UINT64, field_66_0123456 INT64, field_67_01234567 INT32, field_68_012345678 UINT64, field_69_0123456789 UINT16, field_70_0 INT16, field_71_01 RICHREAL, field_72_012 INT64, field_73_0123 RICHREAL, field_74_01234 HIRESTIME ARRAY, field_75_012345 CHAR ARRAY, field_76_0123456 RICHREAL, field_77_01234567 CHAR, field_78_012345678 UINT32 ARRAY, field_79_0123456789 UINT32, field_80_0 UINT32, field_81_01 UINT8)");
      /* 451 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 INT8, field_3_0123 UINT8 ARRAY, field_4_01234 INT64, field_5_012345 UINT32, field_6_0123456 HIRESTIME, field_7_01234567 UINT16, field_8_012345678 INT8, field_9_0123456789 CHAR, field_10_0 INT64, field_11_01 INT8, field_12_012 UINT32, field_13_0123 INT64, field_14_01234 UINT32, field_15_012345 INT32, field_16_0123456 BOOL, field_17_01234567 INT16, field_18_012345678 BOOL, field_19_0123456789 UINT32, field_20_0 UINT64, field_21_01 INT16, field_22_012 INT16, field_23_0123 INT16, field_24_01234 INT16, field_25_012345 UINT64, field_26_0123456 UINT8 ARRAY, field_27_01234567 UINT32, field_28_012345678 INT64 ARRAY, field_29_0123456789 BOOL, field_30_0 BOOL ARRAY, field_31_01 INT8, field_32_012 BOOL, field_33_0123 DATE, field_34_01234 INT16, field_35_012345 DATETIME ARRAY, field_36_0123456 UINT8, field_37_01234567 BOOL, field_38_012345678 RICHREAL, field_39_0123456789 REAL, field_40_0 INT8, field_41_01 UINT16, field_42_012 UINT64, field_43_0123 RICHREAL ARRAY, field_44_01234 INT16, field_45_012345 BOOL, field_46_0123456 RICHREAL, field_47_01234567 RICHREAL, field_48_012345678 DATE, field_49_0123456789 INT8, field_50_0 INT16, field_51_01 UINT8, field_52_012 HIRESTIME, field_53_0123 UINT32, field_54_01234 INT8, field_55_012345 HIRESTIME, field_56_0123456 DATETIME, field_57_01234567 INT16 ARRAY, field_58_012345678 UINT32, field_59_0123456789 UINT32, field_60_0 REAL, field_61_01 INT16, field_62_012 INT16, field_63_0123 UINT64 ARRAY, field_64_01234 INT32, field_65_012345 INT16, field_66_0123456 UINT64, field_67_01234567 UINT16, field_68_012345678 INT8, field_69_0123456789 UINT16, field_70_0 UINT8, field_71_01 CHAR ARRAY, field_72_012 UINT32, field_73_0123 UINT16 ARRAY, field_74_01234 RICHREAL, field_75_012345 INT32, field_76_0123456 HIRESTIME, field_77_01234567 INT32 ARRAY, field_78_012345678 INT32, field_79_0123456789 UINT32, field_80_0 INT8 ARRAY, field_81_01 UINT32, field_82_012 RICHREAL, field_83_0123 REAL, field_84_01234 UINT64, field_85_012345 RICHREAL)");
      /* 452 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 RICHREAL ARRAY, field_3_0123 DATETIME, field_4_01234 UINT64, field_5_012345 CHAR, field_6_0123456 REAL, field_7_01234567 CHAR, field_8_012345678 UINT64 ARRAY, field_9_0123456789 UINT8 ARRAY, field_10_0 UINT8, field_11_01 UINT8 ARRAY, field_12_012 UINT8, field_13_0123 DATETIME, field_14_01234 REAL, field_15_012345 INT8 ARRAY, field_16_0123456 UINT16, field_17_01234567 DATE, field_18_012345678 RICHREAL, field_19_0123456789 INT8, field_20_0 INT64, field_21_01 UINT8, field_22_012 DATE ARRAY, field_23_0123 INT64, field_24_01234 INT32 ARRAY, field_25_012345 BOOL, field_26_0123456 CHAR ARRAY, field_27_01234567 DATE, field_28_012345678 HIRESTIME, field_29_0123456789 BOOL, field_30_0 UINT64, field_31_01 INT16, field_32_012 INT64, field_33_0123 INT16, field_34_01234 INT32 ARRAY, field_35_012345 UINT16, field_36_0123456 INT16, field_37_01234567 UINT32, field_38_012345678 HIRESTIME, field_39_0123456789 DATE, field_40_0 DATE, field_41_01 INT64, field_42_012 RICHREAL, field_43_0123 BOOL ARRAY, field_44_01234 UINT8, field_45_012345 UINT16, field_46_0123456 INT16, field_47_01234567 UINT8, field_48_012345678 UINT64, field_49_0123456789 RICHREAL, field_50_0 REAL, field_51_01 CHAR ARRAY, field_52_012 BOOL, field_53_0123 UINT64, field_54_01234 INT8 ARRAY, field_55_012345 CHAR, field_56_0123456 DATE, field_57_01234567 INT32, field_58_012345678 UINT16 ARRAY, field_59_0123456789 UINT8, field_60_0 HIRESTIME, field_61_01 CHAR ARRAY, field_62_012 DATETIME, field_63_0123 DATETIME ARRAY, field_64_01234 INT64, field_65_012345 HIRESTIME)");
      /* 453 */ glbTypes.push_back("TABLE(field_1_01 UINT32 ARRAY, field_2_012 DATETIME, field_3_0123 INT16, field_4_01234 CHAR ARRAY, field_5_012345 UINT8, field_6_0123456 BOOL, field_7_01234567 INT16, field_8_012345678 DATETIME, field_9_0123456789 UINT32 ARRAY, field_10_0 CHAR, field_11_01 INT16, field_12_012 UINT64, field_13_0123 CHAR, field_14_01234 CHAR, field_15_012345 INT16 ARRAY, field_16_0123456 DATE, field_17_01234567 DATE ARRAY, field_18_012345678 UINT16 ARRAY, field_19_0123456789 UINT64, field_20_0 HIRESTIME, field_21_01 UINT64, field_22_012 INT64, field_23_0123 CHAR, field_24_01234 DATE, field_25_012345 INT32, field_26_0123456 HIRESTIME ARRAY, field_27_01234567 INT64, field_28_012345678 HIRESTIME, field_29_0123456789 INT64)");
      /* 454 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 UINT32, field_3_0123 INT16, field_4_01234 UINT64, field_5_012345 INT64, field_6_0123456 INT64, field_7_01234567 UINT32, field_8_012345678 DATE ARRAY, field_9_0123456789 UINT32, field_10_0 INT8, field_11_01 REAL, field_12_012 INT64, field_13_0123 INT16, field_14_01234 UINT16, field_15_012345 DATE, field_16_0123456 INT16, field_17_01234567 INT8, field_18_012345678 INT8, field_19_0123456789 DATETIME, field_20_0 DATE, field_21_01 UINT64, field_22_012 BOOL, field_23_0123 CHAR, field_24_01234 INT16, field_25_012345 CHAR, field_26_0123456 BOOL, field_27_01234567 BOOL, field_28_012345678 HIRESTIME, field_29_0123456789 INT64, field_30_0 BOOL, field_31_01 UINT32, field_32_012 UINT32, field_33_0123 INT8, field_34_01234 UINT64 ARRAY, field_35_012345 BOOL, field_36_0123456 DATE ARRAY, field_37_01234567 DATETIME, field_38_012345678 HIRESTIME ARRAY, field_39_0123456789 CHAR, field_40_0 UINT8 ARRAY, field_41_01 HIRESTIME, field_42_012 BOOL, field_43_0123 DATETIME, field_44_01234 REAL ARRAY, field_45_012345 INT64, field_46_0123456 HIRESTIME, field_47_01234567 INT16, field_48_012345678 HIRESTIME, field_49_0123456789 DATETIME, field_50_0 UINT8, field_51_01 UINT64, field_52_012 CHAR, field_53_0123 UINT64, field_54_01234 INT8, field_55_012345 CHAR)");
      /* 455 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 RICHREAL, field_3_0123 BOOL, field_4_01234 REAL, field_5_012345 RICHREAL)");
      /* 456 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 INT32, field_3_0123 DATETIME, field_4_01234 UINT16, field_5_012345 UINT32 ARRAY, field_6_0123456 INT32, field_7_01234567 INT64, field_8_012345678 UINT16, field_9_0123456789 INT32, field_10_0 INT32, field_11_01 DATETIME, field_12_012 DATE ARRAY, field_13_0123 DATETIME, field_14_01234 DATE, field_15_012345 BOOL, field_16_0123456 UINT32, field_17_01234567 REAL, field_18_012345678 DATE, field_19_0123456789 UINT16, field_20_0 HIRESTIME, field_21_01 INT64, field_22_012 UINT64 ARRAY, field_23_0123 HIRESTIME ARRAY, field_24_01234 BOOL, field_25_012345 REAL, field_26_0123456 RICHREAL, field_27_01234567 INT8 ARRAY, field_28_012345678 DATE, field_29_0123456789 UINT32 ARRAY, field_30_0 CHAR, field_31_01 INT32 ARRAY, field_32_012 INT32 ARRAY, field_33_0123 HIRESTIME, field_34_01234 UINT32 ARRAY, field_35_012345 INT64, field_36_0123456 UINT8, field_37_01234567 INT64 ARRAY, field_38_012345678 UINT8)");
      /* 457 */ glbTypes.push_back("TABLE(field_1_01 INT8 ARRAY, field_2_012 DATE ARRAY, field_3_0123 HIRESTIME, field_4_01234 UINT32, field_5_012345 DATETIME, field_6_0123456 INT8, field_7_01234567 HIRESTIME, field_8_012345678 INT8 ARRAY, field_9_0123456789 DATETIME, field_10_0 UINT64, field_11_01 UINT8 ARRAY, field_12_012 UINT16, field_13_0123 UINT32, field_14_01234 RICHREAL, field_15_012345 INT16, field_16_0123456 RICHREAL, field_17_01234567 REAL, field_18_012345678 REAL, field_19_0123456789 UINT32 ARRAY, field_20_0 BOOL, field_21_01 INT64 ARRAY, field_22_012 UINT16, field_23_0123 INT32, field_24_01234 UINT64, field_25_012345 REAL ARRAY, field_26_0123456 INT16, field_27_01234567 UINT64, field_28_012345678 CHAR, field_29_0123456789 CHAR, field_30_0 CHAR, field_31_01 UINT32, field_32_012 DATETIME ARRAY, field_33_0123 CHAR, field_34_01234 BOOL, field_35_012345 RICHREAL, field_36_0123456 INT64, field_37_01234567 CHAR ARRAY, field_38_012345678 INT32, field_39_0123456789 INT8, field_40_0 BOOL, field_41_01 CHAR, field_42_012 RICHREAL, field_43_0123 INT32, field_44_01234 INT16 ARRAY, field_45_012345 UINT8, field_46_0123456 INT16, field_47_01234567 CHAR, field_48_012345678 UINT8, field_49_0123456789 UINT32, field_50_0 DATE, field_51_01 INT16, field_52_012 INT64, field_53_0123 INT8, field_54_01234 BOOL, field_55_012345 REAL ARRAY, field_56_0123456 INT64 ARRAY, field_57_01234567 BOOL, field_58_012345678 DATETIME, field_59_0123456789 RICHREAL, field_60_0 UINT32, field_61_01 UINT64, field_62_012 UINT32 ARRAY, field_63_0123 UINT16, field_64_01234 BOOL ARRAY, field_65_012345 INT16, field_66_0123456 CHAR, field_67_01234567 INT8, field_68_012345678 UINT8 ARRAY, field_69_0123456789 INT32, field_70_0 INT32 ARRAY, field_71_01 CHAR ARRAY, field_72_012 BOOL, field_73_0123 BOOL, field_74_01234 REAL, field_75_012345 HIRESTIME, field_76_0123456 BOOL ARRAY, field_77_01234567 INT64, field_78_012345678 DATE, field_79_0123456789 DATE, field_80_0 UINT64, field_81_01 UINT8, field_82_012 CHAR ARRAY, field_83_0123 UINT64, field_84_01234 INT8, field_85_012345 UINT64)");
      /* 458 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 UINT16, field_3_0123 INT32, field_4_01234 UINT8, field_5_012345 DATETIME, field_6_0123456 INT32, field_7_01234567 DATE, field_8_012345678 UINT16, field_9_0123456789 RICHREAL, field_10_0 BOOL, field_11_01 INT16, field_12_012 BOOL, field_13_0123 INT64, field_14_01234 DATETIME, field_15_012345 DATETIME, field_16_0123456 BOOL, field_17_01234567 DATE ARRAY, field_18_012345678 HIRESTIME ARRAY, field_19_0123456789 UINT32 ARRAY, field_20_0 INT16, field_21_01 DATETIME, field_22_012 BOOL, field_23_0123 HIRESTIME, field_24_01234 REAL ARRAY, field_25_012345 BOOL, field_26_0123456 DATETIME, field_27_01234567 INT16 ARRAY, field_28_012345678 BOOL, field_29_0123456789 INT16, field_30_0 BOOL, field_31_01 BOOL ARRAY, field_32_012 DATETIME, field_33_0123 UINT64 ARRAY, field_34_01234 UINT32, field_35_012345 INT16 ARRAY, field_36_0123456 UINT8 ARRAY, field_37_01234567 INT32, field_38_012345678 UINT32, field_39_0123456789 INT16 ARRAY, field_40_0 DATE, field_41_01 RICHREAL ARRAY, field_42_012 INT32, field_43_0123 HIRESTIME, field_44_01234 CHAR, field_45_012345 UINT8 ARRAY, field_46_0123456 DATE, field_47_01234567 INT32 ARRAY, field_48_012345678 BOOL, field_49_0123456789 INT64, field_50_0 DATETIME ARRAY, field_51_01 INT16, field_52_012 INT32, field_53_0123 BOOL, field_54_01234 UINT8, field_55_012345 UINT32, field_56_0123456 UINT16, field_57_01234567 UINT16)");
      /* 459 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 INT16, field_3_0123 UINT64, field_4_01234 INT64, field_5_012345 UINT16 ARRAY, field_6_0123456 REAL, field_7_01234567 UINT16, field_8_012345678 RICHREAL, field_9_0123456789 CHAR ARRAY, field_10_0 RICHREAL, field_11_01 INT16 ARRAY, field_12_012 BOOL, field_13_0123 INT32, field_14_01234 INT16, field_15_012345 UINT32, field_16_0123456 DATE, field_17_01234567 RICHREAL, field_18_012345678 INT64 ARRAY, field_19_0123456789 INT64, field_20_0 HIRESTIME, field_21_01 CHAR, field_22_012 HIRESTIME ARRAY, field_23_0123 INT64 ARRAY, field_24_01234 CHAR, field_25_012345 INT8, field_26_0123456 INT64, field_27_01234567 HIRESTIME, field_28_012345678 INT64 ARRAY, field_29_0123456789 BOOL, field_30_0 INT8, field_31_01 CHAR, field_32_012 REAL ARRAY, field_33_0123 UINT16, field_34_01234 HIRESTIME, field_35_012345 DATE, field_36_0123456 DATE, field_37_01234567 BOOL ARRAY)");
      /* 460 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 INT16, field_3_0123 HIRESTIME, field_4_01234 UINT32, field_5_012345 INT8 ARRAY, field_6_0123456 INT64, field_7_01234567 INT64, field_8_012345678 REAL, field_9_0123456789 UINT8 ARRAY, field_10_0 CHAR, field_11_01 UINT64, field_12_012 UINT32, field_13_0123 RICHREAL ARRAY, field_14_01234 INT8, field_15_012345 HIRESTIME, field_16_0123456 DATETIME, field_17_01234567 HIRESTIME ARRAY, field_18_012345678 UINT16, field_19_0123456789 UINT32, field_20_0 INT8 ARRAY, field_21_01 INT16, field_22_012 DATE, field_23_0123 UINT32 ARRAY, field_24_01234 INT16, field_25_012345 INT8 ARRAY, field_26_0123456 DATE, field_27_01234567 CHAR, field_28_012345678 CHAR, field_29_0123456789 INT64, field_30_0 DATETIME, field_31_01 INT8, field_32_012 HIRESTIME, field_33_0123 RICHREAL, field_34_01234 BOOL ARRAY, field_35_012345 RICHREAL, field_36_0123456 INT8, field_37_01234567 HIRESTIME ARRAY, field_38_012345678 UINT16, field_39_0123456789 CHAR, field_40_0 HIRESTIME ARRAY, field_41_01 HIRESTIME, field_42_012 UINT32, field_43_0123 UINT64, field_44_01234 BOOL, field_45_012345 BOOL)");
      /* 461 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 RICHREAL, field_3_0123 REAL, field_4_01234 INT64 ARRAY, field_5_012345 HIRESTIME, field_6_0123456 UINT8, field_7_01234567 HIRESTIME, field_8_012345678 INT64 ARRAY, field_9_0123456789 BOOL, field_10_0 INT32, field_11_01 DATE, field_12_012 DATE, field_13_0123 INT32, field_14_01234 HIRESTIME, field_15_012345 UINT32, field_16_0123456 UINT64, field_17_01234567 INT32, field_18_012345678 INT32, field_19_0123456789 BOOL, field_20_0 UINT32, field_21_01 INT64, field_22_012 DATETIME ARRAY, field_23_0123 INT64, field_24_01234 BOOL, field_25_012345 HIRESTIME ARRAY, field_26_0123456 CHAR, field_27_01234567 DATE ARRAY, field_28_012345678 INT32, field_29_0123456789 RICHREAL, field_30_0 BOOL, field_31_01 DATETIME, field_32_012 DATE, field_33_0123 HIRESTIME, field_34_01234 BOOL ARRAY, field_35_012345 UINT16, field_36_0123456 REAL, field_37_01234567 INT64, field_38_012345678 INT64, field_39_0123456789 INT32, field_40_0 UINT16, field_41_01 INT8, field_42_012 CHAR ARRAY, field_43_0123 UINT16, field_44_01234 BOOL, field_45_012345 INT32, field_46_0123456 BOOL, field_47_01234567 DATETIME, field_48_012345678 DATE, field_49_0123456789 INT32, field_50_0 HIRESTIME, field_51_01 DATETIME, field_52_012 INT8, field_53_0123 UINT64, field_54_01234 RICHREAL ARRAY, field_55_012345 UINT64 ARRAY, field_56_0123456 UINT32, field_57_01234567 DATE, field_58_012345678 INT64, field_59_0123456789 HIRESTIME, field_60_0 BOOL, field_61_01 INT8, field_62_012 UINT16, field_63_0123 UINT8, field_64_01234 UINT64 ARRAY, field_65_012345 DATE, field_66_0123456 BOOL ARRAY, field_67_01234567 INT8, field_68_012345678 UINT8, field_69_0123456789 RICHREAL, field_70_0 REAL ARRAY, field_71_01 INT8)");
      /* 462 */ glbTypes.push_back("TABLE(field_1_01 BOOL ARRAY, field_2_012 UINT16, field_3_0123 CHAR, field_4_01234 DATETIME, field_5_012345 BOOL, field_6_0123456 DATETIME, field_7_01234567 INT64, field_8_012345678 CHAR ARRAY, field_9_0123456789 DATE ARRAY, field_10_0 CHAR, field_11_01 INT8, field_12_012 CHAR, field_13_0123 UINT32, field_14_01234 INT32, field_15_012345 BOOL, field_16_0123456 DATE, field_17_01234567 INT64, field_18_012345678 UINT8, field_19_0123456789 UINT32, field_20_0 DATE ARRAY, field_21_01 BOOL, field_22_012 INT8, field_23_0123 INT64, field_24_01234 INT64, field_25_012345 INT64, field_26_0123456 UINT32, field_27_01234567 INT8, field_28_012345678 INT32, field_29_0123456789 INT64, field_30_0 HIRESTIME, field_31_01 INT8 ARRAY, field_32_012 INT8, field_33_0123 UINT64, field_34_01234 CHAR, field_35_012345 INT64, field_36_0123456 UINT64, field_37_01234567 BOOL, field_38_012345678 UINT16, field_39_0123456789 RICHREAL, field_40_0 INT64, field_41_01 UINT16, field_42_012 INT8, field_43_0123 CHAR, field_44_01234 DATE ARRAY, field_45_012345 DATE, field_46_0123456 RICHREAL, field_47_01234567 UINT32, field_48_012345678 INT16, field_49_0123456789 INT64 ARRAY, field_50_0 UINT8, field_51_01 UINT32, field_52_012 INT8, field_53_0123 INT16, field_54_01234 BOOL, field_55_012345 UINT32, field_56_0123456 INT16, field_57_01234567 CHAR, field_58_012345678 HIRESTIME ARRAY, field_59_0123456789 UINT8, field_60_0 INT64, field_61_01 INT8, field_62_012 UINT32, field_63_0123 BOOL ARRAY, field_64_01234 BOOL, field_65_012345 HIRESTIME, field_66_0123456 DATETIME, field_67_01234567 DATETIME, field_68_012345678 INT32, field_69_0123456789 DATE, field_70_0 INT16, field_71_01 HIRESTIME ARRAY, field_72_012 INT8, field_73_0123 INT32 ARRAY, field_74_01234 DATE, field_75_012345 DATE, field_76_0123456 INT8, field_77_01234567 RICHREAL ARRAY, field_78_012345678 DATETIME, field_79_0123456789 UINT16)");
      /* 463 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 RICHREAL, field_3_0123 INT64, field_4_01234 BOOL, field_5_012345 INT64, field_6_0123456 CHAR, field_7_01234567 DATETIME ARRAY, field_8_012345678 CHAR)");
      /* 464 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 REAL, field_3_0123 UINT64, field_4_01234 CHAR, field_5_012345 INT32 ARRAY, field_6_0123456 UINT32 ARRAY, field_7_01234567 UINT8 ARRAY, field_8_012345678 INT8, field_9_0123456789 UINT16, field_10_0 DATE ARRAY, field_11_01 INT32 ARRAY, field_12_012 RICHREAL ARRAY, field_13_0123 INT64, field_14_01234 HIRESTIME, field_15_012345 INT64, field_16_0123456 INT16, field_17_01234567 DATETIME, field_18_012345678 UINT16, field_19_0123456789 INT16, field_20_0 INT32, field_21_01 HIRESTIME ARRAY, field_22_012 UINT64 ARRAY, field_23_0123 BOOL, field_24_01234 UINT8, field_25_012345 HIRESTIME, field_26_0123456 UINT16 ARRAY, field_27_01234567 HIRESTIME, field_28_012345678 DATE, field_29_0123456789 INT8 ARRAY, field_30_0 UINT8, field_31_01 UINT64, field_32_012 DATETIME, field_33_0123 HIRESTIME, field_34_01234 INT32, field_35_012345 INT16, field_36_0123456 INT16, field_37_01234567 DATE ARRAY, field_38_012345678 UINT32 ARRAY, field_39_0123456789 UINT64, field_40_0 INT32, field_41_01 UINT64, field_42_012 RICHREAL, field_43_0123 UINT32, field_44_01234 INT64, field_45_012345 INT8, field_46_0123456 INT16, field_47_01234567 DATE, field_48_012345678 BOOL, field_49_0123456789 DATE, field_50_0 BOOL, field_51_01 UINT8, field_52_012 UINT32, field_53_0123 INT64, field_54_01234 RICHREAL, field_55_012345 INT8 ARRAY, field_56_0123456 HIRESTIME, field_57_01234567 UINT16, field_58_012345678 UINT16, field_59_0123456789 UINT64, field_60_0 UINT64, field_61_01 INT32, field_62_012 BOOL, field_63_0123 UINT32, field_64_01234 INT32, field_65_012345 DATETIME, field_66_0123456 UINT32, field_67_01234567 RICHREAL, field_68_012345678 REAL, field_69_0123456789 INT8, field_70_0 INT32, field_71_01 INT8, field_72_012 HIRESTIME, field_73_0123 INT16, field_74_01234 HIRESTIME, field_75_012345 BOOL, field_76_0123456 INT8 ARRAY, field_77_01234567 REAL ARRAY, field_78_012345678 DATETIME, field_79_0123456789 UINT32, field_80_0 CHAR, field_81_01 BOOL, field_82_012 BOOL ARRAY, field_83_0123 INT32, field_84_01234 BOOL, field_85_012345 UINT32 ARRAY, field_86_0123456 RICHREAL, field_87_01234567 UINT8, field_88_012345678 RICHREAL)");
      /* 465 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 UINT32 ARRAY, field_3_0123 INT8, field_4_01234 INT16, field_5_012345 DATE, field_6_0123456 INT8)");
      /* 466 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 INT64 ARRAY, field_3_0123 REAL, field_4_01234 DATE, field_5_012345 UINT8, field_6_0123456 DATETIME, field_7_01234567 RICHREAL, field_8_012345678 INT16, field_9_0123456789 INT8 ARRAY, field_10_0 CHAR, field_11_01 DATETIME, field_12_012 INT64, field_13_0123 CHAR, field_14_01234 INT16, field_15_012345 DATE, field_16_0123456 INT8, field_17_01234567 UINT64 ARRAY, field_18_012345678 DATETIME, field_19_0123456789 BOOL, field_20_0 INT8, field_21_01 INT32 ARRAY, field_22_012 UINT8, field_23_0123 INT64 ARRAY, field_24_01234 BOOL, field_25_012345 REAL, field_26_0123456 DATE, field_27_01234567 INT64, field_28_012345678 UINT32, field_29_0123456789 UINT64, field_30_0 INT8 ARRAY, field_31_01 INT16 ARRAY, field_32_012 INT8, field_33_0123 UINT8, field_34_01234 BOOL, field_35_012345 UINT64, field_36_0123456 INT32, field_37_01234567 UINT8, field_38_012345678 INT64 ARRAY, field_39_0123456789 INT32, field_40_0 UINT16 ARRAY, field_41_01 INT32, field_42_012 INT32, field_43_0123 INT32, field_44_01234 UINT64, field_45_012345 INT64, field_46_0123456 INT64)");
      /* 467 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 INT64, field_3_0123 BOOL, field_4_01234 DATE, field_5_012345 BOOL, field_6_0123456 DATETIME, field_7_01234567 HIRESTIME ARRAY, field_8_012345678 INT8, field_9_0123456789 INT8 ARRAY, field_10_0 INT32 ARRAY, field_11_01 INT64, field_12_012 INT16, field_13_0123 UINT16, field_14_01234 HIRESTIME, field_15_012345 DATETIME, field_16_0123456 INT32, field_17_01234567 INT32 ARRAY, field_18_012345678 UINT64, field_19_0123456789 INT8, field_20_0 HIRESTIME, field_21_01 UINT64, field_22_012 INT32, field_23_0123 UINT8, field_24_01234 DATETIME, field_25_012345 INT32, field_26_0123456 INT8, field_27_01234567 UINT8, field_28_012345678 REAL, field_29_0123456789 INT8 ARRAY, field_30_0 UINT64 ARRAY, field_31_01 DATETIME, field_32_012 INT32, field_33_0123 HIRESTIME, field_34_01234 UINT8, field_35_012345 UINT32, field_36_0123456 UINT8, field_37_01234567 INT8 ARRAY, field_38_012345678 CHAR, field_39_0123456789 UINT64, field_40_0 UINT16, field_41_01 UINT8, field_42_012 INT16 ARRAY, field_43_0123 UINT8, field_44_01234 INT64, field_45_012345 UINT64 ARRAY, field_46_0123456 UINT64, field_47_01234567 BOOL, field_48_012345678 DATETIME)");
      /* 468 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 INT64, field_3_0123 DATE, field_4_01234 DATETIME, field_5_012345 DATETIME, field_6_0123456 DATE ARRAY, field_7_01234567 INT16, field_8_012345678 UINT16 ARRAY, field_9_0123456789 INT64, field_10_0 INT64, field_11_01 UINT8, field_12_012 INT16, field_13_0123 UINT8, field_14_01234 BOOL, field_15_012345 CHAR ARRAY, field_16_0123456 BOOL, field_17_01234567 CHAR ARRAY, field_18_012345678 BOOL, field_19_0123456789 CHAR, field_20_0 UINT8, field_21_01 REAL, field_22_012 DATETIME, field_23_0123 INT8 ARRAY, field_24_01234 RICHREAL ARRAY, field_25_012345 UINT32, field_26_0123456 UINT64 ARRAY, field_27_01234567 UINT32, field_28_012345678 INT32, field_29_0123456789 CHAR, field_30_0 UINT32 ARRAY, field_31_01 INT64, field_32_012 UINT8, field_33_0123 HIRESTIME, field_34_01234 RICHREAL)");
      /* 469 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 INT32, field_3_0123 INT16, field_4_01234 UINT8 ARRAY, field_5_012345 RICHREAL ARRAY, field_6_0123456 DATE, field_7_01234567 UINT32 ARRAY, field_8_012345678 HIRESTIME, field_9_0123456789 INT8, field_10_0 BOOL, field_11_01 INT8, field_12_012 UINT8, field_13_0123 HIRESTIME, field_14_01234 HIRESTIME ARRAY, field_15_012345 RICHREAL, field_16_0123456 UINT16 ARRAY, field_17_01234567 INT32 ARRAY, field_18_012345678 REAL, field_19_0123456789 UINT32, field_20_0 UINT32 ARRAY, field_21_01 CHAR, field_22_012 INT32, field_23_0123 DATE, field_24_01234 CHAR, field_25_012345 UINT16, field_26_0123456 RICHREAL, field_27_01234567 UINT32, field_28_012345678 INT8 ARRAY, field_29_0123456789 INT16, field_30_0 BOOL, field_31_01 UINT32 ARRAY, field_32_012 INT64 ARRAY, field_33_0123 INT16 ARRAY, field_34_01234 INT64, field_35_012345 BOOL, field_36_0123456 INT8, field_37_01234567 INT32, field_38_012345678 INT64 ARRAY, field_39_0123456789 UINT8, field_40_0 INT64 ARRAY, field_41_01 UINT16, field_42_012 RICHREAL, field_43_0123 INT8, field_44_01234 INT32, field_45_012345 UINT16, field_46_0123456 UINT64, field_47_01234567 INT32, field_48_012345678 DATETIME, field_49_0123456789 DATE ARRAY, field_50_0 RICHREAL, field_51_01 UINT16 ARRAY, field_52_012 INT8, field_53_0123 UINT16, field_54_01234 CHAR, field_55_012345 BOOL, field_56_0123456 REAL, field_57_01234567 INT64, field_58_012345678 UINT64, field_59_0123456789 HIRESTIME, field_60_0 HIRESTIME ARRAY, field_61_01 UINT64, field_62_012 UINT64, field_63_0123 RICHREAL ARRAY, field_64_01234 INT64, field_65_012345 UINT8, field_66_0123456 UINT32, field_67_01234567 BOOL, field_68_012345678 INT32, field_69_0123456789 UINT8, field_70_0 UINT64, field_71_01 INT64 ARRAY, field_72_012 UINT32, field_73_0123 INT64 ARRAY, field_74_01234 CHAR, field_75_012345 UINT8, field_76_0123456 UINT64, field_77_01234567 UINT64, field_78_012345678 UINT8, field_79_0123456789 CHAR, field_80_0 HIRESTIME, field_81_01 UINT16 ARRAY, field_82_012 INT16, field_83_0123 UINT16, field_84_01234 REAL, field_85_012345 CHAR, field_86_0123456 INT16)");
      /* 470 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 DATETIME, field_3_0123 RICHREAL, field_4_01234 BOOL ARRAY, field_5_012345 UINT32, field_6_0123456 DATE ARRAY, field_7_01234567 INT64, field_8_012345678 DATETIME, field_9_0123456789 DATETIME, field_10_0 UINT64, field_11_01 REAL ARRAY, field_12_012 UINT8, field_13_0123 UINT8, field_14_01234 DATETIME, field_15_012345 CHAR, field_16_0123456 DATETIME, field_17_01234567 CHAR ARRAY, field_18_012345678 DATETIME, field_19_0123456789 BOOL ARRAY, field_20_0 DATE, field_21_01 DATE, field_22_012 CHAR, field_23_0123 UINT8, field_24_01234 REAL, field_25_012345 CHAR, field_26_0123456 CHAR, field_27_01234567 CHAR, field_28_012345678 CHAR, field_29_0123456789 HIRESTIME, field_30_0 UINT8 ARRAY, field_31_01 UINT8, field_32_012 INT8, field_33_0123 UINT8, field_34_01234 INT8, field_35_012345 CHAR, field_36_0123456 DATE, field_37_01234567 UINT32 ARRAY, field_38_012345678 UINT8, field_39_0123456789 INT8, field_40_0 REAL, field_41_01 INT16, field_42_012 REAL, field_43_0123 INT8 ARRAY, field_44_01234 DATETIME, field_45_012345 UINT16, field_46_0123456 UINT16, field_47_01234567 HIRESTIME, field_48_012345678 INT32 ARRAY, field_49_0123456789 INT64, field_50_0 REAL, field_51_01 UINT64 ARRAY, field_52_012 INT8, field_53_0123 HIRESTIME, field_54_01234 RICHREAL, field_55_012345 INT8 ARRAY, field_56_0123456 BOOL, field_57_01234567 UINT16, field_58_012345678 RICHREAL, field_59_0123456789 DATETIME, field_60_0 HIRESTIME, field_61_01 DATE ARRAY, field_62_012 INT8, field_63_0123 UINT16, field_64_01234 DATE, field_65_012345 BOOL, field_66_0123456 HIRESTIME, field_67_01234567 UINT64, field_68_012345678 UINT32, field_69_0123456789 UINT64, field_70_0 INT8, field_71_01 INT64, field_72_012 UINT8, field_73_0123 INT8, field_74_01234 UINT16, field_75_012345 INT32, field_76_0123456 INT64, field_77_01234567 UINT32, field_78_012345678 UINT64, field_79_0123456789 INT8, field_80_0 INT32, field_81_01 INT64 ARRAY, field_82_012 UINT8 ARRAY, field_83_0123 BOOL ARRAY, field_84_01234 HIRESTIME, field_85_012345 DATE ARRAY, field_86_0123456 REAL, field_87_01234567 UINT64, field_88_012345678 UINT8, field_89_0123456789 INT64)");
      /* 471 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 RICHREAL ARRAY, field_3_0123 UINT64, field_4_01234 DATETIME, field_5_012345 UINT8, field_6_0123456 INT16, field_7_01234567 UINT8, field_8_012345678 UINT64, field_9_0123456789 HIRESTIME, field_10_0 UINT16, field_11_01 CHAR, field_12_012 CHAR, field_13_0123 UINT16, field_14_01234 UINT32, field_15_012345 BOOL, field_16_0123456 UINT8 ARRAY, field_17_01234567 UINT8, field_18_012345678 DATETIME, field_19_0123456789 DATETIME, field_20_0 CHAR, field_21_01 HIRESTIME, field_22_012 DATETIME, field_23_0123 UINT8, field_24_01234 UINT64, field_25_012345 UINT64 ARRAY, field_26_0123456 INT16, field_27_01234567 UINT16, field_28_012345678 RICHREAL, field_29_0123456789 INT32, field_30_0 RICHREAL, field_31_01 DATETIME, field_32_012 HIRESTIME, field_33_0123 HIRESTIME ARRAY, field_34_01234 UINT32, field_35_012345 INT8, field_36_0123456 UINT8, field_37_01234567 BOOL, field_38_012345678 INT32, field_39_0123456789 INT32 ARRAY, field_40_0 INT8, field_41_01 INT8, field_42_012 BOOL, field_43_0123 UINT32 ARRAY, field_44_01234 CHAR, field_45_012345 UINT16, field_46_0123456 INT8, field_47_01234567 INT16, field_48_012345678 INT64, field_49_0123456789 UINT16, field_50_0 RICHREAL, field_51_01 UINT16, field_52_012 INT8, field_53_0123 INT32, field_54_01234 REAL, field_55_012345 UINT8, field_56_0123456 DATETIME, field_57_01234567 DATETIME, field_58_012345678 UINT16, field_59_0123456789 INT16, field_60_0 INT64 ARRAY, field_61_01 DATETIME, field_62_012 UINT64 ARRAY, field_63_0123 DATETIME ARRAY, field_64_01234 INT32, field_65_012345 UINT8, field_66_0123456 INT32, field_67_01234567 INT64, field_68_012345678 REAL ARRAY, field_69_0123456789 HIRESTIME, field_70_0 INT16 ARRAY, field_71_01 INT16, field_72_012 CHAR, field_73_0123 INT32, field_74_01234 BOOL, field_75_012345 RICHREAL, field_76_0123456 UINT8, field_77_01234567 HIRESTIME, field_78_012345678 INT64, field_79_0123456789 DATETIME, field_80_0 INT64, field_81_01 REAL, field_82_012 INT8 ARRAY, field_83_0123 INT16, field_84_01234 RICHREAL ARRAY, field_85_012345 UINT8, field_86_0123456 HIRESTIME, field_87_01234567 UINT32, field_88_012345678 INT32 ARRAY, field_89_0123456789 REAL, field_90_0 DATE, field_91_01 UINT8, field_92_012 DATE ARRAY, field_93_0123 UINT32, field_94_01234 UINT8, field_95_012345 INT32, field_96_0123456 INT8 ARRAY)");
      /* 472 */ glbTypes.push_back("TABLE(field_1_01 REAL ARRAY, field_2_012 BOOL ARRAY, field_3_0123 UINT32, field_4_01234 INT8, field_5_012345 INT8, field_6_0123456 RICHREAL ARRAY, field_7_01234567 HIRESTIME, field_8_012345678 UINT32, field_9_0123456789 BOOL, field_10_0 INT16, field_11_01 REAL, field_12_012 CHAR, field_13_0123 DATETIME, field_14_01234 INT64, field_15_012345 DATETIME, field_16_0123456 UINT16, field_17_01234567 INT8, field_18_012345678 BOOL, field_19_0123456789 CHAR, field_20_0 UINT16, field_21_01 HIRESTIME, field_22_012 UINT64, field_23_0123 DATETIME, field_24_01234 DATETIME ARRAY, field_25_012345 REAL ARRAY, field_26_0123456 REAL ARRAY, field_27_01234567 UINT64 ARRAY, field_28_012345678 INT32 ARRAY, field_29_0123456789 CHAR ARRAY, field_30_0 HIRESTIME, field_31_01 UINT8, field_32_012 INT64, field_33_0123 BOOL, field_34_01234 HIRESTIME, field_35_012345 INT8, field_36_0123456 CHAR, field_37_01234567 INT8 ARRAY, field_38_012345678 DATE, field_39_0123456789 UINT16, field_40_0 UINT64 ARRAY, field_41_01 HIRESTIME, field_42_012 INT64, field_43_0123 DATE, field_44_01234 UINT64, field_45_012345 BOOL ARRAY, field_46_0123456 UINT8, field_47_01234567 BOOL ARRAY, field_48_012345678 HIRESTIME, field_49_0123456789 RICHREAL, field_50_0 BOOL, field_51_01 INT64, field_52_012 INT64, field_53_0123 CHAR, field_54_01234 HIRESTIME, field_55_012345 DATETIME, field_56_0123456 RICHREAL, field_57_01234567 UINT8, field_58_012345678 UINT16 ARRAY, field_59_0123456789 UINT16, field_60_0 INT16, field_61_01 DATETIME, field_62_012 HIRESTIME, field_63_0123 UINT64, field_64_01234 UINT32, field_65_012345 DATETIME, field_66_0123456 INT32, field_67_01234567 INT64, field_68_012345678 BOOL, field_69_0123456789 UINT8 ARRAY, field_70_0 UINT8, field_71_01 UINT32 ARRAY, field_72_012 INT8 ARRAY, field_73_0123 INT32 ARRAY, field_74_01234 REAL, field_75_012345 RICHREAL ARRAY, field_76_0123456 INT64, field_77_01234567 DATETIME, field_78_012345678 UINT8, field_79_0123456789 INT32, field_80_0 INT64, field_81_01 BOOL, field_82_012 REAL, field_83_0123 REAL ARRAY, field_84_01234 INT64, field_85_012345 RICHREAL, field_86_0123456 REAL, field_87_01234567 DATE, field_88_012345678 INT8, field_89_0123456789 REAL, field_90_0 DATETIME, field_91_01 UINT16, field_92_012 DATETIME, field_93_0123 INT64 ARRAY, field_94_01234 REAL, field_95_012345 REAL, field_96_0123456 UINT32 ARRAY)");
      /* 473 */ glbTypes.push_back("TABLE(field_1_01 INT64 ARRAY, field_2_012 UINT32, field_3_0123 INT64, field_4_01234 UINT64, field_5_012345 INT16 ARRAY, field_6_0123456 INT64, field_7_01234567 HIRESTIME, field_8_012345678 CHAR, field_9_0123456789 UINT32, field_10_0 INT64, field_11_01 REAL, field_12_012 INT16, field_13_0123 UINT32, field_14_01234 REAL, field_15_012345 RICHREAL, field_16_0123456 DATETIME, field_17_01234567 UINT16, field_18_012345678 RICHREAL, field_19_0123456789 DATE, field_20_0 UINT32, field_21_01 UINT64, field_22_012 UINT16 ARRAY, field_23_0123 UINT8, field_24_01234 CHAR, field_25_012345 RICHREAL, field_26_0123456 UINT8, field_27_01234567 INT32, field_28_012345678 RICHREAL ARRAY, field_29_0123456789 INT8, field_30_0 INT16, field_31_01 CHAR, field_32_012 INT8, field_33_0123 CHAR, field_34_01234 UINT8, field_35_012345 UINT64 ARRAY, field_36_0123456 CHAR, field_37_01234567 UINT64, field_38_012345678 INT64, field_39_0123456789 REAL ARRAY, field_40_0 REAL, field_41_01 REAL, field_42_012 INT16, field_43_0123 DATE, field_44_01234 UINT64 ARRAY, field_45_012345 UINT16, field_46_0123456 INT16, field_47_01234567 UINT64, field_48_012345678 RICHREAL, field_49_0123456789 UINT16, field_50_0 UINT16, field_51_01 BOOL, field_52_012 UINT8, field_53_0123 RICHREAL, field_54_01234 UINT16, field_55_012345 UINT8 ARRAY, field_56_0123456 UINT64 ARRAY, field_57_01234567 UINT32, field_58_012345678 DATETIME, field_59_0123456789 INT8, field_60_0 BOOL, field_61_01 DATETIME, field_62_012 INT64, field_63_0123 UINT8, field_64_01234 INT16, field_65_012345 REAL, field_66_0123456 BOOL ARRAY, field_67_01234567 INT64, field_68_012345678 CHAR, field_69_0123456789 INT8 ARRAY, field_70_0 INT8, field_71_01 DATE ARRAY, field_72_012 DATETIME)");
      /* 474 */ glbTypes.push_back("TABLE(field_1_01 INT64)");
      /* 475 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 INT8, field_3_0123 INT8, field_4_01234 UINT64, field_5_012345 UINT8, field_6_0123456 INT32, field_7_01234567 INT8 ARRAY, field_8_012345678 BOOL, field_9_0123456789 UINT32, field_10_0 CHAR, field_11_01 BOOL, field_12_012 HIRESTIME, field_13_0123 CHAR, field_14_01234 DATETIME ARRAY, field_15_012345 INT32, field_16_0123456 DATE ARRAY, field_17_01234567 INT32, field_18_012345678 INT64, field_19_0123456789 INT64, field_20_0 INT64, field_21_01 UINT64, field_22_012 UINT64, field_23_0123 RICHREAL, field_24_01234 BOOL ARRAY, field_25_012345 INT32, field_26_0123456 DATE, field_27_01234567 INT8, field_28_012345678 DATE, field_29_0123456789 INT64, field_30_0 CHAR, field_31_01 RICHREAL, field_32_012 BOOL, field_33_0123 RICHREAL, field_34_01234 UINT8, field_35_012345 DATETIME ARRAY, field_36_0123456 INT64, field_37_01234567 DATE, field_38_012345678 INT32, field_39_0123456789 RICHREAL, field_40_0 INT16 ARRAY, field_41_01 UINT16 ARRAY, field_42_012 INT16 ARRAY, field_43_0123 INT32, field_44_01234 CHAR, field_45_012345 HIRESTIME, field_46_0123456 BOOL, field_47_01234567 CHAR, field_48_012345678 INT64, field_49_0123456789 INT8, field_50_0 REAL, field_51_01 DATETIME, field_52_012 UINT16, field_53_0123 INT16, field_54_01234 RICHREAL, field_55_012345 RICHREAL ARRAY, field_56_0123456 INT8, field_57_01234567 UINT32 ARRAY, field_58_012345678 CHAR, field_59_0123456789 DATETIME, field_60_0 UINT32 ARRAY, field_61_01 HIRESTIME, field_62_012 UINT64, field_63_0123 UINT64, field_64_01234 UINT64, field_65_012345 DATETIME ARRAY, field_66_0123456 UINT32, field_67_01234567 DATE, field_68_012345678 INT8, field_69_0123456789 INT32, field_70_0 INT64, field_71_01 BOOL, field_72_012 BOOL, field_73_0123 DATE, field_74_01234 RICHREAL, field_75_012345 UINT64, field_76_0123456 HIRESTIME, field_77_01234567 INT64, field_78_012345678 REAL, field_79_0123456789 UINT64, field_80_0 DATETIME, field_81_01 INT32, field_82_012 INT32, field_83_0123 INT32 ARRAY, field_84_01234 DATETIME ARRAY, field_85_012345 DATE, field_86_0123456 DATETIME, field_87_01234567 INT16, field_88_012345678 DATETIME, field_89_0123456789 INT64, field_90_0 INT8, field_91_01 INT8 ARRAY)");
      /* 476 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 HIRESTIME, field_3_0123 CHAR, field_4_01234 DATETIME ARRAY, field_5_012345 INT64, field_6_0123456 UINT32, field_7_01234567 HIRESTIME ARRAY, field_8_012345678 DATE, field_9_0123456789 RICHREAL, field_10_0 CHAR, field_11_01 UINT16, field_12_012 DATE, field_13_0123 INT32, field_14_01234 DATETIME, field_15_012345 REAL, field_16_0123456 UINT8, field_17_01234567 INT16, field_18_012345678 REAL, field_19_0123456789 UINT16, field_20_0 INT64, field_21_01 CHAR ARRAY, field_22_012 CHAR, field_23_0123 RICHREAL, field_24_01234 BOOL ARRAY, field_25_012345 BOOL, field_26_0123456 DATETIME, field_27_01234567 UINT64, field_28_012345678 DATETIME ARRAY, field_29_0123456789 INT64, field_30_0 DATETIME, field_31_01 DATETIME, field_32_012 CHAR, field_33_0123 DATETIME ARRAY, field_34_01234 UINT16, field_35_012345 INT32, field_36_0123456 UINT64 ARRAY, field_37_01234567 UINT64, field_38_012345678 UINT32 ARRAY, field_39_0123456789 UINT64 ARRAY, field_40_0 HIRESTIME, field_41_01 DATETIME, field_42_012 HIRESTIME, field_43_0123 BOOL ARRAY, field_44_01234 BOOL, field_45_012345 DATETIME, field_46_0123456 DATETIME ARRAY, field_47_01234567 UINT64, field_48_012345678 REAL, field_49_0123456789 INT16, field_50_0 DATETIME, field_51_01 UINT16 ARRAY, field_52_012 UINT8, field_53_0123 DATE, field_54_01234 UINT16 ARRAY, field_55_012345 UINT8, field_56_0123456 BOOL ARRAY, field_57_01234567 DATETIME, field_58_012345678 UINT8, field_59_0123456789 RICHREAL, field_60_0 UINT8, field_61_01 INT64, field_62_012 UINT8, field_63_0123 INT32, field_64_01234 UINT16, field_65_012345 UINT16, field_66_0123456 HIRESTIME, field_67_01234567 RICHREAL, field_68_012345678 UINT64 ARRAY, field_69_0123456789 BOOL ARRAY, field_70_0 INT8, field_71_01 INT16, field_72_012 DATE, field_73_0123 BOOL ARRAY, field_74_01234 INT8, field_75_012345 UINT64 ARRAY, field_76_0123456 REAL, field_77_01234567 RICHREAL, field_78_012345678 INT64, field_79_0123456789 INT16, field_80_0 RICHREAL, field_81_01 REAL ARRAY, field_82_012 RICHREAL)");
      /* 477 */ glbTypes.push_back("TABLE(field_1_01 UINT32 ARRAY)");
      /* 478 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 INT32, field_3_0123 INT16 ARRAY, field_4_01234 INT64, field_5_012345 UINT16, field_6_0123456 UINT64 ARRAY, field_7_01234567 UINT8 ARRAY, field_8_012345678 BOOL, field_9_0123456789 HIRESTIME ARRAY, field_10_0 UINT32, field_11_01 UINT32, field_12_012 CHAR, field_13_0123 UINT16, field_14_01234 REAL, field_15_012345 CHAR, field_16_0123456 UINT32, field_17_01234567 UINT32, field_18_012345678 DATE, field_19_0123456789 INT32, field_20_0 UINT16, field_21_01 UINT32, field_22_012 INT64, field_23_0123 UINT8, field_24_01234 UINT32 ARRAY, field_25_012345 INT32 ARRAY, field_26_0123456 CHAR, field_27_01234567 DATETIME, field_28_012345678 INT64, field_29_0123456789 INT16 ARRAY, field_30_0 UINT8, field_31_01 HIRESTIME, field_32_012 INT16, field_33_0123 UINT64, field_34_01234 REAL, field_35_012345 RICHREAL, field_36_0123456 UINT64, field_37_01234567 INT8, field_38_012345678 DATETIME, field_39_0123456789 INT64, field_40_0 CHAR, field_41_01 BOOL, field_42_012 HIRESTIME ARRAY, field_43_0123 INT16, field_44_01234 BOOL, field_45_012345 INT16, field_46_0123456 INT32, field_47_01234567 RICHREAL ARRAY, field_48_012345678 UINT64 ARRAY, field_49_0123456789 INT16, field_50_0 INT64 ARRAY, field_51_01 UINT32, field_52_012 BOOL, field_53_0123 INT32 ARRAY, field_54_01234 INT8 ARRAY, field_55_012345 REAL, field_56_0123456 REAL, field_57_01234567 RICHREAL, field_58_012345678 REAL, field_59_0123456789 HIRESTIME, field_60_0 UINT8, field_61_01 UINT16, field_62_012 INT64 ARRAY, field_63_0123 INT64 ARRAY, field_64_01234 BOOL, field_65_012345 RICHREAL)");
      /* 479 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 INT32, field_3_0123 REAL, field_4_01234 BOOL, field_5_012345 INT8, field_6_0123456 DATE, field_7_01234567 UINT16, field_8_012345678 INT16, field_9_0123456789 CHAR, field_10_0 INT32)");
      /* 480 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 INT16 ARRAY, field_3_0123 REAL, field_4_01234 INT16, field_5_012345 BOOL, field_6_0123456 DATETIME, field_7_01234567 CHAR ARRAY, field_8_012345678 INT16, field_9_0123456789 BOOL, field_10_0 UINT32, field_11_01 HIRESTIME, field_12_012 REAL, field_13_0123 INT64, field_14_01234 DATE ARRAY, field_15_012345 DATE, field_16_0123456 BOOL, field_17_01234567 REAL ARRAY, field_18_012345678 HIRESTIME, field_19_0123456789 UINT8, field_20_0 RICHREAL, field_21_01 UINT16, field_22_012 INT32, field_23_0123 DATE, field_24_01234 DATE ARRAY, field_25_012345 REAL, field_26_0123456 REAL ARRAY, field_27_01234567 INT32, field_28_012345678 UINT8, field_29_0123456789 INT32, field_30_0 INT64 ARRAY, field_31_01 HIRESTIME, field_32_012 UINT8, field_33_0123 UINT16, field_34_01234 REAL ARRAY, field_35_012345 INT8, field_36_0123456 CHAR, field_37_01234567 DATETIME ARRAY, field_38_012345678 INT32 ARRAY, field_39_0123456789 UINT16, field_40_0 INT32, field_41_01 UINT8, field_42_012 REAL, field_43_0123 UINT32 ARRAY, field_44_01234 BOOL ARRAY, field_45_012345 CHAR, field_46_0123456 RICHREAL ARRAY, field_47_01234567 REAL, field_48_012345678 UINT32, field_49_0123456789 DATETIME, field_50_0 INT32, field_51_01 HIRESTIME, field_52_012 RICHREAL, field_53_0123 DATE, field_54_01234 REAL ARRAY, field_55_012345 INT8, field_56_0123456 HIRESTIME ARRAY, field_57_01234567 UINT32, field_58_012345678 RICHREAL, field_59_0123456789 UINT16, field_60_0 CHAR, field_61_01 CHAR, field_62_012 INT16, field_63_0123 HIRESTIME, field_64_01234 HIRESTIME, field_65_012345 BOOL, field_66_0123456 INT64, field_67_01234567 CHAR, field_68_012345678 INT64 ARRAY, field_69_0123456789 INT8, field_70_0 RICHREAL, field_71_01 HIRESTIME, field_72_012 REAL, field_73_0123 BOOL, field_74_01234 UINT16 ARRAY, field_75_012345 UINT32, field_76_0123456 DATETIME, field_77_01234567 INT8, field_78_012345678 UINT32, field_79_0123456789 HIRESTIME ARRAY)");
      /* 481 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL ARRAY, field_2_012 REAL, field_3_0123 HIRESTIME, field_4_01234 UINT64, field_5_012345 DATETIME ARRAY, field_6_0123456 DATE, field_7_01234567 UINT16, field_8_012345678 INT32, field_9_0123456789 HIRESTIME ARRAY, field_10_0 INT32, field_11_01 UINT64, field_12_012 INT16, field_13_0123 BOOL ARRAY, field_14_01234 CHAR, field_15_012345 DATE, field_16_0123456 INT8, field_17_01234567 INT16, field_18_012345678 RICHREAL ARRAY, field_19_0123456789 RICHREAL, field_20_0 UINT64 ARRAY, field_21_01 UINT64 ARRAY, field_22_012 INT8, field_23_0123 UINT16, field_24_01234 DATE, field_25_012345 REAL, field_26_0123456 CHAR, field_27_01234567 UINT8, field_28_012345678 CHAR, field_29_0123456789 DATETIME, field_30_0 DATE, field_31_01 DATETIME, field_32_012 INT64)");
      /* 482 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 INT32, field_3_0123 INT8, field_4_01234 UINT32, field_5_012345 INT32, field_6_0123456 UINT32, field_7_01234567 UINT8 ARRAY, field_8_012345678 REAL, field_9_0123456789 DATE, field_10_0 INT32, field_11_01 UINT64, field_12_012 UINT32, field_13_0123 BOOL, field_14_01234 HIRESTIME, field_15_012345 HIRESTIME, field_16_0123456 CHAR, field_17_01234567 RICHREAL, field_18_012345678 REAL ARRAY, field_19_0123456789 CHAR ARRAY, field_20_0 DATETIME, field_21_01 UINT32, field_22_012 DATETIME, field_23_0123 INT64, field_24_01234 INT16 ARRAY, field_25_012345 DATE, field_26_0123456 UINT64 ARRAY, field_27_01234567 UINT8, field_28_012345678 DATE, field_29_0123456789 RICHREAL, field_30_0 INT8, field_31_01 DATETIME, field_32_012 DATETIME, field_33_0123 DATE, field_34_01234 CHAR, field_35_012345 BOOL, field_36_0123456 UINT8, field_37_01234567 INT64, field_38_012345678 DATETIME, field_39_0123456789 UINT64 ARRAY, field_40_0 INT16, field_41_01 UINT8, field_42_012 UINT8, field_43_0123 UINT64 ARRAY, field_44_01234 INT8, field_45_012345 BOOL, field_46_0123456 UINT8, field_47_01234567 INT64, field_48_012345678 UINT16, field_49_0123456789 CHAR, field_50_0 DATE, field_51_01 INT32, field_52_012 UINT8 ARRAY, field_53_0123 UINT64 ARRAY, field_54_01234 INT8 ARRAY, field_55_012345 INT64 ARRAY, field_56_0123456 UINT16 ARRAY, field_57_01234567 INT32 ARRAY, field_58_012345678 REAL, field_59_0123456789 INT64, field_60_0 DATETIME, field_61_01 UINT8, field_62_012 INT16, field_63_0123 UINT8, field_64_01234 INT32, field_65_012345 DATETIME, field_66_0123456 UINT32, field_67_01234567 DATE, field_68_012345678 UINT32, field_69_0123456789 HIRESTIME ARRAY, field_70_0 INT64, field_71_01 INT64, field_72_012 BOOL, field_73_0123 DATETIME, field_74_01234 INT64, field_75_012345 UINT32 ARRAY, field_76_0123456 UINT8, field_77_01234567 RICHREAL, field_78_012345678 HIRESTIME, field_79_0123456789 DATETIME, field_80_0 DATETIME, field_81_01 UINT8 ARRAY, field_82_012 HIRESTIME, field_83_0123 HIRESTIME, field_84_01234 CHAR, field_85_012345 INT64, field_86_0123456 INT32, field_87_01234567 INT64 ARRAY, field_88_012345678 RICHREAL, field_89_0123456789 INT16 ARRAY, field_90_0 INT16, field_91_01 DATETIME, field_92_012 UINT32, field_93_0123 INT8, field_94_01234 INT32, field_95_012345 RICHREAL, field_96_0123456 REAL, field_97_01234567 UINT64, field_98_012345678 UINT16 ARRAY)");
      /* 483 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 INT64, field_3_0123 INT16, field_4_01234 HIRESTIME, field_5_012345 UINT8 ARRAY, field_6_0123456 INT64, field_7_01234567 UINT64, field_8_012345678 INT8, field_9_0123456789 RICHREAL, field_10_0 INT64, field_11_01 INT32, field_12_012 DATE, field_13_0123 INT32, field_14_01234 BOOL ARRAY, field_15_012345 INT64, field_16_0123456 UINT64, field_17_01234567 INT8, field_18_012345678 INT32, field_19_0123456789 CHAR ARRAY, field_20_0 INT16, field_21_01 HIRESTIME, field_22_012 REAL, field_23_0123 BOOL ARRAY, field_24_01234 DATE, field_25_012345 UINT32, field_26_0123456 INT64, field_27_01234567 INT16 ARRAY, field_28_012345678 INT32, field_29_0123456789 INT32, field_30_0 UINT64 ARRAY, field_31_01 UINT32, field_32_012 INT32, field_33_0123 UINT64, field_34_01234 INT32 ARRAY, field_35_012345 RICHREAL, field_36_0123456 UINT8, field_37_01234567 INT64, field_38_012345678 UINT64 ARRAY, field_39_0123456789 DATETIME ARRAY, field_40_0 REAL ARRAY, field_41_01 HIRESTIME, field_42_012 UINT64, field_43_0123 CHAR, field_44_01234 REAL, field_45_012345 INT16, field_46_0123456 REAL, field_47_01234567 REAL ARRAY, field_48_012345678 BOOL, field_49_0123456789 INT32, field_50_0 INT8 ARRAY, field_51_01 INT64, field_52_012 REAL, field_53_0123 DATE, field_54_01234 INT8, field_55_012345 UINT8, field_56_0123456 INT32, field_57_01234567 UINT16, field_58_012345678 UINT32, field_59_0123456789 DATE, field_60_0 UINT32)");
      /* 484 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 UINT8, field_3_0123 INT8, field_4_01234 UINT32, field_5_012345 BOOL, field_6_0123456 INT64 ARRAY, field_7_01234567 RICHREAL, field_8_012345678 INT64 ARRAY, field_9_0123456789 RICHREAL, field_10_0 UINT8, field_11_01 UINT64, field_12_012 DATETIME, field_13_0123 INT32 ARRAY, field_14_01234 INT16 ARRAY, field_15_012345 RICHREAL, field_16_0123456 INT16, field_17_01234567 UINT8, field_18_012345678 INT32, field_19_0123456789 REAL ARRAY, field_20_0 UINT16, field_21_01 DATE, field_22_012 INT64, field_23_0123 UINT32, field_24_01234 INT16, field_25_012345 UINT32, field_26_0123456 CHAR ARRAY, field_27_01234567 RICHREAL, field_28_012345678 UINT8 ARRAY)");
      /* 485 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 BOOL, field_3_0123 INT8, field_4_01234 UINT32, field_5_012345 DATE, field_6_0123456 UINT64, field_7_01234567 DATETIME, field_8_012345678 INT16, field_9_0123456789 INT64, field_10_0 BOOL, field_11_01 INT8 ARRAY, field_12_012 UINT64)");
      /* 486 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 BOOL, field_3_0123 REAL, field_4_01234 INT16 ARRAY, field_5_012345 INT16 ARRAY, field_6_0123456 INT64, field_7_01234567 INT32, field_8_012345678 DATE, field_9_0123456789 RICHREAL ARRAY, field_10_0 CHAR, field_11_01 UINT16, field_12_012 INT8, field_13_0123 CHAR, field_14_01234 INT32, field_15_012345 INT32 ARRAY, field_16_0123456 INT8, field_17_01234567 UINT8, field_18_012345678 REAL ARRAY, field_19_0123456789 HIRESTIME, field_20_0 CHAR, field_21_01 BOOL, field_22_012 DATETIME, field_23_0123 DATE, field_24_01234 INT8, field_25_012345 INT32, field_26_0123456 CHAR, field_27_01234567 CHAR ARRAY, field_28_012345678 UINT8, field_29_0123456789 DATETIME, field_30_0 DATE, field_31_01 INT8 ARRAY, field_32_012 UINT8 ARRAY, field_33_0123 UINT16, field_34_01234 DATETIME, field_35_012345 UINT8, field_36_0123456 DATE, field_37_01234567 BOOL ARRAY, field_38_012345678 DATE, field_39_0123456789 INT64, field_40_0 UINT32 ARRAY, field_41_01 INT32, field_42_012 INT16, field_43_0123 DATETIME ARRAY, field_44_01234 INT16, field_45_012345 DATE, field_46_0123456 DATETIME, field_47_01234567 UINT64, field_48_012345678 UINT32, field_49_0123456789 CHAR, field_50_0 REAL, field_51_01 BOOL, field_52_012 REAL, field_53_0123 INT8, field_54_01234 REAL ARRAY)");
      /* 487 */ glbTypes.push_back("TABLE(field_1_01 INT32 ARRAY, field_2_012 CHAR, field_3_0123 BOOL ARRAY, field_4_01234 INT32, field_5_012345 CHAR, field_6_0123456 UINT8, field_7_01234567 HIRESTIME, field_8_012345678 DATETIME, field_9_0123456789 DATETIME, field_10_0 RICHREAL, field_11_01 INT16, field_12_012 INT16, field_13_0123 UINT16, field_14_01234 CHAR ARRAY, field_15_012345 UINT16, field_16_0123456 UINT64, field_17_01234567 INT64, field_18_012345678 UINT64, field_19_0123456789 INT64, field_20_0 DATETIME, field_21_01 DATETIME, field_22_012 REAL, field_23_0123 INT16, field_24_01234 UINT32, field_25_012345 INT32, field_26_0123456 BOOL, field_27_01234567 UINT32, field_28_012345678 HIRESTIME, field_29_0123456789 DATETIME ARRAY, field_30_0 BOOL)");
      /* 488 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 INT16, field_3_0123 INT64 ARRAY, field_4_01234 DATE, field_5_012345 CHAR, field_6_0123456 DATE, field_7_01234567 UINT8, field_8_012345678 INT64, field_9_0123456789 INT16, field_10_0 UINT8, field_11_01 CHAR, field_12_012 RICHREAL, field_13_0123 UINT64, field_14_01234 CHAR, field_15_012345 CHAR, field_16_0123456 INT8, field_17_01234567 INT32, field_18_012345678 DATE ARRAY, field_19_0123456789 INT64 ARRAY, field_20_0 UINT8, field_21_01 HIRESTIME ARRAY, field_22_012 DATETIME ARRAY, field_23_0123 CHAR, field_24_01234 DATE ARRAY, field_25_012345 UINT8, field_26_0123456 INT16, field_27_01234567 UINT16, field_28_012345678 RICHREAL, field_29_0123456789 UINT64 ARRAY, field_30_0 UINT32, field_31_01 UINT64, field_32_012 UINT32, field_33_0123 CHAR ARRAY, field_34_01234 DATETIME ARRAY, field_35_012345 INT16, field_36_0123456 UINT64, field_37_01234567 INT8 ARRAY, field_38_012345678 HIRESTIME, field_39_0123456789 INT8 ARRAY, field_40_0 RICHREAL, field_41_01 UINT16, field_42_012 BOOL, field_43_0123 CHAR, field_44_01234 CHAR, field_45_012345 BOOL ARRAY, field_46_0123456 UINT8, field_47_01234567 HIRESTIME, field_48_012345678 INT64, field_49_0123456789 UINT16 ARRAY, field_50_0 INT32, field_51_01 DATE, field_52_012 REAL, field_53_0123 DATE, field_54_01234 UINT64, field_55_012345 DATETIME ARRAY, field_56_0123456 UINT8, field_57_01234567 INT16, field_58_012345678 UINT32, field_59_0123456789 INT8, field_60_0 INT32, field_61_01 UINT64, field_62_012 BOOL, field_63_0123 UINT16, field_64_01234 CHAR, field_65_012345 HIRESTIME ARRAY, field_66_0123456 DATE, field_67_01234567 UINT32 ARRAY, field_68_012345678 INT32, field_69_0123456789 INT8, field_70_0 RICHREAL, field_71_01 REAL, field_72_012 DATETIME, field_73_0123 REAL, field_74_01234 UINT16, field_75_012345 INT32 ARRAY, field_76_0123456 INT16, field_77_01234567 UINT32, field_78_012345678 DATE, field_79_0123456789 UINT32, field_80_0 UINT64, field_81_01 INT64, field_82_012 HIRESTIME, field_83_0123 INT64, field_84_01234 INT16, field_85_012345 DATETIME, field_86_0123456 INT32)");
      /* 489 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 UINT32 ARRAY, field_3_0123 DATETIME, field_4_01234 DATETIME, field_5_012345 UINT8, field_6_0123456 INT32 ARRAY, field_7_01234567 RICHREAL, field_8_012345678 UINT16, field_9_0123456789 INT64, field_10_0 DATE, field_11_01 UINT64, field_12_012 INT16 ARRAY, field_13_0123 INT16, field_14_01234 UINT8, field_15_012345 UINT32, field_16_0123456 INT64, field_17_01234567 DATE, field_18_012345678 RICHREAL ARRAY, field_19_0123456789 UINT8, field_20_0 INT64, field_21_01 INT64, field_22_012 DATE ARRAY, field_23_0123 DATE, field_24_01234 RICHREAL, field_25_012345 INT8 ARRAY, field_26_0123456 BOOL ARRAY, field_27_01234567 DATE, field_28_012345678 CHAR, field_29_0123456789 REAL, field_30_0 INT32, field_31_01 UINT32, field_32_012 CHAR, field_33_0123 UINT16, field_34_01234 UINT64, field_35_012345 UINT32, field_36_0123456 BOOL ARRAY, field_37_01234567 UINT8, field_38_012345678 HIRESTIME ARRAY, field_39_0123456789 UINT64, field_40_0 DATETIME, field_41_01 DATE, field_42_012 REAL, field_43_0123 INT16, field_44_01234 RICHREAL ARRAY, field_45_012345 INT64, field_46_0123456 DATETIME, field_47_01234567 REAL, field_48_012345678 INT32, field_49_0123456789 INT32, field_50_0 RICHREAL, field_51_01 REAL, field_52_012 UINT32, field_53_0123 INT16, field_54_01234 INT32, field_55_012345 UINT32, field_56_0123456 INT16, field_57_01234567 BOOL, field_58_012345678 RICHREAL, field_59_0123456789 INT64, field_60_0 DATE, field_61_01 CHAR, field_62_012 INT8 ARRAY, field_63_0123 HIRESTIME, field_64_01234 INT8 ARRAY, field_65_012345 RICHREAL, field_66_0123456 UINT8, field_67_01234567 INT32 ARRAY, field_68_012345678 INT32, field_69_0123456789 UINT8 ARRAY, field_70_0 DATE, field_71_01 DATETIME, field_72_012 DATE, field_73_0123 UINT64, field_74_01234 INT32, field_75_012345 DATETIME, field_76_0123456 DATETIME, field_77_01234567 INT16 ARRAY, field_78_012345678 CHAR ARRAY, field_79_0123456789 BOOL, field_80_0 DATETIME, field_81_01 INT8)");
      /* 490 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 INT32, field_3_0123 INT16, field_4_01234 UINT8, field_5_012345 INT8 ARRAY, field_6_0123456 UINT32, field_7_01234567 REAL, field_8_012345678 CHAR, field_9_0123456789 INT8, field_10_0 UINT64 ARRAY, field_11_01 INT8, field_12_012 UINT16, field_13_0123 INT8, field_14_01234 INT64, field_15_012345 INT64, field_16_0123456 UINT32, field_17_01234567 RICHREAL, field_18_012345678 DATETIME, field_19_0123456789 UINT8, field_20_0 INT8 ARRAY, field_21_01 UINT32, field_22_012 REAL, field_23_0123 UINT16, field_24_01234 REAL ARRAY, field_25_012345 UINT8, field_26_0123456 UINT16, field_27_01234567 UINT32 ARRAY, field_28_012345678 UINT16 ARRAY, field_29_0123456789 REAL ARRAY, field_30_0 INT8, field_31_01 UINT64, field_32_012 UINT16, field_33_0123 BOOL, field_34_01234 HIRESTIME ARRAY, field_35_012345 UINT8, field_36_0123456 HIRESTIME, field_37_01234567 DATE, field_38_012345678 UINT32, field_39_0123456789 INT32, field_40_0 UINT64, field_41_01 UINT8, field_42_012 DATE, field_43_0123 DATETIME ARRAY)");
      /* 491 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 UINT16, field_3_0123 REAL, field_4_01234 INT32 ARRAY, field_5_012345 DATETIME, field_6_0123456 RICHREAL, field_7_01234567 INT64, field_8_012345678 DATE, field_9_0123456789 INT8, field_10_0 INT32, field_11_01 RICHREAL ARRAY, field_12_012 INT32 ARRAY, field_13_0123 INT32, field_14_01234 INT32, field_15_012345 INT32, field_16_0123456 RICHREAL, field_17_01234567 CHAR, field_18_012345678 BOOL, field_19_0123456789 DATE, field_20_0 DATETIME, field_21_01 INT32, field_22_012 RICHREAL, field_23_0123 BOOL, field_24_01234 UINT16, field_25_012345 HIRESTIME, field_26_0123456 INT64, field_27_01234567 RICHREAL, field_28_012345678 INT16, field_29_0123456789 REAL, field_30_0 INT32, field_31_01 UINT64, field_32_012 UINT8, field_33_0123 INT8 ARRAY, field_34_01234 UINT8)");
      /* 492 */ glbTypes.push_back("TABLE(field_1_01 BOOL ARRAY, field_2_012 INT16, field_3_0123 DATETIME, field_4_01234 DATETIME, field_5_012345 DATETIME, field_6_0123456 INT32, field_7_01234567 UINT64, field_8_012345678 HIRESTIME, field_9_0123456789 INT16, field_10_0 UINT8, field_11_01 CHAR, field_12_012 UINT32, field_13_0123 DATE ARRAY, field_14_01234 REAL, field_15_012345 INT32, field_16_0123456 UINT8, field_17_01234567 CHAR, field_18_012345678 UINT32 ARRAY, field_19_0123456789 DATE, field_20_0 DATETIME ARRAY, field_21_01 INT16 ARRAY, field_22_012 UINT32, field_23_0123 INT32, field_24_01234 CHAR, field_25_012345 INT8, field_26_0123456 CHAR ARRAY, field_27_01234567 BOOL, field_28_012345678 INT64, field_29_0123456789 UINT32, field_30_0 BOOL, field_31_01 UINT32, field_32_012 REAL ARRAY, field_33_0123 DATETIME, field_34_01234 INT8 ARRAY, field_35_012345 UINT8, field_36_0123456 UINT16, field_37_01234567 BOOL, field_38_012345678 BOOL ARRAY, field_39_0123456789 INT16 ARRAY, field_40_0 INT32, field_41_01 DATE, field_42_012 INT32 ARRAY, field_43_0123 UINT16, field_44_01234 UINT8 ARRAY, field_45_012345 HIRESTIME ARRAY, field_46_0123456 BOOL, field_47_01234567 BOOL, field_48_012345678 INT8, field_49_0123456789 INT8, field_50_0 BOOL, field_51_01 INT8 ARRAY, field_52_012 UINT16, field_53_0123 UINT16, field_54_01234 UINT8, field_55_012345 UINT16 ARRAY, field_56_0123456 CHAR, field_57_01234567 UINT8, field_58_012345678 INT64, field_59_0123456789 INT32)");
      /* 493 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME ARRAY, field_2_012 DATETIME, field_3_0123 DATE, field_4_01234 DATETIME, field_5_012345 INT32, field_6_0123456 DATETIME, field_7_01234567 INT8 ARRAY, field_8_012345678 BOOL, field_9_0123456789 INT8, field_10_0 CHAR, field_11_01 DATE, field_12_012 BOOL, field_13_0123 CHAR, field_14_01234 CHAR, field_15_012345 INT64, field_16_0123456 UINT32, field_17_01234567 UINT64 ARRAY, field_18_012345678 UINT32, field_19_0123456789 DATE, field_20_0 DATE, field_21_01 UINT8, field_22_012 INT32, field_23_0123 UINT64, field_24_01234 UINT8, field_25_012345 INT16, field_26_0123456 UINT16 ARRAY, field_27_01234567 RICHREAL, field_28_012345678 INT64, field_29_0123456789 INT64, field_30_0 INT64, field_31_01 INT16, field_32_012 UINT8, field_33_0123 CHAR, field_34_01234 UINT16 ARRAY, field_35_012345 UINT64, field_36_0123456 INT8, field_37_01234567 REAL, field_38_012345678 DATETIME, field_39_0123456789 RICHREAL, field_40_0 DATETIME, field_41_01 DATETIME ARRAY, field_42_012 REAL, field_43_0123 INT16, field_44_01234 INT8, field_45_012345 DATETIME, field_46_0123456 HIRESTIME, field_47_01234567 INT8, field_48_012345678 UINT16, field_49_0123456789 REAL ARRAY, field_50_0 UINT8, field_51_01 BOOL, field_52_012 UINT32, field_53_0123 INT32, field_54_01234 UINT16, field_55_012345 BOOL, field_56_0123456 DATE, field_57_01234567 REAL ARRAY, field_58_012345678 UINT8 ARRAY, field_59_0123456789 DATETIME, field_60_0 INT8)");
      /* 494 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 DATE, field_3_0123 INT8, field_4_01234 CHAR, field_5_012345 DATE ARRAY, field_6_0123456 INT16 ARRAY, field_7_01234567 INT64, field_8_012345678 INT64, field_9_0123456789 UINT16 ARRAY, field_10_0 UINT32, field_11_01 REAL, field_12_012 INT16, field_13_0123 INT32, field_14_01234 UINT32, field_15_012345 DATETIME, field_16_0123456 RICHREAL, field_17_01234567 CHAR, field_18_012345678 INT32, field_19_0123456789 UINT16, field_20_0 DATE, field_21_01 DATE, field_22_012 UINT16, field_23_0123 INT32, field_24_01234 INT32, field_25_012345 CHAR, field_26_0123456 RICHREAL, field_27_01234567 UINT64, field_28_012345678 UINT64, field_29_0123456789 CHAR ARRAY, field_30_0 DATE, field_31_01 UINT32, field_32_012 UINT32, field_33_0123 INT16, field_34_01234 CHAR, field_35_012345 DATE, field_36_0123456 DATETIME, field_37_01234567 UINT64, field_38_012345678 RICHREAL ARRAY, field_39_0123456789 INT32, field_40_0 INT64, field_41_01 UINT64, field_42_012 RICHREAL, field_43_0123 INT64, field_44_01234 DATE ARRAY, field_45_012345 UINT8 ARRAY, field_46_0123456 DATE, field_47_01234567 INT32, field_48_012345678 REAL, field_49_0123456789 REAL, field_50_0 UINT32, field_51_01 INT8, field_52_012 HIRESTIME, field_53_0123 UINT64, field_54_01234 CHAR, field_55_012345 DATE, field_56_0123456 UINT32, field_57_01234567 CHAR ARRAY, field_58_012345678 BOOL, field_59_0123456789 UINT32, field_60_0 UINT32, field_61_01 UINT32, field_62_012 DATETIME, field_63_0123 INT8, field_64_01234 UINT32 ARRAY, field_65_012345 REAL, field_66_0123456 HIRESTIME, field_67_01234567 BOOL, field_68_012345678 INT32, field_69_0123456789 CHAR)");
      /* 495 */ glbTypes.push_back("TABLE(field_1_01 INT16 ARRAY, field_2_012 BOOL, field_3_0123 CHAR)");
      /* 496 */ glbTypes.push_back("TABLE(field_1_01 UINT16 ARRAY, field_2_012 DATETIME, field_3_0123 INT64, field_4_01234 CHAR, field_5_012345 INT8 ARRAY, field_6_0123456 UINT8, field_7_01234567 UINT8, field_8_012345678 INT64, field_9_0123456789 INT64 ARRAY, field_10_0 INT32, field_11_01 HIRESTIME ARRAY, field_12_012 UINT64, field_13_0123 DATETIME ARRAY, field_14_01234 UINT16 ARRAY, field_15_012345 CHAR, field_16_0123456 CHAR, field_17_01234567 REAL, field_18_012345678 INT32, field_19_0123456789 DATE, field_20_0 INT64, field_21_01 INT64 ARRAY, field_22_012 BOOL, field_23_0123 INT8, field_24_01234 INT32, field_25_012345 CHAR, field_26_0123456 HIRESTIME, field_27_01234567 INT8, field_28_012345678 INT16, field_29_0123456789 DATETIME, field_30_0 REAL ARRAY, field_31_01 UINT16, field_32_012 UINT64, field_33_0123 DATE, field_34_01234 REAL, field_35_012345 BOOL, field_36_0123456 UINT32, field_37_01234567 UINT64, field_38_012345678 RICHREAL, field_39_0123456789 BOOL, field_40_0 DATETIME ARRAY, field_41_01 REAL, field_42_012 BOOL, field_43_0123 REAL, field_44_01234 INT8 ARRAY, field_45_012345 UINT32, field_46_0123456 UINT16, field_47_01234567 UINT8, field_48_012345678 DATE, field_49_0123456789 INT64 ARRAY, field_50_0 DATE, field_51_01 INT32, field_52_012 DATE, field_53_0123 HIRESTIME, field_54_01234 DATETIME ARRAY, field_55_012345 REAL, field_56_0123456 DATETIME, field_57_01234567 DATE, field_58_012345678 UINT64)");
      /* 497 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 BOOL ARRAY, field_3_0123 INT64, field_4_01234 CHAR, field_5_012345 INT64, field_6_0123456 INT32, field_7_01234567 REAL, field_8_012345678 UINT32, field_9_0123456789 UINT8, field_10_0 BOOL, field_11_01 INT16, field_12_012 INT64, field_13_0123 INT64, field_14_01234 INT16, field_15_012345 BOOL, field_16_0123456 INT32, field_17_01234567 UINT64, field_18_012345678 DATE, field_19_0123456789 UINT32 ARRAY, field_20_0 UINT64, field_21_01 INT64, field_22_012 INT64 ARRAY, field_23_0123 UINT16, field_24_01234 BOOL, field_25_012345 CHAR, field_26_0123456 DATE, field_27_01234567 DATE ARRAY, field_28_012345678 HIRESTIME, field_29_0123456789 DATETIME ARRAY, field_30_0 UINT16, field_31_01 INT16)");
      /* 498 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 INT64, field_3_0123 CHAR, field_4_01234 INT16, field_5_012345 INT64 ARRAY, field_6_0123456 DATE, field_7_01234567 INT32, field_8_012345678 UINT32, field_9_0123456789 CHAR, field_10_0 INT16, field_11_01 CHAR, field_12_012 UINT64, field_13_0123 RICHREAL, field_14_01234 HIRESTIME, field_15_012345 UINT16, field_16_0123456 RICHREAL, field_17_01234567 CHAR, field_18_012345678 DATETIME, field_19_0123456789 REAL, field_20_0 UINT16, field_21_01 CHAR ARRAY, field_22_012 UINT16, field_23_0123 BOOL ARRAY, field_24_01234 UINT64, field_25_012345 INT16 ARRAY, field_26_0123456 INT16, field_27_01234567 HIRESTIME, field_28_012345678 DATE, field_29_0123456789 HIRESTIME, field_30_0 BOOL, field_31_01 INT8, field_32_012 INT16, field_33_0123 BOOL ARRAY, field_34_01234 INT8 ARRAY, field_35_012345 CHAR, field_36_0123456 INT16, field_37_01234567 HIRESTIME ARRAY, field_38_012345678 HIRESTIME ARRAY, field_39_0123456789 UINT16, field_40_0 DATE, field_41_01 DATETIME, field_42_012 INT32 ARRAY, field_43_0123 HIRESTIME ARRAY, field_44_01234 CHAR, field_45_012345 INT8, field_46_0123456 DATE ARRAY, field_47_01234567 INT32, field_48_012345678 REAL, field_49_0123456789 UINT32, field_50_0 HIRESTIME, field_51_01 INT8, field_52_012 UINT16, field_53_0123 INT8 ARRAY, field_54_01234 CHAR, field_55_012345 DATETIME, field_56_0123456 RICHREAL, field_57_01234567 BOOL, field_58_012345678 DATETIME, field_59_0123456789 INT8 ARRAY, field_60_0 UINT64, field_61_01 INT16, field_62_012 BOOL, field_63_0123 BOOL ARRAY, field_64_01234 CHAR ARRAY, field_65_012345 DATETIME, field_66_0123456 RICHREAL ARRAY, field_67_01234567 HIRESTIME, field_68_012345678 BOOL ARRAY, field_69_0123456789 DATETIME, field_70_0 BOOL)");
      /* 499 */ glbTypes.push_back("TABLE(field_1_01 BOOL ARRAY, field_2_012 INT16, field_3_0123 UINT16, field_4_01234 BOOL, field_5_012345 REAL, field_6_0123456 INT64, field_7_01234567 INT32, field_8_012345678 INT8, field_9_0123456789 BOOL, field_10_0 UINT16, field_11_01 UINT8 ARRAY, field_12_012 DATETIME, field_13_0123 UINT32, field_14_01234 BOOL, field_15_012345 INT8, field_16_0123456 UINT64 ARRAY)");
      /* 500 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 BOOL, field_3_0123 BOOL, field_4_01234 BOOL, field_5_012345 INT32, field_6_0123456 INT16, field_7_01234567 DATETIME, field_8_012345678 DATE, field_9_0123456789 INT32, field_10_0 HIRESTIME, field_11_01 UINT8, field_12_012 INT32 ARRAY, field_13_0123 DATE, field_14_01234 DATETIME, field_15_012345 INT32 ARRAY, field_16_0123456 UINT8, field_17_01234567 RICHREAL, field_18_012345678 UINT8, field_19_0123456789 BOOL, field_20_0 UINT64 ARRAY, field_21_01 BOOL, field_22_012 DATE, field_23_0123 UINT32, field_24_01234 INT64, field_25_012345 INT16 ARRAY, field_26_0123456 UINT32, field_27_01234567 UINT32 ARRAY, field_28_012345678 INT8, field_29_0123456789 INT16, field_30_0 HIRESTIME, field_31_01 RICHREAL ARRAY, field_32_012 INT16, field_33_0123 INT32, field_34_01234 UINT8 ARRAY, field_35_012345 INT64, field_36_0123456 DATE, field_37_01234567 DATE, field_38_012345678 INT32 ARRAY, field_39_0123456789 CHAR, field_40_0 DATETIME, field_41_01 INT64, field_42_012 INT8, field_43_0123 INT16, field_44_01234 BOOL, field_45_012345 INT64 ARRAY, field_46_0123456 HIRESTIME, field_47_01234567 DATETIME ARRAY, field_48_012345678 UINT32, field_49_0123456789 REAL, field_50_0 DATE, field_51_01 RICHREAL, field_52_012 DATE, field_53_0123 HIRESTIME, field_54_01234 UINT16, field_55_012345 UINT16, field_56_0123456 DATETIME, field_57_01234567 HIRESTIME, field_58_012345678 UINT64 ARRAY, field_59_0123456789 REAL, field_60_0 DATETIME, field_61_01 INT32, field_62_012 UINT64, field_63_0123 UINT32, field_64_01234 DATE, field_65_012345 INT32, field_66_0123456 CHAR, field_67_01234567 INT32, field_68_012345678 UINT32 ARRAY, field_69_0123456789 INT16, field_70_0 CHAR ARRAY, field_71_01 INT16, field_72_012 HIRESTIME, field_73_0123 REAL, field_74_01234 UINT8, field_75_012345 UINT8, field_76_0123456 BOOL, field_77_01234567 UINT32, field_78_012345678 REAL, field_79_0123456789 HIRESTIME ARRAY)");
      /* 501 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 RICHREAL ARRAY, field_3_0123 INT32, field_4_01234 INT64, field_5_012345 BOOL ARRAY, field_6_0123456 UINT8 ARRAY, field_7_01234567 DATETIME, field_8_012345678 CHAR, field_9_0123456789 REAL, field_10_0 HIRESTIME ARRAY, field_11_01 INT64 ARRAY, field_12_012 REAL, field_13_0123 BOOL, field_14_01234 UINT16 ARRAY, field_15_012345 UINT32, field_16_0123456 UINT64, field_17_01234567 REAL, field_18_012345678 UINT64, field_19_0123456789 HIRESTIME, field_20_0 INT8, field_21_01 INT16 ARRAY, field_22_012 BOOL, field_23_0123 RICHREAL, field_24_01234 INT32, field_25_012345 DATETIME, field_26_0123456 CHAR, field_27_01234567 UINT8, field_28_012345678 DATE, field_29_0123456789 INT8, field_30_0 INT16, field_31_01 UINT16 ARRAY, field_32_012 CHAR, field_33_0123 INT8, field_34_01234 UINT16, field_35_012345 UINT8)");
      /* 502 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 DATE, field_3_0123 CHAR ARRAY, field_4_01234 INT64, field_5_012345 UINT16 ARRAY, field_6_0123456 REAL, field_7_01234567 UINT16 ARRAY, field_8_012345678 DATETIME, field_9_0123456789 INT64, field_10_0 RICHREAL, field_11_01 UINT64, field_12_012 CHAR ARRAY, field_13_0123 UINT16 ARRAY, field_14_01234 RICHREAL ARRAY, field_15_012345 HIRESTIME ARRAY, field_16_0123456 DATETIME, field_17_01234567 CHAR ARRAY, field_18_012345678 INT64, field_19_0123456789 DATE, field_20_0 DATETIME, field_21_01 INT32 ARRAY, field_22_012 UINT32 ARRAY, field_23_0123 INT64, field_24_01234 INT32, field_25_012345 UINT16 ARRAY, field_26_0123456 INT8, field_27_01234567 INT64, field_28_012345678 INT16 ARRAY, field_29_0123456789 INT64 ARRAY, field_30_0 INT8, field_31_01 INT64, field_32_012 UINT16, field_33_0123 REAL ARRAY, field_34_01234 DATETIME ARRAY, field_35_012345 BOOL, field_36_0123456 UINT64, field_37_01234567 HIRESTIME, field_38_012345678 CHAR, field_39_0123456789 INT16, field_40_0 RICHREAL, field_41_01 INT16, field_42_012 DATETIME, field_43_0123 UINT16, field_44_01234 RICHREAL, field_45_012345 BOOL, field_46_0123456 REAL, field_47_01234567 DATETIME, field_48_012345678 CHAR, field_49_0123456789 INT8, field_50_0 CHAR, field_51_01 UINT8, field_52_012 UINT32 ARRAY, field_53_0123 REAL, field_54_01234 REAL, field_55_012345 DATE, field_56_0123456 INT16, field_57_01234567 INT16, field_58_012345678 UINT64, field_59_0123456789 UINT8, field_60_0 BOOL, field_61_01 REAL, field_62_012 INT16, field_63_0123 UINT64, field_64_01234 DATE, field_65_012345 INT64, field_66_0123456 INT64, field_67_01234567 CHAR ARRAY, field_68_012345678 HIRESTIME, field_69_0123456789 HIRESTIME, field_70_0 INT64 ARRAY, field_71_01 INT32, field_72_012 UINT32, field_73_0123 HIRESTIME, field_74_01234 CHAR ARRAY, field_75_012345 HIRESTIME, field_76_0123456 INT32, field_77_01234567 BOOL)");
      /* 503 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 INT8 ARRAY, field_3_0123 UINT64, field_4_01234 UINT32 ARRAY, field_5_012345 BOOL, field_6_0123456 CHAR ARRAY, field_7_01234567 BOOL, field_8_012345678 UINT64, field_9_0123456789 UINT64, field_10_0 UINT16 ARRAY, field_11_01 REAL, field_12_012 UINT64, field_13_0123 REAL, field_14_01234 DATETIME ARRAY, field_15_012345 INT32, field_16_0123456 CHAR ARRAY, field_17_01234567 CHAR, field_18_012345678 DATETIME, field_19_0123456789 DATE, field_20_0 BOOL ARRAY, field_21_01 DATETIME, field_22_012 UINT16, field_23_0123 INT16, field_24_01234 DATE, field_25_012345 CHAR, field_26_0123456 BOOL, field_27_01234567 DATETIME, field_28_012345678 INT8, field_29_0123456789 DATE, field_30_0 INT8, field_31_01 RICHREAL, field_32_012 UINT16, field_33_0123 INT32, field_34_01234 INT32, field_35_012345 UINT32, field_36_0123456 INT16, field_37_01234567 INT8, field_38_012345678 UINT8 ARRAY, field_39_0123456789 UINT32, field_40_0 DATETIME ARRAY, field_41_01 UINT8, field_42_012 DATETIME, field_43_0123 RICHREAL, field_44_01234 RICHREAL, field_45_012345 INT16, field_46_0123456 INT64, field_47_01234567 HIRESTIME ARRAY, field_48_012345678 INT16, field_49_0123456789 INT32 ARRAY, field_50_0 DATE, field_51_01 DATE ARRAY, field_52_012 INT16, field_53_0123 REAL, field_54_01234 INT8 ARRAY, field_55_012345 DATETIME, field_56_0123456 INT16, field_57_01234567 RICHREAL, field_58_012345678 UINT8 ARRAY, field_59_0123456789 UINT8 ARRAY, field_60_0 UINT16, field_61_01 UINT64, field_62_012 UINT32, field_63_0123 UINT8, field_64_01234 UINT16, field_65_012345 HIRESTIME, field_66_0123456 DATE, field_67_01234567 CHAR, field_68_012345678 REAL, field_69_0123456789 INT64 ARRAY, field_70_0 UINT16, field_71_01 HIRESTIME, field_72_012 INT32, field_73_0123 BOOL, field_74_01234 UINT32, field_75_012345 UINT16, field_76_0123456 RICHREAL, field_77_01234567 UINT64 ARRAY, field_78_012345678 INT32 ARRAY, field_79_0123456789 RICHREAL, field_80_0 DATE, field_81_01 UINT16, field_82_012 INT32)");
      /* 504 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 INT64 ARRAY)");
      /* 505 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME ARRAY, field_2_012 REAL, field_3_0123 INT32, field_4_01234 UINT32 ARRAY, field_5_012345 HIRESTIME, field_6_0123456 HIRESTIME, field_7_01234567 DATE ARRAY, field_8_012345678 RICHREAL, field_9_0123456789 INT16, field_10_0 INT32, field_11_01 UINT64, field_12_012 REAL, field_13_0123 BOOL ARRAY, field_14_01234 DATE, field_15_012345 BOOL, field_16_0123456 UINT8 ARRAY, field_17_01234567 CHAR ARRAY, field_18_012345678 REAL, field_19_0123456789 INT64, field_20_0 UINT8, field_21_01 INT32, field_22_012 INT8, field_23_0123 CHAR, field_24_01234 DATE, field_25_012345 INT16, field_26_0123456 CHAR ARRAY, field_27_01234567 UINT32, field_28_012345678 HIRESTIME, field_29_0123456789 INT32, field_30_0 DATETIME, field_31_01 INT8, field_32_012 INT64, field_33_0123 INT8, field_34_01234 UINT32 ARRAY, field_35_012345 RICHREAL, field_36_0123456 UINT32 ARRAY, field_37_01234567 UINT32, field_38_012345678 DATE, field_39_0123456789 INT64, field_40_0 DATE, field_41_01 DATETIME, field_42_012 INT16 ARRAY, field_43_0123 REAL, field_44_01234 UINT64, field_45_012345 DATE, field_46_0123456 UINT8 ARRAY, field_47_01234567 REAL, field_48_012345678 CHAR, field_49_0123456789 REAL ARRAY, field_50_0 REAL ARRAY, field_51_01 CHAR, field_52_012 UINT8, field_53_0123 CHAR, field_54_01234 RICHREAL ARRAY, field_55_012345 INT16, field_56_0123456 INT16, field_57_01234567 REAL, field_58_012345678 DATE, field_59_0123456789 UINT16, field_60_0 INT64 ARRAY, field_61_01 UINT32, field_62_012 UINT8, field_63_0123 UINT64, field_64_01234 CHAR, field_65_012345 INT16, field_66_0123456 INT8, field_67_01234567 BOOL ARRAY, field_68_012345678 DATETIME, field_69_0123456789 CHAR, field_70_0 INT64 ARRAY, field_71_01 UINT16, field_72_012 INT16, field_73_0123 INT16 ARRAY, field_74_01234 INT32, field_75_012345 INT64, field_76_0123456 INT8, field_77_01234567 UINT16, field_78_012345678 INT8, field_79_0123456789 BOOL ARRAY, field_80_0 REAL, field_81_01 HIRESTIME, field_82_012 DATE ARRAY, field_83_0123 UINT64 ARRAY, field_84_01234 BOOL, field_85_012345 CHAR, field_86_0123456 HIRESTIME, field_87_01234567 UINT8 ARRAY, field_88_012345678 CHAR)");
      /* 506 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 INT16, field_3_0123 HIRESTIME, field_4_01234 DATE, field_5_012345 DATE, field_6_0123456 UINT16 ARRAY, field_7_01234567 REAL, field_8_012345678 UINT64, field_9_0123456789 INT64, field_10_0 RICHREAL ARRAY, field_11_01 INT16, field_12_012 UINT64)");
      /* 507 */ glbTypes.push_back("TABLE(field_1_01 INT32 ARRAY, field_2_012 INT16, field_3_0123 CHAR, field_4_01234 INT16 ARRAY, field_5_012345 UINT64, field_6_0123456 UINT64 ARRAY, field_7_01234567 HIRESTIME, field_8_012345678 HIRESTIME, field_9_0123456789 CHAR, field_10_0 HIRESTIME, field_11_01 INT16, field_12_012 HIRESTIME, field_13_0123 UINT8, field_14_01234 UINT16 ARRAY, field_15_012345 DATETIME, field_16_0123456 HIRESTIME ARRAY, field_17_01234567 UINT16, field_18_012345678 CHAR ARRAY, field_19_0123456789 DATETIME, field_20_0 REAL, field_21_01 UINT8, field_22_012 BOOL, field_23_0123 UINT16, field_24_01234 RICHREAL, field_25_012345 INT64 ARRAY)");
      /* 508 */ glbTypes.push_back("TABLE(field_1_01 INT8 ARRAY, field_2_012 DATE, field_3_0123 UINT64, field_4_01234 HIRESTIME, field_5_012345 REAL, field_6_0123456 INT16, field_7_01234567 BOOL, field_8_012345678 UINT32, field_9_0123456789 UINT16 ARRAY, field_10_0 HIRESTIME, field_11_01 CHAR, field_12_012 HIRESTIME, field_13_0123 DATE, field_14_01234 REAL, field_15_012345 CHAR, field_16_0123456 UINT8 ARRAY, field_17_01234567 CHAR, field_18_012345678 INT8, field_19_0123456789 INT32, field_20_0 DATETIME, field_21_01 BOOL, field_22_012 UINT16, field_23_0123 UINT8, field_24_01234 UINT64, field_25_012345 DATE, field_26_0123456 HIRESTIME ARRAY, field_27_01234567 RICHREAL, field_28_012345678 UINT16, field_29_0123456789 INT16, field_30_0 CHAR, field_31_01 UINT16, field_32_012 INT16, field_33_0123 HIRESTIME, field_34_01234 BOOL, field_35_012345 DATE, field_36_0123456 RICHREAL, field_37_01234567 INT64, field_38_012345678 CHAR, field_39_0123456789 UINT64, field_40_0 RICHREAL, field_41_01 BOOL ARRAY, field_42_012 DATE, field_43_0123 UINT32 ARRAY, field_44_01234 UINT8, field_45_012345 BOOL, field_46_0123456 CHAR, field_47_01234567 UINT64, field_48_012345678 BOOL ARRAY, field_49_0123456789 BOOL, field_50_0 UINT32, field_51_01 DATETIME, field_52_012 HIRESTIME, field_53_0123 HIRESTIME, field_54_01234 REAL, field_55_012345 CHAR, field_56_0123456 INT8, field_57_01234567 INT16 ARRAY, field_58_012345678 HIRESTIME, field_59_0123456789 UINT64, field_60_0 DATETIME ARRAY, field_61_01 HIRESTIME, field_62_012 UINT32)");
      /* 509 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 BOOL, field_3_0123 INT8 ARRAY, field_4_01234 INT16, field_5_012345 INT64, field_6_0123456 BOOL ARRAY, field_7_01234567 UINT16, field_8_012345678 UINT16, field_9_0123456789 UINT32, field_10_0 INT64 ARRAY, field_11_01 UINT32 ARRAY, field_12_012 DATETIME, field_13_0123 INT32, field_14_01234 INT64 ARRAY, field_15_012345 INT8, field_16_0123456 INT8, field_17_01234567 INT64, field_18_012345678 HIRESTIME, field_19_0123456789 RICHREAL, field_20_0 BOOL ARRAY, field_21_01 DATETIME ARRAY, field_22_012 BOOL, field_23_0123 INT8, field_24_01234 INT16, field_25_012345 DATETIME, field_26_0123456 UINT64, field_27_01234567 UINT16, field_28_012345678 INT16, field_29_0123456789 INT64, field_30_0 UINT32, field_31_01 INT8, field_32_012 HIRESTIME, field_33_0123 HIRESTIME, field_34_01234 INT16 ARRAY, field_35_012345 UINT64 ARRAY, field_36_0123456 DATETIME, field_37_01234567 INT8 ARRAY, field_38_012345678 RICHREAL, field_39_0123456789 UINT32, field_40_0 DATE, field_41_01 UINT16, field_42_012 UINT8 ARRAY, field_43_0123 UINT8, field_44_01234 REAL, field_45_012345 INT16, field_46_0123456 UINT8)");
      /* 510 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 BOOL, field_3_0123 REAL, field_4_01234 INT16 ARRAY, field_5_012345 UINT16, field_6_0123456 UINT32, field_7_01234567 DATETIME, field_8_012345678 UINT16, field_9_0123456789 INT64, field_10_0 INT16 ARRAY, field_11_01 UINT64 ARRAY, field_12_012 HIRESTIME, field_13_0123 UINT64, field_14_01234 REAL, field_15_012345 INT8, field_16_0123456 REAL ARRAY, field_17_01234567 INT8, field_18_012345678 RICHREAL, field_19_0123456789 INT64, field_20_0 RICHREAL, field_21_01 UINT64 ARRAY, field_22_012 UINT32 ARRAY, field_23_0123 BOOL, field_24_01234 INT32, field_25_012345 UINT8, field_26_0123456 UINT16, field_27_01234567 DATETIME ARRAY, field_28_012345678 INT64, field_29_0123456789 DATETIME, field_30_0 INT64, field_31_01 RICHREAL, field_32_012 INT8, field_33_0123 BOOL, field_34_01234 REAL ARRAY, field_35_012345 INT64, field_36_0123456 RICHREAL ARRAY, field_37_01234567 CHAR, field_38_012345678 UINT64, field_39_0123456789 INT64, field_40_0 INT64, field_41_01 RICHREAL, field_42_012 HIRESTIME ARRAY, field_43_0123 BOOL, field_44_01234 INT32 ARRAY, field_45_012345 INT16 ARRAY, field_46_0123456 REAL ARRAY, field_47_01234567 RICHREAL, field_48_012345678 REAL, field_49_0123456789 RICHREAL, field_50_0 DATE, field_51_01 UINT16 ARRAY, field_52_012 HIRESTIME, field_53_0123 INT32 ARRAY, field_54_01234 UINT8, field_55_012345 UINT32 ARRAY, field_56_0123456 HIRESTIME ARRAY, field_57_01234567 INT16, field_58_012345678 UINT16, field_59_0123456789 UINT32, field_60_0 INT8, field_61_01 RICHREAL, field_62_012 DATE, field_63_0123 REAL, field_64_01234 BOOL ARRAY, field_65_012345 CHAR, field_66_0123456 UINT8, field_67_01234567 UINT64 ARRAY, field_68_012345678 DATETIME, field_69_0123456789 REAL ARRAY, field_70_0 DATE, field_71_01 UINT32 ARRAY, field_72_012 INT16 ARRAY, field_73_0123 INT64, field_74_01234 UINT16 ARRAY, field_75_012345 CHAR, field_76_0123456 DATE, field_77_01234567 INT32, field_78_012345678 INT64, field_79_0123456789 UINT64 ARRAY, field_80_0 REAL, field_81_01 INT32, field_82_012 RICHREAL, field_83_0123 UINT64, field_84_01234 UINT64, field_85_012345 UINT32)");
      /* 511 */ glbTypes.push_back("TABLE(field_1_01 DATE ARRAY, field_2_012 INT16 ARRAY, field_3_0123 INT64, field_4_01234 INT64 ARRAY, field_5_012345 DATE ARRAY, field_6_0123456 REAL, field_7_01234567 BOOL ARRAY, field_8_012345678 BOOL, field_9_0123456789 UINT16, field_10_0 CHAR ARRAY, field_11_01 UINT64, field_12_012 DATE, field_13_0123 DATE, field_14_01234 DATE, field_15_012345 HIRESTIME, field_16_0123456 INT64, field_17_01234567 UINT16 ARRAY, field_18_012345678 INT8, field_19_0123456789 UINT8, field_20_0 RICHREAL, field_21_01 RICHREAL, field_22_012 UINT8, field_23_0123 INT64 ARRAY, field_24_01234 DATE, field_25_012345 DATE, field_26_0123456 INT64, field_27_01234567 INT64, field_28_012345678 UINT8, field_29_0123456789 RICHREAL, field_30_0 INT64, field_31_01 INT8, field_32_012 REAL ARRAY, field_33_0123 BOOL, field_34_01234 UINT32, field_35_012345 UINT64, field_36_0123456 CHAR, field_37_01234567 INT64, field_38_012345678 UINT16, field_39_0123456789 INT64, field_40_0 CHAR, field_41_01 REAL, field_42_012 CHAR, field_43_0123 UINT16, field_44_01234 UINT32, field_45_012345 INT64, field_46_0123456 INT16, field_47_01234567 DATE ARRAY, field_48_012345678 INT16 ARRAY, field_49_0123456789 INT64)");
      /* 512 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 INT32, field_3_0123 BOOL)");
      /* 513 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 CHAR, field_3_0123 UINT16, field_4_01234 RICHREAL, field_5_012345 CHAR, field_6_0123456 UINT16, field_7_01234567 HIRESTIME, field_8_012345678 INT8 ARRAY, field_9_0123456789 INT64, field_10_0 INT8, field_11_01 UINT8, field_12_012 INT8, field_13_0123 BOOL, field_14_01234 HIRESTIME ARRAY, field_15_012345 UINT8, field_16_0123456 DATETIME ARRAY, field_17_01234567 UINT16, field_18_012345678 INT64, field_19_0123456789 INT16, field_20_0 RICHREAL, field_21_01 DATETIME, field_22_012 INT64, field_23_0123 HIRESTIME ARRAY, field_24_01234 INT16, field_25_012345 DATETIME, field_26_0123456 HIRESTIME ARRAY, field_27_01234567 DATE, field_28_012345678 BOOL, field_29_0123456789 HIRESTIME, field_30_0 CHAR, field_31_01 UINT8, field_32_012 INT32, field_33_0123 INT64 ARRAY, field_34_01234 HIRESTIME, field_35_012345 RICHREAL, field_36_0123456 INT32, field_37_01234567 UINT8, field_38_012345678 INT32, field_39_0123456789 UINT64, field_40_0 UINT32, field_41_01 CHAR, field_42_012 DATETIME, field_43_0123 UINT64, field_44_01234 BOOL, field_45_012345 INT64 ARRAY, field_46_0123456 INT16, field_47_01234567 UINT8, field_48_012345678 INT32, field_49_0123456789 UINT32, field_50_0 UINT64, field_51_01 DATETIME ARRAY, field_52_012 REAL ARRAY, field_53_0123 BOOL, field_54_01234 INT64, field_55_012345 UINT64 ARRAY, field_56_0123456 INT32, field_57_01234567 BOOL, field_58_012345678 BOOL, field_59_0123456789 INT16, field_60_0 DATE, field_61_01 INT16, field_62_012 UINT64, field_63_0123 INT32, field_64_01234 INT16 ARRAY, field_65_012345 UINT64, field_66_0123456 INT32, field_67_01234567 HIRESTIME, field_68_012345678 INT8, field_69_0123456789 HIRESTIME, field_70_0 UINT8, field_71_01 UINT8, field_72_012 HIRESTIME, field_73_0123 UINT16, field_74_01234 INT16, field_75_012345 INT64, field_76_0123456 HIRESTIME, field_77_01234567 RICHREAL, field_78_012345678 INT16, field_79_0123456789 DATETIME, field_80_0 DATETIME, field_81_01 DATE, field_82_012 INT8, field_83_0123 RICHREAL ARRAY, field_84_01234 BOOL ARRAY)");
      /* 514 */ glbTypes.push_back("TABLE(field_1_01 REAL ARRAY, field_2_012 RICHREAL, field_3_0123 CHAR, field_4_01234 DATETIME, field_5_012345 INT8, field_6_0123456 INT16, field_7_01234567 REAL, field_8_012345678 UINT8, field_9_0123456789 INT64, field_10_0 UINT8, field_11_01 BOOL, field_12_012 HIRESTIME)");
      /* 515 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 REAL, field_3_0123 REAL, field_4_01234 UINT8, field_5_012345 RICHREAL ARRAY, field_6_0123456 CHAR ARRAY, field_7_01234567 UINT64, field_8_012345678 REAL, field_9_0123456789 INT8, field_10_0 UINT8, field_11_01 UINT16, field_12_012 UINT32 ARRAY, field_13_0123 UINT64 ARRAY, field_14_01234 INT8, field_15_012345 INT16, field_16_0123456 UINT8, field_17_01234567 DATETIME, field_18_012345678 INT8, field_19_0123456789 UINT16, field_20_0 BOOL, field_21_01 INT32, field_22_012 UINT64, field_23_0123 INT16, field_24_01234 CHAR, field_25_012345 UINT8, field_26_0123456 INT16, field_27_01234567 UINT16, field_28_012345678 HIRESTIME, field_29_0123456789 UINT8, field_30_0 UINT8, field_31_01 INT8, field_32_012 INT8, field_33_0123 DATE, field_34_01234 INT8 ARRAY, field_35_012345 DATETIME, field_36_0123456 INT16, field_37_01234567 UINT16, field_38_012345678 DATE, field_39_0123456789 CHAR, field_40_0 INT16, field_41_01 BOOL, field_42_012 UINT16 ARRAY, field_43_0123 UINT16, field_44_01234 UINT32, field_45_012345 BOOL, field_46_0123456 INT16 ARRAY, field_47_01234567 INT32, field_48_012345678 HIRESTIME, field_49_0123456789 RICHREAL, field_50_0 INT8, field_51_01 UINT32, field_52_012 UINT16, field_53_0123 INT16, field_54_01234 DATE, field_55_012345 INT64, field_56_0123456 BOOL, field_57_01234567 INT32, field_58_012345678 UINT16, field_59_0123456789 UINT64, field_60_0 INT16, field_61_01 INT16, field_62_012 REAL ARRAY, field_63_0123 REAL, field_64_01234 RICHREAL, field_65_012345 UINT64, field_66_0123456 INT64, field_67_01234567 DATETIME ARRAY, field_68_012345678 DATE, field_69_0123456789 INT8, field_70_0 BOOL ARRAY, field_71_01 DATETIME, field_72_012 BOOL, field_73_0123 REAL, field_74_01234 DATE ARRAY, field_75_012345 RICHREAL, field_76_0123456 INT32, field_77_01234567 INT32, field_78_012345678 INT16, field_79_0123456789 REAL, field_80_0 INT32, field_81_01 HIRESTIME, field_82_012 INT8, field_83_0123 RICHREAL, field_84_01234 CHAR, field_85_012345 UINT64 ARRAY, field_86_0123456 UINT16)");
      /* 516 */ glbTypes.push_back("TABLE(field_1_01 REAL ARRAY, field_2_012 INT16, field_3_0123 UINT32, field_4_01234 UINT64, field_5_012345 INT8, field_6_0123456 UINT8, field_7_01234567 UINT8, field_8_012345678 REAL, field_9_0123456789 REAL, field_10_0 RICHREAL, field_11_01 BOOL ARRAY, field_12_012 UINT16, field_13_0123 UINT32, field_14_01234 BOOL, field_15_012345 INT64 ARRAY, field_16_0123456 INT64, field_17_01234567 UINT64, field_18_012345678 UINT8, field_19_0123456789 DATE, field_20_0 INT64, field_21_01 CHAR, field_22_012 UINT16, field_23_0123 UINT8, field_24_01234 HIRESTIME, field_25_012345 REAL, field_26_0123456 UINT64, field_27_01234567 UINT8, field_28_012345678 BOOL, field_29_0123456789 REAL, field_30_0 HIRESTIME, field_31_01 INT16, field_32_012 UINT16 ARRAY, field_33_0123 UINT32, field_34_01234 INT32, field_35_012345 RICHREAL, field_36_0123456 INT64, field_37_01234567 INT16, field_38_012345678 INT8, field_39_0123456789 INT32, field_40_0 DATE, field_41_01 BOOL ARRAY, field_42_012 CHAR ARRAY, field_43_0123 INT16, field_44_01234 INT32, field_45_012345 INT16, field_46_0123456 HIRESTIME ARRAY, field_47_01234567 CHAR, field_48_012345678 REAL, field_49_0123456789 UINT8 ARRAY, field_50_0 INT64 ARRAY, field_51_01 HIRESTIME ARRAY, field_52_012 DATETIME, field_53_0123 INT64, field_54_01234 REAL, field_55_012345 UINT8 ARRAY, field_56_0123456 UINT8, field_57_01234567 BOOL, field_58_012345678 INT16, field_59_0123456789 CHAR, field_60_0 INT16, field_61_01 INT16 ARRAY, field_62_012 DATE, field_63_0123 UINT8, field_64_01234 INT64, field_65_012345 REAL ARRAY, field_66_0123456 CHAR, field_67_01234567 HIRESTIME, field_68_012345678 REAL ARRAY, field_69_0123456789 RICHREAL, field_70_0 UINT8 ARRAY, field_71_01 INT32, field_72_012 DATE, field_73_0123 INT32, field_74_01234 UINT8, field_75_012345 CHAR, field_76_0123456 DATE, field_77_01234567 DATE, field_78_012345678 BOOL, field_79_0123456789 DATE, field_80_0 INT64, field_81_01 DATETIME ARRAY, field_82_012 REAL, field_83_0123 UINT16 ARRAY, field_84_01234 INT8, field_85_012345 BOOL, field_86_0123456 INT8, field_87_01234567 DATE, field_88_012345678 RICHREAL, field_89_0123456789 INT64, field_90_0 UINT64 ARRAY, field_91_01 INT8, field_92_012 CHAR, field_93_0123 RICHREAL, field_94_01234 INT64, field_95_012345 BOOL, field_96_0123456 UINT32, field_97_01234567 HIRESTIME, field_98_012345678 DATE)");
      /* 517 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 INT32, field_3_0123 BOOL, field_4_01234 INT32, field_5_012345 REAL ARRAY, field_6_0123456 DATE, field_7_01234567 REAL ARRAY, field_8_012345678 DATE, field_9_0123456789 INT64, field_10_0 UINT32 ARRAY, field_11_01 UINT16, field_12_012 INT64, field_13_0123 RICHREAL, field_14_01234 HIRESTIME, field_15_012345 UINT8, field_16_0123456 UINT8, field_17_01234567 RICHREAL, field_18_012345678 UINT32, field_19_0123456789 UINT64, field_20_0 RICHREAL, field_21_01 INT8, field_22_012 UINT8, field_23_0123 RICHREAL ARRAY, field_24_01234 INT8, field_25_012345 INT64 ARRAY, field_26_0123456 CHAR ARRAY, field_27_01234567 INT64 ARRAY, field_28_012345678 INT16, field_29_0123456789 INT16 ARRAY, field_30_0 REAL, field_31_01 INT8, field_32_012 UINT64 ARRAY, field_33_0123 INT16, field_34_01234 BOOL, field_35_012345 INT16 ARRAY, field_36_0123456 BOOL ARRAY)");
      /* 518 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 INT16, field_3_0123 BOOL, field_4_01234 REAL, field_5_012345 UINT64, field_6_0123456 UINT8, field_7_01234567 BOOL, field_8_012345678 UINT8 ARRAY, field_9_0123456789 DATE, field_10_0 HIRESTIME, field_11_01 UINT16, field_12_012 BOOL, field_13_0123 DATETIME, field_14_01234 CHAR, field_15_012345 DATE, field_16_0123456 HIRESTIME ARRAY, field_17_01234567 BOOL, field_18_012345678 UINT8, field_19_0123456789 INT32 ARRAY, field_20_0 DATE, field_21_01 UINT16, field_22_012 REAL, field_23_0123 DATETIME ARRAY, field_24_01234 UINT16, field_25_012345 UINT64, field_26_0123456 HIRESTIME, field_27_01234567 UINT16, field_28_012345678 INT8, field_29_0123456789 BOOL ARRAY, field_30_0 DATETIME, field_31_01 DATE, field_32_012 CHAR)");
      /* 519 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 UINT16, field_3_0123 INT16, field_4_01234 DATETIME, field_5_012345 DATETIME, field_6_0123456 REAL, field_7_01234567 CHAR, field_8_012345678 DATE, field_9_0123456789 INT64, field_10_0 CHAR ARRAY, field_11_01 DATETIME, field_12_012 BOOL, field_13_0123 HIRESTIME, field_14_01234 INT32, field_15_012345 INT16, field_16_0123456 INT32, field_17_01234567 INT32 ARRAY, field_18_012345678 UINT8, field_19_0123456789 UINT8, field_20_0 DATETIME ARRAY, field_21_01 INT32, field_22_012 HIRESTIME, field_23_0123 BOOL, field_24_01234 BOOL, field_25_012345 INT64, field_26_0123456 RICHREAL, field_27_01234567 CHAR, field_28_012345678 UINT32, field_29_0123456789 UINT16 ARRAY, field_30_0 INT32, field_31_01 INT64, field_32_012 UINT64, field_33_0123 DATETIME, field_34_01234 UINT32, field_35_012345 REAL, field_36_0123456 BOOL ARRAY, field_37_01234567 INT32, field_38_012345678 DATE, field_39_0123456789 INT8)");
      /* 520 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 REAL, field_3_0123 INT8, field_4_01234 RICHREAL ARRAY, field_5_012345 INT64 ARRAY, field_6_0123456 INT64, field_7_01234567 BOOL, field_8_012345678 INT32 ARRAY, field_9_0123456789 RICHREAL, field_10_0 INT16, field_11_01 INT16, field_12_012 DATETIME, field_13_0123 INT16, field_14_01234 HIRESTIME, field_15_012345 DATE, field_16_0123456 DATE, field_17_01234567 UINT8, field_18_012345678 INT16, field_19_0123456789 CHAR, field_20_0 INT32, field_21_01 RICHREAL, field_22_012 HIRESTIME, field_23_0123 UINT32, field_24_01234 INT16, field_25_012345 RICHREAL, field_26_0123456 INT16, field_27_01234567 INT32, field_28_012345678 UINT8, field_29_0123456789 INT8, field_30_0 INT8, field_31_01 REAL, field_32_012 INT8 ARRAY, field_33_0123 UINT16, field_34_01234 INT16, field_35_012345 INT32, field_36_0123456 DATE, field_37_01234567 INT32, field_38_012345678 UINT64, field_39_0123456789 REAL, field_40_0 CHAR, field_41_01 UINT64 ARRAY, field_42_012 BOOL, field_43_0123 UINT32, field_44_01234 DATE ARRAY, field_45_012345 INT16, field_46_0123456 CHAR, field_47_01234567 DATE, field_48_012345678 BOOL ARRAY, field_49_0123456789 BOOL, field_50_0 UINT64, field_51_01 DATE, field_52_012 HIRESTIME, field_53_0123 RICHREAL, field_54_01234 INT64, field_55_012345 INT16, field_56_0123456 CHAR ARRAY, field_57_01234567 UINT8, field_58_012345678 CHAR, field_59_0123456789 DATE, field_60_0 UINT32, field_61_01 UINT32, field_62_012 UINT64 ARRAY)");
      /* 521 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 BOOL, field_3_0123 UINT16, field_4_01234 INT32, field_5_012345 INT32, field_6_0123456 REAL, field_7_01234567 DATE, field_8_012345678 CHAR, field_9_0123456789 RICHREAL, field_10_0 RICHREAL, field_11_01 DATE, field_12_012 HIRESTIME ARRAY, field_13_0123 INT64, field_14_01234 RICHREAL ARRAY, field_15_012345 UINT32, field_16_0123456 UINT8, field_17_01234567 INT64, field_18_012345678 INT32, field_19_0123456789 DATETIME, field_20_0 UINT8, field_21_01 UINT16, field_22_012 INT16, field_23_0123 DATETIME, field_24_01234 UINT32, field_25_012345 BOOL ARRAY, field_26_0123456 UINT32 ARRAY, field_27_01234567 INT64, field_28_012345678 REAL, field_29_0123456789 INT8, field_30_0 BOOL, field_31_01 INT16, field_32_012 DATETIME, field_33_0123 DATETIME, field_34_01234 DATETIME)");
      /* 522 */ glbTypes.push_back("TABLE(field_1_01 CHAR ARRAY, field_2_012 UINT16, field_3_0123 HIRESTIME, field_4_01234 UINT8, field_5_012345 INT8, field_6_0123456 DATE ARRAY, field_7_01234567 UINT32 ARRAY, field_8_012345678 INT32, field_9_0123456789 CHAR, field_10_0 UINT16, field_11_01 RICHREAL, field_12_012 RICHREAL, field_13_0123 DATETIME, field_14_01234 INT64, field_15_012345 UINT8, field_16_0123456 CHAR, field_17_01234567 CHAR, field_18_012345678 BOOL, field_19_0123456789 DATE, field_20_0 INT16, field_21_01 DATETIME, field_22_012 BOOL, field_23_0123 RICHREAL, field_24_01234 RICHREAL, field_25_012345 HIRESTIME, field_26_0123456 UINT64, field_27_01234567 INT16, field_28_012345678 CHAR, field_29_0123456789 RICHREAL, field_30_0 DATE, field_31_01 INT8, field_32_012 UINT64, field_33_0123 UINT32, field_34_01234 DATETIME, field_35_012345 INT16, field_36_0123456 RICHREAL, field_37_01234567 INT16 ARRAY, field_38_012345678 INT8, field_39_0123456789 DATE, field_40_0 HIRESTIME, field_41_01 RICHREAL)");
      /* 523 */ glbTypes.push_back("TABLE(field_1_01 INT32 ARRAY, field_2_012 UINT16, field_3_0123 INT32 ARRAY, field_4_01234 UINT64, field_5_012345 UINT64, field_6_0123456 UINT16, field_7_01234567 INT16, field_8_012345678 HIRESTIME, field_9_0123456789 BOOL, field_10_0 REAL, field_11_01 BOOL, field_12_012 DATE, field_13_0123 UINT16, field_14_01234 DATETIME, field_15_012345 DATETIME, field_16_0123456 REAL, field_17_01234567 INT64, field_18_012345678 DATETIME ARRAY, field_19_0123456789 UINT8, field_20_0 DATE, field_21_01 CHAR ARRAY, field_22_012 BOOL, field_23_0123 RICHREAL, field_24_01234 UINT64 ARRAY, field_25_012345 INT16 ARRAY, field_26_0123456 BOOL ARRAY, field_27_01234567 DATE, field_28_012345678 UINT64, field_29_0123456789 INT8 ARRAY, field_30_0 UINT16, field_31_01 CHAR, field_32_012 UINT32 ARRAY, field_33_0123 UINT32 ARRAY, field_34_01234 UINT32, field_35_012345 DATETIME, field_36_0123456 UINT16 ARRAY, field_37_01234567 RICHREAL ARRAY, field_38_012345678 DATETIME, field_39_0123456789 HIRESTIME, field_40_0 CHAR, field_41_01 INT16, field_42_012 UINT64, field_43_0123 DATE, field_44_01234 REAL, field_45_012345 CHAR ARRAY, field_46_0123456 CHAR, field_47_01234567 HIRESTIME ARRAY, field_48_012345678 RICHREAL, field_49_0123456789 UINT32, field_50_0 DATE, field_51_01 UINT32, field_52_012 DATETIME, field_53_0123 UINT16, field_54_01234 DATE, field_55_012345 RICHREAL, field_56_0123456 HIRESTIME ARRAY, field_57_01234567 UINT64, field_58_012345678 INT8, field_59_0123456789 DATE ARRAY, field_60_0 REAL, field_61_01 UINT8, field_62_012 UINT8 ARRAY, field_63_0123 UINT64, field_64_01234 INT64 ARRAY, field_65_012345 INT16 ARRAY, field_66_0123456 UINT16, field_67_01234567 DATE, field_68_012345678 UINT32, field_69_0123456789 RICHREAL, field_70_0 UINT8, field_71_01 CHAR, field_72_012 INT64, field_73_0123 RICHREAL, field_74_01234 INT64 ARRAY, field_75_012345 UINT64, field_76_0123456 HIRESTIME, field_77_01234567 CHAR, field_78_012345678 CHAR, field_79_0123456789 RICHREAL, field_80_0 INT32, field_81_01 RICHREAL, field_82_012 INT8 ARRAY, field_83_0123 CHAR, field_84_01234 DATETIME, field_85_012345 UINT32, field_86_0123456 INT16 ARRAY, field_87_01234567 INT32, field_88_012345678 RICHREAL, field_89_0123456789 DATETIME ARRAY, field_90_0 BOOL, field_91_01 INT16 ARRAY, field_92_012 INT32 ARRAY, field_93_0123 INT8, field_94_01234 HIRESTIME)");
      /* 524 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL ARRAY, field_2_012 INT8, field_3_0123 DATETIME, field_4_01234 CHAR, field_5_012345 RICHREAL, field_6_0123456 INT16, field_7_01234567 UINT32, field_8_012345678 INT64, field_9_0123456789 UINT8 ARRAY, field_10_0 INT16, field_11_01 UINT32, field_12_012 INT8, field_13_0123 UINT16, field_14_01234 INT16 ARRAY, field_15_012345 RICHREAL, field_16_0123456 DATE ARRAY, field_17_01234567 CHAR, field_18_012345678 UINT8, field_19_0123456789 INT64, field_20_0 DATETIME ARRAY, field_21_01 UINT32, field_22_012 UINT64, field_23_0123 INT16, field_24_01234 UINT64, field_25_012345 REAL, field_26_0123456 INT64, field_27_01234567 REAL, field_28_012345678 CHAR ARRAY, field_29_0123456789 INT32, field_30_0 DATETIME)");
      /* 525 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 INT32 ARRAY, field_3_0123 RICHREAL, field_4_01234 BOOL, field_5_012345 CHAR, field_6_0123456 UINT16 ARRAY, field_7_01234567 DATE ARRAY, field_8_012345678 CHAR, field_9_0123456789 DATETIME, field_10_0 RICHREAL ARRAY, field_11_01 UINT16, field_12_012 REAL, field_13_0123 INT16, field_14_01234 UINT32, field_15_012345 UINT16, field_16_0123456 INT16, field_17_01234567 HIRESTIME, field_18_012345678 INT8, field_19_0123456789 HIRESTIME, field_20_0 DATETIME, field_21_01 UINT32, field_22_012 DATETIME ARRAY, field_23_0123 INT64, field_24_01234 DATETIME, field_25_012345 UINT8 ARRAY, field_26_0123456 HIRESTIME, field_27_01234567 BOOL ARRAY, field_28_012345678 INT32 ARRAY, field_29_0123456789 CHAR ARRAY, field_30_0 INT64 ARRAY, field_31_01 REAL, field_32_012 UINT16, field_33_0123 UINT8, field_34_01234 UINT16, field_35_012345 INT16, field_36_0123456 BOOL, field_37_01234567 DATE ARRAY, field_38_012345678 UINT32, field_39_0123456789 UINT64, field_40_0 INT32, field_41_01 DATETIME, field_42_012 HIRESTIME, field_43_0123 HIRESTIME, field_44_01234 INT16, field_45_012345 REAL ARRAY, field_46_0123456 INT16, field_47_01234567 CHAR, field_48_012345678 BOOL, field_49_0123456789 HIRESTIME, field_50_0 UINT8 ARRAY, field_51_01 DATE, field_52_012 INT16, field_53_0123 INT8, field_54_01234 INT16, field_55_012345 DATETIME, field_56_0123456 REAL, field_57_01234567 UINT8, field_58_012345678 INT32, field_59_0123456789 CHAR, field_60_0 INT16, field_61_01 INT32, field_62_012 REAL, field_63_0123 DATETIME, field_64_01234 REAL, field_65_012345 DATE, field_66_0123456 CHAR ARRAY, field_67_01234567 HIRESTIME, field_68_012345678 BOOL, field_69_0123456789 HIRESTIME)");
      /* 526 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 UINT8, field_3_0123 BOOL, field_4_01234 DATE, field_5_012345 INT32 ARRAY, field_6_0123456 BOOL ARRAY, field_7_01234567 INT16 ARRAY, field_8_012345678 HIRESTIME, field_9_0123456789 REAL, field_10_0 UINT16, field_11_01 UINT32, field_12_012 RICHREAL, field_13_0123 BOOL, field_14_01234 INT32, field_15_012345 DATE ARRAY, field_16_0123456 RICHREAL ARRAY, field_17_01234567 INT16, field_18_012345678 INT64, field_19_0123456789 REAL, field_20_0 UINT16 ARRAY, field_21_01 UINT32, field_22_012 HIRESTIME ARRAY, field_23_0123 INT32, field_24_01234 DATETIME, field_25_012345 CHAR, field_26_0123456 REAL, field_27_01234567 UINT64, field_28_012345678 DATE, field_29_0123456789 UINT16, field_30_0 BOOL, field_31_01 REAL, field_32_012 INT64, field_33_0123 UINT16, field_34_01234 HIRESTIME, field_35_012345 UINT64 ARRAY, field_36_0123456 RICHREAL, field_37_01234567 INT8, field_38_012345678 INT32, field_39_0123456789 UINT32, field_40_0 UINT16 ARRAY, field_41_01 UINT64, field_42_012 CHAR, field_43_0123 UINT16, field_44_01234 HIRESTIME, field_45_012345 REAL, field_46_0123456 UINT8, field_47_01234567 INT8, field_48_012345678 INT32, field_49_0123456789 HIRESTIME, field_50_0 UINT16 ARRAY, field_51_01 DATETIME ARRAY, field_52_012 UINT64, field_53_0123 RICHREAL, field_54_01234 DATE, field_55_012345 UINT16 ARRAY, field_56_0123456 UINT8, field_57_01234567 INT64, field_58_012345678 INT16, field_59_0123456789 UINT16, field_60_0 DATE)");
      /* 527 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 INT64 ARRAY, field_3_0123 RICHREAL, field_4_01234 REAL ARRAY, field_5_012345 CHAR ARRAY, field_6_0123456 REAL, field_7_01234567 UINT8, field_8_012345678 DATE, field_9_0123456789 UINT16, field_10_0 UINT64 ARRAY, field_11_01 DATE, field_12_012 INT16, field_13_0123 INT16, field_14_01234 INT16, field_15_012345 INT16, field_16_0123456 DATE, field_17_01234567 INT16, field_18_012345678 INT32, field_19_0123456789 CHAR, field_20_0 UINT8, field_21_01 UINT8, field_22_012 CHAR, field_23_0123 INT64, field_24_01234 REAL, field_25_012345 DATE, field_26_0123456 UINT64, field_27_01234567 REAL, field_28_012345678 UINT16, field_29_0123456789 INT16, field_30_0 REAL, field_31_01 UINT64, field_32_012 DATETIME, field_33_0123 REAL, field_34_01234 UINT32, field_35_012345 INT16, field_36_0123456 HIRESTIME, field_37_01234567 CHAR, field_38_012345678 INT64, field_39_0123456789 DATE ARRAY, field_40_0 DATE, field_41_01 UINT8 ARRAY, field_42_012 REAL, field_43_0123 HIRESTIME, field_44_01234 CHAR, field_45_012345 CHAR, field_46_0123456 BOOL, field_47_01234567 REAL, field_48_012345678 BOOL, field_49_0123456789 REAL, field_50_0 UINT32, field_51_01 INT32, field_52_012 UINT32 ARRAY, field_53_0123 DATE ARRAY, field_54_01234 UINT16, field_55_012345 BOOL, field_56_0123456 HIRESTIME, field_57_01234567 INT16 ARRAY, field_58_012345678 REAL, field_59_0123456789 REAL, field_60_0 REAL ARRAY, field_61_01 CHAR, field_62_012 UINT16, field_63_0123 BOOL ARRAY, field_64_01234 DATETIME, field_65_012345 INT32, field_66_0123456 INT16 ARRAY, field_67_01234567 CHAR, field_68_012345678 INT16 ARRAY, field_69_0123456789 INT64, field_70_0 UINT64, field_71_01 INT64, field_72_012 UINT32, field_73_0123 BOOL, field_74_01234 HIRESTIME, field_75_012345 HIRESTIME, field_76_0123456 RICHREAL, field_77_01234567 HIRESTIME, field_78_012345678 DATE, field_79_0123456789 INT32, field_80_0 BOOL ARRAY, field_81_01 UINT32, field_82_012 DATE ARRAY, field_83_0123 REAL, field_84_01234 UINT64, field_85_012345 UINT32, field_86_0123456 REAL, field_87_01234567 DATETIME ARRAY, field_88_012345678 INT8 ARRAY, field_89_0123456789 UINT16, field_90_0 CHAR ARRAY, field_91_01 DATETIME, field_92_012 DATE, field_93_0123 UINT32, field_94_01234 DATETIME, field_95_012345 CHAR, field_96_0123456 BOOL, field_97_01234567 INT16, field_98_012345678 UINT16 ARRAY)");
      /* 528 */ glbTypes.push_back("TABLE(field_1_01 UINT16 ARRAY, field_2_012 INT8 ARRAY, field_3_0123 UINT16, field_4_01234 CHAR)");
      /* 529 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 INT32, field_3_0123 INT64, field_4_01234 DATE ARRAY, field_5_012345 UINT32, field_6_0123456 BOOL, field_7_01234567 HIRESTIME, field_8_012345678 INT64, field_9_0123456789 INT8, field_10_0 RICHREAL, field_11_01 HIRESTIME ARRAY, field_12_012 UINT64)");
      /* 530 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 HIRESTIME, field_3_0123 BOOL ARRAY, field_4_01234 REAL, field_5_012345 DATE ARRAY, field_6_0123456 INT32, field_7_01234567 DATE, field_8_012345678 RICHREAL, field_9_0123456789 UINT8 ARRAY, field_10_0 UINT32, field_11_01 INT8, field_12_012 INT64, field_13_0123 INT32, field_14_01234 UINT8, field_15_012345 REAL, field_16_0123456 UINT16, field_17_01234567 INT16 ARRAY, field_18_012345678 UINT8, field_19_0123456789 INT16, field_20_0 INT16, field_21_01 UINT32 ARRAY, field_22_012 REAL, field_23_0123 UINT32, field_24_01234 INT32, field_25_012345 UINT64, field_26_0123456 DATETIME, field_27_01234567 BOOL, field_28_012345678 UINT16, field_29_0123456789 UINT16, field_30_0 UINT8 ARRAY, field_31_01 INT16 ARRAY, field_32_012 INT16, field_33_0123 INT16, field_34_01234 INT32, field_35_012345 REAL, field_36_0123456 REAL, field_37_01234567 UINT8, field_38_012345678 CHAR, field_39_0123456789 REAL ARRAY, field_40_0 INT16, field_41_01 REAL, field_42_012 INT32 ARRAY, field_43_0123 DATE, field_44_01234 INT8, field_45_012345 UINT32, field_46_0123456 DATE, field_47_01234567 UINT64 ARRAY, field_48_012345678 RICHREAL, field_49_0123456789 REAL, field_50_0 INT32 ARRAY, field_51_01 REAL, field_52_012 CHAR, field_53_0123 INT32, field_54_01234 UINT8, field_55_012345 UINT64, field_56_0123456 CHAR, field_57_01234567 UINT16 ARRAY, field_58_012345678 UINT16, field_59_0123456789 UINT32, field_60_0 DATETIME, field_61_01 UINT16, field_62_012 DATETIME, field_63_0123 BOOL, field_64_01234 INT8, field_65_012345 UINT8, field_66_0123456 RICHREAL ARRAY, field_67_01234567 INT8 ARRAY, field_68_012345678 INT32, field_69_0123456789 CHAR, field_70_0 UINT64, field_71_01 UINT16, field_72_012 REAL)");
      /* 531 */ glbTypes.push_back("TABLE");
      /* 532 */ glbTypes.push_back("TABLE(field_1_01 INT32 ARRAY, field_2_012 BOOL ARRAY, field_3_0123 UINT8 ARRAY, field_4_01234 UINT8 ARRAY, field_5_012345 CHAR, field_6_0123456 INT32, field_7_01234567 UINT32 ARRAY, field_8_012345678 UINT8, field_9_0123456789 UINT8, field_10_0 UINT64 ARRAY, field_11_01 INT16, field_12_012 INT64, field_13_0123 REAL, field_14_01234 INT8, field_15_012345 REAL, field_16_0123456 RICHREAL, field_17_01234567 INT32, field_18_012345678 UINT64 ARRAY, field_19_0123456789 UINT64, field_20_0 UINT8, field_21_01 UINT16, field_22_012 INT32, field_23_0123 REAL ARRAY, field_24_01234 INT16, field_25_012345 INT32, field_26_0123456 BOOL, field_27_01234567 DATETIME ARRAY, field_28_012345678 INT32, field_29_0123456789 HIRESTIME, field_30_0 RICHREAL, field_31_01 UINT64, field_32_012 DATE, field_33_0123 INT8 ARRAY, field_34_01234 UINT8, field_35_012345 DATETIME, field_36_0123456 UINT64, field_37_01234567 UINT16, field_38_012345678 UINT32, field_39_0123456789 DATETIME, field_40_0 DATETIME, field_41_01 UINT64, field_42_012 REAL, field_43_0123 INT8, field_44_01234 DATE, field_45_012345 HIRESTIME ARRAY, field_46_0123456 BOOL ARRAY, field_47_01234567 UINT8 ARRAY, field_48_012345678 RICHREAL, field_49_0123456789 HIRESTIME, field_50_0 CHAR ARRAY, field_51_01 REAL, field_52_012 INT16, field_53_0123 UINT64, field_54_01234 DATE, field_55_012345 REAL, field_56_0123456 UINT64 ARRAY, field_57_01234567 HIRESTIME, field_58_012345678 UINT8, field_59_0123456789 DATE ARRAY, field_60_0 RICHREAL, field_61_01 BOOL, field_62_012 BOOL ARRAY, field_63_0123 UINT16, field_64_01234 BOOL, field_65_012345 REAL, field_66_0123456 REAL, field_67_01234567 HIRESTIME ARRAY, field_68_012345678 INT32, field_69_0123456789 UINT8 ARRAY, field_70_0 RICHREAL ARRAY, field_71_01 UINT8, field_72_012 HIRESTIME, field_73_0123 DATETIME, field_74_01234 INT16, field_75_012345 DATETIME, field_76_0123456 UINT32 ARRAY, field_77_01234567 RICHREAL, field_78_012345678 INT64)");
      /* 533 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 INT64, field_3_0123 HIRESTIME, field_4_01234 BOOL, field_5_012345 RICHREAL, field_6_0123456 INT64, field_7_01234567 UINT16, field_8_012345678 INT32 ARRAY, field_9_0123456789 RICHREAL, field_10_0 UINT64, field_11_01 INT64 ARRAY, field_12_012 CHAR, field_13_0123 INT64, field_14_01234 DATETIME, field_15_012345 RICHREAL ARRAY, field_16_0123456 REAL, field_17_01234567 INT32 ARRAY, field_18_012345678 CHAR, field_19_0123456789 INT32 ARRAY, field_20_0 INT8, field_21_01 UINT16, field_22_012 BOOL ARRAY, field_23_0123 CHAR, field_24_01234 DATE, field_25_012345 INT64, field_26_0123456 REAL, field_27_01234567 UINT16, field_28_012345678 UINT8, field_29_0123456789 UINT64 ARRAY, field_30_0 INT16, field_31_01 BOOL, field_32_012 CHAR, field_33_0123 HIRESTIME, field_34_01234 BOOL, field_35_012345 INT64, field_36_0123456 UINT16, field_37_01234567 INT32, field_38_012345678 INT32 ARRAY, field_39_0123456789 INT64, field_40_0 INT64, field_41_01 UINT8 ARRAY, field_42_012 INT32 ARRAY, field_43_0123 HIRESTIME, field_44_01234 UINT8 ARRAY, field_45_012345 BOOL, field_46_0123456 CHAR, field_47_01234567 UINT32, field_48_012345678 UINT8, field_49_0123456789 UINT8 ARRAY, field_50_0 INT8, field_51_01 UINT32 ARRAY, field_52_012 DATE, field_53_0123 DATE, field_54_01234 RICHREAL, field_55_012345 CHAR ARRAY)");
      /* 534 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 DATE ARRAY, field_3_0123 RICHREAL, field_4_01234 INT64 ARRAY, field_5_012345 UINT64, field_6_0123456 HIRESTIME, field_7_01234567 INT8, field_8_012345678 DATE, field_9_0123456789 UINT8, field_10_0 CHAR, field_11_01 DATE, field_12_012 INT8, field_13_0123 INT16, field_14_01234 RICHREAL, field_15_012345 DATETIME, field_16_0123456 INT8 ARRAY, field_17_01234567 RICHREAL, field_18_012345678 UINT32, field_19_0123456789 UINT16, field_20_0 BOOL ARRAY)");
      /* 535 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 BOOL, field_3_0123 INT64, field_4_01234 BOOL, field_5_012345 UINT32, field_6_0123456 UINT64, field_7_01234567 INT16, field_8_012345678 DATE, field_9_0123456789 UINT64, field_10_0 UINT64, field_11_01 HIRESTIME, field_12_012 INT64, field_13_0123 DATETIME ARRAY, field_14_01234 REAL, field_15_012345 INT32, field_16_0123456 INT8, field_17_01234567 INT16, field_18_012345678 DATETIME, field_19_0123456789 HIRESTIME ARRAY, field_20_0 UINT32, field_21_01 UINT32, field_22_012 UINT64, field_23_0123 INT8, field_24_01234 UINT16, field_25_012345 INT16, field_26_0123456 REAL, field_27_01234567 INT64, field_28_012345678 UINT8, field_29_0123456789 INT64 ARRAY, field_30_0 UINT8, field_31_01 INT64, field_32_012 INT16, field_33_0123 INT32 ARRAY, field_34_01234 INT8, field_35_012345 UINT64 ARRAY, field_36_0123456 REAL, field_37_01234567 DATETIME, field_38_012345678 REAL, field_39_0123456789 INT16, field_40_0 INT16, field_41_01 DATETIME, field_42_012 UINT8 ARRAY, field_43_0123 UINT16, field_44_01234 DATE, field_45_012345 RICHREAL, field_46_0123456 DATETIME, field_47_01234567 BOOL, field_48_012345678 BOOL, field_49_0123456789 HIRESTIME, field_50_0 REAL, field_51_01 INT64, field_52_012 BOOL ARRAY, field_53_0123 UINT16, field_54_01234 UINT64, field_55_012345 INT64, field_56_0123456 HIRESTIME, field_57_01234567 UINT64, field_58_012345678 UINT8, field_59_0123456789 DATETIME, field_60_0 INT64, field_61_01 INT8, field_62_012 DATETIME, field_63_0123 UINT8, field_64_01234 UINT8, field_65_012345 INT64, field_66_0123456 DATE, field_67_01234567 UINT8, field_68_012345678 UINT16 ARRAY, field_69_0123456789 INT8, field_70_0 UINT32, field_71_01 INT16, field_72_012 UINT32 ARRAY, field_73_0123 INT16, field_74_01234 DATETIME, field_75_012345 UINT8, field_76_0123456 DATETIME ARRAY, field_77_01234567 INT32, field_78_012345678 BOOL ARRAY, field_79_0123456789 DATETIME, field_80_0 BOOL, field_81_01 DATE, field_82_012 INT8, field_83_0123 UINT16, field_84_01234 UINT16, field_85_012345 INT16 ARRAY, field_86_0123456 INT64 ARRAY, field_87_01234567 UINT32, field_88_012345678 DATETIME, field_89_0123456789 BOOL, field_90_0 INT8, field_91_01 BOOL, field_92_012 BOOL, field_93_0123 RICHREAL, field_94_01234 DATE)");
      /* 536 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 UINT64, field_3_0123 INT32, field_4_01234 UINT64 ARRAY, field_5_012345 INT8, field_6_0123456 UINT64, field_7_01234567 UINT32, field_8_012345678 BOOL, field_9_0123456789 CHAR, field_10_0 DATE ARRAY, field_11_01 DATETIME, field_12_012 CHAR ARRAY, field_13_0123 INT16, field_14_01234 UINT64 ARRAY, field_15_012345 UINT8, field_16_0123456 INT16, field_17_01234567 HIRESTIME, field_18_012345678 UINT32, field_19_0123456789 INT8 ARRAY, field_20_0 INT32, field_21_01 INT16, field_22_012 UINT64, field_23_0123 INT8, field_24_01234 INT32 ARRAY, field_25_012345 RICHREAL, field_26_0123456 INT64, field_27_01234567 BOOL, field_28_012345678 DATETIME, field_29_0123456789 BOOL, field_30_0 BOOL, field_31_01 INT16, field_32_012 INT16, field_33_0123 INT16, field_34_01234 DATE, field_35_012345 UINT8)");
      /* 537 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 UINT16, field_3_0123 RICHREAL ARRAY, field_4_01234 BOOL, field_5_012345 RICHREAL, field_6_0123456 INT8, field_7_01234567 DATETIME, field_8_012345678 DATETIME, field_9_0123456789 DATETIME, field_10_0 UINT16, field_11_01 INT16, field_12_012 DATE, field_13_0123 BOOL, field_14_01234 UINT8, field_15_012345 UINT32, field_16_0123456 CHAR, field_17_01234567 HIRESTIME, field_18_012345678 UINT8 ARRAY, field_19_0123456789 INT32, field_20_0 UINT16, field_21_01 INT32 ARRAY, field_22_012 INT16 ARRAY, field_23_0123 UINT8 ARRAY, field_24_01234 REAL, field_25_012345 RICHREAL, field_26_0123456 UINT64 ARRAY, field_27_01234567 UINT16, field_28_012345678 UINT32, field_29_0123456789 INT8 ARRAY, field_30_0 BOOL, field_31_01 INT8, field_32_012 CHAR, field_33_0123 RICHREAL ARRAY, field_34_01234 INT8, field_35_012345 RICHREAL ARRAY, field_36_0123456 DATE, field_37_01234567 CHAR, field_38_012345678 UINT16, field_39_0123456789 UINT32, field_40_0 UINT8 ARRAY, field_41_01 INT16 ARRAY, field_42_012 DATE, field_43_0123 UINT32, field_44_01234 INT8, field_45_012345 INT8, field_46_0123456 UINT16, field_47_01234567 INT32, field_48_012345678 CHAR, field_49_0123456789 BOOL, field_50_0 CHAR, field_51_01 CHAR, field_52_012 UINT16, field_53_0123 INT8 ARRAY, field_54_01234 INT16, field_55_012345 INT32, field_56_0123456 INT32, field_57_01234567 UINT16, field_58_012345678 DATE, field_59_0123456789 DATE, field_60_0 HIRESTIME, field_61_01 BOOL, field_62_012 INT32 ARRAY, field_63_0123 UINT32 ARRAY, field_64_01234 CHAR ARRAY, field_65_012345 INT8, field_66_0123456 DATE, field_67_01234567 DATE ARRAY, field_68_012345678 UINT16, field_69_0123456789 INT16, field_70_0 RICHREAL, field_71_01 UINT8, field_72_012 HIRESTIME, field_73_0123 RICHREAL)");
      /* 538 */ glbTypes.push_back("TABLE(field_1_01 INT32 ARRAY, field_2_012 INT16, field_3_0123 INT32, field_4_01234 CHAR, field_5_012345 INT32, field_6_0123456 RICHREAL, field_7_01234567 UINT16, field_8_012345678 BOOL, field_9_0123456789 INT32, field_10_0 INT16 ARRAY, field_11_01 UINT16, field_12_012 INT32, field_13_0123 CHAR ARRAY, field_14_01234 HIRESTIME ARRAY, field_15_012345 INT8, field_16_0123456 REAL, field_17_01234567 DATETIME, field_18_012345678 DATETIME, field_19_0123456789 DATE, field_20_0 UINT8, field_21_01 HIRESTIME, field_22_012 INT16, field_23_0123 UINT8, field_24_01234 UINT64, field_25_012345 UINT32, field_26_0123456 UINT16, field_27_01234567 BOOL, field_28_012345678 HIRESTIME, field_29_0123456789 UINT8, field_30_0 INT32, field_31_01 UINT32, field_32_012 DATE, field_33_0123 UINT32, field_34_01234 UINT32, field_35_012345 INT8, field_36_0123456 INT16, field_37_01234567 DATETIME, field_38_012345678 UINT8 ARRAY, field_39_0123456789 INT8, field_40_0 INT32, field_41_01 RICHREAL, field_42_012 INT32, field_43_0123 CHAR, field_44_01234 DATE, field_45_012345 REAL ARRAY, field_46_0123456 UINT8, field_47_01234567 INT64, field_48_012345678 BOOL, field_49_0123456789 HIRESTIME, field_50_0 DATE, field_51_01 CHAR, field_52_012 UINT16, field_53_0123 DATE, field_54_01234 DATE, field_55_012345 RICHREAL, field_56_0123456 INT64, field_57_01234567 REAL, field_58_012345678 RICHREAL, field_59_0123456789 BOOL, field_60_0 UINT8, field_61_01 REAL, field_62_012 DATE, field_63_0123 DATETIME, field_64_01234 INT32, field_65_012345 INT32, field_66_0123456 REAL, field_67_01234567 INT8 ARRAY, field_68_012345678 DATETIME, field_69_0123456789 REAL ARRAY, field_70_0 INT16, field_71_01 INT16, field_72_012 UINT16, field_73_0123 HIRESTIME ARRAY, field_74_01234 UINT8 ARRAY)");
      /* 539 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 INT64, field_3_0123 INT8 ARRAY, field_4_01234 DATE, field_5_012345 UINT8, field_6_0123456 INT64, field_7_01234567 BOOL, field_8_012345678 RICHREAL, field_9_0123456789 CHAR, field_10_0 INT16, field_11_01 RICHREAL ARRAY, field_12_012 DATETIME ARRAY, field_13_0123 UINT64, field_14_01234 DATETIME, field_15_012345 UINT64, field_16_0123456 INT32, field_17_01234567 UINT64, field_18_012345678 DATE, field_19_0123456789 INT32, field_20_0 UINT8, field_21_01 INT32, field_22_012 UINT8, field_23_0123 INT16 ARRAY, field_24_01234 UINT64, field_25_012345 INT64 ARRAY, field_26_0123456 INT32, field_27_01234567 DATETIME, field_28_012345678 BOOL, field_29_0123456789 DATETIME, field_30_0 RICHREAL, field_31_01 DATE, field_32_012 UINT64, field_33_0123 UINT32, field_34_01234 HIRESTIME ARRAY, field_35_012345 UINT16 ARRAY, field_36_0123456 UINT8, field_37_01234567 INT16, field_38_012345678 UINT8, field_39_0123456789 DATETIME, field_40_0 HIRESTIME ARRAY, field_41_01 INT8 ARRAY, field_42_012 INT32, field_43_0123 DATETIME ARRAY, field_44_01234 CHAR, field_45_012345 UINT8, field_46_0123456 INT16, field_47_01234567 HIRESTIME, field_48_012345678 INT16 ARRAY, field_49_0123456789 INT16 ARRAY, field_50_0 HIRESTIME, field_51_01 DATE, field_52_012 UINT16 ARRAY, field_53_0123 UINT8, field_54_01234 CHAR, field_55_012345 DATETIME ARRAY, field_56_0123456 INT32, field_57_01234567 UINT16, field_58_012345678 UINT64 ARRAY, field_59_0123456789 HIRESTIME, field_60_0 DATE, field_61_01 INT8, field_62_012 BOOL ARRAY, field_63_0123 CHAR, field_64_01234 INT32, field_65_012345 CHAR, field_66_0123456 REAL, field_67_01234567 UINT8 ARRAY, field_68_012345678 INT32, field_69_0123456789 UINT8, field_70_0 HIRESTIME, field_71_01 CHAR ARRAY, field_72_012 RICHREAL, field_73_0123 UINT32 ARRAY, field_74_01234 UINT32, field_75_012345 DATE, field_76_0123456 DATETIME)");
      /* 540 */ glbTypes.push_back("TABLE(field_1_01 INT8 ARRAY, field_2_012 RICHREAL, field_3_0123 REAL, field_4_01234 CHAR, field_5_012345 REAL, field_6_0123456 UINT32, field_7_01234567 INT16, field_8_012345678 REAL ARRAY, field_9_0123456789 UINT32, field_10_0 INT8, field_11_01 UINT64, field_12_012 DATE, field_13_0123 UINT64, field_14_01234 INT64, field_15_012345 INT32, field_16_0123456 DATE ARRAY, field_17_01234567 UINT16, field_18_012345678 CHAR, field_19_0123456789 HIRESTIME, field_20_0 DATE, field_21_01 INT32, field_22_012 RICHREAL, field_23_0123 UINT16, field_24_01234 INT16, field_25_012345 UINT64, field_26_0123456 HIRESTIME ARRAY, field_27_01234567 RICHREAL, field_28_012345678 UINT16, field_29_0123456789 CHAR, field_30_0 INT64 ARRAY, field_31_01 INT16, field_32_012 INT16, field_33_0123 UINT32, field_34_01234 CHAR, field_35_012345 INT16, field_36_0123456 UINT32 ARRAY, field_37_01234567 INT8, field_38_012345678 DATETIME, field_39_0123456789 UINT32, field_40_0 CHAR ARRAY, field_41_01 DATETIME, field_42_012 INT64, field_43_0123 INT8, field_44_01234 UINT8, field_45_012345 INT16, field_46_0123456 UINT32, field_47_01234567 INT32, field_48_012345678 HIRESTIME, field_49_0123456789 DATETIME ARRAY, field_50_0 UINT8, field_51_01 INT64 ARRAY, field_52_012 CHAR)");
      /* 541 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 UINT32, field_3_0123 HIRESTIME, field_4_01234 UINT32, field_5_012345 UINT32 ARRAY, field_6_0123456 UINT64, field_7_01234567 HIRESTIME, field_8_012345678 REAL, field_9_0123456789 BOOL ARRAY, field_10_0 DATE, field_11_01 DATETIME ARRAY, field_12_012 UINT32, field_13_0123 DATETIME, field_14_01234 DATETIME, field_15_012345 CHAR, field_16_0123456 INT64, field_17_01234567 INT32, field_18_012345678 BOOL ARRAY, field_19_0123456789 HIRESTIME ARRAY, field_20_0 DATE, field_21_01 INT32 ARRAY, field_22_012 RICHREAL, field_23_0123 INT16 ARRAY, field_24_01234 BOOL, field_25_012345 INT32, field_26_0123456 DATETIME, field_27_01234567 DATETIME, field_28_012345678 UINT64, field_29_0123456789 BOOL, field_30_0 BOOL, field_31_01 HIRESTIME, field_32_012 UINT64, field_33_0123 INT32, field_34_01234 CHAR, field_35_012345 HIRESTIME, field_36_0123456 INT64 ARRAY, field_37_01234567 UINT8, field_38_012345678 INT32, field_39_0123456789 INT32, field_40_0 BOOL, field_41_01 HIRESTIME, field_42_012 INT16 ARRAY, field_43_0123 INT16, field_44_01234 UINT64, field_45_012345 INT8, field_46_0123456 RICHREAL, field_47_01234567 INT64 ARRAY, field_48_012345678 HIRESTIME, field_49_0123456789 INT32, field_50_0 UINT8, field_51_01 UINT16, field_52_012 BOOL, field_53_0123 INT16, field_54_01234 INT16, field_55_012345 INT8, field_56_0123456 UINT16, field_57_01234567 BOOL, field_58_012345678 CHAR ARRAY, field_59_0123456789 CHAR ARRAY, field_60_0 UINT16, field_61_01 INT64, field_62_012 CHAR, field_63_0123 BOOL, field_64_01234 DATE, field_65_012345 INT64 ARRAY)");
      /* 542 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 HIRESTIME, field_3_0123 RICHREAL, field_4_01234 HIRESTIME, field_5_012345 BOOL, field_6_0123456 DATE, field_7_01234567 INT16, field_8_012345678 DATE, field_9_0123456789 INT8, field_10_0 UINT32 ARRAY, field_11_01 UINT32, field_12_012 REAL, field_13_0123 CHAR, field_14_01234 DATE, field_15_012345 RICHREAL ARRAY, field_16_0123456 INT32 ARRAY, field_17_01234567 INT32, field_18_012345678 DATETIME, field_19_0123456789 INT16, field_20_0 UINT32, field_21_01 DATE, field_22_012 INT64, field_23_0123 INT64 ARRAY, field_24_01234 CHAR, field_25_012345 CHAR, field_26_0123456 CHAR ARRAY, field_27_01234567 UINT8, field_28_012345678 BOOL, field_29_0123456789 UINT64, field_30_0 DATE, field_31_01 INT8 ARRAY, field_32_012 DATETIME, field_33_0123 INT8, field_34_01234 DATETIME, field_35_012345 INT16, field_36_0123456 INT16, field_37_01234567 INT16, field_38_012345678 HIRESTIME, field_39_0123456789 INT16, field_40_0 BOOL, field_41_01 INT16, field_42_012 INT8, field_43_0123 UINT32, field_44_01234 UINT16, field_45_012345 UINT64, field_46_0123456 DATE ARRAY, field_47_01234567 INT64, field_48_012345678 INT32, field_49_0123456789 INT64, field_50_0 UINT64, field_51_01 INT32, field_52_012 DATETIME, field_53_0123 UINT32, field_54_01234 UINT16 ARRAY, field_55_012345 INT64, field_56_0123456 INT32, field_57_01234567 BOOL, field_58_012345678 INT8, field_59_0123456789 HIRESTIME, field_60_0 DATETIME, field_61_01 UINT8, field_62_012 HIRESTIME ARRAY, field_63_0123 DATETIME, field_64_01234 INT32 ARRAY, field_65_012345 BOOL ARRAY, field_66_0123456 UINT8, field_67_01234567 INT64 ARRAY, field_68_012345678 UINT16, field_69_0123456789 INT8, field_70_0 INT32, field_71_01 CHAR, field_72_012 INT32, field_73_0123 DATE, field_74_01234 UINT32, field_75_012345 DATETIME, field_76_0123456 INT64 ARRAY, field_77_01234567 BOOL)");
      /* 543 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 CHAR, field_3_0123 HIRESTIME ARRAY, field_4_01234 UINT8, field_5_012345 DATE ARRAY, field_6_0123456 INT64, field_7_01234567 INT32, field_8_012345678 UINT16, field_9_0123456789 CHAR, field_10_0 DATE, field_11_01 REAL, field_12_012 UINT8, field_13_0123 INT64 ARRAY, field_14_01234 DATE, field_15_012345 CHAR, field_16_0123456 BOOL, field_17_01234567 INT16, field_18_012345678 INT32, field_19_0123456789 INT32, field_20_0 REAL, field_21_01 BOOL, field_22_012 BOOL ARRAY, field_23_0123 DATETIME, field_24_01234 RICHREAL ARRAY, field_25_012345 DATETIME, field_26_0123456 UINT32, field_27_01234567 INT32, field_28_012345678 RICHREAL, field_29_0123456789 INT64, field_30_0 UINT64 ARRAY, field_31_01 INT8, field_32_012 INT32, field_33_0123 REAL, field_34_01234 BOOL ARRAY, field_35_012345 UINT8)");
      /* 544 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 REAL, field_3_0123 DATE ARRAY, field_4_01234 INT32 ARRAY, field_5_012345 CHAR ARRAY, field_6_0123456 DATE, field_7_01234567 HIRESTIME, field_8_012345678 UINT64, field_9_0123456789 DATETIME ARRAY, field_10_0 UINT64, field_11_01 DATETIME, field_12_012 RICHREAL, field_13_0123 DATE ARRAY, field_14_01234 INT8, field_15_012345 UINT16 ARRAY, field_16_0123456 BOOL, field_17_01234567 INT16, field_18_012345678 INT16, field_19_0123456789 HIRESTIME ARRAY, field_20_0 UINT8, field_21_01 DATE ARRAY, field_22_012 INT64, field_23_0123 UINT64, field_24_01234 CHAR, field_25_012345 UINT8 ARRAY, field_26_0123456 DATETIME, field_27_01234567 INT16, field_28_012345678 HIRESTIME, field_29_0123456789 UINT16, field_30_0 UINT16 ARRAY, field_31_01 BOOL ARRAY, field_32_012 UINT16 ARRAY, field_33_0123 INT64, field_34_01234 INT64, field_35_012345 BOOL, field_36_0123456 UINT8 ARRAY, field_37_01234567 UINT32 ARRAY, field_38_012345678 BOOL, field_39_0123456789 UINT8, field_40_0 UINT16, field_41_01 UINT64 ARRAY, field_42_012 CHAR, field_43_0123 DATE, field_44_01234 UINT8, field_45_012345 UINT64, field_46_0123456 UINT32, field_47_01234567 UINT64, field_48_012345678 UINT64, field_49_0123456789 INT16, field_50_0 INT32, field_51_01 INT16, field_52_012 INT16, field_53_0123 INT8, field_54_01234 HIRESTIME ARRAY, field_55_012345 DATETIME, field_56_0123456 UINT64, field_57_01234567 CHAR, field_58_012345678 CHAR, field_59_0123456789 INT8, field_60_0 INT16, field_61_01 UINT32, field_62_012 HIRESTIME, field_63_0123 DATETIME, field_64_01234 INT32, field_65_012345 INT64, field_66_0123456 INT8, field_67_01234567 INT32, field_68_012345678 INT32, field_69_0123456789 CHAR, field_70_0 DATE, field_71_01 INT32, field_72_012 INT8 ARRAY, field_73_0123 DATETIME, field_74_01234 INT8 ARRAY, field_75_012345 INT16 ARRAY, field_76_0123456 INT8)");
      /* 545 */ glbTypes.push_back("TABLE(field_1_01 BOOL ARRAY, field_2_012 INT32, field_3_0123 UINT16, field_4_01234 INT16, field_5_012345 UINT8, field_6_0123456 DATETIME, field_7_01234567 RICHREAL ARRAY, field_8_012345678 INT16, field_9_0123456789 CHAR, field_10_0 INT8 ARRAY, field_11_01 CHAR ARRAY, field_12_012 DATETIME)");
      /* 546 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL ARRAY, field_2_012 UINT32, field_3_0123 UINT16, field_4_01234 INT32 ARRAY, field_5_012345 UINT8, field_6_0123456 INT64, field_7_01234567 CHAR, field_8_012345678 CHAR ARRAY, field_9_0123456789 BOOL ARRAY, field_10_0 INT64, field_11_01 INT8, field_12_012 BOOL, field_13_0123 INT64, field_14_01234 BOOL, field_15_012345 INT64, field_16_0123456 RICHREAL, field_17_01234567 INT64, field_18_012345678 DATETIME, field_19_0123456789 DATE, field_20_0 DATE, field_21_01 UINT32, field_22_012 REAL, field_23_0123 DATE ARRAY, field_24_01234 CHAR, field_25_012345 UINT8, field_26_0123456 INT32, field_27_01234567 REAL, field_28_012345678 DATETIME, field_29_0123456789 UINT32, field_30_0 UINT16 ARRAY, field_31_01 UINT16 ARRAY, field_32_012 INT32 ARRAY, field_33_0123 CHAR ARRAY, field_34_01234 INT16, field_35_012345 UINT8, field_36_0123456 INT8, field_37_01234567 HIRESTIME, field_38_012345678 UINT64 ARRAY, field_39_0123456789 INT64 ARRAY, field_40_0 CHAR, field_41_01 HIRESTIME ARRAY, field_42_012 UINT8, field_43_0123 INT8, field_44_01234 CHAR, field_45_012345 DATE, field_46_0123456 RICHREAL ARRAY, field_47_01234567 BOOL, field_48_012345678 INT64, field_49_0123456789 INT8, field_50_0 DATE, field_51_01 INT32, field_52_012 INT64, field_53_0123 CHAR ARRAY, field_54_01234 INT64, field_55_012345 BOOL, field_56_0123456 INT16, field_57_01234567 DATE, field_58_012345678 CHAR, field_59_0123456789 INT16, field_60_0 UINT16, field_61_01 INT8 ARRAY, field_62_012 RICHREAL, field_63_0123 DATETIME, field_64_01234 DATE, field_65_012345 RICHREAL, field_66_0123456 REAL, field_67_01234567 CHAR, field_68_012345678 DATE, field_69_0123456789 INT8, field_70_0 INT16, field_71_01 REAL, field_72_012 UINT32, field_73_0123 INT32 ARRAY, field_74_01234 REAL)");
      /* 547 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 UINT16, field_3_0123 INT8, field_4_01234 BOOL ARRAY, field_5_012345 UINT64, field_6_0123456 INT8, field_7_01234567 UINT64, field_8_012345678 UINT64, field_9_0123456789 CHAR, field_10_0 HIRESTIME ARRAY, field_11_01 UINT16 ARRAY, field_12_012 INT32, field_13_0123 REAL, field_14_01234 INT8, field_15_012345 HIRESTIME ARRAY, field_16_0123456 REAL, field_17_01234567 UINT16, field_18_012345678 UINT64 ARRAY, field_19_0123456789 INT16, field_20_0 INT64, field_21_01 HIRESTIME, field_22_012 UINT64, field_23_0123 HIRESTIME, field_24_01234 UINT64 ARRAY, field_25_012345 INT64, field_26_0123456 UINT16, field_27_01234567 INT64, field_28_012345678 UINT16, field_29_0123456789 BOOL, field_30_0 UINT32, field_31_01 INT32, field_32_012 BOOL, field_33_0123 INT64 ARRAY, field_34_01234 CHAR, field_35_012345 INT32, field_36_0123456 DATE ARRAY, field_37_01234567 INT16, field_38_012345678 INT32, field_39_0123456789 INT8, field_40_0 CHAR, field_41_01 INT16, field_42_012 INT16, field_43_0123 UINT8, field_44_01234 UINT16, field_45_012345 CHAR, field_46_0123456 REAL, field_47_01234567 CHAR, field_48_012345678 DATE ARRAY, field_49_0123456789 BOOL, field_50_0 UINT64, field_51_01 RICHREAL ARRAY, field_52_012 UINT32, field_53_0123 INT8, field_54_01234 CHAR, field_55_012345 UINT8 ARRAY, field_56_0123456 INT64)");
      /* 548 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME ARRAY, field_2_012 UINT32 ARRAY, field_3_0123 UINT16, field_4_01234 INT32 ARRAY, field_5_012345 INT64 ARRAY, field_6_0123456 INT32, field_7_01234567 INT32 ARRAY, field_8_012345678 HIRESTIME ARRAY, field_9_0123456789 BOOL ARRAY, field_10_0 HIRESTIME, field_11_01 INT8, field_12_012 UINT32, field_13_0123 CHAR, field_14_01234 INT16, field_15_012345 INT64, field_16_0123456 UINT8, field_17_01234567 CHAR ARRAY, field_18_012345678 INT8 ARRAY, field_19_0123456789 UINT8 ARRAY, field_20_0 CHAR, field_21_01 INT16, field_22_012 INT16, field_23_0123 INT64 ARRAY, field_24_01234 DATETIME, field_25_012345 UINT64 ARRAY, field_26_0123456 CHAR, field_27_01234567 UINT64, field_28_012345678 BOOL, field_29_0123456789 BOOL, field_30_0 UINT64, field_31_01 BOOL, field_32_012 CHAR, field_33_0123 DATE ARRAY)");
      /* 549 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 INT64, field_3_0123 INT16, field_4_01234 UINT8, field_5_012345 UINT32, field_6_0123456 INT64 ARRAY, field_7_01234567 UINT8 ARRAY, field_8_012345678 UINT16, field_9_0123456789 RICHREAL, field_10_0 CHAR ARRAY, field_11_01 HIRESTIME, field_12_012 RICHREAL, field_13_0123 UINT32 ARRAY, field_14_01234 INT16, field_15_012345 INT8, field_16_0123456 INT8 ARRAY, field_17_01234567 DATETIME, field_18_012345678 DATE, field_19_0123456789 UINT64, field_20_0 CHAR, field_21_01 INT8, field_22_012 UINT32, field_23_0123 INT32, field_24_01234 INT16, field_25_012345 UINT64, field_26_0123456 INT32, field_27_01234567 DATE, field_28_012345678 INT16, field_29_0123456789 DATE, field_30_0 DATETIME, field_31_01 CHAR, field_32_012 UINT8, field_33_0123 DATETIME, field_34_01234 RICHREAL ARRAY, field_35_012345 HIRESTIME ARRAY, field_36_0123456 HIRESTIME, field_37_01234567 CHAR, field_38_012345678 INT64, field_39_0123456789 UINT64, field_40_0 DATE, field_41_01 UINT8, field_42_012 UINT16 ARRAY, field_43_0123 DATE, field_44_01234 DATE, field_45_012345 BOOL, field_46_0123456 DATE, field_47_01234567 UINT16, field_48_012345678 BOOL, field_49_0123456789 INT16, field_50_0 DATE, field_51_01 REAL, field_52_012 UINT64 ARRAY, field_53_0123 UINT16, field_54_01234 INT8, field_55_012345 RICHREAL, field_56_0123456 UINT8, field_57_01234567 INT64, field_58_012345678 UINT8, field_59_0123456789 INT64, field_60_0 INT32, field_61_01 DATETIME, field_62_012 INT64, field_63_0123 INT8, field_64_01234 INT8, field_65_012345 INT32 ARRAY, field_66_0123456 INT64, field_67_01234567 UINT64, field_68_012345678 UINT16, field_69_0123456789 INT32, field_70_0 DATE, field_71_01 REAL, field_72_012 DATETIME, field_73_0123 DATE ARRAY, field_74_01234 UINT8 ARRAY, field_75_012345 REAL, field_76_0123456 INT64 ARRAY, field_77_01234567 INT64)");
      /* 550 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 BOOL, field_3_0123 RICHREAL, field_4_01234 INT8, field_5_012345 RICHREAL ARRAY, field_6_0123456 UINT64, field_7_01234567 UINT64, field_8_012345678 INT16, field_9_0123456789 INT64 ARRAY, field_10_0 DATETIME, field_11_01 INT8, field_12_012 UINT64, field_13_0123 DATE ARRAY, field_14_01234 BOOL, field_15_012345 INT8, field_16_0123456 UINT16, field_17_01234567 UINT8, field_18_012345678 REAL ARRAY, field_19_0123456789 INT8, field_20_0 RICHREAL, field_21_01 INT8, field_22_012 UINT16, field_23_0123 RICHREAL, field_24_01234 RICHREAL, field_25_012345 HIRESTIME, field_26_0123456 UINT16, field_27_01234567 RICHREAL, field_28_012345678 UINT8, field_29_0123456789 BOOL, field_30_0 INT16 ARRAY, field_31_01 INT16, field_32_012 DATE, field_33_0123 INT16, field_34_01234 REAL, field_35_012345 UINT8, field_36_0123456 CHAR ARRAY, field_37_01234567 RICHREAL ARRAY, field_38_012345678 INT64, field_39_0123456789 INT8, field_40_0 UINT64, field_41_01 DATE, field_42_012 UINT16, field_43_0123 HIRESTIME, field_44_01234 UINT32, field_45_012345 INT32, field_46_0123456 UINT16, field_47_01234567 DATETIME, field_48_012345678 INT64, field_49_0123456789 INT16 ARRAY, field_50_0 INT64, field_51_01 UINT8, field_52_012 RICHREAL, field_53_0123 INT64, field_54_01234 INT64 ARRAY, field_55_012345 DATE, field_56_0123456 INT8, field_57_01234567 DATE, field_58_012345678 HIRESTIME, field_59_0123456789 RICHREAL, field_60_0 INT64 ARRAY, field_61_01 UINT16, field_62_012 INT16, field_63_0123 DATE, field_64_01234 BOOL, field_65_012345 RICHREAL, field_66_0123456 BOOL, field_67_01234567 UINT64, field_68_012345678 HIRESTIME ARRAY, field_69_0123456789 UINT16, field_70_0 INT32 ARRAY, field_71_01 INT32, field_72_012 INT8, field_73_0123 REAL, field_74_01234 RICHREAL, field_75_012345 UINT16 ARRAY, field_76_0123456 UINT16 ARRAY, field_77_01234567 INT64 ARRAY, field_78_012345678 UINT32, field_79_0123456789 DATE, field_80_0 INT16 ARRAY, field_81_01 RICHREAL, field_82_012 DATETIME, field_83_0123 UINT64, field_84_01234 INT16, field_85_012345 REAL ARRAY, field_86_0123456 UINT8, field_87_01234567 DATE, field_88_012345678 UINT64, field_89_0123456789 HIRESTIME)");
      /* 551 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL ARRAY, field_2_012 CHAR ARRAY, field_3_0123 RICHREAL, field_4_01234 INT16 ARRAY, field_5_012345 INT16, field_6_0123456 UINT32, field_7_01234567 INT64, field_8_012345678 HIRESTIME, field_9_0123456789 INT64 ARRAY, field_10_0 INT64 ARRAY, field_11_01 REAL ARRAY, field_12_012 UINT16, field_13_0123 BOOL, field_14_01234 INT64, field_15_012345 DATETIME, field_16_0123456 UINT8, field_17_01234567 HIRESTIME, field_18_012345678 INT32, field_19_0123456789 BOOL ARRAY, field_20_0 HIRESTIME, field_21_01 INT8 ARRAY, field_22_012 REAL)");
      /* 552 */ glbTypes.push_back("TABLE(field_1_01 DATE ARRAY, field_2_012 UINT16, field_3_0123 DATETIME, field_4_01234 UINT64, field_5_012345 INT32, field_6_0123456 UINT32, field_7_01234567 CHAR, field_8_012345678 UINT32, field_9_0123456789 HIRESTIME, field_10_0 DATE, field_11_01 REAL, field_12_012 INT32, field_13_0123 RICHREAL, field_14_01234 INT8 ARRAY, field_15_012345 UINT16, field_16_0123456 UINT16 ARRAY, field_17_01234567 RICHREAL ARRAY, field_18_012345678 RICHREAL, field_19_0123456789 UINT16 ARRAY, field_20_0 CHAR, field_21_01 CHAR, field_22_012 DATE, field_23_0123 REAL ARRAY, field_24_01234 DATE, field_25_012345 UINT16, field_26_0123456 INT64 ARRAY, field_27_01234567 UINT64, field_28_012345678 RICHREAL, field_29_0123456789 INT8, field_30_0 DATE ARRAY, field_31_01 INT32, field_32_012 UINT32, field_33_0123 INT32, field_34_01234 INT16, field_35_012345 INT16 ARRAY, field_36_0123456 CHAR, field_37_01234567 DATE ARRAY, field_38_012345678 INT8, field_39_0123456789 RICHREAL, field_40_0 RICHREAL ARRAY, field_41_01 UINT16, field_42_012 HIRESTIME ARRAY, field_43_0123 UINT64, field_44_01234 DATETIME, field_45_012345 CHAR, field_46_0123456 CHAR ARRAY, field_47_01234567 HIRESTIME, field_48_012345678 DATETIME, field_49_0123456789 REAL ARRAY, field_50_0 UINT32, field_51_01 UINT8, field_52_012 RICHREAL, field_53_0123 RICHREAL, field_54_01234 DATE, field_55_012345 INT32, field_56_0123456 UINT16, field_57_01234567 UINT32, field_58_012345678 BOOL, field_59_0123456789 INT64 ARRAY, field_60_0 BOOL ARRAY, field_61_01 INT8, field_62_012 UINT8, field_63_0123 DATETIME, field_64_01234 DATETIME, field_65_012345 UINT8, field_66_0123456 RICHREAL, field_67_01234567 UINT8, field_68_012345678 INT32 ARRAY, field_69_0123456789 UINT8, field_70_0 UINT32, field_71_01 UINT32, field_72_012 UINT64 ARRAY, field_73_0123 UINT32, field_74_01234 RICHREAL, field_75_012345 RICHREAL, field_76_0123456 INT8, field_77_01234567 INT16 ARRAY, field_78_012345678 REAL, field_79_0123456789 UINT8, field_80_0 DATE ARRAY, field_81_01 BOOL, field_82_012 RICHREAL, field_83_0123 DATE ARRAY, field_84_01234 UINT8, field_85_012345 DATETIME, field_86_0123456 BOOL, field_87_01234567 REAL, field_88_012345678 RICHREAL, field_89_0123456789 INT32, field_90_0 DATETIME)");
      /* 553 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 INT32, field_3_0123 INT8, field_4_01234 INT16, field_5_012345 BOOL, field_6_0123456 UINT32, field_7_01234567 INT64, field_8_012345678 BOOL ARRAY, field_9_0123456789 UINT8, field_10_0 INT8 ARRAY, field_11_01 DATE, field_12_012 DATETIME, field_13_0123 DATETIME, field_14_01234 UINT32, field_15_012345 HIRESTIME, field_16_0123456 INT64 ARRAY, field_17_01234567 REAL, field_18_012345678 DATETIME, field_19_0123456789 RICHREAL, field_20_0 REAL, field_21_01 HIRESTIME, field_22_012 HIRESTIME, field_23_0123 UINT16, field_24_01234 CHAR, field_25_012345 INT8, field_26_0123456 UINT16 ARRAY, field_27_01234567 UINT32, field_28_012345678 DATE ARRAY, field_29_0123456789 DATETIME, field_30_0 UINT64 ARRAY, field_31_01 UINT64, field_32_012 INT8, field_33_0123 DATE)");
      /* 554 */ glbTypes.push_back("TABLE(field_1_01 UINT64 ARRAY, field_2_012 INT8, field_3_0123 CHAR, field_4_01234 RICHREAL, field_5_012345 HIRESTIME, field_6_0123456 UINT64, field_7_01234567 UINT8, field_8_012345678 DATETIME ARRAY, field_9_0123456789 CHAR, field_10_0 INT64, field_11_01 REAL, field_12_012 UINT32, field_13_0123 DATETIME, field_14_01234 DATETIME, field_15_012345 DATE, field_16_0123456 DATETIME, field_17_01234567 BOOL, field_18_012345678 CHAR, field_19_0123456789 CHAR ARRAY, field_20_0 UINT32, field_21_01 INT64, field_22_012 INT16, field_23_0123 INT64, field_24_01234 INT64, field_25_012345 BOOL, field_26_0123456 INT32, field_27_01234567 UINT32, field_28_012345678 BOOL, field_29_0123456789 UINT16, field_30_0 UINT16, field_31_01 INT8, field_32_012 HIRESTIME, field_33_0123 REAL ARRAY, field_34_01234 DATETIME, field_35_012345 INT32 ARRAY, field_36_0123456 BOOL, field_37_01234567 CHAR, field_38_012345678 BOOL, field_39_0123456789 BOOL, field_40_0 DATE, field_41_01 REAL ARRAY, field_42_012 DATETIME ARRAY, field_43_0123 INT64, field_44_01234 INT32, field_45_012345 INT64, field_46_0123456 UINT64, field_47_01234567 HIRESTIME, field_48_012345678 RICHREAL ARRAY, field_49_0123456789 BOOL ARRAY, field_50_0 BOOL, field_51_01 HIRESTIME, field_52_012 INT64, field_53_0123 UINT32 ARRAY, field_54_01234 UINT64, field_55_012345 INT64, field_56_0123456 UINT8, field_57_01234567 UINT8, field_58_012345678 UINT64 ARRAY, field_59_0123456789 INT64, field_60_0 INT16, field_61_01 HIRESTIME, field_62_012 UINT16, field_63_0123 REAL, field_64_01234 INT64, field_65_012345 BOOL ARRAY, field_66_0123456 INT16, field_67_01234567 INT8, field_68_012345678 REAL, field_69_0123456789 UINT32, field_70_0 HIRESTIME, field_71_01 UINT8, field_72_012 UINT16, field_73_0123 CHAR, field_74_01234 INT32, field_75_012345 UINT32 ARRAY, field_76_0123456 REAL, field_77_01234567 RICHREAL ARRAY, field_78_012345678 INT64, field_79_0123456789 UINT8, field_80_0 INT32, field_81_01 DATE, field_82_012 REAL, field_83_0123 UINT8, field_84_01234 INT8, field_85_012345 REAL, field_86_0123456 RICHREAL, field_87_01234567 INT64, field_88_012345678 INT64, field_89_0123456789 INT8, field_90_0 DATE, field_91_01 DATE ARRAY, field_92_012 HIRESTIME ARRAY, field_93_0123 INT16, field_94_01234 UINT8, field_95_012345 INT16)");
      /* 555 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 DATETIME ARRAY, field_3_0123 INT8 ARRAY, field_4_01234 REAL, field_5_012345 INT64 ARRAY, field_6_0123456 INT32, field_7_01234567 UINT64 ARRAY, field_8_012345678 REAL, field_9_0123456789 REAL ARRAY, field_10_0 INT64, field_11_01 DATETIME, field_12_012 INT16, field_13_0123 INT32 ARRAY, field_14_01234 INT32, field_15_012345 UINT64, field_16_0123456 HIRESTIME, field_17_01234567 RICHREAL, field_18_012345678 UINT16, field_19_0123456789 RICHREAL ARRAY, field_20_0 INT16, field_21_01 INT8, field_22_012 INT8, field_23_0123 REAL ARRAY, field_24_01234 UINT32, field_25_012345 UINT16 ARRAY, field_26_0123456 BOOL, field_27_01234567 INT64, field_28_012345678 CHAR, field_29_0123456789 REAL ARRAY, field_30_0 RICHREAL, field_31_01 BOOL, field_32_012 INT64, field_33_0123 INT32, field_34_01234 DATE ARRAY, field_35_012345 REAL ARRAY, field_36_0123456 UINT8, field_37_01234567 RICHREAL ARRAY, field_38_012345678 UINT32, field_39_0123456789 HIRESTIME, field_40_0 UINT16, field_41_01 REAL, field_42_012 DATETIME, field_43_0123 UINT32 ARRAY, field_44_01234 RICHREAL ARRAY, field_45_012345 INT16, field_46_0123456 CHAR, field_47_01234567 DATE, field_48_012345678 INT64, field_49_0123456789 INT8, field_50_0 INT16, field_51_01 UINT32 ARRAY, field_52_012 DATETIME ARRAY, field_53_0123 INT16, field_54_01234 BOOL, field_55_012345 UINT16, field_56_0123456 UINT64, field_57_01234567 UINT32, field_58_012345678 INT64, field_59_0123456789 UINT16, field_60_0 UINT64, field_61_01 INT8, field_62_012 CHAR, field_63_0123 INT64, field_64_01234 REAL, field_65_012345 UINT64)");
      /* 556 */ glbTypes.push_back("TABLE(field_1_01 UINT8 ARRAY, field_2_012 UINT16, field_3_0123 UINT16, field_4_01234 UINT64, field_5_012345 UINT16 ARRAY, field_6_0123456 INT8 ARRAY, field_7_01234567 CHAR ARRAY, field_8_012345678 RICHREAL, field_9_0123456789 INT8, field_10_0 INT32, field_11_01 DATE, field_12_012 RICHREAL ARRAY, field_13_0123 UINT32, field_14_01234 CHAR, field_15_012345 INT32, field_16_0123456 UINT64, field_17_01234567 INT8, field_18_012345678 INT32, field_19_0123456789 UINT32 ARRAY, field_20_0 BOOL, field_21_01 INT8, field_22_012 BOOL, field_23_0123 HIRESTIME, field_24_01234 INT64, field_25_012345 BOOL, field_26_0123456 DATE ARRAY, field_27_01234567 DATETIME, field_28_012345678 INT64, field_29_0123456789 UINT8, field_30_0 RICHREAL ARRAY, field_31_01 INT32, field_32_012 UINT16, field_33_0123 DATETIME, field_34_01234 REAL ARRAY, field_35_012345 INT16, field_36_0123456 UINT32 ARRAY, field_37_01234567 DATETIME, field_38_012345678 CHAR, field_39_0123456789 HIRESTIME, field_40_0 HIRESTIME, field_41_01 INT64, field_42_012 INT8, field_43_0123 RICHREAL ARRAY, field_44_01234 CHAR, field_45_012345 DATE, field_46_0123456 INT32, field_47_01234567 UINT32, field_48_012345678 RICHREAL, field_49_0123456789 INT8, field_50_0 RICHREAL ARRAY, field_51_01 CHAR, field_52_012 CHAR ARRAY, field_53_0123 HIRESTIME, field_54_01234 UINT16, field_55_012345 INT16, field_56_0123456 INT16, field_57_01234567 UINT32, field_58_012345678 INT8, field_59_0123456789 UINT16 ARRAY)");
      /* 557 */ glbTypes.push_back("TABLE(field_1_01 DATE ARRAY, field_2_012 REAL, field_3_0123 INT32, field_4_01234 UINT64 ARRAY, field_5_012345 INT64 ARRAY, field_6_0123456 INT8 ARRAY, field_7_01234567 BOOL, field_8_012345678 BOOL, field_9_0123456789 BOOL, field_10_0 INT64, field_11_01 INT8 ARRAY, field_12_012 UINT8, field_13_0123 RICHREAL, field_14_01234 DATE, field_15_012345 HIRESTIME ARRAY, field_16_0123456 DATETIME, field_17_01234567 DATETIME)");
      /* 558 */ glbTypes.push_back("TABLE(field_1_01 INT32 ARRAY, field_2_012 INT32, field_3_0123 UINT16, field_4_01234 INT64, field_5_012345 INT8, field_6_0123456 UINT16 ARRAY, field_7_01234567 DATE, field_8_012345678 DATE, field_9_0123456789 HIRESTIME, field_10_0 CHAR, field_11_01 UINT8, field_12_012 HIRESTIME, field_13_0123 UINT32, field_14_01234 INT8, field_15_012345 UINT64, field_16_0123456 HIRESTIME ARRAY, field_17_01234567 HIRESTIME ARRAY, field_18_012345678 INT64, field_19_0123456789 BOOL, field_20_0 UINT32, field_21_01 INT8, field_22_012 INT64, field_23_0123 UINT16, field_24_01234 INT64 ARRAY, field_25_012345 UINT8, field_26_0123456 REAL ARRAY, field_27_01234567 REAL, field_28_012345678 DATETIME, field_29_0123456789 INT16, field_30_0 UINT32 ARRAY, field_31_01 CHAR, field_32_012 INT16, field_33_0123 UINT8, field_34_01234 INT8, field_35_012345 DATE, field_36_0123456 UINT16, field_37_01234567 DATETIME, field_38_012345678 DATE, field_39_0123456789 BOOL, field_40_0 UINT32, field_41_01 INT32, field_42_012 UINT16 ARRAY, field_43_0123 UINT64 ARRAY, field_44_01234 DATE, field_45_012345 DATETIME, field_46_0123456 RICHREAL ARRAY, field_47_01234567 CHAR, field_48_012345678 CHAR, field_49_0123456789 BOOL, field_50_0 INT64, field_51_01 UINT8, field_52_012 CHAR, field_53_0123 INT16, field_54_01234 RICHREAL, field_55_012345 INT16, field_56_0123456 UINT8, field_57_01234567 INT16, field_58_012345678 INT16, field_59_0123456789 REAL, field_60_0 UINT16, field_61_01 INT64, field_62_012 UINT32, field_63_0123 INT16, field_64_01234 RICHREAL, field_65_012345 UINT8, field_66_0123456 DATETIME, field_67_01234567 INT8, field_68_012345678 RICHREAL, field_69_0123456789 INT8, field_70_0 RICHREAL, field_71_01 INT64, field_72_012 CHAR, field_73_0123 CHAR ARRAY, field_74_01234 INT32, field_75_012345 BOOL, field_76_0123456 INT8, field_77_01234567 INT64 ARRAY, field_78_012345678 UINT32 ARRAY)");
      /* 559 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 INT8, field_3_0123 INT64, field_4_01234 CHAR, field_5_012345 CHAR, field_6_0123456 CHAR, field_7_01234567 REAL, field_8_012345678 DATETIME, field_9_0123456789 RICHREAL ARRAY, field_10_0 BOOL, field_11_01 RICHREAL, field_12_012 HIRESTIME, field_13_0123 INT64, field_14_01234 UINT8, field_15_012345 INT32, field_16_0123456 CHAR ARRAY, field_17_01234567 INT8 ARRAY, field_18_012345678 DATETIME, field_19_0123456789 UINT8, field_20_0 INT32, field_21_01 REAL)");
      /* 560 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 BOOL, field_3_0123 INT32 ARRAY, field_4_01234 DATETIME ARRAY, field_5_012345 DATE, field_6_0123456 DATETIME, field_7_01234567 UINT8, field_8_012345678 DATE, field_9_0123456789 HIRESTIME, field_10_0 INT64 ARRAY, field_11_01 INT64, field_12_012 HIRESTIME, field_13_0123 DATE, field_14_01234 INT16, field_15_012345 DATE, field_16_0123456 CHAR ARRAY, field_17_01234567 BOOL, field_18_012345678 INT32, field_19_0123456789 UINT8, field_20_0 INT64, field_21_01 INT32, field_22_012 INT16, field_23_0123 DATE, field_24_01234 INT64, field_25_012345 UINT8, field_26_0123456 INT64, field_27_01234567 UINT32, field_28_012345678 BOOL, field_29_0123456789 UINT32, field_30_0 RICHREAL, field_31_01 DATETIME, field_32_012 UINT64, field_33_0123 INT64, field_34_01234 DATETIME, field_35_012345 UINT32, field_36_0123456 DATETIME, field_37_01234567 INT32)");
      /* 561 */ glbTypes.push_back("TABLE(field_1_01 UINT8 ARRAY, field_2_012 DATE, field_3_0123 UINT16, field_4_01234 DATETIME, field_5_012345 BOOL, field_6_0123456 UINT64, field_7_01234567 CHAR)");
      /* 562 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL ARRAY, field_2_012 UINT32 ARRAY, field_3_0123 BOOL, field_4_01234 INT64 ARRAY, field_5_012345 UINT16, field_6_0123456 CHAR, field_7_01234567 DATETIME, field_8_012345678 UINT8, field_9_0123456789 DATE, field_10_0 REAL ARRAY, field_11_01 BOOL, field_12_012 INT32, field_13_0123 REAL, field_14_01234 INT64, field_15_012345 INT8, field_16_0123456 CHAR, field_17_01234567 UINT64 ARRAY, field_18_012345678 UINT64, field_19_0123456789 INT32, field_20_0 INT8, field_21_01 RICHREAL ARRAY, field_22_012 UINT8, field_23_0123 UINT32 ARRAY)");
      /* 563 */ glbTypes.push_back("TABLE");
      /* 564 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 DATETIME, field_3_0123 REAL, field_4_01234 REAL, field_5_012345 CHAR, field_6_0123456 UINT16, field_7_01234567 REAL, field_8_012345678 UINT16, field_9_0123456789 CHAR, field_10_0 INT8, field_11_01 INT32, field_12_012 REAL, field_13_0123 INT8, field_14_01234 DATETIME, field_15_012345 INT32, field_16_0123456 DATETIME ARRAY, field_17_01234567 DATE ARRAY, field_18_012345678 DATETIME ARRAY, field_19_0123456789 CHAR, field_20_0 REAL, field_21_01 CHAR, field_22_012 INT8 ARRAY, field_23_0123 CHAR, field_24_01234 CHAR, field_25_012345 UINT8, field_26_0123456 UINT64, field_27_01234567 RICHREAL, field_28_012345678 UINT32 ARRAY, field_29_0123456789 INT64, field_30_0 INT32, field_31_01 UINT8 ARRAY, field_32_012 DATE, field_33_0123 INT16, field_34_01234 UINT64, field_35_012345 DATE, field_36_0123456 RICHREAL, field_37_01234567 RICHREAL, field_38_012345678 HIRESTIME ARRAY, field_39_0123456789 UINT64, field_40_0 UINT64, field_41_01 UINT8 ARRAY, field_42_012 UINT32, field_43_0123 INT8, field_44_01234 REAL, field_45_012345 CHAR, field_46_0123456 DATETIME, field_47_01234567 INT8, field_48_012345678 CHAR, field_49_0123456789 RICHREAL, field_50_0 INT16, field_51_01 UINT16, field_52_012 UINT8 ARRAY, field_53_0123 HIRESTIME, field_54_01234 INT16, field_55_012345 UINT8 ARRAY, field_56_0123456 INT16)");
      /* 565 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 INT32, field_3_0123 INT8, field_4_01234 REAL, field_5_012345 HIRESTIME, field_6_0123456 UINT64 ARRAY, field_7_01234567 DATE, field_8_012345678 INT64, field_9_0123456789 UINT64 ARRAY, field_10_0 DATE)");
      /* 566 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 INT32, field_3_0123 REAL, field_4_01234 UINT8 ARRAY, field_5_012345 UINT32, field_6_0123456 INT8, field_7_01234567 INT64, field_8_012345678 UINT8, field_9_0123456789 UINT64, field_10_0 CHAR, field_11_01 RICHREAL, field_12_012 INT8, field_13_0123 INT64, field_14_01234 INT64, field_15_012345 CHAR, field_16_0123456 REAL ARRAY, field_17_01234567 INT64, field_18_012345678 INT32, field_19_0123456789 HIRESTIME, field_20_0 BOOL, field_21_01 INT64, field_22_012 INT64 ARRAY, field_23_0123 UINT64, field_24_01234 DATE, field_25_012345 INT64, field_26_0123456 INT32 ARRAY, field_27_01234567 INT32, field_28_012345678 UINT32, field_29_0123456789 HIRESTIME, field_30_0 DATETIME, field_31_01 DATE ARRAY, field_32_012 DATETIME, field_33_0123 CHAR, field_34_01234 INT8, field_35_012345 BOOL, field_36_0123456 BOOL, field_37_01234567 UINT16, field_38_012345678 UINT8 ARRAY, field_39_0123456789 DATETIME, field_40_0 HIRESTIME ARRAY, field_41_01 BOOL, field_42_012 UINT8, field_43_0123 CHAR ARRAY, field_44_01234 INT64)");
      /* 567 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 INT64, field_3_0123 UINT64, field_4_01234 BOOL, field_5_012345 UINT8, field_6_0123456 INT32, field_7_01234567 INT32 ARRAY, field_8_012345678 INT8, field_9_0123456789 REAL, field_10_0 INT8, field_11_01 RICHREAL ARRAY, field_12_012 INT64, field_13_0123 BOOL, field_14_01234 REAL, field_15_012345 INT64, field_16_0123456 UINT8, field_17_01234567 UINT8 ARRAY, field_18_012345678 DATETIME, field_19_0123456789 UINT8, field_20_0 CHAR ARRAY, field_21_01 CHAR, field_22_012 BOOL, field_23_0123 INT64, field_24_01234 DATETIME, field_25_012345 UINT8, field_26_0123456 HIRESTIME, field_27_01234567 UINT32, field_28_012345678 INT16, field_29_0123456789 INT8, field_30_0 INT64, field_31_01 REAL, field_32_012 RICHREAL ARRAY, field_33_0123 RICHREAL, field_34_01234 UINT16 ARRAY, field_35_012345 UINT16, field_36_0123456 INT64, field_37_01234567 DATETIME, field_38_012345678 UINT64 ARRAY, field_39_0123456789 HIRESTIME, field_40_0 INT8, field_41_01 REAL, field_42_012 UINT64, field_43_0123 REAL, field_44_01234 REAL, field_45_012345 UINT8, field_46_0123456 DATETIME, field_47_01234567 INT16, field_48_012345678 DATE, field_49_0123456789 REAL, field_50_0 DATE, field_51_01 INT16, field_52_012 INT64, field_53_0123 BOOL, field_54_01234 REAL, field_55_012345 BOOL, field_56_0123456 DATETIME, field_57_01234567 UINT8, field_58_012345678 UINT16, field_59_0123456789 REAL, field_60_0 UINT8, field_61_01 INT8 ARRAY, field_62_012 DATETIME ARRAY, field_63_0123 UINT64, field_64_01234 DATETIME, field_65_012345 UINT32, field_66_0123456 RICHREAL, field_67_01234567 DATETIME ARRAY, field_68_012345678 UINT32, field_69_0123456789 BOOL, field_70_0 UINT8 ARRAY, field_71_01 DATE ARRAY, field_72_012 UINT16, field_73_0123 INT16 ARRAY, field_74_01234 DATE, field_75_012345 UINT32, field_76_0123456 INT64, field_77_01234567 REAL, field_78_012345678 RICHREAL, field_79_0123456789 DATE, field_80_0 INT8 ARRAY, field_81_01 UINT64, field_82_012 RICHREAL, field_83_0123 REAL, field_84_01234 INT64, field_85_012345 RICHREAL, field_86_0123456 INT64, field_87_01234567 UINT16)");
      /* 568 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 DATE, field_3_0123 HIRESTIME, field_4_01234 INT8, field_5_012345 RICHREAL ARRAY, field_6_0123456 CHAR, field_7_01234567 DATE, field_8_012345678 HIRESTIME, field_9_0123456789 DATE, field_10_0 INT8, field_11_01 RICHREAL, field_12_012 INT16, field_13_0123 INT32 ARRAY, field_14_01234 REAL, field_15_012345 DATE ARRAY, field_16_0123456 UINT16, field_17_01234567 CHAR, field_18_012345678 UINT32, field_19_0123456789 UINT64, field_20_0 UINT8, field_21_01 UINT32, field_22_012 INT8, field_23_0123 INT32, field_24_01234 INT8, field_25_012345 UINT64, field_26_0123456 CHAR, field_27_01234567 BOOL, field_28_012345678 REAL, field_29_0123456789 UINT32, field_30_0 DATE, field_31_01 RICHREAL, field_32_012 INT32, field_33_0123 UINT64, field_34_01234 INT32, field_35_012345 BOOL, field_36_0123456 BOOL, field_37_01234567 UINT32, field_38_012345678 REAL, field_39_0123456789 DATE, field_40_0 INT8, field_41_01 UINT16, field_42_012 UINT64, field_43_0123 INT8 ARRAY, field_44_01234 REAL ARRAY, field_45_012345 UINT8, field_46_0123456 UINT16, field_47_01234567 BOOL, field_48_012345678 BOOL, field_49_0123456789 UINT16, field_50_0 REAL ARRAY, field_51_01 DATE, field_52_012 REAL, field_53_0123 UINT64, field_54_01234 INT16, field_55_012345 UINT32 ARRAY, field_56_0123456 UINT32, field_57_01234567 INT64 ARRAY, field_58_012345678 DATETIME ARRAY, field_59_0123456789 INT64, field_60_0 DATETIME, field_61_01 CHAR, field_62_012 BOOL, field_63_0123 REAL, field_64_01234 UINT8 ARRAY, field_65_012345 INT64, field_66_0123456 DATETIME ARRAY, field_67_01234567 DATETIME, field_68_012345678 INT8, field_69_0123456789 DATETIME, field_70_0 INT32, field_71_01 DATETIME)");
      /* 569 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 UINT8, field_3_0123 DATETIME, field_4_01234 HIRESTIME, field_5_012345 INT16, field_6_0123456 INT64, field_7_01234567 HIRESTIME ARRAY, field_8_012345678 REAL, field_9_0123456789 REAL, field_10_0 BOOL, field_11_01 CHAR, field_12_012 UINT16, field_13_0123 DATE, field_14_01234 UINT32 ARRAY, field_15_012345 INT64, field_16_0123456 UINT8)");
      /* 570 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME ARRAY, field_2_012 UINT8 ARRAY, field_3_0123 RICHREAL, field_4_01234 INT64 ARRAY, field_5_012345 INT64, field_6_0123456 INT32, field_7_01234567 RICHREAL, field_8_012345678 HIRESTIME, field_9_0123456789 UINT16, field_10_0 CHAR, field_11_01 HIRESTIME, field_12_012 UINT64, field_13_0123 HIRESTIME, field_14_01234 INT8, field_15_012345 INT8, field_16_0123456 CHAR, field_17_01234567 UINT64 ARRAY, field_18_012345678 DATETIME, field_19_0123456789 INT64, field_20_0 BOOL ARRAY, field_21_01 INT16 ARRAY, field_22_012 INT8, field_23_0123 INT16, field_24_01234 UINT16 ARRAY, field_25_012345 HIRESTIME, field_26_0123456 INT32, field_27_01234567 INT8, field_28_012345678 UINT8 ARRAY, field_29_0123456789 DATE, field_30_0 INT64, field_31_01 DATETIME, field_32_012 DATE, field_33_0123 BOOL, field_34_01234 UINT64 ARRAY, field_35_012345 RICHREAL ARRAY, field_36_0123456 CHAR, field_37_01234567 UINT32, field_38_012345678 UINT8 ARRAY, field_39_0123456789 INT64, field_40_0 RICHREAL, field_41_01 UINT64, field_42_012 CHAR, field_43_0123 INT64, field_44_01234 INT64, field_45_012345 UINT16, field_46_0123456 RICHREAL, field_47_01234567 CHAR, field_48_012345678 UINT32, field_49_0123456789 RICHREAL, field_50_0 INT16, field_51_01 INT16, field_52_012 UINT64)");
      /* 571 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 UINT8 ARRAY, field_3_0123 REAL ARRAY, field_4_01234 REAL, field_5_012345 UINT8, field_6_0123456 REAL, field_7_01234567 INT64, field_8_012345678 CHAR ARRAY, field_9_0123456789 INT64, field_10_0 DATE, field_11_01 DATE, field_12_012 CHAR, field_13_0123 INT64, field_14_01234 UINT8, field_15_012345 CHAR, field_16_0123456 INT16, field_17_01234567 INT32, field_18_012345678 BOOL, field_19_0123456789 UINT8, field_20_0 UINT8, field_21_01 DATE, field_22_012 RICHREAL, field_23_0123 INT8, field_24_01234 DATETIME, field_25_012345 DATETIME, field_26_0123456 BOOL, field_27_01234567 RICHREAL, field_28_012345678 BOOL, field_29_0123456789 REAL, field_30_0 CHAR, field_31_01 INT8, field_32_012 DATE, field_33_0123 INT64, field_34_01234 INT64, field_35_012345 INT8, field_36_0123456 INT16, field_37_01234567 INT32, field_38_012345678 UINT8, field_39_0123456789 UINT32, field_40_0 REAL ARRAY, field_41_01 DATE, field_42_012 REAL, field_43_0123 HIRESTIME, field_44_01234 RICHREAL, field_45_012345 INT16, field_46_0123456 INT8 ARRAY, field_47_01234567 INT64, field_48_012345678 CHAR, field_49_0123456789 UINT8, field_50_0 BOOL, field_51_01 UINT16, field_52_012 INT32, field_53_0123 RICHREAL, field_54_01234 CHAR, field_55_012345 UINT32, field_56_0123456 UINT8, field_57_01234567 RICHREAL, field_58_012345678 BOOL, field_59_0123456789 CHAR ARRAY, field_60_0 UINT8 ARRAY, field_61_01 BOOL, field_62_012 CHAR, field_63_0123 UINT64, field_64_01234 HIRESTIME, field_65_012345 UINT8, field_66_0123456 UINT8, field_67_01234567 INT64 ARRAY, field_68_012345678 DATETIME ARRAY, field_69_0123456789 INT64 ARRAY, field_70_0 UINT16, field_71_01 UINT64 ARRAY, field_72_012 CHAR ARRAY, field_73_0123 REAL, field_74_01234 DATETIME ARRAY, field_75_012345 INT32, field_76_0123456 CHAR, field_77_01234567 HIRESTIME, field_78_012345678 UINT32, field_79_0123456789 UINT8 ARRAY)");
      /* 572 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 BOOL, field_3_0123 RICHREAL, field_4_01234 INT8, field_5_012345 INT32, field_6_0123456 HIRESTIME, field_7_01234567 RICHREAL, field_8_012345678 CHAR, field_9_0123456789 UINT8, field_10_0 DATE, field_11_01 CHAR, field_12_012 INT64, field_13_0123 INT32, field_14_01234 BOOL ARRAY, field_15_012345 BOOL, field_16_0123456 DATETIME ARRAY, field_17_01234567 REAL ARRAY, field_18_012345678 HIRESTIME, field_19_0123456789 DATETIME ARRAY, field_20_0 INT32 ARRAY, field_21_01 INT8 ARRAY, field_22_012 BOOL, field_23_0123 RICHREAL, field_24_01234 INT16 ARRAY, field_25_012345 CHAR, field_26_0123456 UINT8, field_27_01234567 UINT32, field_28_012345678 DATETIME, field_29_0123456789 INT32, field_30_0 INT64 ARRAY, field_31_01 CHAR, field_32_012 REAL ARRAY, field_33_0123 CHAR, field_34_01234 INT16 ARRAY, field_35_012345 UINT8, field_36_0123456 DATE ARRAY, field_37_01234567 INT16 ARRAY, field_38_012345678 UINT16, field_39_0123456789 INT32, field_40_0 INT32, field_41_01 HIRESTIME, field_42_012 CHAR, field_43_0123 INT64, field_44_01234 CHAR, field_45_012345 INT64, field_46_0123456 DATE, field_47_01234567 INT16)");
      /* 573 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 INT16, field_3_0123 RICHREAL, field_4_01234 BOOL, field_5_012345 INT64, field_6_0123456 UINT32, field_7_01234567 UINT32, field_8_012345678 UINT16 ARRAY, field_9_0123456789 UINT16 ARRAY, field_10_0 CHAR, field_11_01 UINT64, field_12_012 INT8, field_13_0123 BOOL ARRAY, field_14_01234 HIRESTIME, field_15_012345 INT16, field_16_0123456 UINT32, field_17_01234567 INT8 ARRAY, field_18_012345678 INT32, field_19_0123456789 BOOL, field_20_0 HIRESTIME, field_21_01 BOOL, field_22_012 BOOL, field_23_0123 CHAR ARRAY, field_24_01234 UINT64, field_25_012345 HIRESTIME ARRAY, field_26_0123456 UINT8 ARRAY, field_27_01234567 UINT64, field_28_012345678 DATETIME ARRAY, field_29_0123456789 DATE, field_30_0 UINT16, field_31_01 INT64 ARRAY, field_32_012 CHAR, field_33_0123 CHAR, field_34_01234 REAL, field_35_012345 DATETIME, field_36_0123456 BOOL ARRAY, field_37_01234567 HIRESTIME, field_38_012345678 UINT64 ARRAY, field_39_0123456789 UINT16 ARRAY, field_40_0 HIRESTIME, field_41_01 UINT8 ARRAY, field_42_012 DATE, field_43_0123 DATETIME, field_44_01234 INT8 ARRAY, field_45_012345 INT32, field_46_0123456 INT32 ARRAY, field_47_01234567 INT8, field_48_012345678 RICHREAL, field_49_0123456789 UINT16, field_50_0 UINT32, field_51_01 REAL, field_52_012 DATE, field_53_0123 UINT8 ARRAY, field_54_01234 INT32, field_55_012345 UINT64, field_56_0123456 HIRESTIME ARRAY, field_57_01234567 INT64, field_58_012345678 HIRESTIME, field_59_0123456789 DATETIME, field_60_0 UINT16, field_61_01 RICHREAL, field_62_012 UINT8, field_63_0123 HIRESTIME, field_64_01234 INT32, field_65_012345 HIRESTIME, field_66_0123456 INT16, field_67_01234567 UINT32, field_68_012345678 BOOL, field_69_0123456789 INT8, field_70_0 INT32, field_71_01 UINT16, field_72_012 UINT32 ARRAY, field_73_0123 UINT32, field_74_01234 RICHREAL ARRAY, field_75_012345 UINT32, field_76_0123456 REAL, field_77_01234567 UINT16, field_78_012345678 UINT16, field_79_0123456789 HIRESTIME, field_80_0 DATETIME, field_81_01 DATE, field_82_012 RICHREAL, field_83_0123 INT64, field_84_01234 HIRESTIME, field_85_012345 INT16 ARRAY, field_86_0123456 UINT16 ARRAY, field_87_01234567 UINT32, field_88_012345678 UINT64, field_89_0123456789 DATE, field_90_0 REAL ARRAY, field_91_01 BOOL, field_92_012 HIRESTIME ARRAY, field_93_0123 CHAR)");
      /* 574 */ glbTypes.push_back("TABLE(field_1_01 DATETIME ARRAY, field_2_012 CHAR, field_3_0123 REAL, field_4_01234 UINT8, field_5_012345 INT64 ARRAY, field_6_0123456 RICHREAL, field_7_01234567 UINT32, field_8_012345678 UINT8, field_9_0123456789 CHAR, field_10_0 CHAR, field_11_01 UINT8 ARRAY, field_12_012 RICHREAL ARRAY, field_13_0123 CHAR ARRAY, field_14_01234 INT64, field_15_012345 UINT16 ARRAY, field_16_0123456 DATE, field_17_01234567 DATE, field_18_012345678 INT8, field_19_0123456789 UINT64, field_20_0 DATETIME ARRAY, field_21_01 UINT64, field_22_012 UINT32, field_23_0123 INT16, field_24_01234 CHAR, field_25_012345 INT32, field_26_0123456 INT64 ARRAY)");
      /* 575 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 UINT64, field_3_0123 INT64, field_4_01234 HIRESTIME, field_5_012345 UINT64 ARRAY, field_6_0123456 REAL ARRAY, field_7_01234567 INT8, field_8_012345678 CHAR, field_9_0123456789 INT64 ARRAY, field_10_0 UINT32, field_11_01 HIRESTIME, field_12_012 DATETIME, field_13_0123 INT64, field_14_01234 INT8, field_15_012345 CHAR, field_16_0123456 HIRESTIME, field_17_01234567 HIRESTIME ARRAY, field_18_012345678 INT32, field_19_0123456789 INT16, field_20_0 BOOL, field_21_01 INT8, field_22_012 UINT32 ARRAY, field_23_0123 BOOL, field_24_01234 INT64, field_25_012345 HIRESTIME, field_26_0123456 UINT16, field_27_01234567 INT64, field_28_012345678 HIRESTIME, field_29_0123456789 INT16, field_30_0 INT16, field_31_01 UINT8, field_32_012 DATE ARRAY, field_33_0123 INT16 ARRAY, field_34_01234 UINT8, field_35_012345 DATETIME, field_36_0123456 HIRESTIME, field_37_01234567 INT64, field_38_012345678 CHAR, field_39_0123456789 INT32, field_40_0 DATETIME, field_41_01 UINT8, field_42_012 DATE ARRAY, field_43_0123 RICHREAL ARRAY, field_44_01234 BOOL, field_45_012345 RICHREAL, field_46_0123456 DATE, field_47_01234567 BOOL, field_48_012345678 UINT64, field_49_0123456789 CHAR, field_50_0 INT32, field_51_01 INT16, field_52_012 DATE, field_53_0123 HIRESTIME, field_54_01234 REAL, field_55_012345 INT32, field_56_0123456 INT8 ARRAY, field_57_01234567 UINT8, field_58_012345678 DATETIME, field_59_0123456789 UINT16 ARRAY, field_60_0 DATE, field_61_01 DATE, field_62_012 BOOL, field_63_0123 BOOL, field_64_01234 INT16 ARRAY, field_65_012345 DATE ARRAY, field_66_0123456 INT64, field_67_01234567 CHAR, field_68_012345678 DATE, field_69_0123456789 CHAR, field_70_0 DATETIME, field_71_01 INT8, field_72_012 INT64, field_73_0123 INT64, field_74_01234 UINT8, field_75_012345 INT32)");
      /* 576 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 CHAR, field_3_0123 REAL ARRAY, field_4_01234 INT32, field_5_012345 BOOL, field_6_0123456 RICHREAL, field_7_01234567 INT32 ARRAY, field_8_012345678 INT32, field_9_0123456789 CHAR ARRAY, field_10_0 INT32, field_11_01 HIRESTIME, field_12_012 CHAR, field_13_0123 HIRESTIME, field_14_01234 RICHREAL, field_15_012345 DATE, field_16_0123456 INT16, field_17_01234567 INT8, field_18_012345678 UINT32, field_19_0123456789 INT32, field_20_0 DATETIME, field_21_01 UINT32, field_22_012 CHAR, field_23_0123 CHAR, field_24_01234 DATETIME, field_25_012345 INT64, field_26_0123456 HIRESTIME, field_27_01234567 UINT32, field_28_012345678 HIRESTIME ARRAY)");
      /* 577 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 REAL, field_3_0123 UINT16 ARRAY, field_4_01234 DATETIME, field_5_012345 INT8, field_6_0123456 CHAR ARRAY, field_7_01234567 UINT16, field_8_012345678 UINT16, field_9_0123456789 DATETIME, field_10_0 REAL, field_11_01 BOOL, field_12_012 DATE, field_13_0123 UINT32, field_14_01234 INT64, field_15_012345 REAL, field_16_0123456 CHAR, field_17_01234567 INT16, field_18_012345678 DATETIME ARRAY, field_19_0123456789 BOOL, field_20_0 BOOL, field_21_01 DATE, field_22_012 UINT32, field_23_0123 UINT64, field_24_01234 INT16, field_25_012345 UINT64, field_26_0123456 INT8, field_27_01234567 INT8, field_28_012345678 INT16, field_29_0123456789 UINT32, field_30_0 REAL, field_31_01 HIRESTIME, field_32_012 UINT16 ARRAY, field_33_0123 UINT32 ARRAY, field_34_01234 REAL, field_35_012345 UINT32, field_36_0123456 REAL, field_37_01234567 INT64, field_38_012345678 UINT16, field_39_0123456789 INT64, field_40_0 INT8, field_41_01 UINT32, field_42_012 UINT16, field_43_0123 INT16, field_44_01234 CHAR, field_45_012345 INT64, field_46_0123456 UINT16, field_47_01234567 INT8, field_48_012345678 INT8, field_49_0123456789 HIRESTIME, field_50_0 UINT32, field_51_01 INT32 ARRAY, field_52_012 UINT16, field_53_0123 INT32 ARRAY)");
      /* 578 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 UINT8, field_3_0123 DATETIME ARRAY, field_4_01234 BOOL ARRAY, field_5_012345 INT64, field_6_0123456 INT32, field_7_01234567 UINT64, field_8_012345678 DATE ARRAY, field_9_0123456789 UINT64 ARRAY, field_10_0 UINT8, field_11_01 CHAR ARRAY, field_12_012 DATE, field_13_0123 INT16 ARRAY, field_14_01234 INT64, field_15_012345 REAL ARRAY, field_16_0123456 REAL, field_17_01234567 INT8, field_18_012345678 HIRESTIME, field_19_0123456789 REAL, field_20_0 HIRESTIME, field_21_01 INT8, field_22_012 UINT32, field_23_0123 UINT8, field_24_01234 DATETIME, field_25_012345 REAL, field_26_0123456 CHAR, field_27_01234567 UINT64, field_28_012345678 UINT64, field_29_0123456789 CHAR ARRAY, field_30_0 REAL, field_31_01 REAL, field_32_012 UINT16, field_33_0123 HIRESTIME, field_34_01234 REAL, field_35_012345 CHAR ARRAY, field_36_0123456 INT32, field_37_01234567 DATE, field_38_012345678 REAL, field_39_0123456789 INT8, field_40_0 INT16, field_41_01 RICHREAL, field_42_012 HIRESTIME, field_43_0123 INT8, field_44_01234 INT16, field_45_012345 DATETIME ARRAY, field_46_0123456 UINT8, field_47_01234567 INT16)");
      /* 579 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 DATETIME, field_3_0123 CHAR ARRAY, field_4_01234 BOOL, field_5_012345 INT64, field_6_0123456 DATE, field_7_01234567 UINT16, field_8_012345678 INT8, field_9_0123456789 CHAR, field_10_0 BOOL)");
      /* 580 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 DATE, field_3_0123 DATETIME, field_4_01234 UINT32, field_5_012345 UINT64, field_6_0123456 UINT8 ARRAY, field_7_01234567 REAL, field_8_012345678 INT64 ARRAY, field_9_0123456789 UINT64, field_10_0 INT16, field_11_01 RICHREAL ARRAY, field_12_012 DATETIME ARRAY, field_13_0123 UINT8 ARRAY, field_14_01234 BOOL ARRAY, field_15_012345 CHAR, field_16_0123456 HIRESTIME, field_17_01234567 INT64 ARRAY, field_18_012345678 DATE, field_19_0123456789 DATETIME, field_20_0 INT32, field_21_01 INT16, field_22_012 HIRESTIME, field_23_0123 CHAR, field_24_01234 HIRESTIME, field_25_012345 INT64 ARRAY, field_26_0123456 UINT8 ARRAY, field_27_01234567 CHAR, field_28_012345678 UINT8, field_29_0123456789 BOOL ARRAY, field_30_0 CHAR, field_31_01 INT64, field_32_012 UINT16, field_33_0123 BOOL, field_34_01234 UINT32, field_35_012345 REAL, field_36_0123456 INT8, field_37_01234567 HIRESTIME, field_38_012345678 UINT8, field_39_0123456789 UINT64 ARRAY, field_40_0 DATETIME, field_41_01 RICHREAL ARRAY, field_42_012 REAL, field_43_0123 CHAR ARRAY, field_44_01234 BOOL ARRAY, field_45_012345 UINT64 ARRAY, field_46_0123456 INT32, field_47_01234567 BOOL ARRAY, field_48_012345678 CHAR, field_49_0123456789 UINT32, field_50_0 CHAR, field_51_01 BOOL, field_52_012 UINT16, field_53_0123 INT32, field_54_01234 REAL, field_55_012345 DATE ARRAY, field_56_0123456 INT64 ARRAY, field_57_01234567 BOOL ARRAY, field_58_012345678 DATE, field_59_0123456789 UINT8, field_60_0 INT32, field_61_01 INT16 ARRAY, field_62_012 CHAR, field_63_0123 DATE, field_64_01234 DATE ARRAY, field_65_012345 DATE, field_66_0123456 DATE, field_67_01234567 DATETIME)");
      /* 581 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 UINT64, field_3_0123 DATETIME, field_4_01234 UINT8)");
      /* 582 */ glbTypes.push_back("TABLE(field_1_01 CHAR ARRAY, field_2_012 INT32, field_3_0123 HIRESTIME ARRAY, field_4_01234 DATE ARRAY)");
      /* 583 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 INT16, field_3_0123 BOOL, field_4_01234 UINT32, field_5_012345 UINT64, field_6_0123456 DATETIME ARRAY, field_7_01234567 INT16, field_8_012345678 RICHREAL, field_9_0123456789 CHAR, field_10_0 BOOL, field_11_01 RICHREAL, field_12_012 BOOL, field_13_0123 DATE, field_14_01234 DATE ARRAY, field_15_012345 DATE, field_16_0123456 UINT32, field_17_01234567 INT16 ARRAY, field_18_012345678 UINT8, field_19_0123456789 DATETIME, field_20_0 INT16, field_21_01 INT16, field_22_012 REAL ARRAY, field_23_0123 DATETIME, field_24_01234 UINT64, field_25_012345 INT16, field_26_0123456 UINT32 ARRAY, field_27_01234567 INT16, field_28_012345678 REAL, field_29_0123456789 INT64, field_30_0 INT64, field_31_01 REAL, field_32_012 REAL, field_33_0123 CHAR ARRAY, field_34_01234 UINT64, field_35_012345 INT32, field_36_0123456 INT16, field_37_01234567 UINT32, field_38_012345678 RICHREAL ARRAY, field_39_0123456789 RICHREAL, field_40_0 UINT32 ARRAY, field_41_01 INT64, field_42_012 CHAR, field_43_0123 RICHREAL, field_44_01234 DATE, field_45_012345 UINT32, field_46_0123456 UINT64, field_47_01234567 INT8, field_48_012345678 DATETIME, field_49_0123456789 CHAR ARRAY, field_50_0 BOOL, field_51_01 HIRESTIME)");
      /* 584 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 RICHREAL, field_3_0123 UINT32, field_4_01234 INT32, field_5_012345 BOOL ARRAY, field_6_0123456 INT16, field_7_01234567 RICHREAL ARRAY, field_8_012345678 BOOL, field_9_0123456789 UINT8, field_10_0 HIRESTIME, field_11_01 UINT16, field_12_012 DATETIME ARRAY, field_13_0123 INT64, field_14_01234 UINT8, field_15_012345 INT64, field_16_0123456 RICHREAL, field_17_01234567 RICHREAL, field_18_012345678 UINT8, field_19_0123456789 DATETIME, field_20_0 REAL, field_21_01 INT64, field_22_012 INT8, field_23_0123 UINT64 ARRAY, field_24_01234 DATE, field_25_012345 DATETIME, field_26_0123456 RICHREAL, field_27_01234567 UINT8 ARRAY, field_28_012345678 DATETIME, field_29_0123456789 UINT32, field_30_0 RICHREAL, field_31_01 DATETIME ARRAY, field_32_012 INT32, field_33_0123 INT32 ARRAY, field_34_01234 BOOL, field_35_012345 RICHREAL, field_36_0123456 DATETIME, field_37_01234567 CHAR, field_38_012345678 INT8, field_39_0123456789 INT16 ARRAY, field_40_0 INT8, field_41_01 INT16, field_42_012 HIRESTIME, field_43_0123 RICHREAL, field_44_01234 INT16, field_45_012345 CHAR ARRAY, field_46_0123456 INT8, field_47_01234567 INT8, field_48_012345678 DATETIME ARRAY, field_49_0123456789 CHAR ARRAY, field_50_0 UINT32, field_51_01 DATE, field_52_012 UINT64, field_53_0123 UINT32, field_54_01234 UINT64, field_55_012345 HIRESTIME, field_56_0123456 UINT32 ARRAY, field_57_01234567 RICHREAL, field_58_012345678 DATE, field_59_0123456789 INT32, field_60_0 INT32, field_61_01 UINT64, field_62_012 CHAR, field_63_0123 RICHREAL ARRAY, field_64_01234 CHAR, field_65_012345 UINT16, field_66_0123456 INT32, field_67_01234567 BOOL, field_68_012345678 BOOL, field_69_0123456789 INT16 ARRAY, field_70_0 DATETIME, field_71_01 INT8, field_72_012 DATE, field_73_0123 HIRESTIME, field_74_01234 UINT8, field_75_012345 UINT8, field_76_0123456 UINT8, field_77_01234567 REAL, field_78_012345678 UINT64, field_79_0123456789 UINT32, field_80_0 DATETIME, field_81_01 DATETIME, field_82_012 CHAR, field_83_0123 HIRESTIME, field_84_01234 INT8, field_85_012345 RICHREAL ARRAY)");
      /* 585 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 RICHREAL ARRAY, field_3_0123 UINT64, field_4_01234 CHAR, field_5_012345 INT16, field_6_0123456 UINT16 ARRAY, field_7_01234567 DATE ARRAY, field_8_012345678 DATETIME, field_9_0123456789 INT8 ARRAY, field_10_0 HIRESTIME, field_11_01 CHAR, field_12_012 INT32, field_13_0123 INT64, field_14_01234 INT32, field_15_012345 UINT64, field_16_0123456 CHAR, field_17_01234567 CHAR, field_18_012345678 CHAR, field_19_0123456789 HIRESTIME, field_20_0 DATETIME, field_21_01 CHAR, field_22_012 INT16, field_23_0123 UINT8, field_24_01234 INT32 ARRAY, field_25_012345 CHAR, field_26_0123456 HIRESTIME, field_27_01234567 UINT8, field_28_012345678 RICHREAL, field_29_0123456789 INT8, field_30_0 BOOL, field_31_01 CHAR)");
      /* 586 */ glbTypes.push_back("TABLE(field_1_01 UINT8 ARRAY, field_2_012 UINT64, field_3_0123 INT8, field_4_01234 BOOL, field_5_012345 UINT64, field_6_0123456 UINT16 ARRAY, field_7_01234567 RICHREAL ARRAY, field_8_012345678 RICHREAL, field_9_0123456789 DATE, field_10_0 INT64, field_11_01 INT64, field_12_012 RICHREAL, field_13_0123 UINT8, field_14_01234 DATETIME, field_15_012345 REAL, field_16_0123456 UINT32, field_17_01234567 CHAR, field_18_012345678 DATETIME, field_19_0123456789 CHAR ARRAY, field_20_0 BOOL ARRAY, field_21_01 INT64, field_22_012 DATE, field_23_0123 CHAR, field_24_01234 UINT64, field_25_012345 INT64 ARRAY, field_26_0123456 UINT16, field_27_01234567 UINT8, field_28_012345678 BOOL, field_29_0123456789 UINT64, field_30_0 INT64 ARRAY, field_31_01 DATE, field_32_012 INT32 ARRAY, field_33_0123 INT8 ARRAY, field_34_01234 BOOL, field_35_012345 HIRESTIME, field_36_0123456 UINT64 ARRAY, field_37_01234567 INT16, field_38_012345678 INT8, field_39_0123456789 INT64, field_40_0 DATE, field_41_01 UINT16, field_42_012 INT8, field_43_0123 INT64 ARRAY, field_44_01234 INT8, field_45_012345 UINT64, field_46_0123456 RICHREAL ARRAY, field_47_01234567 INT8, field_48_012345678 UINT8, field_49_0123456789 REAL, field_50_0 INT8, field_51_01 UINT16, field_52_012 UINT64 ARRAY, field_53_0123 CHAR, field_54_01234 INT64 ARRAY, field_55_012345 UINT8, field_56_0123456 INT8, field_57_01234567 UINT64, field_58_012345678 INT32, field_59_0123456789 INT64, field_60_0 INT8, field_61_01 UINT8, field_62_012 RICHREAL, field_63_0123 REAL, field_64_01234 HIRESTIME, field_65_012345 BOOL, field_66_0123456 DATE, field_67_01234567 INT8, field_68_012345678 UINT8, field_69_0123456789 INT8, field_70_0 INT64, field_71_01 INT16, field_72_012 RICHREAL, field_73_0123 UINT32, field_74_01234 RICHREAL, field_75_012345 INT8, field_76_0123456 INT16, field_77_01234567 UINT8, field_78_012345678 RICHREAL, field_79_0123456789 REAL ARRAY, field_80_0 HIRESTIME ARRAY, field_81_01 DATE, field_82_012 INT32 ARRAY, field_83_0123 REAL ARRAY, field_84_01234 INT8 ARRAY, field_85_012345 UINT32)");
      /* 587 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 HIRESTIME, field_3_0123 INT32, field_4_01234 HIRESTIME, field_5_012345 INT8 ARRAY, field_6_0123456 INT64 ARRAY, field_7_01234567 HIRESTIME, field_8_012345678 INT16, field_9_0123456789 RICHREAL ARRAY, field_10_0 HIRESTIME, field_11_01 INT32 ARRAY, field_12_012 UINT16, field_13_0123 UINT16 ARRAY, field_14_01234 DATE ARRAY, field_15_012345 BOOL, field_16_0123456 UINT64, field_17_01234567 HIRESTIME, field_18_012345678 HIRESTIME, field_19_0123456789 CHAR ARRAY, field_20_0 RICHREAL, field_21_01 INT16, field_22_012 RICHREAL, field_23_0123 UINT64, field_24_01234 RICHREAL ARRAY, field_25_012345 DATE, field_26_0123456 BOOL, field_27_01234567 CHAR ARRAY, field_28_012345678 HIRESTIME, field_29_0123456789 DATE, field_30_0 DATETIME, field_31_01 UINT8, field_32_012 INT8 ARRAY, field_33_0123 BOOL, field_34_01234 UINT64 ARRAY, field_35_012345 INT8, field_36_0123456 UINT8, field_37_01234567 INT16 ARRAY, field_38_012345678 BOOL, field_39_0123456789 INT32, field_40_0 UINT8 ARRAY, field_41_01 UINT32, field_42_012 DATE, field_43_0123 INT64, field_44_01234 DATE, field_45_012345 DATE, field_46_0123456 INT16, field_47_01234567 REAL ARRAY, field_48_012345678 CHAR, field_49_0123456789 UINT64, field_50_0 CHAR, field_51_01 UINT32, field_52_012 HIRESTIME ARRAY, field_53_0123 INT16 ARRAY, field_54_01234 DATE, field_55_012345 RICHREAL, field_56_0123456 UINT16, field_57_01234567 UINT16, field_58_012345678 INT64, field_59_0123456789 DATETIME, field_60_0 INT32, field_61_01 RICHREAL)");
      /* 588 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 INT32 ARRAY, field_3_0123 DATE ARRAY, field_4_01234 UINT32, field_5_012345 INT32, field_6_0123456 DATETIME, field_7_01234567 UINT32, field_8_012345678 REAL, field_9_0123456789 UINT8, field_10_0 RICHREAL, field_11_01 RICHREAL, field_12_012 INT64, field_13_0123 CHAR, field_14_01234 UINT8, field_15_012345 UINT16, field_16_0123456 HIRESTIME, field_17_01234567 HIRESTIME, field_18_012345678 INT32, field_19_0123456789 INT16, field_20_0 INT16, field_21_01 REAL, field_22_012 UINT16 ARRAY, field_23_0123 UINT8, field_24_01234 INT32, field_25_012345 RICHREAL, field_26_0123456 DATE, field_27_01234567 DATETIME, field_28_012345678 REAL ARRAY, field_29_0123456789 HIRESTIME, field_30_0 UINT8, field_31_01 INT16, field_32_012 DATE, field_33_0123 UINT8 ARRAY, field_34_01234 DATETIME ARRAY, field_35_012345 INT8 ARRAY, field_36_0123456 INT16, field_37_01234567 UINT32, field_38_012345678 BOOL, field_39_0123456789 INT16, field_40_0 UINT8)");
      /* 589 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 REAL ARRAY, field_3_0123 INT8, field_4_01234 UINT64 ARRAY, field_5_012345 RICHREAL, field_6_0123456 CHAR, field_7_01234567 INT64, field_8_012345678 HIRESTIME, field_9_0123456789 DATE, field_10_0 UINT64, field_11_01 HIRESTIME, field_12_012 INT64, field_13_0123 INT64, field_14_01234 UINT64, field_15_012345 RICHREAL, field_16_0123456 UINT8, field_17_01234567 INT64 ARRAY, field_18_012345678 INT64 ARRAY, field_19_0123456789 BOOL, field_20_0 HIRESTIME, field_21_01 DATETIME, field_22_012 DATETIME, field_23_0123 DATETIME, field_24_01234 UINT8, field_25_012345 INT8, field_26_0123456 INT8, field_27_01234567 INT64 ARRAY, field_28_012345678 DATE ARRAY, field_29_0123456789 UINT32, field_30_0 HIRESTIME, field_31_01 CHAR, field_32_012 INT32, field_33_0123 BOOL, field_34_01234 DATE, field_35_012345 UINT64, field_36_0123456 CHAR ARRAY, field_37_01234567 DATETIME ARRAY, field_38_012345678 HIRESTIME, field_39_0123456789 INT16, field_40_0 CHAR, field_41_01 BOOL, field_42_012 UINT8, field_43_0123 HIRESTIME)");
      /* 590 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 UINT32 ARRAY, field_3_0123 INT16, field_4_01234 HIRESTIME, field_5_012345 RICHREAL, field_6_0123456 UINT32, field_7_01234567 DATE, field_8_012345678 CHAR, field_9_0123456789 UINT8, field_10_0 HIRESTIME, field_11_01 UINT32 ARRAY, field_12_012 UINT8, field_13_0123 CHAR ARRAY, field_14_01234 DATETIME, field_15_012345 REAL, field_16_0123456 UINT64 ARRAY, field_17_01234567 INT64, field_18_012345678 DATETIME ARRAY, field_19_0123456789 RICHREAL, field_20_0 INT16, field_21_01 INT32, field_22_012 CHAR, field_23_0123 UINT64 ARRAY, field_24_01234 HIRESTIME, field_25_012345 CHAR, field_26_0123456 INT8, field_27_01234567 CHAR ARRAY, field_28_012345678 UINT64, field_29_0123456789 UINT64, field_30_0 UINT16, field_31_01 UINT64, field_32_012 UINT8 ARRAY, field_33_0123 INT16, field_34_01234 REAL, field_35_012345 UINT64, field_36_0123456 DATE ARRAY, field_37_01234567 INT16 ARRAY, field_38_012345678 UINT8, field_39_0123456789 UINT64, field_40_0 INT64 ARRAY, field_41_01 REAL, field_42_012 DATETIME, field_43_0123 UINT64, field_44_01234 UINT64, field_45_012345 DATE, field_46_0123456 INT16 ARRAY, field_47_01234567 INT32 ARRAY)");
      /* 591 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 INT16, field_3_0123 HIRESTIME, field_4_01234 BOOL ARRAY, field_5_012345 REAL, field_6_0123456 UINT64 ARRAY, field_7_01234567 INT32, field_8_012345678 DATE, field_9_0123456789 REAL, field_10_0 HIRESTIME, field_11_01 UINT64, field_12_012 UINT8, field_13_0123 DATE, field_14_01234 RICHREAL ARRAY, field_15_012345 HIRESTIME, field_16_0123456 INT16, field_17_01234567 INT32 ARRAY, field_18_012345678 DATETIME, field_19_0123456789 UINT8, field_20_0 INT32, field_21_01 HIRESTIME, field_22_012 BOOL, field_23_0123 INT32, field_24_01234 DATE ARRAY, field_25_012345 DATE ARRAY, field_26_0123456 DATE, field_27_01234567 UINT16, field_28_012345678 UINT64, field_29_0123456789 DATETIME, field_30_0 UINT16, field_31_01 DATE, field_32_012 DATETIME ARRAY, field_33_0123 UINT64 ARRAY, field_34_01234 CHAR, field_35_012345 UINT16 ARRAY, field_36_0123456 INT32, field_37_01234567 REAL, field_38_012345678 RICHREAL, field_39_0123456789 REAL, field_40_0 UINT64, field_41_01 HIRESTIME, field_42_012 UINT8, field_43_0123 INT8, field_44_01234 DATETIME, field_45_012345 BOOL, field_46_0123456 CHAR, field_47_01234567 BOOL ARRAY, field_48_012345678 REAL)");
      /* 592 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 UINT64 ARRAY, field_3_0123 UINT64, field_4_01234 CHAR ARRAY, field_5_012345 INT8 ARRAY, field_6_0123456 CHAR ARRAY, field_7_01234567 INT8, field_8_012345678 UINT64, field_9_0123456789 REAL ARRAY, field_10_0 INT32, field_11_01 UINT8, field_12_012 INT8, field_13_0123 REAL, field_14_01234 INT8, field_15_012345 UINT16, field_16_0123456 DATETIME, field_17_01234567 DATETIME, field_18_012345678 REAL, field_19_0123456789 INT8, field_20_0 DATETIME, field_21_01 DATETIME, field_22_012 UINT32, field_23_0123 INT16, field_24_01234 INT64, field_25_012345 REAL, field_26_0123456 UINT16, field_27_01234567 RICHREAL, field_28_012345678 RICHREAL, field_29_0123456789 REAL, field_30_0 DATETIME, field_31_01 INT32 ARRAY, field_32_012 DATETIME, field_33_0123 CHAR, field_34_01234 UINT8, field_35_012345 UINT32, field_36_0123456 CHAR, field_37_01234567 HIRESTIME, field_38_012345678 INT64, field_39_0123456789 DATE, field_40_0 CHAR)");
      /* 593 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 INT64, field_3_0123 RICHREAL, field_4_01234 HIRESTIME, field_5_012345 UINT64, field_6_0123456 RICHREAL, field_7_01234567 UINT16 ARRAY, field_8_012345678 INT32, field_9_0123456789 UINT8 ARRAY, field_10_0 BOOL, field_11_01 REAL, field_12_012 CHAR, field_13_0123 UINT64, field_14_01234 INT32 ARRAY, field_15_012345 BOOL, field_16_0123456 INT32, field_17_01234567 UINT16, field_18_012345678 UINT32, field_19_0123456789 REAL, field_20_0 INT32 ARRAY, field_21_01 INT64, field_22_012 INT64, field_23_0123 INT32 ARRAY, field_24_01234 CHAR, field_25_012345 UINT64, field_26_0123456 INT32)");
      /* 594 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 HIRESTIME, field_3_0123 DATETIME, field_4_01234 UINT32 ARRAY, field_5_012345 HIRESTIME, field_6_0123456 DATETIME, field_7_01234567 CHAR, field_8_012345678 INT8, field_9_0123456789 RICHREAL, field_10_0 UINT8, field_11_01 INT32, field_12_012 INT16 ARRAY, field_13_0123 DATETIME, field_14_01234 UINT8 ARRAY, field_15_012345 UINT32, field_16_0123456 INT64, field_17_01234567 DATETIME ARRAY, field_18_012345678 INT64, field_19_0123456789 CHAR ARRAY, field_20_0 INT32 ARRAY, field_21_01 REAL, field_22_012 DATETIME, field_23_0123 INT16 ARRAY, field_24_01234 INT64 ARRAY, field_25_012345 UINT16, field_26_0123456 INT16 ARRAY, field_27_01234567 INT8, field_28_012345678 INT64, field_29_0123456789 REAL ARRAY, field_30_0 UINT16, field_31_01 UINT64 ARRAY, field_32_012 REAL, field_33_0123 INT8, field_34_01234 INT32 ARRAY, field_35_012345 INT16, field_36_0123456 INT8, field_37_01234567 REAL, field_38_012345678 UINT16, field_39_0123456789 INT64, field_40_0 BOOL, field_41_01 UINT8, field_42_012 DATETIME, field_43_0123 DATETIME, field_44_01234 UINT64, field_45_012345 UINT32, field_46_0123456 HIRESTIME, field_47_01234567 BOOL, field_48_012345678 INT16, field_49_0123456789 INT64)");
      /* 595 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 CHAR, field_3_0123 REAL, field_4_01234 CHAR, field_5_012345 INT16, field_6_0123456 BOOL, field_7_01234567 INT16, field_8_012345678 RICHREAL, field_9_0123456789 INT16, field_10_0 UINT32 ARRAY, field_11_01 INT8, field_12_012 HIRESTIME, field_13_0123 UINT64, field_14_01234 UINT16 ARRAY)");
      /* 596 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 CHAR ARRAY, field_3_0123 CHAR ARRAY, field_4_01234 REAL, field_5_012345 INT16, field_6_0123456 UINT64, field_7_01234567 UINT64, field_8_012345678 UINT32, field_9_0123456789 CHAR ARRAY, field_10_0 INT8)");
      /* 597 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 RICHREAL, field_3_0123 RICHREAL ARRAY, field_4_01234 HIRESTIME, field_5_012345 UINT16, field_6_0123456 UINT8, field_7_01234567 DATE ARRAY, field_8_012345678 INT8, field_9_0123456789 INT64, field_10_0 INT64 ARRAY, field_11_01 UINT8 ARRAY, field_12_012 RICHREAL, field_13_0123 UINT16, field_14_01234 CHAR ARRAY, field_15_012345 UINT8 ARRAY, field_16_0123456 UINT32, field_17_01234567 DATETIME, field_18_012345678 BOOL, field_19_0123456789 BOOL ARRAY, field_20_0 BOOL, field_21_01 UINT64, field_22_012 CHAR, field_23_0123 DATE, field_24_01234 REAL ARRAY, field_25_012345 HIRESTIME, field_26_0123456 INT8, field_27_01234567 CHAR, field_28_012345678 BOOL ARRAY, field_29_0123456789 DATETIME, field_30_0 REAL, field_31_01 UINT16, field_32_012 INT64, field_33_0123 UINT64, field_34_01234 DATE ARRAY, field_35_012345 UINT32 ARRAY, field_36_0123456 UINT8, field_37_01234567 INT32, field_38_012345678 CHAR, field_39_0123456789 RICHREAL, field_40_0 HIRESTIME, field_41_01 REAL, field_42_012 INT16 ARRAY, field_43_0123 DATETIME, field_44_01234 RICHREAL ARRAY, field_45_012345 BOOL, field_46_0123456 UINT32, field_47_01234567 INT8, field_48_012345678 UINT16, field_49_0123456789 DATETIME, field_50_0 INT8, field_51_01 CHAR, field_52_012 HIRESTIME, field_53_0123 UINT8, field_54_01234 DATETIME, field_55_012345 UINT16, field_56_0123456 UINT64, field_57_01234567 CHAR, field_58_012345678 DATE, field_59_0123456789 RICHREAL ARRAY, field_60_0 INT64, field_61_01 UINT32 ARRAY, field_62_012 UINT32, field_63_0123 HIRESTIME, field_64_01234 DATE, field_65_012345 REAL ARRAY, field_66_0123456 BOOL, field_67_01234567 DATETIME, field_68_012345678 UINT8, field_69_0123456789 BOOL, field_70_0 REAL, field_71_01 DATETIME, field_72_012 HIRESTIME, field_73_0123 INT16, field_74_01234 HIRESTIME, field_75_012345 INT32 ARRAY, field_76_0123456 BOOL, field_77_01234567 INT32, field_78_012345678 DATETIME, field_79_0123456789 HIRESTIME, field_80_0 UINT32 ARRAY, field_81_01 INT64 ARRAY, field_82_012 UINT16 ARRAY, field_83_0123 INT16, field_84_01234 UINT8, field_85_012345 INT16, field_86_0123456 INT16, field_87_01234567 REAL, field_88_012345678 UINT32, field_89_0123456789 INT16, field_90_0 UINT8, field_91_01 UINT16 ARRAY, field_92_012 UINT16, field_93_0123 UINT16, field_94_01234 UINT16, field_95_012345 INT64, field_96_0123456 RICHREAL, field_97_01234567 DATETIME, field_98_012345678 INT8)");
      /* 598 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME ARRAY, field_2_012 UINT8, field_3_0123 UINT8, field_4_01234 REAL, field_5_012345 DATE, field_6_0123456 BOOL ARRAY, field_7_01234567 INT8 ARRAY, field_8_012345678 DATE ARRAY, field_9_0123456789 UINT64, field_10_0 UINT32, field_11_01 BOOL, field_12_012 UINT32 ARRAY, field_13_0123 INT16, field_14_01234 INT16, field_15_012345 CHAR ARRAY, field_16_0123456 UINT32, field_17_01234567 INT64, field_18_012345678 DATE ARRAY, field_19_0123456789 RICHREAL, field_20_0 INT16, field_21_01 DATETIME ARRAY, field_22_012 INT32, field_23_0123 INT16, field_24_01234 UINT16, field_25_012345 UINT8 ARRAY, field_26_0123456 RICHREAL, field_27_01234567 REAL, field_28_012345678 DATETIME, field_29_0123456789 RICHREAL, field_30_0 UINT64, field_31_01 HIRESTIME, field_32_012 INT64, field_33_0123 DATE, field_34_01234 REAL, field_35_012345 RICHREAL ARRAY, field_36_0123456 UINT64, field_37_01234567 INT64, field_38_012345678 INT64, field_39_0123456789 CHAR, field_40_0 CHAR ARRAY, field_41_01 DATETIME ARRAY, field_42_012 DATE ARRAY, field_43_0123 INT8, field_44_01234 DATE)");
      /* 599 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 CHAR, field_3_0123 INT16 ARRAY, field_4_01234 BOOL, field_5_012345 UINT16, field_6_0123456 DATE, field_7_01234567 UINT64, field_8_012345678 CHAR, field_9_0123456789 INT8, field_10_0 RICHREAL ARRAY, field_11_01 INT8, field_12_012 REAL ARRAY, field_13_0123 RICHREAL, field_14_01234 REAL ARRAY, field_15_012345 DATETIME, field_16_0123456 REAL, field_17_01234567 INT32, field_18_012345678 UINT16, field_19_0123456789 UINT32 ARRAY, field_20_0 REAL, field_21_01 INT64, field_22_012 UINT16, field_23_0123 CHAR, field_24_01234 RICHREAL, field_25_012345 INT8, field_26_0123456 DATE, field_27_01234567 DATE, field_28_012345678 DATE, field_29_0123456789 UINT16, field_30_0 UINT32 ARRAY, field_31_01 HIRESTIME, field_32_012 UINT8, field_33_0123 UINT64 ARRAY, field_34_01234 INT16, field_35_012345 INT8 ARRAY, field_36_0123456 INT8, field_37_01234567 CHAR, field_38_012345678 INT16, field_39_0123456789 REAL, field_40_0 UINT16 ARRAY, field_41_01 HIRESTIME ARRAY)");
      /* 600 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 CHAR ARRAY, field_3_0123 INT8, field_4_01234 DATETIME ARRAY, field_5_012345 INT64, field_6_0123456 DATE, field_7_01234567 CHAR, field_8_012345678 UINT8, field_9_0123456789 INT8, field_10_0 HIRESTIME, field_11_01 INT16, field_12_012 BOOL, field_13_0123 INT16 ARRAY, field_14_01234 BOOL, field_15_012345 INT8 ARRAY, field_16_0123456 REAL, field_17_01234567 CHAR, field_18_012345678 UINT16, field_19_0123456789 DATE ARRAY, field_20_0 UINT32 ARRAY, field_21_01 INT32 ARRAY, field_22_012 INT64, field_23_0123 INT8, field_24_01234 UINT32, field_25_012345 INT64 ARRAY, field_26_0123456 INT32, field_27_01234567 INT64, field_28_012345678 INT16 ARRAY, field_29_0123456789 INT16, field_30_0 UINT8, field_31_01 CHAR, field_32_012 DATE ARRAY, field_33_0123 RICHREAL, field_34_01234 INT16, field_35_012345 UINT64, field_36_0123456 UINT64, field_37_01234567 REAL, field_38_012345678 INT8, field_39_0123456789 INT16, field_40_0 INT64, field_41_01 INT64, field_42_012 CHAR ARRAY, field_43_0123 UINT16, field_44_01234 UINT8 ARRAY, field_45_012345 DATE, field_46_0123456 DATE, field_47_01234567 INT8, field_48_012345678 RICHREAL, field_49_0123456789 INT32 ARRAY, field_50_0 REAL, field_51_01 INT64 ARRAY, field_52_012 UINT32, field_53_0123 UINT8, field_54_01234 CHAR, field_55_012345 UINT64, field_56_0123456 UINT8 ARRAY, field_57_01234567 UINT8, field_58_012345678 INT64, field_59_0123456789 REAL, field_60_0 UINT8, field_61_01 INT64 ARRAY, field_62_012 REAL, field_63_0123 DATETIME, field_64_01234 UINT64, field_65_012345 CHAR, field_66_0123456 DATETIME)");
      /* 601 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 INT8, field_3_0123 UINT16, field_4_01234 INT8, field_5_012345 REAL, field_6_0123456 UINT32 ARRAY, field_7_01234567 CHAR)");
      /* 602 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL ARRAY, field_2_012 RICHREAL ARRAY, field_3_0123 UINT16, field_4_01234 DATE, field_5_012345 UINT32, field_6_0123456 INT64 ARRAY, field_7_01234567 INT64, field_8_012345678 UINT8, field_9_0123456789 RICHREAL, field_10_0 INT16, field_11_01 UINT8, field_12_012 BOOL, field_13_0123 DATE, field_14_01234 INT8 ARRAY, field_15_012345 UINT64, field_16_0123456 INT32, field_17_01234567 BOOL, field_18_012345678 INT32, field_19_0123456789 DATE, field_20_0 DATETIME, field_21_01 DATETIME, field_22_012 INT16 ARRAY, field_23_0123 REAL, field_24_01234 REAL, field_25_012345 INT64, field_26_0123456 HIRESTIME, field_27_01234567 INT8, field_28_012345678 INT8, field_29_0123456789 HIRESTIME, field_30_0 HIRESTIME, field_31_01 REAL, field_32_012 INT16 ARRAY, field_33_0123 REAL ARRAY, field_34_01234 INT16, field_35_012345 UINT64, field_36_0123456 UINT16, field_37_01234567 INT8, field_38_012345678 UINT16, field_39_0123456789 INT32, field_40_0 RICHREAL, field_41_01 INT32, field_42_012 INT32, field_43_0123 INT8, field_44_01234 RICHREAL, field_45_012345 REAL, field_46_0123456 BOOL, field_47_01234567 DATETIME, field_48_012345678 RICHREAL ARRAY, field_49_0123456789 CHAR, field_50_0 BOOL ARRAY, field_51_01 UINT64, field_52_012 INT64, field_53_0123 DATE, field_54_01234 HIRESTIME, field_55_012345 BOOL, field_56_0123456 UINT32 ARRAY, field_57_01234567 UINT8, field_58_012345678 DATE, field_59_0123456789 BOOL ARRAY, field_60_0 HIRESTIME, field_61_01 INT8 ARRAY, field_62_012 DATE, field_63_0123 INT16, field_64_01234 INT8, field_65_012345 CHAR, field_66_0123456 INT16, field_67_01234567 HIRESTIME, field_68_012345678 DATETIME, field_69_0123456789 HIRESTIME ARRAY, field_70_0 INT32, field_71_01 INT32, field_72_012 INT32, field_73_0123 DATETIME, field_74_01234 INT8, field_75_012345 INT32)");
      /* 603 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 UINT64, field_3_0123 HIRESTIME, field_4_01234 INT16 ARRAY, field_5_012345 RICHREAL, field_6_0123456 INT16, field_7_01234567 DATE, field_8_012345678 INT16, field_9_0123456789 INT32, field_10_0 INT8, field_11_01 UINT32, field_12_012 UINT8, field_13_0123 DATETIME ARRAY, field_14_01234 UINT8, field_15_012345 HIRESTIME, field_16_0123456 REAL ARRAY, field_17_01234567 INT8 ARRAY, field_18_012345678 UINT32, field_19_0123456789 DATETIME, field_20_0 UINT8, field_21_01 INT16, field_22_012 UINT8, field_23_0123 UINT8, field_24_01234 DATETIME, field_25_012345 REAL, field_26_0123456 REAL, field_27_01234567 RICHREAL, field_28_012345678 DATETIME ARRAY, field_29_0123456789 UINT32, field_30_0 INT64, field_31_01 DATETIME, field_32_012 BOOL, field_33_0123 UINT16, field_34_01234 HIRESTIME, field_35_012345 UINT16, field_36_0123456 DATE, field_37_01234567 DATETIME, field_38_012345678 REAL, field_39_0123456789 UINT32, field_40_0 UINT8, field_41_01 UINT8 ARRAY, field_42_012 DATE, field_43_0123 INT64, field_44_01234 DATETIME ARRAY, field_45_012345 CHAR, field_46_0123456 REAL, field_47_01234567 RICHREAL, field_48_012345678 UINT8 ARRAY, field_49_0123456789 INT16, field_50_0 BOOL, field_51_01 CHAR, field_52_012 REAL, field_53_0123 INT16, field_54_01234 UINT64, field_55_012345 UINT16, field_56_0123456 INT16)");
      /* 604 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 DATETIME, field_3_0123 DATE, field_4_01234 RICHREAL ARRAY, field_5_012345 REAL, field_6_0123456 INT32 ARRAY, field_7_01234567 DATETIME, field_8_012345678 UINT8 ARRAY, field_9_0123456789 DATE ARRAY, field_10_0 INT32, field_11_01 UINT64, field_12_012 REAL, field_13_0123 DATE, field_14_01234 INT8, field_15_012345 INT32, field_16_0123456 INT32 ARRAY, field_17_01234567 INT8, field_18_012345678 UINT16, field_19_0123456789 BOOL, field_20_0 RICHREAL ARRAY, field_21_01 INT8, field_22_012 DATETIME, field_23_0123 DATE, field_24_01234 DATETIME, field_25_012345 HIRESTIME ARRAY, field_26_0123456 DATE, field_27_01234567 INT16, field_28_012345678 INT32, field_29_0123456789 INT8, field_30_0 DATE, field_31_01 INT32, field_32_012 INT32, field_33_0123 UINT16, field_34_01234 INT8, field_35_012345 DATE)");
      /* 605 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 BOOL, field_3_0123 INT32, field_4_01234 BOOL, field_5_012345 CHAR, field_6_0123456 HIRESTIME, field_7_01234567 INT32, field_8_012345678 DATE ARRAY, field_9_0123456789 UINT8, field_10_0 UINT16, field_11_01 UINT8, field_12_012 UINT32, field_13_0123 BOOL, field_14_01234 CHAR, field_15_012345 INT16, field_16_0123456 BOOL, field_17_01234567 HIRESTIME, field_18_012345678 BOOL, field_19_0123456789 HIRESTIME, field_20_0 INT16)");
      /* 606 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 BOOL, field_3_0123 DATETIME, field_4_01234 REAL, field_5_012345 REAL, field_6_0123456 UINT16, field_7_01234567 DATETIME, field_8_012345678 INT8, field_9_0123456789 BOOL, field_10_0 HIRESTIME, field_11_01 INT32, field_12_012 INT16 ARRAY, field_13_0123 UINT32 ARRAY, field_14_01234 UINT16, field_15_012345 BOOL, field_16_0123456 UINT64, field_17_01234567 INT64, field_18_012345678 UINT64, field_19_0123456789 DATETIME, field_20_0 UINT16, field_21_01 BOOL, field_22_012 DATE, field_23_0123 HIRESTIME, field_24_01234 INT8, field_25_012345 RICHREAL, field_26_0123456 INT8, field_27_01234567 UINT16 ARRAY, field_28_012345678 UINT16, field_29_0123456789 INT8, field_30_0 INT8, field_31_01 CHAR, field_32_012 DATETIME ARRAY, field_33_0123 CHAR, field_34_01234 INT64, field_35_012345 UINT8, field_36_0123456 UINT64, field_37_01234567 UINT64, field_38_012345678 CHAR, field_39_0123456789 UINT64, field_40_0 HIRESTIME, field_41_01 INT32, field_42_012 INT32, field_43_0123 UINT8, field_44_01234 INT64 ARRAY, field_45_012345 UINT8, field_46_0123456 REAL, field_47_01234567 UINT8 ARRAY, field_48_012345678 BOOL ARRAY, field_49_0123456789 RICHREAL, field_50_0 REAL, field_51_01 UINT8, field_52_012 INT8, field_53_0123 INT16)");
      /* 607 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 DATETIME, field_3_0123 UINT64, field_4_01234 UINT64, field_5_012345 RICHREAL, field_6_0123456 INT32, field_7_01234567 INT32, field_8_012345678 INT64, field_9_0123456789 UINT64)");
      /* 608 */ glbTypes.push_back("TABLE");
      /* 609 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 BOOL, field_3_0123 INT8, field_4_01234 UINT32 ARRAY, field_5_012345 BOOL, field_6_0123456 BOOL, field_7_01234567 RICHREAL, field_8_012345678 CHAR, field_9_0123456789 UINT64 ARRAY, field_10_0 CHAR, field_11_01 INT64, field_12_012 RICHREAL, field_13_0123 INT16, field_14_01234 RICHREAL, field_15_012345 UINT8, field_16_0123456 BOOL, field_17_01234567 UINT8, field_18_012345678 UINT64 ARRAY, field_19_0123456789 INT8, field_20_0 INT8 ARRAY, field_21_01 INT16, field_22_012 UINT64, field_23_0123 UINT8, field_24_01234 INT8, field_25_012345 DATE, field_26_0123456 INT32, field_27_01234567 UINT32, field_28_012345678 INT32 ARRAY, field_29_0123456789 INT16, field_30_0 UINT64, field_31_01 INT32, field_32_012 UINT32, field_33_0123 BOOL, field_34_01234 UINT64, field_35_012345 CHAR, field_36_0123456 UINT16 ARRAY, field_37_01234567 REAL ARRAY, field_38_012345678 DATE, field_39_0123456789 INT16, field_40_0 INT64, field_41_01 REAL, field_42_012 UINT32, field_43_0123 HIRESTIME, field_44_01234 RICHREAL, field_45_012345 UINT8, field_46_0123456 UINT16, field_47_01234567 UINT64)");
      /* 610 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 UINT8 ARRAY, field_3_0123 UINT8, field_4_01234 HIRESTIME, field_5_012345 INT8, field_6_0123456 INT32 ARRAY, field_7_01234567 UINT8, field_8_012345678 BOOL ARRAY, field_9_0123456789 INT16, field_10_0 CHAR, field_11_01 REAL, field_12_012 REAL, field_13_0123 INT8, field_14_01234 BOOL ARRAY, field_15_012345 INT16, field_16_0123456 INT64, field_17_01234567 UINT16, field_18_012345678 UINT16, field_19_0123456789 INT32, field_20_0 DATE ARRAY, field_21_01 HIRESTIME, field_22_012 UINT16 ARRAY, field_23_0123 INT32, field_24_01234 HIRESTIME, field_25_012345 UINT8, field_26_0123456 INT16, field_27_01234567 UINT8, field_28_012345678 HIRESTIME, field_29_0123456789 DATETIME ARRAY, field_30_0 HIRESTIME, field_31_01 DATE, field_32_012 UINT32, field_33_0123 UINT8)");
      /* 611 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 RICHREAL, field_3_0123 UINT16 ARRAY, field_4_01234 INT64, field_5_012345 INT16, field_6_0123456 DATETIME, field_7_01234567 BOOL, field_8_012345678 UINT16, field_9_0123456789 UINT16, field_10_0 UINT16 ARRAY, field_11_01 UINT64, field_12_012 HIRESTIME, field_13_0123 RICHREAL, field_14_01234 INT8, field_15_012345 UINT8, field_16_0123456 RICHREAL ARRAY, field_17_01234567 INT32, field_18_012345678 REAL ARRAY, field_19_0123456789 UINT64, field_20_0 DATE, field_21_01 INT64, field_22_012 UINT16, field_23_0123 CHAR, field_24_01234 UINT64, field_25_012345 CHAR ARRAY, field_26_0123456 BOOL ARRAY, field_27_01234567 HIRESTIME, field_28_012345678 UINT32 ARRAY, field_29_0123456789 UINT8, field_30_0 HIRESTIME, field_31_01 CHAR, field_32_012 INT64, field_33_0123 INT64, field_34_01234 UINT64, field_35_012345 UINT32 ARRAY, field_36_0123456 CHAR, field_37_01234567 CHAR, field_38_012345678 BOOL, field_39_0123456789 UINT16, field_40_0 CHAR, field_41_01 BOOL, field_42_012 UINT8, field_43_0123 INT16 ARRAY, field_44_01234 INT16, field_45_012345 BOOL, field_46_0123456 UINT64, field_47_01234567 INT64, field_48_012345678 UINT64 ARRAY, field_49_0123456789 RICHREAL, field_50_0 DATE, field_51_01 DATETIME ARRAY, field_52_012 INT8, field_53_0123 BOOL ARRAY, field_54_01234 UINT16, field_55_012345 REAL, field_56_0123456 INT16, field_57_01234567 CHAR, field_58_012345678 UINT64, field_59_0123456789 DATE, field_60_0 CHAR, field_61_01 INT64, field_62_012 REAL, field_63_0123 DATE, field_64_01234 UINT16, field_65_012345 DATE, field_66_0123456 HIRESTIME, field_67_01234567 INT8, field_68_012345678 RICHREAL, field_69_0123456789 INT16 ARRAY, field_70_0 RICHREAL, field_71_01 UINT8)");
      /* 612 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 INT16 ARRAY, field_3_0123 INT64 ARRAY, field_4_01234 HIRESTIME, field_5_012345 HIRESTIME, field_6_0123456 DATE, field_7_01234567 INT64, field_8_012345678 REAL ARRAY, field_9_0123456789 UINT32, field_10_0 HIRESTIME ARRAY, field_11_01 HIRESTIME, field_12_012 HIRESTIME, field_13_0123 INT32, field_14_01234 RICHREAL, field_15_012345 UINT8 ARRAY, field_16_0123456 INT32, field_17_01234567 INT8, field_18_012345678 DATE ARRAY, field_19_0123456789 INT32, field_20_0 RICHREAL ARRAY, field_21_01 BOOL, field_22_012 RICHREAL, field_23_0123 INT16 ARRAY, field_24_01234 UINT8, field_25_012345 REAL, field_26_0123456 UINT8, field_27_01234567 INT32, field_28_012345678 INT64, field_29_0123456789 RICHREAL, field_30_0 REAL, field_31_01 DATE, field_32_012 CHAR, field_33_0123 BOOL, field_34_01234 INT64, field_35_012345 CHAR, field_36_0123456 UINT64, field_37_01234567 UINT8 ARRAY, field_38_012345678 CHAR, field_39_0123456789 HIRESTIME, field_40_0 DATETIME, field_41_01 UINT32, field_42_012 HIRESTIME, field_43_0123 DATETIME, field_44_01234 UINT64, field_45_012345 CHAR, field_46_0123456 UINT32 ARRAY, field_47_01234567 INT64, field_48_012345678 INT16, field_49_0123456789 INT16, field_50_0 UINT8, field_51_01 UINT16, field_52_012 UINT8, field_53_0123 UINT64, field_54_01234 INT32, field_55_012345 DATETIME, field_56_0123456 INT64 ARRAY, field_57_01234567 RICHREAL, field_58_012345678 UINT64 ARRAY, field_59_0123456789 INT8, field_60_0 UINT64, field_61_01 INT64, field_62_012 UINT16 ARRAY, field_63_0123 HIRESTIME ARRAY, field_64_01234 BOOL, field_65_012345 INT16, field_66_0123456 RICHREAL, field_67_01234567 UINT64, field_68_012345678 INT8, field_69_0123456789 REAL ARRAY, field_70_0 INT16, field_71_01 UINT16, field_72_012 CHAR, field_73_0123 INT16, field_74_01234 CHAR, field_75_012345 INT16, field_76_0123456 BOOL ARRAY, field_77_01234567 CHAR, field_78_012345678 INT8, field_79_0123456789 DATETIME, field_80_0 DATETIME, field_81_01 REAL, field_82_012 RICHREAL ARRAY, field_83_0123 DATE, field_84_01234 UINT16)");
      /* 613 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 UINT32, field_3_0123 INT8, field_4_01234 UINT8, field_5_012345 BOOL, field_6_0123456 RICHREAL, field_7_01234567 INT8, field_8_012345678 UINT32 ARRAY, field_9_0123456789 UINT32, field_10_0 INT8, field_11_01 BOOL, field_12_012 DATETIME, field_13_0123 INT8, field_14_01234 UINT16 ARRAY, field_15_012345 DATETIME ARRAY, field_16_0123456 BOOL, field_17_01234567 INT32, field_18_012345678 DATETIME, field_19_0123456789 HIRESTIME, field_20_0 BOOL ARRAY, field_21_01 REAL, field_22_012 BOOL ARRAY, field_23_0123 UINT32 ARRAY, field_24_01234 REAL ARRAY, field_25_012345 INT32, field_26_0123456 INT64, field_27_01234567 UINT16, field_28_012345678 UINT16, field_29_0123456789 CHAR, field_30_0 UINT64 ARRAY, field_31_01 UINT16, field_32_012 CHAR, field_33_0123 INT8, field_34_01234 UINT8 ARRAY, field_35_012345 DATETIME, field_36_0123456 UINT64, field_37_01234567 UINT32 ARRAY, field_38_012345678 HIRESTIME, field_39_0123456789 REAL, field_40_0 INT8 ARRAY, field_41_01 INT32 ARRAY, field_42_012 INT32, field_43_0123 INT8, field_44_01234 CHAR, field_45_012345 INT32, field_46_0123456 UINT16, field_47_01234567 RICHREAL, field_48_012345678 DATETIME, field_49_0123456789 INT64, field_50_0 UINT8, field_51_01 INT8 ARRAY, field_52_012 UINT16, field_53_0123 INT32, field_54_01234 INT8, field_55_012345 HIRESTIME, field_56_0123456 HIRESTIME, field_57_01234567 INT8, field_58_012345678 REAL, field_59_0123456789 UINT32, field_60_0 UINT8, field_61_01 INT64, field_62_012 HIRESTIME, field_63_0123 BOOL)");
      /* 614 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 INT32, field_3_0123 DATETIME, field_4_01234 UINT64, field_5_012345 INT8, field_6_0123456 UINT64, field_7_01234567 INT32, field_8_012345678 INT16, field_9_0123456789 INT8, field_10_0 INT8, field_11_01 INT32, field_12_012 BOOL, field_13_0123 UINT32, field_14_01234 HIRESTIME)");
      /* 615 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 INT16, field_3_0123 DATETIME, field_4_01234 UINT8, field_5_012345 DATETIME, field_6_0123456 INT8 ARRAY, field_7_01234567 DATETIME, field_8_012345678 INT16 ARRAY, field_9_0123456789 DATE, field_10_0 DATE ARRAY, field_11_01 UINT64 ARRAY, field_12_012 UINT32, field_13_0123 BOOL, field_14_01234 INT8, field_15_012345 UINT16, field_16_0123456 INT64, field_17_01234567 INT16 ARRAY, field_18_012345678 UINT64, field_19_0123456789 INT32, field_20_0 INT8, field_21_01 HIRESTIME, field_22_012 UINT8 ARRAY, field_23_0123 REAL, field_24_01234 INT16, field_25_012345 DATETIME, field_26_0123456 INT8, field_27_01234567 RICHREAL, field_28_012345678 HIRESTIME, field_29_0123456789 REAL, field_30_0 UINT8, field_31_01 INT64 ARRAY, field_32_012 INT32, field_33_0123 INT16, field_34_01234 UINT16, field_35_012345 UINT8, field_36_0123456 DATETIME ARRAY, field_37_01234567 BOOL, field_38_012345678 REAL, field_39_0123456789 UINT64, field_40_0 UINT64, field_41_01 INT32, field_42_012 INT32, field_43_0123 DATE, field_44_01234 CHAR ARRAY, field_45_012345 REAL, field_46_0123456 DATE ARRAY, field_47_01234567 INT32, field_48_012345678 INT64, field_49_0123456789 CHAR, field_50_0 RICHREAL, field_51_01 DATE, field_52_012 INT64, field_53_0123 HIRESTIME ARRAY, field_54_01234 UINT64, field_55_012345 UINT32, field_56_0123456 DATETIME, field_57_01234567 REAL, field_58_012345678 UINT8 ARRAY, field_59_0123456789 DATE, field_60_0 REAL, field_61_01 DATE, field_62_012 UINT8, field_63_0123 UINT32, field_64_01234 UINT16, field_65_012345 DATETIME, field_66_0123456 INT16, field_67_01234567 UINT64, field_68_012345678 RICHREAL, field_69_0123456789 HIRESTIME, field_70_0 INT64)");
      /* 616 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 UINT16, field_3_0123 INT8 ARRAY, field_4_01234 UINT32, field_5_012345 INT64, field_6_0123456 HIRESTIME, field_7_01234567 UINT8, field_8_012345678 RICHREAL, field_9_0123456789 RICHREAL ARRAY, field_10_0 CHAR, field_11_01 DATETIME, field_12_012 UINT8 ARRAY, field_13_0123 INT64, field_14_01234 INT8, field_15_012345 INT8, field_16_0123456 CHAR, field_17_01234567 DATETIME, field_18_012345678 INT8, field_19_0123456789 CHAR, field_20_0 INT16, field_21_01 REAL, field_22_012 UINT32, field_23_0123 UINT8, field_24_01234 UINT64, field_25_012345 INT32)");
      /* 617 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 UINT8 ARRAY, field_3_0123 INT64, field_4_01234 UINT16, field_5_012345 UINT8, field_6_0123456 DATETIME, field_7_01234567 UINT8, field_8_012345678 DATE, field_9_0123456789 DATETIME, field_10_0 DATETIME ARRAY, field_11_01 INT16, field_12_012 INT16 ARRAY, field_13_0123 UINT8, field_14_01234 INT64 ARRAY, field_15_012345 UINT8, field_16_0123456 DATE ARRAY, field_17_01234567 INT16, field_18_012345678 UINT64, field_19_0123456789 RICHREAL ARRAY, field_20_0 CHAR ARRAY, field_21_01 UINT64, field_22_012 RICHREAL, field_23_0123 UINT32, field_24_01234 UINT8, field_25_012345 DATE, field_26_0123456 BOOL ARRAY, field_27_01234567 REAL, field_28_012345678 UINT16, field_29_0123456789 INT32, field_30_0 UINT8, field_31_01 DATE ARRAY, field_32_012 DATETIME, field_33_0123 RICHREAL, field_34_01234 UINT64, field_35_012345 UINT8)");
      /* 618 */ glbTypes.push_back("TABLE(field_1_01 INT16 ARRAY, field_2_012 UINT64, field_3_0123 RICHREAL, field_4_01234 UINT8, field_5_012345 HIRESTIME, field_6_0123456 UINT8, field_7_01234567 UINT32, field_8_012345678 INT8, field_9_0123456789 UINT32, field_10_0 UINT8, field_11_01 BOOL ARRAY, field_12_012 UINT8 ARRAY, field_13_0123 BOOL, field_14_01234 UINT16, field_15_012345 INT8 ARRAY, field_16_0123456 REAL ARRAY, field_17_01234567 DATE, field_18_012345678 INT8, field_19_0123456789 INT64 ARRAY, field_20_0 INT8, field_21_01 INT64 ARRAY, field_22_012 INT16, field_23_0123 BOOL, field_24_01234 REAL, field_25_012345 UINT32, field_26_0123456 UINT8, field_27_01234567 INT64, field_28_012345678 DATETIME, field_29_0123456789 UINT16 ARRAY, field_30_0 HIRESTIME, field_31_01 DATE, field_32_012 BOOL, field_33_0123 RICHREAL, field_34_01234 INT64, field_35_012345 UINT8, field_36_0123456 CHAR, field_37_01234567 UINT32, field_38_012345678 UINT64, field_39_0123456789 REAL ARRAY, field_40_0 BOOL, field_41_01 REAL, field_42_012 INT16 ARRAY, field_43_0123 RICHREAL, field_44_01234 RICHREAL, field_45_012345 UINT32, field_46_0123456 RICHREAL, field_47_01234567 HIRESTIME, field_48_012345678 CHAR, field_49_0123456789 REAL, field_50_0 CHAR, field_51_01 UINT32, field_52_012 RICHREAL, field_53_0123 UINT16 ARRAY, field_54_01234 UINT8, field_55_012345 REAL, field_56_0123456 CHAR, field_57_01234567 DATETIME)");
      /* 619 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 UINT64, field_3_0123 UINT16, field_4_01234 BOOL, field_5_012345 INT64, field_6_0123456 INT16, field_7_01234567 UINT32, field_8_012345678 INT32, field_9_0123456789 UINT32, field_10_0 INT64, field_11_01 HIRESTIME ARRAY, field_12_012 BOOL, field_13_0123 REAL, field_14_01234 UINT8, field_15_012345 RICHREAL, field_16_0123456 INT32, field_17_01234567 CHAR, field_18_012345678 DATE, field_19_0123456789 REAL, field_20_0 BOOL, field_21_01 UINT32, field_22_012 INT64, field_23_0123 INT32, field_24_01234 INT8, field_25_012345 INT32 ARRAY, field_26_0123456 RICHREAL, field_27_01234567 DATE, field_28_012345678 UINT8, field_29_0123456789 DATE ARRAY, field_30_0 UINT16 ARRAY, field_31_01 UINT16, field_32_012 DATETIME ARRAY, field_33_0123 DATE, field_34_01234 INT8, field_35_012345 BOOL, field_36_0123456 INT8 ARRAY, field_37_01234567 CHAR ARRAY, field_38_012345678 HIRESTIME, field_39_0123456789 DATETIME, field_40_0 CHAR ARRAY, field_41_01 UINT16 ARRAY, field_42_012 DATE, field_43_0123 UINT64, field_44_01234 DATETIME ARRAY, field_45_012345 UINT8, field_46_0123456 UINT8, field_47_01234567 INT64, field_48_012345678 BOOL, field_49_0123456789 INT16, field_50_0 UINT8, field_51_01 INT64 ARRAY, field_52_012 DATE, field_53_0123 REAL, field_54_01234 UINT32, field_55_012345 REAL, field_56_0123456 REAL ARRAY, field_57_01234567 CHAR)");
      /* 620 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 RICHREAL, field_3_0123 INT32, field_4_01234 CHAR ARRAY, field_5_012345 DATETIME, field_6_0123456 BOOL, field_7_01234567 DATE)");
      /* 621 */ glbTypes.push_back("TABLE(field_1_01 BOOL ARRAY, field_2_012 UINT64, field_3_0123 CHAR, field_4_01234 UINT64 ARRAY, field_5_012345 BOOL, field_6_0123456 UINT8, field_7_01234567 REAL, field_8_012345678 INT32, field_9_0123456789 CHAR, field_10_0 RICHREAL, field_11_01 REAL, field_12_012 INT16 ARRAY, field_13_0123 DATE, field_14_01234 UINT32, field_15_012345 UINT16, field_16_0123456 INT32, field_17_01234567 UINT16, field_18_012345678 UINT16, field_19_0123456789 HIRESTIME, field_20_0 INT32 ARRAY, field_21_01 CHAR, field_22_012 INT16, field_23_0123 BOOL, field_24_01234 INT64, field_25_012345 UINT64, field_26_0123456 INT32, field_27_01234567 UINT8, field_28_012345678 UINT64 ARRAY, field_29_0123456789 INT16, field_30_0 INT16, field_31_01 UINT8, field_32_012 UINT64, field_33_0123 UINT16, field_34_01234 INT8, field_35_012345 INT8, field_36_0123456 BOOL, field_37_01234567 UINT8, field_38_012345678 UINT32, field_39_0123456789 UINT16, field_40_0 CHAR, field_41_01 INT32, field_42_012 UINT8)");
      /* 622 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 UINT64 ARRAY, field_3_0123 UINT16, field_4_01234 INT32 ARRAY, field_5_012345 HIRESTIME, field_6_0123456 CHAR, field_7_01234567 RICHREAL ARRAY, field_8_012345678 UINT32, field_9_0123456789 CHAR, field_10_0 DATETIME, field_11_01 INT16 ARRAY, field_12_012 DATETIME, field_13_0123 DATE, field_14_01234 INT64)");
      /* 623 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 REAL, field_3_0123 INT8, field_4_01234 BOOL, field_5_012345 DATE, field_6_0123456 DATETIME, field_7_01234567 INT16, field_8_012345678 INT32, field_9_0123456789 INT16, field_10_0 HIRESTIME, field_11_01 CHAR, field_12_012 BOOL, field_13_0123 UINT8, field_14_01234 RICHREAL, field_15_012345 UINT32, field_16_0123456 UINT8, field_17_01234567 UINT64, field_18_012345678 CHAR, field_19_0123456789 INT16, field_20_0 DATE, field_21_01 UINT32, field_22_012 BOOL, field_23_0123 UINT64 ARRAY, field_24_01234 HIRESTIME, field_25_012345 HIRESTIME, field_26_0123456 DATETIME, field_27_01234567 INT16, field_28_012345678 UINT64, field_29_0123456789 RICHREAL, field_30_0 UINT16, field_31_01 BOOL, field_32_012 RICHREAL ARRAY, field_33_0123 UINT64, field_34_01234 DATE, field_35_012345 DATETIME, field_36_0123456 RICHREAL, field_37_01234567 INT32, field_38_012345678 HIRESTIME, field_39_0123456789 INT16, field_40_0 INT32, field_41_01 UINT16, field_42_012 INT64, field_43_0123 HIRESTIME ARRAY, field_44_01234 INT8, field_45_012345 INT8 ARRAY, field_46_0123456 REAL, field_47_01234567 INT8, field_48_012345678 HIRESTIME, field_49_0123456789 DATE ARRAY, field_50_0 INT8, field_51_01 UINT64, field_52_012 INT16, field_53_0123 INT32 ARRAY, field_54_01234 BOOL ARRAY, field_55_012345 RICHREAL, field_56_0123456 INT16, field_57_01234567 UINT8, field_58_012345678 BOOL, field_59_0123456789 DATETIME, field_60_0 INT16, field_61_01 UINT64)");
      /* 624 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 UINT32, field_3_0123 UINT8, field_4_01234 UINT16 ARRAY, field_5_012345 INT16, field_6_0123456 UINT32 ARRAY, field_7_01234567 INT32, field_8_012345678 UINT16 ARRAY, field_9_0123456789 UINT64 ARRAY, field_10_0 CHAR, field_11_01 INT16, field_12_012 UINT8 ARRAY, field_13_0123 RICHREAL, field_14_01234 UINT16, field_15_012345 UINT64, field_16_0123456 INT8 ARRAY, field_17_01234567 RICHREAL, field_18_012345678 UINT16 ARRAY, field_19_0123456789 INT8 ARRAY, field_20_0 RICHREAL, field_21_01 CHAR, field_22_012 INT8, field_23_0123 CHAR, field_24_01234 INT64, field_25_012345 UINT16, field_26_0123456 REAL, field_27_01234567 INT8, field_28_012345678 UINT16, field_29_0123456789 UINT64, field_30_0 BOOL ARRAY, field_31_01 INT64, field_32_012 UINT8, field_33_0123 REAL, field_34_01234 UINT8, field_35_012345 REAL, field_36_0123456 UINT8, field_37_01234567 REAL, field_38_012345678 UINT8, field_39_0123456789 REAL ARRAY, field_40_0 INT32 ARRAY, field_41_01 INT32 ARRAY, field_42_012 INT8 ARRAY, field_43_0123 INT32, field_44_01234 UINT8, field_45_012345 BOOL, field_46_0123456 HIRESTIME, field_47_01234567 INT8, field_48_012345678 INT8, field_49_0123456789 REAL, field_50_0 DATETIME, field_51_01 DATETIME ARRAY, field_52_012 INT32, field_53_0123 INT32, field_54_01234 UINT8, field_55_012345 RICHREAL, field_56_0123456 RICHREAL, field_57_01234567 UINT64, field_58_012345678 INT8)");
      /* 625 */ glbTypes.push_back("TABLE(field_1_01 UINT8 ARRAY, field_2_012 INT8, field_3_0123 BOOL, field_4_01234 REAL, field_5_012345 INT8, field_6_0123456 INT8, field_7_01234567 HIRESTIME ARRAY, field_8_012345678 RICHREAL ARRAY, field_9_0123456789 CHAR)");
      /* 626 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 INT64, field_3_0123 REAL, field_4_01234 BOOL, field_5_012345 REAL, field_6_0123456 UINT32 ARRAY, field_7_01234567 BOOL, field_8_012345678 UINT8, field_9_0123456789 DATE, field_10_0 UINT64, field_11_01 INT16, field_12_012 BOOL, field_13_0123 INT32, field_14_01234 DATE, field_15_012345 UINT64, field_16_0123456 HIRESTIME, field_17_01234567 BOOL, field_18_012345678 INT16, field_19_0123456789 CHAR, field_20_0 UINT16, field_21_01 RICHREAL, field_22_012 INT32, field_23_0123 INT8, field_24_01234 UINT8, field_25_012345 UINT16, field_26_0123456 RICHREAL, field_27_01234567 UINT64, field_28_012345678 REAL, field_29_0123456789 UINT64, field_30_0 INT64, field_31_01 UINT8, field_32_012 UINT8, field_33_0123 UINT16, field_34_01234 INT16 ARRAY, field_35_012345 UINT8, field_36_0123456 HIRESTIME, field_37_01234567 INT64, field_38_012345678 INT32, field_39_0123456789 UINT16, field_40_0 HIRESTIME ARRAY, field_41_01 REAL ARRAY, field_42_012 UINT8, field_43_0123 INT8, field_44_01234 DATETIME, field_45_012345 CHAR, field_46_0123456 HIRESTIME, field_47_01234567 UINT64, field_48_012345678 INT64 ARRAY, field_49_0123456789 CHAR ARRAY, field_50_0 HIRESTIME, field_51_01 DATE ARRAY, field_52_012 INT16, field_53_0123 INT32 ARRAY, field_54_01234 INT8, field_55_012345 BOOL, field_56_0123456 BOOL, field_57_01234567 INT32, field_58_012345678 RICHREAL, field_59_0123456789 UINT64, field_60_0 UINT8 ARRAY, field_61_01 INT32 ARRAY, field_62_012 INT8, field_63_0123 DATETIME, field_64_01234 UINT32, field_65_012345 HIRESTIME, field_66_0123456 UINT64, field_67_01234567 UINT64, field_68_012345678 INT64, field_69_0123456789 CHAR, field_70_0 BOOL, field_71_01 UINT16 ARRAY, field_72_012 DATE, field_73_0123 INT64, field_74_01234 DATE)");
      /* 627 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 RICHREAL, field_3_0123 RICHREAL, field_4_01234 HIRESTIME, field_5_012345 DATE, field_6_0123456 UINT32, field_7_01234567 INT8, field_8_012345678 UINT64, field_9_0123456789 INT16 ARRAY, field_10_0 REAL, field_11_01 UINT16, field_12_012 DATE, field_13_0123 BOOL, field_14_01234 INT8, field_15_012345 DATE, field_16_0123456 BOOL, field_17_01234567 RICHREAL, field_18_012345678 REAL, field_19_0123456789 DATE, field_20_0 UINT16, field_21_01 CHAR ARRAY, field_22_012 UINT8 ARRAY, field_23_0123 INT32, field_24_01234 INT32, field_25_012345 RICHREAL)");
      /* 628 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 INT64, field_3_0123 INT32, field_4_01234 INT8, field_5_012345 UINT32, field_6_0123456 UINT32 ARRAY, field_7_01234567 DATE, field_8_012345678 HIRESTIME, field_9_0123456789 INT64, field_10_0 UINT64, field_11_01 RICHREAL, field_12_012 UINT32, field_13_0123 INT32, field_14_01234 INT64, field_15_012345 RICHREAL ARRAY, field_16_0123456 UINT64 ARRAY, field_17_01234567 UINT8 ARRAY, field_18_012345678 CHAR ARRAY, field_19_0123456789 INT32, field_20_0 RICHREAL, field_21_01 RICHREAL, field_22_012 INT32 ARRAY, field_23_0123 INT8, field_24_01234 CHAR, field_25_012345 INT64, field_26_0123456 INT64, field_27_01234567 UINT64, field_28_012345678 HIRESTIME, field_29_0123456789 INT32, field_30_0 REAL, field_31_01 DATE, field_32_012 DATETIME ARRAY, field_33_0123 UINT8, field_34_01234 DATETIME, field_35_012345 UINT32, field_36_0123456 DATETIME ARRAY, field_37_01234567 RICHREAL, field_38_012345678 INT64, field_39_0123456789 DATE ARRAY, field_40_0 UINT32, field_41_01 UINT8, field_42_012 UINT64, field_43_0123 UINT16 ARRAY, field_44_01234 RICHREAL, field_45_012345 INT64, field_46_0123456 UINT8 ARRAY, field_47_01234567 BOOL, field_48_012345678 INT16, field_49_0123456789 INT16, field_50_0 INT32 ARRAY, field_51_01 UINT64, field_52_012 HIRESTIME, field_53_0123 UINT8, field_54_01234 REAL, field_55_012345 INT16, field_56_0123456 REAL, field_57_01234567 DATETIME ARRAY, field_58_012345678 DATE ARRAY, field_59_0123456789 UINT16 ARRAY, field_60_0 DATETIME, field_61_01 DATE, field_62_012 INT64, field_63_0123 BOOL ARRAY, field_64_01234 CHAR, field_65_012345 BOOL, field_66_0123456 DATE ARRAY, field_67_01234567 UINT16 ARRAY, field_68_012345678 RICHREAL, field_69_0123456789 INT16, field_70_0 UINT32, field_71_01 HIRESTIME, field_72_012 HIRESTIME, field_73_0123 DATE, field_74_01234 UINT8, field_75_012345 UINT16, field_76_0123456 UINT16, field_77_01234567 UINT8, field_78_012345678 UINT16, field_79_0123456789 BOOL, field_80_0 INT64 ARRAY, field_81_01 DATE, field_82_012 UINT32 ARRAY, field_83_0123 INT8, field_84_01234 INT16 ARRAY)");
      /* 629 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 CHAR ARRAY, field_3_0123 CHAR, field_4_01234 UINT32 ARRAY, field_5_012345 BOOL, field_6_0123456 HIRESTIME, field_7_01234567 UINT64, field_8_012345678 INT16 ARRAY, field_9_0123456789 BOOL, field_10_0 UINT64, field_11_01 RICHREAL, field_12_012 INT32 ARRAY, field_13_0123 HIRESTIME ARRAY, field_14_01234 UINT8, field_15_012345 UINT16, field_16_0123456 UINT16, field_17_01234567 CHAR ARRAY, field_18_012345678 INT32, field_19_0123456789 HIRESTIME, field_20_0 REAL, field_21_01 HIRESTIME ARRAY, field_22_012 HIRESTIME, field_23_0123 UINT16, field_24_01234 INT32, field_25_012345 REAL, field_26_0123456 DATE, field_27_01234567 DATE, field_28_012345678 DATETIME, field_29_0123456789 INT64, field_30_0 UINT64, field_31_01 HIRESTIME, field_32_012 CHAR, field_33_0123 INT16 ARRAY, field_34_01234 BOOL, field_35_012345 DATETIME, field_36_0123456 UINT8, field_37_01234567 INT8 ARRAY, field_38_012345678 INT8 ARRAY, field_39_0123456789 REAL, field_40_0 UINT64 ARRAY, field_41_01 CHAR, field_42_012 DATE ARRAY, field_43_0123 INT32, field_44_01234 CHAR ARRAY, field_45_012345 HIRESTIME, field_46_0123456 CHAR ARRAY, field_47_01234567 CHAR, field_48_012345678 INT64, field_49_0123456789 REAL ARRAY, field_50_0 INT8, field_51_01 HIRESTIME ARRAY, field_52_012 INT8, field_53_0123 CHAR, field_54_01234 CHAR ARRAY)");
      /* 630 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 UINT32, field_3_0123 INT32, field_4_01234 CHAR, field_5_012345 UINT16, field_6_0123456 HIRESTIME, field_7_01234567 INT8, field_8_012345678 UINT16, field_9_0123456789 UINT64, field_10_0 UINT8, field_11_01 INT32, field_12_012 HIRESTIME, field_13_0123 DATE, field_14_01234 INT32, field_15_012345 UINT64, field_16_0123456 CHAR, field_17_01234567 UINT64 ARRAY, field_18_012345678 INT64, field_19_0123456789 RICHREAL, field_20_0 INT16, field_21_01 INT16, field_22_012 DATE, field_23_0123 CHAR ARRAY, field_24_01234 UINT16, field_25_012345 CHAR, field_26_0123456 UINT8, field_27_01234567 INT64, field_28_012345678 DATETIME, field_29_0123456789 DATE, field_30_0 INT32, field_31_01 INT64, field_32_012 HIRESTIME, field_33_0123 DATETIME, field_34_01234 INT8, field_35_012345 INT8, field_36_0123456 DATETIME ARRAY, field_37_01234567 UINT16, field_38_012345678 UINT16 ARRAY, field_39_0123456789 DATE, field_40_0 DATE ARRAY, field_41_01 INT8, field_42_012 UINT8 ARRAY, field_43_0123 INT16, field_44_01234 UINT16, field_45_012345 CHAR)");
      /* 631 */ glbTypes.push_back("TABLE(field_1_01 CHAR ARRAY, field_2_012 HIRESTIME, field_3_0123 RICHREAL, field_4_01234 UINT16, field_5_012345 INT16, field_6_0123456 UINT64, field_7_01234567 INT64, field_8_012345678 UINT64, field_9_0123456789 DATETIME, field_10_0 CHAR, field_11_01 UINT8, field_12_012 CHAR, field_13_0123 UINT16, field_14_01234 BOOL, field_15_012345 INT16, field_16_0123456 CHAR, field_17_01234567 INT32, field_18_012345678 UINT8, field_19_0123456789 INT32, field_20_0 RICHREAL, field_21_01 DATETIME, field_22_012 CHAR, field_23_0123 CHAR, field_24_01234 INT16, field_25_012345 HIRESTIME, field_26_0123456 REAL, field_27_01234567 BOOL, field_28_012345678 CHAR, field_29_0123456789 INT64, field_30_0 DATE, field_31_01 BOOL ARRAY, field_32_012 UINT16, field_33_0123 HIRESTIME, field_34_01234 INT32, field_35_012345 UINT64, field_36_0123456 INT16 ARRAY, field_37_01234567 HIRESTIME, field_38_012345678 RICHREAL, field_39_0123456789 UINT32, field_40_0 HIRESTIME, field_41_01 UINT16, field_42_012 INT16 ARRAY, field_43_0123 HIRESTIME ARRAY, field_44_01234 INT8, field_45_012345 UINT16 ARRAY, field_46_0123456 INT32, field_47_01234567 BOOL, field_48_012345678 UINT8 ARRAY, field_49_0123456789 UINT8 ARRAY, field_50_0 DATETIME, field_51_01 INT16 ARRAY, field_52_012 CHAR ARRAY, field_53_0123 CHAR, field_54_01234 BOOL ARRAY, field_55_012345 INT16, field_56_0123456 UINT8, field_57_01234567 BOOL, field_58_012345678 INT32, field_59_0123456789 INT32, field_60_0 DATE ARRAY, field_61_01 INT32, field_62_012 UINT16, field_63_0123 DATE ARRAY, field_64_01234 INT16, field_65_012345 CHAR ARRAY, field_66_0123456 CHAR, field_67_01234567 REAL, field_68_012345678 HIRESTIME, field_69_0123456789 UINT32, field_70_0 REAL, field_71_01 REAL, field_72_012 INT8, field_73_0123 INT8, field_74_01234 BOOL, field_75_012345 UINT64, field_76_0123456 RICHREAL ARRAY, field_77_01234567 UINT64, field_78_012345678 INT64, field_79_0123456789 INT64, field_80_0 INT8, field_81_01 INT16, field_82_012 UINT64, field_83_0123 INT64, field_84_01234 INT16 ARRAY, field_85_012345 INT8, field_86_0123456 HIRESTIME, field_87_01234567 UINT8, field_88_012345678 INT32 ARRAY, field_89_0123456789 INT8, field_90_0 INT8, field_91_01 BOOL ARRAY, field_92_012 DATE, field_93_0123 DATE ARRAY, field_94_01234 DATETIME ARRAY)");
      /* 632 */ glbTypes.push_back("TABLE(field_1_01 DATE ARRAY, field_2_012 DATE ARRAY, field_3_0123 CHAR, field_4_01234 BOOL ARRAY, field_5_012345 UINT8, field_6_0123456 UINT8 ARRAY, field_7_01234567 CHAR ARRAY, field_8_012345678 UINT16, field_9_0123456789 UINT64, field_10_0 INT16)");
      /* 633 */ glbTypes.push_back("TABLE(field_1_01 UINT32 ARRAY, field_2_012 INT64, field_3_0123 UINT64 ARRAY, field_4_01234 HIRESTIME ARRAY, field_5_012345 REAL ARRAY, field_6_0123456 CHAR ARRAY, field_7_01234567 UINT32, field_8_012345678 INT32, field_9_0123456789 HIRESTIME, field_10_0 UINT32, field_11_01 INT8, field_12_012 BOOL, field_13_0123 RICHREAL, field_14_01234 INT64, field_15_012345 INT8, field_16_0123456 REAL, field_17_01234567 DATE, field_18_012345678 INT8, field_19_0123456789 INT8, field_20_0 INT32, field_21_01 INT64, field_22_012 UINT16, field_23_0123 INT16, field_24_01234 UINT32, field_25_012345 INT16, field_26_0123456 UINT64, field_27_01234567 DATE, field_28_012345678 UINT8, field_29_0123456789 UINT64, field_30_0 INT64, field_31_01 UINT8, field_32_012 UINT16 ARRAY, field_33_0123 UINT64, field_34_01234 INT8, field_35_012345 INT8, field_36_0123456 INT8)");
      /* 634 */ glbTypes.push_back("TABLE(field_1_01 INT16 ARRAY, field_2_012 CHAR, field_3_0123 REAL, field_4_01234 UINT32 ARRAY, field_5_012345 RICHREAL, field_6_0123456 INT32, field_7_01234567 UINT8, field_8_012345678 UINT32, field_9_0123456789 UINT16, field_10_0 UINT32, field_11_01 REAL, field_12_012 HIRESTIME ARRAY, field_13_0123 RICHREAL, field_14_01234 CHAR, field_15_012345 UINT16 ARRAY, field_16_0123456 HIRESTIME, field_17_01234567 INT32, field_18_012345678 INT8 ARRAY, field_19_0123456789 DATETIME, field_20_0 UINT8, field_21_01 UINT8, field_22_012 INT8, field_23_0123 UINT16 ARRAY, field_24_01234 RICHREAL, field_25_012345 UINT8, field_26_0123456 BOOL, field_27_01234567 RICHREAL ARRAY, field_28_012345678 DATE, field_29_0123456789 RICHREAL, field_30_0 UINT64, field_31_01 UINT64, field_32_012 INT16, field_33_0123 INT8, field_34_01234 UINT16, field_35_012345 UINT8, field_36_0123456 CHAR ARRAY, field_37_01234567 DATETIME ARRAY, field_38_012345678 UINT16, field_39_0123456789 UINT8, field_40_0 INT64, field_41_01 INT8 ARRAY, field_42_012 INT16, field_43_0123 BOOL ARRAY, field_44_01234 INT16, field_45_012345 DATETIME, field_46_0123456 BOOL, field_47_01234567 INT16, field_48_012345678 DATE, field_49_0123456789 UINT32, field_50_0 REAL ARRAY, field_51_01 INT16, field_52_012 UINT8, field_53_0123 INT8 ARRAY, field_54_01234 INT64, field_55_012345 HIRESTIME, field_56_0123456 UINT8, field_57_01234567 INT64 ARRAY, field_58_012345678 HIRESTIME ARRAY, field_59_0123456789 UINT16, field_60_0 UINT32, field_61_01 UINT64, field_62_012 CHAR, field_63_0123 INT32, field_64_01234 BOOL, field_65_012345 UINT32, field_66_0123456 BOOL, field_67_01234567 BOOL, field_68_012345678 CHAR, field_69_0123456789 BOOL, field_70_0 REAL, field_71_01 BOOL, field_72_012 REAL ARRAY, field_73_0123 BOOL, field_74_01234 INT32 ARRAY, field_75_012345 UINT16, field_76_0123456 INT16, field_77_01234567 RICHREAL, field_78_012345678 UINT64)");
      /* 635 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 INT16, field_3_0123 INT64, field_4_01234 UINT32, field_5_012345 UINT16, field_6_0123456 INT64, field_7_01234567 HIRESTIME ARRAY, field_8_012345678 UINT32, field_9_0123456789 DATE, field_10_0 RICHREAL ARRAY, field_11_01 BOOL, field_12_012 INT32, field_13_0123 RICHREAL, field_14_01234 INT64, field_15_012345 CHAR, field_16_0123456 INT64, field_17_01234567 UINT8, field_18_012345678 DATE ARRAY, field_19_0123456789 UINT16, field_20_0 UINT8, field_21_01 INT8, field_22_012 INT64, field_23_0123 HIRESTIME, field_24_01234 DATE, field_25_012345 INT64 ARRAY, field_26_0123456 DATE, field_27_01234567 RICHREAL, field_28_012345678 UINT64, field_29_0123456789 RICHREAL, field_30_0 INT16 ARRAY, field_31_01 RICHREAL, field_32_012 BOOL ARRAY, field_33_0123 CHAR ARRAY, field_34_01234 RICHREAL, field_35_012345 INT8, field_36_0123456 INT16, field_37_01234567 UINT64 ARRAY, field_38_012345678 INT16, field_39_0123456789 UINT64, field_40_0 INT32, field_41_01 INT8, field_42_012 INT8, field_43_0123 INT16 ARRAY, field_44_01234 INT64, field_45_012345 INT16, field_46_0123456 BOOL, field_47_01234567 INT64 ARRAY, field_48_012345678 BOOL ARRAY, field_49_0123456789 INT8, field_50_0 BOOL, field_51_01 UINT64, field_52_012 UINT64, field_53_0123 RICHREAL, field_54_01234 INT64, field_55_012345 CHAR, field_56_0123456 DATETIME, field_57_01234567 UINT8, field_58_012345678 INT16, field_59_0123456789 UINT8, field_60_0 INT16, field_61_01 UINT16, field_62_012 DATE, field_63_0123 BOOL, field_64_01234 INT16, field_65_012345 UINT16, field_66_0123456 INT8, field_67_01234567 DATETIME, field_68_012345678 DATE ARRAY, field_69_0123456789 UINT16, field_70_0 UINT32, field_71_01 HIRESTIME, field_72_012 BOOL, field_73_0123 CHAR, field_74_01234 CHAR ARRAY, field_75_012345 UINT8 ARRAY, field_76_0123456 UINT64, field_77_01234567 INT16 ARRAY, field_78_012345678 INT8, field_79_0123456789 UINT16, field_80_0 INT16, field_81_01 INT16 ARRAY, field_82_012 UINT8, field_83_0123 INT64, field_84_01234 INT64, field_85_012345 DATETIME, field_86_0123456 CHAR, field_87_01234567 INT64, field_88_012345678 INT16, field_89_0123456789 DATETIME, field_90_0 UINT16, field_91_01 UINT16 ARRAY)");
      /* 636 */ glbTypes.push_back("TABLE(field_1_01 UINT64 ARRAY, field_2_012 DATE, field_3_0123 INT32)");
      /* 637 */ glbTypes.push_back("TABLE(field_1_01 CHAR ARRAY, field_2_012 INT16, field_3_0123 HIRESTIME, field_4_01234 BOOL, field_5_012345 UINT64, field_6_0123456 HIRESTIME ARRAY, field_7_01234567 HIRESTIME)");
      /* 638 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 INT32, field_3_0123 BOOL, field_4_01234 DATETIME ARRAY, field_5_012345 DATE, field_6_0123456 UINT8, field_7_01234567 REAL, field_8_012345678 REAL, field_9_0123456789 DATETIME, field_10_0 UINT32 ARRAY, field_11_01 REAL, field_12_012 INT16, field_13_0123 CHAR, field_14_01234 UINT32 ARRAY, field_15_012345 INT16, field_16_0123456 BOOL, field_17_01234567 UINT32, field_18_012345678 UINT64, field_19_0123456789 DATE, field_20_0 HIRESTIME, field_21_01 UINT8, field_22_012 UINT64 ARRAY, field_23_0123 UINT16, field_24_01234 BOOL, field_25_012345 RICHREAL, field_26_0123456 DATE, field_27_01234567 DATE, field_28_012345678 INT8 ARRAY, field_29_0123456789 BOOL, field_30_0 UINT64, field_31_01 INT16, field_32_012 BOOL, field_33_0123 HIRESTIME ARRAY, field_34_01234 UINT16, field_35_012345 BOOL, field_36_0123456 UINT32, field_37_01234567 RICHREAL, field_38_012345678 UINT8 ARRAY, field_39_0123456789 UINT64, field_40_0 DATETIME, field_41_01 CHAR, field_42_012 RICHREAL, field_43_0123 INT8, field_44_01234 UINT8, field_45_012345 HIRESTIME ARRAY, field_46_0123456 HIRESTIME, field_47_01234567 INT32, field_48_012345678 HIRESTIME ARRAY, field_49_0123456789 UINT8 ARRAY, field_50_0 DATETIME, field_51_01 REAL, field_52_012 INT64, field_53_0123 INT8, field_54_01234 INT16, field_55_012345 INT32 ARRAY, field_56_0123456 HIRESTIME, field_57_01234567 BOOL ARRAY, field_58_012345678 INT64, field_59_0123456789 BOOL ARRAY, field_60_0 INT32, field_61_01 DATETIME ARRAY, field_62_012 RICHREAL ARRAY, field_63_0123 INT32, field_64_01234 UINT8, field_65_012345 INT8, field_66_0123456 REAL, field_67_01234567 DATETIME, field_68_012345678 HIRESTIME, field_69_0123456789 UINT32, field_70_0 UINT16, field_71_01 DATE, field_72_012 HIRESTIME, field_73_0123 UINT64, field_74_01234 INT16, field_75_012345 BOOL ARRAY, field_76_0123456 UINT64, field_77_01234567 BOOL ARRAY, field_78_012345678 INT32)");
      /* 639 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 BOOL, field_3_0123 INT8, field_4_01234 UINT32 ARRAY, field_5_012345 REAL ARRAY, field_6_0123456 UINT16, field_7_01234567 UINT8, field_8_012345678 DATE ARRAY, field_9_0123456789 DATETIME, field_10_0 RICHREAL, field_11_01 RICHREAL, field_12_012 UINT32)");
      /* 640 */ glbTypes.push_back("TABLE(field_1_01 DATE ARRAY, field_2_012 UINT16 ARRAY, field_3_0123 RICHREAL, field_4_01234 CHAR, field_5_012345 DATETIME, field_6_0123456 UINT8, field_7_01234567 HIRESTIME ARRAY, field_8_012345678 REAL ARRAY, field_9_0123456789 INT8 ARRAY, field_10_0 RICHREAL, field_11_01 INT8, field_12_012 UINT32, field_13_0123 UINT32, field_14_01234 BOOL, field_15_012345 INT64 ARRAY, field_16_0123456 INT16, field_17_01234567 DATE, field_18_012345678 CHAR, field_19_0123456789 DATE, field_20_0 INT32, field_21_01 INT32, field_22_012 INT64, field_23_0123 RICHREAL ARRAY, field_24_01234 UINT8, field_25_012345 RICHREAL, field_26_0123456 INT32, field_27_01234567 BOOL, field_28_012345678 REAL, field_29_0123456789 REAL, field_30_0 REAL, field_31_01 REAL, field_32_012 INT16 ARRAY, field_33_0123 HIRESTIME ARRAY, field_34_01234 REAL ARRAY, field_35_012345 INT16 ARRAY, field_36_0123456 UINT64, field_37_01234567 UINT16, field_38_012345678 DATE, field_39_0123456789 INT16, field_40_0 BOOL, field_41_01 INT64 ARRAY, field_42_012 INT16 ARRAY, field_43_0123 BOOL, field_44_01234 UINT64 ARRAY)");
      /* 641 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 INT64, field_3_0123 CHAR ARRAY, field_4_01234 CHAR, field_5_012345 RICHREAL, field_6_0123456 RICHREAL, field_7_01234567 INT8, field_8_012345678 HIRESTIME ARRAY, field_9_0123456789 REAL, field_10_0 BOOL, field_11_01 UINT32 ARRAY, field_12_012 INT16 ARRAY, field_13_0123 CHAR, field_14_01234 CHAR, field_15_012345 INT8, field_16_0123456 INT32, field_17_01234567 INT8, field_18_012345678 INT16, field_19_0123456789 INT16, field_20_0 UINT64, field_21_01 DATE, field_22_012 UINT16, field_23_0123 RICHREAL, field_24_01234 BOOL, field_25_012345 BOOL, field_26_0123456 INT32, field_27_01234567 INT16, field_28_012345678 INT8, field_29_0123456789 CHAR, field_30_0 INT16, field_31_01 RICHREAL, field_32_012 BOOL, field_33_0123 UINT8 ARRAY, field_34_01234 BOOL, field_35_012345 CHAR, field_36_0123456 UINT16, field_37_01234567 REAL, field_38_012345678 BOOL)");
      /* 642 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 INT16, field_3_0123 UINT8, field_4_01234 DATE, field_5_012345 UINT8, field_6_0123456 BOOL, field_7_01234567 INT32, field_8_012345678 BOOL, field_9_0123456789 DATETIME, field_10_0 HIRESTIME, field_11_01 INT32, field_12_012 BOOL, field_13_0123 INT64, field_14_01234 HIRESTIME ARRAY, field_15_012345 BOOL, field_16_0123456 DATE, field_17_01234567 RICHREAL, field_18_012345678 INT8 ARRAY, field_19_0123456789 BOOL, field_20_0 UINT16, field_21_01 DATE, field_22_012 INT8, field_23_0123 BOOL, field_24_01234 INT16, field_25_012345 INT16, field_26_0123456 BOOL ARRAY, field_27_01234567 INT8, field_28_012345678 INT16, field_29_0123456789 UINT32 ARRAY, field_30_0 RICHREAL, field_31_01 BOOL, field_32_012 DATETIME, field_33_0123 BOOL, field_34_01234 UINT32 ARRAY, field_35_012345 INT8, field_36_0123456 CHAR, field_37_01234567 HIRESTIME, field_38_012345678 UINT32, field_39_0123456789 INT8, field_40_0 INT8 ARRAY, field_41_01 UINT32 ARRAY, field_42_012 UINT64, field_43_0123 REAL, field_44_01234 INT64 ARRAY, field_45_012345 INT32 ARRAY, field_46_0123456 INT16, field_47_01234567 HIRESTIME, field_48_012345678 UINT16, field_49_0123456789 UINT32 ARRAY, field_50_0 UINT8, field_51_01 RICHREAL ARRAY, field_52_012 UINT16, field_53_0123 BOOL, field_54_01234 INT16 ARRAY, field_55_012345 UINT32, field_56_0123456 BOOL ARRAY, field_57_01234567 DATE, field_58_012345678 DATETIME ARRAY, field_59_0123456789 INT32 ARRAY, field_60_0 UINT64, field_61_01 DATETIME ARRAY, field_62_012 REAL)");
      /* 643 */ glbTypes.push_back("TABLE(field_1_01 UINT32 ARRAY, field_2_012 CHAR ARRAY, field_3_0123 CHAR, field_4_01234 INT32, field_5_012345 INT8, field_6_0123456 REAL, field_7_01234567 CHAR, field_8_012345678 UINT64, field_9_0123456789 UINT64, field_10_0 REAL ARRAY, field_11_01 BOOL, field_12_012 UINT16, field_13_0123 HIRESTIME, field_14_01234 DATETIME, field_15_012345 DATETIME, field_16_0123456 INT64 ARRAY, field_17_01234567 UINT32, field_18_012345678 HIRESTIME, field_19_0123456789 DATETIME, field_20_0 DATETIME ARRAY, field_21_01 REAL, field_22_012 INT16, field_23_0123 UINT64, field_24_01234 INT8 ARRAY, field_25_012345 DATETIME ARRAY, field_26_0123456 UINT64, field_27_01234567 UINT16, field_28_012345678 RICHREAL, field_29_0123456789 UINT32, field_30_0 UINT16, field_31_01 RICHREAL ARRAY, field_32_012 CHAR, field_33_0123 INT32, field_34_01234 BOOL, field_35_012345 DATETIME, field_36_0123456 REAL ARRAY, field_37_01234567 HIRESTIME, field_38_012345678 INT8, field_39_0123456789 UINT16, field_40_0 DATE, field_41_01 INT8 ARRAY, field_42_012 UINT64, field_43_0123 HIRESTIME, field_44_01234 REAL, field_45_012345 CHAR, field_46_0123456 INT8, field_47_01234567 BOOL, field_48_012345678 UINT16, field_49_0123456789 DATETIME, field_50_0 INT8, field_51_01 INT64, field_52_012 INT8, field_53_0123 CHAR, field_54_01234 UINT64, field_55_012345 UINT8)");
      /* 644 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 INT32, field_3_0123 HIRESTIME ARRAY, field_4_01234 BOOL, field_5_012345 REAL ARRAY, field_6_0123456 REAL)");
      /* 645 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 DATETIME, field_3_0123 DATE, field_4_01234 INT32 ARRAY, field_5_012345 HIRESTIME ARRAY, field_6_0123456 UINT16, field_7_01234567 BOOL, field_8_012345678 REAL ARRAY, field_9_0123456789 UINT32, field_10_0 UINT64 ARRAY, field_11_01 CHAR, field_12_012 DATE, field_13_0123 INT32, field_14_01234 BOOL, field_15_012345 RICHREAL ARRAY, field_16_0123456 INT8, field_17_01234567 UINT8, field_18_012345678 INT8, field_19_0123456789 DATE ARRAY, field_20_0 DATE, field_21_01 INT16, field_22_012 HIRESTIME, field_23_0123 INT32, field_24_01234 BOOL, field_25_012345 CHAR ARRAY, field_26_0123456 CHAR, field_27_01234567 RICHREAL, field_28_012345678 UINT16 ARRAY, field_29_0123456789 CHAR, field_30_0 DATETIME, field_31_01 BOOL, field_32_012 INT8, field_33_0123 BOOL, field_34_01234 HIRESTIME, field_35_012345 INT16, field_36_0123456 DATETIME)");
      /* 646 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 CHAR ARRAY, field_3_0123 INT32 ARRAY, field_4_01234 INT64, field_5_012345 REAL, field_6_0123456 REAL, field_7_01234567 INT16, field_8_012345678 CHAR, field_9_0123456789 INT8 ARRAY, field_10_0 DATE, field_11_01 BOOL, field_12_012 UINT16, field_13_0123 INT32 ARRAY, field_14_01234 RICHREAL, field_15_012345 UINT8, field_16_0123456 RICHREAL, field_17_01234567 UINT32 ARRAY, field_18_012345678 BOOL ARRAY, field_19_0123456789 DATE, field_20_0 DATE ARRAY, field_21_01 DATE, field_22_012 INT16, field_23_0123 HIRESTIME, field_24_01234 CHAR ARRAY, field_25_012345 INT8, field_26_0123456 BOOL, field_27_01234567 INT32 ARRAY, field_28_012345678 UINT8, field_29_0123456789 DATETIME, field_30_0 HIRESTIME, field_31_01 BOOL ARRAY, field_32_012 HIRESTIME ARRAY, field_33_0123 UINT32, field_34_01234 INT8, field_35_012345 BOOL, field_36_0123456 DATETIME, field_37_01234567 DATETIME, field_38_012345678 UINT8, field_39_0123456789 CHAR ARRAY, field_40_0 INT64, field_41_01 HIRESTIME, field_42_012 UINT16 ARRAY, field_43_0123 RICHREAL ARRAY, field_44_01234 INT64, field_45_012345 INT16, field_46_0123456 CHAR, field_47_01234567 REAL, field_48_012345678 UINT64, field_49_0123456789 INT64, field_50_0 INT8 ARRAY, field_51_01 RICHREAL, field_52_012 INT64, field_53_0123 DATETIME, field_54_01234 DATE, field_55_012345 INT64 ARRAY, field_56_0123456 DATE, field_57_01234567 INT16, field_58_012345678 UINT16, field_59_0123456789 INT8, field_60_0 REAL, field_61_01 BOOL, field_62_012 HIRESTIME, field_63_0123 RICHREAL ARRAY, field_64_01234 REAL, field_65_012345 DATE ARRAY, field_66_0123456 REAL, field_67_01234567 DATE, field_68_012345678 INT64 ARRAY, field_69_0123456789 INT8)");
      /* 647 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 BOOL, field_3_0123 INT16 ARRAY, field_4_01234 INT16, field_5_012345 INT32, field_6_0123456 INT16 ARRAY, field_7_01234567 INT64, field_8_012345678 UINT8)");
      /* 648 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 RICHREAL, field_3_0123 UINT32, field_4_01234 UINT16, field_5_012345 INT16 ARRAY, field_6_0123456 RICHREAL, field_7_01234567 DATETIME, field_8_012345678 UINT32, field_9_0123456789 HIRESTIME, field_10_0 REAL, field_11_01 UINT16 ARRAY, field_12_012 CHAR, field_13_0123 UINT64, field_14_01234 INT8 ARRAY, field_15_012345 UINT64, field_16_0123456 DATE, field_17_01234567 HIRESTIME, field_18_012345678 UINT8, field_19_0123456789 UINT8, field_20_0 UINT64, field_21_01 INT16, field_22_012 UINT8, field_23_0123 INT64 ARRAY, field_24_01234 INT8 ARRAY, field_25_012345 CHAR, field_26_0123456 CHAR, field_27_01234567 UINT8, field_28_012345678 CHAR, field_29_0123456789 DATE, field_30_0 BOOL, field_31_01 REAL, field_32_012 INT16, field_33_0123 INT8, field_34_01234 INT16, field_35_012345 DATETIME ARRAY, field_36_0123456 INT8, field_37_01234567 HIRESTIME, field_38_012345678 CHAR ARRAY, field_39_0123456789 INT16, field_40_0 CHAR ARRAY, field_41_01 UINT16, field_42_012 CHAR, field_43_0123 RICHREAL, field_44_01234 INT64, field_45_012345 INT16, field_46_0123456 CHAR, field_47_01234567 RICHREAL, field_48_012345678 DATETIME, field_49_0123456789 INT8, field_50_0 CHAR, field_51_01 RICHREAL, field_52_012 UINT8, field_53_0123 CHAR, field_54_01234 HIRESTIME ARRAY, field_55_012345 CHAR, field_56_0123456 UINT32 ARRAY, field_57_01234567 INT64, field_58_012345678 INT32, field_59_0123456789 RICHREAL, field_60_0 INT32, field_61_01 INT32, field_62_012 INT32 ARRAY, field_63_0123 DATE, field_64_01234 UINT32, field_65_012345 UINT32 ARRAY)");
      /* 649 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 DATETIME, field_3_0123 BOOL, field_4_01234 UINT16, field_5_012345 DATE ARRAY, field_6_0123456 DATETIME, field_7_01234567 UINT16 ARRAY, field_8_012345678 DATE, field_9_0123456789 INT64, field_10_0 REAL ARRAY, field_11_01 INT64, field_12_012 UINT64, field_13_0123 UINT8, field_14_01234 DATE, field_15_012345 DATE, field_16_0123456 UINT8, field_17_01234567 INT8, field_18_012345678 CHAR, field_19_0123456789 INT64, field_20_0 BOOL, field_21_01 DATETIME, field_22_012 BOOL, field_23_0123 BOOL, field_24_01234 DATETIME, field_25_012345 DATETIME, field_26_0123456 RICHREAL, field_27_01234567 RICHREAL, field_28_012345678 BOOL, field_29_0123456789 DATE ARRAY, field_30_0 INT32, field_31_01 INT16 ARRAY, field_32_012 INT32, field_33_0123 CHAR, field_34_01234 INT16, field_35_012345 REAL, field_36_0123456 INT32, field_37_01234567 UINT16, field_38_012345678 RICHREAL ARRAY, field_39_0123456789 UINT8, field_40_0 UINT64, field_41_01 CHAR ARRAY, field_42_012 REAL, field_43_0123 BOOL, field_44_01234 INT32, field_45_012345 HIRESTIME, field_46_0123456 INT32, field_47_01234567 UINT8, field_48_012345678 UINT8 ARRAY, field_49_0123456789 HIRESTIME, field_50_0 DATE, field_51_01 DATE ARRAY, field_52_012 INT16, field_53_0123 UINT32, field_54_01234 DATETIME ARRAY, field_55_012345 REAL, field_56_0123456 DATE, field_57_01234567 CHAR ARRAY, field_58_012345678 UINT8, field_59_0123456789 INT64, field_60_0 INT32 ARRAY, field_61_01 UINT16, field_62_012 RICHREAL, field_63_0123 CHAR, field_64_01234 DATE, field_65_012345 REAL ARRAY, field_66_0123456 INT8, field_67_01234567 UINT16, field_68_012345678 INT32, field_69_0123456789 HIRESTIME, field_70_0 DATETIME, field_71_01 RICHREAL, field_72_012 UINT32, field_73_0123 BOOL ARRAY, field_74_01234 DATETIME)");
      /* 650 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 UINT8, field_3_0123 UINT32, field_4_01234 REAL, field_5_012345 REAL ARRAY, field_6_0123456 DATETIME, field_7_01234567 UINT32, field_8_012345678 UINT16, field_9_0123456789 BOOL, field_10_0 BOOL, field_11_01 RICHREAL, field_12_012 UINT8, field_13_0123 DATE ARRAY, field_14_01234 DATETIME ARRAY, field_15_012345 BOOL ARRAY, field_16_0123456 INT64, field_17_01234567 UINT8, field_18_012345678 DATE ARRAY, field_19_0123456789 UINT64 ARRAY, field_20_0 REAL, field_21_01 UINT8, field_22_012 DATE ARRAY, field_23_0123 INT64, field_24_01234 UINT64, field_25_012345 UINT8, field_26_0123456 UINT8 ARRAY, field_27_01234567 REAL, field_28_012345678 UINT8, field_29_0123456789 CHAR, field_30_0 INT8 ARRAY, field_31_01 CHAR ARRAY, field_32_012 INT32, field_33_0123 DATE, field_34_01234 HIRESTIME, field_35_012345 UINT64, field_36_0123456 DATE, field_37_01234567 DATE, field_38_012345678 RICHREAL ARRAY, field_39_0123456789 HIRESTIME, field_40_0 INT64, field_41_01 DATETIME, field_42_012 INT16, field_43_0123 UINT16, field_44_01234 UINT16, field_45_012345 UINT32, field_46_0123456 RICHREAL, field_47_01234567 DATE, field_48_012345678 CHAR ARRAY, field_49_0123456789 INT32, field_50_0 REAL ARRAY, field_51_01 UINT32 ARRAY, field_52_012 REAL, field_53_0123 BOOL, field_54_01234 INT64, field_55_012345 UINT32 ARRAY, field_56_0123456 INT16, field_57_01234567 REAL)");
      /* 651 */ glbTypes.push_back("TABLE(field_1_01 DATE ARRAY, field_2_012 INT64, field_3_0123 INT32, field_4_01234 HIRESTIME ARRAY, field_5_012345 BOOL, field_6_0123456 REAL, field_7_01234567 UINT64, field_8_012345678 INT32, field_9_0123456789 RICHREAL ARRAY, field_10_0 BOOL ARRAY, field_11_01 UINT64, field_12_012 UINT64, field_13_0123 DATE ARRAY, field_14_01234 INT32, field_15_012345 DATE ARRAY, field_16_0123456 UINT32, field_17_01234567 CHAR, field_18_012345678 DATE ARRAY, field_19_0123456789 BOOL, field_20_0 HIRESTIME, field_21_01 REAL, field_22_012 INT16, field_23_0123 REAL, field_24_01234 CHAR, field_25_012345 INT16, field_26_0123456 HIRESTIME, field_27_01234567 INT8)");
      /* 652 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 BOOL, field_3_0123 INT32, field_4_01234 RICHREAL ARRAY, field_5_012345 INT64, field_6_0123456 INT32, field_7_01234567 UINT32, field_8_012345678 HIRESTIME, field_9_0123456789 REAL, field_10_0 INT32, field_11_01 UINT16 ARRAY, field_12_012 DATETIME, field_13_0123 UINT8, field_14_01234 UINT64, field_15_012345 UINT64 ARRAY, field_16_0123456 RICHREAL ARRAY, field_17_01234567 CHAR, field_18_012345678 INT8, field_19_0123456789 UINT32 ARRAY, field_20_0 INT16, field_21_01 INT16, field_22_012 INT32, field_23_0123 INT32, field_24_01234 INT64 ARRAY, field_25_012345 DATETIME, field_26_0123456 CHAR, field_27_01234567 INT8, field_28_012345678 REAL, field_29_0123456789 UINT64, field_30_0 INT32, field_31_01 BOOL, field_32_012 UINT8, field_33_0123 UINT64)");
      /* 653 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 UINT16, field_3_0123 BOOL ARRAY, field_4_01234 UINT64, field_5_012345 RICHREAL, field_6_0123456 DATETIME, field_7_01234567 UINT16, field_8_012345678 HIRESTIME, field_9_0123456789 UINT32 ARRAY, field_10_0 INT16, field_11_01 INT16 ARRAY, field_12_012 CHAR, field_13_0123 INT64, field_14_01234 INT16, field_15_012345 INT32, field_16_0123456 REAL, field_17_01234567 DATETIME, field_18_012345678 HIRESTIME, field_19_0123456789 INT32 ARRAY, field_20_0 DATE ARRAY, field_21_01 UINT8, field_22_012 INT16, field_23_0123 UINT8, field_24_01234 DATETIME, field_25_012345 HIRESTIME, field_26_0123456 HIRESTIME ARRAY, field_27_01234567 INT64, field_28_012345678 INT16, field_29_0123456789 DATE, field_30_0 UINT8, field_31_01 DATE, field_32_012 CHAR ARRAY, field_33_0123 UINT32, field_34_01234 INT32, field_35_012345 REAL ARRAY, field_36_0123456 HIRESTIME, field_37_01234567 INT32 ARRAY, field_38_012345678 RICHREAL ARRAY, field_39_0123456789 BOOL, field_40_0 RICHREAL, field_41_01 CHAR, field_42_012 INT64, field_43_0123 UINT32, field_44_01234 HIRESTIME ARRAY, field_45_012345 INT64, field_46_0123456 UINT8 ARRAY, field_47_01234567 UINT16, field_48_012345678 CHAR ARRAY, field_49_0123456789 UINT16, field_50_0 BOOL, field_51_01 UINT16 ARRAY, field_52_012 DATETIME, field_53_0123 CHAR, field_54_01234 INT8, field_55_012345 DATE)");
      /* 654 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 UINT32, field_3_0123 UINT16, field_4_01234 INT32, field_5_012345 UINT64, field_6_0123456 UINT8, field_7_01234567 INT64, field_8_012345678 INT16, field_9_0123456789 HIRESTIME, field_10_0 INT16, field_11_01 UINT8 ARRAY, field_12_012 DATETIME, field_13_0123 CHAR, field_14_01234 UINT8, field_15_012345 DATE, field_16_0123456 INT16, field_17_01234567 INT32 ARRAY, field_18_012345678 HIRESTIME ARRAY, field_19_0123456789 INT64, field_20_0 INT16, field_21_01 INT32, field_22_012 HIRESTIME)");
      /* 655 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 UINT16, field_3_0123 UINT32, field_4_01234 UINT64, field_5_012345 DATE ARRAY, field_6_0123456 REAL, field_7_01234567 HIRESTIME ARRAY, field_8_012345678 HIRESTIME ARRAY, field_9_0123456789 HIRESTIME ARRAY, field_10_0 DATETIME ARRAY, field_11_01 HIRESTIME, field_12_012 REAL, field_13_0123 INT8, field_14_01234 UINT16, field_15_012345 DATETIME, field_16_0123456 UINT16, field_17_01234567 UINT32 ARRAY, field_18_012345678 DATETIME, field_19_0123456789 REAL, field_20_0 BOOL, field_21_01 CHAR, field_22_012 DATE, field_23_0123 UINT16, field_24_01234 UINT16, field_25_012345 INT16, field_26_0123456 INT8, field_27_01234567 DATETIME, field_28_012345678 BOOL, field_29_0123456789 UINT32 ARRAY, field_30_0 INT32, field_31_01 INT16, field_32_012 INT64, field_33_0123 RICHREAL, field_34_01234 DATE, field_35_012345 INT64, field_36_0123456 INT64 ARRAY, field_37_01234567 INT32, field_38_012345678 UINT8, field_39_0123456789 INT16, field_40_0 BOOL, field_41_01 UINT16, field_42_012 REAL, field_43_0123 INT64, field_44_01234 RICHREAL, field_45_012345 UINT16, field_46_0123456 RICHREAL, field_47_01234567 REAL ARRAY, field_48_012345678 INT8, field_49_0123456789 DATETIME, field_50_0 CHAR ARRAY, field_51_01 INT64, field_52_012 UINT64, field_53_0123 HIRESTIME, field_54_01234 UINT32, field_55_012345 INT32, field_56_0123456 UINT32, field_57_01234567 INT16, field_58_012345678 INT16, field_59_0123456789 UINT32, field_60_0 DATETIME ARRAY, field_61_01 UINT16, field_62_012 INT32, field_63_0123 CHAR ARRAY, field_64_01234 HIRESTIME, field_65_012345 REAL, field_66_0123456 INT64, field_67_01234567 REAL, field_68_012345678 INT32, field_69_0123456789 UINT8 ARRAY, field_70_0 INT8, field_71_01 UINT8, field_72_012 INT32, field_73_0123 INT32 ARRAY, field_74_01234 INT32, field_75_012345 INT64, field_76_0123456 INT16, field_77_01234567 UINT64, field_78_012345678 UINT8, field_79_0123456789 UINT64, field_80_0 UINT16, field_81_01 INT32 ARRAY, field_82_012 INT64 ARRAY, field_83_0123 INT64 ARRAY, field_84_01234 UINT16, field_85_012345 INT64, field_86_0123456 RICHREAL, field_87_01234567 UINT32, field_88_012345678 UINT16, field_89_0123456789 UINT64 ARRAY, field_90_0 INT32, field_91_01 DATETIME ARRAY)");
      /* 656 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 UINT16, field_3_0123 UINT32, field_4_01234 RICHREAL, field_5_012345 INT16, field_6_0123456 UINT8, field_7_01234567 HIRESTIME, field_8_012345678 RICHREAL, field_9_0123456789 REAL, field_10_0 HIRESTIME ARRAY, field_11_01 INT16 ARRAY, field_12_012 INT32, field_13_0123 DATE)");
      /* 657 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 INT16, field_3_0123 UINT64, field_4_01234 INT64, field_5_012345 BOOL, field_6_0123456 HIRESTIME, field_7_01234567 INT64, field_8_012345678 HIRESTIME ARRAY, field_9_0123456789 INT32, field_10_0 HIRESTIME, field_11_01 INT32 ARRAY, field_12_012 INT32, field_13_0123 DATETIME, field_14_01234 INT8, field_15_012345 INT32, field_16_0123456 INT8, field_17_01234567 BOOL, field_18_012345678 CHAR ARRAY, field_19_0123456789 UINT16, field_20_0 HIRESTIME, field_21_01 CHAR, field_22_012 DATETIME, field_23_0123 DATE, field_24_01234 INT32 ARRAY, field_25_012345 INT8, field_26_0123456 INT64, field_27_01234567 UINT32, field_28_012345678 RICHREAL, field_29_0123456789 UINT64, field_30_0 RICHREAL, field_31_01 INT8, field_32_012 INT16, field_33_0123 HIRESTIME, field_34_01234 CHAR, field_35_012345 RICHREAL ARRAY, field_36_0123456 REAL ARRAY, field_37_01234567 INT16, field_38_012345678 REAL, field_39_0123456789 HIRESTIME, field_40_0 UINT16, field_41_01 INT64, field_42_012 DATETIME, field_43_0123 INT32, field_44_01234 RICHREAL, field_45_012345 CHAR, field_46_0123456 UINT32, field_47_01234567 INT32, field_48_012345678 DATE, field_49_0123456789 BOOL, field_50_0 INT64, field_51_01 INT32, field_52_012 HIRESTIME, field_53_0123 DATE ARRAY, field_54_01234 UINT64 ARRAY, field_55_012345 HIRESTIME, field_56_0123456 DATE, field_57_01234567 UINT8, field_58_012345678 CHAR ARRAY, field_59_0123456789 CHAR)");
      /* 658 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 UINT64, field_3_0123 INT32, field_4_01234 INT64 ARRAY, field_5_012345 RICHREAL, field_6_0123456 UINT8, field_7_01234567 UINT16 ARRAY, field_8_012345678 UINT16 ARRAY, field_9_0123456789 INT16, field_10_0 UINT8, field_11_01 UINT64, field_12_012 UINT64, field_13_0123 INT64, field_14_01234 INT8 ARRAY, field_15_012345 UINT64, field_16_0123456 INT32, field_17_01234567 INT64, field_18_012345678 INT64, field_19_0123456789 REAL, field_20_0 INT32 ARRAY, field_21_01 INT32, field_22_012 UINT8, field_23_0123 INT8, field_24_01234 UINT64 ARRAY, field_25_012345 CHAR, field_26_0123456 UINT16, field_27_01234567 UINT8, field_28_012345678 DATE, field_29_0123456789 UINT64, field_30_0 BOOL, field_31_01 UINT8, field_32_012 CHAR, field_33_0123 DATE, field_34_01234 CHAR, field_35_012345 INT16, field_36_0123456 INT16, field_37_01234567 HIRESTIME, field_38_012345678 REAL ARRAY, field_39_0123456789 INT8, field_40_0 INT64 ARRAY, field_41_01 BOOL, field_42_012 UINT64)");
      /* 659 */ glbTypes.push_back("TABLE");
      /* 660 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 DATE ARRAY, field_3_0123 INT16, field_4_01234 DATE, field_5_012345 UINT32, field_6_0123456 DATE ARRAY, field_7_01234567 BOOL, field_8_012345678 UINT16, field_9_0123456789 DATETIME, field_10_0 INT64, field_11_01 DATE, field_12_012 REAL, field_13_0123 RICHREAL ARRAY, field_14_01234 DATE ARRAY, field_15_012345 INT16 ARRAY, field_16_0123456 INT32, field_17_01234567 INT64, field_18_012345678 INT8, field_19_0123456789 DATETIME, field_20_0 INT64, field_21_01 UINT8, field_22_012 UINT8, field_23_0123 BOOL, field_24_01234 DATETIME ARRAY, field_25_012345 HIRESTIME, field_26_0123456 CHAR, field_27_01234567 UINT8, field_28_012345678 DATETIME, field_29_0123456789 CHAR, field_30_0 UINT16, field_31_01 CHAR, field_32_012 UINT32 ARRAY, field_33_0123 UINT16, field_34_01234 INT8 ARRAY, field_35_012345 UINT16, field_36_0123456 CHAR ARRAY, field_37_01234567 DATE, field_38_012345678 REAL, field_39_0123456789 HIRESTIME ARRAY, field_40_0 UINT64, field_41_01 CHAR ARRAY, field_42_012 INT16, field_43_0123 INT32, field_44_01234 INT32, field_45_012345 BOOL, field_46_0123456 INT8, field_47_01234567 INT64, field_48_012345678 UINT16 ARRAY, field_49_0123456789 BOOL, field_50_0 UINT64, field_51_01 UINT64, field_52_012 HIRESTIME, field_53_0123 INT32, field_54_01234 UINT32, field_55_012345 RICHREAL, field_56_0123456 DATETIME, field_57_01234567 INT8, field_58_012345678 UINT8, field_59_0123456789 BOOL, field_60_0 INT16 ARRAY, field_61_01 REAL, field_62_012 UINT8, field_63_0123 INT32 ARRAY, field_64_01234 HIRESTIME, field_65_012345 DATE, field_66_0123456 UINT8, field_67_01234567 INT64, field_68_012345678 CHAR, field_69_0123456789 HIRESTIME, field_70_0 HIRESTIME, field_71_01 HIRESTIME, field_72_012 RICHREAL ARRAY, field_73_0123 UINT64, field_74_01234 UINT8, field_75_012345 UINT64, field_76_0123456 UINT64, field_77_01234567 RICHREAL ARRAY, field_78_012345678 UINT16, field_79_0123456789 REAL, field_80_0 HIRESTIME, field_81_01 UINT32, field_82_012 UINT32, field_83_0123 BOOL, field_84_01234 UINT16 ARRAY, field_85_012345 INT16, field_86_0123456 HIRESTIME, field_87_01234567 CHAR, field_88_012345678 BOOL, field_89_0123456789 INT32 ARRAY, field_90_0 HIRESTIME, field_91_01 INT8, field_92_012 INT32 ARRAY, field_93_0123 UINT8, field_94_01234 REAL, field_95_012345 DATE)");
      /* 661 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 HIRESTIME ARRAY, field_3_0123 BOOL, field_4_01234 CHAR ARRAY, field_5_012345 CHAR ARRAY, field_6_0123456 DATE, field_7_01234567 REAL ARRAY, field_8_012345678 BOOL, field_9_0123456789 UINT8, field_10_0 DATE, field_11_01 DATETIME, field_12_012 INT8, field_13_0123 UINT64, field_14_01234 INT16, field_15_012345 UINT16, field_16_0123456 CHAR ARRAY, field_17_01234567 CHAR, field_18_012345678 DATE, field_19_0123456789 INT16, field_20_0 INT32, field_21_01 UINT32, field_22_012 RICHREAL, field_23_0123 REAL ARRAY, field_24_01234 UINT64, field_25_012345 INT64, field_26_0123456 CHAR, field_27_01234567 UINT8 ARRAY, field_28_012345678 UINT8, field_29_0123456789 HIRESTIME, field_30_0 INT16, field_31_01 INT64, field_32_012 INT32, field_33_0123 UINT16, field_34_01234 UINT64, field_35_012345 DATE, field_36_0123456 REAL, field_37_01234567 INT8, field_38_012345678 INT8, field_39_0123456789 HIRESTIME, field_40_0 UINT8, field_41_01 INT8 ARRAY, field_42_012 UINT64 ARRAY, field_43_0123 DATE, field_44_01234 INT16, field_45_012345 CHAR, field_46_0123456 REAL ARRAY, field_47_01234567 INT32, field_48_012345678 HIRESTIME ARRAY, field_49_0123456789 BOOL, field_50_0 DATE, field_51_01 CHAR ARRAY, field_52_012 UINT32, field_53_0123 DATE, field_54_01234 RICHREAL, field_55_012345 UINT16, field_56_0123456 UINT16, field_57_01234567 UINT32, field_58_012345678 UINT64, field_59_0123456789 INT64, field_60_0 REAL ARRAY, field_61_01 HIRESTIME, field_62_012 UINT16 ARRAY, field_63_0123 INT16, field_64_01234 UINT16, field_65_012345 UINT16, field_66_0123456 UINT16, field_67_01234567 INT16, field_68_012345678 CHAR, field_69_0123456789 UINT8 ARRAY, field_70_0 INT8, field_71_01 DATETIME, field_72_012 UINT16, field_73_0123 HIRESTIME, field_74_01234 INT8)");
      /* 662 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 HIRESTIME, field_3_0123 UINT64 ARRAY, field_4_01234 UINT16, field_5_012345 UINT64 ARRAY, field_6_0123456 DATE, field_7_01234567 DATETIME, field_8_012345678 DATETIME, field_9_0123456789 UINT64, field_10_0 UINT64, field_11_01 DATE, field_12_012 UINT8, field_13_0123 INT8)");
      /* 663 */ glbTypes.push_back("TABLE(field_1_01 CHAR ARRAY, field_2_012 UINT64, field_3_0123 BOOL, field_4_01234 INT16, field_5_012345 RICHREAL, field_6_0123456 UINT32, field_7_01234567 RICHREAL, field_8_012345678 INT64 ARRAY, field_9_0123456789 INT8, field_10_0 INT16, field_11_01 BOOL, field_12_012 HIRESTIME, field_13_0123 HIRESTIME, field_14_01234 DATETIME, field_15_012345 HIRESTIME, field_16_0123456 DATE, field_17_01234567 INT32, field_18_012345678 HIRESTIME, field_19_0123456789 INT16, field_20_0 RICHREAL ARRAY, field_21_01 CHAR, field_22_012 UINT32, field_23_0123 DATETIME, field_24_01234 DATETIME, field_25_012345 UINT64, field_26_0123456 INT64, field_27_01234567 HIRESTIME, field_28_012345678 UINT16 ARRAY, field_29_0123456789 INT64, field_30_0 BOOL, field_31_01 DATE, field_32_012 RICHREAL, field_33_0123 BOOL, field_34_01234 RICHREAL ARRAY, field_35_012345 RICHREAL, field_36_0123456 HIRESTIME, field_37_01234567 DATE, field_38_012345678 RICHREAL)");
      /* 664 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 HIRESTIME ARRAY, field_3_0123 BOOL, field_4_01234 BOOL, field_5_012345 INT8, field_6_0123456 INT8, field_7_01234567 DATETIME, field_8_012345678 UINT64, field_9_0123456789 UINT8, field_10_0 DATE, field_11_01 HIRESTIME, field_12_012 INT64 ARRAY, field_13_0123 INT16, field_14_01234 CHAR, field_15_012345 BOOL, field_16_0123456 CHAR, field_17_01234567 UINT64, field_18_012345678 INT8, field_19_0123456789 BOOL, field_20_0 DATETIME, field_21_01 REAL, field_22_012 UINT8 ARRAY, field_23_0123 UINT16 ARRAY, field_24_01234 HIRESTIME, field_25_012345 REAL ARRAY, field_26_0123456 BOOL, field_27_01234567 INT32, field_28_012345678 DATE ARRAY, field_29_0123456789 INT8, field_30_0 INT64, field_31_01 UINT8, field_32_012 UINT32, field_33_0123 UINT32, field_34_01234 DATETIME, field_35_012345 INT16, field_36_0123456 CHAR, field_37_01234567 DATETIME)");
      /* 665 */ glbTypes.push_back("TABLE(field_1_01 INT8 ARRAY, field_2_012 CHAR ARRAY, field_3_0123 UINT64 ARRAY, field_4_01234 DATE, field_5_012345 RICHREAL, field_6_0123456 UINT32, field_7_01234567 INT32, field_8_012345678 HIRESTIME, field_9_0123456789 INT64, field_10_0 BOOL, field_11_01 HIRESTIME, field_12_012 UINT64 ARRAY, field_13_0123 DATE, field_14_01234 INT8 ARRAY, field_15_012345 HIRESTIME, field_16_0123456 INT8, field_17_01234567 UINT32, field_18_012345678 UINT32, field_19_0123456789 INT64, field_20_0 INT32, field_21_01 BOOL, field_22_012 BOOL, field_23_0123 DATE, field_24_01234 DATE, field_25_012345 INT16, field_26_0123456 INT16, field_27_01234567 INT32 ARRAY, field_28_012345678 INT8, field_29_0123456789 INT64, field_30_0 DATE, field_31_01 INT16, field_32_012 UINT16 ARRAY, field_33_0123 DATETIME, field_34_01234 REAL, field_35_012345 REAL, field_36_0123456 INT32, field_37_01234567 HIRESTIME, field_38_012345678 UINT8, field_39_0123456789 INT8, field_40_0 HIRESTIME, field_41_01 UINT16, field_42_012 DATE ARRAY, field_43_0123 DATETIME ARRAY, field_44_01234 INT64, field_45_012345 UINT64, field_46_0123456 INT16, field_47_01234567 REAL, field_48_012345678 CHAR, field_49_0123456789 INT32 ARRAY, field_50_0 REAL, field_51_01 INT32, field_52_012 HIRESTIME, field_53_0123 INT64, field_54_01234 UINT8, field_55_012345 INT8, field_56_0123456 DATETIME, field_57_01234567 UINT8, field_58_012345678 HIRESTIME ARRAY, field_59_0123456789 DATETIME, field_60_0 UINT16, field_61_01 HIRESTIME ARRAY, field_62_012 INT32, field_63_0123 REAL, field_64_01234 HIRESTIME, field_65_012345 UINT32, field_66_0123456 INT64 ARRAY, field_67_01234567 INT32, field_68_012345678 CHAR, field_69_0123456789 INT16 ARRAY, field_70_0 DATE, field_71_01 INT32, field_72_012 CHAR ARRAY, field_73_0123 DATETIME)");
      /* 666 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 UINT64 ARRAY, field_3_0123 DATE, field_4_01234 INT16, field_5_012345 REAL, field_6_0123456 INT8, field_7_01234567 UINT32, field_8_012345678 INT8, field_9_0123456789 DATETIME, field_10_0 DATETIME, field_11_01 RICHREAL, field_12_012 INT16, field_13_0123 CHAR, field_14_01234 UINT8, field_15_012345 UINT32, field_16_0123456 HIRESTIME ARRAY, field_17_01234567 UINT16, field_18_012345678 UINT64, field_19_0123456789 RICHREAL, field_20_0 INT64, field_21_01 BOOL, field_22_012 DATE, field_23_0123 UINT32 ARRAY, field_24_01234 HIRESTIME ARRAY, field_25_012345 CHAR)");
      /* 667 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 REAL, field_3_0123 DATETIME ARRAY, field_4_01234 INT32, field_5_012345 DATE, field_6_0123456 INT8, field_7_01234567 DATE ARRAY, field_8_012345678 RICHREAL ARRAY, field_9_0123456789 UINT8, field_10_0 BOOL, field_11_01 DATE, field_12_012 DATETIME)");
      /* 668 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 DATE, field_3_0123 CHAR ARRAY, field_4_01234 UINT64, field_5_012345 UINT8, field_6_0123456 UINT16 ARRAY, field_7_01234567 INT8, field_8_012345678 UINT8, field_9_0123456789 HIRESTIME, field_10_0 INT64, field_11_01 DATE ARRAY, field_12_012 CHAR ARRAY, field_13_0123 UINT16, field_14_01234 REAL, field_15_012345 UINT64, field_16_0123456 HIRESTIME, field_17_01234567 HIRESTIME, field_18_012345678 UINT64, field_19_0123456789 REAL, field_20_0 BOOL ARRAY, field_21_01 UINT8, field_22_012 INT16, field_23_0123 UINT64, field_24_01234 DATE, field_25_012345 UINT16, field_26_0123456 RICHREAL, field_27_01234567 REAL, field_28_012345678 INT64, field_29_0123456789 INT8 ARRAY, field_30_0 UINT64, field_31_01 REAL, field_32_012 RICHREAL ARRAY, field_33_0123 INT16, field_34_01234 INT16 ARRAY, field_35_012345 RICHREAL, field_36_0123456 REAL, field_37_01234567 UINT8, field_38_012345678 UINT32, field_39_0123456789 INT32, field_40_0 BOOL, field_41_01 HIRESTIME ARRAY, field_42_012 CHAR, field_43_0123 INT64, field_44_01234 INT16, field_45_012345 DATETIME, field_46_0123456 DATE, field_47_01234567 UINT32, field_48_012345678 CHAR, field_49_0123456789 UINT32, field_50_0 INT64, field_51_01 INT16, field_52_012 DATE, field_53_0123 HIRESTIME, field_54_01234 HIRESTIME, field_55_012345 UINT32 ARRAY, field_56_0123456 BOOL, field_57_01234567 UINT16, field_58_012345678 INT8 ARRAY, field_59_0123456789 INT8 ARRAY, field_60_0 BOOL, field_61_01 UINT8, field_62_012 DATETIME, field_63_0123 HIRESTIME, field_64_01234 DATETIME, field_65_012345 CHAR, field_66_0123456 BOOL, field_67_01234567 UINT64, field_68_012345678 REAL, field_69_0123456789 INT64, field_70_0 INT64, field_71_01 CHAR, field_72_012 DATE, field_73_0123 CHAR, field_74_01234 REAL ARRAY, field_75_012345 REAL, field_76_0123456 UINT64, field_77_01234567 INT16, field_78_012345678 HIRESTIME, field_79_0123456789 CHAR ARRAY, field_80_0 DATE, field_81_01 HIRESTIME, field_82_012 UINT16, field_83_0123 UINT16 ARRAY, field_84_01234 DATETIME, field_85_012345 UINT8, field_86_0123456 INT32, field_87_01234567 INT64, field_88_012345678 INT32 ARRAY)");
      /* 669 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 UINT64, field_3_0123 INT8, field_4_01234 INT64 ARRAY, field_5_012345 UINT64, field_6_0123456 CHAR, field_7_01234567 INT8, field_8_012345678 INT8, field_9_0123456789 UINT32, field_10_0 INT8 ARRAY, field_11_01 INT16, field_12_012 UINT16 ARRAY, field_13_0123 INT32, field_14_01234 BOOL, field_15_012345 INT16, field_16_0123456 UINT8, field_17_01234567 UINT64, field_18_012345678 RICHREAL, field_19_0123456789 CHAR, field_20_0 DATETIME, field_21_01 REAL, field_22_012 RICHREAL, field_23_0123 DATETIME ARRAY, field_24_01234 UINT64, field_25_012345 UINT8, field_26_0123456 CHAR, field_27_01234567 DATE, field_28_012345678 RICHREAL, field_29_0123456789 INT32, field_30_0 BOOL, field_31_01 CHAR ARRAY, field_32_012 DATETIME, field_33_0123 HIRESTIME ARRAY, field_34_01234 UINT16 ARRAY, field_35_012345 UINT32, field_36_0123456 DATETIME ARRAY, field_37_01234567 UINT64 ARRAY, field_38_012345678 DATE ARRAY, field_39_0123456789 UINT64, field_40_0 INT32, field_41_01 DATE, field_42_012 UINT8)");
      /* 670 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 DATETIME, field_3_0123 UINT32 ARRAY, field_4_01234 UINT32, field_5_012345 UINT32, field_6_0123456 INT64 ARRAY, field_7_01234567 CHAR, field_8_012345678 BOOL, field_9_0123456789 HIRESTIME, field_10_0 INT8, field_11_01 REAL ARRAY, field_12_012 REAL, field_13_0123 HIRESTIME, field_14_01234 UINT32, field_15_012345 INT16, field_16_0123456 DATETIME, field_17_01234567 UINT16, field_18_012345678 DATE, field_19_0123456789 RICHREAL, field_20_0 UINT16, field_21_01 INT8, field_22_012 INT64, field_23_0123 INT8, field_24_01234 UINT32, field_25_012345 INT32 ARRAY, field_26_0123456 CHAR, field_27_01234567 UINT64, field_28_012345678 BOOL, field_29_0123456789 INT8, field_30_0 UINT8, field_31_01 UINT16)");
      /* 671 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 UINT16, field_3_0123 INT32, field_4_01234 HIRESTIME, field_5_012345 INT16, field_6_0123456 HIRESTIME, field_7_01234567 CHAR, field_8_012345678 INT32, field_9_0123456789 HIRESTIME ARRAY, field_10_0 INT64, field_11_01 UINT32, field_12_012 INT64, field_13_0123 UINT32, field_14_01234 INT8, field_15_012345 INT8 ARRAY, field_16_0123456 UINT8, field_17_01234567 DATE, field_18_012345678 HIRESTIME, field_19_0123456789 CHAR, field_20_0 DATE, field_21_01 UINT8, field_22_012 UINT32, field_23_0123 DATETIME, field_24_01234 INT64, field_25_012345 BOOL, field_26_0123456 INT16, field_27_01234567 RICHREAL, field_28_012345678 RICHREAL, field_29_0123456789 CHAR, field_30_0 DATETIME ARRAY, field_31_01 UINT8, field_32_012 BOOL, field_33_0123 UINT8 ARRAY, field_34_01234 DATETIME, field_35_012345 RICHREAL, field_36_0123456 UINT32, field_37_01234567 BOOL, field_38_012345678 INT16, field_39_0123456789 CHAR, field_40_0 UINT64, field_41_01 REAL, field_42_012 INT8, field_43_0123 UINT16 ARRAY)");
      /* 672 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL ARRAY, field_2_012 UINT64, field_3_0123 RICHREAL, field_4_01234 UINT8, field_5_012345 HIRESTIME, field_6_0123456 INT16 ARRAY, field_7_01234567 INT16, field_8_012345678 INT32, field_9_0123456789 UINT8, field_10_0 CHAR ARRAY, field_11_01 UINT32, field_12_012 INT64, field_13_0123 INT16, field_14_01234 UINT8, field_15_012345 REAL, field_16_0123456 REAL, field_17_01234567 INT16, field_18_012345678 DATETIME, field_19_0123456789 CHAR, field_20_0 DATETIME, field_21_01 INT16, field_22_012 UINT8, field_23_0123 INT16, field_24_01234 HIRESTIME, field_25_012345 INT8, field_26_0123456 REAL, field_27_01234567 INT64, field_28_012345678 DATETIME, field_29_0123456789 UINT16, field_30_0 INT16, field_31_01 UINT8, field_32_012 BOOL ARRAY, field_33_0123 INT32 ARRAY, field_34_01234 INT64 ARRAY, field_35_012345 INT8, field_36_0123456 CHAR, field_37_01234567 INT32, field_38_012345678 RICHREAL, field_39_0123456789 RICHREAL, field_40_0 UINT64, field_41_01 REAL)");
      /* 673 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 INT64, field_3_0123 INT64, field_4_01234 INT64, field_5_012345 BOOL ARRAY, field_6_0123456 BOOL, field_7_01234567 INT8, field_8_012345678 INT32, field_9_0123456789 INT16, field_10_0 HIRESTIME, field_11_01 UINT8, field_12_012 CHAR, field_13_0123 CHAR ARRAY, field_14_01234 INT8, field_15_012345 DATE, field_16_0123456 DATE, field_17_01234567 CHAR, field_18_012345678 UINT8, field_19_0123456789 UINT64, field_20_0 HIRESTIME ARRAY, field_21_01 UINT8, field_22_012 INT32, field_23_0123 RICHREAL, field_24_01234 HIRESTIME, field_25_012345 REAL, field_26_0123456 INT32, field_27_01234567 CHAR, field_28_012345678 UINT32, field_29_0123456789 BOOL, field_30_0 DATE ARRAY, field_31_01 DATE, field_32_012 INT8, field_33_0123 BOOL, field_34_01234 CHAR, field_35_012345 INT8 ARRAY, field_36_0123456 UINT32, field_37_01234567 UINT8 ARRAY, field_38_012345678 INT64, field_39_0123456789 HIRESTIME ARRAY, field_40_0 DATE ARRAY, field_41_01 UINT16, field_42_012 INT64, field_43_0123 REAL, field_44_01234 REAL, field_45_012345 UINT16, field_46_0123456 INT64, field_47_01234567 UINT64 ARRAY, field_48_012345678 INT64, field_49_0123456789 REAL, field_50_0 INT32, field_51_01 DATETIME, field_52_012 DATE ARRAY, field_53_0123 DATE, field_54_01234 DATETIME, field_55_012345 CHAR, field_56_0123456 DATE, field_57_01234567 INT32 ARRAY, field_58_012345678 CHAR, field_59_0123456789 RICHREAL, field_60_0 DATETIME, field_61_01 DATE, field_62_012 BOOL)");
      /* 674 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 UINT16 ARRAY, field_3_0123 INT32, field_4_01234 DATE, field_5_012345 UINT32, field_6_0123456 DATE, field_7_01234567 HIRESTIME, field_8_012345678 UINT16, field_9_0123456789 INT16, field_10_0 INT32, field_11_01 BOOL, field_12_012 CHAR ARRAY, field_13_0123 RICHREAL, field_14_01234 HIRESTIME ARRAY, field_15_012345 CHAR, field_16_0123456 BOOL, field_17_01234567 RICHREAL ARRAY, field_18_012345678 BOOL, field_19_0123456789 DATETIME ARRAY, field_20_0 RICHREAL, field_21_01 CHAR ARRAY, field_22_012 UINT32, field_23_0123 DATETIME, field_24_01234 REAL, field_25_012345 BOOL, field_26_0123456 INT64, field_27_01234567 HIRESTIME, field_28_012345678 INT8, field_29_0123456789 DATETIME, field_30_0 UINT64 ARRAY, field_31_01 HIRESTIME, field_32_012 INT64, field_33_0123 UINT16 ARRAY, field_34_01234 DATE ARRAY, field_35_012345 UINT32, field_36_0123456 UINT32, field_37_01234567 BOOL, field_38_012345678 UINT32, field_39_0123456789 RICHREAL, field_40_0 BOOL ARRAY, field_41_01 INT32 ARRAY, field_42_012 BOOL ARRAY, field_43_0123 BOOL, field_44_01234 INT64 ARRAY, field_45_012345 UINT8, field_46_0123456 BOOL, field_47_01234567 BOOL ARRAY, field_48_012345678 UINT8, field_49_0123456789 UINT16, field_50_0 INT64 ARRAY, field_51_01 UINT16, field_52_012 RICHREAL, field_53_0123 REAL, field_54_01234 UINT16, field_55_012345 DATE, field_56_0123456 REAL, field_57_01234567 CHAR, field_58_012345678 UINT16, field_59_0123456789 DATETIME, field_60_0 REAL, field_61_01 BOOL, field_62_012 INT32, field_63_0123 DATETIME, field_64_01234 DATE)");
      /* 675 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME ARRAY, field_2_012 DATETIME, field_3_0123 REAL, field_4_01234 INT16, field_5_012345 UINT16, field_6_0123456 INT16, field_7_01234567 DATE ARRAY, field_8_012345678 UINT64, field_9_0123456789 HIRESTIME ARRAY, field_10_0 DATETIME, field_11_01 DATETIME)");
      /* 676 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 INT8, field_3_0123 INT64 ARRAY, field_4_01234 REAL, field_5_012345 BOOL, field_6_0123456 INT16, field_7_01234567 BOOL, field_8_012345678 REAL, field_9_0123456789 UINT16 ARRAY, field_10_0 DATETIME, field_11_01 INT64, field_12_012 REAL, field_13_0123 INT32, field_14_01234 UINT16)");
      /* 677 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 CHAR, field_3_0123 INT64, field_4_01234 BOOL, field_5_012345 RICHREAL, field_6_0123456 CHAR, field_7_01234567 INT64, field_8_012345678 BOOL, field_9_0123456789 CHAR, field_10_0 DATETIME ARRAY, field_11_01 UINT64, field_12_012 RICHREAL, field_13_0123 UINT8, field_14_01234 RICHREAL, field_15_012345 INT64, field_16_0123456 REAL, field_17_01234567 INT64, field_18_012345678 UINT32, field_19_0123456789 UINT32, field_20_0 UINT8, field_21_01 INT64, field_22_012 REAL ARRAY, field_23_0123 DATETIME, field_24_01234 INT16, field_25_012345 CHAR, field_26_0123456 UINT16, field_27_01234567 INT8 ARRAY, field_28_012345678 UINT64, field_29_0123456789 INT64, field_30_0 BOOL, field_31_01 RICHREAL, field_32_012 UINT32, field_33_0123 INT64)");
      /* 678 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 UINT8, field_3_0123 CHAR, field_4_01234 DATETIME, field_5_012345 BOOL, field_6_0123456 CHAR, field_7_01234567 CHAR, field_8_012345678 UINT64, field_9_0123456789 DATETIME, field_10_0 INT32, field_11_01 UINT32 ARRAY, field_12_012 INT32, field_13_0123 BOOL, field_14_01234 BOOL, field_15_012345 INT32, field_16_0123456 INT16, field_17_01234567 INT32, field_18_012345678 UINT64, field_19_0123456789 BOOL, field_20_0 UINT64, field_21_01 RICHREAL, field_22_012 INT64, field_23_0123 UINT8, field_24_01234 REAL ARRAY, field_25_012345 HIRESTIME, field_26_0123456 CHAR, field_27_01234567 INT16, field_28_012345678 REAL ARRAY, field_29_0123456789 BOOL, field_30_0 INT16, field_31_01 RICHREAL, field_32_012 DATE ARRAY, field_33_0123 INT64, field_34_01234 UINT8, field_35_012345 REAL, field_36_0123456 DATETIME, field_37_01234567 INT32, field_38_012345678 REAL, field_39_0123456789 INT32, field_40_0 INT64, field_41_01 INT64, field_42_012 UINT8, field_43_0123 CHAR, field_44_01234 INT64, field_45_012345 HIRESTIME, field_46_0123456 UINT8 ARRAY, field_47_01234567 UINT32, field_48_012345678 INT64, field_49_0123456789 INT64, field_50_0 UINT16, field_51_01 UINT32 ARRAY, field_52_012 HIRESTIME, field_53_0123 DATETIME, field_54_01234 BOOL, field_55_012345 INT16, field_56_0123456 HIRESTIME, field_57_01234567 INT64, field_58_012345678 INT16 ARRAY, field_59_0123456789 INT8, field_60_0 BOOL, field_61_01 RICHREAL, field_62_012 INT32, field_63_0123 DATETIME, field_64_01234 UINT16, field_65_012345 UINT32, field_66_0123456 UINT32, field_67_01234567 UINT64 ARRAY, field_68_012345678 REAL, field_69_0123456789 RICHREAL, field_70_0 INT64, field_71_01 BOOL ARRAY, field_72_012 REAL, field_73_0123 DATETIME, field_74_01234 BOOL, field_75_012345 DATE, field_76_0123456 CHAR ARRAY, field_77_01234567 HIRESTIME, field_78_012345678 INT16, field_79_0123456789 UINT32, field_80_0 DATE, field_81_01 INT16, field_82_012 HIRESTIME, field_83_0123 INT8, field_84_01234 BOOL, field_85_012345 INT16, field_86_0123456 INT32, field_87_01234567 BOOL, field_88_012345678 RICHREAL, field_89_0123456789 BOOL, field_90_0 UINT32, field_91_01 BOOL, field_92_012 UINT64)");
      /* 679 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 UINT32, field_3_0123 UINT64, field_4_01234 UINT16, field_5_012345 INT64 ARRAY, field_6_0123456 CHAR, field_7_01234567 INT8, field_8_012345678 HIRESTIME, field_9_0123456789 INT16, field_10_0 UINT8 ARRAY, field_11_01 INT32, field_12_012 UINT8, field_13_0123 INT32 ARRAY, field_14_01234 INT64, field_15_012345 REAL, field_16_0123456 UINT16, field_17_01234567 INT64, field_18_012345678 RICHREAL, field_19_0123456789 INT32, field_20_0 UINT64, field_21_01 CHAR ARRAY, field_22_012 DATETIME, field_23_0123 HIRESTIME, field_24_01234 REAL ARRAY, field_25_012345 INT8, field_26_0123456 UINT64, field_27_01234567 CHAR, field_28_012345678 UINT16, field_29_0123456789 BOOL, field_30_0 CHAR ARRAY, field_31_01 HIRESTIME, field_32_012 RICHREAL ARRAY, field_33_0123 RICHREAL, field_34_01234 RICHREAL, field_35_012345 UINT64, field_36_0123456 RICHREAL, field_37_01234567 DATE, field_38_012345678 UINT8, field_39_0123456789 INT16, field_40_0 INT32, field_41_01 RICHREAL, field_42_012 UINT16, field_43_0123 CHAR, field_44_01234 INT64, field_45_012345 HIRESTIME, field_46_0123456 DATETIME, field_47_01234567 INT32, field_48_012345678 HIRESTIME, field_49_0123456789 DATETIME, field_50_0 CHAR, field_51_01 INT16, field_52_012 UINT16, field_53_0123 BOOL, field_54_01234 DATE, field_55_012345 RICHREAL, field_56_0123456 INT8, field_57_01234567 UINT64, field_58_012345678 DATETIME, field_59_0123456789 INT32 ARRAY, field_60_0 RICHREAL, field_61_01 INT32, field_62_012 INT8, field_63_0123 REAL, field_64_01234 REAL, field_65_012345 INT8, field_66_0123456 BOOL, field_67_01234567 DATE, field_68_012345678 REAL, field_69_0123456789 CHAR, field_70_0 UINT8, field_71_01 INT32, field_72_012 INT64, field_73_0123 UINT8 ARRAY, field_74_01234 INT32, field_75_012345 DATETIME, field_76_0123456 BOOL, field_77_01234567 UINT64, field_78_012345678 UINT16 ARRAY, field_79_0123456789 DATE, field_80_0 REAL, field_81_01 INT8, field_82_012 INT16, field_83_0123 RICHREAL, field_84_01234 INT8, field_85_012345 CHAR, field_86_0123456 INT16 ARRAY, field_87_01234567 UINT8 ARRAY)");
      /* 680 */ glbTypes.push_back("TABLE(field_1_01 BOOL ARRAY, field_2_012 UINT32 ARRAY, field_3_0123 INT64, field_4_01234 CHAR ARRAY, field_5_012345 HIRESTIME, field_6_0123456 HIRESTIME, field_7_01234567 DATETIME, field_8_012345678 INT64 ARRAY, field_9_0123456789 BOOL, field_10_0 INT32, field_11_01 UINT16, field_12_012 INT64, field_13_0123 HIRESTIME, field_14_01234 BOOL, field_15_012345 UINT64, field_16_0123456 UINT8, field_17_01234567 INT32, field_18_012345678 RICHREAL ARRAY, field_19_0123456789 INT64 ARRAY, field_20_0 UINT64 ARRAY, field_21_01 RICHREAL, field_22_012 INT64, field_23_0123 DATE, field_24_01234 BOOL, field_25_012345 HIRESTIME ARRAY, field_26_0123456 UINT64 ARRAY, field_27_01234567 DATETIME, field_28_012345678 INT16, field_29_0123456789 INT64, field_30_0 REAL, field_31_01 HIRESTIME, field_32_012 UINT16, field_33_0123 UINT32, field_34_01234 CHAR, field_35_012345 DATETIME, field_36_0123456 INT64, field_37_01234567 BOOL, field_38_012345678 RICHREAL, field_39_0123456789 HIRESTIME, field_40_0 CHAR ARRAY, field_41_01 HIRESTIME, field_42_012 DATE, field_43_0123 BOOL, field_44_01234 HIRESTIME, field_45_012345 UINT8, field_46_0123456 REAL, field_47_01234567 BOOL, field_48_012345678 REAL, field_49_0123456789 DATE, field_50_0 HIRESTIME, field_51_01 UINT32, field_52_012 RICHREAL, field_53_0123 INT32, field_54_01234 INT64, field_55_012345 HIRESTIME, field_56_0123456 REAL, field_57_01234567 INT8, field_58_012345678 INT16 ARRAY, field_59_0123456789 HIRESTIME, field_60_0 UINT8, field_61_01 UINT32, field_62_012 HIRESTIME, field_63_0123 INT32, field_64_01234 INT8, field_65_012345 INT8, field_66_0123456 INT32, field_67_01234567 INT16 ARRAY, field_68_012345678 RICHREAL, field_69_0123456789 RICHREAL, field_70_0 INT16, field_71_01 INT32, field_72_012 INT32, field_73_0123 UINT64 ARRAY, field_74_01234 REAL ARRAY, field_75_012345 CHAR, field_76_0123456 UINT16, field_77_01234567 UINT64)");
      /* 681 */ glbTypes.push_back("TABLE(field_1_01 UINT8 ARRAY, field_2_012 INT16, field_3_0123 DATETIME, field_4_01234 INT32 ARRAY, field_5_012345 UINT32 ARRAY, field_6_0123456 DATETIME, field_7_01234567 INT16, field_8_012345678 DATETIME, field_9_0123456789 CHAR, field_10_0 CHAR, field_11_01 UINT32, field_12_012 INT16, field_13_0123 DATE, field_14_01234 UINT16, field_15_012345 CHAR, field_16_0123456 INT32 ARRAY, field_17_01234567 INT8, field_18_012345678 INT32, field_19_0123456789 DATE, field_20_0 INT8 ARRAY, field_21_01 UINT8, field_22_012 UINT64, field_23_0123 CHAR, field_24_01234 UINT64 ARRAY, field_25_012345 DATETIME, field_26_0123456 UINT16, field_27_01234567 DATE ARRAY, field_28_012345678 HIRESTIME ARRAY, field_29_0123456789 REAL, field_30_0 CHAR, field_31_01 DATE, field_32_012 INT32, field_33_0123 UINT64, field_34_01234 BOOL, field_35_012345 RICHREAL, field_36_0123456 CHAR, field_37_01234567 UINT8, field_38_012345678 UINT32, field_39_0123456789 CHAR, field_40_0 UINT16, field_41_01 UINT16, field_42_012 UINT64, field_43_0123 UINT32, field_44_01234 UINT32, field_45_012345 UINT64, field_46_0123456 UINT32, field_47_01234567 HIRESTIME, field_48_012345678 INT32, field_49_0123456789 CHAR, field_50_0 UINT8, field_51_01 RICHREAL, field_52_012 RICHREAL, field_53_0123 INT8)");
      /* 682 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 INT8, field_3_0123 DATE, field_4_01234 HIRESTIME, field_5_012345 UINT64 ARRAY, field_6_0123456 UINT16 ARRAY, field_7_01234567 INT32, field_8_012345678 UINT64, field_9_0123456789 UINT64, field_10_0 UINT8 ARRAY, field_11_01 INT64, field_12_012 INT32 ARRAY, field_13_0123 UINT32, field_14_01234 DATETIME, field_15_012345 INT8 ARRAY, field_16_0123456 INT32, field_17_01234567 INT64, field_18_012345678 INT64, field_19_0123456789 UINT16 ARRAY, field_20_0 UINT8, field_21_01 REAL, field_22_012 RICHREAL, field_23_0123 UINT8, field_24_01234 CHAR, field_25_012345 DATE, field_26_0123456 CHAR, field_27_01234567 DATE, field_28_012345678 INT16 ARRAY, field_29_0123456789 UINT16 ARRAY, field_30_0 HIRESTIME, field_31_01 CHAR ARRAY, field_32_012 INT32, field_33_0123 CHAR, field_34_01234 UINT16, field_35_012345 CHAR, field_36_0123456 INT8, field_37_01234567 INT64, field_38_012345678 REAL, field_39_0123456789 INT16, field_40_0 INT32, field_41_01 INT32 ARRAY, field_42_012 UINT8, field_43_0123 DATETIME, field_44_01234 DATE, field_45_012345 INT64, field_46_0123456 INT64, field_47_01234567 RICHREAL, field_48_012345678 DATE ARRAY, field_49_0123456789 UINT32, field_50_0 REAL, field_51_01 DATE, field_52_012 UINT64, field_53_0123 INT8, field_54_01234 UINT8, field_55_012345 INT64, field_56_0123456 INT32, field_57_01234567 INT8, field_58_012345678 REAL ARRAY, field_59_0123456789 DATETIME, field_60_0 RICHREAL, field_61_01 INT32 ARRAY, field_62_012 UINT32, field_63_0123 REAL, field_64_01234 UINT16, field_65_012345 UINT64, field_66_0123456 INT8, field_67_01234567 HIRESTIME ARRAY, field_68_012345678 UINT8, field_69_0123456789 HIRESTIME, field_70_0 UINT16, field_71_01 BOOL, field_72_012 RICHREAL, field_73_0123 HIRESTIME, field_74_01234 INT8 ARRAY, field_75_012345 DATETIME, field_76_0123456 CHAR, field_77_01234567 INT8, field_78_012345678 CHAR, field_79_0123456789 BOOL ARRAY, field_80_0 CHAR)");
      /* 683 */ glbTypes.push_back("TABLE(field_1_01 INT16 ARRAY, field_2_012 RICHREAL, field_3_0123 DATETIME ARRAY, field_4_01234 CHAR, field_5_012345 CHAR, field_6_0123456 INT32, field_7_01234567 INT8, field_8_012345678 INT8 ARRAY, field_9_0123456789 INT16, field_10_0 CHAR ARRAY, field_11_01 DATETIME, field_12_012 UINT8 ARRAY, field_13_0123 INT32, field_14_01234 RICHREAL ARRAY, field_15_012345 DATETIME, field_16_0123456 INT32, field_17_01234567 HIRESTIME, field_18_012345678 CHAR, field_19_0123456789 BOOL, field_20_0 INT16, field_21_01 UINT32, field_22_012 UINT64, field_23_0123 INT16, field_24_01234 UINT32, field_25_012345 INT32, field_26_0123456 UINT8, field_27_01234567 UINT32 ARRAY, field_28_012345678 HIRESTIME ARRAY, field_29_0123456789 UINT16, field_30_0 INT8, field_31_01 UINT16, field_32_012 UINT16, field_33_0123 INT64 ARRAY, field_34_01234 UINT8 ARRAY, field_35_012345 UINT16, field_36_0123456 INT64, field_37_01234567 HIRESTIME, field_38_012345678 UINT32, field_39_0123456789 UINT64 ARRAY, field_40_0 DATETIME, field_41_01 INT16, field_42_012 INT8, field_43_0123 UINT16, field_44_01234 UINT64, field_45_012345 DATETIME, field_46_0123456 CHAR, field_47_01234567 BOOL, field_48_012345678 UINT64 ARRAY, field_49_0123456789 INT64 ARRAY, field_50_0 BOOL, field_51_01 INT64, field_52_012 CHAR ARRAY, field_53_0123 INT16, field_54_01234 UINT8, field_55_012345 INT8, field_56_0123456 UINT16, field_57_01234567 RICHREAL ARRAY, field_58_012345678 DATETIME, field_59_0123456789 INT64, field_60_0 HIRESTIME ARRAY, field_61_01 UINT8, field_62_012 CHAR ARRAY, field_63_0123 INT16, field_64_01234 UINT8, field_65_012345 HIRESTIME)");
      /* 684 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 REAL ARRAY, field_3_0123 REAL ARRAY, field_4_01234 UINT32, field_5_012345 INT16 ARRAY, field_6_0123456 REAL, field_7_01234567 REAL, field_8_012345678 UINT32 ARRAY, field_9_0123456789 BOOL, field_10_0 DATE, field_11_01 INT64, field_12_012 DATETIME ARRAY, field_13_0123 UINT16 ARRAY, field_14_01234 INT64, field_15_012345 UINT8 ARRAY, field_16_0123456 HIRESTIME, field_17_01234567 DATETIME, field_18_012345678 UINT64 ARRAY, field_19_0123456789 REAL, field_20_0 UINT8, field_21_01 INT16, field_22_012 HIRESTIME, field_23_0123 INT16, field_24_01234 CHAR, field_25_012345 UINT64, field_26_0123456 HIRESTIME, field_27_01234567 UINT64, field_28_012345678 UINT16, field_29_0123456789 INT32, field_30_0 INT32 ARRAY, field_31_01 UINT16, field_32_012 UINT8, field_33_0123 INT16, field_34_01234 DATE, field_35_012345 UINT64, field_36_0123456 UINT16, field_37_01234567 HIRESTIME, field_38_012345678 UINT16, field_39_0123456789 BOOL, field_40_0 UINT64, field_41_01 INT8, field_42_012 INT64, field_43_0123 INT64, field_44_01234 DATETIME, field_45_012345 INT16, field_46_0123456 DATE, field_47_01234567 INT16 ARRAY, field_48_012345678 RICHREAL, field_49_0123456789 INT64 ARRAY, field_50_0 DATETIME ARRAY, field_51_01 INT8, field_52_012 DATETIME, field_53_0123 CHAR ARRAY, field_54_01234 INT8 ARRAY, field_55_012345 RICHREAL, field_56_0123456 UINT8, field_57_01234567 REAL, field_58_012345678 INT64, field_59_0123456789 INT16, field_60_0 INT8, field_61_01 INT64, field_62_012 RICHREAL, field_63_0123 CHAR, field_64_01234 DATE ARRAY, field_65_012345 INT8, field_66_0123456 DATETIME, field_67_01234567 DATETIME, field_68_012345678 HIRESTIME, field_69_0123456789 UINT16, field_70_0 REAL, field_71_01 UINT32, field_72_012 UINT64, field_73_0123 CHAR, field_74_01234 UINT32, field_75_012345 REAL ARRAY, field_76_0123456 UINT8, field_77_01234567 UINT8 ARRAY, field_78_012345678 DATETIME, field_79_0123456789 INT8, field_80_0 UINT32, field_81_01 HIRESTIME, field_82_012 DATETIME, field_83_0123 DATETIME, field_84_01234 REAL, field_85_012345 UINT8, field_86_0123456 BOOL, field_87_01234567 REAL, field_88_012345678 BOOL, field_89_0123456789 REAL, field_90_0 UINT32, field_91_01 INT32, field_92_012 UINT64, field_93_0123 RICHREAL ARRAY, field_94_01234 DATETIME, field_95_012345 UINT8, field_96_0123456 UINT32)");
      /* 685 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 UINT16, field_3_0123 DATETIME, field_4_01234 INT16 ARRAY, field_5_012345 RICHREAL, field_6_0123456 UINT64, field_7_01234567 RICHREAL, field_8_012345678 INT32, field_9_0123456789 CHAR, field_10_0 DATE ARRAY, field_11_01 BOOL, field_12_012 INT8 ARRAY, field_13_0123 UINT8, field_14_01234 UINT8, field_15_012345 INT16, field_16_0123456 UINT8, field_17_01234567 HIRESTIME, field_18_012345678 UINT16 ARRAY, field_19_0123456789 CHAR, field_20_0 DATE, field_21_01 UINT16, field_22_012 CHAR ARRAY, field_23_0123 INT8, field_24_01234 INT32, field_25_012345 RICHREAL, field_26_0123456 BOOL ARRAY, field_27_01234567 UINT8, field_28_012345678 UINT8, field_29_0123456789 HIRESTIME, field_30_0 INT8, field_31_01 CHAR ARRAY, field_32_012 DATETIME, field_33_0123 DATETIME ARRAY, field_34_01234 INT32, field_35_012345 INT8, field_36_0123456 DATE, field_37_01234567 INT16, field_38_012345678 DATE ARRAY, field_39_0123456789 REAL, field_40_0 UINT16, field_41_01 INT8 ARRAY, field_42_012 BOOL, field_43_0123 INT16, field_44_01234 UINT8, field_45_012345 UINT8 ARRAY, field_46_0123456 UINT64, field_47_01234567 INT8, field_48_012345678 REAL ARRAY, field_49_0123456789 BOOL ARRAY, field_50_0 UINT64 ARRAY, field_51_01 UINT8 ARRAY, field_52_012 UINT8, field_53_0123 BOOL, field_54_01234 INT32, field_55_012345 BOOL ARRAY, field_56_0123456 DATE, field_57_01234567 RICHREAL)");
      /* 686 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 INT32, field_3_0123 DATE ARRAY, field_4_01234 BOOL, field_5_012345 DATETIME, field_6_0123456 INT8, field_7_01234567 HIRESTIME ARRAY, field_8_012345678 UINT32, field_9_0123456789 CHAR, field_10_0 UINT64, field_11_01 RICHREAL, field_12_012 UINT32, field_13_0123 UINT64 ARRAY, field_14_01234 DATETIME, field_15_012345 UINT8, field_16_0123456 INT64, field_17_01234567 HIRESTIME, field_18_012345678 BOOL ARRAY, field_19_0123456789 UINT64, field_20_0 CHAR ARRAY, field_21_01 UINT16, field_22_012 BOOL ARRAY, field_23_0123 REAL, field_24_01234 DATETIME, field_25_012345 DATETIME, field_26_0123456 HIRESTIME ARRAY, field_27_01234567 UINT32, field_28_012345678 CHAR ARRAY, field_29_0123456789 UINT64, field_30_0 UINT64, field_31_01 CHAR, field_32_012 INT64, field_33_0123 DATE, field_34_01234 INT16, field_35_012345 UINT64, field_36_0123456 DATE ARRAY, field_37_01234567 INT64, field_38_012345678 UINT64, field_39_0123456789 INT32 ARRAY, field_40_0 DATETIME ARRAY, field_41_01 DATE, field_42_012 HIRESTIME ARRAY, field_43_0123 INT64 ARRAY, field_44_01234 HIRESTIME, field_45_012345 DATETIME, field_46_0123456 UINT64, field_47_01234567 UINT32, field_48_012345678 UINT64, field_49_0123456789 CHAR ARRAY, field_50_0 UINT32, field_51_01 DATE ARRAY, field_52_012 RICHREAL ARRAY, field_53_0123 UINT32 ARRAY, field_54_01234 UINT32, field_55_012345 INT32 ARRAY, field_56_0123456 INT32)");
      /* 687 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 BOOL, field_3_0123 INT16 ARRAY, field_4_01234 DATE, field_5_012345 UINT8, field_6_0123456 INT16 ARRAY, field_7_01234567 UINT8, field_8_012345678 DATE, field_9_0123456789 DATE, field_10_0 INT64, field_11_01 CHAR, field_12_012 RICHREAL, field_13_0123 UINT32, field_14_01234 DATETIME, field_15_012345 UINT8 ARRAY, field_16_0123456 UINT32, field_17_01234567 INT16, field_18_012345678 RICHREAL, field_19_0123456789 UINT8, field_20_0 CHAR, field_21_01 CHAR, field_22_012 UINT32, field_23_0123 INT8, field_24_01234 UINT16, field_25_012345 UINT32, field_26_0123456 UINT32, field_27_01234567 INT64, field_28_012345678 REAL, field_29_0123456789 INT8 ARRAY, field_30_0 RICHREAL, field_31_01 INT8, field_32_012 CHAR, field_33_0123 INT64, field_34_01234 UINT32, field_35_012345 DATETIME, field_36_0123456 REAL, field_37_01234567 CHAR, field_38_012345678 DATE, field_39_0123456789 UINT32, field_40_0 INT64 ARRAY, field_41_01 INT32, field_42_012 UINT32 ARRAY, field_43_0123 DATETIME, field_44_01234 HIRESTIME ARRAY, field_45_012345 DATETIME, field_46_0123456 UINT16, field_47_01234567 HIRESTIME, field_48_012345678 UINT16 ARRAY, field_49_0123456789 INT16 ARRAY, field_50_0 DATE ARRAY, field_51_01 INT8 ARRAY, field_52_012 DATE, field_53_0123 CHAR, field_54_01234 DATE, field_55_012345 INT64, field_56_0123456 UINT32 ARRAY, field_57_01234567 HIRESTIME, field_58_012345678 DATETIME, field_59_0123456789 REAL, field_60_0 UINT64, field_61_01 INT64 ARRAY, field_62_012 CHAR, field_63_0123 BOOL, field_64_01234 REAL, field_65_012345 INT32, field_66_0123456 INT8 ARRAY, field_67_01234567 BOOL ARRAY, field_68_012345678 REAL, field_69_0123456789 UINT8, field_70_0 HIRESTIME, field_71_01 CHAR ARRAY, field_72_012 DATETIME, field_73_0123 REAL)");
      /* 688 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 UINT64, field_3_0123 CHAR, field_4_01234 DATE ARRAY, field_5_012345 UINT64, field_6_0123456 INT16, field_7_01234567 INT16, field_8_012345678 INT64, field_9_0123456789 DATETIME, field_10_0 UINT32 ARRAY, field_11_01 DATETIME, field_12_012 INT8, field_13_0123 UINT32, field_14_01234 BOOL ARRAY, field_15_012345 BOOL ARRAY, field_16_0123456 BOOL, field_17_01234567 DATE, field_18_012345678 DATE, field_19_0123456789 INT32, field_20_0 CHAR, field_21_01 INT16, field_22_012 INT32, field_23_0123 CHAR, field_24_01234 CHAR, field_25_012345 UINT8, field_26_0123456 REAL, field_27_01234567 UINT64, field_28_012345678 DATE, field_29_0123456789 INT64, field_30_0 DATE, field_31_01 CHAR, field_32_012 INT32, field_33_0123 HIRESTIME, field_34_01234 UINT16, field_35_012345 CHAR, field_36_0123456 UINT8, field_37_01234567 REAL)");
      /* 689 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 INT64, field_3_0123 INT32, field_4_01234 REAL, field_5_012345 HIRESTIME ARRAY, field_6_0123456 UINT64 ARRAY, field_7_01234567 DATETIME, field_8_012345678 RICHREAL, field_9_0123456789 UINT32, field_10_0 REAL, field_11_01 INT64 ARRAY, field_12_012 DATETIME, field_13_0123 DATETIME, field_14_01234 UINT32 ARRAY, field_15_012345 UINT8 ARRAY, field_16_0123456 UINT32, field_17_01234567 HIRESTIME ARRAY, field_18_012345678 CHAR ARRAY, field_19_0123456789 UINT32, field_20_0 INT32, field_21_01 DATETIME, field_22_012 UINT32, field_23_0123 REAL, field_24_01234 DATETIME ARRAY, field_25_012345 UINT8, field_26_0123456 INT32, field_27_01234567 HIRESTIME ARRAY, field_28_012345678 BOOL, field_29_0123456789 CHAR ARRAY, field_30_0 INT32, field_31_01 DATE, field_32_012 INT8, field_33_0123 UINT32, field_34_01234 CHAR, field_35_012345 CHAR, field_36_0123456 REAL ARRAY, field_37_01234567 UINT32, field_38_012345678 RICHREAL, field_39_0123456789 DATE ARRAY, field_40_0 UINT16, field_41_01 BOOL, field_42_012 UINT32, field_43_0123 DATE, field_44_01234 UINT32, field_45_012345 INT64, field_46_0123456 HIRESTIME, field_47_01234567 HIRESTIME)");
      /* 690 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 RICHREAL, field_3_0123 DATETIME, field_4_01234 UINT32 ARRAY, field_5_012345 INT64, field_6_0123456 INT64, field_7_01234567 REAL, field_8_012345678 UINT16 ARRAY, field_9_0123456789 REAL ARRAY, field_10_0 HIRESTIME, field_11_01 RICHREAL, field_12_012 INT64, field_13_0123 HIRESTIME ARRAY, field_14_01234 UINT16 ARRAY, field_15_012345 BOOL, field_16_0123456 CHAR, field_17_01234567 UINT16, field_18_012345678 HIRESTIME, field_19_0123456789 UINT8)");
      /* 691 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 DATETIME, field_3_0123 INT16, field_4_01234 BOOL, field_5_012345 INT64, field_6_0123456 HIRESTIME, field_7_01234567 UINT64, field_8_012345678 DATE, field_9_0123456789 UINT8, field_10_0 DATETIME, field_11_01 CHAR, field_12_012 UINT32)");
      /* 692 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 INT16, field_3_0123 HIRESTIME ARRAY, field_4_01234 UINT8 ARRAY, field_5_012345 UINT64, field_6_0123456 DATETIME, field_7_01234567 UINT64, field_8_012345678 DATE, field_9_0123456789 DATETIME, field_10_0 DATETIME, field_11_01 UINT8, field_12_012 HIRESTIME, field_13_0123 INT64 ARRAY, field_14_01234 DATE, field_15_012345 INT64 ARRAY, field_16_0123456 RICHREAL ARRAY, field_17_01234567 INT16, field_18_012345678 DATETIME, field_19_0123456789 INT16 ARRAY, field_20_0 INT32, field_21_01 DATE, field_22_012 UINT16, field_23_0123 UINT16, field_24_01234 DATE, field_25_012345 DATETIME, field_26_0123456 INT8, field_27_01234567 RICHREAL, field_28_012345678 INT32, field_29_0123456789 INT8 ARRAY, field_30_0 RICHREAL, field_31_01 RICHREAL, field_32_012 INT16 ARRAY, field_33_0123 DATETIME, field_34_01234 REAL ARRAY, field_35_012345 INT64, field_36_0123456 UINT64, field_37_01234567 INT8, field_38_012345678 UINT64 ARRAY, field_39_0123456789 UINT64, field_40_0 INT16, field_41_01 DATE ARRAY, field_42_012 HIRESTIME, field_43_0123 DATE ARRAY, field_44_01234 BOOL, field_45_012345 HIRESTIME, field_46_0123456 UINT64, field_47_01234567 UINT8 ARRAY, field_48_012345678 UINT8, field_49_0123456789 CHAR, field_50_0 UINT8, field_51_01 INT64, field_52_012 UINT64 ARRAY, field_53_0123 UINT16 ARRAY, field_54_01234 HIRESTIME, field_55_012345 CHAR, field_56_0123456 RICHREAL, field_57_01234567 REAL, field_58_012345678 UINT16, field_59_0123456789 INT64, field_60_0 BOOL, field_61_01 HIRESTIME, field_62_012 INT8, field_63_0123 UINT16, field_64_01234 INT8, field_65_012345 INT8, field_66_0123456 DATETIME, field_67_01234567 RICHREAL, field_68_012345678 INT16)");
      /* 693 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 INT32, field_3_0123 RICHREAL, field_4_01234 RICHREAL, field_5_012345 CHAR, field_6_0123456 UINT32, field_7_01234567 UINT64, field_8_012345678 UINT32, field_9_0123456789 UINT64, field_10_0 BOOL, field_11_01 CHAR, field_12_012 HIRESTIME ARRAY, field_13_0123 UINT16, field_14_01234 INT8, field_15_012345 INT64 ARRAY, field_16_0123456 BOOL, field_17_01234567 INT32, field_18_012345678 INT8, field_19_0123456789 INT8, field_20_0 UINT16, field_21_01 REAL, field_22_012 UINT64 ARRAY, field_23_0123 DATETIME, field_24_01234 UINT64, field_25_012345 DATETIME, field_26_0123456 UINT8 ARRAY, field_27_01234567 CHAR, field_28_012345678 UINT32, field_29_0123456789 UINT64, field_30_0 HIRESTIME, field_31_01 INT8, field_32_012 UINT64, field_33_0123 DATETIME, field_34_01234 INT16, field_35_012345 INT8, field_36_0123456 INT64, field_37_01234567 DATETIME ARRAY, field_38_012345678 RICHREAL, field_39_0123456789 DATETIME, field_40_0 CHAR, field_41_01 RICHREAL ARRAY, field_42_012 INT32 ARRAY, field_43_0123 INT32, field_44_01234 INT64 ARRAY, field_45_012345 UINT16, field_46_0123456 INT16 ARRAY, field_47_01234567 CHAR, field_48_012345678 REAL, field_49_0123456789 HIRESTIME, field_50_0 INT8, field_51_01 UINT32, field_52_012 INT32, field_53_0123 BOOL, field_54_01234 REAL, field_55_012345 UINT64, field_56_0123456 INT64, field_57_01234567 HIRESTIME ARRAY, field_58_012345678 DATETIME ARRAY, field_59_0123456789 UINT8, field_60_0 BOOL, field_61_01 HIRESTIME, field_62_012 UINT64 ARRAY)");
      /* 694 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 UINT32 ARRAY, field_3_0123 CHAR, field_4_01234 REAL, field_5_012345 DATE, field_6_0123456 UINT64, field_7_01234567 BOOL, field_8_012345678 UINT16, field_9_0123456789 HIRESTIME, field_10_0 INT8, field_11_01 INT64, field_12_012 REAL, field_13_0123 UINT64, field_14_01234 DATE, field_15_012345 UINT32, field_16_0123456 DATETIME ARRAY, field_17_01234567 INT8, field_18_012345678 INT16 ARRAY, field_19_0123456789 DATE, field_20_0 REAL ARRAY, field_21_01 CHAR, field_22_012 REAL ARRAY, field_23_0123 UINT64, field_24_01234 REAL, field_25_012345 UINT16, field_26_0123456 RICHREAL ARRAY, field_27_01234567 INT64, field_28_012345678 UINT32, field_29_0123456789 REAL ARRAY, field_30_0 INT16, field_31_01 DATE, field_32_012 UINT8, field_33_0123 INT8, field_34_01234 CHAR, field_35_012345 UINT32 ARRAY, field_36_0123456 HIRESTIME ARRAY, field_37_01234567 CHAR, field_38_012345678 RICHREAL, field_39_0123456789 CHAR, field_40_0 INT16, field_41_01 BOOL, field_42_012 UINT16 ARRAY, field_43_0123 CHAR, field_44_01234 INT32, field_45_012345 UINT16, field_46_0123456 UINT32, field_47_01234567 DATETIME, field_48_012345678 INT32, field_49_0123456789 UINT32, field_50_0 DATE, field_51_01 DATE, field_52_012 RICHREAL ARRAY, field_53_0123 INT32, field_54_01234 INT8, field_55_012345 HIRESTIME ARRAY, field_56_0123456 HIRESTIME, field_57_01234567 UINT8, field_58_012345678 HIRESTIME, field_59_0123456789 UINT32, field_60_0 INT8)");
      /* 695 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 CHAR, field_3_0123 REAL, field_4_01234 REAL, field_5_012345 HIRESTIME, field_6_0123456 HIRESTIME, field_7_01234567 BOOL, field_8_012345678 UINT64, field_9_0123456789 INT32 ARRAY, field_10_0 BOOL, field_11_01 INT64, field_12_012 UINT8, field_13_0123 RICHREAL, field_14_01234 UINT8, field_15_012345 UINT8, field_16_0123456 DATETIME, field_17_01234567 HIRESTIME, field_18_012345678 UINT16, field_19_0123456789 UINT16, field_20_0 DATETIME, field_21_01 UINT8, field_22_012 BOOL, field_23_0123 UINT8, field_24_01234 INT8, field_25_012345 HIRESTIME, field_26_0123456 UINT32, field_27_01234567 DATETIME, field_28_012345678 BOOL ARRAY, field_29_0123456789 BOOL, field_30_0 UINT32, field_31_01 HIRESTIME, field_32_012 INT8, field_33_0123 DATE, field_34_01234 INT64, field_35_012345 CHAR ARRAY, field_36_0123456 BOOL, field_37_01234567 UINT16, field_38_012345678 HIRESTIME, field_39_0123456789 UINT64, field_40_0 RICHREAL ARRAY, field_41_01 UINT32, field_42_012 CHAR, field_43_0123 INT8, field_44_01234 INT8, field_45_012345 UINT8 ARRAY, field_46_0123456 INT32, field_47_01234567 CHAR ARRAY, field_48_012345678 UINT32, field_49_0123456789 UINT16, field_50_0 REAL ARRAY, field_51_01 HIRESTIME, field_52_012 REAL ARRAY, field_53_0123 UINT16)");
      /* 696 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 RICHREAL, field_3_0123 UINT32, field_4_01234 HIRESTIME, field_5_012345 UINT16 ARRAY, field_6_0123456 INT8, field_7_01234567 UINT16, field_8_012345678 INT8 ARRAY, field_9_0123456789 INT64 ARRAY, field_10_0 REAL, field_11_01 UINT32, field_12_012 BOOL, field_13_0123 BOOL ARRAY, field_14_01234 INT16 ARRAY, field_15_012345 INT64, field_16_0123456 INT32, field_17_01234567 HIRESTIME ARRAY, field_18_012345678 UINT32, field_19_0123456789 INT16, field_20_0 UINT64, field_21_01 INT8, field_22_012 REAL, field_23_0123 UINT8, field_24_01234 UINT32 ARRAY, field_25_012345 HIRESTIME ARRAY, field_26_0123456 DATE, field_27_01234567 UINT16, field_28_012345678 CHAR, field_29_0123456789 CHAR, field_30_0 REAL, field_31_01 DATETIME, field_32_012 INT8, field_33_0123 HIRESTIME, field_34_01234 HIRESTIME, field_35_012345 INT64, field_36_0123456 RICHREAL, field_37_01234567 DATE ARRAY, field_38_012345678 BOOL, field_39_0123456789 CHAR ARRAY, field_40_0 RICHREAL, field_41_01 HIRESTIME, field_42_012 UINT16 ARRAY, field_43_0123 INT16, field_44_01234 UINT64, field_45_012345 CHAR, field_46_0123456 UINT16, field_47_01234567 UINT64, field_48_012345678 UINT8, field_49_0123456789 INT64, field_50_0 DATE, field_51_01 UINT8 ARRAY, field_52_012 INT16, field_53_0123 DATE, field_54_01234 UINT8, field_55_012345 UINT16 ARRAY, field_56_0123456 DATE ARRAY, field_57_01234567 UINT8, field_58_012345678 INT8, field_59_0123456789 UINT16, field_60_0 HIRESTIME, field_61_01 BOOL, field_62_012 INT16, field_63_0123 RICHREAL, field_64_01234 HIRESTIME, field_65_012345 INT32, field_66_0123456 INT16, field_67_01234567 UINT8, field_68_012345678 HIRESTIME, field_69_0123456789 CHAR, field_70_0 UINT64, field_71_01 UINT16 ARRAY, field_72_012 UINT8, field_73_0123 UINT16, field_74_01234 UINT32 ARRAY, field_75_012345 UINT16 ARRAY, field_76_0123456 REAL, field_77_01234567 UINT16 ARRAY, field_78_012345678 RICHREAL, field_79_0123456789 HIRESTIME ARRAY, field_80_0 UINT8, field_81_01 UINT16 ARRAY, field_82_012 CHAR, field_83_0123 BOOL, field_84_01234 INT16, field_85_012345 UINT64, field_86_0123456 UINT8, field_87_01234567 INT8, field_88_012345678 UINT16, field_89_0123456789 CHAR, field_90_0 UINT32)");
      /* 697 */ glbTypes.push_back("TABLE(field_1_01 UINT64 ARRAY, field_2_012 DATE, field_3_0123 INT16, field_4_01234 CHAR, field_5_012345 INT16, field_6_0123456 DATE, field_7_01234567 INT8, field_8_012345678 INT8, field_9_0123456789 UINT8 ARRAY, field_10_0 UINT64 ARRAY, field_11_01 HIRESTIME, field_12_012 HIRESTIME, field_13_0123 CHAR ARRAY, field_14_01234 UINT8, field_15_012345 UINT16, field_16_0123456 DATE, field_17_01234567 UINT8, field_18_012345678 CHAR, field_19_0123456789 REAL, field_20_0 UINT8 ARRAY, field_21_01 INT32, field_22_012 INT8, field_23_0123 UINT64, field_24_01234 INT8, field_25_012345 BOOL, field_26_0123456 INT32, field_27_01234567 INT16, field_28_012345678 CHAR, field_29_0123456789 UINT8, field_30_0 UINT16, field_31_01 UINT8, field_32_012 REAL, field_33_0123 INT16, field_34_01234 REAL ARRAY, field_35_012345 INT16 ARRAY, field_36_0123456 HIRESTIME, field_37_01234567 REAL, field_38_012345678 REAL ARRAY, field_39_0123456789 UINT32, field_40_0 DATE, field_41_01 UINT64, field_42_012 BOOL ARRAY, field_43_0123 UINT8, field_44_01234 DATETIME, field_45_012345 DATETIME, field_46_0123456 INT32, field_47_01234567 CHAR ARRAY, field_48_012345678 DATE, field_49_0123456789 INT64 ARRAY, field_50_0 UINT16, field_51_01 RICHREAL, field_52_012 DATETIME, field_53_0123 INT64, field_54_01234 INT16, field_55_012345 HIRESTIME, field_56_0123456 UINT64, field_57_01234567 UINT64, field_58_012345678 INT8, field_59_0123456789 CHAR, field_60_0 REAL, field_61_01 REAL, field_62_012 HIRESTIME, field_63_0123 INT16, field_64_01234 INT64, field_65_012345 UINT8, field_66_0123456 UINT8 ARRAY, field_67_01234567 CHAR, field_68_012345678 UINT64, field_69_0123456789 HIRESTIME, field_70_0 INT8 ARRAY, field_71_01 UINT16, field_72_012 INT8, field_73_0123 BOOL ARRAY, field_74_01234 INT32, field_75_012345 UINT32 ARRAY, field_76_0123456 INT64, field_77_01234567 INT32, field_78_012345678 INT8, field_79_0123456789 DATETIME, field_80_0 DATE, field_81_01 CHAR, field_82_012 INT8, field_83_0123 INT16, field_84_01234 INT64 ARRAY, field_85_012345 INT16, field_86_0123456 INT32, field_87_01234567 UINT64, field_88_012345678 INT16, field_89_0123456789 INT64, field_90_0 UINT8, field_91_01 HIRESTIME ARRAY, field_92_012 BOOL, field_93_0123 REAL, field_94_01234 UINT64, field_95_012345 UINT32, field_96_0123456 INT32, field_97_01234567 UINT16, field_98_012345678 UINT32 ARRAY)");
      /* 698 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 INT8 ARRAY, field_3_0123 INT16, field_4_01234 DATETIME, field_5_012345 INT32 ARRAY, field_6_0123456 DATETIME, field_7_01234567 DATE ARRAY, field_8_012345678 INT32, field_9_0123456789 INT32, field_10_0 BOOL)");
      /* 699 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 DATETIME, field_3_0123 UINT16, field_4_01234 UINT8, field_5_012345 INT16, field_6_0123456 UINT16, field_7_01234567 HIRESTIME, field_8_012345678 BOOL, field_9_0123456789 INT8, field_10_0 DATE, field_11_01 INT16, field_12_012 INT16)");
      /* 700 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 RICHREAL ARRAY, field_3_0123 HIRESTIME, field_4_01234 UINT64, field_5_012345 INT64, field_6_0123456 INT32, field_7_01234567 DATE, field_8_012345678 INT8, field_9_0123456789 DATETIME, field_10_0 INT8 ARRAY, field_11_01 UINT32 ARRAY, field_12_012 CHAR, field_13_0123 INT32, field_14_01234 HIRESTIME, field_15_012345 UINT32, field_16_0123456 UINT8, field_17_01234567 INT64 ARRAY, field_18_012345678 DATE, field_19_0123456789 INT8, field_20_0 UINT16, field_21_01 CHAR, field_22_012 HIRESTIME, field_23_0123 INT64, field_24_01234 INT16, field_25_012345 UINT32, field_26_0123456 INT16 ARRAY, field_27_01234567 INT8, field_28_012345678 HIRESTIME, field_29_0123456789 INT32, field_30_0 UINT8 ARRAY, field_31_01 UINT32 ARRAY, field_32_012 INT64, field_33_0123 INT16 ARRAY, field_34_01234 INT8, field_35_012345 INT32, field_36_0123456 INT8, field_37_01234567 DATE, field_38_012345678 UINT64, field_39_0123456789 INT32 ARRAY, field_40_0 DATETIME ARRAY, field_41_01 REAL, field_42_012 UINT16 ARRAY, field_43_0123 RICHREAL, field_44_01234 DATETIME)");
      /* 701 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 CHAR, field_3_0123 RICHREAL, field_4_01234 INT32, field_5_012345 DATE ARRAY, field_6_0123456 INT64, field_7_01234567 HIRESTIME, field_8_012345678 UINT16, field_9_0123456789 INT16, field_10_0 UINT8 ARRAY, field_11_01 CHAR, field_12_012 HIRESTIME, field_13_0123 UINT32 ARRAY, field_14_01234 REAL, field_15_012345 RICHREAL, field_16_0123456 REAL, field_17_01234567 REAL, field_18_012345678 DATETIME, field_19_0123456789 REAL ARRAY, field_20_0 CHAR, field_21_01 UINT8, field_22_012 UINT64, field_23_0123 DATE, field_24_01234 DATETIME ARRAY, field_25_012345 UINT16, field_26_0123456 INT64, field_27_01234567 DATETIME, field_28_012345678 DATE, field_29_0123456789 BOOL, field_30_0 UINT64, field_31_01 UINT16, field_32_012 INT16, field_33_0123 DATE, field_34_01234 INT64 ARRAY, field_35_012345 UINT16 ARRAY, field_36_0123456 BOOL, field_37_01234567 BOOL, field_38_012345678 DATETIME ARRAY, field_39_0123456789 INT8, field_40_0 UINT64, field_41_01 DATE, field_42_012 DATETIME, field_43_0123 INT64, field_44_01234 INT8, field_45_012345 UINT64, field_46_0123456 DATE, field_47_01234567 DATE, field_48_012345678 CHAR, field_49_0123456789 UINT16, field_50_0 INT8, field_51_01 INT64 ARRAY, field_52_012 CHAR, field_53_0123 CHAR, field_54_01234 RICHREAL, field_55_012345 UINT64 ARRAY, field_56_0123456 CHAR, field_57_01234567 UINT64, field_58_012345678 DATETIME, field_59_0123456789 DATETIME, field_60_0 BOOL, field_61_01 INT32 ARRAY, field_62_012 INT8, field_63_0123 INT16, field_64_01234 INT32, field_65_012345 DATETIME, field_66_0123456 UINT8, field_67_01234567 HIRESTIME, field_68_012345678 UINT8, field_69_0123456789 CHAR, field_70_0 UINT16, field_71_01 INT64, field_72_012 HIRESTIME, field_73_0123 INT8, field_74_01234 HIRESTIME ARRAY, field_75_012345 INT8, field_76_0123456 INT8, field_77_01234567 REAL, field_78_012345678 UINT16, field_79_0123456789 CHAR, field_80_0 UINT16, field_81_01 INT32 ARRAY, field_82_012 BOOL, field_83_0123 INT32, field_84_01234 UINT32, field_85_012345 INT8, field_86_0123456 UINT16, field_87_01234567 CHAR, field_88_012345678 UINT8)");
      /* 702 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 CHAR, field_3_0123 CHAR, field_4_01234 UINT16, field_5_012345 BOOL ARRAY, field_6_0123456 UINT32 ARRAY, field_7_01234567 DATETIME, field_8_012345678 INT32, field_9_0123456789 DATETIME, field_10_0 UINT64, field_11_01 INT32, field_12_012 UINT32 ARRAY, field_13_0123 DATE, field_14_01234 INT8 ARRAY, field_15_012345 DATE, field_16_0123456 DATETIME, field_17_01234567 DATETIME ARRAY, field_18_012345678 INT32 ARRAY, field_19_0123456789 UINT32 ARRAY, field_20_0 REAL, field_21_01 INT64, field_22_012 CHAR, field_23_0123 HIRESTIME ARRAY, field_24_01234 INT8, field_25_012345 HIRESTIME, field_26_0123456 DATETIME ARRAY, field_27_01234567 INT64 ARRAY, field_28_012345678 RICHREAL, field_29_0123456789 INT8, field_30_0 BOOL, field_31_01 INT32)");
      /* 703 */ glbTypes.push_back("TABLE(field_1_01 UINT8 ARRAY, field_2_012 UINT32, field_3_0123 INT32, field_4_01234 INT8, field_5_012345 DATE, field_6_0123456 INT16, field_7_01234567 BOOL ARRAY, field_8_012345678 UINT32, field_9_0123456789 CHAR, field_10_0 UINT32 ARRAY, field_11_01 INT64)");
      /* 704 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 INT32, field_3_0123 INT8, field_4_01234 UINT16 ARRAY, field_5_012345 BOOL, field_6_0123456 INT32 ARRAY, field_7_01234567 UINT64, field_8_012345678 DATETIME, field_9_0123456789 DATE, field_10_0 HIRESTIME, field_11_01 HIRESTIME ARRAY, field_12_012 CHAR, field_13_0123 REAL, field_14_01234 HIRESTIME, field_15_012345 HIRESTIME, field_16_0123456 DATE, field_17_01234567 UINT64 ARRAY, field_18_012345678 DATETIME, field_19_0123456789 UINT32, field_20_0 UINT64, field_21_01 HIRESTIME, field_22_012 HIRESTIME)");
      /* 705 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 HIRESTIME, field_3_0123 UINT64, field_4_01234 BOOL, field_5_012345 CHAR, field_6_0123456 INT16, field_7_01234567 BOOL, field_8_012345678 INT8, field_9_0123456789 REAL, field_10_0 UINT64, field_11_01 INT8, field_12_012 INT16 ARRAY, field_13_0123 INT16)");
      /* 706 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 CHAR ARRAY, field_3_0123 DATE, field_4_01234 BOOL, field_5_012345 CHAR, field_6_0123456 BOOL, field_7_01234567 CHAR, field_8_012345678 CHAR, field_9_0123456789 REAL, field_10_0 INT8, field_11_01 INT8)");
      /* 707 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 INT64, field_3_0123 INT8, field_4_01234 UINT8 ARRAY, field_5_012345 UINT8, field_6_0123456 UINT32, field_7_01234567 DATETIME, field_8_012345678 INT64, field_9_0123456789 CHAR, field_10_0 UINT32, field_11_01 CHAR ARRAY, field_12_012 INT16, field_13_0123 UINT16, field_14_01234 CHAR, field_15_012345 UINT8, field_16_0123456 HIRESTIME, field_17_01234567 INT64 ARRAY, field_18_012345678 HIRESTIME, field_19_0123456789 UINT16, field_20_0 DATETIME, field_21_01 BOOL, field_22_012 DATE, field_23_0123 RICHREAL ARRAY, field_24_01234 BOOL, field_25_012345 UINT8, field_26_0123456 CHAR, field_27_01234567 DATETIME, field_28_012345678 DATE, field_29_0123456789 BOOL, field_30_0 HIRESTIME, field_31_01 RICHREAL ARRAY, field_32_012 UINT64, field_33_0123 DATE, field_34_01234 UINT64, field_35_012345 RICHREAL, field_36_0123456 UINT16, field_37_01234567 UINT64, field_38_012345678 BOOL ARRAY, field_39_0123456789 DATE, field_40_0 UINT16 ARRAY, field_41_01 DATE ARRAY, field_42_012 DATETIME, field_43_0123 RICHREAL, field_44_01234 INT8, field_45_012345 CHAR ARRAY, field_46_0123456 INT8, field_47_01234567 UINT32, field_48_012345678 UINT32, field_49_0123456789 INT16, field_50_0 UINT32, field_51_01 UINT16, field_52_012 UINT16, field_53_0123 INT8, field_54_01234 UINT16, field_55_012345 UINT32 ARRAY, field_56_0123456 UINT32 ARRAY, field_57_01234567 INT64, field_58_012345678 INT16 ARRAY, field_59_0123456789 UINT16, field_60_0 INT32, field_61_01 CHAR, field_62_012 INT16, field_63_0123 RICHREAL, field_64_01234 REAL, field_65_012345 INT8, field_66_0123456 UINT8, field_67_01234567 UINT64, field_68_012345678 HIRESTIME, field_69_0123456789 RICHREAL ARRAY, field_70_0 UINT8, field_71_01 UINT64, field_72_012 DATETIME, field_73_0123 DATE, field_74_01234 INT64 ARRAY, field_75_012345 DATE ARRAY, field_76_0123456 INT8, field_77_01234567 INT32, field_78_012345678 UINT32 ARRAY, field_79_0123456789 INT32, field_80_0 REAL)");
      /* 708 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 HIRESTIME, field_3_0123 DATETIME ARRAY, field_4_01234 UINT64, field_5_012345 UINT64, field_6_0123456 HIRESTIME, field_7_01234567 RICHREAL ARRAY, field_8_012345678 UINT16, field_9_0123456789 UINT8, field_10_0 DATE, field_11_01 INT8 ARRAY, field_12_012 INT16 ARRAY, field_13_0123 UINT16, field_14_01234 UINT8 ARRAY, field_15_012345 INT16, field_16_0123456 DATETIME, field_17_01234567 INT32 ARRAY, field_18_012345678 RICHREAL ARRAY, field_19_0123456789 CHAR, field_20_0 UINT8, field_21_01 INT16, field_22_012 RICHREAL ARRAY, field_23_0123 DATETIME, field_24_01234 INT64, field_25_012345 UINT8)");
      /* 709 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 INT64, field_3_0123 CHAR, field_4_01234 UINT32, field_5_012345 BOOL, field_6_0123456 UINT32, field_7_01234567 INT8, field_8_012345678 INT16, field_9_0123456789 DATETIME, field_10_0 INT16, field_11_01 REAL ARRAY, field_12_012 UINT8, field_13_0123 INT32, field_14_01234 UINT16 ARRAY, field_15_012345 INT32, field_16_0123456 UINT32, field_17_01234567 HIRESTIME ARRAY, field_18_012345678 DATETIME, field_19_0123456789 RICHREAL, field_20_0 INT16, field_21_01 UINT32, field_22_012 UINT64, field_23_0123 UINT8, field_24_01234 UINT64, field_25_012345 DATE, field_26_0123456 INT32, field_27_01234567 DATE, field_28_012345678 HIRESTIME, field_29_0123456789 HIRESTIME, field_30_0 DATE, field_31_01 UINT8, field_32_012 UINT32, field_33_0123 DATETIME ARRAY, field_34_01234 BOOL, field_35_012345 REAL, field_36_0123456 CHAR, field_37_01234567 BOOL ARRAY, field_38_012345678 INT32, field_39_0123456789 HIRESTIME, field_40_0 INT32, field_41_01 DATE, field_42_012 UINT64, field_43_0123 DATETIME, field_44_01234 INT8, field_45_012345 BOOL, field_46_0123456 INT8, field_47_01234567 INT32, field_48_012345678 INT8, field_49_0123456789 INT16, field_50_0 REAL, field_51_01 INT8, field_52_012 UINT64, field_53_0123 HIRESTIME, field_54_01234 BOOL, field_55_012345 CHAR, field_56_0123456 UINT8, field_57_01234567 REAL ARRAY, field_58_012345678 REAL, field_59_0123456789 BOOL, field_60_0 HIRESTIME ARRAY, field_61_01 CHAR, field_62_012 DATE ARRAY, field_63_0123 UINT64, field_64_01234 INT16, field_65_012345 UINT8, field_66_0123456 UINT32, field_67_01234567 REAL, field_68_012345678 BOOL, field_69_0123456789 HIRESTIME, field_70_0 INT8, field_71_01 INT16, field_72_012 HIRESTIME, field_73_0123 INT64 ARRAY, field_74_01234 INT16, field_75_012345 UINT16)");
      /* 710 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 DATE, field_3_0123 RICHREAL, field_4_01234 DATE, field_5_012345 CHAR, field_6_0123456 UINT8, field_7_01234567 UINT32 ARRAY, field_8_012345678 RICHREAL, field_9_0123456789 INT32, field_10_0 UINT64, field_11_01 CHAR, field_12_012 UINT32, field_13_0123 INT8, field_14_01234 REAL ARRAY, field_15_012345 INT32, field_16_0123456 RICHREAL, field_17_01234567 DATE, field_18_012345678 INT16, field_19_0123456789 HIRESTIME, field_20_0 BOOL, field_21_01 INT32 ARRAY, field_22_012 RICHREAL ARRAY, field_23_0123 HIRESTIME, field_24_01234 UINT64 ARRAY, field_25_012345 UINT16, field_26_0123456 RICHREAL, field_27_01234567 CHAR, field_28_012345678 INT16, field_29_0123456789 UINT16, field_30_0 INT32 ARRAY, field_31_01 BOOL, field_32_012 UINT32, field_33_0123 CHAR, field_34_01234 INT16 ARRAY, field_35_012345 INT8, field_36_0123456 UINT32, field_37_01234567 DATE, field_38_012345678 UINT64, field_39_0123456789 UINT32, field_40_0 DATE ARRAY, field_41_01 UINT16, field_42_012 DATETIME ARRAY, field_43_0123 UINT16, field_44_01234 DATE, field_45_012345 UINT8, field_46_0123456 INT8 ARRAY, field_47_01234567 UINT64, field_48_012345678 INT32, field_49_0123456789 CHAR, field_50_0 RICHREAL, field_51_01 CHAR, field_52_012 INT16 ARRAY, field_53_0123 INT8, field_54_01234 UINT8, field_55_012345 DATETIME, field_56_0123456 HIRESTIME, field_57_01234567 DATETIME ARRAY, field_58_012345678 HIRESTIME, field_59_0123456789 INT32, field_60_0 BOOL, field_61_01 INT64, field_62_012 INT8, field_63_0123 INT8, field_64_01234 BOOL, field_65_012345 UINT64, field_66_0123456 INT32, field_67_01234567 DATETIME, field_68_012345678 BOOL, field_69_0123456789 INT8, field_70_0 UINT8 ARRAY, field_71_01 DATE, field_72_012 UINT8 ARRAY, field_73_0123 INT64, field_74_01234 HIRESTIME)");
      /* 711 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 INT16, field_3_0123 UINT32 ARRAY, field_4_01234 HIRESTIME, field_5_012345 UINT8, field_6_0123456 BOOL ARRAY, field_7_01234567 CHAR, field_8_012345678 INT64, field_9_0123456789 UINT64, field_10_0 INT8, field_11_01 UINT32, field_12_012 BOOL, field_13_0123 UINT32 ARRAY, field_14_01234 REAL, field_15_012345 RICHREAL, field_16_0123456 HIRESTIME, field_17_01234567 INT16, field_18_012345678 RICHREAL, field_19_0123456789 HIRESTIME, field_20_0 DATE, field_21_01 INT8 ARRAY, field_22_012 INT64, field_23_0123 BOOL ARRAY, field_24_01234 DATETIME, field_25_012345 DATE, field_26_0123456 INT16, field_27_01234567 INT64 ARRAY, field_28_012345678 INT64, field_29_0123456789 INT8 ARRAY, field_30_0 INT64 ARRAY, field_31_01 HIRESTIME, field_32_012 REAL, field_33_0123 UINT32 ARRAY, field_34_01234 UINT64 ARRAY, field_35_012345 HIRESTIME ARRAY, field_36_0123456 UINT16, field_37_01234567 HIRESTIME, field_38_012345678 CHAR, field_39_0123456789 UINT64, field_40_0 INT8, field_41_01 RICHREAL ARRAY, field_42_012 DATETIME, field_43_0123 HIRESTIME ARRAY, field_44_01234 INT8, field_45_012345 DATETIME, field_46_0123456 INT8, field_47_01234567 INT64, field_48_012345678 HIRESTIME, field_49_0123456789 DATE, field_50_0 INT32, field_51_01 INT8 ARRAY, field_52_012 INT32, field_53_0123 INT16)");
      /* 712 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 BOOL, field_3_0123 HIRESTIME, field_4_01234 DATETIME, field_5_012345 INT16, field_6_0123456 UINT8, field_7_01234567 UINT8, field_8_012345678 DATETIME, field_9_0123456789 CHAR, field_10_0 HIRESTIME, field_11_01 REAL, field_12_012 UINT16, field_13_0123 REAL, field_14_01234 INT64, field_15_012345 CHAR, field_16_0123456 RICHREAL, field_17_01234567 BOOL ARRAY, field_18_012345678 UINT32, field_19_0123456789 INT16, field_20_0 DATETIME, field_21_01 INT8, field_22_012 INT16 ARRAY, field_23_0123 BOOL, field_24_01234 RICHREAL, field_25_012345 BOOL, field_26_0123456 UINT8, field_27_01234567 RICHREAL ARRAY, field_28_012345678 UINT8, field_29_0123456789 UINT64, field_30_0 CHAR, field_31_01 INT8)");
      /* 713 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 UINT16, field_3_0123 REAL, field_4_01234 DATE, field_5_012345 INT64, field_6_0123456 UINT32 ARRAY, field_7_01234567 UINT16, field_8_012345678 RICHREAL ARRAY, field_9_0123456789 UINT64, field_10_0 DATE, field_11_01 UINT16 ARRAY, field_12_012 BOOL, field_13_0123 UINT64, field_14_01234 INT8 ARRAY, field_15_012345 BOOL ARRAY, field_16_0123456 UINT8, field_17_01234567 INT16 ARRAY, field_18_012345678 HIRESTIME, field_19_0123456789 BOOL ARRAY, field_20_0 INT32, field_21_01 UINT64, field_22_012 BOOL ARRAY, field_23_0123 UINT64, field_24_01234 REAL, field_25_012345 UINT32, field_26_0123456 INT32, field_27_01234567 DATETIME, field_28_012345678 HIRESTIME, field_29_0123456789 REAL, field_30_0 UINT64 ARRAY)");
      /* 714 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 DATE ARRAY, field_3_0123 UINT32, field_4_01234 UINT16, field_5_012345 HIRESTIME, field_6_0123456 UINT16, field_7_01234567 INT32, field_8_012345678 BOOL, field_9_0123456789 INT16, field_10_0 INT64, field_11_01 INT16, field_12_012 RICHREAL, field_13_0123 DATE, field_14_01234 DATETIME, field_15_012345 UINT32, field_16_0123456 INT16 ARRAY, field_17_01234567 INT64, field_18_012345678 BOOL, field_19_0123456789 UINT32, field_20_0 INT16, field_21_01 RICHREAL, field_22_012 UINT8, field_23_0123 DATETIME, field_24_01234 UINT16, field_25_012345 INT64, field_26_0123456 DATE, field_27_01234567 UINT64, field_28_012345678 BOOL, field_29_0123456789 INT8 ARRAY, field_30_0 HIRESTIME, field_31_01 BOOL ARRAY, field_32_012 UINT8 ARRAY, field_33_0123 INT64, field_34_01234 UINT8, field_35_012345 DATE, field_36_0123456 RICHREAL, field_37_01234567 UINT32, field_38_012345678 UINT32, field_39_0123456789 INT16, field_40_0 INT32 ARRAY, field_41_01 UINT16, field_42_012 INT8, field_43_0123 INT16, field_44_01234 CHAR, field_45_012345 INT32, field_46_0123456 RICHREAL, field_47_01234567 UINT64 ARRAY, field_48_012345678 UINT8, field_49_0123456789 RICHREAL, field_50_0 INT32, field_51_01 UINT64, field_52_012 BOOL, field_53_0123 UINT8, field_54_01234 INT32, field_55_012345 HIRESTIME ARRAY, field_56_0123456 UINT16, field_57_01234567 INT16, field_58_012345678 DATE, field_59_0123456789 RICHREAL, field_60_0 CHAR, field_61_01 HIRESTIME, field_62_012 UINT16, field_63_0123 UINT64, field_64_01234 CHAR ARRAY, field_65_012345 DATETIME ARRAY, field_66_0123456 INT32, field_67_01234567 DATE, field_68_012345678 UINT16, field_69_0123456789 UINT8 ARRAY, field_70_0 BOOL, field_71_01 UINT16, field_72_012 DATE ARRAY, field_73_0123 INT8, field_74_01234 CHAR, field_75_012345 UINT8, field_76_0123456 INT64, field_77_01234567 UINT32, field_78_012345678 UINT16, field_79_0123456789 UINT64, field_80_0 BOOL, field_81_01 INT16, field_82_012 INT8, field_83_0123 INT64, field_84_01234 UINT16, field_85_012345 INT32, field_86_0123456 UINT8, field_87_01234567 HIRESTIME, field_88_012345678 DATETIME, field_89_0123456789 BOOL ARRAY, field_90_0 UINT32, field_91_01 INT32)");
      /* 715 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME ARRAY, field_2_012 REAL, field_3_0123 CHAR, field_4_01234 INT64, field_5_012345 INT16, field_6_0123456 INT64 ARRAY, field_7_01234567 RICHREAL, field_8_012345678 CHAR, field_9_0123456789 DATE ARRAY, field_10_0 REAL ARRAY, field_11_01 INT16, field_12_012 INT32 ARRAY, field_13_0123 CHAR, field_14_01234 INT8, field_15_012345 INT16, field_16_0123456 INT64, field_17_01234567 HIRESTIME ARRAY, field_18_012345678 HIRESTIME, field_19_0123456789 DATE, field_20_0 REAL, field_21_01 INT32, field_22_012 INT64, field_23_0123 DATE, field_24_01234 BOOL, field_25_012345 DATETIME, field_26_0123456 BOOL ARRAY, field_27_01234567 INT32, field_28_012345678 INT8, field_29_0123456789 INT16 ARRAY, field_30_0 BOOL, field_31_01 INT16, field_32_012 INT16, field_33_0123 INT8, field_34_01234 UINT16, field_35_012345 REAL, field_36_0123456 INT32, field_37_01234567 UINT32, field_38_012345678 UINT16, field_39_0123456789 INT64 ARRAY, field_40_0 REAL, field_41_01 DATETIME, field_42_012 UINT64 ARRAY, field_43_0123 RICHREAL ARRAY, field_44_01234 INT64 ARRAY, field_45_012345 INT64, field_46_0123456 BOOL, field_47_01234567 RICHREAL, field_48_012345678 BOOL, field_49_0123456789 UINT16, field_50_0 REAL, field_51_01 INT8, field_52_012 HIRESTIME, field_53_0123 INT64 ARRAY, field_54_01234 DATETIME, field_55_012345 REAL ARRAY, field_56_0123456 INT32, field_57_01234567 UINT64 ARRAY, field_58_012345678 UINT32, field_59_0123456789 BOOL, field_60_0 UINT8)");
      /* 716 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 BOOL, field_3_0123 RICHREAL, field_4_01234 UINT64, field_5_012345 DATE, field_6_0123456 INT64, field_7_01234567 CHAR, field_8_012345678 DATETIME, field_9_0123456789 DATE, field_10_0 INT8, field_11_01 DATE, field_12_012 INT8, field_13_0123 INT64 ARRAY, field_14_01234 INT8 ARRAY, field_15_012345 INT8, field_16_0123456 REAL ARRAY, field_17_01234567 CHAR, field_18_012345678 INT64, field_19_0123456789 UINT8, field_20_0 RICHREAL, field_21_01 INT64 ARRAY, field_22_012 INT16, field_23_0123 UINT32, field_24_01234 INT8, field_25_012345 REAL, field_26_0123456 INT16 ARRAY, field_27_01234567 CHAR ARRAY, field_28_012345678 INT16 ARRAY, field_29_0123456789 DATE, field_30_0 UINT8, field_31_01 HIRESTIME, field_32_012 DATETIME ARRAY, field_33_0123 INT64 ARRAY, field_34_01234 INT8, field_35_012345 INT32, field_36_0123456 DATETIME, field_37_01234567 CHAR, field_38_012345678 RICHREAL, field_39_0123456789 UINT32, field_40_0 INT8, field_41_01 UINT32 ARRAY, field_42_012 HIRESTIME, field_43_0123 BOOL, field_44_01234 RICHREAL, field_45_012345 UINT64 ARRAY, field_46_0123456 REAL, field_47_01234567 INT64, field_48_012345678 UINT16 ARRAY, field_49_0123456789 INT64, field_50_0 REAL, field_51_01 BOOL, field_52_012 DATE, field_53_0123 DATETIME, field_54_01234 HIRESTIME, field_55_012345 UINT8, field_56_0123456 BOOL, field_57_01234567 INT64, field_58_012345678 INT64, field_59_0123456789 DATETIME, field_60_0 UINT16, field_61_01 INT8, field_62_012 UINT16, field_63_0123 HIRESTIME, field_64_01234 UINT32, field_65_012345 DATETIME, field_66_0123456 UINT64, field_67_01234567 INT8, field_68_012345678 UINT16, field_69_0123456789 RICHREAL, field_70_0 BOOL, field_71_01 DATETIME, field_72_012 INT8, field_73_0123 DATETIME, field_74_01234 INT8, field_75_012345 INT16, field_76_0123456 UINT16, field_77_01234567 HIRESTIME, field_78_012345678 UINT64, field_79_0123456789 UINT64, field_80_0 BOOL, field_81_01 DATETIME ARRAY)");
      /* 717 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 UINT16, field_3_0123 INT32, field_4_01234 INT64, field_5_012345 RICHREAL, field_6_0123456 INT32, field_7_01234567 HIRESTIME, field_8_012345678 DATE, field_9_0123456789 UINT32, field_10_0 UINT16, field_11_01 UINT16, field_12_012 RICHREAL ARRAY, field_13_0123 REAL, field_14_01234 INT32, field_15_012345 HIRESTIME, field_16_0123456 DATE, field_17_01234567 INT64, field_18_012345678 RICHREAL, field_19_0123456789 DATETIME, field_20_0 BOOL, field_21_01 UINT8, field_22_012 RICHREAL, field_23_0123 UINT32, field_24_01234 CHAR, field_25_012345 UINT32, field_26_0123456 CHAR ARRAY, field_27_01234567 INT32 ARRAY, field_28_012345678 RICHREAL, field_29_0123456789 REAL, field_30_0 RICHREAL, field_31_01 DATETIME ARRAY, field_32_012 DATE, field_33_0123 REAL, field_34_01234 HIRESTIME, field_35_012345 CHAR, field_36_0123456 INT8, field_37_01234567 REAL, field_38_012345678 UINT32, field_39_0123456789 DATE, field_40_0 DATETIME, field_41_01 HIRESTIME, field_42_012 UINT8 ARRAY, field_43_0123 UINT16, field_44_01234 HIRESTIME ARRAY, field_45_012345 DATETIME, field_46_0123456 BOOL, field_47_01234567 UINT8, field_48_012345678 BOOL, field_49_0123456789 DATETIME, field_50_0 INT32, field_51_01 INT32, field_52_012 REAL, field_53_0123 INT16, field_54_01234 UINT32, field_55_012345 BOOL, field_56_0123456 REAL, field_57_01234567 HIRESTIME, field_58_012345678 INT32 ARRAY, field_59_0123456789 INT8, field_60_0 HIRESTIME, field_61_01 INT32 ARRAY, field_62_012 HIRESTIME, field_63_0123 UINT32 ARRAY, field_64_01234 UINT16 ARRAY, field_65_012345 UINT16, field_66_0123456 BOOL, field_67_01234567 BOOL, field_68_012345678 UINT64, field_69_0123456789 DATETIME, field_70_0 HIRESTIME)");
      /* 718 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 REAL, field_3_0123 UINT16, field_4_01234 UINT8, field_5_012345 CHAR, field_6_0123456 INT16 ARRAY, field_7_01234567 HIRESTIME ARRAY, field_8_012345678 BOOL, field_9_0123456789 UINT64, field_10_0 INT64, field_11_01 CHAR, field_12_012 UINT8, field_13_0123 UINT64, field_14_01234 DATE ARRAY, field_15_012345 UINT64 ARRAY, field_16_0123456 INT8, field_17_01234567 DATE, field_18_012345678 DATETIME, field_19_0123456789 CHAR, field_20_0 UINT16, field_21_01 UINT16, field_22_012 CHAR ARRAY, field_23_0123 INT32, field_24_01234 REAL ARRAY, field_25_012345 BOOL, field_26_0123456 CHAR, field_27_01234567 UINT16, field_28_012345678 REAL, field_29_0123456789 RICHREAL, field_30_0 UINT64 ARRAY, field_31_01 UINT8, field_32_012 INT64 ARRAY, field_33_0123 UINT32, field_34_01234 UINT64, field_35_012345 UINT16, field_36_0123456 DATE ARRAY, field_37_01234567 DATE, field_38_012345678 DATETIME ARRAY, field_39_0123456789 INT64, field_40_0 INT64, field_41_01 UINT8 ARRAY, field_42_012 CHAR, field_43_0123 INT8, field_44_01234 RICHREAL, field_45_012345 DATE, field_46_0123456 CHAR, field_47_01234567 INT64, field_48_012345678 INT16, field_49_0123456789 HIRESTIME ARRAY, field_50_0 INT32, field_51_01 INT64 ARRAY, field_52_012 DATETIME, field_53_0123 INT16 ARRAY, field_54_01234 INT64, field_55_012345 HIRESTIME ARRAY, field_56_0123456 RICHREAL, field_57_01234567 INT64, field_58_012345678 RICHREAL ARRAY, field_59_0123456789 UINT32, field_60_0 DATE, field_61_01 INT8, field_62_012 RICHREAL, field_63_0123 UINT32, field_64_01234 INT32 ARRAY)");
      /* 719 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 INT16, field_3_0123 UINT16, field_4_01234 UINT32, field_5_012345 BOOL, field_6_0123456 INT16, field_7_01234567 UINT16, field_8_012345678 UINT16, field_9_0123456789 RICHREAL ARRAY, field_10_0 CHAR, field_11_01 INT8, field_12_012 UINT16, field_13_0123 DATE, field_14_01234 UINT8, field_15_012345 UINT16, field_16_0123456 HIRESTIME ARRAY, field_17_01234567 INT8 ARRAY, field_18_012345678 INT32, field_19_0123456789 UINT16, field_20_0 UINT16 ARRAY, field_21_01 HIRESTIME, field_22_012 UINT64, field_23_0123 BOOL, field_24_01234 HIRESTIME, field_25_012345 INT64, field_26_0123456 BOOL ARRAY, field_27_01234567 UINT64, field_28_012345678 UINT8, field_29_0123456789 RICHREAL, field_30_0 UINT64, field_31_01 UINT64, field_32_012 UINT64, field_33_0123 UINT32, field_34_01234 INT8, field_35_012345 UINT64, field_36_0123456 INT8, field_37_01234567 INT8 ARRAY, field_38_012345678 INT8, field_39_0123456789 BOOL ARRAY, field_40_0 DATE ARRAY, field_41_01 UINT8, field_42_012 INT64 ARRAY, field_43_0123 HIRESTIME ARRAY, field_44_01234 RICHREAL ARRAY, field_45_012345 HIRESTIME, field_46_0123456 BOOL ARRAY, field_47_01234567 UINT64, field_48_012345678 UINT32, field_49_0123456789 BOOL, field_50_0 REAL, field_51_01 UINT64, field_52_012 UINT64, field_53_0123 UINT16 ARRAY, field_54_01234 BOOL, field_55_012345 UINT16, field_56_0123456 CHAR, field_57_01234567 INT32 ARRAY, field_58_012345678 REAL ARRAY, field_59_0123456789 DATETIME, field_60_0 UINT16, field_61_01 BOOL ARRAY, field_62_012 RICHREAL, field_63_0123 INT8, field_64_01234 INT8, field_65_012345 INT8, field_66_0123456 BOOL, field_67_01234567 DATE, field_68_012345678 UINT8, field_69_0123456789 INT64 ARRAY, field_70_0 HIRESTIME, field_71_01 UINT8 ARRAY, field_72_012 INT64, field_73_0123 UINT16, field_74_01234 BOOL, field_75_012345 REAL, field_76_0123456 UINT32, field_77_01234567 UINT16, field_78_012345678 INT32, field_79_0123456789 BOOL, field_80_0 UINT32, field_81_01 UINT8, field_82_012 HIRESTIME, field_83_0123 INT16 ARRAY, field_84_01234 DATETIME)");
      /* 720 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 INT8, field_3_0123 INT32, field_4_01234 UINT8, field_5_012345 BOOL, field_6_0123456 DATETIME, field_7_01234567 INT64, field_8_012345678 HIRESTIME, field_9_0123456789 INT32, field_10_0 UINT16, field_11_01 BOOL, field_12_012 BOOL, field_13_0123 REAL, field_14_01234 HIRESTIME, field_15_012345 INT64, field_16_0123456 RICHREAL)");
      /* 721 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 UINT16 ARRAY, field_3_0123 CHAR ARRAY, field_4_01234 INT32 ARRAY, field_5_012345 RICHREAL, field_6_0123456 CHAR ARRAY, field_7_01234567 RICHREAL, field_8_012345678 UINT8, field_9_0123456789 UINT32, field_10_0 UINT16, field_11_01 UINT32, field_12_012 INT32, field_13_0123 INT32, field_14_01234 RICHREAL, field_15_012345 DATETIME, field_16_0123456 INT32 ARRAY, field_17_01234567 DATETIME, field_18_012345678 CHAR, field_19_0123456789 CHAR ARRAY, field_20_0 REAL, field_21_01 CHAR, field_22_012 UINT8 ARRAY, field_23_0123 UINT8, field_24_01234 INT8, field_25_012345 BOOL, field_26_0123456 BOOL, field_27_01234567 RICHREAL ARRAY, field_28_012345678 INT16)");
      /* 722 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 INT16, field_3_0123 UINT32, field_4_01234 BOOL ARRAY)");
      /* 723 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 INT32 ARRAY, field_3_0123 INT8, field_4_01234 INT16, field_5_012345 CHAR, field_6_0123456 BOOL, field_7_01234567 INT8, field_8_012345678 REAL ARRAY, field_9_0123456789 INT8, field_10_0 UINT64, field_11_01 UINT64, field_12_012 RICHREAL, field_13_0123 UINT16, field_14_01234 BOOL, field_15_012345 INT8, field_16_0123456 UINT64, field_17_01234567 RICHREAL, field_18_012345678 CHAR, field_19_0123456789 INT64 ARRAY, field_20_0 INT64, field_21_01 BOOL, field_22_012 INT16, field_23_0123 BOOL, field_24_01234 UINT32)");
      /* 724 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 REAL, field_3_0123 UINT64, field_4_01234 INT8, field_5_012345 INT32, field_6_0123456 RICHREAL ARRAY, field_7_01234567 INT8, field_8_012345678 INT8, field_9_0123456789 REAL, field_10_0 DATETIME ARRAY, field_11_01 INT64, field_12_012 INT64, field_13_0123 INT64, field_14_01234 INT8 ARRAY, field_15_012345 UINT32, field_16_0123456 INT32, field_17_01234567 RICHREAL, field_18_012345678 CHAR, field_19_0123456789 HIRESTIME, field_20_0 UINT16, field_21_01 BOOL ARRAY, field_22_012 UINT64, field_23_0123 HIRESTIME, field_24_01234 INT8, field_25_012345 INT8 ARRAY, field_26_0123456 INT64, field_27_01234567 RICHREAL, field_28_012345678 UINT8, field_29_0123456789 INT16, field_30_0 REAL ARRAY, field_31_01 UINT32, field_32_012 DATETIME, field_33_0123 UINT16 ARRAY, field_34_01234 UINT8, field_35_012345 BOOL, field_36_0123456 INT64, field_37_01234567 INT16, field_38_012345678 UINT64, field_39_0123456789 BOOL, field_40_0 CHAR, field_41_01 DATETIME, field_42_012 HIRESTIME ARRAY, field_43_0123 UINT32 ARRAY, field_44_01234 INT32, field_45_012345 INT64, field_46_0123456 CHAR, field_47_01234567 REAL, field_48_012345678 REAL ARRAY, field_49_0123456789 UINT64, field_50_0 UINT8 ARRAY, field_51_01 INT32, field_52_012 INT32, field_53_0123 CHAR, field_54_01234 DATE, field_55_012345 CHAR, field_56_0123456 INT64, field_57_01234567 INT8 ARRAY, field_58_012345678 HIRESTIME, field_59_0123456789 BOOL, field_60_0 DATE, field_61_01 BOOL, field_62_012 INT32, field_63_0123 CHAR, field_64_01234 BOOL, field_65_012345 BOOL, field_66_0123456 INT8, field_67_01234567 UINT16, field_68_012345678 UINT64, field_69_0123456789 CHAR ARRAY, field_70_0 HIRESTIME ARRAY, field_71_01 RICHREAL, field_72_012 REAL, field_73_0123 UINT8, field_74_01234 DATETIME, field_75_012345 DATE ARRAY, field_76_0123456 UINT32, field_77_01234567 DATE ARRAY, field_78_012345678 HIRESTIME ARRAY, field_79_0123456789 REAL ARRAY)");
      /* 725 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 REAL, field_3_0123 INT16, field_4_01234 BOOL, field_5_012345 UINT16, field_6_0123456 DATE, field_7_01234567 UINT16, field_8_012345678 DATE ARRAY, field_9_0123456789 DATETIME, field_10_0 UINT8, field_11_01 UINT64, field_12_012 DATETIME ARRAY, field_13_0123 UINT8, field_14_01234 UINT16, field_15_012345 DATE ARRAY, field_16_0123456 CHAR, field_17_01234567 REAL, field_18_012345678 HIRESTIME ARRAY, field_19_0123456789 INT16 ARRAY, field_20_0 UINT16, field_21_01 DATE ARRAY, field_22_012 HIRESTIME ARRAY, field_23_0123 DATETIME, field_24_01234 DATE, field_25_012345 UINT32, field_26_0123456 UINT64 ARRAY, field_27_01234567 INT16, field_28_012345678 INT8, field_29_0123456789 CHAR ARRAY, field_30_0 UINT32, field_31_01 UINT64, field_32_012 DATETIME, field_33_0123 INT16, field_34_01234 UINT32, field_35_012345 INT8, field_36_0123456 INT16, field_37_01234567 DATETIME, field_38_012345678 INT8 ARRAY, field_39_0123456789 CHAR, field_40_0 INT64, field_41_01 UINT8, field_42_012 DATE, field_43_0123 INT16 ARRAY, field_44_01234 UINT64, field_45_012345 INT64, field_46_0123456 DATETIME ARRAY, field_47_01234567 UINT32, field_48_012345678 RICHREAL, field_49_0123456789 UINT8, field_50_0 UINT16, field_51_01 RICHREAL, field_52_012 BOOL, field_53_0123 INT64, field_54_01234 REAL ARRAY, field_55_012345 UINT32, field_56_0123456 CHAR ARRAY, field_57_01234567 INT8, field_58_012345678 INT64, field_59_0123456789 UINT8 ARRAY, field_60_0 CHAR, field_61_01 DATE, field_62_012 INT16, field_63_0123 BOOL, field_64_01234 REAL, field_65_012345 DATE ARRAY, field_66_0123456 HIRESTIME, field_67_01234567 INT32, field_68_012345678 UINT8, field_69_0123456789 DATE, field_70_0 UINT32 ARRAY, field_71_01 INT64, field_72_012 INT32, field_73_0123 UINT8 ARRAY, field_74_01234 HIRESTIME, field_75_012345 HIRESTIME, field_76_0123456 UINT64, field_77_01234567 DATETIME, field_78_012345678 CHAR ARRAY, field_79_0123456789 INT8, field_80_0 DATE ARRAY, field_81_01 UINT32, field_82_012 INT16, field_83_0123 UINT32, field_84_01234 BOOL ARRAY, field_85_012345 BOOL, field_86_0123456 UINT32, field_87_01234567 INT16 ARRAY, field_88_012345678 INT32, field_89_0123456789 UINT16, field_90_0 HIRESTIME, field_91_01 INT16, field_92_012 RICHREAL ARRAY, field_93_0123 UINT16, field_94_01234 UINT16 ARRAY)");
      /* 726 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 INT8 ARRAY, field_3_0123 INT16, field_4_01234 INT16 ARRAY, field_5_012345 UINT64 ARRAY, field_6_0123456 DATE, field_7_01234567 UINT16, field_8_012345678 INT16, field_9_0123456789 UINT64, field_10_0 INT32 ARRAY, field_11_01 DATE, field_12_012 UINT16 ARRAY, field_13_0123 INT32 ARRAY, field_14_01234 HIRESTIME, field_15_012345 DATE, field_16_0123456 INT16 ARRAY, field_17_01234567 UINT8, field_18_012345678 INT16, field_19_0123456789 DATE, field_20_0 UINT16, field_21_01 BOOL, field_22_012 INT64, field_23_0123 INT8, field_24_01234 DATETIME, field_25_012345 HIRESTIME ARRAY, field_26_0123456 INT32, field_27_01234567 INT16, field_28_012345678 HIRESTIME, field_29_0123456789 UINT16, field_30_0 RICHREAL, field_31_01 DATETIME, field_32_012 HIRESTIME ARRAY, field_33_0123 CHAR ARRAY, field_34_01234 UINT32, field_35_012345 UINT32, field_36_0123456 CHAR ARRAY, field_37_01234567 BOOL, field_38_012345678 UINT64, field_39_0123456789 INT16, field_40_0 UINT16, field_41_01 BOOL ARRAY, field_42_012 INT32, field_43_0123 INT32, field_44_01234 INT64, field_45_012345 DATE, field_46_0123456 REAL, field_47_01234567 UINT32, field_48_012345678 BOOL, field_49_0123456789 BOOL ARRAY, field_50_0 INT16, field_51_01 UINT32, field_52_012 CHAR, field_53_0123 RICHREAL)");
      /* 727 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 RICHREAL, field_3_0123 CHAR, field_4_01234 INT32, field_5_012345 DATE, field_6_0123456 REAL, field_7_01234567 UINT16, field_8_012345678 INT16, field_9_0123456789 UINT8, field_10_0 UINT64, field_11_01 INT32 ARRAY, field_12_012 REAL, field_13_0123 UINT16, field_14_01234 UINT16, field_15_012345 CHAR, field_16_0123456 UINT8 ARRAY, field_17_01234567 RICHREAL, field_18_012345678 INT32 ARRAY, field_19_0123456789 UINT32, field_20_0 CHAR ARRAY, field_21_01 UINT64, field_22_012 UINT8, field_23_0123 INT8 ARRAY, field_24_01234 DATETIME ARRAY, field_25_012345 UINT64, field_26_0123456 RICHREAL, field_27_01234567 INT16, field_28_012345678 DATETIME, field_29_0123456789 CHAR, field_30_0 UINT64, field_31_01 RICHREAL)");
      /* 728 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 DATETIME, field_3_0123 DATETIME, field_4_01234 INT16, field_5_012345 INT8, field_6_0123456 RICHREAL, field_7_01234567 INT64 ARRAY, field_8_012345678 UINT32, field_9_0123456789 UINT32, field_10_0 REAL, field_11_01 BOOL, field_12_012 DATETIME, field_13_0123 RICHREAL ARRAY, field_14_01234 UINT16 ARRAY, field_15_012345 INT8 ARRAY, field_16_0123456 INT32, field_17_01234567 DATE, field_18_012345678 INT64, field_19_0123456789 REAL, field_20_0 HIRESTIME, field_21_01 HIRESTIME, field_22_012 UINT32, field_23_0123 RICHREAL ARRAY, field_24_01234 INT32, field_25_012345 INT16 ARRAY, field_26_0123456 INT32, field_27_01234567 DATETIME, field_28_012345678 RICHREAL, field_29_0123456789 UINT16, field_30_0 INT32, field_31_01 BOOL)");
      /* 729 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 CHAR, field_3_0123 UINT64, field_4_01234 CHAR, field_5_012345 UINT64, field_6_0123456 CHAR, field_7_01234567 DATETIME, field_8_012345678 UINT16 ARRAY, field_9_0123456789 INT32, field_10_0 HIRESTIME, field_11_01 UINT16, field_12_012 HIRESTIME, field_13_0123 DATETIME, field_14_01234 INT64 ARRAY, field_15_012345 INT16, field_16_0123456 BOOL, field_17_01234567 RICHREAL ARRAY, field_18_012345678 INT16, field_19_0123456789 DATE, field_20_0 UINT16, field_21_01 INT64 ARRAY, field_22_012 REAL, field_23_0123 CHAR, field_24_01234 INT16, field_25_012345 INT64, field_26_0123456 DATETIME ARRAY, field_27_01234567 HIRESTIME, field_28_012345678 UINT8 ARRAY, field_29_0123456789 UINT32, field_30_0 DATE, field_31_01 UINT32, field_32_012 UINT64, field_33_0123 INT16, field_34_01234 UINT16, field_35_012345 INT32, field_36_0123456 DATETIME, field_37_01234567 UINT16, field_38_012345678 UINT8, field_39_0123456789 RICHREAL, field_40_0 DATE ARRAY, field_41_01 BOOL, field_42_012 HIRESTIME, field_43_0123 INT8 ARRAY, field_44_01234 UINT32, field_45_012345 INT8, field_46_0123456 DATETIME, field_47_01234567 CHAR ARRAY)");
      /* 730 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 UINT32, field_3_0123 INT8, field_4_01234 UINT64 ARRAY, field_5_012345 INT64, field_6_0123456 UINT8, field_7_01234567 INT64, field_8_012345678 UINT64, field_9_0123456789 DATE ARRAY, field_10_0 INT8, field_11_01 DATE ARRAY, field_12_012 HIRESTIME, field_13_0123 UINT8 ARRAY, field_14_01234 INT8, field_15_012345 DATETIME ARRAY, field_16_0123456 CHAR, field_17_01234567 INT32, field_18_012345678 INT64, field_19_0123456789 UINT16, field_20_0 INT64, field_21_01 INT16, field_22_012 UINT16, field_23_0123 BOOL, field_24_01234 REAL, field_25_012345 INT16, field_26_0123456 INT8 ARRAY)");
      /* 731 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 UINT64, field_3_0123 UINT32, field_4_01234 DATE ARRAY, field_5_012345 BOOL, field_6_0123456 REAL, field_7_01234567 INT32 ARRAY, field_8_012345678 RICHREAL, field_9_0123456789 UINT32, field_10_0 BOOL, field_11_01 INT16 ARRAY, field_12_012 UINT16, field_13_0123 DATE, field_14_01234 RICHREAL, field_15_012345 BOOL, field_16_0123456 RICHREAL, field_17_01234567 BOOL ARRAY, field_18_012345678 HIRESTIME, field_19_0123456789 REAL ARRAY, field_20_0 UINT8, field_21_01 REAL, field_22_012 INT64, field_23_0123 BOOL ARRAY, field_24_01234 DATE, field_25_012345 UINT32, field_26_0123456 CHAR ARRAY)");
      /* 732 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 DATE, field_3_0123 BOOL, field_4_01234 DATETIME, field_5_012345 HIRESTIME, field_6_0123456 BOOL, field_7_01234567 RICHREAL ARRAY, field_8_012345678 INT16, field_9_0123456789 UINT32, field_10_0 UINT16, field_11_01 UINT8, field_12_012 UINT8, field_13_0123 REAL, field_14_01234 UINT8, field_15_012345 INT16, field_16_0123456 UINT8, field_17_01234567 INT16, field_18_012345678 CHAR, field_19_0123456789 UINT8, field_20_0 UINT32, field_21_01 UINT8, field_22_012 RICHREAL ARRAY, field_23_0123 DATE, field_24_01234 UINT8, field_25_012345 DATE, field_26_0123456 UINT16, field_27_01234567 DATETIME, field_28_012345678 REAL, field_29_0123456789 DATE, field_30_0 INT8 ARRAY, field_31_01 RICHREAL)");
      /* 733 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 CHAR, field_3_0123 CHAR ARRAY, field_4_01234 BOOL, field_5_012345 INT64, field_6_0123456 HIRESTIME, field_7_01234567 INT8, field_8_012345678 BOOL, field_9_0123456789 INT32, field_10_0 INT16, field_11_01 INT64, field_12_012 BOOL, field_13_0123 UINT32 ARRAY, field_14_01234 INT32, field_15_012345 INT16 ARRAY, field_16_0123456 INT32 ARRAY, field_17_01234567 UINT8 ARRAY, field_18_012345678 INT32 ARRAY, field_19_0123456789 UINT32, field_20_0 BOOL, field_21_01 UINT16, field_22_012 INT64, field_23_0123 UINT16, field_24_01234 HIRESTIME, field_25_012345 INT8, field_26_0123456 UINT16, field_27_01234567 CHAR, field_28_012345678 DATE, field_29_0123456789 RICHREAL, field_30_0 INT8, field_31_01 INT8, field_32_012 BOOL, field_33_0123 INT16, field_34_01234 INT32 ARRAY, field_35_012345 DATE, field_36_0123456 DATE ARRAY, field_37_01234567 DATETIME, field_38_012345678 INT8, field_39_0123456789 UINT32 ARRAY, field_40_0 INT8 ARRAY, field_41_01 REAL, field_42_012 BOOL, field_43_0123 DATE, field_44_01234 INT16, field_45_012345 UINT16, field_46_0123456 INT64, field_47_01234567 DATETIME ARRAY, field_48_012345678 UINT16, field_49_0123456789 HIRESTIME, field_50_0 UINT8 ARRAY, field_51_01 INT16, field_52_012 CHAR, field_53_0123 HIRESTIME, field_54_01234 BOOL, field_55_012345 BOOL ARRAY, field_56_0123456 CHAR, field_57_01234567 HIRESTIME, field_58_012345678 HIRESTIME, field_59_0123456789 UINT8 ARRAY, field_60_0 INT8, field_61_01 INT16, field_62_012 DATETIME ARRAY, field_63_0123 RICHREAL, field_64_01234 CHAR, field_65_012345 DATETIME, field_66_0123456 DATETIME, field_67_01234567 DATE, field_68_012345678 UINT32, field_69_0123456789 DATETIME, field_70_0 CHAR ARRAY, field_71_01 HIRESTIME, field_72_012 UINT64, field_73_0123 BOOL, field_74_01234 UINT8, field_75_012345 UINT64, field_76_0123456 INT8, field_77_01234567 UINT8, field_78_012345678 INT8, field_79_0123456789 INT64, field_80_0 UINT16 ARRAY, field_81_01 INT32, field_82_012 DATETIME, field_83_0123 INT16 ARRAY, field_84_01234 RICHREAL ARRAY, field_85_012345 UINT64 ARRAY, field_86_0123456 INT64, field_87_01234567 INT64 ARRAY, field_88_012345678 UINT64, field_89_0123456789 UINT32, field_90_0 REAL ARRAY, field_91_01 INT64)");
      /* 734 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 UINT32 ARRAY, field_3_0123 CHAR, field_4_01234 INT16 ARRAY, field_5_012345 UINT8, field_6_0123456 REAL, field_7_01234567 UINT8 ARRAY, field_8_012345678 UINT8 ARRAY, field_9_0123456789 CHAR, field_10_0 HIRESTIME ARRAY, field_11_01 HIRESTIME, field_12_012 INT16, field_13_0123 HIRESTIME, field_14_01234 CHAR ARRAY, field_15_012345 HIRESTIME, field_16_0123456 HIRESTIME ARRAY)");
      /* 735 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 DATETIME, field_3_0123 REAL, field_4_01234 CHAR ARRAY, field_5_012345 INT32, field_6_0123456 UINT64 ARRAY, field_7_01234567 DATE, field_8_012345678 BOOL, field_9_0123456789 BOOL, field_10_0 UINT64 ARRAY, field_11_01 DATE ARRAY)");
      /* 736 */ glbTypes.push_back("TABLE(field_1_01 INT64 ARRAY, field_2_012 DATE, field_3_0123 HIRESTIME ARRAY, field_4_01234 INT32, field_5_012345 DATETIME, field_6_0123456 INT64, field_7_01234567 INT64, field_8_012345678 REAL, field_9_0123456789 INT8 ARRAY, field_10_0 UINT16 ARRAY, field_11_01 INT32, field_12_012 INT8, field_13_0123 DATE, field_14_01234 UINT64, field_15_012345 UINT32 ARRAY, field_16_0123456 INT8, field_17_01234567 RICHREAL, field_18_012345678 RICHREAL, field_19_0123456789 INT32, field_20_0 INT16, field_21_01 UINT32, field_22_012 CHAR, field_23_0123 BOOL, field_24_01234 HIRESTIME, field_25_012345 UINT64, field_26_0123456 DATE, field_27_01234567 UINT32, field_28_012345678 DATETIME, field_29_0123456789 UINT16, field_30_0 INT8, field_31_01 RICHREAL, field_32_012 UINT16, field_33_0123 HIRESTIME ARRAY, field_34_01234 INT8 ARRAY, field_35_012345 INT16, field_36_0123456 UINT16 ARRAY, field_37_01234567 INT64, field_38_012345678 DATE ARRAY, field_39_0123456789 INT16, field_40_0 DATE, field_41_01 CHAR ARRAY, field_42_012 REAL, field_43_0123 UINT32, field_44_01234 UINT16, field_45_012345 BOOL, field_46_0123456 INT8, field_47_01234567 UINT8 ARRAY, field_48_012345678 UINT64, field_49_0123456789 UINT32, field_50_0 INT16, field_51_01 UINT32, field_52_012 INT32, field_53_0123 UINT16 ARRAY, field_54_01234 UINT16, field_55_012345 BOOL, field_56_0123456 UINT64, field_57_01234567 BOOL, field_58_012345678 HIRESTIME ARRAY, field_59_0123456789 INT16, field_60_0 DATETIME, field_61_01 UINT32, field_62_012 DATETIME, field_63_0123 RICHREAL, field_64_01234 DATE, field_65_012345 UINT16, field_66_0123456 INT64, field_67_01234567 DATETIME, field_68_012345678 INT8, field_69_0123456789 HIRESTIME ARRAY, field_70_0 REAL, field_71_01 INT32, field_72_012 DATE ARRAY, field_73_0123 INT8, field_74_01234 CHAR, field_75_012345 INT64, field_76_0123456 UINT32 ARRAY)");
      /* 737 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 CHAR, field_3_0123 INT32, field_4_01234 HIRESTIME, field_5_012345 DATETIME, field_6_0123456 UINT64 ARRAY, field_7_01234567 UINT16, field_8_012345678 REAL, field_9_0123456789 UINT16 ARRAY, field_10_0 HIRESTIME, field_11_01 UINT64, field_12_012 CHAR, field_13_0123 REAL, field_14_01234 BOOL, field_15_012345 DATE, field_16_0123456 UINT32 ARRAY, field_17_01234567 HIRESTIME, field_18_012345678 RICHREAL, field_19_0123456789 INT16, field_20_0 BOOL, field_21_01 CHAR, field_22_012 DATETIME ARRAY, field_23_0123 UINT64 ARRAY, field_24_01234 INT32, field_25_012345 INT32, field_26_0123456 INT8, field_27_01234567 BOOL, field_28_012345678 INT64, field_29_0123456789 REAL, field_30_0 DATE, field_31_01 HIRESTIME, field_32_012 UINT8, field_33_0123 UINT64, field_34_01234 UINT16, field_35_012345 DATE, field_36_0123456 UINT64 ARRAY, field_37_01234567 UINT32, field_38_012345678 HIRESTIME, field_39_0123456789 INT16, field_40_0 UINT16, field_41_01 UINT32, field_42_012 CHAR ARRAY, field_43_0123 INT32 ARRAY, field_44_01234 INT8, field_45_012345 RICHREAL, field_46_0123456 HIRESTIME, field_47_01234567 BOOL, field_48_012345678 DATETIME, field_49_0123456789 DATE)");
      /* 738 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 INT64, field_3_0123 RICHREAL, field_4_01234 HIRESTIME, field_5_012345 REAL, field_6_0123456 DATE, field_7_01234567 DATE, field_8_012345678 BOOL, field_9_0123456789 CHAR, field_10_0 HIRESTIME ARRAY, field_11_01 DATE, field_12_012 UINT16, field_13_0123 INT8, field_14_01234 DATE ARRAY, field_15_012345 INT16, field_16_0123456 BOOL, field_17_01234567 BOOL, field_18_012345678 RICHREAL ARRAY, field_19_0123456789 REAL, field_20_0 DATE ARRAY, field_21_01 HIRESTIME, field_22_012 UINT64, field_23_0123 REAL, field_24_01234 INT64, field_25_012345 UINT16, field_26_0123456 INT8, field_27_01234567 HIRESTIME ARRAY, field_28_012345678 DATETIME, field_29_0123456789 BOOL, field_30_0 UINT32, field_31_01 RICHREAL, field_32_012 UINT32 ARRAY, field_33_0123 CHAR ARRAY, field_34_01234 INT16, field_35_012345 INT32, field_36_0123456 INT8, field_37_01234567 INT64 ARRAY, field_38_012345678 INT32 ARRAY, field_39_0123456789 BOOL, field_40_0 CHAR, field_41_01 INT32, field_42_012 INT8 ARRAY, field_43_0123 INT32, field_44_01234 UINT32, field_45_012345 INT64, field_46_0123456 INT8, field_47_01234567 CHAR ARRAY, field_48_012345678 HIRESTIME ARRAY, field_49_0123456789 INT32, field_50_0 RICHREAL, field_51_01 INT64 ARRAY, field_52_012 UINT8, field_53_0123 UINT8, field_54_01234 CHAR, field_55_012345 INT64 ARRAY, field_56_0123456 CHAR, field_57_01234567 DATETIME, field_58_012345678 UINT16, field_59_0123456789 INT64, field_60_0 UINT64 ARRAY, field_61_01 UINT64, field_62_012 INT8 ARRAY, field_63_0123 INT8, field_64_01234 INT64, field_65_012345 UINT64, field_66_0123456 UINT64, field_67_01234567 CHAR, field_68_012345678 CHAR, field_69_0123456789 INT16, field_70_0 DATETIME, field_71_01 BOOL, field_72_012 INT16, field_73_0123 DATE, field_74_01234 RICHREAL)");
      /* 739 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 DATE, field_3_0123 BOOL ARRAY, field_4_01234 UINT32, field_5_012345 UINT32 ARRAY, field_6_0123456 UINT16, field_7_01234567 INT16, field_8_012345678 INT8, field_9_0123456789 RICHREAL ARRAY, field_10_0 CHAR, field_11_01 HIRESTIME ARRAY, field_12_012 INT8 ARRAY, field_13_0123 RICHREAL ARRAY, field_14_01234 HIRESTIME, field_15_012345 CHAR ARRAY, field_16_0123456 INT16, field_17_01234567 BOOL, field_18_012345678 HIRESTIME, field_19_0123456789 CHAR, field_20_0 UINT16 ARRAY, field_21_01 BOOL, field_22_012 INT8, field_23_0123 UINT16, field_24_01234 INT32, field_25_012345 INT32, field_26_0123456 INT16 ARRAY, field_27_01234567 INT8 ARRAY, field_28_012345678 UINT32, field_29_0123456789 UINT16, field_30_0 DATETIME ARRAY, field_31_01 INT16, field_32_012 REAL, field_33_0123 INT64 ARRAY, field_34_01234 UINT64, field_35_012345 UINT64, field_36_0123456 HIRESTIME, field_37_01234567 UINT8, field_38_012345678 INT32, field_39_0123456789 DATETIME, field_40_0 INT16, field_41_01 UINT32, field_42_012 INT64, field_43_0123 INT8, field_44_01234 HIRESTIME, field_45_012345 REAL, field_46_0123456 UINT16, field_47_01234567 DATE, field_48_012345678 INT64, field_49_0123456789 RICHREAL, field_50_0 DATETIME, field_51_01 DATETIME ARRAY, field_52_012 BOOL, field_53_0123 UINT64, field_54_01234 CHAR, field_55_012345 INT32, field_56_0123456 INT64, field_57_01234567 DATE, field_58_012345678 DATE, field_59_0123456789 REAL, field_60_0 INT32, field_61_01 INT8, field_62_012 BOOL, field_63_0123 INT32, field_64_01234 INT16, field_65_012345 DATE, field_66_0123456 DATE, field_67_01234567 INT64, field_68_012345678 DATETIME, field_69_0123456789 REAL, field_70_0 BOOL, field_71_01 REAL)");
      /* 740 */ glbTypes.push_back("TABLE");
      /* 741 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 HIRESTIME, field_3_0123 BOOL, field_4_01234 DATETIME ARRAY, field_5_012345 DATETIME, field_6_0123456 DATE, field_7_01234567 HIRESTIME, field_8_012345678 DATE, field_9_0123456789 REAL ARRAY, field_10_0 INT64, field_11_01 DATE, field_12_012 UINT8 ARRAY, field_13_0123 CHAR ARRAY, field_14_01234 INT16, field_15_012345 DATE, field_16_0123456 INT64, field_17_01234567 UINT8, field_18_012345678 UINT64, field_19_0123456789 DATETIME, field_20_0 REAL, field_21_01 INT32 ARRAY, field_22_012 DATE, field_23_0123 REAL ARRAY, field_24_01234 DATETIME, field_25_012345 UINT8 ARRAY, field_26_0123456 RICHREAL, field_27_01234567 INT8, field_28_012345678 DATE ARRAY, field_29_0123456789 HIRESTIME ARRAY)");
      /* 742 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 REAL, field_3_0123 INT16, field_4_01234 UINT8, field_5_012345 UINT8 ARRAY, field_6_0123456 DATETIME, field_7_01234567 UINT16, field_8_012345678 CHAR, field_9_0123456789 HIRESTIME, field_10_0 RICHREAL, field_11_01 REAL ARRAY, field_12_012 INT64, field_13_0123 RICHREAL, field_14_01234 HIRESTIME, field_15_012345 INT8, field_16_0123456 INT16, field_17_01234567 UINT32, field_18_012345678 BOOL ARRAY, field_19_0123456789 UINT8, field_20_0 INT32 ARRAY, field_21_01 INT8, field_22_012 BOOL, field_23_0123 UINT32, field_24_01234 CHAR, field_25_012345 INT64, field_26_0123456 UINT16, field_27_01234567 DATE, field_28_012345678 INT16 ARRAY, field_29_0123456789 UINT16, field_30_0 HIRESTIME, field_31_01 HIRESTIME, field_32_012 INT64 ARRAY, field_33_0123 INT16, field_34_01234 REAL, field_35_012345 UINT64, field_36_0123456 DATE ARRAY, field_37_01234567 DATETIME ARRAY, field_38_012345678 BOOL, field_39_0123456789 RICHREAL ARRAY, field_40_0 INT32, field_41_01 INT8, field_42_012 DATETIME ARRAY, field_43_0123 DATETIME, field_44_01234 DATE, field_45_012345 DATETIME, field_46_0123456 DATE, field_47_01234567 HIRESTIME, field_48_012345678 DATE, field_49_0123456789 DATETIME, field_50_0 DATE, field_51_01 UINT32 ARRAY, field_52_012 INT8, field_53_0123 INT32, field_54_01234 REAL, field_55_012345 UINT32, field_56_0123456 BOOL, field_57_01234567 BOOL, field_58_012345678 UINT64, field_59_0123456789 HIRESTIME ARRAY, field_60_0 DATETIME, field_61_01 DATETIME, field_62_012 INT64, field_63_0123 UINT64)");
      /* 743 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 RICHREAL, field_3_0123 HIRESTIME, field_4_01234 UINT8, field_5_012345 DATETIME, field_6_0123456 UINT16, field_7_01234567 RICHREAL, field_8_012345678 INT8 ARRAY, field_9_0123456789 HIRESTIME, field_10_0 DATETIME ARRAY, field_11_01 CHAR, field_12_012 INT32 ARRAY, field_13_0123 DATE, field_14_01234 DATETIME ARRAY, field_15_012345 INT16 ARRAY, field_16_0123456 UINT32, field_17_01234567 UINT16 ARRAY, field_18_012345678 DATE ARRAY, field_19_0123456789 INT64, field_20_0 INT16 ARRAY, field_21_01 INT8, field_22_012 RICHREAL, field_23_0123 INT16, field_24_01234 REAL, field_25_012345 INT16, field_26_0123456 HIRESTIME, field_27_01234567 UINT8, field_28_012345678 UINT16, field_29_0123456789 CHAR, field_30_0 DATETIME, field_31_01 UINT64 ARRAY, field_32_012 UINT64 ARRAY, field_33_0123 REAL, field_34_01234 CHAR, field_35_012345 INT8, field_36_0123456 INT64, field_37_01234567 INT64, field_38_012345678 UINT8, field_39_0123456789 INT64 ARRAY, field_40_0 UINT64, field_41_01 HIRESTIME ARRAY, field_42_012 UINT16, field_43_0123 CHAR, field_44_01234 UINT32 ARRAY, field_45_012345 INT16, field_46_0123456 RICHREAL ARRAY, field_47_01234567 UINT8 ARRAY, field_48_012345678 HIRESTIME, field_49_0123456789 BOOL, field_50_0 RICHREAL, field_51_01 INT16 ARRAY, field_52_012 DATE, field_53_0123 INT32, field_54_01234 UINT32, field_55_012345 HIRESTIME, field_56_0123456 UINT32, field_57_01234567 INT64, field_58_012345678 INT8, field_59_0123456789 UINT8, field_60_0 INT16, field_61_01 DATETIME, field_62_012 UINT8, field_63_0123 HIRESTIME, field_64_01234 HIRESTIME, field_65_012345 INT32, field_66_0123456 CHAR, field_67_01234567 UINT16, field_68_012345678 HIRESTIME)");
      /* 744 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 REAL, field_3_0123 UINT8, field_4_01234 RICHREAL, field_5_012345 DATE, field_6_0123456 UINT32, field_7_01234567 INT8 ARRAY, field_8_012345678 REAL, field_9_0123456789 RICHREAL, field_10_0 REAL, field_11_01 BOOL, field_12_012 UINT32, field_13_0123 HIRESTIME, field_14_01234 INT32, field_15_012345 INT8 ARRAY, field_16_0123456 CHAR, field_17_01234567 DATE, field_18_012345678 UINT64, field_19_0123456789 BOOL, field_20_0 UINT16, field_21_01 INT8, field_22_012 UINT8 ARRAY, field_23_0123 UINT16, field_24_01234 UINT32, field_25_012345 RICHREAL, field_26_0123456 UINT64 ARRAY, field_27_01234567 UINT16, field_28_012345678 INT64, field_29_0123456789 UINT16, field_30_0 DATETIME)");
      /* 745 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 INT64, field_3_0123 INT16, field_4_01234 INT32, field_5_012345 RICHREAL ARRAY, field_6_0123456 DATETIME, field_7_01234567 INT32, field_8_012345678 UINT64, field_9_0123456789 INT64, field_10_0 RICHREAL, field_11_01 INT16, field_12_012 UINT64, field_13_0123 REAL, field_14_01234 INT16, field_15_012345 UINT64, field_16_0123456 INT16, field_17_01234567 HIRESTIME ARRAY, field_18_012345678 UINT64, field_19_0123456789 INT64, field_20_0 UINT64, field_21_01 DATETIME ARRAY, field_22_012 CHAR ARRAY, field_23_0123 REAL, field_24_01234 DATE ARRAY, field_25_012345 INT32, field_26_0123456 UINT8, field_27_01234567 BOOL, field_28_012345678 UINT32, field_29_0123456789 DATE, field_30_0 INT16, field_31_01 UINT32, field_32_012 HIRESTIME, field_33_0123 RICHREAL ARRAY, field_34_01234 INT32, field_35_012345 UINT32, field_36_0123456 INT8, field_37_01234567 DATETIME, field_38_012345678 UINT64, field_39_0123456789 UINT8, field_40_0 UINT64 ARRAY, field_41_01 CHAR, field_42_012 CHAR, field_43_0123 UINT8, field_44_01234 UINT16, field_45_012345 HIRESTIME, field_46_0123456 UINT64 ARRAY, field_47_01234567 HIRESTIME, field_48_012345678 DATE, field_49_0123456789 INT32, field_50_0 DATE, field_51_01 INT8 ARRAY, field_52_012 BOOL ARRAY, field_53_0123 UINT8, field_54_01234 INT16, field_55_012345 BOOL, field_56_0123456 DATE, field_57_01234567 INT32 ARRAY, field_58_012345678 DATE, field_59_0123456789 UINT64, field_60_0 RICHREAL, field_61_01 REAL ARRAY, field_62_012 RICHREAL, field_63_0123 DATETIME, field_64_01234 UINT64, field_65_012345 INT64)");
      /* 746 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 DATETIME, field_3_0123 CHAR, field_4_01234 INT32, field_5_012345 INT8, field_6_0123456 INT8, field_7_01234567 DATE, field_8_012345678 REAL ARRAY, field_9_0123456789 HIRESTIME, field_10_0 CHAR, field_11_01 BOOL, field_12_012 INT8)");
      /* 747 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 UINT64, field_3_0123 UINT64, field_4_01234 DATE ARRAY, field_5_012345 INT64, field_6_0123456 HIRESTIME, field_7_01234567 DATE, field_8_012345678 BOOL, field_9_0123456789 RICHREAL, field_10_0 REAL, field_11_01 HIRESTIME, field_12_012 INT8, field_13_0123 INT16 ARRAY, field_14_01234 RICHREAL, field_15_012345 HIRESTIME ARRAY, field_16_0123456 DATE, field_17_01234567 UINT64 ARRAY)");
      /* 748 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 UINT16, field_3_0123 UINT16 ARRAY, field_4_01234 UINT32 ARRAY, field_5_012345 DATE ARRAY, field_6_0123456 BOOL, field_7_01234567 HIRESTIME, field_8_012345678 UINT32, field_9_0123456789 UINT8, field_10_0 DATE, field_11_01 RICHREAL, field_12_012 INT64, field_13_0123 HIRESTIME, field_14_01234 UINT8, field_15_012345 RICHREAL, field_16_0123456 REAL, field_17_01234567 UINT64 ARRAY, field_18_012345678 INT16 ARRAY, field_19_0123456789 UINT16, field_20_0 DATE, field_21_01 RICHREAL, field_22_012 BOOL, field_23_0123 DATETIME, field_24_01234 UINT8, field_25_012345 UINT64, field_26_0123456 INT16, field_27_01234567 UINT32 ARRAY, field_28_012345678 UINT8, field_29_0123456789 INT16, field_30_0 DATETIME, field_31_01 REAL ARRAY, field_32_012 CHAR ARRAY, field_33_0123 INT16, field_34_01234 UINT16 ARRAY, field_35_012345 BOOL, field_36_0123456 INT64 ARRAY, field_37_01234567 HIRESTIME, field_38_012345678 UINT64, field_39_0123456789 DATETIME, field_40_0 UINT32, field_41_01 HIRESTIME, field_42_012 INT16, field_43_0123 INT8, field_44_01234 UINT16, field_45_012345 INT16, field_46_0123456 UINT8, field_47_01234567 HIRESTIME, field_48_012345678 BOOL ARRAY, field_49_0123456789 INT32, field_50_0 UINT8, field_51_01 REAL, field_52_012 INT8, field_53_0123 INT16, field_54_01234 REAL, field_55_012345 HIRESTIME, field_56_0123456 INT32 ARRAY, field_57_01234567 DATETIME, field_58_012345678 UINT16, field_59_0123456789 DATETIME, field_60_0 INT8, field_61_01 REAL, field_62_012 REAL, field_63_0123 INT16, field_64_01234 DATE, field_65_012345 REAL, field_66_0123456 RICHREAL, field_67_01234567 INT8, field_68_012345678 INT8, field_69_0123456789 CHAR, field_70_0 INT32, field_71_01 REAL ARRAY, field_72_012 DATE, field_73_0123 INT16, field_74_01234 INT8, field_75_012345 INT16, field_76_0123456 UINT16, field_77_01234567 UINT64, field_78_012345678 DATE, field_79_0123456789 DATE, field_80_0 UINT64, field_81_01 UINT8, field_82_012 UINT16, field_83_0123 INT64, field_84_01234 INT64, field_85_012345 INT16 ARRAY, field_86_0123456 INT16, field_87_01234567 UINT32, field_88_012345678 INT16, field_89_0123456789 INT16 ARRAY, field_90_0 UINT16, field_91_01 BOOL, field_92_012 INT16, field_93_0123 INT32)");
      /* 749 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 INT16, field_3_0123 INT32, field_4_01234 DATE, field_5_012345 INT64, field_6_0123456 BOOL, field_7_01234567 RICHREAL ARRAY, field_8_012345678 INT32, field_9_0123456789 UINT16, field_10_0 INT16, field_11_01 DATE ARRAY, field_12_012 UINT8, field_13_0123 BOOL, field_14_01234 DATE, field_15_012345 INT64, field_16_0123456 DATE, field_17_01234567 HIRESTIME ARRAY, field_18_012345678 RICHREAL ARRAY, field_19_0123456789 UINT32, field_20_0 UINT16, field_21_01 BOOL, field_22_012 UINT32, field_23_0123 INT16, field_24_01234 CHAR, field_25_012345 REAL, field_26_0123456 CHAR, field_27_01234567 UINT32 ARRAY, field_28_012345678 INT32, field_29_0123456789 REAL, field_30_0 UINT32, field_31_01 INT16, field_32_012 UINT32, field_33_0123 BOOL, field_34_01234 INT16, field_35_012345 DATE, field_36_0123456 UINT32, field_37_01234567 UINT8 ARRAY, field_38_012345678 CHAR ARRAY, field_39_0123456789 INT64, field_40_0 UINT64, field_41_01 REAL, field_42_012 INT64, field_43_0123 INT16, field_44_01234 INT8 ARRAY, field_45_012345 INT16, field_46_0123456 INT8, field_47_01234567 DATE, field_48_012345678 RICHREAL ARRAY, field_49_0123456789 BOOL, field_50_0 INT64, field_51_01 INT64, field_52_012 INT32, field_53_0123 HIRESTIME, field_54_01234 RICHREAL ARRAY, field_55_012345 CHAR, field_56_0123456 CHAR, field_57_01234567 HIRESTIME ARRAY, field_58_012345678 INT32 ARRAY, field_59_0123456789 HIRESTIME, field_60_0 DATE, field_61_01 REAL ARRAY, field_62_012 INT32, field_63_0123 HIRESTIME, field_64_01234 DATE, field_65_012345 DATE, field_66_0123456 INT16 ARRAY, field_67_01234567 DATE, field_68_012345678 INT16, field_69_0123456789 INT64)");
      /* 750 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 REAL, field_3_0123 UINT32, field_4_01234 INT32, field_5_012345 DATE, field_6_0123456 INT8 ARRAY, field_7_01234567 CHAR ARRAY, field_8_012345678 UINT32, field_9_0123456789 UINT8, field_10_0 INT16, field_11_01 BOOL, field_12_012 CHAR, field_13_0123 DATETIME, field_14_01234 INT8, field_15_012345 BOOL, field_16_0123456 INT16, field_17_01234567 UINT32, field_18_012345678 BOOL, field_19_0123456789 CHAR, field_20_0 RICHREAL, field_21_01 CHAR ARRAY, field_22_012 UINT8, field_23_0123 INT8, field_24_01234 DATETIME, field_25_012345 REAL, field_26_0123456 HIRESTIME, field_27_01234567 CHAR ARRAY, field_28_012345678 HIRESTIME, field_29_0123456789 INT64, field_30_0 UINT32, field_31_01 UINT8, field_32_012 DATE, field_33_0123 UINT8, field_34_01234 DATETIME, field_35_012345 INT32, field_36_0123456 UINT32, field_37_01234567 INT64, field_38_012345678 HIRESTIME, field_39_0123456789 CHAR ARRAY, field_40_0 UINT8, field_41_01 UINT8 ARRAY, field_42_012 INT8 ARRAY, field_43_0123 UINT32 ARRAY, field_44_01234 INT8, field_45_012345 UINT32 ARRAY, field_46_0123456 UINT32, field_47_01234567 REAL, field_48_012345678 CHAR, field_49_0123456789 BOOL, field_50_0 INT32, field_51_01 HIRESTIME)");
      /* 751 */ glbTypes.push_back("TABLE(field_1_01 DATE ARRAY, field_2_012 UINT8, field_3_0123 INT64, field_4_01234 BOOL, field_5_012345 UINT8, field_6_0123456 INT32, field_7_01234567 INT16, field_8_012345678 RICHREAL, field_9_0123456789 HIRESTIME, field_10_0 INT16 ARRAY, field_11_01 DATE, field_12_012 CHAR ARRAY, field_13_0123 HIRESTIME ARRAY, field_14_01234 DATE ARRAY, field_15_012345 INT16, field_16_0123456 INT64)");
      /* 752 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 UINT16, field_3_0123 DATE, field_4_01234 UINT8, field_5_012345 HIRESTIME ARRAY, field_6_0123456 UINT32, field_7_01234567 INT32, field_8_012345678 HIRESTIME, field_9_0123456789 UINT32 ARRAY, field_10_0 BOOL, field_11_01 INT32 ARRAY, field_12_012 INT64, field_13_0123 UINT64 ARRAY, field_14_01234 UINT64, field_15_012345 UINT32, field_16_0123456 INT64, field_17_01234567 DATETIME, field_18_012345678 INT32, field_19_0123456789 HIRESTIME, field_20_0 INT8, field_21_01 INT64 ARRAY, field_22_012 INT16, field_23_0123 INT16, field_24_01234 HIRESTIME ARRAY, field_25_012345 BOOL, field_26_0123456 UINT16, field_27_01234567 UINT64, field_28_012345678 UINT32, field_29_0123456789 UINT16, field_30_0 UINT32, field_31_01 INT64, field_32_012 DATE, field_33_0123 INT16, field_34_01234 DATE, field_35_012345 INT32, field_36_0123456 INT32, field_37_01234567 UINT16, field_38_012345678 RICHREAL, field_39_0123456789 REAL, field_40_0 DATETIME, field_41_01 DATE, field_42_012 INT8, field_43_0123 INT32 ARRAY, field_44_01234 RICHREAL, field_45_012345 DATE, field_46_0123456 INT16, field_47_01234567 DATETIME, field_48_012345678 DATETIME, field_49_0123456789 UINT16, field_50_0 BOOL, field_51_01 HIRESTIME, field_52_012 DATETIME, field_53_0123 HIRESTIME, field_54_01234 HIRESTIME, field_55_012345 INT64, field_56_0123456 BOOL ARRAY, field_57_01234567 DATE ARRAY, field_58_012345678 UINT32, field_59_0123456789 CHAR, field_60_0 INT32, field_61_01 HIRESTIME ARRAY, field_62_012 INT16 ARRAY)");
      /* 753 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL ARRAY, field_2_012 INT64, field_3_0123 INT16 ARRAY, field_4_01234 RICHREAL, field_5_012345 INT16 ARRAY, field_6_0123456 INT32, field_7_01234567 UINT32, field_8_012345678 RICHREAL)");
      /* 754 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 REAL, field_3_0123 INT8, field_4_01234 INT64, field_5_012345 UINT64 ARRAY, field_6_0123456 RICHREAL ARRAY, field_7_01234567 UINT32, field_8_012345678 UINT8, field_9_0123456789 DATE, field_10_0 BOOL ARRAY, field_11_01 DATE, field_12_012 UINT64 ARRAY, field_13_0123 RICHREAL, field_14_01234 REAL, field_15_012345 UINT8, field_16_0123456 UINT64, field_17_01234567 DATE, field_18_012345678 DATE, field_19_0123456789 UINT32 ARRAY, field_20_0 UINT16, field_21_01 UINT8, field_22_012 CHAR, field_23_0123 DATE, field_24_01234 CHAR, field_25_012345 INT16)");
      /* 755 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 RICHREAL, field_3_0123 INT8 ARRAY, field_4_01234 RICHREAL ARRAY, field_5_012345 REAL, field_6_0123456 INT8, field_7_01234567 INT32 ARRAY, field_8_012345678 INT8, field_9_0123456789 UINT8 ARRAY, field_10_0 INT32, field_11_01 DATETIME, field_12_012 UINT64, field_13_0123 CHAR, field_14_01234 INT64, field_15_012345 DATE, field_16_0123456 INT8, field_17_01234567 INT8, field_18_012345678 INT64 ARRAY, field_19_0123456789 CHAR, field_20_0 INT32 ARRAY, field_21_01 UINT64, field_22_012 REAL, field_23_0123 INT16 ARRAY, field_24_01234 INT16, field_25_012345 UINT16 ARRAY, field_26_0123456 INT8, field_27_01234567 INT8, field_28_012345678 DATETIME, field_29_0123456789 UINT64, field_30_0 DATETIME, field_31_01 HIRESTIME ARRAY, field_32_012 UINT64 ARRAY, field_33_0123 BOOL, field_34_01234 UINT32, field_35_012345 INT16, field_36_0123456 DATE, field_37_01234567 DATE, field_38_012345678 REAL, field_39_0123456789 UINT8, field_40_0 DATETIME ARRAY, field_41_01 HIRESTIME ARRAY, field_42_012 DATETIME ARRAY, field_43_0123 INT8, field_44_01234 UINT8, field_45_012345 UINT32, field_46_0123456 UINT16, field_47_01234567 BOOL, field_48_012345678 CHAR, field_49_0123456789 DATETIME, field_50_0 INT8, field_51_01 DATE, field_52_012 BOOL, field_53_0123 UINT16)");
      /* 756 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 REAL, field_3_0123 INT64 ARRAY, field_4_01234 UINT8, field_5_012345 UINT32 ARRAY, field_6_0123456 BOOL, field_7_01234567 UINT8, field_8_012345678 DATE, field_9_0123456789 INT64, field_10_0 INT64 ARRAY, field_11_01 INT64, field_12_012 UINT32 ARRAY, field_13_0123 INT32, field_14_01234 DATETIME, field_15_012345 HIRESTIME, field_16_0123456 UINT64, field_17_01234567 UINT8 ARRAY, field_18_012345678 INT64, field_19_0123456789 HIRESTIME, field_20_0 UINT8, field_21_01 HIRESTIME, field_22_012 UINT8, field_23_0123 UINT32, field_24_01234 INT8, field_25_012345 BOOL, field_26_0123456 REAL, field_27_01234567 INT64, field_28_012345678 RICHREAL ARRAY, field_29_0123456789 INT64, field_30_0 UINT64, field_31_01 RICHREAL, field_32_012 CHAR, field_33_0123 REAL, field_34_01234 DATE)");
      /* 757 */ glbTypes.push_back("TABLE(field_1_01 INT32 ARRAY, field_2_012 UINT32 ARRAY, field_3_0123 INT32, field_4_01234 DATETIME, field_5_012345 INT16, field_6_0123456 INT8 ARRAY, field_7_01234567 REAL, field_8_012345678 UINT32, field_9_0123456789 INT8, field_10_0 HIRESTIME, field_11_01 RICHREAL, field_12_012 CHAR ARRAY, field_13_0123 INT64, field_14_01234 HIRESTIME, field_15_012345 DATETIME ARRAY, field_16_0123456 REAL, field_17_01234567 DATE ARRAY, field_18_012345678 UINT8, field_19_0123456789 HIRESTIME, field_20_0 RICHREAL, field_21_01 UINT8, field_22_012 RICHREAL ARRAY, field_23_0123 INT64, field_24_01234 HIRESTIME, field_25_012345 UINT64, field_26_0123456 UINT32, field_27_01234567 INT8, field_28_012345678 DATETIME, field_29_0123456789 HIRESTIME, field_30_0 REAL ARRAY, field_31_01 REAL, field_32_012 RICHREAL, field_33_0123 REAL, field_34_01234 UINT64, field_35_012345 DATETIME, field_36_0123456 UINT16, field_37_01234567 INT32 ARRAY, field_38_012345678 HIRESTIME ARRAY, field_39_0123456789 BOOL, field_40_0 RICHREAL, field_41_01 UINT16, field_42_012 CHAR ARRAY, field_43_0123 INT32, field_44_01234 INT16, field_45_012345 REAL, field_46_0123456 BOOL, field_47_01234567 UINT16, field_48_012345678 INT8 ARRAY, field_49_0123456789 BOOL, field_50_0 INT64, field_51_01 INT16, field_52_012 INT8, field_53_0123 BOOL ARRAY, field_54_01234 UINT32 ARRAY, field_55_012345 DATE, field_56_0123456 BOOL, field_57_01234567 UINT8, field_58_012345678 DATE)");
      /* 758 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 INT16, field_3_0123 INT8, field_4_01234 CHAR ARRAY, field_5_012345 INT8, field_6_0123456 UINT8, field_7_01234567 INT32, field_8_012345678 INT16, field_9_0123456789 HIRESTIME, field_10_0 UINT8, field_11_01 BOOL ARRAY, field_12_012 RICHREAL, field_13_0123 UINT32, field_14_01234 UINT8, field_15_012345 INT64, field_16_0123456 INT64, field_17_01234567 HIRESTIME ARRAY, field_18_012345678 HIRESTIME ARRAY, field_19_0123456789 RICHREAL, field_20_0 REAL, field_21_01 CHAR, field_22_012 RICHREAL, field_23_0123 UINT64, field_24_01234 REAL, field_25_012345 INT64 ARRAY, field_26_0123456 UINT32 ARRAY, field_27_01234567 REAL, field_28_012345678 DATE, field_29_0123456789 DATETIME ARRAY, field_30_0 CHAR, field_31_01 UINT64, field_32_012 DATETIME, field_33_0123 DATE, field_34_01234 HIRESTIME, field_35_012345 CHAR, field_36_0123456 UINT8, field_37_01234567 REAL, field_38_012345678 INT64 ARRAY, field_39_0123456789 INT32, field_40_0 HIRESTIME, field_41_01 UINT64, field_42_012 UINT16, field_43_0123 UINT8, field_44_01234 UINT64, field_45_012345 INT64 ARRAY, field_46_0123456 INT16, field_47_01234567 UINT16, field_48_012345678 INT32 ARRAY, field_49_0123456789 REAL, field_50_0 DATE ARRAY, field_51_01 DATE, field_52_012 BOOL, field_53_0123 UINT16, field_54_01234 INT16, field_55_012345 DATE ARRAY, field_56_0123456 INT16, field_57_01234567 UINT64, field_58_012345678 UINT32, field_59_0123456789 UINT32 ARRAY, field_60_0 INT32, field_61_01 REAL, field_62_012 CHAR ARRAY, field_63_0123 UINT16, field_64_01234 INT8, field_65_012345 UINT8, field_66_0123456 DATE ARRAY, field_67_01234567 UINT64, field_68_012345678 INT16, field_69_0123456789 CHAR, field_70_0 RICHREAL, field_71_01 INT32 ARRAY, field_72_012 INT64, field_73_0123 HIRESTIME ARRAY, field_74_01234 DATE ARRAY, field_75_012345 INT16, field_76_0123456 REAL, field_77_01234567 UINT16 ARRAY, field_78_012345678 CHAR, field_79_0123456789 HIRESTIME, field_80_0 CHAR ARRAY)");
      /* 759 */ glbTypes.push_back("TABLE(field_1_01 CHAR ARRAY, field_2_012 RICHREAL ARRAY, field_3_0123 UINT16, field_4_01234 INT32, field_5_012345 INT8 ARRAY, field_6_0123456 INT8, field_7_01234567 UINT64, field_8_012345678 UINT32 ARRAY, field_9_0123456789 UINT64, field_10_0 UINT16 ARRAY, field_11_01 REAL, field_12_012 UINT64, field_13_0123 UINT16, field_14_01234 UINT32, field_15_012345 HIRESTIME, field_16_0123456 INT16, field_17_01234567 BOOL, field_18_012345678 UINT8, field_19_0123456789 BOOL ARRAY, field_20_0 INT64, field_21_01 DATE, field_22_012 BOOL, field_23_0123 INT16 ARRAY, field_24_01234 INT64, field_25_012345 INT8, field_26_0123456 UINT16, field_27_01234567 DATETIME ARRAY, field_28_012345678 REAL, field_29_0123456789 HIRESTIME, field_30_0 INT8, field_31_01 DATE, field_32_012 INT64, field_33_0123 INT32 ARRAY, field_34_01234 UINT16 ARRAY, field_35_012345 REAL, field_36_0123456 RICHREAL ARRAY, field_37_01234567 INT16 ARRAY, field_38_012345678 RICHREAL, field_39_0123456789 UINT32 ARRAY, field_40_0 UINT8, field_41_01 DATETIME, field_42_012 UINT32, field_43_0123 INT64, field_44_01234 UINT8, field_45_012345 INT32 ARRAY, field_46_0123456 BOOL, field_47_01234567 INT8 ARRAY, field_48_012345678 HIRESTIME, field_49_0123456789 BOOL, field_50_0 RICHREAL, field_51_01 UINT32, field_52_012 UINT16 ARRAY, field_53_0123 HIRESTIME ARRAY, field_54_01234 BOOL, field_55_012345 HIRESTIME, field_56_0123456 DATETIME, field_57_01234567 INT64, field_58_012345678 INT16, field_59_0123456789 UINT16, field_60_0 DATETIME, field_61_01 INT8, field_62_012 UINT32 ARRAY, field_63_0123 BOOL, field_64_01234 UINT64 ARRAY, field_65_012345 CHAR ARRAY, field_66_0123456 HIRESTIME, field_67_01234567 CHAR, field_68_012345678 INT16, field_69_0123456789 INT16 ARRAY, field_70_0 INT16, field_71_01 INT64 ARRAY, field_72_012 INT64, field_73_0123 REAL, field_74_01234 INT32, field_75_012345 INT64 ARRAY, field_76_0123456 DATETIME ARRAY, field_77_01234567 REAL ARRAY, field_78_012345678 HIRESTIME, field_79_0123456789 UINT16 ARRAY, field_80_0 UINT8 ARRAY, field_81_01 INT64, field_82_012 DATETIME ARRAY, field_83_0123 BOOL ARRAY, field_84_01234 CHAR, field_85_012345 INT8, field_86_0123456 INT64 ARRAY, field_87_01234567 INT64, field_88_012345678 BOOL ARRAY, field_89_0123456789 REAL, field_90_0 INT16, field_91_01 UINT16, field_92_012 INT16, field_93_0123 UINT8, field_94_01234 UINT32 ARRAY, field_95_012345 UINT16 ARRAY, field_96_0123456 DATETIME, field_97_01234567 UINT16 ARRAY)");
      /* 760 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 INT32, field_3_0123 CHAR, field_4_01234 CHAR, field_5_012345 INT8 ARRAY, field_6_0123456 INT64, field_7_01234567 INT8, field_8_012345678 UINT32 ARRAY, field_9_0123456789 INT16, field_10_0 INT64, field_11_01 RICHREAL, field_12_012 UINT32 ARRAY, field_13_0123 UINT8, field_14_01234 HIRESTIME, field_15_012345 UINT32, field_16_0123456 HIRESTIME, field_17_01234567 INT64 ARRAY, field_18_012345678 INT32, field_19_0123456789 DATETIME, field_20_0 HIRESTIME, field_21_01 UINT8 ARRAY, field_22_012 UINT8 ARRAY, field_23_0123 INT8, field_24_01234 HIRESTIME, field_25_012345 INT16, field_26_0123456 INT32, field_27_01234567 CHAR, field_28_012345678 RICHREAL, field_29_0123456789 DATE ARRAY, field_30_0 INT8 ARRAY, field_31_01 UINT64, field_32_012 REAL, field_33_0123 UINT32, field_34_01234 INT32, field_35_012345 INT16, field_36_0123456 UINT16, field_37_01234567 DATE, field_38_012345678 REAL, field_39_0123456789 INT32 ARRAY, field_40_0 DATE ARRAY, field_41_01 DATETIME, field_42_012 INT16, field_43_0123 UINT8 ARRAY)");
      /* 761 */ glbTypes.push_back("TABLE(field_1_01 CHAR ARRAY, field_2_012 DATETIME, field_3_0123 UINT8, field_4_01234 DATE, field_5_012345 RICHREAL ARRAY, field_6_0123456 INT64 ARRAY, field_7_01234567 UINT8, field_8_012345678 DATE, field_9_0123456789 INT8, field_10_0 HIRESTIME, field_11_01 INT8, field_12_012 INT16 ARRAY, field_13_0123 INT32 ARRAY, field_14_01234 UINT64, field_15_012345 UINT16, field_16_0123456 INT64, field_17_01234567 INT16, field_18_012345678 DATE, field_19_0123456789 INT64, field_20_0 RICHREAL, field_21_01 INT64, field_22_012 UINT8, field_23_0123 INT64, field_24_01234 INT8, field_25_012345 UINT8, field_26_0123456 UINT8 ARRAY, field_27_01234567 INT8 ARRAY, field_28_012345678 BOOL, field_29_0123456789 UINT8, field_30_0 RICHREAL, field_31_01 INT16, field_32_012 UINT32 ARRAY, field_33_0123 UINT64, field_34_01234 INT64, field_35_012345 UINT16, field_36_0123456 HIRESTIME ARRAY, field_37_01234567 INT64, field_38_012345678 UINT16, field_39_0123456789 DATETIME ARRAY, field_40_0 DATETIME ARRAY, field_41_01 INT16, field_42_012 HIRESTIME, field_43_0123 RICHREAL, field_44_01234 UINT8, field_45_012345 INT16, field_46_0123456 INT8 ARRAY, field_47_01234567 DATE, field_48_012345678 UINT64, field_49_0123456789 UINT16 ARRAY, field_50_0 INT32)");
      /* 762 */ glbTypes.push_back("TABLE(field_1_01 INT16 ARRAY, field_2_012 DATE, field_3_0123 UINT8)");
      /* 763 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 INT64, field_3_0123 UINT8, field_4_01234 DATE, field_5_012345 DATE, field_6_0123456 INT64, field_7_01234567 HIRESTIME, field_8_012345678 DATE, field_9_0123456789 BOOL, field_10_0 REAL, field_11_01 INT8, field_12_012 INT16 ARRAY, field_13_0123 UINT32, field_14_01234 CHAR ARRAY, field_15_012345 UINT32, field_16_0123456 UINT8, field_17_01234567 UINT16, field_18_012345678 UINT8, field_19_0123456789 CHAR, field_20_0 UINT8, field_21_01 UINT16, field_22_012 INT8, field_23_0123 INT32, field_24_01234 UINT16, field_25_012345 INT8, field_26_0123456 CHAR ARRAY, field_27_01234567 RICHREAL, field_28_012345678 UINT8)");
      /* 764 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 HIRESTIME, field_3_0123 INT8, field_4_01234 UINT32, field_5_012345 BOOL, field_6_0123456 HIRESTIME, field_7_01234567 UINT8 ARRAY, field_8_012345678 UINT16 ARRAY, field_9_0123456789 UINT16, field_10_0 UINT16, field_11_01 UINT8, field_12_012 DATETIME, field_13_0123 REAL, field_14_01234 DATE, field_15_012345 INT32, field_16_0123456 INT32, field_17_01234567 UINT64, field_18_012345678 CHAR, field_19_0123456789 DATE, field_20_0 UINT8, field_21_01 INT64 ARRAY, field_22_012 INT32, field_23_0123 REAL, field_24_01234 DATE, field_25_012345 UINT16, field_26_0123456 UINT64, field_27_01234567 DATETIME, field_28_012345678 REAL, field_29_0123456789 UINT64 ARRAY, field_30_0 UINT16, field_31_01 INT32, field_32_012 UINT16 ARRAY, field_33_0123 INT8, field_34_01234 UINT64, field_35_012345 UINT32, field_36_0123456 INT16, field_37_01234567 RICHREAL ARRAY, field_38_012345678 REAL, field_39_0123456789 UINT64, field_40_0 BOOL, field_41_01 RICHREAL, field_42_012 HIRESTIME, field_43_0123 HIRESTIME, field_44_01234 DATETIME ARRAY, field_45_012345 RICHREAL ARRAY, field_46_0123456 INT32 ARRAY, field_47_01234567 DATETIME, field_48_012345678 UINT16, field_49_0123456789 INT32 ARRAY, field_50_0 DATE, field_51_01 CHAR, field_52_012 DATETIME, field_53_0123 UINT32, field_54_01234 INT16, field_55_012345 INT32, field_56_0123456 UINT16, field_57_01234567 DATE ARRAY, field_58_012345678 INT32, field_59_0123456789 HIRESTIME, field_60_0 INT64 ARRAY, field_61_01 HIRESTIME, field_62_012 UINT16 ARRAY, field_63_0123 HIRESTIME, field_64_01234 DATE, field_65_012345 BOOL, field_66_0123456 DATE, field_67_01234567 DATETIME, field_68_012345678 INT8, field_69_0123456789 HIRESTIME, field_70_0 DATE ARRAY, field_71_01 UINT8, field_72_012 DATE ARRAY, field_73_0123 CHAR ARRAY)");
      /* 765 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 INT32, field_3_0123 UINT64 ARRAY, field_4_01234 UINT32 ARRAY, field_5_012345 UINT8 ARRAY, field_6_0123456 UINT16, field_7_01234567 UINT16, field_8_012345678 INT64, field_9_0123456789 CHAR ARRAY, field_10_0 CHAR, field_11_01 UINT64, field_12_012 CHAR, field_13_0123 REAL, field_14_01234 INT16, field_15_012345 HIRESTIME, field_16_0123456 UINT16, field_17_01234567 UINT64 ARRAY, field_18_012345678 DATE ARRAY, field_19_0123456789 INT16, field_20_0 UINT32, field_21_01 DATE ARRAY, field_22_012 DATE, field_23_0123 INT64, field_24_01234 UINT16, field_25_012345 REAL, field_26_0123456 DATE, field_27_01234567 UINT32, field_28_012345678 BOOL, field_29_0123456789 BOOL, field_30_0 DATETIME, field_31_01 RICHREAL, field_32_012 UINT8, field_33_0123 CHAR ARRAY, field_34_01234 BOOL, field_35_012345 INT16, field_36_0123456 DATETIME ARRAY, field_37_01234567 INT16, field_38_012345678 BOOL, field_39_0123456789 UINT64, field_40_0 DATETIME, field_41_01 REAL, field_42_012 CHAR, field_43_0123 BOOL, field_44_01234 INT8, field_45_012345 INT8, field_46_0123456 INT8, field_47_01234567 UINT16, field_48_012345678 INT16 ARRAY, field_49_0123456789 UINT32 ARRAY, field_50_0 RICHREAL, field_51_01 BOOL, field_52_012 CHAR, field_53_0123 REAL, field_54_01234 DATE, field_55_012345 INT16 ARRAY, field_56_0123456 UINT32, field_57_01234567 INT64, field_58_012345678 DATETIME ARRAY, field_59_0123456789 BOOL, field_60_0 RICHREAL ARRAY, field_61_01 UINT64, field_62_012 DATETIME ARRAY, field_63_0123 INT32, field_64_01234 INT64, field_65_012345 INT16, field_66_0123456 RICHREAL, field_67_01234567 INT16, field_68_012345678 RICHREAL, field_69_0123456789 INT32, field_70_0 DATETIME, field_71_01 DATETIME ARRAY, field_72_012 RICHREAL, field_73_0123 INT16, field_74_01234 RICHREAL, field_75_012345 INT16, field_76_0123456 INT16, field_77_01234567 BOOL ARRAY, field_78_012345678 UINT16, field_79_0123456789 UINT64, field_80_0 UINT8, field_81_01 UINT64 ARRAY, field_82_012 DATETIME, field_83_0123 HIRESTIME, field_84_01234 UINT64)");
      /* 766 */ glbTypes.push_back("TABLE(field_1_01 BOOL ARRAY, field_2_012 INT8, field_3_0123 HIRESTIME, field_4_01234 UINT16, field_5_012345 UINT64, field_6_0123456 DATETIME, field_7_01234567 INT64, field_8_012345678 INT16, field_9_0123456789 REAL ARRAY, field_10_0 INT16, field_11_01 INT16, field_12_012 UINT8, field_13_0123 INT16 ARRAY, field_14_01234 REAL, field_15_012345 REAL, field_16_0123456 INT32, field_17_01234567 UINT64, field_18_012345678 UINT64, field_19_0123456789 UINT8 ARRAY, field_20_0 INT32, field_21_01 UINT32 ARRAY, field_22_012 INT64 ARRAY, field_23_0123 CHAR, field_24_01234 INT16, field_25_012345 DATETIME, field_26_0123456 UINT32, field_27_01234567 UINT32 ARRAY, field_28_012345678 BOOL, field_29_0123456789 INT16, field_30_0 HIRESTIME, field_31_01 INT16, field_32_012 DATETIME, field_33_0123 UINT64, field_34_01234 UINT64, field_35_012345 DATE, field_36_0123456 INT16, field_37_01234567 INT8, field_38_012345678 UINT8, field_39_0123456789 BOOL, field_40_0 UINT64, field_41_01 UINT8, field_42_012 HIRESTIME, field_43_0123 CHAR ARRAY, field_44_01234 UINT64, field_45_012345 REAL ARRAY, field_46_0123456 CHAR, field_47_01234567 DATETIME, field_48_012345678 BOOL, field_49_0123456789 UINT16, field_50_0 UINT32, field_51_01 UINT16 ARRAY, field_52_012 INT32, field_53_0123 HIRESTIME, field_54_01234 DATETIME, field_55_012345 UINT64 ARRAY, field_56_0123456 DATE, field_57_01234567 DATE, field_58_012345678 DATE ARRAY, field_59_0123456789 REAL, field_60_0 INT64, field_61_01 UINT8 ARRAY, field_62_012 INT64 ARRAY, field_63_0123 UINT32, field_64_01234 INT32, field_65_012345 UINT16 ARRAY, field_66_0123456 DATETIME, field_67_01234567 BOOL, field_68_012345678 UINT64, field_69_0123456789 BOOL, field_70_0 REAL, field_71_01 DATETIME ARRAY, field_72_012 REAL ARRAY, field_73_0123 INT16 ARRAY, field_74_01234 UINT16, field_75_012345 INT32, field_76_0123456 INT8, field_77_01234567 INT8, field_78_012345678 UINT8, field_79_0123456789 HIRESTIME ARRAY, field_80_0 DATETIME, field_81_01 CHAR, field_82_012 BOOL, field_83_0123 INT8, field_84_01234 UINT64, field_85_012345 UINT64, field_86_0123456 REAL, field_87_01234567 UINT16, field_88_012345678 DATETIME ARRAY, field_89_0123456789 INT32 ARRAY, field_90_0 UINT8 ARRAY, field_91_01 INT8, field_92_012 INT32, field_93_0123 DATETIME, field_94_01234 INT8, field_95_012345 DATE ARRAY)");
      /* 767 */ glbTypes.push_back("TABLE(field_1_01 INT64 ARRAY, field_2_012 INT32, field_3_0123 UINT16 ARRAY, field_4_01234 INT8, field_5_012345 HIRESTIME, field_6_0123456 CHAR, field_7_01234567 UINT64, field_8_012345678 RICHREAL, field_9_0123456789 CHAR, field_10_0 REAL, field_11_01 UINT64, field_12_012 CHAR, field_13_0123 RICHREAL, field_14_01234 UINT64, field_15_012345 DATETIME, field_16_0123456 INT16, field_17_01234567 INT8 ARRAY, field_18_012345678 REAL, field_19_0123456789 UINT16)");
      /* 768 */ glbTypes.push_back("TABLE(field_1_01 INT64 ARRAY, field_2_012 UINT8 ARRAY, field_3_0123 UINT16, field_4_01234 BOOL ARRAY, field_5_012345 UINT16, field_6_0123456 DATETIME, field_7_01234567 INT64, field_8_012345678 INT16, field_9_0123456789 DATETIME ARRAY, field_10_0 CHAR, field_11_01 DATE, field_12_012 UINT8, field_13_0123 CHAR ARRAY, field_14_01234 RICHREAL, field_15_012345 INT8 ARRAY, field_16_0123456 REAL, field_17_01234567 INT64, field_18_012345678 UINT8, field_19_0123456789 DATE, field_20_0 UINT8, field_21_01 HIRESTIME, field_22_012 INT16, field_23_0123 REAL, field_24_01234 HIRESTIME, field_25_012345 INT64 ARRAY, field_26_0123456 UINT8, field_27_01234567 REAL, field_28_012345678 UINT16, field_29_0123456789 BOOL, field_30_0 INT8, field_31_01 DATE ARRAY, field_32_012 INT8, field_33_0123 BOOL, field_34_01234 DATE, field_35_012345 UINT64, field_36_0123456 INT8 ARRAY, field_37_01234567 RICHREAL, field_38_012345678 HIRESTIME, field_39_0123456789 HIRESTIME, field_40_0 UINT32, field_41_01 HIRESTIME, field_42_012 DATETIME, field_43_0123 DATETIME, field_44_01234 INT8 ARRAY, field_45_012345 UINT16, field_46_0123456 CHAR, field_47_01234567 UINT64 ARRAY, field_48_012345678 HIRESTIME, field_49_0123456789 UINT8, field_50_0 UINT32, field_51_01 UINT64, field_52_012 HIRESTIME, field_53_0123 INT8, field_54_01234 RICHREAL, field_55_012345 UINT8, field_56_0123456 BOOL, field_57_01234567 DATE ARRAY, field_58_012345678 UINT8, field_59_0123456789 RICHREAL, field_60_0 INT64, field_61_01 INT16 ARRAY, field_62_012 INT8, field_63_0123 INT32 ARRAY, field_64_01234 HIRESTIME, field_65_012345 INT16, field_66_0123456 DATE ARRAY, field_67_01234567 DATE, field_68_012345678 INT16 ARRAY, field_69_0123456789 BOOL, field_70_0 REAL, field_71_01 UINT16 ARRAY, field_72_012 BOOL, field_73_0123 INT32, field_74_01234 REAL, field_75_012345 UINT64, field_76_0123456 UINT16, field_77_01234567 DATETIME, field_78_012345678 HIRESTIME ARRAY, field_79_0123456789 INT64, field_80_0 INT16, field_81_01 UINT8 ARRAY, field_82_012 UINT32, field_83_0123 INT32, field_84_01234 HIRESTIME ARRAY, field_85_012345 UINT64 ARRAY, field_86_0123456 CHAR, field_87_01234567 REAL, field_88_012345678 HIRESTIME, field_89_0123456789 REAL ARRAY, field_90_0 INT8 ARRAY, field_91_01 HIRESTIME)");
      /* 769 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 REAL ARRAY)");
      /* 770 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 UINT16 ARRAY, field_3_0123 REAL, field_4_01234 RICHREAL, field_5_012345 HIRESTIME, field_6_0123456 INT64, field_7_01234567 CHAR, field_8_012345678 CHAR, field_9_0123456789 UINT16, field_10_0 UINT8, field_11_01 CHAR, field_12_012 CHAR, field_13_0123 INT32 ARRAY, field_14_01234 BOOL, field_15_012345 DATE, field_16_0123456 HIRESTIME ARRAY, field_17_01234567 UINT16, field_18_012345678 INT8, field_19_0123456789 UINT8 ARRAY, field_20_0 REAL, field_21_01 RICHREAL, field_22_012 HIRESTIME, field_23_0123 INT8, field_24_01234 CHAR, field_25_012345 UINT16, field_26_0123456 CHAR, field_27_01234567 UINT16, field_28_012345678 INT16, field_29_0123456789 DATE ARRAY, field_30_0 UINT16, field_31_01 BOOL, field_32_012 BOOL ARRAY, field_33_0123 UINT16, field_34_01234 INT16, field_35_012345 CHAR, field_36_0123456 INT16, field_37_01234567 INT32, field_38_012345678 INT32, field_39_0123456789 INT32, field_40_0 INT16, field_41_01 HIRESTIME, field_42_012 INT16, field_43_0123 DATE, field_44_01234 DATE, field_45_012345 REAL, field_46_0123456 DATETIME, field_47_01234567 HIRESTIME, field_48_012345678 HIRESTIME, field_49_0123456789 INT8, field_50_0 UINT8, field_51_01 BOOL ARRAY, field_52_012 REAL, field_53_0123 REAL, field_54_01234 UINT8 ARRAY, field_55_012345 UINT8, field_56_0123456 DATETIME ARRAY, field_57_01234567 RICHREAL, field_58_012345678 BOOL, field_59_0123456789 HIRESTIME ARRAY, field_60_0 DATE, field_61_01 UINT32, field_62_012 INT64, field_63_0123 RICHREAL, field_64_01234 CHAR, field_65_012345 INT64, field_66_0123456 INT32, field_67_01234567 DATE, field_68_012345678 UINT64, field_69_0123456789 HIRESTIME, field_70_0 UINT32, field_71_01 RICHREAL, field_72_012 UINT16, field_73_0123 DATETIME, field_74_01234 INT16, field_75_012345 DATE, field_76_0123456 BOOL ARRAY, field_77_01234567 BOOL, field_78_012345678 UINT16, field_79_0123456789 UINT32 ARRAY, field_80_0 BOOL ARRAY, field_81_01 HIRESTIME, field_82_012 UINT8, field_83_0123 DATE, field_84_01234 HIRESTIME ARRAY, field_85_012345 UINT32, field_86_0123456 UINT32, field_87_01234567 HIRESTIME, field_88_012345678 REAL, field_89_0123456789 INT64)");
      /* 771 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 UINT8, field_3_0123 UINT64, field_4_01234 BOOL, field_5_012345 UINT16, field_6_0123456 UINT64, field_7_01234567 UINT8, field_8_012345678 INT64 ARRAY, field_9_0123456789 UINT8, field_10_0 INT16, field_11_01 UINT32, field_12_012 RICHREAL, field_13_0123 INT64, field_14_01234 DATETIME, field_15_012345 INT32 ARRAY, field_16_0123456 RICHREAL, field_17_01234567 RICHREAL, field_18_012345678 INT8 ARRAY, field_19_0123456789 UINT16 ARRAY, field_20_0 DATETIME, field_21_01 INT64, field_22_012 UINT8, field_23_0123 BOOL, field_24_01234 UINT16, field_25_012345 UINT8, field_26_0123456 DATE, field_27_01234567 REAL, field_28_012345678 REAL, field_29_0123456789 REAL, field_30_0 DATETIME ARRAY, field_31_01 INT32 ARRAY, field_32_012 UINT64, field_33_0123 CHAR, field_34_01234 INT32, field_35_012345 REAL, field_36_0123456 INT64, field_37_01234567 INT64, field_38_012345678 INT32, field_39_0123456789 RICHREAL, field_40_0 DATE, field_41_01 REAL ARRAY, field_42_012 INT32, field_43_0123 UINT32, field_44_01234 DATE, field_45_012345 INT16, field_46_0123456 DATE, field_47_01234567 CHAR, field_48_012345678 UINT32, field_49_0123456789 BOOL ARRAY, field_50_0 UINT64, field_51_01 INT8, field_52_012 RICHREAL, field_53_0123 REAL ARRAY, field_54_01234 DATETIME, field_55_012345 INT64, field_56_0123456 UINT64, field_57_01234567 UINT64, field_58_012345678 UINT32, field_59_0123456789 CHAR, field_60_0 REAL ARRAY, field_61_01 INT8)");
      /* 772 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 INT16, field_3_0123 INT8, field_4_01234 HIRESTIME, field_5_012345 INT64, field_6_0123456 UINT64 ARRAY, field_7_01234567 DATETIME, field_8_012345678 CHAR, field_9_0123456789 DATE, field_10_0 REAL ARRAY, field_11_01 INT64, field_12_012 REAL, field_13_0123 DATETIME, field_14_01234 INT32, field_15_012345 CHAR, field_16_0123456 INT16 ARRAY, field_17_01234567 UINT32, field_18_012345678 DATETIME, field_19_0123456789 INT8, field_20_0 UINT32, field_21_01 INT32, field_22_012 RICHREAL ARRAY, field_23_0123 DATETIME, field_24_01234 INT8, field_25_012345 INT8, field_26_0123456 HIRESTIME, field_27_01234567 INT8, field_28_012345678 HIRESTIME, field_29_0123456789 DATETIME, field_30_0 REAL, field_31_01 HIRESTIME, field_32_012 REAL, field_33_0123 INT16 ARRAY, field_34_01234 DATETIME, field_35_012345 DATE, field_36_0123456 BOOL ARRAY, field_37_01234567 DATE ARRAY, field_38_012345678 INT32, field_39_0123456789 HIRESTIME, field_40_0 INT32, field_41_01 UINT16, field_42_012 INT64, field_43_0123 REAL, field_44_01234 REAL, field_45_012345 DATETIME, field_46_0123456 RICHREAL, field_47_01234567 BOOL, field_48_012345678 DATETIME ARRAY, field_49_0123456789 INT32)");
      /* 773 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 INT64 ARRAY, field_3_0123 INT64, field_4_01234 INT64, field_5_012345 BOOL, field_6_0123456 REAL, field_7_01234567 DATE, field_8_012345678 UINT64, field_9_0123456789 INT32, field_10_0 BOOL, field_11_01 INT16, field_12_012 REAL ARRAY, field_13_0123 UINT32 ARRAY, field_14_01234 CHAR ARRAY, field_15_012345 INT64, field_16_0123456 REAL ARRAY, field_17_01234567 INT8, field_18_012345678 INT64, field_19_0123456789 CHAR ARRAY, field_20_0 UINT64, field_21_01 DATETIME ARRAY, field_22_012 INT16, field_23_0123 RICHREAL)");
      /* 774 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 UINT8, field_3_0123 CHAR ARRAY, field_4_01234 CHAR, field_5_012345 UINT8 ARRAY, field_6_0123456 DATE, field_7_01234567 INT32 ARRAY, field_8_012345678 UINT64, field_9_0123456789 INT32, field_10_0 DATETIME, field_11_01 DATE, field_12_012 UINT64 ARRAY, field_13_0123 REAL, field_14_01234 HIRESTIME, field_15_012345 INT16, field_16_0123456 HIRESTIME ARRAY, field_17_01234567 DATETIME, field_18_012345678 UINT32, field_19_0123456789 HIRESTIME, field_20_0 INT16 ARRAY, field_21_01 DATETIME ARRAY, field_22_012 UINT64, field_23_0123 RICHREAL ARRAY, field_24_01234 RICHREAL, field_25_012345 HIRESTIME, field_26_0123456 RICHREAL, field_27_01234567 HIRESTIME, field_28_012345678 INT8, field_29_0123456789 UINT8 ARRAY, field_30_0 UINT16 ARRAY, field_31_01 DATETIME, field_32_012 DATETIME ARRAY, field_33_0123 INT64, field_34_01234 DATE, field_35_012345 INT64, field_36_0123456 CHAR, field_37_01234567 DATE, field_38_012345678 HIRESTIME, field_39_0123456789 UINT8, field_40_0 INT16, field_41_01 UINT32, field_42_012 DATETIME, field_43_0123 UINT64, field_44_01234 INT64, field_45_012345 BOOL ARRAY, field_46_0123456 INT64, field_47_01234567 UINT16, field_48_012345678 UINT64, field_49_0123456789 INT64, field_50_0 UINT64, field_51_01 UINT8, field_52_012 INT16, field_53_0123 INT32, field_54_01234 UINT32, field_55_012345 DATE, field_56_0123456 INT32)");
      /* 775 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 RICHREAL, field_3_0123 INT16, field_4_01234 INT8 ARRAY, field_5_012345 CHAR, field_6_0123456 UINT64, field_7_01234567 DATE, field_8_012345678 UINT8, field_9_0123456789 DATETIME, field_10_0 HIRESTIME, field_11_01 BOOL ARRAY, field_12_012 BOOL, field_13_0123 BOOL, field_14_01234 BOOL, field_15_012345 UINT16 ARRAY, field_16_0123456 RICHREAL, field_17_01234567 INT64, field_18_012345678 REAL, field_19_0123456789 DATE, field_20_0 UINT16, field_21_01 INT64, field_22_012 INT64, field_23_0123 BOOL ARRAY, field_24_01234 INT8, field_25_012345 BOOL, field_26_0123456 UINT64 ARRAY, field_27_01234567 UINT8, field_28_012345678 UINT8, field_29_0123456789 INT32, field_30_0 UINT16, field_31_01 INT32 ARRAY, field_32_012 INT8, field_33_0123 DATETIME, field_34_01234 INT64, field_35_012345 INT8 ARRAY, field_36_0123456 HIRESTIME ARRAY, field_37_01234567 HIRESTIME, field_38_012345678 UINT64, field_39_0123456789 RICHREAL, field_40_0 UINT64 ARRAY, field_41_01 HIRESTIME, field_42_012 UINT16 ARRAY, field_43_0123 REAL, field_44_01234 UINT16, field_45_012345 UINT16, field_46_0123456 UINT32 ARRAY, field_47_01234567 DATE, field_48_012345678 INT16, field_49_0123456789 UINT32, field_50_0 HIRESTIME, field_51_01 INT16, field_52_012 CHAR, field_53_0123 UINT8)");
      /* 776 */ glbTypes.push_back("TABLE(field_1_01 INT16 ARRAY, field_2_012 UINT64, field_3_0123 UINT32 ARRAY, field_4_01234 UINT8 ARRAY, field_5_012345 CHAR, field_6_0123456 UINT16, field_7_01234567 UINT32, field_8_012345678 HIRESTIME ARRAY, field_9_0123456789 RICHREAL, field_10_0 UINT8, field_11_01 RICHREAL, field_12_012 INT8, field_13_0123 UINT8, field_14_01234 DATE, field_15_012345 UINT16, field_16_0123456 DATETIME, field_17_01234567 UINT16, field_18_012345678 UINT32, field_19_0123456789 UINT16, field_20_0 REAL, field_21_01 INT32, field_22_012 UINT8, field_23_0123 INT16, field_24_01234 BOOL, field_25_012345 INT8, field_26_0123456 UINT64)");
      /* 777 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 CHAR ARRAY, field_3_0123 RICHREAL, field_4_01234 CHAR ARRAY, field_5_012345 UINT16, field_6_0123456 UINT64, field_7_01234567 CHAR, field_8_012345678 INT16 ARRAY, field_9_0123456789 INT16, field_10_0 DATE ARRAY, field_11_01 DATETIME, field_12_012 DATE ARRAY, field_13_0123 UINT64, field_14_01234 INT64 ARRAY, field_15_012345 CHAR, field_16_0123456 REAL, field_17_01234567 REAL, field_18_012345678 UINT32, field_19_0123456789 DATETIME, field_20_0 DATE, field_21_01 BOOL, field_22_012 INT64, field_23_0123 UINT16, field_24_01234 CHAR, field_25_012345 DATE, field_26_0123456 HIRESTIME, field_27_01234567 BOOL, field_28_012345678 UINT64, field_29_0123456789 RICHREAL, field_30_0 DATE, field_31_01 INT8, field_32_012 UINT32, field_33_0123 HIRESTIME ARRAY, field_34_01234 DATE, field_35_012345 UINT32, field_36_0123456 UINT32, field_37_01234567 UINT32, field_38_012345678 UINT8, field_39_0123456789 INT16, field_40_0 UINT64, field_41_01 UINT64, field_42_012 DATE ARRAY, field_43_0123 RICHREAL ARRAY, field_44_01234 INT16, field_45_012345 DATE, field_46_0123456 UINT16, field_47_01234567 RICHREAL, field_48_012345678 CHAR, field_49_0123456789 CHAR ARRAY, field_50_0 DATE ARRAY, field_51_01 UINT64, field_52_012 HIRESTIME, field_53_0123 INT8 ARRAY, field_54_01234 REAL, field_55_012345 INT8, field_56_0123456 UINT8, field_57_01234567 DATETIME ARRAY, field_58_012345678 HIRESTIME, field_59_0123456789 UINT8, field_60_0 DATE, field_61_01 DATETIME, field_62_012 HIRESTIME, field_63_0123 RICHREAL, field_64_01234 INT8, field_65_012345 INT32 ARRAY, field_66_0123456 UINT16, field_67_01234567 HIRESTIME, field_68_012345678 UINT8, field_69_0123456789 INT32, field_70_0 UINT32, field_71_01 BOOL, field_72_012 REAL, field_73_0123 INT8, field_74_01234 UINT32 ARRAY, field_75_012345 DATE, field_76_0123456 BOOL, field_77_01234567 INT8, field_78_012345678 CHAR, field_79_0123456789 UINT16, field_80_0 REAL, field_81_01 BOOL, field_82_012 INT32, field_83_0123 BOOL ARRAY, field_84_01234 HIRESTIME, field_85_012345 UINT32, field_86_0123456 REAL, field_87_01234567 UINT32, field_88_012345678 BOOL, field_89_0123456789 INT32)");
      /* 778 */ glbTypes.push_back("TABLE(field_1_01 UINT64 ARRAY, field_2_012 RICHREAL ARRAY, field_3_0123 INT64, field_4_01234 RICHREAL, field_5_012345 RICHREAL, field_6_0123456 INT64, field_7_01234567 INT16, field_8_012345678 INT8, field_9_0123456789 UINT32, field_10_0 DATETIME, field_11_01 UINT8, field_12_012 UINT32, field_13_0123 INT8, field_14_01234 BOOL ARRAY, field_15_012345 DATETIME ARRAY, field_16_0123456 RICHREAL, field_17_01234567 CHAR, field_18_012345678 RICHREAL, field_19_0123456789 DATE ARRAY, field_20_0 RICHREAL, field_21_01 DATE, field_22_012 HIRESTIME, field_23_0123 DATETIME ARRAY, field_24_01234 UINT8, field_25_012345 INT32)");
      /* 779 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 DATETIME, field_3_0123 BOOL, field_4_01234 CHAR ARRAY, field_5_012345 UINT16, field_6_0123456 INT8 ARRAY, field_7_01234567 DATETIME, field_8_012345678 CHAR, field_9_0123456789 INT32, field_10_0 UINT64 ARRAY, field_11_01 RICHREAL ARRAY, field_12_012 UINT32, field_13_0123 UINT64, field_14_01234 UINT32, field_15_012345 INT16, field_16_0123456 INT8, field_17_01234567 DATETIME ARRAY, field_18_012345678 DATETIME)");
      /* 780 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 DATETIME, field_3_0123 INT64, field_4_01234 RICHREAL, field_5_012345 CHAR, field_6_0123456 BOOL, field_7_01234567 INT32, field_8_012345678 UINT64, field_9_0123456789 DATE, field_10_0 UINT32, field_11_01 UINT32, field_12_012 INT32, field_13_0123 INT64, field_14_01234 INT16, field_15_012345 DATE ARRAY, field_16_0123456 DATE, field_17_01234567 RICHREAL, field_18_012345678 INT8, field_19_0123456789 DATE, field_20_0 BOOL, field_21_01 REAL, field_22_012 UINT16, field_23_0123 INT8, field_24_01234 DATETIME, field_25_012345 UINT8, field_26_0123456 CHAR, field_27_01234567 INT32, field_28_012345678 DATE ARRAY, field_29_0123456789 UINT8, field_30_0 RICHREAL, field_31_01 UINT32, field_32_012 REAL, field_33_0123 INT8, field_34_01234 DATETIME ARRAY, field_35_012345 UINT64, field_36_0123456 RICHREAL)");
      /* 781 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 UINT8, field_3_0123 DATETIME, field_4_01234 UINT16, field_5_012345 CHAR, field_6_0123456 DATETIME, field_7_01234567 UINT16, field_8_012345678 REAL, field_9_0123456789 INT32 ARRAY, field_10_0 REAL, field_11_01 CHAR, field_12_012 DATE ARRAY, field_13_0123 HIRESTIME, field_14_01234 UINT32 ARRAY, field_15_012345 INT8 ARRAY, field_16_0123456 BOOL ARRAY, field_17_01234567 UINT8 ARRAY, field_18_012345678 BOOL, field_19_0123456789 UINT64, field_20_0 UINT64, field_21_01 UINT32, field_22_012 BOOL, field_23_0123 INT32, field_24_01234 CHAR ARRAY, field_25_012345 DATETIME, field_26_0123456 INT32 ARRAY, field_27_01234567 BOOL ARRAY, field_28_012345678 DATE, field_29_0123456789 UINT32, field_30_0 CHAR, field_31_01 HIRESTIME, field_32_012 REAL, field_33_0123 DATE, field_34_01234 INT32, field_35_012345 DATE ARRAY, field_36_0123456 INT32, field_37_01234567 HIRESTIME, field_38_012345678 CHAR, field_39_0123456789 RICHREAL, field_40_0 UINT64, field_41_01 RICHREAL, field_42_012 INT64, field_43_0123 INT32, field_44_01234 DATE, field_45_012345 INT32 ARRAY, field_46_0123456 CHAR)");
      /* 782 */ glbTypes.push_back("TABLE(field_1_01 UINT64 ARRAY, field_2_012 DATE, field_3_0123 HIRESTIME, field_4_01234 BOOL, field_5_012345 DATE, field_6_0123456 INT32 ARRAY, field_7_01234567 INT64, field_8_012345678 INT32, field_9_0123456789 HIRESTIME, field_10_0 UINT32 ARRAY, field_11_01 DATETIME, field_12_012 UINT16, field_13_0123 UINT64, field_14_01234 RICHREAL, field_15_012345 INT32, field_16_0123456 DATE, field_17_01234567 DATE, field_18_012345678 INT64, field_19_0123456789 CHAR, field_20_0 RICHREAL ARRAY, field_21_01 BOOL ARRAY, field_22_012 BOOL ARRAY, field_23_0123 INT64, field_24_01234 UINT16, field_25_012345 INT64 ARRAY, field_26_0123456 UINT64, field_27_01234567 CHAR, field_28_012345678 DATE, field_29_0123456789 UINT16, field_30_0 INT16, field_31_01 CHAR, field_32_012 UINT32 ARRAY, field_33_0123 DATETIME, field_34_01234 UINT8 ARRAY, field_35_012345 UINT8, field_36_0123456 HIRESTIME, field_37_01234567 INT16, field_38_012345678 INT64, field_39_0123456789 DATE, field_40_0 BOOL, field_41_01 DATETIME, field_42_012 INT16, field_43_0123 BOOL, field_44_01234 INT8, field_45_012345 UINT8, field_46_0123456 INT64, field_47_01234567 UINT16 ARRAY, field_48_012345678 UINT16, field_49_0123456789 UINT16 ARRAY, field_50_0 INT16, field_51_01 DATETIME, field_52_012 INT16, field_53_0123 BOOL, field_54_01234 CHAR, field_55_012345 INT8, field_56_0123456 BOOL, field_57_01234567 INT16, field_58_012345678 DATE ARRAY, field_59_0123456789 INT32, field_60_0 BOOL, field_61_01 BOOL, field_62_012 UINT8, field_63_0123 INT16 ARRAY, field_64_01234 DATE, field_65_012345 INT64, field_66_0123456 RICHREAL, field_67_01234567 BOOL, field_68_012345678 INT16, field_69_0123456789 INT64 ARRAY, field_70_0 BOOL, field_71_01 INT8, field_72_012 REAL, field_73_0123 INT64, field_74_01234 HIRESTIME, field_75_012345 DATETIME, field_76_0123456 DATE ARRAY, field_77_01234567 UINT8, field_78_012345678 UINT16, field_79_0123456789 INT64, field_80_0 BOOL, field_81_01 UINT16, field_82_012 UINT32, field_83_0123 INT16, field_84_01234 UINT32, field_85_012345 HIRESTIME, field_86_0123456 UINT8, field_87_01234567 REAL, field_88_012345678 BOOL)");
      /* 783 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 BOOL, field_3_0123 RICHREAL, field_4_01234 INT32 ARRAY, field_5_012345 HIRESTIME ARRAY, field_6_0123456 INT32, field_7_01234567 DATETIME ARRAY, field_8_012345678 UINT64, field_9_0123456789 DATETIME ARRAY, field_10_0 BOOL, field_11_01 DATETIME, field_12_012 HIRESTIME ARRAY, field_13_0123 UINT16 ARRAY, field_14_01234 DATETIME ARRAY)");
      /* 784 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 HIRESTIME, field_3_0123 CHAR, field_4_01234 REAL, field_5_012345 UINT32, field_6_0123456 INT16, field_7_01234567 INT8 ARRAY, field_8_012345678 INT64, field_9_0123456789 CHAR, field_10_0 CHAR, field_11_01 BOOL ARRAY, field_12_012 CHAR ARRAY, field_13_0123 UINT16 ARRAY, field_14_01234 UINT32, field_15_012345 DATETIME ARRAY, field_16_0123456 UINT16, field_17_01234567 RICHREAL, field_18_012345678 UINT8 ARRAY, field_19_0123456789 INT32, field_20_0 INT64, field_21_01 DATE ARRAY, field_22_012 CHAR, field_23_0123 INT16, field_24_01234 UINT16, field_25_012345 DATETIME, field_26_0123456 INT8, field_27_01234567 UINT8, field_28_012345678 UINT32, field_29_0123456789 UINT16, field_30_0 INT8 ARRAY, field_31_01 RICHREAL, field_32_012 UINT32, field_33_0123 DATETIME, field_34_01234 UINT16 ARRAY, field_35_012345 INT16, field_36_0123456 DATETIME, field_37_01234567 UINT32, field_38_012345678 DATE, field_39_0123456789 HIRESTIME, field_40_0 INT32, field_41_01 UINT32, field_42_012 BOOL, field_43_0123 INT32 ARRAY, field_44_01234 INT64, field_45_012345 INT64, field_46_0123456 DATE, field_47_01234567 INT32, field_48_012345678 INT8, field_49_0123456789 CHAR, field_50_0 INT8, field_51_01 RICHREAL, field_52_012 CHAR, field_53_0123 DATETIME, field_54_01234 INT16, field_55_012345 CHAR, field_56_0123456 HIRESTIME, field_57_01234567 REAL, field_58_012345678 INT16, field_59_0123456789 UINT8, field_60_0 UINT32, field_61_01 INT32 ARRAY, field_62_012 UINT8 ARRAY, field_63_0123 BOOL, field_64_01234 DATE, field_65_012345 CHAR ARRAY, field_66_0123456 DATE, field_67_01234567 DATE, field_68_012345678 INT32, field_69_0123456789 REAL, field_70_0 HIRESTIME ARRAY, field_71_01 CHAR, field_72_012 BOOL, field_73_0123 HIRESTIME ARRAY, field_74_01234 BOOL, field_75_012345 INT64, field_76_0123456 RICHREAL, field_77_01234567 INT16, field_78_012345678 REAL, field_79_0123456789 DATE, field_80_0 INT64, field_81_01 BOOL, field_82_012 UINT8, field_83_0123 REAL ARRAY, field_84_01234 UINT16, field_85_012345 INT8, field_86_0123456 CHAR, field_87_01234567 INT64, field_88_012345678 UINT32, field_89_0123456789 INT8, field_90_0 HIRESTIME, field_91_01 UINT64)");
      /* 785 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 UINT16, field_3_0123 UINT32, field_4_01234 CHAR, field_5_012345 DATE, field_6_0123456 CHAR ARRAY, field_7_01234567 REAL, field_8_012345678 INT16, field_9_0123456789 UINT16, field_10_0 REAL, field_11_01 INT16, field_12_012 INT64, field_13_0123 REAL, field_14_01234 INT8, field_15_012345 HIRESTIME, field_16_0123456 UINT16, field_17_01234567 UINT16, field_18_012345678 UINT64, field_19_0123456789 DATETIME, field_20_0 INT64 ARRAY, field_21_01 UINT32, field_22_012 INT32 ARRAY, field_23_0123 BOOL, field_24_01234 HIRESTIME, field_25_012345 UINT16, field_26_0123456 RICHREAL, field_27_01234567 HIRESTIME, field_28_012345678 DATE, field_29_0123456789 HIRESTIME, field_30_0 INT16, field_31_01 REAL, field_32_012 BOOL, field_33_0123 INT32 ARRAY, field_34_01234 BOOL, field_35_012345 INT32, field_36_0123456 UINT8, field_37_01234567 UINT8, field_38_012345678 INT8, field_39_0123456789 RICHREAL, field_40_0 REAL, field_41_01 INT16, field_42_012 UINT8 ARRAY, field_43_0123 INT32, field_44_01234 UINT32, field_45_012345 INT32 ARRAY, field_46_0123456 DATETIME, field_47_01234567 UINT16, field_48_012345678 UINT8, field_49_0123456789 INT64, field_50_0 RICHREAL, field_51_01 UINT8, field_52_012 DATE ARRAY, field_53_0123 INT64, field_54_01234 CHAR ARRAY, field_55_012345 BOOL, field_56_0123456 DATE, field_57_01234567 BOOL, field_58_012345678 INT64, field_59_0123456789 HIRESTIME, field_60_0 DATE, field_61_01 INT32 ARRAY, field_62_012 UINT8, field_63_0123 INT8 ARRAY, field_64_01234 INT64 ARRAY, field_65_012345 CHAR, field_66_0123456 HIRESTIME, field_67_01234567 HIRESTIME, field_68_012345678 UINT8, field_69_0123456789 REAL, field_70_0 UINT16, field_71_01 RICHREAL ARRAY, field_72_012 UINT64, field_73_0123 HIRESTIME, field_74_01234 INT32, field_75_012345 UINT64)");
      /* 786 */ glbTypes.push_back("TABLE(field_1_01 UINT16 ARRAY, field_2_012 INT8, field_3_0123 UINT64, field_4_01234 INT32, field_5_012345 REAL, field_6_0123456 HIRESTIME, field_7_01234567 REAL ARRAY, field_8_012345678 UINT32, field_9_0123456789 UINT64 ARRAY, field_10_0 INT16, field_11_01 INT16, field_12_012 INT64, field_13_0123 INT8, field_14_01234 UINT32, field_15_012345 RICHREAL, field_16_0123456 INT64 ARRAY, field_17_01234567 DATE, field_18_012345678 INT8, field_19_0123456789 DATETIME ARRAY, field_20_0 BOOL, field_21_01 UINT32, field_22_012 DATE ARRAY, field_23_0123 INT64, field_24_01234 RICHREAL, field_25_012345 INT32, field_26_0123456 UINT32, field_27_01234567 HIRESTIME, field_28_012345678 INT8, field_29_0123456789 BOOL ARRAY, field_30_0 INT16, field_31_01 HIRESTIME, field_32_012 UINT32, field_33_0123 INT64, field_34_01234 RICHREAL, field_35_012345 DATETIME, field_36_0123456 INT32, field_37_01234567 BOOL, field_38_012345678 INT8 ARRAY, field_39_0123456789 INT32, field_40_0 INT16, field_41_01 UINT64, field_42_012 INT32, field_43_0123 UINT64, field_44_01234 DATETIME, field_45_012345 INT64, field_46_0123456 INT32, field_47_01234567 INT32 ARRAY, field_48_012345678 INT32, field_49_0123456789 REAL ARRAY, field_50_0 UINT8, field_51_01 UINT64, field_52_012 DATE ARRAY, field_53_0123 UINT8 ARRAY, field_54_01234 UINT64 ARRAY, field_55_012345 UINT32, field_56_0123456 HIRESTIME ARRAY, field_57_01234567 RICHREAL)");
      /* 787 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 BOOL, field_3_0123 INT64, field_4_01234 INT32, field_5_012345 UINT8 ARRAY, field_6_0123456 DATE, field_7_01234567 REAL, field_8_012345678 UINT16, field_9_0123456789 UINT64, field_10_0 UINT8, field_11_01 BOOL, field_12_012 BOOL, field_13_0123 RICHREAL, field_14_01234 INT64, field_15_012345 UINT64, field_16_0123456 HIRESTIME, field_17_01234567 UINT32 ARRAY, field_18_012345678 BOOL, field_19_0123456789 REAL)");
      /* 788 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 INT32 ARRAY, field_3_0123 CHAR, field_4_01234 UINT64, field_5_012345 UINT32, field_6_0123456 DATETIME, field_7_01234567 RICHREAL, field_8_012345678 INT8 ARRAY, field_9_0123456789 INT8, field_10_0 BOOL, field_11_01 DATE ARRAY, field_12_012 BOOL, field_13_0123 BOOL, field_14_01234 RICHREAL ARRAY, field_15_012345 UINT64)");
      /* 789 */ glbTypes.push_back("TABLE(field_1_01 UINT16 ARRAY, field_2_012 HIRESTIME, field_3_0123 REAL ARRAY, field_4_01234 UINT8)");
      /* 790 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 HIRESTIME, field_3_0123 BOOL ARRAY, field_4_01234 UINT64, field_5_012345 BOOL, field_6_0123456 INT8, field_7_01234567 INT8 ARRAY, field_8_012345678 INT16 ARRAY, field_9_0123456789 DATE, field_10_0 INT8, field_11_01 INT16, field_12_012 REAL, field_13_0123 BOOL, field_14_01234 UINT32, field_15_012345 REAL, field_16_0123456 UINT64, field_17_01234567 INT64, field_18_012345678 UINT32, field_19_0123456789 RICHREAL ARRAY, field_20_0 UINT8 ARRAY, field_21_01 UINT64, field_22_012 CHAR, field_23_0123 UINT16, field_24_01234 DATE, field_25_012345 INT64, field_26_0123456 REAL, field_27_01234567 CHAR, field_28_012345678 INT64 ARRAY, field_29_0123456789 RICHREAL, field_30_0 INT32 ARRAY, field_31_01 UINT32, field_32_012 BOOL ARRAY, field_33_0123 RICHREAL, field_34_01234 CHAR, field_35_012345 DATETIME, field_36_0123456 INT16, field_37_01234567 RICHREAL, field_38_012345678 UINT8 ARRAY, field_39_0123456789 UINT8 ARRAY, field_40_0 UINT32)");
      /* 791 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 DATETIME, field_3_0123 INT32, field_4_01234 HIRESTIME, field_5_012345 UINT16 ARRAY, field_6_0123456 RICHREAL, field_7_01234567 UINT32 ARRAY, field_8_012345678 INT16, field_9_0123456789 INT8, field_10_0 UINT8, field_11_01 BOOL, field_12_012 DATETIME, field_13_0123 CHAR, field_14_01234 DATETIME, field_15_012345 UINT64, field_16_0123456 INT64, field_17_01234567 BOOL, field_18_012345678 INT8, field_19_0123456789 INT8, field_20_0 UINT16, field_21_01 INT8, field_22_012 UINT64, field_23_0123 UINT64, field_24_01234 CHAR, field_25_012345 RICHREAL, field_26_0123456 DATE ARRAY, field_27_01234567 UINT8, field_28_012345678 BOOL, field_29_0123456789 UINT8, field_30_0 REAL, field_31_01 HIRESTIME, field_32_012 INT16, field_33_0123 INT8, field_34_01234 INT16 ARRAY, field_35_012345 UINT32, field_36_0123456 CHAR, field_37_01234567 DATETIME, field_38_012345678 UINT16, field_39_0123456789 CHAR, field_40_0 DATETIME, field_41_01 UINT8, field_42_012 DATETIME ARRAY, field_43_0123 CHAR, field_44_01234 UINT64, field_45_012345 HIRESTIME, field_46_0123456 UINT8, field_47_01234567 INT16, field_48_012345678 CHAR ARRAY, field_49_0123456789 RICHREAL, field_50_0 HIRESTIME ARRAY, field_51_01 RICHREAL, field_52_012 INT8, field_53_0123 INT16 ARRAY, field_54_01234 DATETIME, field_55_012345 INT64, field_56_0123456 INT32, field_57_01234567 UINT64, field_58_012345678 INT64, field_59_0123456789 HIRESTIME, field_60_0 UINT32, field_61_01 INT32, field_62_012 UINT32, field_63_0123 CHAR, field_64_01234 UINT16, field_65_012345 INT8, field_66_0123456 DATETIME, field_67_01234567 CHAR)");
      /* 792 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 CHAR ARRAY, field_3_0123 BOOL, field_4_01234 BOOL, field_5_012345 INT16, field_6_0123456 DATETIME, field_7_01234567 BOOL, field_8_012345678 CHAR ARRAY, field_9_0123456789 INT64, field_10_0 INT64, field_11_01 REAL, field_12_012 RICHREAL, field_13_0123 REAL, field_14_01234 UINT8, field_15_012345 UINT32, field_16_0123456 INT8, field_17_01234567 INT64, field_18_012345678 UINT16, field_19_0123456789 UINT64, field_20_0 UINT64, field_21_01 DATE, field_22_012 UINT8 ARRAY, field_23_0123 DATETIME, field_24_01234 HIRESTIME, field_25_012345 INT8, field_26_0123456 UINT64, field_27_01234567 RICHREAL, field_28_012345678 HIRESTIME ARRAY, field_29_0123456789 CHAR, field_30_0 RICHREAL, field_31_01 DATE)");
      /* 793 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 INT64, field_3_0123 BOOL, field_4_01234 UINT64 ARRAY, field_5_012345 INT16, field_6_0123456 INT8, field_7_01234567 INT16 ARRAY, field_8_012345678 CHAR, field_9_0123456789 UINT32, field_10_0 INT32, field_11_01 BOOL, field_12_012 RICHREAL, field_13_0123 UINT32)");
      /* 794 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 DATE, field_3_0123 INT64, field_4_01234 INT64, field_5_012345 INT32, field_6_0123456 UINT8 ARRAY, field_7_01234567 INT8, field_8_012345678 UINT16 ARRAY, field_9_0123456789 UINT8, field_10_0 CHAR, field_11_01 INT64, field_12_012 INT64)");
      /* 795 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 HIRESTIME, field_3_0123 INT16, field_4_01234 RICHREAL, field_5_012345 RICHREAL, field_6_0123456 INT32 ARRAY, field_7_01234567 UINT32, field_8_012345678 INT16, field_9_0123456789 DATE, field_10_0 UINT32 ARRAY, field_11_01 BOOL, field_12_012 INT16, field_13_0123 INT16 ARRAY, field_14_01234 DATE, field_15_012345 HIRESTIME, field_16_0123456 BOOL, field_17_01234567 UINT32 ARRAY, field_18_012345678 CHAR, field_19_0123456789 DATE, field_20_0 INT64 ARRAY, field_21_01 CHAR, field_22_012 INT32, field_23_0123 INT8, field_24_01234 UINT64, field_25_012345 RICHREAL ARRAY, field_26_0123456 BOOL, field_27_01234567 UINT64)");
      /* 796 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 RICHREAL, field_3_0123 INT32, field_4_01234 UINT64, field_5_012345 BOOL ARRAY, field_6_0123456 INT32 ARRAY, field_7_01234567 UINT64, field_8_012345678 CHAR, field_9_0123456789 UINT32 ARRAY, field_10_0 INT64, field_11_01 REAL ARRAY, field_12_012 INT32, field_13_0123 UINT16 ARRAY, field_14_01234 UINT8, field_15_012345 DATE, field_16_0123456 INT64)");
      /* 797 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 INT32, field_3_0123 INT32, field_4_01234 UINT16, field_5_012345 BOOL, field_6_0123456 INT32 ARRAY, field_7_01234567 UINT8, field_8_012345678 DATETIME, field_9_0123456789 INT64, field_10_0 UINT64, field_11_01 RICHREAL, field_12_012 UINT32, field_13_0123 UINT32 ARRAY, field_14_01234 INT32, field_15_012345 BOOL, field_16_0123456 UINT64 ARRAY, field_17_01234567 INT64, field_18_012345678 INT8, field_19_0123456789 DATE, field_20_0 INT16, field_21_01 UINT32, field_22_012 DATETIME, field_23_0123 INT16, field_24_01234 HIRESTIME, field_25_012345 INT8, field_26_0123456 HIRESTIME, field_27_01234567 INT64, field_28_012345678 INT8 ARRAY, field_29_0123456789 REAL ARRAY, field_30_0 UINT8, field_31_01 INT64, field_32_012 INT32 ARRAY, field_33_0123 RICHREAL ARRAY, field_34_01234 INT16 ARRAY, field_35_012345 DATETIME ARRAY, field_36_0123456 CHAR ARRAY, field_37_01234567 RICHREAL, field_38_012345678 HIRESTIME, field_39_0123456789 UINT32 ARRAY)");
      /* 798 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 INT8 ARRAY, field_3_0123 UINT32, field_4_01234 BOOL, field_5_012345 UINT64, field_6_0123456 DATETIME, field_7_01234567 INT32, field_8_012345678 CHAR ARRAY, field_9_0123456789 INT64, field_10_0 UINT64, field_11_01 RICHREAL, field_12_012 CHAR, field_13_0123 UINT32, field_14_01234 UINT32 ARRAY, field_15_012345 UINT32, field_16_0123456 DATE, field_17_01234567 HIRESTIME, field_18_012345678 INT64, field_19_0123456789 INT64 ARRAY, field_20_0 REAL, field_21_01 DATETIME, field_22_012 UINT64, field_23_0123 DATE ARRAY, field_24_01234 UINT32, field_25_012345 BOOL, field_26_0123456 INT64, field_27_01234567 INT64, field_28_012345678 INT8 ARRAY, field_29_0123456789 INT16, field_30_0 INT8, field_31_01 INT64 ARRAY, field_32_012 BOOL, field_33_0123 DATE, field_34_01234 REAL, field_35_012345 BOOL, field_36_0123456 UINT64, field_37_01234567 INT8, field_38_012345678 HIRESTIME, field_39_0123456789 DATE, field_40_0 UINT64, field_41_01 INT64, field_42_012 INT64, field_43_0123 INT32, field_44_01234 INT8, field_45_012345 DATE, field_46_0123456 REAL, field_47_01234567 HIRESTIME ARRAY, field_48_012345678 HIRESTIME, field_49_0123456789 UINT32 ARRAY, field_50_0 DATETIME, field_51_01 REAL, field_52_012 INT8 ARRAY, field_53_0123 UINT16, field_54_01234 DATETIME, field_55_012345 UINT16, field_56_0123456 INT8, field_57_01234567 DATE, field_58_012345678 UINT32, field_59_0123456789 CHAR ARRAY, field_60_0 HIRESTIME ARRAY, field_61_01 REAL, field_62_012 INT32, field_63_0123 DATETIME, field_64_01234 DATETIME, field_65_012345 INT8, field_66_0123456 REAL, field_67_01234567 DATE ARRAY, field_68_012345678 INT16, field_69_0123456789 INT32, field_70_0 UINT64, field_71_01 CHAR, field_72_012 DATE, field_73_0123 RICHREAL, field_74_01234 CHAR ARRAY, field_75_012345 REAL, field_76_0123456 UINT8 ARRAY, field_77_01234567 DATE, field_78_012345678 RICHREAL, field_79_0123456789 INT8, field_80_0 INT32, field_81_01 DATE, field_82_012 INT32, field_83_0123 INT8 ARRAY, field_84_01234 UINT32, field_85_012345 HIRESTIME, field_86_0123456 BOOL, field_87_01234567 DATE, field_88_012345678 BOOL, field_89_0123456789 INT32, field_90_0 INT16)");
      /* 799 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 INT64, field_3_0123 INT16, field_4_01234 REAL ARRAY, field_5_012345 BOOL ARRAY, field_6_0123456 INT64 ARRAY, field_7_01234567 RICHREAL, field_8_012345678 BOOL, field_9_0123456789 UINT32 ARRAY, field_10_0 RICHREAL ARRAY, field_11_01 INT64, field_12_012 UINT32, field_13_0123 BOOL, field_14_01234 HIRESTIME ARRAY, field_15_012345 UINT8, field_16_0123456 DATETIME, field_17_01234567 UINT64 ARRAY, field_18_012345678 INT16 ARRAY, field_19_0123456789 REAL ARRAY, field_20_0 REAL, field_21_01 DATETIME, field_22_012 INT32 ARRAY, field_23_0123 CHAR ARRAY, field_24_01234 INT32, field_25_012345 DATETIME, field_26_0123456 DATE, field_27_01234567 DATE, field_28_012345678 INT32, field_29_0123456789 INT8, field_30_0 DATETIME, field_31_01 BOOL, field_32_012 CHAR ARRAY, field_33_0123 RICHREAL, field_34_01234 INT64 ARRAY, field_35_012345 DATETIME, field_36_0123456 UINT64, field_37_01234567 REAL, field_38_012345678 UINT8, field_39_0123456789 UINT32, field_40_0 DATETIME, field_41_01 REAL, field_42_012 INT16 ARRAY, field_43_0123 DATE, field_44_01234 BOOL, field_45_012345 INT32, field_46_0123456 REAL, field_47_01234567 UINT64, field_48_012345678 BOOL, field_49_0123456789 UINT16, field_50_0 DATE ARRAY, field_51_01 INT16, field_52_012 INT64, field_53_0123 UINT32, field_54_01234 INT16 ARRAY, field_55_012345 BOOL, field_56_0123456 RICHREAL, field_57_01234567 INT64, field_58_012345678 INT64 ARRAY, field_59_0123456789 INT16, field_60_0 DATE, field_61_01 INT8 ARRAY, field_62_012 INT16, field_63_0123 UINT8, field_64_01234 CHAR, field_65_012345 INT16, field_66_0123456 CHAR ARRAY, field_67_01234567 HIRESTIME, field_68_012345678 BOOL ARRAY, field_69_0123456789 UINT32, field_70_0 CHAR, field_71_01 INT8 ARRAY, field_72_012 INT64, field_73_0123 DATETIME, field_74_01234 INT8, field_75_012345 DATE ARRAY, field_76_0123456 REAL ARRAY, field_77_01234567 INT32, field_78_012345678 DATE, field_79_0123456789 UINT32, field_80_0 UINT64, field_81_01 INT64)");
      /* 800 */ glbTypes.push_back("TABLE(field_1_01 UINT8 ARRAY, field_2_012 HIRESTIME, field_3_0123 REAL, field_4_01234 INT16, field_5_012345 UINT8, field_6_0123456 INT64, field_7_01234567 INT32 ARRAY, field_8_012345678 INT8, field_9_0123456789 INT16, field_10_0 INT32, field_11_01 UINT16, field_12_012 DATETIME, field_13_0123 INT32, field_14_01234 BOOL, field_15_012345 INT16 ARRAY, field_16_0123456 UINT8, field_17_01234567 INT64, field_18_012345678 DATE ARRAY, field_19_0123456789 INT16, field_20_0 BOOL, field_21_01 DATE, field_22_012 UINT32 ARRAY, field_23_0123 UINT16, field_24_01234 UINT64 ARRAY, field_25_012345 INT8, field_26_0123456 UINT8 ARRAY, field_27_01234567 BOOL, field_28_012345678 INT16, field_29_0123456789 UINT8, field_30_0 INT16, field_31_01 DATETIME, field_32_012 UINT16 ARRAY, field_33_0123 INT16, field_34_01234 BOOL, field_35_012345 HIRESTIME, field_36_0123456 INT64, field_37_01234567 INT64, field_38_012345678 HIRESTIME, field_39_0123456789 INT16, field_40_0 RICHREAL, field_41_01 UINT32, field_42_012 INT16, field_43_0123 DATE, field_44_01234 HIRESTIME, field_45_012345 BOOL, field_46_0123456 UINT32, field_47_01234567 HIRESTIME, field_48_012345678 INT32, field_49_0123456789 UINT32, field_50_0 CHAR, field_51_01 REAL, field_52_012 DATETIME, field_53_0123 INT16, field_54_01234 RICHREAL, field_55_012345 UINT8, field_56_0123456 INT8, field_57_01234567 INT64, field_58_012345678 CHAR, field_59_0123456789 HIRESTIME, field_60_0 INT64 ARRAY, field_61_01 DATETIME, field_62_012 CHAR ARRAY, field_63_0123 INT32, field_64_01234 INT64, field_65_012345 INT64, field_66_0123456 DATE, field_67_01234567 BOOL, field_68_012345678 CHAR, field_69_0123456789 CHAR ARRAY, field_70_0 HIRESTIME, field_71_01 DATETIME, field_72_012 BOOL, field_73_0123 UINT32, field_74_01234 INT64 ARRAY)");
      /* 801 */ glbTypes.push_back("TABLE(field_1_01 INT32)");
      /* 802 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 INT16, field_3_0123 UINT16, field_4_01234 REAL ARRAY, field_5_012345 REAL, field_6_0123456 RICHREAL, field_7_01234567 DATETIME, field_8_012345678 UINT8, field_9_0123456789 INT32, field_10_0 UINT32, field_11_01 REAL ARRAY, field_12_012 HIRESTIME, field_13_0123 INT64, field_14_01234 UINT64, field_15_012345 INT64, field_16_0123456 INT64, field_17_01234567 DATETIME, field_18_012345678 INT64, field_19_0123456789 REAL, field_20_0 RICHREAL ARRAY, field_21_01 CHAR, field_22_012 DATETIME, field_23_0123 RICHREAL, field_24_01234 HIRESTIME, field_25_012345 INT32, field_26_0123456 CHAR, field_27_01234567 RICHREAL, field_28_012345678 INT8, field_29_0123456789 INT64, field_30_0 REAL, field_31_01 DATETIME ARRAY, field_32_012 RICHREAL ARRAY, field_33_0123 DATE, field_34_01234 UINT16, field_35_012345 UINT64, field_36_0123456 HIRESTIME, field_37_01234567 BOOL, field_38_012345678 HIRESTIME)");
      /* 803 */ glbTypes.push_back("TABLE(field_1_01 CHAR ARRAY, field_2_012 BOOL, field_3_0123 INT32, field_4_01234 INT16, field_5_012345 INT8 ARRAY, field_6_0123456 UINT8 ARRAY, field_7_01234567 INT16, field_8_012345678 UINT8, field_9_0123456789 INT8, field_10_0 UINT64, field_11_01 UINT16, field_12_012 INT32, field_13_0123 BOOL, field_14_01234 RICHREAL ARRAY, field_15_012345 REAL, field_16_0123456 UINT8, field_17_01234567 INT8, field_18_012345678 UINT8, field_19_0123456789 INT64, field_20_0 INT64 ARRAY, field_21_01 HIRESTIME, field_22_012 INT64 ARRAY, field_23_0123 INT64, field_24_01234 INT32 ARRAY, field_25_012345 BOOL, field_26_0123456 INT32, field_27_01234567 UINT32 ARRAY, field_28_012345678 CHAR, field_29_0123456789 INT64, field_30_0 UINT16, field_31_01 CHAR ARRAY, field_32_012 INT32 ARRAY, field_33_0123 CHAR, field_34_01234 INT16, field_35_012345 UINT8 ARRAY, field_36_0123456 UINT8, field_37_01234567 INT32)");
      /* 804 */ glbTypes.push_back("TABLE(field_1_01 INT32 ARRAY, field_2_012 RICHREAL, field_3_0123 INT16, field_4_01234 DATETIME, field_5_012345 UINT64, field_6_0123456 UINT32, field_7_01234567 UINT16, field_8_012345678 INT16, field_9_0123456789 REAL, field_10_0 INT16 ARRAY, field_11_01 RICHREAL, field_12_012 INT32 ARRAY, field_13_0123 HIRESTIME ARRAY, field_14_01234 UINT8, field_15_012345 UINT16, field_16_0123456 INT16, field_17_01234567 DATETIME ARRAY, field_18_012345678 BOOL ARRAY, field_19_0123456789 UINT64, field_20_0 UINT64, field_21_01 UINT16, field_22_012 INT16, field_23_0123 RICHREAL, field_24_01234 UINT32, field_25_012345 INT8, field_26_0123456 BOOL ARRAY, field_27_01234567 INT8, field_28_012345678 DATE, field_29_0123456789 UINT64, field_30_0 RICHREAL, field_31_01 INT16, field_32_012 DATETIME, field_33_0123 INT32, field_34_01234 INT32, field_35_012345 INT32, field_36_0123456 DATETIME, field_37_01234567 UINT16, field_38_012345678 INT16, field_39_0123456789 INT64, field_40_0 INT8 ARRAY, field_41_01 HIRESTIME, field_42_012 RICHREAL, field_43_0123 HIRESTIME, field_44_01234 CHAR, field_45_012345 UINT8 ARRAY, field_46_0123456 BOOL, field_47_01234567 UINT32, field_48_012345678 DATETIME, field_49_0123456789 RICHREAL, field_50_0 INT64, field_51_01 DATE ARRAY, field_52_012 UINT64, field_53_0123 UINT16, field_54_01234 UINT8, field_55_012345 HIRESTIME, field_56_0123456 CHAR, field_57_01234567 DATETIME, field_58_012345678 INT32, field_59_0123456789 CHAR, field_60_0 UINT64, field_61_01 DATE, field_62_012 DATETIME, field_63_0123 UINT16, field_64_01234 UINT32, field_65_012345 UINT32, field_66_0123456 INT16, field_67_01234567 UINT32, field_68_012345678 UINT8 ARRAY, field_69_0123456789 CHAR, field_70_0 INT32, field_71_01 REAL, field_72_012 UINT64, field_73_0123 REAL ARRAY, field_74_01234 INT64, field_75_012345 DATE, field_76_0123456 INT32)");
      /* 805 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 UINT16, field_3_0123 DATETIME, field_4_01234 DATETIME, field_5_012345 UINT64, field_6_0123456 DATETIME, field_7_01234567 HIRESTIME, field_8_012345678 BOOL, field_9_0123456789 INT16, field_10_0 UINT64, field_11_01 INT64, field_12_012 INT32, field_13_0123 DATE, field_14_01234 INT16, field_15_012345 INT64, field_16_0123456 UINT64, field_17_01234567 RICHREAL ARRAY, field_18_012345678 INT64, field_19_0123456789 CHAR, field_20_0 UINT8, field_21_01 DATE, field_22_012 REAL, field_23_0123 BOOL, field_24_01234 RICHREAL, field_25_012345 DATE, field_26_0123456 INT16 ARRAY, field_27_01234567 DATE, field_28_012345678 HIRESTIME, field_29_0123456789 INT64 ARRAY, field_30_0 HIRESTIME, field_31_01 UINT32, field_32_012 INT8, field_33_0123 CHAR, field_34_01234 UINT8 ARRAY, field_35_012345 INT64 ARRAY, field_36_0123456 DATETIME, field_37_01234567 INT16 ARRAY, field_38_012345678 HIRESTIME, field_39_0123456789 INT8 ARRAY, field_40_0 UINT8, field_41_01 INT16, field_42_012 INT8, field_43_0123 CHAR, field_44_01234 UINT64, field_45_012345 UINT8, field_46_0123456 INT64, field_47_01234567 UINT64, field_48_012345678 UINT64, field_49_0123456789 RICHREAL, field_50_0 INT8, field_51_01 INT16, field_52_012 UINT64, field_53_0123 UINT8, field_54_01234 UINT32, field_55_012345 UINT16, field_56_0123456 UINT8, field_57_01234567 DATE, field_58_012345678 REAL ARRAY, field_59_0123456789 INT64, field_60_0 HIRESTIME ARRAY, field_61_01 INT32, field_62_012 UINT64, field_63_0123 UINT32, field_64_01234 INT16)");
      /* 806 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 INT16, field_3_0123 REAL, field_4_01234 REAL ARRAY, field_5_012345 INT8, field_6_0123456 INT8 ARRAY, field_7_01234567 UINT32, field_8_012345678 UINT32, field_9_0123456789 INT16, field_10_0 INT64 ARRAY, field_11_01 INT32, field_12_012 UINT64 ARRAY, field_13_0123 DATETIME, field_14_01234 UINT32, field_15_012345 CHAR, field_16_0123456 BOOL, field_17_01234567 DATE, field_18_012345678 UINT64 ARRAY, field_19_0123456789 UINT16, field_20_0 INT8, field_21_01 INT32, field_22_012 INT8, field_23_0123 INT32, field_24_01234 BOOL, field_25_012345 BOOL, field_26_0123456 BOOL ARRAY, field_27_01234567 INT64, field_28_012345678 UINT8, field_29_0123456789 INT32, field_30_0 CHAR, field_31_01 BOOL, field_32_012 UINT16, field_33_0123 CHAR, field_34_01234 DATETIME, field_35_012345 DATETIME, field_36_0123456 INT16, field_37_01234567 UINT64, field_38_012345678 RICHREAL, field_39_0123456789 INT64, field_40_0 BOOL, field_41_01 DATETIME, field_42_012 INT64, field_43_0123 RICHREAL ARRAY, field_44_01234 INT16 ARRAY)");
      /* 807 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 UINT16, field_3_0123 UINT16, field_4_01234 DATE, field_5_012345 INT64, field_6_0123456 UINT16, field_7_01234567 HIRESTIME, field_8_012345678 UINT32, field_9_0123456789 CHAR, field_10_0 INT64, field_11_01 HIRESTIME ARRAY, field_12_012 UINT16, field_13_0123 UINT64, field_14_01234 INT8 ARRAY, field_15_012345 DATETIME ARRAY, field_16_0123456 RICHREAL, field_17_01234567 INT16, field_18_012345678 UINT8, field_19_0123456789 HIRESTIME, field_20_0 UINT8 ARRAY, field_21_01 UINT64, field_22_012 INT32, field_23_0123 UINT8, field_24_01234 INT32, field_25_012345 BOOL, field_26_0123456 UINT32, field_27_01234567 CHAR, field_28_012345678 DATETIME, field_29_0123456789 INT16, field_30_0 CHAR, field_31_01 RICHREAL, field_32_012 REAL, field_33_0123 UINT8 ARRAY, field_34_01234 INT16, field_35_012345 INT64, field_36_0123456 REAL, field_37_01234567 UINT32, field_38_012345678 INT64, field_39_0123456789 CHAR, field_40_0 REAL ARRAY, field_41_01 INT16, field_42_012 HIRESTIME, field_43_0123 INT32, field_44_01234 UINT16, field_45_012345 INT32, field_46_0123456 HIRESTIME ARRAY, field_47_01234567 UINT16, field_48_012345678 CHAR, field_49_0123456789 UINT64, field_50_0 UINT16, field_51_01 INT16, field_52_012 DATE, field_53_0123 CHAR ARRAY, field_54_01234 UINT64 ARRAY, field_55_012345 HIRESTIME, field_56_0123456 INT16, field_57_01234567 BOOL, field_58_012345678 RICHREAL, field_59_0123456789 CHAR, field_60_0 UINT16, field_61_01 INT32, field_62_012 DATETIME, field_63_0123 BOOL, field_64_01234 CHAR ARRAY, field_65_012345 CHAR, field_66_0123456 INT16, field_67_01234567 BOOL, field_68_012345678 DATE ARRAY, field_69_0123456789 RICHREAL, field_70_0 RICHREAL, field_71_01 DATE, field_72_012 INT16, field_73_0123 DATE, field_74_01234 UINT8, field_75_012345 INT8, field_76_0123456 UINT8, field_77_01234567 INT8, field_78_012345678 UINT64 ARRAY, field_79_0123456789 DATETIME, field_80_0 HIRESTIME, field_81_01 INT64, field_82_012 INT16, field_83_0123 UINT16, field_84_01234 INT64, field_85_012345 DATETIME, field_86_0123456 INT64, field_87_01234567 DATETIME ARRAY, field_88_012345678 HIRESTIME ARRAY, field_89_0123456789 INT32 ARRAY, field_90_0 INT32, field_91_01 DATETIME, field_92_012 UINT8 ARRAY, field_93_0123 INT64, field_94_01234 INT32, field_95_012345 BOOL, field_96_0123456 RICHREAL, field_97_01234567 UINT32, field_98_012345678 INT16 ARRAY, field_99_0123456789 INT16)");
      /* 808 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 RICHREAL, field_3_0123 DATETIME, field_4_01234 REAL, field_5_012345 INT16 ARRAY, field_6_0123456 BOOL, field_7_01234567 INT32, field_8_012345678 BOOL, field_9_0123456789 HIRESTIME ARRAY, field_10_0 HIRESTIME, field_11_01 CHAR, field_12_012 UINT32, field_13_0123 CHAR, field_14_01234 UINT32, field_15_012345 INT16, field_16_0123456 BOOL, field_17_01234567 CHAR, field_18_012345678 RICHREAL, field_19_0123456789 DATE, field_20_0 BOOL, field_21_01 DATE, field_22_012 UINT32, field_23_0123 HIRESTIME, field_24_01234 INT32, field_25_012345 INT8 ARRAY, field_26_0123456 DATE, field_27_01234567 INT16, field_28_012345678 DATE, field_29_0123456789 UINT8, field_30_0 CHAR ARRAY, field_31_01 UINT64, field_32_012 INT32 ARRAY, field_33_0123 INT64, field_34_01234 INT64 ARRAY, field_35_012345 REAL ARRAY, field_36_0123456 CHAR, field_37_01234567 INT64, field_38_012345678 INT16, field_39_0123456789 HIRESTIME ARRAY, field_40_0 INT16, field_41_01 RICHREAL ARRAY, field_42_012 INT64 ARRAY, field_43_0123 UINT64, field_44_01234 UINT8, field_45_012345 INT32, field_46_0123456 UINT64, field_47_01234567 INT32, field_48_012345678 UINT16, field_49_0123456789 RICHREAL, field_50_0 INT64, field_51_01 RICHREAL, field_52_012 HIRESTIME)");
      /* 809 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 INT16, field_3_0123 REAL, field_4_01234 INT64, field_5_012345 INT16, field_6_0123456 INT64 ARRAY, field_7_01234567 CHAR ARRAY, field_8_012345678 REAL ARRAY, field_9_0123456789 INT64, field_10_0 CHAR, field_11_01 INT8, field_12_012 UINT32, field_13_0123 BOOL)");
      /* 810 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 DATETIME, field_3_0123 INT32, field_4_01234 UINT64, field_5_012345 UINT32, field_6_0123456 DATE, field_7_01234567 BOOL, field_8_012345678 HIRESTIME ARRAY, field_9_0123456789 HIRESTIME, field_10_0 INT32, field_11_01 CHAR, field_12_012 INT16 ARRAY, field_13_0123 RICHREAL, field_14_01234 INT64, field_15_012345 INT8, field_16_0123456 HIRESTIME, field_17_01234567 INT64 ARRAY, field_18_012345678 INT8 ARRAY, field_19_0123456789 DATE, field_20_0 INT64, field_21_01 INT16, field_22_012 INT32, field_23_0123 HIRESTIME, field_24_01234 DATE ARRAY, field_25_012345 DATE ARRAY, field_26_0123456 UINT8, field_27_01234567 UINT8, field_28_012345678 UINT64 ARRAY, field_29_0123456789 BOOL ARRAY, field_30_0 DATETIME, field_31_01 BOOL, field_32_012 BOOL, field_33_0123 UINT16, field_34_01234 CHAR, field_35_012345 DATETIME, field_36_0123456 INT64 ARRAY)");
      /* 811 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 INT16, field_3_0123 UINT16, field_4_01234 CHAR, field_5_012345 UINT64, field_6_0123456 UINT32, field_7_01234567 CHAR, field_8_012345678 INT8, field_9_0123456789 UINT32 ARRAY, field_10_0 CHAR, field_11_01 DATE, field_12_012 INT64, field_13_0123 INT8, field_14_01234 INT64, field_15_012345 RICHREAL, field_16_0123456 INT32, field_17_01234567 INT16, field_18_012345678 HIRESTIME, field_19_0123456789 INT16, field_20_0 RICHREAL, field_21_01 CHAR ARRAY, field_22_012 UINT32, field_23_0123 DATETIME, field_24_01234 BOOL, field_25_012345 CHAR, field_26_0123456 BOOL, field_27_01234567 INT64, field_28_012345678 UINT8, field_29_0123456789 DATETIME, field_30_0 INT8, field_31_01 HIRESTIME, field_32_012 INT8, field_33_0123 INT32 ARRAY, field_34_01234 CHAR, field_35_012345 DATE, field_36_0123456 BOOL, field_37_01234567 DATE, field_38_012345678 UINT64, field_39_0123456789 UINT64, field_40_0 DATETIME ARRAY, field_41_01 DATETIME ARRAY, field_42_012 UINT16 ARRAY, field_43_0123 REAL ARRAY, field_44_01234 REAL, field_45_012345 UINT16, field_46_0123456 DATETIME, field_47_01234567 UINT64, field_48_012345678 UINT16, field_49_0123456789 INT16, field_50_0 CHAR, field_51_01 DATETIME, field_52_012 CHAR, field_53_0123 DATETIME, field_54_01234 BOOL ARRAY, field_55_012345 INT8, field_56_0123456 UINT64, field_57_01234567 DATE ARRAY, field_58_012345678 UINT64, field_59_0123456789 INT8, field_60_0 UINT16, field_61_01 DATETIME, field_62_012 HIRESTIME, field_63_0123 UINT64, field_64_01234 REAL, field_65_012345 REAL, field_66_0123456 UINT32, field_67_01234567 INT64, field_68_012345678 REAL, field_69_0123456789 RICHREAL ARRAY, field_70_0 UINT8, field_71_01 DATETIME ARRAY, field_72_012 DATE, field_73_0123 REAL, field_74_01234 INT32, field_75_012345 INT8, field_76_0123456 INT8, field_77_01234567 REAL, field_78_012345678 INT64 ARRAY, field_79_0123456789 HIRESTIME ARRAY, field_80_0 UINT64, field_81_01 UINT16, field_82_012 UINT8, field_83_0123 INT32, field_84_01234 UINT64, field_85_012345 INT16, field_86_0123456 REAL, field_87_01234567 BOOL ARRAY, field_88_012345678 INT8, field_89_0123456789 REAL, field_90_0 UINT8, field_91_01 INT32, field_92_012 CHAR, field_93_0123 BOOL, field_94_01234 INT64 ARRAY, field_95_012345 BOOL, field_96_0123456 REAL, field_97_01234567 DATETIME)");
      /* 812 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 DATETIME, field_3_0123 UINT8, field_4_01234 REAL ARRAY, field_5_012345 DATETIME, field_6_0123456 DATE, field_7_01234567 HIRESTIME ARRAY, field_8_012345678 DATE, field_9_0123456789 UINT16, field_10_0 UINT32, field_11_01 UINT32, field_12_012 UINT64, field_13_0123 INT64, field_14_01234 RICHREAL, field_15_012345 UINT32, field_16_0123456 UINT16, field_17_01234567 BOOL, field_18_012345678 BOOL, field_19_0123456789 INT8 ARRAY, field_20_0 DATETIME, field_21_01 UINT64, field_22_012 BOOL, field_23_0123 INT8, field_24_01234 INT64, field_25_012345 CHAR, field_26_0123456 UINT8, field_27_01234567 CHAR, field_28_012345678 BOOL, field_29_0123456789 DATE, field_30_0 UINT64, field_31_01 DATETIME ARRAY, field_32_012 INT16, field_33_0123 CHAR, field_34_01234 DATE, field_35_012345 UINT8, field_36_0123456 UINT64, field_37_01234567 INT32, field_38_012345678 UINT64, field_39_0123456789 BOOL, field_40_0 DATETIME, field_41_01 HIRESTIME, field_42_012 INT64)");
      /* 813 */ glbTypes.push_back("TABLE(field_1_01 INT64)");
      /* 814 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 BOOL, field_3_0123 DATE, field_4_01234 DATE, field_5_012345 CHAR ARRAY, field_6_0123456 INT16 ARRAY, field_7_01234567 REAL, field_8_012345678 UINT64, field_9_0123456789 UINT64, field_10_0 REAL ARRAY, field_11_01 BOOL, field_12_012 CHAR)");
      /* 815 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 DATETIME, field_3_0123 INT64, field_4_01234 INT16, field_5_012345 UINT32, field_6_0123456 DATETIME, field_7_01234567 INT8, field_8_012345678 UINT64, field_9_0123456789 UINT16, field_10_0 INT16 ARRAY, field_11_01 INT8, field_12_012 HIRESTIME, field_13_0123 RICHREAL, field_14_01234 INT32, field_15_012345 UINT64, field_16_0123456 INT64, field_17_01234567 UINT8, field_18_012345678 REAL, field_19_0123456789 INT8, field_20_0 INT16, field_21_01 DATETIME, field_22_012 UINT8, field_23_0123 DATETIME ARRAY, field_24_01234 CHAR)");
      /* 816 */ glbTypes.push_back("TABLE(field_1_01 UINT32 ARRAY, field_2_012 UINT32, field_3_0123 UINT16, field_4_01234 REAL ARRAY, field_5_012345 INT8, field_6_0123456 INT64, field_7_01234567 UINT8, field_8_012345678 REAL, field_9_0123456789 HIRESTIME, field_10_0 DATE, field_11_01 INT64, field_12_012 INT64, field_13_0123 INT8, field_14_01234 INT16, field_15_012345 UINT8, field_16_0123456 INT32, field_17_01234567 INT64 ARRAY, field_18_012345678 BOOL, field_19_0123456789 CHAR, field_20_0 UINT16, field_21_01 UINT16, field_22_012 HIRESTIME ARRAY, field_23_0123 INT16, field_24_01234 DATETIME, field_25_012345 DATETIME, field_26_0123456 DATETIME, field_27_01234567 INT8 ARRAY, field_28_012345678 DATE, field_29_0123456789 INT8, field_30_0 REAL, field_31_01 HIRESTIME, field_32_012 DATETIME, field_33_0123 INT32, field_34_01234 BOOL, field_35_012345 HIRESTIME, field_36_0123456 DATETIME, field_37_01234567 BOOL, field_38_012345678 UINT8, field_39_0123456789 DATETIME, field_40_0 UINT16, field_41_01 HIRESTIME, field_42_012 INT64 ARRAY, field_43_0123 UINT8, field_44_01234 REAL, field_45_012345 INT16 ARRAY, field_46_0123456 INT8 ARRAY, field_47_01234567 UINT16 ARRAY, field_48_012345678 UINT32 ARRAY, field_49_0123456789 DATETIME, field_50_0 UINT8 ARRAY, field_51_01 INT8, field_52_012 UINT64, field_53_0123 INT64, field_54_01234 HIRESTIME, field_55_012345 DATE ARRAY, field_56_0123456 INT8 ARRAY, field_57_01234567 INT64, field_58_012345678 UINT64, field_59_0123456789 INT64, field_60_0 UINT16, field_61_01 INT64, field_62_012 CHAR, field_63_0123 REAL ARRAY, field_64_01234 INT64, field_65_012345 CHAR, field_66_0123456 REAL ARRAY, field_67_01234567 INT64, field_68_012345678 UINT8 ARRAY, field_69_0123456789 UINT16, field_70_0 UINT64, field_71_01 UINT32 ARRAY, field_72_012 DATE, field_73_0123 UINT8, field_74_01234 INT8, field_75_012345 INT16, field_76_0123456 DATETIME ARRAY, field_77_01234567 INT32 ARRAY, field_78_012345678 INT8, field_79_0123456789 REAL, field_80_0 HIRESTIME, field_81_01 CHAR, field_82_012 UINT64, field_83_0123 INT32 ARRAY)");
      /* 817 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 CHAR, field_3_0123 HIRESTIME, field_4_01234 BOOL, field_5_012345 BOOL, field_6_0123456 UINT32, field_7_01234567 INT8, field_8_012345678 DATETIME, field_9_0123456789 DATETIME)");
      /* 818 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 DATETIME, field_3_0123 INT32, field_4_01234 UINT64, field_5_012345 DATE, field_6_0123456 REAL ARRAY, field_7_01234567 DATETIME, field_8_012345678 DATE, field_9_0123456789 CHAR, field_10_0 INT64, field_11_01 DATE ARRAY)");
      /* 819 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 BOOL, field_3_0123 RICHREAL, field_4_01234 RICHREAL, field_5_012345 INT64, field_6_0123456 HIRESTIME ARRAY, field_7_01234567 INT32, field_8_012345678 INT32, field_9_0123456789 CHAR ARRAY, field_10_0 REAL, field_11_01 INT64, field_12_012 INT8, field_13_0123 UINT32, field_14_01234 HIRESTIME, field_15_012345 BOOL, field_16_0123456 HIRESTIME, field_17_01234567 DATETIME, field_18_012345678 INT8, field_19_0123456789 INT32 ARRAY, field_20_0 HIRESTIME, field_21_01 HIRESTIME ARRAY, field_22_012 UINT8, field_23_0123 INT32, field_24_01234 REAL ARRAY, field_25_012345 INT8, field_26_0123456 INT64 ARRAY, field_27_01234567 BOOL ARRAY, field_28_012345678 RICHREAL, field_29_0123456789 UINT8, field_30_0 DATETIME, field_31_01 INT64, field_32_012 INT32, field_33_0123 INT32, field_34_01234 DATE, field_35_012345 UINT16, field_36_0123456 UINT16, field_37_01234567 UINT16, field_38_012345678 INT16, field_39_0123456789 BOOL, field_40_0 CHAR ARRAY, field_41_01 INT8, field_42_012 INT64, field_43_0123 DATE, field_44_01234 UINT16, field_45_012345 INT16, field_46_0123456 REAL, field_47_01234567 BOOL, field_48_012345678 REAL, field_49_0123456789 UINT64, field_50_0 UINT32, field_51_01 INT32, field_52_012 DATETIME, field_53_0123 BOOL, field_54_01234 REAL, field_55_012345 INT16)");
      /* 820 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 INT32, field_3_0123 RICHREAL, field_4_01234 REAL, field_5_012345 CHAR, field_6_0123456 CHAR ARRAY, field_7_01234567 UINT8, field_8_012345678 HIRESTIME, field_9_0123456789 UINT16, field_10_0 INT16, field_11_01 DATETIME, field_12_012 INT8, field_13_0123 INT32, field_14_01234 CHAR ARRAY, field_15_012345 INT16, field_16_0123456 INT16, field_17_01234567 BOOL, field_18_012345678 RICHREAL, field_19_0123456789 INT8, field_20_0 INT16, field_21_01 UINT32 ARRAY, field_22_012 UINT8, field_23_0123 UINT8, field_24_01234 INT16, field_25_012345 INT64, field_26_0123456 HIRESTIME ARRAY, field_27_01234567 UINT16, field_28_012345678 BOOL, field_29_0123456789 HIRESTIME, field_30_0 UINT16, field_31_01 INT64, field_32_012 REAL, field_33_0123 CHAR, field_34_01234 INT32, field_35_012345 INT8, field_36_0123456 UINT64, field_37_01234567 INT32, field_38_012345678 BOOL, field_39_0123456789 HIRESTIME, field_40_0 HIRESTIME, field_41_01 RICHREAL ARRAY, field_42_012 INT8, field_43_0123 INT8 ARRAY, field_44_01234 BOOL ARRAY, field_45_012345 DATE ARRAY, field_46_0123456 INT64, field_47_01234567 CHAR, field_48_012345678 INT16, field_49_0123456789 INT16, field_50_0 REAL ARRAY, field_51_01 BOOL, field_52_012 DATE, field_53_0123 INT64, field_54_01234 DATETIME, field_55_012345 CHAR, field_56_0123456 HIRESTIME, field_57_01234567 HIRESTIME, field_58_012345678 UINT64, field_59_0123456789 CHAR, field_60_0 UINT64, field_61_01 UINT64, field_62_012 INT8, field_63_0123 BOOL ARRAY, field_64_01234 REAL, field_65_012345 DATE ARRAY, field_66_0123456 UINT32, field_67_01234567 CHAR, field_68_012345678 DATETIME)");
      /* 821 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 UINT16, field_3_0123 DATE, field_4_01234 CHAR, field_5_012345 DATE, field_6_0123456 UINT8, field_7_01234567 BOOL, field_8_012345678 RICHREAL ARRAY, field_9_0123456789 REAL, field_10_0 INT32, field_11_01 INT16, field_12_012 INT16, field_13_0123 INT16, field_14_01234 BOOL ARRAY, field_15_012345 DATE ARRAY, field_16_0123456 CHAR, field_17_01234567 DATE, field_18_012345678 UINT64, field_19_0123456789 INT8 ARRAY, field_20_0 UINT64 ARRAY, field_21_01 INT8, field_22_012 UINT16, field_23_0123 UINT32, field_24_01234 INT8, field_25_012345 RICHREAL ARRAY, field_26_0123456 INT16, field_27_01234567 DATE ARRAY, field_28_012345678 INT32, field_29_0123456789 DATE ARRAY, field_30_0 INT16, field_31_01 INT8, field_32_012 BOOL, field_33_0123 DATETIME ARRAY, field_34_01234 DATETIME, field_35_012345 INT32, field_36_0123456 DATETIME ARRAY, field_37_01234567 INT64, field_38_012345678 INT64 ARRAY, field_39_0123456789 DATE ARRAY, field_40_0 CHAR ARRAY, field_41_01 UINT64 ARRAY, field_42_012 UINT16, field_43_0123 INT8, field_44_01234 RICHREAL, field_45_012345 HIRESTIME, field_46_0123456 UINT32, field_47_01234567 CHAR ARRAY, field_48_012345678 BOOL, field_49_0123456789 INT8, field_50_0 UINT32, field_51_01 UINT32, field_52_012 UINT8 ARRAY, field_53_0123 DATETIME, field_54_01234 UINT64, field_55_012345 UINT64, field_56_0123456 DATE)");
      /* 822 */ glbTypes.push_back("TABLE(field_1_01 CHAR ARRAY, field_2_012 INT32, field_3_0123 UINT16, field_4_01234 INT64, field_5_012345 INT16, field_6_0123456 CHAR, field_7_01234567 DATE ARRAY, field_8_012345678 DATE ARRAY, field_9_0123456789 INT64, field_10_0 DATE, field_11_01 DATETIME, field_12_012 REAL ARRAY, field_13_0123 HIRESTIME, field_14_01234 DATE, field_15_012345 BOOL, field_16_0123456 UINT32, field_17_01234567 RICHREAL ARRAY, field_18_012345678 REAL, field_19_0123456789 DATETIME, field_20_0 INT16 ARRAY, field_21_01 BOOL, field_22_012 HIRESTIME, field_23_0123 DATETIME, field_24_01234 REAL, field_25_012345 INT32 ARRAY, field_26_0123456 BOOL, field_27_01234567 HIRESTIME, field_28_012345678 UINT16 ARRAY, field_29_0123456789 INT64, field_30_0 INT16, field_31_01 REAL, field_32_012 UINT16, field_33_0123 UINT64, field_34_01234 REAL, field_35_012345 CHAR ARRAY, field_36_0123456 CHAR, field_37_01234567 BOOL, field_38_012345678 BOOL, field_39_0123456789 DATETIME ARRAY, field_40_0 DATE, field_41_01 RICHREAL, field_42_012 INT8, field_43_0123 UINT8, field_44_01234 HIRESTIME ARRAY, field_45_012345 UINT16, field_46_0123456 DATE ARRAY, field_47_01234567 INT64, field_48_012345678 INT16, field_49_0123456789 DATE, field_50_0 UINT8, field_51_01 BOOL, field_52_012 REAL, field_53_0123 CHAR, field_54_01234 RICHREAL, field_55_012345 RICHREAL, field_56_0123456 DATETIME, field_57_01234567 INT8, field_58_012345678 INT64, field_59_0123456789 RICHREAL, field_60_0 INT64, field_61_01 INT16, field_62_012 UINT32, field_63_0123 UINT8, field_64_01234 BOOL, field_65_012345 DATE, field_66_0123456 REAL, field_67_01234567 RICHREAL, field_68_012345678 INT8, field_69_0123456789 RICHREAL, field_70_0 UINT64, field_71_01 HIRESTIME, field_72_012 UINT32, field_73_0123 DATE, field_74_01234 INT8 ARRAY, field_75_012345 INT64, field_76_0123456 DATE, field_77_01234567 CHAR, field_78_012345678 INT32, field_79_0123456789 CHAR, field_80_0 UINT8 ARRAY, field_81_01 BOOL, field_82_012 RICHREAL, field_83_0123 DATETIME, field_84_01234 UINT8, field_85_012345 REAL, field_86_0123456 INT64)");
      /* 823 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 INT16, field_3_0123 REAL, field_4_01234 CHAR, field_5_012345 BOOL, field_6_0123456 UINT8, field_7_01234567 INT64 ARRAY, field_8_012345678 INT16, field_9_0123456789 UINT16 ARRAY, field_10_0 DATE, field_11_01 BOOL, field_12_012 UINT8, field_13_0123 DATE)");
      /* 824 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 UINT32, field_3_0123 INT64, field_4_01234 DATETIME, field_5_012345 INT64 ARRAY, field_6_0123456 RICHREAL, field_7_01234567 UINT8, field_8_012345678 DATE, field_9_0123456789 INT32, field_10_0 RICHREAL, field_11_01 INT16, field_12_012 BOOL, field_13_0123 INT16, field_14_01234 UINT64 ARRAY)");
      /* 825 */ glbTypes.push_back("TABLE(field_1_01 INT16 ARRAY, field_2_012 CHAR, field_3_0123 CHAR, field_4_01234 INT8 ARRAY, field_5_012345 CHAR ARRAY, field_6_0123456 UINT32, field_7_01234567 UINT64, field_8_012345678 INT8 ARRAY, field_9_0123456789 UINT64 ARRAY, field_10_0 RICHREAL, field_11_01 UINT32 ARRAY, field_12_012 BOOL, field_13_0123 UINT32, field_14_01234 REAL, field_15_012345 UINT64, field_16_0123456 DATE, field_17_01234567 UINT64, field_18_012345678 INT32 ARRAY, field_19_0123456789 INT16 ARRAY, field_20_0 REAL, field_21_01 BOOL ARRAY, field_22_012 UINT16 ARRAY, field_23_0123 UINT64, field_24_01234 UINT8 ARRAY)");
      /* 826 */ glbTypes.push_back("TABLE(field_1_01 UINT32 ARRAY, field_2_012 INT64, field_3_0123 INT8, field_4_01234 UINT32, field_5_012345 UINT64, field_6_0123456 DATETIME ARRAY, field_7_01234567 INT16, field_8_012345678 INT64 ARRAY, field_9_0123456789 CHAR ARRAY, field_10_0 UINT32, field_11_01 DATE, field_12_012 BOOL, field_13_0123 BOOL ARRAY, field_14_01234 INT64, field_15_012345 INT64, field_16_0123456 CHAR, field_17_01234567 BOOL ARRAY, field_18_012345678 CHAR, field_19_0123456789 INT8, field_20_0 DATE, field_21_01 UINT8, field_22_012 DATETIME, field_23_0123 INT8, field_24_01234 REAL, field_25_012345 HIRESTIME, field_26_0123456 UINT8, field_27_01234567 RICHREAL ARRAY, field_28_012345678 DATETIME, field_29_0123456789 INT8, field_30_0 UINT64, field_31_01 REAL, field_32_012 INT64, field_33_0123 UINT8, field_34_01234 INT16, field_35_012345 INT32, field_36_0123456 INT8, field_37_01234567 UINT16, field_38_012345678 UINT32, field_39_0123456789 CHAR ARRAY, field_40_0 UINT64, field_41_01 UINT64 ARRAY, field_42_012 UINT16, field_43_0123 UINT64 ARRAY, field_44_01234 CHAR, field_45_012345 UINT32 ARRAY, field_46_0123456 INT8, field_47_01234567 CHAR ARRAY, field_48_012345678 UINT64, field_49_0123456789 HIRESTIME, field_50_0 DATE, field_51_01 INT16, field_52_012 CHAR, field_53_0123 BOOL, field_54_01234 HIRESTIME, field_55_012345 UINT32, field_56_0123456 UINT8, field_57_01234567 INT32, field_58_012345678 UINT16, field_59_0123456789 DATETIME, field_60_0 UINT8 ARRAY, field_61_01 BOOL, field_62_012 INT8, field_63_0123 REAL, field_64_01234 INT16)");
      /* 827 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 UINT16, field_3_0123 DATETIME ARRAY, field_4_01234 RICHREAL ARRAY, field_5_012345 INT64, field_6_0123456 UINT32 ARRAY, field_7_01234567 INT8 ARRAY, field_8_012345678 INT32, field_9_0123456789 INT16, field_10_0 UINT16 ARRAY, field_11_01 INT8, field_12_012 REAL, field_13_0123 UINT8 ARRAY, field_14_01234 INT64, field_15_012345 UINT16, field_16_0123456 DATE, field_17_01234567 REAL, field_18_012345678 INT16 ARRAY, field_19_0123456789 DATE, field_20_0 DATE, field_21_01 UINT64 ARRAY, field_22_012 UINT64 ARRAY, field_23_0123 UINT32 ARRAY, field_24_01234 CHAR, field_25_012345 INT16, field_26_0123456 UINT64, field_27_01234567 INT16, field_28_012345678 INT16, field_29_0123456789 INT32, field_30_0 DATETIME, field_31_01 UINT8, field_32_012 DATE, field_33_0123 INT64, field_34_01234 CHAR, field_35_012345 INT16 ARRAY, field_36_0123456 INT8 ARRAY, field_37_01234567 INT8 ARRAY, field_38_012345678 REAL, field_39_0123456789 BOOL, field_40_0 UINT64, field_41_01 DATETIME, field_42_012 INT16, field_43_0123 BOOL, field_44_01234 INT16, field_45_012345 UINT8, field_46_0123456 HIRESTIME ARRAY, field_47_01234567 INT64, field_48_012345678 REAL, field_49_0123456789 INT64, field_50_0 REAL, field_51_01 UINT8, field_52_012 HIRESTIME ARRAY, field_53_0123 BOOL ARRAY, field_54_01234 INT16, field_55_012345 UINT8 ARRAY, field_56_0123456 UINT64, field_57_01234567 DATETIME, field_58_012345678 UINT8, field_59_0123456789 INT64, field_60_0 HIRESTIME ARRAY, field_61_01 HIRESTIME ARRAY, field_62_012 CHAR, field_63_0123 DATETIME, field_64_01234 REAL, field_65_012345 CHAR, field_66_0123456 INT64, field_67_01234567 INT8, field_68_012345678 DATETIME, field_69_0123456789 DATETIME)");
      /* 828 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 INT16, field_3_0123 UINT8, field_4_01234 REAL, field_5_012345 REAL, field_6_0123456 RICHREAL ARRAY, field_7_01234567 CHAR, field_8_012345678 UINT16, field_9_0123456789 INT8, field_10_0 DATE, field_11_01 UINT64, field_12_012 REAL, field_13_0123 INT64, field_14_01234 INT16, field_15_012345 CHAR, field_16_0123456 HIRESTIME, field_17_01234567 CHAR ARRAY, field_18_012345678 UINT32, field_19_0123456789 DATETIME ARRAY, field_20_0 INT32, field_21_01 INT32, field_22_012 HIRESTIME, field_23_0123 DATE, field_24_01234 INT16 ARRAY, field_25_012345 INT16, field_26_0123456 INT16, field_27_01234567 DATE, field_28_012345678 UINT8, field_29_0123456789 DATE, field_30_0 HIRESTIME, field_31_01 INT8, field_32_012 CHAR, field_33_0123 INT32 ARRAY, field_34_01234 DATE, field_35_012345 CHAR, field_36_0123456 DATE, field_37_01234567 HIRESTIME, field_38_012345678 INT16, field_39_0123456789 UINT32 ARRAY, field_40_0 INT8 ARRAY, field_41_01 DATE, field_42_012 UINT64, field_43_0123 HIRESTIME, field_44_01234 UINT8, field_45_012345 CHAR, field_46_0123456 UINT16, field_47_01234567 DATE, field_48_012345678 DATETIME, field_49_0123456789 DATETIME, field_50_0 UINT8, field_51_01 INT8, field_52_012 UINT32 ARRAY, field_53_0123 UINT8, field_54_01234 RICHREAL, field_55_012345 BOOL, field_56_0123456 BOOL ARRAY, field_57_01234567 BOOL, field_58_012345678 UINT32, field_59_0123456789 INT16, field_60_0 BOOL, field_61_01 UINT32, field_62_012 CHAR, field_63_0123 INT32, field_64_01234 HIRESTIME ARRAY, field_65_012345 INT16, field_66_0123456 DATETIME, field_67_01234567 HIRESTIME, field_68_012345678 DATETIME, field_69_0123456789 BOOL, field_70_0 UINT32, field_71_01 UINT8, field_72_012 INT32, field_73_0123 INT8, field_74_01234 REAL, field_75_012345 UINT64, field_76_0123456 RICHREAL, field_77_01234567 DATE, field_78_012345678 INT64, field_79_0123456789 DATETIME, field_80_0 CHAR, field_81_01 INT64 ARRAY, field_82_012 UINT16, field_83_0123 UINT32, field_84_01234 CHAR, field_85_012345 DATETIME, field_86_0123456 UINT32 ARRAY, field_87_01234567 BOOL, field_88_012345678 INT64, field_89_0123456789 REAL, field_90_0 INT32)");
      /* 829 */ glbTypes.push_back("TABLE(field_1_01 UINT32 ARRAY, field_2_012 UINT8, field_3_0123 RICHREAL, field_4_01234 UINT64, field_5_012345 DATE, field_6_0123456 UINT32, field_7_01234567 UINT64 ARRAY, field_8_012345678 INT8, field_9_0123456789 INT8 ARRAY, field_10_0 BOOL, field_11_01 REAL, field_12_012 INT32, field_13_0123 UINT32, field_14_01234 DATETIME, field_15_012345 DATE, field_16_0123456 DATETIME, field_17_01234567 RICHREAL ARRAY, field_18_012345678 BOOL ARRAY, field_19_0123456789 REAL)");
      /* 830 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 REAL, field_3_0123 BOOL, field_4_01234 DATETIME, field_5_012345 INT8 ARRAY, field_6_0123456 INT32 ARRAY, field_7_01234567 BOOL, field_8_012345678 UINT32, field_9_0123456789 UINT32, field_10_0 INT8, field_11_01 HIRESTIME)");
      /* 831 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 INT16, field_3_0123 UINT8, field_4_01234 HIRESTIME, field_5_012345 UINT32, field_6_0123456 REAL ARRAY, field_7_01234567 DATE, field_8_012345678 RICHREAL, field_9_0123456789 INT32, field_10_0 UINT32, field_11_01 INT16, field_12_012 RICHREAL, field_13_0123 UINT8, field_14_01234 INT64 ARRAY, field_15_012345 DATE, field_16_0123456 DATE ARRAY, field_17_01234567 BOOL ARRAY, field_18_012345678 RICHREAL, field_19_0123456789 INT8 ARRAY, field_20_0 UINT8, field_21_01 INT64, field_22_012 REAL ARRAY, field_23_0123 UINT8, field_24_01234 DATE, field_25_012345 UINT16, field_26_0123456 INT64 ARRAY, field_27_01234567 INT16, field_28_012345678 UINT32, field_29_0123456789 INT64, field_30_0 RICHREAL, field_31_01 INT64, field_32_012 INT16 ARRAY, field_33_0123 INT32 ARRAY, field_34_01234 HIRESTIME, field_35_012345 UINT16, field_36_0123456 UINT64, field_37_01234567 BOOL, field_38_012345678 DATE, field_39_0123456789 BOOL, field_40_0 INT16 ARRAY, field_41_01 INT64, field_42_012 UINT16, field_43_0123 REAL, field_44_01234 CHAR ARRAY, field_45_012345 UINT32 ARRAY, field_46_0123456 UINT64, field_47_01234567 DATE, field_48_012345678 INT8, field_49_0123456789 INT16, field_50_0 UINT64, field_51_01 INT32 ARRAY, field_52_012 UINT16, field_53_0123 REAL, field_54_01234 UINT32, field_55_012345 CHAR, field_56_0123456 INT32, field_57_01234567 REAL, field_58_012345678 HIRESTIME, field_59_0123456789 INT16, field_60_0 REAL ARRAY, field_61_01 INT16, field_62_012 CHAR ARRAY, field_63_0123 UINT8, field_64_01234 INT64, field_65_012345 HIRESTIME, field_66_0123456 UINT8, field_67_01234567 UINT64, field_68_012345678 INT8)");
      /* 832 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 RICHREAL, field_3_0123 DATE ARRAY, field_4_01234 UINT8, field_5_012345 REAL, field_6_0123456 HIRESTIME, field_7_01234567 UINT8, field_8_012345678 BOOL, field_9_0123456789 CHAR, field_10_0 UINT64, field_11_01 REAL, field_12_012 INT32, field_13_0123 DATE, field_14_01234 RICHREAL, field_15_012345 BOOL, field_16_0123456 DATETIME, field_17_01234567 BOOL ARRAY, field_18_012345678 UINT8, field_19_0123456789 INT64, field_20_0 UINT64, field_21_01 DATETIME, field_22_012 HIRESTIME, field_23_0123 DATE, field_24_01234 CHAR ARRAY, field_25_012345 INT16, field_26_0123456 INT8, field_27_01234567 UINT32, field_28_012345678 INT8, field_29_0123456789 UINT64 ARRAY, field_30_0 DATETIME, field_31_01 UINT32)");
      /* 833 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 INT64, field_3_0123 INT64, field_4_01234 RICHREAL, field_5_012345 INT64, field_6_0123456 INT8 ARRAY, field_7_01234567 HIRESTIME, field_8_012345678 UINT8, field_9_0123456789 INT16, field_10_0 INT16 ARRAY, field_11_01 BOOL, field_12_012 CHAR ARRAY, field_13_0123 DATE, field_14_01234 CHAR ARRAY, field_15_012345 INT16, field_16_0123456 INT8, field_17_01234567 DATETIME ARRAY, field_18_012345678 HIRESTIME, field_19_0123456789 BOOL ARRAY, field_20_0 INT32, field_21_01 UINT32)");
      /* 834 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 UINT8)");
      /* 835 */ glbTypes.push_back("TABLE(field_1_01 CHAR ARRAY, field_2_012 INT16, field_3_0123 CHAR, field_4_01234 INT8, field_5_012345 HIRESTIME, field_6_0123456 RICHREAL, field_7_01234567 INT8, field_8_012345678 HIRESTIME, field_9_0123456789 BOOL, field_10_0 BOOL, field_11_01 INT64, field_12_012 INT32, field_13_0123 INT8, field_14_01234 CHAR ARRAY, field_15_012345 DATE, field_16_0123456 HIRESTIME)");
      /* 836 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 INT8, field_3_0123 DATETIME, field_4_01234 INT8, field_5_012345 REAL, field_6_0123456 HIRESTIME, field_7_01234567 DATE, field_8_012345678 UINT64 ARRAY, field_9_0123456789 UINT8, field_10_0 HIRESTIME ARRAY, field_11_01 BOOL, field_12_012 RICHREAL, field_13_0123 INT16)");
      /* 837 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 REAL, field_3_0123 INT8, field_4_01234 DATETIME, field_5_012345 HIRESTIME, field_6_0123456 UINT8, field_7_01234567 HIRESTIME, field_8_012345678 DATETIME, field_9_0123456789 DATETIME, field_10_0 INT64 ARRAY, field_11_01 INT64, field_12_012 HIRESTIME, field_13_0123 DATETIME, field_14_01234 INT8 ARRAY, field_15_012345 UINT64, field_16_0123456 UINT16, field_17_01234567 UINT8, field_18_012345678 UINT32 ARRAY, field_19_0123456789 UINT32, field_20_0 BOOL, field_21_01 INT64 ARRAY, field_22_012 INT16, field_23_0123 UINT64, field_24_01234 UINT16, field_25_012345 INT64, field_26_0123456 DATE, field_27_01234567 RICHREAL ARRAY, field_28_012345678 DATE, field_29_0123456789 UINT32, field_30_0 HIRESTIME, field_31_01 HIRESTIME ARRAY, field_32_012 DATETIME, field_33_0123 INT64 ARRAY, field_34_01234 HIRESTIME, field_35_012345 UINT8 ARRAY, field_36_0123456 REAL, field_37_01234567 INT32, field_38_012345678 UINT16, field_39_0123456789 UINT16, field_40_0 REAL, field_41_01 RICHREAL, field_42_012 UINT32, field_43_0123 INT16, field_44_01234 RICHREAL, field_45_012345 INT64 ARRAY, field_46_0123456 DATETIME, field_47_01234567 HIRESTIME, field_48_012345678 DATE, field_49_0123456789 INT32, field_50_0 UINT8, field_51_01 INT64 ARRAY, field_52_012 HIRESTIME, field_53_0123 DATETIME, field_54_01234 INT8)");
      /* 838 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 REAL ARRAY, field_3_0123 INT64, field_4_01234 DATETIME, field_5_012345 UINT8, field_6_0123456 UINT64 ARRAY, field_7_01234567 INT16, field_8_012345678 DATETIME, field_9_0123456789 UINT16, field_10_0 INT64, field_11_01 INT32, field_12_012 UINT8, field_13_0123 INT64, field_14_01234 RICHREAL, field_15_012345 UINT32, field_16_0123456 RICHREAL, field_17_01234567 DATE, field_18_012345678 HIRESTIME, field_19_0123456789 CHAR, field_20_0 RICHREAL, field_21_01 RICHREAL ARRAY, field_22_012 UINT16, field_23_0123 REAL, field_24_01234 INT64, field_25_012345 REAL, field_26_0123456 CHAR ARRAY, field_27_01234567 REAL, field_28_012345678 DATE, field_29_0123456789 DATE, field_30_0 HIRESTIME, field_31_01 BOOL)");
      /* 839 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 CHAR ARRAY, field_3_0123 CHAR, field_4_01234 DATE, field_5_012345 REAL ARRAY, field_6_0123456 UINT16, field_7_01234567 INT64, field_8_012345678 DATE, field_9_0123456789 INT32)");
      /* 840 */ glbTypes.push_back("TABLE(field_1_01 UINT16 ARRAY, field_2_012 INT16, field_3_0123 UINT32, field_4_01234 DATETIME ARRAY, field_5_012345 INT8 ARRAY, field_6_0123456 DATETIME, field_7_01234567 INT64, field_8_012345678 INT32, field_9_0123456789 REAL, field_10_0 CHAR, field_11_01 DATE, field_12_012 UINT32 ARRAY, field_13_0123 HIRESTIME ARRAY, field_14_01234 DATE, field_15_012345 UINT16 ARRAY, field_16_0123456 RICHREAL ARRAY, field_17_01234567 BOOL, field_18_012345678 UINT64 ARRAY, field_19_0123456789 INT32 ARRAY, field_20_0 INT16, field_21_01 DATETIME, field_22_012 INT32, field_23_0123 DATETIME ARRAY, field_24_01234 INT16, field_25_012345 BOOL, field_26_0123456 REAL, field_27_01234567 BOOL, field_28_012345678 UINT8 ARRAY, field_29_0123456789 DATE, field_30_0 UINT32 ARRAY, field_31_01 UINT64, field_32_012 INT64, field_33_0123 DATE ARRAY, field_34_01234 INT64 ARRAY, field_35_012345 INT32, field_36_0123456 RICHREAL, field_37_01234567 INT32 ARRAY, field_38_012345678 REAL, field_39_0123456789 RICHREAL, field_40_0 UINT32 ARRAY, field_41_01 INT16, field_42_012 UINT32, field_43_0123 BOOL, field_44_01234 UINT8, field_45_012345 CHAR, field_46_0123456 RICHREAL, field_47_01234567 DATE, field_48_012345678 UINT32, field_49_0123456789 REAL, field_50_0 DATE ARRAY, field_51_01 DATETIME ARRAY, field_52_012 DATETIME ARRAY)");
      /* 841 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 INT64 ARRAY, field_3_0123 INT16, field_4_01234 INT64, field_5_012345 DATETIME, field_6_0123456 INT16 ARRAY, field_7_01234567 CHAR ARRAY, field_8_012345678 INT16 ARRAY, field_9_0123456789 RICHREAL, field_10_0 UINT64, field_11_01 UINT8 ARRAY, field_12_012 BOOL, field_13_0123 UINT64, field_14_01234 DATE, field_15_012345 REAL ARRAY, field_16_0123456 DATE ARRAY, field_17_01234567 DATETIME, field_18_012345678 UINT8, field_19_0123456789 CHAR, field_20_0 INT64, field_21_01 UINT16 ARRAY, field_22_012 UINT8, field_23_0123 RICHREAL ARRAY, field_24_01234 DATETIME, field_25_012345 RICHREAL, field_26_0123456 INT32, field_27_01234567 INT64, field_28_012345678 REAL ARRAY, field_29_0123456789 INT16 ARRAY, field_30_0 INT64, field_31_01 UINT16, field_32_012 INT32, field_33_0123 UINT32 ARRAY, field_34_01234 HIRESTIME, field_35_012345 RICHREAL, field_36_0123456 INT64, field_37_01234567 HIRESTIME, field_38_012345678 UINT32 ARRAY, field_39_0123456789 INT32, field_40_0 UINT16 ARRAY, field_41_01 INT64, field_42_012 RICHREAL, field_43_0123 DATE ARRAY, field_44_01234 REAL, field_45_012345 DATE, field_46_0123456 CHAR, field_47_01234567 INT32, field_48_012345678 CHAR, field_49_0123456789 INT64, field_50_0 UINT16, field_51_01 INT16, field_52_012 DATETIME ARRAY, field_53_0123 UINT32, field_54_01234 INT16, field_55_012345 UINT16, field_56_0123456 RICHREAL ARRAY, field_57_01234567 INT64, field_58_012345678 HIRESTIME, field_59_0123456789 CHAR, field_60_0 BOOL, field_61_01 UINT64, field_62_012 HIRESTIME, field_63_0123 REAL ARRAY, field_64_01234 UINT64, field_65_012345 INT8, field_66_0123456 UINT16, field_67_01234567 DATETIME, field_68_012345678 UINT16, field_69_0123456789 INT16, field_70_0 UINT16, field_71_01 INT8 ARRAY, field_72_012 REAL, field_73_0123 REAL, field_74_01234 INT8)");
      /* 842 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 DATETIME, field_3_0123 INT8 ARRAY, field_4_01234 INT16 ARRAY, field_5_012345 UINT16, field_6_0123456 INT16 ARRAY, field_7_01234567 BOOL, field_8_012345678 DATE, field_9_0123456789 INT16 ARRAY, field_10_0 UINT8, field_11_01 UINT64 ARRAY, field_12_012 UINT32, field_13_0123 INT32, field_14_01234 HIRESTIME, field_15_012345 INT16 ARRAY, field_16_0123456 BOOL, field_17_01234567 INT8, field_18_012345678 UINT64, field_19_0123456789 HIRESTIME, field_20_0 INT32, field_21_01 HIRESTIME, field_22_012 UINT8, field_23_0123 UINT64 ARRAY, field_24_01234 DATETIME, field_25_012345 INT64, field_26_0123456 CHAR, field_27_01234567 REAL, field_28_012345678 INT32, field_29_0123456789 INT32, field_30_0 INT64, field_31_01 UINT16, field_32_012 RICHREAL, field_33_0123 INT32, field_34_01234 CHAR ARRAY, field_35_012345 INT64, field_36_0123456 DATE ARRAY, field_37_01234567 INT8, field_38_012345678 INT32, field_39_0123456789 BOOL ARRAY, field_40_0 INT16, field_41_01 UINT8 ARRAY, field_42_012 UINT16 ARRAY, field_43_0123 UINT16, field_44_01234 INT16, field_45_012345 INT16, field_46_0123456 INT32, field_47_01234567 DATETIME, field_48_012345678 INT16, field_49_0123456789 UINT64, field_50_0 RICHREAL ARRAY, field_51_01 INT8, field_52_012 UINT8, field_53_0123 INT8, field_54_01234 INT32 ARRAY, field_55_012345 RICHREAL ARRAY, field_56_0123456 DATETIME, field_57_01234567 DATETIME, field_58_012345678 INT64, field_59_0123456789 RICHREAL, field_60_0 INT32, field_61_01 UINT8, field_62_012 DATETIME ARRAY)");
      /* 843 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 DATETIME, field_3_0123 DATETIME ARRAY, field_4_01234 INT32 ARRAY, field_5_012345 INT64, field_6_0123456 BOOL ARRAY, field_7_01234567 CHAR, field_8_012345678 UINT16, field_9_0123456789 UINT64, field_10_0 UINT16, field_11_01 RICHREAL, field_12_012 UINT16 ARRAY, field_13_0123 INT16, field_14_01234 INT32, field_15_012345 RICHREAL, field_16_0123456 RICHREAL, field_17_01234567 UINT64, field_18_012345678 INT16)");
      /* 844 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 UINT64, field_3_0123 INT64, field_4_01234 UINT64 ARRAY, field_5_012345 RICHREAL, field_6_0123456 INT8, field_7_01234567 INT32, field_8_012345678 CHAR, field_9_0123456789 DATE, field_10_0 UINT8, field_11_01 INT8, field_12_012 UINT16, field_13_0123 DATE ARRAY, field_14_01234 UINT8 ARRAY, field_15_012345 UINT32 ARRAY, field_16_0123456 RICHREAL, field_17_01234567 UINT8, field_18_012345678 INT32, field_19_0123456789 DATE, field_20_0 DATETIME ARRAY, field_21_01 CHAR, field_22_012 UINT32, field_23_0123 INT8, field_24_01234 HIRESTIME, field_25_012345 INT64, field_26_0123456 DATETIME, field_27_01234567 INT8)");
      /* 845 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 UINT16, field_3_0123 INT16, field_4_01234 BOOL, field_5_012345 DATE, field_6_0123456 BOOL, field_7_01234567 RICHREAL ARRAY, field_8_012345678 INT8, field_9_0123456789 DATETIME, field_10_0 INT8, field_11_01 INT8, field_12_012 BOOL ARRAY, field_13_0123 INT32 ARRAY, field_14_01234 UINT16, field_15_012345 HIRESTIME ARRAY, field_16_0123456 HIRESTIME ARRAY, field_17_01234567 UINT64, field_18_012345678 UINT8 ARRAY, field_19_0123456789 UINT32 ARRAY, field_20_0 DATE, field_21_01 BOOL, field_22_012 HIRESTIME, field_23_0123 UINT8, field_24_01234 UINT64, field_25_012345 INT32, field_26_0123456 UINT8, field_27_01234567 REAL ARRAY, field_28_012345678 INT32, field_29_0123456789 INT64, field_30_0 CHAR, field_31_01 UINT16, field_32_012 BOOL, field_33_0123 REAL, field_34_01234 UINT32, field_35_012345 UINT64, field_36_0123456 INT16 ARRAY, field_37_01234567 HIRESTIME, field_38_012345678 INT16 ARRAY, field_39_0123456789 INT16, field_40_0 UINT32, field_41_01 INT16, field_42_012 INT64, field_43_0123 CHAR ARRAY, field_44_01234 DATETIME ARRAY, field_45_012345 DATETIME, field_46_0123456 RICHREAL, field_47_01234567 BOOL, field_48_012345678 INT16, field_49_0123456789 DATE ARRAY, field_50_0 REAL, field_51_01 INT8, field_52_012 UINT16, field_53_0123 HIRESTIME ARRAY, field_54_01234 UINT64, field_55_012345 UINT64, field_56_0123456 RICHREAL, field_57_01234567 UINT16, field_58_012345678 INT64, field_59_0123456789 INT16, field_60_0 BOOL, field_61_01 DATE, field_62_012 UINT32 ARRAY, field_63_0123 UINT32, field_64_01234 UINT64, field_65_012345 REAL, field_66_0123456 INT16, field_67_01234567 REAL, field_68_012345678 RICHREAL, field_69_0123456789 UINT8 ARRAY, field_70_0 INT64, field_71_01 UINT64 ARRAY, field_72_012 CHAR, field_73_0123 CHAR, field_74_01234 INT8, field_75_012345 UINT16, field_76_0123456 BOOL, field_77_01234567 CHAR)");
      /* 846 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 UINT32, field_3_0123 HIRESTIME, field_4_01234 UINT32, field_5_012345 REAL, field_6_0123456 INT32 ARRAY, field_7_01234567 HIRESTIME ARRAY, field_8_012345678 INT16 ARRAY, field_9_0123456789 HIRESTIME ARRAY, field_10_0 INT16, field_11_01 CHAR ARRAY, field_12_012 DATETIME, field_13_0123 UINT64, field_14_01234 INT16, field_15_012345 CHAR, field_16_0123456 INT64, field_17_01234567 HIRESTIME, field_18_012345678 INT8, field_19_0123456789 INT8, field_20_0 UINT32, field_21_01 INT16, field_22_012 UINT64, field_23_0123 HIRESTIME ARRAY, field_24_01234 REAL, field_25_012345 INT16, field_26_0123456 CHAR, field_27_01234567 REAL, field_28_012345678 BOOL, field_29_0123456789 INT8, field_30_0 BOOL, field_31_01 DATETIME, field_32_012 INT8 ARRAY, field_33_0123 UINT64, field_34_01234 REAL ARRAY, field_35_012345 UINT16 ARRAY, field_36_0123456 DATETIME, field_37_01234567 UINT32, field_38_012345678 UINT64, field_39_0123456789 HIRESTIME ARRAY, field_40_0 INT8, field_41_01 HIRESTIME, field_42_012 UINT8, field_43_0123 UINT32, field_44_01234 HIRESTIME, field_45_012345 RICHREAL ARRAY, field_46_0123456 UINT32, field_47_01234567 INT8, field_48_012345678 UINT32, field_49_0123456789 DATE, field_50_0 UINT8, field_51_01 CHAR, field_52_012 DATE ARRAY, field_53_0123 UINT8, field_54_01234 INT8, field_55_012345 RICHREAL, field_56_0123456 HIRESTIME ARRAY, field_57_01234567 UINT64 ARRAY, field_58_012345678 CHAR, field_59_0123456789 DATE ARRAY, field_60_0 CHAR, field_61_01 RICHREAL, field_62_012 UINT8, field_63_0123 UINT64, field_64_01234 INT8, field_65_012345 BOOL, field_66_0123456 UINT32 ARRAY, field_67_01234567 DATE, field_68_012345678 DATE, field_69_0123456789 INT16, field_70_0 INT16, field_71_01 BOOL, field_72_012 INT8 ARRAY, field_73_0123 UINT16, field_74_01234 UINT16, field_75_012345 DATETIME, field_76_0123456 INT16, field_77_01234567 UINT8 ARRAY, field_78_012345678 DATETIME ARRAY, field_79_0123456789 DATE ARRAY, field_80_0 UINT8, field_81_01 DATE ARRAY, field_82_012 UINT64)");
      /* 847 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 DATETIME ARRAY, field_3_0123 CHAR, field_4_01234 UINT8, field_5_012345 INT8, field_6_0123456 DATETIME ARRAY, field_7_01234567 UINT64, field_8_012345678 BOOL, field_9_0123456789 BOOL, field_10_0 INT32, field_11_01 UINT16, field_12_012 RICHREAL, field_13_0123 RICHREAL, field_14_01234 RICHREAL ARRAY, field_15_012345 UINT8, field_16_0123456 INT8, field_17_01234567 DATE, field_18_012345678 HIRESTIME, field_19_0123456789 INT8, field_20_0 UINT16, field_21_01 INT16, field_22_012 UINT16, field_23_0123 DATETIME, field_24_01234 INT8 ARRAY, field_25_012345 CHAR, field_26_0123456 UINT64, field_27_01234567 INT64, field_28_012345678 REAL ARRAY, field_29_0123456789 INT8, field_30_0 INT32, field_31_01 BOOL, field_32_012 DATE ARRAY, field_33_0123 INT16, field_34_01234 UINT32, field_35_012345 REAL, field_36_0123456 INT32, field_37_01234567 INT64, field_38_012345678 INT16, field_39_0123456789 DATE, field_40_0 DATE, field_41_01 HIRESTIME ARRAY, field_42_012 UINT32, field_43_0123 INT32, field_44_01234 HIRESTIME, field_45_012345 INT16, field_46_0123456 INT8, field_47_01234567 INT32, field_48_012345678 DATE, field_49_0123456789 INT32 ARRAY, field_50_0 UINT8, field_51_01 INT8 ARRAY, field_52_012 REAL, field_53_0123 CHAR, field_54_01234 CHAR ARRAY, field_55_012345 INT64, field_56_0123456 RICHREAL, field_57_01234567 CHAR, field_58_012345678 UINT8, field_59_0123456789 INT32, field_60_0 INT64, field_61_01 UINT16, field_62_012 CHAR, field_63_0123 INT8, field_64_01234 UINT8, field_65_012345 BOOL, field_66_0123456 UINT8, field_67_01234567 UINT64, field_68_012345678 HIRESTIME ARRAY, field_69_0123456789 UINT32, field_70_0 INT8, field_71_01 UINT64, field_72_012 BOOL ARRAY, field_73_0123 INT8, field_74_01234 DATE, field_75_012345 INT64)");
      /* 848 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 INT32, field_3_0123 UINT8, field_4_01234 BOOL, field_5_012345 REAL ARRAY, field_6_0123456 DATETIME, field_7_01234567 UINT64, field_8_012345678 UINT64, field_9_0123456789 INT32, field_10_0 UINT16, field_11_01 REAL, field_12_012 BOOL ARRAY, field_13_0123 DATE, field_14_01234 UINT8, field_15_012345 INT8 ARRAY, field_16_0123456 BOOL, field_17_01234567 RICHREAL, field_18_012345678 DATETIME, field_19_0123456789 UINT16, field_20_0 UINT16, field_21_01 INT16, field_22_012 INT64, field_23_0123 BOOL, field_24_01234 BOOL ARRAY, field_25_012345 REAL, field_26_0123456 INT64 ARRAY, field_27_01234567 HIRESTIME, field_28_012345678 REAL ARRAY, field_29_0123456789 INT16, field_30_0 INT32, field_31_01 HIRESTIME, field_32_012 INT16 ARRAY, field_33_0123 HIRESTIME ARRAY, field_34_01234 REAL, field_35_012345 CHAR, field_36_0123456 INT64, field_37_01234567 INT32 ARRAY, field_38_012345678 BOOL ARRAY, field_39_0123456789 DATETIME, field_40_0 INT32, field_41_01 DATETIME ARRAY, field_42_012 INT32 ARRAY, field_43_0123 HIRESTIME, field_44_01234 UINT32 ARRAY, field_45_012345 DATE ARRAY, field_46_0123456 CHAR, field_47_01234567 HIRESTIME, field_48_012345678 RICHREAL, field_49_0123456789 UINT16 ARRAY, field_50_0 BOOL, field_51_01 UINT64, field_52_012 BOOL, field_53_0123 DATE, field_54_01234 UINT16, field_55_012345 INT32, field_56_0123456 BOOL, field_57_01234567 BOOL, field_58_012345678 INT32, field_59_0123456789 UINT32, field_60_0 INT8, field_61_01 UINT64, field_62_012 BOOL ARRAY, field_63_0123 INT32, field_64_01234 BOOL ARRAY, field_65_012345 INT32, field_66_0123456 DATE ARRAY, field_67_01234567 UINT8, field_68_012345678 INT16, field_69_0123456789 UINT16, field_70_0 UINT8, field_71_01 RICHREAL, field_72_012 CHAR, field_73_0123 DATE, field_74_01234 RICHREAL, field_75_012345 DATETIME, field_76_0123456 INT64, field_77_01234567 REAL, field_78_012345678 UINT32, field_79_0123456789 UINT32, field_80_0 INT32, field_81_01 BOOL, field_82_012 DATE ARRAY, field_83_0123 INT16, field_84_01234 INT16)");
      /* 849 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 INT32 ARRAY, field_3_0123 INT8, field_4_01234 BOOL ARRAY, field_5_012345 REAL, field_6_0123456 INT8, field_7_01234567 INT16, field_8_012345678 DATE, field_9_0123456789 REAL, field_10_0 CHAR, field_11_01 INT8, field_12_012 DATE, field_13_0123 REAL ARRAY, field_14_01234 INT32, field_15_012345 DATE, field_16_0123456 UINT64, field_17_01234567 RICHREAL, field_18_012345678 UINT8 ARRAY, field_19_0123456789 BOOL, field_20_0 DATETIME, field_21_01 UINT64 ARRAY, field_22_012 REAL, field_23_0123 INT8, field_24_01234 UINT32, field_25_012345 HIRESTIME ARRAY, field_26_0123456 DATE, field_27_01234567 INT32, field_28_012345678 REAL, field_29_0123456789 RICHREAL, field_30_0 DATE, field_31_01 UINT8, field_32_012 BOOL, field_33_0123 UINT8, field_34_01234 DATETIME, field_35_012345 UINT8, field_36_0123456 RICHREAL, field_37_01234567 DATETIME, field_38_012345678 INT32, field_39_0123456789 DATE, field_40_0 RICHREAL, field_41_01 HIRESTIME, field_42_012 INT16, field_43_0123 DATETIME, field_44_01234 INT64, field_45_012345 REAL ARRAY, field_46_0123456 INT8, field_47_01234567 CHAR, field_48_012345678 UINT8, field_49_0123456789 INT8 ARRAY, field_50_0 UINT8, field_51_01 UINT32, field_52_012 HIRESTIME ARRAY, field_53_0123 HIRESTIME, field_54_01234 REAL)");
      /* 850 */ glbTypes.push_back("TABLE(field_1_01 UINT8 ARRAY, field_2_012 INT32, field_3_0123 DATETIME, field_4_01234 BOOL, field_5_012345 DATE, field_6_0123456 INT32, field_7_01234567 HIRESTIME, field_8_012345678 INT8, field_9_0123456789 INT8, field_10_0 UINT16, field_11_01 INT16 ARRAY, field_12_012 UINT32 ARRAY, field_13_0123 DATETIME, field_14_01234 UINT32, field_15_012345 INT16, field_16_0123456 CHAR ARRAY, field_17_01234567 UINT16, field_18_012345678 CHAR, field_19_0123456789 INT64, field_20_0 INT16, field_21_01 RICHREAL)");
      /* 851 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 UINT32, field_3_0123 BOOL, field_4_01234 BOOL, field_5_012345 DATE, field_6_0123456 DATE, field_7_01234567 BOOL, field_8_012345678 INT32 ARRAY, field_9_0123456789 CHAR, field_10_0 BOOL ARRAY, field_11_01 INT64 ARRAY, field_12_012 DATETIME ARRAY, field_13_0123 UINT16 ARRAY, field_14_01234 UINT64, field_15_012345 UINT8 ARRAY, field_16_0123456 UINT64, field_17_01234567 UINT64, field_18_012345678 DATE, field_19_0123456789 BOOL ARRAY, field_20_0 UINT8, field_21_01 HIRESTIME ARRAY, field_22_012 CHAR, field_23_0123 BOOL, field_24_01234 INT32, field_25_012345 INT32, field_26_0123456 INT16, field_27_01234567 UINT16)");
      /* 852 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 DATE ARRAY, field_3_0123 CHAR, field_4_01234 DATETIME, field_5_012345 DATETIME, field_6_0123456 UINT32, field_7_01234567 CHAR, field_8_012345678 UINT32, field_9_0123456789 UINT8 ARRAY, field_10_0 INT8, field_11_01 UINT32, field_12_012 INT64, field_13_0123 BOOL, field_14_01234 INT16 ARRAY, field_15_012345 INT8, field_16_0123456 UINT16, field_17_01234567 INT32 ARRAY, field_18_012345678 INT64, field_19_0123456789 INT16, field_20_0 INT8, field_21_01 INT16, field_22_012 REAL ARRAY, field_23_0123 INT64, field_24_01234 INT64, field_25_012345 INT8 ARRAY, field_26_0123456 RICHREAL, field_27_01234567 UINT64, field_28_012345678 UINT64 ARRAY, field_29_0123456789 CHAR, field_30_0 CHAR, field_31_01 INT16, field_32_012 CHAR, field_33_0123 REAL, field_34_01234 UINT32, field_35_012345 INT64, field_36_0123456 UINT64, field_37_01234567 DATETIME, field_38_012345678 UINT16, field_39_0123456789 REAL, field_40_0 INT16, field_41_01 INT16, field_42_012 UINT64, field_43_0123 UINT64, field_44_01234 INT32, field_45_012345 INT8, field_46_0123456 UINT32, field_47_01234567 INT8, field_48_012345678 INT64, field_49_0123456789 INT64, field_50_0 CHAR, field_51_01 INT8, field_52_012 REAL, field_53_0123 INT8, field_54_01234 UINT32 ARRAY, field_55_012345 INT8 ARRAY, field_56_0123456 INT8 ARRAY, field_57_01234567 DATE, field_58_012345678 REAL, field_59_0123456789 DATE ARRAY, field_60_0 UINT32, field_61_01 UINT32, field_62_012 INT16 ARRAY, field_63_0123 RICHREAL, field_64_01234 RICHREAL, field_65_012345 INT16, field_66_0123456 INT16, field_67_01234567 REAL ARRAY, field_68_012345678 CHAR, field_69_0123456789 RICHREAL ARRAY, field_70_0 INT16, field_71_01 UINT8 ARRAY, field_72_012 UINT64 ARRAY, field_73_0123 RICHREAL, field_74_01234 UINT8, field_75_012345 BOOL, field_76_0123456 DATE, field_77_01234567 DATETIME, field_78_012345678 DATETIME, field_79_0123456789 UINT32, field_80_0 REAL, field_81_01 INT8, field_82_012 DATETIME, field_83_0123 INT8, field_84_01234 INT16, field_85_012345 DATE ARRAY, field_86_0123456 INT8, field_87_01234567 INT16, field_88_012345678 DATE, field_89_0123456789 UINT32 ARRAY, field_90_0 DATE, field_91_01 UINT16 ARRAY, field_92_012 BOOL, field_93_0123 HIRESTIME ARRAY, field_94_01234 RICHREAL ARRAY, field_95_012345 UINT32, field_96_0123456 DATETIME, field_97_01234567 DATE, field_98_012345678 DATETIME)");
      /* 853 */ glbTypes.push_back("TABLE(field_1_01 INT8 ARRAY, field_2_012 UINT32, field_3_0123 DATE, field_4_01234 INT8, field_5_012345 REAL, field_6_0123456 INT64, field_7_01234567 INT64, field_8_012345678 DATE, field_9_0123456789 BOOL, field_10_0 UINT32 ARRAY, field_11_01 UINT8, field_12_012 UINT64, field_13_0123 HIRESTIME, field_14_01234 DATE, field_15_012345 HIRESTIME, field_16_0123456 INT8 ARRAY, field_17_01234567 INT16, field_18_012345678 UINT64 ARRAY, field_19_0123456789 BOOL, field_20_0 DATETIME, field_21_01 DATETIME ARRAY, field_22_012 BOOL, field_23_0123 DATE, field_24_01234 INT16 ARRAY, field_25_012345 INT64 ARRAY, field_26_0123456 UINT16 ARRAY, field_27_01234567 INT8, field_28_012345678 DATE, field_29_0123456789 INT32, field_30_0 INT16, field_31_01 DATE, field_32_012 HIRESTIME, field_33_0123 DATE, field_34_01234 INT64, field_35_012345 HIRESTIME, field_36_0123456 INT64, field_37_01234567 UINT16, field_38_012345678 CHAR, field_39_0123456789 REAL, field_40_0 INT8, field_41_01 UINT16, field_42_012 UINT16, field_43_0123 INT64, field_44_01234 BOOL, field_45_012345 UINT64, field_46_0123456 INT8, field_47_01234567 DATETIME, field_48_012345678 UINT16, field_49_0123456789 HIRESTIME, field_50_0 BOOL, field_51_01 INT16, field_52_012 INT8, field_53_0123 INT64, field_54_01234 BOOL ARRAY, field_55_012345 UINT8, field_56_0123456 INT8, field_57_01234567 UINT32, field_58_012345678 DATE, field_59_0123456789 DATETIME, field_60_0 INT8, field_61_01 INT32, field_62_012 RICHREAL, field_63_0123 INT32, field_64_01234 BOOL, field_65_012345 UINT8, field_66_0123456 INT8, field_67_01234567 INT8, field_68_012345678 UINT16, field_69_0123456789 CHAR, field_70_0 INT16, field_71_01 UINT64 ARRAY, field_72_012 UINT16, field_73_0123 REAL, field_74_01234 UINT16, field_75_012345 DATE ARRAY, field_76_0123456 INT16, field_77_01234567 BOOL ARRAY, field_78_012345678 HIRESTIME, field_79_0123456789 INT16 ARRAY, field_80_0 HIRESTIME, field_81_01 BOOL, field_82_012 DATETIME ARRAY, field_83_0123 UINT64, field_84_01234 DATE, field_85_012345 INT64 ARRAY, field_86_0123456 UINT64, field_87_01234567 UINT32 ARRAY)");
      /* 854 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 UINT8 ARRAY, field_3_0123 INT8, field_4_01234 DATETIME, field_5_012345 CHAR ARRAY, field_6_0123456 BOOL, field_7_01234567 HIRESTIME ARRAY, field_8_012345678 UINT32, field_9_0123456789 INT64 ARRAY, field_10_0 RICHREAL ARRAY, field_11_01 BOOL ARRAY, field_12_012 INT16, field_13_0123 RICHREAL ARRAY, field_14_01234 INT32, field_15_012345 DATETIME, field_16_0123456 INT16, field_17_01234567 REAL, field_18_012345678 INT16, field_19_0123456789 INT64, field_20_0 REAL ARRAY, field_21_01 INT64, field_22_012 HIRESTIME, field_23_0123 INT32, field_24_01234 UINT16, field_25_012345 DATETIME, field_26_0123456 UINT16, field_27_01234567 UINT16, field_28_012345678 UINT8, field_29_0123456789 HIRESTIME ARRAY, field_30_0 UINT16, field_31_01 INT64 ARRAY, field_32_012 REAL, field_33_0123 UINT64, field_34_01234 HIRESTIME)");
      /* 855 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 UINT16, field_3_0123 UINT64, field_4_01234 UINT32 ARRAY, field_5_012345 DATETIME ARRAY, field_6_0123456 INT8, field_7_01234567 HIRESTIME, field_8_012345678 UINT16, field_9_0123456789 INT64, field_10_0 UINT32, field_11_01 UINT64, field_12_012 UINT32 ARRAY, field_13_0123 REAL ARRAY, field_14_01234 UINT32, field_15_012345 UINT16, field_16_0123456 REAL, field_17_01234567 HIRESTIME, field_18_012345678 RICHREAL, field_19_0123456789 RICHREAL, field_20_0 INT32, field_21_01 INT64, field_22_012 BOOL, field_23_0123 INT16, field_24_01234 UINT32, field_25_012345 DATE, field_26_0123456 UINT16, field_27_01234567 REAL, field_28_012345678 UINT16, field_29_0123456789 DATE, field_30_0 CHAR ARRAY, field_31_01 CHAR, field_32_012 INT8 ARRAY, field_33_0123 RICHREAL, field_34_01234 INT32, field_35_012345 DATETIME, field_36_0123456 RICHREAL, field_37_01234567 DATETIME, field_38_012345678 UINT32, field_39_0123456789 INT16 ARRAY, field_40_0 INT64, field_41_01 UINT16, field_42_012 DATE, field_43_0123 RICHREAL, field_44_01234 BOOL, field_45_012345 DATE, field_46_0123456 DATE, field_47_01234567 BOOL, field_48_012345678 UINT8, field_49_0123456789 HIRESTIME, field_50_0 INT64, field_51_01 INT16, field_52_012 INT32, field_53_0123 DATETIME ARRAY, field_54_01234 INT8, field_55_012345 DATETIME, field_56_0123456 HIRESTIME, field_57_01234567 BOOL, field_58_012345678 INT16, field_59_0123456789 UINT8 ARRAY, field_60_0 INT16, field_61_01 UINT32, field_62_012 DATE ARRAY, field_63_0123 UINT64, field_64_01234 CHAR, field_65_012345 UINT8, field_66_0123456 REAL ARRAY, field_67_01234567 UINT64, field_68_012345678 INT16, field_69_0123456789 UINT8, field_70_0 UINT32, field_71_01 DATE ARRAY, field_72_012 DATE, field_73_0123 DATE, field_74_01234 UINT16, field_75_012345 UINT8, field_76_0123456 INT32 ARRAY, field_77_01234567 RICHREAL, field_78_012345678 UINT8, field_79_0123456789 UINT64, field_80_0 DATETIME, field_81_01 DATE, field_82_012 BOOL, field_83_0123 UINT16, field_84_01234 INT8 ARRAY, field_85_012345 UINT64, field_86_0123456 INT64, field_87_01234567 INT8, field_88_012345678 HIRESTIME, field_89_0123456789 CHAR, field_90_0 UINT32, field_91_01 HIRESTIME, field_92_012 UINT8, field_93_0123 UINT64)");
      /* 856 */ glbTypes.push_back("TABLE(field_1_01 INT64 ARRAY, field_2_012 INT8, field_3_0123 INT32, field_4_01234 UINT8, field_5_012345 UINT32 ARRAY, field_6_0123456 DATE ARRAY, field_7_01234567 UINT32, field_8_012345678 INT32, field_9_0123456789 CHAR ARRAY, field_10_0 INT64 ARRAY, field_11_01 UINT8, field_12_012 REAL ARRAY, field_13_0123 RICHREAL, field_14_01234 REAL, field_15_012345 CHAR, field_16_0123456 CHAR, field_17_01234567 INT64, field_18_012345678 UINT64 ARRAY, field_19_0123456789 INT32, field_20_0 UINT8 ARRAY, field_21_01 RICHREAL ARRAY, field_22_012 INT16, field_23_0123 INT16, field_24_01234 DATETIME, field_25_012345 DATE, field_26_0123456 DATETIME, field_27_01234567 UINT16, field_28_012345678 BOOL, field_29_0123456789 INT8, field_30_0 INT32, field_31_01 INT8, field_32_012 HIRESTIME, field_33_0123 UINT64, field_34_01234 BOOL, field_35_012345 INT32 ARRAY, field_36_0123456 INT16, field_37_01234567 RICHREAL, field_38_012345678 INT16, field_39_0123456789 INT16 ARRAY, field_40_0 INT8, field_41_01 UINT64, field_42_012 HIRESTIME, field_43_0123 DATETIME, field_44_01234 INT64, field_45_012345 UINT32, field_46_0123456 HIRESTIME, field_47_01234567 HIRESTIME, field_48_012345678 INT64, field_49_0123456789 HIRESTIME, field_50_0 INT16, field_51_01 INT16, field_52_012 HIRESTIME, field_53_0123 UINT32, field_54_01234 UINT8 ARRAY, field_55_012345 INT32 ARRAY, field_56_0123456 UINT16, field_57_01234567 RICHREAL ARRAY, field_58_012345678 UINT16, field_59_0123456789 DATETIME ARRAY, field_60_0 BOOL, field_61_01 INT32 ARRAY, field_62_012 UINT8, field_63_0123 UINT16 ARRAY, field_64_01234 DATE, field_65_012345 REAL, field_66_0123456 INT64, field_67_01234567 RICHREAL ARRAY, field_68_012345678 INT8)");
      /* 857 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 INT64, field_3_0123 DATE, field_4_01234 BOOL, field_5_012345 CHAR ARRAY, field_6_0123456 CHAR, field_7_01234567 REAL, field_8_012345678 UINT32 ARRAY, field_9_0123456789 DATETIME, field_10_0 DATE, field_11_01 UINT32, field_12_012 UINT16 ARRAY, field_13_0123 RICHREAL, field_14_01234 RICHREAL, field_15_012345 UINT64, field_16_0123456 UINT64, field_17_01234567 RICHREAL, field_18_012345678 CHAR, field_19_0123456789 DATETIME, field_20_0 REAL, field_21_01 HIRESTIME, field_22_012 HIRESTIME, field_23_0123 UINT64, field_24_01234 DATETIME, field_25_012345 UINT64, field_26_0123456 INT16, field_27_01234567 UINT16 ARRAY, field_28_012345678 INT16, field_29_0123456789 INT32, field_30_0 RICHREAL ARRAY, field_31_01 DATETIME, field_32_012 INT64, field_33_0123 INT8, field_34_01234 INT64, field_35_012345 UINT16, field_36_0123456 INT8, field_37_01234567 DATETIME, field_38_012345678 UINT8 ARRAY, field_39_0123456789 UINT8, field_40_0 DATE, field_41_01 UINT32 ARRAY, field_42_012 HIRESTIME, field_43_0123 CHAR, field_44_01234 INT64, field_45_012345 UINT16 ARRAY, field_46_0123456 BOOL, field_47_01234567 UINT8 ARRAY, field_48_012345678 DATE, field_49_0123456789 INT8 ARRAY, field_50_0 UINT16, field_51_01 INT32, field_52_012 UINT32, field_53_0123 RICHREAL ARRAY, field_54_01234 BOOL, field_55_012345 INT32, field_56_0123456 RICHREAL, field_57_01234567 INT8 ARRAY, field_58_012345678 CHAR, field_59_0123456789 UINT8, field_60_0 DATE, field_61_01 RICHREAL ARRAY, field_62_012 UINT64, field_63_0123 CHAR ARRAY, field_64_01234 RICHREAL, field_65_012345 INT32, field_66_0123456 UINT32, field_67_01234567 HIRESTIME, field_68_012345678 UINT8, field_69_0123456789 DATETIME, field_70_0 UINT32, field_71_01 CHAR, field_72_012 UINT32, field_73_0123 UINT16, field_74_01234 REAL ARRAY, field_75_012345 UINT32, field_76_0123456 DATE, field_77_01234567 INT8, field_78_012345678 INT16, field_79_0123456789 INT32, field_80_0 INT16, field_81_01 UINT64, field_82_012 CHAR)");
      /* 858 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 UINT8, field_3_0123 BOOL, field_4_01234 UINT32 ARRAY, field_5_012345 UINT32, field_6_0123456 BOOL, field_7_01234567 RICHREAL ARRAY, field_8_012345678 INT64, field_9_0123456789 HIRESTIME, field_10_0 REAL, field_11_01 HIRESTIME, field_12_012 INT32, field_13_0123 DATETIME, field_14_01234 RICHREAL, field_15_012345 RICHREAL, field_16_0123456 INT16 ARRAY, field_17_01234567 UINT64, field_18_012345678 HIRESTIME, field_19_0123456789 INT32 ARRAY, field_20_0 DATE, field_21_01 DATE ARRAY, field_22_012 INT16, field_23_0123 UINT8, field_24_01234 CHAR, field_25_012345 UINT64)");
      /* 859 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 INT32, field_3_0123 RICHREAL, field_4_01234 INT8)");
      /* 860 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 RICHREAL, field_3_0123 DATE, field_4_01234 BOOL, field_5_012345 INT64, field_6_0123456 HIRESTIME, field_7_01234567 RICHREAL, field_8_012345678 UINT8, field_9_0123456789 DATETIME, field_10_0 INT16, field_11_01 HIRESTIME, field_12_012 UINT64, field_13_0123 INT32 ARRAY, field_14_01234 DATETIME)");
      /* 861 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 UINT8, field_3_0123 RICHREAL, field_4_01234 HIRESTIME ARRAY, field_5_012345 UINT64, field_6_0123456 HIRESTIME, field_7_01234567 INT32, field_8_012345678 DATE ARRAY, field_9_0123456789 DATE ARRAY, field_10_0 REAL, field_11_01 HIRESTIME, field_12_012 UINT16, field_13_0123 CHAR, field_14_01234 DATETIME ARRAY, field_15_012345 HIRESTIME, field_16_0123456 INT32 ARRAY, field_17_01234567 REAL ARRAY, field_18_012345678 CHAR, field_19_0123456789 DATETIME, field_20_0 INT16, field_21_01 UINT32, field_22_012 INT64 ARRAY, field_23_0123 DATE, field_24_01234 CHAR, field_25_012345 INT64, field_26_0123456 BOOL, field_27_01234567 INT16, field_28_012345678 CHAR, field_29_0123456789 UINT16, field_30_0 REAL ARRAY, field_31_01 INT16, field_32_012 INT16 ARRAY, field_33_0123 INT32, field_34_01234 UINT64, field_35_012345 DATETIME ARRAY, field_36_0123456 HIRESTIME, field_37_01234567 BOOL ARRAY, field_38_012345678 DATE, field_39_0123456789 UINT32, field_40_0 HIRESTIME, field_41_01 DATE ARRAY, field_42_012 UINT16 ARRAY, field_43_0123 UINT32, field_44_01234 HIRESTIME, field_45_012345 HIRESTIME ARRAY, field_46_0123456 DATE, field_47_01234567 INT32, field_48_012345678 UINT16, field_49_0123456789 UINT16, field_50_0 INT64, field_51_01 HIRESTIME, field_52_012 UINT8, field_53_0123 HIRESTIME, field_54_01234 REAL, field_55_012345 INT16, field_56_0123456 DATE, field_57_01234567 HIRESTIME, field_58_012345678 CHAR, field_59_0123456789 CHAR, field_60_0 RICHREAL, field_61_01 DATE, field_62_012 REAL, field_63_0123 REAL, field_64_01234 INT8 ARRAY, field_65_012345 UINT16, field_66_0123456 INT8, field_67_01234567 RICHREAL ARRAY, field_68_012345678 INT32, field_69_0123456789 INT32, field_70_0 UINT32 ARRAY, field_71_01 HIRESTIME ARRAY, field_72_012 UINT16 ARRAY, field_73_0123 REAL, field_74_01234 RICHREAL, field_75_012345 INT64, field_76_0123456 REAL, field_77_01234567 REAL ARRAY, field_78_012345678 INT16, field_79_0123456789 UINT64 ARRAY, field_80_0 REAL ARRAY, field_81_01 CHAR, field_82_012 UINT32, field_83_0123 UINT64, field_84_01234 UINT64 ARRAY, field_85_012345 CHAR ARRAY, field_86_0123456 UINT16, field_87_01234567 HIRESTIME)");
      /* 862 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 INT64, field_3_0123 CHAR, field_4_01234 DATE ARRAY, field_5_012345 BOOL, field_6_0123456 RICHREAL, field_7_01234567 BOOL, field_8_012345678 INT64, field_9_0123456789 INT64, field_10_0 CHAR, field_11_01 HIRESTIME, field_12_012 UINT64 ARRAY, field_13_0123 REAL, field_14_01234 UINT8, field_15_012345 INT8, field_16_0123456 INT32 ARRAY, field_17_01234567 REAL, field_18_012345678 RICHREAL, field_19_0123456789 INT16 ARRAY, field_20_0 DATETIME, field_21_01 DATETIME, field_22_012 UINT8, field_23_0123 INT16, field_24_01234 REAL, field_25_012345 DATETIME, field_26_0123456 UINT32, field_27_01234567 RICHREAL, field_28_012345678 DATE ARRAY, field_29_0123456789 INT32, field_30_0 UINT32 ARRAY, field_31_01 UINT32 ARRAY, field_32_012 UINT8, field_33_0123 DATETIME, field_34_01234 UINT16, field_35_012345 UINT32, field_36_0123456 INT32, field_37_01234567 UINT32 ARRAY, field_38_012345678 UINT8 ARRAY, field_39_0123456789 HIRESTIME ARRAY, field_40_0 UINT64 ARRAY, field_41_01 INT16 ARRAY, field_42_012 REAL, field_43_0123 INT64 ARRAY, field_44_01234 HIRESTIME, field_45_012345 INT64, field_46_0123456 UINT8, field_47_01234567 INT32 ARRAY, field_48_012345678 INT64 ARRAY, field_49_0123456789 UINT64, field_50_0 REAL, field_51_01 RICHREAL, field_52_012 UINT16, field_53_0123 INT32, field_54_01234 RICHREAL, field_55_012345 BOOL, field_56_0123456 UINT8, field_57_01234567 DATE, field_58_012345678 DATE, field_59_0123456789 CHAR, field_60_0 INT16, field_61_01 HIRESTIME, field_62_012 UINT64 ARRAY, field_63_0123 INT8 ARRAY, field_64_01234 INT16, field_65_012345 UINT8, field_66_0123456 HIRESTIME ARRAY, field_67_01234567 HIRESTIME ARRAY, field_68_012345678 UINT64, field_69_0123456789 RICHREAL, field_70_0 BOOL, field_71_01 DATETIME, field_72_012 INT8, field_73_0123 RICHREAL, field_74_01234 UINT64, field_75_012345 INT32, field_76_0123456 UINT8, field_77_01234567 INT16 ARRAY, field_78_012345678 INT16, field_79_0123456789 CHAR, field_80_0 UINT8 ARRAY, field_81_01 DATETIME, field_82_012 DATE, field_83_0123 INT16, field_84_01234 HIRESTIME, field_85_012345 HIRESTIME)");
      /* 863 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 DATETIME, field_3_0123 HIRESTIME, field_4_01234 REAL, field_5_012345 INT64, field_6_0123456 INT16 ARRAY, field_7_01234567 UINT32, field_8_012345678 INT16, field_9_0123456789 DATETIME, field_10_0 DATE, field_11_01 REAL, field_12_012 UINT64 ARRAY, field_13_0123 REAL, field_14_01234 DATE, field_15_012345 CHAR, field_16_0123456 INT64 ARRAY, field_17_01234567 DATETIME ARRAY, field_18_012345678 UINT64, field_19_0123456789 UINT64)");
      /* 864 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 DATETIME, field_3_0123 HIRESTIME, field_4_01234 BOOL, field_5_012345 INT16, field_6_0123456 UINT8, field_7_01234567 CHAR ARRAY, field_8_012345678 DATETIME, field_9_0123456789 DATETIME, field_10_0 UINT32, field_11_01 INT8, field_12_012 UINT8, field_13_0123 INT64, field_14_01234 UINT32, field_15_012345 INT64 ARRAY, field_16_0123456 CHAR, field_17_01234567 INT32, field_18_012345678 UINT32, field_19_0123456789 INT8, field_20_0 UINT8, field_21_01 UINT32, field_22_012 INT8, field_23_0123 BOOL, field_24_01234 DATE, field_25_012345 UINT32, field_26_0123456 BOOL, field_27_01234567 UINT16, field_28_012345678 CHAR, field_29_0123456789 UINT32, field_30_0 BOOL, field_31_01 UINT8 ARRAY, field_32_012 RICHREAL, field_33_0123 UINT16, field_34_01234 INT16, field_35_012345 INT8, field_36_0123456 DATETIME, field_37_01234567 DATETIME, field_38_012345678 INT16 ARRAY, field_39_0123456789 HIRESTIME, field_40_0 REAL, field_41_01 INT32, field_42_012 INT16, field_43_0123 UINT8, field_44_01234 UINT16, field_45_012345 DATE ARRAY, field_46_0123456 INT32 ARRAY, field_47_01234567 INT8, field_48_012345678 HIRESTIME ARRAY, field_49_0123456789 UINT8, field_50_0 INT32, field_51_01 INT64)");
      /* 865 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 DATE, field_3_0123 UINT8, field_4_01234 DATE, field_5_012345 RICHREAL, field_6_0123456 INT32, field_7_01234567 INT32, field_8_012345678 DATE ARRAY, field_9_0123456789 CHAR, field_10_0 UINT16, field_11_01 UINT16, field_12_012 DATETIME, field_13_0123 INT8, field_14_01234 INT16, field_15_012345 INT8, field_16_0123456 BOOL, field_17_01234567 DATE, field_18_012345678 RICHREAL, field_19_0123456789 INT8, field_20_0 HIRESTIME, field_21_01 INT64, field_22_012 BOOL, field_23_0123 UINT8, field_24_01234 INT64, field_25_012345 DATE, field_26_0123456 DATE, field_27_01234567 DATETIME, field_28_012345678 UINT8, field_29_0123456789 DATE, field_30_0 CHAR, field_31_01 UINT16, field_32_012 UINT8, field_33_0123 INT64, field_34_01234 DATETIME, field_35_012345 UINT8, field_36_0123456 REAL, field_37_01234567 UINT32, field_38_012345678 INT8 ARRAY, field_39_0123456789 RICHREAL, field_40_0 DATETIME, field_41_01 INT8, field_42_012 BOOL, field_43_0123 CHAR, field_44_01234 HIRESTIME, field_45_012345 INT8, field_46_0123456 INT64, field_47_01234567 UINT64 ARRAY, field_48_012345678 UINT8 ARRAY, field_49_0123456789 BOOL, field_50_0 DATE, field_51_01 REAL, field_52_012 INT16, field_53_0123 UINT32 ARRAY, field_54_01234 INT32, field_55_012345 INT8, field_56_0123456 DATE, field_57_01234567 UINT8 ARRAY, field_58_012345678 UINT16, field_59_0123456789 INT32, field_60_0 UINT8 ARRAY, field_61_01 UINT64, field_62_012 BOOL, field_63_0123 UINT16, field_64_01234 REAL, field_65_012345 BOOL, field_66_0123456 BOOL, field_67_01234567 DATE, field_68_012345678 RICHREAL ARRAY, field_69_0123456789 REAL, field_70_0 RICHREAL, field_71_01 INT16, field_72_012 UINT32 ARRAY, field_73_0123 CHAR, field_74_01234 BOOL, field_75_012345 INT64, field_76_0123456 INT8, field_77_01234567 UINT32, field_78_012345678 HIRESTIME, field_79_0123456789 INT16, field_80_0 UINT8, field_81_01 DATE, field_82_012 UINT8, field_83_0123 INT16, field_84_01234 RICHREAL ARRAY, field_85_012345 UINT8 ARRAY, field_86_0123456 DATETIME, field_87_01234567 DATETIME ARRAY, field_88_012345678 DATE, field_89_0123456789 BOOL, field_90_0 UINT8, field_91_01 DATETIME, field_92_012 DATETIME, field_93_0123 REAL, field_94_01234 INT64, field_95_012345 HIRESTIME)");
      /* 866 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 BOOL, field_3_0123 INT16, field_4_01234 RICHREAL, field_5_012345 DATE, field_6_0123456 UINT64, field_7_01234567 INT64 ARRAY)");
      /* 867 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 UINT8, field_3_0123 UINT16, field_4_01234 UINT32, field_5_012345 INT8 ARRAY, field_6_0123456 INT16 ARRAY, field_7_01234567 UINT8, field_8_012345678 INT32 ARRAY, field_9_0123456789 RICHREAL, field_10_0 UINT32, field_11_01 UINT8 ARRAY, field_12_012 DATETIME ARRAY, field_13_0123 UINT64 ARRAY, field_14_01234 INT32, field_15_012345 UINT32, field_16_0123456 UINT16, field_17_01234567 DATE, field_18_012345678 INT8, field_19_0123456789 DATE, field_20_0 DATETIME, field_21_01 BOOL ARRAY, field_22_012 INT8, field_23_0123 HIRESTIME, field_24_01234 UINT64, field_25_012345 UINT16)");
      /* 868 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 UINT32 ARRAY, field_3_0123 RICHREAL, field_4_01234 BOOL, field_5_012345 CHAR, field_6_0123456 HIRESTIME ARRAY, field_7_01234567 UINT32, field_8_012345678 INT64, field_9_0123456789 UINT16 ARRAY, field_10_0 UINT32, field_11_01 HIRESTIME, field_12_012 DATE, field_13_0123 DATETIME, field_14_01234 UINT16, field_15_012345 CHAR, field_16_0123456 RICHREAL, field_17_01234567 DATE, field_18_012345678 UINT8 ARRAY, field_19_0123456789 UINT64 ARRAY, field_20_0 UINT32, field_21_01 INT8, field_22_012 INT8, field_23_0123 CHAR, field_24_01234 RICHREAL, field_25_012345 INT16, field_26_0123456 REAL ARRAY, field_27_01234567 DATETIME, field_28_012345678 UINT16 ARRAY, field_29_0123456789 INT8, field_30_0 HIRESTIME, field_31_01 HIRESTIME, field_32_012 UINT8, field_33_0123 INT8, field_34_01234 RICHREAL ARRAY, field_35_012345 UINT32, field_36_0123456 UINT32, field_37_01234567 DATE, field_38_012345678 UINT32, field_39_0123456789 UINT64, field_40_0 CHAR, field_41_01 CHAR, field_42_012 HIRESTIME, field_43_0123 DATETIME ARRAY, field_44_01234 DATE, field_45_012345 INT64, field_46_0123456 UINT8 ARRAY, field_47_01234567 INT64 ARRAY, field_48_012345678 INT64, field_49_0123456789 BOOL, field_50_0 DATE, field_51_01 CHAR, field_52_012 INT8, field_53_0123 UINT16 ARRAY, field_54_01234 UINT64, field_55_012345 CHAR, field_56_0123456 UINT16, field_57_01234567 UINT16, field_58_012345678 INT8, field_59_0123456789 HIRESTIME, field_60_0 UINT8, field_61_01 UINT16, field_62_012 REAL, field_63_0123 DATE, field_64_01234 INT64, field_65_012345 DATETIME, field_66_0123456 REAL, field_67_01234567 INT64, field_68_012345678 CHAR ARRAY, field_69_0123456789 REAL, field_70_0 REAL, field_71_01 DATETIME, field_72_012 REAL, field_73_0123 REAL, field_74_01234 INT64, field_75_012345 INT8, field_76_0123456 UINT32 ARRAY)");
      /* 869 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 RICHREAL, field_3_0123 INT16, field_4_01234 UINT64 ARRAY, field_5_012345 BOOL, field_6_0123456 UINT16, field_7_01234567 HIRESTIME, field_8_012345678 INT64, field_9_0123456789 DATETIME, field_10_0 HIRESTIME, field_11_01 INT64 ARRAY, field_12_012 INT64, field_13_0123 INT16 ARRAY, field_14_01234 UINT64, field_15_012345 RICHREAL, field_16_0123456 INT8, field_17_01234567 REAL ARRAY, field_18_012345678 INT32, field_19_0123456789 HIRESTIME, field_20_0 INT64, field_21_01 UINT8, field_22_012 UINT64, field_23_0123 UINT8, field_24_01234 INT8, field_25_012345 UINT8, field_26_0123456 DATETIME, field_27_01234567 INT8)");
      /* 870 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 INT8, field_3_0123 UINT8, field_4_01234 INT8 ARRAY, field_5_012345 INT8 ARRAY, field_6_0123456 UINT64, field_7_01234567 CHAR ARRAY, field_8_012345678 INT64 ARRAY, field_9_0123456789 UINT64, field_10_0 BOOL, field_11_01 INT64 ARRAY, field_12_012 BOOL ARRAY, field_13_0123 RICHREAL, field_14_01234 INT16 ARRAY, field_15_012345 UINT8, field_16_0123456 DATETIME, field_17_01234567 DATE ARRAY, field_18_012345678 UINT8, field_19_0123456789 DATETIME, field_20_0 DATE ARRAY, field_21_01 DATE, field_22_012 INT16, field_23_0123 INT64, field_24_01234 INT64, field_25_012345 RICHREAL, field_26_0123456 REAL, field_27_01234567 HIRESTIME, field_28_012345678 UINT64, field_29_0123456789 UINT16, field_30_0 REAL, field_31_01 HIRESTIME, field_32_012 INT64, field_33_0123 RICHREAL, field_34_01234 INT16 ARRAY, field_35_012345 INT32, field_36_0123456 DATETIME ARRAY, field_37_01234567 UINT16, field_38_012345678 INT64, field_39_0123456789 INT16, field_40_0 UINT32, field_41_01 INT32)");
      /* 871 */ glbTypes.push_back("TABLE(field_1_01 BOOL ARRAY, field_2_012 UINT32, field_3_0123 HIRESTIME, field_4_01234 INT32, field_5_012345 DATETIME, field_6_0123456 UINT32, field_7_01234567 CHAR, field_8_012345678 UINT64, field_9_0123456789 RICHREAL ARRAY, field_10_0 CHAR, field_11_01 CHAR, field_12_012 HIRESTIME, field_13_0123 HIRESTIME, field_14_01234 INT16, field_15_012345 REAL, field_16_0123456 UINT64, field_17_01234567 RICHREAL ARRAY, field_18_012345678 CHAR, field_19_0123456789 INT8, field_20_0 UINT8, field_21_01 CHAR ARRAY, field_22_012 UINT64, field_23_0123 BOOL, field_24_01234 INT32, field_25_012345 UINT8, field_26_0123456 UINT16 ARRAY, field_27_01234567 UINT8 ARRAY, field_28_012345678 INT16, field_29_0123456789 REAL ARRAY, field_30_0 DATE ARRAY, field_31_01 CHAR, field_32_012 REAL, field_33_0123 INT32, field_34_01234 UINT32, field_35_012345 UINT8, field_36_0123456 RICHREAL, field_37_01234567 REAL, field_38_012345678 DATETIME ARRAY, field_39_0123456789 HIRESTIME, field_40_0 INT8, field_41_01 RICHREAL ARRAY, field_42_012 UINT64, field_43_0123 UINT64 ARRAY, field_44_01234 INT16, field_45_012345 DATETIME, field_46_0123456 UINT32, field_47_01234567 UINT8, field_48_012345678 BOOL, field_49_0123456789 INT64, field_50_0 INT16, field_51_01 INT16 ARRAY, field_52_012 INT64, field_53_0123 DATETIME, field_54_01234 HIRESTIME, field_55_012345 HIRESTIME, field_56_0123456 INT16, field_57_01234567 REAL ARRAY, field_58_012345678 INT64, field_59_0123456789 UINT8, field_60_0 INT8, field_61_01 DATETIME, field_62_012 INT32, field_63_0123 CHAR, field_64_01234 DATETIME, field_65_012345 INT8, field_66_0123456 DATETIME, field_67_01234567 RICHREAL ARRAY, field_68_012345678 REAL, field_69_0123456789 HIRESTIME ARRAY, field_70_0 DATE, field_71_01 INT32, field_72_012 UINT64, field_73_0123 UINT8, field_74_01234 INT32, field_75_012345 INT8, field_76_0123456 UINT64, field_77_01234567 UINT64, field_78_012345678 INT16)");
      /* 872 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 HIRESTIME, field_3_0123 DATETIME ARRAY, field_4_01234 HIRESTIME, field_5_012345 DATETIME, field_6_0123456 DATETIME, field_7_01234567 REAL, field_8_012345678 HIRESTIME, field_9_0123456789 INT16, field_10_0 UINT64, field_11_01 INT8, field_12_012 INT16, field_13_0123 UINT32, field_14_01234 INT16, field_15_012345 UINT8, field_16_0123456 BOOL, field_17_01234567 UINT16, field_18_012345678 BOOL, field_19_0123456789 INT32, field_20_0 DATETIME ARRAY, field_21_01 INT64, field_22_012 CHAR, field_23_0123 UINT32 ARRAY, field_24_01234 REAL, field_25_012345 INT32 ARRAY, field_26_0123456 UINT8, field_27_01234567 CHAR, field_28_012345678 RICHREAL ARRAY, field_29_0123456789 UINT64, field_30_0 BOOL, field_31_01 CHAR)");
      /* 873 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 INT64 ARRAY, field_3_0123 BOOL, field_4_01234 UINT8, field_5_012345 UINT8, field_6_0123456 DATETIME ARRAY, field_7_01234567 INT32, field_8_012345678 UINT32, field_9_0123456789 INT8, field_10_0 INT32, field_11_01 UINT64, field_12_012 CHAR ARRAY, field_13_0123 UINT16, field_14_01234 INT16, field_15_012345 DATE, field_16_0123456 UINT32, field_17_01234567 UINT64, field_18_012345678 UINT16 ARRAY, field_19_0123456789 DATE ARRAY, field_20_0 INT64, field_21_01 DATE, field_22_012 DATETIME, field_23_0123 REAL, field_24_01234 INT64, field_25_012345 BOOL, field_26_0123456 INT8, field_27_01234567 INT16, field_28_012345678 INT64, field_29_0123456789 UINT8, field_30_0 INT32, field_31_01 RICHREAL, field_32_012 UINT16, field_33_0123 BOOL, field_34_01234 INT16, field_35_012345 CHAR ARRAY, field_36_0123456 INT16, field_37_01234567 HIRESTIME, field_38_012345678 RICHREAL, field_39_0123456789 UINT64, field_40_0 HIRESTIME ARRAY, field_41_01 HIRESTIME ARRAY, field_42_012 INT16, field_43_0123 BOOL ARRAY, field_44_01234 UINT32, field_45_012345 UINT64, field_46_0123456 BOOL, field_47_01234567 INT16, field_48_012345678 INT32, field_49_0123456789 INT8, field_50_0 UINT32 ARRAY, field_51_01 INT16, field_52_012 INT8, field_53_0123 BOOL, field_54_01234 UINT16, field_55_012345 BOOL ARRAY, field_56_0123456 HIRESTIME, field_57_01234567 INT16, field_58_012345678 RICHREAL, field_59_0123456789 RICHREAL, field_60_0 UINT64, field_61_01 DATE, field_62_012 UINT8 ARRAY, field_63_0123 RICHREAL, field_64_01234 UINT8, field_65_012345 INT16, field_66_0123456 UINT32, field_67_01234567 INT16 ARRAY, field_68_012345678 INT16, field_69_0123456789 DATETIME, field_70_0 UINT8, field_71_01 UINT16, field_72_012 INT16, field_73_0123 INT8 ARRAY, field_74_01234 HIRESTIME, field_75_012345 DATETIME ARRAY, field_76_0123456 UINT16, field_77_01234567 REAL, field_78_012345678 INT16, field_79_0123456789 DATETIME, field_80_0 HIRESTIME, field_81_01 DATE ARRAY)");
      /* 874 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 DATETIME, field_3_0123 REAL, field_4_01234 DATE ARRAY, field_5_012345 UINT8, field_6_0123456 REAL, field_7_01234567 UINT16 ARRAY, field_8_012345678 INT64, field_9_0123456789 DATETIME, field_10_0 BOOL ARRAY, field_11_01 INT32, field_12_012 HIRESTIME, field_13_0123 UINT8, field_14_01234 RICHREAL ARRAY, field_15_012345 CHAR ARRAY, field_16_0123456 UINT8, field_17_01234567 DATETIME, field_18_012345678 INT64, field_19_0123456789 CHAR, field_20_0 INT32 ARRAY, field_21_01 RICHREAL, field_22_012 REAL ARRAY, field_23_0123 INT16, field_24_01234 INT64, field_25_012345 UINT32, field_26_0123456 DATETIME, field_27_01234567 INT8, field_28_012345678 REAL, field_29_0123456789 REAL ARRAY, field_30_0 INT64, field_31_01 INT8, field_32_012 REAL, field_33_0123 INT8, field_34_01234 INT64, field_35_012345 INT16, field_36_0123456 UINT8, field_37_01234567 BOOL, field_38_012345678 BOOL ARRAY, field_39_0123456789 DATETIME, field_40_0 UINT32, field_41_01 RICHREAL, field_42_012 INT64 ARRAY, field_43_0123 INT32, field_44_01234 HIRESTIME, field_45_012345 DATETIME, field_46_0123456 UINT32, field_47_01234567 REAL, field_48_012345678 UINT16, field_49_0123456789 UINT8, field_50_0 UINT64, field_51_01 BOOL, field_52_012 INT8 ARRAY, field_53_0123 BOOL, field_54_01234 REAL, field_55_012345 INT16, field_56_0123456 RICHREAL ARRAY, field_57_01234567 BOOL, field_58_012345678 UINT64, field_59_0123456789 HIRESTIME, field_60_0 CHAR ARRAY, field_61_01 UINT8, field_62_012 UINT64, field_63_0123 UINT8, field_64_01234 RICHREAL, field_65_012345 UINT16, field_66_0123456 RICHREAL, field_67_01234567 INT8 ARRAY, field_68_012345678 UINT8 ARRAY, field_69_0123456789 CHAR, field_70_0 INT64, field_71_01 UINT16, field_72_012 REAL, field_73_0123 INT8, field_74_01234 BOOL, field_75_012345 INT32, field_76_0123456 REAL, field_77_01234567 RICHREAL, field_78_012345678 BOOL, field_79_0123456789 INT32, field_80_0 UINT8, field_81_01 UINT8, field_82_012 UINT32, field_83_0123 INT8, field_84_01234 BOOL, field_85_012345 INT64 ARRAY, field_86_0123456 DATETIME ARRAY, field_87_01234567 UINT32, field_88_012345678 RICHREAL, field_89_0123456789 UINT32, field_90_0 INT64)");
      /* 875 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 UINT32 ARRAY, field_3_0123 HIRESTIME, field_4_01234 INT16, field_5_012345 UINT64, field_6_0123456 INT32, field_7_01234567 UINT8, field_8_012345678 HIRESTIME, field_9_0123456789 UINT64, field_10_0 DATETIME, field_11_01 UINT32, field_12_012 UINT64, field_13_0123 BOOL, field_14_01234 INT16, field_15_012345 BOOL, field_16_0123456 UINT16, field_17_01234567 DATE, field_18_012345678 DATE, field_19_0123456789 BOOL, field_20_0 UINT32, field_21_01 RICHREAL, field_22_012 UINT16 ARRAY, field_23_0123 UINT64, field_24_01234 UINT8, field_25_012345 INT8, field_26_0123456 UINT16, field_27_01234567 INT32, field_28_012345678 UINT8 ARRAY, field_29_0123456789 DATETIME ARRAY, field_30_0 INT32 ARRAY, field_31_01 UINT8, field_32_012 CHAR, field_33_0123 UINT8, field_34_01234 HIRESTIME, field_35_012345 HIRESTIME ARRAY, field_36_0123456 REAL, field_37_01234567 BOOL ARRAY, field_38_012345678 HIRESTIME, field_39_0123456789 UINT32, field_40_0 RICHREAL, field_41_01 UINT8, field_42_012 UINT32, field_43_0123 CHAR)");
      /* 876 */ glbTypes.push_back("TABLE(field_1_01 UINT8 ARRAY, field_2_012 INT32, field_3_0123 UINT32, field_4_01234 UINT16, field_5_012345 INT8, field_6_0123456 CHAR, field_7_01234567 BOOL ARRAY, field_8_012345678 INT64, field_9_0123456789 INT16, field_10_0 UINT8 ARRAY)");
      /* 877 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 UINT32 ARRAY, field_3_0123 HIRESTIME, field_4_01234 DATE ARRAY, field_5_012345 HIRESTIME, field_6_0123456 RICHREAL, field_7_01234567 DATETIME, field_8_012345678 BOOL, field_9_0123456789 INT16, field_10_0 UINT32 ARRAY, field_11_01 UINT32, field_12_012 INT32, field_13_0123 INT64, field_14_01234 DATETIME, field_15_012345 INT16, field_16_0123456 UINT8, field_17_01234567 UINT32, field_18_012345678 HIRESTIME, field_19_0123456789 INT16, field_20_0 INT8, field_21_01 INT8, field_22_012 CHAR, field_23_0123 BOOL, field_24_01234 HIRESTIME, field_25_012345 UINT8, field_26_0123456 UINT8, field_27_01234567 DATE, field_28_012345678 INT16, field_29_0123456789 UINT64, field_30_0 DATETIME ARRAY, field_31_01 UINT8 ARRAY, field_32_012 INT8 ARRAY, field_33_0123 UINT32, field_34_01234 UINT64, field_35_012345 RICHREAL, field_36_0123456 DATETIME, field_37_01234567 REAL, field_38_012345678 CHAR, field_39_0123456789 UINT64, field_40_0 UINT16, field_41_01 INT16, field_42_012 INT8, field_43_0123 HIRESTIME, field_44_01234 UINT32, field_45_012345 DATE, field_46_0123456 INT32, field_47_01234567 REAL, field_48_012345678 UINT8, field_49_0123456789 REAL, field_50_0 BOOL ARRAY, field_51_01 INT8, field_52_012 HIRESTIME, field_53_0123 UINT32, field_54_01234 UINT32, field_55_012345 CHAR, field_56_0123456 INT8, field_57_01234567 BOOL, field_58_012345678 INT8, field_59_0123456789 UINT16, field_60_0 DATETIME, field_61_01 BOOL, field_62_012 INT64, field_63_0123 HIRESTIME, field_64_01234 INT32, field_65_012345 CHAR, field_66_0123456 DATE, field_67_01234567 UINT64, field_68_012345678 DATETIME ARRAY, field_69_0123456789 DATE, field_70_0 UINT32, field_71_01 RICHREAL, field_72_012 RICHREAL, field_73_0123 INT16 ARRAY, field_74_01234 DATETIME, field_75_012345 INT32, field_76_0123456 DATETIME, field_77_01234567 UINT8, field_78_012345678 UINT32, field_79_0123456789 INT32, field_80_0 DATETIME, field_81_01 INT32, field_82_012 DATE ARRAY, field_83_0123 INT8 ARRAY, field_84_01234 UINT64, field_85_012345 REAL, field_86_0123456 UINT64 ARRAY, field_87_01234567 REAL)");
      /* 878 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 INT16, field_3_0123 DATE, field_4_01234 DATETIME, field_5_012345 RICHREAL, field_6_0123456 UINT16, field_7_01234567 HIRESTIME, field_8_012345678 DATETIME, field_9_0123456789 REAL, field_10_0 CHAR, field_11_01 UINT16 ARRAY, field_12_012 INT32, field_13_0123 DATE, field_14_01234 INT8, field_15_012345 UINT32, field_16_0123456 INT32, field_17_01234567 INT32, field_18_012345678 DATE, field_19_0123456789 DATE, field_20_0 HIRESTIME, field_21_01 BOOL, field_22_012 UINT64, field_23_0123 DATE, field_24_01234 CHAR, field_25_012345 UINT32, field_26_0123456 HIRESTIME, field_27_01234567 DATETIME, field_28_012345678 HIRESTIME ARRAY, field_29_0123456789 HIRESTIME, field_30_0 DATETIME, field_31_01 INT32, field_32_012 INT16, field_33_0123 DATETIME ARRAY, field_34_01234 UINT64, field_35_012345 INT64, field_36_0123456 INT32)");
      /* 879 */ glbTypes.push_back("TABLE(field_1_01 BOOL ARRAY, field_2_012 HIRESTIME, field_3_0123 UINT16, field_4_01234 UINT8, field_5_012345 UINT8, field_6_0123456 UINT8 ARRAY, field_7_01234567 REAL, field_8_012345678 REAL, field_9_0123456789 CHAR, field_10_0 CHAR, field_11_01 HIRESTIME, field_12_012 DATE, field_13_0123 INT8, field_14_01234 UINT16, field_15_012345 UINT64, field_16_0123456 UINT32, field_17_01234567 INT16, field_18_012345678 INT32, field_19_0123456789 UINT16, field_20_0 INT64 ARRAY, field_21_01 INT16, field_22_012 RICHREAL, field_23_0123 CHAR, field_24_01234 HIRESTIME, field_25_012345 UINT32, field_26_0123456 INT32, field_27_01234567 UINT32, field_28_012345678 UINT16, field_29_0123456789 UINT16, field_30_0 DATETIME ARRAY, field_31_01 UINT8 ARRAY, field_32_012 INT16, field_33_0123 INT32, field_34_01234 BOOL, field_35_012345 REAL, field_36_0123456 CHAR, field_37_01234567 UINT32 ARRAY, field_38_012345678 INT64, field_39_0123456789 BOOL, field_40_0 BOOL, field_41_01 DATE, field_42_012 UINT8, field_43_0123 INT8, field_44_01234 DATETIME, field_45_012345 INT32, field_46_0123456 INT8 ARRAY)");
      /* 880 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 UINT32, field_3_0123 HIRESTIME, field_4_01234 HIRESTIME, field_5_012345 DATE, field_6_0123456 UINT64, field_7_01234567 CHAR, field_8_012345678 INT64, field_9_0123456789 INT64, field_10_0 DATE ARRAY, field_11_01 DATETIME, field_12_012 DATETIME, field_13_0123 UINT64, field_14_01234 INT16, field_15_012345 INT32, field_16_0123456 CHAR, field_17_01234567 REAL, field_18_012345678 HIRESTIME, field_19_0123456789 HIRESTIME, field_20_0 INT16, field_21_01 INT32, field_22_012 INT16, field_23_0123 BOOL, field_24_01234 INT64, field_25_012345 UINT32, field_26_0123456 DATE ARRAY, field_27_01234567 UINT32 ARRAY, field_28_012345678 REAL, field_29_0123456789 CHAR, field_30_0 INT32 ARRAY, field_31_01 REAL)");
      /* 881 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 INT64, field_3_0123 CHAR, field_4_01234 INT32, field_5_012345 UINT16, field_6_0123456 INT16)");
      /* 882 */ glbTypes.push_back("TABLE(field_1_01 DATETIME ARRAY, field_2_012 CHAR, field_3_0123 INT64, field_4_01234 DATE, field_5_012345 HIRESTIME, field_6_0123456 UINT32 ARRAY, field_7_01234567 DATETIME ARRAY, field_8_012345678 HIRESTIME ARRAY, field_9_0123456789 UINT32, field_10_0 INT8, field_11_01 BOOL ARRAY, field_12_012 UINT8, field_13_0123 BOOL, field_14_01234 INT64, field_15_012345 UINT64, field_16_0123456 HIRESTIME, field_17_01234567 UINT16, field_18_012345678 UINT8, field_19_0123456789 DATETIME, field_20_0 REAL, field_21_01 INT64, field_22_012 UINT16, field_23_0123 RICHREAL, field_24_01234 UINT8 ARRAY, field_25_012345 INT32, field_26_0123456 INT16, field_27_01234567 RICHREAL, field_28_012345678 INT8, field_29_0123456789 RICHREAL ARRAY, field_30_0 INT8 ARRAY, field_31_01 CHAR, field_32_012 UINT16, field_33_0123 UINT8, field_34_01234 INT32 ARRAY, field_35_012345 UINT8, field_36_0123456 INT32, field_37_01234567 INT32, field_38_012345678 UINT64 ARRAY, field_39_0123456789 INT32, field_40_0 INT32, field_41_01 INT32, field_42_012 RICHREAL ARRAY, field_43_0123 INT8, field_44_01234 CHAR, field_45_012345 BOOL, field_46_0123456 RICHREAL ARRAY, field_47_01234567 INT64, field_48_012345678 INT16, field_49_0123456789 REAL ARRAY, field_50_0 RICHREAL ARRAY, field_51_01 UINT32, field_52_012 INT64, field_53_0123 INT64, field_54_01234 INT16, field_55_012345 UINT8, field_56_0123456 CHAR, field_57_01234567 HIRESTIME, field_58_012345678 UINT16, field_59_0123456789 CHAR ARRAY, field_60_0 REAL, field_61_01 RICHREAL ARRAY, field_62_012 INT64, field_63_0123 UINT8, field_64_01234 CHAR, field_65_012345 DATE, field_66_0123456 CHAR, field_67_01234567 UINT32, field_68_012345678 INT16 ARRAY, field_69_0123456789 INT16, field_70_0 REAL, field_71_01 UINT64, field_72_012 UINT16, field_73_0123 UINT32, field_74_01234 REAL, field_75_012345 UINT16, field_76_0123456 UINT8, field_77_01234567 DATETIME, field_78_012345678 UINT32, field_79_0123456789 INT64 ARRAY, field_80_0 RICHREAL ARRAY, field_81_01 DATETIME, field_82_012 UINT32, field_83_0123 INT8, field_84_01234 DATE, field_85_012345 INT8 ARRAY, field_86_0123456 INT16, field_87_01234567 INT32 ARRAY, field_88_012345678 INT8, field_89_0123456789 UINT8 ARRAY, field_90_0 HIRESTIME, field_91_01 UINT8)");
      /* 883 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 INT32, field_3_0123 INT8, field_4_01234 REAL, field_5_012345 UINT64, field_6_0123456 REAL, field_7_01234567 UINT32 ARRAY, field_8_012345678 DATE, field_9_0123456789 INT16, field_10_0 REAL, field_11_01 INT64, field_12_012 REAL, field_13_0123 DATE, field_14_01234 UINT16 ARRAY, field_15_012345 HIRESTIME, field_16_0123456 UINT16, field_17_01234567 UINT64, field_18_012345678 INT16, field_19_0123456789 HIRESTIME, field_20_0 UINT32 ARRAY, field_21_01 DATE, field_22_012 BOOL, field_23_0123 CHAR, field_24_01234 HIRESTIME, field_25_012345 INT16, field_26_0123456 INT32, field_27_01234567 INT64, field_28_012345678 INT32 ARRAY, field_29_0123456789 REAL, field_30_0 INT32, field_31_01 UINT64, field_32_012 DATE, field_33_0123 UINT8, field_34_01234 HIRESTIME ARRAY, field_35_012345 DATETIME, field_36_0123456 UINT16, field_37_01234567 BOOL, field_38_012345678 CHAR, field_39_0123456789 BOOL, field_40_0 UINT16, field_41_01 CHAR, field_42_012 INT16 ARRAY, field_43_0123 UINT32, field_44_01234 CHAR, field_45_012345 UINT16, field_46_0123456 UINT32, field_47_01234567 INT16, field_48_012345678 RICHREAL, field_49_0123456789 UINT16, field_50_0 INT32, field_51_01 INT32, field_52_012 HIRESTIME, field_53_0123 INT8, field_54_01234 INT32, field_55_012345 CHAR, field_56_0123456 HIRESTIME, field_57_01234567 HIRESTIME, field_58_012345678 UINT16 ARRAY, field_59_0123456789 INT64 ARRAY, field_60_0 INT64, field_61_01 UINT32, field_62_012 INT64, field_63_0123 CHAR, field_64_01234 UINT16 ARRAY, field_65_012345 REAL, field_66_0123456 UINT64, field_67_01234567 UINT16, field_68_012345678 HIRESTIME ARRAY, field_69_0123456789 INT32)");
      /* 884 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 DATETIME, field_3_0123 RICHREAL, field_4_01234 UINT64, field_5_012345 INT8, field_6_0123456 DATE, field_7_01234567 INT64, field_8_012345678 CHAR, field_9_0123456789 REAL, field_10_0 UINT8, field_11_01 UINT64, field_12_012 INT8, field_13_0123 REAL, field_14_01234 DATETIME, field_15_012345 CHAR, field_16_0123456 CHAR, field_17_01234567 RICHREAL, field_18_012345678 UINT64, field_19_0123456789 INT32 ARRAY, field_20_0 INT64, field_21_01 BOOL, field_22_012 INT64, field_23_0123 INT32, field_24_01234 INT32 ARRAY, field_25_012345 DATE, field_26_0123456 CHAR, field_27_01234567 DATETIME ARRAY, field_28_012345678 RICHREAL, field_29_0123456789 INT8, field_30_0 INT8 ARRAY, field_31_01 INT32, field_32_012 UINT32, field_33_0123 REAL ARRAY, field_34_01234 UINT16, field_35_012345 BOOL, field_36_0123456 INT8, field_37_01234567 DATE ARRAY, field_38_012345678 INT32, field_39_0123456789 UINT64, field_40_0 UINT16 ARRAY, field_41_01 UINT16, field_42_012 UINT32, field_43_0123 CHAR ARRAY, field_44_01234 RICHREAL, field_45_012345 BOOL, field_46_0123456 UINT16 ARRAY, field_47_01234567 INT16, field_48_012345678 INT64 ARRAY, field_49_0123456789 INT32, field_50_0 UINT8, field_51_01 UINT64, field_52_012 DATE ARRAY, field_53_0123 UINT8, field_54_01234 REAL, field_55_012345 DATETIME)");
      /* 885 */ glbTypes.push_back("TABLE(field_1_01 CHAR ARRAY, field_2_012 INT16, field_3_0123 DATE ARRAY, field_4_01234 BOOL, field_5_012345 RICHREAL, field_6_0123456 DATETIME, field_7_01234567 UINT64, field_8_012345678 HIRESTIME, field_9_0123456789 INT32, field_10_0 HIRESTIME ARRAY, field_11_01 INT8, field_12_012 HIRESTIME, field_13_0123 HIRESTIME, field_14_01234 INT8 ARRAY, field_15_012345 DATETIME, field_16_0123456 BOOL, field_17_01234567 INT64, field_18_012345678 RICHREAL ARRAY, field_19_0123456789 UINT32, field_20_0 CHAR, field_21_01 BOOL, field_22_012 INT8 ARRAY, field_23_0123 REAL, field_24_01234 INT64, field_25_012345 INT16 ARRAY, field_26_0123456 CHAR ARRAY, field_27_01234567 DATETIME ARRAY, field_28_012345678 UINT64, field_29_0123456789 CHAR, field_30_0 INT16, field_31_01 INT32, field_32_012 INT8, field_33_0123 RICHREAL, field_34_01234 CHAR, field_35_012345 CHAR, field_36_0123456 INT32, field_37_01234567 UINT32, field_38_012345678 INT8, field_39_0123456789 REAL, field_40_0 RICHREAL)");
      /* 886 */ glbTypes.push_back("TABLE(field_1_01 CHAR ARRAY, field_2_012 DATETIME, field_3_0123 INT32, field_4_01234 UINT16 ARRAY, field_5_012345 CHAR, field_6_0123456 DATETIME, field_7_01234567 INT8, field_8_012345678 INT16 ARRAY, field_9_0123456789 DATE, field_10_0 UINT32, field_11_01 HIRESTIME, field_12_012 UINT8 ARRAY, field_13_0123 UINT64, field_14_01234 CHAR, field_15_012345 UINT64, field_16_0123456 UINT16 ARRAY, field_17_01234567 BOOL ARRAY, field_18_012345678 DATE, field_19_0123456789 UINT64, field_20_0 BOOL, field_21_01 RICHREAL, field_22_012 UINT16, field_23_0123 INT32 ARRAY, field_24_01234 INT64, field_25_012345 DATETIME ARRAY, field_26_0123456 UINT32, field_27_01234567 UINT64, field_28_012345678 BOOL, field_29_0123456789 REAL, field_30_0 REAL, field_31_01 UINT32 ARRAY, field_32_012 DATE, field_33_0123 HIRESTIME ARRAY, field_34_01234 INT64, field_35_012345 INT8, field_36_0123456 UINT16, field_37_01234567 INT64, field_38_012345678 RICHREAL, field_39_0123456789 DATE, field_40_0 DATE, field_41_01 REAL, field_42_012 HIRESTIME, field_43_0123 INT16, field_44_01234 HIRESTIME ARRAY, field_45_012345 UINT64, field_46_0123456 CHAR, field_47_01234567 UINT64, field_48_012345678 CHAR, field_49_0123456789 INT64, field_50_0 INT16 ARRAY, field_51_01 INT32, field_52_012 INT16, field_53_0123 DATE, field_54_01234 INT8, field_55_012345 RICHREAL, field_56_0123456 BOOL, field_57_01234567 CHAR, field_58_012345678 UINT16, field_59_0123456789 UINT32, field_60_0 UINT64, field_61_01 HIRESTIME ARRAY, field_62_012 UINT16, field_63_0123 INT8, field_64_01234 HIRESTIME ARRAY)");
      /* 887 */ glbTypes.push_back("TABLE(field_1_01 UINT32 ARRAY, field_2_012 INT16)");
      /* 888 */ glbTypes.push_back("TABLE(field_1_01 UINT16 ARRAY, field_2_012 UINT8, field_3_0123 CHAR ARRAY, field_4_01234 CHAR ARRAY, field_5_012345 INT64, field_6_0123456 DATETIME, field_7_01234567 DATETIME, field_8_012345678 BOOL, field_9_0123456789 INT64 ARRAY, field_10_0 DATE, field_11_01 UINT8, field_12_012 UINT64, field_13_0123 HIRESTIME, field_14_01234 DATE ARRAY, field_15_012345 INT8, field_16_0123456 INT32, field_17_01234567 DATETIME, field_18_012345678 INT32, field_19_0123456789 INT64, field_20_0 DATE, field_21_01 INT64, field_22_012 DATE ARRAY, field_23_0123 DATE, field_24_01234 REAL, field_25_012345 CHAR ARRAY, field_26_0123456 CHAR, field_27_01234567 UINT32)");
      /* 889 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 RICHREAL, field_3_0123 INT16, field_4_01234 INT32, field_5_012345 CHAR, field_6_0123456 BOOL ARRAY, field_7_01234567 HIRESTIME, field_8_012345678 BOOL, field_9_0123456789 UINT32, field_10_0 CHAR ARRAY, field_11_01 UINT8, field_12_012 INT64, field_13_0123 INT8 ARRAY, field_14_01234 DATETIME ARRAY, field_15_012345 BOOL, field_16_0123456 UINT32, field_17_01234567 UINT16, field_18_012345678 REAL, field_19_0123456789 UINT8, field_20_0 UINT16, field_21_01 UINT64, field_22_012 RICHREAL, field_23_0123 INT32, field_24_01234 UINT64)");
      /* 890 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 UINT32, field_3_0123 BOOL ARRAY, field_4_01234 INT64, field_5_012345 UINT64, field_6_0123456 DATETIME, field_7_01234567 DATE, field_8_012345678 UINT32, field_9_0123456789 DATETIME, field_10_0 DATETIME, field_11_01 INT64, field_12_012 INT32, field_13_0123 DATE, field_14_01234 HIRESTIME ARRAY, field_15_012345 UINT16, field_16_0123456 RICHREAL ARRAY, field_17_01234567 DATE, field_18_012345678 UINT16, field_19_0123456789 DATETIME, field_20_0 RICHREAL, field_21_01 BOOL, field_22_012 DATE)");
      /* 891 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 HIRESTIME ARRAY, field_3_0123 RICHREAL ARRAY, field_4_01234 HIRESTIME, field_5_012345 INT32, field_6_0123456 INT8, field_7_01234567 UINT8 ARRAY, field_8_012345678 CHAR, field_9_0123456789 REAL, field_10_0 UINT16, field_11_01 UINT64 ARRAY, field_12_012 UINT8, field_13_0123 DATE ARRAY, field_14_01234 UINT8 ARRAY, field_15_012345 INT8, field_16_0123456 UINT64, field_17_01234567 RICHREAL ARRAY, field_18_012345678 DATE, field_19_0123456789 UINT8 ARRAY)");
      /* 892 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 UINT8, field_3_0123 BOOL ARRAY, field_4_01234 INT8 ARRAY, field_5_012345 UINT64, field_6_0123456 RICHREAL, field_7_01234567 INT16, field_8_012345678 INT16, field_9_0123456789 DATE ARRAY, field_10_0 HIRESTIME, field_11_01 INT32 ARRAY, field_12_012 UINT16, field_13_0123 DATETIME ARRAY, field_14_01234 UINT32, field_15_012345 DATE, field_16_0123456 INT64, field_17_01234567 DATE, field_18_012345678 REAL, field_19_0123456789 BOOL, field_20_0 HIRESTIME, field_21_01 RICHREAL, field_22_012 INT64 ARRAY, field_23_0123 RICHREAL, field_24_01234 UINT8, field_25_012345 UINT16, field_26_0123456 DATETIME, field_27_01234567 REAL, field_28_012345678 UINT32, field_29_0123456789 UINT8, field_30_0 UINT8, field_31_01 RICHREAL ARRAY, field_32_012 HIRESTIME, field_33_0123 DATETIME, field_34_01234 REAL ARRAY, field_35_012345 BOOL, field_36_0123456 HIRESTIME, field_37_01234567 INT8, field_38_012345678 DATE, field_39_0123456789 DATE ARRAY, field_40_0 BOOL, field_41_01 CHAR, field_42_012 DATETIME, field_43_0123 INT64, field_44_01234 BOOL, field_45_012345 RICHREAL, field_46_0123456 INT16, field_47_01234567 INT8, field_48_012345678 RICHREAL, field_49_0123456789 RICHREAL, field_50_0 INT16, field_51_01 INT16 ARRAY, field_52_012 REAL, field_53_0123 DATETIME, field_54_01234 HIRESTIME ARRAY, field_55_012345 UINT64, field_56_0123456 INT8 ARRAY, field_57_01234567 INT32, field_58_012345678 RICHREAL, field_59_0123456789 INT16, field_60_0 HIRESTIME, field_61_01 BOOL, field_62_012 HIRESTIME, field_63_0123 UINT8, field_64_01234 INT64, field_65_012345 DATETIME, field_66_0123456 BOOL, field_67_01234567 REAL ARRAY, field_68_012345678 RICHREAL, field_69_0123456789 DATE, field_70_0 CHAR, field_71_01 HIRESTIME)");
      /* 893 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 INT8, field_3_0123 HIRESTIME ARRAY, field_4_01234 REAL, field_5_012345 UINT32, field_6_0123456 UINT64, field_7_01234567 BOOL, field_8_012345678 BOOL, field_9_0123456789 DATE, field_10_0 UINT64 ARRAY, field_11_01 CHAR, field_12_012 INT32 ARRAY, field_13_0123 BOOL ARRAY, field_14_01234 HIRESTIME, field_15_012345 UINT16 ARRAY, field_16_0123456 UINT32 ARRAY, field_17_01234567 INT64, field_18_012345678 INT32, field_19_0123456789 UINT64, field_20_0 REAL, field_21_01 UINT32 ARRAY, field_22_012 INT32, field_23_0123 REAL, field_24_01234 INT32, field_25_012345 UINT64, field_26_0123456 UINT16, field_27_01234567 REAL, field_28_012345678 UINT16 ARRAY, field_29_0123456789 BOOL, field_30_0 INT32 ARRAY, field_31_01 INT32 ARRAY, field_32_012 DATETIME, field_33_0123 INT16 ARRAY, field_34_01234 CHAR ARRAY, field_35_012345 REAL, field_36_0123456 UINT32, field_37_01234567 UINT32, field_38_012345678 BOOL ARRAY, field_39_0123456789 INT64 ARRAY, field_40_0 HIRESTIME, field_41_01 UINT32, field_42_012 UINT16, field_43_0123 INT64, field_44_01234 INT64, field_45_012345 INT16, field_46_0123456 DATE ARRAY, field_47_01234567 UINT64 ARRAY, field_48_012345678 UINT64, field_49_0123456789 DATETIME, field_50_0 DATE, field_51_01 REAL, field_52_012 INT8, field_53_0123 DATETIME, field_54_01234 BOOL, field_55_012345 DATETIME, field_56_0123456 UINT64, field_57_01234567 INT64, field_58_012345678 DATETIME, field_59_0123456789 INT16, field_60_0 INT8, field_61_01 INT32 ARRAY, field_62_012 UINT32 ARRAY, field_63_0123 REAL, field_64_01234 REAL, field_65_012345 CHAR, field_66_0123456 REAL ARRAY, field_67_01234567 UINT16 ARRAY, field_68_012345678 REAL, field_69_0123456789 INT8, field_70_0 INT32, field_71_01 INT16, field_72_012 INT16, field_73_0123 INT64, field_74_01234 DATETIME, field_75_012345 INT16, field_76_0123456 DATE ARRAY, field_77_01234567 DATE, field_78_012345678 HIRESTIME, field_79_0123456789 UINT16, field_80_0 BOOL, field_81_01 UINT8, field_82_012 INT32, field_83_0123 UINT16, field_84_01234 HIRESTIME)");
      /* 894 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME ARRAY, field_2_012 UINT64, field_3_0123 INT16, field_4_01234 INT8, field_5_012345 CHAR, field_6_0123456 INT16, field_7_01234567 REAL, field_8_012345678 INT32 ARRAY, field_9_0123456789 INT8, field_10_0 UINT32, field_11_01 INT64 ARRAY)");
      /* 895 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 INT32 ARRAY, field_3_0123 HIRESTIME, field_4_01234 HIRESTIME, field_5_012345 INT32 ARRAY, field_6_0123456 HIRESTIME, field_7_01234567 UINT8, field_8_012345678 HIRESTIME, field_9_0123456789 REAL ARRAY, field_10_0 HIRESTIME, field_11_01 INT8, field_12_012 UINT32, field_13_0123 CHAR, field_14_01234 INT8, field_15_012345 HIRESTIME, field_16_0123456 REAL, field_17_01234567 INT8, field_18_012345678 BOOL, field_19_0123456789 INT8, field_20_0 CHAR, field_21_01 DATE, field_22_012 INT64, field_23_0123 INT64, field_24_01234 UINT8 ARRAY, field_25_012345 BOOL, field_26_0123456 INT64, field_27_01234567 REAL, field_28_012345678 UINT16, field_29_0123456789 CHAR, field_30_0 BOOL, field_31_01 BOOL ARRAY, field_32_012 REAL, field_33_0123 DATETIME, field_34_01234 UINT64, field_35_012345 CHAR, field_36_0123456 INT64, field_37_01234567 UINT16, field_38_012345678 INT16, field_39_0123456789 REAL, field_40_0 INT64, field_41_01 INT32, field_42_012 BOOL, field_43_0123 HIRESTIME, field_44_01234 UINT32 ARRAY, field_45_012345 INT64 ARRAY, field_46_0123456 UINT8 ARRAY, field_47_01234567 DATE, field_48_012345678 RICHREAL, field_49_0123456789 INT64, field_50_0 INT16, field_51_01 INT16, field_52_012 INT16 ARRAY, field_53_0123 RICHREAL, field_54_01234 UINT8, field_55_012345 INT16, field_56_0123456 HIRESTIME, field_57_01234567 DATETIME, field_58_012345678 RICHREAL, field_59_0123456789 DATETIME, field_60_0 REAL ARRAY, field_61_01 RICHREAL ARRAY, field_62_012 CHAR ARRAY, field_63_0123 INT16, field_64_01234 INT64 ARRAY, field_65_012345 DATETIME, field_66_0123456 DATE, field_67_01234567 HIRESTIME, field_68_012345678 CHAR, field_69_0123456789 DATE, field_70_0 DATETIME, field_71_01 INT64, field_72_012 INT8, field_73_0123 UINT16, field_74_01234 INT16 ARRAY)");
      /* 896 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 HIRESTIME, field_3_0123 DATE, field_4_01234 UINT32, field_5_012345 UINT64, field_6_0123456 INT8, field_7_01234567 BOOL, field_8_012345678 INT64, field_9_0123456789 INT64, field_10_0 INT8, field_11_01 DATE, field_12_012 UINT32 ARRAY, field_13_0123 INT16, field_14_01234 INT16, field_15_012345 INT64 ARRAY, field_16_0123456 HIRESTIME, field_17_01234567 INT8, field_18_012345678 INT16, field_19_0123456789 UINT16, field_20_0 UINT64, field_21_01 INT64, field_22_012 UINT32, field_23_0123 UINT8, field_24_01234 HIRESTIME ARRAY, field_25_012345 UINT16, field_26_0123456 REAL, field_27_01234567 UINT16, field_28_012345678 UINT64, field_29_0123456789 BOOL, field_30_0 BOOL ARRAY, field_31_01 INT16, field_32_012 INT8 ARRAY, field_33_0123 BOOL ARRAY, field_34_01234 UINT16, field_35_012345 UINT64, field_36_0123456 UINT32, field_37_01234567 DATETIME, field_38_012345678 INT16, field_39_0123456789 INT16 ARRAY, field_40_0 BOOL, field_41_01 BOOL, field_42_012 INT64 ARRAY, field_43_0123 BOOL ARRAY, field_44_01234 DATETIME, field_45_012345 CHAR, field_46_0123456 UINT8, field_47_01234567 UINT64, field_48_012345678 INT32, field_49_0123456789 INT16, field_50_0 INT32, field_51_01 RICHREAL, field_52_012 HIRESTIME, field_53_0123 CHAR, field_54_01234 UINT32, field_55_012345 UINT64, field_56_0123456 INT8 ARRAY, field_57_01234567 HIRESTIME, field_58_012345678 UINT32 ARRAY, field_59_0123456789 UINT64, field_60_0 UINT32, field_61_01 UINT8, field_62_012 INT32, field_63_0123 UINT8)");
      /* 897 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 DATETIME, field_3_0123 INT32 ARRAY, field_4_01234 INT16, field_5_012345 UINT16 ARRAY, field_6_0123456 CHAR, field_7_01234567 BOOL, field_8_012345678 INT16 ARRAY, field_9_0123456789 DATE ARRAY, field_10_0 REAL, field_11_01 RICHREAL, field_12_012 REAL, field_13_0123 INT32 ARRAY, field_14_01234 HIRESTIME, field_15_012345 DATE, field_16_0123456 HIRESTIME, field_17_01234567 INT32 ARRAY, field_18_012345678 UINT8, field_19_0123456789 CHAR, field_20_0 UINT64, field_21_01 INT8 ARRAY, field_22_012 REAL, field_23_0123 DATE, field_24_01234 BOOL ARRAY, field_25_012345 UINT8 ARRAY, field_26_0123456 INT64 ARRAY, field_27_01234567 INT16, field_28_012345678 INT64, field_29_0123456789 CHAR, field_30_0 HIRESTIME, field_31_01 DATETIME, field_32_012 UINT32, field_33_0123 REAL, field_34_01234 DATE, field_35_012345 DATETIME, field_36_0123456 HIRESTIME, field_37_01234567 UINT64, field_38_012345678 HIRESTIME, field_39_0123456789 HIRESTIME)");
      /* 898 */ glbTypes.push_back("TABLE(field_1_01 UINT8 ARRAY, field_2_012 INT64 ARRAY, field_3_0123 UINT8, field_4_01234 DATETIME, field_5_012345 UINT64, field_6_0123456 DATETIME, field_7_01234567 INT16, field_8_012345678 REAL, field_9_0123456789 REAL, field_10_0 HIRESTIME, field_11_01 INT32, field_12_012 UINT16, field_13_0123 CHAR, field_14_01234 UINT64, field_15_012345 HIRESTIME ARRAY, field_16_0123456 INT64 ARRAY, field_17_01234567 INT32, field_18_012345678 BOOL, field_19_0123456789 BOOL, field_20_0 UINT16, field_21_01 INT8, field_22_012 HIRESTIME, field_23_0123 HIRESTIME, field_24_01234 UINT64, field_25_012345 CHAR, field_26_0123456 INT32 ARRAY, field_27_01234567 INT8, field_28_012345678 UINT32, field_29_0123456789 RICHREAL, field_30_0 INT16 ARRAY, field_31_01 UINT8 ARRAY, field_32_012 UINT8, field_33_0123 BOOL ARRAY, field_34_01234 REAL, field_35_012345 RICHREAL, field_36_0123456 INT8, field_37_01234567 UINT16 ARRAY, field_38_012345678 DATE, field_39_0123456789 DATE, field_40_0 DATE, field_41_01 DATETIME, field_42_012 RICHREAL, field_43_0123 UINT32, field_44_01234 INT32, field_45_012345 DATE, field_46_0123456 UINT8, field_47_01234567 DATE, field_48_012345678 UINT8, field_49_0123456789 RICHREAL ARRAY, field_50_0 INT16 ARRAY, field_51_01 RICHREAL, field_52_012 REAL, field_53_0123 INT64, field_54_01234 UINT16, field_55_012345 CHAR, field_56_0123456 RICHREAL, field_57_01234567 INT8, field_58_012345678 HIRESTIME ARRAY, field_59_0123456789 CHAR, field_60_0 UINT16 ARRAY, field_61_01 DATETIME, field_62_012 INT32, field_63_0123 INT8, field_64_01234 BOOL, field_65_012345 UINT16, field_66_0123456 DATETIME, field_67_01234567 UINT32 ARRAY, field_68_012345678 BOOL, field_69_0123456789 UINT64, field_70_0 INT16, field_71_01 INT16, field_72_012 UINT64, field_73_0123 DATE, field_74_01234 UINT16 ARRAY, field_75_012345 DATE, field_76_0123456 DATE, field_77_01234567 UINT64, field_78_012345678 UINT16 ARRAY, field_79_0123456789 CHAR, field_80_0 REAL, field_81_01 DATE, field_82_012 INT16 ARRAY, field_83_0123 INT64 ARRAY, field_84_01234 INT16, field_85_012345 UINT32, field_86_0123456 UINT16, field_87_01234567 DATETIME)");
      /* 899 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 UINT16, field_3_0123 INT32 ARRAY, field_4_01234 CHAR, field_5_012345 INT32, field_6_0123456 DATETIME, field_7_01234567 UINT64, field_8_012345678 RICHREAL, field_9_0123456789 BOOL, field_10_0 UINT64, field_11_01 UINT16, field_12_012 UINT16 ARRAY, field_13_0123 UINT64, field_14_01234 UINT16, field_15_012345 REAL, field_16_0123456 HIRESTIME, field_17_01234567 UINT16, field_18_012345678 INT64, field_19_0123456789 CHAR, field_20_0 DATE ARRAY, field_21_01 DATE, field_22_012 INT32, field_23_0123 RICHREAL, field_24_01234 BOOL, field_25_012345 UINT64, field_26_0123456 HIRESTIME, field_27_01234567 INT32, field_28_012345678 BOOL, field_29_0123456789 INT32, field_30_0 REAL, field_31_01 INT32 ARRAY, field_32_012 INT64, field_33_0123 DATE, field_34_01234 HIRESTIME, field_35_012345 HIRESTIME ARRAY, field_36_0123456 UINT64, field_37_01234567 CHAR, field_38_012345678 RICHREAL, field_39_0123456789 UINT8, field_40_0 INT8, field_41_01 BOOL, field_42_012 INT16, field_43_0123 INT64, field_44_01234 HIRESTIME, field_45_012345 UINT8, field_46_0123456 BOOL, field_47_01234567 INT16, field_48_012345678 DATE, field_49_0123456789 REAL ARRAY, field_50_0 DATETIME ARRAY, field_51_01 INT8, field_52_012 UINT16, field_53_0123 INT64, field_54_01234 RICHREAL, field_55_012345 BOOL, field_56_0123456 BOOL, field_57_01234567 CHAR, field_58_012345678 REAL, field_59_0123456789 INT64, field_60_0 CHAR, field_61_01 RICHREAL, field_62_012 UINT8, field_63_0123 UINT64, field_64_01234 DATETIME, field_65_012345 DATETIME, field_66_0123456 BOOL, field_67_01234567 INT16, field_68_012345678 INT16, field_69_0123456789 INT16, field_70_0 INT8 ARRAY, field_71_01 HIRESTIME, field_72_012 UINT16, field_73_0123 INT32 ARRAY, field_74_01234 BOOL, field_75_012345 BOOL, field_76_0123456 INT16 ARRAY, field_77_01234567 UINT64, field_78_012345678 RICHREAL, field_79_0123456789 CHAR, field_80_0 RICHREAL, field_81_01 REAL, field_82_012 INT32, field_83_0123 DATE, field_84_01234 INT32, field_85_012345 DATETIME ARRAY, field_86_0123456 CHAR, field_87_01234567 RICHREAL ARRAY, field_88_012345678 UINT32, field_89_0123456789 INT16)");
      /* 900 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 RICHREAL, field_3_0123 INT32, field_4_01234 UINT32, field_5_012345 UINT8, field_6_0123456 UINT64, field_7_01234567 INT64 ARRAY, field_8_012345678 RICHREAL, field_9_0123456789 UINT64 ARRAY, field_10_0 UINT8, field_11_01 DATE, field_12_012 DATE ARRAY, field_13_0123 INT16, field_14_01234 INT8, field_15_012345 UINT16, field_16_0123456 RICHREAL ARRAY, field_17_01234567 UINT8 ARRAY, field_18_012345678 RICHREAL ARRAY, field_19_0123456789 UINT64, field_20_0 CHAR, field_21_01 INT16, field_22_012 DATETIME, field_23_0123 DATETIME, field_24_01234 INT32, field_25_012345 UINT16, field_26_0123456 UINT8, field_27_01234567 BOOL, field_28_012345678 INT64, field_29_0123456789 INT64 ARRAY, field_30_0 RICHREAL ARRAY, field_31_01 INT16, field_32_012 DATE, field_33_0123 RICHREAL, field_34_01234 CHAR, field_35_012345 INT64, field_36_0123456 HIRESTIME ARRAY, field_37_01234567 UINT8)");
      /* 901 */ glbTypes.push_back("TABLE(field_1_01 DATE ARRAY, field_2_012 CHAR ARRAY, field_3_0123 HIRESTIME, field_4_01234 INT8 ARRAY, field_5_012345 UINT32, field_6_0123456 DATE, field_7_01234567 RICHREAL, field_8_012345678 UINT8, field_9_0123456789 UINT64, field_10_0 BOOL ARRAY, field_11_01 DATETIME, field_12_012 BOOL, field_13_0123 INT64, field_14_01234 UINT64, field_15_012345 CHAR, field_16_0123456 HIRESTIME ARRAY, field_17_01234567 BOOL ARRAY, field_18_012345678 HIRESTIME, field_19_0123456789 DATETIME, field_20_0 BOOL, field_21_01 UINT16, field_22_012 INT32 ARRAY, field_23_0123 DATETIME, field_24_01234 UINT8, field_25_012345 REAL ARRAY, field_26_0123456 INT32, field_27_01234567 INT32, field_28_012345678 DATE ARRAY, field_29_0123456789 BOOL)");
      /* 902 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 BOOL, field_3_0123 UINT64, field_4_01234 INT32, field_5_012345 CHAR, field_6_0123456 UINT8, field_7_01234567 DATE, field_8_012345678 DATETIME, field_9_0123456789 CHAR, field_10_0 INT8, field_11_01 INT32 ARRAY, field_12_012 INT32 ARRAY, field_13_0123 UINT32, field_14_01234 INT64, field_15_012345 INT16, field_16_0123456 UINT64, field_17_01234567 DATE ARRAY, field_18_012345678 HIRESTIME, field_19_0123456789 UINT64 ARRAY, field_20_0 INT32 ARRAY, field_21_01 DATETIME, field_22_012 INT8, field_23_0123 DATETIME ARRAY, field_24_01234 UINT32, field_25_012345 DATETIME, field_26_0123456 HIRESTIME, field_27_01234567 BOOL, field_28_012345678 INT32, field_29_0123456789 HIRESTIME, field_30_0 BOOL ARRAY, field_31_01 UINT32, field_32_012 DATE, field_33_0123 INT16, field_34_01234 BOOL, field_35_012345 HIRESTIME, field_36_0123456 INT8, field_37_01234567 INT64, field_38_012345678 DATE, field_39_0123456789 UINT16, field_40_0 RICHREAL, field_41_01 INT64 ARRAY, field_42_012 HIRESTIME, field_43_0123 DATETIME ARRAY, field_44_01234 INT32, field_45_012345 DATETIME, field_46_0123456 UINT8 ARRAY, field_47_01234567 RICHREAL, field_48_012345678 INT16, field_49_0123456789 UINT64, field_50_0 DATETIME, field_51_01 INT32, field_52_012 DATE, field_53_0123 INT64, field_54_01234 INT64, field_55_012345 REAL, field_56_0123456 INT8, field_57_01234567 UINT16, field_58_012345678 BOOL, field_59_0123456789 BOOL, field_60_0 CHAR, field_61_01 INT16, field_62_012 REAL, field_63_0123 INT64, field_64_01234 UINT16, field_65_012345 UINT16 ARRAY, field_66_0123456 INT64, field_67_01234567 UINT32 ARRAY, field_68_012345678 HIRESTIME, field_69_0123456789 RICHREAL, field_70_0 DATE, field_71_01 INT64, field_72_012 DATETIME ARRAY, field_73_0123 RICHREAL, field_74_01234 INT8, field_75_012345 RICHREAL, field_76_0123456 INT8, field_77_01234567 RICHREAL, field_78_012345678 UINT64 ARRAY, field_79_0123456789 DATETIME ARRAY)");
      /* 903 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 REAL, field_3_0123 UINT32, field_4_01234 INT8, field_5_012345 DATE, field_6_0123456 RICHREAL, field_7_01234567 RICHREAL, field_8_012345678 INT32, field_9_0123456789 BOOL, field_10_0 INT32, field_11_01 UINT64 ARRAY, field_12_012 DATETIME, field_13_0123 INT16, field_14_01234 DATETIME ARRAY, field_15_012345 UINT8, field_16_0123456 INT16, field_17_01234567 UINT8, field_18_012345678 UINT32, field_19_0123456789 DATETIME, field_20_0 UINT64 ARRAY, field_21_01 UINT8, field_22_012 DATE, field_23_0123 BOOL, field_24_01234 HIRESTIME, field_25_012345 RICHREAL)");
      /* 904 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 REAL ARRAY, field_3_0123 INT16, field_4_01234 INT32, field_5_012345 INT16 ARRAY, field_6_0123456 INT8, field_7_01234567 CHAR ARRAY, field_8_012345678 UINT64, field_9_0123456789 UINT16, field_10_0 BOOL, field_11_01 BOOL, field_12_012 CHAR, field_13_0123 CHAR, field_14_01234 REAL, field_15_012345 INT16, field_16_0123456 INT8 ARRAY, field_17_01234567 UINT64, field_18_012345678 REAL ARRAY, field_19_0123456789 INT8, field_20_0 INT64, field_21_01 CHAR ARRAY, field_22_012 DATETIME, field_23_0123 INT16, field_24_01234 INT32, field_25_012345 INT32, field_26_0123456 CHAR ARRAY, field_27_01234567 UINT64, field_28_012345678 UINT32, field_29_0123456789 DATETIME, field_30_0 RICHREAL, field_31_01 UINT32, field_32_012 REAL, field_33_0123 INT32 ARRAY, field_34_01234 INT8, field_35_012345 UINT64 ARRAY, field_36_0123456 INT64, field_37_01234567 CHAR, field_38_012345678 DATE, field_39_0123456789 HIRESTIME, field_40_0 HIRESTIME, field_41_01 UINT64 ARRAY, field_42_012 RICHREAL, field_43_0123 CHAR ARRAY, field_44_01234 DATETIME ARRAY, field_45_012345 UINT16, field_46_0123456 UINT64, field_47_01234567 CHAR ARRAY, field_48_012345678 INT16, field_49_0123456789 RICHREAL, field_50_0 REAL, field_51_01 INT64, field_52_012 INT32, field_53_0123 RICHREAL, field_54_01234 INT32 ARRAY, field_55_012345 INT16 ARRAY, field_56_0123456 INT16 ARRAY, field_57_01234567 INT8 ARRAY, field_58_012345678 RICHREAL, field_59_0123456789 RICHREAL ARRAY)");
      /* 905 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 INT8, field_3_0123 UINT64, field_4_01234 DATE, field_5_012345 DATE, field_6_0123456 INT16, field_7_01234567 BOOL, field_8_012345678 UINT8 ARRAY, field_9_0123456789 INT8, field_10_0 INT8, field_11_01 DATETIME, field_12_012 UINT16, field_13_0123 RICHREAL, field_14_01234 DATETIME, field_15_012345 DATE, field_16_0123456 RICHREAL, field_17_01234567 RICHREAL, field_18_012345678 CHAR ARRAY, field_19_0123456789 DATE ARRAY, field_20_0 INT32, field_21_01 UINT8, field_22_012 BOOL, field_23_0123 CHAR, field_24_01234 INT64, field_25_012345 INT8, field_26_0123456 UINT32, field_27_01234567 INT64 ARRAY, field_28_012345678 INT32 ARRAY, field_29_0123456789 RICHREAL, field_30_0 INT16, field_31_01 RICHREAL, field_32_012 INT16, field_33_0123 DATE, field_34_01234 UINT8, field_35_012345 UINT8, field_36_0123456 UINT8, field_37_01234567 CHAR, field_38_012345678 UINT16, field_39_0123456789 UINT8 ARRAY, field_40_0 INT32, field_41_01 BOOL)");
      /* 906 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 HIRESTIME, field_3_0123 INT16, field_4_01234 UINT32, field_5_012345 UINT32 ARRAY, field_6_0123456 DATE, field_7_01234567 INT16, field_8_012345678 HIRESTIME, field_9_0123456789 REAL, field_10_0 DATETIME, field_11_01 DATETIME, field_12_012 UINT32 ARRAY, field_13_0123 UINT64, field_14_01234 DATE ARRAY, field_15_012345 BOOL, field_16_0123456 INT8, field_17_01234567 DATETIME, field_18_012345678 INT64, field_19_0123456789 UINT16, field_20_0 HIRESTIME, field_21_01 CHAR, field_22_012 HIRESTIME, field_23_0123 CHAR, field_24_01234 INT32, field_25_012345 UINT16, field_26_0123456 HIRESTIME)");
      /* 907 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 UINT8, field_3_0123 INT64, field_4_01234 UINT8, field_5_012345 DATETIME ARRAY, field_6_0123456 INT32, field_7_01234567 INT8, field_8_012345678 DATE ARRAY, field_9_0123456789 CHAR, field_10_0 INT32, field_11_01 REAL ARRAY, field_12_012 INT8, field_13_0123 RICHREAL ARRAY, field_14_01234 UINT32, field_15_012345 INT64, field_16_0123456 INT64 ARRAY, field_17_01234567 HIRESTIME, field_18_012345678 INT32, field_19_0123456789 INT32, field_20_0 RICHREAL, field_21_01 DATETIME, field_22_012 RICHREAL, field_23_0123 DATETIME ARRAY, field_24_01234 INT64, field_25_012345 DATE, field_26_0123456 DATE)");
      /* 908 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 DATE, field_3_0123 BOOL ARRAY, field_4_01234 UINT8, field_5_012345 INT16 ARRAY, field_6_0123456 CHAR, field_7_01234567 INT8, field_8_012345678 INT16 ARRAY, field_9_0123456789 INT8, field_10_0 INT8 ARRAY, field_11_01 HIRESTIME, field_12_012 INT8, field_13_0123 UINT64 ARRAY, field_14_01234 UINT16, field_15_012345 DATETIME, field_16_0123456 REAL, field_17_01234567 DATETIME ARRAY, field_18_012345678 HIRESTIME ARRAY, field_19_0123456789 UINT8, field_20_0 RICHREAL ARRAY, field_21_01 BOOL, field_22_012 REAL ARRAY, field_23_0123 CHAR, field_24_01234 DATETIME ARRAY, field_25_012345 BOOL ARRAY, field_26_0123456 UINT64, field_27_01234567 INT8, field_28_012345678 RICHREAL ARRAY, field_29_0123456789 DATETIME, field_30_0 BOOL, field_31_01 INT64, field_32_012 INT64, field_33_0123 DATE, field_34_01234 INT64 ARRAY, field_35_012345 HIRESTIME ARRAY, field_36_0123456 UINT8 ARRAY, field_37_01234567 CHAR, field_38_012345678 CHAR, field_39_0123456789 UINT64, field_40_0 UINT64, field_41_01 UINT8, field_42_012 DATETIME, field_43_0123 UINT32, field_44_01234 UINT32, field_45_012345 UINT32 ARRAY, field_46_0123456 HIRESTIME, field_47_01234567 INT8, field_48_012345678 UINT64, field_49_0123456789 BOOL ARRAY, field_50_0 CHAR, field_51_01 REAL, field_52_012 BOOL, field_53_0123 INT64, field_54_01234 INT64, field_55_012345 CHAR, field_56_0123456 INT64, field_57_01234567 INT16, field_58_012345678 DATE, field_59_0123456789 CHAR ARRAY, field_60_0 UINT8, field_61_01 UINT16, field_62_012 REAL, field_63_0123 RICHREAL, field_64_01234 DATETIME, field_65_012345 INT8 ARRAY, field_66_0123456 UINT8)");
      /* 909 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 INT64 ARRAY, field_3_0123 CHAR, field_4_01234 HIRESTIME, field_5_012345 CHAR, field_6_0123456 UINT32, field_7_01234567 CHAR, field_8_012345678 INT32, field_9_0123456789 DATE, field_10_0 UINT32, field_11_01 DATETIME, field_12_012 DATETIME, field_13_0123 UINT64, field_14_01234 DATETIME, field_15_012345 INT64, field_16_0123456 UINT64, field_17_01234567 INT32, field_18_012345678 HIRESTIME, field_19_0123456789 HIRESTIME, field_20_0 UINT32 ARRAY, field_21_01 INT16, field_22_012 UINT64, field_23_0123 DATETIME)");
      /* 910 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 REAL, field_3_0123 UINT8, field_4_01234 RICHREAL ARRAY, field_5_012345 UINT64 ARRAY, field_6_0123456 DATE, field_7_01234567 UINT16, field_8_012345678 UINT16 ARRAY, field_9_0123456789 CHAR ARRAY, field_10_0 INT16, field_11_01 DATETIME, field_12_012 UINT64, field_13_0123 INT16, field_14_01234 DATETIME, field_15_012345 DATE, field_16_0123456 UINT8 ARRAY, field_17_01234567 INT8, field_18_012345678 INT8, field_19_0123456789 INT8, field_20_0 UINT16, field_21_01 INT16, field_22_012 INT16, field_23_0123 INT16, field_24_01234 DATETIME, field_25_012345 REAL, field_26_0123456 INT16, field_27_01234567 DATE, field_28_012345678 INT8, field_29_0123456789 INT8, field_30_0 UINT8, field_31_01 UINT16 ARRAY, field_32_012 INT16, field_33_0123 INT64, field_34_01234 UINT32, field_35_012345 INT8, field_36_0123456 REAL, field_37_01234567 UINT32, field_38_012345678 BOOL, field_39_0123456789 INT32, field_40_0 INT64, field_41_01 CHAR ARRAY, field_42_012 CHAR ARRAY, field_43_0123 BOOL, field_44_01234 INT16, field_45_012345 UINT64 ARRAY, field_46_0123456 BOOL, field_47_01234567 CHAR, field_48_012345678 CHAR, field_49_0123456789 UINT32 ARRAY, field_50_0 DATETIME, field_51_01 UINT16, field_52_012 HIRESTIME, field_53_0123 BOOL, field_54_01234 INT64, field_55_012345 INT64, field_56_0123456 DATETIME, field_57_01234567 BOOL ARRAY, field_58_012345678 UINT32, field_59_0123456789 INT32 ARRAY, field_60_0 UINT32 ARRAY, field_61_01 DATE, field_62_012 INT64, field_63_0123 UINT64, field_64_01234 RICHREAL ARRAY, field_65_012345 CHAR, field_66_0123456 UINT32, field_67_01234567 RICHREAL, field_68_012345678 HIRESTIME, field_69_0123456789 INT64, field_70_0 UINT32, field_71_01 DATE, field_72_012 BOOL ARRAY, field_73_0123 HIRESTIME, field_74_01234 UINT32, field_75_012345 DATETIME, field_76_0123456 INT64, field_77_01234567 INT32, field_78_012345678 UINT64, field_79_0123456789 UINT64, field_80_0 UINT64, field_81_01 DATE, field_82_012 REAL)");
      /* 911 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 INT16, field_3_0123 UINT16, field_4_01234 RICHREAL, field_5_012345 INT32, field_6_0123456 DATE, field_7_01234567 DATE, field_8_012345678 DATETIME, field_9_0123456789 INT32, field_10_0 UINT64, field_11_01 INT64, field_12_012 UINT8, field_13_0123 RICHREAL, field_14_01234 UINT16, field_15_012345 RICHREAL, field_16_0123456 UINT32 ARRAY, field_17_01234567 DATE, field_18_012345678 UINT16, field_19_0123456789 REAL, field_20_0 INT64, field_21_01 HIRESTIME ARRAY, field_22_012 DATETIME, field_23_0123 INT16, field_24_01234 INT16, field_25_012345 UINT64, field_26_0123456 INT64, field_27_01234567 REAL ARRAY, field_28_012345678 RICHREAL, field_29_0123456789 INT16, field_30_0 UINT16, field_31_01 UINT16, field_32_012 DATETIME, field_33_0123 UINT64, field_34_01234 INT64, field_35_012345 RICHREAL ARRAY, field_36_0123456 INT64, field_37_01234567 DATE, field_38_012345678 CHAR, field_39_0123456789 UINT8 ARRAY, field_40_0 INT16, field_41_01 INT32, field_42_012 REAL, field_43_0123 UINT8, field_44_01234 UINT64 ARRAY, field_45_012345 HIRESTIME, field_46_0123456 HIRESTIME, field_47_01234567 REAL, field_48_012345678 UINT16 ARRAY, field_49_0123456789 INT8, field_50_0 INT8, field_51_01 CHAR, field_52_012 DATETIME ARRAY, field_53_0123 INT64, field_54_01234 UINT16 ARRAY, field_55_012345 INT8, field_56_0123456 REAL ARRAY, field_57_01234567 INT32, field_58_012345678 CHAR, field_59_0123456789 UINT32, field_60_0 INT8 ARRAY, field_61_01 DATETIME ARRAY, field_62_012 HIRESTIME, field_63_0123 DATETIME, field_64_01234 UINT16 ARRAY, field_65_012345 INT16, field_66_0123456 INT16, field_67_01234567 INT8, field_68_012345678 HIRESTIME, field_69_0123456789 REAL, field_70_0 INT16, field_71_01 INT16, field_72_012 INT8, field_73_0123 INT32 ARRAY, field_74_01234 HIRESTIME, field_75_012345 INT64, field_76_0123456 CHAR, field_77_01234567 HIRESTIME, field_78_012345678 DATETIME, field_79_0123456789 INT8, field_80_0 INT32, field_81_01 INT64, field_82_012 INT8, field_83_0123 CHAR ARRAY, field_84_01234 RICHREAL, field_85_012345 INT64, field_86_0123456 INT16, field_87_01234567 DATE ARRAY, field_88_012345678 UINT64, field_89_0123456789 INT32, field_90_0 DATETIME, field_91_01 UINT32, field_92_012 RICHREAL, field_93_0123 INT64 ARRAY, field_94_01234 INT32)");
      /* 912 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 UINT32, field_3_0123 HIRESTIME, field_4_01234 UINT16, field_5_012345 REAL, field_6_0123456 DATETIME, field_7_01234567 RICHREAL, field_8_012345678 UINT8, field_9_0123456789 UINT32, field_10_0 INT16 ARRAY, field_11_01 INT64, field_12_012 REAL, field_13_0123 CHAR, field_14_01234 CHAR, field_15_012345 DATETIME, field_16_0123456 REAL, field_17_01234567 UINT64, field_18_012345678 UINT16, field_19_0123456789 INT8, field_20_0 CHAR, field_21_01 DATE, field_22_012 UINT64 ARRAY, field_23_0123 UINT8, field_24_01234 UINT8, field_25_012345 INT16, field_26_0123456 RICHREAL, field_27_01234567 REAL, field_28_012345678 UINT16, field_29_0123456789 DATETIME ARRAY, field_30_0 INT16)");
      /* 913 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 INT8 ARRAY, field_3_0123 BOOL, field_4_01234 INT64 ARRAY, field_5_012345 INT16 ARRAY, field_6_0123456 CHAR, field_7_01234567 INT16, field_8_012345678 INT16, field_9_0123456789 UINT16, field_10_0 INT32, field_11_01 INT64, field_12_012 CHAR, field_13_0123 DATETIME, field_14_01234 REAL, field_15_012345 CHAR ARRAY, field_16_0123456 DATETIME, field_17_01234567 UINT16, field_18_012345678 CHAR, field_19_0123456789 UINT16, field_20_0 UINT32, field_21_01 INT8, field_22_012 REAL, field_23_0123 INT8, field_24_01234 INT64, field_25_012345 INT16, field_26_0123456 UINT64, field_27_01234567 UINT64, field_28_012345678 UINT8, field_29_0123456789 INT64 ARRAY, field_30_0 UINT8)");
      /* 914 */ glbTypes.push_back("TABLE(field_1_01 CHAR ARRAY, field_2_012 UINT16, field_3_0123 BOOL, field_4_01234 UINT64 ARRAY, field_5_012345 UINT32, field_6_0123456 INT16, field_7_01234567 INT64, field_8_012345678 RICHREAL, field_9_0123456789 HIRESTIME, field_10_0 INT32, field_11_01 DATE, field_12_012 INT8, field_13_0123 HIRESTIME, field_14_01234 UINT64, field_15_012345 DATE, field_16_0123456 CHAR, field_17_01234567 INT32 ARRAY, field_18_012345678 CHAR)");
      /* 915 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 HIRESTIME ARRAY, field_3_0123 DATE ARRAY, field_4_01234 INT32 ARRAY, field_5_012345 REAL ARRAY, field_6_0123456 INT32, field_7_01234567 CHAR, field_8_012345678 DATETIME, field_9_0123456789 INT16, field_10_0 UINT8 ARRAY, field_11_01 RICHREAL, field_12_012 UINT64, field_13_0123 INT32, field_14_01234 INT64, field_15_012345 HIRESTIME, field_16_0123456 RICHREAL, field_17_01234567 INT8, field_18_012345678 DATE, field_19_0123456789 UINT8, field_20_0 DATE, field_21_01 DATETIME, field_22_012 DATE ARRAY, field_23_0123 UINT16, field_24_01234 REAL, field_25_012345 INT32 ARRAY, field_26_0123456 DATETIME, field_27_01234567 UINT64, field_28_012345678 INT32, field_29_0123456789 INT32 ARRAY, field_30_0 INT64, field_31_01 INT8, field_32_012 DATE ARRAY, field_33_0123 UINT64 ARRAY, field_34_01234 BOOL, field_35_012345 INT8, field_36_0123456 UINT32)");
      /* 916 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 RICHREAL, field_3_0123 UINT16, field_4_01234 INT8, field_5_012345 DATE, field_6_0123456 HIRESTIME, field_7_01234567 CHAR, field_8_012345678 UINT32, field_9_0123456789 BOOL, field_10_0 BOOL, field_11_01 INT16, field_12_012 REAL, field_13_0123 UINT16, field_14_01234 BOOL, field_15_012345 INT8, field_16_0123456 DATETIME, field_17_01234567 REAL, field_18_012345678 REAL ARRAY, field_19_0123456789 BOOL, field_20_0 UINT32, field_21_01 INT16 ARRAY, field_22_012 DATE ARRAY, field_23_0123 UINT16, field_24_01234 UINT16, field_25_012345 HIRESTIME, field_26_0123456 BOOL, field_27_01234567 HIRESTIME, field_28_012345678 BOOL ARRAY, field_29_0123456789 DATE, field_30_0 INT64 ARRAY, field_31_01 UINT32, field_32_012 CHAR, field_33_0123 INT8, field_34_01234 INT8, field_35_012345 INT64, field_36_0123456 INT64, field_37_01234567 UINT64, field_38_012345678 UINT32, field_39_0123456789 UINT16 ARRAY, field_40_0 HIRESTIME, field_41_01 DATETIME, field_42_012 INT8, field_43_0123 DATE ARRAY, field_44_01234 INT8, field_45_012345 INT32, field_46_0123456 INT64, field_47_01234567 INT16, field_48_012345678 INT32, field_49_0123456789 BOOL, field_50_0 CHAR, field_51_01 HIRESTIME, field_52_012 UINT64, field_53_0123 BOOL ARRAY, field_54_01234 INT16 ARRAY, field_55_012345 BOOL, field_56_0123456 DATE, field_57_01234567 INT32)");
      /* 917 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 UINT16, field_3_0123 UINT64, field_4_01234 DATE, field_5_012345 BOOL, field_6_0123456 INT8, field_7_01234567 CHAR, field_8_012345678 UINT32, field_9_0123456789 BOOL ARRAY, field_10_0 INT64 ARRAY, field_11_01 UINT8, field_12_012 BOOL, field_13_0123 UINT32, field_14_01234 INT64, field_15_012345 BOOL, field_16_0123456 HIRESTIME, field_17_01234567 INT16, field_18_012345678 INT64, field_19_0123456789 RICHREAL ARRAY, field_20_0 DATE, field_21_01 INT32 ARRAY, field_22_012 BOOL, field_23_0123 UINT64, field_24_01234 INT16, field_25_012345 UINT32, field_26_0123456 CHAR ARRAY, field_27_01234567 BOOL ARRAY, field_28_012345678 UINT8, field_29_0123456789 DATETIME, field_30_0 DATE ARRAY, field_31_01 INT32, field_32_012 RICHREAL, field_33_0123 UINT8 ARRAY, field_34_01234 INT8, field_35_012345 CHAR, field_36_0123456 UINT64, field_37_01234567 CHAR ARRAY, field_38_012345678 UINT64, field_39_0123456789 BOOL ARRAY, field_40_0 INT64, field_41_01 BOOL ARRAY, field_42_012 DATETIME, field_43_0123 REAL, field_44_01234 INT64, field_45_012345 UINT64, field_46_0123456 DATE, field_47_01234567 BOOL, field_48_012345678 BOOL ARRAY, field_49_0123456789 REAL, field_50_0 DATE, field_51_01 UINT8, field_52_012 INT32, field_53_0123 BOOL, field_54_01234 UINT8, field_55_012345 DATE, field_56_0123456 UINT32, field_57_01234567 INT8, field_58_012345678 REAL ARRAY, field_59_0123456789 RICHREAL, field_60_0 BOOL, field_61_01 UINT64, field_62_012 UINT16, field_63_0123 RICHREAL, field_64_01234 BOOL, field_65_012345 HIRESTIME, field_66_0123456 INT8, field_67_01234567 INT16, field_68_012345678 INT16, field_69_0123456789 INT32, field_70_0 BOOL, field_71_01 BOOL, field_72_012 DATETIME, field_73_0123 DATE, field_74_01234 INT8, field_75_012345 BOOL, field_76_0123456 UINT64, field_77_01234567 UINT16, field_78_012345678 RICHREAL, field_79_0123456789 UINT8, field_80_0 INT8, field_81_01 UINT32, field_82_012 INT8 ARRAY, field_83_0123 UINT16)");
      /* 918 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 UINT8, field_3_0123 DATE, field_4_01234 UINT32, field_5_012345 UINT8, field_6_0123456 INT64, field_7_01234567 BOOL, field_8_012345678 RICHREAL, field_9_0123456789 REAL, field_10_0 DATETIME, field_11_01 DATETIME, field_12_012 REAL ARRAY, field_13_0123 REAL, field_14_01234 DATETIME, field_15_012345 RICHREAL ARRAY, field_16_0123456 UINT8, field_17_01234567 INT32, field_18_012345678 HIRESTIME, field_19_0123456789 DATETIME, field_20_0 INT32, field_21_01 UINT64, field_22_012 UINT16 ARRAY, field_23_0123 UINT16, field_24_01234 UINT16, field_25_012345 REAL, field_26_0123456 HIRESTIME, field_27_01234567 INT8, field_28_012345678 RICHREAL, field_29_0123456789 INT8, field_30_0 UINT32, field_31_01 UINT16, field_32_012 REAL, field_33_0123 INT16 ARRAY, field_34_01234 UINT16 ARRAY, field_35_012345 RICHREAL, field_36_0123456 INT16, field_37_01234567 DATETIME, field_38_012345678 UINT8, field_39_0123456789 DATETIME, field_40_0 REAL ARRAY, field_41_01 DATE, field_42_012 RICHREAL ARRAY, field_43_0123 UINT64, field_44_01234 UINT32, field_45_012345 INT16, field_46_0123456 BOOL ARRAY, field_47_01234567 DATE, field_48_012345678 UINT64 ARRAY, field_49_0123456789 INT8, field_50_0 BOOL, field_51_01 UINT16 ARRAY, field_52_012 CHAR ARRAY, field_53_0123 UINT32 ARRAY, field_54_01234 UINT32, field_55_012345 UINT32, field_56_0123456 BOOL, field_57_01234567 UINT64, field_58_012345678 DATETIME, field_59_0123456789 INT32)");
      /* 919 */ glbTypes.push_back("TABLE(field_1_01 UINT64 ARRAY, field_2_012 DATE, field_3_0123 UINT16 ARRAY, field_4_01234 RICHREAL, field_5_012345 BOOL, field_6_0123456 UINT64, field_7_01234567 INT64, field_8_012345678 DATETIME, field_9_0123456789 RICHREAL ARRAY, field_10_0 INT32, field_11_01 UINT64, field_12_012 DATETIME, field_13_0123 UINT8, field_14_01234 UINT64, field_15_012345 BOOL, field_16_0123456 UINT16, field_17_01234567 INT16, field_18_012345678 CHAR, field_19_0123456789 BOOL, field_20_0 UINT32 ARRAY, field_21_01 UINT8, field_22_012 DATE, field_23_0123 INT64 ARRAY, field_24_01234 INT16 ARRAY)");
      /* 920 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 INT8 ARRAY, field_3_0123 HIRESTIME ARRAY, field_4_01234 CHAR, field_5_012345 UINT8, field_6_0123456 UINT16 ARRAY, field_7_01234567 INT16 ARRAY, field_8_012345678 INT32, field_9_0123456789 DATE ARRAY, field_10_0 UINT8, field_11_01 REAL, field_12_012 DATETIME, field_13_0123 CHAR, field_14_01234 UINT16, field_15_012345 DATETIME, field_16_0123456 DATETIME, field_17_01234567 CHAR, field_18_012345678 INT64, field_19_0123456789 BOOL, field_20_0 INT32, field_21_01 INT32, field_22_012 UINT64, field_23_0123 INT32, field_24_01234 DATETIME, field_25_012345 INT32, field_26_0123456 DATE ARRAY, field_27_01234567 INT8, field_28_012345678 UINT16, field_29_0123456789 UINT32, field_30_0 DATETIME ARRAY, field_31_01 UINT8, field_32_012 DATE, field_33_0123 HIRESTIME, field_34_01234 DATE, field_35_012345 REAL)");
      /* 921 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 INT16, field_3_0123 CHAR, field_4_01234 CHAR, field_5_012345 INT8, field_6_0123456 DATE, field_7_01234567 DATETIME, field_8_012345678 DATE, field_9_0123456789 INT32 ARRAY, field_10_0 HIRESTIME, field_11_01 RICHREAL ARRAY, field_12_012 UINT32, field_13_0123 INT16, field_14_01234 UINT8, field_15_012345 INT32, field_16_0123456 UINT8 ARRAY, field_17_01234567 RICHREAL, field_18_012345678 CHAR ARRAY, field_19_0123456789 UINT16, field_20_0 UINT32 ARRAY, field_21_01 UINT8, field_22_012 DATE ARRAY, field_23_0123 UINT32, field_24_01234 DATE, field_25_012345 UINT8, field_26_0123456 HIRESTIME, field_27_01234567 DATE, field_28_012345678 DATE, field_29_0123456789 BOOL, field_30_0 UINT32 ARRAY, field_31_01 BOOL, field_32_012 INT16, field_33_0123 UINT16, field_34_01234 INT16, field_35_012345 UINT32, field_36_0123456 INT64, field_37_01234567 UINT16, field_38_012345678 UINT8 ARRAY, field_39_0123456789 HIRESTIME, field_40_0 REAL, field_41_01 UINT32 ARRAY, field_42_012 INT16, field_43_0123 DATE, field_44_01234 UINT64, field_45_012345 DATE, field_46_0123456 UINT32, field_47_01234567 INT64, field_48_012345678 UINT64, field_49_0123456789 UINT64 ARRAY, field_50_0 INT8, field_51_01 INT8 ARRAY, field_52_012 INT64, field_53_0123 UINT16, field_54_01234 HIRESTIME ARRAY, field_55_012345 CHAR, field_56_0123456 UINT32, field_57_01234567 HIRESTIME, field_58_012345678 INT8, field_59_0123456789 DATE, field_60_0 CHAR, field_61_01 DATE, field_62_012 INT16, field_63_0123 CHAR, field_64_01234 INT64 ARRAY, field_65_012345 UINT64, field_66_0123456 UINT16, field_67_01234567 HIRESTIME, field_68_012345678 UINT16, field_69_0123456789 INT64, field_70_0 INT8, field_71_01 DATE ARRAY, field_72_012 UINT32, field_73_0123 CHAR, field_74_01234 INT32 ARRAY, field_75_012345 HIRESTIME, field_76_0123456 HIRESTIME ARRAY, field_77_01234567 HIRESTIME, field_78_012345678 INT16, field_79_0123456789 UINT16, field_80_0 INT8, field_81_01 UINT16 ARRAY, field_82_012 UINT8 ARRAY, field_83_0123 INT8, field_84_01234 UINT8, field_85_012345 INT16, field_86_0123456 CHAR ARRAY)");
      /* 922 */ glbTypes.push_back("TABLE(field_1_01 INT8 ARRAY, field_2_012 HIRESTIME, field_3_0123 BOOL, field_4_01234 RICHREAL, field_5_012345 DATETIME, field_6_0123456 INT16 ARRAY, field_7_01234567 UINT16 ARRAY, field_8_012345678 DATETIME ARRAY, field_9_0123456789 INT64, field_10_0 DATETIME, field_11_01 INT32 ARRAY, field_12_012 UINT64, field_13_0123 DATETIME, field_14_01234 UINT8, field_15_012345 UINT16, field_16_0123456 INT64, field_17_01234567 BOOL, field_18_012345678 INT64, field_19_0123456789 REAL, field_20_0 UINT8, field_21_01 UINT16, field_22_012 INT16, field_23_0123 UINT16, field_24_01234 BOOL, field_25_012345 DATE, field_26_0123456 DATE, field_27_01234567 INT64 ARRAY, field_28_012345678 HIRESTIME, field_29_0123456789 UINT16, field_30_0 UINT8, field_31_01 INT32, field_32_012 HIRESTIME, field_33_0123 UINT64, field_34_01234 UINT8 ARRAY, field_35_012345 UINT32, field_36_0123456 INT8, field_37_01234567 CHAR, field_38_012345678 UINT32, field_39_0123456789 UINT16, field_40_0 CHAR ARRAY, field_41_01 RICHREAL ARRAY, field_42_012 UINT64, field_43_0123 INT32, field_44_01234 INT32, field_45_012345 INT32, field_46_0123456 INT8, field_47_01234567 HIRESTIME, field_48_012345678 UINT64, field_49_0123456789 HIRESTIME, field_50_0 INT8, field_51_01 CHAR, field_52_012 DATE, field_53_0123 CHAR, field_54_01234 BOOL, field_55_012345 INT64, field_56_0123456 CHAR ARRAY, field_57_01234567 UINT16, field_58_012345678 CHAR, field_59_0123456789 UINT32, field_60_0 UINT8, field_61_01 INT8, field_62_012 DATE, field_63_0123 INT64, field_64_01234 UINT8, field_65_012345 INT16 ARRAY, field_66_0123456 RICHREAL ARRAY, field_67_01234567 INT64, field_68_012345678 RICHREAL, field_69_0123456789 UINT16 ARRAY, field_70_0 INT32, field_71_01 HIRESTIME, field_72_012 HIRESTIME, field_73_0123 UINT32, field_74_01234 BOOL, field_75_012345 RICHREAL, field_76_0123456 INT8, field_77_01234567 DATE, field_78_012345678 CHAR ARRAY, field_79_0123456789 CHAR, field_80_0 DATE, field_81_01 UINT32, field_82_012 BOOL, field_83_0123 CHAR, field_84_01234 INT16, field_85_012345 INT8, field_86_0123456 HIRESTIME, field_87_01234567 BOOL, field_88_012345678 DATETIME, field_89_0123456789 INT64)");
      /* 923 */ glbTypes.push_back("TABLE(field_1_01 CHAR ARRAY, field_2_012 UINT8, field_3_0123 DATE, field_4_01234 CHAR, field_5_012345 HIRESTIME, field_6_0123456 HIRESTIME, field_7_01234567 BOOL ARRAY, field_8_012345678 RICHREAL, field_9_0123456789 DATETIME, field_10_0 DATETIME, field_11_01 UINT8, field_12_012 RICHREAL ARRAY, field_13_0123 INT8, field_14_01234 DATETIME, field_15_012345 DATE ARRAY, field_16_0123456 UINT32, field_17_01234567 INT8, field_18_012345678 UINT32, field_19_0123456789 INT64, field_20_0 INT32, field_21_01 INT16, field_22_012 DATE, field_23_0123 DATE, field_24_01234 REAL, field_25_012345 INT8, field_26_0123456 INT32, field_27_01234567 REAL ARRAY, field_28_012345678 HIRESTIME, field_29_0123456789 INT8 ARRAY, field_30_0 CHAR, field_31_01 INT16 ARRAY, field_32_012 BOOL ARRAY, field_33_0123 UINT16, field_34_01234 UINT8, field_35_012345 CHAR, field_36_0123456 DATE, field_37_01234567 INT64, field_38_012345678 UINT16 ARRAY, field_39_0123456789 INT64, field_40_0 UINT8, field_41_01 INT32, field_42_012 INT64, field_43_0123 DATETIME, field_44_01234 UINT8, field_45_012345 UINT64, field_46_0123456 INT8, field_47_01234567 CHAR, field_48_012345678 INT32, field_49_0123456789 BOOL)");
      /* 924 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 UINT16, field_3_0123 UINT64 ARRAY, field_4_01234 INT8, field_5_012345 INT32, field_6_0123456 REAL, field_7_01234567 RICHREAL, field_8_012345678 UINT32, field_9_0123456789 UINT8, field_10_0 UINT16, field_11_01 INT64 ARRAY, field_12_012 UINT64, field_13_0123 HIRESTIME, field_14_01234 UINT64, field_15_012345 BOOL, field_16_0123456 REAL ARRAY, field_17_01234567 UINT8, field_18_012345678 REAL, field_19_0123456789 INT32, field_20_0 BOOL, field_21_01 INT32 ARRAY, field_22_012 HIRESTIME, field_23_0123 RICHREAL, field_24_01234 DATETIME, field_25_012345 INT8, field_26_0123456 REAL, field_27_01234567 INT8, field_28_012345678 UINT64 ARRAY, field_29_0123456789 INT16, field_30_0 UINT64, field_31_01 INT8, field_32_012 DATETIME ARRAY, field_33_0123 RICHREAL, field_34_01234 INT32, field_35_012345 UINT8, field_36_0123456 INT16 ARRAY, field_37_01234567 BOOL, field_38_012345678 INT32, field_39_0123456789 UINT64 ARRAY, field_40_0 DATETIME, field_41_01 INT32, field_42_012 INT8, field_43_0123 CHAR, field_44_01234 REAL, field_45_012345 UINT32, field_46_0123456 INT8, field_47_01234567 DATETIME ARRAY, field_48_012345678 UINT16, field_49_0123456789 REAL, field_50_0 RICHREAL, field_51_01 INT64 ARRAY, field_52_012 INT32 ARRAY, field_53_0123 UINT32, field_54_01234 RICHREAL, field_55_012345 UINT16, field_56_0123456 CHAR, field_57_01234567 INT8, field_58_012345678 HIRESTIME ARRAY, field_59_0123456789 UINT8, field_60_0 CHAR, field_61_01 BOOL, field_62_012 DATETIME, field_63_0123 UINT8 ARRAY, field_64_01234 RICHREAL, field_65_012345 INT16 ARRAY, field_66_0123456 CHAR ARRAY, field_67_01234567 BOOL, field_68_012345678 UINT32, field_69_0123456789 INT8, field_70_0 HIRESTIME, field_71_01 INT16, field_72_012 INT64, field_73_0123 CHAR, field_74_01234 DATETIME, field_75_012345 CHAR ARRAY, field_76_0123456 HIRESTIME, field_77_01234567 BOOL, field_78_012345678 HIRESTIME, field_79_0123456789 INT32, field_80_0 REAL, field_81_01 INT16, field_82_012 DATE, field_83_0123 HIRESTIME, field_84_01234 UINT8, field_85_012345 UINT64 ARRAY)");
      /* 925 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 UINT32 ARRAY, field_3_0123 DATETIME, field_4_01234 RICHREAL, field_5_012345 INT16 ARRAY, field_6_0123456 HIRESTIME, field_7_01234567 HIRESTIME, field_8_012345678 INT16, field_9_0123456789 DATE, field_10_0 UINT32, field_11_01 INT8, field_12_012 UINT32, field_13_0123 DATE, field_14_01234 RICHREAL, field_15_012345 INT16, field_16_0123456 BOOL, field_17_01234567 UINT64, field_18_012345678 DATE, field_19_0123456789 INT16, field_20_0 INT16, field_21_01 DATETIME, field_22_012 DATE, field_23_0123 INT8, field_24_01234 UINT8, field_25_012345 DATETIME, field_26_0123456 UINT8, field_27_01234567 DATE, field_28_012345678 BOOL, field_29_0123456789 INT32, field_30_0 INT32, field_31_01 BOOL, field_32_012 UINT32, field_33_0123 INT16 ARRAY, field_34_01234 REAL, field_35_012345 UINT32, field_36_0123456 INT64, field_37_01234567 UINT32, field_38_012345678 INT16, field_39_0123456789 UINT16, field_40_0 UINT8, field_41_01 DATE, field_42_012 DATE ARRAY, field_43_0123 UINT64 ARRAY, field_44_01234 BOOL ARRAY, field_45_012345 INT8, field_46_0123456 UINT64, field_47_01234567 UINT64, field_48_012345678 INT64 ARRAY, field_49_0123456789 HIRESTIME, field_50_0 HIRESTIME ARRAY, field_51_01 UINT32, field_52_012 UINT8, field_53_0123 REAL, field_54_01234 BOOL ARRAY, field_55_012345 UINT64, field_56_0123456 INT64, field_57_01234567 REAL, field_58_012345678 DATE, field_59_0123456789 INT32 ARRAY, field_60_0 UINT64, field_61_01 UINT64)");
      /* 926 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 INT64 ARRAY, field_3_0123 CHAR ARRAY, field_4_01234 REAL, field_5_012345 CHAR, field_6_0123456 UINT32 ARRAY, field_7_01234567 DATE, field_8_012345678 INT64, field_9_0123456789 REAL, field_10_0 UINT32, field_11_01 UINT64, field_12_012 UINT32, field_13_0123 RICHREAL, field_14_01234 HIRESTIME, field_15_012345 UINT16, field_16_0123456 UINT16, field_17_01234567 DATE, field_18_012345678 UINT16, field_19_0123456789 UINT16, field_20_0 BOOL, field_21_01 DATE ARRAY, field_22_012 INT64, field_23_0123 INT64, field_24_01234 RICHREAL ARRAY, field_25_012345 REAL, field_26_0123456 UINT64 ARRAY, field_27_01234567 DATETIME, field_28_012345678 INT64, field_29_0123456789 INT8 ARRAY, field_30_0 CHAR, field_31_01 DATE, field_32_012 UINT16, field_33_0123 REAL, field_34_01234 REAL, field_35_012345 INT16, field_36_0123456 INT64, field_37_01234567 RICHREAL, field_38_012345678 UINT8, field_39_0123456789 INT64, field_40_0 DATE ARRAY, field_41_01 INT64, field_42_012 CHAR)");
      /* 927 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 INT8 ARRAY, field_3_0123 INT64, field_4_01234 HIRESTIME, field_5_012345 CHAR ARRAY, field_6_0123456 HIRESTIME ARRAY, field_7_01234567 UINT64 ARRAY, field_8_012345678 UINT8, field_9_0123456789 REAL, field_10_0 CHAR, field_11_01 INT64, field_12_012 UINT16, field_13_0123 UINT16, field_14_01234 REAL, field_15_012345 HIRESTIME, field_16_0123456 INT16 ARRAY, field_17_01234567 UINT32, field_18_012345678 UINT16, field_19_0123456789 INT32, field_20_0 CHAR, field_21_01 INT16, field_22_012 UINT8, field_23_0123 UINT8, field_24_01234 DATETIME, field_25_012345 CHAR ARRAY, field_26_0123456 INT64, field_27_01234567 CHAR, field_28_012345678 INT16, field_29_0123456789 DATETIME, field_30_0 DATETIME, field_31_01 UINT64, field_32_012 DATETIME ARRAY, field_33_0123 INT8 ARRAY, field_34_01234 INT8 ARRAY, field_35_012345 DATETIME, field_36_0123456 DATE, field_37_01234567 INT16 ARRAY, field_38_012345678 HIRESTIME, field_39_0123456789 INT16 ARRAY, field_40_0 UINT16, field_41_01 CHAR, field_42_012 HIRESTIME, field_43_0123 UINT32, field_44_01234 UINT64, field_45_012345 BOOL, field_46_0123456 INT8, field_47_01234567 INT16, field_48_012345678 CHAR ARRAY, field_49_0123456789 UINT8, field_50_0 UINT32, field_51_01 INT32, field_52_012 INT8, field_53_0123 UINT64, field_54_01234 RICHREAL, field_55_012345 INT8, field_56_0123456 DATETIME, field_57_01234567 INT64, field_58_012345678 INT32, field_59_0123456789 INT64, field_60_0 INT32, field_61_01 UINT32, field_62_012 INT16 ARRAY, field_63_0123 REAL ARRAY, field_64_01234 UINT16, field_65_012345 CHAR ARRAY, field_66_0123456 UINT16, field_67_01234567 HIRESTIME ARRAY, field_68_012345678 DATE, field_69_0123456789 DATETIME, field_70_0 INT64, field_71_01 HIRESTIME, field_72_012 UINT16 ARRAY, field_73_0123 DATE ARRAY, field_74_01234 BOOL, field_75_012345 INT8, field_76_0123456 UINT32, field_77_01234567 INT32, field_78_012345678 UINT32, field_79_0123456789 CHAR ARRAY, field_80_0 UINT16, field_81_01 UINT64, field_82_012 INT8, field_83_0123 HIRESTIME ARRAY, field_84_01234 DATE, field_85_012345 UINT32, field_86_0123456 CHAR, field_87_01234567 UINT8, field_88_012345678 REAL, field_89_0123456789 INT8, field_90_0 HIRESTIME)");
      /* 928 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 DATETIME, field_3_0123 INT8, field_4_01234 UINT16, field_5_012345 UINT16, field_6_0123456 UINT8 ARRAY, field_7_01234567 DATE ARRAY, field_8_012345678 INT8 ARRAY, field_9_0123456789 UINT8, field_10_0 REAL, field_11_01 BOOL, field_12_012 DATETIME, field_13_0123 CHAR, field_14_01234 RICHREAL, field_15_012345 INT64, field_16_0123456 UINT32)");
      /* 929 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 INT16 ARRAY, field_3_0123 INT8, field_4_01234 UINT32, field_5_012345 INT16, field_6_0123456 RICHREAL, field_7_01234567 HIRESTIME, field_8_012345678 UINT16, field_9_0123456789 CHAR, field_10_0 INT8, field_11_01 DATETIME, field_12_012 INT8 ARRAY, field_13_0123 UINT8, field_14_01234 UINT32 ARRAY, field_15_012345 CHAR, field_16_0123456 UINT16, field_17_01234567 RICHREAL, field_18_012345678 REAL, field_19_0123456789 CHAR, field_20_0 RICHREAL, field_21_01 UINT32, field_22_012 UINT16, field_23_0123 UINT64, field_24_01234 CHAR ARRAY, field_25_012345 HIRESTIME ARRAY, field_26_0123456 UINT64 ARRAY, field_27_01234567 HIRESTIME ARRAY, field_28_012345678 HIRESTIME, field_29_0123456789 UINT32, field_30_0 HIRESTIME, field_31_01 DATETIME, field_32_012 INT64, field_33_0123 REAL, field_34_01234 INT8 ARRAY, field_35_012345 BOOL ARRAY, field_36_0123456 REAL, field_37_01234567 REAL, field_38_012345678 INT64 ARRAY, field_39_0123456789 INT16, field_40_0 UINT32, field_41_01 DATE, field_42_012 UINT32, field_43_0123 DATETIME, field_44_01234 INT64, field_45_012345 BOOL ARRAY, field_46_0123456 DATE ARRAY, field_47_01234567 INT32, field_48_012345678 UINT8 ARRAY, field_49_0123456789 UINT16, field_50_0 RICHREAL, field_51_01 INT8, field_52_012 CHAR ARRAY, field_53_0123 DATETIME, field_54_01234 UINT32 ARRAY, field_55_012345 HIRESTIME, field_56_0123456 INT64, field_57_01234567 BOOL, field_58_012345678 INT16, field_59_0123456789 DATETIME, field_60_0 UINT32, field_61_01 HIRESTIME, field_62_012 HIRESTIME, field_63_0123 RICHREAL, field_64_01234 INT32 ARRAY, field_65_012345 INT8 ARRAY, field_66_0123456 INT32, field_67_01234567 UINT8, field_68_012345678 CHAR, field_69_0123456789 DATETIME ARRAY, field_70_0 UINT64 ARRAY, field_71_01 DATETIME, field_72_012 UINT64, field_73_0123 CHAR, field_74_01234 UINT64, field_75_012345 REAL, field_76_0123456 INT16, field_77_01234567 CHAR, field_78_012345678 CHAR, field_79_0123456789 REAL, field_80_0 INT64, field_81_01 CHAR, field_82_012 CHAR ARRAY, field_83_0123 CHAR, field_84_01234 DATETIME, field_85_012345 DATE, field_86_0123456 DATE, field_87_01234567 REAL, field_88_012345678 REAL, field_89_0123456789 INT8, field_90_0 INT32, field_91_01 DATETIME, field_92_012 CHAR, field_93_0123 DATETIME, field_94_01234 DATETIME ARRAY, field_95_012345 DATETIME, field_96_0123456 INT16, field_97_01234567 CHAR, field_98_012345678 REAL)");
      /* 930 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 UINT8, field_3_0123 INT32, field_4_01234 INT32, field_5_012345 UINT16, field_6_0123456 UINT16 ARRAY, field_7_01234567 HIRESTIME, field_8_012345678 BOOL, field_9_0123456789 INT8 ARRAY, field_10_0 UINT32, field_11_01 BOOL, field_12_012 UINT64, field_13_0123 UINT32, field_14_01234 BOOL, field_15_012345 UINT8, field_16_0123456 UINT8, field_17_01234567 DATE ARRAY, field_18_012345678 BOOL, field_19_0123456789 DATE ARRAY, field_20_0 UINT64, field_21_01 RICHREAL, field_22_012 INT8, field_23_0123 INT32, field_24_01234 UINT64, field_25_012345 UINT32, field_26_0123456 INT64, field_27_01234567 DATE, field_28_012345678 UINT64 ARRAY, field_29_0123456789 CHAR ARRAY, field_30_0 UINT16, field_31_01 INT16, field_32_012 DATE, field_33_0123 UINT32 ARRAY, field_34_01234 INT64, field_35_012345 RICHREAL, field_36_0123456 RICHREAL ARRAY, field_37_01234567 UINT64, field_38_012345678 CHAR ARRAY, field_39_0123456789 HIRESTIME, field_40_0 CHAR ARRAY, field_41_01 INT64, field_42_012 UINT64, field_43_0123 BOOL ARRAY, field_44_01234 UINT64, field_45_012345 BOOL, field_46_0123456 INT16, field_47_01234567 UINT64, field_48_012345678 DATETIME ARRAY, field_49_0123456789 INT8, field_50_0 REAL, field_51_01 INT64, field_52_012 INT8, field_53_0123 REAL, field_54_01234 DATE, field_55_012345 INT8 ARRAY, field_56_0123456 REAL, field_57_01234567 INT32, field_58_012345678 RICHREAL, field_59_0123456789 INT8, field_60_0 DATE, field_61_01 UINT8, field_62_012 UINT16, field_63_0123 INT16, field_64_01234 INT32, field_65_012345 UINT8, field_66_0123456 DATETIME, field_67_01234567 CHAR, field_68_012345678 HIRESTIME, field_69_0123456789 HIRESTIME, field_70_0 HIRESTIME, field_71_01 UINT32, field_72_012 HIRESTIME, field_73_0123 HIRESTIME, field_74_01234 UINT16, field_75_012345 INT64, field_76_0123456 BOOL ARRAY, field_77_01234567 HIRESTIME, field_78_012345678 UINT8 ARRAY, field_79_0123456789 INT16 ARRAY, field_80_0 DATE, field_81_01 INT8, field_82_012 UINT16, field_83_0123 INT32)");
      /* 931 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 UINT16, field_3_0123 HIRESTIME, field_4_01234 UINT32, field_5_012345 INT16, field_6_0123456 INT16 ARRAY, field_7_01234567 INT32 ARRAY, field_8_012345678 CHAR, field_9_0123456789 HIRESTIME, field_10_0 UINT32, field_11_01 INT32 ARRAY, field_12_012 BOOL, field_13_0123 INT32, field_14_01234 UINT64 ARRAY, field_15_012345 REAL, field_16_0123456 HIRESTIME ARRAY, field_17_01234567 INT8, field_18_012345678 RICHREAL, field_19_0123456789 INT64, field_20_0 INT64, field_21_01 RICHREAL, field_22_012 HIRESTIME ARRAY, field_23_0123 UINT64, field_24_01234 UINT64, field_25_012345 CHAR, field_26_0123456 UINT8, field_27_01234567 DATETIME, field_28_012345678 INT64, field_29_0123456789 INT32, field_30_0 HIRESTIME, field_31_01 RICHREAL, field_32_012 UINT16, field_33_0123 INT16, field_34_01234 UINT16, field_35_012345 INT32, field_36_0123456 UINT32 ARRAY, field_37_01234567 CHAR, field_38_012345678 INT32, field_39_0123456789 INT32, field_40_0 UINT8, field_41_01 BOOL ARRAY)");
      /* 932 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 REAL, field_3_0123 INT16, field_4_01234 RICHREAL, field_5_012345 INT32, field_6_0123456 INT16, field_7_01234567 DATETIME, field_8_012345678 BOOL, field_9_0123456789 UINT32, field_10_0 DATETIME, field_11_01 DATE, field_12_012 UINT8, field_13_0123 REAL ARRAY, field_14_01234 INT16, field_15_012345 UINT32, field_16_0123456 UINT64, field_17_01234567 UINT32, field_18_012345678 INT64 ARRAY, field_19_0123456789 INT64, field_20_0 CHAR, field_21_01 DATETIME, field_22_012 INT32 ARRAY, field_23_0123 CHAR, field_24_01234 DATE, field_25_012345 REAL, field_26_0123456 INT32, field_27_01234567 UINT64, field_28_012345678 INT16 ARRAY, field_29_0123456789 UINT8 ARRAY, field_30_0 CHAR ARRAY, field_31_01 UINT8, field_32_012 DATETIME, field_33_0123 REAL, field_34_01234 CHAR, field_35_012345 HIRESTIME, field_36_0123456 UINT64, field_37_01234567 RICHREAL, field_38_012345678 DATE, field_39_0123456789 BOOL, field_40_0 UINT16, field_41_01 DATE ARRAY, field_42_012 BOOL, field_43_0123 CHAR, field_44_01234 DATE ARRAY, field_45_012345 INT8 ARRAY, field_46_0123456 RICHREAL, field_47_01234567 HIRESTIME ARRAY, field_48_012345678 INT64, field_49_0123456789 UINT8, field_50_0 UINT8, field_51_01 HIRESTIME, field_52_012 INT16, field_53_0123 INT32, field_54_01234 INT16, field_55_012345 DATETIME, field_56_0123456 UINT16 ARRAY, field_57_01234567 RICHREAL, field_58_012345678 INT32, field_59_0123456789 RICHREAL, field_60_0 CHAR, field_61_01 INT64 ARRAY, field_62_012 HIRESTIME ARRAY, field_63_0123 DATETIME ARRAY, field_64_01234 HIRESTIME)");
      /* 933 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 REAL ARRAY, field_3_0123 INT16 ARRAY, field_4_01234 REAL, field_5_012345 CHAR, field_6_0123456 BOOL, field_7_01234567 INT32, field_8_012345678 DATE, field_9_0123456789 DATE, field_10_0 INT16, field_11_01 HIRESTIME, field_12_012 REAL, field_13_0123 INT32, field_14_01234 CHAR, field_15_012345 UINT32 ARRAY, field_16_0123456 CHAR ARRAY, field_17_01234567 DATE, field_18_012345678 UINT16, field_19_0123456789 HIRESTIME, field_20_0 HIRESTIME, field_21_01 DATETIME, field_22_012 INT32 ARRAY, field_23_0123 UINT8, field_24_01234 REAL, field_25_012345 INT64, field_26_0123456 INT32, field_27_01234567 DATE, field_28_012345678 DATETIME ARRAY, field_29_0123456789 RICHREAL ARRAY, field_30_0 UINT32, field_31_01 RICHREAL, field_32_012 DATETIME, field_33_0123 CHAR, field_34_01234 UINT8, field_35_012345 INT16, field_36_0123456 RICHREAL, field_37_01234567 BOOL, field_38_012345678 UINT8, field_39_0123456789 DATE, field_40_0 REAL, field_41_01 INT8, field_42_012 RICHREAL, field_43_0123 HIRESTIME ARRAY, field_44_01234 UINT64, field_45_012345 UINT64 ARRAY, field_46_0123456 UINT8, field_47_01234567 HIRESTIME, field_48_012345678 UINT64, field_49_0123456789 UINT8, field_50_0 UINT64, field_51_01 UINT16, field_52_012 UINT32 ARRAY, field_53_0123 DATE ARRAY, field_54_01234 BOOL, field_55_012345 INT16, field_56_0123456 BOOL, field_57_01234567 DATETIME, field_58_012345678 INT8, field_59_0123456789 DATE, field_60_0 CHAR, field_61_01 INT8, field_62_012 UINT8, field_63_0123 UINT8, field_64_01234 CHAR, field_65_012345 INT16, field_66_0123456 INT16, field_67_01234567 HIRESTIME ARRAY, field_68_012345678 CHAR, field_69_0123456789 RICHREAL ARRAY, field_70_0 INT64, field_71_01 UINT8, field_72_012 DATETIME, field_73_0123 UINT16, field_74_01234 REAL ARRAY, field_75_012345 DATE ARRAY, field_76_0123456 INT64, field_77_01234567 REAL, field_78_012345678 INT32, field_79_0123456789 UINT64)");
      /* 934 */ glbTypes.push_back("TABLE(field_1_01 INT16 ARRAY)");
      /* 935 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 UINT32, field_3_0123 RICHREAL, field_4_01234 INT32, field_5_012345 DATETIME ARRAY, field_6_0123456 UINT8 ARRAY, field_7_01234567 UINT64, field_8_012345678 DATETIME, field_9_0123456789 UINT16 ARRAY, field_10_0 CHAR, field_11_01 CHAR, field_12_012 UINT8, field_13_0123 INT16, field_14_01234 INT16, field_15_012345 DATETIME ARRAY, field_16_0123456 UINT32, field_17_01234567 DATE, field_18_012345678 HIRESTIME)");
      /* 936 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 INT8, field_3_0123 INT64, field_4_01234 INT8, field_5_012345 RICHREAL, field_6_0123456 DATE, field_7_01234567 RICHREAL ARRAY, field_8_012345678 DATE, field_9_0123456789 DATE, field_10_0 UINT8, field_11_01 INT64 ARRAY, field_12_012 UINT8, field_13_0123 INT32, field_14_01234 UINT8, field_15_012345 UINT16, field_16_0123456 UINT64 ARRAY, field_17_01234567 UINT32, field_18_012345678 UINT16, field_19_0123456789 DATE, field_20_0 DATE, field_21_01 UINT8, field_22_012 INT16, field_23_0123 INT64, field_24_01234 REAL, field_25_012345 UINT64, field_26_0123456 UINT64, field_27_01234567 INT32, field_28_012345678 HIRESTIME ARRAY, field_29_0123456789 INT32 ARRAY, field_30_0 INT8, field_31_01 UINT32, field_32_012 DATE, field_33_0123 INT8, field_34_01234 RICHREAL, field_35_012345 INT8 ARRAY, field_36_0123456 UINT64 ARRAY, field_37_01234567 RICHREAL, field_38_012345678 INT8, field_39_0123456789 INT8, field_40_0 CHAR, field_41_01 UINT64, field_42_012 UINT64, field_43_0123 UINT32, field_44_01234 DATETIME, field_45_012345 UINT16, field_46_0123456 INT32, field_47_01234567 INT8, field_48_012345678 INT64 ARRAY, field_49_0123456789 INT8, field_50_0 DATE, field_51_01 CHAR ARRAY, field_52_012 DATE, field_53_0123 CHAR, field_54_01234 UINT64, field_55_012345 CHAR ARRAY, field_56_0123456 INT16, field_57_01234567 DATE, field_58_012345678 INT16 ARRAY, field_59_0123456789 INT8 ARRAY, field_60_0 DATETIME, field_61_01 RICHREAL ARRAY, field_62_012 BOOL, field_63_0123 HIRESTIME, field_64_01234 UINT8 ARRAY, field_65_012345 UINT64, field_66_0123456 DATE, field_67_01234567 RICHREAL, field_68_012345678 REAL, field_69_0123456789 UINT64, field_70_0 RICHREAL ARRAY, field_71_01 CHAR, field_72_012 INT32, field_73_0123 DATETIME ARRAY, field_74_01234 INT8 ARRAY, field_75_012345 REAL, field_76_0123456 DATE, field_77_01234567 REAL ARRAY, field_78_012345678 INT64, field_79_0123456789 DATETIME, field_80_0 HIRESTIME, field_81_01 INT8, field_82_012 HIRESTIME, field_83_0123 UINT8 ARRAY, field_84_01234 INT16 ARRAY, field_85_012345 RICHREAL, field_86_0123456 CHAR)");
      /* 937 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 UINT16, field_3_0123 UINT8, field_4_01234 REAL ARRAY, field_5_012345 CHAR, field_6_0123456 BOOL, field_7_01234567 INT64, field_8_012345678 INT64 ARRAY, field_9_0123456789 INT8 ARRAY, field_10_0 UINT32, field_11_01 UINT32 ARRAY, field_12_012 REAL, field_13_0123 BOOL ARRAY, field_14_01234 UINT32, field_15_012345 UINT8, field_16_0123456 DATETIME, field_17_01234567 HIRESTIME, field_18_012345678 INT32 ARRAY, field_19_0123456789 BOOL, field_20_0 INT8, field_21_01 BOOL ARRAY, field_22_012 UINT8, field_23_0123 CHAR, field_24_01234 INT8, field_25_012345 INT8, field_26_0123456 CHAR, field_27_01234567 BOOL, field_28_012345678 HIRESTIME, field_29_0123456789 INT16, field_30_0 CHAR, field_31_01 UINT16, field_32_012 REAL, field_33_0123 DATE, field_34_01234 UINT32, field_35_012345 UINT64, field_36_0123456 UINT64, field_37_01234567 UINT32, field_38_012345678 RICHREAL, field_39_0123456789 UINT16, field_40_0 DATE, field_41_01 DATE, field_42_012 INT8, field_43_0123 INT64, field_44_01234 REAL, field_45_012345 INT16, field_46_0123456 HIRESTIME, field_47_01234567 DATETIME, field_48_012345678 HIRESTIME, field_49_0123456789 CHAR)");
      /* 938 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 RICHREAL ARRAY)");
      /* 939 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 RICHREAL, field_3_0123 BOOL, field_4_01234 UINT32, field_5_012345 DATETIME, field_6_0123456 INT8, field_7_01234567 DATETIME ARRAY, field_8_012345678 INT64, field_9_0123456789 CHAR, field_10_0 UINT32, field_11_01 DATETIME, field_12_012 DATETIME, field_13_0123 UINT32, field_14_01234 UINT8, field_15_012345 REAL, field_16_0123456 REAL, field_17_01234567 HIRESTIME, field_18_012345678 REAL, field_19_0123456789 UINT32, field_20_0 BOOL ARRAY, field_21_01 INT32, field_22_012 DATETIME, field_23_0123 UINT8, field_24_01234 RICHREAL, field_25_012345 INT64, field_26_0123456 INT8, field_27_01234567 INT64, field_28_012345678 CHAR, field_29_0123456789 HIRESTIME, field_30_0 HIRESTIME, field_31_01 INT8, field_32_012 REAL, field_33_0123 HIRESTIME, field_34_01234 CHAR, field_35_012345 HIRESTIME, field_36_0123456 CHAR ARRAY, field_37_01234567 INT64, field_38_012345678 UINT32, field_39_0123456789 RICHREAL)");
      /* 940 */ glbTypes.push_back("TABLE(field_1_01 INT8 ARRAY)");
      /* 941 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 INT32, field_3_0123 INT64, field_4_01234 INT32, field_5_012345 UINT32, field_6_0123456 DATE, field_7_01234567 INT8, field_8_012345678 DATE, field_9_0123456789 UINT64, field_10_0 RICHREAL, field_11_01 BOOL, field_12_012 INT16 ARRAY, field_13_0123 BOOL, field_14_01234 INT8, field_15_012345 DATETIME, field_16_0123456 INT8, field_17_01234567 REAL ARRAY, field_18_012345678 UINT16, field_19_0123456789 UINT16, field_20_0 UINT64, field_21_01 INT64, field_22_012 BOOL, field_23_0123 INT16 ARRAY, field_24_01234 HIRESTIME ARRAY, field_25_012345 DATE, field_26_0123456 INT8, field_27_01234567 INT8, field_28_012345678 UINT64 ARRAY, field_29_0123456789 DATETIME, field_30_0 INT64, field_31_01 HIRESTIME, field_32_012 CHAR, field_33_0123 DATE, field_34_01234 UINT16 ARRAY, field_35_012345 DATETIME, field_36_0123456 RICHREAL)");
      /* 942 */ glbTypes.push_back("TABLE(field_1_01 CHAR ARRAY, field_2_012 CHAR, field_3_0123 DATE, field_4_01234 DATETIME ARRAY, field_5_012345 INT16, field_6_0123456 REAL, field_7_01234567 INT64, field_8_012345678 INT32, field_9_0123456789 INT16, field_10_0 DATETIME, field_11_01 INT32, field_12_012 UINT32, field_13_0123 DATE ARRAY, field_14_01234 RICHREAL, field_15_012345 REAL, field_16_0123456 DATETIME, field_17_01234567 INT8, field_18_012345678 HIRESTIME, field_19_0123456789 REAL, field_20_0 INT16, field_21_01 DATETIME ARRAY, field_22_012 INT32, field_23_0123 UINT64, field_24_01234 INT16, field_25_012345 RICHREAL, field_26_0123456 HIRESTIME, field_27_01234567 REAL, field_28_012345678 CHAR, field_29_0123456789 DATETIME, field_30_0 CHAR, field_31_01 UINT64, field_32_012 CHAR, field_33_0123 INT32, field_34_01234 REAL, field_35_012345 DATE, field_36_0123456 HIRESTIME, field_37_01234567 REAL, field_38_012345678 UINT64, field_39_0123456789 UINT32 ARRAY, field_40_0 REAL ARRAY, field_41_01 INT32, field_42_012 UINT64, field_43_0123 UINT32, field_44_01234 BOOL ARRAY, field_45_012345 UINT32, field_46_0123456 REAL ARRAY, field_47_01234567 INT16, field_48_012345678 UINT8, field_49_0123456789 INT16, field_50_0 DATE, field_51_01 DATETIME, field_52_012 INT32 ARRAY, field_53_0123 INT16 ARRAY, field_54_01234 DATETIME, field_55_012345 DATETIME, field_56_0123456 INT8, field_57_01234567 DATETIME, field_58_012345678 INT64, field_59_0123456789 BOOL, field_60_0 INT64, field_61_01 REAL, field_62_012 BOOL, field_63_0123 INT64, field_64_01234 RICHREAL ARRAY, field_65_012345 REAL, field_66_0123456 RICHREAL, field_67_01234567 DATETIME, field_68_012345678 CHAR, field_69_0123456789 UINT64 ARRAY, field_70_0 DATETIME, field_71_01 RICHREAL, field_72_012 HIRESTIME, field_73_0123 BOOL, field_74_01234 INT32 ARRAY, field_75_012345 REAL ARRAY, field_76_0123456 BOOL, field_77_01234567 UINT32)");
      /* 943 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME ARRAY, field_2_012 RICHREAL, field_3_0123 DATETIME, field_4_01234 INT16, field_5_012345 RICHREAL, field_6_0123456 INT32 ARRAY, field_7_01234567 UINT8 ARRAY, field_8_012345678 BOOL, field_9_0123456789 INT32, field_10_0 INT16 ARRAY, field_11_01 DATETIME, field_12_012 INT64, field_13_0123 DATETIME, field_14_01234 CHAR, field_15_012345 INT8 ARRAY, field_16_0123456 BOOL ARRAY, field_17_01234567 DATETIME, field_18_012345678 CHAR, field_19_0123456789 DATETIME, field_20_0 CHAR ARRAY, field_21_01 INT64 ARRAY, field_22_012 UINT64, field_23_0123 UINT32, field_24_01234 INT32 ARRAY, field_25_012345 REAL)");
      /* 944 */ glbTypes.push_back("TABLE(field_1_01 INT64 ARRAY, field_2_012 DATETIME, field_3_0123 INT32 ARRAY, field_4_01234 RICHREAL, field_5_012345 CHAR, field_6_0123456 HIRESTIME, field_7_01234567 INT32, field_8_012345678 DATE ARRAY, field_9_0123456789 INT32, field_10_0 INT32, field_11_01 CHAR, field_12_012 CHAR, field_13_0123 DATE, field_14_01234 INT32, field_15_012345 INT64, field_16_0123456 BOOL, field_17_01234567 INT16, field_18_012345678 BOOL, field_19_0123456789 INT16, field_20_0 CHAR, field_21_01 INT32, field_22_012 UINT32, field_23_0123 UINT32, field_24_01234 INT64, field_25_012345 DATETIME, field_26_0123456 CHAR ARRAY, field_27_01234567 HIRESTIME, field_28_012345678 UINT16, field_29_0123456789 INT32 ARRAY, field_30_0 CHAR, field_31_01 DATETIME, field_32_012 UINT8, field_33_0123 HIRESTIME, field_34_01234 RICHREAL, field_35_012345 UINT32, field_36_0123456 INT64, field_37_01234567 BOOL ARRAY, field_38_012345678 INT16 ARRAY, field_39_0123456789 DATE, field_40_0 BOOL, field_41_01 UINT8, field_42_012 UINT64, field_43_0123 INT32, field_44_01234 UINT16, field_45_012345 INT8, field_46_0123456 UINT64 ARRAY, field_47_01234567 BOOL ARRAY, field_48_012345678 CHAR, field_49_0123456789 INT16 ARRAY, field_50_0 HIRESTIME ARRAY, field_51_01 BOOL, field_52_012 INT16, field_53_0123 INT64, field_54_01234 DATE ARRAY, field_55_012345 DATE, field_56_0123456 UINT8, field_57_01234567 INT8, field_58_012345678 INT64, field_59_0123456789 UINT64, field_60_0 UINT64, field_61_01 REAL ARRAY, field_62_012 RICHREAL, field_63_0123 CHAR ARRAY, field_64_01234 RICHREAL, field_65_012345 UINT64, field_66_0123456 CHAR, field_67_01234567 DATETIME, field_68_012345678 INT64, field_69_0123456789 REAL ARRAY, field_70_0 UINT64, field_71_01 INT16, field_72_012 INT16 ARRAY, field_73_0123 RICHREAL, field_74_01234 UINT32, field_75_012345 UINT64, field_76_0123456 CHAR, field_77_01234567 BOOL, field_78_012345678 CHAR, field_79_0123456789 DATE, field_80_0 UINT16 ARRAY, field_81_01 INT8, field_82_012 RICHREAL, field_83_0123 CHAR)");
      /* 945 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 DATE, field_3_0123 CHAR, field_4_01234 BOOL, field_5_012345 UINT16, field_6_0123456 UINT8, field_7_01234567 INT8, field_8_012345678 UINT8 ARRAY, field_9_0123456789 RICHREAL ARRAY, field_10_0 INT64, field_11_01 INT64, field_12_012 INT16 ARRAY, field_13_0123 HIRESTIME, field_14_01234 DATE ARRAY, field_15_012345 BOOL, field_16_0123456 BOOL, field_17_01234567 REAL, field_18_012345678 CHAR, field_19_0123456789 RICHREAL, field_20_0 CHAR, field_21_01 REAL, field_22_012 UINT32)");
      /* 946 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 INT32, field_3_0123 RICHREAL, field_4_01234 CHAR, field_5_012345 BOOL ARRAY, field_6_0123456 INT64, field_7_01234567 INT64)");
      /* 947 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 INT16, field_3_0123 DATE, field_4_01234 BOOL, field_5_012345 REAL, field_6_0123456 INT8, field_7_01234567 BOOL, field_8_012345678 CHAR ARRAY, field_9_0123456789 BOOL, field_10_0 REAL, field_11_01 UINT8, field_12_012 REAL ARRAY, field_13_0123 DATETIME, field_14_01234 INT16, field_15_012345 UINT32, field_16_0123456 INT8, field_17_01234567 INT8 ARRAY, field_18_012345678 UINT64 ARRAY, field_19_0123456789 UINT64, field_20_0 INT64, field_21_01 UINT8, field_22_012 BOOL, field_23_0123 UINT32, field_24_01234 HIRESTIME, field_25_012345 UINT16 ARRAY, field_26_0123456 UINT8, field_27_01234567 UINT32 ARRAY, field_28_012345678 INT64, field_29_0123456789 BOOL, field_30_0 DATE, field_31_01 INT8, field_32_012 UINT16, field_33_0123 DATE, field_34_01234 HIRESTIME, field_35_012345 INT64 ARRAY, field_36_0123456 UINT16, field_37_01234567 HIRESTIME, field_38_012345678 CHAR, field_39_0123456789 REAL, field_40_0 RICHREAL, field_41_01 DATETIME, field_42_012 HIRESTIME, field_43_0123 INT32, field_44_01234 CHAR, field_45_012345 UINT16, field_46_0123456 INT32, field_47_01234567 INT16, field_48_012345678 UINT8, field_49_0123456789 UINT64 ARRAY, field_50_0 BOOL, field_51_01 REAL, field_52_012 UINT64 ARRAY, field_53_0123 UINT16 ARRAY, field_54_01234 INT16, field_55_012345 BOOL, field_56_0123456 UINT64, field_57_01234567 INT16 ARRAY, field_58_012345678 REAL, field_59_0123456789 UINT32, field_60_0 UINT32, field_61_01 DATE, field_62_012 BOOL, field_63_0123 BOOL, field_64_01234 INT16 ARRAY, field_65_012345 HIRESTIME, field_66_0123456 UINT16 ARRAY)");
      /* 948 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 DATE, field_3_0123 INT64, field_4_01234 INT32, field_5_012345 INT16 ARRAY, field_6_0123456 RICHREAL, field_7_01234567 BOOL, field_8_012345678 INT16, field_9_0123456789 INT32, field_10_0 INT16, field_11_01 UINT16, field_12_012 BOOL, field_13_0123 UINT64, field_14_01234 UINT32, field_15_012345 UINT64, field_16_0123456 INT32, field_17_01234567 RICHREAL, field_18_012345678 INT32 ARRAY, field_19_0123456789 INT64, field_20_0 INT8, field_21_01 REAL, field_22_012 RICHREAL ARRAY, field_23_0123 RICHREAL, field_24_01234 HIRESTIME, field_25_012345 INT8, field_26_0123456 CHAR ARRAY, field_27_01234567 DATE ARRAY, field_28_012345678 DATE, field_29_0123456789 UINT16, field_30_0 INT32, field_31_01 CHAR, field_32_012 UINT64 ARRAY, field_33_0123 BOOL, field_34_01234 INT16, field_35_012345 UINT64, field_36_0123456 UINT16, field_37_01234567 CHAR ARRAY, field_38_012345678 INT64, field_39_0123456789 UINT32, field_40_0 INT8, field_41_01 INT16, field_42_012 DATETIME ARRAY, field_43_0123 UINT8, field_44_01234 INT64, field_45_012345 BOOL ARRAY, field_46_0123456 INT8, field_47_01234567 UINT32, field_48_012345678 REAL, field_49_0123456789 HIRESTIME, field_50_0 BOOL, field_51_01 BOOL, field_52_012 INT64, field_53_0123 UINT8, field_54_01234 RICHREAL ARRAY, field_55_012345 INT64, field_56_0123456 HIRESTIME, field_57_01234567 RICHREAL, field_58_012345678 REAL, field_59_0123456789 UINT16, field_60_0 RICHREAL, field_61_01 DATETIME ARRAY, field_62_012 DATETIME, field_63_0123 UINT8, field_64_01234 INT16, field_65_012345 HIRESTIME ARRAY, field_66_0123456 REAL, field_67_01234567 UINT32, field_68_012345678 INT16)");
      /* 949 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 DATETIME, field_3_0123 HIRESTIME ARRAY, field_4_01234 INT16, field_5_012345 UINT32, field_6_0123456 BOOL, field_7_01234567 DATETIME, field_8_012345678 INT32, field_9_0123456789 REAL, field_10_0 BOOL ARRAY, field_11_01 UINT32, field_12_012 DATE, field_13_0123 UINT64 ARRAY, field_14_01234 INT64, field_15_012345 BOOL, field_16_0123456 BOOL, field_17_01234567 HIRESTIME, field_18_012345678 UINT16 ARRAY, field_19_0123456789 BOOL, field_20_0 BOOL ARRAY, field_21_01 UINT32, field_22_012 INT64, field_23_0123 CHAR, field_24_01234 DATE, field_25_012345 INT8, field_26_0123456 REAL, field_27_01234567 UINT64, field_28_012345678 INT64, field_29_0123456789 HIRESTIME, field_30_0 DATE, field_31_01 CHAR, field_32_012 UINT8)");
      /* 950 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 INT8, field_3_0123 RICHREAL, field_4_01234 REAL, field_5_012345 INT32 ARRAY, field_6_0123456 UINT8, field_7_01234567 HIRESTIME, field_8_012345678 INT16 ARRAY, field_9_0123456789 HIRESTIME, field_10_0 DATETIME, field_11_01 INT8, field_12_012 REAL, field_13_0123 UINT32, field_14_01234 UINT64 ARRAY, field_15_012345 UINT64, field_16_0123456 INT16, field_17_01234567 INT32 ARRAY, field_18_012345678 INT32, field_19_0123456789 INT16, field_20_0 INT32, field_21_01 BOOL, field_22_012 DATE, field_23_0123 CHAR ARRAY, field_24_01234 INT8, field_25_012345 REAL, field_26_0123456 HIRESTIME, field_27_01234567 REAL, field_28_012345678 UINT64, field_29_0123456789 INT32, field_30_0 INT32 ARRAY, field_31_01 UINT32 ARRAY, field_32_012 DATE, field_33_0123 INT8, field_34_01234 UINT32, field_35_012345 DATETIME ARRAY, field_36_0123456 INT16, field_37_01234567 INT64, field_38_012345678 INT8 ARRAY, field_39_0123456789 INT16 ARRAY, field_40_0 CHAR ARRAY, field_41_01 HIRESTIME, field_42_012 UINT32, field_43_0123 HIRESTIME, field_44_01234 DATE, field_45_012345 BOOL, field_46_0123456 UINT64, field_47_01234567 INT8, field_48_012345678 CHAR ARRAY, field_49_0123456789 UINT32, field_50_0 REAL, field_51_01 UINT8, field_52_012 CHAR, field_53_0123 UINT32 ARRAY, field_54_01234 RICHREAL ARRAY, field_55_012345 UINT64, field_56_0123456 CHAR, field_57_01234567 DATE, field_58_012345678 INT8 ARRAY, field_59_0123456789 HIRESTIME ARRAY, field_60_0 INT16, field_61_01 DATETIME, field_62_012 BOOL, field_63_0123 CHAR, field_64_01234 DATETIME, field_65_012345 INT32, field_66_0123456 UINT16, field_67_01234567 UINT16 ARRAY, field_68_012345678 INT8, field_69_0123456789 INT16, field_70_0 INT64, field_71_01 INT16, field_72_012 INT16, field_73_0123 BOOL, field_74_01234 UINT16, field_75_012345 INT16 ARRAY, field_76_0123456 INT16, field_77_01234567 DATETIME, field_78_012345678 UINT32, field_79_0123456789 BOOL, field_80_0 INT32 ARRAY, field_81_01 UINT8 ARRAY, field_82_012 BOOL, field_83_0123 DATE, field_84_01234 INT64, field_85_012345 UINT8, field_86_0123456 HIRESTIME, field_87_01234567 UINT64 ARRAY, field_88_012345678 BOOL)");
      /* 951 */ glbTypes.push_back("TABLE(field_1_01 UINT16 ARRAY, field_2_012 UINT64 ARRAY, field_3_0123 INT8, field_4_01234 DATETIME ARRAY, field_5_012345 INT32, field_6_0123456 INT32, field_7_01234567 DATETIME, field_8_012345678 CHAR, field_9_0123456789 INT64, field_10_0 UINT64, field_11_01 UINT32, field_12_012 DATETIME, field_13_0123 INT64, field_14_01234 CHAR, field_15_012345 INT8 ARRAY, field_16_0123456 DATE, field_17_01234567 DATE, field_18_012345678 INT8, field_19_0123456789 BOOL ARRAY, field_20_0 UINT16 ARRAY, field_21_01 BOOL ARRAY, field_22_012 INT16, field_23_0123 RICHREAL, field_24_01234 DATETIME, field_25_012345 BOOL ARRAY, field_26_0123456 UINT64, field_27_01234567 INT32, field_28_012345678 INT8, field_29_0123456789 UINT8, field_30_0 INT16 ARRAY, field_31_01 BOOL ARRAY, field_32_012 INT32 ARRAY, field_33_0123 INT32, field_34_01234 INT16, field_35_012345 HIRESTIME, field_36_0123456 UINT16, field_37_01234567 INT8, field_38_012345678 INT64, field_39_0123456789 HIRESTIME ARRAY, field_40_0 RICHREAL, field_41_01 UINT32 ARRAY, field_42_012 REAL, field_43_0123 DATE, field_44_01234 REAL ARRAY, field_45_012345 UINT8 ARRAY, field_46_0123456 INT32, field_47_01234567 RICHREAL, field_48_012345678 INT16, field_49_0123456789 BOOL, field_50_0 REAL, field_51_01 CHAR, field_52_012 UINT8, field_53_0123 UINT8, field_54_01234 BOOL, field_55_012345 UINT32, field_56_0123456 CHAR ARRAY, field_57_01234567 INT8, field_58_012345678 REAL, field_59_0123456789 UINT16, field_60_0 CHAR, field_61_01 CHAR, field_62_012 INT8, field_63_0123 INT32 ARRAY, field_64_01234 UINT8, field_65_012345 REAL, field_66_0123456 INT8 ARRAY, field_67_01234567 UINT64, field_68_012345678 BOOL, field_69_0123456789 UINT8, field_70_0 CHAR, field_71_01 INT32 ARRAY, field_72_012 HIRESTIME ARRAY, field_73_0123 UINT8, field_74_01234 INT8, field_75_012345 INT64 ARRAY, field_76_0123456 CHAR, field_77_01234567 DATE, field_78_012345678 UINT32, field_79_0123456789 UINT8, field_80_0 REAL ARRAY, field_81_01 INT32 ARRAY, field_82_012 DATE ARRAY, field_83_0123 INT16 ARRAY, field_84_01234 HIRESTIME ARRAY, field_85_012345 DATE ARRAY, field_86_0123456 UINT16 ARRAY, field_87_01234567 UINT8 ARRAY, field_88_012345678 INT32, field_89_0123456789 INT64, field_90_0 BOOL, field_91_01 HIRESTIME, field_92_012 REAL, field_93_0123 DATETIME, field_94_01234 INT16, field_95_012345 INT32 ARRAY, field_96_0123456 RICHREAL)");
      /* 952 */ glbTypes.push_back("TABLE(field_1_01 INT8 ARRAY, field_2_012 INT16 ARRAY, field_3_0123 UINT32, field_4_01234 UINT32, field_5_012345 CHAR, field_6_0123456 DATETIME ARRAY, field_7_01234567 HIRESTIME, field_8_012345678 INT32, field_9_0123456789 REAL, field_10_0 BOOL, field_11_01 BOOL, field_12_012 CHAR, field_13_0123 UINT8 ARRAY, field_14_01234 BOOL ARRAY, field_15_012345 INT32, field_16_0123456 HIRESTIME, field_17_01234567 BOOL ARRAY, field_18_012345678 DATE, field_19_0123456789 INT64, field_20_0 REAL ARRAY, field_21_01 REAL ARRAY, field_22_012 INT16, field_23_0123 REAL, field_24_01234 UINT8 ARRAY, field_25_012345 DATE, field_26_0123456 BOOL, field_27_01234567 UINT16, field_28_012345678 UINT64 ARRAY, field_29_0123456789 RICHREAL, field_30_0 INT16, field_31_01 HIRESTIME, field_32_012 CHAR, field_33_0123 UINT32, field_34_01234 CHAR, field_35_012345 DATETIME, field_36_0123456 CHAR, field_37_01234567 UINT16, field_38_012345678 BOOL, field_39_0123456789 UINT16, field_40_0 INT32, field_41_01 INT64 ARRAY, field_42_012 HIRESTIME, field_43_0123 INT32)");
      /* 953 */ glbTypes.push_back("TABLE");
      /* 954 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 INT32, field_3_0123 DATE, field_4_01234 BOOL, field_5_012345 UINT32, field_6_0123456 UINT64, field_7_01234567 HIRESTIME, field_8_012345678 DATETIME, field_9_0123456789 UINT64, field_10_0 INT16, field_11_01 BOOL, field_12_012 DATE, field_13_0123 UINT8, field_14_01234 INT16, field_15_012345 UINT64 ARRAY, field_16_0123456 UINT16 ARRAY, field_17_01234567 CHAR, field_18_012345678 BOOL, field_19_0123456789 BOOL, field_20_0 HIRESTIME, field_21_01 UINT8 ARRAY, field_22_012 UINT64, field_23_0123 UINT32, field_24_01234 INT16, field_25_012345 BOOL, field_26_0123456 INT32, field_27_01234567 UINT16, field_28_012345678 DATETIME, field_29_0123456789 UINT8 ARRAY, field_30_0 BOOL, field_31_01 INT8, field_32_012 REAL ARRAY, field_33_0123 DATE, field_34_01234 UINT16, field_35_012345 REAL, field_36_0123456 INT32, field_37_01234567 INT16 ARRAY, field_38_012345678 INT32)");
      /* 955 */ glbTypes.push_back("TABLE(field_1_01 BOOL ARRAY, field_2_012 UINT64, field_3_0123 HIRESTIME, field_4_01234 UINT64, field_5_012345 DATETIME, field_6_0123456 BOOL, field_7_01234567 RICHREAL, field_8_012345678 INT32, field_9_0123456789 UINT32, field_10_0 UINT32 ARRAY, field_11_01 UINT8, field_12_012 DATETIME, field_13_0123 UINT16, field_14_01234 UINT16 ARRAY, field_15_012345 REAL, field_16_0123456 UINT64, field_17_01234567 INT16 ARRAY, field_18_012345678 REAL, field_19_0123456789 DATETIME, field_20_0 INT32 ARRAY, field_21_01 CHAR, field_22_012 UINT32, field_23_0123 DATE, field_24_01234 CHAR, field_25_012345 CHAR, field_26_0123456 INT8 ARRAY, field_27_01234567 DATETIME, field_28_012345678 DATETIME, field_29_0123456789 INT16, field_30_0 RICHREAL ARRAY, field_31_01 HIRESTIME, field_32_012 UINT16 ARRAY, field_33_0123 INT64 ARRAY, field_34_01234 HIRESTIME ARRAY, field_35_012345 DATE, field_36_0123456 UINT8, field_37_01234567 INT64, field_38_012345678 CHAR, field_39_0123456789 INT32, field_40_0 INT32, field_41_01 REAL, field_42_012 UINT8, field_43_0123 BOOL, field_44_01234 UINT16, field_45_012345 UINT32, field_46_0123456 REAL, field_47_01234567 CHAR ARRAY, field_48_012345678 DATE, field_49_0123456789 DATE, field_50_0 INT16 ARRAY, field_51_01 INT64, field_52_012 INT64, field_53_0123 REAL, field_54_01234 UINT32, field_55_012345 REAL ARRAY, field_56_0123456 DATETIME, field_57_01234567 HIRESTIME, field_58_012345678 UINT32, field_59_0123456789 UINT32 ARRAY, field_60_0 UINT32, field_61_01 INT64, field_62_012 INT32 ARRAY, field_63_0123 BOOL)");
      /* 956 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 CHAR, field_3_0123 DATE, field_4_01234 REAL ARRAY, field_5_012345 CHAR, field_6_0123456 INT32, field_7_01234567 UINT64, field_8_012345678 CHAR, field_9_0123456789 RICHREAL, field_10_0 INT32 ARRAY, field_11_01 BOOL ARRAY, field_12_012 REAL, field_13_0123 BOOL, field_14_01234 RICHREAL, field_15_012345 UINT8, field_16_0123456 CHAR, field_17_01234567 UINT64, field_18_012345678 UINT32, field_19_0123456789 UINT32 ARRAY, field_20_0 HIRESTIME, field_21_01 INT32, field_22_012 INT64, field_23_0123 DATETIME, field_24_01234 INT32 ARRAY, field_25_012345 UINT8, field_26_0123456 UINT16, field_27_01234567 UINT32)");
      /* 957 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 RICHREAL, field_3_0123 INT16 ARRAY, field_4_01234 RICHREAL, field_5_012345 HIRESTIME, field_6_0123456 UINT8, field_7_01234567 CHAR, field_8_012345678 RICHREAL, field_9_0123456789 INT64, field_10_0 INT8 ARRAY, field_11_01 CHAR, field_12_012 HIRESTIME, field_13_0123 RICHREAL, field_14_01234 DATE, field_15_012345 UINT8, field_16_0123456 INT32 ARRAY, field_17_01234567 RICHREAL ARRAY, field_18_012345678 REAL, field_19_0123456789 INT16, field_20_0 INT64 ARRAY, field_21_01 REAL ARRAY, field_22_012 UINT64, field_23_0123 UINT64 ARRAY, field_24_01234 INT32 ARRAY)");
      /* 958 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 UINT32, field_3_0123 RICHREAL, field_4_01234 UINT32, field_5_012345 INT16, field_6_0123456 REAL, field_7_01234567 INT16, field_8_012345678 UINT16 ARRAY, field_9_0123456789 REAL, field_10_0 INT64 ARRAY, field_11_01 HIRESTIME, field_12_012 DATE, field_13_0123 INT16, field_14_01234 HIRESTIME, field_15_012345 DATETIME, field_16_0123456 INT8, field_17_01234567 UINT8, field_18_012345678 INT64, field_19_0123456789 INT64, field_20_0 DATE, field_21_01 UINT32, field_22_012 HIRESTIME, field_23_0123 HIRESTIME, field_24_01234 UINT32 ARRAY, field_25_012345 INT32, field_26_0123456 UINT64, field_27_01234567 INT8)");
      /* 959 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 INT32, field_3_0123 DATETIME, field_4_01234 INT8, field_5_012345 UINT64 ARRAY, field_6_0123456 INT64, field_7_01234567 UINT16, field_8_012345678 RICHREAL ARRAY, field_9_0123456789 INT8, field_10_0 CHAR, field_11_01 INT16, field_12_012 INT16, field_13_0123 UINT32 ARRAY, field_14_01234 UINT32, field_15_012345 UINT32 ARRAY, field_16_0123456 UINT32, field_17_01234567 UINT64, field_18_012345678 INT32 ARRAY, field_19_0123456789 BOOL, field_20_0 RICHREAL ARRAY, field_21_01 UINT64, field_22_012 UINT64, field_23_0123 INT32, field_24_01234 UINT8 ARRAY, field_25_012345 BOOL ARRAY, field_26_0123456 RICHREAL, field_27_01234567 DATETIME, field_28_012345678 HIRESTIME, field_29_0123456789 BOOL, field_30_0 DATE, field_31_01 RICHREAL, field_32_012 CHAR, field_33_0123 REAL, field_34_01234 UINT64, field_35_012345 HIRESTIME, field_36_0123456 INT16, field_37_01234567 UINT16, field_38_012345678 DATE, field_39_0123456789 BOOL, field_40_0 UINT8 ARRAY, field_41_01 DATE, field_42_012 HIRESTIME, field_43_0123 UINT16, field_44_01234 UINT16, field_45_012345 UINT32, field_46_0123456 INT64 ARRAY, field_47_01234567 UINT8 ARRAY, field_48_012345678 DATETIME ARRAY, field_49_0123456789 CHAR, field_50_0 UINT8 ARRAY, field_51_01 CHAR, field_52_012 UINT64, field_53_0123 DATETIME ARRAY, field_54_01234 UINT16, field_55_012345 HIRESTIME, field_56_0123456 INT8 ARRAY, field_57_01234567 INT64, field_58_012345678 HIRESTIME, field_59_0123456789 INT64, field_60_0 HIRESTIME ARRAY, field_61_01 UINT16, field_62_012 DATETIME, field_63_0123 DATETIME, field_64_01234 INT16, field_65_012345 HIRESTIME ARRAY, field_66_0123456 INT64, field_67_01234567 DATETIME ARRAY, field_68_012345678 DATETIME, field_69_0123456789 DATE, field_70_0 REAL, field_71_01 UINT16, field_72_012 UINT64, field_73_0123 INT8, field_74_01234 UINT64, field_75_012345 UINT8, field_76_0123456 REAL, field_77_01234567 CHAR)");
      /* 960 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 UINT32 ARRAY, field_3_0123 CHAR, field_4_01234 UINT16, field_5_012345 RICHREAL ARRAY, field_6_0123456 UINT8, field_7_01234567 UINT8, field_8_012345678 UINT16 ARRAY, field_9_0123456789 DATETIME, field_10_0 DATE ARRAY, field_11_01 DATETIME, field_12_012 DATETIME, field_13_0123 UINT64, field_14_01234 INT64, field_15_012345 INT16, field_16_0123456 DATE, field_17_01234567 REAL, field_18_012345678 UINT8, field_19_0123456789 UINT16, field_20_0 REAL, field_21_01 CHAR, field_22_012 CHAR, field_23_0123 DATETIME, field_24_01234 RICHREAL, field_25_012345 INT16, field_26_0123456 CHAR, field_27_01234567 INT16 ARRAY, field_28_012345678 BOOL, field_29_0123456789 INT32, field_30_0 CHAR, field_31_01 INT32, field_32_012 RICHREAL, field_33_0123 INT32, field_34_01234 RICHREAL ARRAY, field_35_012345 INT32, field_36_0123456 UINT64, field_37_01234567 BOOL, field_38_012345678 HIRESTIME ARRAY, field_39_0123456789 CHAR ARRAY, field_40_0 UINT8, field_41_01 UINT16, field_42_012 UINT64, field_43_0123 DATE, field_44_01234 DATE, field_45_012345 UINT64 ARRAY, field_46_0123456 RICHREAL)");
      /* 961 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL ARRAY, field_2_012 BOOL, field_3_0123 UINT16, field_4_01234 HIRESTIME, field_5_012345 UINT8, field_6_0123456 RICHREAL, field_7_01234567 BOOL, field_8_012345678 INT8, field_9_0123456789 DATE, field_10_0 INT16, field_11_01 HIRESTIME, field_12_012 HIRESTIME, field_13_0123 UINT8, field_14_01234 INT64 ARRAY, field_15_012345 INT8 ARRAY, field_16_0123456 HIRESTIME, field_17_01234567 INT8, field_18_012345678 BOOL, field_19_0123456789 RICHREAL, field_20_0 DATETIME, field_21_01 UINT8, field_22_012 HIRESTIME ARRAY, field_23_0123 UINT8, field_24_01234 UINT8, field_25_012345 DATETIME, field_26_0123456 CHAR, field_27_01234567 DATETIME, field_28_012345678 DATE ARRAY, field_29_0123456789 INT64 ARRAY, field_30_0 REAL, field_31_01 UINT32 ARRAY, field_32_012 INT32, field_33_0123 HIRESTIME, field_34_01234 REAL, field_35_012345 DATETIME, field_36_0123456 BOOL, field_37_01234567 RICHREAL, field_38_012345678 UINT8, field_39_0123456789 HIRESTIME, field_40_0 UINT64, field_41_01 RICHREAL, field_42_012 UINT32, field_43_0123 BOOL, field_44_01234 BOOL, field_45_012345 REAL, field_46_0123456 UINT16, field_47_01234567 HIRESTIME, field_48_012345678 BOOL, field_49_0123456789 UINT32, field_50_0 INT8, field_51_01 BOOL, field_52_012 RICHREAL, field_53_0123 HIRESTIME, field_54_01234 INT8 ARRAY, field_55_012345 RICHREAL, field_56_0123456 HIRESTIME ARRAY, field_57_01234567 UINT8, field_58_012345678 DATE, field_59_0123456789 HIRESTIME, field_60_0 RICHREAL, field_61_01 INT32 ARRAY, field_62_012 CHAR, field_63_0123 INT32 ARRAY, field_64_01234 REAL, field_65_012345 BOOL ARRAY, field_66_0123456 INT8, field_67_01234567 RICHREAL, field_68_012345678 UINT16 ARRAY, field_69_0123456789 DATE, field_70_0 INT32, field_71_01 BOOL, field_72_012 INT64, field_73_0123 DATETIME ARRAY, field_74_01234 UINT8, field_75_012345 DATETIME, field_76_0123456 UINT64, field_77_01234567 DATE, field_78_012345678 UINT16 ARRAY, field_79_0123456789 BOOL ARRAY, field_80_0 CHAR, field_81_01 INT64, field_82_012 BOOL ARRAY, field_83_0123 UINT8, field_84_01234 UINT64, field_85_012345 UINT8, field_86_0123456 DATETIME, field_87_01234567 CHAR, field_88_012345678 UINT8, field_89_0123456789 REAL ARRAY, field_90_0 BOOL, field_91_01 DATE, field_92_012 INT8 ARRAY, field_93_0123 UINT16, field_94_01234 UINT8 ARRAY, field_95_012345 UINT32, field_96_0123456 INT64)");
      /* 962 */ glbTypes.push_back("TABLE(field_1_01 DATE ARRAY, field_2_012 UINT32, field_3_0123 BOOL ARRAY, field_4_01234 INT32, field_5_012345 CHAR, field_6_0123456 INT32, field_7_01234567 HIRESTIME ARRAY, field_8_012345678 REAL, field_9_0123456789 HIRESTIME, field_10_0 HIRESTIME, field_11_01 UINT16, field_12_012 DATE, field_13_0123 INT16)");
      /* 963 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 DATETIME, field_3_0123 UINT64, field_4_01234 UINT8, field_5_012345 INT16, field_6_0123456 INT16, field_7_01234567 CHAR, field_8_012345678 UINT8, field_9_0123456789 CHAR, field_10_0 BOOL, field_11_01 UINT16, field_12_012 INT8)");
      /* 964 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 UINT8 ARRAY, field_3_0123 BOOL, field_4_01234 CHAR, field_5_012345 DATETIME, field_6_0123456 DATETIME, field_7_01234567 UINT64 ARRAY, field_8_012345678 BOOL, field_9_0123456789 HIRESTIME, field_10_0 CHAR ARRAY, field_11_01 INT8, field_12_012 CHAR, field_13_0123 UINT64 ARRAY, field_14_01234 REAL, field_15_012345 HIRESTIME ARRAY, field_16_0123456 UINT16, field_17_01234567 INT8, field_18_012345678 INT64, field_19_0123456789 INT16, field_20_0 DATE, field_21_01 DATETIME ARRAY, field_22_012 BOOL ARRAY, field_23_0123 HIRESTIME, field_24_01234 CHAR ARRAY, field_25_012345 INT8, field_26_0123456 DATETIME, field_27_01234567 INT8, field_28_012345678 INT16, field_29_0123456789 DATETIME, field_30_0 DATE, field_31_01 INT16, field_32_012 DATE ARRAY, field_33_0123 REAL, field_34_01234 DATETIME, field_35_012345 RICHREAL, field_36_0123456 UINT32, field_37_01234567 INT8 ARRAY, field_38_012345678 DATE, field_39_0123456789 CHAR, field_40_0 INT64, field_41_01 REAL ARRAY, field_42_012 UINT64, field_43_0123 UINT32, field_44_01234 UINT16 ARRAY, field_45_012345 INT64, field_46_0123456 INT8 ARRAY, field_47_01234567 UINT64, field_48_012345678 UINT32, field_49_0123456789 INT16, field_50_0 DATETIME, field_51_01 RICHREAL, field_52_012 REAL, field_53_0123 UINT64, field_54_01234 DATETIME ARRAY, field_55_012345 UINT16, field_56_0123456 INT16, field_57_01234567 DATE, field_58_012345678 UINT64, field_59_0123456789 BOOL, field_60_0 CHAR ARRAY, field_61_01 BOOL ARRAY, field_62_012 INT32, field_63_0123 UINT16, field_64_01234 UINT64, field_65_012345 HIRESTIME, field_66_0123456 UINT8, field_67_01234567 UINT8, field_68_012345678 UINT16, field_69_0123456789 REAL, field_70_0 UINT8, field_71_01 INT16, field_72_012 DATETIME, field_73_0123 UINT32, field_74_01234 DATETIME, field_75_012345 UINT32 ARRAY, field_76_0123456 DATETIME ARRAY, field_77_01234567 UINT8 ARRAY, field_78_012345678 RICHREAL, field_79_0123456789 REAL, field_80_0 HIRESTIME, field_81_01 INT16, field_82_012 DATE, field_83_0123 BOOL, field_84_01234 INT64, field_85_012345 HIRESTIME ARRAY, field_86_0123456 DATETIME, field_87_01234567 INT16 ARRAY, field_88_012345678 INT8, field_89_0123456789 UINT64 ARRAY)");
      /* 965 */ glbTypes.push_back("TABLE(field_1_01 UINT8 ARRAY, field_2_012 UINT64, field_3_0123 UINT32, field_4_01234 UINT32 ARRAY, field_5_012345 INT8 ARRAY, field_6_0123456 UINT32, field_7_01234567 CHAR, field_8_012345678 RICHREAL, field_9_0123456789 UINT32 ARRAY, field_10_0 UINT32, field_11_01 DATETIME, field_12_012 CHAR, field_13_0123 UINT64, field_14_01234 UINT64, field_15_012345 INT64, field_16_0123456 INT8, field_17_01234567 INT16, field_18_012345678 CHAR, field_19_0123456789 HIRESTIME, field_20_0 INT32, field_21_01 UINT32, field_22_012 RICHREAL ARRAY, field_23_0123 UINT64, field_24_01234 RICHREAL, field_25_012345 INT8, field_26_0123456 HIRESTIME, field_27_01234567 BOOL, field_28_012345678 CHAR ARRAY, field_29_0123456789 INT16, field_30_0 INT32, field_31_01 UINT16, field_32_012 DATE, field_33_0123 UINT8, field_34_01234 REAL ARRAY, field_35_012345 BOOL, field_36_0123456 DATE, field_37_01234567 DATETIME, field_38_012345678 UINT16)");
      /* 966 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 HIRESTIME ARRAY, field_3_0123 UINT64, field_4_01234 DATE, field_5_012345 DATETIME, field_6_0123456 UINT8, field_7_01234567 BOOL, field_8_012345678 RICHREAL, field_9_0123456789 UINT32, field_10_0 UINT8, field_11_01 CHAR, field_12_012 DATE, field_13_0123 UINT16, field_14_01234 BOOL, field_15_012345 DATE, field_16_0123456 INT16, field_17_01234567 CHAR, field_18_012345678 UINT64, field_19_0123456789 DATE, field_20_0 BOOL ARRAY, field_21_01 UINT8, field_22_012 RICHREAL, field_23_0123 INT32, field_24_01234 CHAR, field_25_012345 UINT8, field_26_0123456 CHAR, field_27_01234567 UINT64, field_28_012345678 UINT16 ARRAY, field_29_0123456789 INT64, field_30_0 INT32, field_31_01 CHAR, field_32_012 INT8 ARRAY, field_33_0123 CHAR ARRAY, field_34_01234 DATE, field_35_012345 INT8, field_36_0123456 UINT32 ARRAY, field_37_01234567 HIRESTIME, field_38_012345678 UINT8, field_39_0123456789 REAL ARRAY, field_40_0 RICHREAL, field_41_01 HIRESTIME, field_42_012 UINT32 ARRAY, field_43_0123 CHAR, field_44_01234 INT64, field_45_012345 DATE, field_46_0123456 DATE ARRAY, field_47_01234567 BOOL, field_48_012345678 UINT8, field_49_0123456789 UINT64, field_50_0 RICHREAL, field_51_01 INT64, field_52_012 CHAR, field_53_0123 UINT8 ARRAY, field_54_01234 UINT64, field_55_012345 UINT8, field_56_0123456 HIRESTIME ARRAY, field_57_01234567 HIRESTIME, field_58_012345678 DATETIME, field_59_0123456789 INT8, field_60_0 UINT16, field_61_01 INT8)");
      /* 967 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 HIRESTIME, field_3_0123 INT32, field_4_01234 INT16 ARRAY, field_5_012345 RICHREAL, field_6_0123456 INT16 ARRAY, field_7_01234567 DATETIME, field_8_012345678 UINT8, field_9_0123456789 INT64, field_10_0 UINT32, field_11_01 INT8 ARRAY, field_12_012 INT8, field_13_0123 UINT32, field_14_01234 DATETIME, field_15_012345 UINT32, field_16_0123456 UINT16, field_17_01234567 RICHREAL, field_18_012345678 INT64, field_19_0123456789 INT16, field_20_0 RICHREAL, field_21_01 INT32, field_22_012 INT64, field_23_0123 UINT32, field_24_01234 UINT32, field_25_012345 INT64, field_26_0123456 REAL, field_27_01234567 UINT64 ARRAY, field_28_012345678 DATE, field_29_0123456789 DATE ARRAY, field_30_0 INT32, field_31_01 CHAR, field_32_012 REAL, field_33_0123 BOOL ARRAY, field_34_01234 INT16, field_35_012345 DATE, field_36_0123456 REAL, field_37_01234567 INT16, field_38_012345678 UINT32, field_39_0123456789 INT16, field_40_0 UINT16, field_41_01 UINT64, field_42_012 BOOL, field_43_0123 INT16 ARRAY, field_44_01234 HIRESTIME ARRAY, field_45_012345 INT16, field_46_0123456 UINT8 ARRAY, field_47_01234567 BOOL, field_48_012345678 BOOL, field_49_0123456789 REAL ARRAY, field_50_0 REAL, field_51_01 UINT64, field_52_012 UINT64, field_53_0123 RICHREAL, field_54_01234 HIRESTIME, field_55_012345 UINT8 ARRAY, field_56_0123456 CHAR, field_57_01234567 INT64, field_58_012345678 HIRESTIME ARRAY, field_59_0123456789 DATE ARRAY, field_60_0 DATE ARRAY, field_61_01 DATETIME, field_62_012 UINT64)");
      /* 968 */ glbTypes.push_back("TABLE(field_1_01 BOOL ARRAY, field_2_012 CHAR, field_3_0123 REAL, field_4_01234 DATETIME, field_5_012345 INT32, field_6_0123456 BOOL, field_7_01234567 INT16, field_8_012345678 DATETIME, field_9_0123456789 UINT16, field_10_0 HIRESTIME, field_11_01 BOOL, field_12_012 UINT32, field_13_0123 UINT8 ARRAY, field_14_01234 CHAR ARRAY, field_15_012345 INT16, field_16_0123456 INT8, field_17_01234567 INT8, field_18_012345678 UINT8, field_19_0123456789 RICHREAL ARRAY, field_20_0 REAL, field_21_01 DATETIME, field_22_012 CHAR, field_23_0123 INT16, field_24_01234 INT32, field_25_012345 UINT64 ARRAY, field_26_0123456 INT16, field_27_01234567 UINT32, field_28_012345678 INT32, field_29_0123456789 BOOL, field_30_0 DATE)");
      /* 969 */ glbTypes.push_back("TABLE(field_1_01 INT8 ARRAY, field_2_012 UINT8, field_3_0123 REAL, field_4_01234 INT32 ARRAY, field_5_012345 INT8, field_6_0123456 DATETIME, field_7_01234567 DATE, field_8_012345678 UINT32 ARRAY, field_9_0123456789 INT16, field_10_0 INT8, field_11_01 BOOL, field_12_012 DATE, field_13_0123 INT16, field_14_01234 HIRESTIME, field_15_012345 HIRESTIME, field_16_0123456 BOOL, field_17_01234567 REAL, field_18_012345678 INT8, field_19_0123456789 INT32, field_20_0 CHAR ARRAY, field_21_01 INT8 ARRAY, field_22_012 REAL ARRAY, field_23_0123 INT32, field_24_01234 INT32, field_25_012345 HIRESTIME, field_26_0123456 CHAR, field_27_01234567 UINT8, field_28_012345678 REAL, field_29_0123456789 DATETIME, field_30_0 RICHREAL ARRAY, field_31_01 BOOL, field_32_012 HIRESTIME, field_33_0123 RICHREAL, field_34_01234 BOOL ARRAY, field_35_012345 INT32, field_36_0123456 DATE, field_37_01234567 UINT8, field_38_012345678 UINT32, field_39_0123456789 HIRESTIME ARRAY, field_40_0 RICHREAL, field_41_01 UINT8, field_42_012 BOOL, field_43_0123 DATE, field_44_01234 BOOL, field_45_012345 HIRESTIME ARRAY, field_46_0123456 UINT32, field_47_01234567 CHAR, field_48_012345678 UINT32, field_49_0123456789 DATE ARRAY, field_50_0 DATE, field_51_01 DATETIME ARRAY, field_52_012 HIRESTIME ARRAY, field_53_0123 INT64, field_54_01234 UINT16, field_55_012345 INT16 ARRAY, field_56_0123456 DATETIME, field_57_01234567 UINT16, field_58_012345678 UINT16, field_59_0123456789 INT16, field_60_0 CHAR ARRAY, field_61_01 HIRESTIME ARRAY, field_62_012 BOOL, field_63_0123 HIRESTIME, field_64_01234 INT32 ARRAY)");
      /* 970 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 INT64, field_3_0123 INT32 ARRAY, field_4_01234 RICHREAL ARRAY, field_5_012345 RICHREAL, field_6_0123456 RICHREAL, field_7_01234567 UINT64 ARRAY, field_8_012345678 INT16 ARRAY, field_9_0123456789 INT64, field_10_0 INT16, field_11_01 CHAR, field_12_012 DATETIME, field_13_0123 BOOL, field_14_01234 CHAR, field_15_012345 UINT16 ARRAY, field_16_0123456 INT16, field_17_01234567 UINT32, field_18_012345678 INT8 ARRAY, field_19_0123456789 INT64 ARRAY, field_20_0 RICHREAL, field_21_01 DATE, field_22_012 HIRESTIME, field_23_0123 UINT8, field_24_01234 INT16, field_25_012345 HIRESTIME, field_26_0123456 INT64, field_27_01234567 INT8 ARRAY, field_28_012345678 RICHREAL, field_29_0123456789 INT8, field_30_0 RICHREAL, field_31_01 BOOL ARRAY, field_32_012 UINT32, field_33_0123 INT8, field_34_01234 CHAR, field_35_012345 INT64, field_36_0123456 REAL, field_37_01234567 INT64, field_38_012345678 CHAR, field_39_0123456789 INT16, field_40_0 UINT64, field_41_01 DATETIME, field_42_012 DATETIME, field_43_0123 UINT64, field_44_01234 HIRESTIME, field_45_012345 REAL, field_46_0123456 HIRESTIME, field_47_01234567 UINT8, field_48_012345678 DATE ARRAY, field_49_0123456789 DATE, field_50_0 HIRESTIME, field_51_01 UINT8 ARRAY, field_52_012 CHAR, field_53_0123 UINT64, field_54_01234 CHAR, field_55_012345 INT8 ARRAY, field_56_0123456 RICHREAL, field_57_01234567 INT16, field_58_012345678 BOOL, field_59_0123456789 DATETIME, field_60_0 UINT32, field_61_01 UINT8, field_62_012 INT16, field_63_0123 DATE ARRAY, field_64_01234 INT32, field_65_012345 HIRESTIME ARRAY, field_66_0123456 CHAR, field_67_01234567 BOOL, field_68_012345678 RICHREAL, field_69_0123456789 RICHREAL, field_70_0 DATETIME, field_71_01 UINT8, field_72_012 INT16, field_73_0123 RICHREAL, field_74_01234 UINT32, field_75_012345 UINT32, field_76_0123456 RICHREAL ARRAY, field_77_01234567 UINT32, field_78_012345678 RICHREAL, field_79_0123456789 HIRESTIME ARRAY, field_80_0 DATETIME ARRAY, field_81_01 BOOL, field_82_012 REAL, field_83_0123 INT8 ARRAY, field_84_01234 UINT16, field_85_012345 HIRESTIME, field_86_0123456 UINT32, field_87_01234567 DATE, field_88_012345678 UINT32, field_89_0123456789 DATE, field_90_0 CHAR, field_91_01 UINT32, field_92_012 RICHREAL)");
      /* 971 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 INT64, field_3_0123 UINT16, field_4_01234 UINT8 ARRAY, field_5_012345 DATE, field_6_0123456 DATETIME ARRAY, field_7_01234567 UINT8, field_8_012345678 UINT8 ARRAY, field_9_0123456789 UINT32, field_10_0 UINT64, field_11_01 BOOL, field_12_012 RICHREAL, field_13_0123 INT32, field_14_01234 DATE, field_15_012345 INT32, field_16_0123456 DATE ARRAY, field_17_01234567 INT16, field_18_012345678 DATETIME, field_19_0123456789 REAL, field_20_0 DATETIME, field_21_01 DATE ARRAY, field_22_012 UINT32, field_23_0123 UINT16 ARRAY, field_24_01234 DATETIME ARRAY, field_25_012345 BOOL, field_26_0123456 INT16, field_27_01234567 HIRESTIME, field_28_012345678 HIRESTIME, field_29_0123456789 INT16, field_30_0 CHAR, field_31_01 CHAR, field_32_012 DATE, field_33_0123 CHAR ARRAY, field_34_01234 UINT8, field_35_012345 REAL, field_36_0123456 HIRESTIME, field_37_01234567 INT8, field_38_012345678 UINT32, field_39_0123456789 HIRESTIME ARRAY, field_40_0 INT64, field_41_01 INT32, field_42_012 DATE, field_43_0123 UINT16, field_44_01234 REAL ARRAY, field_45_012345 UINT64, field_46_0123456 INT16)");
      /* 972 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 INT64, field_3_0123 DATE, field_4_01234 INT32, field_5_012345 DATETIME, field_6_0123456 INT8, field_7_01234567 UINT64 ARRAY, field_8_012345678 UINT16, field_9_0123456789 INT64 ARRAY, field_10_0 DATETIME, field_11_01 RICHREAL, field_12_012 REAL ARRAY, field_13_0123 UINT64 ARRAY, field_14_01234 INT16, field_15_012345 UINT16 ARRAY, field_16_0123456 RICHREAL ARRAY, field_17_01234567 INT16, field_18_012345678 HIRESTIME ARRAY, field_19_0123456789 BOOL, field_20_0 DATE, field_21_01 INT16, field_22_012 BOOL, field_23_0123 HIRESTIME, field_24_01234 RICHREAL, field_25_012345 INT16, field_26_0123456 UINT16, field_27_01234567 INT8, field_28_012345678 HIRESTIME ARRAY, field_29_0123456789 UINT64, field_30_0 BOOL, field_31_01 INT32, field_32_012 BOOL ARRAY, field_33_0123 HIRESTIME, field_34_01234 INT32, field_35_012345 UINT8, field_36_0123456 INT64, field_37_01234567 REAL, field_38_012345678 DATETIME, field_39_0123456789 REAL, field_40_0 BOOL ARRAY, field_41_01 BOOL, field_42_012 UINT64 ARRAY, field_43_0123 UINT64, field_44_01234 INT8, field_45_012345 DATETIME, field_46_0123456 REAL, field_47_01234567 INT64, field_48_012345678 DATE, field_49_0123456789 DATE, field_50_0 UINT16, field_51_01 INT64, field_52_012 INT16 ARRAY, field_53_0123 INT32, field_54_01234 UINT8, field_55_012345 CHAR, field_56_0123456 INT8, field_57_01234567 RICHREAL, field_58_012345678 DATETIME, field_59_0123456789 INT32 ARRAY, field_60_0 RICHREAL, field_61_01 REAL, field_62_012 INT64 ARRAY, field_63_0123 INT16, field_64_01234 BOOL, field_65_012345 INT16, field_66_0123456 BOOL ARRAY, field_67_01234567 UINT8, field_68_012345678 DATE, field_69_0123456789 UINT16, field_70_0 DATETIME, field_71_01 RICHREAL, field_72_012 REAL, field_73_0123 RICHREAL, field_74_01234 DATETIME, field_75_012345 BOOL, field_76_0123456 INT32, field_77_01234567 REAL, field_78_012345678 CHAR, field_79_0123456789 UINT16, field_80_0 CHAR, field_81_01 CHAR, field_82_012 CHAR ARRAY, field_83_0123 UINT16 ARRAY, field_84_01234 UINT32, field_85_012345 UINT16)");
      /* 973 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 INT32, field_3_0123 INT8, field_4_01234 UINT32, field_5_012345 INT8 ARRAY, field_6_0123456 DATE, field_7_01234567 BOOL, field_8_012345678 INT16, field_9_0123456789 INT32 ARRAY, field_10_0 INT64, field_11_01 INT32, field_12_012 INT16, field_13_0123 INT16, field_14_01234 DATE, field_15_012345 DATE, field_16_0123456 RICHREAL ARRAY, field_17_01234567 BOOL ARRAY, field_18_012345678 DATE, field_19_0123456789 INT8 ARRAY, field_20_0 UINT8)");
      /* 974 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 HIRESTIME ARRAY, field_3_0123 CHAR ARRAY, field_4_01234 UINT16, field_5_012345 UINT8 ARRAY, field_6_0123456 CHAR, field_7_01234567 UINT8 ARRAY, field_8_012345678 DATE ARRAY, field_9_0123456789 BOOL ARRAY)");
      /* 975 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 INT32 ARRAY, field_3_0123 INT8, field_4_01234 RICHREAL ARRAY, field_5_012345 INT16 ARRAY, field_6_0123456 REAL ARRAY, field_7_01234567 INT8, field_8_012345678 UINT8, field_9_0123456789 UINT8, field_10_0 INT8 ARRAY, field_11_01 HIRESTIME, field_12_012 INT16, field_13_0123 INT16, field_14_01234 CHAR, field_15_012345 BOOL, field_16_0123456 REAL, field_17_01234567 HIRESTIME, field_18_012345678 UINT32, field_19_0123456789 DATE, field_20_0 UINT64, field_21_01 UINT16, field_22_012 DATE, field_23_0123 UINT16 ARRAY, field_24_01234 INT32 ARRAY, field_25_012345 UINT32, field_26_0123456 INT32, field_27_01234567 RICHREAL ARRAY, field_28_012345678 RICHREAL, field_29_0123456789 DATE, field_30_0 BOOL ARRAY, field_31_01 INT8)");
      /* 976 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 INT64, field_3_0123 INT8, field_4_01234 BOOL, field_5_012345 UINT64, field_6_0123456 INT16, field_7_01234567 UINT64, field_8_012345678 INT32, field_9_0123456789 CHAR, field_10_0 RICHREAL, field_11_01 RICHREAL, field_12_012 UINT8, field_13_0123 INT32, field_14_01234 DATETIME, field_15_012345 BOOL, field_16_0123456 UINT32, field_17_01234567 INT16, field_18_012345678 REAL, field_19_0123456789 RICHREAL, field_20_0 UINT64 ARRAY, field_21_01 INT16, field_22_012 INT16 ARRAY, field_23_0123 DATE ARRAY, field_24_01234 INT32, field_25_012345 UINT16, field_26_0123456 DATETIME, field_27_01234567 UINT8, field_28_012345678 HIRESTIME ARRAY, field_29_0123456789 INT8, field_30_0 INT64, field_31_01 BOOL, field_32_012 INT16, field_33_0123 UINT32, field_34_01234 UINT8, field_35_012345 INT8, field_36_0123456 DATETIME, field_37_01234567 INT32, field_38_012345678 UINT64 ARRAY, field_39_0123456789 UINT64 ARRAY, field_40_0 DATETIME, field_41_01 CHAR, field_42_012 INT8, field_43_0123 RICHREAL ARRAY, field_44_01234 HIRESTIME ARRAY, field_45_012345 INT16, field_46_0123456 CHAR, field_47_01234567 DATETIME ARRAY, field_48_012345678 CHAR, field_49_0123456789 HIRESTIME ARRAY, field_50_0 RICHREAL, field_51_01 CHAR ARRAY, field_52_012 INT32, field_53_0123 RICHREAL ARRAY, field_54_01234 DATETIME, field_55_012345 RICHREAL, field_56_0123456 DATE, field_57_01234567 UINT16 ARRAY, field_58_012345678 HIRESTIME, field_59_0123456789 DATETIME, field_60_0 INT8, field_61_01 BOOL ARRAY, field_62_012 REAL, field_63_0123 UINT16, field_64_01234 UINT8, field_65_012345 REAL ARRAY, field_66_0123456 UINT32, field_67_01234567 INT8, field_68_012345678 DATE)");
      /* 977 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 DATETIME, field_3_0123 CHAR, field_4_01234 INT64, field_5_012345 CHAR, field_6_0123456 INT8, field_7_01234567 UINT64, field_8_012345678 INT32 ARRAY, field_9_0123456789 RICHREAL ARRAY, field_10_0 UINT16, field_11_01 INT16, field_12_012 BOOL, field_13_0123 INT16, field_14_01234 DATE, field_15_012345 INT32, field_16_0123456 DATETIME, field_17_01234567 UINT8 ARRAY, field_18_012345678 DATE ARRAY, field_19_0123456789 DATETIME ARRAY, field_20_0 DATE, field_21_01 BOOL, field_22_012 HIRESTIME, field_23_0123 CHAR, field_24_01234 DATETIME, field_25_012345 INT32, field_26_0123456 UINT16, field_27_01234567 REAL, field_28_012345678 RICHREAL, field_29_0123456789 UINT64, field_30_0 RICHREAL ARRAY, field_31_01 INT16, field_32_012 BOOL, field_33_0123 INT64 ARRAY, field_34_01234 CHAR, field_35_012345 INT8 ARRAY, field_36_0123456 INT8, field_37_01234567 UINT8 ARRAY, field_38_012345678 RICHREAL, field_39_0123456789 INT64, field_40_0 INT16 ARRAY, field_41_01 DATE ARRAY, field_42_012 INT32, field_43_0123 UINT64, field_44_01234 UINT8)");
      /* 978 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 UINT16, field_3_0123 BOOL ARRAY, field_4_01234 UINT64, field_5_012345 REAL, field_6_0123456 DATETIME, field_7_01234567 UINT8, field_8_012345678 INT8, field_9_0123456789 UINT64, field_10_0 UINT64 ARRAY, field_11_01 BOOL, field_12_012 RICHREAL, field_13_0123 HIRESTIME, field_14_01234 DATE, field_15_012345 INT8 ARRAY, field_16_0123456 INT64, field_17_01234567 UINT8, field_18_012345678 CHAR, field_19_0123456789 REAL, field_20_0 DATETIME, field_21_01 DATE, field_22_012 HIRESTIME, field_23_0123 INT16, field_24_01234 UINT8, field_25_012345 INT64, field_26_0123456 UINT32, field_27_01234567 UINT64, field_28_012345678 UINT8, field_29_0123456789 UINT64, field_30_0 REAL, field_31_01 REAL ARRAY, field_32_012 UINT32, field_33_0123 HIRESTIME, field_34_01234 INT64, field_35_012345 INT32, field_36_0123456 INT8, field_37_01234567 BOOL, field_38_012345678 UINT16, field_39_0123456789 INT16, field_40_0 RICHREAL, field_41_01 INT8, field_42_012 UINT8 ARRAY, field_43_0123 INT8, field_44_01234 UINT32, field_45_012345 INT8 ARRAY, field_46_0123456 UINT8, field_47_01234567 REAL, field_48_012345678 DATE, field_49_0123456789 CHAR, field_50_0 HIRESTIME, field_51_01 DATETIME)");
      /* 979 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 DATETIME, field_3_0123 INT16, field_4_01234 BOOL, field_5_012345 INT16, field_6_0123456 INT32 ARRAY, field_7_01234567 INT64 ARRAY, field_8_012345678 DATE, field_9_0123456789 DATETIME, field_10_0 UINT64 ARRAY, field_11_01 DATETIME ARRAY, field_12_012 UINT32, field_13_0123 INT16, field_14_01234 HIRESTIME, field_15_012345 UINT32, field_16_0123456 INT8 ARRAY, field_17_01234567 CHAR, field_18_012345678 UINT16, field_19_0123456789 INT8, field_20_0 DATE ARRAY, field_21_01 INT16, field_22_012 CHAR, field_23_0123 REAL, field_24_01234 DATE, field_25_012345 RICHREAL, field_26_0123456 UINT8, field_27_01234567 INT32, field_28_012345678 BOOL ARRAY, field_29_0123456789 REAL, field_30_0 INT8, field_31_01 UINT16 ARRAY, field_32_012 REAL, field_33_0123 CHAR ARRAY, field_34_01234 UINT16, field_35_012345 HIRESTIME ARRAY, field_36_0123456 DATETIME, field_37_01234567 INT32, field_38_012345678 INT64, field_39_0123456789 REAL ARRAY, field_40_0 INT32 ARRAY, field_41_01 INT64, field_42_012 INT16, field_43_0123 DATE, field_44_01234 RICHREAL, field_45_012345 UINT8, field_46_0123456 HIRESTIME, field_47_01234567 CHAR, field_48_012345678 UINT16, field_49_0123456789 BOOL, field_50_0 INT32 ARRAY, field_51_01 INT64, field_52_012 UINT16 ARRAY, field_53_0123 UINT16, field_54_01234 UINT32 ARRAY)");
      /* 980 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 BOOL, field_3_0123 UINT32, field_4_01234 DATETIME, field_5_012345 REAL, field_6_0123456 DATE, field_7_01234567 UINT16, field_8_012345678 INT32, field_9_0123456789 DATETIME ARRAY, field_10_0 INT8 ARRAY, field_11_01 DATE ARRAY, field_12_012 INT64, field_13_0123 RICHREAL, field_14_01234 REAL, field_15_012345 UINT16, field_16_0123456 UINT16, field_17_01234567 UINT8, field_18_012345678 RICHREAL, field_19_0123456789 HIRESTIME ARRAY, field_20_0 INT64 ARRAY, field_21_01 DATE, field_22_012 INT32, field_23_0123 REAL, field_24_01234 UINT16 ARRAY, field_25_012345 HIRESTIME ARRAY, field_26_0123456 UINT8, field_27_01234567 DATE ARRAY, field_28_012345678 INT8, field_29_0123456789 INT8, field_30_0 DATETIME, field_31_01 BOOL, field_32_012 INT64 ARRAY, field_33_0123 INT16, field_34_01234 INT8 ARRAY, field_35_012345 DATETIME, field_36_0123456 DATETIME, field_37_01234567 UINT16, field_38_012345678 INT16, field_39_0123456789 HIRESTIME, field_40_0 UINT32 ARRAY, field_41_01 INT64, field_42_012 RICHREAL, field_43_0123 INT16, field_44_01234 INT32, field_45_012345 INT32, field_46_0123456 DATE ARRAY, field_47_01234567 UINT8, field_48_012345678 BOOL, field_49_0123456789 INT16, field_50_0 UINT16, field_51_01 UINT32, field_52_012 INT8, field_53_0123 UINT32, field_54_01234 UINT32, field_55_012345 HIRESTIME, field_56_0123456 DATE, field_57_01234567 BOOL ARRAY)");
      /* 981 */ glbTypes.push_back("TABLE(field_1_01 INT16 ARRAY, field_2_012 DATE ARRAY, field_3_0123 BOOL, field_4_01234 INT16, field_5_012345 UINT16, field_6_0123456 INT32, field_7_01234567 INT64, field_8_012345678 INT16 ARRAY, field_9_0123456789 INT64, field_10_0 UINT32, field_11_01 BOOL, field_12_012 REAL, field_13_0123 UINT64, field_14_01234 REAL, field_15_012345 UINT16, field_16_0123456 UINT32 ARRAY, field_17_01234567 CHAR, field_18_012345678 UINT64, field_19_0123456789 REAL ARRAY, field_20_0 REAL, field_21_01 CHAR, field_22_012 REAL, field_23_0123 UINT16, field_24_01234 UINT64 ARRAY, field_25_012345 INT64 ARRAY, field_26_0123456 DATE ARRAY, field_27_01234567 REAL, field_28_012345678 UINT64, field_29_0123456789 REAL, field_30_0 UINT64 ARRAY, field_31_01 DATETIME ARRAY, field_32_012 UINT32, field_33_0123 UINT16, field_34_01234 INT8 ARRAY, field_35_012345 HIRESTIME, field_36_0123456 INT32, field_37_01234567 DATE ARRAY, field_38_012345678 UINT16 ARRAY, field_39_0123456789 INT16 ARRAY, field_40_0 INT16 ARRAY, field_41_01 UINT8, field_42_012 UINT32, field_43_0123 INT32, field_44_01234 DATE, field_45_012345 DATETIME, field_46_0123456 INT64, field_47_01234567 UINT64, field_48_012345678 CHAR, field_49_0123456789 CHAR, field_50_0 INT32 ARRAY, field_51_01 BOOL ARRAY, field_52_012 HIRESTIME, field_53_0123 RICHREAL, field_54_01234 CHAR, field_55_012345 CHAR, field_56_0123456 DATETIME ARRAY, field_57_01234567 RICHREAL, field_58_012345678 INT16, field_59_0123456789 CHAR ARRAY, field_60_0 UINT8 ARRAY, field_61_01 REAL ARRAY, field_62_012 UINT8, field_63_0123 RICHREAL, field_64_01234 DATE, field_65_012345 UINT64, field_66_0123456 UINT8, field_67_01234567 UINT8, field_68_012345678 UINT64, field_69_0123456789 UINT16, field_70_0 UINT8 ARRAY, field_71_01 BOOL, field_72_012 INT8, field_73_0123 INT16 ARRAY, field_74_01234 CHAR, field_75_012345 RICHREAL, field_76_0123456 INT16 ARRAY, field_77_01234567 INT16, field_78_012345678 UINT16, field_79_0123456789 INT32, field_80_0 CHAR, field_81_01 HIRESTIME, field_82_012 REAL, field_83_0123 INT32, field_84_01234 DATETIME, field_85_012345 INT16, field_86_0123456 RICHREAL, field_87_01234567 CHAR ARRAY, field_88_012345678 RICHREAL, field_89_0123456789 BOOL ARRAY)");
      /* 982 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 INT8, field_3_0123 UINT64, field_4_01234 UINT64, field_5_012345 CHAR, field_6_0123456 INT8, field_7_01234567 INT64, field_8_012345678 REAL ARRAY, field_9_0123456789 INT8, field_10_0 UINT16 ARRAY, field_11_01 INT8, field_12_012 REAL, field_13_0123 CHAR ARRAY, field_14_01234 INT8, field_15_012345 INT32, field_16_0123456 UINT16, field_17_01234567 HIRESTIME, field_18_012345678 UINT16, field_19_0123456789 INT8, field_20_0 INT32 ARRAY, field_21_01 DATETIME, field_22_012 UINT32, field_23_0123 UINT64, field_24_01234 BOOL, field_25_012345 UINT8 ARRAY, field_26_0123456 UINT8 ARRAY, field_27_01234567 INT8, field_28_012345678 INT8, field_29_0123456789 UINT32, field_30_0 INT32 ARRAY, field_31_01 INT16, field_32_012 UINT32, field_33_0123 UINT16, field_34_01234 DATETIME, field_35_012345 UINT64, field_36_0123456 INT32 ARRAY, field_37_01234567 RICHREAL, field_38_012345678 BOOL, field_39_0123456789 RICHREAL, field_40_0 DATE ARRAY, field_41_01 HIRESTIME, field_42_012 UINT16, field_43_0123 INT64, field_44_01234 HIRESTIME, field_45_012345 DATETIME, field_46_0123456 REAL, field_47_01234567 DATE, field_48_012345678 UINT64, field_49_0123456789 RICHREAL ARRAY, field_50_0 UINT8, field_51_01 UINT64 ARRAY, field_52_012 INT32, field_53_0123 HIRESTIME, field_54_01234 DATE ARRAY, field_55_012345 DATE, field_56_0123456 CHAR, field_57_01234567 UINT32, field_58_012345678 DATETIME, field_59_0123456789 INT8, field_60_0 INT32, field_61_01 INT8, field_62_012 INT64, field_63_0123 UINT16, field_64_01234 DATETIME, field_65_012345 INT64 ARRAY, field_66_0123456 HIRESTIME, field_67_01234567 INT8, field_68_012345678 BOOL, field_69_0123456789 UINT8, field_70_0 RICHREAL, field_71_01 REAL, field_72_012 DATE, field_73_0123 DATETIME)");
      /* 983 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 DATETIME, field_3_0123 UINT64 ARRAY, field_4_01234 HIRESTIME ARRAY, field_5_012345 INT64, field_6_0123456 INT64, field_7_01234567 UINT32, field_8_012345678 DATETIME, field_9_0123456789 INT8 ARRAY, field_10_0 UINT8, field_11_01 INT64, field_12_012 REAL, field_13_0123 UINT64, field_14_01234 INT8, field_15_012345 RICHREAL, field_16_0123456 INT32, field_17_01234567 RICHREAL, field_18_012345678 BOOL, field_19_0123456789 INT32, field_20_0 BOOL, field_21_01 UINT8 ARRAY, field_22_012 RICHREAL, field_23_0123 REAL ARRAY, field_24_01234 REAL ARRAY, field_25_012345 INT32, field_26_0123456 INT64, field_27_01234567 INT32, field_28_012345678 DATETIME ARRAY, field_29_0123456789 HIRESTIME, field_30_0 INT8, field_31_01 RICHREAL, field_32_012 INT64, field_33_0123 BOOL, field_34_01234 UINT64 ARRAY, field_35_012345 INT32, field_36_0123456 DATE, field_37_01234567 UINT16, field_38_012345678 CHAR, field_39_0123456789 CHAR, field_40_0 INT8, field_41_01 INT64 ARRAY, field_42_012 UINT64 ARRAY, field_43_0123 INT16 ARRAY, field_44_01234 BOOL, field_45_012345 BOOL, field_46_0123456 UINT8, field_47_01234567 DATE, field_48_012345678 UINT16, field_49_0123456789 DATETIME, field_50_0 CHAR, field_51_01 HIRESTIME, field_52_012 INT64, field_53_0123 UINT64, field_54_01234 INT64, field_55_012345 DATE, field_56_0123456 REAL, field_57_01234567 BOOL, field_58_012345678 RICHREAL, field_59_0123456789 UINT32, field_60_0 UINT16, field_61_01 DATE, field_62_012 INT32, field_63_0123 HIRESTIME, field_64_01234 INT8, field_65_012345 BOOL, field_66_0123456 UINT64 ARRAY, field_67_01234567 UINT32 ARRAY, field_68_012345678 UINT8 ARRAY, field_69_0123456789 DATETIME ARRAY, field_70_0 UINT8, field_71_01 INT8, field_72_012 DATETIME, field_73_0123 INT16)");
      /* 984 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME, field_2_012 DATETIME, field_3_0123 UINT32, field_4_01234 INT8, field_5_012345 BOOL, field_6_0123456 HIRESTIME, field_7_01234567 INT8 ARRAY, field_8_012345678 INT64, field_9_0123456789 CHAR, field_10_0 UINT16, field_11_01 INT8 ARRAY, field_12_012 UINT32, field_13_0123 UINT16, field_14_01234 INT8, field_15_012345 UINT8, field_16_0123456 INT64, field_17_01234567 RICHREAL, field_18_012345678 UINT32, field_19_0123456789 UINT64, field_20_0 UINT8 ARRAY, field_21_01 INT64 ARRAY, field_22_012 BOOL, field_23_0123 INT16, field_24_01234 CHAR, field_25_012345 CHAR, field_26_0123456 REAL ARRAY, field_27_01234567 REAL, field_28_012345678 UINT16, field_29_0123456789 INT64, field_30_0 UINT8, field_31_01 UINT64, field_32_012 RICHREAL)");
      /* 985 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 UINT64, field_3_0123 DATE, field_4_01234 DATE, field_5_012345 INT64, field_6_0123456 INT8 ARRAY, field_7_01234567 RICHREAL, field_8_012345678 UINT32, field_9_0123456789 UINT64 ARRAY, field_10_0 BOOL, field_11_01 INT32, field_12_012 UINT64 ARRAY, field_13_0123 INT16, field_14_01234 CHAR, field_15_012345 UINT8, field_16_0123456 CHAR, field_17_01234567 BOOL, field_18_012345678 BOOL, field_19_0123456789 REAL, field_20_0 INT8, field_21_01 UINT32 ARRAY, field_22_012 INT32, field_23_0123 DATE, field_24_01234 INT8, field_25_012345 RICHREAL, field_26_0123456 INT64, field_27_01234567 UINT64 ARRAY, field_28_012345678 INT8, field_29_0123456789 UINT64, field_30_0 RICHREAL, field_31_01 DATETIME, field_32_012 DATETIME, field_33_0123 DATETIME, field_34_01234 CHAR, field_35_012345 HIRESTIME, field_36_0123456 DATE, field_37_01234567 REAL ARRAY, field_38_012345678 INT64, field_39_0123456789 DATE, field_40_0 DATE, field_41_01 RICHREAL, field_42_012 INT64, field_43_0123 DATE, field_44_01234 UINT8, field_45_012345 RICHREAL, field_46_0123456 CHAR, field_47_01234567 INT8, field_48_012345678 BOOL, field_49_0123456789 UINT32, field_50_0 HIRESTIME, field_51_01 DATE, field_52_012 INT16 ARRAY, field_53_0123 BOOL ARRAY, field_54_01234 RICHREAL ARRAY)");
      /* 986 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 INT16, field_3_0123 BOOL, field_4_01234 DATETIME, field_5_012345 RICHREAL ARRAY, field_6_0123456 BOOL, field_7_01234567 UINT32, field_8_012345678 INT8, field_9_0123456789 BOOL, field_10_0 CHAR, field_11_01 RICHREAL, field_12_012 DATE, field_13_0123 INT64, field_14_01234 INT32, field_15_012345 CHAR, field_16_0123456 UINT64, field_17_01234567 REAL, field_18_012345678 UINT8, field_19_0123456789 CHAR, field_20_0 CHAR, field_21_01 INT16 ARRAY, field_22_012 INT64, field_23_0123 INT64, field_24_01234 INT32 ARRAY, field_25_012345 UINT64, field_26_0123456 BOOL, field_27_01234567 REAL ARRAY, field_28_012345678 DATETIME ARRAY, field_29_0123456789 CHAR, field_30_0 INT16, field_31_01 RICHREAL ARRAY, field_32_012 DATETIME, field_33_0123 UINT64, field_34_01234 INT32, field_35_012345 INT16, field_36_0123456 UINT8, field_37_01234567 INT16, field_38_012345678 RICHREAL, field_39_0123456789 DATE, field_40_0 INT32, field_41_01 INT8, field_42_012 INT16, field_43_0123 INT32, field_44_01234 CHAR ARRAY, field_45_012345 CHAR, field_46_0123456 RICHREAL, field_47_01234567 INT64, field_48_012345678 INT8 ARRAY, field_49_0123456789 HIRESTIME, field_50_0 DATETIME, field_51_01 UINT16 ARRAY)");
      /* 987 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 CHAR, field_3_0123 INT8 ARRAY, field_4_01234 INT8, field_5_012345 UINT64, field_6_0123456 INT8, field_7_01234567 UINT8, field_8_012345678 BOOL, field_9_0123456789 UINT64, field_10_0 DATE, field_11_01 INT16, field_12_012 INT8, field_13_0123 INT64, field_14_01234 HIRESTIME, field_15_012345 REAL ARRAY, field_16_0123456 DATE ARRAY, field_17_01234567 INT32, field_18_012345678 UINT64, field_19_0123456789 INT64, field_20_0 INT16, field_21_01 UINT8, field_22_012 RICHREAL, field_23_0123 DATETIME, field_24_01234 INT32 ARRAY, field_25_012345 UINT8 ARRAY, field_26_0123456 INT64)");
      /* 988 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 INT8, field_3_0123 DATE ARRAY, field_4_01234 UINT8 ARRAY, field_5_012345 INT64, field_6_0123456 UINT16 ARRAY, field_7_01234567 HIRESTIME, field_8_012345678 UINT8, field_9_0123456789 RICHREAL, field_10_0 UINT32, field_11_01 INT8 ARRAY, field_12_012 UINT16, field_13_0123 RICHREAL, field_14_01234 INT64, field_15_012345 UINT16, field_16_0123456 BOOL, field_17_01234567 CHAR, field_18_012345678 INT16, field_19_0123456789 UINT8 ARRAY, field_20_0 DATE, field_21_01 DATE ARRAY, field_22_012 CHAR ARRAY, field_23_0123 UINT64 ARRAY, field_24_01234 HIRESTIME ARRAY, field_25_012345 BOOL, field_26_0123456 DATETIME, field_27_01234567 REAL ARRAY, field_28_012345678 INT16, field_29_0123456789 DATETIME ARRAY, field_30_0 UINT8 ARRAY, field_31_01 CHAR ARRAY, field_32_012 UINT16, field_33_0123 HIRESTIME, field_34_01234 DATE ARRAY, field_35_012345 HIRESTIME ARRAY, field_36_0123456 UINT8, field_37_01234567 INT32, field_38_012345678 UINT8 ARRAY, field_39_0123456789 INT32 ARRAY, field_40_0 REAL ARRAY, field_41_01 REAL, field_42_012 HIRESTIME, field_43_0123 RICHREAL, field_44_01234 INT64, field_45_012345 HIRESTIME, field_46_0123456 INT16, field_47_01234567 INT32, field_48_012345678 CHAR, field_49_0123456789 CHAR, field_50_0 DATETIME, field_51_01 RICHREAL, field_52_012 UINT8, field_53_0123 UINT32, field_54_01234 BOOL ARRAY, field_55_012345 DATE, field_56_0123456 UINT8, field_57_01234567 HIRESTIME, field_58_012345678 UINT32, field_59_0123456789 UINT32, field_60_0 REAL, field_61_01 REAL, field_62_012 UINT64, field_63_0123 BOOL ARRAY, field_64_01234 UINT8, field_65_012345 INT64 ARRAY, field_66_0123456 BOOL ARRAY, field_67_01234567 DATETIME, field_68_012345678 DATE, field_69_0123456789 RICHREAL, field_70_0 DATE, field_71_01 DATE, field_72_012 HIRESTIME ARRAY, field_73_0123 UINT64, field_74_01234 INT16, field_75_012345 DATE, field_76_0123456 DATETIME, field_77_01234567 CHAR, field_78_012345678 UINT8, field_79_0123456789 RICHREAL, field_80_0 INT8, field_81_01 DATE, field_82_012 HIRESTIME, field_83_0123 INT64, field_84_01234 UINT16, field_85_012345 HIRESTIME, field_86_0123456 BOOL ARRAY, field_87_01234567 DATE, field_88_012345678 RICHREAL, field_89_0123456789 DATETIME)");
      /* 989 */ glbTypes.push_back("TABLE(field_1_01 INT32, field_2_012 HIRESTIME, field_3_0123 DATETIME, field_4_01234 UINT16, field_5_012345 BOOL, field_6_0123456 CHAR, field_7_01234567 HIRESTIME, field_8_012345678 BOOL ARRAY, field_9_0123456789 REAL ARRAY, field_10_0 REAL, field_11_01 DATETIME, field_12_012 UINT32 ARRAY, field_13_0123 UINT64, field_14_01234 INT32, field_15_012345 UINT16, field_16_0123456 DATETIME, field_17_01234567 INT8 ARRAY, field_18_012345678 RICHREAL, field_19_0123456789 UINT64, field_20_0 UINT32, field_21_01 INT16, field_22_012 DATE, field_23_0123 INT64, field_24_01234 REAL, field_25_012345 UINT8, field_26_0123456 HIRESTIME, field_27_01234567 INT16, field_28_012345678 DATETIME ARRAY, field_29_0123456789 RICHREAL, field_30_0 REAL, field_31_01 UINT64, field_32_012 UINT64, field_33_0123 INT8, field_34_01234 REAL, field_35_012345 INT16, field_36_0123456 HIRESTIME ARRAY, field_37_01234567 BOOL, field_38_012345678 BOOL, field_39_0123456789 UINT8, field_40_0 INT32, field_41_01 REAL, field_42_012 INT8, field_43_0123 UINT64, field_44_01234 INT8, field_45_012345 INT32, field_46_0123456 DATETIME, field_47_01234567 UINT8, field_48_012345678 UINT64 ARRAY, field_49_0123456789 INT32)");
      /* 990 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 INT8, field_3_0123 INT16 ARRAY, field_4_01234 INT32 ARRAY, field_5_012345 BOOL, field_6_0123456 CHAR ARRAY, field_7_01234567 INT16, field_8_012345678 UINT8, field_9_0123456789 INT64, field_10_0 CHAR, field_11_01 DATETIME, field_12_012 DATE, field_13_0123 DATETIME, field_14_01234 RICHREAL, field_15_012345 REAL, field_16_0123456 RICHREAL, field_17_01234567 UINT64, field_18_012345678 DATE, field_19_0123456789 HIRESTIME, field_20_0 UINT64 ARRAY, field_21_01 UINT64, field_22_012 HIRESTIME, field_23_0123 INT8, field_24_01234 REAL, field_25_012345 HIRESTIME, field_26_0123456 RICHREAL, field_27_01234567 INT32, field_28_012345678 REAL, field_29_0123456789 CHAR, field_30_0 UINT64, field_31_01 REAL, field_32_012 REAL, field_33_0123 UINT16, field_34_01234 REAL, field_35_012345 DATETIME, field_36_0123456 HIRESTIME, field_37_01234567 UINT32, field_38_012345678 INT64, field_39_0123456789 UINT8, field_40_0 UINT16, field_41_01 UINT64 ARRAY, field_42_012 BOOL, field_43_0123 UINT32, field_44_01234 REAL, field_45_012345 RICHREAL, field_46_0123456 CHAR ARRAY, field_47_01234567 INT8 ARRAY, field_48_012345678 INT32, field_49_0123456789 DATETIME ARRAY, field_50_0 CHAR ARRAY, field_51_01 RICHREAL, field_52_012 INT8, field_53_0123 DATETIME, field_54_01234 UINT64, field_55_012345 UINT32, field_56_0123456 CHAR, field_57_01234567 DATE, field_58_012345678 REAL ARRAY, field_59_0123456789 BOOL, field_60_0 RICHREAL, field_61_01 REAL, field_62_012 REAL, field_63_0123 INT32, field_64_01234 INT64, field_65_012345 HIRESTIME, field_66_0123456 UINT8, field_67_01234567 UINT32, field_68_012345678 INT16, field_69_0123456789 REAL, field_70_0 INT64)");
      /* 991 */ glbTypes.push_back("TABLE(field_1_01 CHAR, field_2_012 DATE, field_3_0123 INT8, field_4_01234 BOOL, field_5_012345 HIRESTIME, field_6_0123456 DATE, field_7_01234567 CHAR, field_8_012345678 INT64, field_9_0123456789 UINT8, field_10_0 UINT32 ARRAY, field_11_01 HIRESTIME, field_12_012 INT32, field_13_0123 INT8, field_14_01234 DATETIME ARRAY, field_15_012345 INT32 ARRAY, field_16_0123456 DATETIME, field_17_01234567 HIRESTIME, field_18_012345678 BOOL ARRAY, field_19_0123456789 DATE ARRAY, field_20_0 INT8 ARRAY, field_21_01 INT16, field_22_012 HIRESTIME, field_23_0123 UINT16 ARRAY, field_24_01234 RICHREAL, field_25_012345 CHAR, field_26_0123456 INT64, field_27_01234567 DATE, field_28_012345678 CHAR, field_29_0123456789 INT8, field_30_0 BOOL, field_31_01 DATETIME, field_32_012 INT16, field_33_0123 INT64, field_34_01234 INT8, field_35_012345 CHAR, field_36_0123456 HIRESTIME ARRAY, field_37_01234567 INT16, field_38_012345678 UINT8, field_39_0123456789 DATETIME, field_40_0 BOOL, field_41_01 UINT64, field_42_012 RICHREAL, field_43_0123 DATETIME, field_44_01234 REAL, field_45_012345 CHAR, field_46_0123456 UINT32, field_47_01234567 HIRESTIME, field_48_012345678 CHAR ARRAY, field_49_0123456789 UINT64, field_50_0 UINT32, field_51_01 UINT8, field_52_012 INT64, field_53_0123 INT64, field_54_01234 HIRESTIME, field_55_012345 INT8, field_56_0123456 BOOL ARRAY, field_57_01234567 DATE, field_58_012345678 INT16 ARRAY, field_59_0123456789 DATETIME, field_60_0 DATETIME ARRAY, field_61_01 UINT8 ARRAY, field_62_012 DATE, field_63_0123 UINT16, field_64_01234 UINT32, field_65_012345 DATETIME, field_66_0123456 INT16 ARRAY, field_67_01234567 UINT16, field_68_012345678 REAL, field_69_0123456789 UINT8, field_70_0 UINT32, field_71_01 DATETIME ARRAY, field_72_012 HIRESTIME, field_73_0123 INT32, field_74_01234 INT64 ARRAY, field_75_012345 INT32, field_76_0123456 CHAR, field_77_01234567 REAL, field_78_012345678 INT8, field_79_0123456789 DATE, field_80_0 INT64, field_81_01 CHAR ARRAY, field_82_012 INT32 ARRAY, field_83_0123 HIRESTIME, field_84_01234 INT32, field_85_012345 INT16, field_86_0123456 DATETIME, field_87_01234567 UINT8, field_88_012345678 RICHREAL, field_89_0123456789 UINT8, field_90_0 BOOL ARRAY, field_91_01 DATETIME ARRAY, field_92_012 REAL, field_93_0123 INT16 ARRAY, field_94_01234 INT64, field_95_012345 CHAR)");
      /* 992 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 INT64 ARRAY, field_3_0123 UINT8, field_4_01234 HIRESTIME, field_5_012345 RICHREAL, field_6_0123456 HIRESTIME, field_7_01234567 REAL ARRAY, field_8_012345678 UINT64 ARRAY, field_9_0123456789 INT32, field_10_0 UINT32, field_11_01 BOOL, field_12_012 INT32 ARRAY, field_13_0123 UINT8 ARRAY, field_14_01234 INT64, field_15_012345 HIRESTIME, field_16_0123456 CHAR, field_17_01234567 RICHREAL, field_18_012345678 UINT64, field_19_0123456789 DATETIME, field_20_0 UINT64 ARRAY, field_21_01 INT32, field_22_012 UINT64, field_23_0123 REAL, field_24_01234 INT16, field_25_012345 INT64, field_26_0123456 INT8, field_27_01234567 UINT8)");
      /* 993 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 DATETIME)");
      /* 994 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 DATE)");
      /* 995 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 UINT8, field_3_0123 BOOL ARRAY, field_4_01234 HIRESTIME ARRAY, field_5_012345 CHAR, field_6_0123456 INT8, field_7_01234567 INT16, field_8_012345678 HIRESTIME, field_9_0123456789 INT8, field_10_0 HIRESTIME ARRAY, field_11_01 DATETIME, field_12_012 HIRESTIME, field_13_0123 UINT32, field_14_01234 HIRESTIME, field_15_012345 INT8, field_16_0123456 UINT16, field_17_01234567 INT64 ARRAY, field_18_012345678 RICHREAL, field_19_0123456789 INT16 ARRAY, field_20_0 REAL ARRAY, field_21_01 INT16, field_22_012 HIRESTIME, field_23_0123 INT8, field_24_01234 DATE, field_25_012345 INT32, field_26_0123456 REAL, field_27_01234567 CHAR, field_28_012345678 UINT16, field_29_0123456789 UINT16, field_30_0 BOOL, field_31_01 INT16, field_32_012 DATETIME, field_33_0123 RICHREAL, field_34_01234 RICHREAL, field_35_012345 UINT16, field_36_0123456 BOOL, field_37_01234567 RICHREAL, field_38_012345678 UINT64, field_39_0123456789 REAL ARRAY, field_40_0 REAL, field_41_01 INT32, field_42_012 UINT32, field_43_0123 DATETIME ARRAY, field_44_01234 UINT16, field_45_012345 UINT8, field_46_0123456 INT32, field_47_01234567 DATE, field_48_012345678 BOOL, field_49_0123456789 HIRESTIME, field_50_0 INT32, field_51_01 DATE, field_52_012 DATE, field_53_0123 INT32, field_54_01234 UINT8 ARRAY, field_55_012345 HIRESTIME, field_56_0123456 DATETIME, field_57_01234567 UINT64 ARRAY, field_58_012345678 UINT8, field_59_0123456789 UINT32, field_60_0 DATE ARRAY, field_61_01 INT64, field_62_012 UINT32, field_63_0123 CHAR, field_64_01234 DATE, field_65_012345 INT32 ARRAY, field_66_0123456 REAL, field_67_01234567 INT64, field_68_012345678 DATE, field_69_0123456789 INT16, field_70_0 DATE, field_71_01 UINT16, field_72_012 INT16, field_73_0123 UINT16 ARRAY, field_74_01234 UINT8)");
      /* 996 */ glbTypes.push_back("TABLE(field_1_01 INT8, field_2_012 HIRESTIME ARRAY, field_3_0123 INT64, field_4_01234 REAL, field_5_012345 INT8, field_6_0123456 INT64 ARRAY, field_7_01234567 UINT64, field_8_012345678 RICHREAL, field_9_0123456789 RICHREAL, field_10_0 INT32, field_11_01 REAL, field_12_012 REAL, field_13_0123 REAL, field_14_01234 CHAR ARRAY, field_15_012345 HIRESTIME, field_16_0123456 HIRESTIME, field_17_01234567 INT8, field_18_012345678 UINT32, field_19_0123456789 INT8 ARRAY, field_20_0 UINT16, field_21_01 INT8, field_22_012 HIRESTIME, field_23_0123 RICHREAL ARRAY, field_24_01234 UINT32, field_25_012345 UINT32, field_26_0123456 INT16, field_27_01234567 HIRESTIME, field_28_012345678 INT16 ARRAY, field_29_0123456789 INT64, field_30_0 INT32, field_31_01 DATE, field_32_012 INT8, field_33_0123 RICHREAL, field_34_01234 INT16, field_35_012345 RICHREAL, field_36_0123456 HIRESTIME ARRAY, field_37_01234567 INT64, field_38_012345678 UINT32, field_39_0123456789 RICHREAL ARRAY, field_40_0 DATETIME, field_41_01 INT32 ARRAY, field_42_012 INT8, field_43_0123 DATE, field_44_01234 HIRESTIME, field_45_012345 INT16 ARRAY, field_46_0123456 INT16, field_47_01234567 INT32, field_48_012345678 RICHREAL, field_49_0123456789 DATETIME, field_50_0 UINT8, field_51_01 INT64, field_52_012 DATE ARRAY, field_53_0123 REAL, field_54_01234 INT8, field_55_012345 UINT32 ARRAY, field_56_0123456 DATE, field_57_01234567 INT32, field_58_012345678 UINT8, field_59_0123456789 INT8, field_60_0 UINT64, field_61_01 INT16 ARRAY, field_62_012 REAL ARRAY, field_63_0123 INT64, field_64_01234 UINT8, field_65_012345 DATETIME, field_66_0123456 UINT8, field_67_01234567 CHAR, field_68_012345678 INT64, field_69_0123456789 CHAR, field_70_0 UINT8, field_71_01 INT32, field_72_012 INT64 ARRAY, field_73_0123 INT64, field_74_01234 INT32, field_75_012345 INT16, field_76_0123456 CHAR, field_77_01234567 INT16, field_78_012345678 DATETIME, field_79_0123456789 RICHREAL, field_80_0 CHAR, field_81_01 DATE ARRAY, field_82_012 INT8, field_83_0123 CHAR, field_84_01234 UINT32 ARRAY, field_85_012345 INT8, field_86_0123456 RICHREAL ARRAY, field_87_01234567 DATE ARRAY, field_88_012345678 DATETIME, field_89_0123456789 HIRESTIME)");
      /* 997 */ glbTypes.push_back("TABLE(field_1_01 INT16 ARRAY, field_2_012 DATE, field_3_0123 HIRESTIME, field_4_01234 BOOL, field_5_012345 CHAR ARRAY, field_6_0123456 INT16, field_7_01234567 CHAR, field_8_012345678 RICHREAL, field_9_0123456789 REAL, field_10_0 BOOL, field_11_01 UINT8, field_12_012 UINT8, field_13_0123 BOOL, field_14_01234 UINT8 ARRAY, field_15_012345 HIRESTIME ARRAY, field_16_0123456 DATETIME, field_17_01234567 INT64 ARRAY, field_18_012345678 BOOL, field_19_0123456789 INT8, field_20_0 UINT64, field_21_01 RICHREAL, field_22_012 UINT16 ARRAY, field_23_0123 HIRESTIME ARRAY, field_24_01234 INT32, field_25_012345 DATE, field_26_0123456 DATETIME ARRAY, field_27_01234567 UINT64, field_28_012345678 UINT64 ARRAY, field_29_0123456789 REAL, field_30_0 DATE, field_31_01 DATETIME ARRAY, field_32_012 CHAR, field_33_0123 BOOL, field_34_01234 INT8, field_35_012345 REAL, field_36_0123456 UINT32, field_37_01234567 RICHREAL ARRAY, field_38_012345678 UINT8 ARRAY, field_39_0123456789 UINT8, field_40_0 UINT32, field_41_01 UINT16, field_42_012 REAL, field_43_0123 UINT8, field_44_01234 HIRESTIME ARRAY, field_45_012345 INT64)");
      /* 998 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 REAL, field_3_0123 UINT8 ARRAY, field_4_01234 UINT16 ARRAY, field_5_012345 INT8, field_6_0123456 INT16, field_7_01234567 DATETIME, field_8_012345678 UINT64 ARRAY, field_9_0123456789 DATETIME, field_10_0 UINT64, field_11_01 UINT32, field_12_012 INT8 ARRAY, field_13_0123 RICHREAL ARRAY, field_14_01234 DATE, field_15_012345 UINT16 ARRAY, field_16_0123456 UINT64, field_17_01234567 INT32, field_18_012345678 REAL, field_19_0123456789 INT64, field_20_0 DATE, field_21_01 UINT8, field_22_012 UINT64 ARRAY)");
      /* 999 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 REAL, field_3_0123 INT64, field_4_01234 RICHREAL ARRAY, field_5_012345 HIRESTIME, field_6_0123456 DATE, field_7_01234567 UINT32 ARRAY, field_8_012345678 DATETIME, field_9_0123456789 UINT16, field_10_0 INT64, field_11_01 INT8, field_12_012 CHAR, field_13_0123 UINT16, field_14_01234 INT8 ARRAY, field_15_012345 HIRESTIME, field_16_0123456 UINT16, field_17_01234567 UINT16 ARRAY, field_18_012345678 INT8, field_19_0123456789 INT32, field_20_0 UINT8, field_21_01 UINT8, field_22_012 INT16 ARRAY, field_23_0123 HIRESTIME ARRAY, field_24_01234 INT8, field_25_012345 INT64, field_26_0123456 DATETIME, field_27_01234567 HIRESTIME, field_28_012345678 BOOL, field_29_0123456789 RICHREAL, field_30_0 BOOL ARRAY, field_31_01 UINT16, field_32_012 UINT8, field_33_0123 INT8, field_34_01234 INT8, field_35_012345 DATETIME, field_36_0123456 REAL, field_37_01234567 RICHREAL, field_38_012345678 INT32, field_39_0123456789 DATE, field_40_0 INT16, field_41_01 INT32, field_42_012 UINT8, field_43_0123 UINT32 ARRAY, field_44_01234 INT64, field_45_012345 REAL, field_46_0123456 BOOL, field_47_01234567 INT32, field_48_012345678 BOOL ARRAY, field_49_0123456789 BOOL ARRAY, field_50_0 DATETIME, field_51_01 UINT32, field_52_012 DATETIME, field_53_0123 INT8, field_54_01234 INT16 ARRAY, field_55_012345 DATETIME ARRAY, field_56_0123456 RICHREAL, field_57_01234567 RICHREAL, field_58_012345678 INT32, field_59_0123456789 HIRESTIME, field_60_0 DATE, field_61_01 HIRESTIME ARRAY, field_62_012 BOOL ARRAY, field_63_0123 UINT8, field_64_01234 RICHREAL, field_65_012345 RICHREAL, field_66_0123456 INT32, field_67_01234567 INT64 ARRAY, field_68_012345678 INT8 ARRAY, field_69_0123456789 INT64, field_70_0 HIRESTIME, field_71_01 DATE, field_72_012 UINT16, field_73_0123 DATETIME, field_74_01234 HIRESTIME, field_75_012345 BOOL, field_76_0123456 HIRESTIME, field_77_01234567 RICHREAL, field_78_012345678 UINT64, field_79_0123456789 RICHREAL, field_80_0 CHAR, field_81_01 UINT16, field_82_012 UINT32, field_83_0123 DATE, field_84_01234 REAL, field_85_012345 REAL ARRAY, field_86_0123456 UINT16, field_87_01234567 CHAR, field_88_012345678 DATETIME, field_89_0123456789 UINT16 ARRAY)");
      /* 1000 */ glbTypes.push_back("TABLE(field_1_01 BOOL, field_2_012 UINT64, field_3_0123 INT8 ARRAY, field_4_01234 BOOL, field_5_012345 BOOL, field_6_0123456 DATETIME, field_7_01234567 CHAR, field_8_012345678 DATETIME, field_9_0123456789 HIRESTIME ARRAY)");
      /* 1001 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 UINT32, field_3_0123 UINT64, field_4_01234 BOOL ARRAY, field_5_012345 INT16, field_6_0123456 DATE, field_7_01234567 UINT64, field_8_012345678 RICHREAL, field_9_0123456789 DATETIME, field_10_0 UINT8, field_11_01 CHAR, field_12_012 DATE ARRAY, field_13_0123 HIRESTIME, field_14_01234 DATETIME, field_15_012345 CHAR, field_16_0123456 UINT16 ARRAY, field_17_01234567 INT8 ARRAY, field_18_012345678 UINT64, field_19_0123456789 INT16, field_20_0 UINT64)");
      /* 1002 */ glbTypes.push_back("TABLE(field_1_01 INT64, field_2_012 DATE ARRAY, field_3_0123 INT16, field_4_01234 INT32, field_5_012345 UINT64 ARRAY, field_6_0123456 CHAR, field_7_01234567 INT64, field_8_012345678 UINT8, field_9_0123456789 CHAR, field_10_0 RICHREAL ARRAY, field_11_01 INT16 ARRAY, field_12_012 INT8)");
      /* 1003 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 CHAR ARRAY, field_3_0123 CHAR, field_4_01234 RICHREAL, field_5_012345 DATETIME ARRAY, field_6_0123456 UINT8, field_7_01234567 DATE ARRAY, field_8_012345678 HIRESTIME, field_9_0123456789 UINT64, field_10_0 RICHREAL ARRAY, field_11_01 RICHREAL, field_12_012 UINT8 ARRAY, field_13_0123 UINT32, field_14_01234 UINT8 ARRAY, field_15_012345 INT16, field_16_0123456 UINT64, field_17_01234567 REAL, field_18_012345678 DATE, field_19_0123456789 CHAR, field_20_0 CHAR, field_21_01 BOOL ARRAY, field_22_012 BOOL, field_23_0123 INT32 ARRAY, field_24_01234 HIRESTIME, field_25_012345 HIRESTIME ARRAY, field_26_0123456 DATE, field_27_01234567 INT32, field_28_012345678 HIRESTIME ARRAY)");
      /* 1004 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 INT8, field_3_0123 INT16, field_4_01234 INT64, field_5_012345 INT16, field_6_0123456 UINT16, field_7_01234567 INT32, field_8_012345678 INT16, field_9_0123456789 DATETIME, field_10_0 INT64, field_11_01 INT32, field_12_012 INT8, field_13_0123 INT32, field_14_01234 DATETIME, field_15_012345 DATE, field_16_0123456 HIRESTIME, field_17_01234567 INT8, field_18_012345678 INT32, field_19_0123456789 CHAR, field_20_0 DATE, field_21_01 UINT8, field_22_012 UINT8, field_23_0123 UINT16, field_24_01234 UINT32 ARRAY, field_25_012345 RICHREAL, field_26_0123456 UINT16 ARRAY, field_27_01234567 UINT8, field_28_012345678 UINT8, field_29_0123456789 INT32 ARRAY, field_30_0 REAL, field_31_01 INT8, field_32_012 INT64, field_33_0123 UINT8, field_34_01234 REAL, field_35_012345 BOOL, field_36_0123456 CHAR, field_37_01234567 BOOL, field_38_012345678 CHAR, field_39_0123456789 UINT32, field_40_0 UINT32 ARRAY, field_41_01 REAL, field_42_012 UINT64, field_43_0123 UINT64, field_44_01234 DATETIME ARRAY, field_45_012345 INT64, field_46_0123456 INT64, field_47_01234567 UINT8, field_48_012345678 UINT16, field_49_0123456789 UINT16, field_50_0 UINT64, field_51_01 INT64, field_52_012 DATETIME, field_53_0123 INT64, field_54_01234 INT8, field_55_012345 INT32, field_56_0123456 UINT8 ARRAY, field_57_01234567 UINT16, field_58_012345678 INT64, field_59_0123456789 DATETIME, field_60_0 REAL ARRAY, field_61_01 BOOL ARRAY)");
      /* 1005 */ glbTypes.push_back("TABLE(field_1_01 UINT8, field_2_012 INT32 ARRAY, field_3_0123 DATE, field_4_01234 INT16, field_5_012345 REAL, field_6_0123456 INT32, field_7_01234567 INT32, field_8_012345678 INT32, field_9_0123456789 UINT32 ARRAY)");
      /* 1006 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 DATE, field_3_0123 UINT16, field_4_01234 INT8, field_5_012345 CHAR, field_6_0123456 INT64, field_7_01234567 INT8, field_8_012345678 BOOL, field_9_0123456789 RICHREAL, field_10_0 UINT16 ARRAY, field_11_01 DATETIME, field_12_012 HIRESTIME, field_13_0123 INT8, field_14_01234 UINT32, field_15_012345 BOOL, field_16_0123456 DATETIME, field_17_01234567 DATE ARRAY, field_18_012345678 INT64, field_19_0123456789 REAL, field_20_0 RICHREAL ARRAY)");
      /* 1007 */ glbTypes.push_back("TABLE(field_1_01 INT16, field_2_012 HIRESTIME, field_3_0123 UINT8 ARRAY, field_4_01234 INT8, field_5_012345 CHAR, field_6_0123456 REAL ARRAY, field_7_01234567 INT32, field_8_012345678 UINT16 ARRAY, field_9_0123456789 RICHREAL, field_10_0 UINT8, field_11_01 INT32, field_12_012 RICHREAL, field_13_0123 UINT64 ARRAY, field_14_01234 CHAR, field_15_012345 DATETIME ARRAY, field_16_0123456 UINT32, field_17_01234567 INT8, field_18_012345678 INT64, field_19_0123456789 RICHREAL, field_20_0 INT64, field_21_01 RICHREAL ARRAY, field_22_012 UINT64, field_23_0123 INT32, field_24_01234 INT64 ARRAY, field_25_012345 UINT16 ARRAY, field_26_0123456 UINT64 ARRAY, field_27_01234567 UINT64, field_28_012345678 BOOL, field_29_0123456789 CHAR, field_30_0 HIRESTIME, field_31_01 INT8, field_32_012 UINT32, field_33_0123 UINT16, field_34_01234 BOOL ARRAY, field_35_012345 UINT32, field_36_0123456 UINT8)");
      /* 1008 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 INT16, field_3_0123 REAL, field_4_01234 UINT16, field_5_012345 INT32, field_6_0123456 INT16, field_7_01234567 DATETIME, field_8_012345678 RICHREAL ARRAY, field_9_0123456789 INT16, field_10_0 BOOL, field_11_01 DATE, field_12_012 BOOL ARRAY, field_13_0123 BOOL ARRAY, field_14_01234 DATETIME, field_15_012345 REAL ARRAY, field_16_0123456 HIRESTIME, field_17_01234567 BOOL, field_18_012345678 DATETIME, field_19_0123456789 CHAR, field_20_0 BOOL, field_21_01 INT8, field_22_012 BOOL, field_23_0123 HIRESTIME, field_24_01234 DATE, field_25_012345 UINT32 ARRAY, field_26_0123456 UINT64 ARRAY, field_27_01234567 RICHREAL, field_28_012345678 INT64, field_29_0123456789 UINT8 ARRAY, field_30_0 INT64 ARRAY, field_31_01 UINT64 ARRAY, field_32_012 UINT16, field_33_0123 UINT64 ARRAY, field_34_01234 UINT8 ARRAY, field_35_012345 DATE, field_36_0123456 UINT32 ARRAY, field_37_01234567 INT32, field_38_012345678 UINT16, field_39_0123456789 INT32, field_40_0 REAL, field_41_01 DATETIME, field_42_012 CHAR, field_43_0123 INT16 ARRAY, field_44_01234 INT8 ARRAY, field_45_012345 INT8, field_46_0123456 UINT8, field_47_01234567 BOOL, field_48_012345678 INT16 ARRAY, field_49_0123456789 INT16 ARRAY, field_50_0 DATE, field_51_01 UINT64, field_52_012 RICHREAL, field_53_0123 INT32, field_54_01234 RICHREAL ARRAY, field_55_012345 INT32 ARRAY, field_56_0123456 INT16, field_57_01234567 INT16, field_58_012345678 INT16 ARRAY, field_59_0123456789 BOOL, field_60_0 UINT16 ARRAY, field_61_01 REAL, field_62_012 UINT8, field_63_0123 INT8 ARRAY, field_64_01234 RICHREAL, field_65_012345 BOOL, field_66_0123456 UINT8, field_67_01234567 INT32, field_68_012345678 REAL, field_69_0123456789 INT8, field_70_0 INT16)");
      /* 1009 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 RICHREAL ARRAY, field_3_0123 DATE, field_4_01234 INT8, field_5_012345 CHAR, field_6_0123456 UINT16 ARRAY, field_7_01234567 UINT32, field_8_012345678 INT64, field_9_0123456789 INT64, field_10_0 UINT8, field_11_01 UINT16, field_12_012 CHAR, field_13_0123 UINT32, field_14_01234 BOOL ARRAY, field_15_012345 DATE ARRAY, field_16_0123456 INT8, field_17_01234567 UINT8, field_18_012345678 DATE, field_19_0123456789 BOOL, field_20_0 BOOL, field_21_01 INT16 ARRAY, field_22_012 UINT8, field_23_0123 DATETIME, field_24_01234 DATE, field_25_012345 UINT32, field_26_0123456 INT64, field_27_01234567 DATETIME, field_28_012345678 HIRESTIME, field_29_0123456789 RICHREAL ARRAY, field_30_0 INT8 ARRAY, field_31_01 INT32, field_32_012 UINT64 ARRAY, field_33_0123 UINT32, field_34_01234 INT64, field_35_012345 DATE, field_36_0123456 UINT64, field_37_01234567 CHAR, field_38_012345678 BOOL, field_39_0123456789 UINT32, field_40_0 HIRESTIME, field_41_01 UINT8, field_42_012 INT64, field_43_0123 INT32, field_44_01234 DATE, field_45_012345 INT32 ARRAY, field_46_0123456 HIRESTIME, field_47_01234567 DATE, field_48_012345678 HIRESTIME, field_49_0123456789 RICHREAL ARRAY, field_50_0 DATE, field_51_01 CHAR, field_52_012 HIRESTIME, field_53_0123 UINT8, field_54_01234 RICHREAL, field_55_012345 REAL)");
      /* 1010 */ glbTypes.push_back("TABLE(field_1_01 DATETIME, field_2_012 UINT16, field_3_0123 UINT8, field_4_01234 UINT32 ARRAY, field_5_012345 INT16 ARRAY, field_6_0123456 INT16, field_7_01234567 DATE, field_8_012345678 CHAR, field_9_0123456789 INT32, field_10_0 DATE, field_11_01 INT32, field_12_012 BOOL, field_13_0123 UINT64, field_14_01234 INT16, field_15_012345 DATE, field_16_0123456 DATETIME ARRAY, field_17_01234567 INT64, field_18_012345678 BOOL ARRAY, field_19_0123456789 CHAR, field_20_0 BOOL, field_21_01 CHAR, field_22_012 RICHREAL, field_23_0123 UINT32)");
      /* 1011 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 UINT16 ARRAY, field_3_0123 BOOL ARRAY, field_4_01234 UINT64, field_5_012345 INT8, field_6_0123456 UINT32, field_7_01234567 REAL, field_8_012345678 INT64 ARRAY, field_9_0123456789 INT32, field_10_0 HIRESTIME, field_11_01 RICHREAL, field_12_012 UINT64, field_13_0123 UINT64, field_14_01234 UINT32, field_15_012345 UINT32, field_16_0123456 INT16, field_17_01234567 INT16, field_18_012345678 REAL, field_19_0123456789 INT8, field_20_0 HIRESTIME ARRAY, field_21_01 UINT64, field_22_012 CHAR, field_23_0123 CHAR, field_24_01234 UINT8, field_25_012345 HIRESTIME, field_26_0123456 DATETIME ARRAY, field_27_01234567 HIRESTIME ARRAY, field_28_012345678 INT32 ARRAY, field_29_0123456789 INT16, field_30_0 INT8, field_31_01 UINT8, field_32_012 CHAR, field_33_0123 DATETIME, field_34_01234 HIRESTIME, field_35_012345 BOOL, field_36_0123456 UINT16 ARRAY, field_37_01234567 DATETIME, field_38_012345678 CHAR, field_39_0123456789 DATETIME, field_40_0 DATE ARRAY, field_41_01 INT16, field_42_012 DATETIME, field_43_0123 REAL, field_44_01234 HIRESTIME, field_45_012345 UINT32, field_46_0123456 BOOL, field_47_01234567 UINT64, field_48_012345678 BOOL, field_49_0123456789 CHAR, field_50_0 UINT8 ARRAY, field_51_01 CHAR, field_52_012 INT32, field_53_0123 INT32, field_54_01234 DATETIME, field_55_012345 INT32 ARRAY, field_56_0123456 INT32, field_57_01234567 UINT8, field_58_012345678 UINT32, field_59_0123456789 RICHREAL, field_60_0 CHAR, field_61_01 CHAR, field_62_012 INT8, field_63_0123 UINT8, field_64_01234 INT64 ARRAY, field_65_012345 REAL, field_66_0123456 RICHREAL, field_67_01234567 INT16, field_68_012345678 DATETIME, field_69_0123456789 BOOL, field_70_0 REAL ARRAY, field_71_01 INT8, field_72_012 REAL, field_73_0123 DATETIME, field_74_01234 INT32, field_75_012345 UINT16 ARRAY, field_76_0123456 INT64, field_77_01234567 UINT16, field_78_012345678 CHAR, field_79_0123456789 DATETIME, field_80_0 CHAR, field_81_01 DATETIME ARRAY, field_82_012 INT16, field_83_0123 INT16, field_84_01234 RICHREAL, field_85_012345 CHAR, field_86_0123456 RICHREAL ARRAY, field_87_01234567 HIRESTIME, field_88_012345678 INT32, field_89_0123456789 DATETIME ARRAY, field_90_0 UINT32, field_91_01 CHAR, field_92_012 INT8 ARRAY, field_93_0123 RICHREAL, field_94_01234 RICHREAL, field_95_012345 DATE, field_96_0123456 BOOL, field_97_01234567 INT32)");
      /* 1012 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 INT32, field_3_0123 DATETIME, field_4_01234 DATE, field_5_012345 DATETIME, field_6_0123456 UINT8, field_7_01234567 DATE, field_8_012345678 CHAR, field_9_0123456789 DATETIME, field_10_0 INT8, field_11_01 UINT16, field_12_012 RICHREAL, field_13_0123 INT8, field_14_01234 UINT32, field_15_012345 UINT32, field_16_0123456 REAL, field_17_01234567 INT8, field_18_012345678 BOOL, field_19_0123456789 INT16, field_20_0 INT16, field_21_01 UINT8 ARRAY, field_22_012 INT8, field_23_0123 INT32, field_24_01234 INT64, field_25_012345 INT32, field_26_0123456 HIRESTIME, field_27_01234567 INT32, field_28_012345678 INT64, field_29_0123456789 UINT32)");
      /* 1013 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 BOOL, field_3_0123 INT32, field_4_01234 INT8, field_5_012345 UINT16, field_6_0123456 DATETIME, field_7_01234567 BOOL, field_8_012345678 REAL, field_9_0123456789 INT32, field_10_0 INT32, field_11_01 DATETIME, field_12_012 UINT16 ARRAY, field_13_0123 DATE, field_14_01234 INT16, field_15_012345 INT32, field_16_0123456 DATE ARRAY, field_17_01234567 UINT8, field_18_012345678 INT32, field_19_0123456789 HIRESTIME, field_20_0 REAL, field_21_01 DATE, field_22_012 INT8, field_23_0123 HIRESTIME, field_24_01234 REAL, field_25_012345 BOOL, field_26_0123456 RICHREAL, field_27_01234567 RICHREAL, field_28_012345678 HIRESTIME ARRAY, field_29_0123456789 BOOL, field_30_0 HIRESTIME, field_31_01 INT32, field_32_012 DATETIME, field_33_0123 CHAR, field_34_01234 INT32, field_35_012345 INT16 ARRAY, field_36_0123456 HIRESTIME, field_37_01234567 CHAR, field_38_012345678 INT32 ARRAY, field_39_0123456789 HIRESTIME, field_40_0 REAL ARRAY, field_41_01 RICHREAL ARRAY, field_42_012 INT16, field_43_0123 INT64, field_44_01234 INT16, field_45_012345 HIRESTIME, field_46_0123456 INT64, field_47_01234567 UINT64, field_48_012345678 INT8, field_49_0123456789 UINT16 ARRAY, field_50_0 INT8, field_51_01 DATETIME ARRAY, field_52_012 CHAR, field_53_0123 INT32, field_54_01234 UINT16, field_55_012345 INT16, field_56_0123456 REAL ARRAY)");
      /* 1014 */ glbTypes.push_back("TABLE(field_1_01 REAL, field_2_012 INT16, field_3_0123 REAL, field_4_01234 HIRESTIME, field_5_012345 DATETIME ARRAY, field_6_0123456 INT8 ARRAY, field_7_01234567 UINT16, field_8_012345678 UINT8, field_9_0123456789 UINT8 ARRAY, field_10_0 HIRESTIME, field_11_01 UINT16, field_12_012 INT8 ARRAY, field_13_0123 INT8 ARRAY, field_14_01234 INT64, field_15_012345 UINT8, field_16_0123456 REAL, field_17_01234567 RICHREAL, field_18_012345678 INT16, field_19_0123456789 CHAR, field_20_0 BOOL, field_21_01 RICHREAL ARRAY, field_22_012 DATETIME, field_23_0123 DATETIME ARRAY)");
      /* 1015 */ glbTypes.push_back("TABLE(field_1_01 RICHREAL, field_2_012 DATETIME, field_3_0123 RICHREAL, field_4_01234 UINT16 ARRAY)");
      /* 1016 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 UINT32 ARRAY, field_3_0123 REAL, field_4_01234 INT64 ARRAY, field_5_012345 UINT32, field_6_0123456 DATETIME, field_7_01234567 DATE, field_8_012345678 DATE, field_9_0123456789 DATETIME, field_10_0 BOOL, field_11_01 INT16 ARRAY, field_12_012 INT16, field_13_0123 REAL, field_14_01234 INT16 ARRAY, field_15_012345 UINT32, field_16_0123456 UINT16, field_17_01234567 DATE, field_18_012345678 INT64, field_19_0123456789 CHAR, field_20_0 UINT8, field_21_01 HIRESTIME ARRAY, field_22_012 RICHREAL, field_23_0123 INT16, field_24_01234 HIRESTIME ARRAY, field_25_012345 INT16, field_26_0123456 DATETIME, field_27_01234567 INT16, field_28_012345678 DATETIME, field_29_0123456789 CHAR, field_30_0 RICHREAL, field_31_01 HIRESTIME, field_32_012 INT16, field_33_0123 INT8, field_34_01234 BOOL, field_35_012345 DATETIME, field_36_0123456 REAL, field_37_01234567 INT64, field_38_012345678 REAL ARRAY, field_39_0123456789 HIRESTIME, field_40_0 DATETIME, field_41_01 INT8, field_42_012 INT64 ARRAY, field_43_0123 INT32, field_44_01234 INT8, field_45_012345 CHAR, field_46_0123456 UINT8, field_47_01234567 RICHREAL, field_48_012345678 DATE, field_49_0123456789 REAL, field_50_0 UINT8 ARRAY, field_51_01 REAL ARRAY, field_52_012 UINT16)");
      /* 1017 */ glbTypes.push_back("TABLE(field_1_01 HIRESTIME ARRAY, field_2_012 UINT64, field_3_0123 UINT64, field_4_01234 INT8, field_5_012345 INT16, field_6_0123456 RICHREAL, field_7_01234567 UINT32, field_8_012345678 DATE, field_9_0123456789 UINT32, field_10_0 INT16, field_11_01 DATETIME, field_12_012 INT32, field_13_0123 DATE ARRAY, field_14_01234 REAL, field_15_012345 BOOL, field_16_0123456 UINT64, field_17_01234567 INT16, field_18_012345678 INT16, field_19_0123456789 UINT16, field_20_0 UINT8, field_21_01 INT16, field_22_012 UINT16 ARRAY, field_23_0123 UINT16, field_24_01234 UINT16, field_25_012345 DATE, field_26_0123456 INT16 ARRAY, field_27_01234567 UINT64, field_28_012345678 DATE, field_29_0123456789 UINT32, field_30_0 UINT32, field_31_01 HIRESTIME, field_32_012 DATETIME ARRAY, field_33_0123 INT8, field_34_01234 REAL, field_35_012345 UINT16, field_36_0123456 UINT16 ARRAY, field_37_01234567 DATE, field_38_012345678 INT64, field_39_0123456789 INT64, field_40_0 BOOL ARRAY, field_41_01 RICHREAL ARRAY, field_42_012 UINT8 ARRAY, field_43_0123 RICHREAL, field_44_01234 UINT16 ARRAY, field_45_012345 UINT8, field_46_0123456 RICHREAL, field_47_01234567 UINT64 ARRAY, field_48_012345678 HIRESTIME, field_49_0123456789 INT16 ARRAY, field_50_0 UINT32, field_51_01 RICHREAL, field_52_012 INT32, field_53_0123 INT16 ARRAY, field_54_01234 INT64, field_55_012345 INT32, field_56_0123456 REAL, field_57_01234567 DATETIME, field_58_012345678 INT64, field_59_0123456789 RICHREAL ARRAY, field_60_0 CHAR ARRAY, field_61_01 UINT64 ARRAY, field_62_012 INT32 ARRAY, field_63_0123 INT16, field_64_01234 UINT32 ARRAY)");
      /* 1018 */ glbTypes.push_back("TABLE(field_1_01 DATE, field_2_012 CHAR, field_3_0123 DATE, field_4_01234 INT32, field_5_012345 INT64, field_6_0123456 BOOL, field_7_01234567 RICHREAL ARRAY, field_8_012345678 INT8, field_9_0123456789 INT8 ARRAY, field_10_0 UINT8, field_11_01 INT32, field_12_012 HIRESTIME, field_13_0123 INT8 ARRAY, field_14_01234 UINT16, field_15_012345 INT64)");
      /* 1019 */ glbTypes.push_back("TABLE(field_1_01 UINT64, field_2_012 DATE, field_3_0123 CHAR, field_4_01234 REAL, field_5_012345 CHAR ARRAY, field_6_0123456 DATE ARRAY, field_7_01234567 RICHREAL ARRAY, field_8_012345678 REAL, field_9_0123456789 RICHREAL, field_10_0 DATE, field_11_01 UINT16, field_12_012 INT32, field_13_0123 CHAR, field_14_01234 INT16, field_15_012345 BOOL, field_16_0123456 INT64, field_17_01234567 UINT8 ARRAY, field_18_012345678 INT32, field_19_0123456789 CHAR, field_20_0 UINT64, field_21_01 UINT8, field_22_012 UINT32, field_23_0123 UINT16, field_24_01234 INT32, field_25_012345 INT16 ARRAY, field_26_0123456 BOOL, field_27_01234567 INT8, field_28_012345678 RICHREAL, field_29_0123456789 INT16, field_30_0 RICHREAL, field_31_01 INT8, field_32_012 INT8, field_33_0123 DATETIME, field_34_01234 INT64, field_35_012345 CHAR ARRAY, field_36_0123456 REAL, field_37_01234567 INT16, field_38_012345678 CHAR, field_39_0123456789 UINT64, field_40_0 UINT64, field_41_01 DATETIME ARRAY, field_42_012 DATE, field_43_0123 UINT8 ARRAY, field_44_01234 UINT16, field_45_012345 UINT32, field_46_0123456 HIRESTIME ARRAY, field_47_01234567 BOOL ARRAY, field_48_012345678 HIRESTIME, field_49_0123456789 DATETIME, field_50_0 INT16, field_51_01 RICHREAL, field_52_012 UINT32, field_53_0123 UINT8, field_54_01234 UINT64 ARRAY, field_55_012345 UINT64, field_56_0123456 INT16, field_57_01234567 RICHREAL, field_58_012345678 BOOL, field_59_0123456789 INT64, field_60_0 INT16 ARRAY, field_61_01 INT64, field_62_012 DATETIME, field_63_0123 CHAR, field_64_01234 UINT64, field_65_012345 INT8, field_66_0123456 CHAR ARRAY, field_67_01234567 REAL, field_68_012345678 INT8, field_69_0123456789 UINT64, field_70_0 UINT32, field_71_01 UINT8, field_72_012 INT8, field_73_0123 INT32, field_74_01234 CHAR, field_75_012345 UINT64, field_76_0123456 REAL, field_77_01234567 RICHREAL, field_78_012345678 INT32 ARRAY, field_79_0123456789 UINT64, field_80_0 UINT16, field_81_01 UINT32, field_82_012 INT16, field_83_0123 UINT32 ARRAY, field_84_01234 RICHREAL, field_85_012345 UINT8, field_86_0123456 UINT32)");
      /* 1020 */ glbTypes.push_back("TABLE(field_1_01 UINT16, field_2_012 HIRESTIME, field_3_0123 HIRESTIME, field_4_01234 DATE, field_5_012345 REAL ARRAY)");
      /* 1021 */ glbTypes.push_back("TABLE(field_1_01 DATE ARRAY, field_2_012 UINT64, field_3_0123 DATE, field_4_01234 INT16, field_5_012345 BOOL, field_6_0123456 UINT32, field_7_01234567 UINT16, field_8_012345678 INT16, field_9_0123456789 BOOL, field_10_0 DATE, field_11_01 BOOL, field_12_012 DATETIME, field_13_0123 INT16, field_14_01234 UINT32 ARRAY, field_15_012345 DATE, field_16_0123456 INT32 ARRAY, field_17_01234567 BOOL, field_18_012345678 INT64 ARRAY, field_19_0123456789 UINT64, field_20_0 UINT16, field_21_01 REAL, field_22_012 BOOL ARRAY, field_23_0123 RICHREAL, field_24_01234 INT16, field_25_012345 UINT64 ARRAY, field_26_0123456 INT32, field_27_01234567 DATE ARRAY, field_28_012345678 CHAR ARRAY, field_29_0123456789 HIRESTIME, field_30_0 REAL, field_31_01 REAL, field_32_012 INT8, field_33_0123 UINT16, field_34_01234 RICHREAL, field_35_012345 INT8, field_36_0123456 RICHREAL, field_37_01234567 UINT32, field_38_012345678 RICHREAL, field_39_0123456789 RICHREAL ARRAY, field_40_0 BOOL, field_41_01 INT32, field_42_012 UINT32, field_43_0123 RICHREAL, field_44_01234 UINT64 ARRAY, field_45_012345 BOOL, field_46_0123456 REAL, field_47_01234567 DATETIME, field_48_012345678 UINT16, field_49_0123456789 INT32, field_50_0 RICHREAL, field_51_01 INT32, field_52_012 INT8, field_53_0123 HIRESTIME, field_54_01234 UINT32, field_55_012345 BOOL ARRAY, field_56_0123456 CHAR, field_57_01234567 HIRESTIME, field_58_012345678 UINT8, field_59_0123456789 UINT32, field_60_0 REAL ARRAY, field_61_01 INT64, field_62_012 BOOL, field_63_0123 RICHREAL, field_64_01234 HIRESTIME, field_65_012345 UINT32 ARRAY, field_66_0123456 INT32, field_67_01234567 INT8 ARRAY, field_68_012345678 CHAR, field_69_0123456789 HIRESTIME, field_70_0 UINT8, field_71_01 CHAR, field_72_012 UINT8, field_73_0123 INT16, field_74_01234 UINT16, field_75_012345 RICHREAL ARRAY, field_76_0123456 UINT8, field_77_01234567 UINT8, field_78_012345678 HIRESTIME, field_79_0123456789 HIRESTIME, field_80_0 UINT16, field_81_01 BOOL, field_82_012 INT64, field_83_0123 BOOL, field_84_01234 REAL)");
      /* 1022 */ glbTypes.push_back("TABLE(field_1_01 INT16 ARRAY, field_2_012 BOOL, field_3_0123 UINT32, field_4_01234 UINT16, field_5_012345 HIRESTIME, field_6_0123456 DATETIME, field_7_01234567 UINT64, field_8_012345678 DATETIME, field_9_0123456789 HIRESTIME, field_10_0 CHAR, field_11_01 BOOL, field_12_012 DATETIME, field_13_0123 RICHREAL, field_14_01234 REAL, field_15_012345 UINT8, field_16_0123456 DATE, field_17_01234567 INT32, field_18_012345678 UINT64, field_19_0123456789 INT32, field_20_0 INT64, field_21_01 REAL, field_22_012 RICHREAL, field_23_0123 BOOL, field_24_01234 UINT8, field_25_012345 UINT8, field_26_0123456 UINT64, field_27_01234567 UINT32, field_28_012345678 HIRESTIME ARRAY, field_29_0123456789 INT64, field_30_0 HIRESTIME, field_31_01 DATE, field_32_012 DATETIME, field_33_0123 DATETIME, field_34_01234 HIRESTIME, field_35_012345 CHAR, field_36_0123456 HIRESTIME ARRAY, field_37_01234567 CHAR, field_38_012345678 UINT64, field_39_0123456789 DATETIME, field_40_0 DATETIME, field_41_01 BOOL, field_42_012 UINT16, field_43_0123 INT64, field_44_01234 INT32, field_45_012345 INT8, field_46_0123456 UINT32 ARRAY, field_47_01234567 REAL, field_48_012345678 CHAR, field_49_0123456789 REAL ARRAY, field_50_0 UINT32, field_51_01 UINT32, field_52_012 UINT8, field_53_0123 UINT32, field_54_01234 INT64, field_55_012345 BOOL ARRAY, field_56_0123456 DATE, field_57_01234567 CHAR)");
      /* 1023 */ glbTypes.push_back("TABLE(field_1_01 UINT32, field_2_012 INT8 ARRAY, field_3_0123 BOOL, field_4_01234 HIRESTIME, field_5_012345 UINT32, field_6_0123456 BOOL, field_7_01234567 INT16 ARRAY, field_8_012345678 INT64 ARRAY, field_9_0123456789 DATETIME ARRAY, field_10_0 INT64, field_11_01 DATETIME, field_12_012 UINT32, field_13_0123 UINT64, field_14_01234 UINT8, field_15_012345 INT8, field_16_0123456 RICHREAL ARRAY, field_17_01234567 CHAR ARRAY, field_18_012345678 REAL, field_19_0123456789 INT64, field_20_0 INT8, field_21_01 BOOL, field_22_012 INT8 ARRAY, field_23_0123 HIRESTIME ARRAY, field_24_01234 DATETIME, field_25_012345 DATETIME ARRAY, field_26_0123456 REAL, field_27_01234567 CHAR, field_28_012345678 HIRESTIME ARRAY, field_29_0123456789 INT32, field_30_0 HIRESTIME, field_31_01 HIRESTIME ARRAY, field_32_012 DATETIME, field_33_0123 UINT64 ARRAY, field_34_01234 INT8, field_35_012345 RICHREAL, field_36_0123456 CHAR, field_37_01234567 INT32, field_38_012345678 INT16, field_39_0123456789 UINT8, field_40_0 UINT16 ARRAY, field_41_01 RICHREAL, field_42_012 INT64 ARRAY, field_43_0123 BOOL, field_44_01234 UINT32, field_45_012345 DATETIME, field_46_0123456 UINT32, field_47_01234567 INT32, field_48_012345678 HIRESTIME ARRAY, field_49_0123456789 UINT8 ARRAY, field_50_0 UINT8, field_51_01 INT8, field_52_012 INT32, field_53_0123 DATETIME, field_54_01234 INT8, field_55_012345 RICHREAL, field_56_0123456 DATE, field_57_01234567 BOOL, field_58_012345678 BOOL, field_59_0123456789 UINT8, field_60_0 INT64, field_61_01 UINT32, field_62_012 UINT64, field_63_0123 UINT32, field_64_01234 UINT32, field_65_012345 INT32, field_66_0123456 RICHREAL, field_67_01234567 INT16, field_68_012345678 INT16, field_69_0123456789 UINT64, field_70_0 RICHREAL, field_71_01 DATETIME, field_72_012 UINT8, field_73_0123 RICHREAL, field_74_01234 UINT16, field_75_012345 UINT64, field_76_0123456 DATETIME, field_77_01234567 DATE ARRAY, field_78_012345678 BOOL, field_79_0123456789 UINT8, field_80_0 UINT32, field_81_01 INT64, field_82_012 INT64 ARRAY, field_83_0123 DATETIME)");
    }
}


int
main(int argc, const char** argv)
{
  WH_CONNECTION       hnd = nullptr;

  vector<string> glbNames;
  vector<string> glbTypes;

  setup_database("echo_proc_db", glbNames, glbTypes);

  bool success = tc_settup_connection(argc, argv, &hnd);
  success = success && test_global_variables(hnd, glbNames, glbTypes);
  WClose(hnd);


  if (success)
    {
      setup_database("administrator", glbNames, glbTypes);

      success = tc_settup_connection(argc, argv, &hnd);
      success = success && test_global_variables(hnd, glbNames, glbTypes);
      WClose(hnd);
    }

  if (success)
    {
      setup_database("test_list_db_frame_size", glbNames, glbTypes);

      success = tc_settup_connection(argc, argv, &hnd);
      success = success && test_global_variables(hnd, glbNames, glbTypes);
      WClose(hnd);
    }

  if ( ! success)
    {
      cout << "TEST RESULT: FAIL" << std::endl;
      return 1;
    }


  cout << "TEST RESULT: PASS" << std::endl;

  return 0;
}
