/*
 * This file is part of SubTypo.
 *
 * SubTypo is free software: you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * SubTypo is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with SubTypo.
 * If not, see <https://www.gnu.org/licenses/>.
 */

package com.teixeira0x.subtypo.ui.common.util

import android.app.Activity
import android.content.res.Configuration
import com.google.android.material.color.DynamicColors
import com.teixeira0x.subtypo.core.preference.PreferencesManager
import com.teixeira0x.subtypo.ui.common.R

fun Activity.updateTheme() {
  if (PreferencesManager.appearanceDynamicColors) {
    DynamicColors.applyToActivityIfAvailable(this)
  }

  updateThemeStyle()
}

fun Activity.updateThemeStyle() {
  if (PreferencesManager.appearanceAmoled) {
    theme.applyStyle(R.style.Amoled, true)
  }
}

val Configuration.isDarkMode: Boolean
  get() =
    uiMode.and(Configuration.UI_MODE_NIGHT_MASK) ==
      Configuration.UI_MODE_NIGHT_YES
