/*
 * This file is part of SubTypo.
 *
 * SubTypo is free software: you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * SubTypo is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with SubTypo.
 * If not, see <https://www.gnu.org/licenses/>.
 */

package com.teixeira0x.subtypo.build

@SuppressWarnings("unused")
object VersionUtils {
  const val versionCode = 5
  const val version = "2.0.1"

  val versionName by lazy {
    val branchName = CI.branchName
    val isCi = CI.isCiBuild

    when {
      isCi && branchName == "main" -> "$version-release"
      isCi && branchName == "beta" -> "$version-beta"
      isCi -> "$version-${CI.commitHash}-${CI.branchName}"
      else -> "$version-local"
    }
  }
}
