/*
 * This file is part of SubTypo.
 *
 * SubTypo is free software: you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * SubTypo is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with SubTypo.
 * If not, see <https://www.gnu.org/licenses/>.
 */

package com.teixeira0x.subtypo.ui.projectlist.adapter

import androidx.core.view.isVisible
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.google.android.material.R.attr
import com.google.android.material.color.MaterialColors
import com.teixeira0x.subtypo.core.domain.model.Project
import com.teixeira0x.subtypo.ui.common.R
import com.teixeira0x.subtypo.ui.common.databinding.LayoutProjectItemBinding

class ProjectViewHolder(
  private val listener: ProjectClickListener,
  private val binding: LayoutProjectItemBinding,
) : RecyclerView.ViewHolder(binding.root) {

  fun bind(project: Project, isSelected: Boolean) {
    binding.apply {
      binding.root.setBackgroundColor(
        if (isSelected)
          MaterialColors.getColor(binding.root, attr.colorControlHighlight)
        else android.R.color.transparent
      )
      configureListeners(project)
      with(project) {
        tvName.text = name

        if (videoUri.isNotEmpty()) {
          Glide.with(root.context).load(videoUri).into(imgVideoThumbnail)

          imgVideoThumbnail.isVisible = true
          tvVideoName.text = videoName
        } else {
          imgVideoThumbnail.isVisible = false
          tvVideoName.setText(R.string.proj_no_video)
        }
      }
    }
  }

  private fun configureListeners(project: Project) {
    binding.root.apply {
      setOnClickListener { listener.onProjectClickListener(it, project) }
      setOnLongClickListener {
        listener.onProjectLongClickListener(it, project)
      }
    }
  }
}
