/*
 * This file is part of SubTypo.
 *
 * SubTypo is free software: you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * SubTypo is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with SubTypo.
 * If not, see <https://www.gnu.org/licenses/>.
 */

package com.teixeira0x.subtypo.ui.about.fragment

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.view.ViewCompat
import com.mikepenz.aboutlibraries.ui.LibsSupportFragment
import com.teixeira0x.subtypo.ui.common.R
import com.teixeira0x.subtypo.ui.common.base.BaseBottomSheetFragment
import com.teixeira0x.subtypo.ui.common.databinding.FragmentSheetAboutLibrariesBinding

class AboutLibrariesSheetFragment : BaseBottomSheetFragment() {

  private var fragment: WithoutInsetsLibsFragment? = null

  override fun onCreateView(
    inflater: LayoutInflater,
    container: ViewGroup?,
    savedInstanceState: Bundle?,
  ): View? {
    return FragmentSheetAboutLibrariesBinding.inflate(inflater).root
  }

  override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
    super.onViewCreated(view, savedInstanceState)

    childFragmentManager
      .beginTransaction()
      .replace(
        R.id.fragment_container,
        WithoutInsetsLibsFragment().also { fragment = it },
      )
      .commit()
  }

  override fun onDestroyView() {
    super.onDestroyView()
    fragment = null
  }

  class WithoutInsetsLibsFragment : LibsSupportFragment() {

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
      super.onViewCreated(view, savedInstanceState)

      ViewCompat.setOnApplyWindowInsetsListener(view) { _, insets ->
        view.setPadding(0, 0, 0, 0)
        insets
      }
    }
  }
}
