/*
 * This file is part of SubTypo.
 *
 * SubTypo is free software: you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * SubTypo is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with SubTypo.
 * If not, see <https://www.gnu.org/licenses/>.
 */

package com.teixeira0x.subtypo.ui.about.fragment

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.appcompat.widget.TooltipCompat
import androidx.fragment.app.Fragment
import androidx.recyclerview.widget.LinearLayoutManager
import com.teixeira0x.subtypo.App
import com.teixeira0x.subtypo.BuildConfig
import com.teixeira0x.subtypo.ui.about.adapter.CardItemListAdapter
import com.teixeira0x.subtypo.ui.about.model.CardItem
import com.teixeira0x.subtypo.ui.common.R
import com.teixeira0x.subtypo.ui.common.databinding.FragmentAboutBinding
import com.teixeira0x.subtypo.ui.common.util.openUrl

class AboutFragment : Fragment(), View.OnClickListener {

  private var _binding: FragmentAboutBinding? = null
  private val binding: FragmentAboutBinding
    get() = checkNotNull(_binding) { "AboutFragment has been destroyed" }

  private val appVersion =
    "v${BuildConfig.VERSION_NAME} (${BuildConfig.BUILD_TYPE})"

  override fun onCreateView(
    inflater: LayoutInflater,
    container: ViewGroup?,
    savedInstanceState: Bundle?,
  ): View {
    return FragmentAboutBinding.inflate(inflater, container, false)
      .also { _binding = it }
      .root
  }

  override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
    super.onViewCreated(view, savedInstanceState)
    configureUI()
  }

  private fun configureUI() {
    binding.tvAppVersion.setText(appVersion)
    binding.imgSocialWebsite.setOnClickListener(this)
    binding.imgSocialEmail.setOnClickListener(this)

    TooltipCompat.setTooltipText(
      binding.imgSocialWebsite,
      getString(R.string.description_social_visit_website),
    )

    TooltipCompat.setTooltipText(
      binding.imgSocialEmail,
      getString(R.string.description_social_send_email),
    )

    binding.rvContribution.layoutManager = LinearLayoutManager(requireContext())
    binding.rvContribution.adapter =
      CardItemListAdapter(getContributionCardItemList())

    binding.rvMore.layoutManager = LinearLayoutManager(requireContext())
    binding.rvMore.adapter = CardItemListAdapter(getMoreCardItemList())
  }

  private fun getContributionCardItemList(): List<CardItem> {
    return listOf(
      CardItem(
        icon = R.drawable.ic_github,
        title = getString(R.string.about_title_contribute),
        subtitle = getString(R.string.about_subtitle_contribute),
        action = { context?.openUrl(App.APP_REPO_URL) },
      ),
      CardItem(
        icon = R.drawable.ic_translate,
        title = getString(R.string.about_title_translate),
        subtitle = getString(R.string.about_subtitle_translate),
        action = { context?.openUrl(App.APP_CROWDIN_URL) },
      ),
      CardItem(
        icon = R.drawable.ic_heart,
        title = getString(R.string.about_title_contributors),
        subtitle = getString(R.string.about_subtitle_contributors),
        action = { context?.openUrl(App.APP_REPO_CONTRIBUTORS_URL) },
      ),
    )
  }

  private fun getMoreCardItemList(): List<CardItem> {
    return listOf(
      CardItem(
        icon = R.drawable.ic_text_box_multiple,
        title = getString(R.string.about_title_privacy),
        subtitle = getString(R.string.about_subtitle_privacy),
        action = { context?.openUrl(App.APP_PRIVACY_URL) },
      ),
      CardItem(
        icon = R.drawable.ic_license,
        title = getString(R.string.about_title_libraries),
        subtitle = getString(R.string.about_subtitle_libraries),
        action = {
          AboutLibrariesSheetFragment()
            .show(childFragmentManager, "AboutLibrariesSheetFragment")
        },
      ),
    )
  }

  override fun onClick(view: View) {
    when (view.id) {
      binding.imgSocialWebsite.id -> context?.openUrl(App.APP_WEBSITE_URL)
      binding.imgSocialEmail.id -> context?.openUrl("mailto:${App.APP_EMAIL}")
    }
  }
}
