/*
 * This file is part of SubTypo.
 *
 * SubTypo is free software: you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * SubTypo is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with SubTypo.
 * If not, see <https://www.gnu.org/licenses/>.
 */

package com.teixeira0x.subtypo.ui.about.activity

import android.os.Bundle
import android.view.View
import androidx.core.graphics.Insets
import androidx.core.view.updatePadding
import androidx.core.view.updatePaddingRelative
import com.teixeira0x.subtypo.ui.common.base.BaseEdgeToEdgeActivity
import com.teixeira0x.subtypo.ui.common.databinding.ActivityAboutBinding

class AboutActivity : BaseEdgeToEdgeActivity() {

  private var _binding: ActivityAboutBinding? = null

  override fun bindView(): View {
    return ActivityAboutBinding.inflate(layoutInflater)
      .also { _binding = it }
      .root
  }

  override fun onApplySystemBarInsets(insets: Insets) {
    _binding?.apply {
      appBar.updatePadding(top = insets.top)
      toolbar.updatePaddingRelative(start = insets.left, end = insets.right)

      mainContent.updatePadding(
        left = insets.left,
        right = insets.right,
        bottom = insets.bottom,
      )
    }
  }

  override fun onCreate(savedInstanceState: Bundle?) {
    super.onCreate(savedInstanceState)
    setSupportActionBar(_binding?.toolbar)
    supportActionBar?.setDisplayHomeAsUpEnabled(true)
    _binding?.toolbar?.setNavigationOnClickListener {
      onBackPressedDispatcher.onBackPressed()
    }
  }
}
