<p align="center">
  <img src="./fastlane/metadata/android/en-US/images/logo/2.0.0-logo.png" alt="SubTypo" width="80" height="80"/>
</p>
<h1 align="center"><b>SubTypo</b></h1>
<p align="center">Create and edit subtitles simply and quickly!</p>

<div align="center">

[![](https://img.shields.io/github/v/release/teixeira0x/SubTypo?include_prereleases&style=for-the-badge&logo=GitHub&label=GitHub)](https://github.com/teixeira0x/SubTypo/releases) 
[![](https://img.shields.io/endpoint?url=https://apt.izzysoft.de/fdroid/api/v1/shield/com.teixeira0x.subtypo&style=for-the-badge)](https://apt.izzysoft.de/fdroid/index/apk/com.teixeira0x.subtypo)

</div>

---

## 📋 About

**SubTypo** is a simple, user-friendly subtitle editor designed for quick and efficient subtitle creation and editing. With support for importing/exporting subtitle files and editing with or without video playback, SubTypo ensures a seamless experience.

## 🚧 Currently in Closed Testing

SubTypo is currently in closed testing on Google Play.  
You can join our **testing group** by following the link below:  

**[Join the Testers Group](https://groups.google.com/g/teixeira0x-testers)**


## 🌍 Features

- **Video Support**: Edit subtitles synced with your video.
- **Standalone Editing**: Work on subtitles without requiring a video.
- **Import/Export**: Seamlessly import and export subtitle files.
- **Material You Design**: Customizable and visually appealing interface.


## 🤝 How to Contribute

We welcome contributions to SubTypo! Here’s how you can get involved:

1. **Development**:  
   Commits should always be made to the `dev` branch. The `main` branch is protected and reserved for release commits.  

2. **Translation**:  
   Help translate SubTypo into your language using Crowdin:  
   [![Crowdin](https://badges.crowdin.net/subtypo/localized.svg)](https://crowdin.com/project/subtypo)

3. **Bug Reports and Suggestions**:  
   Report issues or suggest features via [GitHub Issues](https://github.com/teixeira0x/SubTypo/issues).

## 🛠️ Build Instructions

To build SubTypo locally:
1. **Clone the repository**:  

```bash
git clone https://github.com/teixeira0x/SubTypo.git
```

2. **Switch to the dev branch**:

```
git checkout dev
```

3. **Open the project in Android Studio or an IDE of your choice and synchronize the dependencies.**

4. **Build and run the project on an emulator or physical device.**

## 🙏 Thanks to
- [SUSE](https://github.com/SUSE) for the [suse-font](https://github.com/SUSE/suse-font)
- [tony19](https://github.com/tony19) for the [logback-android](https://github.com/tony19/logback-android)
- [Akash Yadav](https://github.com/itsaky) for the awesome [AndroidIDE](https://github.com/AndroidIDEOfficial/AndroidIDE)

## 📜 License

```
SubTypo is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SubTypo is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SubTypo.  If not, see <https://www.gnu.org/licenses/>.
```

Any violations to the license can be reported either by opening an issue or writing a mail to us
directly.
