
# React Native Handbook

by Teerasej Jiraphatchandej, [Nextflow.in.th](https://www.nextflow.in.th)

- [Slide](https://nextflowth-my.sharepoint.com/:b:/g/personal/teerasej_nextflowth_onmicrosoft_com/ERTJ6PlvH91KoFmHI9LwtZ0BFIaPF28IVtiRdksuCImL7Q?e=HD9iDy)

# Setup

- [Setup](setup.md)

# Reference 

- [Node Handbook](https://github.com/teerasej/node-handbook)
- [React Handbook](https://github.com/teerasej/react-handbook)

# Fundamental

1. [React Fundamental](contents/fundamental/react-concept/README.md)
2. [Stack Navigation](contents/stack-navigation/readme.md)
3. [Tab Navigation](contents/tab-navigation/readme.md)


# Example part 

1. [User Interface Module](contents/note-app/3-setup-ui.md)
2. [React Navigation & Redux](contents/fundamental/react-nav-redux/README.md)
3. [Connect Web API](contents/fundamental/react-web-api/README.md)
4. [SQLite](contents/fundamental/react-sqlite/README.md)

## Function Component

- **AI:** [เรียกใช้ ChatGPT](contents/chatgpt-client/README.md)
- **Web API:** [ดึงข้อมูลจาก Web API](contents/example-part/web-api-axios.md)

## Class Component

- **SQLite Database:** [บันทึกข้อมูล](contents/example-part/save-data-sqlite.md)
- **JWT Sign in:** [Login with JWT](contents/example-part/login-with-jwt.md)
- **Google Map:** [Pin Marker on Map](contents/example-part/pin-marker-on-map.md)

# + Workshop 

- **Counter + Redux:** [แบบ Function component](contents/counter-redux-function/readme.md) | [แบบ Class Component](contents/counter-redux/readme.md)
- **Note Application**: [แบบ Function component](contents/note-app-function/README.md) | [แบบ Class Component](note-app/README.md)
- **Barcode Checker** [แบบ Function Component](contents/barcode-checker/README.md)
- **Branch Locator** [แบบ Class Component](contents/branch-locator/README.md)
- [Local Notification](contents/local-notitication/README.md)

# Publishing 

- [การ Publish Application File](contents/publishing/readme.md)

# Performance 

- [Slide](https://www.dropbox.com/s/s2fjkiadto2az9o/Performance%20in%20React.pdf?dl=0)


# Security 

- [Slide](https://www.dropbox.com/s/ayj0tqpxea1dphw/Security%20in%20React%20Native.pdf?dl=0)

# Advanced Topics

- [Advanced Topics Exercise](/contents/advanced-topics/README.md)