<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace ModStart\Admin\Controller; use Illuminate\Routing\Controller; use Illuminate\Support\Str; use ModStart\Admin\Auth\Admin; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminCRUD; use ModStart\Admin\Model\AdminUser; use ModStart\Admin\Provider\AdminUserConfigProvider; use ModStart\Core\Exception\BizException; use ModStart\Core\Util\ConvertUtil; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\RenderUtil; use ModStart\Detail\Detail; use ModStart\Field\AbstractField; use ModStart\Form\Form; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\Grid; use ModStart\Grid\GridFilter; class AdminUserController extends Controller { use HasAdminCRUD; protected function grid() { goto A4mzL; cqW7G: $cFJv5->title(L('Admin User')); goto sODhq; A4mzL: $cFJv5 = new Grid(AdminUser::class, function (Grid $cFJv5) { $cFJv5->display('id', L('ID'))->sortable(true)->width(80); $cFJv5->text('username', L('Username')); if (modstart_config('AdminManagerEnhance_EnablePhone', false)) { $cFJv5->text('phone', L('Phone')); } if (modstart_config('AdminManagerEnhance_EnableEmail', false)) { $cFJv5->text('email', L('Email')); } $cFJv5->tags('roles', L('Roles'))->hookFormatValue(function ($plPBD, AbstractField $Lblb7) { $qn4H0 = $Lblb7->item(); if (AdminPermission::isFounder($qn4H0->id)) { return array(L('Admin Founder')); } return collect($plPBD)->pluck('name')->toArray(); }); if (!AdminUserConfigProvider::isEmpty()) { $cFJv5->display('config', '配置')->hookRendering(function (AbstractField $Lblb7, $qn4H0, $uFdJG) { return RenderUtil::view('modstart::admin.user.configGrid', array('item' => $qn4H0)); }); } $cFJv5->text('lastLoginTime', L('Last Login Time')); $cFJv5->text('lastLoginIp', L('Last Login Ip')); $cFJv5->gridFilter(function (GridFilter $NSbxQ) { $NSbxQ->eq('id', L('ID')); $NSbxQ->like('username', L('Username')); }); $cFJv5->hookItemOperateRendering(function (ItemOperate $w_dYU) { if (AdminPermission::isFounder($w_dYU->item()->id)) { $w_dYU->canDelete(false); } }); }); goto od9dL; od9dL: if (AdminPermission::isNotPermit('AdminUserManage')) { $cFJv5->canAdd(false)->canEdit(false)->canDelete(false); } goto cqW7G; sODhq: return $cFJv5; goto JBt2W; JBt2W: } protected function form() { goto dUEHH; c4I25: $KBQbd->title(L('Admin User')); goto iByjv; iByjv: return $KBQbd; goto V2pSP; dUEHH: $KBQbd = new Form(AdminUser::class, function (Form $KBQbd) { $KBQbd->text('username', L('Username'))->required()->rules('unique:admin_user,username,' . CRUDUtil::id()); $KBQbd->text('password', L('Password'))->rules($KBQbd->isModeAdd() ? 'required' : '')->placeholder($KBQbd->isModeAdd() ? '' : L('Keep Old Password If Empty'))->value($KBQbd->isModeAdd() ? RandomUtil::string(6) : '')->hookFormatValue(function ($plPBD, AbstractField $Lblb7) { return ''; }); if (modstart_config('AdminManagerEnhance_EnablePhone', false)) { $KBQbd->text('phone', L('Phone'))->ruleUnique('admin_user'); } if (modstart_config('AdminManagerEnhance_EnableEmail', false)) { $KBQbd->text('email', L('Email'))->ruleUnique('admin_user'); } $qn4H0 = $KBQbd->item(); $x2TSi = $KBQbd->checkbox('roles', L('Roles'))->optionModel('admin_role')->hookValueUnserialize(function ($plPBD, AbstractField $Lblb7) { return $plPBD->map(function ($AOIkm) { return $AOIkm['id']; }); })->hookValueSerialize(function ($plPBD, AbstractField $Lblb7) { return ConvertUtil::toArray($plPBD); }); if ($KBQbd->isModeEdit() && AdminPermission::isFounder($qn4H0->id)) { $x2TSi->editable(false); } if (!AdminUserConfigProvider::isEmpty()) { $KBQbd->display('config', '配置')->hookRendering(function (AbstractField $Lblb7, $qn4H0, $uFdJG) { return RenderUtil::view('modstart::admin.user.configForm', array('item' => $qn4H0)); })->formShowOnly(true); } $KBQbd->display('created_at', L('Created At'))->editable(true); $KBQbd->hookSaving(function (Form $KBQbd) { if ($KBQbd->isModeAdd()) { goto c3TRV; iUYeD: $j_prK['passwordSalt'] = Str::random(16); goto odXH4; c3TRV: $j_prK = $KBQbd->dataAdding(); goto iUYeD; tE2a8: $KBQbd->dataAdding($j_prK); goto OMoZk; odXH4: $j_prK['password'] = Admin::passwordEncrypt($j_prK['password'], $j_prK['passwordSalt']); goto tE2a8; OMoZk: } else { if ($KBQbd->isModeEdit()) { goto zRiV8; yQqhg: $KBQbd->dataEditing($j_prK); goto BmHOA; zRiV8: $j_prK = $KBQbd->dataEditing(); goto f1cho; f1cho: if ($j_prK['password']) { $j_prK['passwordSalt'] = Str::random(16); $j_prK['password'] = Admin::passwordEncrypt($j_prK['password'], $j_prK['passwordSalt']); } else { unset($j_prK['password']); } goto yQqhg; BmHOA: } } }); $KBQbd->hookDeleting(function (Form $KBQbd) { $KBQbd->item()->each(function ($qn4H0) { if (AdminPermission::isFounder($qn4H0->id)) { BizException::throws(L('Admin Founder Delete Forbidden')); } }); }); $KBQbd->hookSaved(function (Form $KBQbd) { $qn4H0 = $KBQbd->item(); foreach (AdminUserConfigProvider::listAll() as $XVJLM) { $XVJLM->saved($qn4H0); } }); $KBQbd->hookDeleted(function (Form $KBQbd) { $KBQbd->item()->each(function ($qn4H0) { foreach (AdminUserConfigProvider::listAll() as $XVJLM) { $XVJLM->deleted($qn4H0); } }); }); }); goto fY1tr; fY1tr: if (AdminPermission::isNotPermit('AdminUserManage')) { $KBQbd->canAdd(false)->canEdit(false)->canDelete(false); } goto c4I25; V2pSP: } protected function detail() { goto ePMnP; hnNxb: $qKfdJ->title(L('Admin User')); goto Fq0fd; ePMnP: $qKfdJ = new Detail(AdminUser::class, function (Detail $qKfdJ) { $qKfdJ->display('id', L('ID')); $qKfdJ->text('username', L('Username')); if (modstart_config('AdminManagerEnhance_EnablePhone', false)) { $qKfdJ->text('phone', L('Phone')); } if (modstart_config('AdminManagerEnhance_EnableEmail', false)) { $qKfdJ->text('email', L('Email')); } $qKfdJ->tags('roles', L('Roles'))->hookFormatValue(function ($plPBD, AbstractField $Lblb7) { $qn4H0 = $Lblb7->item(); if (AdminPermission::isFounder($qn4H0->id)) { return array(L('Admin Founder')); } return collect($plPBD)->pluck('name')->toArray(); }); if (!AdminUserConfigProvider::isEmpty()) { $qKfdJ->display('config', '配置')->hookRendering(function (AbstractField $Lblb7, $qn4H0, $uFdJG) { return RenderUtil::view('modstart::admin.user.configDetail', array('item' => $qn4H0)); }); } $qKfdJ->display('created_at', L('Created At')); $qKfdJ->display('updated_at', L('Updated At')); }); goto hnNxb; Fq0fd: return $qKfdJ; goto sHuNE; sHuNE: } }