<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\PayCenter\Util; use Carbon\Carbon; use EasyWeChat\Factory; use EasyWeChat\Kernel\Exceptions\InvalidArgumentException; use EasyWeChat\Kernel\Exceptions\InvalidConfigException; use GuzzleHttp\Exception\GuzzleException; use Illuminate\Support\Facades\Log; use Illuminate\Support\Facades\Session; use Illuminate\Support\Str; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Response; use ModStart\Core\Util\EncodeUtil; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\IdUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\StrUtil; use Module\Member\Util\MemberMoneyUtil; use Module\PayCenter\Events\OrderPayedEvent; use Module\PayCenter\Provider\PayCenterProvider; use Module\PayCenter\Type\PayOrderStatus; use Module\PayCenter\Type\PayType; use Module\Vendor\Log\Logger; use Payment\Client\Charge; use Payment\Config; class PayOrderUtil { private static function getOrGeneratePaySessionKey() { goto eKrXI; Ca6AN: return $v7_Bo; goto gh80W; eKrXI: $v7_Bo = Session::get('paySessionKey', null); goto Pw1UZ; Pw1UZ: if (empty($v7_Bo)) { $v7_Bo = RandomUtil::string(32); Session::put('paySessionKey', $v7_Bo); } goto Ca6AN; gh80W: } public static function updateFee($s9y6u, $gcYsp, $bblDN) { goto arZl1; bfGW2: if ($VyxWv['status'] == PayOrderStatus::NEW_ORDER || $VyxWv['status'] == PayOrderStatus::CREATED) { self::update($VyxWv['id'], array('feeTotal' => $bblDN)); } goto MfBFV; WVMOD: BizException::throwsIfEmpty('订单不存在', $VyxWv); goto bfGW2; arZl1: $VyxWv = self::getByBizAndBizId($s9y6u, $gcYsp); goto WVMOD; MfBFV: } public static function autoPay($s9y6u, $gcYsp, $bblDN = null) { goto x6wGB; mfzwA: self::update($zg01X['id'], array('status' => PayOrderStatus::CREATED, 'payType' => PayType::NONE, 'timePayCreated' => Carbon::now(), 'payOrderId' => null)); goto LwmR7; LwmR7: return PayOrderUtil::handleOrderPay(PayType::NONE, config('pay.payOrderOutTradeNoPrefix') . '_' . $zg01X['id']); goto LCSpo; x6wGB: $zg01X = PayOrderUtil::prepareOrder($s9y6u, $gcYsp, $bblDN); goto mfzwA; LCSpo: } public static function prepareOrder($s9y6u, $gcYsp, $bblDN = null, $imAuh = null, $uOPv2 = null, $KI8EF = array()) { goto Y7wyK; KWm__: $VyxWv = array(); goto c8xfQ; ZfHZz: return $VyxWv; goto zSdCN; c8xfQ: if (empty($D8U2O)) { goto J5G2G; J5G2G: $k_QCu = IdUtil::generateSN(); goto OwbTS; ngIuA: $VyxWv['timeClosed'] = null; goto DdmM3; XrNdl: $VyxWv['timePayCreated'] = null; goto OoqWH; x4uZ4: $VyxWv['payOrderId'] = null; goto VlOh9; aXE1e: $VyxWv['timeRefundCreated'] = null; goto s2Nqv; Fqee7: $VyxWv['bizId'] = $gcYsp; goto OW26z; s2Nqv: $VyxWv['timeRefundSuccess'] = null; goto ngIuA; uEKGv: $VyxWv['id'] = $k_QCu; goto CBybD; ILxc1: $VyxWv['body'] = $imAuh; goto ORqJW; hdNZX: $VyxWv['status'] = PayOrderStatus::NEW_ORDER; goto x4uZ4; AG8K2: $VyxWv['biz'] = $s9y6u; goto Fqee7; OW26z: $VyxWv['payType'] = null; goto hdNZX; OoqWH: $VyxWv['timePay'] = null; goto GRzMk; VlOh9: $VyxWv['feeTotal'] = $bblDN; goto XrNdl; OwbTS: $VyxWv['id'] = $k_QCu; goto AG8K2; CBybD: $VyxWv['param'] = $KI8EF; goto J1BhI; ORqJW: $VyxWv['redirect'] = $uOPv2; goto FK_aZ; DdmM3: $VyxWv['param'] = json_encode($KI8EF, JSON_UNESCAPED_UNICODE); goto ILxc1; GRzMk: $VyxWv['feeRefund'] = null; goto aXE1e; FK_aZ: $VyxWv = ModelUtil::insert('pay_order', $VyxWv); goto uEKGv; J1BhI: } else { goto grbKW; ZtUz7: if (!empty($KI8EF)) { $pmhtR['param'] = json_encode($KI8EF, JSON_UNESCAPED_UNICODE); } goto fCzxZ; grbKW: $VyxWv = $D8U2O; goto lGeLz; lGeLz: $pmhtR = array(); goto D6lup; D6lup: if (null !== $bblDN) { $pmhtR['feeTotal'] = $bblDN; } goto ERXXk; GoQWO: switch ($VyxWv['status']) { case PayOrderStatus::NEW_ORDER: break; case PayOrderStatus::CREATED: goto BpZCI; VWdak: $pmhtR['timeClosed'] = null; goto ZN5_3; BpZCI: $pmhtR['status'] = PayOrderStatus::NEW_ORDER; goto VWdak; ZN5_3: break; goto hbA2j; hbA2j: case PayOrderStatus::CLOSED: goto sq3ty; sq3ty: $pmhtR['status'] = PayOrderStatus::NEW_ORDER; goto GhvcM; GhvcM: $pmhtR['timeClosed'] = null; goto tepAO; tepAO: break; goto r0UpZ; r0UpZ: case PayOrderStatus::CLOSED_EXPIRED: goto X7ZmR; X7ZmR: $pmhtR['status'] = PayOrderStatus::NEW_ORDER; goto HpW0j; BplB3: break; goto BXnoV; HpW0j: $pmhtR['timeClosed'] = null; goto BplB3; BXnoV: default: BizException::throws('订单状态异常'); } goto ZtUz7; ERXXk: if (null !== $imAuh) { $pmhtR['body'] = $imAuh; } goto W8e4h; fCzxZ: if (!empty($pmhtR)) { ModelUtil::update('pay_order', $D8U2O['id'], $pmhtR); foreach ($pmhtR as $iM64L => $J9jpR) { $VyxWv[$iM64L] = $J9jpR; } } goto YLlyy; W8e4h: if (null !== $uOPv2) { $pmhtR['redirect'] = $uOPv2; } goto GoQWO; YLlyy: } goto ZfHZz; Y7wyK: $D8U2O = ModelUtil::get('pay_order', array('biz' => $s9y6u, 'bizId' => $gcYsp)); goto KWm__; zSdCN: } public static function getOrderSecretId($koQno) { return EncodeUtil::expiredDataForever($koQno, self::getOrGeneratePaySessionKey()); } public static function getOrder($VyxWv) { goto OrowN; OrowN: $k_QCu = EncodeUtil::expiredDataDecode($VyxWv, self::getOrGeneratePaySessionKey()); goto ERQfA; jDcFf: ModelUtil::decodeRecordJson($wA6n0, array('param')); goto uWZYQ; FNdYm: return $wA6n0; goto pZmoq; uWZYQ: $wA6n0['id'] = '' . $wA6n0['id']; goto FNdYm; qUAbJ: $wA6n0 = ModelUtil::get('pay_order', $k_QCu); goto jDcFf; ERQfA: if (!$k_QCu) { return null; } goto qUAbJ; pZmoq: } public static function createPay($koQno, $LUN3c, $Vhyc6 = array()) { goto YZbp0; twLZt: switch ($LUN3c) { case PayType::ALIPAY: return self::createAlipay($zg01X, $LUN3c, $Vhyc6); case PayType::ALIPAY_WEB: return self::createAlipayWeb($zg01X, $LUN3c, $Vhyc6); case PayType::ALIPAY_MOBILE: return self::createAlipayMobile($zg01X, $LUN3c, $Vhyc6); case PayType::WECHAT: return self::createWechat($zg01X, $LUN3c, $Vhyc6); case PayType::WECHAT_MOBILE: return self::createWechatMobile($zg01X, $LUN3c, $Vhyc6); case PayType::WECHAT_APP: return self::createWechatApp($zg01X, $LUN3c, $Vhyc6); case PayType::WECHAT_MINI_PROGRAM: return self::createWechatMiniProgram($zg01X, $LUN3c, $Vhyc6); case PayType::WECHAT_H5: return self::createWechatH5($zg01X, $LUN3c, $Vhyc6); case PayType::MEMBER_MONEY: return self::createMemberMoney($zg01X, $LUN3c, $Vhyc6); default: goto QgBU5; ZH0Ex: return Response::generate(-1, '支付方式不存在'); goto T1K3z; QgBU5: $UQRO3 = PayCenterProvider::get($LUN3c); goto PeMmD; PeMmD: if ($UQRO3) { return $UQRO3->onSubmit($zg01X, $LUN3c, $Vhyc6); } goto ZH0Ex; T1K3z: } goto VIzRB; y1Pht: BizException::throwsIfEmpty('订单不存在', $zg01X); goto lwAO7; lwAO7: if ($zg01X['status'] == PayOrderStatus::PAYED) { return Response::generateError('订单已支付'); } else { if ($zg01X['status'] == PayOrderStatus::CLOSED) { return Response::generateError('订单已关闭，请刷新该页面'); } } goto twLZt; YZbp0: $zg01X = self::get($koQno); goto y1Pht; VIzRB: } public static function update($k_QCu, $c4mjf) { return ModelUtil::update('pay_order', array('id' => $k_QCu), $c4mjf); } public static function total() { $YvDZc = ModelUtil::model('pay_order')->where('status', PayOrderStatus::PAYED)->sum('feeTotal'); return sprintf('%.2f', $YvDZc); } public static function totalByTimeRange($oqsNF, $PT1Kd) { $YvDZc = ModelUtil::model('pay_order')->where('status', PayOrderStatus::PAYED)->where('created_at', '>=', $oqsNF)->where('created_at', '<=', $PT1Kd)->sum('feeTotal'); return sprintf('%.2f', $YvDZc); } public static function get($k_QCu) { goto fK2oo; fK2oo: $o_uJu = ModelUtil::get('pay_order', $k_QCu); goto Vewpd; Vewpd: ModelUtil::decodeRecordJson($o_uJu, 'param'); goto JpCNj; JpCNj: return $o_uJu; goto EdLmy; EdLmy: } public static function getByBizAndBizId($s9y6u, $gcYsp) { goto S7MvD; Xc3w0: ModelUtil::decodeRecordJson($o_uJu, 'param'); goto yvnse; yvnse: return $o_uJu; goto secAo; S7MvD: $o_uJu = ModelUtil::get('pay_order', array('biz' => $s9y6u, 'bizId' => $gcYsp)); goto Xc3w0; secAo: } public static function refund($s9y6u, $gcYsp, $XViBW = null, $KI8EF = array()) { goto Ua9Z5; UOLc8: return Response::generate(0, 'ok'); goto UAxQG; cf9qH: try { goto EFYH2; Cvho2: BizException::throwsIfEmpty('订单不存在', $VyxWv); goto I8BJe; u8lXT: $VyxWv = ModelUtil::getWithLock('pay_order', array('biz' => $s9y6u, 'bizId' => $gcYsp)); goto Cvho2; BghWk: ModelUtil::transactionCommit(); goto wT1e9; I8BJe: BizException::throwsIf('订单状态异常', $VyxWv['status'] != PayOrderStatus::PAYED); goto reGWF; reGWF: if (null === $pmhtR['feeRefund']) { $pmhtR['feeRefund'] = $VyxWv['feeTotal']; } goto osFZM; EFYH2: ModelUtil::transactionBegin(); goto u8lXT; osFZM: ModelUtil::update('pay_order', $VyxWv['id'], $pmhtR); goto BghWk; wT1e9: } catch (BizException $zJOgU) { ModelUtil::transactionRollback(); return Response::generateError($zJOgU->getMessage()); } goto UOLc8; Ua9Z5: $pmhtR = array('status' => PayOrderStatus::REFUND_SUCCESS, 'feeRefund' => $XViBW, 'timeRefundCreated' => date('Y-m-d H:i:s'), 'timeRefundSuccess' => date('Y-m-d H:i:s')); goto cf9qH; UAxQG: } public static function getWechatPayment() { goto pUOuS; pUOuS: $DKUdS = modstart_config(); goto ecyNz; Zg6qy: return Factory::payment($DKUdS); goto Mbplo; ecyNz: $DKUdS = array('app_id' => $DKUdS->getWithEnv('payWechatAppId'), 'mch_id' => $DKUdS->getWithEnv('payWechatMerchantId'), 'key' => $DKUdS->getWithEnv('payWechatKey'), 'cert_path' => '', 'key_path' => '', 'log' => array('default' => 'debug', 'channels' => array('debug' => array('driver' => 'single', 'path' => Logger::rotateLog('PayCenter_Wechat'), 'level' => 'debug')))); goto Zg6qy; Mbplo: } private static function createWechat($zg01X, $LUN3c, $Vhyc6) { goto pRzqT; pRzqT: if (!modstart_config('payWechatOn', false)) { return Response::generate(-1, '微信支付未开启'); } goto iw3En; Wfrgv: try { $WktN9 = $z4eue->order->unify($N20Vg); } catch (\Exception $zJOgU) { goto sk_eD; pThd4: if (Str::contains($fK95N, 'should be 32 chars length')) { BizException::throws('微信支付配置错误，请检查配置信息'); } goto teqSS; teqSS: throw $zJOgU; goto zWKy7; sk_eD: $fK95N = $zJOgU->getMessage(); goto pThd4; zWKy7: } goto P_DWI; pDnfp: if ($WktN9['result_code'] != 'SUCCESS') { $qc_le = $WktN9['err_code_des']; return Response::generate(-1, '创建订单失败:3:(' . $qc_le . ')'); } goto BjXuc; iw3En: $z4eue = self::getWechatPayment(); goto HiFd8; y5ciM: $c4mjf = array('payCodeUrl' => $WktN9['code_url'], 'successRedirect' => $zg01X['redirect']); goto s16yg; P_DWI: if (!isset($WktN9['return_code']) || $WktN9['return_code'] != 'SUCCESS') { return Response::generate(-1, '创建订单失败:1:' . (isset($WktN9['return_msg']) ? $WktN9['return_msg'] : 'NULL')); } goto zldL8; s16yg: return Response::generate(0, null, $c4mjf); goto u5vx4; BjXuc: self::update($zg01X['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $LUN3c, 'timePayCreated' => Carbon::now(), 'payOrderId' => $WktN9['prepay_id'])); goto y5ciM; zldL8: if (!isset($WktN9['result_code'])) { return Response::generate(-1, '订单创建失败:2'); } goto pDnfp; VG0my: if (isset($Vhyc6['limitPay'])) { switch ($Vhyc6['limitPay']) { case 'no_credit': $N20Vg['limit_pay'] = $Vhyc6['limitPay']; break; default: BizException::throws('Unknown limitPay'); break; } } goto Wfrgv; HiFd8: $N20Vg = array('trade_type' => 'NATIVE', 'body' => StrUtil::mbLimitChars($zg01X['body'], 120), 'out_trade_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $zg01X['id'] . '_' . RandomUtil::string(3), 'total_fee' => intval(bcmul($zg01X['feeTotal'], 100, 2)), 'notify_url' => action('\\Module\\PayCenter\\Web\\Controller\\NotifyController@index', array('payType' => PayType::WECHAT))); goto VG0my; u5vx4: } private static function createWechatApp($zg01X, $LUN3c, $Vhyc6) { goto AzWJr; bBmPu: if (!isset($WktN9['result_code'])) { return Response::generate(-1, '订单创建失败:2'); } goto hQMnt; sEkNn: if (!isset($WktN9['return_code']) || $WktN9['return_code'] != 'SUCCESS') { return Response::generate(-1, '创建订单失败:1:' . (isset($WktN9['return_msg']) ? $WktN9['return_msg'] : 'NULL')); } goto bBmPu; AzWJr: $z4eue = self::getWechatPayment(); goto yBcdv; hQMnt: if ($WktN9['result_code'] != 'SUCCESS') { $qc_le = $WktN9['err_code_des']; return Response::generate(-1, '创建订单失败:3:(' . $qc_le . ')'); } goto UZ2n8; yBcdv: $N20Vg = array('trade_type' => 'APP', 'body' => StrUtil::mbLimitChars($zg01X['body'], 120), 'out_trade_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $zg01X['id'] . '_' . RandomUtil::string(3), 'total_fee' => intval(bcmul($zg01X['feeTotal'], 100, 2)), 'notify_url' => action('\\Module\\PayCenter\\Web\\Controller\\NotifyController@index', array('payType' => PayType::WECHAT_MOBILE))); goto Z2zZI; lP70v: $VQq9D = $z4eue->jssdk->bridgeConfig($WktN9['prepay_id'], false); goto CWmu2; UZ2n8: self::update($zg01X['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $LUN3c, 'timePayCreated' => Carbon::now(), 'payOrderId' => $WktN9['prepay_id'])); goto lP70v; CWmu2: $c4mjf = array('payJsSdkConfig' => $VQq9D, 'successRedirect' => $zg01X['redirect']); goto Lpw1h; Lpw1h: return Response::generate(0, null, $c4mjf); goto uf6Ql; mw6rp: try { $WktN9 = $z4eue->order->unify($N20Vg); } catch (\Exception $zJOgU) { goto z2A3T; z2A3T: $fK95N = $zJOgU->getMessage(); goto qa1Hd; Ki6dF: throw $zJOgU; goto Ty4H3; qa1Hd: if (Str::contains($fK95N, 'should be 32 chars length')) { BizException::throws('微信支付配置错误，请检查配置信息'); } goto Ki6dF; Ty4H3: } goto sEkNn; Z2zZI: if (isset($Vhyc6['limitPay'])) { switch ($Vhyc6['limitPay']) { case 'no_credit': $N20Vg['limit_pay'] = $Vhyc6['limitPay']; break; default: BizException::throws('Unknown limitPay'); break; } } goto mw6rp; uf6Ql: } private static function createWechatMobile($zg01X, $LUN3c, $Vhyc6) { goto P38_9; lFvs8: if (!isset($WktN9['return_code']) || $WktN9['return_code'] != 'SUCCESS') { return Response::generate(-1, '创建订单失败:1:' . (isset($WktN9['return_msg']) ? $WktN9['return_msg'] : 'NULL')); } goto kF0Dz; YixNn: $N20Vg = array('openid' => $Vhyc6['openId'], 'trade_type' => 'JSAPI', 'body' => StrUtil::mbLimitChars($zg01X['body'], 120), 'out_trade_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $zg01X['id'] . '_' . RandomUtil::string(3), 'total_fee' => intval(bcmul($zg01X['feeTotal'], 100, 2)), 'notify_url' => action('\\Module\\PayCenter\\Web\\Controller\\NotifyController@index', array('payType' => PayType::WECHAT_MOBILE))); goto ZinRm; xiwy2: $VQq9D = $z4eue->jssdk->bridgeConfig($WktN9['prepay_id'], false); goto ho11h; P38_9: if (!modstart_config('payWechatOn', false)) { return Response::generate(-1, 'wechat mobile pay not enable'); } goto t39qR; t39qR: if (empty($Vhyc6['openId'])) { return Response::generate(-1, 'wechat mobile openId empty'); } goto X9D3E; ZinRm: if (isset($Vhyc6['limitPay'])) { switch ($Vhyc6['limitPay']) { case 'no_credit': $N20Vg['limit_pay'] = $Vhyc6['limitPay']; break; default: BizException::throws('Unknown limitPay'); break; } } goto AMmHo; HSCIn: if ($WktN9['result_code'] != 'SUCCESS') { $qc_le = $WktN9['err_code_des']; return Response::generate(-1, '创建订单失败:3:(' . $qc_le . ')'); } goto zwyJj; zwyJj: self::update($zg01X['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $LUN3c, 'timePayCreated' => Carbon::now(), 'payOrderId' => $WktN9['prepay_id'])); goto xiwy2; kF0Dz: if (!isset($WktN9['result_code'])) { return Response::generate(-1, '订单创建失败:2'); } goto HSCIn; AMmHo: try { $WktN9 = $z4eue->order->unify($N20Vg); } catch (\Exception $zJOgU) { goto PFO_E; cijKA: if (Str::contains($fK95N, 'should be 32 chars length')) { BizException::throws('微信支付配置错误，请检查配置信息'); } goto GEqib; PFO_E: $fK95N = $zJOgU->getMessage(); goto cijKA; GEqib: throw $zJOgU; goto EVsVX; EVsVX: } goto lFvs8; X9D3E: $z4eue = self::getWechatPayment(); goto YixNn; ho11h: $c4mjf = array('payJsSdkConfig' => $VQq9D, 'successRedirect' => $zg01X['redirect']); goto AfceW; AfceW: return Response::generate(0, null, $c4mjf); goto eOckU; eOckU: } private static function createWechatH5($zg01X, $LUN3c, $Vhyc6) { goto zVRu5; SwQLc: if (!isset($WktN9['return_code']) || $WktN9['return_code'] != 'SUCCESS') { return Response::generate(-1, '创建订单失败:1:' . (isset($WktN9['return_msg']) ? $WktN9['return_msg'] : 'NULL')); } goto aL58S; iqvJS: $z4eue = self::getWechatPayment(); goto FywRl; zVRu5: if (!modstart_config('payWechatOn', false)) { return Response::generate(-1, 'wechat mobile pay not enable'); } goto iqvJS; N5u0K: if ($WktN9['result_code'] != 'SUCCESS') { $qc_le = $WktN9['err_code_des']; return Response::generate(-1, '创建订单失败:3:(' . $qc_le . ')'); } goto w0CuG; s4x3H: return Response::generate(0, null, $c4mjf); goto uB0uv; FywRl: $N20Vg = array('trade_type' => 'MWEB', 'body' => StrUtil::mbLimitChars($zg01X['body'], 120), 'out_trade_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $zg01X['id'] . '_' . RandomUtil::string(3), 'total_fee' => intval(bcmul($zg01X['feeTotal'], 100, 2)), 'notify_url' => action('\\Module\\PayCenter\\Web\\Controller\\NotifyController@index', array('payType' => PayType::WECHAT_H5))); goto L4vUQ; Vgd3X: $c4mjf = array('payLink' => $WktN9['mweb_url'], 'successRedirect' => $zg01X['redirect']); goto s4x3H; aL58S: if (!isset($WktN9['result_code'])) { return Response::generate(-1, '订单创建失败:2'); } goto N5u0K; w0CuG: self::update($zg01X['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $LUN3c, 'timePayCreated' => Carbon::now(), 'payOrderId' => $WktN9['prepay_id'])); goto Vgd3X; No8oU: try { $WktN9 = $z4eue->order->unify($N20Vg); } catch (\Exception $zJOgU) { goto IRRbD; FN2pU: if (Str::contains($fK95N, 'should be 32 chars length')) { BizException::throws('微信支付配置错误，请检查配置信息'); } goto KqsH2; KqsH2: throw $zJOgU; goto b7YtE; IRRbD: $fK95N = $zJOgU->getMessage(); goto FN2pU; b7YtE: } goto SwQLc; L4vUQ: if (isset($Vhyc6['limitPay'])) { switch ($Vhyc6['limitPay']) { case 'no_credit': $N20Vg['limit_pay'] = $Vhyc6['limitPay']; break; default: BizException::throws('Unknown limitPay'); break; } } goto No8oU; uB0uv: } public static function getWechatMiniProgramPayment() { goto YhBO3; YhBO3: $DKUdS = modstart_config(); goto KAiL1; KAiL1: $DKUdS = array('app_id' => $DKUdS->getWithEnv('oauthWechatMiniProgramAppId'), 'mch_id' => $DKUdS->getWithEnv('payWechatMerchantId'), 'key' => $DKUdS->getWithEnv('payWechatKey'), 'cert_path' => '', 'key_path' => '', 'log' => array('default' => 'info', 'channels' => array('info' => array('driver' => 'single', 'path' => Logger::rotateLog('PayCenter_Wechat'), 'level' => 'info')))); goto r5Wne; r5Wne: return Factory::payment($DKUdS); goto jJfg9; jJfg9: } private static function createWechatMiniProgram($zg01X, $LUN3c, $Vhyc6) { goto T114p; xx2PP: if ($WktN9['result_code'] != 'SUCCESS') { $qc_le = $WktN9['err_code_des']; return Response::generate(-1, '创建订单失败:3:(' . $qc_le . ')'); } goto CxiBv; FrEqp: return Response::generate(0, null, $c4mjf); goto d0pHC; T114p: if (!modstart_config('payWechatOn', false)) { return Response::generate(-1, 'wechat mini program pay not enable'); } goto p5Iby; p5Iby: if (empty($Vhyc6['openId'])) { return Response::generate(-1, 'wechat mini program openId empty'); } goto DjFlo; ZT6k4: $VQq9D = $z4eue->jssdk->bridgeConfig($WktN9['prepay_id'], false); goto pHuJ3; zhyzK: if (isset($Vhyc6['limitPay'])) { switch ($Vhyc6['limitPay']) { case 'no_credit': $N20Vg['limit_pay'] = $Vhyc6['limitPay']; break; default: BizException::throws('Unknown limitPay'); break; } } goto J8muj; CxiBv: self::update($zg01X['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $LUN3c, 'timePayCreated' => Carbon::now(), 'payOrderId' => $WktN9['prepay_id'])); goto ZT6k4; JzTK5: $N20Vg = array('openid' => $Vhyc6['openId'], 'trade_type' => 'JSAPI', 'body' => StrUtil::mbLimitChars($zg01X['body'], 120), 'out_trade_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $zg01X['id'] . '_' . RandomUtil::string(3), 'total_fee' => intval(bcmul($zg01X['feeTotal'], 100, 2)), 'notify_url' => action('\\Module\\PayCenter\\Web\\Controller\\NotifyController@index', array('payType' => PayType::WECHAT_MINI_PROGRAM))); goto zhyzK; mT3c2: if (!isset($WktN9['result_code'])) { return Response::generate(-1, '订单创建失败:2'); } goto xx2PP; DjFlo: $z4eue = self::getWechatMiniProgramPayment(); goto JzTK5; J8muj: try { $WktN9 = $z4eue->order->unify($N20Vg); } catch (\Exception $zJOgU) { goto biRQ8; Snu3p: throw $zJOgU; goto JsACd; w_pil: if (Str::contains($fK95N, 'should be 32 chars length')) { BizException::throws('微信支付配置错误，请检查配置信息'); } goto Snu3p; biRQ8: $fK95N = $zJOgU->getMessage(); goto w_pil; JsACd: } goto irrrN; irrrN: if (!isset($WktN9['return_code']) || $WktN9['return_code'] != 'SUCCESS') { return Response::generate(-1, '创建订单失败:1:' . (isset($WktN9['return_msg']) ? $WktN9['return_msg'] : 'NULL')); } goto mT3c2; pHuJ3: $c4mjf = array('payJsSdkConfig' => $VQq9D, 'successRedirect' => $zg01X['redirect']); goto FrEqp; d0pHC: } public static function initAlipay() { config(array('latrell-alipay.partner_id' => config('pay.alipay.partnerId'), 'latrell-alipay.seller_id' => config('pay.alipay.sellerId'), 'latrell-alipay-web.key' => config('pay.alipay.key'), 'latrell-alipay-web.return_url' => action('\\Module\\PayCenter\\Web\\Controller\\ReturnController@index', array('payType' => PayType::ALIPAY)), 'latrell-alipay-web.notify_url' => action('\\Module\\PayCenter\\Web\\Controller\\NotifyController@index', array('payType' => PayType::ALIPAY)))); } public static function alipayWebConfig($LUN3c) { return array('use_sandbox' => false, 'app_id' => modstart_config()->getWithEnv('payAlipayWebAppId'), 'sign_type' => 'RSA2', 'ali_public_key' => modstart_config()->getWithEnv('payAlipayWebAliPublicKey'), 'rsa_private_key' => modstart_config()->getWithEnv('payAlipayWebRSAPrivateKey'), 'limit_pay' => array(), 'notify_url' => action('\\Module\\PayCenter\\Web\\Controller\\NotifyController@index', array('payType' => $LUN3c)), 'return_url' => action('\\Module\\PayCenter\\Web\\Controller\\ReturnController@index', array('payType' => $LUN3c)), 'return_raw' => true); } private static function createAlipayWeb($zg01X, $LUN3c, $Vhyc6) { goto hC56o; iH53V: return Response::generate(0, 'ok', $c4mjf); goto uA38V; ktgo2: $c4mjf = array(); goto wzKjp; pZrk0: try { $hEx10 = Charge::run(Config::ALI_CHANNEL_WEB, $DKUdS, $k8O0o); } catch (\Exception $zJOgU) { return Response::generate(-1, '创建支付错误(' . $zJOgU->getMessage() . ')'); } goto hK6_Z; wzKjp: $c4mjf['payLink'] = $hEx10; goto plgDN; plgDN: $c4mjf['successRedirect'] = $zg01X['redirect']; goto iH53V; Bl_WN: $k8O0o = array('body' => StrUtil::mbLimit(AlipayUtil::filterSpecialChars($zg01X['body']), 200), 'subject' => StrUtil::mbLimit(AlipayUtil::filterSpecialChars($zg01X['body']), 100), 'order_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $zg01X['id'], 'timeout_express' => time() + 3600 * 24, 'amount' => $zg01X['feeTotal'], 'return_param' => '', 'goods_type' => '0', 'store_id' => '', 'qr_mod' => ''); goto pZrk0; hC56o: $DKUdS = self::alipayWebConfig($LUN3c); goto Bl_WN; hK6_Z: self::update($zg01X['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $LUN3c, 'timePayCreated' => Carbon::now())); goto ktgo2; uA38V: } private static function createAlipayMobile($zg01X, $LUN3c, $Vhyc6) { goto W3xH1; qU_02: $k8O0o = array('body' => Str::limit(AlipayUtil::filterSpecialChars($zg01X['body']), 200), 'subject' => Str::limit(AlipayUtil::filterSpecialChars($zg01X['body']), 100), 'order_no' => config('pay.payOrderOutTradeNoPrefix') . '_' . $zg01X['id'], 'timeout_express' => time() + 3600 * 24, 'amount' => $zg01X['feeTotal'], 'return_param' => '', 'goods_type' => '0', 'store_id' => '', 'qr_mod' => ''); goto szCzh; M6V4d: self::update($zg01X['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $LUN3c, 'timePayCreated' => Carbon::now())); goto hgcZx; hgcZx: $c4mjf = array(); goto E3pTf; szCzh: try { $hEx10 = Charge::run(Config::ALI_CHANNEL_WAP, $DKUdS, $k8O0o); } catch (\Exception $zJOgU) { return Response::generate(-1, '创建支付错误(' . $zJOgU->getMessage() . ')'); } goto M6V4d; E3pTf: $c4mjf['payLink'] = $hEx10; goto CP4Sg; W3xH1: $DKUdS = self::alipayWebConfig($LUN3c); goto qU_02; CP4Sg: $c4mjf['successRedirect'] = $zg01X['redirect']; goto OplAO; OplAO: return Response::generate(0, 'ok', $c4mjf); goto NRkQ1; NRkQ1: } private static function createMemberMoney($zg01X, $LUN3c, $Vhyc6) { goto tiTpb; LiBAr: self::update($zg01X['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $LUN3c, 'timePayCreated' => Carbon::now())); goto Br6Mw; GhWT7: if ($KcnRT < $zg01X['feeTotal']) { return Response::generateError('余额不足'); } goto LiBAr; XdSLc: if (Response::isError($WktN9)) { return $WktN9; } goto EwYYf; EwYYf: return Response::generate(0, '支付成功', array('redirect' => $zg01X['redirect'])); goto jRRya; tiTpb: $ts4GV = $Vhyc6['memberUserId']; goto JW4rN; JW4rN: $KcnRT = MemberMoneyUtil::getTotal($ts4GV); goto GhWT7; VXNb6: $WktN9 = PayOrderUtil::handleOrderPay(PayType::MEMBER_MONEY, config('pay.payOrderOutTradeNoPrefix') . '_' . $zg01X['id']); goto XdSLc; Br6Mw: ModelUtil::transactionBegin(); goto m6uNA; m6uNA: try { MemberMoneyUtil::change($ts4GV, -$zg01X['feeTotal'], $zg01X['body']); ModelUtil::transactionCommit(); } catch (\Exception $zJOgU) { ModelUtil::transactionRollback(); return Response::generateError('支付失败，请重试'); } goto VXNb6; jRRya: } private static function createAlipay($zg01X, $LUN3c, $Vhyc6) { goto kWAJ0; qJwmG: if (!config('latrell-alipay.partner_id') || !config('latrell-alipay.seller_id') || !config('latrell-alipay-web.key')) { return Response::generate(-1, '支付宝配置错误'); } goto jhUQg; lmKco: $aBaxD->setBody(Str::limit($zg01X['body'], 100)); goto goBNz; r0D9g: $c4mjf = array(); goto KGOIS; zASiA: return Response::generate(0, 'ok', $c4mjf); goto gbHzS; kWAJ0: self::initAlipay(); goto qJwmG; LVHTE: $aBaxD->setTotalFee($zg01X['feeTotal']); goto mjTjV; Kduc2: $c4mjf['successRedirect'] = $zg01X['redirect']; goto zASiA; goBNz: self::update($zg01X['id'], array('status' => PayOrderStatus::CREATED, 'payType' => $LUN3c, 'timePayCreated' => Carbon::now())); goto r0D9g; MVWEe: $aBaxD->setOutTradeNo(config('pay.payOrderOutTradeNoPrefix') . '_' . $zg01X['id']); goto LVHTE; jhUQg: if (!empty($Vhyc6['alipay_wap'])) { $aBaxD = app('alipay.wap'); } else { $aBaxD = app('alipay.web'); } goto MVWEe; KGOIS: $c4mjf['payLink'] = $aBaxD->getPayLink(); goto Kduc2; mjTjV: $aBaxD->setSubject(Str::limit($zg01X['body'], 200)); goto lmKco; gbHzS: } public static function getOrderByOutTradeNo($zuXuN) { goto pzeDc; DXIig: $OcG1M = $ZWIDO[0]; goto dXpmP; KoR2R: return Response::generateSuccessData(array('order' => $VyxWv)); goto W0dKr; dZX_m: $VyxWv = ModelUtil::get('pay_order', array('id' => $koQno)); goto nXB43; nXB43: BizException::throwsIf('order not found', empty($VyxWv)); goto KoR2R; dXpmP: $koQno = $ZWIDO[1]; goto jodFV; jodFV: if ($OcG1M != config('pay.payOrderOutTradeNoPrefix')) { return Response::generate(-1, 'outTradeNo prefix not match'); } goto dZX_m; pzeDc: $ZWIDO = explode('_', $zuXuN); goto Q_vtx; Q_vtx: if (count($ZWIDO) != 2) { return Response::generate(-1, 'outTradeNo error'); } goto DXIig; W0dKr: } public static function handleOrderPay($rdz0v, $zuXuN, $oqNT2 = array()) { goto nW1tG; XxvVw: $VyxWv = null; goto fLsy9; hrr8F: return Response::generate(0, null, array('order' => $VyxWv)); goto P5JRQ; UTNaY: if (count($ZWIDO) != 2 && count($ZWIDO) != 3) { return Response::generate(-1, 'outTradeNo error'); } goto JHJj2; fLsy9: Log::info('PayCenter.PayOrderNotify - ' . $rdz0v . ' - ' . $zuXuN); goto EZ3Td; YjH37: ModelUtil::update('pay_order', $VyxWv['id'], array('eventNotified' => true)); goto l41XI; nW1tG: $wSDTI = false; goto XxvVw; FqOIF: $oqNT2 = array_merge(array('payType' => $rdz0v), $oqNT2); goto SdGkf; JHJj2: $OcG1M = $ZWIDO[0]; goto Uo0Ca; nMEMy: if ($OcG1M != config('pay.payOrderOutTradeNoPrefix')) { return Response::generate(-1, 'outTradeNo prefix not match'); } goto FqOIF; Uo0Ca: $koQno = $ZWIDO[1]; goto nMEMy; pxYUR: if ($wSDTI) { goto mOU0R; mOU0R: $r42ZK = new OrderPayedEvent(); goto uZaqM; DyKY_: EventUtil::fire($r42ZK); goto IAFCl; IAFCl: Log::info('PayCenter.HandleOrderPay.OrderPayedEvent - ' . json_encode($r42ZK, JSON_UNESCAPED_UNICODE)); goto jGE7d; akc10: $r42ZK->order = $VyxWv; goto DyKY_; uZaqM: $r42ZK->biz = $VyxWv['biz']; goto Gs8Tn; Gs8Tn: $r42ZK->bizId = $VyxWv['bizId']; goto akc10; jGE7d: } goto YjH37; l41XI: ModelUtil::decodeRecordJson($VyxWv, 'param'); goto hrr8F; EZ3Td: $ZWIDO = explode('_', $zuXuN); goto UTNaY; SdGkf: try { goto kQM6f; Zggoo: if (empty($VyxWv)) { ModelUtil::transactionCommit(); return Response::generate(-1, 'order not found'); } goto yXOQA; kQM6f: ModelUtil::transactionBegin(); goto bOuOQ; fr_9Q: ModelUtil::transactionCommit(); goto gerlo; bOuOQ: $VyxWv = ModelUtil::getWithLock('pay_order', array('id' => $koQno)); goto Zggoo; yXOQA: if ($VyxWv['status'] == PayOrderStatus::CREATED) { goto ZhDQV; ogfbr: ModelUtil::update('pay_order', array('id' => $VyxWv['id']), array_merge(array('status' => PayOrderStatus::PAYED, 'timePay' => Carbon::now()), $oqNT2)); goto QNNQA; QNNQA: $wSDTI = true; goto nXkVg; ZhDQV: Log::info('PayCenter.HandleOrderPay.UpdateOrderToPayed - ' . $zuXuN); goto ogfbr; nXkVg: } else { Log::info('PayCenter.HandleOrderPay.Status - ' . $VyxWv['status']); if (!empty($oqNT2)) { ModelUtil::update('pay_order', array('id' => $VyxWv['id']), $oqNT2); } } goto fr_9Q; gerlo: } catch (\Exception $zJOgU) { Log::error('PayCenter.HandleOrderPay.Error - ' . $zJOgU->getMessage()); ModelUtil::transactionRollback(); } goto pxYUR; P5JRQ: } }