<?php
namespace Payment\Common\Ali\Data\Charge; use Payment\Common\Ali\Data\AliBaseData; use Payment\Common\PayException; use Payment\Config; use Payment\Utils\ArrayUtil; abstract class ChargeBaseData extends AliBaseData { protected function checkDataParam() { $subject = $this->subject; $orderNo = $this->order_no; $amount = $this->amount; $goodsType = $this->goods_type; $passBack = $this->return_param; if (empty($subject)) { throw new PayException('必须提供 商品的标题/交易标题/订单标题/订单关键字 等'); } if (empty($orderNo) || mb_strlen($orderNo) > 64) { throw new PayException('订单号不能为空，并且长度不能超过64位'); } if (bccomp($amount, Config::PAY_MIN_FEE, 2) === -1) { throw new PayException('支付金额不能低于 ' . Config::PAY_MIN_FEE . ' 元'); } if (is_null($goodsType)) { $this->goods_type = 1; } elseif (! in_array($goodsType, [0 ,1])) { throw new PayException('商品类型可取值为：0-虚拟类商品  1-实物类商品'); } if (! empty($passBack) && ! is_string($passBack)) { throw new PayException('回传参数必须是字符串'); } if (!empty($passBack)) { $this->return_param = urlencode($passBack); } } } 