<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Util; use Carbon\Carbon; use Illuminate\Support\Facades\Cache; use Illuminate\Support\Str; use Intervention\Image\Facades\Image; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\AgentUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\EncodeUtil; use ModStart\Core\Util\FormatUtil; use ModStart\Core\Util\LockUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\StrUtil; use ModStart\Data\DataManager; use ModStart\Data\Event\DataFileUploadedEvent; use Module\Member\Events\MemberUserLoginAttemptEvent; use Module\Member\Events\MemberUserLoginFailedEvent; use Module\Member\Type\MemberMessageStatus; use Module\Member\Type\MemberStatus; use Module\Vendor\Type\DeviceType; class MemberUtil { public static function total() { return Cache::remember('MemberUserTotal', 60, function () { return ModelUtil::count('member_user'); }); } public static function get($k_QCu) { return ModelUtil::get('member_user', array('id' => $k_QCu)); } public static function getCached($k_QCu) { return Cache::remember('MemberUser:' . $k_QCu, 60, function () use($k_QCu) { return self::get($k_QCu); }); } public static function processDefault(&$kqakb) { goto amz9r; EwHdE: if (empty($kqakb['avatar'])) { $kqakb['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto Tpep7; Tpep7: if (empty($kqakb['avatarMedium'])) { $kqakb['avatarMedium'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto jWx_J; jWx_J: if (empty($kqakb['avatarBig'])) { $kqakb['avatarBig'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto xMXE0; amz9r: if (empty($kqakb)) { return; } goto JMnUP; JMnUP: if (empty($kqakb['nickname'])) { $kqakb['nickname'] = $kqakb['username']; } goto EwHdE; xMXE0: } private static function processBasicFields($ugbti) { goto jw9zP; zlYRs: if (null === $ugbti) { $ugbti = $Min1i; } else { goto u6k_B; FgUYx: $ugbti = $zHbFL; goto qPzKW; u6k_B: $zHbFL = array(); goto t8du3; t8du3: foreach ($ugbti as $iM64L) { if ('<basic>' == $iM64L) { $zHbFL = array_merge($zHbFL, $Min1i); } else { $zHbFL[] = $iM64L; } } goto FgUYx; qPzKW: } goto vVMUk; vVMUk: return $ugbti; goto LBm1D; jw9zP: $Min1i = array('id', 'username', 'avatar', 'created_at', 'signature', 'nickname'); goto zlYRs; LBm1D: } public static function fixAvatar($A8mKq) { return AssetsUtil::fixFullOrDefault($A8mKq, 'asset/image/avatar.svg'); } public static function getBasic($k_QCu, $ugbti = null) { goto Y2hGC; lyT34: $p9RU6 = self::get($k_QCu); goto Hw3cK; A64ny: if (empty($p9RU6['nickname'])) { $p9RU6['nickname'] = $p9RU6['username']; } goto bgYCM; bgYCM: $p9RU6['avatar'] = self::fixAvatar($p9RU6['avatar']); goto CbhJw; CbhJw: $EknUP = array(); goto D5gtl; Y2hGC: $ugbti = self::processBasicFields($ugbti); goto lyT34; D5gtl: foreach ($ugbti as $iWH6z) { if (isset($p9RU6[$iWH6z])) { $EknUP[$iWH6z] = $p9RU6[$iWH6z]; } else { $EknUP[$iWH6z] = null; } } goto u8W2t; Hw3cK: if (empty($p9RU6)) { return null; } goto A64ny; u8W2t: return $EknUP; goto E4uFD; E4uFD: } public static function listViewName($qK10O) { goto xgH2A; Iimgm: $VATHy = ModelUtil::allIn('member_user', 'id', $qK10O); goto MzjCt; r7jod: return $yb4sC; goto iNsKF; xgH2A: $yb4sC = array(); goto Iimgm; MzjCt: foreach ($VATHy as $kqakb) { $yb4sC[] = self::viewName($kqakb); } goto r7jod; iNsKF: } public static function listUsers($qK10O) { return ModelUtil::allIn('member_user', 'id', $qK10O); } public static function convertOneToBasic($kqakb) { return array('id' => $kqakb['id'], 'username' => $kqakb['username'], 'nickname' => empty($kqakb['nickname']) ? $kqakb['username'] : $kqakb['nickname'], 'created_at' => $kqakb['created_at'], 'signature' => isset($kqakb['signature']) ? $kqakb['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($kqakb['avatar'], 'asset/image/avatar.svg')); } public static function convertToBasic($VATHy) { return array_map(function ($p9RU6) { return array('id' => $p9RU6['id'], 'username' => $p9RU6['username'], 'nickname' => empty($p9RU6['nickname']) ? $p9RU6['username'] : $p9RU6['nickname'], 'created_at' => $p9RU6['created_at'], 'signature' => isset($p9RU6['signature']) ? $p9RU6['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($p9RU6['avatar'], 'asset/image/avatar.svg')); }, $VATHy); } public static function listUsersBasic($qK10O) { return self::convertToBasic(self::listUsers($qK10O)); } public static function getViewName($k_QCu) { return self::viewName(self::get($k_QCu)); } public static function viewName($kqakb) { goto yu0AT; TVeo0: if (!empty($kqakb['username'])) { return $kqakb['username']; } goto IMQDn; lgKs_: if (!empty($kqakb['nickname'])) { return $kqakb['nickname']; } goto TVeo0; yu0AT: if ($kqakb && is_numeric($kqakb)) { return self::getViewName($kqakb); } goto aU_ls; aU_ls: if (empty($kqakb)) { return '-'; } goto lgKs_; IMQDn: return "ID-{$kqakb['id']}"; goto Dbd8b; Dbd8b: } public static function update($k_QCu, $c4mjf) { return ModelUtil::update('member_user', array('id' => $k_QCu), $c4mjf); } public static function updateBasicWithUniqueCheck($k_QCu, $c4mjf) { goto uePEX; ole1g: self::update($k_QCu, $c4mjf); goto Z9hOb; Z9hOb: return Response::generate(0, 'ok'); goto fozZ7; OI_nJ: foreach (array('username' => '用户名', 'phone' => '手机', 'email' => '邮箱') as $IZW3h => $V2oei) { if (isset($c4mjf[$IZW3h])) { goto WGUP0; SFTuB: if (count($D8U2O) > 1) { return Response::generate(-1, $V2oei . '重复'); } goto DAWxN; WGUP0: if (empty($c4mjf[$IZW3h])) { $c4mjf[$IZW3h] = null; continue; } goto uml84; uml84: $D8U2O = ModelUtil::all('member_user', array($IZW3h => $c4mjf[$IZW3h])); goto SFTuB; DAWxN: if (count($D8U2O) == 1) { if ($D8U2O[0]['id'] != $k_QCu) { return Response::generate(-1, $V2oei . '重复'); } } goto v22G7; v22G7: } } goto ole1g; uePEX: if (empty($c4mjf)) { return Response::generate(0, 'ok'); } goto OI_nJ; fozZ7: } public static function login($bsOV5 = '', $ToL73 = '', $k43Qq = '', $iOeS_ = '') { goto txNi9; WZZSy: $bsOV5 = trim($bsOV5); goto l2osq; l2osq: if (!($k43Qq || $ToL73 || $bsOV5)) { return Response::generate(-1, '所有登录字段均为空'); } goto uK_Av; txNi9: $k43Qq = trim($k43Qq); goto n0Umh; PhWB_: if ($k43Qq) { if (!FormatUtil::isEmail($k43Qq)) { return Response::generate(-3, '邮箱格式不正确'); } $pBfQU = array('email' => $k43Qq); } else { if ($ToL73) { if (!preg_match('/(^1[0-9]{10}$)/', $ToL73)) { return Response::generate(-4, '手机格式不正确'); } $pBfQU = array('phone' => $ToL73); } else { if ($bsOV5) { if (strpos($bsOV5, '@') !== false) { return Response::generate(-5, '用户名格式不正确'); } $pBfQU = array('username' => $bsOV5); } } } goto d0UGQ; d0UGQ: $kqakb = ModelUtil::get('member_user', $pBfQU); goto wCEDz; wCEDz: if (empty($kqakb)) { return Response::generate(-6, '登录失败:用户名或密码错误'); } goto czcfY; nmsz3: return Response::generateSuccessData($kqakb); goto kFYO9; zY_BJ: if ($kqakb['password'] != EncodeUtil::md5WithSalt($iOeS_, $kqakb['passwordSalt'])) { MemberUserLoginFailedEvent::fire($kqakb['id'], $kqakb['username'], Request::ip(), AgentUtil::getUserAgent()); return Response::generate(-7, '登录失败:用户名或密码错误'); } goto Lf63X; n0Umh: $ToL73 = trim($ToL73); goto WZZSy; czcfY: MemberUserLoginAttemptEvent::fire($kqakb['id'], Request::ip(), AgentUtil::getUserAgent()); goto zY_BJ; uK_Av: if (!$iOeS_) { return Response::generate(-2, '密码为空'); } goto PhWB_; Lf63X: switch ($kqakb['status']) { case MemberStatus::FORBIDDEN: return Response::generateError(-8, '登录失败:当前用户已被禁用'); } goto nmsz3; kFYO9: } public static function autoSetUsernameNickname($ts4GV, $t6OKX) { goto Bukl0; eEAPn: if (preg_match('/\\{.*\\}/', $t6OKX)) { goto RSPtt; TxJbq: $t6OKX = str_replace(array_keys($Ep9Gp), array_values($Ep9Gp), $t6OKX); goto nu4jr; nu4jr: $CQTSr = 0; goto BQNWl; yN2Mu: $Ep9Gp = array('{Phone}' => $kqakb['phone'], '{Phone4}' => substr($kqakb['phone'], 7), '{Uid}' => $kqakb['id']); goto TxJbq; RSPtt: $kqakb = self::get($ts4GV); goto yN2Mu; BQNWl: } goto UsDqY; Bukl0: $CQTSr = 6; goto eEAPn; UsDqY: self::suggestUsernameNickname($ts4GV, $t6OKX, $CQTSr); goto d0Dzc; d0Dzc: } public static function getSuggestUsernameNickname($jUpUh) { goto Bc_8J; iAbZI: return $t6OKX . Str::random(10); goto yYUh2; M0C1P: for ($fSOK5 = 0; $fSOK5 < 20; $fSOK5++) { $Y25ZE = ModelUtil::model('member_user')->where(array('username' => $t6OKX))->orWhere(array('nickname' => $t6OKX))->first(); if (empty($Y25ZE)) { return $t6OKX; } $t6OKX = $t6OKX . Str::random(1); } goto iAbZI; Bc_8J: $t6OKX = $jUpUh . Str::random(1); goto M0C1P; yYUh2: } private static function suggestUsernameNickname($ts4GV, $Y3Vaz = '用户', $CQTSr = 6) { goto TJW0x; TJW0x: if ($CQTSr > 0) { $t6OKX = $Y3Vaz . RandomUtil::string($CQTSr); } else { $t6OKX = $Y3Vaz; } goto AlHJ4; AlHJ4: for ($fSOK5 = 0; $fSOK5 < 20; $fSOK5++) { $Y25ZE = ModelUtil::model('member_user')->where(array('username' => $t6OKX))->orWhere(array('nickname' => $t6OKX))->first(); if (empty($Y25ZE)) { break; } $t6OKX = $t6OKX . Str::random(1); } goto yTvuI; yTvuI: ModelUtil::update('member_user', $ts4GV, array('username' => $t6OKX, 'nickname' => $t6OKX)); goto D8GAo; D8GAo: } public static function registerId($k_QCu, $c4mjf = array()) { $kqakb = ModelUtil::insert('member_user', array_merge(array('id' => $k_QCu, 'status' => MemberStatus::NORMAL, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false), $c4mjf)); return Response::generate(0, 'ok', $kqakb); } public static function registerUsername($bsOV5) { return self::register($bsOV5, '', '', '', true); } public static function registerUsernameQuick($bsOV5) { goto Gi9mw; dAuzr: for ($fSOK5 = 0; $fSOK5 < 10; $fSOK5++) { $WktN9 = self::register($nbE1m, '', '', '', true); if ($WktN9['code']) { $nbE1m = $nbE1m . Str::random(1); } else { return $WktN9; } } goto OYYif; Gi9mw: $nbE1m = $bsOV5; goto dAuzr; OYYif: return Response::generateError('注册失败'); goto qz8cF; qz8cF: } public static function register($bsOV5 = '', $ToL73 = '', $k43Qq = '', $iOeS_ = '', $K9dw3 = false) { goto KDfim; ZLHB0: if (!($k43Qq || $ToL73 || $bsOV5)) { return Response::generate(-1, '所有注册字段均为空'); } goto rnP36; rnP36: if ($k43Qq) { $WktN9 = self::uniqueCheck('email', $k43Qq); if ($WktN9['code']) { return $WktN9; } } else { $k43Qq = null; } goto KjR1J; KWOpH: $XJqYn = Str::random(16); goto bR3jO; PfZkH: return Response::generate(0, 'ok', $kqakb); goto DuiAf; HPnHk: $ToL73 = trim($ToL73); goto p9d4W; p9d4W: $bsOV5 = trim($bsOV5); goto ZLHB0; KjR1J: if ($ToL73) { $WktN9 = self::uniqueCheck('phone', $ToL73); if ($WktN9['code']) { return $WktN9; } } else { $ToL73 = null; } goto xiLhJ; KDfim: $k43Qq = trim($k43Qq); goto HPnHk; xiLhJ: if ($bsOV5) { goto vUNN1; cV2i9: if (preg_match('/^[0-9]{11}$/', $bsOV5)) { return Response::generate(-1, '用户名不能为纯数字'); } goto vlNlq; C1Vry: if (strlen($bsOV5) < modstart_config('Member_UsernameMinLength', 3)) { return Response::generate(-1, '用户名至少3个字符'); } goto JPp_A; JPp_A: if (Str::contains($bsOV5, '@')) { return Response::generate(-1, '用户名不能包含特殊字符'); } goto cV2i9; TZdSq: if ($WktN9['code']) { return $WktN9; } goto C1Vry; vUNN1: $WktN9 = self::uniqueCheck('username', $bsOV5); goto TZdSq; vlNlq: } else { $bsOV5 = null; } goto iv3ts; bR3jO: $kqakb = ModelUtil::insert('member_user', array('status' => MemberStatus::NORMAL, 'username' => $bsOV5, 'email' => $k43Qq, 'phone' => $ToL73, 'password' => $K9dw3 ? null : EncodeUtil::md5WithSalt($iOeS_, $XJqYn), 'passwordSalt' => $K9dw3 ? null : $XJqYn, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false)); goto PfZkH; iv3ts: if (!$K9dw3) { if (empty($iOeS_) || strlen($iOeS_) < 6) { return Response::generate(-3, '密码不合法'); } } goto KWOpH; DuiAf: } public static function uniqueCheck($rdz0v, $bJpVF, $VeDqs = 0) { goto L396W; Bcu3T: return Response::generate(-2, $GH77C[$rdz0v] . '已经被占用'); goto LZByl; BFt0o: if (empty($kqakb)) { return Response::generate(0, 'ok'); } goto W34dv; fe_TH: $kqakb = ModelUtil::get('member_user', array($rdz0v => $bJpVF)); goto BFt0o; L396W: $bJpVF = trim($bJpVF); goto G6ydU; W34dv: $GH77C = array('username' => '用户名', 'email' => '邮箱', 'phone' => '手机号'); goto Qoddb; G6ydU: switch ($rdz0v) { case 'email': if (!FormatUtil::isEmail($bJpVF)) { return Response::generate(-1, '邮箱格式不正确'); } break; case 'phone': if (!preg_match('/(^1[0-9]{10}$)/', $bJpVF)) { return Response::generate(-1, '手机格式不正确'); } break; case 'username': if (strpos($bJpVF, '@') !== false) { return Response::generate(-1, '用户名格式不正确'); } break; case 'nickname': break; default: return Response::generate(-1, '未能识别的类型' . $rdz0v); } goto fe_TH; Qoddb: if ($VeDqs == $kqakb['id']) { return Response::generate(0, 'ok'); } goto Bcu3T; LZByl: } public static function getByUsername($bsOV5) { return ModelUtil::get('member_user', array('username' => $bsOV5)); } public static function getByEmail($k43Qq) { return ModelUtil::get('member_user', array('email' => $k43Qq)); } public static function getByPhone($ToL73) { return ModelUtil::get('member_user', array('phone' => $ToL73)); } public static function changeNickname($ts4GV, $VqcnU) { goto nNyM4; cB5OY: if (Response::isError($WktN9)) { return $WktN9; } goto M6N48; M6N48: ModelUtil::update('member_user', $ts4GV, array('nickname' => $VqcnU)); goto kInz5; nNyM4: $WktN9 = self::uniqueCheck('nickname', $VqcnU, $ts4GV); goto cB5OY; kInz5: return Response::generate(0, 'ok'); goto kDOTq; kDOTq: } public static function changePassword($ts4GV, $EbmqM, $K8CCi = null, $lFqGG = false) { goto AyFfn; FS6Xj: $XJqYn = Str::random(16); goto yPMjY; M487O: $kqakb = ModelUtil::get('member_user', array('id' => $ts4GV)); goto qwclZ; yPMjY: ModelUtil::update('member_user', array('id' => $kqakb['id']), array('passwordSalt' => $XJqYn, 'password' => EncodeUtil::md5WithSalt($EbmqM, $XJqYn))); goto XMCuv; XMCuv: return Response::generate(0, 'ok'); goto i13Kh; EJBjG: if (!$lFqGG && EncodeUtil::md5WithSalt($K8CCi, $kqakb['passwordSalt']) != $kqakb['password']) { return Response::generate(-1, '旧密码不正确'); } goto FS6Xj; AyFfn: if (!$lFqGG && empty($K8CCi)) { return Response::generate(-1, '旧密码不能为空'); } goto M487O; QBDWv: if (empty($EbmqM)) { return Response::generate(-1, '新密码为空'); } goto EJBjG; qwclZ: if (empty($kqakb)) { return Response::generate(-1, '用户不存在'); } goto QBDWv; i13Kh: } public static function setAvatar($u20wt, $IZZD2, $iTiBS = 'jpg') { goto qY6an; jvX7z: if ($s3ktD['code']) { DataManager::deleteById($v5UuX['data']['id']); if ($v5UuX['code']) { return Response::generate(-1, '头像存储失败（' . $s3ktD['msg'] . '）'); } } goto n4EGv; sOkZX: $CPrxs = (string) Image::make($IZZD2)->resize(400, 400)->encode($iTiBS, 75); goto j9_30; F7u_I: if (empty($IZZD2)) { return Response::generate(-1, '图片数据为空'); } goto sOkZX; Mt5Ex: $kqakb = self::get($u20wt); goto CwgtK; B55le: $q8QQJ = (string) Image::make($IZZD2)->resize(50, 50)->encode($iTiBS, 75); goto TBzjQ; DdpIe: $s3ktD = DataManager::upload('image', 'U' . $u20wt . '_AvatarMiddle.' . $iTiBS, $cyygS, null, $ZCS7f); goto jvX7z; aP4ql: return Response::generateSuccess(); goto yh9rq; KppUj: if ($WktN9['code']) { goto vYnYC; vYnYC: DataManager::deleteById($v5UuX['data']['id']); goto OJ1FV; OJ1FV: DataManager::deleteById($s3ktD['data']['id']); goto GOtZl; GOtZl: if ($v5UuX['code']) { return Response::generate(-1, '头像存储失败（' . $WktN9['msg'] . '）'); } goto MQAe8; MQAe8: } goto SlATE; SlATE: self::update($kqakb['id'], array('avatarBig' => $v5UuX['data']['fullPath'], 'avatarMedium' => $s3ktD['data']['fullPath'], 'avatar' => $WktN9['data']['fullPath'])); goto aP4ql; S1aNk: $v5UuX = DataManager::upload('image', 'U' . $u20wt . '_AvatarBig.' . $iTiBS, $CPrxs, null, $ZCS7f); goto HTnID; TBzjQ: $ZCS7f = array('eventOpt' => array(DataFileUploadedEvent::OPT_IMAGE_COMPRESS_IGNORE => true, DataFileUploadedEvent::OPT_IMAGE_WATERMARK_IGNORE => true)); goto S1aNk; qY6an: if (!in_array($iTiBS, array('jpg', 'jpeg', 'png', 'gif'))) { return Response::generate(-1, '图片格式不正确'); } goto Mt5Ex; j9_30: $cyygS = (string) Image::make($IZZD2)->resize(200, 200)->encode($iTiBS, 75); goto B55le; n4EGv: $WktN9 = DataManager::upload('image', 'U_' . $u20wt . '_Avatar.' . $iTiBS, $q8QQJ, null, $ZCS7f); goto KppUj; CwgtK: if (empty($kqakb)) { return Response::generate(-1, '用户不存在'); } goto F7u_I; HTnID: if ($v5UuX['code']) { return Response::generate(-1, '头像存储失败（' . $v5UuX['msg'] . '）'); } goto DdpIe; yh9rq: } public static function findUsers($zWy3j) { goto lpc8y; lpc8y: if (empty($zWy3j)) { return array(); } goto GkLJ1; mauu_: $VATHy = ModelUtil::model('member_user')->whereIn('id', $zWy3j)->get(); goto Jyv7l; GkLJ1: $PJ_QT = array(); goto mauu_; KzenC: return $PJ_QT; goto bFsyy; Jyv7l: foreach ($VATHy as &$ldswL) { $PJ_QT[$ldswL->id] = $ldswL->toArray(); } goto KzenC; bFsyy: } public static function filterUserIds($zWy3j) { goto mxG1l; Tnm7Z: $Ep9Gp = array(); goto iMUcw; iMUcw: $VATHy = ModelUtil::model('member_user')->whereIn('id', $zWy3j)->get(array('id')); goto wGy13; m5Qpx: return array_keys($Ep9Gp); goto fwC0c; mxG1l: if (empty($zWy3j)) { return array(); } goto Tnm7Z; wGy13: foreach ($VATHy as &$ldswL) { $Ep9Gp[$ldswL->id] = true; } goto m5Qpx; fwC0c: } public static function mergeMemberUsers(&$loa94, $oJlVa = 'memberUserId', $JQ103 = '_memberUser') { ModelUtil::join($loa94, $oJlVa, $JQ103, 'member_user', 'id'); } public static function mergeMemberUserBasics(&$loa94, $oJlVa = 'memberUserId', $JQ103 = '_memberUser', $ugbti = null) { $ugbti = self::processBasicFields($ugbti); if (is_array($loa94)) { ModelUtil::join($loa94, $oJlVa, $JQ103, 'member_user', 'id'); foreach ($loa94 as $iM64L => $J9jpR) { goto av4L6; av4L6: if (empty($J9jpR[$JQ103])) { continue; } goto Md6w9; ERXpE: $loa94[$iM64L][$JQ103] = $kqakb; goto key8B; hvwNP: if (empty($kqakb['avatar'])) { $kqakb['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $kqakb['avatar'] = AssetsUtil::fixFull($kqakb['avatar']); } goto ERXpE; Md6w9: $kqakb = ArrayUtil::keepKeys($J9jpR[$JQ103], $ugbti); goto w4cCg; w4cCg: if (empty($kqakb['nickname'])) { $kqakb['nickname'] = $kqakb['username']; } goto hvwNP; key8B: } } else { ModelUtil::joinItems($loa94, $oJlVa, $JQ103, 'member_user', 'id'); foreach ($loa94 as $p9RU6) { goto C2m_t; MX8er: if (empty($kqakb['nickname'])) { $kqakb['nickname'] = $kqakb['username']; } goto dmo8g; C2m_t: if (empty($p9RU6->{$JQ103})) { continue; } goto l7kzK; dmo8g: if (empty($kqakb['avatar'])) { $kqakb['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $kqakb['avatar'] = AssetsUtil::fixFull($kqakb['avatar']); } goto SG902; l7kzK: $kqakb = ArrayUtil::keepKeys($p9RU6->{$JQ103}, $ugbti); goto MX8er; SG902: $p9RU6->{$JQ103} = $kqakb; goto Gfgvi; Gfgvi: } } } public static function insert($c4mjf) { return ModelUtil::insert('member_user', $c4mjf); } public static function getIdByOauth($Sy0rV, $a2b1n) { goto Lw5DT; oiw1e: if (empty($o_uJu)) { return 0; } goto nAaym; nAaym: return intval($o_uJu['memberUserId']); goto Fvncm; Lw5DT: $o_uJu = ModelUtil::get('member_oauth', array('type' => $Sy0rV, 'openId' => $a2b1n)); goto oiw1e; Fvncm: } public static function getIdByOauthAndCheck($Sy0rV, $a2b1n) { goto V2VFS; BYY4y: MemberUtil::forgetOauth($Sy0rV, $a2b1n); goto zzvxF; V2VFS: $ts4GV = self::getIdByOauth($Sy0rV, $a2b1n); goto HXD9W; zzvxF: return 0; goto FfwbN; HXD9W: if (self::get($ts4GV)) { return $ts4GV; } goto BYY4y; FfwbN: } public static function getOauthOpenId($ts4GV, $Sy0rV) { goto X03Jo; AiTpO: return $o_uJu['openId']; goto rHh7T; MdIBP: if (empty($o_uJu)) { return null; } goto AiTpO; X03Jo: $pBfQU = array('memberUserId' => $ts4GV, 'type' => $Sy0rV); goto H8O0n; H8O0n: $o_uJu = ModelUtil::get('member_oauth', $pBfQU); goto MdIBP; rHh7T: } public static function getOauth($ts4GV, $Sy0rV) { $pBfQU = array('memberUserId' => $ts4GV, 'type' => $Sy0rV); return ModelUtil::get('member_oauth', $pBfQU); } public static function listOauths($ts4GV) { return ModelUtil::all('member_oauth', array('memberUserId' => $ts4GV), array('*'), array('type', 'asc')); } public static function putOauth($ts4GV, $Sy0rV, $a2b1n, $aEh2K = array()) { goto pcNuJ; LrGBV: LockUtil::release($F2BZv); goto aVlig; pcNuJ: $pBfQU = array('memberUserId' => $ts4GV, 'type' => $Sy0rV); goto AZ6lH; AZ6lH: $F2BZv = "MemberOauth:{$ts4GV}"; goto Zzbdy; Zzbdy: if (!LockUtil::acquire($F2BZv)) { BizException::throws('正在处理中，请稍后再试'); } goto Zw8cy; zBXN9: $pmhtR = array_merge(array('openId' => $a2b1n), $aEh2K); goto oYZYw; oYZYw: if (empty($o_uJu)) { ModelUtil::delete('member_oauth', array('type' => $Sy0rV, 'openId' => $a2b1n)); ModelUtil::insert('member_oauth', array_merge($pBfQU, $pmhtR)); } else { if ($o_uJu['openId'] != $a2b1n) { ModelUtil::update('member_oauth', $o_uJu['id'], $pmhtR); } } goto LrGBV; Zw8cy: $o_uJu = ModelUtil::get('member_oauth', $pBfQU); goto zBXN9; aVlig: } public static function forgetOauth($Sy0rV, $a2b1n) { ModelUtil::delete('member_oauth', array('type' => $Sy0rV, 'openId' => $a2b1n)); } public static function updateNewMessageStatus($ts4GV) { ModelUtil::update('member_user', array('id' => $ts4GV), array('newMessageCount' => ModelUtil::count('member_message', array('userId' => $ts4GV, 'status' => MemberMessageStatus::UNREAD)))); } public static function updateNewChatMsgStatus($ts4GV) { if (modstart_module_enabled('MemberChat')) { ModelUtil::update('member_user', array('id' => $ts4GV), array('newChatMsgCount' => ModelUtil::sum('member_chat', 'unreadMsgCount', array('memberUserId' => $ts4GV)))); } } public static function paginate($UWW9I, $HvpTs, $Vhyc6 = array()) { return ModelUtil::paginate('member_user', $UWW9I, $HvpTs, $Vhyc6); } public static function updateStatus($obxyh, $npnKq) { goto NkGfF; ubKCq: if (empty($obxyh)) { return; } goto bUiHe; bUiHe: ModelUtil::model('member_user')->whereIn('id', $obxyh)->update(array('status' => $npnKq)); goto GQz4O; NkGfF: if (!is_array($obxyh)) { $obxyh = array($obxyh); } goto ubKCq; GQz4O: } public static function delete($ts4GV) { goto SlQQG; pfK22: $bn9YE = array(); goto nfqc9; nfqc9: $bQSQ7 = ModelUtil::all('member_oauth', array('memberUserId' => $kqakb['id'])); goto upFng; bqFxs: ModelUtil::insert('member_deleted', array('id' => $kqakb['id'], 'username' => $kqakb['username'], 'phone' => $kqakb['phone'], 'email' => $kqakb['email'], 'content' => json_encode($bn9YE, JSON_UNESCAPED_UNICODE))); goto mwZ1h; upFng: $bn9YE['oauth'] = ArrayUtil::keepItemsKeys($bQSQ7, array('type', 'openId', 'infoUsername', 'infoAvatar')); goto bqFxs; M2mnS: ModelUtil::transactionBegin(); goto pfK22; SlQQG: $kqakb = self::get($ts4GV); goto HHHN6; HHHN6: BizException::throwsIfEmpty('用户不存在', $kqakb); goto M2mnS; mwZ1h: ModelUtil::update('member_user', $ts4GV, array('deleteAtTime' => 0, 'isDeleted' => true, 'username' => null, 'phone' => null, 'email' => null)); goto oiJYN; oiJYN: ModelUtil::transactionCommit(); goto nQOFv; nQOFv: } public static function fireLogin($ts4GV) { goto W2cU3; S5Q0M: ModelUtil::update('member_user', $ts4GV, array('lastLoginTime' => Carbon::now(), 'lastLoginIp' => StrUtil::mbLimit($XOXXS, 20))); goto i7h88; W2cU3: $XOXXS = Request::ip(); goto S5Q0M; i7h88: ModelUtil::insert('member_login_log', array('memberUserId' => $ts4GV, 'deviceType' => DeviceType::current(), 'ip' => StrUtil::mbLimit($XOXXS, 20), 'userAgent' => StrUtil::mbLimit(AgentUtil::getUserAgent(), 400))); goto l95E1; l95E1: } }