<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminConfigBuilder; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Admin\Layout\AdminDialogPage; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Type\TypeUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\ColorUtil; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\TimeUtil; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Field\Select; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Form; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\GridFilter; use ModStart\Module\ModuleManager; use ModStart\Repository\Filter\RepositoryFilter; use ModStart\Support\Concern\HasFields; use ModStart\Widget\TextDialogRequest; use Module\Member\Config\MemberAdminList; use Module\Member\Config\MemberOauth; use Module\Member\Events\MemberUserRegisteredEvent; use Module\Member\Provider\MemberAdminShowPanel\MemberAdminShowPanelProvider; use Module\Member\Type\Gender; use Module\Member\Type\MemberStatus; use Module\Member\Util\MemberGroupUtil; use Module\Member\Util\MemberMessageUtil; use Module\Member\Util\MemberUtil; use Module\Member\Util\MemberVipUtil; use Module\Vendor\QuickRun\Export\ExportHandle; class MemberController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $hDbiq) { $hDbiq->init('member_user')->field(function ($hDbiq) { $hDbiq->id('id', 'ID'); MemberAdminList::callGridField($hDbiq); $hDbiq->display('avatar', '头像')->hookRendering(function (AbstractField $IZW3h, $p9RU6, $qwzoR) { $H9CX8 = AssetsUtil::fixOrDefault($p9RU6->avatar, 'asset/image/avatar.svg'); $nuiHQ = AssetsUtil::fixOrDefault($p9RU6->avatarBig, 'asset/image/avatar.svg'); return AutoRenderedFieldValue::make("<a href='{$nuiHQ}' class='tw-inline-block' data-image-preview>\n                        <img src='{$H9CX8}' class='tw-rounded-full tw-w-8 tw-h-8 tw-shadow'></a>"); }); $hDbiq->text('username', '用户名')->required()->ruleUnique('member_user')->hookRendering(function (AbstractField $IZW3h, $p9RU6, $qwzoR) { switch ($IZW3h->renderMode()) { case FieldRenderMode::GRID: case FieldRenderMode::DETAIL: return AutoRenderedFieldValue::make(TextDialogRequest::make('primary', htmlspecialchars($p9RU6->username), modstart_admin_url('member/show', array('_id' => $p9RU6->id)))->width('90%')->height('90%')->render()); break; } }); $hDbiq->text('email', '邮箱'); $hDbiq->text('phone', '手机'); $hDbiq->text('nickname', '昵称'); if (MemberOauth::hasEnableItems()) { $hDbiq->display('_oauth', '授权')->hookRendering(function (AbstractField $IZW3h, $p9RU6, $qwzoR) { $wM3KU = array(); $GlOls = MemberUtil::listOauths($p9RU6->id); foreach ($GlOls as $oB9Fd) { goto AC8Mp; juxVj: if (empty($ujXc6)) { $ujXc6 = ColorUtil::pick($oB9Fd['type']); } goto gsAqa; gsAqa: $wM3KU[] = '<a style="color:' . $ujXc6 . ';" href="javascript:;" data-tip-popover="' . $LbkXD . '"><i class="iconfont icon-dot"></i></a>'; goto a1g6F; EEGOE: if ($AriQX) { $ujXc6 = $AriQX->color(); $LbkXD = $AriQX->title(); } goto juxVj; zC6uo: $LbkXD = $oB9Fd['type']; goto nGUJg; nGUJg: $AriQX = MemberOauth::getByOauthKey($oB9Fd['type']); goto EEGOE; AC8Mp: $ujXc6 = null; goto zC6uo; a1g6F: } return join('', $wM3KU); }); } $hDbiq->type('status', '状态')->type(MemberStatus::class, array(MemberStatus::NORMAL => 'success', MemberStatus::FORBIDDEN => 'danger'))->required(); $JT8WU = ModuleManager::getModuleConfig('Member', 'groupEnable', false); if ($JT8WU) { $hDbiq->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } $J1b11 = ModuleManager::getModuleConfig('Member', 'vipEnable', false); if ($J1b11) { $hDbiq->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $hDbiq->date('vipExpire', 'VIP过期'); } $hDbiq->display('registerIp', '注册IP'); $hDbiq->display('created_at', '注册时间'); $hDbiq->canBatchSelect(true); $hDbiq->batchOperatePrepend('<button class="btn" data-batch-confirm="确认禁用 %d 个用户？" data-batch-operate="' . modstart_admin_url('member/status_forbidden') . '"><i class="iconfont icon-warning"></i> 禁用</button>'); })->repositoryFilter(function (RepositoryFilter $msC13) { $msC13->where(array('isDeleted' => false)); })->gridFilter(function (GridFilter $msC13) { $msC13->eq('id', L('ID')); $msC13->like('username', '用户名'); $msC13->like('email', '邮箱')->autoHide(true); $msC13->like('phone', '手机')->autoHide(true); $msC13->eq('status', '状态')->autoHide(true)->select(MemberStatus::class); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $msC13->eq('groupId', '分组')->autoHide(true)->select(MemberGroupUtil::mapIdTitle()); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $msC13->eq('vipId', 'VIP')->autoHide(true)->select(MemberVipUtil::mapTitle()); } })->operateFixed('right')->hookItemOperateRendering(function (ItemOperate $QgfBr) { $p9RU6 = $QgfBr->item(); $QgfBr->prepend(TextDialogRequest::make('primary', '查看', modstart_admin_url('member/show', array('_id' => $p9RU6->id)))->width('90%')->height('90%')->render()); })->title('用户管理')->canShow(false)->canDelete(true)->canEdit(false)->canExport(ModuleManager::getModuleConfig('Member', 'exportEnable', false)); } public function selectRemote() { return Select::optionRemoteHandleModel('member_user', 'id', 'username'); } public function add(AdminDialogPage $UWW9I) { goto YPjJq; YPjJq: $ibClY = Form::make(''); goto EB4B2; L8qWs: return $UWW9I->pageTitle('创建用户')->body($ibClY)->handleForm($ibClY, function (Form $ibClY) { AdminPermission::demoCheck(); $c4mjf = $ibClY->dataForming(); $bsOV5 = !empty($c4mjf['username']) ? $c4mjf['username'] : null; $ToL73 = !empty($c4mjf['phone']) ? $c4mjf['phone'] : null; $k43Qq = !empty($c4mjf['email']) ? $c4mjf['email'] : null; $oBR6F = ArrayUtil::keepKeys($c4mjf, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $WktN9 = MemberUtil::register($bsOV5, $ToL73, $k43Qq, $c4mjf['password']); BizException::throwsIfResponseError($WktN9); if (!empty($oBR6F)) { if (isset($oBR6F['vipExpire']) && TimeUtil::isDateEmpty($oBR6F['vipExpire'])) { $oBR6F['vipExpire'] = null; } MemberUtil::update($WktN9['data']['id'], $oBR6F); } EventUtil::fire(new MemberUserRegisteredEvent($WktN9['data']['id'])); return Response::redirect(CRUDUtil::jsDialogCloseAndParentGridRefresh()); }); goto I0M4t; EB4B2: $ibClY->layoutPanel('基础（用户、手机、邮箱不能同时为空）', function (Form $ibClY) { $ibClY->text('username', '用户名'); $ibClY->text('phone', '手机'); $ibClY->text('email', '邮箱'); $ibClY->text('password', '初始密码')->defaultValue(RandomUtil::lowerString(8)); }); goto N3Yy5; rhzwt: $ibClY->showSubmit(false)->showReset(false); goto L8qWs; N3Yy5: $ibClY->layoutPanel('高级', function (Form $ibClY) { $ibClY->text('nickname', '昵称'); $ibClY->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $ibClY->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $ibClY->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $ibClY->date('vipExpire', 'VIP过期'); } }); goto rhzwt; I0M4t: } public function edit(AdminDialogPage $UWW9I) { goto CZqS1; N0VI5: $ibClY->layoutPanel('基础', function (Form $ibClY) { $ibClY->display('id', '用户ID')->addable(true); $ibClY->text('username', '用户名'); $ibClY->text('phone', '手机'); $ibClY->text('email', '邮箱'); }); goto d2bQH; CZqS1: $kqakb = ModelUtil::get('member_user', CRUDUtil::id()); goto jAegA; t2mkh: return $UWW9I->pageTitle('修改信息')->body($ibClY)->handleForm($ibClY, function (Form $ibClY) use($kqakb) { AdminPermission::demoCheck(); $c4mjf = $ibClY->dataForming(); $xBjjg = ArrayUtil::keepKeys($c4mjf, array('username', 'phone', 'email')); $oBR6F = ArrayUtil::keepKeys($c4mjf, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $WktN9 = MemberUtil::updateBasicWithUniqueCheck($kqakb['id'], $xBjjg); BizException::throwsIfResponseError($WktN9); if (isset($oBR6F['vipExpire']) && TimeUtil::isDateEmpty($oBR6F['vipExpire'])) { $oBR6F['vipExpire'] = null; } MemberUtil::update($kqakb['id'], $oBR6F); return Response::redirect(CRUDUtil::jsDialogCloseAndParentRefresh()); }); goto W8Cks; gU0B8: $ibClY = Form::make(''); goto N0VI5; RveNJ: $ibClY->showSubmit(false)->showReset(false); goto t2mkh; jAegA: BizException::throwsIfEmpty('用户不存在', $kqakb); goto jiEJM; jiEJM: if (Request::isPost()) { goto zSsZr; zSsZr: AdminPermission::demoCheck(); goto XqaZ2; XqaZ2: $ko470 = InputPackage::buildFromInput(); goto qP6Eb; qP6Eb: switch ($ko470->getTrimString('_action')) { case 'itemCellEdit': goto HfKxH; HfKxH: $pmhtR = array(); goto O8yYb; GgG6N: return Response::generateSuccess(); goto PRsTy; WGtnl: if (!empty($pmhtR)) { MemberUtil::update($kqakb['id'], $pmhtR); } goto GgG6N; O8yYb: switch ($ko470->getTrimString('column')) { case 'status': $pmhtR['status'] = $ko470->getInteger('value'); break; } goto WGtnl; PRsTy: } goto vrfRE; vrfRE: } goto gU0B8; d2bQH: $ibClY->layoutPanel('高级', function (Form $ibClY) { $ibClY->text('nickname', '昵称'); $ibClY->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $ibClY->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $ibClY->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $ibClY->date('vipExpire', 'VIP过期')->help('VIP过期留空表示永久'); } }); goto n8n3I; n8n3I: $ibClY->item($kqakb)->fillFields(); goto RveNJ; W8Cks: } public function select(AdminDialogPage $UWW9I) { goto vcWiP; VcOcI: $Qpd2e->disableCUD(); goto ckwKw; VZNWH: return $UWW9I->pageTitle('选择用户')->body($Qpd2e); goto v0hRX; g8g1d: CRUDUtil::registerGridResource($Qpd2e, '\\' . __CLASS__); goto mK132; vcWiP: $Qpd2e = $this->grid(); goto VcOcI; ckwKw: $Qpd2e->canSingleSelectItem(true); goto g8g1d; mK132: if (Request::isPost()) { return $Qpd2e->request(); } goto VZNWH; v0hRX: } public function search() { goto PxHKP; fYy4j: $bJm3x = $ko470->getTrimString('keywords'); goto R6Qp2; PxHKP: $ko470 = InputPackage::buildFromInput(); goto fYy4j; UqaWs: $SQ1cU = MemberUtil::paginate(1, 10, $Vhyc6); goto ocgmo; ocgmo: $loa94 = array_map(function ($p9RU6) { return array('value' => intval($p9RU6['id']), 'name' => htmlspecialchars(MemberUtil::viewName($p9RU6)), 'avatar' => AssetsUtil::fixOrDefault($p9RU6['avatar'], 'asset/image/avatar.svg')); }, $SQ1cU['records']); goto JDzJE; JDzJE: return Response::jsonSuccessData($loa94); goto BZsZs; a68fP: $Vhyc6['whereOperate'] = array('username', 'like', "%{$bJm3x}%"); goto UqaWs; R6Qp2: $Vhyc6 = array(); goto a68fP; BZsZs: } public function resetPassword(AdminConfigBuilder $hDbiq) { goto GxOav; z93_g: return $hDbiq; goto Cv09W; y9m95: $hDbiq->useDialog(); goto q9yVU; r8Qch: $hDbiq->text('passwordNew', '新密码')->required()->defaultValue(RandomUtil::upperString(6)); goto U7E2v; D6ZRD: $kqakb = MemberUtil::get($k_QCu); goto AWBBf; AWBBf: BizException::throwsIfEmpty('用户不存在', $kqakb); goto y9m95; q9yVU: $hDbiq->pageTitle('重置密码'); goto r8Qch; GxOav: $k_QCu = CRUDUtil::id(); goto D6ZRD; U7E2v: if (Request::isPost()) { return $hDbiq->formRequest(function (Form $ibClY) use($kqakb) { AdminPermission::demoCheck(); $c4mjf = $ibClY->dataForming(); $WktN9 = MemberUtil::changePassword($kqakb['id'], $c4mjf['passwordNew'], null, true); BizException::throwsIfResponseError($WktN9); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto z93_g; Cv09W: } public function sendMessage(AdminConfigBuilder $hDbiq) { goto Lat4G; Rl63i: $hDbiq->pageTitle('发送消息'); goto zzMlG; zzMlG: $hDbiq->richHtml('content', '消息内容')->required(); goto AIo76; AC03C: return $hDbiq; goto ibQIY; AIo76: if (Request::isPost()) { return $hDbiq->formRequest(function (Form $ibClY) use($kqakb) { AdminPermission::demoCheck(); $c4mjf = $ibClY->dataForming(); $WktN9 = MemberMessageUtil::send($kqakb['id'], $c4mjf['content']); BizException::throwsIfResponseError($WktN9); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto AC03C; MVrEI: BizException::throwsIfEmpty('用户不存在', $kqakb); goto v28WZ; HaPEH: $kqakb = MemberUtil::get($k_QCu); goto MVrEI; v28WZ: $hDbiq->useDialog(); goto Rl63i; Lat4G: $k_QCu = CRUDUtil::id(); goto HaPEH; ibQIY: } public function show() { goto hvkdI; j_5H1: $KRWxg = MemberAdminShowPanelProvider::listAll(); goto UuvEt; hvkdI: $wA6n0 = MemberUtil::get(CRUDUtil::id()); goto j_5H1; UuvEt: return view('module::Member.View.admin.memberUser.show', array('record' => $wA6n0, 'showPanelProviders' => $KRWxg)); goto sEQPx; sEQPx: } public function delete() { goto JwWWt; u6z1Q: return Response::redirect(CRUDUtil::jsGridRefresh()); goto h5xDd; meh5L: MemberUtil::delete(CRUDUtil::id()); goto u6z1Q; JwWWt: AdminPermission::demoCheck(); goto meh5L; h5xDd: } public function statusForbidden() { goto KdEyO; mBYPs: return Response::redirect(CRUDUtil::jsGridRefresh()); goto ZpkB1; VfJFU: MemberUtil::updateStatus(CRUDUtil::ids(), MemberStatus::FORBIDDEN); goto mBYPs; KdEyO: AdminPermission::demoCheck(); goto VfJFU; ZpkB1: } public function export(ExportHandle $dHEEk) { $KMdt3 = array('ID', '用户名', '邮箱', '手机', '注册时间', '性别', '姓名', '签名'); return $dHEEk->withPageTitle('导出用户信息')->withDefaultExportName('用户信息')->withHeadTitles($KMdt3)->handleFetch(function ($UWW9I, $HvpTs, $kiWpM, $KI8EF) { $JcmkZ = ModelUtil::model('member_user'); $JcmkZ = $JcmkZ->where(array('isDeleted' => false))->orderBy('id', 'desc'); foreach ($kiWpM as $q2Mg4) { if (!empty($q2Mg4['id']['eq'])) { $JcmkZ = $JcmkZ->where('id', $q2Mg4['id']['eq']); } elseif (!empty($q2Mg4['status']['eq'])) { $JcmkZ = $JcmkZ->where('status', $q2Mg4['status']['eq']); } elseif (!empty($q2Mg4['groupId']['eq'])) { $JcmkZ = $JcmkZ->where('groupId', $q2Mg4['groupId']['eq']); } elseif (!empty($q2Mg4['vipId']['eq'])) { $JcmkZ = $JcmkZ->where('vipId', $q2Mg4['vipId']['eq']); } elseif (!empty($q2Mg4['username']['like'])) { $JcmkZ = $JcmkZ->where('username', 'like', '%' . $q2Mg4['username']['like'] . '%'); } elseif (!empty($q2Mg4['email']['like'])) { $JcmkZ = $JcmkZ->where('email', 'like', '%' . $q2Mg4['email']['like'] . '%'); } elseif (!empty($q2Mg4['phone']['like'])) { $JcmkZ = $JcmkZ->where('phone', 'like', '%' . $q2Mg4['phone']['like'] . '%'); } } $EknUP = $JcmkZ->paginate($HvpTs, array('*'), 'page', $UWW9I)->toArray(); $LEpB3 = array(); foreach ($EknUP['data'] as $p9RU6) { goto zJBbU; tJc6i: $glb9l[] = $p9RU6['username']; goto lm06v; lm06v: $glb9l[] = $p9RU6['email']; goto egJkX; MQh6B: $glb9l[] = $p9RU6['id']; goto tJc6i; tNBTJ: $LEpB3[] = $glb9l; goto lTDEV; egJkX: $glb9l[] = $p9RU6['phone']; goto aF3fn; Pv102: $glb9l[] = $p9RU6['realname']; goto Tvmu8; Tvmu8: $glb9l[] = $p9RU6['signature']; goto tNBTJ; zJBbU: $glb9l = array(); goto MQh6B; aF3fn: $glb9l[] = $p9RU6['created_at']; goto S8YL9; S8YL9: $glb9l[] = TypeUtil::name(Gender::class, $p9RU6['gender']); goto Pv102; lTDEV: } return array('list' => $LEpB3, 'total' => $EknUP['total']); })->performCommon(); } }